/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.history;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import com.sun.jersey.json.impl.provider.entity.JSONRootElementProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.core.MediaType;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.history.logging.EntityTypes;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.history.parser.utils.Utils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class ATSImportTool
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(ATSImportTool.class);
    private static final String BATCH_SIZE = "batchSize";
    private static final int BATCH_SIZE_DEFAULT = 100;
    private static final String YARN_TIMELINE_SERVICE_ADDRESS = "yarnTimelineAddress";
    private static final String DAG_ID = "dagId";
    private static final String BASE_DOWNLOAD_DIR = "downloadDir";
    private static final String HTTPS_SCHEME = "https://";
    private static final String HTTP_SCHEME = "http://";
    private static final String VERTEX_QUERY_STRING = "%s/%s?limit=%s&primaryFilter=%s:%s";
    private static final String TASK_QUERY_STRING = "%s/%s?limit=%s&primaryFilter=%s:%s";
    private static final String TASK_ATTEMPT_QUERY_STRING = "%s/%s?limit=%s&primaryFilter=%s:%s";
    private static final String UTF8 = "UTF-8";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final int batchSize;
    private final String baseUri;
    private final String dagId;
    private final File zipFile;
    private final Client httpClient;
    private final TezDAGID tezDAGID;

    public ATSImportTool(String baseUri, String dagId, File downloadDir, int batchSize) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dagId) ? 1 : 0) != 0, (Object)"dagId can not be null or empty");
        Preconditions.checkArgument((downloadDir != null ? 1 : 0) != 0, (Object)"downloadDir can not be null");
        this.tezDAGID = TezDAGID.fromString((String)dagId);
        this.baseUri = baseUri;
        this.batchSize = batchSize;
        this.dagId = dagId;
        this.httpClient = this.getHttpClient();
        this.zipFile = new File(downloadDir, this.dagId + ".zip");
        boolean result = downloadDir.mkdirs();
        LOG.trace("Result of creating dir {}={}", (Object)downloadDir, (Object)result);
        if (!downloadDir.exists()) {
            throw new IllegalArgumentException("dir=" + downloadDir + " does not exist");
        }
        LOG.info("Using baseURL={}, dagId={}, batchSize={}, downloadDir={}", new Object[]{baseUri, dagId, batchSize, downloadDir});
    }

    private void download() throws Exception {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.zipFile, false);
            ZipOutputStream zos = new ZipOutputStream(fos);
            this.downloadData(zos);
            IOUtils.closeQuietly((OutputStream)zos);
        }
        catch (Exception e) {
            LOG.error("Exception in download", (Throwable)e);
            throw e;
        }
        finally {
            if (this.httpClient != null) {
                this.httpClient.destroy();
            }
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    private void downloadData(ZipOutputStream zos) throws TezException, JSONException, IOException {
        JSONObject finalJson = new JSONObject();
        String tezAppId = "tez_" + this.tezDAGID.getApplicationId().toString();
        String tezAppUrl = String.format("%s/%s/%s", this.baseUri, "TEZ_APPLICATION", tezAppId);
        JSONObject tezAppJson = this.getJsonRootEntity(tezAppUrl);
        finalJson.put("application", (Object)tezAppJson);
        String dagUrl = String.format("%s/%s/%s", this.baseUri, "TEZ_DAG_ID", this.dagId);
        JSONObject dagRoot = this.getJsonRootEntity(dagUrl);
        String dagExtraInfoUrl = String.format("%s/%s/%s", this.baseUri, EntityTypes.TEZ_DAG_EXTRA_INFO, this.dagId);
        JSONObject dagExtraInfo = this.getJsonRootEntity(dagExtraInfoUrl);
        if (dagExtraInfo.has("otherinfo")) {
            JSONObject dagOtherInfo = dagRoot.getJSONObject("otherinfo");
            JSONObject extraOtherInfo = dagExtraInfo.getJSONObject("otherinfo");
            Iterator iter = extraOtherInfo.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                dagOtherInfo.put(key, extraOtherInfo.get(key));
            }
        }
        finalJson.put("dag", (Object)dagRoot);
        ZipEntry zipEntry = new ZipEntry(this.dagId);
        zos.putNextEntry(zipEntry);
        IOUtils.write((String)finalJson.toString(4), (OutputStream)zos, (String)UTF8);
        String vertexURL = String.format("%s/%s?limit=%s&primaryFilter=%s:%s", this.baseUri, "TEZ_VERTEX_ID", this.batchSize, "TEZ_DAG_ID", this.dagId);
        this.downloadJSONArrayFromATS(vertexURL, zos, "vertices");
        String taskURL = String.format("%s/%s?limit=%s&primaryFilter=%s:%s", this.baseUri, "TEZ_TASK_ID", this.batchSize, "TEZ_DAG_ID", this.dagId);
        this.downloadJSONArrayFromATS(taskURL, zos, "tasks");
        String taskAttemptURL = String.format("%s/%s?limit=%s&primaryFilter=%s:%s", this.baseUri, "TEZ_TASK_ATTEMPT_ID", this.batchSize, "TEZ_DAG_ID", this.dagId);
        this.downloadJSONArrayFromATS(taskAttemptURL, zos, "task_attempts");
    }

    private void downloadJSONArrayFromATS(String url, ZipOutputStream zos, String tag) throws IOException, TezException, JSONException {
        JSONArray entities;
        Objects.requireNonNull(zos, "ZipOutputStream can not be null");
        String baseUrl = url;
        long downloadedCount = 0L;
        while ((entities = this.getJsonRootEntity(url).optJSONArray("entities")) != null && entities.length() > 0) {
            int limit = entities.length() >= this.batchSize ? entities.length() - 1 : entities.length();
            LOG.debug("Limit={}, downloaded entities len={}", (Object)limit, (Object)entities.length());
            ZipEntry zipEntry = new ZipEntry("part-" + System.currentTimeMillis() + ".json");
            zos.putNextEntry(zipEntry);
            JSONObject finalJson = new JSONObject();
            finalJson.put(tag, (Object)entities);
            IOUtils.write((String)finalJson.toString(4), (OutputStream)zos, (String)UTF8);
            downloadedCount += (long)entities.length();
            if (entities.length() < this.batchSize) break;
            url = baseUrl + "&fromId=" + entities.getJSONObject(entities.length() - 1).getString("entity");
            String firstItem = entities.getJSONObject(0).getString("entity");
            String lastItem = entities.getJSONObject(entities.length() - 1).getString("entity");
            LOG.info("Downloaded={}, First item={}, LastItem={}, new url={}", new Object[]{downloadedCount, firstItem, lastItem, url});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logErrorMessage(ClientResponse response) throws IOException {
        LOG.error("Response status={}", (Object)response.getClientResponseStatus().toString());
        try (LineIterator it = null;){
            it = IOUtils.lineIterator((InputStream)response.getEntityInputStream(), (String)UTF8);
            while (it.hasNext()) {
                String line = it.nextLine();
                LOG.error(line);
            }
        }
    }

    private JSONObject getJsonRootEntity(String url) throws TezException, IOException {
        try {
            WebResource wr = this.getHttpClient().resource(url);
            ClientResponse response = (ClientResponse)((WebResource.Builder)wr.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).get(ClientResponse.class);
            if (response.getClientResponseStatus() != ClientResponse.Status.OK) {
                this.logErrorMessage(response);
                throw new TezException("Failed to get response from YARN Timeline: url: " + url);
            }
            return (JSONObject)response.getEntity(JSONObject.class);
        }
        catch (ClientHandlerException e) {
            throw new TezException("Error processing response from YARN Timeline. URL=" + url, (Throwable)e);
        }
        catch (UniformInterfaceException e) {
            throw new TezException("Error accessing content from YARN Timeline - unexpected response. URL=" + url, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new TezException("Error accessing content from YARN Timeline - invalid url. URL=" + url, (Throwable)e);
        }
    }

    private Client getHttpClient() {
        if (this.httpClient == null) {
            DefaultClientConfig config = new DefaultClientConfig(new Class[]{JSONRootElementProvider.App.class});
            PseudoAuthenticatedURLConnectionFactory urlFactory = new PseudoAuthenticatedURLConnectionFactory();
            return new Client((ClientHandler)new URLConnectionClientHandler((HttpURLConnectionFactory)urlFactory), (ClientConfig)config);
        }
        return this.httpClient;
    }

    public int run(String[] args) throws Exception {
        try {
            this.download();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("Error occurred when downloading data ", (Throwable)e);
            return -1;
        }
    }

    private static Options buildOptions() {
        Option dagIdOption = Option.builder().argName(DAG_ID).longOpt(DAG_ID).desc("DagId that needs to be downloaded").hasArg().required(true).build();
        Option downloadDirOption = Option.builder().argName(BASE_DOWNLOAD_DIR).longOpt(BASE_DOWNLOAD_DIR).desc("Download directory where data needs to be downloaded").hasArg().required(true).build();
        Option atsAddressOption = Option.builder().argName(YARN_TIMELINE_SERVICE_ADDRESS).longOpt(YARN_TIMELINE_SERVICE_ADDRESS).desc("Optional. ATS address (e.g http://clusterATSNode:8188)").hasArg().required(false).build();
        Option batchSizeOption = Option.builder().argName(BATCH_SIZE).longOpt(BATCH_SIZE).desc("Optional. batch size for downloading data").hasArg().required(false).build();
        Option help = Option.builder().argName("help").longOpt("help").desc("print help").required(false).build();
        Options opts = new Options();
        opts.addOption(dagIdOption);
        opts.addOption(downloadDirOption);
        opts.addOption(atsAddressOption);
        opts.addOption(batchSizeOption);
        opts.addOption(help);
        return opts;
    }

    static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(240);
        String help = LINE_SEPARATOR + "java -cp tez-history-parser-x.y.z-jar-with-dependencies.jar org.apache.tez.history.ATSImportTool" + LINE_SEPARATOR + "OR" + LINE_SEPARATOR + "HADOOP_CLASSPATH=$TEZ_HOME/*:$TEZ_HOME/lib/*:$HADOOP_CLASSPATH hadoop jar tez-history-parser-x.y.z.jar " + ATSImportTool.class.getName() + LINE_SEPARATOR;
        formatter.printHelp(240, help, "Options", options, "", true);
    }

    static boolean hasHttpsPolicy(Configuration conf) {
        YarnConfiguration yarnConf = new YarnConfiguration(conf);
        return HttpConfig.Policy.HTTPS_ONLY == HttpConfig.Policy.fromString((String)yarnConf.get("yarn.http.policy", YarnConfiguration.YARN_HTTP_POLICY_DEFAULT));
    }

    static String getBaseTimelineURL(String yarnTimelineAddress, Configuration conf) throws TezException {
        boolean isHttps = ATSImportTool.hasHttpsPolicy(conf);
        if (yarnTimelineAddress == null) {
            yarnTimelineAddress = isHttps ? conf.get("yarn.timeline-service.webapp.https.address") : conf.get("yarn.timeline-service.webapp.address");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)yarnTimelineAddress) ? 1 : 0) != 0, (Object)"Yarn timeline address can not be empty. Please check configurations.");
        } else {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)(yarnTimelineAddress = yarnTimelineAddress.trim())) ? 1 : 0) != 0, (Object)"Yarn timeline address can not be empty. Please provide valid url with --yarnTimelineAddress option");
        }
        yarnTimelineAddress = yarnTimelineAddress.toLowerCase();
        if (!yarnTimelineAddress.startsWith(HTTP_SCHEME) && !yarnTimelineAddress.startsWith(HTTPS_SCHEME)) {
            yarnTimelineAddress = (isHttps ? HTTPS_SCHEME : HTTP_SCHEME) + yarnTimelineAddress;
        }
        try {
            yarnTimelineAddress = new URI(yarnTimelineAddress).normalize().toString().trim();
            yarnTimelineAddress = yarnTimelineAddress.endsWith("/") ? yarnTimelineAddress.substring(0, yarnTimelineAddress.length() - 1) : yarnTimelineAddress;
        }
        catch (URISyntaxException e) {
            throw new TezException("Please provide a valid URL. url=" + yarnTimelineAddress, (Throwable)e);
        }
        return Joiner.on((String)"").join((Object)yarnTimelineAddress, (Object)"/ws/v1/timeline", new Object[0]);
    }

    @VisibleForTesting
    public static int process(String[] args) throws Exception {
        Options options = ATSImportTool.buildOptions();
        try {
            Configuration conf = new Configuration();
            CommandLine cmdLine = new DefaultParser().parse(options, args);
            String dagId = cmdLine.getOptionValue(DAG_ID);
            File downloadDir = new File(cmdLine.getOptionValue(BASE_DOWNLOAD_DIR));
            String yarnTimelineAddress = cmdLine.getOptionValue(YARN_TIMELINE_SERVICE_ADDRESS);
            String baseTimelineURL = ATSImportTool.getBaseTimelineURL(yarnTimelineAddress, conf);
            int batchSize = cmdLine.hasOption(BATCH_SIZE) ? Integer.parseInt(cmdLine.getOptionValue(BATCH_SIZE)) : 100;
            return ToolRunner.run((Configuration)conf, (Tool)new ATSImportTool(baseTimelineURL, dagId, downloadDir, batchSize), (String[])args);
        }
        catch (ParseException e) {
            LOG.error("Error in parsing options ", (Throwable)e);
            ATSImportTool.printHelp(options);
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error in processing ", (Throwable)e);
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        Utils.setupRootLogger();
        int res = ATSImportTool.process(args);
        System.exit(res);
    }

    static class PseudoAuthenticatedURLConnectionFactory
    implements HttpURLConnectionFactory {
        PseudoAuthenticatedURLConnectionFactory() {
        }

        public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
            String tokenString = (url.getQuery() == null ? "?" : "&") + "user.name=" + URLEncoder.encode(UserGroupInformation.getCurrentUser().getShortUserName(), "UTF8");
            return (HttpURLConnection)new URL(url.toString() + tokenString).openConnection();
        }
    }
}

