/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpMessage;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.apache.tinkerpop.gremlin.server.authz.Authorizer;
import org.apache.tinkerpop.gremlin.server.handler.HttpBasicAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.HttpBasicAuthorizationHandler;
import org.apache.tinkerpop.gremlin.server.handler.SaslAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.WebSocketHandlerUtil;

@ChannelHandler.Sharable
public class SaslAndHttpBasicAuthenticationHandler
extends SaslAuthenticationHandler {
    private final String HTTP_AUTH = "http-authentication";

    @Deprecated
    public SaslAndHttpBasicAuthenticationHandler(Authenticator authenticator, Settings settings) {
        this(authenticator, null, settings);
    }

    public SaslAndHttpBasicAuthenticationHandler(Authenticator authenticator, Authorizer authorizer, Settings settings) {
        super(authenticator, authorizer, settings);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object obj) throws Exception {
        if (obj instanceof HttpMessage && !WebSocketHandlerUtil.isWebSocket((HttpMessage)obj)) {
            ChannelPipeline pipeline = ctx.pipeline();
            if (null != pipeline.get("http-authentication")) {
                pipeline.remove("http-authentication");
            }
            pipeline.addAfter("authenticator", "http-authentication", (ChannelHandler)new HttpBasicAuthenticationHandler(this.authenticator, this.settings));
            if (this.authorizer != null) {
                HttpBasicAuthorizationHandler authorizationHandler = new HttpBasicAuthorizationHandler(this.authorizer);
                pipeline.remove("authorizer");
                pipeline.addAfter("http-authentication", "authorizer", (ChannelHandler)authorizationHandler);
            }
            ctx.fireChannelRead(obj);
        } else {
            super.channelRead(ctx, obj);
        }
    }
}

