/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi;

import jakarta.annotation.Priority;
import jakarta.el.ELProcessor;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.CallerPrincipal;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.authentication.mechanism.http.RememberMe;
import jakarta.security.enterprise.credential.RememberMeCredential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.RememberMeIdentityStore;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomee.security.TomEEELInvocationHandler;

@RememberMe
@Interceptor
@Priority(value=210)
public class RememberMeInterceptor {
    @Inject
    @Intercepted
    private Bean<?> httpMechanismBean;
    @Inject
    private Instance<RememberMeIdentityStore> rememberMeIdentityStore;
    @Inject
    private BeanManager beanManager;

    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) throws Exception {
        if (invocationContext.getMethod().getName().equals("validateRequest") && Arrays.equals(invocationContext.getMethod().getParameterTypes(), new Class[]{HttpServletRequest.class, HttpServletResponse.class, HttpMessageContext.class})) {
            if (this.rememberMeIdentityStore.isUnsatisfied()) {
                throw new IllegalStateException("RememberMe annotated AuthenticationMechanism  " + String.valueOf(this.httpMechanismBean.getBeanClass()) + " required an implementation of RememberMeIdentityStore");
            }
            if (this.rememberMeIdentityStore.isAmbiguous()) {
                throw new IllegalStateException("Multiple implementations of RememberMeIdentityStore found. Only one should be supplied.");
            }
            return this.validateRequest(invocationContext);
        }
        if (invocationContext.getMethod().getName().equals("cleanSubject") && Arrays.equals(invocationContext.getMethod().getParameterTypes(), new Class[]{HttpServletRequest.class, HttpServletResponse.class, HttpMessageContext.class})) {
            this.cleanSubject(invocationContext);
        }
        return invocationContext.proceed();
    }

    private AuthenticationStatus validateRequest(InvocationContext invocationContext) throws Exception {
        AuthenticationStatus status;
        HttpMessageContext httpMessageContext = (HttpMessageContext)invocationContext.getParameters()[2];
        RememberMe rememberMe = TomEEELInvocationHandler.of(RememberMe.class, this.getRememberMe(), this.getElProcessor(invocationContext, httpMessageContext));
        Optional<Cookie> cookie = this.getCookie(httpMessageContext.getRequest(), rememberMe.cookieName());
        if (cookie.isPresent() && !StringUtils.isEmpty((CharSequence)cookie.get().getValue())) {
            RememberMeCredential rememberMeCredential = new RememberMeCredential(cookie.get().getValue());
            CredentialValidationResult validate = ((RememberMeIdentityStore)this.rememberMeIdentityStore.get()).validate(rememberMeCredential);
            if (CredentialValidationResult.Status.VALID.equals((Object)validate.getStatus())) {
                return httpMessageContext.notifyContainerAboutLogin(validate);
            }
            cookie.get().setMaxAge(0);
            httpMessageContext.getResponse().addCookie(cookie.get());
        }
        if (AuthenticationStatus.SUCCESS.equals((Object)(status = (AuthenticationStatus)invocationContext.proceed())) && httpMessageContext.getCallerPrincipal() != null && rememberMe.isRememberMe()) {
            CallerPrincipal principal = new CallerPrincipal(httpMessageContext.getCallerPrincipal().getName());
            Set groups = httpMessageContext.getGroups();
            String loginToken = ((RememberMeIdentityStore)this.rememberMeIdentityStore.get()).generateLoginToken(principal, groups);
            Cookie rememberMeCookie = new Cookie(rememberMe.cookieName(), loginToken);
            rememberMeCookie.setPath(StringUtils.isEmpty((CharSequence)httpMessageContext.getRequest().getContextPath()) ? "/" : httpMessageContext.getRequest().getContextPath());
            rememberMeCookie.setMaxAge(rememberMe.cookieMaxAgeSeconds());
            rememberMeCookie.setHttpOnly(rememberMe.cookieHttpOnly());
            rememberMeCookie.setSecure(rememberMe.cookieSecureOnly());
            httpMessageContext.getResponse().addCookie(rememberMeCookie);
        }
        return status;
    }

    private void cleanSubject(InvocationContext invocationContext) throws Exception {
        HttpMessageContext httpMessageContext = (HttpMessageContext)invocationContext.getParameters()[2];
        RememberMe rememberMe = TomEEELInvocationHandler.of(RememberMe.class, this.getRememberMe(), this.getElProcessor(invocationContext, httpMessageContext));
        Optional<Cookie> cookie = this.getCookie(httpMessageContext.getRequest(), rememberMe.cookieName());
        if (cookie.isPresent() && !StringUtils.isEmpty((CharSequence)cookie.get().getValue())) {
            cookie.get().setValue(null);
            cookie.get().setMaxAge(0);
            cookie.get().setPath(StringUtils.isEmpty((CharSequence)httpMessageContext.getRequest().getContextPath()) ? "/" : httpMessageContext.getRequest().getContextPath());
            httpMessageContext.getResponse().addCookie(cookie.get());
            ((RememberMeIdentityStore)this.rememberMeIdentityStore.get()).removeLoginToken(cookie.get().getValue());
        }
        invocationContext.proceed();
    }

    private Optional<Cookie> getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return Optional.empty();
        }
        return Arrays.stream(cookies).filter(c -> c.getName().equals(name)).findFirst();
    }

    private RememberMe getRememberMe() {
        return Optional.ofNullable(this.httpMechanismBean.getBeanClass().getAnnotation(RememberMe.class)).orElseThrow(IllegalStateException::new);
    }

    private ELProcessor getElProcessor(InvocationContext invocationContext, HttpMessageContext httpMessageContext) {
        ELProcessor elProcessor = new ELProcessor();
        elProcessor.getELManager().addELResolver(this.beanManager.getELResolver());
        elProcessor.defineBean("self", invocationContext.getTarget());
        elProcessor.defineBean("this", invocationContext.getTarget());
        elProcessor.defineBean("httpMessageContext", (Object)httpMessageContext);
        return elProcessor;
    }
}

