/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import wiremock.com.google.common.base.Optional;

public class Response {
    private final int status;
    private final String statusMessage;
    private final byte[] body;
    private final HttpHeaders headers;
    private final boolean configured;
    private final Fault fault;
    private final boolean fromProxy;

    public static Response notConfigured() {
        return new Response(404, null, (byte[])null, HttpHeaders.noHeaders(), false, null, false);
    }

    public static Builder response() {
        return new Builder();
    }

    public Response(int status, String statusMessage, byte[] body, HttpHeaders headers, boolean configured, Fault fault, boolean fromProxy) {
        this.status = status;
        this.statusMessage = statusMessage;
        this.body = body;
        this.headers = headers;
        this.configured = configured;
        this.fault = fault;
        this.fromProxy = fromProxy;
    }

    public Response(int status, String statusMessage, String body, HttpHeaders headers, boolean configured, Fault fault, boolean fromProxy) {
        this.status = status;
        this.statusMessage = statusMessage;
        this.headers = headers;
        this.body = body == null ? null : Strings.bytesFromString(body, headers.getContentTypeHeader().charset());
        this.configured = configured;
        this.fault = fault;
        this.fromProxy = fromProxy;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyAsString() {
        return Strings.stringFromBytes(this.body, this.headers.getContentTypeHeader().charset());
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Fault getFault() {
        return this.fault;
    }

    public boolean wasConfigured() {
        return this.configured;
    }

    public boolean isFromProxy() {
        return this.fromProxy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP/1.1 ").append(this.status).append("\n");
        sb.append(this.headers).append("\n");
        if (this.body != null) {
            sb.append(this.getBodyAsString()).append("\n");
        }
        return sb.toString();
    }

    public static class Builder {
        private int status = 200;
        private String statusMessage;
        private byte[] body;
        private String bodyString;
        private HttpHeaders headers = new HttpHeaders();
        private boolean configured = true;
        private Fault fault;
        private boolean fromProxy;
        private Optional<ResponseDefinition> renderedFromDefinition;

        public static Builder like(Response response) {
            Builder responseBuilder = new Builder();
            responseBuilder.status = response.getStatus();
            responseBuilder.body = response.getBody();
            responseBuilder.headers = response.getHeaders();
            responseBuilder.configured = response.wasConfigured();
            responseBuilder.fault = response.getFault();
            responseBuilder.fromProxy = response.isFromProxy();
            return responseBuilder;
        }

        public Builder but() {
            return this;
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public Builder body(byte[] body) {
            this.body = body;
            this.bodyString = null;
            this.ensureOnlyOneBodySet();
            return this;
        }

        public Builder body(String body) {
            this.bodyString = body;
            this.body = null;
            this.ensureOnlyOneBodySet();
            return this;
        }

        private void ensureOnlyOneBodySet() {
            if (this.body != null && this.bodyString != null) {
                throw new IllegalStateException("Body should either be set as a String or byte[], not both");
            }
        }

        public Builder headers(HttpHeaders headers) {
            this.headers = headers == null ? HttpHeaders.noHeaders() : headers;
            return this;
        }

        public Builder configured(boolean configured) {
            this.configured = configured;
            return this;
        }

        public Builder fault(Fault fault) {
            this.fault = fault;
            return this;
        }

        public Builder fromProxy(boolean fromProxy) {
            this.fromProxy = fromProxy;
            return this;
        }

        public Response build() {
            if (this.body != null) {
                return new Response(this.status, this.statusMessage, this.body, this.headers, this.configured, this.fault, this.fromProxy);
            }
            if (this.bodyString != null) {
                return new Response(this.status, this.statusMessage, this.bodyString, this.headers, this.configured, this.fault, this.fromProxy);
            }
            return new Response(this.status, this.statusMessage, new byte[0], this.headers, this.configured, this.fault, this.fromProxy);
        }
    }
}

