/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.bool;

import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.bool.AbstractBooleanExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class BooleanNumberExpression
extends AbstractBooleanExpression {
    private final INumberExpression e1;
    private final String op;
    private final INumberExpression e2;

    public BooleanNumberExpression(INumberExpression e1, String op, INumberExpression e2) {
        this.e1 = e1;
        this.op = op;
        this.e2 = e2;
    }

    @Override
    public boolean getBooleanValue(MatchContext context, RutaStream stream) {
        double doubleValue1 = this.getFristExpression().getDoubleValue(context, stream);
        double doubleValue2 = this.getSecondExpression().getDoubleValue(context, stream);
        return this.eval(doubleValue1, this.getOperator(), doubleValue2);
    }

    private boolean eval(double t1, String op, double t2) {
        if ("==".equals(op)) {
            return t1 == t2;
        }
        if ("!=".equals(op)) {
            return t1 != t2;
        }
        if ("<".equals(op)) {
            return t1 < t2;
        }
        if ("<=".equals(op)) {
            return t1 <= t2;
        }
        if (">".equals(op)) {
            return t1 > t2;
        }
        if (">=".equals(op)) {
            return t1 >= t2;
        }
        return false;
    }

    public INumberExpression getFristExpression() {
        return this.e1;
    }

    public String getOperator() {
        return this.op;
    }

    public INumberExpression getSecondExpression() {
        return this.e2;
    }

    @Override
    public String getStringValue(MatchContext context, RutaStream stream) {
        return this.e1.getStringValue(context, stream) + " " + this.op + " " + this.e2.getStringValue(context, stream);
    }
}

