/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.string;

import java.util.Collection;
import java.util.List;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.feature.CoveredTextFeature;
import org.apache.uima.ruta.expression.feature.FeatureExpression;
import org.apache.uima.ruta.expression.feature.LazyFeature;
import org.apache.uima.ruta.expression.string.AbstractStringExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class StringFeatureExpression
extends AbstractStringExpression {
    private FeatureExpression fe;

    public StringFeatureExpression(FeatureExpression fe) {
        this.fe = fe;
    }

    @Override
    public String getStringValue(MatchContext context, RutaStream stream) {
        AnnotationFS annotation = context.getAnnotation();
        Feature feature = this.fe.getFeature(context, stream);
        List<AnnotationFS> list = this.getTargetAnnotation(annotation, this.fe, context, stream);
        Collection<? extends FeatureStructure> featureStructures = this.fe.getFeatureStructures(list, false, context, stream);
        if (!featureStructures.isEmpty()) {
            FeatureStructure next = featureStructures.iterator().next();
            if (feature instanceof LazyFeature) {
                LazyFeature lazyFeature = (LazyFeature)feature;
                feature = lazyFeature.initialize(next);
            }
            if (next instanceof AnnotationFS && feature instanceof CoveredTextFeature) {
                return ((AnnotationFS)next).getCoveredText();
            }
            if (feature.getRange().getName().equals("uima.cas.String")) {
                return next.getStringValue(feature);
            }
            return next.getFeatureValueAsString(feature);
        }
        return null;
    }

    public FeatureExpression getFe() {
        return this.fe;
    }

    public void setFe(FeatureExpression fe) {
        this.fe = fe;
    }
}

