/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.cdi;

import javax.enterprise.inject.spi.BeanManager;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.cdi.AutoConversationManager;
import org.apache.wicket.cdi.BehaviorInjector;
import org.apache.wicket.cdi.CdiShutdownCleaner;
import org.apache.wicket.cdi.ComponentInjector;
import org.apache.wicket.cdi.ConversationExpiryChecker;
import org.apache.wicket.cdi.ConversationPropagation;
import org.apache.wicket.cdi.ConversationPropagator;
import org.apache.wicket.cdi.DetachEventEmitter;
import org.apache.wicket.cdi.IConversationPropagation;
import org.apache.wicket.cdi.NonContextual;
import org.apache.wicket.cdi.SessionInjector;
import org.apache.wicket.request.cycle.RequestCycleListenerCollection;

public class CdiConfiguration {
    private static final MetaDataKey<CdiConfiguration> CDI_CONFIGURATION_KEY = new MetaDataKey<CdiConfiguration>(){
        private static final long serialVersionUID = 1L;
    };
    private IConversationPropagation propagation = ConversationPropagation.NONBOOKMARKABLE;
    private BeanManager fallbackBeanManager;

    public IConversationPropagation getPropagation() {
        return this.propagation;
    }

    public CdiConfiguration setPropagation(IConversationPropagation propagation) {
        this.propagation = propagation;
        return this;
    }

    public BeanManager getFallbackBeanManager() {
        return this.fallbackBeanManager;
    }

    public CdiConfiguration setFallbackBeanManager(BeanManager fallbackBeanManager) {
        this.fallbackBeanManager = fallbackBeanManager;
        return this;
    }

    public void configure(Application application) {
        if (application.getMetaData(CDI_CONFIGURATION_KEY) != null) {
            throw new IllegalStateException("Cdi already configured for this application");
        }
        application.setMetaData(CDI_CONFIGURATION_KEY, (Object)this);
        RequestCycleListenerCollection listeners = new RequestCycleListenerCollection();
        application.getRequestCycleListeners().add((Object)listeners);
        if (this.getPropagation() != ConversationPropagation.NONE) {
            listeners.add((Object)new ConversationPropagator(application, this.getPropagation()));
            application.getComponentPreOnBeforeRenderListeners().add((Object)new AutoConversationManager(this.getPropagation()));
            application.getComponentPreOnBeforeRenderListeners().add((Object)new ConversationExpiryChecker());
        }
        listeners.add((Object)new DetachEventEmitter());
        NonContextual.of(application).postConstruct(application);
        application.getSessionListeners().add((Object)new SessionInjector());
        application.getComponentInstantiationListeners().add((Object)new ComponentInjector());
        application.getBehaviorInstantiationListeners().add((Object)new BehaviorInjector());
        application.getApplicationListeners().add((Object)new CdiShutdownCleaner());
    }

    public static CdiConfiguration get(Application application) {
        return (CdiConfiguration)application.getMetaData(CDI_CONFIGURATION_KEY);
    }
}

