/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Checks;
import org.apache.wicket.util.string.Strings;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public abstract class AjaxEventBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final String event;

    public AjaxEventBehavior(String event) {
        Args.notEmpty((CharSequence)event, (String)"event");
        this.event = event;
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (component.isEnabledInHierarchy()) {
            CharSequence js = this.getCallbackScript(component);
            response.render(OnDomReadyHeaderItem.forScript(js.toString()));
        }
    }

    @Override
    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        String evt = this.getEvent();
        Checks.notEmpty((String)evt, (String)"getEvent() should return non-empty event name(s)", (Object[])new Object[0]);
        attributes.setEventNames(evt);
    }

    public String getEvent() {
        String[] splitEvents = this.event.split("\\s+");
        ArrayList<String> cleanedEvents = new ArrayList<String>(splitEvents.length);
        for (String evt : splitEvents) {
            if (Strings.isEmpty((CharSequence)evt)) continue;
            cleanedEvents.add(evt);
        }
        return Strings.join((String)" ", cleanedEvents);
    }

    @Override
    protected final void respond(AjaxRequestTarget target) {
        this.onEvent(target);
    }

    protected abstract void onEvent(AjaxRequestTarget var1);

    public static AjaxEventBehavior onEvent(String eventName, final SerializableConsumer<AjaxRequestTarget> onEvent) {
        Args.notNull(onEvent, (String)"onEvent");
        return new AjaxEventBehavior(eventName){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                onEvent.accept((Object)target);
            }
        };
    }
}

