/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.Locale;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.value.IValueMap;
import org.apache.wicket.validation.validator.RangeValidator;

public class NumberTextField<N extends Number>
extends TextField<N> {
    private static final long serialVersionUID = 1L;
    public static final Double ANY = 0.0;
    private RangeValidator<N> validator = null;
    private IModel<N> minimum = Model.of((Number)null);
    private IModel<N> maximum = Model.of((Number)null);
    private IModel<N> step = Model.of((Number)null);

    public NumberTextField(String id) {
        this(id, (IModel<N>)null, (Class<N>)null);
    }

    public NumberTextField(String id, Class<N> type) {
        this(id, (IModel<N>)null, type);
    }

    public NumberTextField(String id, IModel<N> model) {
        this(id, model, (Class<N>)null);
    }

    public NumberTextField(String id, IModel<N> model, Class<N> type) {
        super(id, model, type);
    }

    public NumberTextField<N> setMinimum(N minimum) {
        this.minimum = Model.of(minimum);
        return this;
    }

    public NumberTextField<N> setMaximum(N maximum) {
        this.maximum = Model.of(maximum);
        return this;
    }

    public NumberTextField<N> setStep(N step) {
        this.step = Model.of(step);
        return this;
    }

    public NumberTextField<N> setMinimum(IModel<N> minimum) {
        this.minimum = minimum;
        return this;
    }

    public NumberTextField<N> setMaximum(IModel<N> maximum) {
        this.maximum = maximum;
        return this;
    }

    public NumberTextField<N> setStep(IModel<N> step) {
        this.step = step;
        return this;
    }

    @Override
    protected void onConfigure() {
        super.onConfigure();
        if (this.validator != null) {
            this.remove(this.validator);
            this.validator = null;
        }
        Number min = (Number)this.minimum.getObject();
        Number max = (Number)this.maximum.getObject();
        if (min != null || max != null) {
            this.validator = RangeValidator.range((Comparable)((Object)min), (Comparable)((Object)max));
            this.add(this.validator);
        }
    }

    private Class<N> getNumberType() {
        Class<Object> numberType = this.getType();
        if (numberType == null && this.getModelObject() != null) {
            numberType = ((Number)this.getModelObject()).getClass();
        }
        return numberType;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        IValueMap attributes = tag.getAttributes();
        Number min = (Number)this.minimum.getObject();
        if (min != null) {
            attributes.put((Object)"min", (Object)Objects.stringValue((Object)min));
        } else {
            attributes.remove((Object)"min");
        }
        Number max = (Number)this.maximum.getObject();
        if (max != null) {
            attributes.put((Object)"max", (Object)Objects.stringValue((Object)max));
        } else {
            attributes.remove((Object)"max");
        }
        Number _step = (Number)this.step.getObject();
        if (_step != null) {
            if (_step.doubleValue() == ANY.doubleValue()) {
                attributes.put((Object)"step", (Object)"any");
            } else {
                attributes.put((Object)"step", (Object)Objects.stringValue((Object)_step));
            }
        } else {
            attributes.remove((Object)"step");
        }
    }

    @Override
    protected String[] getInputTypes() {
        return new String[]{"number"};
    }

    @Override
    protected String getModelValue() {
        Number value = (Number)this.getModelObject();
        if (value == null) {
            return "";
        }
        return Objects.stringValue((Object)value);
    }

    @Override
    public void convertInput() {
        IConverter<N> converter = this.getConverter(this.getNumberType());
        try {
            this.setConvertedInput(converter.convertToObject(this.getInput(), Locale.ENGLISH));
        }
        catch (ConversionException e) {
            this.error(this.newValidationError(e));
        }
    }
}

