/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import org.apache.wicket.IRequestListener;
import org.apache.wicket.Page;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class InlineFrame
extends WebMarkupContainer
implements IRequestListener {
    private static final long serialVersionUID = 1L;
    private final IPageProvider pageProvider;

    public <C extends Page> InlineFrame(String id, Class<C> c) {
        this(id, c, null);
    }

    public <C extends Page> InlineFrame(String id, Class<C> c, PageParameters params) {
        this(id, new PageProvider(c, params));
        if (!Page.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c + " is not a subclass of Page");
        }
    }

    public InlineFrame(String id, Page page) {
        this(id, new PageProvider(page.getPageId(), page.getClass(), page.getRenderCount()));
    }

    public InlineFrame(String id, IPageProvider pageProvider) {
        super(id);
        this.pageProvider = pageProvider;
    }

    protected CharSequence getURL() {
        return this.urlForListener(new PageParameters());
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "iframe");
        CharSequence url = this.getURL();
        tag.put("src", url);
        super.onComponentTag(tag);
    }

    @Override
    public boolean rendersPage() {
        return false;
    }

    @Override
    public final void onRequest() {
        this.setResponsePage(this.pageProvider.getPageInstance());
    }

    @Override
    protected boolean getStatelessHint() {
        return false;
    }
}

