/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(WicketServlet.class);
    protected transient WicketFilter wicketFilter;

    public final void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        if (!this.wicketFilter.processRequest((ServletRequest)servletRequest, (ServletResponse)servletResponse, null)) {
            this.fallback(servletRequest, servletResponse);
        }
    }

    public final void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        if (!this.wicketFilter.processRequest((ServletRequest)servletRequest, (ServletResponse)servletResponse, null)) {
            this.fallback(servletRequest, servletResponse);
        }
    }

    private static String getURL(HttpServletRequest httpServletRequest) {
        String queryString;
        String url = httpServletRequest.getServletPath();
        String pathInfo = httpServletRequest.getPathInfo();
        if (pathInfo != null) {
            url = url + pathInfo;
        }
        if ((queryString = httpServletRequest.getQueryString()) != null) {
            url = url + "?" + queryString;
        }
        if (url.length() > 0 && url.charAt(0) == '/') {
            url = url.substring(1);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fallback(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String url = WicketServlet.getURL(request);
        if (url.indexOf(63) != -1) {
            url = Strings.beforeFirst((String)url, (char)'?');
        }
        if (url.length() > 0 && url.charAt(0) != '/' || url.length() == 0) {
            url = '/' + url;
        }
        InputStream stream = this.getServletContext().getResourceAsStream(url);
        String mimeType = this.getServletContext().getMimeType(url);
        if (stream == null) {
            if (response.isCommitted()) {
                response.setStatus(404);
            } else {
                response.sendError(404);
            }
        } else {
            if (mimeType != null) {
                response.setContentType(mimeType);
            }
            try {
                Streams.copy((InputStream)stream, (OutputStream)response.getOutputStream());
            }
            finally {
                stream.close();
            }
        }
    }

    public void init() throws ServletException {
        this.wicketFilter = this.newWicketFilter();
        this.wicketFilter.init(true, new FilterConfig(){

            public ServletContext getServletContext() {
                return WicketServlet.this.getServletContext();
            }

            public Enumeration<String> getInitParameterNames() {
                return WicketServlet.this.getInitParameterNames();
            }

            public String getInitParameter(String name) {
                return WicketServlet.this.getInitParameter(name);
            }

            public String getFilterName() {
                return WicketServlet.this.getServletName();
            }
        });
    }

    protected WicketFilter newWicketFilter() {
        return new WicketFilter();
    }

    public void destroy() {
        this.wicketFilter.destroy();
        this.wicketFilter = null;
    }
}

