/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.core.request.handler.logger.PageLogData;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.page.PartialPageUpdate;
import org.apache.wicket.page.XmlPartialPageUpdate;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.IWebSocketRequestHandler;
import org.apache.wicket.request.ILogData;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketRequestHandler
implements IWebSocketRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketRequestHandler.class);
    private final Page page;
    private final IWebSocketConnection connection;
    private PartialPageUpdate update;
    private PageLogData logData;

    public WebSocketRequestHandler(Component component, IWebSocketConnection connection) {
        this.page = ((Component)Args.notNull((Object)component, (String)"component")).getPage();
        this.connection = (IWebSocketConnection)Args.notNull((Object)connection, (String)"connection");
    }

    @Override
    public void push(CharSequence message) {
        if (this.connection.isOpen()) {
            Args.notNull((Object)message, (String)"message");
            try {
                this.connection.sendMessage(message.toString());
            }
            catch (IOException iox) {
                LOG.error("An error occurred while pushing text message.", (Throwable)iox);
            }
        } else {
            LOG.warn("The websocket connection is already closed. Cannot push the text message '{}'", (Object)message);
        }
    }

    @Override
    public void push(byte[] message, int offset, int length) {
        if (this.connection.isOpen()) {
            Args.notNull((Object)message, (String)"message");
            try {
                this.connection.sendMessage(message, offset, length);
            }
            catch (IOException iox) {
                LOG.error("An error occurred while pushing binary message.", (Throwable)iox);
            }
        } else {
            LOG.warn("The websocket connection is already closed. Cannot push the binary message '{}'", (Object)message);
        }
    }

    public void add(Component component, String markupId) {
        this.getUpdate().add(component, markupId);
    }

    private PartialPageUpdate getUpdate() {
        if (this.update == null) {
            this.update = new XmlPartialPageUpdate(this.page);
        }
        return this.update;
    }

    public void add(Component ... components) {
        for (Component component : components) {
            Args.notNull((Object)component, (String)"component");
            if (!component.getOutputMarkupId()) {
                throw new IllegalArgumentException("cannot update component that does not have setOutputMarkupId property set to true. Component: " + component.toString());
            }
            this.add(component, component.getMarkupId());
        }
    }

    public final void addChildren(MarkupContainer parent, Class<?> childCriteria) {
        Args.notNull((Object)parent, (String)"parent");
        Args.notNull(childCriteria, (String)"childCriteria");
        parent.visitChildren(childCriteria, (IVisitor)new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                WebSocketRequestHandler.this.add(component);
                visit.dontGoDeeper();
            }
        });
    }

    public void appendJavaScript(CharSequence javascript) {
        this.getUpdate().appendJavaScript(javascript);
    }

    public void prependJavaScript(CharSequence javascript) {
        this.getUpdate().prependJavaScript(javascript);
    }

    public Collection<? extends Component> getComponents() {
        if (this.update == null) {
            return Collections.emptyList();
        }
        return this.update.getComponents();
    }

    public final void focusComponent(Component component) {
        if (component != null && !component.getOutputMarkupId()) {
            throw new IllegalArgumentException("cannot update component that does not have setOutputMarkupId property set to true. Component: " + component.toString());
        }
        String id = component != null ? "'" + component.getMarkupId() + "'" : "null";
        this.appendJavaScript("Wicket.Focus.setFocusOnId(" + id + ");");
    }

    public IHeaderResponse getHeaderResponse() {
        return this.getUpdate().getHeaderResponse();
    }

    public Page getPage() {
        return this.page;
    }

    public Integer getPageId() {
        return this.page.getPageId();
    }

    public boolean isPageInstanceCreated() {
        return true;
    }

    public Integer getRenderCount() {
        return this.page.getRenderCount();
    }

    public ILogData getLogData() {
        return this.logData;
    }

    public Class<? extends IRequestablePage> getPageClass() {
        return this.page.getPageClass();
    }

    public PageParameters getPageParameters() {
        return this.page.getPageParameters();
    }

    public void respond(IRequestCycle requestCycle) {
        if (this.update != null) {
            this.update.writeTo(requestCycle.getResponse(), "UTF-8");
        }
    }

    public void detach(IRequestCycle requestCycle) {
        if (this.logData == null) {
            this.logData = new PageLogData(this.page);
        }
        if (this.update != null) {
            this.update.detach(requestCycle);
            this.update = null;
        }
    }
}

