
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 * Add a L1 element to a L2 namespace aware document and perform namespace normalization.  Should result
 * in an error.
* @author Curt Arnold
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-normalizeDocument">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-normalizeDocument</a>
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/namespaces-algorithms#normalizeDocumentAlgo">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/namespaces-algorithms#normalizeDocumentAlgo</a>
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#parameter-namespaces">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#parameter-namespaces</a>
*/
public final class documentnormalizedocument05 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public documentnormalizedocument05(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "barfoo", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Element elem;
      DOMConfiguration domConfig;
      NodeList pList;
      Element newChild;
      Element retval;
      org.w3c.domts.DOMErrorMonitor errorMonitor = new org.w3c.domts.DOMErrorMonitor();
      
      java.util.List errors = new java.util.ArrayList();
      
      DOMError error;
      int errorCount = 0;
      int severity;
      Node problemNode;
      DOMLocator location;
      int lineNumber;
      int columnNumber;
      int byteOffset;
      int utf16Offset;
      String uri;
      String type;
      String message;
      Object relatedException;
      Object relatedData;
      int length;
      doc = (Document) load("barfoo", true);
      pList = doc.getElementsByTagName("p");
      elem = (Element) pList.item(0);
      newChild = doc.createElement("br");
      retval = (Element) elem.appendChild(newChild);
      domConfig = doc.getDomConfig();
      domConfig.setParameter("namespaces", Boolean.TRUE);
      domConfig.setParameter("error-handler", ((Object) /*DOMErrorMonitor */errorMonitor));
      doc.normalizeDocument();
      errors = errorMonitor.getAllErrors();
for (int indexN100B6 = 0; indexN100B6 < errors.size(); indexN100B6++) {
          error = (DOMError) errors.get(indexN100B6);
    severity = (int) error.getSeverity();
      
      if (equals(2, severity)) {
          location = error.getLocation();
      problemNode = location.getRelatedNode();
      assertSame("relatedNodeIsL1Node", newChild, problemNode);
lineNumber = (int) location.getLineNumber();
      assertEquals("lineNumber", -1, lineNumber);
      columnNumber = (int) location.getColumnNumber();
      assertEquals("columnNumber", -1, columnNumber);
      byteOffset = (int) location.getByteOffset();
      assertEquals("byteOffset", -1, byteOffset);
      utf16Offset = (int) location.getUtf16Offset();
      assertEquals("utf16Offset", -1, utf16Offset);
      uri = location.getUri();
      assertNull("uri", uri);
      message = error.getMessage();
      length = message.length();
      assertTrue("messageNotEmpty", (length > 0));
      type = error.getType();
      relatedData = error.getRelatedData();
      relatedException = error.getRelatedException();
      errorCount += 1;
      } else {
          assertEquals("anyOthersShouldBeWarnings", 1, severity);
      }
        
      }
      assertEquals("oneError", 1, errorCount);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/documentnormalizedocument05";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(documentnormalizedocument05.class, args);
   }
}

