
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  The contains method of the DOMStringList tests if a string is part of this DOMStringList.  
 *  
 *  Invoke the contains method on the list searching for several of the parameters recognized by the 
 *         DOMConfiguration object.  
 *  Verify that the list contains features that are required and supported by this DOMConfiguration object.
 *         Verify that the contains method returns false for a string that is not contained in this DOMStringList. 
* @author IBM
* @author Jenny Hsu
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#DOMStringList-contains">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#DOMStringList-contains</a>
*/
public final class domstringlistcontains02 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public domstringlistcontains02(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      DOMStringList paramList;
      DOMConfiguration domConfig;
      boolean contain;
      doc = (Document) load("hc_staff", false);
      domConfig = doc.getDomConfig();
      paramList = domConfig.getParameterNames();
      contain = paramList.contains("comments");
      assertTrue("domstringlistcontains02_1", contain);
      contain = paramList.contains("cdata-sections");
      assertTrue("domstringlistcontains02_2", contain);
      contain = paramList.contains("entities");
      assertTrue("domstringlistcontains02_3", contain);
      contain = paramList.contains("error-handler");
      assertTrue("domstringlistcontains02_4", contain);
      contain = paramList.contains("infoset");
      assertTrue("domstringlistcontains02_5", contain);
      contain = paramList.contains("namespace-declarations");
      assertTrue("domstringlistcontains02_6", contain);
      contain = paramList.contains("element-content-whitespace");
      assertTrue("domstringlistcontains02_7", contain);
      contain = paramList.contains("test");
      assertFalse("domstringlistcontains02_8", contain);
}
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/domstringlistcontains02";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(domstringlistcontains02.class, args);
   }
}

