/* desktop-file-plugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from desktop-file-plugin.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include "slingshot.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH (synapse_desktop_file_plugin_desktop_file_match_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatchClass))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_DESKTOP_FILE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_DESKTOP_FILE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatchClass))

typedef struct _SynapseDesktopFilePluginDesktopFileMatch SynapseDesktopFilePluginDesktopFileMatch;
typedef struct _SynapseDesktopFilePluginDesktopFileMatchClass SynapseDesktopFilePluginDesktopFileMatchClass;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseDesktopFilePluginLoadAllDesktopFilesData SynapseDesktopFilePluginLoadAllDesktopFilesData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
typedef struct _Block11Data Block11Data;
typedef struct _SynapseDesktopFilePluginSearchData SynapseDesktopFilePluginSearchData;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NUM_PROPERTIES];
typedef struct _SynapseDesktopFilePluginDesktopFileMatchPrivate SynapseDesktopFilePluginDesktopFileMatchPrivate;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GETTEXT_DOMAIN_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NUM_PROPERTIES];

#define SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION (synapse_desktop_file_plugin_open_with_action_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithActionClass))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_OPEN_WITH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_OPEN_WITH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithActionClass))

typedef struct _SynapseDesktopFilePluginOpenWithAction SynapseDesktopFilePluginOpenWithAction;
typedef struct _SynapseDesktopFilePluginOpenWithActionClass SynapseDesktopFilePluginOpenWithActionClass;
typedef struct _SynapseDesktopFilePluginOpenWithActionPrivate SynapseDesktopFilePluginOpenWithActionPrivate;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_LOAD_COMPLETE_SIGNAL,
	SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_SIGNALS
};
static guint synapse_desktop_file_plugin_signals[SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_SIGNALS] = {0};

struct _SynapseDesktopFilePluginPrivate {
	gboolean _enabled;
	GeeList* desktop_files;
	gboolean loading_in_progress;
};

struct _SynapseDesktopFilePluginLoadAllDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFilePlugin* self;
	SynapseDesktopFileService* dfs;
	SynapseDesktopFileService* _tmp0_;
	GeeList* _dfi_list;
	SynapseDesktopFileService* _tmp1_;
	GeeList* _tmp2_;
	gint _dfi_size;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _dfi_index;
	gint _tmp6_;
	gint _tmp7_;
	SynapseDesktopFileInfo* dfi;
	GeeList* _tmp8_;
	gpointer _tmp9_;
	GeeList* _tmp10_;
	SynapseDesktopFileInfo* _tmp11_;
	SynapseDesktopFilePluginDesktopFileMatch* _tmp12_;
	SynapseDesktopFilePluginDesktopFileMatch* _tmp13_;
};

struct _Block11Data {
	int _ref_count_;
	SynapseDesktopFilePlugin* self;
	gpointer _async_data_;
};

struct _SynapseDesktopFilePluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFilePlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	Block11Data* _data11_;
	gulong signal_id;
	gulong _tmp0_;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp1_;
	SynapseQuery _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	SynapseMatcherFlags flags;
	SynapseQuery _tmp6_;
	SynapseResultSet* _tmp7_;
	SynapseQuery _tmp8_;
	SynapseResultSet* _tmp9_;
	GError* _inner_error0_;
};

struct _SynapseDesktopFilePluginActionMatchPrivate {
	GAppInfo* _app_info;
	gboolean _needs_terminal;
	gchar* action_name;
};

struct _SynapseDesktopFilePluginDesktopFileMatch {
	SynapseMatch parent_instance;
	SynapseDesktopFilePluginDesktopFileMatchPrivate * priv;
};

struct _SynapseDesktopFilePluginDesktopFileMatchClass {
	SynapseMatchClass parent_class;
};

struct _SynapseDesktopFilePluginDesktopFileMatchPrivate {
	GAppInfo* _app_info;
	gboolean _needs_terminal;
	gchar* _filename;
	gchar* _generic_name;
	gchar* _gettext_domain;
	gchar* title_folded;
	gchar* _title_unaccented;
	gchar* _desktop_id;
	gchar* _exec;
};

struct _SynapseDesktopFilePluginOpenWithAction {
	SynapseMatch parent_instance;
	SynapseDesktopFilePluginOpenWithActionPrivate * priv;
};

struct _SynapseDesktopFilePluginOpenWithActionClass {
	SynapseMatchClass parent_class;
};

struct _SynapseDesktopFilePluginOpenWithActionPrivate {
	SynapseDesktopFileInfo* _desktop_info;
};

static gint SynapseDesktopFilePlugin_private_offset;
static gpointer synapse_desktop_file_plugin_parent_class = NULL;
static gint SynapseDesktopFilePluginActionMatch_private_offset;
static gpointer synapse_desktop_file_plugin_action_match_parent_class = NULL;
static GType synapse_desktop_file_plugin_action_match_type_id = 0;
static gint SynapseDesktopFilePluginDesktopFileMatch_private_offset;
static gpointer synapse_desktop_file_plugin_desktop_file_match_parent_class = NULL;
static SynapseApplicationMatchIface * synapse_desktop_file_plugin_desktop_file_match_synapse_application_match_parent_iface = NULL;
static GType synapse_desktop_file_plugin_desktop_file_match_type_id = 0;
static gint SynapseDesktopFilePluginOpenWithAction_private_offset;
static gpointer synapse_desktop_file_plugin_open_with_action_parent_class = NULL;
static GType synapse_desktop_file_plugin_open_with_action_type_id = 0;
static SynapseActivatableIface * synapse_desktop_file_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_desktop_file_plugin_synapse_item_provider_parent_iface = NULL;
static GType synapse_desktop_file_plugin_type_id = 0;

GType synapse_desktop_file_plugin_desktop_file_match_register_type (GTypeModule * module);
VALA_EXTERN GType synapse_desktop_file_plugin_desktop_file_match_get_type (void) G_GNUC_CONST ;
static void synapse_desktop_file_plugin_real_activate (SynapseActivatable* base);
static void synapse_desktop_file_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_desktop_file_plugin_register_plugin (void);
static void _synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_desktop_file_plugin_load_all_desktop_files_data_free (gpointer _data);
static void synapse_desktop_file_plugin_load_all_desktop_files (SynapseDesktopFilePlugin* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static void synapse_desktop_file_plugin_load_all_desktop_files_finish (SynapseDesktopFilePlugin* self,
                                                                GAsyncResult* _res_);
static gboolean synapse_desktop_file_plugin_load_all_desktop_files_co (SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_);
static gboolean _synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func (gpointer self);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_new_for_info (SynapseDesktopFileInfo* info);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_construct_for_info (GType object_type,
                                                                                                             SynapseDesktopFileInfo* info);
static gint synapse_desktop_file_plugin_compute_relevancy (SynapseDesktopFilePlugin* self,
                                                    SynapseDesktopFilePluginDesktopFileMatch* dfm,
                                                    gint base_relevancy);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self);
static void synapse_desktop_file_plugin_full_search (SynapseDesktopFilePlugin* self,
                                              SynapseQuery* q,
                                              SynapseResultSet* results,
                                              SynapseMatcherFlags flags);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_title_folded (SynapseDesktopFilePluginDesktopFileMatch* self);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_generic_name (SynapseDesktopFilePluginDesktopFileMatch* self);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_gettext_domain (SynapseDesktopFilePluginDesktopFileMatch* self);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_exec (SynapseDesktopFilePluginDesktopFileMatch* self);
static gboolean synapse_desktop_file_plugin_real_handles_query (SynapseItemProvider* base,
                                                         SynapseQuery* q);
static void synapse_desktop_file_plugin_real_search_data_free (gpointer _data);
static void synapse_desktop_file_plugin_real_search (SynapseItemProvider* base,
                                              SynapseQuery* q,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean synapse_desktop_file_plugin_real_search_co (SynapseDesktopFilePluginSearchData* _data_);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void ___lambda26_ (Block11Data* _data11_);
static void ____lambda26__synapse_desktop_file_plugin_load_complete (SynapseDesktopFilePlugin* _sender,
                                                              gpointer self);
static gboolean _synapse_desktop_file_plugin_real_search_co_gsource_func (gpointer self);
static void synapse_desktop_file_plugin_action_match_real_execute (SynapseMatch* base,
                                                            SynapseMatch* match);
static void synapse_desktop_file_plugin_action_match_finalize (GObject * obj);
static void _vala_synapse_desktop_file_plugin_action_match_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_action_match_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec);
static void synapse_desktop_file_plugin_desktop_file_match_init_from_info (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                    SynapseDesktopFileInfo* info);
static void synapse_desktop_file_plugin_desktop_file_match_set_exec (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                              const gchar* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                          const gchar* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                    const gchar* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_generic_name (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                      const gchar* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_gettext_domain (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                        const gchar* value);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_new (void);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_construct (GType object_type);
static void synapse_desktop_file_plugin_desktop_file_match_finalize (GObject * obj);
static void _vala_synapse_desktop_file_plugin_desktop_file_match_get_property (GObject * object,
                                                                        guint property_id,
                                                                        GValue * value,
                                                                        GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_desktop_file_match_set_property (GObject * object,
                                                                        guint property_id,
                                                                        const GValue * value,
                                                                        GParamSpec * pspec);
GType synapse_desktop_file_plugin_open_with_action_register_type (GTypeModule * module);
VALA_EXTERN GType synapse_desktop_file_plugin_open_with_action_get_type (void) G_GNUC_CONST ;
static SynapseDesktopFilePluginOpenWithAction* synapse_desktop_file_plugin_open_with_action_new (SynapseDesktopFileInfo* info);
static SynapseDesktopFilePluginOpenWithAction* synapse_desktop_file_plugin_open_with_action_construct (GType object_type,
                                                                                                SynapseDesktopFileInfo* info);
static void synapse_desktop_file_plugin_open_with_action_init_with_info (SynapseDesktopFilePluginOpenWithAction* self,
                                                                  SynapseDesktopFileInfo* info);
static void synapse_desktop_file_plugin_open_with_action_set_desktop_info (SynapseDesktopFilePluginOpenWithAction* self,
                                                                    SynapseDesktopFileInfo* value);
static void synapse_desktop_file_plugin_open_with_action_real_execute (SynapseMatch* base,
                                                                SynapseMatch* match);
static SynapseDesktopFileInfo* synapse_desktop_file_plugin_open_with_action_get_desktop_info (SynapseDesktopFilePluginOpenWithAction* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void synapse_desktop_file_plugin_open_with_action_finalize (GObject * obj);
static void _vala_synapse_desktop_file_plugin_open_with_action_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_open_with_action_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec);
static GObject * synapse_desktop_file_plugin_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _synapse_desktop_file_plugin___lambda27_ (SynapseDesktopFilePlugin* self);
static void __synapse_desktop_file_plugin___lambda27__synapse_desktop_file_service_reload_started (SynapseDesktopFileService* _sender,
                                                                                            gpointer self);
static void _synapse_desktop_file_plugin___lambda28_ (SynapseDesktopFilePlugin* self);
static void __synapse_desktop_file_plugin___lambda28__synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender,
                                                                                         gpointer self);
static void synapse_desktop_file_plugin_finalize (GObject * obj);
static void _vala_synapse_desktop_file_plugin_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static gssize _vala_array_length (gpointer array);

static const gchar* SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_SUPPORTED_GETTEXT_DOMAINS_KEYS[2] = {"X-Ubuntu-Gettext-Domain", "X-GNOME-Gettext-Domain"};

static inline gpointer
synapse_desktop_file_plugin_get_instance_private (SynapseDesktopFilePlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePlugin_private_offset);
}

static void
synapse_desktop_file_plugin_real_activate (SynapseActivatable* base)
{
	SynapseDesktopFilePlugin * self;
	self = (SynapseDesktopFilePlugin*) base;
}

static void
synapse_desktop_file_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseDesktopFilePlugin * self;
	self = (SynapseDesktopFilePlugin*) base;
}

static void
_synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func (void)
{
	synapse_desktop_file_plugin_register_plugin ();
}

static void
synapse_desktop_file_plugin_register_plugin (void)
{
	SynapseDataSinkPluginRegistry* _tmp0_;
	SynapseDataSinkPluginRegistry* _tmp1_;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, "Application Search", _ ("Search for and run applications on your computer."), "system-run", _synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
	_g_object_unref0 (_tmp1_);
}

static void
synapse_desktop_file_plugin_load_all_desktop_files_data_free (gpointer _data)
{
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseDesktopFilePluginLoadAllDesktopFilesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
synapse_desktop_file_plugin_load_all_desktop_files (SynapseDesktopFilePlugin* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
	SynapseDesktopFilePlugin* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SynapseDesktopFilePluginLoadAllDesktopFilesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_plugin_load_all_desktop_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	synapse_desktop_file_plugin_load_all_desktop_files_co (_data_);
}

static void
synapse_desktop_file_plugin_load_all_desktop_files_finish (SynapseDesktopFilePlugin* self,
                                                           GAsyncResult* _res_)
{
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_desktop_file_plugin_load_all_desktop_files_co (self);
	return result;
}

static gboolean
synapse_desktop_file_plugin_load_all_desktop_files_co (SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->loading_in_progress = TRUE;
	g_idle_add_full (G_PRIORITY_LOW, _synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp0_ = synapse_desktop_file_service_get_default ();
	_data_->dfs = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->dfs;
		_data_->_tmp2_ = synapse_desktop_file_service_get_desktop_files (_data_->_tmp1_);
		_data_->_dfi_list = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->_dfi_list;
		_data_->_tmp4_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_dfi_size = _data_->_tmp5_;
		_data_->_dfi_index = -1;
		while (TRUE) {
			_data_->_dfi_index = _data_->_dfi_index + 1;
			_data_->_tmp6_ = _data_->_dfi_index;
			_data_->_tmp7_ = _data_->_dfi_size;
			if (!(_data_->_tmp6_ < _data_->_tmp7_)) {
				break;
			}
			_data_->_tmp8_ = _data_->_dfi_list;
			_data_->_tmp9_ = gee_list_get (_data_->_tmp8_, _data_->_dfi_index);
			_data_->dfi = (SynapseDesktopFileInfo*) _data_->_tmp9_;
			_data_->_tmp10_ = _data_->self->priv->desktop_files;
			_data_->_tmp11_ = _data_->dfi;
			_data_->_tmp12_ = synapse_desktop_file_plugin_desktop_file_match_new_for_info (_data_->_tmp11_);
			_data_->_tmp13_ = _data_->_tmp12_;
			gee_collection_add ((GeeCollection*) _data_->_tmp10_, _data_->_tmp13_);
			_g_object_unref0 (_data_->_tmp13_);
			_g_object_unref0 (_data_->dfi);
		}
		_g_object_unref0 (_data_->_dfi_list);
	}
	_data_->self->priv->loading_in_progress = FALSE;
	g_signal_emit (_data_->self, synapse_desktop_file_plugin_signals[SYNAPSE_DESKTOP_FILE_PLUGIN_LOAD_COMPLETE_SIGNAL], 0);
	_g_object_unref0 (_data_->dfs);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gint
synapse_desktop_file_plugin_compute_relevancy (SynapseDesktopFilePlugin* self,
                                               SynapseDesktopFilePluginDesktopFileMatch* dfm,
                                               gint base_relevancy)
{
	SynapseRelevancyService* rs = NULL;
	SynapseRelevancyService* _tmp0_;
	gfloat popularity = 0.0F;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint r = 0;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (dfm != NULL, 0);
	_tmp0_ = synapse_relevancy_service_get_default ();
	rs = _tmp0_;
	_tmp1_ = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (dfm);
	_tmp2_ = _tmp1_;
	popularity = synapse_relevancy_service_get_application_popularity (rs, _tmp2_);
	r = synapse_relevancy_service_compute_relevancy (base_relevancy, popularity);
	_tmp3_ = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (dfm);
	_tmp4_ = _tmp3_;
	g_debug ("desktop-file-plugin.vala:166: relevancy for %s: %d", _tmp4_, r);
	result = r;
	_g_object_unref0 (rs);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
synapse_desktop_file_plugin_full_search (SynapseDesktopFilePlugin* self,
                                         SynapseQuery* q,
                                         SynapseResultSet* results,
                                         SynapseMatcherFlags flags)
{
	GeeList* matchers = NULL;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	GeeList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (q != NULL);
	g_return_if_fail (results != NULL);
	_tmp0_ = *q;
	_tmp1_ = _tmp0_.query_string_folded;
	_tmp2_ = synapse_query_get_matchers_for_query (_tmp1_, flags, G_REGEX_OPTIMIZE);
	matchers = _tmp2_;
	{
		GeeList* _dfm_list = NULL;
		GeeList* _tmp3_;
		gint _dfm_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _dfm_index = 0;
		_tmp3_ = self->priv->desktop_files;
		_dfm_list = _tmp3_;
		_tmp4_ = _dfm_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_dfm_size = _tmp6_;
		_dfm_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			SynapseDesktopFilePluginDesktopFileMatch* dfm = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			const gchar* folded_title = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp11_;
			const gchar* _tmp12_;
			const gchar* unaccented_title = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			const gchar* comment = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* generic_name = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			const gchar* gettext_domain = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* id = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			GDesktopAppInfo* desktop_app_info = NULL;
			const gchar* _tmp29_;
			GDesktopAppInfo* _tmp30_;
			GDesktopAppInfo* _tmp31_;
			GMatchInfo* info = NULL;
			GDesktopAppInfo* _tmp32_;
			gchar** _tmp33_;
			gchar** _tmp34_;
			gboolean matched = FALSE;
			gchar** keywords = NULL;
			GDesktopAppInfo* _tmp73_;
			gchar** _tmp74_;
			gchar** _tmp75_;
			gint keywords_length1;
			gint _keywords_size_;
			gboolean _tmp127_ = FALSE;
			const gchar* _tmp128_;
			gchar* _tmp129_;
			gchar* _tmp130_;
			SynapseQuery _tmp131_;
			const gchar* _tmp132_;
			gboolean _tmp133_;
			_dfm_index = _dfm_index + 1;
			_tmp7_ = _dfm_index;
			_tmp8_ = _dfm_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _dfm_list;
			_tmp10_ = gee_list_get (_tmp9_, _dfm_index);
			dfm = (SynapseDesktopFilePluginDesktopFileMatch*) _tmp10_;
			_tmp11_ = dfm;
			_tmp12_ = synapse_desktop_file_plugin_desktop_file_match_get_title_folded (_tmp11_);
			folded_title = _tmp12_;
			_tmp13_ = dfm;
			_tmp14_ = synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (_tmp13_);
			_tmp15_ = _tmp14_;
			unaccented_title = _tmp15_;
			_tmp16_ = dfm;
			_tmp17_ = synapse_match_get_description ((SynapseMatch*) _tmp16_);
			_tmp18_ = _tmp17_;
			comment = _tmp18_;
			_tmp19_ = dfm;
			_tmp20_ = synapse_desktop_file_plugin_desktop_file_match_get_generic_name (_tmp19_);
			_tmp21_ = _tmp20_;
			generic_name = _tmp21_;
			_tmp22_ = dfm;
			_tmp23_ = synapse_desktop_file_plugin_desktop_file_match_get_gettext_domain (_tmp22_);
			_tmp24_ = _tmp23_;
			gettext_domain = _tmp24_;
			_tmp25_ = dfm;
			_tmp26_ = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = string_replace (_tmp27_, "application://", "");
			id = _tmp28_;
			_tmp29_ = id;
			_tmp30_ = g_desktop_app_info_new (_tmp29_);
			desktop_app_info = _tmp30_;
			_tmp31_ = desktop_app_info;
			if (_tmp31_ == NULL) {
				_g_object_unref0 (desktop_app_info);
				_g_free0 (id);
				_g_object_unref0 (dfm);
				continue;
			}
			_tmp32_ = desktop_app_info;
			_tmp34_ = _tmp33_ = g_desktop_app_info_list_actions (_tmp32_);
			{
				gchar** action_collection = NULL;
				gint action_collection_length1 = 0;
				gint _action_collection_size_ = 0;
				gint action_it = 0;
				action_collection = _tmp34_;
				action_collection_length1 = _vala_array_length (_tmp33_);
				for (action_it = 0; action_it < action_collection_length1; action_it = action_it + 1) {
					gchar* _tmp35_;
					gchar* action = NULL;
					_tmp35_ = g_strdup (action_collection[action_it]);
					action = _tmp35_;
					{
						gchar* title = NULL;
						GDesktopAppInfo* _tmp36_;
						const gchar* _tmp37_;
						gchar* _tmp38_;
						const gchar* _tmp39_;
						_tmp36_ = desktop_app_info;
						_tmp37_ = action;
						_tmp38_ = g_desktop_app_info_get_action_name (_tmp36_, _tmp37_);
						title = _tmp38_;
						_tmp39_ = gettext_domain;
						if (_tmp39_ != NULL) {
							const gchar* _tmp40_;
							const gchar* _tmp41_;
							gchar* _tmp42_;
							_tmp40_ = gettext_domain;
							_tmp41_ = title;
							_tmp42_ = g_utf8_strdown (g_dgettext (_tmp40_, _tmp41_), (gssize) -1);
							_g_free0 (title);
							title = _tmp42_;
						} else {
							const gchar* _tmp43_;
							gchar* _tmp44_;
							_tmp43_ = title;
							_tmp44_ = g_utf8_strdown (_tmp43_, (gssize) -1);
							_g_free0 (title);
							title = _tmp44_;
						}
						{
							GeeList* _matcher_list = NULL;
							GeeList* _tmp45_;
							gint _matcher_size = 0;
							GeeList* _tmp46_;
							gint _tmp47_;
							gint _tmp48_;
							gint _matcher_index = 0;
							_tmp45_ = matchers;
							_matcher_list = _tmp45_;
							_tmp46_ = _matcher_list;
							_tmp47_ = gee_collection_get_size ((GeeCollection*) _tmp46_);
							_tmp48_ = _tmp47_;
							_matcher_size = _tmp48_;
							_matcher_index = -1;
							while (TRUE) {
								gint _tmp49_;
								gint _tmp50_;
								GeeMapEntry* matcher = NULL;
								GeeList* _tmp51_;
								gpointer _tmp52_;
								GeeMapEntry* _tmp53_;
								gconstpointer _tmp54_;
								gconstpointer _tmp55_;
								const gchar* _tmp56_;
								GMatchInfo* _tmp57_ = NULL;
								gboolean _tmp58_;
								_matcher_index = _matcher_index + 1;
								_tmp49_ = _matcher_index;
								_tmp50_ = _matcher_size;
								if (!(_tmp49_ < _tmp50_)) {
									break;
								}
								_tmp51_ = _matcher_list;
								_tmp52_ = gee_list_get (_tmp51_, _matcher_index);
								matcher = (GeeMapEntry*) _tmp52_;
								_tmp53_ = matcher;
								_tmp54_ = gee_map_entry_get_key (_tmp53_);
								_tmp55_ = _tmp54_;
								_tmp56_ = title;
								_tmp58_ = g_regex_match ((GRegex*) _tmp55_, _tmp56_, 0, &_tmp57_);
								_g_match_info_unref0 (info);
								info = _tmp57_;
								if (_tmp58_) {
									SynapseDesktopFilePluginActionMatch* am = NULL;
									const gchar* _tmp59_;
									const gchar* _tmp60_;
									SynapseDesktopFilePluginActionMatch* _tmp61_;
									SynapseDesktopFilePluginActionMatch* _tmp62_;
									SynapseDesktopFilePluginDesktopFileMatch* _tmp63_;
									GeeMapEntry* _tmp64_;
									gconstpointer _tmp65_;
									gconstpointer _tmp66_;
									_tmp59_ = id;
									_tmp60_ = action;
									_tmp61_ = synapse_desktop_file_plugin_action_match_new (_tmp59_, _tmp60_);
									am = _tmp61_;
									_tmp62_ = am;
									_tmp63_ = dfm;
									_tmp64_ = matcher;
									_tmp65_ = gee_map_entry_get_value (_tmp64_);
									_tmp66_ = _tmp65_;
									synapse_result_set_add (results, (SynapseMatch*) _tmp62_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp63_, (gint) ((gintptr) _tmp66_)));
									_g_object_unref0 (am);
									_g_object_unref0 (matcher);
									break;
								} else {
									GMatchInfo* _tmp67_;
									_tmp67_ = info;
									if (g_match_info_is_partial_match (_tmp67_)) {
										SynapseDesktopFilePluginActionMatch* am = NULL;
										const gchar* _tmp68_;
										const gchar* _tmp69_;
										SynapseDesktopFilePluginActionMatch* _tmp70_;
										SynapseDesktopFilePluginActionMatch* _tmp71_;
										SynapseDesktopFilePluginDesktopFileMatch* _tmp72_;
										_tmp68_ = id;
										_tmp69_ = action;
										_tmp70_ = synapse_desktop_file_plugin_action_match_new (_tmp68_, _tmp69_);
										am = _tmp70_;
										_tmp71_ = am;
										_tmp72_ = dfm;
										synapse_result_set_add (results, (SynapseMatch*) _tmp71_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp72_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE));
										_g_object_unref0 (am);
										_g_object_unref0 (matcher);
										break;
									}
								}
								_g_object_unref0 (matcher);
							}
						}
						_g_free0 (title);
						_g_free0 (action);
					}
				}
			}
			matched = FALSE;
			_tmp73_ = desktop_app_info;
			_tmp75_ = _tmp74_ = g_desktop_app_info_get_keywords (_tmp73_);
			keywords = _tmp75_;
			keywords_length1 = _vala_array_length (_tmp74_);
			_keywords_size_ = keywords_length1;
			{
				GeeList* _matcher_list = NULL;
				GeeList* _tmp76_;
				gint _matcher_size = 0;
				GeeList* _tmp77_;
				gint _tmp78_;
				gint _tmp79_;
				gint _matcher_index = 0;
				_tmp76_ = matchers;
				_matcher_list = _tmp76_;
				_tmp77_ = _matcher_list;
				_tmp78_ = gee_collection_get_size ((GeeCollection*) _tmp77_);
				_tmp79_ = _tmp78_;
				_matcher_size = _tmp79_;
				_matcher_index = -1;
				while (TRUE) {
					gint _tmp80_;
					gint _tmp81_;
					GeeMapEntry* matcher = NULL;
					GeeList* _tmp82_;
					gpointer _tmp83_;
					GeeMapEntry* _tmp84_;
					gconstpointer _tmp85_;
					gconstpointer _tmp86_;
					const gchar* _tmp87_;
					GMatchInfo* _tmp88_ = NULL;
					gboolean _tmp89_;
					gchar** _tmp109_;
					gint _tmp109__length1;
					_matcher_index = _matcher_index + 1;
					_tmp80_ = _matcher_index;
					_tmp81_ = _matcher_size;
					if (!(_tmp80_ < _tmp81_)) {
						break;
					}
					_tmp82_ = _matcher_list;
					_tmp83_ = gee_list_get (_tmp82_, _matcher_index);
					matcher = (GeeMapEntry*) _tmp83_;
					_tmp84_ = matcher;
					_tmp85_ = gee_map_entry_get_key (_tmp84_);
					_tmp86_ = _tmp85_;
					_tmp87_ = folded_title;
					_tmp89_ = g_regex_match ((GRegex*) _tmp86_, _tmp87_, 0, &_tmp88_);
					_g_match_info_unref0 (info);
					info = _tmp88_;
					if (_tmp89_) {
						SynapseDesktopFilePluginDesktopFileMatch* _tmp90_;
						SynapseDesktopFilePluginDesktopFileMatch* _tmp91_;
						GeeMapEntry* _tmp92_;
						gconstpointer _tmp93_;
						gconstpointer _tmp94_;
						_tmp90_ = dfm;
						_tmp91_ = dfm;
						_tmp92_ = matcher;
						_tmp93_ = gee_map_entry_get_value (_tmp92_);
						_tmp94_ = _tmp93_;
						synapse_result_set_add (results, (SynapseMatch*) _tmp90_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp91_, (gint) ((gintptr) _tmp94_)));
						matched = TRUE;
						_g_object_unref0 (matcher);
						break;
					} else {
						gboolean _tmp95_ = FALSE;
						const gchar* _tmp96_;
						_tmp96_ = unaccented_title;
						if (_tmp96_ != NULL) {
							GeeMapEntry* _tmp97_;
							gconstpointer _tmp98_;
							gconstpointer _tmp99_;
							const gchar* _tmp100_;
							_tmp97_ = matcher;
							_tmp98_ = gee_map_entry_get_key (_tmp97_);
							_tmp99_ = _tmp98_;
							_tmp100_ = unaccented_title;
							_tmp95_ = g_regex_match ((GRegex*) _tmp99_, _tmp100_, 0, NULL);
						} else {
							_tmp95_ = FALSE;
						}
						if (_tmp95_) {
							SynapseDesktopFilePluginDesktopFileMatch* _tmp101_;
							SynapseDesktopFilePluginDesktopFileMatch* _tmp102_;
							GeeMapEntry* _tmp103_;
							gconstpointer _tmp104_;
							gconstpointer _tmp105_;
							_tmp101_ = dfm;
							_tmp102_ = dfm;
							_tmp103_ = matcher;
							_tmp104_ = gee_map_entry_get_value (_tmp103_);
							_tmp105_ = _tmp104_;
							synapse_result_set_add (results, (SynapseMatch*) _tmp101_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp102_, ((gint) ((gintptr) _tmp105_)) - SYNAPSE_MATCH_SCORE_INCREMENT_SMALL));
							matched = TRUE;
							_g_object_unref0 (matcher);
							break;
						} else {
							GMatchInfo* _tmp106_;
							_tmp106_ = info;
							if (g_match_info_is_partial_match (_tmp106_)) {
								SynapseDesktopFilePluginDesktopFileMatch* _tmp107_;
								SynapseDesktopFilePluginDesktopFileMatch* _tmp108_;
								_tmp107_ = dfm;
								_tmp108_ = dfm;
								synapse_result_set_add (results, (SynapseMatch*) _tmp107_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp108_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE));
								matched = TRUE;
								_g_object_unref0 (matcher);
								break;
							}
						}
					}
					_tmp109_ = keywords;
					_tmp109__length1 = keywords_length1;
					{
						gchar** keyword_collection = NULL;
						gint keyword_collection_length1 = 0;
						gint _keyword_collection_size_ = 0;
						gint keyword_it = 0;
						keyword_collection = _tmp109_;
						keyword_collection_length1 = _tmp109__length1;
						for (keyword_it = 0; keyword_it < keyword_collection_length1; keyword_it = keyword_it + 1) {
							gchar* _tmp110_;
							gchar* keyword = NULL;
							_tmp110_ = g_strdup (keyword_collection[keyword_it]);
							keyword = _tmp110_;
							{
								const gchar* _tmp111_;
								gchar* _tmp112_;
								GeeMapEntry* _tmp113_;
								gconstpointer _tmp114_;
								gconstpointer _tmp115_;
								const gchar* _tmp116_;
								GMatchInfo* _tmp117_ = NULL;
								gboolean _tmp118_;
								_tmp111_ = keyword;
								_tmp112_ = g_utf8_strdown (_tmp111_, (gssize) -1);
								_g_free0 (keyword);
								keyword = _tmp112_;
								_tmp113_ = matcher;
								_tmp114_ = gee_map_entry_get_key (_tmp113_);
								_tmp115_ = _tmp114_;
								_tmp116_ = keyword;
								_tmp118_ = g_regex_match ((GRegex*) _tmp115_, _tmp116_, 0, &_tmp117_);
								_g_match_info_unref0 (info);
								info = _tmp117_;
								if (_tmp118_) {
									SynapseDesktopFilePluginDesktopFileMatch* _tmp119_;
									SynapseDesktopFilePluginDesktopFileMatch* _tmp120_;
									GeeMapEntry* _tmp121_;
									gconstpointer _tmp122_;
									gconstpointer _tmp123_;
									_tmp119_ = dfm;
									_tmp120_ = dfm;
									_tmp121_ = matcher;
									_tmp122_ = gee_map_entry_get_value (_tmp121_);
									_tmp123_ = _tmp122_;
									synapse_result_set_add (results, (SynapseMatch*) _tmp119_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp120_, ((gint) ((gintptr) _tmp123_)) - SYNAPSE_MATCH_SCORE_INCREMENT_LARGE));
									matched = TRUE;
									_g_free0 (keyword);
									break;
								} else {
									GMatchInfo* _tmp124_;
									_tmp124_ = info;
									if (g_match_info_is_partial_match (_tmp124_)) {
										SynapseDesktopFilePluginDesktopFileMatch* _tmp125_;
										SynapseDesktopFilePluginDesktopFileMatch* _tmp126_;
										_tmp125_ = dfm;
										_tmp126_ = dfm;
										synapse_result_set_add (results, (SynapseMatch*) _tmp125_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp126_, (gint) (SYNAPSE_MATCH_SCORE_POOR - SYNAPSE_MATCH_SCORE_INCREMENT_LARGE)));
										matched = TRUE;
										_g_free0 (keyword);
										break;
									}
								}
								_g_free0 (keyword);
							}
						}
					}
					_g_object_unref0 (matcher);
				}
			}
			if (matched) {
				_g_match_info_unref0 (info);
				_g_object_unref0 (desktop_app_info);
				_g_free0 (id);
				_g_object_unref0 (dfm);
				continue;
			}
			_tmp128_ = comment;
			_tmp129_ = g_utf8_strdown (_tmp128_, (gssize) -1);
			_tmp130_ = _tmp129_;
			_tmp131_ = *q;
			_tmp132_ = _tmp131_.query_string_folded;
			_tmp133_ = string_contains (_tmp130_, _tmp132_);
			_g_free0 (_tmp130_);
			if (_tmp133_) {
				_tmp127_ = TRUE;
			} else {
				const gchar* _tmp134_;
				gchar* _tmp135_;
				gchar* _tmp136_;
				SynapseQuery _tmp137_;
				const gchar* _tmp138_;
				_tmp134_ = generic_name;
				_tmp135_ = g_utf8_strdown (_tmp134_, (gssize) -1);
				_tmp136_ = _tmp135_;
				_tmp137_ = *q;
				_tmp138_ = _tmp137_.query_string_folded;
				_tmp127_ = string_contains (_tmp136_, _tmp138_);
				_g_free0 (_tmp136_);
			}
			if (_tmp127_) {
				SynapseDesktopFilePluginDesktopFileMatch* _tmp139_;
				SynapseDesktopFilePluginDesktopFileMatch* _tmp140_;
				_tmp139_ = dfm;
				_tmp140_ = dfm;
				synapse_result_set_add (results, (SynapseMatch*) _tmp139_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp140_, (gint) (SYNAPSE_MATCH_SCORE_BELOW_AVERAGE - SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM)));
			} else {
				SynapseDesktopFilePluginDesktopFileMatch* _tmp141_;
				const gchar* _tmp142_;
				const gchar* _tmp143_;
				SynapseQuery _tmp144_;
				const gchar* _tmp145_;
				_tmp141_ = dfm;
				_tmp142_ = synapse_desktop_file_plugin_desktop_file_match_get_exec (_tmp141_);
				_tmp143_ = _tmp142_;
				_tmp144_ = *q;
				_tmp145_ = _tmp144_.query_string;
				if (g_str_has_prefix (_tmp143_, _tmp145_)) {
					SynapseMatchScore _tmp146_ = 0;
					SynapseDesktopFilePluginDesktopFileMatch* _tmp147_;
					const gchar* _tmp148_;
					const gchar* _tmp149_;
					SynapseQuery _tmp150_;
					const gchar* _tmp151_;
					SynapseDesktopFilePluginDesktopFileMatch* _tmp152_;
					SynapseDesktopFilePluginDesktopFileMatch* _tmp153_;
					_tmp147_ = dfm;
					_tmp148_ = synapse_desktop_file_plugin_desktop_file_match_get_exec (_tmp147_);
					_tmp149_ = _tmp148_;
					_tmp150_ = *q;
					_tmp151_ = _tmp150_.query_string;
					if (g_strcmp0 (_tmp149_, _tmp151_) == 0) {
						_tmp146_ = SYNAPSE_MATCH_SCORE_VERY_GOOD;
					} else {
						_tmp146_ = SYNAPSE_MATCH_SCORE_AVERAGE - SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
					}
					_tmp152_ = dfm;
					_tmp153_ = dfm;
					synapse_result_set_add (results, (SynapseMatch*) _tmp152_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp153_, (gint) _tmp146_));
				}
			}
			_g_match_info_unref0 (info);
			_g_object_unref0 (desktop_app_info);
			_g_free0 (id);
			_g_object_unref0 (dfm);
		}
	}
	_g_object_unref0 (matchers);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
synapse_desktop_file_plugin_real_handles_query (SynapseItemProvider* base,
                                                SynapseQuery* q)
{
	SynapseDesktopFilePlugin * self;
	SynapseQuery _tmp0_;
	SynapseQuery _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	self = (SynapseDesktopFilePlugin*) base;
	g_return_val_if_fail (q != NULL, FALSE);
	_tmp0_ = *q;
	if (!((_tmp0_.query_type & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = *q;
	_tmp2_ = _tmp1_.query_string;
	_tmp3_ = string_strip (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static void
synapse_desktop_file_plugin_real_search_data_free (gpointer _data)
{
	SynapseDesktopFilePluginSearchData* _data_;
	_data_ = _data;
	synapse_query_destroy (&_data_->q);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseDesktopFilePluginSearchData, _data_);
}

static void
synapse_desktop_file_plugin_real_search (SynapseItemProvider* base,
                                         SynapseQuery* q,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	SynapseDesktopFilePlugin * self;
	SynapseDesktopFilePluginSearchData* _data_;
	SynapseDesktopFilePlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
	g_return_if_fail (q != NULL);
	self = (SynapseDesktopFilePlugin*) base;
	_data_ = g_slice_new0 (SynapseDesktopFilePluginSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_plugin_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = *q;
	_tmp2_ = _tmp1_;
	synapse_query_copy (&_tmp2_, &_tmp3_);
	synapse_query_destroy (&_data_->q);
	_data_->q = _tmp3_;
	synapse_desktop_file_plugin_real_search_co (_data_);
}

static SynapseResultSet*
synapse_desktop_file_plugin_search_finish (SynapseItemProvider* base,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	SynapseResultSet* result;
	SynapseDesktopFilePluginSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		SynapseDesktopFilePlugin* self;
		self = _data11_->self;
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
___lambda26_ (Block11Data* _data11_)
{
	SynapseDesktopFilePlugin* self;
	self = _data11_->self;
	synapse_desktop_file_plugin_real_search_co (_data11_->_async_data_);
}

static void
____lambda26__synapse_desktop_file_plugin_load_complete (SynapseDesktopFilePlugin* _sender,
                                                         gpointer self)
{
	___lambda26_ (self);
}

static gboolean
_synapse_desktop_file_plugin_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_desktop_file_plugin_real_search_co (self);
	return result;
}

static gboolean
synapse_desktop_file_plugin_real_search_co (SynapseDesktopFilePluginSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data11_ = g_slice_new0 (Block11Data);
	_data_->_data11_->_ref_count_ = 1;
	_data_->_data11_->self = g_object_ref (_data_->self);
	_data_->_data11_->_async_data_ = _data_;
	if (_data_->self->priv->loading_in_progress) {
		_data_->_tmp0_ = g_signal_connect_data (_data_->self, "load-complete", (GCallback) ____lambda26__synapse_desktop_file_plugin_load_complete, block11_data_ref (_data_->_data11_), (GClosureNotify) block11_data_unref, 0);
		_data_->signal_id = _data_->_tmp0_;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		g_signal_handler_disconnect (_data_->self, _data_->signal_id);
	} else {
		g_idle_add_full (G_PRIORITY_HIGH_IDLE, _synapse_desktop_file_plugin_real_search_co_gsource_func, _data_, NULL);
		_data_->_state_ = 2;
		return FALSE;
		_state_2:
		;
	}
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block11_data_unref (_data_->_data11_);
			_data_->_data11_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block11_data_unref (_data_->_data11_);
			_data_->_data11_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp1_ = synapse_result_set_new ();
	_data_->_result_ = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->q;
	_data_->_tmp3_ = _data_->_tmp2_.query_string;
	_data_->_tmp4_ = strlen (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	if (_data_->_tmp5_ == 1) {
		_data_->flags = (SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL) | SYNAPSE_MATCHER_FLAGS_NO_FUZZY;
		_data_->_tmp6_ = _data_->q;
		_data_->_tmp7_ = _data_->_result_;
		synapse_desktop_file_plugin_full_search (_data_->self, &_data_->_tmp6_, _data_->_tmp7_, _data_->flags);
	} else {
		_data_->_tmp8_ = _data_->q;
		_data_->_tmp9_ = _data_->_result_;
		synapse_desktop_file_plugin_full_search (_data_->self, &_data_->_tmp8_, _data_->_tmp9_, 0);
	}
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->_result_);
			block11_data_unref (_data_->_data11_);
			_data_->_data11_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->_result_);
			block11_data_unref (_data_->_data11_);
			_data_->_data11_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->_result_;
	block11_data_unref (_data_->_data11_);
	_data_->_data11_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SynapseDesktopFilePlugin*
synapse_desktop_file_plugin_construct (GType object_type)
{
	SynapseDesktopFilePlugin * self = NULL;
	self = (SynapseDesktopFilePlugin*) g_object_new (object_type, NULL);
	return self;
}

SynapseDesktopFilePlugin*
synapse_desktop_file_plugin_new (void)
{
	return synapse_desktop_file_plugin_construct (SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN);
}

static gboolean
synapse_desktop_file_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseDesktopFilePlugin* self;
	self = (SynapseDesktopFilePlugin*) base;
	result = self->priv->_enabled;
	return result;
}

static void
synapse_desktop_file_plugin_real_set_enabled (SynapseActivatable* base,
                                              gboolean value)
{
	SynapseDesktopFilePlugin* self;
	gboolean old_value;
	self = (SynapseDesktopFilePlugin*) base;
	old_value = synapse_desktop_file_plugin_real_get_enabled (base);
	if (old_value != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY]);
	}
}

static inline gpointer
synapse_desktop_file_plugin_action_match_get_instance_private (SynapseDesktopFilePluginActionMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePluginActionMatch_private_offset);
}

SynapseDesktopFilePluginActionMatch*
synapse_desktop_file_plugin_action_match_construct (GType object_type,
                                                    const gchar* desktop_id,
                                                    const gchar* action_name)
{
	SynapseDesktopFilePluginActionMatch * self = NULL;
	GDesktopAppInfo* desktop_app_info = NULL;
	GDesktopAppInfo* _tmp0_;
	gchar* textdomain = NULL;
	GDesktopAppInfo* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GDesktopAppInfo* _tmp12_;
	GIcon* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GDesktopAppInfo* _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (desktop_id != NULL, NULL);
	g_return_val_if_fail (action_name != NULL, NULL);
	self = (SynapseDesktopFilePluginActionMatch*) synapse_match_construct (object_type);
	_tmp0_ = g_desktop_app_info_new (desktop_id);
	desktop_app_info = _tmp0_;
	textdomain = NULL;
	{
		const gchar** domain_key_collection = NULL;
		gint domain_key_collection_length1 = 0;
		gint _domain_key_collection_size_ = 0;
		gint domain_key_it = 0;
		domain_key_collection = SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_SUPPORTED_GETTEXT_DOMAINS_KEYS;
		domain_key_collection_length1 = G_N_ELEMENTS (SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_SUPPORTED_GETTEXT_DOMAINS_KEYS);
		for (domain_key_it = 0; domain_key_it < domain_key_collection_length1; domain_key_it = domain_key_it + 1) {
			const gchar* domain_key = NULL;
			domain_key = domain_key_collection[domain_key_it];
			{
				GDesktopAppInfo* _tmp1_;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp1_ = desktop_app_info;
				_tmp2_ = domain_key;
				_tmp3_ = g_desktop_app_info_get_string (_tmp1_, _tmp2_);
				_g_free0 (textdomain);
				textdomain = _tmp3_;
				_tmp4_ = textdomain;
				if (_tmp4_ != NULL) {
					break;
				}
			}
		}
	}
	_tmp5_ = desktop_app_info;
	_tmp6_ = g_desktop_app_info_get_action_name (_tmp5_, action_name);
	_tmp7_ = _tmp6_;
	synapse_match_set_title ((SynapseMatch*) self, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = textdomain;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp9_ = textdomain;
		_tmp10_ = synapse_match_get_title ((SynapseMatch*) self);
		_tmp11_ = _tmp10_;
		synapse_match_set_title ((SynapseMatch*) self, g_dgettext (_tmp9_, _tmp11_));
	}
	_tmp12_ = desktop_app_info;
	_tmp13_ = g_app_info_get_icon ((GAppInfo*) _tmp12_);
	_tmp14_ = g_icon_to_string (_tmp13_);
	_tmp15_ = _tmp14_;
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp15_);
	_g_free0 (_tmp15_);
	synapse_match_set_description ((SynapseMatch*) self, "");
	_tmp16_ = desktop_app_info;
	synapse_desktop_file_plugin_action_match_set_app_info (self, (GAppInfo*) _tmp16_);
	_tmp17_ = g_strdup (action_name);
	_g_free0 (self->priv->action_name);
	self->priv->action_name = _tmp17_;
	_g_free0 (textdomain);
	_g_object_unref0 (desktop_app_info);
	return self;
}

SynapseDesktopFilePluginActionMatch*
synapse_desktop_file_plugin_action_match_new (const gchar* desktop_id,
                                              const gchar* action_name)
{
	return synapse_desktop_file_plugin_action_match_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, desktop_id, action_name);
}

static void
synapse_desktop_file_plugin_action_match_real_execute (SynapseMatch* base,
                                                       SynapseMatch* match)
{
	SynapseDesktopFilePluginActionMatch * self;
	GAppInfo* _tmp0_;
	const gchar* _tmp1_;
	GAppLaunchContext* _tmp2_;
	GAppLaunchContext* _tmp3_;
	self = (SynapseDesktopFilePluginActionMatch*) base;
	_tmp0_ = self->priv->_app_info;
	_tmp1_ = self->priv->action_name;
	_tmp2_ = g_app_launch_context_new ();
	_tmp3_ = _tmp2_;
	g_desktop_app_info_launch_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_DESKTOP_APP_INFO, GDesktopAppInfo), _tmp1_, _tmp3_);
	_g_object_unref0 (_tmp3_);
}

GAppInfo*
synapse_desktop_file_plugin_action_match_get_app_info (SynapseDesktopFilePluginActionMatch* self)
{
	GAppInfo* result;
	GAppInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	result = _tmp0_;
	return result;
}

void
synapse_desktop_file_plugin_action_match_set_app_info (SynapseDesktopFilePluginActionMatch* self,
                                                       GAppInfo* value)
{
	GAppInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_plugin_action_match_get_app_info (self);
	if (old_value != value) {
		GAppInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app_info);
		self->priv->_app_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY]);
	}
}

gboolean
synapse_desktop_file_plugin_action_match_get_needs_terminal (SynapseDesktopFilePluginActionMatch* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_needs_terminal;
	return result;
}

void
synapse_desktop_file_plugin_action_match_set_needs_terminal (SynapseDesktopFilePluginActionMatch* self,
                                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_plugin_action_match_get_needs_terminal (self);
	if (old_value != value) {
		self->priv->_needs_terminal = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY]);
	}
}

static void
synapse_desktop_file_plugin_action_match_class_init (SynapseDesktopFilePluginActionMatchClass * klass,
                                                     gpointer klass_data)
{
	synapse_desktop_file_plugin_action_match_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePluginActionMatch_private_offset);
	((SynapseMatchClass *) klass)->execute = (void (*) (SynapseMatch*, SynapseMatch*)) synapse_desktop_file_plugin_action_match_real_execute;
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_action_match_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_action_match_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_action_match_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", g_app_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY] = g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
synapse_desktop_file_plugin_action_match_instance_init (SynapseDesktopFilePluginActionMatch * self,
                                                        gpointer klass)
{
	self->priv = synapse_desktop_file_plugin_action_match_get_instance_private (self);
	self->priv->_app_info = NULL;
	self->priv->_needs_terminal = FALSE;
}

static void
synapse_desktop_file_plugin_action_match_finalize (GObject * obj)
{
	SynapseDesktopFilePluginActionMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, SynapseDesktopFilePluginActionMatch);
	_g_object_unref0 (self->priv->_app_info);
	_g_free0 (self->priv->action_name);
	G_OBJECT_CLASS (synapse_desktop_file_plugin_action_match_parent_class)->finalize (obj);
}

GType
synapse_desktop_file_plugin_action_match_get_type (void)
{
	return synapse_desktop_file_plugin_action_match_type_id;
}

GType
synapse_desktop_file_plugin_action_match_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginActionMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_action_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginActionMatch), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_action_match_instance_init, NULL };
	synapse_desktop_file_plugin_action_match_type_id = g_type_module_register_type (module, SYNAPSE_TYPE_MATCH, "SynapseDesktopFilePluginActionMatch", &g_define_type_info, 0);
	SynapseDesktopFilePluginActionMatch_private_offset = sizeof (SynapseDesktopFilePluginActionMatchPrivate);
	return synapse_desktop_file_plugin_action_match_type_id;
}

static void
_vala_synapse_desktop_file_plugin_action_match_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec)
{
	SynapseDesktopFilePluginActionMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, SynapseDesktopFilePluginActionMatch);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY:
		g_value_set_object (value, synapse_desktop_file_plugin_action_match_get_app_info (self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY:
		g_value_set_boolean (value, synapse_desktop_file_plugin_action_match_get_needs_terminal (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_desktop_file_plugin_action_match_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec)
{
	SynapseDesktopFilePluginActionMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, SynapseDesktopFilePluginActionMatch);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY:
		synapse_desktop_file_plugin_action_match_set_app_info (self, g_value_get_object (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY:
		synapse_desktop_file_plugin_action_match_set_needs_terminal (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
synapse_desktop_file_plugin_desktop_file_match_get_instance_private (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePluginDesktopFileMatch_private_offset);
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_title_folded (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->title_folded;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = synapse_match_get_title ((SynapseMatch*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) -1);
		_g_free0 (self->priv->title_folded);
		self->priv->title_folded = _tmp3_;
	}
	_tmp4_ = self->priv->title_folded;
	result = _tmp4_;
	return result;
}

static SynapseDesktopFilePluginDesktopFileMatch*
synapse_desktop_file_plugin_desktop_file_match_construct_for_info (GType object_type,
                                                                   SynapseDesktopFileInfo* info)
{
	SynapseDesktopFilePluginDesktopFileMatch * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = synapse_desktop_file_info_get_filename (info);
	_tmp1_ = _tmp0_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) g_object_new (object_type, "filename", _tmp1_, "match-type", SYNAPSE_MATCH_TYPE_APPLICATION, NULL);
	synapse_desktop_file_plugin_desktop_file_match_init_from_info (self, info);
	return self;
}

static SynapseDesktopFilePluginDesktopFileMatch*
synapse_desktop_file_plugin_desktop_file_match_new_for_info (SynapseDesktopFileInfo* info)
{
	return synapse_desktop_file_plugin_desktop_file_match_construct_for_info (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, info);
}

static void
synapse_desktop_file_plugin_desktop_file_match_init_from_info (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                               SynapseDesktopFileInfo* info)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GDesktopAppInfo* _tmp25_;
	GDesktopAppInfo* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = synapse_desktop_file_info_get_name (info);
	_tmp1_ = _tmp0_;
	synapse_match_set_title ((SynapseMatch*) self, _tmp1_);
	_tmp2_ = synapse_desktop_file_info_get_comment (info);
	_tmp3_ = _tmp2_;
	synapse_match_set_description ((SynapseMatch*) self, _tmp3_);
	_tmp4_ = synapse_desktop_file_info_get_icon_name (info);
	_tmp5_ = _tmp4_;
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp5_);
	_tmp6_ = synapse_desktop_file_info_get_exec (info);
	_tmp7_ = _tmp6_;
	synapse_desktop_file_plugin_desktop_file_match_set_exec (self, _tmp7_);
	_tmp8_ = synapse_desktop_file_info_get_needs_terminal (info);
	_tmp9_ = _tmp8_;
	synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, _tmp9_);
	_tmp10_ = synapse_desktop_file_info_get_name_folded (info);
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (self->priv->title_folded);
	self->priv->title_folded = _tmp11_;
	_tmp12_ = self->priv->title_folded;
	_tmp13_ = synapse_utils_remove_accents (_tmp12_);
	_tmp14_ = _tmp13_;
	synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (self, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = synapse_desktop_file_info_get_desktop_id (info);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat ("application://", _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (self, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = synapse_desktop_file_info_get_generic_name (info);
	_tmp20_ = _tmp19_;
	synapse_desktop_file_plugin_desktop_file_match_set_generic_name (self, _tmp20_);
	_tmp21_ = synapse_desktop_file_info_get_gettext_domain (info);
	_tmp22_ = _tmp21_;
	synapse_desktop_file_plugin_desktop_file_match_set_gettext_domain (self, _tmp22_);
	_tmp23_ = synapse_desktop_file_info_get_desktop_id (info);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_desktop_app_info_new (_tmp24_);
	_tmp26_ = _tmp25_;
	synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, (GAppInfo*) _tmp26_);
	_g_object_unref0 (_tmp26_);
}

static SynapseDesktopFilePluginDesktopFileMatch*
synapse_desktop_file_plugin_desktop_file_match_construct (GType object_type)
{
	SynapseDesktopFilePluginDesktopFileMatch * self = NULL;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) synapse_match_construct (object_type);
	return self;
}

static SynapseDesktopFilePluginDesktopFileMatch*
synapse_desktop_file_plugin_desktop_file_match_new (void)
{
	return synapse_desktop_file_plugin_desktop_file_match_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH);
}

static GAppInfo*
synapse_desktop_file_plugin_desktop_file_match_real_get_app_info (SynapseApplicationMatch* base)
{
	GAppInfo* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	GAppInfo* _tmp0_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = self->priv->_app_info;
	result = _tmp0_;
	return result;
}

static void
synapse_desktop_file_plugin_desktop_file_match_real_set_app_info (SynapseApplicationMatch* base,
                                                                  GAppInfo* value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	GAppInfo* old_value;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	old_value = synapse_desktop_file_plugin_desktop_file_match_real_get_app_info (base);
	if (old_value != value) {
		GAppInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app_info);
		self->priv->_app_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY]);
	}
}

static gboolean
synapse_desktop_file_plugin_desktop_file_match_real_get_needs_terminal (SynapseApplicationMatch* base)
{
	gboolean result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	result = self->priv->_needs_terminal;
	return result;
}

static void
synapse_desktop_file_plugin_desktop_file_match_real_set_needs_terminal (SynapseApplicationMatch* base,
                                                                        gboolean value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	gboolean old_value;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	old_value = synapse_desktop_file_plugin_desktop_file_match_real_get_needs_terminal (base);
	if (old_value != value) {
		self->priv->_needs_terminal = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY]);
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_real_get_filename (SynapseApplicationMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	const gchar* _tmp0_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}

static void
synapse_desktop_file_plugin_desktop_file_match_real_set_filename (SynapseApplicationMatch* base,
                                                                  const gchar* value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	gchar* old_value;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	old_value = synapse_desktop_file_plugin_desktop_file_match_real_get_filename (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY]);
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_generic_name (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_generic_name;
	result = _tmp0_;
	return result;
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_generic_name (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_generic_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_generic_name);
		self->priv->_generic_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY]);
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_gettext_domain (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gettext_domain;
	result = _tmp0_;
	return result;
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_gettext_domain (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_gettext_domain (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_gettext_domain);
		self->priv->_gettext_domain = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GETTEXT_DOMAIN_PROPERTY]);
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title_unaccented;
	result = _tmp0_;
	return result;
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title_unaccented);
		self->priv->_title_unaccented = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY]);
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_id;
	result = _tmp0_;
	return result;
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_id);
		self->priv->_desktop_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY]);
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_exec (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_exec;
	result = _tmp0_;
	return result;
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_exec (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_exec (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_exec);
		self->priv->_exec = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY]);
	}
}

static void
synapse_desktop_file_plugin_desktop_file_match_class_init (SynapseDesktopFilePluginDesktopFileMatchClass * klass,
                                                           gpointer klass_data)
{
	synapse_desktop_file_plugin_desktop_file_match_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePluginDesktopFileMatch_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_desktop_file_match_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_desktop_file_match_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_desktop_file_match_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", g_app_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY] = g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY] = g_param_spec_string ("generic-name", "generic-name", "generic-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GETTEXT_DOMAIN_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GETTEXT_DOMAIN_PROPERTY] = g_param_spec_string ("gettext-domain", "gettext-domain", "gettext-domain", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY] = g_param_spec_string ("title-unaccented", "title-unaccented", "title-unaccented", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY] = g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
synapse_desktop_file_plugin_desktop_file_match_synapse_application_match_interface_init (SynapseApplicationMatchIface * iface,
                                                                                         gpointer iface_data)
{
	synapse_desktop_file_plugin_desktop_file_match_synapse_application_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_app_info = synapse_desktop_file_plugin_desktop_file_match_real_get_app_info;
	iface->set_app_info = synapse_desktop_file_plugin_desktop_file_match_real_set_app_info;
	iface->get_needs_terminal = synapse_desktop_file_plugin_desktop_file_match_real_get_needs_terminal;
	iface->set_needs_terminal = synapse_desktop_file_plugin_desktop_file_match_real_set_needs_terminal;
	iface->get_filename = synapse_desktop_file_plugin_desktop_file_match_real_get_filename;
	iface->set_filename = synapse_desktop_file_plugin_desktop_file_match_real_set_filename;
}

static void
synapse_desktop_file_plugin_desktop_file_match_instance_init (SynapseDesktopFilePluginDesktopFileMatch * self,
                                                              gpointer klass)
{
	gchar* _tmp0_;
	self->priv = synapse_desktop_file_plugin_desktop_file_match_get_instance_private (self);
	self->priv->_app_info = NULL;
	self->priv->_needs_terminal = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->_generic_name = _tmp0_;
	self->priv->_gettext_domain = NULL;
	self->priv->title_folded = NULL;
	self->priv->_title_unaccented = NULL;
	self->priv->_desktop_id = NULL;
}

static void
synapse_desktop_file_plugin_desktop_file_match_finalize (GObject * obj)
{
	SynapseDesktopFilePluginDesktopFileMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
	_g_object_unref0 (self->priv->_app_info);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_generic_name);
	_g_free0 (self->priv->_gettext_domain);
	_g_free0 (self->priv->title_folded);
	_g_free0 (self->priv->_title_unaccented);
	_g_free0 (self->priv->_desktop_id);
	_g_free0 (self->priv->_exec);
	G_OBJECT_CLASS (synapse_desktop_file_plugin_desktop_file_match_parent_class)->finalize (obj);
}

GType
synapse_desktop_file_plugin_desktop_file_match_get_type (void)
{
	return synapse_desktop_file_plugin_desktop_file_match_type_id;
}

GType
synapse_desktop_file_plugin_desktop_file_match_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginDesktopFileMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_desktop_file_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginDesktopFileMatch), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_desktop_file_match_instance_init, NULL };
	static const GInterfaceInfo synapse_application_match_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_desktop_file_match_synapse_application_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	synapse_desktop_file_plugin_desktop_file_match_type_id = g_type_module_register_type (module, SYNAPSE_TYPE_MATCH, "SynapseDesktopFilePluginDesktopFileMatch", &g_define_type_info, 0);
	g_type_module_add_interface (module, synapse_desktop_file_plugin_desktop_file_match_type_id, SYNAPSE_TYPE_APPLICATION_MATCH, &synapse_application_match_info);
	SynapseDesktopFilePluginDesktopFileMatch_private_offset = sizeof (SynapseDesktopFilePluginDesktopFileMatchPrivate);
	return synapse_desktop_file_plugin_desktop_file_match_type_id;
}

static void
_vala_synapse_desktop_file_plugin_desktop_file_match_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec)
{
	SynapseDesktopFilePluginDesktopFileMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY:
		g_value_set_object (value, synapse_application_match_get_app_info ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY:
		g_value_set_boolean (value, synapse_application_match_get_needs_terminal ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY:
		g_value_set_string (value, synapse_application_match_get_filename ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_generic_name (self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GETTEXT_DOMAIN_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_gettext_domain (self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_exec (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_desktop_file_plugin_desktop_file_match_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec)
{
	SynapseDesktopFilePluginDesktopFileMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY:
		synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, g_value_get_object (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY:
		synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY:
		synapse_application_match_set_filename ((SynapseApplicationMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY:
		synapse_desktop_file_plugin_desktop_file_match_set_generic_name (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GETTEXT_DOMAIN_PROPERTY:
		synapse_desktop_file_plugin_desktop_file_match_set_gettext_domain (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY:
		synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY:
		synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY:
		synapse_desktop_file_plugin_desktop_file_match_set_exec (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
synapse_desktop_file_plugin_open_with_action_get_instance_private (SynapseDesktopFilePluginOpenWithAction* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePluginOpenWithAction_private_offset);
}

static SynapseDesktopFilePluginOpenWithAction*
synapse_desktop_file_plugin_open_with_action_construct (GType object_type,
                                                        SynapseDesktopFileInfo* info)
{
	SynapseDesktopFilePluginOpenWithAction * self = NULL;
	g_return_val_if_fail (info != NULL, NULL);
	self = (SynapseDesktopFilePluginOpenWithAction*) g_object_new (object_type, NULL);
	synapse_desktop_file_plugin_open_with_action_init_with_info (self, info);
	return self;
}

static SynapseDesktopFilePluginOpenWithAction*
synapse_desktop_file_plugin_open_with_action_new (SynapseDesktopFileInfo* info)
{
	return synapse_desktop_file_plugin_open_with_action_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, info);
}

static void
synapse_desktop_file_plugin_open_with_action_init_with_info (SynapseDesktopFilePluginOpenWithAction* self,
                                                             SynapseDesktopFileInfo* info)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = synapse_desktop_file_info_get_name (info);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("Open with %s"), _tmp1_);
	_tmp3_ = _tmp2_;
	synapse_match_set_title ((SynapseMatch*) self, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = synapse_desktop_file_info_get_icon_name (info);
	_tmp5_ = _tmp4_;
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp5_);
	_tmp6_ = synapse_desktop_file_info_get_name (info);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (_ ("Opens current selection using %s"), _tmp7_);
	_tmp9_ = _tmp8_;
	synapse_match_set_description ((SynapseMatch*) self, _tmp9_);
	_g_free0 (_tmp9_);
	synapse_desktop_file_plugin_open_with_action_set_desktop_info (self, info);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
synapse_desktop_file_plugin_open_with_action_real_execute (SynapseMatch* base,
                                                           SynapseMatch* match)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp0_;
	GFile* f = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	_tmp0_ = _g_object_ref0 (SYNAPSE_IS_URI_MATCH (match) ? ((SynapseUriMatch*) match) : NULL);
	uri_match = _tmp0_;
	g_return_if_fail (uri_match != NULL);
	_tmp1_ = synapse_uri_match_get_uri (uri_match);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	f = _tmp3_;
	{
		GDesktopAppInfo* app_info = NULL;
		SynapseDesktopFileInfo* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GDesktopAppInfo* _tmp7_;
		GList* files = NULL;
		GFile* _tmp8_;
		GdkDisplay* _tmp9_;
		GdkAppLaunchContext* _tmp10_;
		GdkAppLaunchContext* _tmp11_;
		_tmp4_ = self->priv->_desktop_info;
		_tmp5_ = synapse_desktop_file_info_get_filename (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_desktop_app_info_new_from_filename (_tmp6_);
		app_info = _tmp7_;
		files = NULL;
		_tmp8_ = _g_object_ref0 (f);
		files = g_list_prepend (files, _tmp8_);
		_tmp9_ = gdk_display_get_default ();
		_tmp10_ = gdk_display_get_app_launch_context (_tmp9_);
		_tmp11_ = _tmp10_;
		g_app_info_launch ((GAppInfo*) app_info, files, (GAppLaunchContext*) _tmp11_, &_inner_error0_);
		_g_object_unref0 (_tmp11_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
			_g_object_unref0 (app_info);
			goto __catch0_g_error;
		}
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
		_g_object_unref0 (app_info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = err;
		_tmp13_ = _tmp12_->message;
		g_warning ("desktop-file-plugin.vala:339: %s", _tmp13_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (f);
		_g_object_unref0 (uri_match);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (f);
	_g_object_unref0 (uri_match);
}

static SynapseDesktopFileInfo*
synapse_desktop_file_plugin_open_with_action_get_desktop_info (SynapseDesktopFilePluginOpenWithAction* self)
{
	SynapseDesktopFileInfo* result;
	SynapseDesktopFileInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_info;
	result = _tmp0_;
	return result;
}

static void
synapse_desktop_file_plugin_open_with_action_set_desktop_info (SynapseDesktopFilePluginOpenWithAction* self,
                                                               SynapseDesktopFileInfo* value)
{
	SynapseDesktopFileInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_plugin_open_with_action_get_desktop_info (self);
	if (old_value != value) {
		SynapseDesktopFileInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_desktop_info);
		self->priv->_desktop_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY]);
	}
}

static void
synapse_desktop_file_plugin_open_with_action_class_init (SynapseDesktopFilePluginOpenWithActionClass * klass,
                                                         gpointer klass_data)
{
	synapse_desktop_file_plugin_open_with_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePluginOpenWithAction_private_offset);
	((SynapseMatchClass *) klass)->execute = (void (*) (SynapseMatch*, SynapseMatch*)) synapse_desktop_file_plugin_open_with_action_real_execute;
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_open_with_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_open_with_action_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_open_with_action_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY] = g_param_spec_object ("desktop-info", "desktop-info", "desktop-info", SYNAPSE_TYPE_DESKTOP_FILE_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
synapse_desktop_file_plugin_open_with_action_instance_init (SynapseDesktopFilePluginOpenWithAction * self,
                                                            gpointer klass)
{
	self->priv = synapse_desktop_file_plugin_open_with_action_get_instance_private (self);
}

static void
synapse_desktop_file_plugin_open_with_action_finalize (GObject * obj)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
	_g_object_unref0 (self->priv->_desktop_info);
	G_OBJECT_CLASS (synapse_desktop_file_plugin_open_with_action_parent_class)->finalize (obj);
}

GType
synapse_desktop_file_plugin_open_with_action_get_type (void)
{
	return synapse_desktop_file_plugin_open_with_action_type_id;
}

GType
synapse_desktop_file_plugin_open_with_action_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginOpenWithActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_open_with_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginOpenWithAction), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_open_with_action_instance_init, NULL };
	synapse_desktop_file_plugin_open_with_action_type_id = g_type_module_register_type (module, SYNAPSE_TYPE_MATCH, "SynapseDesktopFilePluginOpenWithAction", &g_define_type_info, 0);
	SynapseDesktopFilePluginOpenWithAction_private_offset = sizeof (SynapseDesktopFilePluginOpenWithActionPrivate);
	return synapse_desktop_file_plugin_open_with_action_type_id;
}

static void
_vala_synapse_desktop_file_plugin_open_with_action_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY:
		g_value_set_object (value, synapse_desktop_file_plugin_open_with_action_get_desktop_info (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_desktop_file_plugin_open_with_action_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY:
		synapse_desktop_file_plugin_open_with_action_set_desktop_info (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_synapse_desktop_file_plugin___lambda27_ (SynapseDesktopFilePlugin* self)
{
	self->priv->loading_in_progress = TRUE;
}

static void
__synapse_desktop_file_plugin___lambda27__synapse_desktop_file_service_reload_started (SynapseDesktopFileService* _sender,
                                                                                       gpointer self)
{
	_synapse_desktop_file_plugin___lambda27_ ((SynapseDesktopFilePlugin*) self);
}

static void
_synapse_desktop_file_plugin___lambda28_ (SynapseDesktopFilePlugin* self)
{
	GeeList* _tmp0_;
	_tmp0_ = self->priv->desktop_files;
	gee_collection_clear ((GeeCollection*) _tmp0_);
	synapse_desktop_file_plugin_load_all_desktop_files (self, NULL, NULL);
}

static void
__synapse_desktop_file_plugin___lambda28__synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender,
                                                                                    gpointer self)
{
	_synapse_desktop_file_plugin___lambda28_ ((SynapseDesktopFilePlugin*) self);
}

static GObject *
synapse_desktop_file_plugin_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFilePlugin * self;
	GeeArrayList* _tmp0_;
	SynapseDesktopFileService* dfs = NULL;
	SynapseDesktopFileService* _tmp1_;
	SynapseDesktopFileService* _tmp2_;
	SynapseDesktopFileService* _tmp3_;
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
	_tmp0_ = gee_array_list_new (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->desktop_files);
	self->priv->desktop_files = (GeeList*) _tmp0_;
	_tmp1_ = synapse_desktop_file_service_get_default ();
	dfs = _tmp1_;
	_tmp2_ = dfs;
	g_signal_connect_object (_tmp2_, "reload-started", (GCallback) __synapse_desktop_file_plugin___lambda27__synapse_desktop_file_service_reload_started, self, 0);
	_tmp3_ = dfs;
	g_signal_connect_object (_tmp3_, "reload-done", (GCallback) __synapse_desktop_file_plugin___lambda28__synapse_desktop_file_service_reload_done, self, 0);
	synapse_desktop_file_plugin_load_all_desktop_files (self, NULL, NULL);
	_g_object_unref0 (dfs);
	return obj;
}

static void
synapse_desktop_file_plugin_class_init (SynapseDesktopFilePluginClass * klass,
                                        gpointer klass_data)
{
	synapse_desktop_file_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePlugin_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY, synapse_desktop_file_plugin_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	synapse_desktop_file_plugin_signals[SYNAPSE_DESKTOP_FILE_PLUGIN_LOAD_COMPLETE_SIGNAL] = g_signal_new ("load-complete", SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	synapse_desktop_file_plugin_register_plugin ();
}

static void
synapse_desktop_file_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                                gpointer iface_data)
{
	synapse_desktop_file_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (SynapseActivatable*)) synapse_desktop_file_plugin_real_activate;
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_desktop_file_plugin_real_deactivate;
	iface->get_enabled = synapse_desktop_file_plugin_real_get_enabled;
	iface->set_enabled = synapse_desktop_file_plugin_real_set_enabled;
}

static void
synapse_desktop_file_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                                  gpointer iface_data)
{
	synapse_desktop_file_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_desktop_file_plugin_real_handles_query;
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_desktop_file_plugin_real_search;
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_desktop_file_plugin_search_finish;
}

static void
synapse_desktop_file_plugin_instance_init (SynapseDesktopFilePlugin * self,
                                           gpointer klass)
{
	self->priv = synapse_desktop_file_plugin_get_instance_private (self);
	self->priv->_enabled = TRUE;
	self->priv->loading_in_progress = FALSE;
}

static void
synapse_desktop_file_plugin_finalize (GObject * obj)
{
	SynapseDesktopFilePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
	_g_object_unref0 (self->priv->desktop_files);
	G_OBJECT_CLASS (synapse_desktop_file_plugin_parent_class)->finalize (obj);
}

GType
synapse_desktop_file_plugin_get_type (void)
{
	return synapse_desktop_file_plugin_type_id;
}

GType
synapse_desktop_file_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePlugin), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	synapse_desktop_file_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "SynapseDesktopFilePlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_module_add_interface (module, synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseDesktopFilePlugin_private_offset = sizeof (SynapseDesktopFilePluginPrivate);
	return synapse_desktop_file_plugin_type_id;
}

static void
_vala_synapse_desktop_file_plugin_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	SynapseDesktopFilePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_desktop_file_plugin_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	SynapseDesktopFilePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

