/*
    SPDX-FileCopyrightText: 2019 Nikolai Kosjar <nikolai.kosjar@qt.io>

    SPDX-License-Identifier: LGPL-2.0-or-later
*/

#ifndef CHECKS_JSON_H
#define CHECKS_JSON_H

const char SUPPORTED_CHECKS_JSON_STR[] = 
R"meta({
    "available_categories": [
        "readability",
        "qt6",
        "containers",
        "qstring",
        "cpp",
        "bug",
        "performance",
        "deprecation",
        "qml"
    ],
    "checks": [
        {
            "name": "qbytearray-conversion-to-c-style",
            "level": -1,
            "visits_stmts": true,
            "can_ignore_includes": true,
            "fixits": [
                {
                    "name": "qbytearray-conversion-to-c-style"
                }
            ]
        },
        {
            "name": "qt-keywords",
            "level": -1,
            "fixits": [
                {
                    "name": "qt-keywords"
                }
            ],
            "preprocessor_callbacks": true
        },
        {
            "name": "qt-keyword-emit",
            "level": -1,
            "fixits": [
                {
                    "name": "qt-keyword-emit"
                }
            ],
            "preprocessor_callbacks": true
        },
        {
            "name": "signal-with-return-value",
            "level": -1,
            "visits_decls": true
        },
        {
            "name": "sanitize-inline-keyword",
            "level": -1,
            "visits_decls": true,
            "can_ignore_includes": true,
            "fixits": [
                {
                    "name": "sanitize-inline-keyword"
                }
            ]
        },
        {
            "name": "heap-allocated-small-trivial-type",
            "level": -1,
            "categories": ["performance"],
            "visits_decls": true
        },
        {
            "name": "ifndef-define-typo",
            "level": -1,
            "categories": ["bug"],
            "preprocessor_callbacks": true
        },
        {
            "name": "isempty-vs-count",
            "class_name": "IsEmptyVSCount",
            "level": -1,
            "categories": ["readability"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "qrequiredresult-candidates",
            "class_name": "QRequiredResultCandidates",
            "level": -1,
            "categories": ["bug"],
            "visits_decls": true
        },
        {
            "name": "qstring-varargs",
            "level": -1,
            "categories": ["bug"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "qt6-qlatin1stringchar-to-u",
            "class_name": "Qt6QLatin1StringCharToU",
            "level": -1,
            "categories": ["qt6", "qstring", "containers"],
            "fixits": [
                {
                    "name": "qt6-qlatin1stringchar-to-u"
                }
            ],
            "visits_stmts": true,
            "can_ignore_includes": true,
            "preprocessor_callbacks": true
        },
        {
            "name": "qt6-qhash-signature",
            "class_name": "Qt6QHashSignature",
            "level": -1,
            "categories": ["qt6", "containers"],
            "fixits": [
                {
                    "name": "qt6-qhash-signature"
                }
            ],
            "visits_decls": true,
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "qt6-header-fixes",
            "class_name": "Qt6HeaderFixes",
            "level": -1,
            "categories": ["qt6"],
            "fixits": [
                {
                    "name": "qt6-header-fixes"
                }
            ],
            "visits_stmts": true,
            "can_ignore_includes": true,
            "preprocessor_callbacks": true
        },
        {
            "name": "qt6-deprecated-api-fixes",
            "class_name": "Qt6DeprecatedAPIFixes",
            "level": -1,
            "categories": ["qt6", "containers"],
            "fixits": [
                {
                    "name": "qt6-deprecated-api-fixes"
                }
            ],
            "visits_decls": true,
            "visits_stmts": true,
            "can_ignore_includes": true,
            "preprocessor_callbacks": true
        },
        {
            "name": "qt6-fwd-fixes",
            "class_name": "Qt6FwdFixes",
            "level": -1,
            "categories": ["qt6"],
            "fixits": [
                {
                    "name": "qt6-fwd-fixes"
                }
            ],
            "visits_decls": true,
            "can_ignore_includes": true,
            "preprocessor_callbacks": true
        },
        {
            "name": "tr-non-literal",
            "level": -1,
            "categories": ["bug"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "raw-environment-function",
            "level": -1,
            "categories": ["bug"],
            "visits_stmts": true
        },
        {
            "name": "container-inside-loop",
            "level": -1,
            "categories": ["containers", "performance"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "qhash-with-char-pointer-key",
            "level": -1,
            "categories": ["cpp", "bug"],
            "visits_decls": true
        },
        {
            "name": "overloaded-signal",
            "level": 0,
            "visits_decls": true,
            "categories": ["readability"]
        },
        {
            "name": "connect-by-name",
            "level": 0,
            "categories": ["bug", "readability"],
            "visits_decls": true
        },
        {
            "name": "connect-non-signal",
            "minimum_qt_version": 50700,
            "level": 0,
            "categories": ["bug"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "qstring-comparison-to-implicit-char",
            "level": 0,
            "categories": ["bug"],
            "visits_stmts": true
        },
        {
            "name": "wrong-qevent-cast",
            "level": 0,
            "categories": ["bug"],
            "visits_stmts": true
        },
        {
            "name": "lambda-in-connect",
            "level": 0,
            "categories": ["bug"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "lambda-unique-connection",
            "level": 0,
            "categories": ["bug"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "qdatetime-utc",
            "class_name": "QDateTimeUtc",
            "level": 0,
            "categories": ["performance"],
            "fixits": [
                {
                    "name": "qdatetime-utc"
                }
            ],
            "visits_stmts": true
        },
        {
            "name": "qgetenv",
            "class_name": "QGetEnv",
            "level": 0,
            "minimum_qt_version": 50500,
            "categories": ["performance"],
            "fixits": [
                {
                    "name": "qgetenv"
                }
            ],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "qstring-insensitive-allocation",
            "level": 0,
            "categories": ["performance", "qstring"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "fully-qualified-moc-types",
            "class_name": "FullyQualifiedMocTypes",
            "level": 0,
            "categories": ["bug", "qml"],
            "visits_decls": true,
            "fixits": [
                {
                    "name": "fully-qualified-moc-types"
                }
            ],
            "preprocessor_callbacks": true
        },
        {
            "name": "qvariant-template-instantiation",
            "level": -1,
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "unused-non-trivial-variable",
            "level": 0,
            "categories": ["readability"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "connect-not-normalized",
            "level": 0,
            "categories": ["performance"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "mutable-container-key",
            "level": 0,
            "categories": ["containers", "bug"],
            "visits_decls": true,
            "can_ignore_includes": true
        },
        {
            "name": "qenums",
            "level": 0,
            "minimum_qt_version": 50500,
            "categories": ["deprecation"],
            "preprocessor_callbacks": true
        },
        {
            "name": "qmap-with-pointer-key",
            "level": 0,
            "categories": ["containers", "performance"],
            "visits_decls": true
        },
        {
            "name": "qstring-ref",
            "class_name": "StringRefCandidates",
            "level": 0,
            "categories": ["performance", "qstring"],
            "fixits": [
                {
                    "name": "missing-qstringref"
                }
            ],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "strict-iterators",
            "level": 0,
            "categories": ["containers", "performance", "bug"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "writing-to-temporary",
            "level": 0,
            "categories": ["bug"],
            "options": [
                {
                    "name": "widen-criteria"
                }
            ],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "container-anti-pattern",
            "level": 0,
            "categories": ["containers", "performance"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "qcolor-from-literal",
            "level": 0,
            "categories": ["performance"],
            "visits_stmts": true,
            "fixits": [
                {
                    "name": "qcolor-from-literal"
                }
            ]
        },
        {
            "name": "qfileinfo-exists",
            "class_name": "QFileInfoExists",
            "level": 0,
            "categories": ["performance"],
            "visits_stmts": true,
            "can_ignore_includes": true,
            "fixits": [
                {
                    "name": "qfileinfo-exists"
                }
            ]
        },
        {
            "name": "qstring-arg",
            "level": 0,
            "categories": ["performance", "qstring"],
            "options": [
                {
                    "name": "fillChar-overloads"
                }
            ],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "empty-qstringliteral",
            "level": 0,
            "categories": ["performance"],
            "visits_stmts": true
        },
        {
            "name": "qt-macros",
            "class_name": "QtMacros",
            "level": 0,
            "categories": ["bug"],
            "preprocessor_callbacks": true
        },
        {
            "name": "temporary-iterator",
            "level": 0,
            "categories": ["containers", "bug"],
            "visits_stmts": true
        },
        {
            "name": "wrong-qglobalstatic",
            "class_name": "WrongQGlobalStatic",
            "level": 0,
            "categories": ["performance"],
            "visits_stmts": true
        },
        {
            "name": "lowercase-qml-type-name",
            "level": 0,
            "categories": ["qml", "bug"],
            "visits_stmts": true
        },
        {
            "name": "no-module-include",
            "level": 0,
            "categories": ["performance"],
            "visits_stmts": true,
            "preprocessor_callbacks": true
        },
        {
            "name": "auto-unexpected-qstringbuilder",
            "class_name": "AutoUnexpectedQStringBuilder",
            "level": 1,
            "categories": ["bug", "qstring"],
            "visits_decls": true,
            "visits_stmts": true,
            "can_ignore_includes": true,
            "fixits": [
                {
                    "name": "auto-unexpected-qstringbuilder"
                }
            ]
        },
        {
            "name": "connect-3arg-lambda",
            "level": 1,
            "categories": ["bug"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "const-signal-or-slot",
            "level": 1,
            "categories": ["readability", "bug"],
            "visits_decls": true,
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "qproperty-type-mismatch",
            "level": -1,
            "categories": ["bug"],
            "visits_decls": true,
            "preprocessor_callbacks": true,
            "visit_all_typedefs": true
        },
        {
            "name": "detaching-temporary",
            "level": 1,
            "categories": ["containers", "performance"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "foreach",
            "level": 1,
            "categories": ["containers", "performance"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "incorrect-emit",
            "level": 1,
            "categories": ["readability"],
            "visits_stmts": true,
            "can_ignore_includes": true,
            "preprocessor_callbacks": true
        },
        {
            "name": "install-event-filter",
            "level": 1,
            "categories": ["bug"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "non-pod-global-static",
            "level": 1,
            "categories": ["performance"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "post-event",
            "level": 1,
            "categories": ["bug"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "qdeleteall",
            "class_name": "QDeleteAll",
            "level": 1,
            "categories": ["containers", "performance"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "qlatin1string-non-ascii",
            "level": 1,
            "categories": ["bug", "qstring"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "qproperty-without-notify",
            "level": 1,
            "categories": ["bug"],
            "visits_stmts": true,
            "preprocessor_callbacks": true,
            "can_ignore_includes": true
        },
        {
            "name": "qstring-left",
            "level": 1,
            "categories": ["bug", "performance", "qstring"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "range-loop-detach",
            "level": 1,
            "categories": ["containers", "performance"],
            "visits_stmts": true,
            "can_ignore_includes": true,
            "fixits": [
                {
                    "name": "range-loop-add-qasconst"
                }
            ]
        },
        {
            "name": "range-loop-reference",
            "level": 1,
            "categories": ["containers", "performance"],
            "visits_stmts": true,
            "can_ignore_includes": true,
            "fixits": [
                {
                    "name": "range-loop-add-ref"
                }
            ]
        },
        {
            "name": "returning-data-from-temporary",
            "level": 1,
            "categories": ["bug"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "rule-of-two-soft",
            "level": 1,
            "categories": ["cpp", "bug"],
            "visits_stmts": true
        },
        {
            "name": "child-event-qobject-cast",
            "level": 1,
            "categories": ["bug"],
            "visits_decls": true,
            "can_ignore_includes": true,
            "preprocessor_callbacks": true
        },
        {
            "name": "virtual-signal",
            "level": 1,
            "categories": ["bug", "readability"],
            "visits_decls": true
        },
        {
            "name": "overridden-signal",
            "level": 1,
            "categories": ["bug", "readability"],
            "visits_decls": true,
            "can_ignore_includes": true
        },
        {
            "name": "qhash-namespace",
            "level": 1,
            "categories": ["bug"],
            "visits_decls": true
        },
        {
            "name": "skipped-base-method",
            "level": 1,
            "categories": ["bug", "cpp"],
            "visits_stmts": true
        },
        {
            "name": "unneeded-cast",
            "level": -1,
            "categories": ["cpp", "readability"],
            "options": [
                {
                    "name": "prefer-dynamic-cast-over-qobject"
                }
            ],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "ctor-missing-parent-argument",
            "level": 2,
            "categories": ["bug"],
            "visits_decls": true
        },
        {
            "name": "base-class-event",
            "level": 2,
            "categories": ["bug"],
            "visits_decls": true
        },
        {
            "name": "copyable-polymorphic",
            "level": 2,
            "categories": ["cpp", "bug"],
            "visits_decls": true
        },
        {
            "name": "function-args-by-ref",
            "level": 2,
            "categories": ["cpp", "performance"],
            "options": [
                {
                    "name": "warn-for-overridden-methods"
                }
            ],
            "fixits": [
                {
                    "name": "function-args-by-ref"
                }
            ],
            "visits_decls": true,
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "function-args-by-value",
            "level": 2,
            "categories": ["cpp", "performance"],
            "options": [
                {
                    "name": "warn-for-overridden-methods"
                }
            ],
            "can_ignore_includes": true,
            "visits_decls": true,
            "visits_stmts": true
        },
        {
            "name": "global-const-char-pointer",
            "level": 2,
            "categories": ["cpp", "performance"],
            "visits_decls": true
        },
        {
            "name": "implicit-casts",
            "level": 2,
            "categories": ["cpp", "bug"],
            "options": [
                {
                    "name": "bool-to-int"
                }
            ],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "missing-qobject-macro",
            "level": 2,
            "categories": ["bug"],
            "visits_decls": true,
            "fixits": [
                {
                    "name": "missing-qobject-macro"
                }
            ],
            "preprocessor_callbacks": true
        },
        {
            "name": "missing-typeinfo",
            "class_name": "MissingTypeInfo",
            "level": 2,
            "categories": ["containers", "performance"],
            "visits_decls": true
        },
        {
            "name": "old-style-connect",
            "level": 2,
            "minimum_qt_version": 50500,
            "categories": ["performance"],
            "fixits": [
                {
                    "name": "old-style-connect"
                }
            ],
            "visits_stmts": true,
            "preprocessor_callbacks": true,
            "can_ignore_includes": true
        },
        {
            "name": "qstring-allocations",
            "level": 2,
            "minimum_qt_version": 50000,
            "categories": ["performance", "qstring"],
            "fixits": [
                {
                    "name": "qlatin1string-allocations"
                },
                {
                    "name": "fromLatin1_fromUtf8-allocations"
                },
                {
                    "name": "fromCharPtrAllocations"
                }
            ],
            "options": [
                {
                    "name": "no-msvc-compat"
                }
            ],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "returning-void-expression",
            "level": 2,
            "categories": ["readability", "cpp"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "rule-of-three",
            "level": 2,
            "categories": ["cpp", "bug"],
            "visits_decls": true
        },
        {
            "name": "virtual-call-ctor",
            "level": 2,
            "categories": ["cpp", "bug"],
            "visits_decls": true
        },
        {
            "name": "static-pmf",
            "level": 2,
            "categories": ["bug"],
            "visits_decls": true
        },
        {
            "name": "assert-with-side-effects",
            "level": -1,
            "categories": ["bug"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "detaching-member",
            "level": -1,
            "categories": ["containers", "performance"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "thread-with-slots",
            "level": -1,
            "categories": ["bug"],
            "visits_decls": true,
            "visits_stmts": true
        },
        {
            "name": "reserve-candidates",
            "level": -1,
            "categories": ["containers"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "jni-signatures",
            "level": -1,
            "categories": ["bug"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "use-chrono-in-qtimer",
            "class_name": "UseChronoInQTimer",
            "level": -1,
            "categories": ["readability"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "use-arrow-operator-instead-of-data",
            "class_name": "UseArrowOperatorInsteadOfData",
            "level": -1,
            "categories": ["readability"],
            "visits_stmts": true
        },
        {
            "name": "use-static-qregularexpression",
            "class_name": "UseStaticQRegularExpression",
            "level": 0,
            "categories": ["performance"],
            "visits_stmts": true
        },
        {
            "name": "unexpected-flag-enumerator-value",
            "class_name": "UnexpectedFlagEnumeratorValue",
            "level": -1,
            "categories": ["bug"],
            "visits_decls": true
        },
        {
            "name": "unused-result-check",
            "level": -1,
            "categories": ["bug"],
            "visits_stmts": true,
            "can_ignore_includes": true
        },
        {
            "name": "used-qunused-variable",
            "class_name": "UsedQUnusedVariable",
            "level": -1,
            "categories": ["readability"],
            "visits_decls": true
        },
        {
            "name": "readlock-detaching",
            "level": 1,
            "categories": ["bug"]
        }
    ]
}
)meta"
;

#endif // CHECKS_JSON_H

