/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	acmev1 "github.com/cert-manager/cert-manager/pkg/apis/acme/v1"
)

// ChallengeStatusApplyConfiguration represents a declarative configuration of the ChallengeStatus type for use
// with apply.
type ChallengeStatusApplyConfiguration struct {
	Processing *bool         `json:"processing,omitempty"`
	Presented  *bool         `json:"presented,omitempty"`
	Reason     *string       `json:"reason,omitempty"`
	State      *acmev1.State `json:"state,omitempty"`
}

// ChallengeStatusApplyConfiguration constructs a declarative configuration of the ChallengeStatus type for use with
// apply.
func ChallengeStatus() *ChallengeStatusApplyConfiguration {
	return &ChallengeStatusApplyConfiguration{}
}

// WithProcessing sets the Processing field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Processing field is set to the value of the last call.
func (b *ChallengeStatusApplyConfiguration) WithProcessing(value bool) *ChallengeStatusApplyConfiguration {
	b.Processing = &value
	return b
}

// WithPresented sets the Presented field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Presented field is set to the value of the last call.
func (b *ChallengeStatusApplyConfiguration) WithPresented(value bool) *ChallengeStatusApplyConfiguration {
	b.Presented = &value
	return b
}

// WithReason sets the Reason field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Reason field is set to the value of the last call.
func (b *ChallengeStatusApplyConfiguration) WithReason(value string) *ChallengeStatusApplyConfiguration {
	b.Reason = &value
	return b
}

// WithState sets the State field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the State field is set to the value of the last call.
func (b *ChallengeStatusApplyConfiguration) WithState(value acmev1.State) *ChallengeStatusApplyConfiguration {
	b.State = &value
	return b
}
