/*      Compiler: ECL 24.5.10                                         */
/*      Source: /build/ecl/src/ecl-24.5.10/src/cmp/cmppolicy.lsp      */
#include <ecl/ecl-cmp.h>
#include "cmp/cmppolicy.eclh"
/*      function definition for STANDARD-OPTIMIZATION-QUALITY-P       */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3069standard_optimization_quality_p(cl_object v1name)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  {
   cl_object v2;
   cl_object v3;
   cl_object v4;
   v2 = (ECL_SYM("EQ",335)->symbol.gfdef);
   v3 = v1name;
   v4 = VV[1];
   value0 = si_memq(v3,v4);
   cl_env_copy->nvalues = 1;
   return value0;
  }
 }
}
/*      function definition for TAKE-OPTIMIZATION-BIT                 */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3070take_optimization_bit(cl_object v1name)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ecl_gethash_safe(v1name,ecl_symbol_value(VV[6]),ECL_NIL);
  if ((value0)!=ECL_NIL) { goto L2; }
  cl_set(VV[3],ecl_plus(ecl_symbol_value(VV[3]),ecl_make_fixnum(1)));
  T0 = ecl_symbol_value(VV[3]);
  value0 = si_hash_set(v1name, ecl_symbol_value(VV[6]), T0);
  return value0;
L2:;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      function definition for OPTIMIZATION-QUALITY-SWITCHES         */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3071optimization_quality_switches(cl_object v1type, cl_object v2index)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  T0 = cl_gethash(2, v1type, ecl_symbol_value(VV[4]));
  value0 = ecl_nth(ecl_to_size(v2index),T0);
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      function definition for COMPUTE-POLICY                        */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3073compute_policy(cl_object v1arguments, cl_object v2old_bits)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  {
   cl_object v3on;
   cl_object v4off;
   v3on = ecl_make_fixnum(0);
   v4off = ecl_make_fixnum(0);
   {
    cl_object v5;
    v5 = v1arguments;
    goto L7;
L6:;
    {
     cl_object v6x;
     v6x = ecl_car(v5);
     {
      cl_object v7flags;
      v7flags = LC3072get_flags(v6x);
      if (Null(v7flags)) { goto L13; }
      T0 = ecl_car(v7flags);
      v3on = ecl_boole(ECL_BOOLIOR,(v3on),(T0));
      T0 = ecl_cdr(v7flags);
      v4off = ecl_boole(ECL_BOOLIOR,(v4off),(T0));
      goto L11;
L13:;
      ecl_function_dispatch(cl_env_copy,VV[47])(2, VV[10], v6x) /*  CMPWARN */;
     }
L11:;
    }
    v5 = ecl_cdr(v5);
L7:;
    if (Null(v5)) { goto L20; }
    goto L6;
L20:;
   }
   T0 = ecl_boole(ECL_BOOLIOR,(v2old_bits),(v3on));
   value0 = ecl_boole(ECL_BOOLANDC2,(T0),(v4off));
   cl_env_copy->nvalues = 1;
   return value0;
  }
 }
}
/*      local function GET-FLAGS                                      */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC3072get_flags(cl_object v1x)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  if (!(ECL_ATOM(v1x))) { goto L1; }
  if (Null(L3069standard_optimization_quality_p(v1x))) { goto L3; }
  value0 = L3071optimization_quality_switches(v1x, ecl_make_fixnum(3));
  return value0;
L3:;
  value0 = L3071optimization_quality_switches(v1x, ecl_make_fixnum(1));
  return value0;
L1:;
  {
   cl_object v2;
   cl_object v3name;
   cl_object v4value;
   v2 = v1x;
   if (!(v2==ECL_NIL)) { goto L7; }
   ecl_function_dispatch(cl_env_copy,VV[48])(1, v1x) /*  DM-TOO-FEW-ARGUMENTS */;
L7:;
   {
    cl_object v5;
    v5 = ecl_car(v2);
    v2 = ecl_cdr(v2);
    v3name = v5;
   }
   if (!(v2==ECL_NIL)) { goto L13; }
   ecl_function_dispatch(cl_env_copy,VV[48])(1, v1x) /*  DM-TOO-FEW-ARGUMENTS */;
L13:;
   {
    cl_object v5;
    v5 = ecl_car(v2);
    v2 = ecl_cdr(v2);
    v4value = v5;
   }
   if (Null(v2)) { goto L18; }
   ecl_function_dispatch(cl_env_copy,VV[49])(1, v1x) /*  DM-TOO-MANY-ARGUMENTS */;
L18:;
   {
    cl_fixnum v5;
    v5 = 0;
    if (!(ECL_FIXNUMP(v4value))) { goto L20; }
    v5 = ecl_fixnum(v4value);
    if (!((v5)<=(3))) { goto L20; }
    if (!((v5)>=(0))) { goto L20; }
   }
   value0 = L3071optimization_quality_switches(v3name, v4value);
   return value0;
L20:;
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 1;
   return value0;
  }
 }
}
/*      function definition for AUGMENT-POLICY-SWITCH                 */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3074augment_policy_switch(cl_object v1on_off, cl_object v2switches, cl_object v3flag)
{
 cl_object T0, T1, T2;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  if (!((v1on_off)==(VV[12]))) { goto L1; }
  {
   cl_object v4;
   v4 = v2switches;
   if (ecl_unlikely(ECL_ATOM(v4))) FEtype_error_cons(v4);
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 0;
   T0 = v4;
  }
  T1 = ecl_car(v2switches);
  T2 = ecl_boole(ECL_BOOLIOR,(T1),(v3flag));
  value0 = (ECL_CONS_CAR(T0)=T2,T0);
  cl_env_copy->nvalues = 1;
  return value0;
L1:;
  if (!((v1on_off)==(VV[13]))) { goto L6; }
  {
   cl_object v4;
   v4 = v2switches;
   if (ecl_unlikely(ECL_ATOM(v4))) FEtype_error_cons(v4);
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 0;
   T0 = v4;
  }
  T1 = ecl_cdr(v2switches);
  T2 = ecl_boole(ECL_BOOLIOR,(T1),(v3flag));
  value0 = (ECL_CONS_CDR(T0)=T2,T0);
  cl_env_copy->nvalues = 1;
  return value0;
L6:;
  value0 = si_ecase_error(v1on_off, VV[14]);
  return value0;
 }
}
/*      function definition for AUGMENT-STANDARD-POLICY               */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3075augment_standard_policy(cl_object v1quality, cl_object v2level, cl_object v3on_off, cl_object v4flag)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  {
   cl_fixnum v5i;
   v5i = 0;
   {
    cl_object v6bits;
    v6bits = ECL_NIL;
L3:;
    v6bits = L3071optimization_quality_switches(v1quality, ecl_make_fixnum(v5i));
    if (!(ecl_lower(ecl_make_fixnum(v5i),v2level))) { goto L8; }
    if (!((v3on_off)==(VV[12]))) { goto L10; }
    L3074augment_policy_switch(VV[13], v6bits, v4flag);
    goto L7;
L10:;
    if (!((v3on_off)==(VV[13]))) { goto L12; }
    L3074augment_policy_switch(VV[12], v6bits, v4flag);
    goto L7;
L12:;
    si_ecase_error(v3on_off, VV[14]);
    goto L7;
L8:;
    if (!((v3on_off)==(VV[12]))) { goto L14; }
    L3074augment_policy_switch(VV[12], v6bits, v4flag);
    goto L7;
L14:;
    if (!((v3on_off)==(VV[13]))) { goto L16; }
    L3074augment_policy_switch(VV[13], v6bits, v4flag);
    goto L7;
L16:;
    si_ecase_error(v3on_off, VV[14]);
L7:;
    v5i = (v5i)+1;
    if (!((v5i)>(3))) { goto L20; }
    goto L4;
L20:;
    goto L3;
L4:;
    value0 = ECL_NIL;
    cl_env_copy->nvalues = 1;
    return value0;
   }
  }
 }
}
/*      function definition for AUGMENT-EXTENDED-POLICY               */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3076augment_extended_policy(cl_object v1quality, cl_object v2on_off, cl_object v3flag)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  {
   cl_object v4bits;
   v4bits = L3071optimization_quality_switches(v1quality, ecl_make_fixnum(1));
   if (!((v2on_off)==(VV[17]))) { goto L2; }
   value0 = L3074augment_policy_switch(VV[12], v4bits, v3flag);
   return value0;
L2:;
   if (!((v2on_off)==(VV[18]))) { goto L4; }
   value0 = L3074augment_policy_switch(VV[13], v4bits, v3flag);
   return value0;
L4:;
   value0 = si_ecase_error(v2on_off, VV[19]);
   return value0;
  }
 }
}
/*      function definition for POLICY-FUNCTION-NAME                  */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3077policy_function_name(cl_object v1base)
{
 cl_object T0, T1, T2;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  T0 = ecl_symbol_name(v1base);
  T1 = cl_concatenate(3, ECL_SYM("STRING",807), VV[21], T0);
  T2 = cl_find_package(VV[22]);
  value0 = cl_intern(2, T1, T2);
  return value0;
 }
}
/*      local function DEFINE-POLICY                                  */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC3078define_policy(cl_object v1, cl_object v2)
{
 cl_object T0, T1, T2, T3, T4, T5;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  {
   cl_object v3;
   cl_object v4name;
   cl_object v5conditions;
   v3 = ecl_cdr(v1);
   if (!(v3==ECL_NIL)) { goto L3; }
   ecl_function_dispatch(cl_env_copy,VV[48])(1, v1) /*  DM-TOO-FEW-ARGUMENTS */;
L3:;
   {
    cl_object v6;
    v6 = ecl_car(v3);
    v3 = ecl_cdr(v3);
    v4name = v6;
   }
   v5conditions = v3;
   {
    cl_object v6;
    cl_object v7;
    cl_object v8;
    T0 = ecl_car(v5conditions);
    if (!(ECL_STRINGP(T0))) { goto L11; }
    {
     cl_object v9;
     v9 = v5conditions;
     {
      cl_object v10;
      v10 = v9;
      {
       bool v11;
       v11 = ECL_LISTP(v10);
       if (ecl_unlikely(!(v11)))
         FEwrong_type_argument(VV[24],v10);
       value0 = ECL_NIL;
       cl_env_copy->nvalues = 0;
      }
     }
     if (Null(v9)) { goto L17; }
     {
      cl_object v10;
      v10 = ECL_CONS_CDR(v9);
      v5conditions = v10;
      v9 = ECL_CONS_CAR(v9);
     }
L17:;
     v6 = v9;
     goto L9;
    }
L11:;
    v6 = ECL_NIL;
    goto L9;
L9:;
    T0 = L3070take_optimization_bit(v4name);
    v7 = cl_ash(ecl_make_fixnum(1), T0);
    v8 = L3077policy_function_name(v4name);
    T0 = CONS(ecl_make_fixnum(0),v7);
    T1 = CONS(v7,ecl_make_fixnum(0));
    T2 = cl_list(2, T0, T1);
    si_hash_set(v4name, ecl_symbol_value(VV[4]), T2);
    {
     cl_object v9extra;
     v9extra = ECL_NIL;
     {
      cl_object v10case;
      cl_object v11;
      v10case = ECL_NIL;
      {
       cl_object v12;
       v12 = v5conditions;
       if (ecl_unlikely(!ECL_LISTP(v12))) FEtype_error_list(v12);
       value0 = ECL_NIL;
       cl_env_copy->nvalues = 0;
       v11 = v12;
      }
L31:;
      if (!(ecl_endp(v11))) { goto L33; }
      goto L32;
L33:;
      v10case = ECL_CONS_CAR(v11);
      {
       cl_object v12;
       v12 = ECL_CONS_CDR(v11);
       if (ecl_unlikely(!ECL_LISTP(v12))) FEtype_error_list(v12);
       value0 = ECL_NIL;
       cl_env_copy->nvalues = 0;
       v11 = v12;
      }
      {
       cl_object v12;
       v12 = ecl_car(v10case);
       if (!((v12)==(VV[12]))) { goto L48; }
       goto L45;
       goto L46;
L48:;
       goto L46;
L46:;
       if (!((v12)==(VV[13]))) { goto L43; }
       goto L44;
L45:;
L44:;
       {
        cl_object v13;
        cl_object v14op;
        cl_object v15quality;
        cl_object v16level;
        v13 = v10case;
        if (!(v13==ECL_NIL)) { goto L53; }
        ecl_function_dispatch(cl_env_copy,VV[48])(1, v10case) /*  DM-TOO-FEW-ARGUMENTS */;
L53:;
        {
         cl_object v17;
         v17 = ecl_car(v13);
         v13 = ecl_cdr(v13);
         v14op = v17;
        }
        if (!(v13==ECL_NIL)) { goto L59; }
        ecl_function_dispatch(cl_env_copy,VV[48])(1, v10case) /*  DM-TOO-FEW-ARGUMENTS */;
L59:;
        {
         cl_object v17;
         v17 = ecl_car(v13);
         v13 = ecl_cdr(v13);
         v15quality = v17;
        }
        if (!(v13==ECL_NIL)) { goto L65; }
        ecl_function_dispatch(cl_env_copy,VV[48])(1, v10case) /*  DM-TOO-FEW-ARGUMENTS */;
L65:;
        {
         cl_object v17;
         v17 = ecl_car(v13);
         v13 = ecl_cdr(v13);
         v16level = v17;
        }
        if (Null(v13)) { goto L70; }
        ecl_function_dispatch(cl_env_copy,VV[49])(1, v10case) /*  DM-TOO-MANY-ARGUMENTS */;
L70:;
        L3075augment_standard_policy(v15quality, v16level, v14op, v7);
        goto L41;
       }
L43:;
       if (!((v12)==(VV[17]))) { goto L77; }
       goto L74;
       goto L75;
L77:;
       goto L75;
L75:;
       if (!((v12)==(VV[18]))) { goto L72; }
       goto L73;
L74:;
L73:;
       {
        cl_object v17;
        cl_object v18op;
        cl_object v19quality;
        v17 = v10case;
        if (!(v17==ECL_NIL)) { goto L82; }
        ecl_function_dispatch(cl_env_copy,VV[48])(1, v10case) /*  DM-TOO-FEW-ARGUMENTS */;
L82:;
        {
         cl_object v20;
         v20 = ecl_car(v17);
         v17 = ecl_cdr(v17);
         v18op = v20;
        }
        if (!(v17==ECL_NIL)) { goto L88; }
        ecl_function_dispatch(cl_env_copy,VV[48])(1, v10case) /*  DM-TOO-FEW-ARGUMENTS */;
L88:;
        {
         cl_object v20;
         v20 = ecl_car(v17);
         v17 = ecl_cdr(v17);
         v19quality = v20;
        }
        if (Null(v17)) { goto L93; }
        ecl_function_dispatch(cl_env_copy,VV[49])(1, v10case) /*  DM-TOO-MANY-ARGUMENTS */;
L93:;
        L3076augment_extended_policy(v19quality, v18op, v7);
        goto L41;
       }
L72:;
       if (!((v12)==(VV[27]))) { goto L95; }
       {
        cl_object v20;
        cl_object v21op;
        cl_object v22form;
        v20 = v10case;
        if (!(v20==ECL_NIL)) { goto L99; }
        ecl_function_dispatch(cl_env_copy,VV[48])(1, v10case) /*  DM-TOO-FEW-ARGUMENTS */;
L99:;
        {
         cl_object v23;
         v23 = ecl_car(v20);
         v20 = ecl_cdr(v20);
         v21op = v23;
        }
        if (!(v20==ECL_NIL)) { goto L105; }
        ecl_function_dispatch(cl_env_copy,VV[48])(1, v10case) /*  DM-TOO-FEW-ARGUMENTS */;
L105:;
        {
         cl_object v23;
         v23 = ecl_car(v20);
         v20 = ecl_cdr(v20);
         v22form = v23;
        }
        if (Null(v20)) { goto L110; }
        ecl_function_dispatch(cl_env_copy,VV[49])(1, v10case) /*  DM-TOO-MANY-ARGUMENTS */;
L110:;
        v9extra = CONS(v22form,v9extra);
        goto L41;
       }
L95:;
       T0 = CONS(VV[29],v1);
       cl_error(2, VV[28], T0);
      }
L41:;
      goto L31;
L32:;
      if (Null(v6)) { goto L117; }
      T0 = ecl_list1(v6);
      goto L115;
L117:;
      T0 = ECL_NIL;
      goto L115;
L115:;
      T1 = cl_list(3, ECL_SYM("LOGTEST",508), VV[32], v7);
      T2 = cl_listX(3, ECL_SYM("AND",89), T1, v9extra);
      T3 = cl_list(3, ECL_SYM("LET",479), VV[31], T2);
      T4 = ecl_list1(T3);
      T5 = ecl_append(T0,T4);
      value0 = cl_listX(4, ECL_SYM("DEFUN",291), v8, VV[30], T5);
      return value0;
     }
    }
   }
  }
 }
}
/*      local function DEFINE-POLICY-ALIAS                            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC3079define_policy_alias(cl_object v1, cl_object v2)
{
 cl_object T0, T1, T2, T3;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  {
   cl_object v3;
   cl_object v4name;
   cl_object v5doc;
   cl_object v6;
   cl_object v7;
   cl_object v8op;
   cl_object v9alias;
   v3 = ecl_cdr(v1);
   if (!(v3==ECL_NIL)) { goto L3; }
   ecl_function_dispatch(cl_env_copy,VV[48])(1, v1) /*  DM-TOO-FEW-ARGUMENTS */;
L3:;
   {
    cl_object v10;
    v10 = ecl_car(v3);
    v3 = ecl_cdr(v3);
    v4name = v10;
   }
   if (!(v3==ECL_NIL)) { goto L9; }
   ecl_function_dispatch(cl_env_copy,VV[48])(1, v1) /*  DM-TOO-FEW-ARGUMENTS */;
L9:;
   {
    cl_object v10;
    v10 = ecl_car(v3);
    v3 = ecl_cdr(v3);
    v5doc = v10;
   }
   if (!(v3==ECL_NIL)) { goto L15; }
   ecl_function_dispatch(cl_env_copy,VV[48])(1, v1) /*  DM-TOO-FEW-ARGUMENTS */;
L15:;
   {
    cl_object v10;
    v10 = ecl_car(v3);
    v3 = ecl_cdr(v3);
    v6 = v10;
   }
   v7 = v6;
   if (!(v7==ECL_NIL)) { goto L22; }
   ecl_function_dispatch(cl_env_copy,VV[48])(1, v1) /*  DM-TOO-FEW-ARGUMENTS */;
L22:;
   {
    cl_object v10;
    v10 = ecl_car(v7);
    v7 = ecl_cdr(v7);
    v8op = v10;
   }
   if (!(v7==ECL_NIL)) { goto L28; }
   ecl_function_dispatch(cl_env_copy,VV[48])(1, v1) /*  DM-TOO-FEW-ARGUMENTS */;
L28:;
   {
    cl_object v10;
    v10 = ecl_car(v7);
    v7 = ecl_cdr(v7);
    v9alias = v10;
   }
   if (Null(v3)) { goto L33; }
   ecl_function_dispatch(cl_env_copy,VV[49])(1, v1) /*  DM-TOO-MANY-ARGUMENTS */;
L33:;
   if (Null(v7)) { goto L35; }
   ecl_function_dispatch(cl_env_copy,VV[49])(1, v1) /*  DM-TOO-MANY-ARGUMENTS */;
L35:;
   {
    cl_object v10bits;
    v10bits = ecl_gethash_safe(v9alias,ecl_symbol_value(VV[4]),ECL_NIL);
    if (!((v8op)==(VV[33]))) { goto L38; }
    si_hash_set(v4name, ecl_symbol_value(VV[4]), v10bits);
    T0 = L3077policy_function_name(v4name);
    T1 = L3077policy_function_name(v9alias);
    T2 = cl_list(2, T1, VV[34]);
    value0 = cl_list(5, ECL_SYM("DEFUN",291), T0, VV[30], v5doc, T2);
    return value0;
L38:;
    if (!((v8op)==(VV[35]))) { goto L41; }
    T0 = cl_reverse(v10bits);
    si_hash_set(v4name, ecl_symbol_value(VV[4]), T0);
    T0 = L3077policy_function_name(v4name);
    T1 = L3077policy_function_name(v9alias);
    T2 = cl_list(2, T1, VV[34]);
    T3 = cl_list(2, ECL_SYM("NOT",586), T2);
    value0 = cl_list(5, ECL_SYM("DEFUN",291), T0, VV[30], v5doc, T3);
    return value0;
L41:;
    value0 = si_ecase_error(v8op, VV[36]);
    return value0;
   }
  }
 }
}
/*      function definition for POLICY-TO-DEBUG-LEVEL                 */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3080policy_to_debug_level(cl_object v1policy)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  {
   cl_fixnum v2level;
   v2level = 0;
L2:;
   T0 = ecl_plus(ecl_make_fixnum(v2level),ecl_make_fixnum(0));
   if (Null(cl_logbitp(T0, v1policy))) { goto L4; }
   value0 = ecl_make_fixnum(v2level);
   cl_env_copy->nvalues = 1;
   return value0;
L4:;
   v2level = (v2level)+1;
   if (!((v2level)>(3))) { goto L8; }
   goto L3;
L8:;
   goto L2;
L3:;
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 1;
   return value0;
  }
 }
}
/*      function definition for POLICY-TO-SAFETY-LEVEL                */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3081policy_to_safety_level(cl_object v1policy)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  {
   cl_fixnum v2level;
   v2level = 0;
L2:;
   T0 = ecl_plus(ecl_make_fixnum(v2level),ecl_make_fixnum(4));
   if (Null(cl_logbitp(T0, v1policy))) { goto L4; }
   value0 = ecl_make_fixnum(v2level);
   cl_env_copy->nvalues = 1;
   return value0;
L4:;
   v2level = (v2level)+1;
   if (!((v2level)>(3))) { goto L8; }
   goto L3;
L8:;
   goto L2;
L3:;
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 1;
   return value0;
  }
 }
}
/*      function definition for POLICY-TO-SPEED-LEVEL                 */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3082policy_to_speed_level(cl_object v1policy)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  {
   cl_fixnum v2level;
   v2level = 0;
L2:;
   T0 = ecl_plus(ecl_make_fixnum(v2level),ecl_make_fixnum(8));
   if (Null(cl_logbitp(T0, v1policy))) { goto L4; }
   value0 = ecl_make_fixnum(v2level);
   cl_env_copy->nvalues = 1;
   return value0;
L4:;
   v2level = (v2level)+1;
   if (!((v2level)>(3))) { goto L8; }
   goto L3;
L8:;
   goto L2;
L3:;
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 1;
   return value0;
  }
 }
}
/*      function definition for POLICY-TO-SPACE-LEVEL                 */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3083policy_to_space_level(cl_object v1policy)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  {
   cl_fixnum v2level;
   v2level = 0;
L2:;
   T0 = ecl_plus(ecl_make_fixnum(v2level),ecl_make_fixnum(12));
   if (Null(cl_logbitp(T0, v1policy))) { goto L4; }
   value0 = ecl_make_fixnum(v2level);
   cl_env_copy->nvalues = 1;
   return value0;
L4:;
   v2level = (v2level)+1;
   if (!((v2level)>(3))) { goto L8; }
   goto L3;
L8:;
   goto L2;
L3:;
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 1;
   return value0;
  }
 }
}
/*      function definition for POLICY-TO-COMPILATION-SPEED-LEVEL     */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3084policy_to_compilation_speed_level(cl_object v1policy)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  {
   cl_fixnum v2level;
   v2level = 0;
L2:;
   T0 = ecl_plus(ecl_make_fixnum(v2level),ecl_make_fixnum(16));
   if (Null(cl_logbitp(T0, v1policy))) { goto L4; }
   value0 = ecl_make_fixnum(v2level);
   cl_env_copy->nvalues = 1;
   return value0;
L4:;
   v2level = (v2level)+1;
   if (!((v2level)>(3))) { goto L8; }
   goto L3;
L8:;
   goto L2;
L3:;
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 1;
   return value0;
  }
 }
}

#include "cmp/cmppolicy.data"
#ifdef __cplusplus
extern "C"
#endif
ECL_DLLEXPORT void _eclmXc8rDxglsIr9_Ju64ud71(cl_object flag)
{
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 cl_object *VVtemp;
 if (flag != OBJNULL){
 Cblock = flag;
 #ifndef ECL_DYNAMIC_VV
 flag->cblock.data = VV;
 #endif
 flag->cblock.data_size = VM;
 flag->cblock.temp_data_size = VMtemp;
 flag->cblock.data_text = compiler_data_text;
 flag->cblock.cfuns_size = compiler_cfuns_size;
 flag->cblock.cfuns = compiler_cfuns;
 flag->cblock.source = ecl_make_constant_base_string("SRC:CMP;CMPPOLICY.LSP.NEWEST",-1);
 return;}
 #ifdef ECL_DYNAMIC_VV
 VV = Cblock->cblock.data;
 #endif
 Cblock->cblock.data_text = (const cl_object *)"@EcLtAg:_eclmXc8rDxglsIr9_Ju64ud71@";
 VVtemp = Cblock->cblock.temp_data;
 ECL_DEFINE_SETF_FUNCTIONS
  si_select_package(VVtemp[0]);
  si_Xmake_constant(VV[0], VVtemp[1]);
  ecl_cmp_defun(VV[43]);                          /*  STANDARD-OPTIMIZATION-QUALITY-P */
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  si_Xmake_special(VV[3]);
  if (ecl_boundp(cl_env_copy,VV[3])) { goto L11; }
  cl_set(VV[3],ecl_make_fixnum(38));
L11:;
  si_Xmake_special(VV[4]);
  T0 = cl_make_hash_table(8, ECL_SYM("SIZE",1342), ecl_make_fixnum(64), ECL_SYM("REHASH-SIZE",1331), _ecl_static_0, ECL_SYM("REHASH-THRESHOLD",1332), _ecl_static_1, ECL_SYM("TEST",1350), ECL_SYM("EQ",335));
  VV[5]= si_hash_table_fill(T0, VVtemp[2]);
  if (ecl_boundp(cl_env_copy,VV[4])) { goto L19; }
  cl_set(VV[4],VV[5]);
L19:;
  si_Xmake_special(VV[6]);
  T0 = cl_make_hash_table(8, ECL_SYM("SIZE",1342), ecl_make_fixnum(64), ECL_SYM("REHASH-SIZE",1331), _ecl_static_0, ECL_SYM("REHASH-THRESHOLD",1332), _ecl_static_1, ECL_SYM("TEST",1350), ECL_SYM("EQ",335));
  VV[7]= si_hash_table_fill(T0, VVtemp[3]);
  if (ecl_boundp(cl_env_copy,VV[6])) { goto L27; }
  cl_set(VV[6],VV[7]);
L27:;
 }
  ecl_cmp_defun(VV[44]);                          /*  TAKE-OPTIMIZATION-BIT */
  ecl_cmp_defun(VV[45]);                          /*  OPTIMIZATION-QUALITY-SWITCHES */
  ecl_cmp_defun(VV[46]);                          /*  COMPUTE-POLICY  */
  ecl_cmp_defun(VV[50]);                          /*  AUGMENT-POLICY-SWITCH */
  ecl_cmp_defun(VV[51]);                          /*  AUGMENT-STANDARD-POLICY */
  ecl_cmp_defun(VV[52]);                          /*  AUGMENT-EXTENDED-POLICY */
  ecl_cmp_defun(VV[53]);                          /*  POLICY-FUNCTION-NAME */
  ecl_cmp_defmacro(VV[54]);                       /*  DEFINE-POLICY   */
  ecl_cmp_defmacro(VV[55]);                       /*  DEFINE-POLICY-ALIAS */
  ecl_cmp_defun(VV[56]);                          /*  POLICY-TO-DEBUG-LEVEL */
  ecl_cmp_defun(VV[57]);                          /*  POLICY-TO-SAFETY-LEVEL */
  ecl_cmp_defun(VV[58]);                          /*  POLICY-TO-SPEED-LEVEL */
  ecl_cmp_defun(VV[59]);                          /*  POLICY-TO-SPACE-LEVEL */
  ecl_cmp_defun(VV[60]);                          /*  POLICY-TO-COMPILATION-SPEED-LEVEL */
}
