
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "desktopfile_wrapper.h"

// Argument includes
#include <QString>
#include <qvariant.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_DesktopFile_Type = nullptr;
static PyTypeObject *Sbk_DesktopFile_TypeF(void)
{
    return _Sbk_DesktopFile_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_DesktopFile_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::DesktopFile >()))
        return -1;

    ::DesktopFile *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "DesktopFile", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: DesktopFile::DesktopFile()
    // 1: DesktopFile::DesktopFile(DesktopFile)
    // 2: DesktopFile::DesktopFile(QString)
    if (numArgs == 0) {
        overloadId = 0; // DesktopFile()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 2; // DesktopFile(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]), (pyArgs[0])))) {
        overloadId = 1; // DesktopFile(DesktopFile)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // DesktopFile()
        {

            // DesktopFile()
            cptr = new ::DesktopFile();
            break;
        }
        case 1: // DesktopFile(const DesktopFile &DesktopFile)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::DesktopFile cppArg0_local;
            ::DesktopFile *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // DesktopFile(DesktopFile)
                cptr = new ::DesktopFile(*cppArg0);
            }
            break;
        }
        case 2: // DesktopFile(const QString &fileName)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // DesktopFile(QString)
                cptr = new ::DesktopFile(cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::DesktopFile >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_DesktopFileFunc_comment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // comment()const
        QString cppResult = const_cast<const ::DesktopFile *>(cppSelf)->comment();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DesktopFileFunc_fileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // fileName()const
        QString cppResult = const_cast<const ::DesktopFile *>(cppSelf)->fileName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DesktopFileFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // icon()const
        QString cppResult = const_cast<const ::DesktopFile *>(cppSelf)->icon();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DesktopFileFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // name()const
        QString cppResult = const_cast<const ::DesktopFile *>(cppSelf)->name();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DesktopFileFunc_tryExec(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tryExec()const
        bool cppResult = const_cast<const ::DesktopFile *>(cppSelf)->tryExec();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DesktopFileFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // type()const
        QString cppResult = const_cast<const ::DesktopFile *>(cppSelf)->type();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DesktopFileFunc_value(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "value", errInfo, SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]);

    if (PyArg_ParseTuple(args, "|OO:value", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: DesktopFile::value(QString,bool=)const->QVariant
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // value(QString,bool)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // value(QString,bool)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "value", errInfo, SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"localized", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "value", errInfo, SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = false;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // value(QString,bool)const
            QVariant cppResult = const_cast<const ::DesktopFile *>(cppSelf)->value(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DesktopFile__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_DesktopFile_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_DesktopFile_methods[] = {
    {"comment", reinterpret_cast<PyCFunction>(Sbk_DesktopFileFunc_comment), METH_NOARGS, nullptr},
    {"fileName", reinterpret_cast<PyCFunction>(Sbk_DesktopFileFunc_fileName), METH_NOARGS, nullptr},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_DesktopFileFunc_icon), METH_NOARGS, nullptr},
    {"name", reinterpret_cast<PyCFunction>(Sbk_DesktopFileFunc_name), METH_NOARGS, nullptr},
    {"tryExec", reinterpret_cast<PyCFunction>(Sbk_DesktopFileFunc_tryExec), METH_NOARGS, nullptr},
    {"type", reinterpret_cast<PyCFunction>(Sbk_DesktopFileFunc_type), METH_NOARGS, nullptr},
    {"value", reinterpret_cast<PyCFunction>(Sbk_DesktopFileFunc_value), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_DesktopFile__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_DesktopFile_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_DesktopFile_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_DesktopFile_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_DesktopFile_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_DesktopFile_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_DesktopFile_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_DesktopFile_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_DesktopFile_spec = {
    "1:PyFalkon.DesktopFile",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_DesktopFile_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void DesktopFile_PythonToCpp_DesktopFile_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_DesktopFile_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_DesktopFile_PythonToCpp_DesktopFile_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_DesktopFile_TypeF()))
        return DesktopFile_PythonToCpp_DesktopFile_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *DesktopFile_PTR_CppToPython_DesktopFile(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_DesktopFile_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_DesktopFile_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *DesktopFile_COPY_CppToPython_DesktopFile(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::DesktopFile *>(cppIn);
    return Shiboken::Object::newObject(Sbk_DesktopFile_TypeF(), new ::DesktopFile(*source), true, true);
}

// Python to C++ copy conversion.
static void DesktopFile_PythonToCpp_DesktopFile_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::DesktopFile *>(cppOut) = *reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_DesktopFile_PythonToCpp_DesktopFile_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_DesktopFile_TypeF()))
        return DesktopFile_PythonToCpp_DesktopFile_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *DesktopFile_SignatureStrings[] = {
    "2:PyFalkon.DesktopFile(self)",
    "1:PyFalkon.DesktopFile(self,DesktopFile:PyFalkon.DesktopFile)",
    "0:PyFalkon.DesktopFile(self,fileName:QString)",
    "PyFalkon.DesktopFile.comment(self)->QString",
    "PyFalkon.DesktopFile.fileName(self)->QString",
    "PyFalkon.DesktopFile.icon(self)->QString",
    "PyFalkon.DesktopFile.name(self)->QString",
    "PyFalkon.DesktopFile.tryExec(self)->bool",
    "PyFalkon.DesktopFile.type(self)->QString",
    "PyFalkon.DesktopFile.value(self,key:QString,localized:bool=false)->QVariant",
    "PyFalkon.DesktopFile.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t DesktopFile_SignatureByteSize = 175;
static constexpr uint8_t DesktopFile_SignatureBytes[175] = {
    0x78, 0xda, 0x8d, 0x90, 0xcd, 0x0a, 0xc2, 0x30, 0x0c, 0x80, 0xef, 0x7d, 0x12, 0x07, 0x73, 0xa8,
    0xc7, 0x81, 0x9e, 0x74, 0x47, 0x51, 0x06, 0x5e, 0x4b, 0xad, 0x99, 0x94, 0xa5, 0xcd, 0xd8, 0xaa,
    0x58, 0x9f, 0xde, 0x0e, 0x57, 0xf0, 0xd0, 0x49, 0x6f, 0xf9, 0xf9, 0xf2, 0x25, 0x64, 0x53, 0x9e,
    0x5c, 0x25, 0xb0, 0x25, 0x53, 0xec, 0x61, 0x68, 0x2d, 0x75, 0x95, 0x42, 0x58, 0x0c, 0x80, 0x4d,
    0xc6, 0xd6, 0xf3, 0xcd, 0xfc, 0xa7, 0x10, 0xa5, 0x32, 0xb6, 0xfa, 0x33, 0xdd, 0xf8, 0xe8, 0x28,
    0x34, 0x94, 0xe7, 0xda, 0xf6, 0xca, 0xdc, 0x33, 0x16, 0x63, 0x0b, 0x49, 0x5a, 0x83, 0xb1, 0xdf,
    0x73, 0x96, 0xbb, 0x09, 0x8e, 0xb3, 0x41, 0x99, 0x04, 0x2b, 0x49, 0x26, 0x09, 0x34, 0xa9, 0x46,
    0xdb, 0xbb, 0xc3, 0x0b, 0x64, 0x60, 0xaf, 0x44, 0x38, 0x03, 0xba, 0x2e, 0xcd, 0xf8, 0x14, 0xf8,
    0x98, 0xde, 0xd5, 0x82, 0x0b, 0x9f, 0xca, 0x91, 0xa4, 0x40, 0xf5, 0x86, 0x5b, 0x39, 0xee, 0xd8,
    0x36, 0x02, 0x07, 0x18, 0x55, 0x17, 0xd1, 0x2b, 0x61, 0x6c, 0xdc, 0xc5, 0xb9, 0xa4, 0xce, 0x71,
    0x1e, 0x16, 0xfb, 0x23, 0xbc, 0xab, 0xe0, 0xb5, 0x4f, 0xd9, 0x07, 0x10, 0x28, 0xba, 0xac
};
#endif

PyTypeObject *init_DesktopFile(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX].type;

    Shiboken::AutoDecRef Sbk_DesktopFile_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_DesktopFile_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "DesktopFile",
        "DesktopFile",
        &Sbk_DesktopFile_spec,
        &Shiboken::callCppDestructor< ::DesktopFile >,
        Sbk_DesktopFile_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_DesktopFile_Type; // references _Sbk_DesktopFile_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, DesktopFile_SignatureStrings);
#else
    InitSignatureBytes(pyType, DesktopFile_SignatureBytes, DesktopFile_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_DesktopFile_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        DesktopFile_PythonToCpp_DesktopFile_PTR,
        is_DesktopFile_PythonToCpp_DesktopFile_PTR_Convertible,
        DesktopFile_PTR_CppToPython_DesktopFile,
        DesktopFile_COPY_CppToPython_DesktopFile);

    Shiboken::Conversions::registerConverterName(converter, "DesktopFile");
    Shiboken::Conversions::registerConverterName(converter, "DesktopFile*");
    Shiboken::Conversions::registerConverterName(converter, "DesktopFile&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::DesktopFile).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        DesktopFile_PythonToCpp_DesktopFile_COPY,
        is_DesktopFile_PythonToCpp_DesktopFile_COPY_Convertible);

    qRegisterMetaType< ::DesktopFile >("DesktopFile");

    return pyType;
}
