/* common-message-data.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from common-message-data.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_MESSAGE_DATA_ABSTRACT_MESSAGE_DATA_0_PROPERTY,
	GEARY_MESSAGE_DATA_ABSTRACT_MESSAGE_DATA_NUM_PROPERTIES
};
static GParamSpec* geary_message_data_abstract_message_data_properties[GEARY_MESSAGE_DATA_ABSTRACT_MESSAGE_DATA_NUM_PROPERTIES];
enum  {
	GEARY_MESSAGE_DATA_STRING_MESSAGE_DATA_0_PROPERTY,
	GEARY_MESSAGE_DATA_STRING_MESSAGE_DATA_VALUE_PROPERTY,
	GEARY_MESSAGE_DATA_STRING_MESSAGE_DATA_NUM_PROPERTIES
};
static GParamSpec* geary_message_data_string_message_data_properties[GEARY_MESSAGE_DATA_STRING_MESSAGE_DATA_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GEARY_MESSAGE_DATA_INT_MESSAGE_DATA_0_PROPERTY,
	GEARY_MESSAGE_DATA_INT_MESSAGE_DATA_VALUE_PROPERTY,
	GEARY_MESSAGE_DATA_INT_MESSAGE_DATA_NUM_PROPERTIES
};
static GParamSpec* geary_message_data_int_message_data_properties[GEARY_MESSAGE_DATA_INT_MESSAGE_DATA_NUM_PROPERTIES];
enum  {
	GEARY_MESSAGE_DATA_INT64_MESSAGE_DATA_0_PROPERTY,
	GEARY_MESSAGE_DATA_INT64_MESSAGE_DATA_VALUE_PROPERTY,
	GEARY_MESSAGE_DATA_INT64_MESSAGE_DATA_NUM_PROPERTIES
};
static GParamSpec* geary_message_data_int64_message_data_properties[GEARY_MESSAGE_DATA_INT64_MESSAGE_DATA_NUM_PROPERTIES];
enum  {
	GEARY_MESSAGE_DATA_BLOCK_MESSAGE_DATA_0_PROPERTY,
	GEARY_MESSAGE_DATA_BLOCK_MESSAGE_DATA_DATA_NAME_PROPERTY,
	GEARY_MESSAGE_DATA_BLOCK_MESSAGE_DATA_BUFFER_PROPERTY,
	GEARY_MESSAGE_DATA_BLOCK_MESSAGE_DATA_NUM_PROPERTIES
};
static GParamSpec* geary_message_data_block_message_data_properties[GEARY_MESSAGE_DATA_BLOCK_MESSAGE_DATA_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GearyMessageDataStringMessageDataPrivate {
	gchar* _value;
	guint stored_hash;
};

struct _GearyMessageDataIntMessageDataPrivate {
	gint _value;
};

struct _GearyMessageDataInt64MessageDataPrivate {
	gint64 _value;
	guint stored_hash;
};

struct _GearyMessageDataBlockMessageDataPrivate {
	gchar* _data_name;
	GearyMemoryBuffer* _buffer;
};

static gpointer geary_message_data_abstract_message_data_parent_class = NULL;
static gint GearyMessageDataStringMessageData_private_offset;
static gpointer geary_message_data_string_message_data_parent_class = NULL;
static GeeHashableIface * geary_message_data_string_message_data_gee_hashable_parent_iface = NULL;
static gint GearyMessageDataIntMessageData_private_offset;
static gpointer geary_message_data_int_message_data_parent_class = NULL;
static GeeHashableIface * geary_message_data_int_message_data_gee_hashable_parent_iface = NULL;
static gint GearyMessageDataInt64MessageData_private_offset;
static gpointer geary_message_data_int64_message_data_parent_class = NULL;
static GeeHashableIface * geary_message_data_int64_message_data_gee_hashable_parent_iface = NULL;
static gint GearyMessageDataBlockMessageData_private_offset;
static gpointer geary_message_data_block_message_data_parent_class = NULL;

static gchar* geary_message_data_abstract_message_data_real_to_string (GearyMessageDataAbstractMessageData* self);
static GType geary_message_data_abstract_message_data_get_type_once (void);
static GType geary_message_data_searchable_message_data_get_type_once (void);
static void geary_message_data_string_message_data_set_value (GearyMessageDataStringMessageData* self,
                                                       const gchar* value);
static gboolean geary_message_data_string_message_data_real_equal_to (GearyMessageDataStringMessageData* self,
                                                               GearyMessageDataStringMessageData* other);
static guint geary_message_data_string_message_data_real_hash (GearyMessageDataStringMessageData* self);
static gchar* geary_message_data_string_message_data_real_to_string (GearyMessageDataAbstractMessageData* base);
static void geary_message_data_string_message_data_finalize (GObject * obj);
static GType geary_message_data_string_message_data_get_type_once (void);
static void _vala_geary_message_data_string_message_data_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_geary_message_data_string_message_data_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static void geary_message_data_int_message_data_set_value (GearyMessageDataIntMessageData* self,
                                                    gint value);
static gboolean geary_message_data_int_message_data_real_equal_to (GearyMessageDataIntMessageData* self,
                                                            GearyMessageDataIntMessageData* other);
static guint geary_message_data_int_message_data_real_hash (GearyMessageDataIntMessageData* self);
static gchar* geary_message_data_int_message_data_real_to_string (GearyMessageDataAbstractMessageData* base);
static void geary_message_data_int_message_data_finalize (GObject * obj);
static GType geary_message_data_int_message_data_get_type_once (void);
static void _vala_geary_message_data_int_message_data_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec);
static void _vala_geary_message_data_int_message_data_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec);
static void geary_message_data_int64_message_data_set_value (GearyMessageDataInt64MessageData* self,
                                                      gint64 value);
static gboolean geary_message_data_int64_message_data_real_equal_to (GearyMessageDataInt64MessageData* self,
                                                              GearyMessageDataInt64MessageData* other);
static guint geary_message_data_int64_message_data_real_hash (GearyMessageDataInt64MessageData* self);
static gchar* geary_message_data_int64_message_data_real_to_string (GearyMessageDataAbstractMessageData* base);
static void geary_message_data_int64_message_data_finalize (GObject * obj);
static GType geary_message_data_int64_message_data_get_type_once (void);
static void _vala_geary_message_data_int64_message_data_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);
static void _vala_geary_message_data_int64_message_data_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec);
static void geary_message_data_block_message_data_set_data_name (GearyMessageDataBlockMessageData* self,
                                                          const gchar* value);
static void geary_message_data_block_message_data_set_buffer (GearyMessageDataBlockMessageData* self,
                                                       GearyMemoryBuffer* value);
static gchar* geary_message_data_block_message_data_real_to_string (GearyMessageDataAbstractMessageData* base);
static void geary_message_data_block_message_data_finalize (GObject * obj);
static GType geary_message_data_block_message_data_get_type_once (void);
static void _vala_geary_message_data_block_message_data_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);
static void _vala_geary_message_data_block_message_data_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec);

/**
     * to_string() is intended for debugging and logging purposes, not user-visible text or
     * serialization.
     */
static gchar*
geary_message_data_abstract_message_data_real_to_string (GearyMessageDataAbstractMessageData* self)
{
	g_critical ("Type `%s' does not implement abstract method `geary_message_data_abstract_message_data_to_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
geary_message_data_abstract_message_data_to_string (GearyMessageDataAbstractMessageData* self)
{
	GearyMessageDataAbstractMessageDataClass* _klass_;
	g_return_val_if_fail (GEARY_MESSAGE_DATA_IS_ABSTRACT_MESSAGE_DATA (self), NULL);
	_klass_ = GEARY_MESSAGE_DATA_ABSTRACT_MESSAGE_DATA_GET_CLASS (self);
	if (_klass_->to_string) {
		return _klass_->to_string (self);
	}
	return NULL;
}

GearyMessageDataAbstractMessageData*
geary_message_data_abstract_message_data_construct (GType object_type)
{
	GearyMessageDataAbstractMessageData * self = NULL;
	self = (GearyMessageDataAbstractMessageData*) geary_base_object_construct (object_type);
	return self;
}

static void
geary_message_data_abstract_message_data_class_init (GearyMessageDataAbstractMessageDataClass * klass,
                                                     gpointer klass_data)
{
	geary_message_data_abstract_message_data_parent_class = g_type_class_peek_parent (klass);
	((GearyMessageDataAbstractMessageDataClass *) klass)->to_string = (gchar* (*) (GearyMessageDataAbstractMessageData*)) geary_message_data_abstract_message_data_real_to_string;
}

static void
geary_message_data_abstract_message_data_instance_init (GearyMessageDataAbstractMessageData * self,
                                                        gpointer klass)
{
}

/**
 * AbstractData is an abstract base class to unify the various message-related data and
 * metadata that may be associated with a mail message, whether it's embedded in its MIME
 * structure, its RFC822 header, IMAP metadata, details from a POP server, etc.
 */
 G_GNUC_NO_INLINE static GType
geary_message_data_abstract_message_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyMessageDataAbstractMessageDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_message_data_abstract_message_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyMessageDataAbstractMessageData), 0, (GInstanceInitFunc) geary_message_data_abstract_message_data_instance_init, NULL };
	GType geary_message_data_abstract_message_data_type_id;
	geary_message_data_abstract_message_data_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyMessageDataAbstractMessageData", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return geary_message_data_abstract_message_data_type_id;
}

GType
geary_message_data_abstract_message_data_get_type (void)
{
	static gsize geary_message_data_abstract_message_data_type_id__once = 0;
	if (g_once_init_enter (&geary_message_data_abstract_message_data_type_id__once)) {
		GType geary_message_data_abstract_message_data_type_id;
		geary_message_data_abstract_message_data_type_id = geary_message_data_abstract_message_data_get_type_once ();
		g_once_init_leave (&geary_message_data_abstract_message_data_type_id__once, geary_message_data_abstract_message_data_type_id);
	}
	return geary_message_data_abstract_message_data_type_id__once;
}

/**
     * Return a string representing the data as a corpus of text to be searched
     * against.  Return values from this may be stored in the search index.
     */
gchar*
geary_message_data_searchable_message_data_to_searchable_string (GearyMessageDataSearchableMessageData* self)
{
	GearyMessageDataSearchableMessageDataIface* _iface_;
	g_return_val_if_fail (GEARY_MESSAGE_DATA_IS_SEARCHABLE_MESSAGE_DATA (self), NULL);
	_iface_ = GEARY_MESSAGE_DATA_SEARCHABLE_MESSAGE_DATA_GET_INTERFACE (self);
	if (_iface_->to_searchable_string) {
		return _iface_->to_searchable_string (self);
	}
	return NULL;
}

static void
geary_message_data_searchable_message_data_default_init (GearyMessageDataSearchableMessageDataIface * iface,
                                                         gpointer iface_data)
{
}

/**
 * Allows message data fields to define how they'll expose themselves to search
 * queries.
 */
 G_GNUC_NO_INLINE static GType
geary_message_data_searchable_message_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyMessageDataSearchableMessageDataIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_message_data_searchable_message_data_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType geary_message_data_searchable_message_data_type_id;
	geary_message_data_searchable_message_data_type_id = g_type_register_static (G_TYPE_INTERFACE, "GearyMessageDataSearchableMessageData", &g_define_type_info, 0);
	return geary_message_data_searchable_message_data_type_id;
}

GType
geary_message_data_searchable_message_data_get_type (void)
{
	static gsize geary_message_data_searchable_message_data_type_id__once = 0;
	if (g_once_init_enter (&geary_message_data_searchable_message_data_type_id__once)) {
		GType geary_message_data_searchable_message_data_type_id;
		geary_message_data_searchable_message_data_type_id = geary_message_data_searchable_message_data_get_type_once ();
		g_once_init_leave (&geary_message_data_searchable_message_data_type_id__once, geary_message_data_searchable_message_data_type_id);
	}
	return geary_message_data_searchable_message_data_type_id__once;
}

static inline gpointer
geary_message_data_string_message_data_get_instance_private (GearyMessageDataStringMessageData* self)
{
	return G_STRUCT_MEMBER_P (self, GearyMessageDataStringMessageData_private_offset);
}

const gchar*
geary_message_data_string_message_data_get_value (GearyMessageDataStringMessageData* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_MESSAGE_DATA_IS_STRING_MESSAGE_DATA (self), NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}

static void
geary_message_data_string_message_data_set_value (GearyMessageDataStringMessageData* self,
                                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_MESSAGE_DATA_IS_STRING_MESSAGE_DATA (self));
	old_value = geary_message_data_string_message_data_get_value (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_value);
		self->priv->_value = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_message_data_string_message_data_properties[GEARY_MESSAGE_DATA_STRING_MESSAGE_DATA_VALUE_PROPERTY]);
	}
}

GearyMessageDataStringMessageData*
geary_message_data_string_message_data_construct (GType object_type,
                                                  const gchar* value)
{
	GearyMessageDataStringMessageData * self = NULL;
	g_return_val_if_fail (value != NULL, NULL);
	self = (GearyMessageDataStringMessageData*) geary_message_data_abstract_message_data_construct (object_type);
	geary_message_data_string_message_data_set_value (self, value);
	return self;
}

/**
     * Default definition of equals is case-sensitive comparison.
     */
static gboolean
geary_message_data_string_message_data_real_equal_to (GearyMessageDataStringMessageData* self,
                                                      GearyMessageDataStringMessageData* other)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_MESSAGE_DATA_IS_STRING_MESSAGE_DATA (other), FALSE);
	if (self == other) {
		result = TRUE;
		return result;
	}
	if (geary_message_data_string_message_data_hash (self) != geary_message_data_string_message_data_hash (other)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->_value;
	_tmp1_ = other->priv->_value;
	result = g_strcmp0 (_tmp0_, _tmp1_) == 0;
	return result;
}

gboolean
geary_message_data_string_message_data_equal_to (GearyMessageDataStringMessageData* self,
                                                 GearyMessageDataStringMessageData* other)
{
	GearyMessageDataStringMessageDataClass* _klass_;
	g_return_val_if_fail (GEARY_MESSAGE_DATA_IS_STRING_MESSAGE_DATA (self), FALSE);
	_klass_ = GEARY_MESSAGE_DATA_STRING_MESSAGE_DATA_GET_CLASS (self);
	if (_klass_->equal_to) {
		return _klass_->equal_to (self, other);
	}
	return FALSE;
}

static guint
geary_message_data_string_message_data_real_hash (GearyMessageDataStringMessageData* self)
{
	guint _tmp0_ = 0U;
	guint result;
	if (self->priv->stored_hash != G_MAXUINT) {
		_tmp0_ = self->priv->stored_hash;
	} else {
		GHashFunc _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = g_str_hash;
		_tmp2_ = self->priv->_value;
		self->priv->stored_hash = _tmp1_ (_tmp2_);
		_tmp0_ = self->priv->stored_hash;
	}
	result = _tmp0_;
	return result;
}

guint
geary_message_data_string_message_data_hash (GearyMessageDataStringMessageData* self)
{
	GearyMessageDataStringMessageDataClass* _klass_;
	g_return_val_if_fail (GEARY_MESSAGE_DATA_IS_STRING_MESSAGE_DATA (self), 0U);
	_klass_ = GEARY_MESSAGE_DATA_STRING_MESSAGE_DATA_GET_CLASS (self);
	if (_klass_->hash) {
		return _klass_->hash (self);
	}
	return 0U;
}

static gchar*
geary_message_data_string_message_data_real_to_string (GearyMessageDataAbstractMessageData* base)
{
	GearyMessageDataStringMessageData * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData);
	_tmp0_ = self->priv->_value;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
geary_message_data_string_message_data_class_init (GearyMessageDataStringMessageDataClass * klass,
                                                   gpointer klass_data)
{
	geary_message_data_string_message_data_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyMessageDataStringMessageData_private_offset);
	((GearyMessageDataStringMessageDataClass *) klass)->equal_to = (gboolean (*) (GearyMessageDataStringMessageData*, GearyMessageDataStringMessageData*)) geary_message_data_string_message_data_real_equal_to;
	((GearyMessageDataStringMessageDataClass *) klass)->hash = (guint (*) (GearyMessageDataStringMessageData*)) geary_message_data_string_message_data_real_hash;
	((GearyMessageDataAbstractMessageDataClass *) klass)->to_string = (gchar* (*) (GearyMessageDataAbstractMessageData*)) geary_message_data_string_message_data_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_message_data_string_message_data_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_message_data_string_message_data_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_message_data_string_message_data_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MESSAGE_DATA_STRING_MESSAGE_DATA_VALUE_PROPERTY, geary_message_data_string_message_data_properties[GEARY_MESSAGE_DATA_STRING_MESSAGE_DATA_VALUE_PROPERTY] = g_param_spec_string ("value", "value", "value", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_message_data_string_message_data_gee_hashable_interface_init (GeeHashableIface * iface,
                                                                    gpointer iface_data)
{
	geary_message_data_string_message_data_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) geary_message_data_string_message_data_equal_to;
	iface->hash = (guint (*) (GeeHashable*)) geary_message_data_string_message_data_hash;
}

static void
geary_message_data_string_message_data_instance_init (GearyMessageDataStringMessageData * self,
                                                      gpointer klass)
{
	self->priv = geary_message_data_string_message_data_get_instance_private (self);
	self->priv->stored_hash = G_MAXUINT;
}

static void
geary_message_data_string_message_data_finalize (GObject * obj)
{
	GearyMessageDataStringMessageData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData);
	_g_free0 (self->priv->_value);
	G_OBJECT_CLASS (geary_message_data_string_message_data_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_message_data_string_message_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyMessageDataStringMessageDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_message_data_string_message_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyMessageDataStringMessageData), 0, (GInstanceInitFunc) geary_message_data_string_message_data_instance_init, NULL };
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) geary_message_data_string_message_data_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_message_data_string_message_data_type_id;
	geary_message_data_string_message_data_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, "GearyMessageDataStringMessageData", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (geary_message_data_string_message_data_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	GearyMessageDataStringMessageData_private_offset = g_type_add_instance_private (geary_message_data_string_message_data_type_id, sizeof (GearyMessageDataStringMessageDataPrivate));
	return geary_message_data_string_message_data_type_id;
}

GType
geary_message_data_string_message_data_get_type (void)
{
	static gsize geary_message_data_string_message_data_type_id__once = 0;
	if (g_once_init_enter (&geary_message_data_string_message_data_type_id__once)) {
		GType geary_message_data_string_message_data_type_id;
		geary_message_data_string_message_data_type_id = geary_message_data_string_message_data_get_type_once ();
		g_once_init_leave (&geary_message_data_string_message_data_type_id__once, geary_message_data_string_message_data_type_id);
	}
	return geary_message_data_string_message_data_type_id__once;
}

static void
_vala_geary_message_data_string_message_data_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	GearyMessageDataStringMessageData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData);
	switch (property_id) {
		case GEARY_MESSAGE_DATA_STRING_MESSAGE_DATA_VALUE_PROPERTY:
		g_value_set_string (value, geary_message_data_string_message_data_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_message_data_string_message_data_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	GearyMessageDataStringMessageData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData);
	switch (property_id) {
		case GEARY_MESSAGE_DATA_STRING_MESSAGE_DATA_VALUE_PROPERTY:
		geary_message_data_string_message_data_set_value (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
geary_message_data_int_message_data_get_instance_private (GearyMessageDataIntMessageData* self)
{
	return G_STRUCT_MEMBER_P (self, GearyMessageDataIntMessageData_private_offset);
}

gint
geary_message_data_int_message_data_get_value (GearyMessageDataIntMessageData* self)
{
	gint result;
	g_return_val_if_fail (GEARY_MESSAGE_DATA_IS_INT_MESSAGE_DATA (self), 0);
	result = self->priv->_value;
	return result;
}

static void
geary_message_data_int_message_data_set_value (GearyMessageDataIntMessageData* self,
                                               gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_MESSAGE_DATA_IS_INT_MESSAGE_DATA (self));
	old_value = geary_message_data_int_message_data_get_value (self);
	if (old_value != value) {
		self->priv->_value = value;
		g_object_notify_by_pspec ((GObject *) self, geary_message_data_int_message_data_properties[GEARY_MESSAGE_DATA_INT_MESSAGE_DATA_VALUE_PROPERTY]);
	}
}

GearyMessageDataIntMessageData*
geary_message_data_int_message_data_construct (GType object_type,
                                               gint value)
{
	GearyMessageDataIntMessageData * self = NULL;
	self = (GearyMessageDataIntMessageData*) geary_message_data_abstract_message_data_construct (object_type);
	geary_message_data_int_message_data_set_value (self, value);
	return self;
}

static gboolean
geary_message_data_int_message_data_real_equal_to (GearyMessageDataIntMessageData* self,
                                                   GearyMessageDataIntMessageData* other)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_MESSAGE_DATA_IS_INT_MESSAGE_DATA (other), FALSE);
	_tmp0_ = self->priv->_value;
	_tmp1_ = other->priv->_value;
	result = _tmp0_ == _tmp1_;
	return result;
}

gboolean
geary_message_data_int_message_data_equal_to (GearyMessageDataIntMessageData* self,
                                              GearyMessageDataIntMessageData* other)
{
	GearyMessageDataIntMessageDataClass* _klass_;
	g_return_val_if_fail (GEARY_MESSAGE_DATA_IS_INT_MESSAGE_DATA (self), FALSE);
	_klass_ = GEARY_MESSAGE_DATA_INT_MESSAGE_DATA_GET_CLASS (self);
	if (_klass_->equal_to) {
		return _klass_->equal_to (self, other);
	}
	return FALSE;
}

static guint
geary_message_data_int_message_data_real_hash (GearyMessageDataIntMessageData* self)
{
	gint _tmp0_;
	guint result;
	_tmp0_ = self->priv->_value;
	result = (guint) _tmp0_;
	return result;
}

guint
geary_message_data_int_message_data_hash (GearyMessageDataIntMessageData* self)
{
	GearyMessageDataIntMessageDataClass* _klass_;
	g_return_val_if_fail (GEARY_MESSAGE_DATA_IS_INT_MESSAGE_DATA (self), 0U);
	_klass_ = GEARY_MESSAGE_DATA_INT_MESSAGE_DATA_GET_CLASS (self);
	if (_klass_->hash) {
		return _klass_->hash (self);
	}
	return 0U;
}

static gchar*
geary_message_data_int_message_data_real_to_string (GearyMessageDataAbstractMessageData* base)
{
	GearyMessageDataIntMessageData * self;
	gint _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MESSAGE_DATA_TYPE_INT_MESSAGE_DATA, GearyMessageDataIntMessageData);
	_tmp0_ = self->priv->_value;
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
	result = _tmp1_;
	return result;
}

static void
geary_message_data_int_message_data_class_init (GearyMessageDataIntMessageDataClass * klass,
                                                gpointer klass_data)
{
	geary_message_data_int_message_data_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyMessageDataIntMessageData_private_offset);
	((GearyMessageDataIntMessageDataClass *) klass)->equal_to = (gboolean (*) (GearyMessageDataIntMessageData*, GearyMessageDataIntMessageData*)) geary_message_data_int_message_data_real_equal_to;
	((GearyMessageDataIntMessageDataClass *) klass)->hash = (guint (*) (GearyMessageDataIntMessageData*)) geary_message_data_int_message_data_real_hash;
	((GearyMessageDataAbstractMessageDataClass *) klass)->to_string = (gchar* (*) (GearyMessageDataAbstractMessageData*)) geary_message_data_int_message_data_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_message_data_int_message_data_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_message_data_int_message_data_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_message_data_int_message_data_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MESSAGE_DATA_INT_MESSAGE_DATA_VALUE_PROPERTY, geary_message_data_int_message_data_properties[GEARY_MESSAGE_DATA_INT_MESSAGE_DATA_VALUE_PROPERTY] = g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_message_data_int_message_data_gee_hashable_interface_init (GeeHashableIface * iface,
                                                                 gpointer iface_data)
{
	geary_message_data_int_message_data_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) geary_message_data_int_message_data_equal_to;
	iface->hash = (guint (*) (GeeHashable*)) geary_message_data_int_message_data_hash;
}

static void
geary_message_data_int_message_data_instance_init (GearyMessageDataIntMessageData * self,
                                                   gpointer klass)
{
	self->priv = geary_message_data_int_message_data_get_instance_private (self);
}

static void
geary_message_data_int_message_data_finalize (GObject * obj)
{
	GearyMessageDataIntMessageData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_MESSAGE_DATA_TYPE_INT_MESSAGE_DATA, GearyMessageDataIntMessageData);
	G_OBJECT_CLASS (geary_message_data_int_message_data_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_message_data_int_message_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyMessageDataIntMessageDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_message_data_int_message_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyMessageDataIntMessageData), 0, (GInstanceInitFunc) geary_message_data_int_message_data_instance_init, NULL };
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) geary_message_data_int_message_data_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_message_data_int_message_data_type_id;
	geary_message_data_int_message_data_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, "GearyMessageDataIntMessageData", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (geary_message_data_int_message_data_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	GearyMessageDataIntMessageData_private_offset = g_type_add_instance_private (geary_message_data_int_message_data_type_id, sizeof (GearyMessageDataIntMessageDataPrivate));
	return geary_message_data_int_message_data_type_id;
}

GType
geary_message_data_int_message_data_get_type (void)
{
	static gsize geary_message_data_int_message_data_type_id__once = 0;
	if (g_once_init_enter (&geary_message_data_int_message_data_type_id__once)) {
		GType geary_message_data_int_message_data_type_id;
		geary_message_data_int_message_data_type_id = geary_message_data_int_message_data_get_type_once ();
		g_once_init_leave (&geary_message_data_int_message_data_type_id__once, geary_message_data_int_message_data_type_id);
	}
	return geary_message_data_int_message_data_type_id__once;
}

static void
_vala_geary_message_data_int_message_data_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec)
{
	GearyMessageDataIntMessageData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MESSAGE_DATA_TYPE_INT_MESSAGE_DATA, GearyMessageDataIntMessageData);
	switch (property_id) {
		case GEARY_MESSAGE_DATA_INT_MESSAGE_DATA_VALUE_PROPERTY:
		g_value_set_int (value, geary_message_data_int_message_data_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_message_data_int_message_data_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec)
{
	GearyMessageDataIntMessageData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MESSAGE_DATA_TYPE_INT_MESSAGE_DATA, GearyMessageDataIntMessageData);
	switch (property_id) {
		case GEARY_MESSAGE_DATA_INT_MESSAGE_DATA_VALUE_PROPERTY:
		geary_message_data_int_message_data_set_value (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
geary_message_data_int64_message_data_get_instance_private (GearyMessageDataInt64MessageData* self)
{
	return G_STRUCT_MEMBER_P (self, GearyMessageDataInt64MessageData_private_offset);
}

gint64
geary_message_data_int64_message_data_get_value (GearyMessageDataInt64MessageData* self)
{
	gint64 result;
	g_return_val_if_fail (GEARY_MESSAGE_DATA_IS_INT64_MESSAGE_DATA (self), 0LL);
	result = self->priv->_value;
	return result;
}

static void
geary_message_data_int64_message_data_set_value (GearyMessageDataInt64MessageData* self,
                                                 gint64 value)
{
	gint64 old_value;
	g_return_if_fail (GEARY_MESSAGE_DATA_IS_INT64_MESSAGE_DATA (self));
	old_value = geary_message_data_int64_message_data_get_value (self);
	if (old_value != value) {
		self->priv->_value = value;
		g_object_notify_by_pspec ((GObject *) self, geary_message_data_int64_message_data_properties[GEARY_MESSAGE_DATA_INT64_MESSAGE_DATA_VALUE_PROPERTY]);
	}
}

GearyMessageDataInt64MessageData*
geary_message_data_int64_message_data_construct (GType object_type,
                                                 gint64 value)
{
	GearyMessageDataInt64MessageData * self = NULL;
	self = (GearyMessageDataInt64MessageData*) geary_message_data_abstract_message_data_construct (object_type);
	geary_message_data_int64_message_data_set_value (self, value);
	return self;
}

static gboolean
geary_message_data_int64_message_data_real_equal_to (GearyMessageDataInt64MessageData* self,
                                                     GearyMessageDataInt64MessageData* other)
{
	gint64 _tmp0_;
	gint64 _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_MESSAGE_DATA_IS_INT64_MESSAGE_DATA (other), FALSE);
	if (self == other) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->_value;
	_tmp1_ = other->priv->_value;
	result = _tmp0_ == _tmp1_;
	return result;
}

gboolean
geary_message_data_int64_message_data_equal_to (GearyMessageDataInt64MessageData* self,
                                                GearyMessageDataInt64MessageData* other)
{
	GearyMessageDataInt64MessageDataClass* _klass_;
	g_return_val_if_fail (GEARY_MESSAGE_DATA_IS_INT64_MESSAGE_DATA (self), FALSE);
	_klass_ = GEARY_MESSAGE_DATA_INT64_MESSAGE_DATA_GET_CLASS (self);
	if (_klass_->equal_to) {
		return _klass_->equal_to (self, other);
	}
	return FALSE;
}

static guint
geary_message_data_int64_message_data_real_hash (GearyMessageDataInt64MessageData* self)
{
	guint _tmp0_ = 0U;
	guint result;
	if (self->priv->stored_hash != G_MAXUINT) {
		_tmp0_ = self->priv->stored_hash;
	} else {
		GHashFunc _tmp1_;
		gint64 _tmp2_;
		_tmp1_ = g_int64_hash;
		_tmp2_ = self->priv->_value;
		self->priv->stored_hash = _tmp1_ (&_tmp2_);
		_tmp0_ = self->priv->stored_hash;
	}
	result = _tmp0_;
	return result;
}

guint
geary_message_data_int64_message_data_hash (GearyMessageDataInt64MessageData* self)
{
	GearyMessageDataInt64MessageDataClass* _klass_;
	g_return_val_if_fail (GEARY_MESSAGE_DATA_IS_INT64_MESSAGE_DATA (self), 0U);
	_klass_ = GEARY_MESSAGE_DATA_INT64_MESSAGE_DATA_GET_CLASS (self);
	if (_klass_->hash) {
		return _klass_->hash (self);
	}
	return 0U;
}

static gchar*
geary_message_data_int64_message_data_real_to_string (GearyMessageDataAbstractMessageData* base)
{
	GearyMessageDataInt64MessageData * self;
	gint64 _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData);
	_tmp0_ = self->priv->_value;
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp0_);
	result = _tmp1_;
	return result;
}

static void
geary_message_data_int64_message_data_class_init (GearyMessageDataInt64MessageDataClass * klass,
                                                  gpointer klass_data)
{
	geary_message_data_int64_message_data_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyMessageDataInt64MessageData_private_offset);
	((GearyMessageDataInt64MessageDataClass *) klass)->equal_to = (gboolean (*) (GearyMessageDataInt64MessageData*, GearyMessageDataInt64MessageData*)) geary_message_data_int64_message_data_real_equal_to;
	((GearyMessageDataInt64MessageDataClass *) klass)->hash = (guint (*) (GearyMessageDataInt64MessageData*)) geary_message_data_int64_message_data_real_hash;
	((GearyMessageDataAbstractMessageDataClass *) klass)->to_string = (gchar* (*) (GearyMessageDataAbstractMessageData*)) geary_message_data_int64_message_data_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_message_data_int64_message_data_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_message_data_int64_message_data_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_message_data_int64_message_data_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MESSAGE_DATA_INT64_MESSAGE_DATA_VALUE_PROPERTY, geary_message_data_int64_message_data_properties[GEARY_MESSAGE_DATA_INT64_MESSAGE_DATA_VALUE_PROPERTY] = g_param_spec_int64 ("value", "value", "value", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_message_data_int64_message_data_gee_hashable_interface_init (GeeHashableIface * iface,
                                                                   gpointer iface_data)
{
	geary_message_data_int64_message_data_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) geary_message_data_int64_message_data_equal_to;
	iface->hash = (guint (*) (GeeHashable*)) geary_message_data_int64_message_data_hash;
}

static void
geary_message_data_int64_message_data_instance_init (GearyMessageDataInt64MessageData * self,
                                                     gpointer klass)
{
	self->priv = geary_message_data_int64_message_data_get_instance_private (self);
	self->priv->stored_hash = G_MAXUINT;
}

static void
geary_message_data_int64_message_data_finalize (GObject * obj)
{
	GearyMessageDataInt64MessageData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData);
	G_OBJECT_CLASS (geary_message_data_int64_message_data_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_message_data_int64_message_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyMessageDataInt64MessageDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_message_data_int64_message_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyMessageDataInt64MessageData), 0, (GInstanceInitFunc) geary_message_data_int64_message_data_instance_init, NULL };
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) geary_message_data_int64_message_data_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_message_data_int64_message_data_type_id;
	geary_message_data_int64_message_data_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, "GearyMessageDataInt64MessageData", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (geary_message_data_int64_message_data_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	GearyMessageDataInt64MessageData_private_offset = g_type_add_instance_private (geary_message_data_int64_message_data_type_id, sizeof (GearyMessageDataInt64MessageDataPrivate));
	return geary_message_data_int64_message_data_type_id;
}

GType
geary_message_data_int64_message_data_get_type (void)
{
	static gsize geary_message_data_int64_message_data_type_id__once = 0;
	if (g_once_init_enter (&geary_message_data_int64_message_data_type_id__once)) {
		GType geary_message_data_int64_message_data_type_id;
		geary_message_data_int64_message_data_type_id = geary_message_data_int64_message_data_get_type_once ();
		g_once_init_leave (&geary_message_data_int64_message_data_type_id__once, geary_message_data_int64_message_data_type_id);
	}
	return geary_message_data_int64_message_data_type_id__once;
}

static void
_vala_geary_message_data_int64_message_data_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	GearyMessageDataInt64MessageData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData);
	switch (property_id) {
		case GEARY_MESSAGE_DATA_INT64_MESSAGE_DATA_VALUE_PROPERTY:
		g_value_set_int64 (value, geary_message_data_int64_message_data_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_message_data_int64_message_data_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec)
{
	GearyMessageDataInt64MessageData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData);
	switch (property_id) {
		case GEARY_MESSAGE_DATA_INT64_MESSAGE_DATA_VALUE_PROPERTY:
		geary_message_data_int64_message_data_set_value (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
geary_message_data_block_message_data_get_instance_private (GearyMessageDataBlockMessageData* self)
{
	return G_STRUCT_MEMBER_P (self, GearyMessageDataBlockMessageData_private_offset);
}

const gchar*
geary_message_data_block_message_data_get_data_name (GearyMessageDataBlockMessageData* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_MESSAGE_DATA_IS_BLOCK_MESSAGE_DATA (self), NULL);
	_tmp0_ = self->priv->_data_name;
	result = _tmp0_;
	return result;
}

static void
geary_message_data_block_message_data_set_data_name (GearyMessageDataBlockMessageData* self,
                                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_MESSAGE_DATA_IS_BLOCK_MESSAGE_DATA (self));
	old_value = geary_message_data_block_message_data_get_data_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_data_name);
		self->priv->_data_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_message_data_block_message_data_properties[GEARY_MESSAGE_DATA_BLOCK_MESSAGE_DATA_DATA_NAME_PROPERTY]);
	}
}

GearyMemoryBuffer*
geary_message_data_block_message_data_get_buffer (GearyMessageDataBlockMessageData* self)
{
	GearyMemoryBuffer* result;
	GearyMemoryBuffer* _tmp0_;
	g_return_val_if_fail (GEARY_MESSAGE_DATA_IS_BLOCK_MESSAGE_DATA (self), NULL);
	_tmp0_ = self->priv->_buffer;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_message_data_block_message_data_set_buffer (GearyMessageDataBlockMessageData* self,
                                                  GearyMemoryBuffer* value)
{
	GearyMemoryBuffer* old_value;
	g_return_if_fail (GEARY_MESSAGE_DATA_IS_BLOCK_MESSAGE_DATA (self));
	old_value = geary_message_data_block_message_data_get_buffer (self);
	if (old_value != value) {
		GearyMemoryBuffer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_buffer);
		self->priv->_buffer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_message_data_block_message_data_properties[GEARY_MESSAGE_DATA_BLOCK_MESSAGE_DATA_BUFFER_PROPERTY]);
	}
}

GearyMessageDataBlockMessageData*
geary_message_data_block_message_data_construct (GType object_type,
                                                 const gchar* data_name,
                                                 GearyMemoryBuffer* buffer)
{
	GearyMessageDataBlockMessageData * self = NULL;
	g_return_val_if_fail (data_name != NULL, NULL);
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (buffer), NULL);
	self = (GearyMessageDataBlockMessageData*) geary_message_data_abstract_message_data_construct (object_type);
	geary_message_data_block_message_data_set_data_name (self, data_name);
	geary_message_data_block_message_data_set_buffer (self, buffer);
	return self;
}

static gchar*
geary_message_data_block_message_data_real_to_string (GearyMessageDataAbstractMessageData* base)
{
	GearyMessageDataBlockMessageData * self;
	const gchar* _tmp0_;
	GearyMemoryBuffer* _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, GearyMessageDataBlockMessageData);
	_tmp0_ = self->priv->_data_name;
	_tmp1_ = self->priv->_buffer;
	_tmp2_ = geary_memory_buffer_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s (%lub)", _tmp0_, (gulong) _tmp3_);
	result = _tmp4_;
	return result;
}

static void
geary_message_data_block_message_data_class_init (GearyMessageDataBlockMessageDataClass * klass,
                                                  gpointer klass_data)
{
	geary_message_data_block_message_data_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyMessageDataBlockMessageData_private_offset);
	((GearyMessageDataAbstractMessageDataClass *) klass)->to_string = (gchar* (*) (GearyMessageDataAbstractMessageData*)) geary_message_data_block_message_data_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_message_data_block_message_data_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_message_data_block_message_data_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_message_data_block_message_data_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MESSAGE_DATA_BLOCK_MESSAGE_DATA_DATA_NAME_PROPERTY, geary_message_data_block_message_data_properties[GEARY_MESSAGE_DATA_BLOCK_MESSAGE_DATA_DATA_NAME_PROPERTY] = g_param_spec_string ("data-name", "data-name", "data-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MESSAGE_DATA_BLOCK_MESSAGE_DATA_BUFFER_PROPERTY, geary_message_data_block_message_data_properties[GEARY_MESSAGE_DATA_BLOCK_MESSAGE_DATA_BUFFER_PROPERTY] = g_param_spec_object ("buffer", "buffer", "buffer", GEARY_MEMORY_TYPE_BUFFER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_message_data_block_message_data_instance_init (GearyMessageDataBlockMessageData * self,
                                                     gpointer klass)
{
	self->priv = geary_message_data_block_message_data_get_instance_private (self);
}

static void
geary_message_data_block_message_data_finalize (GObject * obj)
{
	GearyMessageDataBlockMessageData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, GearyMessageDataBlockMessageData);
	_g_free0 (self->priv->_data_name);
	_g_object_unref0 (self->priv->_buffer);
	G_OBJECT_CLASS (geary_message_data_block_message_data_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_message_data_block_message_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyMessageDataBlockMessageDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_message_data_block_message_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyMessageDataBlockMessageData), 0, (GInstanceInitFunc) geary_message_data_block_message_data_instance_init, NULL };
	GType geary_message_data_block_message_data_type_id;
	geary_message_data_block_message_data_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, "GearyMessageDataBlockMessageData", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GearyMessageDataBlockMessageData_private_offset = g_type_add_instance_private (geary_message_data_block_message_data_type_id, sizeof (GearyMessageDataBlockMessageDataPrivate));
	return geary_message_data_block_message_data_type_id;
}

GType
geary_message_data_block_message_data_get_type (void)
{
	static gsize geary_message_data_block_message_data_type_id__once = 0;
	if (g_once_init_enter (&geary_message_data_block_message_data_type_id__once)) {
		GType geary_message_data_block_message_data_type_id;
		geary_message_data_block_message_data_type_id = geary_message_data_block_message_data_get_type_once ();
		g_once_init_leave (&geary_message_data_block_message_data_type_id__once, geary_message_data_block_message_data_type_id);
	}
	return geary_message_data_block_message_data_type_id__once;
}

static void
_vala_geary_message_data_block_message_data_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	GearyMessageDataBlockMessageData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, GearyMessageDataBlockMessageData);
	switch (property_id) {
		case GEARY_MESSAGE_DATA_BLOCK_MESSAGE_DATA_DATA_NAME_PROPERTY:
		g_value_set_string (value, geary_message_data_block_message_data_get_data_name (self));
		break;
		case GEARY_MESSAGE_DATA_BLOCK_MESSAGE_DATA_BUFFER_PROPERTY:
		g_value_set_object (value, geary_message_data_block_message_data_get_buffer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_message_data_block_message_data_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec)
{
	GearyMessageDataBlockMessageData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, GearyMessageDataBlockMessageData);
	switch (property_id) {
		case GEARY_MESSAGE_DATA_BLOCK_MESSAGE_DATA_DATA_NAME_PROPERTY:
		geary_message_data_block_message_data_set_data_name (self, g_value_get_string (value));
		break;
		case GEARY_MESSAGE_DATA_BLOCK_MESSAGE_DATA_BUFFER_PROPERTY:
		geary_message_data_block_message_data_set_buffer (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

