/* gitg-ref-action-merge.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-ref-action-merge.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include "libgitg-ext.h"
#include "libgitg.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <libgit2-glib/ggit.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <gee.h>

#define GITG_REF_ACTION_MERGE_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_REF_ACTION_MERGE (gitg_ref_action_merge_get_type ())
#define GITG_REF_ACTION_MERGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF_ACTION_MERGE, GitgRefActionMerge))
#define GITG_REF_ACTION_MERGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REF_ACTION_MERGE, GitgRefActionMergeClass))
#define GITG_IS_REF_ACTION_MERGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF_ACTION_MERGE))
#define GITG_IS_REF_ACTION_MERGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REF_ACTION_MERGE))
#define GITG_REF_ACTION_MERGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REF_ACTION_MERGE, GitgRefActionMergeClass))

typedef struct _GitgRefActionMerge GitgRefActionMerge;
typedef struct _GitgRefActionMergeClass GitgRefActionMergeClass;
typedef struct _GitgRefActionMergePrivate GitgRefActionMergePrivate;

#define GITG_REF_ACTION_MERGE_TYPE_REMOTE_SOURCE (gitg_ref_action_merge_remote_source_get_type ())
typedef struct _GitgRefActionMergeRemoteSource GitgRefActionMergeRemoteSource;

#define GITG_TYPE_ACTION_SUPPORT (gitg_action_support_get_type ())
#define GITG_ACTION_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_ACTION_SUPPORT, GitgActionSupport))
#define GITG_ACTION_SUPPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_ACTION_SUPPORT, GitgActionSupportClass))
#define GITG_IS_ACTION_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_ACTION_SUPPORT))
#define GITG_IS_ACTION_SUPPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_ACTION_SUPPORT))
#define GITG_ACTION_SUPPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_ACTION_SUPPORT, GitgActionSupportClass))

typedef struct _GitgActionSupport GitgActionSupport;
typedef struct _GitgActionSupportClass GitgActionSupportClass;
enum  {
	GITG_REF_ACTION_MERGE_0_PROPERTY,
	GITG_REF_ACTION_MERGE_APPLICATION_PROPERTY,
	GITG_REF_ACTION_MERGE_ACTION_INTERFACE_PROPERTY,
	GITG_REF_ACTION_MERGE_REFERENCE_PROPERTY,
	GITG_REF_ACTION_MERGE_ID_PROPERTY,
	GITG_REF_ACTION_MERGE_DISPLAY_NAME_PROPERTY,
	GITG_REF_ACTION_MERGE_DESCRIPTION_PROPERTY,
	GITG_REF_ACTION_MERGE_AVAILABLE_PROPERTY,
	GITG_REF_ACTION_MERGE_ENABLED_PROPERTY,
	GITG_REF_ACTION_MERGE_NUM_PROPERTIES
};
static GParamSpec* gitg_ref_action_merge_properties[GITG_REF_ACTION_MERGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TYPE_SIMPLE_NOTIFICATION (gitg_simple_notification_get_type ())
#define GITG_SIMPLE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotification))
#define GITG_SIMPLE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotificationClass))
#define GITG_IS_SIMPLE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_SIMPLE_NOTIFICATION))
#define GITG_IS_SIMPLE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_SIMPLE_NOTIFICATION))
#define GITG_SIMPLE_NOTIFICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotificationClass))

typedef struct _GitgSimpleNotification GitgSimpleNotification;
typedef struct _GitgSimpleNotificationClass GitgSimpleNotificationClass;
typedef struct _Block9Data Block9Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GgitMergeOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitMergeOptions_free (var), NULL)))
typedef struct _GitgRefActionMergeCreateMergeIndexData GitgRefActionMergeCreateMergeIndexData;
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _ggit_index_entry_unref0(var) ((var == NULL) ? NULL : (var = (ggit_index_entry_unref (var), NULL)))
#define _ggit_index_entries_unref0(var) ((var == NULL) ? NULL : (var = (ggit_index_entries_unref (var), NULL)))
typedef struct _GitgRefActionMergeCheckoutConflictsData GitgRefActionMergeCheckoutConflictsData;
typedef struct _GitgRefActionMergeMergeData GitgRefActionMergeMergeData;
typedef struct _Block10Data Block10Data;

struct _GitgRefActionMerge {
	GObject parent_instance;
	GitgRefActionMergePrivate * priv;
};

struct _GitgRefActionMergeClass {
	GObjectClass parent_class;
};

struct _GitgRefActionMergeRemoteSource {
	gchar* name;
	GitgRef** sources;
	gint sources_length1;
	gint _sources_size_;
};

struct _GitgRefActionMergePrivate {
	GitgExtApplication* _application;
	GitgExtRefActionInterface* _action_interface;
	GitgRef* _reference;
	gboolean d_has_sourced;
	GitgRef* d_upstream;
	GitgRef** d_local_sources;
	gint d_local_sources_length1;
	gint _d_local_sources_size_;
	GitgRefActionMergeRemoteSource* d_remote_sources;
	gint d_remote_sources_length1;
	gint _d_remote_sources_size_;
	GitgRef** d_tag_sources;
	gint d_tag_sources_length1;
	gint _d_tag_sources_size_;
	GitgActionSupport* d_support;
};

struct _Block9Data {
	int _ref_count_;
	GitgRefActionMerge* self;
	GgitIndex* index;
	GitgSimpleNotification* notification;
	GgitCommit* ours;
	GgitCommit* theirs;
	gpointer _async_data_;
};

struct _GitgRefActionMergeCreateMergeIndexData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgRefActionMerge* self;
	GitgSimpleNotification* notification;
	GgitCommit* ours;
	GgitCommit* theirs;
	GgitIndex* result;
	Block9Data* _data9_;
	GgitIndex* _tmp0_;
};

struct _GitgRefActionMergeCheckoutConflictsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgRefActionMerge* self;
	GitgSimpleNotification* notification;
	GgitIndex* index;
	GitgRef* source;
	gboolean result;
	gchar* ours_name;
	GitgRef* _tmp0_;
	GitgRef* _tmp1_;
	GitgParsedRefName* _tmp2_;
	GitgParsedRefName* _tmp3_;
	GitgParsedRefName* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* theirs_name;
	GitgParsedRefName* _tmp8_;
	GitgParsedRefName* _tmp9_;
	GitgParsedRefName* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GitgRef* head;
	gboolean ishead;
	GitgActionSupport* _tmp14_;
	GitgRef* _tmp15_;
	GitgRef* _tmp16_;
	gboolean _tmp17_;
	gchar* message;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	GitgExtUserQuery* q;
	const gchar* _tmp25_;
	GitgExtUserQuery* _tmp26_;
	GitgExtApplication* _tmp27_;
	GitgExtApplication* _tmp28_;
	GitgExtApplication* _tmp29_;
	GitgExtUserQuery* _tmp30_;
	gboolean _tmp31_;
	GitgActionSupport* _tmp32_;
	GitgRef* _tmp33_;
	GitgRef* _tmp34_;
	GitgRef* _tmp35_;
};

struct _GitgRefActionMergeMergeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgRefActionMerge* self;
	GitgRef* source;
	GgitOId* result;
	GgitCommit* ours;
	GgitCommit* theirs;
	gchar* ours_name;
	GitgRef* _tmp0_;
	GitgRef* _tmp1_;
	GitgParsedRefName* _tmp2_;
	GitgParsedRefName* _tmp3_;
	GitgParsedRefName* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* theirs_name;
	GitgParsedRefName* _tmp8_;
	GitgParsedRefName* _tmp9_;
	GitgParsedRefName* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GitgSimpleNotification* notification;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GitgSimpleNotification* _tmp18_;
	GitgSimpleNotification* _tmp19_;
	GitgExtApplication* _tmp20_;
	GitgExtApplication* _tmp21_;
	GitgExtApplication* _tmp22_;
	GitgExtNotifications* _tmp23_;
	GitgExtNotifications* _tmp24_;
	GitgExtNotifications* _tmp25_;
	GitgSimpleNotification* _tmp26_;
	GgitRef* _tmp27_;
	GitgRef* _tmp28_;
	GitgRef* _tmp29_;
	GgitRef* _tmp30_;
	GgitObject* _tmp31_;
	GgitObject* _tmp32_;
	GgitCommit* _tmp33_;
	GError* e;
	GitgSimpleNotification* _tmp34_;
	GError* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GgitRef* _tmp39_;
	GgitRef* _tmp40_;
	GgitObject* _tmp41_;
	GgitObject* _tmp42_;
	GgitCommit* _tmp43_;
	GError* _vala1_e;
	GitgSimpleNotification* _tmp44_;
	GError* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GgitIndex* index;
	GitgSimpleNotification* _tmp49_;
	GgitCommit* _tmp50_;
	GgitCommit* _tmp51_;
	GgitIndex* _tmp52_;
	GgitIndex* _tmp53_;
	GgitIndex* _tmp54_;
	GitgSimpleNotification* _tmp55_;
	GgitIndex* _tmp56_;
	gchar* msg;
	GitgParsedRefName* _tmp57_;
	GitgParsedRefName* _tmp58_;
	GitgParsedRefName* _tmp59_;
	GitgRefType _tmp60_;
	GitgRefType _tmp61_;
	gboolean _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	const gchar* _tmp66_;
	const gchar* _tmp67_;
	gchar* _tmp68_;
	GgitOId* oid;
	GitgActionSupport* _tmp69_;
	GitgSimpleNotification* _tmp70_;
	GitgRef* _tmp71_;
	GitgRef* _tmp72_;
	GgitIndex* _tmp73_;
	GgitCommit* _tmp74_;
	GgitOId* _tmp75_;
	GgitCommit* _tmp76_;
	GgitOId* _tmp77_;
	GgitOId** _tmp78_;
	const gchar* _tmp79_;
	GgitOId* _tmp80_;
	GgitOId* _tmp81_;
	GitgSimpleNotification* _tmp82_;
	const gchar* _tmp83_;
	const gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	GError* _inner_error0_;
};

struct _Block10Data {
	int _ref_count_;
	GitgRefActionMerge* self;
	GitgRef* source;
};

static gint GitgRefActionMerge_private_offset;
static gpointer gitg_ref_action_merge_parent_class = NULL;
static GitgExtUIElementIface * gitg_ref_action_merge_gitg_ext_ui_element_parent_iface = NULL;
static GitgExtActionIface * gitg_ref_action_merge_gitg_ext_action_parent_iface = NULL;
static GitgExtRefActionIface * gitg_ref_action_merge_gitg_ext_ref_action_parent_iface = NULL;

VALA_EXTERN GType gitg_ref_action_merge_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgRefActionMerge, g_object_unref)
static GType gitg_ref_action_merge_remote_source_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GitgRefActionMergeRemoteSource* gitg_ref_action_merge_remote_source_dup (const GitgRefActionMergeRemoteSource* self);
static void gitg_ref_action_merge_remote_source_free (GitgRefActionMergeRemoteSource* self);
static void gitg_ref_action_merge_remote_source_copy (const GitgRefActionMergeRemoteSource* self,
                                               GitgRefActionMergeRemoteSource* dest);
static void gitg_ref_action_merge_remote_source_destroy (GitgRefActionMergeRemoteSource* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GitgRefActionMergeRemoteSource, gitg_ref_action_merge_remote_source_destroy)
VALA_EXTERN GType gitg_action_support_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgActionSupport, g_object_unref)
static void _vala_GitgRefActionMergeRemoteSource_array_free (GitgRefActionMergeRemoteSource * array,
                                                      gssize array_length);
VALA_EXTERN GitgRefActionMerge* gitg_ref_action_merge_new (GitgExtApplication* application,
                                               GitgExtRefActionInterface* action_interface,
                                               GitgRef* reference);
VALA_EXTERN GitgRefActionMerge* gitg_ref_action_merge_construct (GType object_type,
                                                     GitgExtApplication* application,
                                                     GitgExtRefActionInterface* action_interface,
                                                     GitgRef* reference);
VALA_EXTERN GitgActionSupport* gitg_action_support_new (GitgExtApplication* application,
                                            GitgExtRefActionInterface* action_interface);
VALA_EXTERN GitgActionSupport* gitg_action_support_construct (GType object_type,
                                                  GitgExtApplication* application,
                                                  GitgExtRefActionInterface* action_interface);
static void gitg_ref_action_merge_create_merge_index_data_free (gpointer _data);
VALA_EXTERN GType gitg_simple_notification_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgSimpleNotification, g_object_unref)
static void gitg_ref_action_merge_create_merge_index (GitgRefActionMerge* self,
                                               GitgSimpleNotification* notification,
                                               GgitCommit* ours,
                                               GgitCommit* theirs,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static GgitIndex* gitg_ref_action_merge_create_merge_index_finish (GitgRefActionMerge* self,
                                                            GAsyncResult* _res_);
static gboolean gitg_ref_action_merge_create_merge_index_co (GitgRefActionMergeCreateMergeIndexData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda23_ (Block9Data* _data9_,
                  GError** error);
VALA_EXTERN void gitg_simple_notification_error (GitgSimpleNotification* self,
                                     const gchar* message);
static void _vala_GgitMergeOptions_free (GgitMergeOptions* self);
static void ___lambda23__gitg_async_thread_func (gpointer self,
                                          GError** error);
static void gitg_ref_action_merge_create_merge_index_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void gitg_ref_action_merge_write_merge_state_files (GitgRefActionMerge* self,
                                                    GgitIndex* index,
                                                    GitgRef* source);
static void _vala_GgitOId_free (GgitOId* self);
static void gitg_ref_action_merge_checkout_conflicts_data_free (gpointer _data);
static void gitg_ref_action_merge_checkout_conflicts (GitgRefActionMerge* self,
                                               GitgSimpleNotification* notification,
                                               GgitIndex* index,
                                               GitgRef* source,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean gitg_ref_action_merge_checkout_conflicts_finish (GitgRefActionMerge* self,
                                                          GAsyncResult* _res_);
static gboolean gitg_ref_action_merge_checkout_conflicts_co (GitgRefActionMergeCheckoutConflictsData* _data_);
VALA_EXTERN void gitg_simple_notification_set_message (GitgSimpleNotification* self,
                                           const gchar* value);
VALA_EXTERN gboolean gitg_action_support_reference_is_head (GitgActionSupport* self,
                                                GitgRef* reference,
                                                GitgRef** head);
static void gitg_ref_action_merge_checkout_conflicts_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
VALA_EXTERN void gitg_action_support_checkout_conflicts (GitgActionSupport* self,
                                             GitgSimpleNotification* notification,
                                             GitgRef* reference,
                                             GgitIndex* index,
                                             GitgRef* head,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN gboolean gitg_action_support_checkout_conflicts_finish (GitgActionSupport* self,
                                                        GAsyncResult* _res_);
VALA_EXTERN void gitg_simple_notification_success (GitgSimpleNotification* self,
                                       const gchar* message);
static void gitg_ref_action_merge_merge_data_free (gpointer _data);
VALA_EXTERN void gitg_ref_action_merge_merge (GitgRefActionMerge* self,
                                  GitgRef* source,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN GgitOId* gitg_ref_action_merge_merge_finish (GitgRefActionMerge* self,
                                             GAsyncResult* _res_);
static gboolean gitg_ref_action_merge_merge_co (GitgRefActionMergeMergeData* _data_);
VALA_EXTERN GitgSimpleNotification* gitg_simple_notification_new (const gchar* title,
                                                      const gchar* message);
VALA_EXTERN GitgSimpleNotification* gitg_simple_notification_construct (GType object_type,
                                                            const gchar* title,
                                                            const gchar* message);
static void gitg_ref_action_merge_merge_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
VALA_EXTERN void gitg_action_support_commit_index (GitgActionSupport* self,
                                       GitgSimpleNotification* notification,
                                       GitgRef* reference,
                                       GgitIndex* index,
                                       GgitOId** parents,
                                       gint parents_length1,
                                       GgitSignature* author,
                                       const gchar* message,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN GgitOId* gitg_action_support_commit_index_finish (GitgActionSupport* self,
                                                  GAsyncResult* _res_);
VALA_EXTERN void gitg_ref_action_merge_activate_source (GitgRefActionMerge* self,
                                            GitgRef* source);
static void __lambda24_ (GitgRefActionMerge* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda24__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static GitgRef* gitg_ref_action_merge_upstream_reference (GitgRefActionMerge* self);
static void gitg_ref_action_merge_add_merge_source (GitgRefActionMerge* self,
                                             GtkMenu* submenu,
                                             GitgRef* source);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda25_ (Block10Data* _data10_);
static void ___lambda25__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void gitg_ref_action_merge_ensure_sources (GitgRefActionMerge* self);
static void _vala_array_add2 (GitgRef** * array,
                       gint* length,
                       gint* size,
                       GitgRef* value);
static void _vala_array_add3 (GitgRef** * array,
                       gint* length,
                       gint* size,
                       GitgRef* value);
static void _vala_array_add4 (GitgRefActionMergeRemoteSource* * array,
                       gint* length,
                       gint* size,
                       const GitgRefActionMergeRemoteSource* value);
static void _vala_array_add5 (GitgRef** * array,
                       gint* length,
                       gint* size,
                       GitgRef* value);
static void gitg_ref_action_merge_real_populate_menu (GitgExtAction* base,
                                               GtkMenu* menu);
static GitgRef** _vala_array_dup1 (GitgRef** self,
                            gssize length);
static void gitg_ref_action_merge_finalize (GObject * obj);
static GType gitg_ref_action_merge_get_type_once (void);
static void _vala_gitg_ref_action_merge_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_gitg_ref_action_merge_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gitg_ref_action_merge_get_instance_private (GitgRefActionMerge* self)
{
	return G_STRUCT_MEMBER_P (self, GitgRefActionMerge_private_offset);
}

static void
_vala_GitgRefActionMergeRemoteSource_array_free (GitgRefActionMergeRemoteSource * array,
                                                 gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			gitg_ref_action_merge_remote_source_destroy (&array[i]);
		}
	}
	g_free (array);
}

GitgRefActionMerge*
gitg_ref_action_merge_construct (GType object_type,
                                 GitgExtApplication* application,
                                 GitgExtRefActionInterface* action_interface,
                                 GitgRef* reference)
{
	GitgRefActionMerge * self = NULL;
	GitgActionSupport* _tmp0_;
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (action_interface != NULL, NULL);
	g_return_val_if_fail (reference != NULL, NULL);
	self = (GitgRefActionMerge*) g_object_new (object_type, "application", application, "action-interface", action_interface, "reference", reference, NULL);
	_tmp0_ = gitg_action_support_new (application, action_interface);
	_g_object_unref0 (self->priv->d_support);
	self->priv->d_support = _tmp0_;
	return self;
}

GitgRefActionMerge*
gitg_ref_action_merge_new (GitgExtApplication* application,
                           GitgExtRefActionInterface* action_interface,
                           GitgRef* reference)
{
	return gitg_ref_action_merge_construct (GITG_TYPE_REF_ACTION_MERGE, application, action_interface, reference);
}

static void
gitg_ref_action_merge_create_merge_index_data_free (gpointer _data)
{
	GitgRefActionMergeCreateMergeIndexData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgRefActionMergeCreateMergeIndexData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gitg_ref_action_merge_create_merge_index (GitgRefActionMerge* self,
                                          GitgSimpleNotification* notification,
                                          GgitCommit* ours,
                                          GgitCommit* theirs,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GitgRefActionMergeCreateMergeIndexData* _data_;
	GitgRefActionMerge* _tmp0_;
	GitgSimpleNotification* _tmp1_;
	GgitCommit* _tmp2_;
	GgitCommit* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	g_return_if_fail (ours != NULL);
	g_return_if_fail (theirs != NULL);
	_data_ = g_slice_new0 (GitgRefActionMergeCreateMergeIndexData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_ref_action_merge_create_merge_index_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (notification);
	_g_object_unref0 (_data_->notification);
	_data_->notification = _tmp1_;
	_tmp2_ = _g_object_ref0 (ours);
	_g_object_unref0 (_data_->ours);
	_data_->ours = _tmp2_;
	_tmp3_ = _g_object_ref0 (theirs);
	_g_object_unref0 (_data_->theirs);
	_data_->theirs = _tmp3_;
	gitg_ref_action_merge_create_merge_index_co (_data_);
}

static GgitIndex*
gitg_ref_action_merge_create_merge_index_finish (GitgRefActionMerge* self,
                                                 GAsyncResult* _res_)
{
	GgitIndex* result;
	GitgRefActionMergeCreateMergeIndexData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		GitgRefActionMerge* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->index);
		_g_object_unref0 (_data9_->notification);
		_g_object_unref0 (_data9_->ours);
		_g_object_unref0 (_data9_->theirs);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
_vala_GgitMergeOptions_free (GgitMergeOptions* self)
{
	g_boxed_free (ggit_merge_options_get_type (), self);
}

static void
__lambda23_ (Block9Data* _data9_,
             GError** error)
{
	GitgRefActionMerge* self;
	GgitMergeOptions* options = NULL;
	GgitMergeOptions* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = _data9_->self;
	_tmp0_ = ggit_merge_options_new ();
	options = _tmp0_;
	{
		GgitIndex* _tmp1_ = NULL;
		GitgExtApplication* _tmp2_;
		GitgExtApplication* _tmp3_;
		GitgExtApplication* _tmp4_;
		GitgRepository* _tmp5_;
		GitgRepository* _tmp6_;
		GitgRepository* _tmp7_;
		GgitMergeOptions* _tmp8_;
		GgitIndex* _tmp9_;
		GgitIndex* _tmp10_;
		GgitIndex* _tmp11_;
		_tmp2_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gitg_ext_application_get_repository (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = options;
		_tmp9_ = ggit_repository_merge_commits ((GgitRepository*) _tmp7_, _data9_->ours, _data9_->theirs, _tmp8_, &_inner_error0_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp4_);
		_tmp1_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (_data9_->index);
		_data9_->index = _tmp11_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		_tmp14_ = g_strdup_printf (_ ("Failed to merge commits: %s"), _tmp13_);
		_tmp15_ = _tmp14_;
		gitg_simple_notification_error (_data9_->notification, _tmp15_);
		_g_free0 (_tmp15_);
		_g_error_free0 (e);
		__vala_GgitMergeOptions_free0 (options);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		__vala_GgitMergeOptions_free0 (options);
		return;
	}
	__vala_GgitMergeOptions_free0 (options);
}

static void
___lambda23__gitg_async_thread_func (gpointer self,
                                     GError** error)
{
	__lambda23_ (self, error);
}

static void
gitg_ref_action_merge_create_merge_index_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	GitgRefActionMergeCreateMergeIndexData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_ref_action_merge_create_merge_index_co (_data_);
}

static gboolean
gitg_ref_action_merge_create_merge_index_co (GitgRefActionMergeCreateMergeIndexData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data9_ = g_slice_new0 (Block9Data);
	_data_->_data9_->_ref_count_ = 1;
	_data_->_data9_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data9_->notification);
	_data_->_data9_->notification = _data_->notification;
	_g_object_unref0 (_data_->_data9_->ours);
	_data_->_data9_->ours = _data_->ours;
	_g_object_unref0 (_data_->_data9_->theirs);
	_data_->_data9_->theirs = _data_->theirs;
	_data_->_data9_->_async_data_ = _data_;
	_data_->_data9_->index = NULL;
	_data_->_state_ = 1;
	gitg_async_thread_try (___lambda23__gitg_async_thread_func, _data_->_data9_, gitg_ref_action_merge_create_merge_index_ready, _data_);
	return FALSE;
	_state_1:
	gitg_async_thread_try_finish (_data_->_res_);
	_data_->_tmp0_ = _g_object_ref0 (_data_->_data9_->index);
	_data_->result = _data_->_tmp0_;
	block9_data_unref (_data_->_data9_);
	_data_->_data9_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
gitg_ref_action_merge_write_merge_state_files (GitgRefActionMerge* self,
                                               GgitIndex* index,
                                               GitgRef* source)
{
	gchar* wd = NULL;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	GitgExtApplication* _tmp2_;
	GitgRepository* _tmp3_;
	GitgRepository* _tmp4_;
	GitgRepository* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* theirs_name = NULL;
	GitgParsedRefName* _tmp10_;
	GitgParsedRefName* _tmp11_;
	GitgParsedRefName* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (index != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gitg_ext_application_get_repository (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = ggit_repository_get_location ((GgitRepository*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_file_get_path (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp2_);
	wd = _tmp9_;
	_tmp10_ = gitg_ref_get_parsed_name (source);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp13_ = gitg_parsed_ref_name_get_shortname (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_;
	_g_object_unref0 (_tmp12_);
	theirs_name = _tmp15_;
	{
		GgitRef* _tmp16_ = NULL;
		GitgRef* _tmp17_;
		GitgRef* _tmp18_;
		GgitRef* _tmp19_;
		GgitOId* dest_oid = NULL;
		GgitOId* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GgitOId* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp17_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = ggit_ref_resolve ((GgitRef*) _tmp18_, &_inner_error0_);
		_tmp16_ = _tmp19_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp20_ = ggit_ref_get_target (_tmp16_);
		dest_oid = _tmp20_;
		_tmp21_ = wd;
		_tmp22_ = g_build_filename (_tmp21_, "ORIG_HEAD", NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = dest_oid;
		_tmp25_ = ggit_oid_to_string (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strdup_printf ("%s\n", _tmp26_);
		_tmp28_ = _tmp27_;
		g_file_set_contents (_tmp23_, _tmp28_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp23_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			__vala_GgitOId_free0 (dest_oid);
			_g_object_unref0 (_tmp16_);
			goto __catch0_g_error;
		}
		__vala_GgitOId_free0 (dest_oid);
		_g_object_unref0 (_tmp16_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (theirs_name);
		_g_free0 (wd);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GgitRef* _tmp29_ = NULL;
		GgitRef* _tmp30_;
		GgitOId* source_oid = NULL;
		GgitOId* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		GgitOId* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp30_ = ggit_ref_resolve ((GgitRef*) source, &_inner_error0_);
		_tmp29_ = _tmp30_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp31_ = ggit_ref_get_target (_tmp29_);
		source_oid = _tmp31_;
		_tmp32_ = wd;
		_tmp33_ = g_build_filename (_tmp32_, "MERGE_HEAD", NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = source_oid;
		_tmp36_ = ggit_oid_to_string (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strdup_printf ("%s\n", _tmp37_);
		_tmp39_ = _tmp38_;
		g_file_set_contents (_tmp34_, _tmp39_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp34_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			__vala_GgitOId_free0 (source_oid);
			_g_object_unref0 (_tmp29_);
			goto __catch1_g_error;
		}
		__vala_GgitOId_free0 (source_oid);
		_g_object_unref0 (_tmp29_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (theirs_name);
		_g_free0 (wd);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp40_ = wd;
		_tmp41_ = g_build_filename (_tmp40_, "MERGE_MODE", NULL);
		_tmp42_ = _tmp41_;
		g_file_set_contents (_tmp42_, "no-ff\n", (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp42_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (theirs_name);
		_g_free0 (wd);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		gchar* msg = NULL;
		GitgParsedRefName* _tmp43_;
		GitgParsedRefName* _tmp44_;
		GitgParsedRefName* _tmp45_;
		GitgRefType _tmp46_;
		GitgRefType _tmp47_;
		gboolean _tmp48_;
		const gchar* _tmp55_;
		gchar* _tmp56_;
		GgitIndexEntries* entries = NULL;
		GgitIndexEntries* _tmp57_;
		GeeHashSet* seen = NULL;
		GeeHashSet* _tmp58_;
		const gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		const gchar* _tmp81_;
		_tmp43_ = gitg_ref_get_parsed_name (source);
		_tmp44_ = _tmp43_;
		_tmp45_ = _tmp44_;
		_tmp46_ = gitg_parsed_ref_name_get_rtype (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = _tmp47_ == GITG_REF_TYPE_REMOTE;
		_g_object_unref0 (_tmp45_);
		if (_tmp48_) {
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			gchar* _tmp51_;
			_tmp49_ = theirs_name;
			_tmp50_ = string_to_string (_tmp49_);
			_tmp51_ = g_strconcat ("Merge remote branch “", _tmp50_, "”", NULL);
			_g_free0 (msg);
			msg = _tmp51_;
		} else {
			const gchar* _tmp52_;
			const gchar* _tmp53_;
			gchar* _tmp54_;
			_tmp52_ = theirs_name;
			_tmp53_ = string_to_string (_tmp52_);
			_tmp54_ = g_strconcat ("Merge branch “", _tmp53_, "”", NULL);
			_g_free0 (msg);
			msg = _tmp54_;
		}
		_tmp55_ = msg;
		_tmp56_ = g_strconcat (_tmp55_, "\n\nConflicts:\n", NULL);
		_g_free0 (msg);
		msg = _tmp56_;
		_tmp57_ = ggit_index_get_entries (index);
		entries = _tmp57_;
		_tmp58_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
		seen = _tmp58_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp59_ = FALSE;
				_tmp59_ = TRUE;
				while (TRUE) {
					GgitIndexEntries* _tmp61_;
					GgitIndexEntry* entry = NULL;
					GgitIndexEntries* _tmp62_;
					GgitIndexEntry* _tmp63_;
					gchar* p = NULL;
					GgitIndexEntry* _tmp64_;
					const gchar* _tmp65_;
					gchar* _tmp66_;
					gboolean _tmp67_ = FALSE;
					GgitIndexEntry* _tmp68_;
					if (!_tmp59_) {
						gint _tmp60_;
						_tmp60_ = i;
						i = _tmp60_ + 1;
					}
					_tmp59_ = FALSE;
					_tmp61_ = entries;
					if (!(((guint) i) < ggit_index_entries_size (_tmp61_))) {
						break;
					}
					_tmp62_ = entries;
					_tmp63_ = ggit_index_entries_get_by_index (_tmp62_, (gsize) i);
					entry = _tmp63_;
					_tmp64_ = entry;
					_tmp65_ = ggit_index_entry_get_path (_tmp64_);
					_tmp66_ = g_strdup (_tmp65_);
					p = _tmp66_;
					_tmp68_ = entry;
					if (ggit_index_entry_is_conflict (_tmp68_)) {
						GeeHashSet* _tmp69_;
						const gchar* _tmp70_;
						_tmp69_ = seen;
						_tmp70_ = p;
						_tmp67_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp69_, _tmp70_);
					} else {
						_tmp67_ = FALSE;
					}
					if (_tmp67_) {
						const gchar* _tmp71_;
						const gchar* _tmp72_;
						gchar* _tmp73_;
						gchar* _tmp74_;
						gchar* _tmp75_;
						GeeHashSet* _tmp76_;
						const gchar* _tmp77_;
						_tmp71_ = msg;
						_tmp72_ = p;
						_tmp73_ = g_strdup_printf ("\t%s\n", _tmp72_);
						_tmp74_ = _tmp73_;
						_tmp75_ = g_strconcat (_tmp71_, _tmp74_, NULL);
						_g_free0 (msg);
						msg = _tmp75_;
						_g_free0 (_tmp74_);
						_tmp76_ = seen;
						_tmp77_ = p;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp76_, _tmp77_);
					}
					_g_free0 (p);
					_ggit_index_entry_unref0 (entry);
				}
			}
		}
		_tmp78_ = wd;
		_tmp79_ = g_build_filename (_tmp78_, "MERGE_MSG", NULL);
		_tmp80_ = _tmp79_;
		_tmp81_ = msg;
		g_file_set_contents (_tmp80_, _tmp81_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp80_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (seen);
			_ggit_index_entries_unref0 (entries);
			_g_free0 (msg);
			goto __catch3_g_error;
		}
		_g_object_unref0 (seen);
		_ggit_index_entries_unref0 (entries);
		_g_free0 (msg);
	}
	goto __finally3;
	__catch3_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (theirs_name);
		_g_free0 (wd);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (theirs_name);
	_g_free0 (wd);
}

static void
gitg_ref_action_merge_checkout_conflicts_data_free (gpointer _data)
{
	GitgRefActionMergeCheckoutConflictsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->notification);
	_g_object_unref0 (_data_->index);
	_g_object_unref0 (_data_->source);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgRefActionMergeCheckoutConflictsData, _data_);
}

static void
gitg_ref_action_merge_checkout_conflicts (GitgRefActionMerge* self,
                                          GitgSimpleNotification* notification,
                                          GgitIndex* index,
                                          GitgRef* source,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GitgRefActionMergeCheckoutConflictsData* _data_;
	GitgRefActionMerge* _tmp0_;
	GitgSimpleNotification* _tmp1_;
	GgitIndex* _tmp2_;
	GitgRef* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	g_return_if_fail (index != NULL);
	g_return_if_fail (source != NULL);
	_data_ = g_slice_new0 (GitgRefActionMergeCheckoutConflictsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_ref_action_merge_checkout_conflicts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (notification);
	_g_object_unref0 (_data_->notification);
	_data_->notification = _tmp1_;
	_tmp2_ = _g_object_ref0 (index);
	_g_object_unref0 (_data_->index);
	_data_->index = _tmp2_;
	_tmp3_ = _g_object_ref0 (source);
	_g_object_unref0 (_data_->source);
	_data_->source = _tmp3_;
	gitg_ref_action_merge_checkout_conflicts_co (_data_);
}

static gboolean
gitg_ref_action_merge_checkout_conflicts_finish (GitgRefActionMerge* self,
                                                 GAsyncResult* _res_)
{
	gboolean result;
	GitgRefActionMergeCheckoutConflictsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
gitg_ref_action_merge_checkout_conflicts_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	GitgRefActionMergeCheckoutConflictsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_ref_action_merge_checkout_conflicts_co (_data_);
}

static gboolean
gitg_ref_action_merge_checkout_conflicts_co (GitgRefActionMergeCheckoutConflictsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = gitg_ref_get_parsed_name (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = gitg_parsed_ref_name_get_shortname (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = _data_->_tmp6_;
	_g_object_unref0 (_data_->_tmp4_);
	_data_->ours_name = _data_->_tmp7_;
	_data_->_tmp8_ = gitg_ref_get_parsed_name (_data_->source);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = gitg_parsed_ref_name_get_shortname (_data_->_tmp10_);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = _data_->_tmp12_;
	_g_object_unref0 (_data_->_tmp10_);
	_data_->theirs_name = _data_->_tmp13_;
	gitg_simple_notification_set_message (_data_->notification, _ ("Merge has conflicts"));
	_data_->head = NULL;
	_data_->_tmp14_ = _data_->self->priv->d_support;
	_data_->_tmp15_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) _data_->self);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = gitg_action_support_reference_is_head (_data_->_tmp14_, _data_->_tmp16_, &_data_->head);
	_data_->ishead = _data_->_tmp17_;
	if (_data_->ishead) {
		_data_->_tmp18_ = _data_->theirs_name;
		_data_->_tmp19_ = _data_->ours_name;
		_data_->_tmp20_ = _data_->ours_name;
		_data_->_tmp21_ = g_strdup_printf (_ ("The merge of “%s” into “%s” has caused conflicts, would you like to ch" \
"eckout branch “%s” with the merge to your working directory to resolve" \
" the conflicts?"), _data_->_tmp18_, _data_->_tmp19_, _data_->_tmp20_);
		_g_free0 (_data_->message);
		_data_->message = _data_->_tmp21_;
	} else {
		_data_->_tmp22_ = _data_->theirs_name;
		_data_->_tmp23_ = _data_->ours_name;
		_data_->_tmp24_ = g_strdup_printf (_ ("The merge of “%s” into “%s” has caused conflicts, would you like to ch" \
"eckout the merge to your working directory to resolve the conflicts?"), _data_->_tmp22_, _data_->_tmp23_);
		_g_free0 (_data_->message);
		_data_->message = _data_->_tmp24_;
	}
	_data_->_tmp25_ = _data_->message;
	_data_->_tmp26_ = gitg_ext_user_query_new_full (_ ("Merge has conflicts"), _data_->_tmp25_, GTK_MESSAGE_QUESTION, _ ("Cancel"), GTK_RESPONSE_CANCEL, _ ("Checkout"), GTK_RESPONSE_OK, NULL);
	_data_->q = _data_->_tmp26_;
	_data_->_tmp27_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) _data_->self);
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_tmp29_ = _data_->_tmp28_;
	_data_->_tmp30_ = _data_->q;
	_data_->_state_ = 1;
	gitg_ext_application_user_query_async (_data_->_tmp29_, _data_->_tmp30_, gitg_ref_action_merge_checkout_conflicts_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp31_ = gitg_ext_application_user_query_finish (_data_->_tmp29_, _data_->_res_) != GTK_RESPONSE_OK;
	_g_object_unref0 (_data_->_tmp29_);
	if (_data_->_tmp31_) {
		gitg_simple_notification_error (_data_->notification, _ ("Merge failed with conflicts"));
		_data_->result = FALSE;
		_g_object_unref0 (_data_->q);
		_g_free0 (_data_->message);
		_g_object_unref0 (_data_->head);
		_g_free0 (_data_->theirs_name);
		_g_free0 (_data_->ours_name);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp32_ = _data_->self->priv->d_support;
	_data_->_tmp33_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) _data_->self);
	_data_->_tmp34_ = _data_->_tmp33_;
	_data_->_tmp35_ = _data_->head;
	_data_->_state_ = 2;
	gitg_action_support_checkout_conflicts (_data_->_tmp32_, _data_->notification, _data_->_tmp34_, _data_->index, _data_->_tmp35_, gitg_ref_action_merge_checkout_conflicts_ready, _data_);
	return FALSE;
	_state_2:
	if (!gitg_action_support_checkout_conflicts_finish (_data_->_tmp32_, _data_->_res_)) {
		_data_->result = FALSE;
		_g_object_unref0 (_data_->q);
		_g_free0 (_data_->message);
		_g_object_unref0 (_data_->head);
		_g_free0 (_data_->theirs_name);
		_g_free0 (_data_->ours_name);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	gitg_ref_action_merge_write_merge_state_files (_data_->self, _data_->index, _data_->source);
	gitg_simple_notification_success (_data_->notification, _ ("Finished merge with conflicts in working directory"));
	_data_->result = TRUE;
	_g_object_unref0 (_data_->q);
	_g_free0 (_data_->message);
	_g_object_unref0 (_data_->head);
	_g_free0 (_data_->theirs_name);
	_g_free0 (_data_->ours_name);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_ref_action_merge_merge_data_free (gpointer _data)
{
	GitgRefActionMergeMergeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->source);
	__vala_GgitOId_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgRefActionMergeMergeData, _data_);
}

void
gitg_ref_action_merge_merge (GitgRefActionMerge* self,
                             GitgRef* source,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	GitgRefActionMergeMergeData* _data_;
	GitgRefActionMerge* _tmp0_;
	GitgRef* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_data_ = g_slice_new0 (GitgRefActionMergeMergeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_ref_action_merge_merge_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (source);
	_g_object_unref0 (_data_->source);
	_data_->source = _tmp1_;
	gitg_ref_action_merge_merge_co (_data_);
}

GgitOId*
gitg_ref_action_merge_merge_finish (GitgRefActionMerge* self,
                                    GAsyncResult* _res_)
{
	GgitOId* result;
	GitgRefActionMergeMergeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
gitg_ref_action_merge_merge_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	GitgRefActionMergeMergeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_ref_action_merge_merge_co (_data_);
}

static gboolean
gitg_ref_action_merge_merge_co (GitgRefActionMergeMergeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = gitg_ref_get_parsed_name (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = gitg_parsed_ref_name_get_shortname (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = _data_->_tmp6_;
	_g_object_unref0 (_data_->_tmp4_);
	_data_->ours_name = _data_->_tmp7_;
	_data_->_tmp8_ = gitg_ref_get_parsed_name (_data_->source);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = gitg_parsed_ref_name_get_shortname (_data_->_tmp10_);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = _data_->_tmp12_;
	_g_object_unref0 (_data_->_tmp10_);
	_data_->theirs_name = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->theirs_name;
	_data_->_tmp15_ = _data_->ours_name;
	_data_->_tmp16_ = g_strdup_printf (_ ("Merge “%s” into “%s”"), _data_->_tmp14_, _data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	_data_->_tmp18_ = gitg_simple_notification_new (_data_->_tmp17_, NULL);
	g_object_ref_sink (_data_->_tmp18_);
	_data_->_tmp19_ = _data_->_tmp18_;
	_g_free0 (_data_->_tmp17_);
	_data_->notification = _data_->_tmp19_;
	_data_->_tmp20_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) _data_->self);
	_data_->_tmp21_ = _data_->_tmp20_;
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = gitg_ext_application_get_notifications (_data_->_tmp22_);
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = _data_->_tmp24_;
	_data_->_tmp26_ = _data_->notification;
	gitg_ext_notifications_add (_data_->_tmp25_, (GitgExtNotification*) _data_->_tmp26_);
	_g_object_unref0 (_data_->_tmp25_);
	_g_object_unref0 (_data_->_tmp22_);
	{
		_data_->_tmp28_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) _data_->self);
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->_tmp30_ = ggit_ref_resolve ((GgitRef*) _data_->_tmp29_, &_data_->_inner_error0_);
		_data_->_tmp27_ = _data_->_tmp30_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp32_ = ggit_ref_lookup (_data_->_tmp27_, &_data_->_inner_error0_);
		_data_->_tmp31_ = _data_->_tmp32_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp27_);
			goto __catch0_g_error;
		}
		_data_->_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp31_, ggit_commit_get_type ()) ? ((GgitCommit*) _data_->_tmp31_) : NULL);
		_g_object_unref0 (_data_->ours);
		_data_->ours = _data_->_tmp33_;
		_g_object_unref0 (_data_->_tmp31_);
		_g_object_unref0 (_data_->_tmp27_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp34_ = _data_->notification;
		_data_->_tmp35_ = _data_->e;
		_data_->_tmp36_ = _data_->_tmp35_->message;
		_data_->_tmp37_ = g_strdup_printf (_ ("Failed to lookup our commit: %s"), _data_->_tmp36_);
		_data_->_tmp38_ = _data_->_tmp37_;
		gitg_simple_notification_error (_data_->_tmp34_, _data_->_tmp38_);
		_g_free0 (_data_->_tmp38_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->notification);
		_g_free0 (_data_->theirs_name);
		_g_free0 (_data_->ours_name);
		_g_object_unref0 (_data_->theirs);
		_g_object_unref0 (_data_->ours);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->notification);
		_g_free0 (_data_->theirs_name);
		_g_free0 (_data_->ours_name);
		_g_object_unref0 (_data_->theirs);
		_g_object_unref0 (_data_->ours);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp40_ = ggit_ref_resolve ((GgitRef*) _data_->source, &_data_->_inner_error0_);
		_data_->_tmp39_ = _data_->_tmp40_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_data_->_tmp42_ = ggit_ref_lookup (_data_->_tmp39_, &_data_->_inner_error0_);
		_data_->_tmp41_ = _data_->_tmp42_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp39_);
			goto __catch1_g_error;
		}
		_data_->_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp41_, ggit_commit_get_type ()) ? ((GgitCommit*) _data_->_tmp41_) : NULL);
		_g_object_unref0 (_data_->theirs);
		_data_->theirs = _data_->_tmp43_;
		_g_object_unref0 (_data_->_tmp41_);
		_g_object_unref0 (_data_->_tmp39_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp44_ = _data_->notification;
		_data_->_tmp45_ = _data_->_vala1_e;
		_data_->_tmp46_ = _data_->_tmp45_->message;
		_data_->_tmp47_ = g_strdup_printf (_ ("Failed to lookup their commit: %s"), _data_->_tmp46_);
		_data_->_tmp48_ = _data_->_tmp47_;
		gitg_simple_notification_error (_data_->_tmp44_, _data_->_tmp48_);
		_g_free0 (_data_->_tmp48_);
		_data_->result = NULL;
		_g_error_free0 (_data_->_vala1_e);
		_g_object_unref0 (_data_->notification);
		_g_free0 (_data_->theirs_name);
		_g_free0 (_data_->ours_name);
		_g_object_unref0 (_data_->theirs);
		_g_object_unref0 (_data_->ours);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->notification);
		_g_free0 (_data_->theirs_name);
		_g_free0 (_data_->ours_name);
		_g_object_unref0 (_data_->theirs);
		_g_object_unref0 (_data_->ours);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp49_ = _data_->notification;
	_data_->_tmp50_ = _data_->ours;
	_data_->_tmp51_ = _data_->theirs;
	_data_->_state_ = 1;
	gitg_ref_action_merge_create_merge_index (_data_->self, _data_->_tmp49_, _data_->_tmp50_, _data_->_tmp51_, gitg_ref_action_merge_merge_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp52_ = gitg_ref_action_merge_create_merge_index_finish (_data_->self, _data_->_res_);
	_data_->index = _data_->_tmp52_;
	_data_->_tmp53_ = _data_->index;
	if (_data_->_tmp53_ == NULL) {
		_data_->result = NULL;
		_g_object_unref0 (_data_->index);
		_g_object_unref0 (_data_->notification);
		_g_free0 (_data_->theirs_name);
		_g_free0 (_data_->ours_name);
		_g_object_unref0 (_data_->theirs);
		_g_object_unref0 (_data_->ours);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp54_ = _data_->index;
	if (ggit_index_has_conflicts (_data_->_tmp54_)) {
		_data_->_tmp55_ = _data_->notification;
		_data_->_tmp56_ = _data_->index;
		_data_->_state_ = 2;
		gitg_ref_action_merge_checkout_conflicts (_data_->self, _data_->_tmp55_, _data_->_tmp56_, _data_->source, gitg_ref_action_merge_merge_ready, _data_);
		return FALSE;
		_state_2:
		gitg_ref_action_merge_checkout_conflicts_finish (_data_->self, _data_->_res_);
		_data_->result = NULL;
		_g_object_unref0 (_data_->index);
		_g_object_unref0 (_data_->notification);
		_g_free0 (_data_->theirs_name);
		_g_free0 (_data_->ours_name);
		_g_object_unref0 (_data_->theirs);
		_g_object_unref0 (_data_->ours);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp57_ = gitg_ref_get_parsed_name (_data_->source);
	_data_->_tmp58_ = _data_->_tmp57_;
	_data_->_tmp59_ = _data_->_tmp58_;
	_data_->_tmp60_ = gitg_parsed_ref_name_get_rtype (_data_->_tmp59_);
	_data_->_tmp61_ = _data_->_tmp60_;
	_data_->_tmp62_ = _data_->_tmp61_ == GITG_REF_TYPE_REMOTE;
	_g_object_unref0 (_data_->_tmp59_);
	if (_data_->_tmp62_) {
		_data_->_tmp63_ = _data_->theirs_name;
		_data_->_tmp64_ = string_to_string (_data_->_tmp63_);
		_data_->_tmp65_ = g_strconcat ("Merge remote branch “", _data_->_tmp64_, "”", NULL);
		_g_free0 (_data_->msg);
		_data_->msg = _data_->_tmp65_;
	} else {
		_data_->_tmp66_ = _data_->theirs_name;
		_data_->_tmp67_ = string_to_string (_data_->_tmp66_);
		_data_->_tmp68_ = g_strconcat ("Merge branch “", _data_->_tmp67_, "”", NULL);
		_g_free0 (_data_->msg);
		_data_->msg = _data_->_tmp68_;
	}
	_data_->_tmp69_ = _data_->self->priv->d_support;
	_data_->_tmp70_ = _data_->notification;
	_data_->_tmp71_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) _data_->self);
	_data_->_tmp72_ = _data_->_tmp71_;
	_data_->_tmp73_ = _data_->index;
	_data_->_tmp74_ = _data_->ours;
	_data_->_tmp75_ = ggit_object_get_id ((GgitObject*) _data_->_tmp74_);
	_data_->_tmp76_ = _data_->theirs;
	_data_->_tmp77_ = ggit_object_get_id ((GgitObject*) _data_->_tmp76_);
	_data_->_tmp78_ = g_new0 (GgitOId*, 2 + 1);
	_data_->_tmp78_[0] = _data_->_tmp75_;
	_data_->_tmp78_[1] = _data_->_tmp77_;
	_data_->_tmp79_ = _data_->msg;
	_data_->_state_ = 3;
	gitg_action_support_commit_index (_data_->_tmp69_, _data_->_tmp70_, _data_->_tmp72_, _data_->_tmp73_, _data_->_tmp78_, (gint) 2, NULL, _data_->_tmp79_, gitg_ref_action_merge_merge_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp80_ = gitg_action_support_commit_index_finish (_data_->_tmp69_, _data_->_res_);
	_data_->oid = _data_->_tmp80_;
	_data_->_tmp81_ = _data_->oid;
	if (_data_->_tmp81_ != NULL) {
		_data_->_tmp82_ = _data_->notification;
		_data_->_tmp83_ = _data_->theirs_name;
		_data_->_tmp84_ = _data_->ours_name;
		_data_->_tmp85_ = g_strdup_printf (_ ("Successfully merged “%s” into “%s”"), _data_->_tmp83_, _data_->_tmp84_);
		_data_->_tmp86_ = _data_->_tmp85_;
		gitg_simple_notification_success (_data_->_tmp82_, _data_->_tmp86_);
		_g_free0 (_data_->_tmp86_);
	}
	_data_->result = _data_->oid;
	_g_free0 (_data_->msg);
	_g_object_unref0 (_data_->index);
	_g_object_unref0 (_data_->notification);
	_g_free0 (_data_->theirs_name);
	_g_free0 (_data_->ours_name);
	_g_object_unref0 (_data_->theirs);
	_g_object_unref0 (_data_->ours);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
__lambda24_ (GitgRefActionMerge* self,
             GObject* obj,
             GAsyncResult* res)
{
	GgitOId* _tmp0_;
	GgitOId* _tmp1_;
	g_return_if_fail (res != NULL);
	_tmp0_ = gitg_ref_action_merge_merge_finish (self, res);
	_tmp1_ = _tmp0_;
	__vala_GgitOId_free0 (_tmp1_);
}

static void
___lambda24__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda24_ ((GitgRefActionMerge*) self, source_object, res);
	g_object_unref (self);
}

void
gitg_ref_action_merge_activate_source (GitgRefActionMerge* self,
                                       GitgRef* source)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	gitg_ref_action_merge_merge (self, source, ___lambda24__gasync_ready_callback, g_object_ref (self));
}

static GitgRef*
gitg_ref_action_merge_upstream_reference (GitgRefActionMerge* self)
{
	GgitBranch* branch = NULL;
	GitgRef* _tmp0_;
	GitgRef* _tmp1_;
	GgitBranch* _tmp2_;
	GgitBranch* _tmp3_;
	GError* _inner_error0_ = NULL;
	GitgRef* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, ggit_branch_get_type ()) ? ((GgitBranch*) _tmp1_) : NULL);
	branch = _tmp2_;
	_tmp3_ = branch;
	if (_tmp3_ != NULL) {
		{
			GgitRef* _tmp4_ = NULL;
			GgitBranch* _tmp5_;
			GgitRef* _tmp6_;
			GitgRef* _tmp7_;
			_tmp5_ = branch;
			_tmp6_ = ggit_branch_get_upstream (_tmp5_, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GITG_TYPE_REF) ? ((GitgRef*) _tmp4_) : NULL);
			result = _tmp7_;
			_g_object_unref0 (_tmp4_);
			_g_object_unref0 (branch);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (branch);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = NULL;
	_g_object_unref0 (branch);
	return result;
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		GitgRefActionMerge* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->source);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda25_ (Block10Data* _data10_)
{
	GitgRefActionMerge* self;
	self = _data10_->self;
	gitg_ref_action_merge_activate_source (self, _data10_->source);
}

static void
___lambda25__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda25_ (self);
}

static void
gitg_ref_action_merge_add_merge_source (GitgRefActionMerge* self,
                                        GtkMenu* submenu,
                                        GitgRef* source)
{
	Block10Data* _data10_;
	GitgRef* _tmp0_;
	gchar* name = NULL;
	GitgParsedRefName* _tmp4_;
	GitgParsedRefName* _tmp5_;
	GitgParsedRefName* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GtkMenuItem* item = NULL;
	const gchar* _tmp10_;
	GtkMenuItem* _tmp11_;
	GtkMenuItem* _tmp12_;
	GtkMenuItem* _tmp13_;
	const gchar* _tmp14_;
	GitgRef* _tmp15_;
	GitgRef* _tmp16_;
	GitgParsedRefName* _tmp17_;
	GitgParsedRefName* _tmp18_;
	GitgParsedRefName* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GtkMenuItem* _tmp25_;
	GtkMenuItem* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (submenu != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data10_->source);
	_data10_->source = _tmp0_;
	if (_data10_->source == NULL) {
		GtkSeparatorMenuItem* sep = NULL;
		GtkSeparatorMenuItem* _tmp1_;
		GtkSeparatorMenuItem* _tmp2_;
		GtkSeparatorMenuItem* _tmp3_;
		_tmp1_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp1_);
		sep = _tmp1_;
		_tmp2_ = sep;
		gtk_widget_show ((GtkWidget*) _tmp2_);
		_tmp3_ = sep;
		gtk_menu_shell_append ((GtkMenuShell*) submenu, (GtkMenuItem*) _tmp3_);
		_g_object_unref0 (sep);
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return;
	}
	_tmp4_ = gitg_ref_get_parsed_name (_data10_->source);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = gitg_parsed_ref_name_get_shortname (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp6_);
	name = _tmp9_;
	_tmp10_ = name;
	_tmp11_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp10_);
	g_object_ref_sink (_tmp11_);
	item = _tmp11_;
	_tmp12_ = item;
	gtk_widget_show ((GtkWidget*) _tmp12_);
	_tmp13_ = item;
	_tmp14_ = name;
	_tmp15_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
	_tmp16_ = _tmp15_;
	_tmp17_ = gitg_ref_get_parsed_name (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp20_ = gitg_parsed_ref_name_get_shortname (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strdup_printf (_ ("Merge “%s” into branch “%s”"), _tmp14_, _tmp22_);
	_tmp24_ = _tmp23_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp13_, _tmp24_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	_g_object_unref0 (_tmp19_);
	_tmp25_ = item;
	g_signal_connect_data (_tmp25_, "activate", (GCallback) ___lambda25__gtk_menu_item_activate, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp26_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) submenu, _tmp26_);
	_g_object_unref0 (item);
	_g_free0 (name);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static void
_vala_array_add2 (GitgRef** * array,
                  gint* length,
                  gint* size,
                  GitgRef* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GitgRef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (GitgRef** * array,
                  gint* length,
                  gint* size,
                  GitgRef* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GitgRef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (GitgRefActionMergeRemoteSource* * array,
                  gint* length,
                  gint* size,
                  const GitgRefActionMergeRemoteSource* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GitgRefActionMergeRemoteSource, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add5 (GitgRef** * array,
                  gint* length,
                  gint* size,
                  GitgRef* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GitgRef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
gitg_ref_action_merge_ensure_sources (GitgRefActionMerge* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GitgRef* _tmp2_;
	GitgRef** _tmp3_;
	GitgRefActionMergeRemoteSource* _tmp4_;
	GitgRef** _tmp5_;
	GgitOId* target_oid = NULL;
	gchar* last_remote = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->d_has_sourced) {
		return;
	}
	self->priv->d_has_sourced = TRUE;
	_tmp0_ = gitg_ext_ui_element_get_available ((GitgExtUIElement*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gitg_ref_action_merge_upstream_reference (self);
	_g_object_unref0 (self->priv->d_upstream);
	self->priv->d_upstream = _tmp2_;
	_tmp3_ = g_new0 (GitgRef*, 0 + 1);
	self->priv->d_local_sources = (_vala_array_free (self->priv->d_local_sources, self->priv->d_local_sources_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_local_sources = _tmp3_;
	self->priv->d_local_sources_length1 = 0;
	self->priv->_d_local_sources_size_ = self->priv->d_local_sources_length1;
	_tmp4_ = g_new0 (GitgRefActionMergeRemoteSource, 0);
	self->priv->d_remote_sources = (_vala_GitgRefActionMergeRemoteSource_array_free (self->priv->d_remote_sources, self->priv->d_remote_sources_length1), NULL);
	self->priv->d_remote_sources = _tmp4_;
	self->priv->d_remote_sources_length1 = 0;
	self->priv->_d_remote_sources_size_ = self->priv->d_remote_sources_length1;
	_tmp5_ = g_new0 (GitgRef*, 0 + 1);
	self->priv->d_tag_sources = (_vala_array_free (self->priv->d_tag_sources, self->priv->d_tag_sources_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_tag_sources = _tmp5_;
	self->priv->d_tag_sources_length1 = 0;
	self->priv->_d_tag_sources_size_ = self->priv->d_tag_sources_length1;
	target_oid = NULL;
	{
		GgitRef* _tmp6_ = NULL;
		GitgRef* _tmp7_;
		GitgRef* _tmp8_;
		GgitRef* _tmp9_;
		GgitOId* _tmp10_;
		_tmp7_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = ggit_ref_resolve ((GgitRef*) _tmp8_, &_inner_error0_);
		_tmp6_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = ggit_ref_get_target (_tmp6_);
		__vala_GgitOId_free0 (target_oid);
		target_oid = _tmp10_;
		_g_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		__vala_GgitOId_free0 (target_oid);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	last_remote = NULL;
	{
		GeeList* _r_list = NULL;
		GitgExtRefActionInterface* _tmp11_;
		GitgExtRefActionInterface* _tmp12_;
		GeeList* _tmp13_;
		GeeList* _tmp14_;
		gint _r_size = 0;
		GeeList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _r_index = 0;
		_tmp11_ = gitg_ext_ref_action_get_action_interface ((GitgExtRefAction*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = gitg_ext_ref_action_interface_get_references (_tmp12_);
		_tmp14_ = _tmp13_;
		_r_list = _tmp14_;
		_tmp15_ = _r_list;
		_tmp16_ = gee_collection_get_size ((GeeCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_r_size = _tmp17_;
		_r_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			GitgRef* r = NULL;
			GeeList* _tmp20_;
			gpointer _tmp21_;
			gboolean _tmp22_ = FALSE;
			GitgRef* _tmp23_;
			GgitOId* _tmp28_;
			GitgRef* _tmp37_;
			_r_index = _r_index + 1;
			_tmp18_ = _r_index;
			_tmp19_ = _r_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _r_list;
			_tmp21_ = gee_list_get (_tmp20_, _r_index);
			r = (GitgRef*) _tmp21_;
			_tmp23_ = self->priv->d_upstream;
			if (_tmp23_ != NULL) {
				GitgRef* _tmp24_;
				const gchar* _tmp25_;
				GitgRef* _tmp26_;
				const gchar* _tmp27_;
				_tmp24_ = r;
				_tmp25_ = ggit_ref_get_name ((GgitRef*) _tmp24_);
				_tmp26_ = self->priv->d_upstream;
				_tmp27_ = ggit_ref_get_name ((GgitRef*) _tmp26_);
				_tmp22_ = g_strcmp0 (_tmp25_, _tmp27_) == 0;
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				_g_object_unref0 (r);
				continue;
			}
			_tmp28_ = target_oid;
			if (_tmp28_ != NULL) {
				GgitOId* oid = NULL;
				gboolean _tmp33_ = FALSE;
				GgitOId* _tmp34_;
				oid = NULL;
				{
					GgitRef* _tmp29_ = NULL;
					GitgRef* _tmp30_;
					GgitRef* _tmp31_;
					GgitOId* _tmp32_;
					_tmp30_ = r;
					_tmp31_ = ggit_ref_resolve ((GgitRef*) _tmp30_, &_inner_error0_);
					_tmp29_ = _tmp31_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
					_tmp32_ = ggit_ref_get_target (_tmp29_);
					__vala_GgitOId_free0 (oid);
					oid = _tmp32_;
					_g_object_unref0 (_tmp29_);
				}
				goto __finally1;
				__catch1_g_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					__vala_GgitOId_free0 (oid);
					_g_object_unref0 (r);
					_g_object_unref0 (_r_list);
					_g_free0 (last_remote);
					__vala_GgitOId_free0 (target_oid);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp34_ = oid;
				if (_tmp34_ != NULL) {
					GgitOId* _tmp35_;
					GgitOId* _tmp36_;
					_tmp35_ = oid;
					_tmp36_ = target_oid;
					_tmp33_ = ggit_oid_equal (_tmp35_, _tmp36_);
				} else {
					_tmp33_ = FALSE;
				}
				if (_tmp33_) {
					__vala_GgitOId_free0 (oid);
					_g_object_unref0 (r);
					continue;
				}
				__vala_GgitOId_free0 (oid);
			}
			_tmp37_ = r;
			if (ggit_ref_is_branch ((GgitRef*) _tmp37_)) {
				GitgRef* _tmp38_;
				GitgRef* _tmp39_;
				_tmp38_ = r;
				_tmp39_ = _g_object_ref0 (_tmp38_);
				_vala_array_add2 (&self->priv->d_local_sources, &self->priv->d_local_sources_length1, &self->priv->_d_local_sources_size_, _tmp39_);
			} else {
				GitgRef* _tmp40_;
				_tmp40_ = r;
				if (ggit_ref_is_tag ((GgitRef*) _tmp40_)) {
					GitgRef* _tmp41_;
					GitgRef* _tmp42_;
					_tmp41_ = r;
					_tmp42_ = _g_object_ref0 (_tmp41_);
					_vala_array_add3 (&self->priv->d_tag_sources, &self->priv->d_tag_sources_length1, &self->priv->_d_tag_sources_size_, _tmp42_);
				} else {
					GitgRef* _tmp43_;
					GitgParsedRefName* _tmp44_;
					GitgParsedRefName* _tmp45_;
					GitgParsedRefName* _tmp46_;
					GitgRefType _tmp47_;
					GitgRefType _tmp48_;
					gboolean _tmp49_;
					_tmp43_ = r;
					_tmp44_ = gitg_ref_get_parsed_name (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = _tmp45_;
					_tmp47_ = gitg_parsed_ref_name_get_rtype (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = _tmp48_ == GITG_REF_TYPE_REMOTE;
					_g_object_unref0 (_tmp46_);
					if (_tmp49_) {
						gchar* remote_name = NULL;
						GitgRef* _tmp50_;
						GitgParsedRefName* _tmp51_;
						GitgParsedRefName* _tmp52_;
						GitgParsedRefName* _tmp53_;
						gchar* _tmp54_;
						gchar* _tmp55_;
						gchar* _tmp56_;
						const gchar* _tmp57_;
						const gchar* _tmp58_;
						const gchar* _tmp74_;
						gchar* _tmp75_;
						_tmp50_ = r;
						_tmp51_ = gitg_ref_get_parsed_name (_tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = _tmp52_;
						_tmp54_ = gitg_parsed_ref_name_get_remote_name (_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = _tmp55_;
						_g_object_unref0 (_tmp53_);
						remote_name = _tmp56_;
						_tmp57_ = remote_name;
						_tmp58_ = last_remote;
						if (g_strcmp0 (_tmp57_, _tmp58_) != 0) {
							GitgRefActionMergeRemoteSource source = {0};
							const gchar* _tmp59_;
							gchar* _tmp60_;
							GitgRef* _tmp61_;
							GitgRef* _tmp62_;
							GitgRef** _tmp63_;
							GitgRefActionMergeRemoteSource _tmp64_ = {0};
							GitgRefActionMergeRemoteSource _tmp65_;
							GitgRefActionMergeRemoteSource _tmp66_;
							GitgRefActionMergeRemoteSource _tmp67_ = {0};
							_tmp59_ = remote_name;
							_tmp60_ = g_strdup (_tmp59_);
							_tmp61_ = r;
							_tmp62_ = _g_object_ref0 (_tmp61_);
							_tmp63_ = g_new0 (GitgRef*, 1 + 1);
							_tmp63_[0] = _tmp62_;
							memset (&_tmp64_, 0, sizeof (GitgRefActionMergeRemoteSource));
							_g_free0 (_tmp64_.name);
							_tmp64_.name = _tmp60_;
							_tmp64_.sources = (_vala_array_free (_tmp64_.sources, _tmp64_.sources_length1, (GDestroyNotify) g_object_unref), NULL);
							_tmp64_.sources = _tmp63_;
							_tmp64_.sources_length1 = 1;
							_tmp64_._sources_size_ = _tmp64_.sources_length1;
							source = _tmp64_;
							_tmp65_ = source;
							_tmp66_ = _tmp65_;
							gitg_ref_action_merge_remote_source_copy (&_tmp66_, &_tmp67_);
							_vala_array_add4 (&self->priv->d_remote_sources, &self->priv->d_remote_sources_length1, &self->priv->_d_remote_sources_size_, &_tmp67_);
							gitg_ref_action_merge_remote_source_destroy (&source);
						} else {
							GitgRefActionMergeRemoteSource* _tmp68_;
							gint _tmp68__length1;
							GitgRefActionMergeRemoteSource* _tmp69_;
							gint _tmp69__length1;
							GitgRefActionMergeRemoteSource* _tmp70_;
							gint _tmp70__length1;
							GitgRefActionMergeRemoteSource* _tmp71_;
							gint _tmp71__length1;
							GitgRef* _tmp72_;
							GitgRef* _tmp73_;
							_tmp68_ = self->priv->d_remote_sources;
							_tmp68__length1 = self->priv->d_remote_sources_length1;
							_tmp69_ = self->priv->d_remote_sources;
							_tmp69__length1 = self->priv->d_remote_sources_length1;
							_tmp70_ = self->priv->d_remote_sources;
							_tmp70__length1 = self->priv->d_remote_sources_length1;
							_tmp71_ = self->priv->d_remote_sources;
							_tmp71__length1 = self->priv->d_remote_sources_length1;
							_tmp72_ = r;
							_tmp73_ = _g_object_ref0 (_tmp72_);
							_vala_array_add5 (&_tmp68_[_tmp69__length1 - 1].sources, &_tmp68_[_tmp69__length1 - 1].sources_length1, &_tmp68_[_tmp69__length1 - 1]._sources_size_, _tmp73_);
						}
						_tmp74_ = remote_name;
						_tmp75_ = g_strdup (_tmp74_);
						_g_free0 (last_remote);
						last_remote = _tmp75_;
						_g_free0 (remote_name);
					}
				}
			}
			_g_object_unref0 (r);
		}
		_g_object_unref0 (_r_list);
	}
	_g_free0 (last_remote);
	__vala_GgitOId_free0 (target_oid);
}

static void
gitg_ref_action_merge_real_populate_menu (GitgExtAction* base,
                                          GtkMenu* menu)
{
	GitgRefActionMerge * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkMenuItem* item = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkMenuItem* _tmp5_;
	GtkMenuItem* _tmp6_;
	GtkMenuItem* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GtkMenuItem* _tmp70_;
	GtkMenuItem* _tmp71_;
	self = (GitgRefActionMerge*) base;
	g_return_if_fail (menu != NULL);
	_tmp0_ = gitg_ext_ui_element_get_available ((GitgExtUIElement*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gitg_ext_ui_element_get_display_name ((GitgExtUIElement*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	item = _tmp6_;
	_tmp7_ = item;
	_tmp8_ = gitg_ext_ui_element_get_description ((GitgExtUIElement*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp7_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = gitg_ext_ui_element_get_enabled ((GitgExtUIElement*) self);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		GtkMenu* submenu = NULL;
		GtkMenu* _tmp13_;
		GtkMenu* _tmp14_;
		GitgRef* _tmp15_;
		GitgRef** _tmp18_;
		gint _tmp18__length1;
		GitgRefActionMergeRemoteSource* _tmp25_;
		gint _tmp25__length1;
		GitgRef** _tmp48_;
		gint _tmp48__length1;
		GtkMenuItem* _tmp67_;
		GtkMenu* _tmp68_;
		_tmp13_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp13_);
		submenu = _tmp13_;
		_tmp14_ = submenu;
		gtk_widget_show ((GtkWidget*) _tmp14_);
		_tmp15_ = self->priv->d_upstream;
		if (_tmp15_ != NULL) {
			GtkMenu* _tmp16_;
			GitgRef* _tmp17_;
			_tmp16_ = submenu;
			_tmp17_ = self->priv->d_upstream;
			gitg_ref_action_merge_add_merge_source (self, _tmp16_, _tmp17_);
		}
		_tmp18_ = self->priv->d_local_sources;
		_tmp18__length1 = self->priv->d_local_sources_length1;
		if (_tmp18__length1 != 0) {
			GitgRef* _tmp19_;
			GitgRef** _tmp21_;
			gint _tmp21__length1;
			_tmp19_ = self->priv->d_upstream;
			if (_tmp19_ != NULL) {
				GtkMenu* _tmp20_;
				_tmp20_ = submenu;
				gitg_ref_action_merge_add_merge_source (self, _tmp20_, NULL);
			}
			_tmp21_ = self->priv->d_local_sources;
			_tmp21__length1 = self->priv->d_local_sources_length1;
			{
				GitgRef** source_collection = NULL;
				gint source_collection_length1 = 0;
				gint _source_collection_size_ = 0;
				gint source_it = 0;
				source_collection = _tmp21_;
				source_collection_length1 = _tmp21__length1;
				for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
					GitgRef* _tmp22_;
					GitgRef* source = NULL;
					_tmp22_ = _g_object_ref0 (source_collection[source_it]);
					source = _tmp22_;
					{
						GtkMenu* _tmp23_;
						GitgRef* _tmp24_;
						_tmp23_ = submenu;
						_tmp24_ = source;
						gitg_ref_action_merge_add_merge_source (self, _tmp23_, _tmp24_);
						_g_object_unref0 (source);
					}
				}
			}
		}
		_tmp25_ = self->priv->d_remote_sources;
		_tmp25__length1 = self->priv->d_remote_sources_length1;
		if (_tmp25__length1 != 0) {
			gboolean _tmp26_ = FALSE;
			GitgRef** _tmp27_;
			gint _tmp27__length1;
			GitgRefActionMergeRemoteSource* _tmp30_;
			gint _tmp30__length1;
			_tmp27_ = self->priv->d_local_sources;
			_tmp27__length1 = self->priv->d_local_sources_length1;
			if (_tmp27__length1 != 0) {
				_tmp26_ = TRUE;
			} else {
				GitgRef* _tmp28_;
				_tmp28_ = self->priv->d_upstream;
				_tmp26_ = _tmp28_ != NULL;
			}
			if (_tmp26_) {
				GtkMenu* _tmp29_;
				_tmp29_ = submenu;
				gitg_ref_action_merge_add_merge_source (self, _tmp29_, NULL);
			}
			_tmp30_ = self->priv->d_remote_sources;
			_tmp30__length1 = self->priv->d_remote_sources_length1;
			{
				GitgRefActionMergeRemoteSource* remote_collection = NULL;
				gint remote_collection_length1 = 0;
				gint _remote_collection_size_ = 0;
				gint remote_it = 0;
				remote_collection = _tmp30_;
				remote_collection_length1 = _tmp30__length1;
				for (remote_it = 0; remote_it < remote_collection_length1; remote_it = remote_it + 1) {
					GitgRefActionMergeRemoteSource _tmp31_;
					GitgRefActionMergeRemoteSource _tmp32_ = {0};
					GitgRefActionMergeRemoteSource remote = {0};
					_tmp31_ = remote_collection[remote_it];
					gitg_ref_action_merge_remote_source_copy (&_tmp31_, &_tmp32_);
					remote = _tmp32_;
					{
						GtkMenuItem* subitem = NULL;
						GitgRefActionMergeRemoteSource _tmp33_;
						const gchar* _tmp34_;
						GtkMenuItem* _tmp35_;
						GtkMenuItem* _tmp36_;
						GtkMenu* subsubmenu = NULL;
						GtkMenu* _tmp37_;
						GtkMenu* _tmp38_;
						GitgRefActionMergeRemoteSource _tmp39_;
						GitgRef** _tmp40_;
						gint _tmp40__length1;
						GtkMenuItem* _tmp44_;
						GtkMenu* _tmp45_;
						GtkMenu* _tmp46_;
						GtkMenuItem* _tmp47_;
						_tmp33_ = remote;
						_tmp34_ = _tmp33_.name;
						_tmp35_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp34_);
						g_object_ref_sink (_tmp35_);
						subitem = _tmp35_;
						_tmp36_ = subitem;
						gtk_widget_show ((GtkWidget*) _tmp36_);
						_tmp37_ = (GtkMenu*) gtk_menu_new ();
						g_object_ref_sink (_tmp37_);
						subsubmenu = _tmp37_;
						_tmp38_ = subsubmenu;
						gtk_widget_show ((GtkWidget*) _tmp38_);
						_tmp39_ = remote;
						_tmp40_ = _tmp39_.sources;
						_tmp40__length1 = _tmp39_.sources_length1;
						{
							GitgRef** source_collection = NULL;
							gint source_collection_length1 = 0;
							gint _source_collection_size_ = 0;
							gint source_it = 0;
							source_collection = _tmp40_;
							source_collection_length1 = _tmp40__length1;
							for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
								GitgRef* _tmp41_;
								GitgRef* source = NULL;
								_tmp41_ = _g_object_ref0 (source_collection[source_it]);
								source = _tmp41_;
								{
									GtkMenu* _tmp42_;
									GitgRef* _tmp43_;
									_tmp42_ = subsubmenu;
									_tmp43_ = source;
									gitg_ref_action_merge_add_merge_source (self, _tmp42_, _tmp43_);
									_g_object_unref0 (source);
								}
							}
						}
						_tmp44_ = subitem;
						_tmp45_ = subsubmenu;
						gtk_menu_item_set_submenu (_tmp44_, _tmp45_);
						_tmp46_ = submenu;
						_tmp47_ = subitem;
						gtk_menu_shell_append ((GtkMenuShell*) _tmp46_, _tmp47_);
						_g_object_unref0 (subsubmenu);
						_g_object_unref0 (subitem);
						gitg_ref_action_merge_remote_source_destroy (&remote);
					}
				}
			}
		}
		_tmp48_ = self->priv->d_tag_sources;
		_tmp48__length1 = self->priv->d_tag_sources_length1;
		if (_tmp48__length1 != 0) {
			gboolean _tmp49_ = FALSE;
			gboolean _tmp50_ = FALSE;
			GitgRefActionMergeRemoteSource* _tmp51_;
			gint _tmp51__length1;
			GtkMenuItem* subitem = NULL;
			GtkMenuItem* _tmp55_;
			GtkMenuItem* _tmp56_;
			GtkMenu* subsubmenu = NULL;
			GtkMenu* _tmp57_;
			GtkMenu* _tmp58_;
			GitgRef** _tmp59_;
			gint _tmp59__length1;
			GtkMenuItem* _tmp63_;
			GtkMenu* _tmp64_;
			GtkMenu* _tmp65_;
			GtkMenuItem* _tmp66_;
			_tmp51_ = self->priv->d_remote_sources;
			_tmp51__length1 = self->priv->d_remote_sources_length1;
			if (_tmp51__length1 != 0) {
				_tmp50_ = TRUE;
			} else {
				GitgRef** _tmp52_;
				gint _tmp52__length1;
				_tmp52_ = self->priv->d_local_sources;
				_tmp52__length1 = self->priv->d_local_sources_length1;
				_tmp50_ = _tmp52__length1 != 0;
			}
			if (_tmp50_) {
				_tmp49_ = TRUE;
			} else {
				GitgRef* _tmp53_;
				_tmp53_ = self->priv->d_upstream;
				_tmp49_ = _tmp53_ != NULL;
			}
			if (_tmp49_) {
				GtkMenu* _tmp54_;
				_tmp54_ = submenu;
				gitg_ref_action_merge_add_merge_source (self, _tmp54_, NULL);
			}
			_tmp55_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Tags"));
			g_object_ref_sink (_tmp55_);
			subitem = _tmp55_;
			_tmp56_ = subitem;
			gtk_widget_show ((GtkWidget*) _tmp56_);
			_tmp57_ = (GtkMenu*) gtk_menu_new ();
			g_object_ref_sink (_tmp57_);
			subsubmenu = _tmp57_;
			_tmp58_ = subsubmenu;
			gtk_widget_show ((GtkWidget*) _tmp58_);
			_tmp59_ = self->priv->d_tag_sources;
			_tmp59__length1 = self->priv->d_tag_sources_length1;
			{
				GitgRef** source_collection = NULL;
				gint source_collection_length1 = 0;
				gint _source_collection_size_ = 0;
				gint source_it = 0;
				source_collection = _tmp59_;
				source_collection_length1 = _tmp59__length1;
				for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
					GitgRef* _tmp60_;
					GitgRef* source = NULL;
					_tmp60_ = _g_object_ref0 (source_collection[source_it]);
					source = _tmp60_;
					{
						GtkMenu* _tmp61_;
						GitgRef* _tmp62_;
						_tmp61_ = subsubmenu;
						_tmp62_ = source;
						gitg_ref_action_merge_add_merge_source (self, _tmp61_, _tmp62_);
						_g_object_unref0 (source);
					}
				}
			}
			_tmp63_ = subitem;
			_tmp64_ = subsubmenu;
			gtk_menu_item_set_submenu (_tmp63_, _tmp64_);
			_tmp65_ = submenu;
			_tmp66_ = subitem;
			gtk_menu_shell_append ((GtkMenuShell*) _tmp65_, _tmp66_);
			_g_object_unref0 (subsubmenu);
			_g_object_unref0 (subitem);
		}
		_tmp67_ = item;
		_tmp68_ = submenu;
		gtk_menu_item_set_submenu (_tmp67_, _tmp68_);
		_g_object_unref0 (submenu);
	} else {
		GtkMenuItem* _tmp69_;
		_tmp69_ = item;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp69_, FALSE);
	}
	_tmp70_ = item;
	gtk_widget_show ((GtkWidget*) _tmp70_);
	_tmp71_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp71_);
	_g_object_unref0 (item);
}

static GitgExtApplication*
gitg_ref_action_merge_real_get_application (GitgExtUIElement* base)
{
	GitgExtApplication* result;
	GitgRefActionMerge* self;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	self = (GitgRefActionMerge*) base;
	_tmp0_ = self->priv->_application;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
gitg_ref_action_merge_real_set_application (GitgExtUIElement* base,
                                            GitgExtApplication* value)
{
	GitgRefActionMerge* self;
	GitgExtApplication* old_value;
	self = (GitgRefActionMerge*) base;
	old_value = gitg_ref_action_merge_real_get_application (base);
	if (old_value != value) {
		GitgExtApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_application);
		self->priv->_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_ref_action_merge_properties[GITG_REF_ACTION_MERGE_APPLICATION_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

static GitgExtRefActionInterface*
gitg_ref_action_merge_real_get_action_interface (GitgExtRefAction* base)
{
	GitgExtRefActionInterface* result;
	GitgRefActionMerge* self;
	GitgExtRefActionInterface* _tmp0_;
	self = (GitgRefActionMerge*) base;
	_tmp0_ = self->priv->_action_interface;
	result = _tmp0_;
	return result;
}

static void
gitg_ref_action_merge_real_set_action_interface (GitgExtRefAction* base,
                                                 GitgExtRefActionInterface* value)
{
	GitgRefActionMerge* self;
	GitgExtRefActionInterface* old_value;
	self = (GitgRefActionMerge*) base;
	old_value = gitg_ref_action_merge_real_get_action_interface (base);
	if (old_value != value) {
		GitgExtRefActionInterface* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_action_interface);
		self->priv->_action_interface = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_ref_action_merge_properties[GITG_REF_ACTION_MERGE_ACTION_INTERFACE_PROPERTY]);
	}
}

static GitgRef*
gitg_ref_action_merge_real_get_reference (GitgExtRefAction* base)
{
	GitgRef* result;
	GitgRefActionMerge* self;
	GitgRef* _tmp0_;
	self = (GitgRefActionMerge*) base;
	_tmp0_ = self->priv->_reference;
	result = _tmp0_;
	return result;
}

static void
gitg_ref_action_merge_real_set_reference (GitgExtRefAction* base,
                                          GitgRef* value)
{
	GitgRefActionMerge* self;
	GitgRef* old_value;
	self = (GitgRefActionMerge*) base;
	old_value = gitg_ref_action_merge_real_get_reference (base);
	if (old_value != value) {
		GitgRef* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_reference);
		self->priv->_reference = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_ref_action_merge_properties[GITG_REF_ACTION_MERGE_REFERENCE_PROPERTY]);
	}
}

static gchar*
gitg_ref_action_merge_real_get_id (GitgExtUIElement* base)
{
	gchar* result;
	GitgRefActionMerge* self;
	gchar* _tmp0_;
	self = (GitgRefActionMerge*) base;
	_tmp0_ = g_strdup ("/org/gnome/gitg/ref-actions/merge");
	result = _tmp0_;
	return result;
}

static gchar*
gitg_ref_action_merge_real_get_display_name (GitgExtUIElement* base)
{
	gchar* result;
	GitgRefActionMerge* self;
	GitgRef* _tmp0_;
	GitgRef* _tmp1_;
	GitgParsedRefName* _tmp2_;
	GitgParsedRefName* _tmp3_;
	GitgParsedRefName* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	self = (GitgRefActionMerge*) base;
	_tmp0_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gitg_ref_get_parsed_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = gitg_parsed_ref_name_get_shortname (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (_ ("Merge into %s"), _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_object_unref0 (_tmp4_);
	result = _tmp9_;
	return result;
}

static gchar*
gitg_ref_action_merge_real_get_description (GitgExtUIElement* base)
{
	gchar* result;
	GitgRefActionMerge* self;
	GitgRef* _tmp0_;
	GitgRef* _tmp1_;
	GitgParsedRefName* _tmp2_;
	GitgParsedRefName* _tmp3_;
	GitgParsedRefName* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	self = (GitgRefActionMerge*) base;
	_tmp0_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gitg_ref_get_parsed_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = gitg_parsed_ref_name_get_shortname (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (_ ("Merge another branch into branch %s"), _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_object_unref0 (_tmp4_);
	result = _tmp9_;
	return result;
}

static gboolean
gitg_ref_action_merge_real_get_available (GitgExtUIElement* base)
{
	gboolean result;
	GitgRefActionMerge* self;
	GitgRef* _tmp0_;
	GitgRef* _tmp1_;
	self = (GitgRefActionMerge*) base;
	_tmp0_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
	_tmp1_ = _tmp0_;
	result = ggit_ref_is_branch ((GgitRef*) _tmp1_);
	return result;
}

static gboolean
gitg_ref_action_merge_real_get_enabled (GitgExtUIElement* base)
{
	gboolean result;
	GitgRefActionMerge* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GitgRef* _tmp3_;
	self = (GitgRefActionMerge*) base;
	gitg_ref_action_merge_ensure_sources (self);
	_tmp3_ = self->priv->d_upstream;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		GitgRef** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = self->priv->d_local_sources;
		_tmp4__length1 = self->priv->d_local_sources_length1;
		_tmp2_ = _tmp4__length1 != 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GitgRefActionMergeRemoteSource* _tmp5_;
		gint _tmp5__length1;
		_tmp5_ = self->priv->d_remote_sources;
		_tmp5__length1 = self->priv->d_remote_sources_length1;
		_tmp1_ = _tmp5__length1 != 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GitgRef** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = self->priv->d_tag_sources;
		_tmp6__length1 = self->priv->d_tag_sources_length1;
		_tmp0_ = _tmp6__length1 != 0;
	}
	result = _tmp0_;
	return result;
}

static GitgRef**
_vala_array_dup1 (GitgRef** self,
                  gssize length)
{
	if (length >= 0) {
		GitgRef** result;
		gssize i;
		result = g_new0 (GitgRef*, length + 1);
		for (i = 0; i < length; i++) {
			GitgRef* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
gitg_ref_action_merge_remote_source_copy (const GitgRefActionMergeRemoteSource* self,
                                          GitgRefActionMergeRemoteSource* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GitgRef** _tmp2_;
	gint _tmp2__length1;
	GitgRef** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).sources;
	_tmp2__length1 = (*self).sources_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	(*dest).sources = (_vala_array_free ((*dest).sources, (*dest).sources_length1, (GDestroyNotify) g_object_unref), NULL);
	(*dest).sources = _tmp3_;
	(*dest).sources_length1 = _tmp3__length1;
	(*dest)._sources_size_ = (*dest).sources_length1;
}

static void
gitg_ref_action_merge_remote_source_destroy (GitgRefActionMergeRemoteSource* self)
{
	_g_free0 ((*self).name);
	(*self).sources = (_vala_array_free ((*self).sources, (*self).sources_length1, (GDestroyNotify) g_object_unref), NULL);
}

static GitgRefActionMergeRemoteSource*
gitg_ref_action_merge_remote_source_dup (const GitgRefActionMergeRemoteSource* self)
{
	GitgRefActionMergeRemoteSource* dup;
	dup = g_new0 (GitgRefActionMergeRemoteSource, 1);
	gitg_ref_action_merge_remote_source_copy (self, dup);
	return dup;
}

static void
gitg_ref_action_merge_remote_source_free (GitgRefActionMergeRemoteSource* self)
{
	gitg_ref_action_merge_remote_source_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gitg_ref_action_merge_remote_source_get_type_once (void)
{
	GType gitg_ref_action_merge_remote_source_type_id;
	gitg_ref_action_merge_remote_source_type_id = g_boxed_type_register_static ("GitgRefActionMergeRemoteSource", (GBoxedCopyFunc) gitg_ref_action_merge_remote_source_dup, (GBoxedFreeFunc) gitg_ref_action_merge_remote_source_free);
	return gitg_ref_action_merge_remote_source_type_id;
}

static GType
gitg_ref_action_merge_remote_source_get_type (void)
{
	static gsize gitg_ref_action_merge_remote_source_type_id__once = 0;
	if (g_once_init_enter (&gitg_ref_action_merge_remote_source_type_id__once)) {
		GType gitg_ref_action_merge_remote_source_type_id;
		gitg_ref_action_merge_remote_source_type_id = gitg_ref_action_merge_remote_source_get_type_once ();
		g_once_init_leave (&gitg_ref_action_merge_remote_source_type_id__once, gitg_ref_action_merge_remote_source_type_id);
	}
	return gitg_ref_action_merge_remote_source_type_id__once;
}

static void
gitg_ref_action_merge_class_init (GitgRefActionMergeClass * klass,
                                  gpointer klass_data)
{
	gitg_ref_action_merge_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgRefActionMerge_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_ref_action_merge_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_ref_action_merge_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_ref_action_merge_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_MERGE_APPLICATION_PROPERTY, gitg_ref_action_merge_properties[GITG_REF_ACTION_MERGE_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", GITG_EXT_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_MERGE_ACTION_INTERFACE_PROPERTY, gitg_ref_action_merge_properties[GITG_REF_ACTION_MERGE_ACTION_INTERFACE_PROPERTY] = g_param_spec_object ("action-interface", "action-interface", "action-interface", GITG_EXT_TYPE_REF_ACTION_INTERFACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_MERGE_REFERENCE_PROPERTY, gitg_ref_action_merge_properties[GITG_REF_ACTION_MERGE_REFERENCE_PROPERTY] = g_param_spec_object ("reference", "reference", "reference", GITG_TYPE_REF, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_MERGE_ID_PROPERTY, gitg_ref_action_merge_properties[GITG_REF_ACTION_MERGE_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_MERGE_DISPLAY_NAME_PROPERTY, gitg_ref_action_merge_properties[GITG_REF_ACTION_MERGE_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_MERGE_DESCRIPTION_PROPERTY, gitg_ref_action_merge_properties[GITG_REF_ACTION_MERGE_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_MERGE_AVAILABLE_PROPERTY, gitg_ref_action_merge_properties[GITG_REF_ACTION_MERGE_AVAILABLE_PROPERTY] = g_param_spec_boolean ("available", "available", "available", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_MERGE_ENABLED_PROPERTY, gitg_ref_action_merge_properties[GITG_REF_ACTION_MERGE_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_ref_action_merge_gitg_ext_ui_element_interface_init (GitgExtUIElementIface * iface,
                                                          gpointer iface_data)
{
	gitg_ref_action_merge_gitg_ext_ui_element_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_application = gitg_ref_action_merge_real_get_application;
	iface->set_application = gitg_ref_action_merge_real_set_application;
	iface->get_id = gitg_ref_action_merge_real_get_id;
	iface->get_display_name = gitg_ref_action_merge_real_get_display_name;
	iface->get_description = gitg_ref_action_merge_real_get_description;
	iface->get_available = gitg_ref_action_merge_real_get_available;
	iface->get_enabled = gitg_ref_action_merge_real_get_enabled;
}

static void
gitg_ref_action_merge_gitg_ext_action_interface_init (GitgExtActionIface * iface,
                                                      gpointer iface_data)
{
	gitg_ref_action_merge_gitg_ext_action_parent_iface = g_type_interface_peek_parent (iface);
	iface->populate_menu = (void (*) (GitgExtAction*, GtkMenu*)) gitg_ref_action_merge_real_populate_menu;
}

static void
gitg_ref_action_merge_gitg_ext_ref_action_interface_init (GitgExtRefActionIface * iface,
                                                          gpointer iface_data)
{
	gitg_ref_action_merge_gitg_ext_ref_action_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_action_interface = gitg_ref_action_merge_real_get_action_interface;
	iface->set_action_interface = gitg_ref_action_merge_real_set_action_interface;
	iface->get_reference = gitg_ref_action_merge_real_get_reference;
	iface->set_reference = gitg_ref_action_merge_real_set_reference;
}

static void
gitg_ref_action_merge_instance_init (GitgRefActionMerge * self,
                                     gpointer klass)
{
	self->priv = gitg_ref_action_merge_get_instance_private (self);
}

static void
gitg_ref_action_merge_finalize (GObject * obj)
{
	GitgRefActionMerge * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REF_ACTION_MERGE, GitgRefActionMerge);
	_g_object_unref0 (self->priv->_application);
	_g_object_unref0 (self->priv->_action_interface);
	_g_object_unref0 (self->priv->_reference);
	_g_object_unref0 (self->priv->d_upstream);
	self->priv->d_local_sources = (_vala_array_free (self->priv->d_local_sources, self->priv->d_local_sources_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_remote_sources = (_vala_GitgRefActionMergeRemoteSource_array_free (self->priv->d_remote_sources, self->priv->d_remote_sources_length1), NULL);
	self->priv->d_tag_sources = (_vala_array_free (self->priv->d_tag_sources, self->priv->d_tag_sources_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->d_support);
	G_OBJECT_CLASS (gitg_ref_action_merge_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_ref_action_merge_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgRefActionMergeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_ref_action_merge_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRefActionMerge), 0, (GInstanceInitFunc) gitg_ref_action_merge_instance_init, NULL };
	static const GInterfaceInfo gitg_ext_ui_element_info = { (GInterfaceInitFunc) gitg_ref_action_merge_gitg_ext_ui_element_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_action_info = { (GInterfaceInitFunc) gitg_ref_action_merge_gitg_ext_action_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_ref_action_info = { (GInterfaceInitFunc) gitg_ref_action_merge_gitg_ext_ref_action_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_ref_action_merge_type_id;
	gitg_ref_action_merge_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgRefActionMerge", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_ref_action_merge_type_id, GITG_EXT_TYPE_UI_ELEMENT, &gitg_ext_ui_element_info);
	g_type_add_interface_static (gitg_ref_action_merge_type_id, GITG_EXT_TYPE_ACTION, &gitg_ext_action_info);
	g_type_add_interface_static (gitg_ref_action_merge_type_id, GITG_EXT_TYPE_REF_ACTION, &gitg_ext_ref_action_info);
	GitgRefActionMerge_private_offset = g_type_add_instance_private (gitg_ref_action_merge_type_id, sizeof (GitgRefActionMergePrivate));
	return gitg_ref_action_merge_type_id;
}

GType
gitg_ref_action_merge_get_type (void)
{
	static gsize gitg_ref_action_merge_type_id__once = 0;
	if (g_once_init_enter (&gitg_ref_action_merge_type_id__once)) {
		GType gitg_ref_action_merge_type_id;
		gitg_ref_action_merge_type_id = gitg_ref_action_merge_get_type_once ();
		g_once_init_leave (&gitg_ref_action_merge_type_id__once, gitg_ref_action_merge_type_id);
	}
	return gitg_ref_action_merge_type_id__once;
}

static void
_vala_gitg_ref_action_merge_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	GitgRefActionMerge * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REF_ACTION_MERGE, GitgRefActionMerge);
	switch (property_id) {
		case GITG_REF_ACTION_MERGE_APPLICATION_PROPERTY:
		g_value_take_object (value, gitg_ext_ui_element_get_application ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_MERGE_ACTION_INTERFACE_PROPERTY:
		g_value_set_object (value, gitg_ext_ref_action_get_action_interface ((GitgExtRefAction*) self));
		break;
		case GITG_REF_ACTION_MERGE_REFERENCE_PROPERTY:
		g_value_set_object (value, gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self));
		break;
		case GITG_REF_ACTION_MERGE_ID_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_id ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_MERGE_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_display_name ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_MERGE_DESCRIPTION_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_description ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_MERGE_AVAILABLE_PROPERTY:
		g_value_set_boolean (value, gitg_ext_ui_element_get_available ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_MERGE_ENABLED_PROPERTY:
		g_value_set_boolean (value, gitg_ext_ui_element_get_enabled ((GitgExtUIElement*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_ref_action_merge_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	GitgRefActionMerge * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REF_ACTION_MERGE, GitgRefActionMerge);
	switch (property_id) {
		case GITG_REF_ACTION_MERGE_APPLICATION_PROPERTY:
		gitg_ext_ui_element_set_application ((GitgExtUIElement*) self, g_value_get_object (value));
		break;
		case GITG_REF_ACTION_MERGE_ACTION_INTERFACE_PROPERTY:
		gitg_ext_ref_action_set_action_interface ((GitgExtRefAction*) self, g_value_get_object (value));
		break;
		case GITG_REF_ACTION_MERGE_REFERENCE_PROPERTY:
		gitg_ext_ref_action_set_reference ((GitgExtRefAction*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

