/* shared-folders.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from shared-folders.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>
#include "config.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_UI (boxes_ui_get_type ())
#define BOXES_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UI, BoxesUI))
#define BOXES_IS_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UI))
#define BOXES_UI_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_UI, BoxesUIIface))

typedef struct _BoxesUI BoxesUI;
typedef struct _BoxesUIIface BoxesUIIface;
typedef enum  {
	BOXES_UI_STATE_NONE,
	BOXES_UI_STATE_COLLECTION,
	BOXES_UI_STATE_CREDS,
	BOXES_UI_STATE_DISPLAY,
	BOXES_UI_STATE_WIZARD,
	BOXES_UI_STATE_PROPERTIES,
	BOXES_UI_STATE_TROUBLESHOOT
} BoxesUIState;

#define BOXES_TYPE_UI_STATE (boxes_ui_state_get_type ())

#define BOXES_TYPE_COLLECTION_ITEM (boxes_collection_item_get_type ())
#define BOXES_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem))
#define BOXES_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))
#define BOXES_IS_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_IS_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_COLLECTION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))

typedef struct _BoxesCollectionItem BoxesCollectionItem;
typedef struct _BoxesCollectionItemClass BoxesCollectionItemClass;
typedef struct _BoxesCollectionItemPrivate BoxesCollectionItemPrivate;

#define BOXES_TYPE_SHARED_FOLDER (boxes_shared_folder_get_type ())
#define BOXES_SHARED_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SHARED_FOLDER, BoxesSharedFolder))
#define BOXES_SHARED_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SHARED_FOLDER, BoxesSharedFolderClass))
#define BOXES_IS_SHARED_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SHARED_FOLDER))
#define BOXES_IS_SHARED_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SHARED_FOLDER))
#define BOXES_SHARED_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SHARED_FOLDER, BoxesSharedFolderClass))

typedef struct _BoxesSharedFolder BoxesSharedFolder;
typedef struct _BoxesSharedFolderClass BoxesSharedFolderClass;
typedef struct _BoxesSharedFolderPrivate BoxesSharedFolderPrivate;
enum  {
	BOXES_SHARED_FOLDER_0_PROPERTY,
	BOXES_SHARED_FOLDER_PATH_PROPERTY,
	BOXES_SHARED_FOLDER_MACHINE_UUID_PROPERTY,
	BOXES_SHARED_FOLDER_NUM_PROPERTIES
};
static GParamSpec* boxes_shared_folder_properties[BOXES_SHARED_FOLDER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define BOXES_TYPE_COLLECTION (boxes_collection_get_type ())
#define BOXES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION, BoxesCollection))
#define BOXES_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION, BoxesCollectionClass))
#define BOXES_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION))
#define BOXES_IS_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION))
#define BOXES_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION, BoxesCollectionClass))

typedef struct _BoxesCollection BoxesCollection;
typedef struct _BoxesCollectionClass BoxesCollectionClass;
typedef struct _BoxesCollectionPrivate BoxesCollectionPrivate;

#define BOXES_TYPE_SHARED_FOLDERS_MANAGER (boxes_shared_folders_manager_get_type ())
#define BOXES_SHARED_FOLDERS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SHARED_FOLDERS_MANAGER, BoxesSharedFoldersManager))
#define BOXES_SHARED_FOLDERS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SHARED_FOLDERS_MANAGER, BoxesSharedFoldersManagerClass))
#define BOXES_IS_SHARED_FOLDERS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SHARED_FOLDERS_MANAGER))
#define BOXES_IS_SHARED_FOLDERS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SHARED_FOLDERS_MANAGER))
#define BOXES_SHARED_FOLDERS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SHARED_FOLDERS_MANAGER, BoxesSharedFoldersManagerClass))

typedef struct _BoxesSharedFoldersManager BoxesSharedFoldersManager;
typedef struct _BoxesSharedFoldersManagerClass BoxesSharedFoldersManagerClass;
typedef struct _BoxesSharedFoldersManagerPrivate BoxesSharedFoldersManagerPrivate;
enum  {
	BOXES_SHARED_FOLDERS_MANAGER_0_PROPERTY,
	BOXES_SHARED_FOLDERS_MANAGER_NUM_PROPERTIES
};
static GParamSpec* boxes_shared_folders_manager_properties[BOXES_SHARED_FOLDERS_MANAGER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BoxesUIIface {
	GTypeInterface parent_iface;
	BoxesUIState (*get_previous_ui_state) (BoxesUI* self);
	void (*set_previous_ui_state) (BoxesUI* self, BoxesUIState value);
	BoxesUIState (*get_ui_state) (BoxesUI* self);
	void (*set_ui_state) (BoxesUI* self, BoxesUIState value);
};

struct _BoxesCollectionItem {
	GObject parent_instance;
	BoxesCollectionItemPrivate * priv;
};

struct _BoxesCollectionItemClass {
	GObjectClass parent_class;
	gint (*compare) (BoxesCollectionItem* self, BoxesCollectionItem* other);
};

struct _BoxesSharedFolder {
	BoxesCollectionItem parent_instance;
	BoxesSharedFolderPrivate * priv;
};

struct _BoxesSharedFolderClass {
	BoxesCollectionItemClass parent_class;
};

struct _BoxesSharedFolderPrivate {
	gchar* _path;
	gchar* _machine_uuid;
};

struct _BoxesCollection {
	GObject parent_instance;
	BoxesCollectionPrivate * priv;
	GListStore* filtered_items;
};

struct _BoxesCollectionClass {
	GObjectClass parent_class;
};

struct _BoxesSharedFoldersManager {
	BoxesCollection parent_instance;
	BoxesSharedFoldersManagerPrivate * priv;
};

struct _BoxesSharedFoldersManagerClass {
	BoxesCollectionClass parent_class;
};

struct _BoxesSharedFoldersManagerPrivate {
	GHashTable* folders;
	GSettings* settings;
};

static gint BoxesSharedFolder_private_offset;
static gpointer boxes_shared_folder_parent_class = NULL;
static gint BoxesSharedFoldersManager_private_offset;
static gpointer boxes_shared_folders_manager_parent_class = NULL;
static BoxesSharedFoldersManager* boxes_shared_folders_manager_shared_folders_manager;
static BoxesSharedFoldersManager* boxes_shared_folders_manager_shared_folders_manager = NULL;

VALA_EXTERN GType boxes_ui_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType boxes_ui_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesUI, g_object_unref)
VALA_EXTERN GType boxes_collection_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesCollectionItem, g_object_unref)
VALA_EXTERN GType boxes_shared_folder_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesSharedFolder, g_object_unref)
VALA_EXTERN BoxesSharedFolder* boxes_shared_folder_new (const gchar* machine_uuid,
                                            const gchar* path,
                                            const gchar* name);
VALA_EXTERN BoxesSharedFolder* boxes_shared_folder_construct (GType object_type,
                                                  const gchar* machine_uuid,
                                                  const gchar* path,
                                                  const gchar* name);
VALA_EXTERN BoxesCollectionItem* boxes_collection_item_construct (GType object_type);
VALA_EXTERN void boxes_shared_folder_set_machine_uuid (BoxesSharedFolder* self,
                                           const gchar* value);
VALA_EXTERN void boxes_shared_folder_set_path (BoxesSharedFolder* self,
                                   const gchar* value);
VALA_EXTERN void boxes_collection_item_set_name (BoxesCollectionItem* self,
                                     const gchar* value);
VALA_EXTERN const gchar* boxes_shared_folder_get_path (BoxesSharedFolder* self);
VALA_EXTERN const gchar* boxes_shared_folder_get_machine_uuid (BoxesSharedFolder* self);
static void boxes_shared_folder_finalize (GObject * obj);
static GType boxes_shared_folder_get_type_once (void);
static void _vala_boxes_shared_folder_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_boxes_shared_folder_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
VALA_EXTERN GType boxes_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesCollection, g_object_unref)
VALA_EXTERN GType boxes_shared_folders_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesSharedFoldersManager, g_object_unref)
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN BoxesSharedFoldersManager* boxes_shared_folders_manager_get_default (void);
VALA_EXTERN BoxesSharedFoldersManager* boxes_shared_folders_manager_new (void);
VALA_EXTERN BoxesSharedFoldersManager* boxes_shared_folders_manager_construct (GType object_type);
VALA_EXTERN GListStore* boxes_shared_folders_manager_get_folders (BoxesSharedFoldersManager* self,
                                                      const gchar* machine_uuid);
VALA_EXTERN gboolean boxes_shared_folders_manager_add_item (BoxesSharedFoldersManager* self,
                                                BoxesSharedFolder* folder);
static gchar* boxes_shared_folders_manager_get_shared_folder_real_path (BoxesSharedFolder* folder);
VALA_EXTERN const gchar* boxes_collection_item_get_name (BoxesCollectionItem* self);
static gboolean boxes_shared_folders_manager_add_to_gsetting (BoxesSharedFoldersManager* self,
                                                       BoxesSharedFolder* folder);
VALA_EXTERN void boxes_shared_folders_manager_remove_item (BoxesSharedFoldersManager* self,
                                               BoxesSharedFolder* folder);
static void boxes_shared_folders_manager_remove_from_gsetting (BoxesSharedFoldersManager* self,
                                                        BoxesSharedFolder* folder);
VALA_EXTERN BoxesCollection* boxes_collection_new (void);
VALA_EXTERN BoxesCollection* boxes_collection_construct (GType object_type);
static GObject * boxes_shared_folders_manager_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void boxes_shared_folders_manager_finalize (GObject * obj);
static GType boxes_shared_folders_manager_get_type_once (void);

static inline gpointer
boxes_shared_folder_get_instance_private (BoxesSharedFolder* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesSharedFolder_private_offset);
}

BoxesSharedFolder*
boxes_shared_folder_construct (GType object_type,
                               const gchar* machine_uuid,
                               const gchar* path,
                               const gchar* name)
{
	BoxesSharedFolder * self = NULL;
	g_return_val_if_fail (machine_uuid != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (BoxesSharedFolder*) boxes_collection_item_construct (object_type);
	boxes_shared_folder_set_machine_uuid (self, machine_uuid);
	boxes_shared_folder_set_path (self, path);
	boxes_collection_item_set_name ((BoxesCollectionItem*) self, name);
	return self;
}

BoxesSharedFolder*
boxes_shared_folder_new (const gchar* machine_uuid,
                         const gchar* path,
                         const gchar* name)
{
	return boxes_shared_folder_construct (BOXES_TYPE_SHARED_FOLDER, machine_uuid, path, name);
}

const gchar*
boxes_shared_folder_get_path (BoxesSharedFolder* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	result = _tmp0_;
	return result;
}

void
boxes_shared_folder_set_path (BoxesSharedFolder* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_shared_folder_get_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_path);
		self->priv->_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, boxes_shared_folder_properties[BOXES_SHARED_FOLDER_PATH_PROPERTY]);
	}
}

const gchar*
boxes_shared_folder_get_machine_uuid (BoxesSharedFolder* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_machine_uuid;
	result = _tmp0_;
	return result;
}

void
boxes_shared_folder_set_machine_uuid (BoxesSharedFolder* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_shared_folder_get_machine_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_machine_uuid);
		self->priv->_machine_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, boxes_shared_folder_properties[BOXES_SHARED_FOLDER_MACHINE_UUID_PROPERTY]);
	}
}

static void
boxes_shared_folder_class_init (BoxesSharedFolderClass * klass,
                                gpointer klass_data)
{
	boxes_shared_folder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesSharedFolder_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_shared_folder_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_shared_folder_set_property;
	G_OBJECT_CLASS (klass)->finalize = boxes_shared_folder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SHARED_FOLDER_PATH_PROPERTY, boxes_shared_folder_properties[BOXES_SHARED_FOLDER_PATH_PROPERTY] = g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SHARED_FOLDER_MACHINE_UUID_PROPERTY, boxes_shared_folder_properties[BOXES_SHARED_FOLDER_MACHINE_UUID_PROPERTY] = g_param_spec_string ("machine-uuid", "machine-uuid", "machine-uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
boxes_shared_folder_instance_init (BoxesSharedFolder * self,
                                   gpointer klass)
{
	self->priv = boxes_shared_folder_get_instance_private (self);
}

static void
boxes_shared_folder_finalize (GObject * obj)
{
	BoxesSharedFolder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_SHARED_FOLDER, BoxesSharedFolder);
	_g_free0 (self->priv->_path);
	_g_free0 (self->priv->_machine_uuid);
	G_OBJECT_CLASS (boxes_shared_folder_parent_class)->finalize (obj);
}

static GType
boxes_shared_folder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesSharedFolderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_shared_folder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesSharedFolder), 0, (GInstanceInitFunc) boxes_shared_folder_instance_init, NULL };
	GType boxes_shared_folder_type_id;
	boxes_shared_folder_type_id = g_type_register_static (BOXES_TYPE_COLLECTION_ITEM, "BoxesSharedFolder", &g_define_type_info, 0);
	BoxesSharedFolder_private_offset = g_type_add_instance_private (boxes_shared_folder_type_id, sizeof (BoxesSharedFolderPrivate));
	return boxes_shared_folder_type_id;
}

GType
boxes_shared_folder_get_type (void)
{
	static volatile gsize boxes_shared_folder_type_id__once = 0;
	if (g_once_init_enter (&boxes_shared_folder_type_id__once)) {
		GType boxes_shared_folder_type_id;
		boxes_shared_folder_type_id = boxes_shared_folder_get_type_once ();
		g_once_init_leave (&boxes_shared_folder_type_id__once, boxes_shared_folder_type_id);
	}
	return boxes_shared_folder_type_id__once;
}

static void
_vala_boxes_shared_folder_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	BoxesSharedFolder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_SHARED_FOLDER, BoxesSharedFolder);
	switch (property_id) {
		case BOXES_SHARED_FOLDER_PATH_PROPERTY:
		g_value_set_string (value, boxes_shared_folder_get_path (self));
		break;
		case BOXES_SHARED_FOLDER_MACHINE_UUID_PROPERTY:
		g_value_set_string (value, boxes_shared_folder_get_machine_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_boxes_shared_folder_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	BoxesSharedFolder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_SHARED_FOLDER, BoxesSharedFolder);
	switch (property_id) {
		case BOXES_SHARED_FOLDER_PATH_PROPERTY:
		boxes_shared_folder_set_path (self, g_value_get_string (value));
		break;
		case BOXES_SHARED_FOLDER_MACHINE_UUID_PROPERTY:
		boxes_shared_folder_set_machine_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
boxes_shared_folders_manager_get_instance_private (BoxesSharedFoldersManager* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesSharedFoldersManager_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BoxesSharedFoldersManager*
boxes_shared_folders_manager_get_default (void)
{
	BoxesSharedFoldersManager* _tmp0_;
	BoxesSharedFoldersManager* _tmp2_;
	BoxesSharedFoldersManager* _tmp3_;
	BoxesSharedFoldersManager* result;
	_tmp0_ = boxes_shared_folders_manager_shared_folders_manager;
	if (_tmp0_ == NULL) {
		BoxesSharedFoldersManager* _tmp1_;
		_tmp1_ = boxes_shared_folders_manager_new ();
		_g_object_unref0 (boxes_shared_folders_manager_shared_folders_manager);
		boxes_shared_folders_manager_shared_folders_manager = _tmp1_;
	}
	_tmp2_ = boxes_shared_folders_manager_shared_folders_manager;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

GListStore*
boxes_shared_folders_manager_get_folders (BoxesSharedFoldersManager* self,
                                          const gchar* machine_uuid)
{
	GListStore* store = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GListStore* _tmp2_;
	GListStore* _tmp3_;
	GListStore* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (machine_uuid != NULL, NULL);
	_tmp0_ = self->priv->folders;
	_tmp1_ = g_hash_table_lookup (_tmp0_, machine_uuid);
	_tmp2_ = _g_object_ref0 ((GListStore*) _tmp1_);
	store = _tmp2_;
	_tmp3_ = store;
	if (_tmp3_ == NULL) {
		GListStore* _tmp4_;
		GHashTable* _tmp5_;
		gchar* _tmp6_;
		GListStore* _tmp7_;
		GListStore* _tmp8_;
		_tmp4_ = g_list_store_new (BOXES_TYPE_SHARED_FOLDER);
		_g_object_unref0 (store);
		store = _tmp4_;
		_tmp5_ = self->priv->folders;
		_tmp6_ = g_strdup (machine_uuid);
		_tmp7_ = store;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		g_hash_table_insert (_tmp5_, _tmp6_, _tmp8_);
	}
	result = store;
	return result;
}

gboolean
boxes_shared_folders_manager_add_item (BoxesSharedFoldersManager* self,
                                       BoxesSharedFolder* folder)
{
	GListStore* model = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GListStore* _tmp2_;
	GListStore* _tmp3_;
	gchar* shared_folder = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp8_;
	gchar* link_path = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (folder != NULL, FALSE);
	_tmp0_ = boxes_shared_folder_get_machine_uuid (folder);
	_tmp1_ = _tmp0_;
	_tmp2_ = boxes_shared_folders_manager_get_folders (self, _tmp1_);
	model = _tmp2_;
	_tmp3_ = model;
	g_list_store_append (_tmp3_, (GObject*) folder);
	_tmp4_ = boxes_shared_folders_manager_get_shared_folder_real_path (folder);
	shared_folder = _tmp4_;
	_tmp5_ = shared_folder;
	if (!g_file_test (_tmp5_, G_FILE_TEST_IS_DIR)) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = boxes_shared_folder_get_path (folder);
		_tmp7_ = _tmp6_;
		unlink (_tmp7_);
	}
	_tmp8_ = shared_folder;
	if (!g_file_test (_tmp8_, G_FILE_TEST_EXISTS)) {
		const gchar* _tmp9_;
		_tmp9_ = shared_folder;
		if (mkdir (_tmp9_, (mode_t) 0755) == -1) {
			const gchar* _tmp10_;
			_tmp10_ = g_strerror (errno);
			g_warning ("shared-folders.vala:74: %s", _tmp10_);
			result = FALSE;
			_g_free0 (shared_folder);
			_g_object_unref0 (model);
			return result;
		}
	}
	_tmp11_ = shared_folder;
	_tmp12_ = boxes_collection_item_get_name ((BoxesCollectionItem*) folder);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_build_filename (_tmp11_, _tmp13_, NULL);
	link_path = _tmp14_;
	_tmp15_ = boxes_shared_folder_get_path (folder);
	_tmp16_ = _tmp15_;
	_tmp17_ = link_path;
	if (symlink (_tmp16_, _tmp17_) == -1) {
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp18_ = link_path;
		_tmp19_ = g_strerror (errno);
		g_debug ("shared-folders.vala:82: Not creating symlink for shared folder \"%s\":" \
" %s", _tmp18_, _tmp19_);
		result = FALSE;
		_g_free0 (link_path);
		_g_free0 (shared_folder);
		_g_object_unref0 (model);
		return result;
	}
	result = boxes_shared_folders_manager_add_to_gsetting (self, folder);
	_g_free0 (link_path);
	_g_free0 (shared_folder);
	_g_object_unref0 (model);
	return result;
}

static gboolean
boxes_shared_folders_manager_add_to_gsetting (BoxesSharedFoldersManager* self,
                                              BoxesSharedFolder* folder)
{
	GVariantBuilder* variant_builder = NULL;
	const GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantType* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* _tmp4_;
	gchar* shared_folders = NULL;
	GSettings* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GVariantBuilder* entry_variant_builder = NULL;
	const GVariantType* _tmp23_;
	GVariantBuilder* _tmp24_;
	GVariant* uuid_variant = NULL;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	GVariant* _tmp27_;
	GVariant* path_variant = NULL;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GVariant* _tmp30_;
	GVariant* name_variant = NULL;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GVariant* _tmp33_;
	GVariant* entry_variant = NULL;
	GVariant* _tmp34_;
	GVariantBuilder* _tmp35_;
	GVariant* variant = NULL;
	GVariantBuilder* _tmp36_;
	GVariant* _tmp37_;
	GSettings* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gboolean _tmp41_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (folder != NULL, FALSE);
	_tmp0_ = G_VARIANT_TYPE_VARIANT;
	_tmp1_ = g_variant_type_new_array (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_builder_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_variant_type_free0 (_tmp2_);
	variant_builder = _tmp4_;
	_tmp5_ = self->priv->settings;
	_tmp6_ = g_settings_get_string (_tmp5_, "shared-folders");
	shared_folders = _tmp6_;
	_tmp7_ = shared_folders;
	if (g_strcmp0 (_tmp7_, "") != 0) {
		{
			GVariant* entry = NULL;
			GVariant* variant = NULL;
			const GVariantType* _tmp8_;
			GVariantType* _tmp9_;
			GVariantType* _tmp10_;
			const gchar* _tmp11_;
			GVariant* _tmp12_;
			GVariant* _tmp13_;
			GVariantIter* iter = NULL;
			GVariant* _tmp15_;
			GVariantIter* _tmp16_;
			entry = NULL;
			_tmp8_ = G_VARIANT_TYPE_VARIANT;
			_tmp9_ = g_variant_type_new_array (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = shared_folders;
			_tmp12_ = g_variant_parse (_tmp10_, _tmp11_, NULL, NULL, &_inner_error0_);
			_tmp13_ = _tmp12_;
			_g_variant_type_free0 (_tmp10_);
			variant = _tmp13_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp14_ = FALSE;
				_g_variant_unref0 (entry);
				if (_inner_error0_->domain == G_VARIANT_PARSE_ERROR) {
					goto __catch0_g_variant_parse_error;
				}
				_g_free0 (shared_folders);
				_g_variant_builder_unref0 (variant_builder);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp14_;
			}
			_tmp15_ = variant;
			_tmp16_ = g_variant_iter_new (_tmp15_);
			iter = _tmp16_;
			while (TRUE) {
				GVariantIter* _tmp17_;
				GVariantBuilder* _tmp18_;
				GVariant* _tmp19_;
				_tmp17_ = iter;
				if (!g_variant_iter_next (_tmp17_, "v", &entry, NULL)) {
					break;
				}
				_tmp18_ = variant_builder;
				_tmp19_ = entry;
				g_variant_builder_add (_tmp18_, "v", _tmp19_, NULL);
			}
			_g_variant_iter_free0 (iter);
			_g_variant_unref0 (variant);
			_g_variant_unref0 (entry);
		}
		goto __finally0;
		__catch0_g_variant_parse_error:
		{
			GError* err = NULL;
			GError* _tmp20_;
			const gchar* _tmp21_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp20_ = err;
			_tmp21_ = _tmp20_->message;
			g_warning ("shared-folders.vala:103: %s", _tmp21_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp22_ = FALSE;
			_g_free0 (shared_folders);
			_g_variant_builder_unref0 (variant_builder);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp22_;
		}
	}
	_tmp23_ = G_VARIANT_TYPE_VARDICT;
	_tmp24_ = g_variant_builder_new (_tmp23_);
	entry_variant_builder = _tmp24_;
	_tmp25_ = boxes_shared_folder_get_machine_uuid (folder);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_variant_new ("s", _tmp26_, NULL);
	g_variant_ref_sink (_tmp27_);
	uuid_variant = _tmp27_;
	_tmp28_ = boxes_shared_folder_get_path (folder);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_variant_new ("s", _tmp29_, NULL);
	g_variant_ref_sink (_tmp30_);
	path_variant = _tmp30_;
	_tmp31_ = boxes_collection_item_get_name ((BoxesCollectionItem*) folder);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_variant_new ("s", _tmp32_, NULL);
	g_variant_ref_sink (_tmp33_);
	name_variant = _tmp33_;
	g_variant_builder_add (entry_variant_builder, "{sv}", "uuid", uuid_variant, NULL);
	g_variant_builder_add (entry_variant_builder, "{sv}", "path", path_variant, NULL);
	g_variant_builder_add (entry_variant_builder, "{sv}", "name", name_variant, NULL);
	_tmp34_ = g_variant_builder_end (entry_variant_builder);
	g_variant_ref_sink (_tmp34_);
	entry_variant = _tmp34_;
	_tmp35_ = variant_builder;
	g_variant_builder_add (_tmp35_, "v", entry_variant, NULL);
	_tmp36_ = variant_builder;
	_tmp37_ = g_variant_builder_end (_tmp36_);
	g_variant_ref_sink (_tmp37_);
	variant = _tmp37_;
	_tmp38_ = self->priv->settings;
	_tmp39_ = g_variant_print (variant, TRUE);
	_tmp40_ = _tmp39_;
	_tmp41_ = g_settings_set_string (_tmp38_, "shared-folders", _tmp40_);
	_g_free0 (_tmp40_);
	result = _tmp41_;
	_g_variant_unref0 (variant);
	_g_variant_unref0 (entry_variant);
	_g_variant_unref0 (name_variant);
	_g_variant_unref0 (path_variant);
	_g_variant_unref0 (uuid_variant);
	_g_variant_builder_unref0 (entry_variant_builder);
	_g_free0 (shared_folders);
	_g_variant_builder_unref0 (variant_builder);
	return result;
}

void
boxes_shared_folders_manager_remove_item (BoxesSharedFoldersManager* self,
                                          BoxesSharedFolder* folder)
{
	GListStore* list_model = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	GListStore* _tmp4_;
	gchar* shared_folder = NULL;
	gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	gchar* to_remove = NULL;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	_tmp0_ = self->priv->folders;
	_tmp1_ = boxes_shared_folder_get_machine_uuid (folder);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_hash_table_lookup (_tmp0_, _tmp2_);
	_tmp4_ = _g_object_ref0 ((GListStore*) _tmp3_);
	list_model = _tmp4_;
	{
		gint idx = 0;
		idx = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				GListStore* _tmp7_;
				BoxesSharedFolder* item = NULL;
				GListStore* _tmp8_;
				GObject* _tmp9_;
				BoxesSharedFolder* _tmp10_;
				BoxesSharedFolder* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = idx;
					idx = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = list_model;
				if (!(((guint) idx) < g_list_model_get_n_items ((GListModel*) _tmp7_))) {
					break;
				}
				_tmp8_ = list_model;
				_tmp9_ = g_list_model_get_item ((GListModel*) _tmp8_, (guint) idx);
				_tmp10_ = BOXES_IS_SHARED_FOLDER (_tmp9_) ? ((BoxesSharedFolder*) _tmp9_) : NULL;
				if (_tmp10_ == NULL) {
					_g_object_unref0 (_tmp9_);
				}
				item = _tmp10_;
				_tmp11_ = item;
				_tmp12_ = boxes_collection_item_get_name ((BoxesCollectionItem*) _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = boxes_collection_item_get_name ((BoxesCollectionItem*) folder);
				_tmp15_ = _tmp14_;
				if (g_strcmp0 (_tmp13_, _tmp15_) == 0) {
					GListStore* _tmp16_;
					_tmp16_ = list_model;
					g_list_store_remove (_tmp16_, (guint) idx);
					_g_object_unref0 (item);
					break;
				}
				_g_object_unref0 (item);
			}
		}
	}
	_tmp17_ = boxes_shared_folders_manager_get_shared_folder_real_path (folder);
	shared_folder = _tmp17_;
	_tmp19_ = shared_folder;
	if (!g_file_test (_tmp19_, G_FILE_TEST_EXISTS)) {
		_tmp18_ = TRUE;
	} else {
		const gchar* _tmp20_;
		_tmp20_ = shared_folder;
		_tmp18_ = !g_file_test (_tmp20_, G_FILE_TEST_IS_DIR);
	}
	if (_tmp18_) {
		_g_free0 (shared_folder);
		_g_object_unref0 (list_model);
		return;
	}
	_tmp21_ = shared_folder;
	_tmp22_ = boxes_collection_item_get_name ((BoxesCollectionItem*) folder);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_build_filename (_tmp21_, _tmp23_, NULL);
	to_remove = _tmp24_;
	_tmp25_ = to_remove;
	unlink (_tmp25_);
	boxes_shared_folders_manager_remove_from_gsetting (self, folder);
	_g_free0 (to_remove);
	_g_free0 (shared_folder);
	_g_object_unref0 (list_model);
}

static void
boxes_shared_folders_manager_remove_from_gsetting (BoxesSharedFoldersManager* self,
                                                   BoxesSharedFolder* folder)
{
	GVariantBuilder* variant_builder = NULL;
	const GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantType* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* _tmp4_;
	gchar* shared_folders = NULL;
	GSettings* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	_tmp0_ = G_VARIANT_TYPE_VARIANT;
	_tmp1_ = g_variant_type_new_array (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_builder_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_variant_type_free0 (_tmp2_);
	variant_builder = _tmp4_;
	_tmp5_ = self->priv->settings;
	_tmp6_ = g_settings_get_string (_tmp5_, "shared-folders");
	shared_folders = _tmp6_;
	_tmp7_ = shared_folders;
	if (g_strcmp0 (_tmp7_, "") == 0) {
		_g_free0 (shared_folders);
		_g_variant_builder_unref0 (variant_builder);
		return;
	}
	{
		GVariant* entry = NULL;
		gchar* name_str = NULL;
		gchar* uuid_str = NULL;
		GVariant* variant = NULL;
		const GVariantType* _tmp8_;
		GVariantType* _tmp9_;
		GVariantType* _tmp10_;
		const gchar* _tmp11_;
		GVariant* _tmp12_;
		GVariant* _tmp13_;
		GVariantIter* iter = NULL;
		GVariant* _tmp14_;
		GVariantIter* _tmp15_;
		GVariantBuilder* _tmp30_;
		GVariant* _tmp31_;
		GSettings* _tmp32_;
		GVariant* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		entry = NULL;
		_tmp8_ = G_VARIANT_TYPE_VARIANT;
		_tmp9_ = g_variant_type_new_array (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = shared_folders;
		_tmp12_ = g_variant_parse (_tmp10_, _tmp11_, NULL, NULL, &_inner_error0_);
		_tmp13_ = _tmp12_;
		_g_variant_type_free0 (_tmp10_);
		variant = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (uuid_str);
			_g_free0 (name_str);
			_g_variant_unref0 (entry);
			if (_inner_error0_->domain == G_VARIANT_PARSE_ERROR) {
				goto __catch0_g_variant_parse_error;
			}
			_g_free0 (shared_folders);
			_g_variant_builder_unref0 (variant_builder);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp14_ = variant;
		_tmp15_ = g_variant_iter_new (_tmp14_);
		iter = _tmp15_;
		while (TRUE) {
			GVariantIter* _tmp16_;
			GVariant* _tmp17_;
			gchar* _tmp18_ = NULL;
			GVariant* _tmp19_;
			gchar* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			GVariantBuilder* _tmp28_;
			GVariant* _tmp29_;
			_tmp16_ = iter;
			if (!g_variant_iter_next (_tmp16_, "v", &entry, NULL)) {
				break;
			}
			_tmp17_ = entry;
			g_variant_lookup (_tmp17_, "uuid", "s", &_tmp18_, NULL);
			_g_free0 (uuid_str);
			uuid_str = _tmp18_;
			_tmp19_ = entry;
			g_variant_lookup (_tmp19_, "name", "s", &_tmp20_, NULL);
			_g_free0 (name_str);
			name_str = _tmp20_;
			_tmp22_ = uuid_str;
			_tmp23_ = boxes_shared_folder_get_machine_uuid (folder);
			_tmp24_ = _tmp23_;
			if (g_strcmp0 (_tmp22_, _tmp24_) == 0) {
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				_tmp25_ = name_str;
				_tmp26_ = boxes_collection_item_get_name ((BoxesCollectionItem*) folder);
				_tmp27_ = _tmp26_;
				_tmp21_ = g_strcmp0 (_tmp25_, _tmp27_) == 0;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				continue;
			}
			_tmp28_ = variant_builder;
			_tmp29_ = entry;
			g_variant_builder_add (_tmp28_, "v", _tmp29_, NULL);
		}
		_tmp30_ = variant_builder;
		_tmp31_ = g_variant_builder_end (_tmp30_);
		g_variant_ref_sink (_tmp31_);
		_g_variant_unref0 (variant);
		variant = _tmp31_;
		_tmp32_ = self->priv->settings;
		_tmp33_ = variant;
		_tmp34_ = g_variant_print (_tmp33_, TRUE);
		_tmp35_ = _tmp34_;
		g_settings_set_string (_tmp32_, "shared-folders", _tmp35_);
		_g_free0 (_tmp35_);
		_g_variant_iter_free0 (iter);
		_g_variant_unref0 (variant);
		_g_free0 (uuid_str);
		_g_free0 (name_str);
		_g_variant_unref0 (entry);
	}
	goto __finally0;
	__catch0_g_variant_parse_error:
	{
		GError* err = NULL;
		GError* _tmp36_;
		const gchar* _tmp37_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp36_ = err;
		_tmp37_ = _tmp36_->message;
		g_warning ("shared-folders.vala:171: %s", _tmp37_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (shared_folders);
		_g_variant_builder_unref0 (variant_builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (shared_folders);
	_g_variant_builder_unref0 (variant_builder);
}

static gchar*
boxes_shared_folders_manager_get_shared_folder_real_path (BoxesSharedFolder* folder)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (folder != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = boxes_shared_folder_get_machine_uuid (folder);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_build_filename (_tmp0_, PACKAGE_TARNAME, _tmp2_, NULL);
	result = _tmp3_;
	return result;
}

BoxesSharedFoldersManager*
boxes_shared_folders_manager_construct (GType object_type)
{
	BoxesSharedFoldersManager * self = NULL;
	self = (BoxesSharedFoldersManager*) boxes_collection_construct (object_type);
	return self;
}

BoxesSharedFoldersManager*
boxes_shared_folders_manager_new (void)
{
	return boxes_shared_folders_manager_construct (BOXES_TYPE_SHARED_FOLDERS_MANAGER);
}

static GObject *
boxes_shared_folders_manager_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BoxesSharedFoldersManager * self;
	gchar* serialized_list = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (boxes_shared_folders_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_SHARED_FOLDERS_MANAGER, BoxesSharedFoldersManager);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "shared-folders");
	serialized_list = _tmp1_;
	_tmp2_ = serialized_list;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		_g_free0 (serialized_list);
		return obj;
	}
	{
		GVariant* entry = NULL;
		gchar* uuid = NULL;
		gchar* path = NULL;
		gchar* name = NULL;
		GVariant* variant = NULL;
		const GVariantType* _tmp3_;
		GVariantType* _tmp4_;
		GVariantType* _tmp5_;
		const gchar* _tmp6_;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		GVariantIter* iter = NULL;
		GVariant* _tmp9_;
		GVariantIter* _tmp10_;
		entry = NULL;
		_tmp3_ = G_VARIANT_TYPE_VARIANT;
		_tmp4_ = g_variant_type_new_array (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = serialized_list;
		_tmp7_ = g_variant_parse (_tmp5_, _tmp6_, NULL, NULL, &_inner_error0_);
		_tmp8_ = _tmp7_;
		_g_variant_type_free0 (_tmp5_);
		variant = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (name);
			_g_free0 (path);
			_g_free0 (uuid);
			_g_variant_unref0 (entry);
			if (_inner_error0_->domain == G_VARIANT_PARSE_ERROR) {
				goto __catch0_g_variant_parse_error;
			}
			_g_free0 (serialized_list);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp9_ = variant;
		_tmp10_ = g_variant_iter_new (_tmp9_);
		iter = _tmp10_;
		while (TRUE) {
			GVariantIter* _tmp11_;
			GVariant* _tmp12_;
			gchar* _tmp13_ = NULL;
			GVariant* _tmp14_;
			gchar* _tmp15_ = NULL;
			GVariant* _tmp16_;
			gchar* _tmp17_ = NULL;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			BoxesSharedFolder* _tmp21_;
			BoxesSharedFolder* _tmp22_;
			_tmp11_ = iter;
			if (!g_variant_iter_next (_tmp11_, "v", &entry, NULL)) {
				break;
			}
			_tmp12_ = entry;
			g_variant_lookup (_tmp12_, "uuid", "s", &_tmp13_, NULL);
			_g_free0 (uuid);
			uuid = _tmp13_;
			_tmp14_ = entry;
			g_variant_lookup (_tmp14_, "path", "s", &_tmp15_, NULL);
			_g_free0 (path);
			path = _tmp15_;
			_tmp16_ = entry;
			g_variant_lookup (_tmp16_, "name", "s", &_tmp17_, NULL);
			_g_free0 (name);
			name = _tmp17_;
			_tmp18_ = uuid;
			_tmp19_ = path;
			_tmp20_ = name;
			_tmp21_ = boxes_shared_folder_new (_tmp18_, _tmp19_, _tmp20_);
			_tmp22_ = _tmp21_;
			boxes_shared_folders_manager_add_item (self, _tmp22_);
			_g_object_unref0 (_tmp22_);
		}
		_g_variant_iter_free0 (iter);
		_g_variant_unref0 (variant);
		_g_free0 (name);
		_g_free0 (path);
		_g_free0 (uuid);
		_g_variant_unref0 (entry);
	}
	goto __finally0;
	__catch0_g_variant_parse_error:
	{
		GError* err = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = err;
		_tmp24_ = _tmp23_->message;
		g_warning ("shared-folders.vala:49: %s", _tmp24_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (serialized_list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_g_free0 (serialized_list);
	return obj;
}

static void
boxes_shared_folders_manager_class_init (BoxesSharedFoldersManagerClass * klass,
                                         gpointer klass_data)
{
	boxes_shared_folders_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesSharedFoldersManager_private_offset);
	G_OBJECT_CLASS (klass)->constructor = boxes_shared_folders_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = boxes_shared_folders_manager_finalize;
}

static void
boxes_shared_folders_manager_instance_init (BoxesSharedFoldersManager * self,
                                            gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GSettings* _tmp3_;
	self->priv = boxes_shared_folders_manager_get_instance_private (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	self->priv->folders = _tmp2_;
	_tmp3_ = g_settings_new ("org.gnome.boxes");
	self->priv->settings = _tmp3_;
}

static void
boxes_shared_folders_manager_finalize (GObject * obj)
{
	BoxesSharedFoldersManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_SHARED_FOLDERS_MANAGER, BoxesSharedFoldersManager);
	_g_hash_table_unref0 (self->priv->folders);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (boxes_shared_folders_manager_parent_class)->finalize (obj);
}

static GType
boxes_shared_folders_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesSharedFoldersManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_shared_folders_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesSharedFoldersManager), 0, (GInstanceInitFunc) boxes_shared_folders_manager_instance_init, NULL };
	GType boxes_shared_folders_manager_type_id;
	boxes_shared_folders_manager_type_id = g_type_register_static (BOXES_TYPE_COLLECTION, "BoxesSharedFoldersManager", &g_define_type_info, 0);
	BoxesSharedFoldersManager_private_offset = g_type_add_instance_private (boxes_shared_folders_manager_type_id, sizeof (BoxesSharedFoldersManagerPrivate));
	return boxes_shared_folders_manager_type_id;
}

GType
boxes_shared_folders_manager_get_type (void)
{
	static volatile gsize boxes_shared_folders_manager_type_id__once = 0;
	if (g_once_init_enter (&boxes_shared_folders_manager_type_id__once)) {
		GType boxes_shared_folders_manager_type_id;
		boxes_shared_folders_manager_type_id = boxes_shared_folders_manager_get_type_once ();
		g_once_init_leave (&boxes_shared_folders_manager_type_id__once, boxes_shared_folders_manager_type_id);
	}
	return boxes_shared_folders_manager_type_id__once;
}

