/* NaturalTime.c generated by valac 0.56.17, the Vala compiler
 * generated from NaturalTime.vala, do not modify */

/* NaturalTime.vala
 *
 * Copyright 2020 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "common.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define BREAK_TIMER_COMMON_NATURAL_TIME_TYPE_TIME_FORMAT (break_timer_common_natural_time_time_format_get_type ())
typedef struct _BreakTimerCommonNaturalTimeTimeFormat BreakTimerCommonNaturalTimeTimeFormat;
enum  {
	BREAK_TIMER_COMMON_NATURAL_TIME_0_PROPERTY,
	BREAK_TIMER_COMMON_NATURAL_TIME_NUM_PROPERTIES
};
static GParamSpec* break_timer_common_natural_time_properties[BREAK_TIMER_COMMON_NATURAL_TIME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BreakTimerCommonNaturalTimeTimeFormat {
	gint seconds;
	BreakTimerCommonNaturalTimeFormatTimeCb format_time;
	gpointer format_time_target;
};

struct _BreakTimerCommonNaturalTimePrivate {
	BreakTimerCommonNaturalTimeTimeFormat* units;
	gint units_length1;
	gint _units_size_;
};

static gint BreakTimerCommonNaturalTime_private_offset;
static gpointer break_timer_common_natural_time_parent_class = NULL;
static BreakTimerCommonNaturalTime* break_timer_common_natural_time__instance;
static BreakTimerCommonNaturalTime* break_timer_common_natural_time__instance = NULL;

static GType break_timer_common_natural_time_time_format_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static BreakTimerCommonNaturalTimeTimeFormat* break_timer_common_natural_time_time_format_dup (const BreakTimerCommonNaturalTimeTimeFormat* self);
static void break_timer_common_natural_time_time_format_free (BreakTimerCommonNaturalTimeTimeFormat* self);
static BreakTimerCommonNaturalTime* break_timer_common_natural_time_new (void);
static BreakTimerCommonNaturalTime* break_timer_common_natural_time_construct (GType object_type);
static gchar* __lambda4_ (BreakTimerCommonNaturalTime* self,
                   gint time);
static gchar* ___lambda4__break_timer_common_natural_time_format_time_cb (gint seconds,
                                                                   gpointer self);
static void break_timer_common_natural_time_time_format_init (BreakTimerCommonNaturalTimeTimeFormat *self,
                                                       gint seconds,
                                                       BreakTimerCommonNaturalTimeFormatTimeCb format_time,
                                                       gpointer format_time_target);
static gchar* __lambda5_ (BreakTimerCommonNaturalTime* self,
                   gint time);
static gchar* ___lambda5__break_timer_common_natural_time_format_time_cb (gint seconds,
                                                                   gpointer self);
static gchar* __lambda6_ (BreakTimerCommonNaturalTime* self,
                   gint time);
static gchar* ___lambda6__break_timer_common_natural_time_format_time_cb (gint seconds,
                                                                   gpointer self);
static gchar* break_timer_common_natural_time_time_format_format_seconds (BreakTimerCommonNaturalTimeTimeFormat *self,
                                                                   gint seconds,
                                                                   gint* output_value);
static gint break_timer_common_natural_time_soften_seconds_for_countdown (BreakTimerCommonNaturalTime* self,
                                                                   gint seconds);
static void break_timer_common_natural_time_finalize (GObject * obj);
static GType break_timer_common_natural_time_get_type_once (void);
static void _vala_break_timer_common_natural_time_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);

static inline gpointer
break_timer_common_natural_time_get_instance_private (BreakTimerCommonNaturalTime* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerCommonNaturalTime_private_offset);
}

static gchar*
__lambda4_ (BreakTimerCommonNaturalTime* self,
            gint time)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup_printf (ngettext ("%d second", "%d seconds", (gulong) time), time);
	result = _tmp0_;
	return result;
}

static gchar*
___lambda4__break_timer_common_natural_time_format_time_cb (gint seconds,
                                                            gpointer self)
{
	gchar* result;
	result = __lambda4_ ((BreakTimerCommonNaturalTime*) self, seconds);
	return result;
}

static gchar*
__lambda5_ (BreakTimerCommonNaturalTime* self,
            gint time)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup_printf (ngettext ("%d minute", "%d minutes", (gulong) time), time);
	result = _tmp0_;
	return result;
}

static gchar*
___lambda5__break_timer_common_natural_time_format_time_cb (gint seconds,
                                                            gpointer self)
{
	gchar* result;
	result = __lambda5_ ((BreakTimerCommonNaturalTime*) self, seconds);
	return result;
}

static gchar*
__lambda6_ (BreakTimerCommonNaturalTime* self,
            gint time)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup_printf (ngettext ("%d hour", "%d hours", (gulong) time), time);
	result = _tmp0_;
	return result;
}

static gchar*
___lambda6__break_timer_common_natural_time_format_time_cb (gint seconds,
                                                            gpointer self)
{
	gchar* result;
	result = __lambda6_ ((BreakTimerCommonNaturalTime*) self, seconds);
	return result;
}

static BreakTimerCommonNaturalTime*
break_timer_common_natural_time_construct (GType object_type)
{
	BreakTimerCommonNaturalTime * self = NULL;
	BreakTimerCommonNaturalTimeTimeFormat _tmp0_ = {0};
	BreakTimerCommonNaturalTimeTimeFormat _tmp1_ = {0};
	BreakTimerCommonNaturalTimeTimeFormat _tmp2_ = {0};
	BreakTimerCommonNaturalTimeTimeFormat* _tmp3_;
	self = (BreakTimerCommonNaturalTime*) g_object_new (object_type, NULL);
	break_timer_common_natural_time_time_format_init (&_tmp0_, 1, ___lambda4__break_timer_common_natural_time_format_time_cb, self);
	break_timer_common_natural_time_time_format_init (&_tmp1_, 60, ___lambda5__break_timer_common_natural_time_format_time_cb, self);
	break_timer_common_natural_time_time_format_init (&_tmp2_, 3600, ___lambda6__break_timer_common_natural_time_format_time_cb, self);
	_tmp3_ = g_new0 (BreakTimerCommonNaturalTimeTimeFormat, 3);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp1_;
	_tmp3_[2] = _tmp2_;
	self->priv->units = (g_free (self->priv->units), NULL);
	self->priv->units = _tmp3_;
	self->priv->units_length1 = 3;
	self->priv->_units_size_ = self->priv->units_length1;
	return self;
}

static BreakTimerCommonNaturalTime*
break_timer_common_natural_time_new (void)
{
	return break_timer_common_natural_time_construct (BREAK_TIMER_COMMON_TYPE_NATURAL_TIME);
}

/**
     * Get a natural label for the given time in seconds. Converts seconds
     * to a unit that will represent the time as accurately as possible,
     * favouring precision over unit selection.
     * So, an input of 60 will return "1 minute", but 61 will return
     * "61 seconds".
     * @param seconds time in seconds.
     * @param output_value set to the numerical value of the output.
     * @return a string with a natural and accurate representation of the time.
     */
gchar*
break_timer_common_natural_time_get_label_for_seconds (BreakTimerCommonNaturalTime* self,
                                                       gint seconds,
                                                       gint* output_value)
{
	gint _vala_output_value = 0;
	BreakTimerCommonNaturalTimeTimeFormat label_unit = {0};
	BreakTimerCommonNaturalTimeTimeFormat* _tmp0_;
	gint _tmp0__length1;
	BreakTimerCommonNaturalTimeTimeFormat _tmp1_;
	BreakTimerCommonNaturalTimeTimeFormat* _tmp2_;
	gint _tmp2__length1;
	gint _tmp5_ = 0;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->units;
	_tmp0__length1 = self->priv->units_length1;
	_tmp1_ = _tmp0_[0];
	label_unit = _tmp1_;
	_tmp2_ = self->priv->units;
	_tmp2__length1 = self->priv->units_length1;
	{
		BreakTimerCommonNaturalTimeTimeFormat* unit_collection = NULL;
		gint unit_collection_length1 = 0;
		gint _unit_collection_size_ = 0;
		gint unit_it = 0;
		unit_collection = _tmp2_;
		unit_collection_length1 = _tmp2__length1;
		for (unit_it = 0; unit_it < unit_collection_length1; unit_it = unit_it + 1) {
			BreakTimerCommonNaturalTimeTimeFormat unit = {0};
			unit = unit_collection[unit_it];
			{
				BreakTimerCommonNaturalTimeTimeFormat _tmp3_;
				_tmp3_ = unit;
				if ((seconds % _tmp3_.seconds) == 0) {
					BreakTimerCommonNaturalTimeTimeFormat _tmp4_;
					_tmp4_ = unit;
					label_unit = _tmp4_;
					if (seconds == 0) {
						break;
					}
				}
			}
		}
	}
	_tmp6_ = break_timer_common_natural_time_time_format_format_seconds (&label_unit, seconds, &_tmp5_);
	_vala_output_value = _tmp5_;
	result = _tmp6_;
	if (output_value) {
		*output_value = _vala_output_value;
	}
	return result;
}

/**
     * Get a natural label for the given time in seconds. Converts seconds
     * to a unit that will represent the time as cleanly as possible,
     * favouring the simplest possible unit over precision.
     * So, an input of 60 will return "1 minute", and 61 will return the
     * same.
     * @param seconds time in seconds.
     * @param output_value set to the numerical value of the output.
     * @return a string with a natural and accurate representation of the time.
     */
gchar*
break_timer_common_natural_time_get_simplest_label_for_seconds (BreakTimerCommonNaturalTime* self,
                                                                gint seconds,
                                                                gint* output_value)
{
	gint _vala_output_value = 0;
	BreakTimerCommonNaturalTimeTimeFormat label_unit = {0};
	BreakTimerCommonNaturalTimeTimeFormat* _tmp0_;
	gint _tmp0__length1;
	BreakTimerCommonNaturalTimeTimeFormat _tmp1_;
	BreakTimerCommonNaturalTimeTimeFormat* _tmp2_;
	gint _tmp2__length1;
	gint _tmp5_ = 0;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->units;
	_tmp0__length1 = self->priv->units_length1;
	_tmp1_ = _tmp0_[0];
	label_unit = _tmp1_;
	_tmp2_ = self->priv->units;
	_tmp2__length1 = self->priv->units_length1;
	{
		BreakTimerCommonNaturalTimeTimeFormat* unit_collection = NULL;
		gint unit_collection_length1 = 0;
		gint _unit_collection_size_ = 0;
		gint unit_it = 0;
		unit_collection = _tmp2_;
		unit_collection_length1 = _tmp2__length1;
		for (unit_it = 0; unit_it < unit_collection_length1; unit_it = unit_it + 1) {
			BreakTimerCommonNaturalTimeTimeFormat unit = {0};
			unit = unit_collection[unit_it];
			{
				BreakTimerCommonNaturalTimeTimeFormat _tmp3_;
				_tmp3_ = unit;
				if (seconds >= _tmp3_.seconds) {
					BreakTimerCommonNaturalTimeTimeFormat _tmp4_;
					_tmp4_ = unit;
					label_unit = _tmp4_;
				}
			}
		}
	}
	_tmp6_ = break_timer_common_natural_time_time_format_format_seconds (&label_unit, seconds, &_tmp5_);
	_vala_output_value = _tmp5_;
	result = _tmp6_;
	if (output_value) {
		*output_value = _vala_output_value;
	}
	return result;
}

/**
     * Get a natural label for the given time in seconds, in an imprecise
     * format intented for a countdown. Precision is unimportant, so this
     * function softens the time by a gradually smaller interval as seconds
     * reaches 0.
     * @param seconds number of seconds remaining in the countdown.
     * @param output_value set to the numerical value of the output.
     * @return a string representing the time remaining.
     */
gchar*
break_timer_common_natural_time_get_countdown_for_seconds (BreakTimerCommonNaturalTime* self,
                                                           gint seconds,
                                                           gint* output_value)
{
	gint _vala_output_value = 0;
	gint seconds_softened = 0;
	gint _tmp0_ = 0;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	seconds_softened = break_timer_common_natural_time_soften_seconds_for_countdown (self, seconds);
	_tmp1_ = break_timer_common_natural_time_get_simplest_label_for_seconds (self, seconds_softened, &_tmp0_);
	_vala_output_value = _tmp0_;
	result = _tmp1_;
	if (output_value) {
		*output_value = _vala_output_value;
	}
	return result;
}

/**
     * Get a natural label for the given time in seconds, in an imprecise
     * format intented for a countdown. Precision is unimportant, so this
     * function softens the time by a gradually smaller interval as seconds
     * reaches 0.
     * When the remaining time is near the given start time, the start time
     * is shown instead, without being softened.
     * @param seconds number of seconds remaining in the countdown.
     * @param start countdown start time, in seconds, which will be shown exactly.
     * @param output_value set to the numerical value of the output.
     * @return a string representing the time remaining.
     */
gchar*
break_timer_common_natural_time_get_countdown_for_seconds_with_start (BreakTimerCommonNaturalTime* self,
                                                                      gint seconds,
                                                                      gint start,
                                                                      gint* output_value)
{
	gint _vala_output_value = 0;
	gint seconds_softened = 0;
	gint _tmp0_ = 0;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	seconds_softened = break_timer_common_natural_time_soften_seconds_for_countdown (self, seconds);
	if (seconds_softened > start) {
		seconds_softened = start;
	}
	_tmp1_ = break_timer_common_natural_time_get_simplest_label_for_seconds (self, seconds_softened, &_tmp0_);
	_vala_output_value = _tmp0_;
	result = _tmp1_;
	if (output_value) {
		*output_value = _vala_output_value;
	}
	return result;
}

static gint
break_timer_common_natural_time_soften_seconds_for_countdown (BreakTimerCommonNaturalTime* self,
                                                              gint seconds)
{
	gint interval = 0;
	gint time_softened = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	interval = 1;
	if (seconds <= 10) {
		interval = 1;
	} else {
		if (seconds <= 60) {
			interval = 10;
		} else {
			interval = 60;
		}
	}
	time_softened = ((seconds - 1) / interval) + 1;
	result = time_softened * interval;
	return result;
}

BreakTimerCommonNaturalTime*
break_timer_common_natural_time_get_instance (void)
{
	BreakTimerCommonNaturalTime* result;
	BreakTimerCommonNaturalTime* _tmp0_;
	BreakTimerCommonNaturalTime* _tmp2_;
	_tmp0_ = break_timer_common_natural_time__instance;
	if (_tmp0_ == NULL) {
		BreakTimerCommonNaturalTime* _tmp1_;
		_tmp1_ = break_timer_common_natural_time_new ();
		_g_object_unref0 (break_timer_common_natural_time__instance);
		break_timer_common_natural_time__instance = _tmp1_;
	}
	_tmp2_ = break_timer_common_natural_time__instance;
	result = _tmp2_;
	return result;
}

static void
break_timer_common_natural_time_time_format_init (BreakTimerCommonNaturalTimeTimeFormat *self,
                                                  gint seconds,
                                                  BreakTimerCommonNaturalTimeFormatTimeCb format_time,
                                                  gpointer format_time_target)
{
	memset (self, 0, sizeof (BreakTimerCommonNaturalTimeTimeFormat));
	(*self).seconds = seconds;
	(*self).format_time = format_time;
	(*self).format_time_target = format_time_target;
}

static gchar*
break_timer_common_natural_time_time_format_format_seconds (BreakTimerCommonNaturalTimeTimeFormat *self,
                                                            gint seconds,
                                                            gint* output_value)
{
	gint _vala_output_value = 0;
	BreakTimerCommonNaturalTimeFormatTimeCb _tmp0_;
	gpointer _tmp0__target;
	gchar* _tmp1_;
	gchar* result;
	_vala_output_value = seconds / (*self).seconds;
	_tmp0_ = (*self).format_time;
	_tmp0__target = (*self).format_time_target;
	_tmp1_ = _tmp0_ (_vala_output_value, _tmp0__target);
	result = _tmp1_;
	if (output_value) {
		*output_value = _vala_output_value;
	}
	return result;
}

static BreakTimerCommonNaturalTimeTimeFormat*
break_timer_common_natural_time_time_format_dup (const BreakTimerCommonNaturalTimeTimeFormat* self)
{
	BreakTimerCommonNaturalTimeTimeFormat* dup;
	dup = g_new0 (BreakTimerCommonNaturalTimeTimeFormat, 1);
	memcpy (dup, self, sizeof (BreakTimerCommonNaturalTimeTimeFormat));
	return dup;
}

static void
break_timer_common_natural_time_time_format_free (BreakTimerCommonNaturalTimeTimeFormat* self)
{
	g_free (self);
}

static GType
break_timer_common_natural_time_time_format_get_type_once (void)
{
	GType break_timer_common_natural_time_time_format_type_id;
	break_timer_common_natural_time_time_format_type_id = g_boxed_type_register_static ("BreakTimerCommonNaturalTimeTimeFormat", (GBoxedCopyFunc) break_timer_common_natural_time_time_format_dup, (GBoxedFreeFunc) break_timer_common_natural_time_time_format_free);
	return break_timer_common_natural_time_time_format_type_id;
}

static GType
break_timer_common_natural_time_time_format_get_type (void)
{
	static volatile gsize break_timer_common_natural_time_time_format_type_id__once = 0;
	if (g_once_init_enter (&break_timer_common_natural_time_time_format_type_id__once)) {
		GType break_timer_common_natural_time_time_format_type_id;
		break_timer_common_natural_time_time_format_type_id = break_timer_common_natural_time_time_format_get_type_once ();
		g_once_init_leave (&break_timer_common_natural_time_time_format_type_id__once, break_timer_common_natural_time_time_format_type_id);
	}
	return break_timer_common_natural_time_time_format_type_id__once;
}

static void
break_timer_common_natural_time_class_init (BreakTimerCommonNaturalTimeClass * klass,
                                            gpointer klass_data)
{
	break_timer_common_natural_time_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerCommonNaturalTime_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_break_timer_common_natural_time_get_property;
	G_OBJECT_CLASS (klass)->finalize = break_timer_common_natural_time_finalize;
}

static void
break_timer_common_natural_time_instance_init (BreakTimerCommonNaturalTime * self,
                                               gpointer klass)
{
	self->priv = break_timer_common_natural_time_get_instance_private (self);
}

static void
break_timer_common_natural_time_finalize (GObject * obj)
{
	BreakTimerCommonNaturalTime * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_COMMON_TYPE_NATURAL_TIME, BreakTimerCommonNaturalTime);
	self->priv->units = (g_free (self->priv->units), NULL);
	G_OBJECT_CLASS (break_timer_common_natural_time_parent_class)->finalize (obj);
}

static GType
break_timer_common_natural_time_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerCommonNaturalTimeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_common_natural_time_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerCommonNaturalTime), 0, (GInstanceInitFunc) break_timer_common_natural_time_instance_init, NULL };
	GType break_timer_common_natural_time_type_id;
	break_timer_common_natural_time_type_id = g_type_register_static (G_TYPE_OBJECT, "BreakTimerCommonNaturalTime", &g_define_type_info, 0);
	BreakTimerCommonNaturalTime_private_offset = g_type_add_instance_private (break_timer_common_natural_time_type_id, sizeof (BreakTimerCommonNaturalTimePrivate));
	return break_timer_common_natural_time_type_id;
}

GType
break_timer_common_natural_time_get_type (void)
{
	static volatile gsize break_timer_common_natural_time_type_id__once = 0;
	if (g_once_init_enter (&break_timer_common_natural_time_type_id__once)) {
		GType break_timer_common_natural_time_type_id;
		break_timer_common_natural_time_type_id = break_timer_common_natural_time_get_type_once ();
		g_once_init_leave (&break_timer_common_natural_time_type_id__once, break_timer_common_natural_time_type_id);
	}
	return break_timer_common_natural_time_type_id__once;
}

static void
_vala_break_timer_common_natural_time_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	BreakTimerCommonNaturalTime * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_COMMON_TYPE_NATURAL_TIME, BreakTimerCommonNaturalTime);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

