/* network-interface-graph.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from network-interface-graph.vala, do not modify */

/* network-interface-graph.vala
 *
 * Copyright (C) 2023–2025 Markus Göllnitz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Markus Göllnitz <camelcasenick@bewares.it>
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include <gsk/gsk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_NETWORK_INTERFACE_GRAPH (usage_network_interface_graph_get_type ())
#define USAGE_NETWORK_INTERFACE_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_NETWORK_INTERFACE_GRAPH, UsageNetworkInterfaceGraph))
#define USAGE_NETWORK_INTERFACE_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_NETWORK_INTERFACE_GRAPH, UsageNetworkInterfaceGraphClass))
#define USAGE_IS_NETWORK_INTERFACE_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_NETWORK_INTERFACE_GRAPH))
#define USAGE_IS_NETWORK_INTERFACE_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_NETWORK_INTERFACE_GRAPH))
#define USAGE_NETWORK_INTERFACE_GRAPH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_NETWORK_INTERFACE_GRAPH, UsageNetworkInterfaceGraphClass))

typedef struct _UsageNetworkInterfaceGraph UsageNetworkInterfaceGraph;
typedef struct _UsageNetworkInterfaceGraphClass UsageNetworkInterfaceGraphClass;
typedef struct _UsageNetworkInterfaceGraphPrivate UsageNetworkInterfaceGraphPrivate;

#define USAGE_TYPE_GRAPH (usage_graph_get_type ())
#define USAGE_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_GRAPH, UsageGraph))
#define USAGE_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_GRAPH, UsageGraphClass))
#define USAGE_IS_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_GRAPH))
#define USAGE_IS_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_GRAPH))
#define USAGE_GRAPH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_GRAPH, UsageGraphClass))

typedef struct _UsageGraph UsageGraph;
typedef struct _UsageGraphClass UsageGraphClass;

#define USAGE_TYPE_GRAPH_VIEW (usage_graph_view_get_type ())
#define USAGE_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_GRAPH_VIEW, UsageGraphView))
#define USAGE_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_GRAPH_VIEW, UsageGraphViewClass))
#define USAGE_IS_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_GRAPH_VIEW))
#define USAGE_IS_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_GRAPH_VIEW))
#define USAGE_GRAPH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_GRAPH_VIEW, UsageGraphViewClass))

typedef struct _UsageGraphView UsageGraphView;
typedef struct _UsageGraphViewClass UsageGraphViewClass;
enum  {
	USAGE_NETWORK_INTERFACE_GRAPH_0_PROPERTY,
	USAGE_NETWORK_INTERFACE_GRAPH_DOWNLOAD_GRAPH_PROPERTY,
	USAGE_NETWORK_INTERFACE_GRAPH_UPLOAD_GRAPH_PROPERTY,
	USAGE_NETWORK_INTERFACE_GRAPH_GRAPH_VIEW_PROPERTY,
	USAGE_NETWORK_INTERFACE_GRAPH_NUM_PROPERTIES
};
static GParamSpec* usage_network_interface_graph_properties[USAGE_NETWORK_INTERFACE_GRAPH_NUM_PROPERTIES];
typedef struct _UsageGraphPrivate UsageGraphPrivate;

#define USAGE_TYPE_GRAPH_POINT (usage_graph_point_get_type ())
typedef struct _UsageGraphPoint UsageGraphPoint;
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))
#define _usage_graph_unref0(var) ((var == NULL) ? NULL : (var = (usage_graph_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define USAGE_TYPE_GRAPH_BOX (usage_graph_box_get_type ())
#define USAGE_GRAPH_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_GRAPH_BOX, UsageGraphBox))
#define USAGE_GRAPH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_GRAPH_BOX, UsageGraphBoxClass))
#define USAGE_IS_GRAPH_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_GRAPH_BOX))
#define USAGE_IS_GRAPH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_GRAPH_BOX))
#define USAGE_GRAPH_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_GRAPH_BOX, UsageGraphBoxClass))

typedef struct _UsageGraphBox UsageGraphBox;
typedef struct _UsageGraphBoxClass UsageGraphBoxClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _UsageNetworkInterfaceGraph {
	AdwBin parent_instance;
	UsageNetworkInterfaceGraphPrivate * priv;
};

struct _UsageNetworkInterfaceGraphClass {
	AdwBinClass parent_class;
};

struct _UsageNetworkInterfaceGraphPrivate {
	UsageGraph* _download_graph;
	UsageGraph* _upload_graph;
	UsageGraphView* _graph_view;
	GtkLabel* y_label_max;
	GtkLabel* t_label_min;
	GtkLabel* t_label_max;
};

struct _UsageGraphPoint {
	gint64 timestamp;
	gdouble level;
};

struct _UsageGraph {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UsageGraphPrivate * priv;
	GskRenderNode* render_node;
	GQueue* values;
	guint maximal_queue_length;
	GdkRGBA* color;
};

struct _UsageGraphClass {
	GTypeClass parent_class;
	void (*finalize) (UsageGraph *self);
};

static gint UsageNetworkInterfaceGraph_private_offset;
static gpointer usage_network_interface_graph_parent_class = NULL;
VALA_EXTERN GtkSizeGroup* usage_network_interface_graph_y_labels_group;
GtkSizeGroup* usage_network_interface_graph_y_labels_group = NULL;

VALA_EXTERN GType usage_network_interface_graph_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageNetworkInterfaceGraph, g_object_unref)
VALA_EXTERN gpointer usage_graph_ref (gpointer instance);
VALA_EXTERN void usage_graph_unref (gpointer instance);
VALA_EXTERN GParamSpec* usage_param_spec_graph (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void usage_value_set_graph (GValue* value,
                            gpointer v_object);
VALA_EXTERN void usage_value_take_graph (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer usage_value_get_graph (const GValue* value);
VALA_EXTERN GType usage_graph_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageGraph, usage_graph_unref)
VALA_EXTERN GType usage_graph_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageGraphView, g_object_unref)
static GdkRGBA* _vala_GdkRGBA_copy (GdkRGBA* self);
VALA_EXTERN UsageGraph* usage_graph_new (void);
VALA_EXTERN UsageGraph* usage_graph_construct (GType object_type);
VALA_EXTERN GType usage_graph_point_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UsageGraphPoint* usage_graph_point_dup (const UsageGraphPoint* self);
VALA_EXTERN void usage_graph_point_free (UsageGraphPoint* self);
static void _vala_GdkRGBA_free (GdkRGBA* self);
VALA_EXTERN UsageGraphView* usage_graph_view_new (void);
VALA_EXTERN UsageGraphView* usage_graph_view_construct (GType object_type);
VALA_EXTERN UsageNetworkInterfaceGraph* usage_network_interface_graph_new (void);
VALA_EXTERN UsageNetworkInterfaceGraph* usage_network_interface_graph_construct (GType object_type);
VALA_EXTERN UsageGraphView* usage_network_interface_graph_get_graph_view (UsageNetworkInterfaceGraph* self);
VALA_EXTERN void usage_graph_view_add_graph (UsageGraphView* self,
                                 UsageGraph* graph);
VALA_EXTERN UsageGraph* usage_network_interface_graph_get_download_graph (UsageNetworkInterfaceGraph* self);
VALA_EXTERN UsageGraph* usage_network_interface_graph_get_upload_graph (UsageNetworkInterfaceGraph* self);
VALA_EXTERN GType usage_graph_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageGraphBox, g_object_unref)
VALA_EXTERN UsageGraphBox* usage_graph_box_new (UsageGraphView* graph);
VALA_EXTERN UsageGraphBox* usage_graph_box_construct (GType object_type,
                                          UsageGraphView* graph);
VALA_EXTERN gchar* usage_utils_format_size_values (guint64 value,
                                       gulong** most_significant);
VALA_EXTERN void usage_network_interface_graph_set_ranges (UsageNetworkInterfaceGraph* self,
                                               gint64 min_timestamp,
                                               gint64 max_timestamp,
                                               gint64 max_val);
VALA_EXTERN void usage_graph_view_set_offset_x (UsageGraphView* self,
                                    gint64 value);
VALA_EXTERN void usage_graph_view_set_offset_y (UsageGraphView* self,
                                    gint64 value);
VALA_EXTERN void usage_graph_view_set_range_x (UsageGraphView* self,
                                   gint64 value);
VALA_EXTERN void usage_graph_view_set_range_y (UsageGraphView* self,
                                   gint64 value);
VALA_EXTERN gint64 usage_graph_view_get_range_y (UsageGraphView* self);
static void usage_network_interface_graph_set_download_graph (UsageNetworkInterfaceGraph* self,
                                                       UsageGraph* value);
static void usage_network_interface_graph_set_upload_graph (UsageNetworkInterfaceGraph* self,
                                                     UsageGraph* value);
static void usage_network_interface_graph_set_graph_view (UsageNetworkInterfaceGraph* self,
                                                   UsageGraphView* value);
static void usage_network_interface_graph_finalize (GObject * obj);
static GType usage_network_interface_graph_get_type_once (void);
static void _vala_usage_network_interface_graph_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_usage_network_interface_graph_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_network_interface_graph_get_instance_private (UsageNetworkInterfaceGraph* self)
{
	return G_STRUCT_MEMBER_P (self, UsageNetworkInterfaceGraph_private_offset);
}

static GdkRGBA*
_vala_GdkRGBA_copy (GdkRGBA* self)
{
	return g_boxed_copy (gdk_rgba_get_type (), self);
}

static gpointer
__vala_GdkRGBA_copy0 (gpointer self)
{
	return self ? _vala_GdkRGBA_copy (self) : NULL;
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

UsageNetworkInterfaceGraph*
usage_network_interface_graph_construct (GType object_type)
{
	UsageNetworkInterfaceGraph * self = NULL;
	UsageGraphView* _tmp0_;
	UsageGraphView* _tmp1_;
	UsageGraph* _tmp2_;
	UsageGraphView* _tmp3_;
	UsageGraph* _tmp4_;
	UsageGraphBox* network_graph_box = NULL;
	UsageGraphView* _tmp5_;
	UsageGraphBox* _tmp6_;
	GtkLabel* y_label_min = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkBox* y_labels = NULL;
	GtkBox* _tmp12_;
	GtkSizeGroup* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkBox* timestamp_labels = NULL;
	GtkBox* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkLabel* _tmp26_;
	GtkGrid* network_box = NULL;
	GtkGrid* _tmp27_;
	self = (UsageNetworkInterfaceGraph*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->_graph_view;
	gtk_widget_add_css_class ((GtkWidget*) _tmp0_, "big");
	_tmp1_ = self->priv->_graph_view;
	_tmp2_ = self->priv->_download_graph;
	usage_graph_view_add_graph (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->_graph_view;
	_tmp4_ = self->priv->_upload_graph;
	usage_graph_view_add_graph (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->_graph_view;
	_tmp6_ = usage_graph_box_new (_tmp5_);
	g_object_ref_sink (_tmp6_);
	network_graph_box = _tmp6_;
	g_object_set ((GtkWidget*) network_graph_box, "height-request", 225, NULL);
	gtk_widget_set_valign ((GtkWidget*) network_graph_box, GTK_ALIGN_START);
	gtk_widget_add_css_class ((GtkWidget*) network_graph_box, "card");
	_tmp7_ = usage_utils_format_size_values ((guint64) 0, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = (GtkLabel*) gtk_label_new (_tmp8_);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	y_label_min = _tmp10_;
	_tmp11_ = (GtkLabel*) gtk_label_new ("…");
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->y_label_max);
	self->priv->y_label_max = _tmp11_;
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp12_);
	y_labels = _tmp12_;
	_tmp13_ = usage_network_interface_graph_y_labels_group;
	gtk_size_group_add_widget (_tmp13_, (GtkWidget*) y_labels);
	_tmp14_ = self->priv->y_label_max;
	gtk_box_append (y_labels, (GtkWidget*) _tmp14_);
	gtk_box_append (y_labels, (GtkWidget*) y_label_min);
	gtk_label_set_xalign (y_label_min, (gfloat) 1);
	_tmp15_ = self->priv->y_label_max;
	gtk_label_set_xalign (_tmp15_, (gfloat) 1);
	_tmp16_ = self->priv->y_label_max;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp16_, TRUE);
	_tmp17_ = self->priv->y_label_max;
	gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_START);
	_tmp18_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp18_);
	timestamp_labels = _tmp18_;
	_tmp19_ = (GtkLabel*) gtk_label_new ("…");
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->t_label_min);
	self->priv->t_label_min = _tmp19_;
	_tmp20_ = self->priv->t_label_min;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp20_, TRUE);
	_tmp21_ = self->priv->t_label_min;
	gtk_widget_set_halign ((GtkWidget*) _tmp21_, GTK_ALIGN_START);
	_tmp22_ = (GtkLabel*) gtk_label_new ("…");
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->t_label_max);
	self->priv->t_label_max = _tmp22_;
	_tmp23_ = self->priv->t_label_max;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp23_, TRUE);
	_tmp24_ = self->priv->t_label_max;
	gtk_widget_set_halign ((GtkWidget*) _tmp24_, GTK_ALIGN_END);
	_tmp25_ = self->priv->t_label_min;
	gtk_box_append (timestamp_labels, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->t_label_max;
	gtk_box_append (timestamp_labels, (GtkWidget*) _tmp26_);
	_tmp27_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp27_);
	network_box = _tmp27_;
	gtk_grid_set_column_spacing (network_box, 6);
	gtk_grid_set_row_spacing (network_box, 6);
	gtk_widget_set_valign ((GtkWidget*) network_box, GTK_ALIGN_START);
	gtk_grid_attach (network_box, (GtkWidget*) y_labels, 0, 0, 1, 1);
	gtk_grid_attach (network_box, (GtkWidget*) network_graph_box, 1, 0, 1, 1);
	gtk_grid_attach (network_box, (GtkWidget*) timestamp_labels, 1, 1, 1, 1);
	adw_bin_set_child ((AdwBin*) self, (GtkWidget*) network_box);
	_g_object_unref0 (network_box);
	_g_object_unref0 (timestamp_labels);
	_g_object_unref0 (y_labels);
	_g_object_unref0 (y_label_min);
	_g_object_unref0 (network_graph_box);
	return self;
}

UsageNetworkInterfaceGraph*
usage_network_interface_graph_new (void)
{
	return usage_network_interface_graph_construct (USAGE_TYPE_NETWORK_INTERFACE_GRAPH);
}

void
usage_network_interface_graph_set_ranges (UsageNetworkInterfaceGraph* self,
                                          gint64 min_timestamp,
                                          gint64 max_timestamp,
                                          gint64 max_val)
{
	GDateTime* start_date = NULL;
	GDateTime* _tmp0_;
	GDateTime* end_date = NULL;
	GDateTime* _tmp1_;
	UsageGraphView* _tmp2_;
	UsageGraphView* _tmp3_;
	UsageGraphView* _tmp4_;
	UsageGraphView* _tmp5_;
	GtkLabel* _tmp6_;
	UsageGraphView* _tmp7_;
	gint64 _tmp8_;
	gint64 _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkLabel* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GtkLabel* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_date_time_new_from_unix_local (min_timestamp);
	start_date = _tmp0_;
	_tmp1_ = g_date_time_new_from_unix_local (max_timestamp);
	end_date = _tmp1_;
	_tmp2_ = self->priv->_graph_view;
	usage_graph_view_set_offset_x (_tmp2_, min_timestamp);
	_tmp3_ = self->priv->_graph_view;
	usage_graph_view_set_offset_y (_tmp3_, (gint64) 0);
	_tmp4_ = self->priv->_graph_view;
	usage_graph_view_set_range_x (_tmp4_, max_timestamp - min_timestamp);
	_tmp5_ = self->priv->_graph_view;
	usage_graph_view_set_range_y (_tmp5_, (gint64) max_val);
	_tmp6_ = self->priv->y_label_max;
	_tmp7_ = self->priv->_graph_view;
	_tmp8_ = usage_graph_view_get_range_y (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = usage_utils_format_size_values ((guint64) _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	gtk_label_set_label (_tmp6_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = self->priv->t_label_min;
	_tmp13_ = g_date_time_format (start_date, _ ("%b %e, %Y"));
	_tmp14_ = _tmp13_;
	gtk_label_set_label (_tmp12_, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = self->priv->t_label_max;
	_tmp16_ = g_date_time_format (end_date, _ ("%b %e, %Y"));
	_tmp17_ = _tmp16_;
	gtk_label_set_label (_tmp15_, _tmp17_);
	_g_free0 (_tmp17_);
	_g_date_time_unref0 (end_date);
	_g_date_time_unref0 (start_date);
}

UsageGraph*
usage_network_interface_graph_get_download_graph (UsageNetworkInterfaceGraph* self)
{
	UsageGraph* result;
	UsageGraph* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_download_graph;
	result = _tmp0_;
	return result;
}

static gpointer
_usage_graph_ref0 (gpointer self)
{
	return self ? usage_graph_ref (self) : NULL;
}

static void
usage_network_interface_graph_set_download_graph (UsageNetworkInterfaceGraph* self,
                                                  UsageGraph* value)
{
	UsageGraph* old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_network_interface_graph_get_download_graph (self);
	if (old_value != value) {
		UsageGraph* _tmp0_;
		_tmp0_ = _usage_graph_ref0 (value);
		_usage_graph_unref0 (self->priv->_download_graph);
		self->priv->_download_graph = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, usage_network_interface_graph_properties[USAGE_NETWORK_INTERFACE_GRAPH_DOWNLOAD_GRAPH_PROPERTY]);
	}
}

UsageGraph*
usage_network_interface_graph_get_upload_graph (UsageNetworkInterfaceGraph* self)
{
	UsageGraph* result;
	UsageGraph* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_upload_graph;
	result = _tmp0_;
	return result;
}

static void
usage_network_interface_graph_set_upload_graph (UsageNetworkInterfaceGraph* self,
                                                UsageGraph* value)
{
	UsageGraph* old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_network_interface_graph_get_upload_graph (self);
	if (old_value != value) {
		UsageGraph* _tmp0_;
		_tmp0_ = _usage_graph_ref0 (value);
		_usage_graph_unref0 (self->priv->_upload_graph);
		self->priv->_upload_graph = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, usage_network_interface_graph_properties[USAGE_NETWORK_INTERFACE_GRAPH_UPLOAD_GRAPH_PROPERTY]);
	}
}

UsageGraphView*
usage_network_interface_graph_get_graph_view (UsageNetworkInterfaceGraph* self)
{
	UsageGraphView* result;
	UsageGraphView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_graph_view;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
usage_network_interface_graph_set_graph_view (UsageNetworkInterfaceGraph* self,
                                              UsageGraphView* value)
{
	UsageGraphView* old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_network_interface_graph_get_graph_view (self);
	if (old_value != value) {
		UsageGraphView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_graph_view);
		self->priv->_graph_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, usage_network_interface_graph_properties[USAGE_NETWORK_INTERFACE_GRAPH_GRAPH_VIEW_PROPERTY]);
	}
}

static void
usage_network_interface_graph_class_init (UsageNetworkInterfaceGraphClass * klass,
                                          gpointer klass_data)
{
	GtkSizeGroup* _tmp0_;
	usage_network_interface_graph_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageNetworkInterfaceGraph_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_usage_network_interface_graph_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_usage_network_interface_graph_set_property;
	G_OBJECT_CLASS (klass)->finalize = usage_network_interface_graph_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_NETWORK_INTERFACE_GRAPH_DOWNLOAD_GRAPH_PROPERTY, usage_network_interface_graph_properties[USAGE_NETWORK_INTERFACE_GRAPH_DOWNLOAD_GRAPH_PROPERTY] = usage_param_spec_graph ("download-graph", "download-graph", "download-graph", USAGE_TYPE_GRAPH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_NETWORK_INTERFACE_GRAPH_UPLOAD_GRAPH_PROPERTY, usage_network_interface_graph_properties[USAGE_NETWORK_INTERFACE_GRAPH_UPLOAD_GRAPH_PROPERTY] = usage_param_spec_graph ("upload-graph", "upload-graph", "upload-graph", USAGE_TYPE_GRAPH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_NETWORK_INTERFACE_GRAPH_GRAPH_VIEW_PROPERTY, usage_network_interface_graph_properties[USAGE_NETWORK_INTERFACE_GRAPH_GRAPH_VIEW_PROPERTY] = g_param_spec_object ("graph-view", "graph-view", "graph-view", USAGE_TYPE_GRAPH_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	usage_network_interface_graph_y_labels_group = _tmp0_;
}

static void
usage_network_interface_graph_instance_init (UsageNetworkInterfaceGraph * self,
                                             gpointer klass)
{
	GdkRGBA _tmp0_ = {0};
	GdkRGBA* _tmp1_;
	UsageGraph* _tmp2_ = NULL;
	GdkRGBA _tmp3_ = {0};
	GdkRGBA* _tmp4_;
	UsageGraph* _tmp5_ = NULL;
	UsageGraphView* _tmp6_;
	self->priv = usage_network_interface_graph_get_instance_private (self);
	memset (&_tmp0_, 0, sizeof (GdkRGBA));
	_tmp0_.red = 46.f / 255.f;
	_tmp0_.green = 194.f / 255.f;
	_tmp0_.blue = 126.f / 255.f;
	_tmp0_.alpha = 1.f;
	_tmp1_ = __vala_GdkRGBA_copy0 (&_tmp0_);
	_tmp2_ = usage_graph_new ();
	__vala_GdkRGBA_free0 (_tmp2_->color);
	_tmp2_->color = _tmp1_;
	self->priv->_download_graph = _tmp2_;
	memset (&_tmp3_, 0, sizeof (GdkRGBA));
	_tmp3_.red = 192.f / 255.f;
	_tmp3_.green = 97.f / 255.f;
	_tmp3_.blue = 203.f / 255.f;
	_tmp3_.alpha = 1.f;
	_tmp4_ = __vala_GdkRGBA_copy0 (&_tmp3_);
	_tmp5_ = usage_graph_new ();
	__vala_GdkRGBA_free0 (_tmp5_->color);
	_tmp5_->color = _tmp4_;
	self->priv->_upload_graph = _tmp5_;
	_tmp6_ = usage_graph_view_new ();
	g_object_ref_sink (_tmp6_);
	self->priv->_graph_view = _tmp6_;
}

static void
usage_network_interface_graph_finalize (GObject * obj)
{
	UsageNetworkInterfaceGraph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_NETWORK_INTERFACE_GRAPH, UsageNetworkInterfaceGraph);
	_usage_graph_unref0 (self->priv->_download_graph);
	_usage_graph_unref0 (self->priv->_upload_graph);
	_g_object_unref0 (self->priv->_graph_view);
	_g_object_unref0 (self->priv->y_label_max);
	_g_object_unref0 (self->priv->t_label_min);
	_g_object_unref0 (self->priv->t_label_max);
	G_OBJECT_CLASS (usage_network_interface_graph_parent_class)->finalize (obj);
}

static GType
usage_network_interface_graph_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageNetworkInterfaceGraphClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_network_interface_graph_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageNetworkInterfaceGraph), 0, (GInstanceInitFunc) usage_network_interface_graph_instance_init, NULL };
	GType usage_network_interface_graph_type_id;
	usage_network_interface_graph_type_id = g_type_register_static (adw_bin_get_type (), "UsageNetworkInterfaceGraph", &g_define_type_info, 0);
	UsageNetworkInterfaceGraph_private_offset = g_type_add_instance_private (usage_network_interface_graph_type_id, sizeof (UsageNetworkInterfaceGraphPrivate));
	return usage_network_interface_graph_type_id;
}

GType
usage_network_interface_graph_get_type (void)
{
	static volatile gsize usage_network_interface_graph_type_id__once = 0;
	if (g_once_init_enter (&usage_network_interface_graph_type_id__once)) {
		GType usage_network_interface_graph_type_id;
		usage_network_interface_graph_type_id = usage_network_interface_graph_get_type_once ();
		g_once_init_leave (&usage_network_interface_graph_type_id__once, usage_network_interface_graph_type_id);
	}
	return usage_network_interface_graph_type_id__once;
}

static void
_vala_usage_network_interface_graph_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	UsageNetworkInterfaceGraph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_NETWORK_INTERFACE_GRAPH, UsageNetworkInterfaceGraph);
	switch (property_id) {
		case USAGE_NETWORK_INTERFACE_GRAPH_DOWNLOAD_GRAPH_PROPERTY:
		usage_value_set_graph (value, usage_network_interface_graph_get_download_graph (self));
		break;
		case USAGE_NETWORK_INTERFACE_GRAPH_UPLOAD_GRAPH_PROPERTY:
		usage_value_set_graph (value, usage_network_interface_graph_get_upload_graph (self));
		break;
		case USAGE_NETWORK_INTERFACE_GRAPH_GRAPH_VIEW_PROPERTY:
		g_value_set_object (value, usage_network_interface_graph_get_graph_view (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_usage_network_interface_graph_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	UsageNetworkInterfaceGraph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_NETWORK_INTERFACE_GRAPH, UsageNetworkInterfaceGraph);
	switch (property_id) {
		case USAGE_NETWORK_INTERFACE_GRAPH_DOWNLOAD_GRAPH_PROPERTY:
		usage_network_interface_graph_set_download_graph (self, usage_value_get_graph (value));
		break;
		case USAGE_NETWORK_INTERFACE_GRAPH_UPLOAD_GRAPH_PROPERTY:
		usage_network_interface_graph_set_upload_graph (self, usage_value_get_graph (value));
		break;
		case USAGE_NETWORK_INTERFACE_GRAPH_GRAPH_VIEW_PROPERTY:
		usage_network_interface_graph_set_graph_view (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

