{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A t'GI.Gdk.Objects.Cursor.Cursor' represents a cursor. Its contents are private.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.Cursor
    ( 

-- * Exported types
    Cursor(..)                              ,
    IsCursor                                ,
    toCursor                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.Gdk.Objects.Cursor#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.Gdk.Objects.Cursor#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCursorType]("GI.Gdk.Objects.Cursor#g:method:getCursorType"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDisplay]("GI.Gdk.Objects.Cursor#g:method:getDisplay"), [getImage]("GI.Gdk.Objects.Cursor#g:method:getImage"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSurface]("GI.Gdk.Objects.Cursor#g:method:getSurface").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveCursorMethod                     ,
#endif

-- ** getCursorType #method:getCursorType#

#if defined(ENABLE_OVERLOADING)
    CursorGetCursorTypeMethodInfo           ,
#endif
    cursorGetCursorType                     ,


-- ** getDisplay #method:getDisplay#

#if defined(ENABLE_OVERLOADING)
    CursorGetDisplayMethodInfo              ,
#endif
    cursorGetDisplay                        ,


-- ** getImage #method:getImage#

#if defined(ENABLE_OVERLOADING)
    CursorGetImageMethodInfo                ,
#endif
    cursorGetImage                          ,


-- ** getSurface #method:getSurface#

#if defined(ENABLE_OVERLOADING)
    CursorGetSurfaceMethodInfo              ,
#endif
    cursorGetSurface                        ,


-- ** new #method:new#

    cursorNew                               ,


-- ** newForDisplay #method:newForDisplay#

    cursorNewForDisplay                     ,


-- ** newFromName #method:newFromName#

    cursorNewFromName                       ,


-- ** newFromPixbuf #method:newFromPixbuf#

    cursorNewFromPixbuf                     ,


-- ** newFromSurface #method:newFromSurface#

    cursorNewFromSurface                    ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    CursorRefMethodInfo                     ,
#endif
    cursorRef                               ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    CursorUnrefMethodInfo                   ,
#endif
    cursorUnref                             ,




 -- * Properties


-- ** cursorType #attr:cursorType#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    CursorCursorTypePropertyInfo            ,
#endif
    constructCursorCursorType               ,
#if defined(ENABLE_OVERLOADING)
    cursorCursorType                        ,
#endif
    getCursorCursorType                     ,


-- ** display #attr:display#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    CursorDisplayPropertyInfo               ,
#endif
    constructCursorDisplay                  ,
#if defined(ENABLE_OVERLOADING)
    cursorDisplay                           ,
#endif
    getCursorDisplay                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf

#endif

-- | Memory-managed wrapper type.
newtype Cursor = Cursor (SP.ManagedPtr Cursor)
    deriving (Eq)

instance SP.ManagedPtrNewtype Cursor where
    toManagedPtr (Cursor p) = p

foreign import ccall "gdk_cursor_get_type"
    c_gdk_cursor_get_type :: IO B.Types.GType

instance B.Types.TypedObject Cursor where
    glibType = c_gdk_cursor_get_type

instance B.Types.GObject Cursor

-- | Type class for types which can be safely cast to t'Cursor', for instance with `toCursor`.
class (SP.GObject o, O.IsDescendantOf Cursor o) => IsCursor o
instance (SP.GObject o, O.IsDescendantOf Cursor o) => IsCursor o

instance O.HasParentTypes Cursor
type instance O.ParentTypes Cursor = '[GObject.Object.Object]

-- | Cast to t'Cursor', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toCursor :: (MIO.MonadIO m, IsCursor o) => o -> m Cursor
toCursor = MIO.liftIO . B.ManagedPtr.unsafeCastTo Cursor

-- | Convert t'Cursor' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Cursor) where
    gvalueGType_ = c_gdk_cursor_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Cursor)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Cursor)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Cursor ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveCursorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCursorMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveCursorMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveCursorMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveCursorMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveCursorMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveCursorMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveCursorMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveCursorMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveCursorMethod "ref" o = CursorRefMethodInfo
    ResolveCursorMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveCursorMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveCursorMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveCursorMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveCursorMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveCursorMethod "unref" o = CursorUnrefMethodInfo
    ResolveCursorMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveCursorMethod "getCursorType" o = CursorGetCursorTypeMethodInfo
    ResolveCursorMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveCursorMethod "getDisplay" o = CursorGetDisplayMethodInfo
    ResolveCursorMethod "getImage" o = CursorGetImageMethodInfo
    ResolveCursorMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveCursorMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveCursorMethod "getSurface" o = CursorGetSurfaceMethodInfo
    ResolveCursorMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveCursorMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveCursorMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveCursorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCursorMethod t Cursor, O.OverloadedMethod info Cursor p) => OL.IsLabel t (Cursor -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCursorMethod t Cursor, O.OverloadedMethod info Cursor p, R.HasField t Cursor p) => R.HasField t Cursor p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCursorMethod t Cursor, O.OverloadedMethodInfo info Cursor) => OL.IsLabel t (O.MethodProxy info Cursor) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "cursor-type"
   -- Type: TInterface (Name {namespace = "Gdk", name = "CursorType"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@cursor-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' cursor #cursorType
-- @
getCursorCursorType :: (MonadIO m, IsCursor o) => o -> m Gdk.Enums.CursorType
getCursorCursorType obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "cursor-type"

-- | Construct a t'GValueConstruct' with valid value for the “@cursor-type@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCursorCursorType :: (IsCursor o, MIO.MonadIO m) => Gdk.Enums.CursorType -> m (GValueConstruct o)
constructCursorCursorType val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "cursor-type" val

#if defined(ENABLE_OVERLOADING)
data CursorCursorTypePropertyInfo
instance AttrInfo CursorCursorTypePropertyInfo where
    type AttrAllowedOps CursorCursorTypePropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint CursorCursorTypePropertyInfo = IsCursor
    type AttrSetTypeConstraint CursorCursorTypePropertyInfo = (~) Gdk.Enums.CursorType
    type AttrTransferTypeConstraint CursorCursorTypePropertyInfo = (~) Gdk.Enums.CursorType
    type AttrTransferType CursorCursorTypePropertyInfo = Gdk.Enums.CursorType
    type AttrGetType CursorCursorTypePropertyInfo = Gdk.Enums.CursorType
    type AttrLabel CursorCursorTypePropertyInfo = "cursor-type"
    type AttrOrigin CursorCursorTypePropertyInfo = Cursor
    attrGet = getCursorCursorType
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructCursorCursorType
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Cursor.cursorType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Cursor.html#g:attr:cursorType"
        })
#endif

-- VVV Prop "display"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Display"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' cursor #display
-- @
getCursorDisplay :: (MonadIO m, IsCursor o) => o -> m Gdk.Display.Display
getCursorDisplay obj = MIO.liftIO $ checkUnexpectedNothing "getCursorDisplay" $ B.Properties.getObjectPropertyObject obj "display" Gdk.Display.Display

-- | Construct a t'GValueConstruct' with valid value for the “@display@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCursorDisplay :: (IsCursor o, MIO.MonadIO m, Gdk.Display.IsDisplay a) => a -> m (GValueConstruct o)
constructCursorDisplay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "display" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data CursorDisplayPropertyInfo
instance AttrInfo CursorDisplayPropertyInfo where
    type AttrAllowedOps CursorDisplayPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint CursorDisplayPropertyInfo = IsCursor
    type AttrSetTypeConstraint CursorDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferTypeConstraint CursorDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferType CursorDisplayPropertyInfo = Gdk.Display.Display
    type AttrGetType CursorDisplayPropertyInfo = Gdk.Display.Display
    type AttrLabel CursorDisplayPropertyInfo = "display"
    type AttrOrigin CursorDisplayPropertyInfo = Cursor
    attrGet = getCursorDisplay
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Display.Display v
    attrConstruct = constructCursorDisplay
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Cursor.display"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Cursor.html#g:attr:display"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Cursor
type instance O.AttributeList Cursor = CursorAttributeList
type CursorAttributeList = ('[ '("cursorType", CursorCursorTypePropertyInfo), '("display", CursorDisplayPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
cursorCursorType :: AttrLabelProxy "cursorType"
cursorCursorType = AttrLabelProxy

cursorDisplay :: AttrLabelProxy "display"
cursorDisplay = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Cursor = CursorSignalList
type CursorSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Cursor::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "cursor_type"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "CursorType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "cursor to create" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Cursor" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cursor_new" gdk_cursor_new :: 
    CInt ->                                 -- cursor_type : TInterface (Name {namespace = "Gdk", name = "CursorType"})
    IO (Ptr Cursor)

{-# DEPRECATED cursorNew ["(Since version 3.16)","Use 'GI.Gdk.Objects.Cursor.cursorNewForDisplay' instead."] #-}
-- | Creates a new cursor from the set of builtin cursors for the default display.
-- See 'GI.Gdk.Objects.Cursor.cursorNewForDisplay'.
-- 
-- To make the cursor invisible, use 'GI.Gdk.Enums.CursorTypeBlankCursor'.
cursorNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gdk.Enums.CursorType
    -- ^ /@cursorType@/: cursor to create
    -> m Cursor
    -- ^ __Returns:__ a new t'GI.Gdk.Objects.Cursor.Cursor'
cursorNew cursorType = liftIO $ do
    let cursorType' = (fromIntegral . fromEnum) cursorType
    result <- gdk_cursor_new cursorType'
    checkUnexpectedReturnNULL "cursorNew" result
    result' <- (wrapObject Cursor) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Cursor::new_for_display
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GdkDisplay for which the cursor will be created"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cursor_type"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "CursorType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "cursor to create" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Cursor" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cursor_new_for_display" gdk_cursor_new_for_display :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    CInt ->                                 -- cursor_type : TInterface (Name {namespace = "Gdk", name = "CursorType"})
    IO (Ptr Cursor)

-- | Creates a new cursor from the set of builtin cursors.
-- 
-- /Since: 2.2/
cursorNewForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a) =>
    a
    -- ^ /@display@/: the t'GI.Gdk.Objects.Display.Display' for which the cursor will be created
    -> Gdk.Enums.CursorType
    -- ^ /@cursorType@/: cursor to create
    -> m (Maybe Cursor)
    -- ^ __Returns:__ a new t'GI.Gdk.Objects.Cursor.Cursor', or 'P.Nothing' on failure
cursorNewForDisplay display cursorType = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    let cursorType' = (fromIntegral . fromEnum) cursorType
    result <- gdk_cursor_new_for_display display' cursorType'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Cursor) result'
        return result''
    touchManagedPtr display
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method Cursor::new_from_name
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GdkDisplay for which the cursor will be created"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the cursor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Cursor" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cursor_new_from_name" gdk_cursor_new_from_name :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr Cursor)

-- | Creates a new cursor by looking up /@name@/ in the current cursor
-- theme.
-- 
-- A recommended set of cursor names that will work across different
-- platforms can be found in the CSS specification:
-- * \"none\"
-- * <<http://developer.gnome.org/gdk/stable/default_cursor.png>> \"default\"
-- * <<http://developer.gnome.org/gdk/stable/help_cursor.png>> \"help\"
-- * <<http://developer.gnome.org/gdk/stable/pointer_cursor.png>> \"pointer\"
-- * <<http://developer.gnome.org/gdk/stable/context_menu_cursor.png>> \"context-menu\"
-- * <<http://developer.gnome.org/gdk/stable/progress_cursor.png>> \"progress\"
-- * <<http://developer.gnome.org/gdk/stable/wait_cursor.png>> \"wait\"
-- * <<http://developer.gnome.org/gdk/stable/cell_cursor.png>> \"cell\"
-- * <<http://developer.gnome.org/gdk/stable/crosshair_cursor.png>> \"crosshair\"
-- * <<http://developer.gnome.org/gdk/stable/text_cursor.png>> \"text\"
-- * <<http://developer.gnome.org/gdk/stable/vertical_text_cursor.png>> \"vertical-text\"
-- * <<http://developer.gnome.org/gdk/stable/alias_cursor.png>> \"alias\"
-- * <<http://developer.gnome.org/gdk/stable/copy_cursor.png>> \"copy\"
-- * <<http://developer.gnome.org/gdk/stable/no_drop_cursor.png>> \"no-drop\"
-- * <<http://developer.gnome.org/gdk/stable/move_cursor.png>> \"move\"
-- * <<http://developer.gnome.org/gdk/stable/not_allowed_cursor.png>> \"not-allowed\"
-- * <<http://developer.gnome.org/gdk/stable/grab_cursor.png>> \"grab\"
-- * <<http://developer.gnome.org/gdk/stable/grabbing_cursor.png>> \"grabbing\"
-- * <<http://developer.gnome.org/gdk/stable/all_scroll_cursor.png>> \"all-scroll\"
-- * <<http://developer.gnome.org/gdk/stable/col_resize_cursor.png>> \"col-resize\"
-- * <<http://developer.gnome.org/gdk/stable/row_resize_cursor.png>> \"row-resize\"
-- * <<http://developer.gnome.org/gdk/stable/n_resize_cursor.png>> \"n-resize\"
-- * <<http://developer.gnome.org/gdk/stable/e_resize_cursor.png>> \"e-resize\"
-- * <<http://developer.gnome.org/gdk/stable/s_resize_cursor.png>> \"s-resize\"
-- * <<http://developer.gnome.org/gdk/stable/w_resize_cursor.png>> \"w-resize\"
-- * <<http://developer.gnome.org/gdk/stable/ne_resize_cursor.png>> \"ne-resize\"
-- * <<http://developer.gnome.org/gdk/stable/nw_resize_cursor.png>> \"nw-resize\"
-- * <<http://developer.gnome.org/gdk/stable/sw_resize_cursor.png>> \"sw-resize\"
-- * <<http://developer.gnome.org/gdk/stable/se_resize_cursor.png>> \"se-resize\"
-- * <<http://developer.gnome.org/gdk/stable/ew_resize_cursor.png>> \"ew-resize\"
-- * <<http://developer.gnome.org/gdk/stable/ns_resize_cursor.png>> \"ns-resize\"
-- * <<http://developer.gnome.org/gdk/stable/nesw_resize_cursor.png>> \"nesw-resize\"
-- * <<http://developer.gnome.org/gdk/stable/nwse_resize_cursor.png>> \"nwse-resize\"
-- * <<http://developer.gnome.org/gdk/stable/zoom_in_cursor.png>> \"zoom-in\"
-- * <<http://developer.gnome.org/gdk/stable/zoom_out_cursor.png>> \"zoom-out\"
-- 
-- 
-- Additionally, the following cursor names are supported, which are
-- not in the CSS specification:
-- * <<http://developer.gnome.org/gdk/stable/dnd_ask_cursor.png>> \"dnd-ask\"
-- * <<http://developer.gnome.org/gdk/stable/all_resize_cursor.png>> \"all-resize\"
-- 
-- 
-- /Since: 2.8/
cursorNewFromName ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a) =>
    a
    -- ^ /@display@/: the t'GI.Gdk.Objects.Display.Display' for which the cursor will be created
    -> T.Text
    -- ^ /@name@/: the name of the cursor
    -> m (Maybe Cursor)
    -- ^ __Returns:__ a new t'GI.Gdk.Objects.Cursor.Cursor', or 'P.Nothing' if there is no
    --   cursor with the given name
cursorNewFromName display name = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    name' <- textToCString name
    result <- gdk_cursor_new_from_name display' name'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Cursor) result'
        return result''
    touchManagedPtr display
    freeMem name'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method Cursor::new_from_pixbuf
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GdkDisplay for which the cursor will be created"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pixbuf"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GdkPixbuf containing the cursor image"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the horizontal offset of the \8220hotspot\8221 of the cursor."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the vertical offset of the \8220hotspot\8221 of the cursor."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Cursor" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cursor_new_from_pixbuf" gdk_cursor_new_from_pixbuf :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr GdkPixbuf.Pixbuf.Pixbuf ->          -- pixbuf : TInterface (Name {namespace = "GdkPixbuf", name = "Pixbuf"})
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    IO (Ptr Cursor)

-- | Creates a new cursor from a pixbuf.
-- 
-- Not all GDK backends support RGBA cursors. If they are not
-- supported, a monochrome approximation will be displayed.
-- The functions 'GI.Gdk.Objects.Display.displaySupportsCursorAlpha' and
-- 'GI.Gdk.Objects.Display.displaySupportsCursorColor' can be used to determine
-- whether RGBA cursors are supported;
-- 'GI.Gdk.Objects.Display.displayGetDefaultCursorSize' and
-- 'GI.Gdk.Objects.Display.displayGetMaximalCursorSize' give information about
-- cursor sizes.
-- 
-- If /@x@/ or /@y@/ are @-1@, the pixbuf must have
-- options named “x_hot” and “y_hot”, resp., containing
-- integer values between @0@ and the width resp. height of
-- the pixbuf. (Since: 3.0)
-- 
-- On the X backend, support for RGBA cursors requires a
-- sufficently new version of the X Render extension.
-- 
-- /Since: 2.4/
cursorNewFromPixbuf ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a, GdkPixbuf.Pixbuf.IsPixbuf b) =>
    a
    -- ^ /@display@/: the t'GI.Gdk.Objects.Display.Display' for which the cursor will be created
    -> b
    -- ^ /@pixbuf@/: the t'GI.GdkPixbuf.Objects.Pixbuf.Pixbuf' containing the cursor image
    -> Int32
    -- ^ /@x@/: the horizontal offset of the “hotspot” of the cursor.
    -> Int32
    -- ^ /@y@/: the vertical offset of the “hotspot” of the cursor.
    -> m Cursor
    -- ^ __Returns:__ a new t'GI.Gdk.Objects.Cursor.Cursor'.
cursorNewFromPixbuf display pixbuf x y = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    pixbuf' <- unsafeManagedPtrCastPtr pixbuf
    result <- gdk_cursor_new_from_pixbuf display' pixbuf' x y
    checkUnexpectedReturnNULL "cursorNewFromPixbuf" result
    result' <- (wrapObject Cursor) result
    touchManagedPtr display
    touchManagedPtr pixbuf
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Cursor::new_from_surface
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GdkDisplay for which the cursor will be created"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "surface"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Surface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the cairo image surface containing the cursor pixel data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the horizontal offset of the \8220hotspot\8221 of the cursor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the vertical offset of the \8220hotspot\8221 of the cursor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Cursor" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cursor_new_from_surface" gdk_cursor_new_from_surface :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Cairo.Surface.Surface ->            -- surface : TInterface (Name {namespace = "cairo", name = "Surface"})
    CDouble ->                              -- x : TBasicType TDouble
    CDouble ->                              -- y : TBasicType TDouble
    IO (Ptr Cursor)

-- | Creates a new cursor from a cairo image surface.
-- 
-- Not all GDK backends support RGBA cursors. If they are not
-- supported, a monochrome approximation will be displayed.
-- The functions 'GI.Gdk.Objects.Display.displaySupportsCursorAlpha' and
-- 'GI.Gdk.Objects.Display.displaySupportsCursorColor' can be used to determine
-- whether RGBA cursors are supported;
-- 'GI.Gdk.Objects.Display.displayGetDefaultCursorSize' and
-- 'GI.Gdk.Objects.Display.displayGetMaximalCursorSize' give information about
-- cursor sizes.
-- 
-- On the X backend, support for RGBA cursors requires a
-- sufficently new version of the X Render extension.
-- 
-- /Since: 3.10/
cursorNewFromSurface ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a) =>
    a
    -- ^ /@display@/: the t'GI.Gdk.Objects.Display.Display' for which the cursor will be created
    -> Cairo.Surface.Surface
    -- ^ /@surface@/: the cairo image surface containing the cursor pixel data
    -> Double
    -- ^ /@x@/: the horizontal offset of the “hotspot” of the cursor
    -> Double
    -- ^ /@y@/: the vertical offset of the “hotspot” of the cursor
    -> m Cursor
    -- ^ __Returns:__ a new t'GI.Gdk.Objects.Cursor.Cursor'.
cursorNewFromSurface display surface x y = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    surface' <- unsafeManagedPtrGetPtr surface
    let x' = realToFrac x
    let y' = realToFrac y
    result <- gdk_cursor_new_from_surface display' surface' x' y'
    checkUnexpectedReturnNULL "cursorNewFromSurface" result
    result' <- (wrapObject Cursor) result
    touchManagedPtr display
    touchManagedPtr surface
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Cursor::get_cursor_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cursor"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Cursor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkCursor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "CursorType" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cursor_get_cursor_type" gdk_cursor_get_cursor_type :: 
    Ptr Cursor ->                           -- cursor : TInterface (Name {namespace = "Gdk", name = "Cursor"})
    IO CInt

-- | Returns the cursor type for this cursor.
-- 
-- /Since: 2.22/
cursorGetCursorType ::
    (B.CallStack.HasCallStack, MonadIO m, IsCursor a) =>
    a
    -- ^ /@cursor@/: a t'GI.Gdk.Objects.Cursor.Cursor'
    -> m Gdk.Enums.CursorType
    -- ^ __Returns:__ a t'GI.Gdk.Enums.CursorType'
cursorGetCursorType cursor = liftIO $ do
    cursor' <- unsafeManagedPtrCastPtr cursor
    result <- gdk_cursor_get_cursor_type cursor'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr cursor
    return result'

#if defined(ENABLE_OVERLOADING)
data CursorGetCursorTypeMethodInfo
instance (signature ~ (m Gdk.Enums.CursorType), MonadIO m, IsCursor a) => O.OverloadedMethod CursorGetCursorTypeMethodInfo a signature where
    overloadedMethod = cursorGetCursorType

instance O.OverloadedMethodInfo CursorGetCursorTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Cursor.cursorGetCursorType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Cursor.html#v:cursorGetCursorType"
        })


#endif

-- method Cursor::get_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cursor"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Cursor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkCursor." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cursor_get_display" gdk_cursor_get_display :: 
    Ptr Cursor ->                           -- cursor : TInterface (Name {namespace = "Gdk", name = "Cursor"})
    IO (Ptr Gdk.Display.Display)

-- | Returns the display on which the t'GI.Gdk.Objects.Cursor.Cursor' is defined.
-- 
-- /Since: 2.2/
cursorGetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsCursor a) =>
    a
    -- ^ /@cursor@/: a t'GI.Gdk.Objects.Cursor.Cursor'.
    -> m Gdk.Display.Display
    -- ^ __Returns:__ the t'GI.Gdk.Objects.Display.Display' associated to /@cursor@/
cursorGetDisplay cursor = liftIO $ do
    cursor' <- unsafeManagedPtrCastPtr cursor
    result <- gdk_cursor_get_display cursor'
    checkUnexpectedReturnNULL "cursorGetDisplay" result
    result' <- (newObject Gdk.Display.Display) result
    touchManagedPtr cursor
    return result'

#if defined(ENABLE_OVERLOADING)
data CursorGetDisplayMethodInfo
instance (signature ~ (m Gdk.Display.Display), MonadIO m, IsCursor a) => O.OverloadedMethod CursorGetDisplayMethodInfo a signature where
    overloadedMethod = cursorGetDisplay

instance O.OverloadedMethodInfo CursorGetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Cursor.cursorGetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Cursor.html#v:cursorGetDisplay"
        })


#endif

-- method Cursor::get_image
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cursor"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Cursor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkCursor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cursor_get_image" gdk_cursor_get_image :: 
    Ptr Cursor ->                           -- cursor : TInterface (Name {namespace = "Gdk", name = "Cursor"})
    IO (Ptr GdkPixbuf.Pixbuf.Pixbuf)

-- | Returns a t'GI.GdkPixbuf.Objects.Pixbuf.Pixbuf' with the image used to display the cursor.
-- 
-- Note that depending on the capabilities of the windowing system and
-- on the cursor, GDK may not be able to obtain the image data. In this
-- case, 'P.Nothing' is returned.
-- 
-- /Since: 2.8/
cursorGetImage ::
    (B.CallStack.HasCallStack, MonadIO m, IsCursor a) =>
    a
    -- ^ /@cursor@/: a t'GI.Gdk.Objects.Cursor.Cursor'
    -> m (Maybe GdkPixbuf.Pixbuf.Pixbuf)
    -- ^ __Returns:__ a t'GI.GdkPixbuf.Objects.Pixbuf.Pixbuf' representing
    --   /@cursor@/, or 'P.Nothing'
cursorGetImage cursor = liftIO $ do
    cursor' <- unsafeManagedPtrCastPtr cursor
    result <- gdk_cursor_get_image cursor'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject GdkPixbuf.Pixbuf.Pixbuf) result'
        return result''
    touchManagedPtr cursor
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data CursorGetImageMethodInfo
instance (signature ~ (m (Maybe GdkPixbuf.Pixbuf.Pixbuf)), MonadIO m, IsCursor a) => O.OverloadedMethod CursorGetImageMethodInfo a signature where
    overloadedMethod = cursorGetImage

instance O.OverloadedMethodInfo CursorGetImageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Cursor.cursorGetImage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Cursor.html#v:cursorGetImage"
        })


#endif

-- method Cursor::get_surface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cursor"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Cursor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkCursor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x_hot"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Location to store the hotspot x position,\n  or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y_hot"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Location to store the hotspot y position,\n  or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Surface" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cursor_get_surface" gdk_cursor_get_surface :: 
    Ptr Cursor ->                           -- cursor : TInterface (Name {namespace = "Gdk", name = "Cursor"})
    Ptr CDouble ->                          -- x_hot : TBasicType TDouble
    Ptr CDouble ->                          -- y_hot : TBasicType TDouble
    IO (Ptr Cairo.Surface.Surface)

-- | Returns a cairo image surface with the image used to display the cursor.
-- 
-- Note that depending on the capabilities of the windowing system and
-- on the cursor, GDK may not be able to obtain the image data. In this
-- case, 'P.Nothing' is returned.
-- 
-- /Since: 3.10/
cursorGetSurface ::
    (B.CallStack.HasCallStack, MonadIO m, IsCursor a) =>
    a
    -- ^ /@cursor@/: a t'GI.Gdk.Objects.Cursor.Cursor'
    -> m ((Maybe Cairo.Surface.Surface, Double, Double))
    -- ^ __Returns:__ a t'GI.Cairo.Structs.Surface.Surface'
    --   representing /@cursor@/, or 'P.Nothing'
cursorGetSurface cursor = liftIO $ do
    cursor' <- unsafeManagedPtrCastPtr cursor
    xHot <- allocMem :: IO (Ptr CDouble)
    yHot <- allocMem :: IO (Ptr CDouble)
    result <- gdk_cursor_get_surface cursor' xHot yHot
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Cairo.Surface.Surface) result'
        return result''
    xHot' <- peek xHot
    let xHot'' = realToFrac xHot'
    yHot' <- peek yHot
    let yHot'' = realToFrac yHot'
    touchManagedPtr cursor
    freeMem xHot
    freeMem yHot
    return (maybeResult, xHot'', yHot'')

#if defined(ENABLE_OVERLOADING)
data CursorGetSurfaceMethodInfo
instance (signature ~ (m ((Maybe Cairo.Surface.Surface, Double, Double))), MonadIO m, IsCursor a) => O.OverloadedMethod CursorGetSurfaceMethodInfo a signature where
    overloadedMethod = cursorGetSurface

instance O.OverloadedMethodInfo CursorGetSurfaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Cursor.cursorGetSurface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Cursor.html#v:cursorGetSurface"
        })


#endif

-- method Cursor::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cursor"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Cursor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkCursor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Cursor" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cursor_ref" gdk_cursor_ref :: 
    Ptr Cursor ->                           -- cursor : TInterface (Name {namespace = "Gdk", name = "Cursor"})
    IO (Ptr Cursor)

{-# DEPRECATED cursorRef ["(Since version 3.0)","Use 'GI.GObject.Objects.Object.objectRef' instead"] #-}
-- | Adds a reference to /@cursor@/.
cursorRef ::
    (B.CallStack.HasCallStack, MonadIO m, IsCursor a) =>
    a
    -- ^ /@cursor@/: a t'GI.Gdk.Objects.Cursor.Cursor'
    -> m Cursor
    -- ^ __Returns:__ Same /@cursor@/ that was passed in
cursorRef cursor = liftIO $ do
    cursor' <- unsafeManagedPtrCastPtr cursor
    result <- gdk_cursor_ref cursor'
    checkUnexpectedReturnNULL "cursorRef" result
    result' <- (wrapObject Cursor) result
    touchManagedPtr cursor
    return result'

#if defined(ENABLE_OVERLOADING)
data CursorRefMethodInfo
instance (signature ~ (m Cursor), MonadIO m, IsCursor a) => O.OverloadedMethod CursorRefMethodInfo a signature where
    overloadedMethod = cursorRef

instance O.OverloadedMethodInfo CursorRefMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Cursor.cursorRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Cursor.html#v:cursorRef"
        })


#endif

-- method Cursor::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cursor"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Cursor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkCursor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cursor_unref" gdk_cursor_unref :: 
    Ptr Cursor ->                           -- cursor : TInterface (Name {namespace = "Gdk", name = "Cursor"})
    IO ()

{-# DEPRECATED cursorUnref ["(Since version 3.0)","Use 'GI.GObject.Objects.Object.objectUnref' instead"] #-}
-- | Removes a reference from /@cursor@/, deallocating the cursor
-- if no references remain.
cursorUnref ::
    (B.CallStack.HasCallStack, MonadIO m, IsCursor a) =>
    a
    -- ^ /@cursor@/: a t'GI.Gdk.Objects.Cursor.Cursor'
    -> m ()
cursorUnref cursor = liftIO $ do
    cursor' <- unsafeManagedPtrCastPtr cursor
    gdk_cursor_unref cursor'
    touchManagedPtr cursor
    return ()

#if defined(ENABLE_OVERLOADING)
data CursorUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m, IsCursor a) => O.OverloadedMethod CursorUnrefMethodInfo a signature where
    overloadedMethod = cursorUnref

instance O.OverloadedMethodInfo CursorUnrefMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Cursor.cursorUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Cursor.html#v:cursorUnref"
        })


#endif


