{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @PangoLogAttr@ structure stores information about the attributes of a
-- single character.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.LogAttr
    ( 

-- * Exported types
    LogAttr(..)                             ,
    newZeroLogAttr                          ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveLogAttrMethod                    ,
#endif



 -- * Properties


-- ** backspaceDeletesCharacter #attr:backspaceDeletesCharacter#
-- | if set, backspace deletes one character
--   rather than the entire grapheme cluster. This field is only meaningful
--   on grapheme boundaries (where /@isCursorPosition@/ is set). In some languages,
--   the full grapheme (e.g. letter + diacritics) is considered a unit, while in
--   others, each decomposed character in the grapheme is a unit. In the default
--   implementation of [func/@break@/], this bit is set on all grapheme boundaries
--   except those following Latin, Cyrillic or Greek base characters.

    getLogAttrBackspaceDeletesCharacter     ,
#if defined(ENABLE_OVERLOADING)
    logAttr_backspaceDeletesCharacter       ,
#endif
    setLogAttrBackspaceDeletesCharacter     ,


-- ** breakInsertsHyphen #attr:breakInsertsHyphen#
-- | when breaking lines before this char, insert a hyphen.
--   Since: 1.50

    getLogAttrBreakInsertsHyphen            ,
#if defined(ENABLE_OVERLOADING)
    logAttr_breakInsertsHyphen              ,
#endif
    setLogAttrBreakInsertsHyphen            ,


-- ** breakRemovesPreceding #attr:breakRemovesPreceding#
-- | when breaking lines before this char, remove the
--   preceding char. Since 1.50

    getLogAttrBreakRemovesPreceding         ,
#if defined(ENABLE_OVERLOADING)
    logAttr_breakRemovesPreceding           ,
#endif
    setLogAttrBreakRemovesPreceding         ,


-- ** isCharBreak #attr:isCharBreak#
-- | if set, can break here when doing character wrapping

    getLogAttrIsCharBreak                   ,
#if defined(ENABLE_OVERLOADING)
    logAttr_isCharBreak                     ,
#endif
    setLogAttrIsCharBreak                   ,


-- ** isCursorPosition #attr:isCursorPosition#
-- | if set, cursor can appear in front of character.
--   i.e. this is a grapheme boundary, or the first character in the text.
--   This flag implements Unicode\'s
--   <http://www.unicode.org/reports/tr29/ Grapheme Cluster Boundaries>
--   semantics.

    getLogAttrIsCursorPosition              ,
#if defined(ENABLE_OVERLOADING)
    logAttr_isCursorPosition                ,
#endif
    setLogAttrIsCursorPosition              ,


-- ** isExpandableSpace #attr:isExpandableSpace#
-- | is a whitespace character that can possibly be
--   expanded for justification purposes. (Since: 1.18)

    getLogAttrIsExpandableSpace             ,
#if defined(ENABLE_OVERLOADING)
    logAttr_isExpandableSpace               ,
#endif
    setLogAttrIsExpandableSpace             ,


-- ** isLineBreak #attr:isLineBreak#
-- | if set, can break line in front of character

    getLogAttrIsLineBreak                   ,
#if defined(ENABLE_OVERLOADING)
    logAttr_isLineBreak                     ,
#endif
    setLogAttrIsLineBreak                   ,


-- ** isMandatoryBreak #attr:isMandatoryBreak#
-- | if set, must break line in front of character

    getLogAttrIsMandatoryBreak              ,
#if defined(ENABLE_OVERLOADING)
    logAttr_isMandatoryBreak                ,
#endif
    setLogAttrIsMandatoryBreak              ,


-- ** isSentenceBoundary #attr:isSentenceBoundary#
-- | is a sentence boundary.
--   There are two ways to divide sentences. The first assigns all
--   inter-sentence whitespace\/control\/format chars to some sentence,
--   so all chars are in some sentence; /@isSentenceBoundary@/ denotes
--   the boundaries there. The second way doesn\'t assign
--   between-sentence spaces, etc. to any sentence, so
--   /@isSentenceStart@/\//@isSentenceEnd@/ mark the boundaries of those sentences.

    getLogAttrIsSentenceBoundary            ,
#if defined(ENABLE_OVERLOADING)
    logAttr_isSentenceBoundary              ,
#endif
    setLogAttrIsSentenceBoundary            ,


-- ** isSentenceEnd #attr:isSentenceEnd#
-- | is first char after a sentence.
--   Note that in degenerate cases, you could have both /@isSentenceStart@/
--   and /@isSentenceEnd@/ set for some character. (e.g. no space after a
--   period, so the next sentence starts right away)

    getLogAttrIsSentenceEnd                 ,
#if defined(ENABLE_OVERLOADING)
    logAttr_isSentenceEnd                   ,
#endif
    setLogAttrIsSentenceEnd                 ,


-- ** isSentenceStart #attr:isSentenceStart#
-- | is first character in a sentence

    getLogAttrIsSentenceStart               ,
#if defined(ENABLE_OVERLOADING)
    logAttr_isSentenceStart                 ,
#endif
    setLogAttrIsSentenceStart               ,


-- ** isWhite #attr:isWhite#
-- | is whitespace character

    getLogAttrIsWhite                       ,
#if defined(ENABLE_OVERLOADING)
    logAttr_isWhite                         ,
#endif
    setLogAttrIsWhite                       ,


-- ** isWordBoundary #attr:isWordBoundary#
-- | is a word boundary, as defined by UAX@/29/@.
--   More specifically, means that this is not a position in the middle of a word.
--   For example, both sides of a punctuation mark are considered word boundaries.
--   This flag is particularly useful when selecting text word-by-word. This flag
--   implements Unicode\'s <http://www.unicode.org/reports/tr29/ Word Boundaries>
--   semantics. (Since: 1.22)

    getLogAttrIsWordBoundary                ,
#if defined(ENABLE_OVERLOADING)
    logAttr_isWordBoundary                  ,
#endif
    setLogAttrIsWordBoundary                ,


-- ** isWordEnd #attr:isWordEnd#
-- | is first non-word char after a word
--   Note that in degenerate cases, you could have both /@isWordStart@/
--   and /@isWordEnd@/ set for some character.

    getLogAttrIsWordEnd                     ,
#if defined(ENABLE_OVERLOADING)
    logAttr_isWordEnd                       ,
#endif
    setLogAttrIsWordEnd                     ,


-- ** isWordStart #attr:isWordStart#
-- | is first character in a word

    getLogAttrIsWordStart                   ,
#if defined(ENABLE_OVERLOADING)
    logAttr_isWordStart                     ,
#endif
    setLogAttrIsWordStart                   ,


-- ** reserved #attr:reserved#
-- | /No description available in the introspection data./

    getLogAttrReserved                      ,
#if defined(ENABLE_OVERLOADING)
    logAttr_reserved                        ,
#endif
    setLogAttrReserved                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype LogAttr = LogAttr (SP.ManagedPtr LogAttr)
    deriving (Eq)

instance SP.ManagedPtrNewtype LogAttr where
    toManagedPtr (LogAttr p) = p

instance BoxedPtr LogAttr where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 64 >=> B.ManagedPtr.wrapPtr LogAttr)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr LogAttr where
    boxedPtrCalloc = callocBytes 64


-- | Construct a t'LogAttr' struct initialized to zero.
newZeroLogAttr :: MonadIO m => m LogAttr
newZeroLogAttr = liftIO $ boxedPtrCalloc >>= wrapPtr LogAttr

instance tag ~ 'AttrSet => Constructible LogAttr tag where
    new _ attrs = do
        o <- newZeroLogAttr
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@is_line_break@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' logAttr #isLineBreak
-- @
getLogAttrIsLineBreak :: MonadIO m => LogAttr -> m Word32
getLogAttrIsLineBreak s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@is_line_break@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' logAttr [ #isLineBreak 'Data.GI.Base.Attributes.:=' value ]
-- @
setLogAttrIsLineBreak :: MonadIO m => LogAttr -> Word32 -> m ()
setLogAttrIsLineBreak s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LogAttrIsLineBreakFieldInfo
instance AttrInfo LogAttrIsLineBreakFieldInfo where
    type AttrBaseTypeConstraint LogAttrIsLineBreakFieldInfo = (~) LogAttr
    type AttrAllowedOps LogAttrIsLineBreakFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LogAttrIsLineBreakFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LogAttrIsLineBreakFieldInfo = (~)Word32
    type AttrTransferType LogAttrIsLineBreakFieldInfo = Word32
    type AttrGetType LogAttrIsLineBreakFieldInfo = Word32
    type AttrLabel LogAttrIsLineBreakFieldInfo = "is_line_break"
    type AttrOrigin LogAttrIsLineBreakFieldInfo = LogAttr
    attrGet = getLogAttrIsLineBreak
    attrSet = setLogAttrIsLineBreak
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LogAttr.isLineBreak"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LogAttr.html#g:attr:isLineBreak"
        })

logAttr_isLineBreak :: AttrLabelProxy "isLineBreak"
logAttr_isLineBreak = AttrLabelProxy

#endif


-- | Get the value of the “@is_mandatory_break@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' logAttr #isMandatoryBreak
-- @
getLogAttrIsMandatoryBreak :: MonadIO m => LogAttr -> m Word32
getLogAttrIsMandatoryBreak s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Word32
    return val

-- | Set the value of the “@is_mandatory_break@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' logAttr [ #isMandatoryBreak 'Data.GI.Base.Attributes.:=' value ]
-- @
setLogAttrIsMandatoryBreak :: MonadIO m => LogAttr -> Word32 -> m ()
setLogAttrIsMandatoryBreak s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LogAttrIsMandatoryBreakFieldInfo
instance AttrInfo LogAttrIsMandatoryBreakFieldInfo where
    type AttrBaseTypeConstraint LogAttrIsMandatoryBreakFieldInfo = (~) LogAttr
    type AttrAllowedOps LogAttrIsMandatoryBreakFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LogAttrIsMandatoryBreakFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LogAttrIsMandatoryBreakFieldInfo = (~)Word32
    type AttrTransferType LogAttrIsMandatoryBreakFieldInfo = Word32
    type AttrGetType LogAttrIsMandatoryBreakFieldInfo = Word32
    type AttrLabel LogAttrIsMandatoryBreakFieldInfo = "is_mandatory_break"
    type AttrOrigin LogAttrIsMandatoryBreakFieldInfo = LogAttr
    attrGet = getLogAttrIsMandatoryBreak
    attrSet = setLogAttrIsMandatoryBreak
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LogAttr.isMandatoryBreak"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LogAttr.html#g:attr:isMandatoryBreak"
        })

logAttr_isMandatoryBreak :: AttrLabelProxy "isMandatoryBreak"
logAttr_isMandatoryBreak = AttrLabelProxy

#endif


-- | Get the value of the “@is_char_break@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' logAttr #isCharBreak
-- @
getLogAttrIsCharBreak :: MonadIO m => LogAttr -> m Word32
getLogAttrIsCharBreak s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Word32
    return val

-- | Set the value of the “@is_char_break@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' logAttr [ #isCharBreak 'Data.GI.Base.Attributes.:=' value ]
-- @
setLogAttrIsCharBreak :: MonadIO m => LogAttr -> Word32 -> m ()
setLogAttrIsCharBreak s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LogAttrIsCharBreakFieldInfo
instance AttrInfo LogAttrIsCharBreakFieldInfo where
    type AttrBaseTypeConstraint LogAttrIsCharBreakFieldInfo = (~) LogAttr
    type AttrAllowedOps LogAttrIsCharBreakFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LogAttrIsCharBreakFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LogAttrIsCharBreakFieldInfo = (~)Word32
    type AttrTransferType LogAttrIsCharBreakFieldInfo = Word32
    type AttrGetType LogAttrIsCharBreakFieldInfo = Word32
    type AttrLabel LogAttrIsCharBreakFieldInfo = "is_char_break"
    type AttrOrigin LogAttrIsCharBreakFieldInfo = LogAttr
    attrGet = getLogAttrIsCharBreak
    attrSet = setLogAttrIsCharBreak
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LogAttr.isCharBreak"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LogAttr.html#g:attr:isCharBreak"
        })

logAttr_isCharBreak :: AttrLabelProxy "isCharBreak"
logAttr_isCharBreak = AttrLabelProxy

#endif


-- | Get the value of the “@is_white@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' logAttr #isWhite
-- @
getLogAttrIsWhite :: MonadIO m => LogAttr -> m Word32
getLogAttrIsWhite s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO Word32
    return val

-- | Set the value of the “@is_white@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' logAttr [ #isWhite 'Data.GI.Base.Attributes.:=' value ]
-- @
setLogAttrIsWhite :: MonadIO m => LogAttr -> Word32 -> m ()
setLogAttrIsWhite s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 12) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LogAttrIsWhiteFieldInfo
instance AttrInfo LogAttrIsWhiteFieldInfo where
    type AttrBaseTypeConstraint LogAttrIsWhiteFieldInfo = (~) LogAttr
    type AttrAllowedOps LogAttrIsWhiteFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LogAttrIsWhiteFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LogAttrIsWhiteFieldInfo = (~)Word32
    type AttrTransferType LogAttrIsWhiteFieldInfo = Word32
    type AttrGetType LogAttrIsWhiteFieldInfo = Word32
    type AttrLabel LogAttrIsWhiteFieldInfo = "is_white"
    type AttrOrigin LogAttrIsWhiteFieldInfo = LogAttr
    attrGet = getLogAttrIsWhite
    attrSet = setLogAttrIsWhite
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LogAttr.isWhite"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LogAttr.html#g:attr:isWhite"
        })

logAttr_isWhite :: AttrLabelProxy "isWhite"
logAttr_isWhite = AttrLabelProxy

#endif


-- | Get the value of the “@is_cursor_position@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' logAttr #isCursorPosition
-- @
getLogAttrIsCursorPosition :: MonadIO m => LogAttr -> m Word32
getLogAttrIsCursorPosition s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Word32
    return val

-- | Set the value of the “@is_cursor_position@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' logAttr [ #isCursorPosition 'Data.GI.Base.Attributes.:=' value ]
-- @
setLogAttrIsCursorPosition :: MonadIO m => LogAttr -> Word32 -> m ()
setLogAttrIsCursorPosition s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LogAttrIsCursorPositionFieldInfo
instance AttrInfo LogAttrIsCursorPositionFieldInfo where
    type AttrBaseTypeConstraint LogAttrIsCursorPositionFieldInfo = (~) LogAttr
    type AttrAllowedOps LogAttrIsCursorPositionFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LogAttrIsCursorPositionFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LogAttrIsCursorPositionFieldInfo = (~)Word32
    type AttrTransferType LogAttrIsCursorPositionFieldInfo = Word32
    type AttrGetType LogAttrIsCursorPositionFieldInfo = Word32
    type AttrLabel LogAttrIsCursorPositionFieldInfo = "is_cursor_position"
    type AttrOrigin LogAttrIsCursorPositionFieldInfo = LogAttr
    attrGet = getLogAttrIsCursorPosition
    attrSet = setLogAttrIsCursorPosition
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LogAttr.isCursorPosition"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LogAttr.html#g:attr:isCursorPosition"
        })

logAttr_isCursorPosition :: AttrLabelProxy "isCursorPosition"
logAttr_isCursorPosition = AttrLabelProxy

#endif


-- | Get the value of the “@is_word_start@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' logAttr #isWordStart
-- @
getLogAttrIsWordStart :: MonadIO m => LogAttr -> m Word32
getLogAttrIsWordStart s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Word32
    return val

-- | Set the value of the “@is_word_start@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' logAttr [ #isWordStart 'Data.GI.Base.Attributes.:=' value ]
-- @
setLogAttrIsWordStart :: MonadIO m => LogAttr -> Word32 -> m ()
setLogAttrIsWordStart s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LogAttrIsWordStartFieldInfo
instance AttrInfo LogAttrIsWordStartFieldInfo where
    type AttrBaseTypeConstraint LogAttrIsWordStartFieldInfo = (~) LogAttr
    type AttrAllowedOps LogAttrIsWordStartFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LogAttrIsWordStartFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LogAttrIsWordStartFieldInfo = (~)Word32
    type AttrTransferType LogAttrIsWordStartFieldInfo = Word32
    type AttrGetType LogAttrIsWordStartFieldInfo = Word32
    type AttrLabel LogAttrIsWordStartFieldInfo = "is_word_start"
    type AttrOrigin LogAttrIsWordStartFieldInfo = LogAttr
    attrGet = getLogAttrIsWordStart
    attrSet = setLogAttrIsWordStart
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LogAttr.isWordStart"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LogAttr.html#g:attr:isWordStart"
        })

logAttr_isWordStart :: AttrLabelProxy "isWordStart"
logAttr_isWordStart = AttrLabelProxy

#endif


-- | Get the value of the “@is_word_end@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' logAttr #isWordEnd
-- @
getLogAttrIsWordEnd :: MonadIO m => LogAttr -> m Word32
getLogAttrIsWordEnd s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO Word32
    return val

-- | Set the value of the “@is_word_end@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' logAttr [ #isWordEnd 'Data.GI.Base.Attributes.:=' value ]
-- @
setLogAttrIsWordEnd :: MonadIO m => LogAttr -> Word32 -> m ()
setLogAttrIsWordEnd s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LogAttrIsWordEndFieldInfo
instance AttrInfo LogAttrIsWordEndFieldInfo where
    type AttrBaseTypeConstraint LogAttrIsWordEndFieldInfo = (~) LogAttr
    type AttrAllowedOps LogAttrIsWordEndFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LogAttrIsWordEndFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LogAttrIsWordEndFieldInfo = (~)Word32
    type AttrTransferType LogAttrIsWordEndFieldInfo = Word32
    type AttrGetType LogAttrIsWordEndFieldInfo = Word32
    type AttrLabel LogAttrIsWordEndFieldInfo = "is_word_end"
    type AttrOrigin LogAttrIsWordEndFieldInfo = LogAttr
    attrGet = getLogAttrIsWordEnd
    attrSet = setLogAttrIsWordEnd
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LogAttr.isWordEnd"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LogAttr.html#g:attr:isWordEnd"
        })

logAttr_isWordEnd :: AttrLabelProxy "isWordEnd"
logAttr_isWordEnd = AttrLabelProxy

#endif


-- | Get the value of the “@is_sentence_boundary@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' logAttr #isSentenceBoundary
-- @
getLogAttrIsSentenceBoundary :: MonadIO m => LogAttr -> m Word32
getLogAttrIsSentenceBoundary s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 28) :: IO Word32
    return val

-- | Set the value of the “@is_sentence_boundary@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' logAttr [ #isSentenceBoundary 'Data.GI.Base.Attributes.:=' value ]
-- @
setLogAttrIsSentenceBoundary :: MonadIO m => LogAttr -> Word32 -> m ()
setLogAttrIsSentenceBoundary s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 28) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LogAttrIsSentenceBoundaryFieldInfo
instance AttrInfo LogAttrIsSentenceBoundaryFieldInfo where
    type AttrBaseTypeConstraint LogAttrIsSentenceBoundaryFieldInfo = (~) LogAttr
    type AttrAllowedOps LogAttrIsSentenceBoundaryFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LogAttrIsSentenceBoundaryFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LogAttrIsSentenceBoundaryFieldInfo = (~)Word32
    type AttrTransferType LogAttrIsSentenceBoundaryFieldInfo = Word32
    type AttrGetType LogAttrIsSentenceBoundaryFieldInfo = Word32
    type AttrLabel LogAttrIsSentenceBoundaryFieldInfo = "is_sentence_boundary"
    type AttrOrigin LogAttrIsSentenceBoundaryFieldInfo = LogAttr
    attrGet = getLogAttrIsSentenceBoundary
    attrSet = setLogAttrIsSentenceBoundary
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LogAttr.isSentenceBoundary"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LogAttr.html#g:attr:isSentenceBoundary"
        })

logAttr_isSentenceBoundary :: AttrLabelProxy "isSentenceBoundary"
logAttr_isSentenceBoundary = AttrLabelProxy

#endif


-- | Get the value of the “@is_sentence_start@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' logAttr #isSentenceStart
-- @
getLogAttrIsSentenceStart :: MonadIO m => LogAttr -> m Word32
getLogAttrIsSentenceStart s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO Word32
    return val

-- | Set the value of the “@is_sentence_start@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' logAttr [ #isSentenceStart 'Data.GI.Base.Attributes.:=' value ]
-- @
setLogAttrIsSentenceStart :: MonadIO m => LogAttr -> Word32 -> m ()
setLogAttrIsSentenceStart s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LogAttrIsSentenceStartFieldInfo
instance AttrInfo LogAttrIsSentenceStartFieldInfo where
    type AttrBaseTypeConstraint LogAttrIsSentenceStartFieldInfo = (~) LogAttr
    type AttrAllowedOps LogAttrIsSentenceStartFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LogAttrIsSentenceStartFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LogAttrIsSentenceStartFieldInfo = (~)Word32
    type AttrTransferType LogAttrIsSentenceStartFieldInfo = Word32
    type AttrGetType LogAttrIsSentenceStartFieldInfo = Word32
    type AttrLabel LogAttrIsSentenceStartFieldInfo = "is_sentence_start"
    type AttrOrigin LogAttrIsSentenceStartFieldInfo = LogAttr
    attrGet = getLogAttrIsSentenceStart
    attrSet = setLogAttrIsSentenceStart
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LogAttr.isSentenceStart"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LogAttr.html#g:attr:isSentenceStart"
        })

logAttr_isSentenceStart :: AttrLabelProxy "isSentenceStart"
logAttr_isSentenceStart = AttrLabelProxy

#endif


-- | Get the value of the “@is_sentence_end@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' logAttr #isSentenceEnd
-- @
getLogAttrIsSentenceEnd :: MonadIO m => LogAttr -> m Word32
getLogAttrIsSentenceEnd s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 36) :: IO Word32
    return val

-- | Set the value of the “@is_sentence_end@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' logAttr [ #isSentenceEnd 'Data.GI.Base.Attributes.:=' value ]
-- @
setLogAttrIsSentenceEnd :: MonadIO m => LogAttr -> Word32 -> m ()
setLogAttrIsSentenceEnd s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 36) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LogAttrIsSentenceEndFieldInfo
instance AttrInfo LogAttrIsSentenceEndFieldInfo where
    type AttrBaseTypeConstraint LogAttrIsSentenceEndFieldInfo = (~) LogAttr
    type AttrAllowedOps LogAttrIsSentenceEndFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LogAttrIsSentenceEndFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LogAttrIsSentenceEndFieldInfo = (~)Word32
    type AttrTransferType LogAttrIsSentenceEndFieldInfo = Word32
    type AttrGetType LogAttrIsSentenceEndFieldInfo = Word32
    type AttrLabel LogAttrIsSentenceEndFieldInfo = "is_sentence_end"
    type AttrOrigin LogAttrIsSentenceEndFieldInfo = LogAttr
    attrGet = getLogAttrIsSentenceEnd
    attrSet = setLogAttrIsSentenceEnd
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LogAttr.isSentenceEnd"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LogAttr.html#g:attr:isSentenceEnd"
        })

logAttr_isSentenceEnd :: AttrLabelProxy "isSentenceEnd"
logAttr_isSentenceEnd = AttrLabelProxy

#endif


-- | Get the value of the “@backspace_deletes_character@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' logAttr #backspaceDeletesCharacter
-- @
getLogAttrBackspaceDeletesCharacter :: MonadIO m => LogAttr -> m Word32
getLogAttrBackspaceDeletesCharacter s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO Word32
    return val

-- | Set the value of the “@backspace_deletes_character@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' logAttr [ #backspaceDeletesCharacter 'Data.GI.Base.Attributes.:=' value ]
-- @
setLogAttrBackspaceDeletesCharacter :: MonadIO m => LogAttr -> Word32 -> m ()
setLogAttrBackspaceDeletesCharacter s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LogAttrBackspaceDeletesCharacterFieldInfo
instance AttrInfo LogAttrBackspaceDeletesCharacterFieldInfo where
    type AttrBaseTypeConstraint LogAttrBackspaceDeletesCharacterFieldInfo = (~) LogAttr
    type AttrAllowedOps LogAttrBackspaceDeletesCharacterFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LogAttrBackspaceDeletesCharacterFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LogAttrBackspaceDeletesCharacterFieldInfo = (~)Word32
    type AttrTransferType LogAttrBackspaceDeletesCharacterFieldInfo = Word32
    type AttrGetType LogAttrBackspaceDeletesCharacterFieldInfo = Word32
    type AttrLabel LogAttrBackspaceDeletesCharacterFieldInfo = "backspace_deletes_character"
    type AttrOrigin LogAttrBackspaceDeletesCharacterFieldInfo = LogAttr
    attrGet = getLogAttrBackspaceDeletesCharacter
    attrSet = setLogAttrBackspaceDeletesCharacter
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LogAttr.backspaceDeletesCharacter"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LogAttr.html#g:attr:backspaceDeletesCharacter"
        })

logAttr_backspaceDeletesCharacter :: AttrLabelProxy "backspaceDeletesCharacter"
logAttr_backspaceDeletesCharacter = AttrLabelProxy

#endif


-- | Get the value of the “@is_expandable_space@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' logAttr #isExpandableSpace
-- @
getLogAttrIsExpandableSpace :: MonadIO m => LogAttr -> m Word32
getLogAttrIsExpandableSpace s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 44) :: IO Word32
    return val

-- | Set the value of the “@is_expandable_space@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' logAttr [ #isExpandableSpace 'Data.GI.Base.Attributes.:=' value ]
-- @
setLogAttrIsExpandableSpace :: MonadIO m => LogAttr -> Word32 -> m ()
setLogAttrIsExpandableSpace s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 44) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LogAttrIsExpandableSpaceFieldInfo
instance AttrInfo LogAttrIsExpandableSpaceFieldInfo where
    type AttrBaseTypeConstraint LogAttrIsExpandableSpaceFieldInfo = (~) LogAttr
    type AttrAllowedOps LogAttrIsExpandableSpaceFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LogAttrIsExpandableSpaceFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LogAttrIsExpandableSpaceFieldInfo = (~)Word32
    type AttrTransferType LogAttrIsExpandableSpaceFieldInfo = Word32
    type AttrGetType LogAttrIsExpandableSpaceFieldInfo = Word32
    type AttrLabel LogAttrIsExpandableSpaceFieldInfo = "is_expandable_space"
    type AttrOrigin LogAttrIsExpandableSpaceFieldInfo = LogAttr
    attrGet = getLogAttrIsExpandableSpace
    attrSet = setLogAttrIsExpandableSpace
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LogAttr.isExpandableSpace"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LogAttr.html#g:attr:isExpandableSpace"
        })

logAttr_isExpandableSpace :: AttrLabelProxy "isExpandableSpace"
logAttr_isExpandableSpace = AttrLabelProxy

#endif


-- | Get the value of the “@is_word_boundary@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' logAttr #isWordBoundary
-- @
getLogAttrIsWordBoundary :: MonadIO m => LogAttr -> m Word32
getLogAttrIsWordBoundary s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO Word32
    return val

-- | Set the value of the “@is_word_boundary@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' logAttr [ #isWordBoundary 'Data.GI.Base.Attributes.:=' value ]
-- @
setLogAttrIsWordBoundary :: MonadIO m => LogAttr -> Word32 -> m ()
setLogAttrIsWordBoundary s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LogAttrIsWordBoundaryFieldInfo
instance AttrInfo LogAttrIsWordBoundaryFieldInfo where
    type AttrBaseTypeConstraint LogAttrIsWordBoundaryFieldInfo = (~) LogAttr
    type AttrAllowedOps LogAttrIsWordBoundaryFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LogAttrIsWordBoundaryFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LogAttrIsWordBoundaryFieldInfo = (~)Word32
    type AttrTransferType LogAttrIsWordBoundaryFieldInfo = Word32
    type AttrGetType LogAttrIsWordBoundaryFieldInfo = Word32
    type AttrLabel LogAttrIsWordBoundaryFieldInfo = "is_word_boundary"
    type AttrOrigin LogAttrIsWordBoundaryFieldInfo = LogAttr
    attrGet = getLogAttrIsWordBoundary
    attrSet = setLogAttrIsWordBoundary
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LogAttr.isWordBoundary"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LogAttr.html#g:attr:isWordBoundary"
        })

logAttr_isWordBoundary :: AttrLabelProxy "isWordBoundary"
logAttr_isWordBoundary = AttrLabelProxy

#endif


-- | Get the value of the “@break_inserts_hyphen@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' logAttr #breakInsertsHyphen
-- @
getLogAttrBreakInsertsHyphen :: MonadIO m => LogAttr -> m Word32
getLogAttrBreakInsertsHyphen s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 52) :: IO Word32
    return val

-- | Set the value of the “@break_inserts_hyphen@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' logAttr [ #breakInsertsHyphen 'Data.GI.Base.Attributes.:=' value ]
-- @
setLogAttrBreakInsertsHyphen :: MonadIO m => LogAttr -> Word32 -> m ()
setLogAttrBreakInsertsHyphen s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 52) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LogAttrBreakInsertsHyphenFieldInfo
instance AttrInfo LogAttrBreakInsertsHyphenFieldInfo where
    type AttrBaseTypeConstraint LogAttrBreakInsertsHyphenFieldInfo = (~) LogAttr
    type AttrAllowedOps LogAttrBreakInsertsHyphenFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LogAttrBreakInsertsHyphenFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LogAttrBreakInsertsHyphenFieldInfo = (~)Word32
    type AttrTransferType LogAttrBreakInsertsHyphenFieldInfo = Word32
    type AttrGetType LogAttrBreakInsertsHyphenFieldInfo = Word32
    type AttrLabel LogAttrBreakInsertsHyphenFieldInfo = "break_inserts_hyphen"
    type AttrOrigin LogAttrBreakInsertsHyphenFieldInfo = LogAttr
    attrGet = getLogAttrBreakInsertsHyphen
    attrSet = setLogAttrBreakInsertsHyphen
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LogAttr.breakInsertsHyphen"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LogAttr.html#g:attr:breakInsertsHyphen"
        })

logAttr_breakInsertsHyphen :: AttrLabelProxy "breakInsertsHyphen"
logAttr_breakInsertsHyphen = AttrLabelProxy

#endif


-- | Get the value of the “@break_removes_preceding@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' logAttr #breakRemovesPreceding
-- @
getLogAttrBreakRemovesPreceding :: MonadIO m => LogAttr -> m Word32
getLogAttrBreakRemovesPreceding s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 56) :: IO Word32
    return val

-- | Set the value of the “@break_removes_preceding@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' logAttr [ #breakRemovesPreceding 'Data.GI.Base.Attributes.:=' value ]
-- @
setLogAttrBreakRemovesPreceding :: MonadIO m => LogAttr -> Word32 -> m ()
setLogAttrBreakRemovesPreceding s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LogAttrBreakRemovesPrecedingFieldInfo
instance AttrInfo LogAttrBreakRemovesPrecedingFieldInfo where
    type AttrBaseTypeConstraint LogAttrBreakRemovesPrecedingFieldInfo = (~) LogAttr
    type AttrAllowedOps LogAttrBreakRemovesPrecedingFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LogAttrBreakRemovesPrecedingFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LogAttrBreakRemovesPrecedingFieldInfo = (~)Word32
    type AttrTransferType LogAttrBreakRemovesPrecedingFieldInfo = Word32
    type AttrGetType LogAttrBreakRemovesPrecedingFieldInfo = Word32
    type AttrLabel LogAttrBreakRemovesPrecedingFieldInfo = "break_removes_preceding"
    type AttrOrigin LogAttrBreakRemovesPrecedingFieldInfo = LogAttr
    attrGet = getLogAttrBreakRemovesPreceding
    attrSet = setLogAttrBreakRemovesPreceding
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LogAttr.breakRemovesPreceding"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LogAttr.html#g:attr:breakRemovesPreceding"
        })

logAttr_breakRemovesPreceding :: AttrLabelProxy "breakRemovesPreceding"
logAttr_breakRemovesPreceding = AttrLabelProxy

#endif


-- | Get the value of the “@reserved@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' logAttr #reserved
-- @
getLogAttrReserved :: MonadIO m => LogAttr -> m Word32
getLogAttrReserved s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 60) :: IO Word32
    return val

-- | Set the value of the “@reserved@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' logAttr [ #reserved 'Data.GI.Base.Attributes.:=' value ]
-- @
setLogAttrReserved :: MonadIO m => LogAttr -> Word32 -> m ()
setLogAttrReserved s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 60) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data LogAttrReservedFieldInfo
instance AttrInfo LogAttrReservedFieldInfo where
    type AttrBaseTypeConstraint LogAttrReservedFieldInfo = (~) LogAttr
    type AttrAllowedOps LogAttrReservedFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint LogAttrReservedFieldInfo = (~) Word32
    type AttrTransferTypeConstraint LogAttrReservedFieldInfo = (~)Word32
    type AttrTransferType LogAttrReservedFieldInfo = Word32
    type AttrGetType LogAttrReservedFieldInfo = Word32
    type AttrLabel LogAttrReservedFieldInfo = "reserved"
    type AttrOrigin LogAttrReservedFieldInfo = LogAttr
    attrGet = getLogAttrReserved
    attrSet = setLogAttrReserved
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LogAttr.reserved"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LogAttr.html#g:attr:reserved"
        })

logAttr_reserved :: AttrLabelProxy "reserved"
logAttr_reserved = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList LogAttr
type instance O.AttributeList LogAttr = LogAttrAttributeList
type LogAttrAttributeList = ('[ '("isLineBreak", LogAttrIsLineBreakFieldInfo), '("isMandatoryBreak", LogAttrIsMandatoryBreakFieldInfo), '("isCharBreak", LogAttrIsCharBreakFieldInfo), '("isWhite", LogAttrIsWhiteFieldInfo), '("isCursorPosition", LogAttrIsCursorPositionFieldInfo), '("isWordStart", LogAttrIsWordStartFieldInfo), '("isWordEnd", LogAttrIsWordEndFieldInfo), '("isSentenceBoundary", LogAttrIsSentenceBoundaryFieldInfo), '("isSentenceStart", LogAttrIsSentenceStartFieldInfo), '("isSentenceEnd", LogAttrIsSentenceEndFieldInfo), '("backspaceDeletesCharacter", LogAttrBackspaceDeletesCharacterFieldInfo), '("isExpandableSpace", LogAttrIsExpandableSpaceFieldInfo), '("isWordBoundary", LogAttrIsWordBoundaryFieldInfo), '("breakInsertsHyphen", LogAttrBreakInsertsHyphenFieldInfo), '("breakRemovesPreceding", LogAttrBreakRemovesPrecedingFieldInfo), '("reserved", LogAttrReservedFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveLogAttrMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveLogAttrMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveLogAttrMethod t LogAttr, O.OverloadedMethod info LogAttr p) => OL.IsLabel t (LogAttr -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveLogAttrMethod t LogAttr, O.OverloadedMethod info LogAttr p, R.HasField t LogAttr p) => R.HasField t LogAttr p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveLogAttrMethod t LogAttr, O.OverloadedMethodInfo info LogAttr) => OL.IsLabel t (O.MethodProxy info LogAttr) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


