mod application;
#[rustfmt::skip]
mod config;
mod classify;
mod widgets;
mod window;

use gettextrs::{LocaleCategory, gettext};
use gtk::{gio, glib};

use self::application::HieroglyphicApplication;
use self::config::{GETTEXT_PACKAGE, LOCALEDIR, RESOURCES_FILE};

fn main() -> glib::ExitCode {
    // Initialize logger
    tracing_subscriber::fmt::init();

    unsafe {
        // ensure that adwaita is used
        std::env::remove_var("GTK_THEME");
    }

    // Prepare i18n
    gettextrs::setlocale(LocaleCategory::LcAll, "");
    gettextrs::bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR).expect("Unable to bind the text domain");
    gettextrs::textdomain(GETTEXT_PACKAGE).expect("Unable to switch to the text domain");

    glib::set_application_name(&gettext("Hieroglyphic"));

    let res = gio::Resource::load(RESOURCES_FILE).expect("Could not load gresource file");
    gio::resources_register(&res);

    let app = HieroglyphicApplication::default();
    app.run()
}
