
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kshell_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <kshell.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KShell_Type = nullptr;
static PyTypeObject *Sbk_KShell_TypeF(void)
{
    return _Sbk_KShell_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KShell_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KShell");
    return -1;
}

static PyObject *Sbk_KShellFunc_joinArgs(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KShell::joinArgs(QStringList)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArg)))) {
        overloadId = 0; // joinArgs(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "joinArgs", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKShell_IDX]);

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // joinArgs(QStringList)
            QString cppResult = ::KShell::joinArgs(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KShellFunc_quoteArg(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KShell::quoteArg(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // quoteArg(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "quoteArg", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKShell_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // quoteArg(QString)
            QString cppResult = ::KShell::quoteArg(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KShellFunc_splitArgs(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "splitArgs", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKShell_IDX]);

    if (PyArg_ParseTuple(args, "|OO:splitArgs", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KShell::splitArgs(QString,QFlags<KShell::Option>=,KShell::Errors*=)->QStringList
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // splitArgs(QString,QFlags<KShell::Option>,KShell::Errors*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KShell_Option_IDX])))->flagsConverter, (pyArgs[1])))) {
            overloadId = 0; // splitArgs(QString,QFlags<KShell::Option>,KShell::Errors*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "splitArgs", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKShell_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"flags", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KShell_Option_IDX])))->flagsConverter, (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "splitArgs", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKShell_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<KShell::Option> cppArg1(KShell::Option::NoOptions);
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        ::KShell::Errors* removed_cppArg2 = nullptr;
        SBK_UNUSED(removed_cppArg2)

        if (Shiboken::Errors::occurred() == nullptr) {
            // splitArgs(QString,QFlags<KShell::Option>,KShell::Errors*)
            QStringList cppResult = ::KShell::splitArgs(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KShellFunc_tildeCollapse(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KShell::tildeCollapse(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // tildeCollapse(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tildeCollapse", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKShell_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tildeCollapse(QString)
            QString cppResult = ::KShell::tildeCollapse(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KShellFunc_tildeExpand(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KShell::tildeExpand(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // tildeExpand(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tildeExpand", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKShell_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tildeExpand(QString)
            QString cppResult = ::KShell::tildeExpand(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KShell_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KShell_EnumFlagInfo[] = {
    "Errors:IntEnum",
    "Option:IntFlag:Options",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KShell_methods[] = {
    {"joinArgs", reinterpret_cast<PyCFunction>(Sbk_KShellFunc_joinArgs), METH_O|METH_STATIC, nullptr},
    {"quoteArg", reinterpret_cast<PyCFunction>(Sbk_KShellFunc_quoteArg), METH_O|METH_STATIC, nullptr},
    {"splitArgs", reinterpret_cast<PyCFunction>(Sbk_KShellFunc_splitArgs), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"tildeCollapse", reinterpret_cast<PyCFunction>(Sbk_KShellFunc_tildeCollapse), METH_O|METH_STATIC, nullptr},
    {"tildeExpand", reinterpret_cast<PyCFunction>(Sbk_KShellFunc_tildeExpand), METH_O|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KShell_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KShell_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KShell_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KShell_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KShell_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KShell_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KShell_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KShell_spec = {
    "1:KCoreAddons.KShell",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KShell_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KShell_Option(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KShell::Option>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KShell::Option *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KShell_Option_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KShell_Option_IDX])))
        return Enum_PythonToCpp_KShell_Option;
    return {};
}

static PyObject *KShell_Option_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KShell::Option>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KShell::Option *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KShell_Option(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KShell::Option>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KShell::Option> *>(cppOut) = value;

}

static PyObject *KShell_Option_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KShell::Option> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KShell_Option_IDX]), flags.toInt());

}

static void Enum_PythonToCpp_KShell_Errors(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KShell::Errors>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KShell::Errors *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KShell_Errors_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KShell_Errors_IDX])))
        return Enum_PythonToCpp_KShell_Errors;
    return {};
}

static PyObject *KShell_Errors_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KShell::Errors>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KShell::Errors *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddonsKShell_SignatureStrings[] = {
    "KCoreAddons.KShell.joinArgs(args:QStringList)->QString",
    "KCoreAddons.KShell.quoteArg(arg:QString)->QString",
    "KCoreAddons.KShell.splitArgs(cmd:QString,flags:KCoreAddons.KShell.Option=KShell.Option.NoOptions)->QStringList",
    "KCoreAddons.KShell.tildeCollapse(path:QString)->QString",
    "KCoreAddons.KShell.tildeExpand(path:QString)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddonsKShell_SignatureByteSize = 145;
static constexpr uint8_t KCoreAddonsKShell_SignatureBytes[145] = {
    0x78, 0xda, 0xf3, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0x0e,
    0xce, 0x48, 0xcd, 0xc9, 0xd1, 0xcb, 0xca, 0xcf, 0xcc, 0x73, 0x2c, 0x4a, 0x2f, 0xd6, 0x48, 0x04,
    0x12, 0x56, 0x81, 0xc1, 0x25, 0x45, 0x99, 0x79, 0xe9, 0x3e, 0x99, 0xc5, 0x25, 0x9a, 0xba, 0x76,
    0x50, 0x1e, 0x97, 0x37, 0xa6, 0xb6, 0xc2, 0xd2, 0xfc, 0x92, 0x54, 0xa0, 0x3e, 0x90, 0x36, 0x98,
    0x2e, 0xfc, 0x3a, 0x8a, 0x0b, 0x72, 0x32, 0x4b, 0xc0, 0x36, 0x25, 0xe7, 0xa6, 0xc0, 0xb4, 0xe8,
    0xa4, 0xe5, 0x24, 0x02, 0xad, 0xc5, 0xa2, 0xdc, 0xbf, 0xa0, 0x24, 0x33, 0x3f, 0xcf, 0x16, 0x85,
    0xa7, 0xe7, 0x97, 0x0f, 0x61, 0x14, 0x23, 0xac, 0x02, 0x39, 0x15, 0x9b, 0x75, 0x25, 0x99, 0x39,
    0x29, 0xa9, 0xce, 0xf9, 0x39, 0x39, 0x89, 0x05, 0xc5, 0xa9, 0x1a, 0x05, 0x89, 0x25, 0x19, 0xc4,
    0x39, 0x13, 0xac, 0xcf, 0xb5, 0xa2, 0x20, 0x31, 0x2f, 0x05, 0x97, 0x2e, 0x00, 0x95, 0x24, 0x76,
    0x25
};
#endif

PyTypeObject *init_KCoreAddonsKShell(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKShell_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKShell_IDX].type;

    Shiboken::AutoDecRef Sbk_KShell_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KShell_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KShell",
        "KShell",
        &Sbk_KShell_spec,
        nullptr,
        Sbk_KShell_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KShell_Type; // references _Sbk_KShell_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCoreAddonsKShell_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCoreAddonsKShell_SignatureBytes, KCoreAddonsKShell_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KShell_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKShell_IDX].type = pyType;


    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KShell_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Option'.
    const char *Option_Initializer[] = {
        "NoOptions",
        "TildeExpand",
        "AbortOnMeta",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Option_InitializerValues[] = {
        uint8_t(KShell::Option::NoOptions),   //  0x00  0
        uint8_t(KShell::Option::TildeExpand), //  0x01  1
        uint8_t(KShell::Option::AbortOnMeta)  //  0x02  2
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KShell_TypeF(),
        "1:KCoreAddons.KShell.Option",
        Option_Initializer, Option_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KShell_Option_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKCoreAddonsTypeStructs[SBK_QFlags_KShell_Option_IDX].type =
        EType;
    // Register converter for enum 'KShell::Option'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KShell_Option_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KShell_Option,
            is_Enum_PythonToCpp_KShell_Option_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KShell::Option");
        Shiboken::Conversions::registerConverterAlias(converter, "Option");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KShell_Option_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KShell_Option,
            is_Enum_PythonToCpp_KShell_Option_Convertible);
        // Register converter for flag 'QFlags<KShell::Option>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KShell::Option>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KShell::Options");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'Option' enum/flags.

    // Initialization of enum 'Errors'.
    const char *Errors_Initializer[] = {
        "NoError",
        "BadQuoting",
        "FoundMeta",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Errors_InitializerValues[] = {
        uint8_t(KShell::Errors::NoError),    //  0x00  0
        uint8_t(KShell::Errors::BadQuoting), //  0x01  1
        uint8_t(KShell::Errors::FoundMeta)   //  0x02  2
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KShell_TypeF(),
        "1:KCoreAddons.KShell.Errors",
        Errors_Initializer, Errors_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KShell_Errors_IDX].type = EType;
    // Register converter for enum 'KShell::Errors'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KShell_Errors_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KShell_Errors,
            is_Enum_PythonToCpp_KShell_Errors_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KShell::Errors");
        Shiboken::Conversions::registerConverterAlias(converter, "Errors");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Errors' enum.

    qRegisterMetaType< ::KShell::Option >("KShell::Option");
    qRegisterMetaType< ::KShell::Errors >("KShell::Errors");

    return pyType;
}
