#ifndef SBK_KNOTIFICATIONACTIONWRAPPER_H
#define SBK_KNOTIFICATIONACTIONWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <knotification.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KNotificationActionWrapper : public KNotificationAction
{
public:
    KNotificationActionWrapper(::QObject * parent = nullptr);
    KNotificationActionWrapper(const ::QString & label);
    KNotificationActionWrapper(const KNotificationActionWrapper &) = delete;
    KNotificationActionWrapper& operator=(const KNotificationActionWrapper &) = delete;
    KNotificationActionWrapper(KNotificationActionWrapper &&) = delete;
    KNotificationActionWrapper& operator=(KNotificationActionWrapper &&) = delete;
    ~KNotificationActionWrapper() override;

    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 7> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KNOTIFICATIONACTIONWRAPPER_H
