// Code generated by smithy-go-codegen DO NOT EDIT.

package route53

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of your hosted zones in lexicographic order. The response
// includes a HostedZones child element for each hosted zone created by the
// current Amazon Web Services account.
//
// ListHostedZonesByName sorts hosted zones by name with the labels reversed. For
// example:
//
//	com.example.www.
//
// Note the trailing dot, which can change the sort order in some circumstances.
//
// If the domain name includes escape characters or Punycode, ListHostedZonesByName
// alphabetizes the domain name using the escaped or Punycoded value, which is the
// format that Amazon Route 53 saves in its database. For example, to create a
// hosted zone for exämple.com, you specify ex\344mple.com for the domain name.
// ListHostedZonesByName alphabetizes it as:
//
//	com.ex\344mple.
//
// The labels are reversed and alphabetized using the escaped value. For more
// information about valid domain name formats, including internationalized domain
// names, see [DNS Domain Name Format]in the Amazon Route 53 Developer Guide.
//
// Route 53 returns up to 100 items in each response. If you have a lot of hosted
// zones, use the MaxItems parameter to list them in groups of up to 100. The
// response includes values that help navigate from one group of MaxItems hosted
// zones to the next:
//
//   - The DNSName and HostedZoneId elements in the response contain the values, if
//     any, specified for the dnsname and hostedzoneid parameters in the request that
//     produced the current response.
//
//   - The MaxItems element in the response contains the value, if any, that you
//     specified for the maxitems parameter in the request that produced the current
//     response.
//
//   - If the value of IsTruncated in the response is true, there are more hosted
//     zones associated with the current Amazon Web Services account.
//
// If IsTruncated is false, this response includes the last hosted zone that is
//
//	associated with the current account. The NextDNSName element and
//	NextHostedZoneId elements are omitted from the response.
//
//	- The NextDNSName and NextHostedZoneId elements in the response contain the
//	domain name and the hosted zone ID of the next hosted zone that is associated
//	with the current Amazon Web Services account. If you want to list more hosted
//	zones, make another call to ListHostedZonesByName , and specify the value of
//	NextDNSName and NextHostedZoneId in the dnsname and hostedzoneid parameters,
//	respectively.
//
// [DNS Domain Name Format]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html
func (c *Client) ListHostedZonesByName(ctx context.Context, params *ListHostedZonesByNameInput, optFns ...func(*Options)) (*ListHostedZonesByNameOutput, error) {
	if params == nil {
		params = &ListHostedZonesByNameInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListHostedZonesByName", params, optFns, c.addOperationListHostedZonesByNameMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListHostedZonesByNameOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Retrieves a list of the public and private hosted zones that are associated
// with the current Amazon Web Services account in ASCII order by domain name.
type ListHostedZonesByNameInput struct {

	// (Optional) For your first request to ListHostedZonesByName , include the dnsname
	// parameter only if you want to specify the name of the first hosted zone in the
	// response. If you don't include the dnsname parameter, Amazon Route 53 returns
	// all of the hosted zones that were created by the current Amazon Web Services
	// account, in ASCII order. For subsequent requests, include both dnsname and
	// hostedzoneid parameters. For dnsname , specify the value of NextDNSName from
	// the previous response.
	DNSName *string

	// (Optional) For your first request to ListHostedZonesByName , do not include the
	// hostedzoneid parameter.
	//
	// If you have more hosted zones than the value of maxitems , ListHostedZonesByName
	// returns only the first maxitems hosted zones. To get the next group of maxitems
	// hosted zones, submit another request to ListHostedZonesByName and include both
	// dnsname and hostedzoneid parameters. For the value of hostedzoneid , specify the
	// value of the NextHostedZoneId element from the previous response.
	HostedZoneId *string

	// The maximum number of hosted zones to be included in the response body for this
	// request. If you have more than maxitems hosted zones, then the value of the
	// IsTruncated element in the response is true, and the values of NextDNSName and
	// NextHostedZoneId specify the first hosted zone in the next group of maxitems
	// hosted zones.
	MaxItems *int32

	noSmithyDocumentSerde
}

// A complex type that contains the response information for the request.
type ListHostedZonesByNameOutput struct {

	// A complex type that contains general information about the hosted zone.
	//
	// This member is required.
	HostedZones []types.HostedZone

	// A flag that indicates whether there are more hosted zones to be listed. If the
	// response was truncated, you can get the next group of maxitems hosted zones by
	// calling ListHostedZonesByName again and specifying the values of NextDNSName
	// and NextHostedZoneId elements in the dnsname and hostedzoneid parameters.
	//
	// This member is required.
	IsTruncated bool

	// The value that you specified for the maxitems parameter in the call to
	// ListHostedZonesByName that produced the current response.
	//
	// This member is required.
	MaxItems *int32

	// For the second and subsequent calls to ListHostedZonesByName , DNSName is the
	// value that you specified for the dnsname parameter in the request that produced
	// the current response.
	DNSName *string

	// The ID that Amazon Route 53 assigned to the hosted zone when you created it.
	HostedZoneId *string

	// If IsTruncated is true, the value of NextDNSName is the name of the first
	// hosted zone in the next group of maxitems hosted zones. Call
	// ListHostedZonesByName again and specify the value of NextDNSName and
	// NextHostedZoneId in the dnsname and hostedzoneid parameters, respectively.
	//
	// This element is present only if IsTruncated is true .
	NextDNSName *string

	// If IsTruncated is true , the value of NextHostedZoneId identifies the first
	// hosted zone in the next group of maxitems hosted zones. Call
	// ListHostedZonesByName again and specify the value of NextDNSName and
	// NextHostedZoneId in the dnsname and hostedzoneid parameters, respectively.
	//
	// This element is present only if IsTruncated is true .
	NextHostedZoneId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListHostedZonesByNameMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpListHostedZonesByName{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpListHostedZonesByName{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListHostedZonesByName"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListHostedZonesByName(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addSanitizeURLMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListHostedZonesByName(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListHostedZonesByName",
	}
}
