/* session-list.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from session-list.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Michael Terry <michael.terry@canonical.com>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <lightdm.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>

#define SESSION_LIST_BADGE_SIZE 22
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_FADABLE (fadable_get_type ())
#define FADABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE, Fadable))
#define IS_FADABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE))
#define FADABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FADABLE, FadableIface))

typedef struct _Fadable Fadable;
typedef struct _FadableIface FadableIface;

#define TYPE_FADE_TRACKER (fade_tracker_get_type ())
#define FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADE_TRACKER, FadeTracker))
#define FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADE_TRACKER, FadeTrackerClass))
#define IS_FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADE_TRACKER))
#define IS_FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADE_TRACKER))
#define FADE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADE_TRACKER, FadeTrackerClass))

typedef struct _FadeTracker FadeTracker;
typedef struct _FadeTrackerClass FadeTrackerClass;

#define TYPE_FADABLE_BOX (fadable_box_get_type ())
#define FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE_BOX, FadableBox))
#define FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADABLE_BOX, FadableBoxClass))
#define IS_FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE_BOX))
#define IS_FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADABLE_BOX))
#define FADABLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADABLE_BOX, FadableBoxClass))

typedef struct _FadableBox FadableBox;
typedef struct _FadableBoxClass FadableBoxClass;
typedef struct _FadableBoxPrivate FadableBoxPrivate;

#define TYPE_PROMPT_BOX (prompt_box_get_type ())
#define PROMPT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROMPT_BOX, PromptBox))
#define PROMPT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROMPT_BOX, PromptBoxClass))
#define IS_PROMPT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROMPT_BOX))
#define IS_PROMPT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROMPT_BOX))
#define PROMPT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROMPT_BOX, PromptBoxClass))

typedef struct _PromptBox PromptBox;
typedef struct _PromptBoxClass PromptBoxClass;
typedef struct _PromptBoxPrivate PromptBoxPrivate;

#define TYPE_FADING_LABEL (fading_label_get_type ())
#define FADING_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADING_LABEL, FadingLabel))
#define FADING_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADING_LABEL, FadingLabelClass))
#define IS_FADING_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADING_LABEL))
#define IS_FADING_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADING_LABEL))
#define FADING_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADING_LABEL, FadingLabelClass))

typedef struct _FadingLabel FadingLabel;
typedef struct _FadingLabelClass FadingLabelClass;

#define TYPE_FLAT_BUTTON (flat_button_get_type ())
#define FLAT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAT_BUTTON, FlatButton))
#define FLAT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FLAT_BUTTON, FlatButtonClass))
#define IS_FLAT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAT_BUTTON))
#define IS_FLAT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FLAT_BUTTON))
#define FLAT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FLAT_BUTTON, FlatButtonClass))

typedef struct _FlatButton FlatButton;
typedef struct _FlatButtonClass FlatButtonClass;

#define TYPE_SESSION_PROMPT (session_prompt_get_type ())
#define SESSION_PROMPT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SESSION_PROMPT, SessionPrompt))
#define SESSION_PROMPT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SESSION_PROMPT, SessionPromptClass))
#define IS_SESSION_PROMPT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SESSION_PROMPT))
#define IS_SESSION_PROMPT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SESSION_PROMPT))
#define SESSION_PROMPT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SESSION_PROMPT, SessionPromptClass))

typedef struct _SessionPrompt SessionPrompt;
typedef struct _SessionPromptClass SessionPromptClass;
typedef struct _SessionPromptPrivate SessionPromptPrivate;

#define TYPE_TOGGLE_BOX (toggle_box_get_type ())
#define TOGGLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOGGLE_BOX, ToggleBox))
#define TOGGLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOGGLE_BOX, ToggleBoxClass))
#define IS_TOGGLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOGGLE_BOX))
#define IS_TOGGLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOGGLE_BOX))
#define TOGGLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOGGLE_BOX, ToggleBoxClass))

typedef struct _ToggleBox ToggleBox;
typedef struct _ToggleBoxClass ToggleBoxClass;
enum  {
	SESSION_PROMPT_0_PROPERTY,
	SESSION_PROMPT_SESSION_PROPERTY,
	SESSION_PROMPT_DEFAULT_SESSION_PROPERTY,
	SESSION_PROMPT_NUM_PROPERTIES
};
static GParamSpec* session_prompt_properties[SESSION_PROMPT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SLICK_GREETER (slick_greeter_get_type ())
#define SLICK_GREETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLICK_GREETER, SlickGreeter))
#define SLICK_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLICK_GREETER, SlickGreeterClass))
#define IS_SLICK_GREETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLICK_GREETER))
#define IS_SLICK_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLICK_GREETER))
#define SLICK_GREETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLICK_GREETER, SlickGreeterClass))

typedef struct _SlickGreeter SlickGreeter;
typedef struct _SlickGreeterClass SlickGreeterClass;
typedef struct _SlickGreeterPrivate SlickGreeterPrivate;

#define TYPE_GREETER_LIST (greeter_list_get_type ())
#define GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GREETER_LIST, GreeterList))
#define GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GREETER_LIST, GreeterListClass))
#define IS_GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GREETER_LIST))
#define IS_GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GREETER_LIST))
#define GREETER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GREETER_LIST, GreeterListClass))

typedef struct _GreeterList GreeterList;
typedef struct _GreeterListClass GreeterListClass;
typedef struct _GreeterListPrivate GreeterListPrivate;

#define TYPE_DASH_BOX (dash_box_get_type ())
#define DASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DASH_BOX, DashBox))
#define DASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DASH_BOX, DashBoxClass))
#define IS_DASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DASH_BOX))
#define IS_DASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DASH_BOX))
#define DASH_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DASH_BOX, DashBoxClass))

typedef struct _DashBox DashBox;
typedef struct _DashBoxClass DashBoxClass;
typedef enum  {
	GREETER_LIST_MODE_ENTRY,
	GREETER_LIST_MODE_SCROLLING
} GreeterListMode;

#define GREETER_LIST_TYPE_MODE (greeter_list_mode_get_type ())

#define TYPE_SESSION_LIST (session_list_get_type ())
#define SESSION_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SESSION_LIST, SessionList))
#define SESSION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SESSION_LIST, SessionListClass))
#define IS_SESSION_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SESSION_LIST))
#define IS_SESSION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SESSION_LIST))
#define SESSION_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SESSION_LIST, SessionListClass))

typedef struct _SessionList SessionList;
typedef struct _SessionListClass SessionListClass;
typedef struct _SessionListPrivate SessionListPrivate;
enum  {
	SESSION_LIST_0_PROPERTY,
	SESSION_LIST_SESSION_PROPERTY,
	SESSION_LIST_DEFAULT_SESSION_PROPERTY,
	SESSION_LIST_NUM_PROPERTIES
};
static GParamSpec* session_list_properties[SESSION_LIST_NUM_PROPERTIES];

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;

#define TYPE_MENU_BAR (menu_bar_get_type ())
#define MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENU_BAR, MenuBar))
#define MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENU_BAR, MenuBarClass))
#define IS_MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENU_BAR))
#define IS_MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENU_BAR))
#define MENU_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENU_BAR, MenuBarClass))

typedef struct _MenuBar MenuBar;
typedef struct _MenuBarClass MenuBarClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	SESSION_LIST_SESSION_CLICKED_SIGNAL,
	SESSION_LIST_NUM_SIGNALS
};
static guint session_list_signals[SESSION_LIST_NUM_SIGNALS] = {0};

struct _FadableIface {
	GTypeInterface parent_iface;
	FadeTracker* (*get_fade_tracker) (Fadable* self);
	void (*set_fade_tracker) (Fadable* self, FadeTracker* value);
};

struct _FadableBox {
	GtkEventBox parent_instance;
	FadableBoxPrivate * priv;
};

struct _FadableBoxClass {
	GtkEventBoxClass parent_class;
	void (*draw_full_alpha) (FadableBox* self, cairo_t* c);
};

struct _PromptBox {
	FadableBox parent_instance;
	PromptBoxPrivate * priv;
	GtkGrid* box_grid;
	GtkGrid* name_grid;
	FadingLabel* name_label;
	FlatButton* option_button;
	GtkWidget* small_box_widget;
	FadingLabel* small_name_label;
	gint start_row;
	gint last_row;
};

struct _PromptBoxClass {
	FadableBoxClass parent_class;
	GtkGrid* (*create_name_grid) (PromptBox* self);
	GtkGrid* (*create_small_name_grid) (PromptBox* self);
	void (*set_start_row) (PromptBox* self);
	void (*reset_last_row) (PromptBox* self);
	void (*add_static_prompts) (PromptBox* self);
};

struct _SessionPrompt {
	PromptBox parent_instance;
	SessionPromptPrivate * priv;
};

struct _SessionPromptClass {
	PromptBoxClass parent_class;
};

struct _SessionPromptPrivate {
	gchar* _session;
	gchar* _default_session;
	ToggleBox* box;
};

struct _SlickGreeter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SlickGreeterPrivate * priv;
	gboolean test_mode;
	gboolean orca_needs_kick;
};

struct _SlickGreeterClass {
	GTypeClass parent_class;
	void (*finalize) (SlickGreeter *self);
};

struct _GreeterList {
	FadableBox parent_instance;
	GreeterListPrivate * priv;
	gchar* greeter_authenticating_user;
	gboolean _always_show_manual;
	GList* entries;
	DashBox* greeter_box;
	GreeterListMode mode;
	gboolean will_clear;
	gboolean prompted;
	gboolean unacknowledged_messages;
	gchar* test_username;
	gboolean test_is_authenticated;
};

struct _GreeterListClass {
	FadableBoxClass parent_class;
	gchar* (*get_selected_id) (GreeterList* self);
	void (*focus_prompt) (GreeterList* self);
	void (*show_authenticated) (GreeterList* self, gboolean successful);
	void (*insert_entry) (GreeterList* self, PromptBox* entry);
	void (*add_manual_entry) (GreeterList* self);
	gint (*get_position_y) (GreeterList* self, gdouble position);
	void (*setup_prompt_box) (GreeterList* self, gboolean fade);
	void (*show_prompt_cb) (GreeterList* self, const gchar* text, LightDMPromptType type);
	void (*authentication_complete_cb) (GreeterList* self);
	void (*start_authentication) (GreeterList* self);
	gchar* (*get_lightdm_session) (GreeterList* self);
	void (*test_start_authentication) (GreeterList* self);
};

struct _SessionList {
	GreeterList parent_instance;
	SessionListPrivate * priv;
};

struct _SessionListClass {
	GreeterListClass parent_class;
};

struct _SessionListPrivate {
	gchar* _session;
	gchar* _default_session;
	SessionPrompt* prompt;
};

static gint SessionPrompt_private_offset;
static gpointer session_prompt_parent_class = NULL;
VALA_EXTERN SlickGreeter* slick_greeter_singleton;
static gint SessionList_private_offset;
static gpointer session_list_parent_class = NULL;
static GHashTable* session_list_badges;
static GHashTable* session_list_badges = NULL;
VALA_EXTERN gint _scale_factor;

VALA_EXTERN GType fade_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FadeTracker, g_object_unref)
VALA_EXTERN GType fadable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Fadable, g_object_unref)
VALA_EXTERN GType fadable_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FadableBox, g_object_unref)
VALA_EXTERN GType prompt_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PromptBox, g_object_unref)
VALA_EXTERN GType fading_label_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FadingLabel, g_object_unref)
VALA_EXTERN GType flat_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FlatButton, g_object_unref)
VALA_EXTERN GType session_prompt_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SessionPrompt, g_object_unref)
VALA_EXTERN GType toggle_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ToggleBox, g_object_unref)
VALA_EXTERN SessionPrompt* session_prompt_new (const gchar* id,
                                   const gchar* session,
                                   const gchar* default_session);
VALA_EXTERN SessionPrompt* session_prompt_construct (GType object_type,
                                         const gchar* id,
                                         const gchar* session,
                                         const gchar* default_session);
static void session_prompt_selected_cb (SessionPrompt* self);
VALA_EXTERN const gchar* toggle_box_get_selected_key (ToggleBox* self);
VALA_EXTERN const gchar* session_prompt_get_session (SessionPrompt* self);
static void session_prompt_set_session (SessionPrompt* self,
                                 const gchar* value);
VALA_EXTERN const gchar* session_prompt_get_default_session (SessionPrompt* self);
static void session_prompt_set_default_session (SessionPrompt* self,
                                         const gchar* value);
static GObject * session_prompt_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
VALA_EXTERN void prompt_box_set_label (PromptBox* self,
                           const gchar* value);
VALA_EXTERN void prompt_box_hide_avatar (PromptBox* self);
VALA_EXTERN ToggleBox* toggle_box_new (const gchar* default_key,
                           const gchar* starting_key);
VALA_EXTERN ToggleBox* toggle_box_construct (GType object_type,
                                 const gchar* default_key,
                                 const gchar* starting_key);
VALA_EXTERN gpointer slick_greeter_ref (gpointer instance);
VALA_EXTERN void slick_greeter_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_slick_greeter (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_slick_greeter (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_slick_greeter (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_slick_greeter (const GValue* value);
VALA_EXTERN GType slick_greeter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SlickGreeter, slick_greeter_unref)
VALA_EXTERN void toggle_box_add_item (ToggleBox* self,
                          const gchar* key,
                          const gchar* label,
                          GdkPixbuf* icon);
VALA_EXTERN GdkPixbuf* session_list_get_badge (const gchar* session);
static void _session_prompt_selected_cb_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self);
VALA_EXTERN void prompt_box_attach_item (PromptBox* self,
                             GtkWidget* w,
                             gboolean add_style_class);
static void session_prompt_finalize (GObject * obj);
static GType session_prompt_get_type_once (void);
static void _vala_session_prompt_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_session_prompt_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
VALA_EXTERN GType greeter_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterList, g_object_unref)
VALA_EXTERN GType dash_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DashBox, g_object_unref)
VALA_EXTERN GType greeter_list_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType session_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SessionList, g_object_unref)
VALA_EXTERN void greeter_list_add_manual_entry (GreeterList* self);
VALA_EXTERN void greeter_list_show_authenticated (GreeterList* self,
                                      gboolean successful);
VALA_EXTERN GType background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Background, g_object_unref)
VALA_EXTERN GType menu_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MenuBar, g_object_unref)
VALA_EXTERN SessionList* session_list_new (Background* bg,
                               MenuBar* mb,
                               const gchar* session,
                               const gchar* default_session);
VALA_EXTERN SessionList* session_list_construct (GType object_type,
                                     Background* bg,
                                     MenuBar* mb,
                                     const gchar* session,
                                     const gchar* default_session);
static SessionPrompt* session_list_add_session_prompt (SessionList* self,
                                                const gchar* id);
VALA_EXTERN const gchar* session_list_get_session (SessionList* self);
VALA_EXTERN const gchar* session_list_get_default_session (SessionList* self);
static void __lambda42_ (SessionList* self,
                  gchar** responses,
                  gint responses_length1);
static void ___lambda42__prompt_box_respond (PromptBox* _sender,
                                      gchar** response,
                                      gint response_length1,
                                      gpointer self);
VALA_EXTERN void greeter_list_add_entry (GreeterList* self,
                             PromptBox* entry);
static void session_list_real_add_manual_entry (GreeterList* base);
static void session_list_real_show_authenticated (GreeterList* base,
                                           gboolean successful);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void session_list_set_session (SessionList* self,
                               const gchar* value);
static void session_list_set_default_session (SessionList* self,
                                       const gchar* value);
static GObject * session_list_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void session_list_finalize (GObject * obj);
static GType session_list_get_type_once (void);
static void _vala_session_list_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_session_list_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
session_prompt_get_instance_private (SessionPrompt* self)
{
	return G_STRUCT_MEMBER_P (self, SessionPrompt_private_offset);
}

SessionPrompt*
session_prompt_construct (GType object_type,
                          const gchar* id,
                          const gchar* session,
                          const gchar* default_session)
{
	SessionPrompt * self = NULL;
#line 25 "../src/session-list.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 27 "../src/session-list.vala"
	self = (SessionPrompt*) g_object_new (object_type, "id", id, "session", session, "default-session", default_session, NULL);
#line 25 "../src/session-list.vala"
	return self;
#line 514 "session-list.c"
}

SessionPrompt*
session_prompt_new (const gchar* id,
                    const gchar* session,
                    const gchar* default_session)
{
#line 25 "../src/session-list.vala"
	return session_prompt_construct (TYPE_SESSION_PROMPT, id, session, default_session);
#line 524 "session-list.c"
}

static void
session_prompt_selected_cb (SessionPrompt* self)
{
	ToggleBox* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
#line 64 "../src/session-list.vala"
	g_return_if_fail (self != NULL);
#line 66 "../src/session-list.vala"
	_tmp0_ = self->priv->box;
#line 66 "../src/session-list.vala"
	_tmp1_ = toggle_box_get_selected_key (_tmp0_);
#line 66 "../src/session-list.vala"
	_tmp2_ = _tmp1_;
#line 66 "../src/session-list.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 66 "../src/session-list.vala"
	_tmp4_ = g_new0 (gchar*, 1 + 1);
#line 66 "../src/session-list.vala"
	_tmp4_[0] = _tmp3_;
#line 66 "../src/session-list.vala"
	_tmp5_ = _tmp4_;
#line 66 "../src/session-list.vala"
	_tmp5__length1 = 1;
#line 66 "../src/session-list.vala"
	g_signal_emit_by_name ((PromptBox*) self, "respond", _tmp5_, (gint) 1);
#line 66 "../src/session-list.vala"
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
#line 559 "session-list.c"
}

const gchar*
session_prompt_get_session (SessionPrompt* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 22 "../src/session-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 22 "../src/session-list.vala"
	_tmp0_ = self->priv->_session;
#line 22 "../src/session-list.vala"
	result = _tmp0_;
#line 22 "../src/session-list.vala"
	return result;
#line 575 "session-list.c"
}

static void
session_prompt_set_session (SessionPrompt* self,
                            const gchar* value)
{
	gchar* old_value;
#line 22 "../src/session-list.vala"
	g_return_if_fail (self != NULL);
#line 22 "../src/session-list.vala"
	old_value = session_prompt_get_session (self);
#line 22 "../src/session-list.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 589 "session-list.c"
		gchar* _tmp0_;
#line 22 "../src/session-list.vala"
		_tmp0_ = g_strdup (value);
#line 22 "../src/session-list.vala"
		_g_free0 (self->priv->_session);
#line 22 "../src/session-list.vala"
		self->priv->_session = _tmp0_;
#line 22 "../src/session-list.vala"
		g_object_notify_by_pspec ((GObject *) self, session_prompt_properties[SESSION_PROMPT_SESSION_PROPERTY]);
#line 599 "session-list.c"
	}
}

const gchar*
session_prompt_get_default_session (SessionPrompt* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 23 "../src/session-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 23 "../src/session-list.vala"
	_tmp0_ = self->priv->_default_session;
#line 23 "../src/session-list.vala"
	result = _tmp0_;
#line 23 "../src/session-list.vala"
	return result;
#line 616 "session-list.c"
}

static void
session_prompt_set_default_session (SessionPrompt* self,
                                    const gchar* value)
{
	gchar* old_value;
#line 23 "../src/session-list.vala"
	g_return_if_fail (self != NULL);
#line 23 "../src/session-list.vala"
	old_value = session_prompt_get_default_session (self);
#line 23 "../src/session-list.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 630 "session-list.c"
		gchar* _tmp0_;
#line 23 "../src/session-list.vala"
		_tmp0_ = g_strdup (value);
#line 23 "../src/session-list.vala"
		_g_free0 (self->priv->_default_session);
#line 23 "../src/session-list.vala"
		self->priv->_default_session = _tmp0_;
#line 23 "../src/session-list.vala"
		g_object_notify_by_pspec ((GObject *) self, session_prompt_properties[SESSION_PROMPT_DEFAULT_SESSION_PROPERTY]);
#line 640 "session-list.c"
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 51 "../src/session-list.vala"
	return self ? g_object_ref (self) : NULL;
#line 649 "session-list.c"
}

static void
_session_prompt_selected_cb_g_object_notify (GObject* _sender,
                                             GParamSpec* pspec,
                                             gpointer self)
{
#line 58 "../src/session-list.vala"
	session_prompt_selected_cb ((SessionPrompt*) self);
#line 659 "session-list.c"
}

static GObject *
session_prompt_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SessionPrompt * self;
	FadingLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ToggleBox* _tmp3_;
	SlickGreeter* _tmp4_;
	ToggleBox* _tmp43_;
	ToggleBox* _tmp44_;
	ToggleBox* _tmp45_;
#line 32 "../src/session-list.vala"
	parent_class = G_OBJECT_CLASS (session_prompt_parent_class);
#line 32 "../src/session-list.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 32 "../src/session-list.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SESSION_PROMPT, SessionPrompt);
#line 34 "../src/session-list.vala"
	prompt_box_set_label ((PromptBox*) self, _ ("Select desktop environment"));
#line 35 "../src/session-list.vala"
	_tmp0_ = ((PromptBox*) self)->name_label;
#line 35 "../src/session-list.vala"
	gtk_widget_set_vexpand ((GtkWidget*) _tmp0_, FALSE);
#line 36 "../src/session-list.vala"
	prompt_box_hide_avatar ((PromptBox*) self);
#line 38 "../src/session-list.vala"
	_tmp1_ = self->priv->_default_session;
#line 38 "../src/session-list.vala"
	_tmp2_ = self->priv->_session;
#line 38 "../src/session-list.vala"
	_tmp3_ = toggle_box_new (_tmp1_, _tmp2_);
#line 38 "../src/session-list.vala"
	g_object_ref_sink (_tmp3_);
#line 38 "../src/session-list.vala"
	_g_object_unref0 (self->priv->box);
#line 38 "../src/session-list.vala"
	self->priv->box = _tmp3_;
#line 40 "../src/session-list.vala"
	_tmp4_ = slick_greeter_singleton;
#line 40 "../src/session-list.vala"
	if (_tmp4_->test_mode) {
#line 708 "session-list.c"
		ToggleBox* _tmp5_;
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp7_;
		ToggleBox* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		ToggleBox* _tmp11_;
		GdkPixbuf* _tmp12_;
		GdkPixbuf* _tmp13_;
		ToggleBox* _tmp14_;
		GdkPixbuf* _tmp15_;
		GdkPixbuf* _tmp16_;
		ToggleBox* _tmp17_;
		GdkPixbuf* _tmp18_;
		GdkPixbuf* _tmp19_;
		ToggleBox* _tmp20_;
		GdkPixbuf* _tmp21_;
		GdkPixbuf* _tmp22_;
#line 42 "../src/session-list.vala"
		_tmp5_ = self->priv->box;
#line 42 "../src/session-list.vala"
		_tmp6_ = session_list_get_badge ("cinnamon");
#line 42 "../src/session-list.vala"
		_tmp7_ = _tmp6_;
#line 42 "../src/session-list.vala"
		toggle_box_add_item (_tmp5_, "cinnamon", "Cinnamon", _tmp7_);
#line 42 "../src/session-list.vala"
		_g_object_unref0 (_tmp7_);
#line 43 "../src/session-list.vala"
		_tmp8_ = self->priv->box;
#line 43 "../src/session-list.vala"
		_tmp9_ = session_list_get_badge ("cinnamon");
#line 43 "../src/session-list.vala"
		_tmp10_ = _tmp9_;
#line 43 "../src/session-list.vala"
		toggle_box_add_item (_tmp8_, "cinnamon-wayland", "Cinnamon on Wayland (Experimental)", _tmp10_);
#line 43 "../src/session-list.vala"
		_g_object_unref0 (_tmp10_);
#line 44 "../src/session-list.vala"
		_tmp11_ = self->priv->box;
#line 44 "../src/session-list.vala"
		_tmp12_ = session_list_get_badge ("mate");
#line 44 "../src/session-list.vala"
		_tmp13_ = _tmp12_;
#line 44 "../src/session-list.vala"
		toggle_box_add_item (_tmp11_, "mate", "MATE", _tmp13_);
#line 44 "../src/session-list.vala"
		_g_object_unref0 (_tmp13_);
#line 45 "../src/session-list.vala"
		_tmp14_ = self->priv->box;
#line 45 "../src/session-list.vala"
		_tmp15_ = session_list_get_badge ("xfce");
#line 45 "../src/session-list.vala"
		_tmp16_ = _tmp15_;
#line 45 "../src/session-list.vala"
		toggle_box_add_item (_tmp14_, "xfce", "Xfce", _tmp16_);
#line 45 "../src/session-list.vala"
		_g_object_unref0 (_tmp16_);
#line 46 "../src/session-list.vala"
		_tmp17_ = self->priv->box;
#line 46 "../src/session-list.vala"
		_tmp18_ = session_list_get_badge ("kde");
#line 46 "../src/session-list.vala"
		_tmp19_ = _tmp18_;
#line 46 "../src/session-list.vala"
		toggle_box_add_item (_tmp17_, "kde", "KDE", _tmp19_);
#line 46 "../src/session-list.vala"
		_g_object_unref0 (_tmp19_);
#line 47 "../src/session-list.vala"
		_tmp20_ = self->priv->box;
#line 47 "../src/session-list.vala"
		_tmp21_ = session_list_get_badge ("gnome");
#line 47 "../src/session-list.vala"
		_tmp22_ = _tmp21_;
#line 47 "../src/session-list.vala"
		toggle_box_add_item (_tmp20_, "gnome", "GNOME", _tmp22_);
#line 47 "../src/session-list.vala"
		_g_object_unref0 (_tmp22_);
#line 787 "session-list.c"
	} else {
		GList* _tmp23_;
#line 51 "../src/session-list.vala"
		_tmp23_ = lightdm_get_sessions ();
#line 792 "session-list.c"
		{
			GList* session_collection = NULL;
			GList* session_it = NULL;
#line 51 "../src/session-list.vala"
			session_collection = _tmp23_;
#line 51 "../src/session-list.vala"
			for (session_it = session_collection; session_it != NULL; session_it = session_it->next) {
#line 800 "session-list.c"
				LightDMSession* _tmp24_;
				LightDMSession* session = NULL;
#line 51 "../src/session-list.vala"
				_tmp24_ = _g_object_ref0 ((LightDMSession*) session_it->data);
#line 51 "../src/session-list.vala"
				session = _tmp24_;
#line 807 "session-list.c"
				{
					LightDMSession* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					LightDMSession* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					ToggleBox* _tmp31_;
					LightDMSession* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					LightDMSession* _tmp35_;
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					LightDMSession* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					GdkPixbuf* _tmp41_;
					GdkPixbuf* _tmp42_;
#line 53 "../src/session-list.vala"
					_tmp25_ = session;
#line 53 "../src/session-list.vala"
					_tmp26_ = lightdm_session_get_key (_tmp25_);
#line 53 "../src/session-list.vala"
					_tmp27_ = _tmp26_;
#line 53 "../src/session-list.vala"
					_tmp28_ = session;
#line 53 "../src/session-list.vala"
					_tmp29_ = lightdm_session_get_name (_tmp28_);
#line 53 "../src/session-list.vala"
					_tmp30_ = _tmp29_;
#line 53 "../src/session-list.vala"
					g_debug ("session-list.vala:53: Adding session %s (%s)", _tmp27_, _tmp30_);
#line 54 "../src/session-list.vala"
					_tmp31_ = self->priv->box;
#line 54 "../src/session-list.vala"
					_tmp32_ = session;
#line 54 "../src/session-list.vala"
					_tmp33_ = lightdm_session_get_key (_tmp32_);
#line 54 "../src/session-list.vala"
					_tmp34_ = _tmp33_;
#line 54 "../src/session-list.vala"
					_tmp35_ = session;
#line 54 "../src/session-list.vala"
					_tmp36_ = lightdm_session_get_name (_tmp35_);
#line 54 "../src/session-list.vala"
					_tmp37_ = _tmp36_;
#line 54 "../src/session-list.vala"
					_tmp38_ = session;
#line 54 "../src/session-list.vala"
					_tmp39_ = lightdm_session_get_key (_tmp38_);
#line 54 "../src/session-list.vala"
					_tmp40_ = _tmp39_;
#line 54 "../src/session-list.vala"
					_tmp41_ = session_list_get_badge (_tmp40_);
#line 54 "../src/session-list.vala"
					_tmp42_ = _tmp41_;
#line 54 "../src/session-list.vala"
					toggle_box_add_item (_tmp31_, _tmp34_, _tmp37_, _tmp42_);
#line 54 "../src/session-list.vala"
					_g_object_unref0 (_tmp42_);
#line 51 "../src/session-list.vala"
					_g_object_unref0 (session);
#line 871 "session-list.c"
				}
			}
		}
	}
#line 58 "../src/session-list.vala"
	_tmp43_ = self->priv->box;
#line 58 "../src/session-list.vala"
	g_signal_connect_object ((GObject*) _tmp43_, "notify::selected-key", (GCallback) _session_prompt_selected_cb_g_object_notify, self, 0);
#line 59 "../src/session-list.vala"
	_tmp44_ = self->priv->box;
#line 59 "../src/session-list.vala"
	gtk_widget_show ((GtkWidget*) _tmp44_);
#line 61 "../src/session-list.vala"
	_tmp45_ = self->priv->box;
#line 61 "../src/session-list.vala"
	prompt_box_attach_item ((PromptBox*) self, (GtkWidget*) _tmp45_, TRUE);
#line 32 "../src/session-list.vala"
	return obj;
#line 890 "session-list.c"
}

static void
session_prompt_class_init (SessionPromptClass * klass,
                           gpointer klass_data)
{
#line 20 "../src/session-list.vala"
	session_prompt_parent_class = g_type_class_peek_parent (klass);
#line 20 "../src/session-list.vala"
	g_type_class_adjust_private_offset (klass, &SessionPrompt_private_offset);
#line 20 "../src/session-list.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_session_prompt_get_property;
#line 20 "../src/session-list.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_session_prompt_set_property;
#line 20 "../src/session-list.vala"
	G_OBJECT_CLASS (klass)->constructor = session_prompt_constructor;
#line 20 "../src/session-list.vala"
	G_OBJECT_CLASS (klass)->finalize = session_prompt_finalize;
#line 20 "../src/session-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SESSION_PROMPT_SESSION_PROPERTY, session_prompt_properties[SESSION_PROMPT_SESSION_PROPERTY] = g_param_spec_string ("session", "session", "session", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 20 "../src/session-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SESSION_PROMPT_DEFAULT_SESSION_PROPERTY, session_prompt_properties[SESSION_PROMPT_DEFAULT_SESSION_PROPERTY] = g_param_spec_string ("default-session", "default-session", "default-session", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 913 "session-list.c"
}

static void
session_prompt_instance_init (SessionPrompt * self,
                              gpointer klass)
{
#line 20 "../src/session-list.vala"
	self->priv = session_prompt_get_instance_private (self);
#line 922 "session-list.c"
}

static void
session_prompt_finalize (GObject * obj)
{
	SessionPrompt * self;
#line 20 "../src/session-list.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SESSION_PROMPT, SessionPrompt);
#line 22 "../src/session-list.vala"
	_g_free0 (self->priv->_session);
#line 23 "../src/session-list.vala"
	_g_free0 (self->priv->_default_session);
#line 30 "../src/session-list.vala"
	_g_object_unref0 (self->priv->box);
#line 20 "../src/session-list.vala"
	G_OBJECT_CLASS (session_prompt_parent_class)->finalize (obj);
#line 939 "session-list.c"
}

static GType
session_prompt_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SessionPromptClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) session_prompt_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SessionPrompt), 0, (GInstanceInitFunc) session_prompt_instance_init, NULL };
	GType session_prompt_type_id;
	session_prompt_type_id = g_type_register_static (TYPE_PROMPT_BOX, "SessionPrompt", &g_define_type_info, 0);
	SessionPrompt_private_offset = g_type_add_instance_private (session_prompt_type_id, sizeof (SessionPromptPrivate));
	return session_prompt_type_id;
}

GType
session_prompt_get_type (void)
{
	static volatile gsize session_prompt_type_id__once = 0;
	if (g_once_init_enter (&session_prompt_type_id__once)) {
		GType session_prompt_type_id;
		session_prompt_type_id = session_prompt_get_type_once ();
		g_once_init_leave (&session_prompt_type_id__once, session_prompt_type_id);
	}
	return session_prompt_type_id__once;
}

static void
_vala_session_prompt_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	SessionPrompt * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SESSION_PROMPT, SessionPrompt);
#line 20 "../src/session-list.vala"
	switch (property_id) {
#line 20 "../src/session-list.vala"
		case SESSION_PROMPT_SESSION_PROPERTY:
#line 20 "../src/session-list.vala"
		g_value_set_string (value, session_prompt_get_session (self));
#line 20 "../src/session-list.vala"
		break;
#line 20 "../src/session-list.vala"
		case SESSION_PROMPT_DEFAULT_SESSION_PROPERTY:
#line 20 "../src/session-list.vala"
		g_value_set_string (value, session_prompt_get_default_session (self));
#line 20 "../src/session-list.vala"
		break;
#line 986 "session-list.c"
		default:
#line 20 "../src/session-list.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "../src/session-list.vala"
		break;
#line 992 "session-list.c"
	}
}

static void
_vala_session_prompt_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	SessionPrompt * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SESSION_PROMPT, SessionPrompt);
#line 20 "../src/session-list.vala"
	switch (property_id) {
#line 20 "../src/session-list.vala"
		case SESSION_PROMPT_SESSION_PROPERTY:
#line 20 "../src/session-list.vala"
		session_prompt_set_session (self, g_value_get_string (value));
#line 20 "../src/session-list.vala"
		break;
#line 20 "../src/session-list.vala"
		case SESSION_PROMPT_DEFAULT_SESSION_PROPERTY:
#line 20 "../src/session-list.vala"
		session_prompt_set_default_session (self, g_value_get_string (value));
#line 20 "../src/session-list.vala"
		break;
#line 1018 "session-list.c"
		default:
#line 20 "../src/session-list.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "../src/session-list.vala"
		break;
#line 1024 "session-list.c"
	}
}

static inline gpointer
session_list_get_instance_private (SessionList* self)
{
	return G_STRUCT_MEMBER_P (self, SessionList_private_offset);
}

SessionList*
session_list_construct (GType object_type,
                        Background* bg,
                        MenuBar* mb,
                        const gchar* session,
                        const gchar* default_session)
{
	SessionList * self = NULL;
#line 80 "../src/session-list.vala"
	g_return_val_if_fail (bg != NULL, NULL);
#line 80 "../src/session-list.vala"
	g_return_val_if_fail (mb != NULL, NULL);
#line 82 "../src/session-list.vala"
	self = (SessionList*) g_object_new (object_type, "background", bg, "menubar", mb, "session", session, "default-session", default_session, NULL);
#line 80 "../src/session-list.vala"
	return self;
#line 1050 "session-list.c"
}

SessionList*
session_list_new (Background* bg,
                  MenuBar* mb,
                  const gchar* session,
                  const gchar* default_session)
{
#line 80 "../src/session-list.vala"
	return session_list_construct (TYPE_SESSION_LIST, bg, mb, session, default_session);
#line 1061 "session-list.c"
}

static void
__lambda42_ (SessionList* self,
             gchar** responses,
             gint responses_length1)
{
	const gchar* _tmp0_;
#line 93 "../src/session-list.vala"
	_tmp0_ = responses[0];
#line 93 "../src/session-list.vala"
	g_signal_emit (self, session_list_signals[SESSION_LIST_SESSION_CLICKED_SIGNAL], 0, _tmp0_);
#line 1074 "session-list.c"
}

static void
___lambda42__prompt_box_respond (PromptBox* _sender,
                                 gchar** response,
                                 gint response_length1,
                                 gpointer self)
{
#line 93 "../src/session-list.vala"
	__lambda42_ ((SessionList*) self, response, response_length1);
#line 1085 "session-list.c"
}

static SessionPrompt*
session_list_add_session_prompt (SessionList* self,
                                 const gchar* id)
{
	SessionPrompt* e = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	SessionPrompt* _tmp2_;
	SessionPrompt* result;
#line 90 "../src/session-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 90 "../src/session-list.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 92 "../src/session-list.vala"
	_tmp0_ = self->priv->_session;
#line 92 "../src/session-list.vala"
	_tmp1_ = self->priv->_default_session;
#line 92 "../src/session-list.vala"
	_tmp2_ = session_prompt_new (id, _tmp0_, _tmp1_);
#line 92 "../src/session-list.vala"
	g_object_ref_sink (_tmp2_);
#line 92 "../src/session-list.vala"
	e = _tmp2_;
#line 93 "../src/session-list.vala"
	g_signal_connect_object ((PromptBox*) e, "respond", (GCallback) ___lambda42__prompt_box_respond, self, 0);
#line 94 "../src/session-list.vala"
	greeter_list_add_entry ((GreeterList*) self, (PromptBox*) e);
#line 95 "../src/session-list.vala"
	result = e;
#line 95 "../src/session-list.vala"
	return result;
#line 1119 "session-list.c"
}

static void
session_list_real_add_manual_entry (GreeterList* base)
{
	SessionList * self;
#line 98 "../src/session-list.vala"
	self = (SessionList*) base;
#line 1128 "session-list.c"
}

static void
session_list_real_show_authenticated (GreeterList* base,
                                      gboolean successful)
{
	SessionList * self;
#line 99 "../src/session-list.vala"
	self = (SessionList*) base;
#line 1138 "session-list.c"
}

static void
_g_free0_ (gpointer var)
{
#line 122 "../src/session-list.vala"
	var = (g_free (var), NULL);
#line 1146 "session-list.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 122 "../src/session-list.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1154 "session-list.c"
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
#line 127 "../src/session-list.vala"
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
#line 1162 "session-list.c"
}

GdkPixbuf*
session_list_get_badge (const gchar* session)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	GList* extensions = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GList* _tmp3_;
	GHashTable* _tmp12_;
	GdkPixbuf* pixbuf = NULL;
	GHashTable* _tmp16_;
	const gchar* _tmp17_;
	gconstpointer _tmp18_;
	GdkPixbuf* _tmp19_;
	GdkPixbuf* _tmp20_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
#line 102 "../src/session-list.vala"
	g_return_val_if_fail (session != NULL, NULL);
#line 104 "../src/session-list.vala"
	_tmp0_ = g_strdup ("unknown.png");
#line 104 "../src/session-list.vala"
	name = _tmp0_;
#line 106 "../src/session-list.vala"
	extensions = NULL;
#line 107 "../src/session-list.vala"
	_tmp1_ = g_strdup ("svg");
#line 107 "../src/session-list.vala"
	extensions = g_list_append (extensions, _tmp1_);
#line 108 "../src/session-list.vala"
	_tmp2_ = g_strdup ("png");
#line 108 "../src/session-list.vala"
	extensions = g_list_append (extensions, _tmp2_);
#line 110 "../src/session-list.vala"
	_tmp3_ = extensions;
#line 1201 "session-list.c"
	{
		GList* extension_collection = NULL;
		GList* extension_it = NULL;
#line 110 "../src/session-list.vala"
		extension_collection = _tmp3_;
#line 110 "../src/session-list.vala"
		for (extension_it = extension_collection; extension_it != NULL; extension_it = extension_it->next) {
#line 1209 "session-list.c"
			gchar* _tmp4_;
			gchar* extension = NULL;
#line 110 "../src/session-list.vala"
			_tmp4_ = g_strdup ((const gchar*) extension_it->data);
#line 110 "../src/session-list.vala"
			extension = _tmp4_;
#line 1216 "session-list.c"
			{
				gchar* filename = NULL;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* path = NULL;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				const gchar* _tmp9_;
#line 112 "../src/session-list.vala"
				_tmp5_ = extension;
#line 112 "../src/session-list.vala"
				_tmp6_ = g_strdup_printf ("%s.%s", session, _tmp5_);
#line 112 "../src/session-list.vala"
				filename = _tmp6_;
#line 113 "../src/session-list.vala"
				_tmp7_ = filename;
#line 113 "../src/session-list.vala"
				_tmp8_ = g_build_filename ("/usr/share/slick-greeter/badges/", _tmp7_, NULL, NULL);
#line 113 "../src/session-list.vala"
				path = _tmp8_;
#line 114 "../src/session-list.vala"
				_tmp9_ = path;
#line 114 "../src/session-list.vala"
				if (g_file_test (_tmp9_, G_FILE_TEST_EXISTS)) {
#line 1241 "session-list.c"
					const gchar* _tmp10_;
					gchar* _tmp11_;
#line 116 "../src/session-list.vala"
					_tmp10_ = filename;
#line 116 "../src/session-list.vala"
					_tmp11_ = g_strdup (_tmp10_);
#line 116 "../src/session-list.vala"
					_g_free0 (name);
#line 116 "../src/session-list.vala"
					name = _tmp11_;
#line 117 "../src/session-list.vala"
					_g_free0 (path);
#line 117 "../src/session-list.vala"
					_g_free0 (filename);
#line 117 "../src/session-list.vala"
					_g_free0 (extension);
#line 117 "../src/session-list.vala"
					break;
#line 1260 "session-list.c"
				}
#line 110 "../src/session-list.vala"
				_g_free0 (path);
#line 110 "../src/session-list.vala"
				_g_free0 (filename);
#line 110 "../src/session-list.vala"
				_g_free0 (extension);
#line 1268 "session-list.c"
			}
		}
	}
#line 121 "../src/session-list.vala"
	_tmp12_ = session_list_badges;
#line 121 "../src/session-list.vala"
	if (_tmp12_ == NULL) {
#line 1276 "session-list.c"
		GHashFunc _tmp13_;
		GEqualFunc _tmp14_;
		GHashTable* _tmp15_;
#line 122 "../src/session-list.vala"
		_tmp13_ = g_str_hash;
#line 122 "../src/session-list.vala"
		_tmp14_ = g_str_equal;
#line 122 "../src/session-list.vala"
		_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, _g_free0_, _g_object_unref0_);
#line 122 "../src/session-list.vala"
		_g_hash_table_unref0 (session_list_badges);
#line 122 "../src/session-list.vala"
		session_list_badges = _tmp15_;
#line 1290 "session-list.c"
	}
#line 124 "../src/session-list.vala"
	_tmp16_ = session_list_badges;
#line 124 "../src/session-list.vala"
	_tmp17_ = name;
#line 124 "../src/session-list.vala"
	_tmp18_ = g_hash_table_lookup (_tmp16_, _tmp17_);
#line 124 "../src/session-list.vala"
	_tmp19_ = _g_object_ref0 ((GdkPixbuf*) _tmp18_);
#line 124 "../src/session-list.vala"
	pixbuf = _tmp19_;
#line 125 "../src/session-list.vala"
	_tmp20_ = pixbuf;
#line 125 "../src/session-list.vala"
	if (_tmp20_ == NULL) {
#line 1306 "session-list.c"
		{
			GdkPixbuf* _tmp21_ = NULL;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			GdkPixbuf* _tmp25_;
			GdkPixbuf* _tmp26_;
			GdkPixbuf* _tmp27_;
			GHashTable* _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			GdkPixbuf* _tmp31_;
			GdkPixbuf* _tmp32_;
#line 129 "../src/session-list.vala"
			_tmp22_ = name;
#line 129 "../src/session-list.vala"
			_tmp23_ = g_build_filename ("/usr/share/slick-greeter/badges/", _tmp22_, NULL, NULL);
#line 129 "../src/session-list.vala"
			_tmp24_ = _tmp23_;
#line 129 "../src/session-list.vala"
			_tmp25_ = gdk_pixbuf_new_from_file_at_size (_tmp24_, SESSION_LIST_BADGE_SIZE * _scale_factor, SESSION_LIST_BADGE_SIZE * _scale_factor, &_inner_error0_);
#line 129 "../src/session-list.vala"
			_tmp26_ = _tmp25_;
#line 129 "../src/session-list.vala"
			_g_free0 (_tmp24_);
#line 129 "../src/session-list.vala"
			_tmp21_ = _tmp26_;
#line 129 "../src/session-list.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1336 "session-list.c"
				goto __catch0_g_error;
			}
#line 129 "../src/session-list.vala"
			_tmp27_ = _tmp21_;
#line 129 "../src/session-list.vala"
			_tmp21_ = NULL;
#line 129 "../src/session-list.vala"
			_g_object_unref0 (pixbuf);
#line 129 "../src/session-list.vala"
			pixbuf = _tmp27_;
#line 131 "../src/session-list.vala"
			_tmp28_ = session_list_badges;
#line 131 "../src/session-list.vala"
			_tmp29_ = name;
#line 131 "../src/session-list.vala"
			_tmp30_ = g_strdup (_tmp29_);
#line 131 "../src/session-list.vala"
			_tmp31_ = pixbuf;
#line 131 "../src/session-list.vala"
			_tmp32_ = _g_object_ref0 (_tmp31_);
#line 131 "../src/session-list.vala"
			g_hash_table_insert (_tmp28_, _tmp30_, _tmp32_);
#line 127 "../src/session-list.vala"
			_g_object_unref0 (_tmp21_);
#line 1361 "session-list.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp33_;
			GError* _tmp34_;
			const gchar* _tmp35_;
#line 127 "../src/session-list.vala"
			e = _inner_error0_;
#line 127 "../src/session-list.vala"
			_inner_error0_ = NULL;
#line 135 "../src/session-list.vala"
			_tmp33_ = name;
#line 135 "../src/session-list.vala"
			_tmp34_ = e;
#line 135 "../src/session-list.vala"
			_tmp35_ = _tmp34_->message;
#line 135 "../src/session-list.vala"
			g_debug ("session-list.vala:135: Error loading badge %s: %s", _tmp33_, _tmp35_);
#line 127 "../src/session-list.vala"
			_g_error_free0 (e);
#line 1384 "session-list.c"
		}
		__finally0:
#line 127 "../src/session-list.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 127 "../src/session-list.vala"
			_g_object_unref0 (pixbuf);
#line 127 "../src/session-list.vala"
			(extensions == NULL) ? NULL : (extensions = (_g_list_free__g_free0_ (extensions), NULL));
#line 127 "../src/session-list.vala"
			_g_free0 (name);
#line 127 "../src/session-list.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 127 "../src/session-list.vala"
			g_clear_error (&_inner_error0_);
#line 127 "../src/session-list.vala"
			return NULL;
#line 1401 "session-list.c"
		}
	}
#line 139 "../src/session-list.vala"
	result = pixbuf;
#line 139 "../src/session-list.vala"
	(extensions == NULL) ? NULL : (extensions = (_g_list_free__g_free0_ (extensions), NULL));
#line 139 "../src/session-list.vala"
	_g_free0 (name);
#line 139 "../src/session-list.vala"
	return result;
#line 1412 "session-list.c"
}

const gchar*
session_list_get_session (SessionList* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 73 "../src/session-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 73 "../src/session-list.vala"
	_tmp0_ = self->priv->_session;
#line 73 "../src/session-list.vala"
	result = _tmp0_;
#line 73 "../src/session-list.vala"
	return result;
#line 1428 "session-list.c"
}

static void
session_list_set_session (SessionList* self,
                          const gchar* value)
{
	gchar* old_value;
#line 73 "../src/session-list.vala"
	g_return_if_fail (self != NULL);
#line 73 "../src/session-list.vala"
	old_value = session_list_get_session (self);
#line 73 "../src/session-list.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1442 "session-list.c"
		gchar* _tmp0_;
#line 73 "../src/session-list.vala"
		_tmp0_ = g_strdup (value);
#line 73 "../src/session-list.vala"
		_g_free0 (self->priv->_session);
#line 73 "../src/session-list.vala"
		self->priv->_session = _tmp0_;
#line 73 "../src/session-list.vala"
		g_object_notify_by_pspec ((GObject *) self, session_list_properties[SESSION_LIST_SESSION_PROPERTY]);
#line 1452 "session-list.c"
	}
}

const gchar*
session_list_get_default_session (SessionList* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 74 "../src/session-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 74 "../src/session-list.vala"
	_tmp0_ = self->priv->_default_session;
#line 74 "../src/session-list.vala"
	result = _tmp0_;
#line 74 "../src/session-list.vala"
	return result;
#line 1469 "session-list.c"
}

static void
session_list_set_default_session (SessionList* self,
                                  const gchar* value)
{
	gchar* old_value;
#line 74 "../src/session-list.vala"
	g_return_if_fail (self != NULL);
#line 74 "../src/session-list.vala"
	old_value = session_list_get_default_session (self);
#line 74 "../src/session-list.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1483 "session-list.c"
		gchar* _tmp0_;
#line 74 "../src/session-list.vala"
		_tmp0_ = g_strdup (value);
#line 74 "../src/session-list.vala"
		_g_free0 (self->priv->_default_session);
#line 74 "../src/session-list.vala"
		self->priv->_default_session = _tmp0_;
#line 74 "../src/session-list.vala"
		g_object_notify_by_pspec ((GObject *) self, session_list_properties[SESSION_LIST_DEFAULT_SESSION_PROPERTY]);
#line 1493 "session-list.c"
	}
}

static GObject *
session_list_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SessionList * self;
	SessionPrompt* _tmp0_;
#line 85 "../src/session-list.vala"
	parent_class = G_OBJECT_CLASS (session_list_parent_class);
#line 85 "../src/session-list.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 85 "../src/session-list.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SESSION_LIST, SessionList);
#line 87 "../src/session-list.vala"
	_tmp0_ = session_list_add_session_prompt (self, "session");
#line 87 "../src/session-list.vala"
	_g_object_unref0 (self->priv->prompt);
#line 87 "../src/session-list.vala"
	self->priv->prompt = _tmp0_;
#line 85 "../src/session-list.vala"
	return obj;
#line 1520 "session-list.c"
}

static void
session_list_class_init (SessionListClass * klass,
                         gpointer klass_data)
{
#line 70 "../src/session-list.vala"
	session_list_parent_class = g_type_class_peek_parent (klass);
#line 70 "../src/session-list.vala"
	g_type_class_adjust_private_offset (klass, &SessionList_private_offset);
#line 70 "../src/session-list.vala"
	((GreeterListClass *) klass)->add_manual_entry = (void (*) (GreeterList*)) session_list_real_add_manual_entry;
#line 70 "../src/session-list.vala"
	((GreeterListClass *) klass)->show_authenticated = (void (*) (GreeterList*, gboolean)) session_list_real_show_authenticated;
#line 70 "../src/session-list.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_session_list_get_property;
#line 70 "../src/session-list.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_session_list_set_property;
#line 70 "../src/session-list.vala"
	G_OBJECT_CLASS (klass)->constructor = session_list_constructor;
#line 70 "../src/session-list.vala"
	G_OBJECT_CLASS (klass)->finalize = session_list_finalize;
#line 70 "../src/session-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SESSION_LIST_SESSION_PROPERTY, session_list_properties[SESSION_LIST_SESSION_PROPERTY] = g_param_spec_string ("session", "session", "session", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 70 "../src/session-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SESSION_LIST_DEFAULT_SESSION_PROPERTY, session_list_properties[SESSION_LIST_DEFAULT_SESSION_PROPERTY] = g_param_spec_string ("default-session", "default-session", "default-session", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 70 "../src/session-list.vala"
	session_list_signals[SESSION_LIST_SESSION_CLICKED_SIGNAL] = g_signal_new ("session-clicked", TYPE_SESSION_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 1549 "session-list.c"
}

static void
session_list_instance_init (SessionList * self,
                            gpointer klass)
{
#line 70 "../src/session-list.vala"
	self->priv = session_list_get_instance_private (self);
#line 1558 "session-list.c"
}

static void
session_list_finalize (GObject * obj)
{
	SessionList * self;
#line 70 "../src/session-list.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SESSION_LIST, SessionList);
#line 73 "../src/session-list.vala"
	_g_free0 (self->priv->_session);
#line 74 "../src/session-list.vala"
	_g_free0 (self->priv->_default_session);
#line 76 "../src/session-list.vala"
	_g_object_unref0 (self->priv->prompt);
#line 70 "../src/session-list.vala"
	G_OBJECT_CLASS (session_list_parent_class)->finalize (obj);
#line 1575 "session-list.c"
}

static GType
session_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SessionListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) session_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SessionList), 0, (GInstanceInitFunc) session_list_instance_init, NULL };
	GType session_list_type_id;
	session_list_type_id = g_type_register_static (TYPE_GREETER_LIST, "SessionList", &g_define_type_info, 0);
	SessionList_private_offset = g_type_add_instance_private (session_list_type_id, sizeof (SessionListPrivate));
	return session_list_type_id;
}

GType
session_list_get_type (void)
{
	static volatile gsize session_list_type_id__once = 0;
	if (g_once_init_enter (&session_list_type_id__once)) {
		GType session_list_type_id;
		session_list_type_id = session_list_get_type_once ();
		g_once_init_leave (&session_list_type_id__once, session_list_type_id);
	}
	return session_list_type_id__once;
}

static void
_vala_session_list_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	SessionList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SESSION_LIST, SessionList);
#line 70 "../src/session-list.vala"
	switch (property_id) {
#line 70 "../src/session-list.vala"
		case SESSION_LIST_SESSION_PROPERTY:
#line 70 "../src/session-list.vala"
		g_value_set_string (value, session_list_get_session (self));
#line 70 "../src/session-list.vala"
		break;
#line 70 "../src/session-list.vala"
		case SESSION_LIST_DEFAULT_SESSION_PROPERTY:
#line 70 "../src/session-list.vala"
		g_value_set_string (value, session_list_get_default_session (self));
#line 70 "../src/session-list.vala"
		break;
#line 1622 "session-list.c"
		default:
#line 70 "../src/session-list.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 70 "../src/session-list.vala"
		break;
#line 1628 "session-list.c"
	}
}

static void
_vala_session_list_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	SessionList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SESSION_LIST, SessionList);
#line 70 "../src/session-list.vala"
	switch (property_id) {
#line 70 "../src/session-list.vala"
		case SESSION_LIST_SESSION_PROPERTY:
#line 70 "../src/session-list.vala"
		session_list_set_session (self, g_value_get_string (value));
#line 70 "../src/session-list.vala"
		break;
#line 70 "../src/session-list.vala"
		case SESSION_LIST_DEFAULT_SESSION_PROPERTY:
#line 70 "../src/session-list.vala"
		session_list_set_default_session (self, g_value_get_string (value));
#line 70 "../src/session-list.vala"
		break;
#line 1654 "session-list.c"
		default:
#line 70 "../src/session-list.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 70 "../src/session-list.vala"
		break;
#line 1660 "session-list.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

