/**************************************************************************
** This file is part of LiteIDE
**
** Copyright (c) 2011-2019 LiteIDE. All rights reserved.
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** In addition, as a special exception,  that plugins developed for LiteIDE,
** are allowed to remain closed sourced and can be distributed under any license .
** These rights are included in the file LGPL_EXCEPTION.txt in this package.
**
**************************************************************************/
// Module: replacedocument.h
// Creator: visualfc <visualfc@gmail.com>

#ifndef REPLACEDOCUMENT_H
#define REPLACEDOCUMENT_H

#include <liteapi/liteapi.h>
#include "qtc_searchresult/searchresultwidget.h"

class ReplaceDocument : public QObject
{
    Q_OBJECT
public:
    explicit ReplaceDocument(LiteApi::IApplication *app, QObject *parent = 0);
    ~ReplaceDocument();
    QList<Find::SearchResultItem> replace(const QString &fileName, const QString &text, const QList<Find::SearchResultItem> &items);
protected:
    QTextDocument* fileDocument(const QString &fileName, QTextCursor &cursor, bool &crlf);
    LiteApi::IApplication *m_liteApp;
    QTextDocument *m_document;
    QTextCursor    cursor;
};

#endif // REPLACEDOCUMENT_H
