/* Clipboard.c generated by valac 0.56.18, the Vala compiler
 * generated from Clipboard.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <handy.h>
#include <gtksourceview/gtksource.h>
#include <gobject/gvaluecollector.h>

#define MINDER_CLIPBOARD_NODES_TARGET_NAME "x-application/minder-nodes"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MINDER_CLIPBOARD (minder_clipboard_get_type ())
#define MINDER_CLIPBOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINDER_CLIPBOARD, MinderClipboard))
#define MINDER_CLIPBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINDER_CLIPBOARD, MinderClipboardClass))
#define IS_MINDER_CLIPBOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINDER_CLIPBOARD))
#define IS_MINDER_CLIPBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINDER_CLIPBOARD))
#define MINDER_CLIPBOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINDER_CLIPBOARD, MinderClipboardClass))

typedef struct _MinderClipboard MinderClipboard;
typedef struct _MinderClipboardClass MinderClipboardClass;
typedef struct _MinderClipboardPrivate MinderClipboardPrivate;
typedef enum  {
	MINDER_CLIPBOARD_TARGET_STRING,
	MINDER_CLIPBOARD_TARGET_IMAGE,
	MINDER_CLIPBOARD_TARGET_NODES
} MinderClipboardTarget;

#define MINDER_CLIPBOARD_TYPE_TARGET (minder_clipboard_target_get_type ())

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_CONNECTIONS (connections_get_type ())
#define CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTIONS, Connections))
#define CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTIONS, ConnectionsClass))
#define IS_CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTIONS))
#define IS_CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTIONS))
#define CONNECTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTIONS, ConnectionsClass))

typedef struct _Connections Connections;
typedef struct _ConnectionsClass ConnectionsClass;

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;

#define TYPE_EXPORT_TEXT (export_text_get_type ())
#define EXPORT_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_TEXT, ExportText))
#define EXPORT_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_TEXT, ExportTextClass))
#define IS_EXPORT_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_TEXT))
#define IS_EXPORT_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_TEXT))
#define EXPORT_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_TEXT, ExportTextClass))

typedef struct _ExportText ExportText;
typedef struct _ExportTextClass ExportTextClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_EXPORTS (exports_get_type ())
#define EXPORTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTS, Exports))
#define EXPORTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTS, ExportsClass))
#define IS_EXPORTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTS))
#define IS_EXPORTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTS))
#define EXPORTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTS, ExportsClass))

typedef struct _Exports Exports;
typedef struct _ExportsClass ExportsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _export_unref0(var) ((var == NULL) ? NULL : (var = (export_unref (var), NULL)))

#define TYPE_NODE_IMAGE (node_image_get_type ())
#define NODE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_IMAGE, NodeImage))
#define NODE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_IMAGE, NodeImageClass))
#define IS_NODE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_IMAGE))
#define IS_NODE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_IMAGE))
#define NODE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_IMAGE, NodeImageClass))

typedef struct _NodeImage NodeImage;
typedef struct _NodeImageClass NodeImageClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _connections_unref0(var) ((var == NULL) ? NULL : (var = (connections_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;

#define TYPE_NOTE_VIEW (note_view_get_type ())
#define NOTE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTE_VIEW, NoteView))
#define NOTE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTE_VIEW, NoteViewClass))
#define IS_NOTE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTE_VIEW))
#define IS_NOTE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTE_VIEW))
#define NOTE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTE_VIEW, NoteViewClass))

typedef struct _NoteView NoteView;
typedef struct _NoteViewClass NoteViewClass;
typedef struct _Block5Data Block5Data;

#define TYPE_NODE_LINK (node_link_get_type ())
#define NODE_LINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_LINK, NodeLink))
#define NODE_LINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_LINK, NodeLinkClass))
#define IS_NODE_LINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_LINK))
#define IS_NODE_LINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_LINK))
#define NODE_LINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_LINK, NodeLinkClass))

typedef struct _NodeLink NodeLink;
typedef struct _NodeLinkClass NodeLinkClass;
#define _node_link_unref0(var) ((var == NULL) ? NULL : (var = (node_link_unref (var), NULL)))
typedef struct _ParamSpecMinderClipboard ParamSpecMinderClipboard;

struct _MinderClipboard {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MinderClipboardPrivate * priv;
};

struct _MinderClipboardClass {
	GTypeClass parent_class;
	void (*finalize) (MinderClipboard *self);
};

struct _Block3Data {
	int _ref_count_;
	DrawArea* da;
	gboolean shift;
};

struct _Block4Data {
	int _ref_count_;
	DrawArea* da;
};

struct _Block5Data {
	int _ref_count_;
	NoteView* note;
};

struct _ParamSpecMinderClipboard {
	GParamSpec parent_instance;
};

static gpointer minder_clipboard_parent_class = NULL;
static GdkAtom minder_clipboard_NODES_ATOM;
static GdkAtom minder_clipboard_NODES_ATOM = 0U;
static DrawArea* minder_clipboard_da;
static DrawArea* minder_clipboard_da = NULL;
static GArray* minder_clipboard_nodes;
static GArray* minder_clipboard_nodes = NULL;
static Connections* minder_clipboard_conns;
static Connections* minder_clipboard_conns = NULL;
static gchar* minder_clipboard_text;
static gchar* minder_clipboard_text = NULL;
static GdkPixbuf* minder_clipboard_image;
static GdkPixbuf* minder_clipboard_image = NULL;
static gboolean minder_clipboard_set_internally;
static gboolean minder_clipboard_set_internally = FALSE;

VALA_EXTERN gpointer minder_clipboard_ref (gpointer instance);
VALA_EXTERN void minder_clipboard_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_minder_clipboard (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_minder_clipboard (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_minder_clipboard (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_minder_clipboard (const GValue* value);
VALA_EXTERN GType minder_clipboard_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MinderClipboard, minder_clipboard_unref)
static GType minder_clipboard_target_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN gpointer connections_ref (gpointer instance);
VALA_EXTERN void connections_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_connections (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_connections (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_connections (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_connections (const GValue* value);
VALA_EXTERN GType connections_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Connections, connections_unref)
VALA_EXTERN void minder_clipboard_set_with_data (GtkClipboard* clipboard,
                                     GtkSelectionData* selection_data,
                                     guint info,
                                     void* user_data_or_owner);
VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType export_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportText, export_unref)
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN MainWindow* draw_area_get_win (DrawArea* self);
VALA_EXTERN gpointer exports_ref (gpointer instance);
VALA_EXTERN void exports_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_exports (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_exports (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_exports (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_exports (const GValue* value);
VALA_EXTERN GType exports_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Exports, exports_unref)
VALA_EXTERN Exports* main_window_get_exports (MainWindow* self);
VALA_EXTERN Export* exports_get_by_name (Exports* self,
                             const gchar* name);
VALA_EXTERN gchar* export_text_export_node (ExportText* self,
                                DrawArea* da,
                                Node* node,
                                const gchar* prefix);
VALA_EXTERN gpointer node_image_ref (gpointer instance);
VALA_EXTERN void node_image_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_image (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_node_image (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_node_image (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_node_image (const GValue* value);
VALA_EXTERN GType node_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeImage, node_image_unref)
VALA_EXTERN NodeImage* node_get_image (Node* self);
VALA_EXTERN GdkPixbuf* node_image_get_pixbuf (NodeImage* self);
VALA_EXTERN gchar* draw_area_serialize_for_copy (DrawArea* self,
                                     GArray* nodes,
                                     Connections* conns);
VALA_EXTERN void minder_clipboard_clear_data (GtkClipboard* clipboard,
                                  void* user_data_or_owner);
VALA_EXTERN void minder_clipboard_copy_text (const gchar* txt);
static void _minder_clipboard_set_with_data_gtk_clipboard_get_func (GtkClipboard* clipboard,
                                                             GtkSelectionData* selection_data,
                                                             guint info,
                                                             void* user_data_or_owner);
static void _minder_clipboard_clear_data_gtk_clipboard_clear_func (GtkClipboard* clipboard,
                                                            void* user_data_or_owner);
VALA_EXTERN void minder_clipboard_copy_image (GdkPixbuf* img);
VALA_EXTERN void minder_clipboard_copy_nodes (DrawArea* d);
VALA_EXTERN void draw_area_get_nodes_for_clipboard (DrawArea* self,
                                        GArray** nodes,
                                        Connections** conns);
VALA_EXTERN gboolean minder_clipboard_node_pasteable (void);
VALA_EXTERN void minder_clipboard_paste (DrawArea* da,
                             gboolean shift);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN gboolean draw_area_is_node_editable (DrawArea* self);
VALA_EXTERN gboolean draw_area_is_connection_editable (DrawArea* self);
static GdkAtom* _gdk_atom_dup (GdkAtom* self);
static void ___lambda49_ (Block3Data* _data3_,
                   GtkClipboard* c,
                   GtkSelectionData* raw_data);
VALA_EXTERN void draw_area_paste_nodes (DrawArea* self,
                            const gchar* text,
                            gboolean shift);
static void ____lambda49__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                                GtkSelectionData* selection_data,
                                                gpointer self);
static void ____lambda50_ (Block3Data* _data3_,
                    GtkClipboard* c,
                    GtkSelectionData* raw_data);
VALA_EXTERN void draw_area_paste_image (DrawArea* self,
                            GdkPixbuf* image,
                            gboolean shift);
static void _____lambda50__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                                 GtkSelectionData* selection_data,
                                                 gpointer self);
static void _____lambda51_ (Block3Data* _data3_,
                     GtkClipboard* c,
                     GtkSelectionData* raw_data);
VALA_EXTERN void draw_area_paste_text (DrawArea* self,
                           const gchar* text,
                           gboolean shift);
static void ______lambda51__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                                  GtkSelectionData* selection_data,
                                                  gpointer self);
VALA_EXTERN void minder_clipboard_paste_node_link (DrawArea* da);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void _____lambda52_ (Block4Data* _data4_,
                     GtkClipboard* c,
                     GtkSelectionData* raw_data);
VALA_EXTERN void draw_area_paste_node_link (DrawArea* self,
                                const gchar* text);
static void ______lambda52__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                                  GtkSelectionData* selection_data,
                                                  gpointer self);
VALA_EXTERN GType note_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NoteView, g_object_unref)
VALA_EXTERN void minder_clipboard_paste_into_note (NoteView* note);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda53_ (Block5Data* _data5_,
                   GtkClipboard* c,
                   GtkSelectionData* raw_data);
VALA_EXTERN gpointer node_link_ref (gpointer instance);
VALA_EXTERN void node_link_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_link (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_node_link (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_node_link (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_node_link (const GValue* value);
VALA_EXTERN GType node_link_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeLink, node_link_unref)
VALA_EXTERN NodeLink* draw_area_deserialize_for_node_link (const gchar* str);
VALA_EXTERN void note_view_paste_node_link (NoteView* self,
                                NodeLink* link);
static void ____lambda53__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                                GtkSelectionData* selection_data,
                                                gpointer self);
static void ____lambda54_ (Block5Data* _data5_,
                    GtkClipboard* c,
                    GtkSelectionData* raw_data);
VALA_EXTERN void note_view_paste_text (NoteView* self,
                           const gchar* str);
static void _____lambda54__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                                 GtkSelectionData* selection_data,
                                                 gpointer self);
VALA_EXTERN MinderClipboard* minder_clipboard_new (void);
VALA_EXTERN MinderClipboard* minder_clipboard_construct (GType object_type);
static void minder_clipboard_finalize (MinderClipboard * obj);
static GType minder_clipboard_get_type_once (void);

static const GtkTargetEntry MINDER_CLIPBOARD_text_target_list[3] = {{"UTF8_STRING", (guint) 0, (guint) MINDER_CLIPBOARD_TARGET_STRING}, {"text/plain", (guint) 0, (guint) MINDER_CLIPBOARD_TARGET_STRING}, {"STRING", (guint) 0, (guint) MINDER_CLIPBOARD_TARGET_STRING}};
static const GtkTargetEntry MINDER_CLIPBOARD_image_target_list[1] = {{"image/png", (guint) 0, (guint) MINDER_CLIPBOARD_TARGET_IMAGE}};
static const GtkTargetEntry MINDER_CLIPBOARD_node_target_list[5] = {{"UTF8_STRING", (guint) 0, (guint) MINDER_CLIPBOARD_TARGET_STRING}, {"text/plain", (guint) 0, (guint) MINDER_CLIPBOARD_TARGET_STRING}, {"STRING", (guint) 0, (guint) MINDER_CLIPBOARD_TARGET_STRING}, {"image/png", (guint) 0, (guint) MINDER_CLIPBOARD_TARGET_IMAGE}, {MINDER_CLIPBOARD_NODES_TARGET_NAME, (guint) 0, (guint) MINDER_CLIPBOARD_TARGET_NODES}};

static GType
minder_clipboard_target_get_type_once (void)
{
	static const GEnumValue values[] = {{MINDER_CLIPBOARD_TARGET_STRING, "MINDER_CLIPBOARD_TARGET_STRING", "string"}, {MINDER_CLIPBOARD_TARGET_IMAGE, "MINDER_CLIPBOARD_TARGET_IMAGE", "image"}, {MINDER_CLIPBOARD_TARGET_NODES, "MINDER_CLIPBOARD_TARGET_NODES", "nodes"}, {0, NULL, NULL}};
	GType minder_clipboard_target_type_id;
	minder_clipboard_target_type_id = g_enum_register_static ("MinderClipboardTarget", values);
	return minder_clipboard_target_type_id;
}

static GType
minder_clipboard_target_get_type (void)
{
	static volatile gsize minder_clipboard_target_type_id__once = 0;
	if (g_once_init_enter (&minder_clipboard_target_type_id__once)) {
		GType minder_clipboard_target_type_id;
		minder_clipboard_target_type_id = minder_clipboard_target_get_type_once ();
		g_once_init_leave (&minder_clipboard_target_type_id__once, minder_clipboard_target_type_id);
	}
	return minder_clipboard_target_type_id__once;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
minder_clipboard_set_with_data (GtkClipboard* clipboard,
                                GtkSelectionData* selection_data,
                                guint info,
                                void* user_data_or_owner)
{
	g_return_if_fail (clipboard != NULL);
	g_return_if_fail (selection_data != NULL);
	switch (info) {
		case MINDER_CLIPBOARD_TARGET_STRING:
		{
			const gchar* _tmp0_;
			_tmp0_ = minder_clipboard_text;
			if (_tmp0_ != NULL) {
				const gchar* _tmp1_;
				_tmp1_ = minder_clipboard_text;
				gtk_selection_data_set_text (selection_data, _tmp1_, -1);
			} else {
				gboolean _tmp2_ = FALSE;
				GArray* _tmp3_;
				_tmp3_ = minder_clipboard_nodes;
				if (_tmp3_ != NULL) {
					GArray* _tmp4_;
					_tmp4_ = minder_clipboard_nodes;
					_tmp2_ = _tmp4_->len == ((guint) 1);
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					gchar* str = NULL;
					gchar* _tmp5_;
					ExportText* export = NULL;
					DrawArea* _tmp6_;
					MainWindow* _tmp7_;
					MainWindow* _tmp8_;
					Exports* _tmp9_;
					Exports* _tmp10_;
					Export* _tmp11_;
					const gchar* _tmp23_;
					_tmp5_ = g_strdup ("");
					str = _tmp5_;
					_tmp6_ = minder_clipboard_da;
					_tmp7_ = draw_area_get_win (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = main_window_get_exports (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = exports_get_by_name (_tmp10_, "text");
					export = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_EXPORT_TEXT, ExportText);
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp12_ = FALSE;
							_tmp12_ = TRUE;
							while (TRUE) {
								GArray* _tmp14_;
								const gchar* _tmp15_;
								ExportText* _tmp16_;
								DrawArea* _tmp17_;
								GArray* _tmp18_;
								Node* _tmp19_;
								gchar* _tmp20_;
								gchar* _tmp21_;
								gchar* _tmp22_;
								if (!_tmp12_) {
									gint _tmp13_;
									_tmp13_ = i;
									i = _tmp13_ + 1;
								}
								_tmp12_ = FALSE;
								_tmp14_ = minder_clipboard_nodes;
								if (!(((guint) i) < _tmp14_->len)) {
									break;
								}
								_tmp15_ = str;
								_tmp16_ = export;
								_tmp17_ = minder_clipboard_da;
								_tmp18_ = minder_clipboard_nodes;
								_tmp19_ = g_array_index (_tmp18_, Node*, (guint) i);
								_tmp20_ = export_text_export_node (_tmp16_, _tmp17_, _tmp19_, "");
								_tmp21_ = _tmp20_;
								_tmp22_ = g_strconcat (_tmp15_, _tmp21_, NULL);
								_g_free0 (str);
								str = _tmp22_;
								_g_free0 (_tmp21_);
							}
						}
					}
					_tmp23_ = str;
					gtk_selection_data_set_text (selection_data, _tmp23_, -1);
					_export_unref0 (export);
					_g_free0 (str);
				}
			}
			break;
		}
		case MINDER_CLIPBOARD_TARGET_IMAGE:
		{
			GdkPixbuf* _tmp24_;
			_tmp24_ = minder_clipboard_image;
			if (_tmp24_ != NULL) {
				GdkPixbuf* _tmp25_;
				_tmp25_ = minder_clipboard_image;
				gtk_selection_data_set_pixbuf (selection_data, _tmp25_);
			} else {
				gboolean _tmp26_ = FALSE;
				gboolean _tmp27_ = FALSE;
				GArray* _tmp28_;
				_tmp28_ = minder_clipboard_nodes;
				if (_tmp28_ != NULL) {
					GArray* _tmp29_;
					_tmp29_ = minder_clipboard_nodes;
					_tmp27_ = _tmp29_->len == ((guint) 1);
				} else {
					_tmp27_ = FALSE;
				}
				if (_tmp27_) {
					GArray* _tmp30_;
					Node* _tmp31_;
					NodeImage* _tmp32_;
					NodeImage* _tmp33_;
					_tmp30_ = minder_clipboard_nodes;
					_tmp31_ = g_array_index (_tmp30_, Node*, (guint) 0);
					_tmp32_ = node_get_image (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp26_ = _tmp33_ != NULL;
				} else {
					_tmp26_ = FALSE;
				}
				if (_tmp26_) {
					GArray* _tmp34_;
					Node* _tmp35_;
					NodeImage* _tmp36_;
					NodeImage* _tmp37_;
					GdkPixbuf* _tmp38_;
					GdkPixbuf* _tmp39_;
					GdkPixbuf* _tmp40_;
					GdkPixbuf* _tmp41_;
					_tmp34_ = minder_clipboard_nodes;
					_tmp35_ = g_array_index (_tmp34_, Node*, (guint) 0);
					_tmp36_ = node_get_image (_tmp35_);
					_tmp37_ = _tmp36_;
					_tmp38_ = node_image_get_pixbuf (_tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = gdk_pixbuf_copy (_tmp39_);
					_tmp41_ = _tmp40_;
					gtk_selection_data_set_pixbuf (selection_data, _tmp41_);
					_g_object_unref0 (_tmp41_);
					_g_object_unref0 (_tmp39_);
				}
			}
			break;
		}
		case MINDER_CLIPBOARD_TARGET_NODES:
		{
			gboolean _tmp42_ = FALSE;
			GArray* _tmp43_;
			_tmp43_ = minder_clipboard_nodes;
			if (_tmp43_ != NULL) {
				GArray* _tmp44_;
				_tmp44_ = minder_clipboard_nodes;
				_tmp42_ = _tmp44_->len > ((guint) 0);
			} else {
				_tmp42_ = FALSE;
			}
			if (_tmp42_) {
				gchar* text = NULL;
				DrawArea* _tmp45_;
				GArray* _tmp46_;
				Connections* _tmp47_;
				gchar* _tmp48_;
				const gchar* _tmp49_;
				guint8* _tmp50_;
				gint _tmp50__length1;
				gint _tmp51_ = 0;
				guint8* _tmp52_;
				gint _tmp52__length1;
				_tmp45_ = minder_clipboard_da;
				_tmp46_ = minder_clipboard_nodes;
				_tmp47_ = minder_clipboard_conns;
				_tmp48_ = draw_area_serialize_for_copy (_tmp45_, _tmp46_, _tmp47_);
				text = _tmp48_;
				_tmp49_ = text;
				_tmp50_ = string_get_data (_tmp49_, &_tmp51_);
				_tmp50__length1 = _tmp51_;
				_tmp52_ = _tmp50_;
				_tmp52__length1 = _tmp50__length1;
				gtk_selection_data_set (selection_data, minder_clipboard_NODES_ATOM, 0, _tmp52_, (gint) _tmp52__length1);
				_g_free0 (text);
			}
			break;
		}
		default:
		break;
	}
}

void
minder_clipboard_clear_data (GtkClipboard* clipboard,
                             void* user_data_or_owner)
{
	g_return_if_fail (clipboard != NULL);
	if (!minder_clipboard_set_internally) {
		_g_object_unref0 (minder_clipboard_da);
		minder_clipboard_da = NULL;
		_g_array_unref0 (minder_clipboard_nodes);
		minder_clipboard_nodes = NULL;
		_connections_unref0 (minder_clipboard_conns);
		minder_clipboard_conns = NULL;
		_g_free0 (minder_clipboard_text);
		minder_clipboard_text = NULL;
		_g_object_unref0 (minder_clipboard_image);
		minder_clipboard_image = NULL;
	}
	minder_clipboard_set_internally = FALSE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_minder_clipboard_set_with_data_gtk_clipboard_get_func (GtkClipboard* clipboard,
                                                        GtkSelectionData* selection_data,
                                                        guint info,
                                                        void* user_data_or_owner)
{
	minder_clipboard_set_with_data (clipboard, selection_data, info, user_data_or_owner);
}

static void
_minder_clipboard_clear_data_gtk_clipboard_clear_func (GtkClipboard* clipboard,
                                                       void* user_data_or_owner)
{
	minder_clipboard_clear_data (clipboard, user_data_or_owner);
}

void
minder_clipboard_copy_text (const gchar* txt)
{
	gchar* _tmp0_;
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp1_;
	GtkClipboard* _tmp2_;
	GtkClipboard* _tmp3_;
	g_return_if_fail (txt != NULL);
	_tmp0_ = g_strdup (txt);
	_g_free0 (minder_clipboard_text);
	minder_clipboard_text = _tmp0_;
	minder_clipboard_set_internally = TRUE;
	_tmp1_ = gdk_display_get_default ();
	_tmp2_ = gtk_clipboard_get_default (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	gtk_clipboard_set_with_data (clipboard, MINDER_CLIPBOARD_text_target_list, (guint) G_N_ELEMENTS (MINDER_CLIPBOARD_text_target_list), _minder_clipboard_set_with_data_gtk_clipboard_get_func, _minder_clipboard_clear_data_gtk_clipboard_clear_func, NULL);
	_g_object_unref0 (clipboard);
}

void
minder_clipboard_copy_image (GdkPixbuf* img)
{
	GdkPixbuf* _tmp0_;
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp1_;
	GtkClipboard* _tmp2_;
	GtkClipboard* _tmp3_;
	g_return_if_fail (img != NULL);
	_tmp0_ = _g_object_ref0 (img);
	_g_object_unref0 (minder_clipboard_image);
	minder_clipboard_image = _tmp0_;
	minder_clipboard_set_internally = TRUE;
	_tmp1_ = gdk_display_get_default ();
	_tmp2_ = gtk_clipboard_get_default (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	gtk_clipboard_set_with_data (clipboard, MINDER_CLIPBOARD_image_target_list, (guint) G_N_ELEMENTS (MINDER_CLIPBOARD_image_target_list), _minder_clipboard_set_with_data_gtk_clipboard_get_func, _minder_clipboard_clear_data_gtk_clipboard_clear_func, NULL);
	_g_object_unref0 (clipboard);
}

void
minder_clipboard_copy_nodes (DrawArea* d)
{
	DrawArea* _tmp0_;
	DrawArea* _tmp1_;
	GArray* _tmp2_ = NULL;
	Connections* _tmp3_ = NULL;
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp4_;
	GtkClipboard* _tmp5_;
	GtkClipboard* _tmp6_;
	g_return_if_fail (d != NULL);
	_tmp0_ = _g_object_ref0 (d);
	_g_object_unref0 (minder_clipboard_da);
	minder_clipboard_da = _tmp0_;
	_tmp1_ = minder_clipboard_da;
	draw_area_get_nodes_for_clipboard (_tmp1_, &_tmp2_, &_tmp3_);
	_g_array_unref0 (minder_clipboard_nodes);
	minder_clipboard_nodes = _tmp2_;
	_connections_unref0 (minder_clipboard_conns);
	minder_clipboard_conns = _tmp3_;
	minder_clipboard_set_internally = TRUE;
	_tmp4_ = gdk_display_get_default ();
	_tmp5_ = gtk_clipboard_get_default (_tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	clipboard = _tmp6_;
	gtk_clipboard_set_with_data (clipboard, MINDER_CLIPBOARD_node_target_list, (guint) G_N_ELEMENTS (MINDER_CLIPBOARD_node_target_list), _minder_clipboard_set_with_data_gtk_clipboard_get_func, _minder_clipboard_clear_data_gtk_clipboard_clear_func, NULL);
	_g_object_unref0 (clipboard);
}

gboolean
minder_clipboard_node_pasteable (void)
{
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp0_;
	GtkClipboard* _tmp1_;
	GtkClipboard* _tmp2_;
	GdkAtom* targets = NULL;
	gint targets_length1 = 0;
	gint _targets_size_ = 0;
	GtkClipboard* _tmp3_;
	GdkAtom* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GdkAtom* _tmp6_;
	gint _tmp6__length1;
	gboolean result;
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gtk_clipboard_get_default (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	clipboard = _tmp2_;
	_tmp3_ = clipboard;
	gtk_clipboard_wait_for_targets (_tmp3_, &_tmp4_, &_tmp5_);
	targets = (g_free (targets), NULL);
	targets = _tmp4_;
	targets_length1 = _tmp5_;
	_targets_size_ = targets_length1;
	_tmp6_ = targets;
	_tmp6__length1 = targets_length1;
	{
		GdkAtom* target_collection = NULL;
		gint target_collection_length1 = 0;
		gint _target_collection_size_ = 0;
		gint target_it = 0;
		target_collection = _tmp6_;
		target_collection_length1 = _tmp6__length1;
		for (target_it = 0; target_it < target_collection_length1; target_it = target_it + 1) {
			GdkAtom target = (GdkAtom) 0U;
			target = target_collection[target_it];
			{
				gchar* _tmp7_;
				gchar* _tmp8_;
				gboolean _tmp9_;
				_tmp7_ = gdk_atom_name (target);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strcmp0 (_tmp8_, MINDER_CLIPBOARD_NODES_TARGET_NAME) == 0;
				_g_free0 (_tmp8_);
				if (_tmp9_) {
					result = TRUE;
					targets = (g_free (targets), NULL);
					_g_object_unref0 (clipboard);
					return result;
				}
			}
		}
	}
	result = FALSE;
	targets = (g_free (targets), NULL);
	_g_object_unref0 (clipboard);
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->da);
		g_slice_free (Block3Data, _data3_);
	}
}

static GdkAtom*
_gdk_atom_dup (GdkAtom* self)
{
	GdkAtom* dup;
	dup = g_new0 (GdkAtom, 1);
	memcpy (dup, self, sizeof (GdkAtom));
	return dup;
}

static gpointer
__gdk_atom_dup0 (gpointer self)
{
	return self ? _gdk_atom_dup (self) : NULL;
}

static void
___lambda49_ (Block3Data* _data3_,
              GtkClipboard* c,
              GtkSelectionData* raw_data)
{
	gchar* data = NULL;
	guint8* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (c != NULL);
	g_return_if_fail (raw_data != NULL);
	_tmp0_ = gtk_selection_data_get_data (raw_data);
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	data = _tmp1_;
	_tmp2_ = data;
	if (_tmp2_ == NULL) {
		_g_free0 (data);
		return;
	}
	_tmp3_ = data;
	draw_area_paste_nodes (_data3_->da, _tmp3_, _data3_->shift);
	_g_free0 (data);
}

static void
____lambda49__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                           GtkSelectionData* selection_data,
                                           gpointer self)
{
	___lambda49_ (self, clipboard, selection_data);
	block3_data_unref (self);
}

static void
____lambda50_ (Block3Data* _data3_,
               GtkClipboard* c,
               GtkSelectionData* raw_data)
{
	GdkPixbuf* data = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	g_return_if_fail (c != NULL);
	g_return_if_fail (raw_data != NULL);
	_tmp0_ = gtk_selection_data_get_pixbuf (raw_data);
	data = _tmp0_;
	_tmp1_ = data;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (data);
		return;
	}
	_tmp2_ = data;
	draw_area_paste_image (_data3_->da, _tmp2_, _data3_->shift);
	_g_object_unref0 (data);
}

static void
_____lambda50__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                            GtkSelectionData* selection_data,
                                            gpointer self)
{
	____lambda50_ (self, clipboard, selection_data);
	block3_data_unref (self);
}

static void
_____lambda51_ (Block3Data* _data3_,
                GtkClipboard* c,
                GtkSelectionData* raw_data)
{
	gchar* data = NULL;
	guint8* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (c != NULL);
	g_return_if_fail (raw_data != NULL);
	_tmp0_ = gtk_selection_data_get_data (raw_data);
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	data = _tmp1_;
	_tmp2_ = data;
	if (_tmp2_ == NULL) {
		_g_free0 (data);
		return;
	}
	_tmp3_ = data;
	draw_area_paste_text (_data3_->da, _tmp3_, _data3_->shift);
	_g_free0 (data);
}

static void
______lambda51__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                             GtkSelectionData* selection_data,
                                             gpointer self)
{
	_____lambda51_ (self, clipboard, selection_data);
	block3_data_unref (self);
}

void
minder_clipboard_paste (DrawArea* da,
                        gboolean shift)
{
	Block3Data* _data3_;
	DrawArea* _tmp0_;
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp1_;
	GtkClipboard* _tmp2_;
	GtkClipboard* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean text_needed = FALSE;
	GdkAtom* targets = NULL;
	gint targets_length1 = 0;
	gint _targets_size_ = 0;
	GtkClipboard* _tmp5_;
	GdkAtom* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GdkAtom* nodes_atom = NULL;
	GdkAtom* text_atom = NULL;
	GdkAtom* image_atom = NULL;
	GdkAtom* _tmp8_;
	gint _tmp8__length1;
	GdkAtom* _tmp28_;
	g_return_if_fail (da != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (_data3_->da);
	_data3_->da = _tmp0_;
	_data3_->shift = shift;
	_tmp1_ = gdk_display_get_default ();
	_tmp2_ = gtk_clipboard_get_default (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	if (draw_area_is_node_editable (_data3_->da)) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = draw_area_is_connection_editable (_data3_->da);
	}
	text_needed = _tmp4_;
	_tmp5_ = clipboard;
	gtk_clipboard_wait_for_targets (_tmp5_, &_tmp6_, &_tmp7_);
	targets = (g_free (targets), NULL);
	targets = _tmp6_;
	targets_length1 = _tmp7_;
	_targets_size_ = targets_length1;
	nodes_atom = NULL;
	text_atom = NULL;
	image_atom = NULL;
	_tmp8_ = targets;
	_tmp8__length1 = targets_length1;
	{
		GdkAtom* target_collection = NULL;
		gint target_collection_length1 = 0;
		gint _target_collection_size_ = 0;
		gint target_it = 0;
		target_collection = _tmp8_;
		target_collection_length1 = _tmp8__length1;
		for (target_it = 0; target_it < target_collection_length1; target_it = target_it + 1) {
			GdkAtom target = (GdkAtom) 0U;
			target = target_collection[target_it];
			{
				gchar* _tmp9_;
				gchar* _tmp10_;
				GQuark _tmp12_ = 0U;
				static GQuark _tmp11_label0 = 0;
				static GQuark _tmp11_label1 = 0;
				static GQuark _tmp11_label2 = 0;
				static GQuark _tmp11_label3 = 0;
				static GQuark _tmp11_label4 = 0;
				_tmp9_ = gdk_atom_name (target);
				_tmp10_ = _tmp9_;
				_tmp12_ = (NULL == _tmp10_) ? 0 : g_quark_from_string (_tmp10_);
				g_free (_tmp10_);
				if (_tmp12_ == ((0 != _tmp11_label0) ? _tmp11_label0 : (_tmp11_label0 = g_quark_from_static_string (MINDER_CLIPBOARD_NODES_TARGET_NAME)))) {
					switch (0) {
						default:
						{
							GdkAtom* _tmp13_ = NULL;
							GdkAtom* _tmp14_;
							GdkAtom* _tmp15_;
							GdkAtom* _tmp17_;
							_tmp14_ = nodes_atom;
							_tmp15_ = __gdk_atom_dup0 (_tmp14_);
							_tmp13_ = _tmp15_;
							if (_tmp13_ == NULL) {
								GdkAtom* _tmp16_;
								_tmp16_ = __gdk_atom_dup0 (&target);
								_g_free0 (_tmp13_);
								_tmp13_ = _tmp16_;
							}
							_tmp17_ = _tmp13_;
							_tmp13_ = NULL;
							_g_free0 (nodes_atom);
							nodes_atom = _tmp17_;
							_g_free0 (_tmp13_);
							break;
						}
					}
				} else if (((_tmp12_ == ((0 != _tmp11_label1) ? _tmp11_label1 : (_tmp11_label1 = g_quark_from_static_string ("UTF8_STRING")))) || (_tmp12_ == ((0 != _tmp11_label2) ? _tmp11_label2 : (_tmp11_label2 = g_quark_from_static_string ("STRING"))))) || (_tmp12_ == ((0 != _tmp11_label3) ? _tmp11_label3 : (_tmp11_label3 = g_quark_from_static_string ("text/plain"))))) {
					switch (0) {
						default:
						{
							GdkAtom* _tmp18_ = NULL;
							GdkAtom* _tmp19_;
							GdkAtom* _tmp20_;
							GdkAtom* _tmp22_;
							_tmp19_ = text_atom;
							_tmp20_ = __gdk_atom_dup0 (_tmp19_);
							_tmp18_ = _tmp20_;
							if (_tmp18_ == NULL) {
								GdkAtom* _tmp21_;
								_tmp21_ = __gdk_atom_dup0 (&target);
								_g_free0 (_tmp18_);
								_tmp18_ = _tmp21_;
							}
							_tmp22_ = _tmp18_;
							_tmp18_ = NULL;
							_g_free0 (text_atom);
							text_atom = _tmp22_;
							_g_free0 (_tmp18_);
							break;
						}
					}
				} else if (_tmp12_ == ((0 != _tmp11_label4) ? _tmp11_label4 : (_tmp11_label4 = g_quark_from_static_string ("image/png")))) {
					switch (0) {
						default:
						{
							GdkAtom* _tmp23_ = NULL;
							GdkAtom* _tmp24_;
							GdkAtom* _tmp25_;
							GdkAtom* _tmp27_;
							_tmp24_ = image_atom;
							_tmp25_ = __gdk_atom_dup0 (_tmp24_);
							_tmp23_ = _tmp25_;
							if (_tmp23_ == NULL) {
								GdkAtom* _tmp26_;
								_tmp26_ = __gdk_atom_dup0 (&target);
								_g_free0 (_tmp23_);
								_tmp23_ = _tmp26_;
							}
							_tmp27_ = _tmp23_;
							_tmp23_ = NULL;
							_g_free0 (image_atom);
							image_atom = _tmp27_;
							_g_free0 (_tmp23_);
							break;
						}
					}
				}
			}
		}
	}
	_tmp28_ = nodes_atom;
	if (_tmp28_ != NULL) {
		GtkClipboard* _tmp29_;
		GdkAtom* _tmp30_;
		_tmp29_ = clipboard;
		_tmp30_ = nodes_atom;
		gtk_clipboard_request_contents (_tmp29_, *_tmp30_, ____lambda49__gtk_clipboard_received_func, block3_data_ref (_data3_));
	} else {
		gboolean _tmp31_ = FALSE;
		GdkAtom* _tmp32_;
		_tmp32_ = image_atom;
		if (_tmp32_ != NULL) {
			gboolean _tmp33_ = FALSE;
			GdkAtom* _tmp34_;
			_tmp34_ = text_atom;
			if (_tmp34_ == NULL) {
				_tmp33_ = TRUE;
			} else {
				_tmp33_ = !text_needed;
			}
			_tmp31_ = _tmp33_;
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			GtkClipboard* _tmp35_;
			GdkAtom* _tmp36_;
			_tmp35_ = clipboard;
			_tmp36_ = image_atom;
			gtk_clipboard_request_contents (_tmp35_, *_tmp36_, _____lambda50__gtk_clipboard_received_func, block3_data_ref (_data3_));
		} else {
			GdkAtom* _tmp37_;
			_tmp37_ = text_atom;
			if (_tmp37_ != NULL) {
				GtkClipboard* _tmp38_;
				GdkAtom* _tmp39_;
				_tmp38_ = clipboard;
				_tmp39_ = text_atom;
				gtk_clipboard_request_contents (_tmp38_, *_tmp39_, ______lambda51__gtk_clipboard_received_func, block3_data_ref (_data3_));
			}
		}
	}
	_g_free0 (image_atom);
	_g_free0 (text_atom);
	_g_free0 (nodes_atom);
	targets = (g_free (targets), NULL);
	_g_object_unref0 (clipboard);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->da);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_____lambda52_ (Block4Data* _data4_,
                GtkClipboard* c,
                GtkSelectionData* raw_data)
{
	gchar* data = NULL;
	guint8* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (c != NULL);
	g_return_if_fail (raw_data != NULL);
	_tmp0_ = gtk_selection_data_get_data (raw_data);
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	data = _tmp1_;
	_tmp2_ = data;
	if (_tmp2_ == NULL) {
		_g_free0 (data);
		return;
	}
	_tmp3_ = data;
	draw_area_paste_node_link (_data4_->da, _tmp3_);
	_g_free0 (data);
}

static void
______lambda52__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                             GtkSelectionData* selection_data,
                                             gpointer self)
{
	_____lambda52_ (self, clipboard, selection_data);
	block4_data_unref (self);
}

void
minder_clipboard_paste_node_link (DrawArea* da)
{
	Block4Data* _data4_;
	DrawArea* _tmp0_;
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp1_;
	GtkClipboard* _tmp2_;
	GtkClipboard* _tmp3_;
	GdkAtom* targets = NULL;
	gint targets_length1 = 0;
	gint _targets_size_ = 0;
	GtkClipboard* _tmp4_;
	GdkAtom* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GdkAtom* _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (da != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (_data4_->da);
	_data4_->da = _tmp0_;
	_tmp1_ = gdk_display_get_default ();
	_tmp2_ = gtk_clipboard_get_default (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	_tmp4_ = clipboard;
	gtk_clipboard_wait_for_targets (_tmp4_, &_tmp5_, &_tmp6_);
	targets = (g_free (targets), NULL);
	targets = _tmp5_;
	targets_length1 = _tmp6_;
	_targets_size_ = targets_length1;
	_tmp7_ = targets;
	_tmp7__length1 = targets_length1;
	{
		GdkAtom* target_collection = NULL;
		gint target_collection_length1 = 0;
		gint _target_collection_size_ = 0;
		gint target_it = 0;
		target_collection = _tmp7_;
		target_collection_length1 = _tmp7__length1;
		for (target_it = 0; target_it < target_collection_length1; target_it = target_it + 1) {
			GdkAtom target = (GdkAtom) 0U;
			target = target_collection[target_it];
			{
				gchar* _tmp8_;
				gchar* _tmp9_;
				gboolean _tmp10_;
				_tmp8_ = gdk_atom_name (target);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strcmp0 (_tmp9_, MINDER_CLIPBOARD_NODES_TARGET_NAME) == 0;
				_g_free0 (_tmp9_);
				if (_tmp10_) {
					GtkClipboard* _tmp11_;
					_tmp11_ = clipboard;
					gtk_clipboard_request_contents (_tmp11_, target, ______lambda52__gtk_clipboard_received_func, block4_data_ref (_data4_));
					targets = (g_free (targets), NULL);
					_g_object_unref0 (clipboard);
					block4_data_unref (_data4_);
					_data4_ = NULL;
					return;
				}
			}
		}
	}
	targets = (g_free (targets), NULL);
	_g_object_unref0 (clipboard);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->note);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda53_ (Block5Data* _data5_,
              GtkClipboard* c,
              GtkSelectionData* raw_data)
{
	gchar* data = NULL;
	guint8* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	NodeLink* link = NULL;
	const gchar* _tmp3_;
	NodeLink* _tmp4_;
	NodeLink* _tmp5_;
	g_return_if_fail (c != NULL);
	g_return_if_fail (raw_data != NULL);
	_tmp0_ = gtk_selection_data_get_data (raw_data);
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	data = _tmp1_;
	_tmp2_ = data;
	if (_tmp2_ == NULL) {
		_g_free0 (data);
		return;
	}
	_tmp3_ = data;
	_tmp4_ = draw_area_deserialize_for_node_link (_tmp3_);
	link = _tmp4_;
	_tmp5_ = link;
	if (_tmp5_ != NULL) {
		NodeLink* _tmp6_;
		_tmp6_ = link;
		note_view_paste_node_link (_data5_->note, _tmp6_);
	}
	_node_link_unref0 (link);
	_g_free0 (data);
}

static void
____lambda53__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                           GtkSelectionData* selection_data,
                                           gpointer self)
{
	___lambda53_ (self, clipboard, selection_data);
	block5_data_unref (self);
}

static void
____lambda54_ (Block5Data* _data5_,
               GtkClipboard* c,
               GtkSelectionData* raw_data)
{
	gchar* data = NULL;
	guint8* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (c != NULL);
	g_return_if_fail (raw_data != NULL);
	_tmp0_ = gtk_selection_data_get_data (raw_data);
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	data = _tmp1_;
	_tmp2_ = data;
	if (_tmp2_ == NULL) {
		_g_free0 (data);
		return;
	}
	_tmp3_ = data;
	note_view_paste_text (_data5_->note, _tmp3_);
	_g_free0 (data);
}

static void
_____lambda54__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                            GtkSelectionData* selection_data,
                                            gpointer self)
{
	____lambda54_ (self, clipboard, selection_data);
	block5_data_unref (self);
}

void
minder_clipboard_paste_into_note (NoteView* note)
{
	Block5Data* _data5_;
	NoteView* _tmp0_;
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp1_;
	GtkClipboard* _tmp2_;
	GtkClipboard* _tmp3_;
	GdkAtom* targets = NULL;
	gint targets_length1 = 0;
	gint _targets_size_ = 0;
	GtkClipboard* _tmp4_;
	GdkAtom* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GdkAtom* nodes_atom = NULL;
	GdkAtom* text_atom = NULL;
	GdkAtom* _tmp7_;
	gint _tmp7__length1;
	GdkAtom* _tmp22_;
	g_return_if_fail (note != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (note);
	_g_object_unref0 (_data5_->note);
	_data5_->note = _tmp0_;
	_tmp1_ = gdk_display_get_default ();
	_tmp2_ = gtk_clipboard_get_default (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	_tmp4_ = clipboard;
	gtk_clipboard_wait_for_targets (_tmp4_, &_tmp5_, &_tmp6_);
	targets = (g_free (targets), NULL);
	targets = _tmp5_;
	targets_length1 = _tmp6_;
	_targets_size_ = targets_length1;
	nodes_atom = NULL;
	text_atom = NULL;
	_tmp7_ = targets;
	_tmp7__length1 = targets_length1;
	{
		GdkAtom* target_collection = NULL;
		gint target_collection_length1 = 0;
		gint _target_collection_size_ = 0;
		gint target_it = 0;
		target_collection = _tmp7_;
		target_collection_length1 = _tmp7__length1;
		for (target_it = 0; target_it < target_collection_length1; target_it = target_it + 1) {
			GdkAtom target = (GdkAtom) 0U;
			target = target_collection[target_it];
			{
				gchar* _tmp8_;
				gchar* _tmp9_;
				GQuark _tmp11_ = 0U;
				static GQuark _tmp10_label0 = 0;
				static GQuark _tmp10_label1 = 0;
				static GQuark _tmp10_label2 = 0;
				static GQuark _tmp10_label3 = 0;
				_tmp8_ = gdk_atom_name (target);
				_tmp9_ = _tmp8_;
				_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
				g_free (_tmp9_);
				if (_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string (MINDER_CLIPBOARD_NODES_TARGET_NAME)))) {
					switch (0) {
						default:
						{
							GdkAtom* _tmp12_ = NULL;
							GdkAtom* _tmp13_;
							GdkAtom* _tmp14_;
							GdkAtom* _tmp16_;
							_tmp13_ = nodes_atom;
							_tmp14_ = __gdk_atom_dup0 (_tmp13_);
							_tmp12_ = _tmp14_;
							if (_tmp12_ == NULL) {
								GdkAtom* _tmp15_;
								_tmp15_ = __gdk_atom_dup0 (&target);
								_g_free0 (_tmp12_);
								_tmp12_ = _tmp15_;
							}
							_tmp16_ = _tmp12_;
							_tmp12_ = NULL;
							_g_free0 (nodes_atom);
							nodes_atom = _tmp16_;
							_g_free0 (_tmp12_);
							break;
						}
					}
				} else if (((_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("UTF8_STRING")))) || (_tmp11_ == ((0 != _tmp10_label2) ? _tmp10_label2 : (_tmp10_label2 = g_quark_from_static_string ("STRING"))))) || (_tmp11_ == ((0 != _tmp10_label3) ? _tmp10_label3 : (_tmp10_label3 = g_quark_from_static_string ("text/plain"))))) {
					switch (0) {
						default:
						{
							GdkAtom* _tmp17_ = NULL;
							GdkAtom* _tmp18_;
							GdkAtom* _tmp19_;
							GdkAtom* _tmp21_;
							_tmp18_ = text_atom;
							_tmp19_ = __gdk_atom_dup0 (_tmp18_);
							_tmp17_ = _tmp19_;
							if (_tmp17_ == NULL) {
								GdkAtom* _tmp20_;
								_tmp20_ = __gdk_atom_dup0 (&target);
								_g_free0 (_tmp17_);
								_tmp17_ = _tmp20_;
							}
							_tmp21_ = _tmp17_;
							_tmp17_ = NULL;
							_g_free0 (text_atom);
							text_atom = _tmp21_;
							_g_free0 (_tmp17_);
							break;
						}
					}
				}
			}
		}
	}
	_tmp22_ = nodes_atom;
	if (_tmp22_ != NULL) {
		GtkClipboard* _tmp23_;
		GdkAtom* _tmp24_;
		_tmp23_ = clipboard;
		_tmp24_ = nodes_atom;
		gtk_clipboard_request_contents (_tmp23_, *_tmp24_, ____lambda53__gtk_clipboard_received_func, block5_data_ref (_data5_));
	} else {
		GdkAtom* _tmp25_;
		_tmp25_ = text_atom;
		if (_tmp25_ != NULL) {
			GtkClipboard* _tmp26_;
			GdkAtom* _tmp27_;
			_tmp26_ = clipboard;
			_tmp27_ = text_atom;
			gtk_clipboard_request_contents (_tmp26_, *_tmp27_, _____lambda54__gtk_clipboard_received_func, block5_data_ref (_data5_));
		}
	}
	_g_free0 (text_atom);
	_g_free0 (nodes_atom);
	targets = (g_free (targets), NULL);
	_g_object_unref0 (clipboard);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

MinderClipboard*
minder_clipboard_construct (GType object_type)
{
	MinderClipboard* self = NULL;
	self = (MinderClipboard*) g_type_create_instance (object_type);
	return self;
}

MinderClipboard*
minder_clipboard_new (void)
{
	return minder_clipboard_construct (TYPE_MINDER_CLIPBOARD);
}

static void
value_minder_clipboard_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_minder_clipboard_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		minder_clipboard_unref (value->data[0].v_pointer);
	}
}

static void
value_minder_clipboard_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = minder_clipboard_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_minder_clipboard_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_minder_clipboard_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		MinderClipboard * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = minder_clipboard_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_minder_clipboard_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	MinderClipboard ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = minder_clipboard_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_minder_clipboard (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecMinderClipboard* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MINDER_CLIPBOARD), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_minder_clipboard (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MINDER_CLIPBOARD), NULL);
	return value->data[0].v_pointer;
}

void
value_set_minder_clipboard (GValue* value,
                            gpointer v_object)
{
	MinderClipboard * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MINDER_CLIPBOARD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MINDER_CLIPBOARD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		minder_clipboard_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		minder_clipboard_unref (old);
	}
}

void
value_take_minder_clipboard (GValue* value,
                             gpointer v_object)
{
	MinderClipboard * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MINDER_CLIPBOARD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MINDER_CLIPBOARD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		minder_clipboard_unref (old);
	}
}

static void
minder_clipboard_class_init (MinderClipboardClass * klass,
                             gpointer klass_data)
{
	minder_clipboard_parent_class = g_type_class_peek_parent (klass);
	((MinderClipboardClass *) klass)->finalize = minder_clipboard_finalize;
	minder_clipboard_NODES_ATOM = gdk_atom_intern_static_string (MINDER_CLIPBOARD_NODES_TARGET_NAME);
}

static void
minder_clipboard_instance_init (MinderClipboard * self,
                                gpointer klass)
{
	self->ref_count = 1;
}

static void
minder_clipboard_finalize (MinderClipboard * obj)
{
	MinderClipboard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINDER_CLIPBOARD, MinderClipboard);
	g_signal_handlers_destroy (self);
}

static GType
minder_clipboard_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_minder_clipboard_init, value_minder_clipboard_free_value, value_minder_clipboard_copy_value, value_minder_clipboard_peek_pointer, "p", value_minder_clipboard_collect_value, "p", value_minder_clipboard_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MinderClipboardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) minder_clipboard_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MinderClipboard), 0, (GInstanceInitFunc) minder_clipboard_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType minder_clipboard_type_id;
	minder_clipboard_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MinderClipboard", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return minder_clipboard_type_id;
}

GType
minder_clipboard_get_type (void)
{
	static volatile gsize minder_clipboard_type_id__once = 0;
	if (g_once_init_enter (&minder_clipboard_type_id__once)) {
		GType minder_clipboard_type_id;
		minder_clipboard_type_id = minder_clipboard_get_type_once ();
		g_once_init_leave (&minder_clipboard_type_id__once, minder_clipboard_type_id);
	}
	return minder_clipboard_type_id__once;
}

gpointer
minder_clipboard_ref (gpointer instance)
{
	MinderClipboard * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
minder_clipboard_unref (gpointer instance)
{
	MinderClipboard * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MINDER_CLIPBOARD_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

