/* FormattedText.c generated by valac 0.56.18, the Vala compiler
 * generated from FormattedText.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Outliner)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <pango/pango.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	FORMAT_TAG_BOLD = 0,
	FORMAT_TAG_ITALICS,
	FORMAT_TAG_UNDERLINE,
	FORMAT_TAG_STRIKETHRU,
	FORMAT_TAG_CODE,
	FORMAT_TAG_SUB,
	FORMAT_TAG_SUPER,
	FORMAT_TAG_HEADER,
	FORMAT_TAG_COLOR,
	FORMAT_TAG_HILITE,
	FORMAT_TAG_URL,
	FORMAT_TAG_SYNTAX,
	FORMAT_TAG_TAG,
	FORMAT_TAG_MATCH,
	FORMAT_TAG_SELECT,
	FORMAT_TAG_LENGTH
} FormatTag;

#define TYPE_FORMAT_TAG (format_tag_get_type ())

#define TYPE_UNDO_TAG_INFO (undo_tag_info_get_type ())
#define UNDO_TAG_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TAG_INFO, UndoTagInfo))
#define UNDO_TAG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TAG_INFO, UndoTagInfoClass))
#define IS_UNDO_TAG_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TAG_INFO))
#define IS_UNDO_TAG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TAG_INFO))
#define UNDO_TAG_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TAG_INFO, UndoTagInfoClass))

typedef struct _UndoTagInfo UndoTagInfo;
typedef struct _UndoTagInfoClass UndoTagInfoClass;
typedef struct _UndoTagInfoPrivate UndoTagInfoPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecUndoTagInfo ParamSpecUndoTagInfo;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;
typedef struct _FormattedTextPrivate FormattedTextPrivate;

#define FORMATTED_TEXT_TYPE_TAG_INFO (formatted_text_tag_info_get_type ())
#define FORMATTED_TEXT_TAG_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_TAG_INFO, FormattedTextTagInfo))
#define FORMATTED_TEXT_TAG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_TAG_INFO, FormattedTextTagInfoClass))
#define FORMATTED_TEXT_IS_TAG_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_TAG_INFO))
#define FORMATTED_TEXT_IS_TAG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_TAG_INFO))
#define FORMATTED_TEXT_TAG_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_TAG_INFO, FormattedTextTagInfoClass))

typedef struct _FormattedTextTagInfo FormattedTextTagInfo;
typedef struct _FormattedTextTagInfoClass FormattedTextTagInfoClass;

#define TYPE_TEXT_PARSER (text_parser_get_type ())
#define TEXT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_PARSER, TextParser))
#define TEXT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_PARSER, TextParserClass))
#define IS_TEXT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_PARSER))
#define IS_TEXT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_PARSER))
#define TEXT_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_PARSER, TextParserClass))

typedef struct _TextParser TextParser;
typedef struct _TextParserClass TextParserClass;

#define FORMATTED_TEXT_TYPE_TAG_ATTR (formatted_text_tag_attr_get_type ())
#define FORMATTED_TEXT_TAG_ATTR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_TAG_ATTR, FormattedTextTagAttr))
#define FORMATTED_TEXT_TAG_ATTR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_TAG_ATTR, FormattedTextTagAttrClass))
#define FORMATTED_TEXT_IS_TAG_ATTR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_TAG_ATTR))
#define FORMATTED_TEXT_IS_TAG_ATTR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_TAG_ATTR))
#define FORMATTED_TEXT_TAG_ATTR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_TAG_ATTR, FormattedTextTagAttrClass))

typedef struct _FormattedTextTagAttr FormattedTextTagAttr;
typedef struct _FormattedTextTagAttrClass FormattedTextTagAttrClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;
#define _undo_tag_info_unref0(var) ((var == NULL) ? NULL : (var = (undo_tag_info_unref (var), NULL)))

#define FORMATTED_TEXT_TAG_INFO_TYPE_FORMATTED_RANGE (formatted_text_tag_info_formatted_range_get_type ())
#define FORMATTED_TEXT_TAG_INFO_FORMATTED_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TAG_INFO_TYPE_FORMATTED_RANGE, FormattedTextTagInfoFormattedRange))
#define FORMATTED_TEXT_TAG_INFO_FORMATTED_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TAG_INFO_TYPE_FORMATTED_RANGE, FormattedTextTagInfoFormattedRangeClass))
#define FORMATTED_TEXT_TAG_INFO_IS_FORMATTED_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TAG_INFO_TYPE_FORMATTED_RANGE))
#define FORMATTED_TEXT_TAG_INFO_IS_FORMATTED_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TAG_INFO_TYPE_FORMATTED_RANGE))
#define FORMATTED_TEXT_TAG_INFO_FORMATTED_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TAG_INFO_TYPE_FORMATTED_RANGE, FormattedTextTagInfoFormattedRangeClass))

typedef struct _FormattedTextTagInfoFormattedRange FormattedTextTagInfoFormattedRange;
typedef struct _FormattedTextTagInfoFormattedRangeClass FormattedTextTagInfoFormattedRangeClass;
#define _formatted_text_tag_info_formatted_range_unref0(var) ((var == NULL) ? NULL : (var = (formatted_text_tag_info_formatted_range_unref (var), NULL)))

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;

#define FORMATTED_TEXT_TYPE_BOLD_INFO (formatted_text_bold_info_get_type ())
#define FORMATTED_TEXT_BOLD_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_BOLD_INFO, FormattedTextBoldInfo))
#define FORMATTED_TEXT_BOLD_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_BOLD_INFO, FormattedTextBoldInfoClass))
#define FORMATTED_TEXT_IS_BOLD_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_BOLD_INFO))
#define FORMATTED_TEXT_IS_BOLD_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_BOLD_INFO))
#define FORMATTED_TEXT_BOLD_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_BOLD_INFO, FormattedTextBoldInfoClass))

typedef struct _FormattedTextBoldInfo FormattedTextBoldInfo;
typedef struct _FormattedTextBoldInfoClass FormattedTextBoldInfoClass;
#define _formatted_text_tag_attr_unref0(var) ((var == NULL) ? NULL : (var = (formatted_text_tag_attr_unref (var), NULL)))

#define FORMATTED_TEXT_TYPE_ITALICS_INFO (formatted_text_italics_info_get_type ())
#define FORMATTED_TEXT_ITALICS_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_ITALICS_INFO, FormattedTextItalicsInfo))
#define FORMATTED_TEXT_ITALICS_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_ITALICS_INFO, FormattedTextItalicsInfoClass))
#define FORMATTED_TEXT_IS_ITALICS_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_ITALICS_INFO))
#define FORMATTED_TEXT_IS_ITALICS_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_ITALICS_INFO))
#define FORMATTED_TEXT_ITALICS_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_ITALICS_INFO, FormattedTextItalicsInfoClass))

typedef struct _FormattedTextItalicsInfo FormattedTextItalicsInfo;
typedef struct _FormattedTextItalicsInfoClass FormattedTextItalicsInfoClass;

#define FORMATTED_TEXT_TYPE_UNDERLINE_INFO (formatted_text_underline_info_get_type ())
#define FORMATTED_TEXT_UNDERLINE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_UNDERLINE_INFO, FormattedTextUnderlineInfo))
#define FORMATTED_TEXT_UNDERLINE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_UNDERLINE_INFO, FormattedTextUnderlineInfoClass))
#define FORMATTED_TEXT_IS_UNDERLINE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_UNDERLINE_INFO))
#define FORMATTED_TEXT_IS_UNDERLINE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_UNDERLINE_INFO))
#define FORMATTED_TEXT_UNDERLINE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_UNDERLINE_INFO, FormattedTextUnderlineInfoClass))

typedef struct _FormattedTextUnderlineInfo FormattedTextUnderlineInfo;
typedef struct _FormattedTextUnderlineInfoClass FormattedTextUnderlineInfoClass;

#define FORMATTED_TEXT_TYPE_STRIKE_THRU_INFO (formatted_text_strike_thru_info_get_type ())
#define FORMATTED_TEXT_STRIKE_THRU_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_STRIKE_THRU_INFO, FormattedTextStrikeThruInfo))
#define FORMATTED_TEXT_STRIKE_THRU_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_STRIKE_THRU_INFO, FormattedTextStrikeThruInfoClass))
#define FORMATTED_TEXT_IS_STRIKE_THRU_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_STRIKE_THRU_INFO))
#define FORMATTED_TEXT_IS_STRIKE_THRU_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_STRIKE_THRU_INFO))
#define FORMATTED_TEXT_STRIKE_THRU_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_STRIKE_THRU_INFO, FormattedTextStrikeThruInfoClass))

typedef struct _FormattedTextStrikeThruInfo FormattedTextStrikeThruInfo;
typedef struct _FormattedTextStrikeThruInfoClass FormattedTextStrikeThruInfoClass;

#define FORMATTED_TEXT_TYPE_CODE_INFO (formatted_text_code_info_get_type ())
#define FORMATTED_TEXT_CODE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_CODE_INFO, FormattedTextCodeInfo))
#define FORMATTED_TEXT_CODE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_CODE_INFO, FormattedTextCodeInfoClass))
#define FORMATTED_TEXT_IS_CODE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_CODE_INFO))
#define FORMATTED_TEXT_IS_CODE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_CODE_INFO))
#define FORMATTED_TEXT_CODE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_CODE_INFO, FormattedTextCodeInfoClass))

typedef struct _FormattedTextCodeInfo FormattedTextCodeInfo;
typedef struct _FormattedTextCodeInfoClass FormattedTextCodeInfoClass;

#define FORMATTED_TEXT_TYPE_SUB_INFO (formatted_text_sub_info_get_type ())
#define FORMATTED_TEXT_SUB_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_SUB_INFO, FormattedTextSubInfo))
#define FORMATTED_TEXT_SUB_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_SUB_INFO, FormattedTextSubInfoClass))
#define FORMATTED_TEXT_IS_SUB_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_SUB_INFO))
#define FORMATTED_TEXT_IS_SUB_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_SUB_INFO))
#define FORMATTED_TEXT_SUB_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_SUB_INFO, FormattedTextSubInfoClass))

typedef struct _FormattedTextSubInfo FormattedTextSubInfo;
typedef struct _FormattedTextSubInfoClass FormattedTextSubInfoClass;

#define FORMATTED_TEXT_TYPE_SUPER_INFO (formatted_text_super_info_get_type ())
#define FORMATTED_TEXT_SUPER_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_SUPER_INFO, FormattedTextSuperInfo))
#define FORMATTED_TEXT_SUPER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_SUPER_INFO, FormattedTextSuperInfoClass))
#define FORMATTED_TEXT_IS_SUPER_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_SUPER_INFO))
#define FORMATTED_TEXT_IS_SUPER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_SUPER_INFO))
#define FORMATTED_TEXT_SUPER_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_SUPER_INFO, FormattedTextSuperInfoClass))

typedef struct _FormattedTextSuperInfo FormattedTextSuperInfo;
typedef struct _FormattedTextSuperInfoClass FormattedTextSuperInfoClass;

#define FORMATTED_TEXT_TYPE_HEADER_INFO (formatted_text_header_info_get_type ())
#define FORMATTED_TEXT_HEADER_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_HEADER_INFO, FormattedTextHeaderInfo))
#define FORMATTED_TEXT_HEADER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_HEADER_INFO, FormattedTextHeaderInfoClass))
#define FORMATTED_TEXT_IS_HEADER_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_HEADER_INFO))
#define FORMATTED_TEXT_IS_HEADER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_HEADER_INFO))
#define FORMATTED_TEXT_HEADER_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_HEADER_INFO, FormattedTextHeaderInfoClass))

typedef struct _FormattedTextHeaderInfo FormattedTextHeaderInfo;
typedef struct _FormattedTextHeaderInfoClass FormattedTextHeaderInfoClass;

#define FORMATTED_TEXT_TYPE_COLOR_INFO (formatted_text_color_info_get_type ())
#define FORMATTED_TEXT_COLOR_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_COLOR_INFO, FormattedTextColorInfo))
#define FORMATTED_TEXT_COLOR_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_COLOR_INFO, FormattedTextColorInfoClass))
#define FORMATTED_TEXT_IS_COLOR_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_COLOR_INFO))
#define FORMATTED_TEXT_IS_COLOR_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_COLOR_INFO))
#define FORMATTED_TEXT_COLOR_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_COLOR_INFO, FormattedTextColorInfoClass))

typedef struct _FormattedTextColorInfo FormattedTextColorInfo;
typedef struct _FormattedTextColorInfoClass FormattedTextColorInfoClass;

#define FORMATTED_TEXT_TYPE_HIGHLIGHT_INFO (formatted_text_highlight_info_get_type ())
#define FORMATTED_TEXT_HIGHLIGHT_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_HIGHLIGHT_INFO, FormattedTextHighlightInfo))
#define FORMATTED_TEXT_HIGHLIGHT_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_HIGHLIGHT_INFO, FormattedTextHighlightInfoClass))
#define FORMATTED_TEXT_IS_HIGHLIGHT_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_HIGHLIGHT_INFO))
#define FORMATTED_TEXT_IS_HIGHLIGHT_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_HIGHLIGHT_INFO))
#define FORMATTED_TEXT_HIGHLIGHT_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_HIGHLIGHT_INFO, FormattedTextHighlightInfoClass))

typedef struct _FormattedTextHighlightInfo FormattedTextHighlightInfo;
typedef struct _FormattedTextHighlightInfoClass FormattedTextHighlightInfoClass;

#define FORMATTED_TEXT_TYPE_URL_INFO (formatted_text_url_info_get_type ())
#define FORMATTED_TEXT_URL_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_URL_INFO, FormattedTextUrlInfo))
#define FORMATTED_TEXT_URL_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_URL_INFO, FormattedTextUrlInfoClass))
#define FORMATTED_TEXT_IS_URL_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_URL_INFO))
#define FORMATTED_TEXT_IS_URL_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_URL_INFO))
#define FORMATTED_TEXT_URL_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_URL_INFO, FormattedTextUrlInfoClass))

typedef struct _FormattedTextUrlInfo FormattedTextUrlInfo;
typedef struct _FormattedTextUrlInfoClass FormattedTextUrlInfoClass;
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))

#define FORMATTED_TEXT_TYPE_TAGGING_INFO (formatted_text_tagging_info_get_type ())
#define FORMATTED_TEXT_TAGGING_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_TAGGING_INFO, FormattedTextTaggingInfo))
#define FORMATTED_TEXT_TAGGING_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_TAGGING_INFO, FormattedTextTaggingInfoClass))
#define FORMATTED_TEXT_IS_TAGGING_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_TAGGING_INFO))
#define FORMATTED_TEXT_IS_TAGGING_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_TAGGING_INFO))
#define FORMATTED_TEXT_TAGGING_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_TAGGING_INFO, FormattedTextTaggingInfoClass))

typedef struct _FormattedTextTaggingInfo FormattedTextTaggingInfo;
typedef struct _FormattedTextTaggingInfoClass FormattedTextTaggingInfoClass;

#define FORMATTED_TEXT_TYPE_SYNTAX_INFO (formatted_text_syntax_info_get_type ())
#define FORMATTED_TEXT_SYNTAX_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_SYNTAX_INFO, FormattedTextSyntaxInfo))
#define FORMATTED_TEXT_SYNTAX_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_SYNTAX_INFO, FormattedTextSyntaxInfoClass))
#define FORMATTED_TEXT_IS_SYNTAX_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_SYNTAX_INFO))
#define FORMATTED_TEXT_IS_SYNTAX_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_SYNTAX_INFO))
#define FORMATTED_TEXT_SYNTAX_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_SYNTAX_INFO, FormattedTextSyntaxInfoClass))

typedef struct _FormattedTextSyntaxInfo FormattedTextSyntaxInfo;
typedef struct _FormattedTextSyntaxInfoClass FormattedTextSyntaxInfoClass;

#define FORMATTED_TEXT_TYPE_MATCH_INFO (formatted_text_match_info_get_type ())
#define FORMATTED_TEXT_MATCH_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_MATCH_INFO, FormattedTextMatchInfo))
#define FORMATTED_TEXT_MATCH_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_MATCH_INFO, FormattedTextMatchInfoClass))
#define FORMATTED_TEXT_IS_MATCH_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_MATCH_INFO))
#define FORMATTED_TEXT_IS_MATCH_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_MATCH_INFO))
#define FORMATTED_TEXT_MATCH_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_MATCH_INFO, FormattedTextMatchInfoClass))

typedef struct _FormattedTextMatchInfo FormattedTextMatchInfo;
typedef struct _FormattedTextMatchInfoClass FormattedTextMatchInfoClass;

#define FORMATTED_TEXT_TYPE_SELECT_INFO (formatted_text_select_info_get_type ())
#define FORMATTED_TEXT_SELECT_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FORMATTED_TEXT_TYPE_SELECT_INFO, FormattedTextSelectInfo))
#define FORMATTED_TEXT_SELECT_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FORMATTED_TEXT_TYPE_SELECT_INFO, FormattedTextSelectInfoClass))
#define FORMATTED_TEXT_IS_SELECT_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FORMATTED_TEXT_TYPE_SELECT_INFO))
#define FORMATTED_TEXT_IS_SELECT_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FORMATTED_TEXT_TYPE_SELECT_INFO))
#define FORMATTED_TEXT_SELECT_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FORMATTED_TEXT_TYPE_SELECT_INFO, FormattedTextSelectInfoClass))

typedef struct _FormattedTextSelectInfo FormattedTextSelectInfo;
typedef struct _FormattedTextSelectInfoClass FormattedTextSelectInfoClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _formatted_text_tag_info_unref0(var) ((var == NULL) ? NULL : (var = (formatted_text_tag_info_unref (var), NULL)))
#define _text_parser_unref0(var) ((var == NULL) ? NULL : (var = (text_parser_unref (var), NULL)))
typedef struct _FormattedTextTagInfoPrivate FormattedTextTagInfoPrivate;
typedef struct _FormattedTextTagInfoFormattedRangePrivate FormattedTextTagInfoFormattedRangePrivate;
typedef struct _FormattedTextTagInfoParamSpecFormattedRange FormattedTextTagInfoParamSpecFormattedRange;
typedef struct _FormattedTextParamSpecTagInfo FormattedTextParamSpecTagInfo;
typedef struct _FormattedTextTagAttrPrivate FormattedTextTagAttrPrivate;
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
typedef struct _FormattedTextParamSpecTagAttr FormattedTextParamSpecTagAttr;
typedef struct _FormattedTextBoldInfoPrivate FormattedTextBoldInfoPrivate;
typedef struct _FormattedTextItalicsInfoPrivate FormattedTextItalicsInfoPrivate;
typedef struct _FormattedTextUnderlineInfoPrivate FormattedTextUnderlineInfoPrivate;
typedef struct _FormattedTextStrikeThruInfoPrivate FormattedTextStrikeThruInfoPrivate;
typedef struct _FormattedTextCodeInfoPrivate FormattedTextCodeInfoPrivate;
typedef struct _FormattedTextSubInfoPrivate FormattedTextSubInfoPrivate;
typedef struct _FormattedTextSuperInfoPrivate FormattedTextSuperInfoPrivate;
typedef struct _FormattedTextHeaderInfoPrivate FormattedTextHeaderInfoPrivate;
typedef struct _FormattedTextColorInfoPrivate FormattedTextColorInfoPrivate;
typedef struct _FormattedTextHighlightInfoPrivate FormattedTextHighlightInfoPrivate;
typedef struct _FormattedTextUrlInfoPrivate FormattedTextUrlInfoPrivate;
typedef struct _FormattedTextTaggingInfoPrivate FormattedTextTaggingInfoPrivate;
typedef struct _FormattedTextSyntaxInfoPrivate FormattedTextSyntaxInfoPrivate;
typedef struct _FormattedTextMatchInfoPrivate FormattedTextMatchInfoPrivate;
typedef struct _FormattedTextSelectInfoPrivate FormattedTextSelectInfoPrivate;
typedef struct _ParamSpecFormattedText ParamSpecFormattedText;
enum  {
	FORMATTED_TEXT_CHANGED_SIGNAL,
	FORMATTED_TEXT_NUM_SIGNALS
};
static guint formatted_text_signals[FORMATTED_TEXT_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _UndoTagInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UndoTagInfoPrivate * priv;
};

struct _UndoTagInfoClass {
	GTypeClass parent_class;
	void (*finalize) (UndoTagInfo *self);
};

struct _UndoTagInfoPrivate {
	gint _start;
	gint _end;
	gint _tag;
	gboolean _parsed;
	gchar* _extra;
};

struct _ParamSpecUndoTagInfo {
	GParamSpec parent_instance;
};

struct _FormattedText {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FormattedTextPrivate * priv;
};

struct _FormattedTextClass {
	GTypeClass parent_class;
	void (*finalize) (FormattedText *self);
};

struct _FormattedTextPrivate {
	FormattedTextTagInfo** _formats;
	gint _formats_length1;
	gint __formats_size_;
	gchar* _text;
	GArray* _parsers;
};

struct _FormattedTextTagInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FormattedTextTagInfoPrivate * priv;
};

struct _FormattedTextTagInfoClass {
	GTypeClass parent_class;
	void (*finalize) (FormattedTextTagInfo *self);
};

struct _FormattedTextTagInfoPrivate {
	GArray* _info;
};

struct _FormattedTextTagInfoFormattedRange {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FormattedTextTagInfoFormattedRangePrivate * priv;
};

struct _FormattedTextTagInfoFormattedRangeClass {
	GTypeClass parent_class;
	void (*finalize) (FormattedTextTagInfoFormattedRange *self);
};

struct _FormattedTextTagInfoFormattedRangePrivate {
	gint _start;
	gint _end;
	gboolean _parsed;
	gchar* _extra;
};

struct _FormattedTextTagInfoParamSpecFormattedRange {
	GParamSpec parent_instance;
};

struct _FormattedTextParamSpecTagInfo {
	GParamSpec parent_instance;
};

struct _FormattedTextTagAttr {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FormattedTextTagAttrPrivate * priv;
	GArray* attrs;
};

struct _FormattedTextTagAttrClass {
	GTypeClass parent_class;
	void (*finalize) (FormattedTextTagAttr *self);
	void (*add_attrs) (FormattedTextTagAttr* self, PangoAttrList** list, gint start, gint end, const gchar* extra);
	GtkTextTag* (*text_tag) (FormattedTextTagAttr* self, const gchar* extra);
};

struct _FormattedTextParamSpecTagAttr {
	GParamSpec parent_instance;
};

struct _FormattedTextBoldInfo {
	FormattedTextTagAttr parent_instance;
	FormattedTextBoldInfoPrivate * priv;
};

struct _FormattedTextBoldInfoClass {
	FormattedTextTagAttrClass parent_class;
};

struct _FormattedTextItalicsInfo {
	FormattedTextTagAttr parent_instance;
	FormattedTextItalicsInfoPrivate * priv;
};

struct _FormattedTextItalicsInfoClass {
	FormattedTextTagAttrClass parent_class;
};

struct _FormattedTextUnderlineInfo {
	FormattedTextTagAttr parent_instance;
	FormattedTextUnderlineInfoPrivate * priv;
};

struct _FormattedTextUnderlineInfoClass {
	FormattedTextTagAttrClass parent_class;
};

struct _FormattedTextStrikeThruInfo {
	FormattedTextTagAttr parent_instance;
	FormattedTextStrikeThruInfoPrivate * priv;
};

struct _FormattedTextStrikeThruInfoClass {
	FormattedTextTagAttrClass parent_class;
};

struct _FormattedTextCodeInfo {
	FormattedTextTagAttr parent_instance;
	FormattedTextCodeInfoPrivate * priv;
};

struct _FormattedTextCodeInfoClass {
	FormattedTextTagAttrClass parent_class;
};

struct _FormattedTextSubInfo {
	FormattedTextTagAttr parent_instance;
	FormattedTextSubInfoPrivate * priv;
};

struct _FormattedTextSubInfoClass {
	FormattedTextTagAttrClass parent_class;
};

struct _FormattedTextSuperInfo {
	FormattedTextTagAttr parent_instance;
	FormattedTextSuperInfoPrivate * priv;
};

struct _FormattedTextSuperInfoClass {
	FormattedTextTagAttrClass parent_class;
};

struct _FormattedTextHeaderInfo {
	FormattedTextTagAttr parent_instance;
	FormattedTextHeaderInfoPrivate * priv;
};

struct _FormattedTextHeaderInfoClass {
	FormattedTextTagAttrClass parent_class;
};

struct _FormattedTextColorInfo {
	FormattedTextTagAttr parent_instance;
	FormattedTextColorInfoPrivate * priv;
};

struct _FormattedTextColorInfoClass {
	FormattedTextTagAttrClass parent_class;
};

struct _FormattedTextHighlightInfo {
	FormattedTextTagAttr parent_instance;
	FormattedTextHighlightInfoPrivate * priv;
};

struct _FormattedTextHighlightInfoClass {
	FormattedTextTagAttrClass parent_class;
};

struct _FormattedTextUrlInfo {
	FormattedTextTagAttr parent_instance;
	FormattedTextUrlInfoPrivate * priv;
};

struct _FormattedTextUrlInfoClass {
	FormattedTextTagAttrClass parent_class;
};

struct _FormattedTextUrlInfoPrivate {
	GdkRGBA _color;
};

struct _FormattedTextTaggingInfo {
	FormattedTextTagAttr parent_instance;
	FormattedTextTaggingInfoPrivate * priv;
};

struct _FormattedTextTaggingInfoClass {
	FormattedTextTagAttrClass parent_class;
};

struct _FormattedTextTaggingInfoPrivate {
	GdkRGBA _color;
};

struct _FormattedTextSyntaxInfo {
	FormattedTextTagAttr parent_instance;
	FormattedTextSyntaxInfoPrivate * priv;
};

struct _FormattedTextSyntaxInfoClass {
	FormattedTextTagAttrClass parent_class;
};

struct _FormattedTextSyntaxInfoPrivate {
	GdkRGBA _color;
	gboolean _hide;
};

struct _FormattedTextMatchInfo {
	FormattedTextTagAttr parent_instance;
	FormattedTextMatchInfoPrivate * priv;
};

struct _FormattedTextMatchInfoClass {
	FormattedTextTagAttrClass parent_class;
};

struct _FormattedTextSelectInfo {
	FormattedTextTagAttr parent_instance;
	FormattedTextSelectInfoPrivate * priv;
};

struct _FormattedTextSelectInfoClass {
	FormattedTextTagAttrClass parent_class;
};

struct _ParamSpecFormattedText {
	GParamSpec parent_instance;
};

static gint UndoTagInfo_private_offset;
static gpointer undo_tag_info_parent_class = NULL;
static gint FormattedText_private_offset;
static gpointer formatted_text_parent_class = NULL;
static FormattedTextTagAttr** formatted_text__attr_tags;
static gint formatted_text__attr_tags_length1;
static FormattedTextTagAttr** formatted_text__attr_tags = NULL;
static gint formatted_text__attr_tags_length1 = 0;
static gint _formatted_text__attr_tags_size_ = 0;
static gint FormattedTextTagInfo_private_offset;
static gpointer formatted_text_tag_info_parent_class = NULL;
static gint FormattedTextTagInfoFormattedRange_private_offset;
static gpointer formatted_text_tag_info_formatted_range_parent_class = NULL;
static gpointer formatted_text_tag_attr_parent_class = NULL;
static gpointer formatted_text_bold_info_parent_class = NULL;
static gpointer formatted_text_italics_info_parent_class = NULL;
static gpointer formatted_text_underline_info_parent_class = NULL;
static gpointer formatted_text_strike_thru_info_parent_class = NULL;
static gpointer formatted_text_code_info_parent_class = NULL;
static gpointer formatted_text_sub_info_parent_class = NULL;
static gpointer formatted_text_super_info_parent_class = NULL;
static gpointer formatted_text_header_info_parent_class = NULL;
static gpointer formatted_text_color_info_parent_class = NULL;
static gpointer formatted_text_highlight_info_parent_class = NULL;
static gint FormattedTextUrlInfo_private_offset;
static gpointer formatted_text_url_info_parent_class = NULL;
static gint FormattedTextTaggingInfo_private_offset;
static gpointer formatted_text_tagging_info_parent_class = NULL;
static gint FormattedTextSyntaxInfo_private_offset;
static gpointer formatted_text_syntax_info_parent_class = NULL;
static gpointer formatted_text_match_info_parent_class = NULL;
static gpointer formatted_text_select_info_parent_class = NULL;

VALA_EXTERN GType format_tag_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* format_tag_to_string (FormatTag self);
VALA_EXTERN FormatTag format_tag_from_string (const gchar* str);
VALA_EXTERN gpointer undo_tag_info_ref (gpointer instance);
VALA_EXTERN void undo_tag_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_undo_tag_info (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_undo_tag_info (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_undo_tag_info (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_undo_tag_info (const GValue* value);
VALA_EXTERN GType undo_tag_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTagInfo, undo_tag_info_unref)
VALA_EXTERN UndoTagInfo* undo_tag_info_new (gint tag,
                                gint start,
                                gint end,
                                const gchar* extra,
                                gboolean parsed);
VALA_EXTERN UndoTagInfo* undo_tag_info_construct (GType object_type,
                                      gint tag,
                                      gint start,
                                      gint end,
                                      const gchar* extra,
                                      gboolean parsed);
static void undo_tag_info_set_tag (UndoTagInfo* self,
                            gint value);
static void undo_tag_info_set_start (UndoTagInfo* self,
                              gint value);
static void undo_tag_info_set_end (UndoTagInfo* self,
                            gint value);
static void undo_tag_info_set_parsed (UndoTagInfo* self,
                               gboolean value);
static void undo_tag_info_set_extra (UndoTagInfo* self,
                              const gchar* value);
VALA_EXTERN gchar* undo_tag_info_to_string (UndoTagInfo* self);
VALA_EXTERN gint undo_tag_info_get_tag (UndoTagInfo* self);
VALA_EXTERN gint undo_tag_info_get_start (UndoTagInfo* self);
VALA_EXTERN gint undo_tag_info_get_end (UndoTagInfo* self);
VALA_EXTERN const gchar* undo_tag_info_get_extra (UndoTagInfo* self);
VALA_EXTERN gboolean undo_tag_info_get_parsed (UndoTagInfo* self);
static void undo_tag_info_finalize (UndoTagInfo * obj);
static GType undo_tag_info_get_type_once (void);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
static gpointer formatted_text_tag_info_ref (gpointer instance);
static void formatted_text_tag_info_unref (gpointer instance);
static GParamSpec* formatted_text_param_spec_tag_info (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags) G_GNUC_UNUSED ;
static void formatted_text_value_set_tag_info (GValue* value,
                                        gpointer v_object) G_GNUC_UNUSED ;
static void formatted_text_value_take_tag_info (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED ;
static gpointer formatted_text_value_get_tag_info (const GValue* value) G_GNUC_UNUSED ;
static GType formatted_text_tag_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextTagInfo, formatted_text_tag_info_unref)
VALA_EXTERN gpointer text_parser_ref (gpointer instance);
VALA_EXTERN void text_parser_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_text_parser (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_text_parser (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_text_parser (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_text_parser (const GValue* value);
VALA_EXTERN GType text_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextParser, text_parser_unref)
static gpointer formatted_text_tag_attr_ref (gpointer instance);
static void formatted_text_tag_attr_unref (gpointer instance);
static GParamSpec* formatted_text_param_spec_tag_attr (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags) G_GNUC_UNUSED ;
static void formatted_text_value_set_tag_attr (GValue* value,
                                        gpointer v_object) G_GNUC_UNUSED ;
static void formatted_text_value_take_tag_attr (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED ;
static gpointer formatted_text_value_get_tag_attr (const GValue* value) G_GNUC_UNUSED ;
static GType formatted_text_tag_attr_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextTagAttr, formatted_text_tag_attr_unref)
static void _text_parser_unref0_ (gpointer var);
static void _vala_TextParser_free_function_content_of (gpointer data);
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN FormattedText* formatted_text_new (DrawArea* da);
VALA_EXTERN FormattedText* formatted_text_construct (GType object_type,
                                         DrawArea* da);
static void formatted_text_initialize (FormattedText* self,
                                DrawArea* da);
VALA_EXTERN FormattedText* formatted_text_new_with_text (DrawArea* da,
                                             const gchar* txt);
VALA_EXTERN FormattedText* formatted_text_construct_with_text (GType object_type,
                                                   DrawArea* da,
                                                   const gchar* txt);
VALA_EXTERN FormattedText* formatted_text_new_copy_range (DrawArea* da,
                                              FormattedText* text,
                                              gint start,
                                              gint end);
VALA_EXTERN FormattedText* formatted_text_construct_copy_range (GType object_type,
                                                    DrawArea* da,
                                                    FormattedText* text,
                                                    gint start,
                                                    gint end);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
VALA_EXTERN GArray* formatted_text_get_tags_in_range (FormattedText* self,
                                          gint start,
                                          gint end);
static void formatted_text_tag_info_add_tag (FormattedTextTagInfo* self,
                                      gint start,
                                      gint end,
                                      const gchar* extra,
                                      gboolean parsed);
VALA_EXTERN FormattedText* formatted_text_new_copy_clean (DrawArea* da,
                                              FormattedText* other);
VALA_EXTERN FormattedText* formatted_text_construct_copy_clean (GType object_type,
                                                    DrawArea* da,
                                                    FormattedText* other);
static void formatted_text_tag_info_copy (FormattedTextTagInfo* self,
                                   FormattedTextTagInfo* other);
static gpointer formatted_text_tag_info_formatted_range_ref (gpointer instance);
static void formatted_text_tag_info_formatted_range_unref (gpointer instance);
static GParamSpec* formatted_text_tag_info_param_spec_formatted_range (const gchar* name,
                                                                const gchar* nick,
                                                                const gchar* blurb,
                                                                GType object_type,
                                                                GParamFlags flags) G_GNUC_UNUSED ;
static void formatted_text_tag_info_value_set_formatted_range (GValue* value,
                                                        gpointer v_object) G_GNUC_UNUSED ;
static void formatted_text_tag_info_value_take_formatted_range (GValue* value,
                                                         gpointer v_object) G_GNUC_UNUSED ;
static gpointer formatted_text_tag_info_value_get_formatted_range (const GValue* value) G_GNUC_UNUSED ;
VALA_EXTERN GType formatted_text_tag_info_formatted_range_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextTagInfoFormattedRange, formatted_text_tag_info_formatted_range_unref)
static GArray* formatted_text_tag_info_get_info (FormattedTextTagInfo* self);
VALA_EXTERN void formatted_text_remove_text (FormattedText* self,
                                 gint index,
                                 gint chars);
static gint formatted_text_tag_info_formatted_range_get_start (FormattedTextTagInfoFormattedRange* self);
static gint formatted_text_tag_info_formatted_range_get_end (FormattedTextTagInfoFormattedRange* self);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN Theme* draw_area_get_theme (DrawArea* self);
static FormattedTextBoldInfo* formatted_text_bold_info_new (void);
static FormattedTextBoldInfo* formatted_text_bold_info_construct (GType object_type);
static GType formatted_text_bold_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextBoldInfo, formatted_text_tag_attr_unref)
static FormattedTextItalicsInfo* formatted_text_italics_info_new (void);
static FormattedTextItalicsInfo* formatted_text_italics_info_construct (GType object_type);
static GType formatted_text_italics_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextItalicsInfo, formatted_text_tag_attr_unref)
static FormattedTextUnderlineInfo* formatted_text_underline_info_new (void);
static FormattedTextUnderlineInfo* formatted_text_underline_info_construct (GType object_type);
static GType formatted_text_underline_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextUnderlineInfo, formatted_text_tag_attr_unref)
static FormattedTextStrikeThruInfo* formatted_text_strike_thru_info_new (void);
static FormattedTextStrikeThruInfo* formatted_text_strike_thru_info_construct (GType object_type);
static GType formatted_text_strike_thru_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextStrikeThruInfo, formatted_text_tag_attr_unref)
static FormattedTextCodeInfo* formatted_text_code_info_new (DrawArea* da);
static FormattedTextCodeInfo* formatted_text_code_info_construct (GType object_type,
                                                           DrawArea* da);
static GType formatted_text_code_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextCodeInfo, formatted_text_tag_attr_unref)
static FormattedTextSubInfo* formatted_text_sub_info_new (void);
static FormattedTextSubInfo* formatted_text_sub_info_construct (GType object_type);
static GType formatted_text_sub_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextSubInfo, formatted_text_tag_attr_unref)
static FormattedTextSuperInfo* formatted_text_super_info_new (void);
static FormattedTextSuperInfo* formatted_text_super_info_construct (GType object_type);
static GType formatted_text_super_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextSuperInfo, formatted_text_tag_attr_unref)
static FormattedTextHeaderInfo* formatted_text_header_info_new (void);
static FormattedTextHeaderInfo* formatted_text_header_info_construct (GType object_type);
static GType formatted_text_header_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextHeaderInfo, formatted_text_tag_attr_unref)
static FormattedTextColorInfo* formatted_text_color_info_new (void);
static FormattedTextColorInfo* formatted_text_color_info_construct (GType object_type);
static GType formatted_text_color_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextColorInfo, formatted_text_tag_attr_unref)
static FormattedTextHighlightInfo* formatted_text_highlight_info_new (void);
static FormattedTextHighlightInfo* formatted_text_highlight_info_construct (GType object_type);
static GType formatted_text_highlight_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextHighlightInfo, formatted_text_tag_attr_unref)
VALA_EXTERN GdkRGBA* theme_get_color (Theme* self,
                          const gchar* name);
static FormattedTextUrlInfo* formatted_text_url_info_new (GdkRGBA* color);
static FormattedTextUrlInfo* formatted_text_url_info_construct (GType object_type,
                                                         GdkRGBA* color);
static GType formatted_text_url_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextUrlInfo, formatted_text_tag_attr_unref)
static void _vala_GdkRGBA_free (GdkRGBA* self);
static FormattedTextTaggingInfo* formatted_text_tagging_info_new (GdkRGBA* color);
static FormattedTextTaggingInfo* formatted_text_tagging_info_construct (GType object_type,
                                                                 GdkRGBA* color);
static GType formatted_text_tagging_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextTaggingInfo, formatted_text_tag_attr_unref)
static FormattedTextSyntaxInfo* formatted_text_syntax_info_new (GdkRGBA* color,
                                                         gboolean hide);
static FormattedTextSyntaxInfo* formatted_text_syntax_info_construct (GType object_type,
                                                               GdkRGBA* color,
                                                               gboolean hide);
static GType formatted_text_syntax_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextSyntaxInfo, formatted_text_tag_attr_unref)
static FormattedTextMatchInfo* formatted_text_match_info_new (GdkRGBA* f,
                                                       GdkRGBA* b);
static FormattedTextMatchInfo* formatted_text_match_info_construct (GType object_type,
                                                             GdkRGBA* f,
                                                             GdkRGBA* b);
static GType formatted_text_match_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextMatchInfo, formatted_text_tag_attr_unref)
static FormattedTextSelectInfo* formatted_text_select_info_new (GdkRGBA* f,
                                                         GdkRGBA* b);
static FormattedTextSelectInfo* formatted_text_select_info_construct (GType object_type,
                                                               GdkRGBA* f,
                                                               GdkRGBA* b);
static GType formatted_text_select_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedTextSelectInfo, formatted_text_tag_attr_unref)
static FormattedTextTagInfo* formatted_text_tag_info_new (void);
static FormattedTextTagInfo* formatted_text_tag_info_construct (GType object_type);
VALA_EXTERN void formatted_text_set_theme (Theme* theme);
static void formatted_text_url_info_update_color (FormattedTextUrlInfo* self,
                                           GdkRGBA* color);
static void formatted_text_tagging_info_update_color (FormattedTextTaggingInfo* self,
                                               GdkRGBA* color);
static void formatted_text_syntax_info_update_color (FormattedTextSyntaxInfo* self,
                                              GdkRGBA* color);
static void formatted_text_match_info_update_color (FormattedTextMatchInfo* self,
                                             GdkRGBA* f,
                                             GdkRGBA* b);
static void formatted_text_select_info_update_color (FormattedTextSelectInfo* self,
                                              GdkRGBA* f,
                                              GdkRGBA* b);
VALA_EXTERN void formatted_text_add_parser (FormattedText* self,
                                TextParser* parser);
static void formatted_text_handle_parser_enable_change (FormattedText* self);
static void _formatted_text_handle_parser_enable_change_text_parser_enable_changed (TextParser* _sender,
                                                                             gpointer self);
static void formatted_text_parse (FormattedText* self,
                           gboolean force_clear);
VALA_EXTERN void formatted_text_remove_parser (FormattedText* self,
                                   TextParser* parser);
VALA_EXTERN void formatted_text_copy (FormattedText* self,
                          FormattedText* other);
VALA_EXTERN void formatted_text_set_text (FormattedText* self,
                              const gchar* str);
VALA_EXTERN void formatted_text_append_text (FormattedText* self,
                                 const gchar* str);
VALA_EXTERN void formatted_text_insert_text (FormattedText* self,
                                 gint index,
                                 const gchar* str);
static void formatted_text_tag_info_adjust (FormattedTextTagInfo* self,
                                     gint index,
                                     gint length);
VALA_EXTERN void formatted_text_insert_formatted_text (FormattedText* self,
                                           gint index,
                                           FormattedText* text);
static void formatted_text_tag_info_add_tags_at_offset (FormattedTextTagInfo* self,
                                                 FormattedTextTagInfo* other,
                                                 gint offset);
VALA_EXTERN void formatted_text_replace_text (FormattedText* self,
                                  gint index,
                                  gint chars,
                                  const gchar* str);
static void formatted_text_tag_info_remove_tag (FormattedTextTagInfo* self,
                                         gint start,
                                         gint end);
VALA_EXTERN void formatted_text_add_tag (FormattedText* self,
                             FormatTag tag,
                             gint start,
                             gint end,
                             gboolean parsed,
                             const gchar* extra);
VALA_EXTERN void formatted_text_replace_tag (FormattedText* self,
                                 FormatTag tag,
                                 gint start,
                                 gint end,
                                 gboolean parsed,
                                 const gchar* extra);
static void formatted_text_tag_info_replace_tag (FormattedTextTagInfo* self,
                                          gint start,
                                          gint end,
                                          const gchar* extra,
                                          gboolean parsed);
VALA_EXTERN void formatted_text_remove_tag (FormattedText* self,
                                FormatTag tag,
                                gint start,
                                gint end);
VALA_EXTERN void formatted_text_remove_parsed_tags (FormattedText* self,
                                        FormatTag tag);
static void formatted_text_tag_info_remove_parsed_tags (FormattedTextTagInfo* self);
VALA_EXTERN void formatted_text_remove_tag_all (FormattedText* self,
                                    FormatTag tag);
static void formatted_text_tag_info_remove_tag_all (FormattedTextTagInfo* self);
VALA_EXTERN void formatted_text_remove_all_tags (FormattedText* self,
                                     gint start,
                                     gint end);
VALA_EXTERN gboolean formatted_text_is_tag_applied_at_index (FormattedText* self,
                                                 FormatTag tag,
                                                 gint index);
static gboolean formatted_text_tag_info_is_applied_at_index (FormattedTextTagInfo* self,
                                                      gint index);
VALA_EXTERN gboolean formatted_text_is_tag_applied_in_range (FormattedText* self,
                                                 FormatTag tag,
                                                 gint start,
                                                 gint end);
static gboolean formatted_text_tag_info_is_applied_in_range (FormattedTextTagInfo* self,
                                                      gint start,
                                                      gint end);
VALA_EXTERN gboolean formatted_text_tags_exist (FormattedText* self);
static gboolean formatted_text_tag_info_is_empty (FormattedTextTagInfo* self);
VALA_EXTERN gboolean formatted_text_contains_tag (FormattedText* self,
                                      FormatTag tag,
                                      const gchar* extra);
static gboolean formatted_text_tag_info_contains_tag (FormattedTextTagInfo* self,
                                               const gchar* extra);
VALA_EXTERN GeeHashMap* formatted_text_get_extras_for_tag (FormattedText* self,
                                               FormatTag tag);
static void formatted_text_tag_info_get_extras_for_tag (FormattedTextTagInfo* self,
                                                 GeeHashMap** extras);
VALA_EXTERN GArray* formatted_text_get_full_tags_in_range (FormattedText* self,
                                               FormatTag tag,
                                               gint start,
                                               gint end);
static void _undo_tag_info_unref0_ (gpointer var);
static void _vala_UndoTagInfo_free_function_content_of (gpointer data);
static void formatted_text_tag_info_get_full_tags_in_range (FormattedTextTagInfo* self,
                                                     gint tag,
                                                     gint start,
                                                     gint end,
                                                     GArray** tags);
static void formatted_text_tag_info_get_tags_in_range (FormattedTextTagInfo* self,
                                                gint tag,
                                                gint start,
                                                gint end,
                                                GArray** tags);
VALA_EXTERN void formatted_text_apply_tags (FormattedText* self,
                                GArray* tags,
                                gint start);
VALA_EXTERN PangoAttrList* formatted_text_get_attributes (FormattedText* self);
static void formatted_text_tag_info_get_attributes (FormattedTextTagInfo* self,
                                             FormattedTextTagAttr* tag_attr,
                                             PangoAttrList** attrs);
VALA_EXTERN PangoAttrList* formatted_text_get_attributes_from_theme (FormattedText* self,
                                                         Theme* theme);
VALA_EXTERN void formatted_text_to_buffer (FormattedText* self,
                               GtkTextBuffer* buf,
                               gint start,
                               gint end);
static GtkTextTag* formatted_text_tag_attr_text_tag (FormattedTextTagAttr* self,
                                              const gchar* extra);
VALA_EXTERN gchar* formatted_text_get_extra (FormattedText* self,
                                 FormatTag tag,
                                 gint index);
static gchar* formatted_text_tag_info_get_extra (FormattedTextTagInfo* self,
                                          gint index);
VALA_EXTERN void formatted_text_get_extra_parsed (FormattedText* self,
                                      FormatTag tag,
                                      gint index,
                                      gchar** extra,
                                      gboolean* parsed);
static void formatted_text_tag_info_get_extra_parsed (FormattedTextTagInfo* self,
                                               gint index,
                                               gchar** extra,
                                               gboolean* parsed);
VALA_EXTERN gchar* formatted_text_get_first_extra_in_range (FormattedText* self,
                                                FormatTag tag,
                                                gint start,
                                                gint end);
static gchar* formatted_text_tag_info_get_first_extra_in_range (FormattedTextTagInfo* self,
                                                         gint start,
                                                         gint end);
VALA_EXTERN gboolean formatted_text_do_search (FormattedText* self,
                                   const gchar* pattern);
VALA_EXTERN void text_parser_parse (TextParser* self,
                        FormattedText* text);
VALA_EXTERN xmlNode* formatted_text_save (FormattedText* self);
static gboolean formatted_text_tag_info_save_needed (FormattedTextTagInfo* self);
static xmlNode* formatted_text_tag_info_save (FormattedTextTagInfo* self,
                                       const gchar* tag);
VALA_EXTERN gchar* formatted_text_xml_text (xmlNode* n);
VALA_EXTERN void formatted_text_load (FormattedText* self,
                          xmlNode* n);
static void formatted_text_tag_info_load (FormattedTextTagInfo* self,
                                   xmlNode* n);
static void _formatted_text_tag_info_formatted_range_unref0_ (gpointer var);
static void _vala_FormattedTextTagInfoFormattedRange_free_function_content_of (gpointer data);
static const gchar* formatted_text_tag_info_formatted_range_get_extra (FormattedTextTagInfoFormattedRange* self);
static gboolean formatted_text_tag_info_formatted_range_get_parsed (FormattedTextTagInfoFormattedRange* self);
static FormattedTextTagInfoFormattedRange* formatted_text_tag_info_formatted_range_new (gint s,
                                                                                 gint e,
                                                                                 const gchar* x,
                                                                                 gboolean p);
static FormattedTextTagInfoFormattedRange* formatted_text_tag_info_formatted_range_construct (GType object_type,
                                                                                       gint s,
                                                                                       gint e,
                                                                                       const gchar* x,
                                                                                       gboolean p);
static void formatted_text_tag_info_formatted_range_set_start (FormattedTextTagInfoFormattedRange* self,
                                                        gint value);
static void formatted_text_tag_info_formatted_range_set_end (FormattedTextTagInfoFormattedRange* self,
                                                      gint value);
static gboolean formatted_text_tag_info_formatted_range_combine (FormattedTextTagInfoFormattedRange* self,
                                                          gint s,
                                                          gint e,
                                                          const gchar* x);
static gint formatted_text_tag_info_formatted_range_compare (void* x,
                                                      void* y);
static void formatted_text_tag_attr_add_attrs (FormattedTextTagAttr* self,
                                        PangoAttrList** list,
                                        gint start,
                                        gint end,
                                        const gchar* extra);
static xmlNode* formatted_text_tag_info_formatted_range_save (FormattedTextTagInfoFormattedRange* self);
static FormattedTextTagInfoFormattedRange* formatted_text_tag_info_formatted_range_new_from_xml (xmlNode* n);
static FormattedTextTagInfoFormattedRange* formatted_text_tag_info_formatted_range_construct_from_xml (GType object_type,
                                                                                                xmlNode* n);
static void formatted_text_tag_info_formatted_range_set_extra (FormattedTextTagInfoFormattedRange* self,
                                                        const gchar* value);
static void formatted_text_tag_info_formatted_range_set_parsed (FormattedTextTagInfoFormattedRange* self,
                                                         gboolean value);
static void formatted_text_tag_info_formatted_range_load (FormattedTextTagInfoFormattedRange* self,
                                                   xmlNode* n);
static void formatted_text_tag_info_formatted_range_finalize (FormattedTextTagInfoFormattedRange * obj);
static GType formatted_text_tag_info_formatted_range_get_type_once (void);
static void formatted_text_tag_info_finalize (FormattedTextTagInfo * obj);
static GType formatted_text_tag_info_get_type_once (void);
static FormattedTextTagAttr* formatted_text_tag_attr_new (void);
static FormattedTextTagAttr* formatted_text_tag_attr_construct (GType object_type);
static void _pango_attribute_destroy0_ (gpointer var);
static void _vala_PangoAttribute_free_function_content_of (gpointer data);
static FormattedTextTagAttr* formatted_text_tag_attr_new_copy_from (FormattedTextTagAttr* ta);
static FormattedTextTagAttr* formatted_text_tag_attr_construct_copy_from (GType object_type,
                                                                   FormattedTextTagAttr* ta);
static void formatted_text_tag_attr_real_add_attrs (FormattedTextTagAttr* self,
                                             PangoAttrList** list,
                                             gint start,
                                             gint end,
                                             const gchar* extra);
static GtkTextTag* formatted_text_tag_attr_real_text_tag (FormattedTextTagAttr* self,
                                                   const gchar* extra);
static void formatted_text_tag_attr_get_color (FormattedTextTagAttr* self,
                                        const gchar* value,
                                        GdkRGBA* result);
static void formatted_text_tag_attr_finalize (FormattedTextTagAttr * obj);
static GType formatted_text_tag_attr_get_type_once (void);
static GtkTextTag* formatted_text_bold_info_real_text_tag (FormattedTextTagAttr* base,
                                                    const gchar* extra);
static GType formatted_text_bold_info_get_type_once (void);
static GtkTextTag* formatted_text_italics_info_real_text_tag (FormattedTextTagAttr* base,
                                                       const gchar* extra);
static GType formatted_text_italics_info_get_type_once (void);
static GtkTextTag* formatted_text_underline_info_real_text_tag (FormattedTextTagAttr* base,
                                                         const gchar* extra);
static GType formatted_text_underline_info_get_type_once (void);
static GtkTextTag* formatted_text_strike_thru_info_real_text_tag (FormattedTextTagAttr* base,
                                                           const gchar* extra);
static GType formatted_text_strike_thru_info_get_type_once (void);
static GtkTextTag* formatted_text_code_info_real_text_tag (FormattedTextTagAttr* base,
                                                    const gchar* extra);
static GType formatted_text_code_info_get_type_once (void);
static GtkTextTag* formatted_text_sub_info_real_text_tag (FormattedTextTagAttr* base,
                                                   const gchar* extra);
static GType formatted_text_sub_info_get_type_once (void);
static GtkTextTag* formatted_text_super_info_real_text_tag (FormattedTextTagAttr* base,
                                                     const gchar* extra);
static GType formatted_text_super_info_get_type_once (void);
static gdouble formatted_text_header_info_get_scale_factor (FormattedTextHeaderInfo* self,
                                                     const gchar* extra);
static void formatted_text_header_info_real_add_attrs (FormattedTextTagAttr* base,
                                                PangoAttrList** list,
                                                gint start,
                                                gint end,
                                                const gchar* extra);
static GtkTextTag* formatted_text_header_info_real_text_tag (FormattedTextTagAttr* base,
                                                      const gchar* extra);
static GType formatted_text_header_info_get_type_once (void);
static void formatted_text_color_info_real_add_attrs (FormattedTextTagAttr* base,
                                               PangoAttrList** list,
                                               gint start,
                                               gint end,
                                               const gchar* extra);
static GtkTextTag* formatted_text_color_info_real_text_tag (FormattedTextTagAttr* base,
                                                     const gchar* extra);
static GType formatted_text_color_info_get_type_once (void);
static void formatted_text_highlight_info_real_add_attrs (FormattedTextTagAttr* base,
                                                   PangoAttrList** list,
                                                   gint start,
                                                   gint end,
                                                   const gchar* extra);
static GtkTextTag* formatted_text_highlight_info_real_text_tag (FormattedTextTagAttr* base,
                                                         const gchar* extra);
static GType formatted_text_highlight_info_get_type_once (void);
static void formatted_text_url_info_set_color (FormattedTextUrlInfo* self,
                                        GdkRGBA* color);
static GtkTextTag* formatted_text_url_info_real_text_tag (FormattedTextTagAttr* base,
                                                   const gchar* extra);
VALA_EXTERN gchar* utils_color_from_rgba (GdkRGBA* rgba);
static void formatted_text_url_info_finalize (FormattedTextTagAttr * obj);
static GType formatted_text_url_info_get_type_once (void);
static void formatted_text_tagging_info_set_color (FormattedTextTaggingInfo* self,
                                            GdkRGBA* color);
static GtkTextTag* formatted_text_tagging_info_real_text_tag (FormattedTextTagAttr* base,
                                                       const gchar* extra);
static void formatted_text_tagging_info_finalize (FormattedTextTagAttr * obj);
static GType formatted_text_tagging_info_get_type_once (void);
static void formatted_text_syntax_info_set_color (FormattedTextSyntaxInfo* self,
                                           GdkRGBA* color,
                                           gboolean hide);
static GtkTextTag* formatted_text_syntax_info_real_text_tag (FormattedTextTagAttr* base,
                                                      const gchar* extra);
static void formatted_text_syntax_info_finalize (FormattedTextTagAttr * obj);
static GType formatted_text_syntax_info_get_type_once (void);
static void formatted_text_match_info_set_color (FormattedTextMatchInfo* self,
                                          GdkRGBA* f,
                                          GdkRGBA* b);
static GType formatted_text_match_info_get_type_once (void);
static void formatted_text_select_info_set_color (FormattedTextSelectInfo* self,
                                           GdkRGBA* f,
                                           GdkRGBA* b);
static GType formatted_text_select_info_get_type_once (void);
static void formatted_text_finalize (FormattedText * obj);
static GType formatted_text_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

gchar*
format_tag_to_string (FormatTag self)
{
	gchar* _tmp14_;
	gchar* result;
	switch (self) {
		case FORMAT_TAG_BOLD:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("bold");
			result = _tmp0_;
			return result;
		}
		case FORMAT_TAG_ITALICS:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("italics");
			result = _tmp1_;
			return result;
		}
		case FORMAT_TAG_UNDERLINE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("underline");
			result = _tmp2_;
			return result;
		}
		case FORMAT_TAG_STRIKETHRU:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("strikethru");
			result = _tmp3_;
			return result;
		}
		case FORMAT_TAG_CODE:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("code");
			result = _tmp4_;
			return result;
		}
		case FORMAT_TAG_SUB:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("subscript");
			result = _tmp5_;
			return result;
		}
		case FORMAT_TAG_SUPER:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("superscript");
			result = _tmp6_;
			return result;
		}
		case FORMAT_TAG_HEADER:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("header");
			result = _tmp7_;
			return result;
		}
		case FORMAT_TAG_COLOR:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("color");
			result = _tmp8_;
			return result;
		}
		case FORMAT_TAG_HILITE:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("hilite");
			result = _tmp9_;
			return result;
		}
		case FORMAT_TAG_URL:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("url");
			result = _tmp10_;
			return result;
		}
		case FORMAT_TAG_TAG:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("tag");
			result = _tmp11_;
			return result;
		}
		case FORMAT_TAG_SYNTAX:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("syntax");
			result = _tmp12_;
			return result;
		}
		case FORMAT_TAG_MATCH:
		{
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("match");
			result = _tmp13_;
			return result;
		}
		default:
		break;
	}
	_tmp14_ = g_strdup ("bold");
	result = _tmp14_;
	return result;
}

FormatTag
format_tag_from_string (const gchar* str)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	static GQuark _tmp1_label9 = 0;
	static GQuark _tmp1_label10 = 0;
	static GQuark _tmp1_label11 = 0;
	static GQuark _tmp1_label12 = 0;
	static GQuark _tmp1_label13 = 0;
	FormatTag result;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = str;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("bold")))) {
		switch (0) {
			default:
			{
				result = FORMAT_TAG_BOLD;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("italics")))) {
		switch (0) {
			default:
			{
				result = FORMAT_TAG_ITALICS;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("underline")))) {
		switch (0) {
			default:
			{
				result = FORMAT_TAG_UNDERLINE;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("strikethru")))) {
		switch (0) {
			default:
			{
				result = FORMAT_TAG_STRIKETHRU;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("code")))) {
		switch (0) {
			default:
			{
				result = FORMAT_TAG_CODE;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("subscript")))) {
		switch (0) {
			default:
			{
				result = FORMAT_TAG_SUB;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("superscript")))) {
		switch (0) {
			default:
			{
				result = FORMAT_TAG_SUPER;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("header")))) {
		switch (0) {
			default:
			{
				result = FORMAT_TAG_HEADER;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("color")))) {
		switch (0) {
			default:
			{
				result = FORMAT_TAG_COLOR;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("hilite")))) {
		switch (0) {
			default:
			{
				result = FORMAT_TAG_HILITE;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("url")))) {
		switch (0) {
			default:
			{
				result = FORMAT_TAG_URL;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string ("tag")))) {
		switch (0) {
			default:
			{
				result = FORMAT_TAG_TAG;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label12) ? _tmp1_label12 : (_tmp1_label12 = g_quark_from_static_string ("syntax")))) {
		switch (0) {
			default:
			{
				result = FORMAT_TAG_SYNTAX;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label13) ? _tmp1_label13 : (_tmp1_label13 = g_quark_from_static_string ("match")))) {
		switch (0) {
			default:
			{
				result = FORMAT_TAG_MATCH;
				return result;
			}
		}
	}
	result = FORMAT_TAG_LENGTH;
	return result;
}

static GType
format_tag_get_type_once (void)
{
	static const GEnumValue values[] = {{FORMAT_TAG_BOLD, "FORMAT_TAG_BOLD", "bold"}, {FORMAT_TAG_ITALICS, "FORMAT_TAG_ITALICS", "italics"}, {FORMAT_TAG_UNDERLINE, "FORMAT_TAG_UNDERLINE", "underline"}, {FORMAT_TAG_STRIKETHRU, "FORMAT_TAG_STRIKETHRU", "strikethru"}, {FORMAT_TAG_CODE, "FORMAT_TAG_CODE", "code"}, {FORMAT_TAG_SUB, "FORMAT_TAG_SUB", "sub"}, {FORMAT_TAG_SUPER, "FORMAT_TAG_SUPER", "super"}, {FORMAT_TAG_HEADER, "FORMAT_TAG_HEADER", "header"}, {FORMAT_TAG_COLOR, "FORMAT_TAG_COLOR", "color"}, {FORMAT_TAG_HILITE, "FORMAT_TAG_HILITE", "hilite"}, {FORMAT_TAG_URL, "FORMAT_TAG_URL", "url"}, {FORMAT_TAG_SYNTAX, "FORMAT_TAG_SYNTAX", "syntax"}, {FORMAT_TAG_TAG, "FORMAT_TAG_TAG", "tag"}, {FORMAT_TAG_MATCH, "FORMAT_TAG_MATCH", "match"}, {FORMAT_TAG_SELECT, "FORMAT_TAG_SELECT", "select"}, {FORMAT_TAG_LENGTH, "FORMAT_TAG_LENGTH", "length"}, {0, NULL, NULL}};
	GType format_tag_type_id;
	format_tag_type_id = g_enum_register_static ("FormatTag", values);
	return format_tag_type_id;
}

GType
format_tag_get_type (void)
{
	static volatile gsize format_tag_type_id__once = 0;
	if (g_once_init_enter (&format_tag_type_id__once)) {
		GType format_tag_type_id;
		format_tag_type_id = format_tag_get_type_once ();
		g_once_init_leave (&format_tag_type_id__once, format_tag_type_id);
	}
	return format_tag_type_id__once;
}

static inline gpointer
undo_tag_info_get_instance_private (UndoTagInfo* self)
{
	return G_STRUCT_MEMBER_P (self, UndoTagInfo_private_offset);
}

UndoTagInfo*
undo_tag_info_construct (GType object_type,
                         gint tag,
                         gint start,
                         gint end,
                         const gchar* extra,
                         gboolean parsed)
{
	UndoTagInfo* self = NULL;
	self = (UndoTagInfo*) g_type_create_instance (object_type);
	undo_tag_info_set_tag (self, tag);
	undo_tag_info_set_start (self, start);
	undo_tag_info_set_end (self, end);
	undo_tag_info_set_parsed (self, parsed);
	undo_tag_info_set_extra (self, extra);
	return self;
}

UndoTagInfo*
undo_tag_info_new (gint tag,
                   gint start,
                   gint end,
                   const gchar* extra,
                   gboolean parsed)
{
	return undo_tag_info_construct (TYPE_UNDO_TAG_INFO, tag, start, end, extra, parsed);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

gchar*
undo_tag_info_to_string (UndoTagInfo* self)
{
	gint _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tag;
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_start;
	_tmp4_ = self->priv->_end;
	_tmp5_ = self->priv->_extra;
	_tmp6_ = self->priv->_parsed;
	_tmp7_ = bool_to_string (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("tag: %s, start: %d, end: %d, extra: %s, parsed: %s", _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp2_);
	result = _tmp10_;
	return result;
}

gint
undo_tag_info_get_start (UndoTagInfo* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_start;
	return result;
}

static void
undo_tag_info_set_start (UndoTagInfo* self,
                         gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_start = value;
}

gint
undo_tag_info_get_end (UndoTagInfo* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_end;
	return result;
}

static void
undo_tag_info_set_end (UndoTagInfo* self,
                       gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_end = value;
}

gint
undo_tag_info_get_tag (UndoTagInfo* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_tag;
	return result;
}

static void
undo_tag_info_set_tag (UndoTagInfo* self,
                       gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tag = value;
}

gboolean
undo_tag_info_get_parsed (UndoTagInfo* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_parsed;
	return result;
}

static void
undo_tag_info_set_parsed (UndoTagInfo* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_parsed = value;
}

const gchar*
undo_tag_info_get_extra (UndoTagInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extra;
	result = _tmp0_;
	return result;
}

static void
undo_tag_info_set_extra (UndoTagInfo* self,
                         const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_extra);
	self->priv->_extra = _tmp0_;
}

static void
value_undo_tag_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_undo_tag_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		undo_tag_info_unref (value->data[0].v_pointer);
	}
}

static void
value_undo_tag_info_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = undo_tag_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_undo_tag_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_undo_tag_info_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UndoTagInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = undo_tag_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_undo_tag_info_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	UndoTagInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = undo_tag_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_undo_tag_info (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ParamSpecUndoTagInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_UNDO_TAG_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_undo_tag_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNDO_TAG_INFO), NULL);
	return value->data[0].v_pointer;
}

void
value_set_undo_tag_info (GValue* value,
                         gpointer v_object)
{
	UndoTagInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNDO_TAG_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UNDO_TAG_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		undo_tag_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		undo_tag_info_unref (old);
	}
}

void
value_take_undo_tag_info (GValue* value,
                          gpointer v_object)
{
	UndoTagInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNDO_TAG_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UNDO_TAG_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		undo_tag_info_unref (old);
	}
}

static void
undo_tag_info_class_init (UndoTagInfoClass * klass,
                          gpointer klass_data)
{
	undo_tag_info_parent_class = g_type_class_peek_parent (klass);
	((UndoTagInfoClass *) klass)->finalize = undo_tag_info_finalize;
	g_type_class_adjust_private_offset (klass, &UndoTagInfo_private_offset);
}

static void
undo_tag_info_instance_init (UndoTagInfo * self,
                             gpointer klass)
{
	self->priv = undo_tag_info_get_instance_private (self);
	self->ref_count = 1;
}

static void
undo_tag_info_finalize (UndoTagInfo * obj)
{
	UndoTagInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNDO_TAG_INFO, UndoTagInfo);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_extra);
}

static GType
undo_tag_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_undo_tag_info_init, value_undo_tag_info_free_value, value_undo_tag_info_copy_value, value_undo_tag_info_peek_pointer, "p", value_undo_tag_info_collect_value, "p", value_undo_tag_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UndoTagInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) undo_tag_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UndoTagInfo), 0, (GInstanceInitFunc) undo_tag_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType undo_tag_info_type_id;
	undo_tag_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UndoTagInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	UndoTagInfo_private_offset = g_type_add_instance_private (undo_tag_info_type_id, sizeof (UndoTagInfoPrivate));
	return undo_tag_info_type_id;
}

GType
undo_tag_info_get_type (void)
{
	static volatile gsize undo_tag_info_type_id__once = 0;
	if (g_once_init_enter (&undo_tag_info_type_id__once)) {
		GType undo_tag_info_type_id;
		undo_tag_info_type_id = undo_tag_info_get_type_once ();
		g_once_init_leave (&undo_tag_info_type_id__once, undo_tag_info_type_id);
	}
	return undo_tag_info_type_id__once;
}

gpointer
undo_tag_info_ref (gpointer instance)
{
	UndoTagInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
undo_tag_info_unref (gpointer instance)
{
	UndoTagInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNDO_TAG_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
formatted_text_get_instance_private (FormattedText* self)
{
	return G_STRUCT_MEMBER_P (self, FormattedText_private_offset);
}

static void
_text_parser_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (text_parser_unref (var), NULL));
}

static void
_vala_TextParser_free_function_content_of (gpointer data)
{
	TextParser* self;
	self = *((TextParser**) data);
	_text_parser_unref0_ (self);
}

FormattedText*
formatted_text_construct (GType object_type,
                          DrawArea* da)
{
	FormattedText* self = NULL;
	g_return_val_if_fail (da != NULL, NULL);
	self = (FormattedText*) g_type_create_instance (object_type);
	formatted_text_initialize (self, da);
	return self;
}

FormattedText*
formatted_text_new (DrawArea* da)
{
	return formatted_text_construct (TYPE_FORMATTED_TEXT, da);
}

FormattedText*
formatted_text_construct_with_text (GType object_type,
                                    DrawArea* da,
                                    const gchar* txt)
{
	FormattedText* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (txt != NULL, NULL);
	self = (FormattedText*) g_type_create_instance (object_type);
	formatted_text_initialize (self, da);
	_tmp0_ = g_strdup (txt);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp0_;
	return self;
}

FormattedText*
formatted_text_new_with_text (DrawArea* da,
                              const gchar* txt)
{
	return formatted_text_construct_with_text (TYPE_FORMATTED_TEXT, da, txt);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gpointer
_undo_tag_info_ref0 (gpointer self)
{
	return self ? undo_tag_info_ref (self) : NULL;
}

FormattedText*
formatted_text_construct_copy_range (GType object_type,
                                     DrawArea* da,
                                     FormattedText* text,
                                     gint start,
                                     gint end)
{
	FormattedText* self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GArray* tags = NULL;
	GArray* _tmp3_;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	self = (FormattedText*) g_type_create_instance (object_type);
	formatted_text_initialize (self, da);
	_tmp0_ = formatted_text_get_text (text);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_slice (_tmp1_, (glong) start, (glong) end);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp2_;
	_tmp3_ = formatted_text_get_tags_in_range (text, start, end);
	tags = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GArray* _tmp6_;
				UndoTagInfo* tag = NULL;
				GArray* _tmp7_;
				UndoTagInfo* _tmp8_;
				UndoTagInfo* _tmp9_;
				FormattedTextTagInfo** _tmp10_;
				gint _tmp10__length1;
				UndoTagInfo* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				FormattedTextTagInfo* _tmp14_;
				UndoTagInfo* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				UndoTagInfo* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				UndoTagInfo* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				UndoTagInfo* _tmp24_;
				gboolean _tmp25_;
				gboolean _tmp26_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = tags;
				if (!(((guint) i) < _tmp6_->len)) {
					break;
				}
				_tmp7_ = tags;
				_tmp8_ = g_array_index (_tmp7_, UndoTagInfo*, (guint) i);
				_tmp9_ = _undo_tag_info_ref0 (_tmp8_);
				tag = _tmp9_;
				_tmp10_ = self->priv->_formats;
				_tmp10__length1 = self->priv->_formats_length1;
				_tmp11_ = tag;
				_tmp12_ = undo_tag_info_get_tag (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = _tmp10_[_tmp13_];
				_tmp15_ = tag;
				_tmp16_ = undo_tag_info_get_start (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = tag;
				_tmp19_ = undo_tag_info_get_end (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = tag;
				_tmp22_ = undo_tag_info_get_extra (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = tag;
				_tmp25_ = undo_tag_info_get_parsed (_tmp24_);
				_tmp26_ = _tmp25_;
				formatted_text_tag_info_add_tag (_tmp14_, _tmp17_ - start, _tmp20_ - start, _tmp23_, _tmp26_);
				_undo_tag_info_unref0 (tag);
			}
		}
	}
	_g_array_unref0 (tags);
	return self;
}

FormattedText*
formatted_text_new_copy_range (DrawArea* da,
                               FormattedText* text,
                               gint start,
                               gint end)
{
	return formatted_text_construct_copy_range (TYPE_FORMATTED_TEXT, da, text, start, end);
}

static gpointer
_g_array_ref0 (gpointer self)
{
	return self ? g_array_ref (self) : NULL;
}

static gpointer
_formatted_text_tag_info_formatted_range_ref0 (gpointer self)
{
	return self ? formatted_text_tag_info_formatted_range_ref (self) : NULL;
}

FormattedText*
formatted_text_construct_copy_clean (GType object_type,
                                     DrawArea* da,
                                     FormattedText* other)
{
	FormattedText* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GArray* ranges = NULL;
	FormattedTextTagInfo** _tmp8_;
	gint _tmp8__length1;
	FormattedTextTagInfo* _tmp9_;
	GArray* _tmp10_;
	GArray* _tmp11_;
	GArray* _tmp12_;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (other != NULL, NULL);
	self = (FormattedText*) g_type_create_instance (object_type);
	formatted_text_initialize (self, da);
	_tmp0_ = other->priv->_text;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				FormattedTextTagInfo** _tmp4_;
				gint _tmp4__length1;
				FormattedTextTagInfo* _tmp5_;
				FormattedTextTagInfo** _tmp6_;
				gint _tmp6__length1;
				FormattedTextTagInfo* _tmp7_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < ((gint) (FORMAT_TAG_LENGTH - 3)))) {
					break;
				}
				_tmp4_ = self->priv->_formats;
				_tmp4__length1 = self->priv->_formats_length1;
				_tmp5_ = _tmp4_[i];
				_tmp6_ = other->priv->_formats;
				_tmp6__length1 = other->priv->_formats_length1;
				_tmp7_ = _tmp6_[i];
				formatted_text_tag_info_copy (_tmp5_, _tmp7_);
			}
		}
	}
	_tmp8_ = other->priv->_formats;
	_tmp8__length1 = other->priv->_formats_length1;
	_tmp9_ = _tmp8_[FORMAT_TAG_SYNTAX];
	_tmp10_ = formatted_text_tag_info_get_info (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _g_array_ref0 (_tmp11_);
	ranges = _tmp12_;
	{
		gint i = 0;
		GArray* _tmp13_;
		_tmp13_ = ranges;
		i = (gint) (_tmp13_->len - 1);
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				FormattedTextTagInfoFormattedRange* range = NULL;
				GArray* _tmp16_;
				FormattedTextTagInfoFormattedRange* _tmp17_;
				FormattedTextTagInfoFormattedRange* _tmp18_;
				FormattedTextTagInfoFormattedRange* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				FormattedTextTagInfoFormattedRange* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				FormattedTextTagInfoFormattedRange* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ - 1;
				}
				_tmp14_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp16_ = ranges;
				_tmp17_ = g_array_index (_tmp16_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp18_ = _formatted_text_tag_info_formatted_range_ref0 (_tmp17_);
				range = _tmp18_;
				_tmp19_ = range;
				_tmp20_ = formatted_text_tag_info_formatted_range_get_start (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = range;
				_tmp23_ = formatted_text_tag_info_formatted_range_get_end (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = range;
				_tmp26_ = formatted_text_tag_info_formatted_range_get_start (_tmp25_);
				_tmp27_ = _tmp26_;
				formatted_text_remove_text (self, _tmp21_, _tmp24_ - _tmp27_);
				_formatted_text_tag_info_formatted_range_unref0 (range);
			}
		}
	}
	_g_array_unref0 (ranges);
	return self;
}

FormattedText*
formatted_text_new_copy_clean (DrawArea* da,
                               FormattedText* other)
{
	return formatted_text_construct_copy_clean (TYPE_FORMATTED_TEXT, da, other);
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

static void
formatted_text_initialize (FormattedText* self,
                           DrawArea* da)
{
	FormattedTextTagAttr** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	_tmp0_ = formatted_text__attr_tags;
	_tmp0__length1 = formatted_text__attr_tags_length1;
	if (_tmp0_ == NULL) {
		Theme* theme = NULL;
		Theme* _tmp1_;
		FormattedTextTagAttr** _tmp2_;
		FormattedTextTagAttr** _tmp3_;
		gint _tmp3__length1;
		FormattedTextBoldInfo* _tmp4_;
		FormattedTextTagAttr** _tmp5_;
		gint _tmp5__length1;
		FormattedTextItalicsInfo* _tmp6_;
		FormattedTextTagAttr** _tmp7_;
		gint _tmp7__length1;
		FormattedTextUnderlineInfo* _tmp8_;
		FormattedTextTagAttr** _tmp9_;
		gint _tmp9__length1;
		FormattedTextStrikeThruInfo* _tmp10_;
		FormattedTextTagAttr** _tmp11_;
		gint _tmp11__length1;
		FormattedTextCodeInfo* _tmp12_;
		FormattedTextTagAttr** _tmp13_;
		gint _tmp13__length1;
		FormattedTextSubInfo* _tmp14_;
		FormattedTextTagAttr** _tmp15_;
		gint _tmp15__length1;
		FormattedTextSuperInfo* _tmp16_;
		FormattedTextTagAttr** _tmp17_;
		gint _tmp17__length1;
		FormattedTextHeaderInfo* _tmp18_;
		FormattedTextTagAttr** _tmp19_;
		gint _tmp19__length1;
		FormattedTextColorInfo* _tmp20_;
		FormattedTextTagAttr** _tmp21_;
		gint _tmp21__length1;
		FormattedTextHighlightInfo* _tmp22_;
		FormattedTextTagAttr** _tmp23_;
		gint _tmp23__length1;
		Theme* _tmp24_;
		GdkRGBA* _tmp25_;
		GdkRGBA* _tmp26_;
		GdkRGBA _tmp27_;
		FormattedTextUrlInfo* _tmp28_;
		FormattedTextTagAttr** _tmp29_;
		gint _tmp29__length1;
		Theme* _tmp30_;
		GdkRGBA* _tmp31_;
		GdkRGBA* _tmp32_;
		GdkRGBA _tmp33_;
		FormattedTextTaggingInfo* _tmp34_;
		FormattedTextTagAttr** _tmp35_;
		gint _tmp35__length1;
		Theme* _tmp36_;
		GdkRGBA* _tmp37_;
		GdkRGBA* _tmp38_;
		GdkRGBA _tmp39_;
		FormattedTextSyntaxInfo* _tmp40_;
		FormattedTextTagAttr** _tmp41_;
		gint _tmp41__length1;
		Theme* _tmp42_;
		GdkRGBA* _tmp43_;
		GdkRGBA* _tmp44_;
		Theme* _tmp45_;
		GdkRGBA* _tmp46_;
		GdkRGBA* _tmp47_;
		GdkRGBA _tmp48_;
		GdkRGBA _tmp49_;
		FormattedTextMatchInfo* _tmp50_;
		FormattedTextTagAttr** _tmp51_;
		gint _tmp51__length1;
		Theme* _tmp52_;
		GdkRGBA* _tmp53_;
		GdkRGBA* _tmp54_;
		Theme* _tmp55_;
		GdkRGBA* _tmp56_;
		GdkRGBA* _tmp57_;
		GdkRGBA _tmp58_;
		GdkRGBA _tmp59_;
		FormattedTextSelectInfo* _tmp60_;
		_tmp1_ = draw_area_get_theme (da);
		theme = _tmp1_;
		_tmp2_ = g_new0 (FormattedTextTagAttr*, FORMAT_TAG_LENGTH + 1);
		formatted_text__attr_tags = (_vala_array_free (formatted_text__attr_tags, formatted_text__attr_tags_length1, (GDestroyNotify) formatted_text_tag_attr_unref), NULL);
		formatted_text__attr_tags = _tmp2_;
		formatted_text__attr_tags_length1 = FORMAT_TAG_LENGTH;
		_formatted_text__attr_tags_size_ = formatted_text__attr_tags_length1;
		_tmp3_ = formatted_text__attr_tags;
		_tmp3__length1 = formatted_text__attr_tags_length1;
		_tmp4_ = formatted_text_bold_info_new ();
		_formatted_text_tag_attr_unref0 (_tmp3_[FORMAT_TAG_BOLD]);
		_tmp3_[FORMAT_TAG_BOLD] = (FormattedTextTagAttr*) _tmp4_;
		_tmp5_ = formatted_text__attr_tags;
		_tmp5__length1 = formatted_text__attr_tags_length1;
		_tmp6_ = formatted_text_italics_info_new ();
		_formatted_text_tag_attr_unref0 (_tmp5_[FORMAT_TAG_ITALICS]);
		_tmp5_[FORMAT_TAG_ITALICS] = (FormattedTextTagAttr*) _tmp6_;
		_tmp7_ = formatted_text__attr_tags;
		_tmp7__length1 = formatted_text__attr_tags_length1;
		_tmp8_ = formatted_text_underline_info_new ();
		_formatted_text_tag_attr_unref0 (_tmp7_[FORMAT_TAG_UNDERLINE]);
		_tmp7_[FORMAT_TAG_UNDERLINE] = (FormattedTextTagAttr*) _tmp8_;
		_tmp9_ = formatted_text__attr_tags;
		_tmp9__length1 = formatted_text__attr_tags_length1;
		_tmp10_ = formatted_text_strike_thru_info_new ();
		_formatted_text_tag_attr_unref0 (_tmp9_[FORMAT_TAG_STRIKETHRU]);
		_tmp9_[FORMAT_TAG_STRIKETHRU] = (FormattedTextTagAttr*) _tmp10_;
		_tmp11_ = formatted_text__attr_tags;
		_tmp11__length1 = formatted_text__attr_tags_length1;
		_tmp12_ = formatted_text_code_info_new (da);
		_formatted_text_tag_attr_unref0 (_tmp11_[FORMAT_TAG_CODE]);
		_tmp11_[FORMAT_TAG_CODE] = (FormattedTextTagAttr*) _tmp12_;
		_tmp13_ = formatted_text__attr_tags;
		_tmp13__length1 = formatted_text__attr_tags_length1;
		_tmp14_ = formatted_text_sub_info_new ();
		_formatted_text_tag_attr_unref0 (_tmp13_[FORMAT_TAG_SUB]);
		_tmp13_[FORMAT_TAG_SUB] = (FormattedTextTagAttr*) _tmp14_;
		_tmp15_ = formatted_text__attr_tags;
		_tmp15__length1 = formatted_text__attr_tags_length1;
		_tmp16_ = formatted_text_super_info_new ();
		_formatted_text_tag_attr_unref0 (_tmp15_[FORMAT_TAG_SUPER]);
		_tmp15_[FORMAT_TAG_SUPER] = (FormattedTextTagAttr*) _tmp16_;
		_tmp17_ = formatted_text__attr_tags;
		_tmp17__length1 = formatted_text__attr_tags_length1;
		_tmp18_ = formatted_text_header_info_new ();
		_formatted_text_tag_attr_unref0 (_tmp17_[FORMAT_TAG_HEADER]);
		_tmp17_[FORMAT_TAG_HEADER] = (FormattedTextTagAttr*) _tmp18_;
		_tmp19_ = formatted_text__attr_tags;
		_tmp19__length1 = formatted_text__attr_tags_length1;
		_tmp20_ = formatted_text_color_info_new ();
		_formatted_text_tag_attr_unref0 (_tmp19_[FORMAT_TAG_COLOR]);
		_tmp19_[FORMAT_TAG_COLOR] = (FormattedTextTagAttr*) _tmp20_;
		_tmp21_ = formatted_text__attr_tags;
		_tmp21__length1 = formatted_text__attr_tags_length1;
		_tmp22_ = formatted_text_highlight_info_new ();
		_formatted_text_tag_attr_unref0 (_tmp21_[FORMAT_TAG_HILITE]);
		_tmp21_[FORMAT_TAG_HILITE] = (FormattedTextTagAttr*) _tmp22_;
		_tmp23_ = formatted_text__attr_tags;
		_tmp23__length1 = formatted_text__attr_tags_length1;
		_tmp24_ = theme;
		_tmp25_ = theme_get_color (_tmp24_, "url_foreground");
		_tmp26_ = _tmp25_;
		_tmp27_ = *_tmp26_;
		_tmp28_ = formatted_text_url_info_new (&_tmp27_);
		_formatted_text_tag_attr_unref0 (_tmp23_[FORMAT_TAG_URL]);
		_tmp23_[FORMAT_TAG_URL] = (FormattedTextTagAttr*) _tmp28_;
		__vala_GdkRGBA_free0 (_tmp26_);
		_tmp29_ = formatted_text__attr_tags;
		_tmp29__length1 = formatted_text__attr_tags_length1;
		_tmp30_ = theme;
		_tmp31_ = theme_get_color (_tmp30_, "tag");
		_tmp32_ = _tmp31_;
		_tmp33_ = *_tmp32_;
		_tmp34_ = formatted_text_tagging_info_new (&_tmp33_);
		_formatted_text_tag_attr_unref0 (_tmp29_[FORMAT_TAG_TAG]);
		_tmp29_[FORMAT_TAG_TAG] = (FormattedTextTagAttr*) _tmp34_;
		__vala_GdkRGBA_free0 (_tmp32_);
		_tmp35_ = formatted_text__attr_tags;
		_tmp35__length1 = formatted_text__attr_tags_length1;
		_tmp36_ = theme;
		_tmp37_ = theme_get_color (_tmp36_, "syntax");
		_tmp38_ = _tmp37_;
		_tmp39_ = *_tmp38_;
		_tmp40_ = formatted_text_syntax_info_new (&_tmp39_, FALSE);
		_formatted_text_tag_attr_unref0 (_tmp35_[FORMAT_TAG_SYNTAX]);
		_tmp35_[FORMAT_TAG_SYNTAX] = (FormattedTextTagAttr*) _tmp40_;
		__vala_GdkRGBA_free0 (_tmp38_);
		_tmp41_ = formatted_text__attr_tags;
		_tmp41__length1 = formatted_text__attr_tags_length1;
		_tmp42_ = theme;
		_tmp43_ = theme_get_color (_tmp42_, "match_foreground");
		_tmp44_ = _tmp43_;
		_tmp45_ = theme;
		_tmp46_ = theme_get_color (_tmp45_, "match_background");
		_tmp47_ = _tmp46_;
		_tmp48_ = *_tmp44_;
		_tmp49_ = *_tmp47_;
		_tmp50_ = formatted_text_match_info_new (&_tmp48_, &_tmp49_);
		_formatted_text_tag_attr_unref0 (_tmp41_[FORMAT_TAG_MATCH]);
		_tmp41_[FORMAT_TAG_MATCH] = (FormattedTextTagAttr*) _tmp50_;
		__vala_GdkRGBA_free0 (_tmp47_);
		__vala_GdkRGBA_free0 (_tmp44_);
		_tmp51_ = formatted_text__attr_tags;
		_tmp51__length1 = formatted_text__attr_tags_length1;
		_tmp52_ = theme;
		_tmp53_ = theme_get_color (_tmp52_, "textsel_foreground");
		_tmp54_ = _tmp53_;
		_tmp55_ = theme;
		_tmp56_ = theme_get_color (_tmp55_, "textsel_background");
		_tmp57_ = _tmp56_;
		_tmp58_ = *_tmp54_;
		_tmp59_ = *_tmp57_;
		_tmp60_ = formatted_text_select_info_new (&_tmp58_, &_tmp59_);
		_formatted_text_tag_attr_unref0 (_tmp51_[FORMAT_TAG_SELECT]);
		_tmp51_[FORMAT_TAG_SELECT] = (FormattedTextTagAttr*) _tmp60_;
		__vala_GdkRGBA_free0 (_tmp57_);
		__vala_GdkRGBA_free0 (_tmp54_);
		_g_object_unref0 (theme);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp61_ = FALSE;
			_tmp61_ = TRUE;
			while (TRUE) {
				FormattedTextTagInfo** _tmp63_;
				gint _tmp63__length1;
				FormattedTextTagInfo* _tmp64_;
				if (!_tmp61_) {
					gint _tmp62_;
					_tmp62_ = i;
					i = _tmp62_ + 1;
				}
				_tmp61_ = FALSE;
				if (!(i < ((gint) FORMAT_TAG_LENGTH))) {
					break;
				}
				_tmp63_ = self->priv->_formats;
				_tmp63__length1 = self->priv->_formats_length1;
				_tmp64_ = formatted_text_tag_info_new ();
				_formatted_text_tag_info_unref0 (_tmp63_[i]);
				_tmp63_[i] = _tmp64_;
			}
		}
	}
}

void
formatted_text_set_theme (Theme* theme)
{
	FormattedTextTagAttr** _tmp0_;
	gint _tmp0__length1;
	FormattedTextTagAttr** _tmp1_;
	gint _tmp1__length1;
	FormattedTextTagAttr* _tmp2_;
	GdkRGBA* _tmp3_;
	GdkRGBA* _tmp4_;
	GdkRGBA _tmp5_;
	FormattedTextTagAttr** _tmp6_;
	gint _tmp6__length1;
	FormattedTextTagAttr* _tmp7_;
	GdkRGBA* _tmp8_;
	GdkRGBA* _tmp9_;
	GdkRGBA _tmp10_;
	FormattedTextTagAttr** _tmp11_;
	gint _tmp11__length1;
	FormattedTextTagAttr* _tmp12_;
	GdkRGBA* _tmp13_;
	GdkRGBA* _tmp14_;
	GdkRGBA _tmp15_;
	FormattedTextTagAttr** _tmp16_;
	gint _tmp16__length1;
	FormattedTextTagAttr* _tmp17_;
	GdkRGBA* _tmp18_;
	GdkRGBA* _tmp19_;
	GdkRGBA* _tmp20_;
	GdkRGBA* _tmp21_;
	GdkRGBA _tmp22_;
	GdkRGBA _tmp23_;
	FormattedTextTagAttr** _tmp24_;
	gint _tmp24__length1;
	FormattedTextTagAttr* _tmp25_;
	GdkRGBA* _tmp26_;
	GdkRGBA* _tmp27_;
	GdkRGBA* _tmp28_;
	GdkRGBA* _tmp29_;
	GdkRGBA _tmp30_;
	GdkRGBA _tmp31_;
	g_return_if_fail (theme != NULL);
	_tmp0_ = formatted_text__attr_tags;
	_tmp0__length1 = formatted_text__attr_tags_length1;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = formatted_text__attr_tags;
	_tmp1__length1 = formatted_text__attr_tags_length1;
	_tmp2_ = _tmp1_[FORMAT_TAG_URL];
	_tmp3_ = theme_get_color (theme, "url_foreground");
	_tmp4_ = _tmp3_;
	_tmp5_ = *_tmp4_;
	formatted_text_url_info_update_color (FORMATTED_TEXT_IS_URL_INFO (_tmp2_) ? ((FormattedTextUrlInfo*) _tmp2_) : NULL, &_tmp5_);
	__vala_GdkRGBA_free0 (_tmp4_);
	_tmp6_ = formatted_text__attr_tags;
	_tmp6__length1 = formatted_text__attr_tags_length1;
	_tmp7_ = _tmp6_[FORMAT_TAG_TAG];
	_tmp8_ = theme_get_color (theme, "tag");
	_tmp9_ = _tmp8_;
	_tmp10_ = *_tmp9_;
	formatted_text_tagging_info_update_color (FORMATTED_TEXT_IS_TAGGING_INFO (_tmp7_) ? ((FormattedTextTaggingInfo*) _tmp7_) : NULL, &_tmp10_);
	__vala_GdkRGBA_free0 (_tmp9_);
	_tmp11_ = formatted_text__attr_tags;
	_tmp11__length1 = formatted_text__attr_tags_length1;
	_tmp12_ = _tmp11_[FORMAT_TAG_SYNTAX];
	_tmp13_ = theme_get_color (theme, "syntax");
	_tmp14_ = _tmp13_;
	_tmp15_ = *_tmp14_;
	formatted_text_syntax_info_update_color (FORMATTED_TEXT_IS_SYNTAX_INFO (_tmp12_) ? ((FormattedTextSyntaxInfo*) _tmp12_) : NULL, &_tmp15_);
	__vala_GdkRGBA_free0 (_tmp14_);
	_tmp16_ = formatted_text__attr_tags;
	_tmp16__length1 = formatted_text__attr_tags_length1;
	_tmp17_ = _tmp16_[FORMAT_TAG_MATCH];
	_tmp18_ = theme_get_color (theme, "match_foreground");
	_tmp19_ = _tmp18_;
	_tmp20_ = theme_get_color (theme, "match_background");
	_tmp21_ = _tmp20_;
	_tmp22_ = *_tmp19_;
	_tmp23_ = *_tmp21_;
	formatted_text_match_info_update_color (FORMATTED_TEXT_IS_MATCH_INFO (_tmp17_) ? ((FormattedTextMatchInfo*) _tmp17_) : NULL, &_tmp22_, &_tmp23_);
	__vala_GdkRGBA_free0 (_tmp21_);
	__vala_GdkRGBA_free0 (_tmp19_);
	_tmp24_ = formatted_text__attr_tags;
	_tmp24__length1 = formatted_text__attr_tags_length1;
	_tmp25_ = _tmp24_[FORMAT_TAG_SELECT];
	_tmp26_ = theme_get_color (theme, "textsel_foreground");
	_tmp27_ = _tmp26_;
	_tmp28_ = theme_get_color (theme, "textsel_background");
	_tmp29_ = _tmp28_;
	_tmp30_ = *_tmp27_;
	_tmp31_ = *_tmp29_;
	formatted_text_select_info_update_color (FORMATTED_TEXT_IS_SELECT_INFO (_tmp25_) ? ((FormattedTextSelectInfo*) _tmp25_) : NULL, &_tmp30_, &_tmp31_);
	__vala_GdkRGBA_free0 (_tmp29_);
	__vala_GdkRGBA_free0 (_tmp27_);
}

static gpointer
_text_parser_ref0 (gpointer self)
{
	return self ? text_parser_ref (self) : NULL;
}

static void
_formatted_text_handle_parser_enable_change_text_parser_enable_changed (TextParser* _sender,
                                                                        gpointer self)
{
	formatted_text_handle_parser_enable_change ((FormattedText*) self);
}

void
formatted_text_add_parser (FormattedText* self,
                           TextParser* parser)
{
	GArray* _tmp0_;
	TextParser* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parser != NULL);
	_tmp0_ = self->priv->_parsers;
	_tmp1_ = _text_parser_ref0 (parser);
	g_array_append_val (_tmp0_, _tmp1_);
	g_signal_connect (parser, "enable-changed", (GCallback) _formatted_text_handle_parser_enable_change_text_parser_enable_changed, self);
	formatted_text_parse (self, FALSE);
	g_signal_emit (self, formatted_text_signals[FORMATTED_TEXT_CHANGED_SIGNAL], 0);
}

static void
formatted_text_handle_parser_enable_change (FormattedText* self)
{
	g_return_if_fail (self != NULL);
	formatted_text_parse (self, FALSE);
	g_signal_emit (self, formatted_text_signals[FORMATTED_TEXT_CHANGED_SIGNAL], 0);
}

static gpointer
vala_g_array_remove_index (GArray* self,
                           guint index)
{
	gpointer g = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len > index, "length > index");
	_tmp0_ = self->data;
	_tmp0__length1 = self->len;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	g = _tmp1_;
	g_array_remove_index (self, index);
	result = g;
	return result;
}

void
formatted_text_remove_parser (FormattedText* self,
                              TextParser* parser)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (parser != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				TextParser* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_parsers;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_parsers;
				_tmp4_ = g_array_index (_tmp3_, TextParser*, (guint) i);
				if (_tmp4_ == parser) {
					guint _tmp5_;
					GArray* _tmp6_;
					TextParser* _tmp7_;
					TextParser* _tmp8_;
					g_signal_parse_name ("enable-changed", TYPE_TEXT_PARSER, &_tmp5_, NULL, FALSE);
					g_signal_handlers_disconnect_matched (parser, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _formatted_text_handle_parser_enable_change_text_parser_enable_changed, self);
					_tmp6_ = self->priv->_parsers;
					_tmp7_ = vala_g_array_remove_index (_tmp6_, (guint) i);
					_tmp8_ = _tmp7_;
					_text_parser_unref0 (_tmp8_);
					formatted_text_parse (self, TRUE);
					g_signal_emit (self, formatted_text_signals[FORMATTED_TEXT_CHANGED_SIGNAL], 0);
					return;
				}
			}
		}
	}
}

void
formatted_text_copy (FormattedText* self,
                     FormattedText* other)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (other != NULL);
	_tmp0_ = other->priv->_text;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				FormattedTextTagInfo** _tmp4_;
				gint _tmp4__length1;
				FormattedTextTagInfo* _tmp5_;
				FormattedTextTagInfo** _tmp6_;
				gint _tmp6__length1;
				FormattedTextTagInfo* _tmp7_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < ((gint) FORMAT_TAG_LENGTH))) {
					break;
				}
				_tmp4_ = self->priv->_formats;
				_tmp4__length1 = self->priv->_formats_length1;
				_tmp5_ = _tmp4_[i];
				_tmp6_ = other->priv->_formats;
				_tmp6__length1 = other->priv->_formats_length1;
				_tmp7_ = _tmp6_[i];
				formatted_text_tag_info_copy (_tmp5_, _tmp7_);
			}
		}
	}
	g_signal_emit (self, formatted_text_signals[FORMATTED_TEXT_CHANGED_SIGNAL], 0);
}

void
formatted_text_set_text (FormattedText* self,
                         const gchar* str)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = g_strdup (str);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp0_;
}

void
formatted_text_append_text (FormattedText* self,
                            const gchar* str)
{
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = self->priv->_text;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	formatted_text_insert_text (self, _tmp2_, str);
}

static gchar*
string_splice (const gchar* self,
               glong start,
               glong end,
               const gchar* str)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gsize str_size = 0UL;
	const gchar* _result_ = NULL;
	void* _tmp6_;
	gchar* dest = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	if (str == NULL) {
		str_size = (gsize) 0;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = strlen ((const gchar*) str);
		_tmp5_ = _tmp4_;
		str_size = (gsize) _tmp5_;
	}
	_tmp6_ = g_malloc0 (((string_length - (end - start)) + str_size) + 1);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	dest = (gchar*) _tmp7_;
	_tmp8_ = dest;
	memcpy (_tmp8_, self, (gsize) start);
	_tmp9_ = dest;
	dest = _tmp9_ + start;
	if (str != NULL) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = dest;
		memcpy (_tmp10_, str, str_size);
		_tmp11_ = dest;
		dest = _tmp11_ + str_size;
	}
	_tmp12_ = dest;
	memcpy (_tmp12_, ((gchar*) self) + end, (gsize) (string_length - end));
	_tmp13_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp13_;
	return result;
}

static gpointer
_formatted_text_tag_info_ref0 (gpointer self)
{
	return self ? formatted_text_tag_info_ref (self) : NULL;
}

void
formatted_text_insert_text (FormattedText* self,
                            gint index,
                            const gchar* str)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	FormattedTextTagInfo** _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = self->priv->_text;
	_tmp1_ = string_splice (_tmp0_, (glong) index, (glong) index, str);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp1_;
	_tmp2_ = self->priv->_formats;
	_tmp2__length1 = self->priv->_formats_length1;
	{
		FormattedTextTagInfo** f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
		f_collection = _tmp2_;
		f_collection_length1 = _tmp2__length1;
		for (f_it = 0; f_it < f_collection_length1; f_it = f_it + 1) {
			FormattedTextTagInfo* _tmp3_;
			FormattedTextTagInfo* f = NULL;
			_tmp3_ = _formatted_text_tag_info_ref0 (f_collection[f_it]);
			f = _tmp3_;
			{
				FormattedTextTagInfo* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				_tmp4_ = f;
				_tmp5_ = strlen (str);
				_tmp6_ = _tmp5_;
				formatted_text_tag_info_adjust (_tmp4_, index, _tmp6_);
				_formatted_text_tag_info_unref0 (f);
			}
		}
	}
	formatted_text_parse (self, FALSE);
	g_signal_emit (self, formatted_text_signals[FORMATTED_TEXT_CHANGED_SIGNAL], 0);
}

void
formatted_text_insert_formatted_text (FormattedText* self,
                                      gint index,
                                      FormattedText* text)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = formatted_text_get_text (text);
	_tmp1_ = _tmp0_;
	formatted_text_insert_text (self, index, _tmp1_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				FormattedTextTagInfo** _tmp4_;
				gint _tmp4__length1;
				FormattedTextTagInfo* _tmp5_;
				FormattedTextTagInfo** _tmp6_;
				gint _tmp6__length1;
				FormattedTextTagInfo* _tmp7_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < ((gint) (FORMAT_TAG_LENGTH - 2)))) {
					break;
				}
				_tmp4_ = self->priv->_formats;
				_tmp4__length1 = self->priv->_formats_length1;
				_tmp5_ = _tmp4_[i];
				_tmp6_ = text->priv->_formats;
				_tmp6__length1 = text->priv->_formats_length1;
				_tmp7_ = _tmp6_[i];
				formatted_text_tag_info_add_tags_at_offset (_tmp5_, _tmp7_, index);
			}
		}
	}
}

void
formatted_text_replace_text (FormattedText* self,
                             gint index,
                             gint chars,
                             const gchar* str)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	FormattedTextTagInfo** _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = self->priv->_text;
	_tmp1_ = string_splice (_tmp0_, (glong) index, (glong) (index + chars), str);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp1_;
	_tmp2_ = self->priv->_formats;
	_tmp2__length1 = self->priv->_formats_length1;
	{
		FormattedTextTagInfo** f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
		f_collection = _tmp2_;
		f_collection_length1 = _tmp2__length1;
		for (f_it = 0; f_it < f_collection_length1; f_it = f_it + 1) {
			FormattedTextTagInfo* _tmp3_;
			FormattedTextTagInfo* f = NULL;
			_tmp3_ = _formatted_text_tag_info_ref0 (f_collection[f_it]);
			f = _tmp3_;
			{
				FormattedTextTagInfo* _tmp4_;
				FormattedTextTagInfo* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				_tmp4_ = f;
				formatted_text_tag_info_remove_tag (_tmp4_, index, index + chars);
				_tmp5_ = f;
				_tmp6_ = strlen (str);
				_tmp7_ = _tmp6_;
				formatted_text_tag_info_adjust (_tmp5_, index, (0 - chars) + _tmp7_);
				_formatted_text_tag_info_unref0 (f);
			}
		}
	}
	formatted_text_parse (self, FALSE);
	g_signal_emit (self, formatted_text_signals[FORMATTED_TEXT_CHANGED_SIGNAL], 0);
}

void
formatted_text_remove_text (FormattedText* self,
                            gint index,
                            gint chars)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	FormattedTextTagInfo** _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_text;
	_tmp1_ = string_splice (_tmp0_, (glong) index, (glong) (index + chars), NULL);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp1_;
	_tmp2_ = self->priv->_formats;
	_tmp2__length1 = self->priv->_formats_length1;
	{
		FormattedTextTagInfo** f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
		f_collection = _tmp2_;
		f_collection_length1 = _tmp2__length1;
		for (f_it = 0; f_it < f_collection_length1; f_it = f_it + 1) {
			FormattedTextTagInfo* _tmp3_;
			FormattedTextTagInfo* f = NULL;
			_tmp3_ = _formatted_text_tag_info_ref0 (f_collection[f_it]);
			f = _tmp3_;
			{
				FormattedTextTagInfo* _tmp4_;
				FormattedTextTagInfo* _tmp5_;
				_tmp4_ = f;
				formatted_text_tag_info_remove_tag (_tmp4_, index, index + chars);
				_tmp5_ = f;
				formatted_text_tag_info_adjust (_tmp5_, index, 0 - chars);
				_formatted_text_tag_info_unref0 (f);
			}
		}
	}
	formatted_text_parse (self, FALSE);
	g_signal_emit (self, formatted_text_signals[FORMATTED_TEXT_CHANGED_SIGNAL], 0);
}

void
formatted_text_add_tag (FormattedText* self,
                        FormatTag tag,
                        gint start,
                        gint end,
                        gboolean parsed,
                        const gchar* extra)
{
	FormattedTextTagInfo** _tmp0_;
	gint _tmp0__length1;
	FormattedTextTagInfo* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_formats;
	_tmp0__length1 = self->priv->_formats_length1;
	_tmp1_ = _tmp0_[tag];
	formatted_text_tag_info_add_tag (_tmp1_, start, end, extra, parsed);
	g_signal_emit (self, formatted_text_signals[FORMATTED_TEXT_CHANGED_SIGNAL], 0);
}

void
formatted_text_replace_tag (FormattedText* self,
                            FormatTag tag,
                            gint start,
                            gint end,
                            gboolean parsed,
                            const gchar* extra)
{
	FormattedTextTagInfo** _tmp0_;
	gint _tmp0__length1;
	FormattedTextTagInfo* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_formats;
	_tmp0__length1 = self->priv->_formats_length1;
	_tmp1_ = _tmp0_[tag];
	formatted_text_tag_info_replace_tag (_tmp1_, start, end, extra, parsed);
	g_signal_emit (self, formatted_text_signals[FORMATTED_TEXT_CHANGED_SIGNAL], 0);
}

void
formatted_text_remove_tag (FormattedText* self,
                           FormatTag tag,
                           gint start,
                           gint end)
{
	FormattedTextTagInfo** _tmp0_;
	gint _tmp0__length1;
	FormattedTextTagInfo* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_formats;
	_tmp0__length1 = self->priv->_formats_length1;
	_tmp1_ = _tmp0_[tag];
	formatted_text_tag_info_remove_tag (_tmp1_, start, end);
	g_signal_emit (self, formatted_text_signals[FORMATTED_TEXT_CHANGED_SIGNAL], 0);
}

void
formatted_text_remove_parsed_tags (FormattedText* self,
                                   FormatTag tag)
{
	FormattedTextTagInfo** _tmp0_;
	gint _tmp0__length1;
	FormattedTextTagInfo* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_formats;
	_tmp0__length1 = self->priv->_formats_length1;
	_tmp1_ = _tmp0_[tag];
	formatted_text_tag_info_remove_parsed_tags (_tmp1_);
	g_signal_emit (self, formatted_text_signals[FORMATTED_TEXT_CHANGED_SIGNAL], 0);
}

void
formatted_text_remove_tag_all (FormattedText* self,
                               FormatTag tag)
{
	FormattedTextTagInfo** _tmp0_;
	gint _tmp0__length1;
	FormattedTextTagInfo* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_formats;
	_tmp0__length1 = self->priv->_formats_length1;
	_tmp1_ = _tmp0_[tag];
	formatted_text_tag_info_remove_tag_all (_tmp1_);
	g_signal_emit (self, formatted_text_signals[FORMATTED_TEXT_CHANGED_SIGNAL], 0);
}

void
formatted_text_remove_all_tags (FormattedText* self,
                                gint start,
                                gint end)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				FormattedTextTagInfo** _tmp2_;
				gint _tmp2__length1;
				FormattedTextTagInfo* _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < ((gint) (FORMAT_TAG_LENGTH - 3)))) {
					break;
				}
				_tmp2_ = self->priv->_formats;
				_tmp2__length1 = self->priv->_formats_length1;
				_tmp3_ = _tmp2_[i];
				formatted_text_tag_info_remove_tag (_tmp3_, start, end);
			}
		}
	}
	g_signal_emit (self, formatted_text_signals[FORMATTED_TEXT_CHANGED_SIGNAL], 0);
}

gboolean
formatted_text_is_tag_applied_at_index (FormattedText* self,
                                        FormatTag tag,
                                        gint index)
{
	FormattedTextTagInfo** _tmp0_;
	gint _tmp0__length1;
	FormattedTextTagInfo* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_formats;
	_tmp0__length1 = self->priv->_formats_length1;
	_tmp1_ = _tmp0_[tag];
	result = formatted_text_tag_info_is_applied_at_index (_tmp1_, index);
	return result;
}

gboolean
formatted_text_is_tag_applied_in_range (FormattedText* self,
                                        FormatTag tag,
                                        gint start,
                                        gint end)
{
	FormattedTextTagInfo** _tmp0_;
	gint _tmp0__length1;
	FormattedTextTagInfo* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_formats;
	_tmp0__length1 = self->priv->_formats_length1;
	_tmp1_ = _tmp0_[tag];
	result = formatted_text_tag_info_is_applied_in_range (_tmp1_, start, end);
	return result;
}

gboolean
formatted_text_tags_exist (FormattedText* self)
{
	FormattedTextTagInfo** _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_formats;
	_tmp0__length1 = self->priv->_formats_length1;
	{
		FormattedTextTagInfo** f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
		f_collection = _tmp0_;
		f_collection_length1 = _tmp0__length1;
		for (f_it = 0; f_it < f_collection_length1; f_it = f_it + 1) {
			FormattedTextTagInfo* _tmp1_;
			FormattedTextTagInfo* f = NULL;
			_tmp1_ = _formatted_text_tag_info_ref0 (f_collection[f_it]);
			f = _tmp1_;
			{
				FormattedTextTagInfo* _tmp2_;
				_tmp2_ = f;
				if (!formatted_text_tag_info_is_empty (_tmp2_)) {
					result = TRUE;
					_formatted_text_tag_info_unref0 (f);
					return result;
				}
				_formatted_text_tag_info_unref0 (f);
			}
		}
	}
	result = FALSE;
	return result;
}

gboolean
formatted_text_contains_tag (FormattedText* self,
                             FormatTag tag,
                             const gchar* extra)
{
	FormattedTextTagInfo** _tmp0_;
	gint _tmp0__length1;
	FormattedTextTagInfo* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (extra != NULL, FALSE);
	_tmp0_ = self->priv->_formats;
	_tmp0__length1 = self->priv->_formats_length1;
	_tmp1_ = _tmp0_[tag];
	result = formatted_text_tag_info_contains_tag (_tmp1_, extra);
	return result;
}

GeeHashMap*
formatted_text_get_extras_for_tag (FormattedText* self,
                                   FormatTag tag)
{
	GeeHashMap* extras = NULL;
	GeeHashMap* _tmp0_;
	FormattedTextTagInfo** _tmp1_;
	gint _tmp1__length1;
	FormattedTextTagInfo* _tmp2_;
	GeeHashMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	extras = _tmp0_;
	_tmp1_ = self->priv->_formats;
	_tmp1__length1 = self->priv->_formats_length1;
	_tmp2_ = _tmp1_[tag];
	formatted_text_tag_info_get_extras_for_tag (_tmp2_, &extras);
	result = extras;
	return result;
}

static void
_undo_tag_info_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (undo_tag_info_unref (var), NULL));
}

static void
_vala_UndoTagInfo_free_function_content_of (gpointer data)
{
	UndoTagInfo* self;
	self = *((UndoTagInfo**) data);
	_undo_tag_info_unref0_ (self);
}

GArray*
formatted_text_get_full_tags_in_range (FormattedText* self,
                                       FormatTag tag,
                                       gint start,
                                       gint end)
{
	GArray* tags = NULL;
	GArray* _tmp0_;
	GArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (UndoTagInfo*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_UndoTagInfo_free_function_content_of);
	tags = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				FormattedTextTagInfo** _tmp3_;
				gint _tmp3__length1;
				FormattedTextTagInfo* _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((gint) (FORMAT_TAG_LENGTH - 4)))) {
					break;
				}
				_tmp3_ = self->priv->_formats;
				_tmp3__length1 = self->priv->_formats_length1;
				_tmp4_ = _tmp3_[i];
				formatted_text_tag_info_get_full_tags_in_range (_tmp4_, i, start, end, &tags);
			}
		}
	}
	result = tags;
	return result;
}

GArray*
formatted_text_get_tags_in_range (FormattedText* self,
                                  gint start,
                                  gint end)
{
	GArray* tags = NULL;
	GArray* _tmp0_;
	GArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (UndoTagInfo*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_UndoTagInfo_free_function_content_of);
	tags = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				FormattedTextTagInfo** _tmp3_;
				gint _tmp3__length1;
				FormattedTextTagInfo* _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((gint) (FORMAT_TAG_LENGTH - 4)))) {
					break;
				}
				_tmp3_ = self->priv->_formats;
				_tmp3__length1 = self->priv->_formats_length1;
				_tmp4_ = _tmp3_[i];
				formatted_text_tag_info_get_tags_in_range (_tmp4_, i, start, end, &tags);
			}
		}
	}
	result = tags;
	return result;
}

void
formatted_text_apply_tags (FormattedText* self,
                           GArray* tags,
                           gint start)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tags != NULL);
	{
		gint i = 0;
		i = ((gint) tags->len) - 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				UndoTagInfo* info = NULL;
				UndoTagInfo* _tmp2_;
				UndoTagInfo* _tmp3_;
				FormattedTextTagInfo** _tmp4_;
				gint _tmp4__length1;
				UndoTagInfo* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				FormattedTextTagInfo* _tmp8_;
				UndoTagInfo* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				UndoTagInfo* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				UndoTagInfo* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				UndoTagInfo* _tmp18_;
				gboolean _tmp19_;
				gboolean _tmp20_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ - 1;
				}
				_tmp0_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp2_ = g_array_index (tags, UndoTagInfo*, (guint) i);
				_tmp3_ = _undo_tag_info_ref0 (_tmp2_);
				info = _tmp3_;
				_tmp4_ = self->priv->_formats;
				_tmp4__length1 = self->priv->_formats_length1;
				_tmp5_ = info;
				_tmp6_ = undo_tag_info_get_tag (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp4_[_tmp7_];
				_tmp9_ = info;
				_tmp10_ = undo_tag_info_get_start (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = info;
				_tmp13_ = undo_tag_info_get_end (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = info;
				_tmp16_ = undo_tag_info_get_extra (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = info;
				_tmp19_ = undo_tag_info_get_parsed (_tmp18_);
				_tmp20_ = _tmp19_;
				formatted_text_tag_info_add_tag (_tmp8_, _tmp11_ + start, _tmp14_ + start, _tmp17_, _tmp20_);
				_undo_tag_info_unref0 (info);
			}
		}
	}
	g_signal_emit (self, formatted_text_signals[FORMATTED_TEXT_CHANGED_SIGNAL], 0);
}

PangoAttrList*
formatted_text_get_attributes (FormattedText* self)
{
	PangoAttrList* attrs = NULL;
	PangoAttrList* _tmp0_;
	PangoAttrList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = pango_attr_list_new ();
	attrs = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				FormattedTextTagInfo** _tmp3_;
				gint _tmp3__length1;
				FormattedTextTagInfo* _tmp4_;
				FormattedTextTagAttr** _tmp5_;
				gint _tmp5__length1;
				FormattedTextTagAttr* _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((gint) FORMAT_TAG_LENGTH))) {
					break;
				}
				_tmp3_ = self->priv->_formats;
				_tmp3__length1 = self->priv->_formats_length1;
				_tmp4_ = _tmp3_[i];
				_tmp5_ = formatted_text__attr_tags;
				_tmp5__length1 = formatted_text__attr_tags_length1;
				_tmp6_ = _tmp5_[i];
				formatted_text_tag_info_get_attributes (_tmp4_, _tmp6_, &attrs);
			}
		}
	}
	result = attrs;
	return result;
}

PangoAttrList*
formatted_text_get_attributes_from_theme (FormattedText* self,
                                          Theme* theme)
{
	PangoAttrList* attrs = NULL;
	PangoAttrList* _tmp0_;
	FormattedTextTagInfo** _tmp7_;
	gint _tmp7__length1;
	FormattedTextTagInfo* _tmp8_;
	GdkRGBA* _tmp9_;
	GdkRGBA* _tmp10_;
	GdkRGBA _tmp11_;
	FormattedTextUrlInfo* _tmp12_;
	FormattedTextUrlInfo* _tmp13_;
	FormattedTextTagInfo** _tmp14_;
	gint _tmp14__length1;
	FormattedTextTagInfo* _tmp15_;
	GdkRGBA* _tmp16_;
	GdkRGBA* _tmp17_;
	GdkRGBA _tmp18_;
	FormattedTextSyntaxInfo* _tmp19_;
	FormattedTextSyntaxInfo* _tmp20_;
	PangoAttrList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (theme != NULL, NULL);
	_tmp0_ = pango_attr_list_new ();
	attrs = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				FormattedTextTagInfo** _tmp3_;
				gint _tmp3__length1;
				FormattedTextTagInfo* _tmp4_;
				FormattedTextTagAttr** _tmp5_;
				gint _tmp5__length1;
				FormattedTextTagAttr* _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((gint) (FORMAT_TAG_LENGTH - 5)))) {
					break;
				}
				_tmp3_ = self->priv->_formats;
				_tmp3__length1 = self->priv->_formats_length1;
				_tmp4_ = _tmp3_[i];
				_tmp5_ = formatted_text__attr_tags;
				_tmp5__length1 = formatted_text__attr_tags_length1;
				_tmp6_ = _tmp5_[i];
				formatted_text_tag_info_get_attributes (_tmp4_, _tmp6_, &attrs);
			}
		}
	}
	_tmp7_ = self->priv->_formats;
	_tmp7__length1 = self->priv->_formats_length1;
	_tmp8_ = _tmp7_[FORMAT_TAG_URL];
	_tmp9_ = theme_get_color (theme, "url_foreground");
	_tmp10_ = _tmp9_;
	_tmp11_ = *_tmp10_;
	_tmp12_ = formatted_text_url_info_new (&_tmp11_);
	_tmp13_ = _tmp12_;
	formatted_text_tag_info_get_attributes (_tmp8_, (FormattedTextTagAttr*) _tmp13_, &attrs);
	_formatted_text_tag_attr_unref0 (_tmp13_);
	__vala_GdkRGBA_free0 (_tmp10_);
	_tmp14_ = self->priv->_formats;
	_tmp14__length1 = self->priv->_formats_length1;
	_tmp15_ = _tmp14_[FORMAT_TAG_SYNTAX];
	_tmp16_ = theme_get_color (theme, "syntax");
	_tmp17_ = _tmp16_;
	_tmp18_ = *_tmp17_;
	_tmp19_ = formatted_text_syntax_info_new (&_tmp18_, TRUE);
	_tmp20_ = _tmp19_;
	formatted_text_tag_info_get_attributes (_tmp15_, (FormattedTextTagAttr*) _tmp20_, &attrs);
	_formatted_text_tag_attr_unref0 (_tmp20_);
	__vala_GdkRGBA_free0 (_tmp17_);
	result = attrs;
	return result;
}

void
formatted_text_to_buffer (FormattedText* self,
                          GtkTextBuffer* buf,
                          gint start,
                          gint end)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GArray* tags = NULL;
	GArray* _tmp2_;
	GtkTextIter ti_start = {0};
	GtkTextIter ti_end = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (buf != NULL);
	_tmp0_ = formatted_text_get_text (self);
	_tmp1_ = _tmp0_;
	g_object_set (buf, "text", _tmp1_, NULL);
	_tmp2_ = formatted_text_get_tags_in_range (self, start, end);
	tags = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GArray* _tmp5_;
				UndoTagInfo* tag = NULL;
				GArray* _tmp6_;
				UndoTagInfo* _tmp7_;
				UndoTagInfo* _tmp8_;
				GtkTextTag* ttag = NULL;
				FormattedTextTagAttr** _tmp9_;
				gint _tmp9__length1;
				UndoTagInfo* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				FormattedTextTagAttr* _tmp13_;
				UndoTagInfo* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				GtkTextTag* _tmp17_;
				GtkTextTagTable* _tmp18_;
				GtkTextTagTable* _tmp19_;
				GtkTextTag* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				GtkTextTag* _tmp24_;
				gboolean _tmp25_;
				UndoTagInfo* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				GtkTextIter _tmp32_ = {0};
				UndoTagInfo* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				GtkTextIter _tmp36_ = {0};
				GtkTextTag* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				GtkTextIter _tmp41_;
				GtkTextIter _tmp42_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = tags;
				if (!(((guint) i) < _tmp5_->len)) {
					break;
				}
				_tmp6_ = tags;
				_tmp7_ = g_array_index (_tmp6_, UndoTagInfo*, (guint) i);
				_tmp8_ = _undo_tag_info_ref0 (_tmp7_);
				tag = _tmp8_;
				_tmp9_ = formatted_text__attr_tags;
				_tmp9__length1 = formatted_text__attr_tags_length1;
				_tmp10_ = tag;
				_tmp11_ = undo_tag_info_get_tag (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = _tmp9_[_tmp12_];
				_tmp14_ = tag;
				_tmp15_ = undo_tag_info_get_extra (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = formatted_text_tag_attr_text_tag (_tmp13_, _tmp16_);
				ttag = _tmp17_;
				_tmp18_ = gtk_text_buffer_get_tag_table (buf);
				_tmp19_ = _tmp18_;
				_tmp20_ = ttag;
				g_object_get (_tmp20_, "name", &_tmp21_, NULL);
				_tmp22_ = _tmp21_;
				_tmp23_ = _tmp22_;
				_tmp24_ = gtk_text_tag_table_lookup (_tmp19_, _tmp23_);
				_tmp25_ = _tmp24_ == NULL;
				_g_free0 (_tmp23_);
				if (_tmp25_) {
					GtkTextTagTable* _tmp26_;
					GtkTextTagTable* _tmp27_;
					GtkTextTag* _tmp28_;
					_tmp26_ = gtk_text_buffer_get_tag_table (buf);
					_tmp27_ = _tmp26_;
					_tmp28_ = ttag;
					gtk_text_tag_table_add (_tmp27_, _tmp28_);
				}
				_tmp29_ = tag;
				_tmp30_ = undo_tag_info_get_start (_tmp29_);
				_tmp31_ = _tmp30_;
				gtk_text_buffer_get_iter_at_offset (buf, &_tmp32_, _tmp31_);
				ti_start = _tmp32_;
				_tmp33_ = tag;
				_tmp34_ = undo_tag_info_get_end (_tmp33_);
				_tmp35_ = _tmp34_;
				gtk_text_buffer_get_iter_at_offset (buf, &_tmp36_, _tmp35_);
				ti_end = _tmp36_;
				_tmp37_ = ttag;
				g_object_get (_tmp37_, "name", &_tmp38_, NULL);
				_tmp39_ = _tmp38_;
				_tmp40_ = _tmp39_;
				_tmp41_ = ti_start;
				_tmp42_ = ti_end;
				gtk_text_buffer_apply_tag_by_name (buf, _tmp40_, &_tmp41_, &_tmp42_);
				_g_free0 (_tmp40_);
				_g_object_unref0 (ttag);
				_undo_tag_info_unref0 (tag);
			}
		}
	}
	_g_array_unref0 (tags);
}

gchar*
formatted_text_get_extra (FormattedText* self,
                          FormatTag tag,
                          gint index)
{
	FormattedTextTagInfo** _tmp0_;
	gint _tmp0__length1;
	FormattedTextTagInfo* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_formats;
	_tmp0__length1 = self->priv->_formats_length1;
	_tmp1_ = _tmp0_[tag];
	_tmp2_ = formatted_text_tag_info_get_extra (_tmp1_, index);
	result = _tmp2_;
	return result;
}

void
formatted_text_get_extra_parsed (FormattedText* self,
                                 FormatTag tag,
                                 gint index,
                                 gchar** extra,
                                 gboolean* parsed)
{
	gchar* _vala_extra = NULL;
	gboolean _vala_parsed = FALSE;
	FormattedTextTagInfo** _tmp0_;
	gint _tmp0__length1;
	FormattedTextTagInfo* _tmp1_;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_formats;
	_tmp0__length1 = self->priv->_formats_length1;
	_tmp1_ = _tmp0_[tag];
	formatted_text_tag_info_get_extra_parsed (_tmp1_, index, &_tmp2_, &_tmp3_);
	_g_free0 (_vala_extra);
	_vala_extra = _tmp2_;
	_vala_parsed = _tmp3_;
	if (extra) {
		*extra = _vala_extra;
	} else {
		_g_free0 (_vala_extra);
	}
	if (parsed) {
		*parsed = _vala_parsed;
	}
}

gchar*
formatted_text_get_first_extra_in_range (FormattedText* self,
                                         FormatTag tag,
                                         gint start,
                                         gint end)
{
	FormattedTextTagInfo** _tmp0_;
	gint _tmp0__length1;
	FormattedTextTagInfo* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_formats;
	_tmp0__length1 = self->priv->_formats_length1;
	_tmp1_ = _tmp0_[tag];
	_tmp2_ = formatted_text_tag_info_get_first_extra_in_range (_tmp1_, start, end);
	result = _tmp2_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

gboolean
formatted_text_do_search (FormattedText* self,
                          const gchar* pattern)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pattern != NULL, FALSE);
	formatted_text_remove_tag_all (self, FORMAT_TAG_MATCH);
	if (g_strcmp0 (pattern, "") != 0) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = formatted_text_get_text (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = string_contains (_tmp2_, pattern);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GArray* tags = NULL;
		GArray* _tmp3_;
		gint start = 0;
		GArray* _tmp12_;
		_tmp3_ = g_array_new (TRUE, TRUE, sizeof (UndoTagInfo*));
		g_array_set_clear_func (_tmp3_, (GDestroyNotify) _vala_UndoTagInfo_free_function_content_of);
		tags = _tmp3_;
		start = 0;
		while (TRUE) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gint end = 0;
			gint _tmp6_;
			gint _tmp7_;
			GArray* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			UndoTagInfo* _tmp11_;
			_tmp4_ = formatted_text_get_text (self);
			_tmp5_ = _tmp4_;
			start = string_index_of (_tmp5_, pattern, start);
			if (!(start != -1)) {
				break;
			}
			_tmp6_ = strlen (pattern);
			_tmp7_ = _tmp6_;
			end = start + string_index_of_nth_char (pattern, (glong) _tmp7_);
			_tmp8_ = tags;
			_tmp9_ = start;
			start = _tmp9_ + 1;
			_tmp10_ = end;
			_tmp11_ = undo_tag_info_new ((gint) FORMAT_TAG_MATCH, _tmp9_, _tmp10_, NULL, TRUE);
			g_array_append_val (_tmp8_, _tmp11_);
		}
		_tmp12_ = tags;
		formatted_text_apply_tags (self, _tmp12_, 0);
		result = TRUE;
		_g_array_unref0 (tags);
		return result;
	}
	result = FALSE;
	return result;
}

static void
formatted_text_parse (FormattedText* self,
                      gboolean force_clear)
{
	gboolean _tmp0_ = FALSE;
	GArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_parsers;
	if (_tmp1_->len > ((guint) 0)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = force_clear;
	}
	if (_tmp0_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					FormattedTextTagInfo** _tmp4_;
					gint _tmp4__length1;
					FormattedTextTagInfo* _tmp5_;
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					if (!(i < ((gint) (FORMAT_TAG_LENGTH - 2)))) {
						break;
					}
					_tmp4_ = self->priv->_formats;
					_tmp4__length1 = self->priv->_formats_length1;
					_tmp5_ = _tmp4_[i];
					formatted_text_tag_info_remove_parsed_tags (_tmp5_);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				GArray* _tmp8_;
				GArray* _tmp9_;
				TextParser* _tmp10_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = self->priv->_parsers;
				if (!(((guint) i) < _tmp8_->len)) {
					break;
				}
				_tmp9_ = self->priv->_parsers;
				_tmp10_ = g_array_index (_tmp9_, TextParser*, (guint) i);
				text_parser_parse (_tmp10_, self);
			}
		}
	}
}

xmlNode*
formatted_text_save (FormattedText* self)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	xmlNode* _tmp14_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "text");
	n = _tmp0_;
	_tmp1_ = n;
	_tmp2_ = formatted_text_get_text (self);
	_tmp3_ = _tmp2_;
	xmlNewProp (_tmp1_, (xmlChar*) "data", (xmlChar*) _tmp3_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				FormattedTextTagInfo** _tmp6_;
				gint _tmp6__length1;
				FormattedTextTagInfo* _tmp7_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(i < ((gint) (FORMAT_TAG_LENGTH - 4)))) {
					break;
				}
				_tmp6_ = self->priv->_formats;
				_tmp6__length1 = self->priv->_formats_length1;
				_tmp7_ = _tmp6_[i];
				if (formatted_text_tag_info_save_needed (_tmp7_)) {
					FormatTag tag = 0;
					xmlNode* _tmp8_;
					FormattedTextTagInfo** _tmp9_;
					gint _tmp9__length1;
					FormattedTextTagInfo* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					xmlNode* _tmp13_;
					tag = (FormatTag) i;
					_tmp8_ = n;
					_tmp9_ = self->priv->_formats;
					_tmp9__length1 = self->priv->_formats_length1;
					_tmp10_ = _tmp9_[i];
					_tmp11_ = format_tag_to_string (tag);
					_tmp12_ = _tmp11_;
					_tmp13_ = formatted_text_tag_info_save (_tmp10_, _tmp12_);
					xmlAddChild (_tmp8_, _tmp13_);
					_g_free0 (_tmp12_);
				}
			}
		}
	}
	_tmp14_ = n;
	result = _tmp14_;
	return result;
}

gchar*
formatted_text_xml_text (xmlNode* n)
{
	gchar* t = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = (gchar*) xmlGetProp (n, (xmlChar*) "data");
	t = _tmp0_;
	_tmp2_ = t;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = t;
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = _ ("No text found");
	}
	_tmp4_ = g_strdup (_tmp1_);
	result = _tmp4_;
	_g_free0 (t);
	return result;
}

void
formatted_text_load (FormattedText* self,
                     xmlNode* n)
{
	gchar* t = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* pa = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (gchar*) xmlGetProp (n, (xmlChar*) "data");
	t = _tmp0_;
	_tmp1_ = t;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = t;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (self->priv->_text);
		self->priv->_text = _tmp3_;
	}
	_tmp4_ = (gchar*) xmlGetProp (n, (xmlChar*) "parse-as");
	pa = _tmp4_;
	_tmp5_ = pa;
	if (_tmp5_ != NULL) {
		gchar* str = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = self->priv->_text;
		_tmp7_ = g_strdup (_tmp6_);
		str = _tmp7_;
		_tmp8_ = g_strdup ("");
		_g_free0 (self->priv->_text);
		self->priv->_text = _tmp8_;
		_g_free0 (str);
	}
	{
		xmlNode* it = NULL;
		xmlNode* _tmp9_;
		_tmp9_ = n->children;
		it = _tmp9_;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp13_;
				xmlNode* _tmp14_;
				if (!_tmp10_) {
					xmlNode* _tmp11_;
					xmlNode* _tmp12_;
					_tmp11_ = it;
					_tmp12_ = _tmp11_->next;
					it = _tmp12_;
				}
				_tmp10_ = FALSE;
				_tmp13_ = it;
				if (!(_tmp13_ != NULL)) {
					break;
				}
				_tmp14_ = it;
				if (_tmp14_->type == XML_ELEMENT_NODE) {
					FormatTag tag = 0;
					xmlNode* _tmp15_;
					const gchar* _tmp16_;
					_tmp15_ = it;
					_tmp16_ = _tmp15_->name;
					tag = format_tag_from_string (_tmp16_);
					if (tag != FORMAT_TAG_LENGTH) {
						FormattedTextTagInfo** _tmp17_;
						gint _tmp17__length1;
						FormattedTextTagInfo* _tmp18_;
						xmlNode* _tmp19_;
						_tmp17_ = self->priv->_formats;
						_tmp17__length1 = self->priv->_formats_length1;
						_tmp18_ = _tmp17_[tag];
						_tmp19_ = it;
						formatted_text_tag_info_load (_tmp18_, _tmp19_);
					}
				}
			}
		}
	}
	formatted_text_parse (self, FALSE);
	g_signal_emit (self, formatted_text_signals[FORMATTED_TEXT_CHANGED_SIGNAL], 0);
	_g_free0 (pa);
	_g_free0 (t);
}

const gchar*
formatted_text_get_text (FormattedText* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

static inline gpointer
formatted_text_tag_info_get_instance_private (FormattedTextTagInfo* self)
{
	return G_STRUCT_MEMBER_P (self, FormattedTextTagInfo_private_offset);
}

static void
_formatted_text_tag_info_formatted_range_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (formatted_text_tag_info_formatted_range_unref (var), NULL));
}

static void
_vala_FormattedTextTagInfoFormattedRange_free_function_content_of (gpointer data)
{
	FormattedTextTagInfoFormattedRange* self;
	self = *((FormattedTextTagInfoFormattedRange**) data);
	_formatted_text_tag_info_formatted_range_unref0_ (self);
}

static FormattedTextTagInfo*
formatted_text_tag_info_construct (GType object_type)
{
	FormattedTextTagInfo* self = NULL;
	GArray* _tmp0_;
	self = (FormattedTextTagInfo*) g_type_create_instance (object_type);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (FormattedTextTagInfoFormattedRange*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_FormattedTextTagInfoFormattedRange_free_function_content_of);
	_g_array_unref0 (self->priv->_info);
	self->priv->_info = _tmp0_;
	return self;
}

static FormattedTextTagInfo*
formatted_text_tag_info_new (void)
{
	return formatted_text_tag_info_construct (FORMATTED_TEXT_TYPE_TAG_INFO);
}

static gpointer*
vala_g_array_remove_range (GArray* self,
                           guint index,
                           guint length,
                           gint* result_length1)
{
	gpointer* ga = NULL;
	gpointer* _tmp0_;
	gint ga_length1;
	gint _ga_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len >= (index + length), "this.length >= index + length");
	_tmp0_ = g_new0 (gpointer, length);
	ga = _tmp0_;
	ga_length1 = length;
	_ga_size_ = ga_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gpointer* _tmp4_;
				gint _tmp4__length1;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp3_ = ga;
				_tmp3__length1 = ga_length1;
				_tmp4_ = self->data;
				_tmp4__length1 = self->len;
				_tmp5_ = _tmp4_[i + index];
				_tmp4_[i + index] = NULL;
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	g_array_remove_range (self, index, length);
	_tmp6_ = ga;
	_tmp6__length1 = ga_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static void
formatted_text_tag_info_copy (FormattedTextTagInfo* self,
                              FormattedTextTagInfo* other)
{
	GArray* _tmp0_;
	GArray* _tmp1_;
	gint _tmp2_ = 0;
	gpointer* _tmp3_;
	FormattedTextTagInfoFormattedRange** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (other != NULL);
	_tmp0_ = self->priv->_info;
	_tmp1_ = self->priv->_info;
	_tmp3_ = vala_g_array_remove_range (_tmp0_, (guint) 0, _tmp1_->len, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) formatted_text_tag_info_formatted_range_unref), NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				GArray* _tmp7_;
				FormattedTextTagInfoFormattedRange* other_info = NULL;
				GArray* _tmp8_;
				FormattedTextTagInfoFormattedRange* _tmp9_;
				FormattedTextTagInfoFormattedRange* _tmp10_;
				GArray* _tmp11_;
				FormattedTextTagInfoFormattedRange* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				FormattedTextTagInfoFormattedRange* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				FormattedTextTagInfoFormattedRange* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				FormattedTextTagInfoFormattedRange* _tmp21_;
				gboolean _tmp22_;
				gboolean _tmp23_;
				FormattedTextTagInfoFormattedRange* _tmp24_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = other->priv->_info;
				if (!(((guint) i) < _tmp7_->len)) {
					break;
				}
				_tmp8_ = other->priv->_info;
				_tmp9_ = g_array_index (_tmp8_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp10_ = _formatted_text_tag_info_formatted_range_ref0 (_tmp9_);
				other_info = _tmp10_;
				_tmp11_ = self->priv->_info;
				_tmp12_ = other_info;
				_tmp13_ = formatted_text_tag_info_formatted_range_get_start (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = other_info;
				_tmp16_ = formatted_text_tag_info_formatted_range_get_end (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = other_info;
				_tmp19_ = formatted_text_tag_info_formatted_range_get_extra (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = other_info;
				_tmp22_ = formatted_text_tag_info_formatted_range_get_parsed (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = formatted_text_tag_info_formatted_range_new (_tmp14_, _tmp17_, _tmp20_, _tmp23_);
				g_array_append_val (_tmp11_, _tmp24_);
				_formatted_text_tag_info_formatted_range_unref0 (other_info);
			}
		}
	}
}

static gboolean
formatted_text_tag_info_is_empty (FormattedTextTagInfo* self)
{
	GArray* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_info;
	result = _tmp0_->len == ((guint) 0);
	return result;
}

static gboolean
formatted_text_tag_info_save_needed (FormattedTextTagInfo* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				FormattedTextTagInfoFormattedRange* _tmp4_;
				gboolean _tmp5_;
				gboolean _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_info;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_info;
				_tmp4_ = g_array_index (_tmp3_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp5_ = formatted_text_tag_info_formatted_range_get_parsed (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static void
formatted_text_tag_info_adjust (FormattedTextTagInfo* self,
                                gint index,
                                gint length)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				FormattedTextTagInfoFormattedRange* info = NULL;
				GArray* _tmp3_;
				FormattedTextTagInfoFormattedRange* _tmp4_;
				FormattedTextTagInfoFormattedRange* _tmp5_;
				FormattedTextTagInfoFormattedRange* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_info;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_info;
				_tmp4_ = g_array_index (_tmp3_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp5_ = _formatted_text_tag_info_formatted_range_ref0 (_tmp4_);
				info = _tmp5_;
				_tmp6_ = info;
				_tmp7_ = formatted_text_tag_info_formatted_range_get_start (_tmp6_);
				_tmp8_ = _tmp7_;
				if (index <= _tmp8_) {
					FormattedTextTagInfoFormattedRange* _tmp9_;
					FormattedTextTagInfoFormattedRange* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					FormattedTextTagInfoFormattedRange* _tmp13_;
					FormattedTextTagInfoFormattedRange* _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					FormattedTextTagInfoFormattedRange* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					_tmp9_ = info;
					_tmp10_ = info;
					_tmp11_ = formatted_text_tag_info_formatted_range_get_start (_tmp10_);
					_tmp12_ = _tmp11_;
					formatted_text_tag_info_formatted_range_set_start (_tmp10_, _tmp12_ + length);
					_tmp13_ = info;
					_tmp14_ = info;
					_tmp15_ = formatted_text_tag_info_formatted_range_get_end (_tmp14_);
					_tmp16_ = _tmp15_;
					formatted_text_tag_info_formatted_range_set_end (_tmp14_, _tmp16_ + length);
					_tmp17_ = info;
					_tmp18_ = formatted_text_tag_info_formatted_range_get_end (_tmp17_);
					_tmp19_ = _tmp18_;
					if (_tmp19_ <= index) {
						GArray* _tmp20_;
						FormattedTextTagInfoFormattedRange* _tmp21_;
						FormattedTextTagInfoFormattedRange* _tmp22_;
						_tmp20_ = self->priv->_info;
						_tmp21_ = vala_g_array_remove_index (_tmp20_, (guint) i);
						_tmp22_ = _tmp21_;
						_formatted_text_tag_info_formatted_range_unref0 (_tmp22_);
					}
				} else {
					FormattedTextTagInfoFormattedRange* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					_tmp23_ = info;
					_tmp24_ = formatted_text_tag_info_formatted_range_get_end (_tmp23_);
					_tmp25_ = _tmp24_;
					if (index < _tmp25_) {
						FormattedTextTagInfoFormattedRange* _tmp26_;
						FormattedTextTagInfoFormattedRange* _tmp27_;
						gint _tmp28_;
						gint _tmp29_;
						_tmp26_ = info;
						_tmp27_ = info;
						_tmp28_ = formatted_text_tag_info_formatted_range_get_end (_tmp27_);
						_tmp29_ = _tmp28_;
						formatted_text_tag_info_formatted_range_set_end (_tmp27_, _tmp29_ + length);
					}
				}
				_formatted_text_tag_info_formatted_range_unref0 (info);
			}
		}
	}
}

static void
formatted_text_tag_info_add_tag (FormattedTextTagInfo* self,
                                 gint start,
                                 gint end,
                                 const gchar* extra,
                                 gboolean parsed)
{
	GArray* _tmp5_;
	FormattedTextTagInfoFormattedRange* _tmp6_;
	GArray* _tmp7_;
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				FormattedTextTagInfoFormattedRange* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_info;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_info;
				_tmp4_ = g_array_index (_tmp3_, FormattedTextTagInfoFormattedRange*, (guint) i);
				if (formatted_text_tag_info_formatted_range_combine (_tmp4_, start, end, extra)) {
					return;
				}
			}
		}
	}
	_tmp5_ = self->priv->_info;
	_tmp6_ = formatted_text_tag_info_formatted_range_new (start, end, extra, parsed);
	g_array_append_val (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->_info;
	g_array_sort (_tmp7_, (GCompareFunc) formatted_text_tag_info_formatted_range_compare);
}

static void
formatted_text_tag_info_add_tags_at_offset (FormattedTextTagInfo* self,
                                            FormattedTextTagInfo* other,
                                            gint offset)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (other != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				FormattedTextTagInfoFormattedRange* other_info = NULL;
				GArray* _tmp3_;
				FormattedTextTagInfoFormattedRange* _tmp4_;
				FormattedTextTagInfoFormattedRange* _tmp5_;
				FormattedTextTagInfoFormattedRange* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				FormattedTextTagInfoFormattedRange* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				FormattedTextTagInfoFormattedRange* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				FormattedTextTagInfoFormattedRange* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = other->priv->_info;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = other->priv->_info;
				_tmp4_ = g_array_index (_tmp3_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp5_ = _formatted_text_tag_info_formatted_range_ref0 (_tmp4_);
				other_info = _tmp5_;
				_tmp6_ = other_info;
				_tmp7_ = formatted_text_tag_info_formatted_range_get_start (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = other_info;
				_tmp10_ = formatted_text_tag_info_formatted_range_get_end (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = other_info;
				_tmp13_ = formatted_text_tag_info_formatted_range_get_extra (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = other_info;
				_tmp16_ = formatted_text_tag_info_formatted_range_get_parsed (_tmp15_);
				_tmp17_ = _tmp16_;
				formatted_text_tag_info_add_tag (self, _tmp8_ + offset, _tmp11_ + offset, _tmp14_, _tmp17_);
				_formatted_text_tag_info_formatted_range_unref0 (other_info);
			}
		}
	}
}

static void
formatted_text_tag_info_replace_tag (FormattedTextTagInfo* self,
                                     gint start,
                                     gint end,
                                     const gchar* extra,
                                     gboolean parsed)
{
	GArray* _tmp0_;
	GArray* _tmp1_;
	gint _tmp2_ = 0;
	gpointer* _tmp3_;
	FormattedTextTagInfoFormattedRange** _tmp4_;
	gint _tmp4__length1;
	GArray* _tmp5_;
	FormattedTextTagInfoFormattedRange* _tmp6_;
	GArray* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_info;
	_tmp1_ = self->priv->_info;
	_tmp3_ = vala_g_array_remove_range (_tmp0_, (guint) 0, _tmp1_->len, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) formatted_text_tag_info_formatted_range_unref), NULL);
	_tmp5_ = self->priv->_info;
	_tmp6_ = formatted_text_tag_info_formatted_range_new (start, end, extra, parsed);
	g_array_append_val (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->_info;
	g_array_sort (_tmp7_, (GCompareFunc) formatted_text_tag_info_formatted_range_compare);
}

static void
formatted_text_tag_info_remove_tag (FormattedTextTagInfo* self,
                                    gint start,
                                    gint end)
{
	GArray* _tmp38_;
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		GArray* _tmp0_;
		_tmp0_ = self->priv->_info;
		i = ((gint) _tmp0_->len) - 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				FormattedTextTagInfoFormattedRange* info = NULL;
				GArray* _tmp3_;
				FormattedTextTagInfoFormattedRange* _tmp4_;
				FormattedTextTagInfoFormattedRange* _tmp5_;
				gboolean _tmp6_ = FALSE;
				FormattedTextTagInfoFormattedRange* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ - 1;
				}
				_tmp1_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp3_ = self->priv->_info;
				_tmp4_ = g_array_index (_tmp3_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp5_ = _formatted_text_tag_info_formatted_range_ref0 (_tmp4_);
				info = _tmp5_;
				_tmp7_ = info;
				_tmp8_ = formatted_text_tag_info_formatted_range_get_end (_tmp7_);
				_tmp9_ = _tmp8_;
				if (start < _tmp9_) {
					FormattedTextTagInfoFormattedRange* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					_tmp10_ = info;
					_tmp11_ = formatted_text_tag_info_formatted_range_get_start (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp6_ = end > _tmp12_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					FormattedTextTagInfoFormattedRange* _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					_tmp13_ = info;
					_tmp14_ = formatted_text_tag_info_formatted_range_get_start (_tmp13_);
					_tmp15_ = _tmp14_;
					if (start <= _tmp15_) {
						FormattedTextTagInfoFormattedRange* _tmp16_;
						gint _tmp17_;
						gint _tmp18_;
						_tmp16_ = info;
						_tmp17_ = formatted_text_tag_info_formatted_range_get_end (_tmp16_);
						_tmp18_ = _tmp17_;
						if (_tmp18_ <= end) {
							GArray* _tmp19_;
							FormattedTextTagInfoFormattedRange* _tmp20_;
							FormattedTextTagInfoFormattedRange* _tmp21_;
							_tmp19_ = self->priv->_info;
							_tmp20_ = vala_g_array_remove_index (_tmp19_, (guint) i);
							_tmp21_ = _tmp20_;
							_formatted_text_tag_info_formatted_range_unref0 (_tmp21_);
						} else {
							FormattedTextTagInfoFormattedRange* _tmp22_;
							_tmp22_ = info;
							formatted_text_tag_info_formatted_range_set_start (_tmp22_, end);
						}
					} else {
						FormattedTextTagInfoFormattedRange* _tmp23_;
						gint _tmp24_;
						gint _tmp25_;
						FormattedTextTagInfoFormattedRange* _tmp37_;
						_tmp23_ = info;
						_tmp24_ = formatted_text_tag_info_formatted_range_get_end (_tmp23_);
						_tmp25_ = _tmp24_;
						if (_tmp25_ > end) {
							GArray* _tmp26_;
							FormattedTextTagInfoFormattedRange* _tmp27_;
							gint _tmp28_;
							gint _tmp29_;
							FormattedTextTagInfoFormattedRange* _tmp30_;
							const gchar* _tmp31_;
							const gchar* _tmp32_;
							FormattedTextTagInfoFormattedRange* _tmp33_;
							gboolean _tmp34_;
							gboolean _tmp35_;
							FormattedTextTagInfoFormattedRange* _tmp36_;
							_tmp26_ = self->priv->_info;
							_tmp27_ = info;
							_tmp28_ = formatted_text_tag_info_formatted_range_get_end (_tmp27_);
							_tmp29_ = _tmp28_;
							_tmp30_ = info;
							_tmp31_ = formatted_text_tag_info_formatted_range_get_extra (_tmp30_);
							_tmp32_ = _tmp31_;
							_tmp33_ = info;
							_tmp34_ = formatted_text_tag_info_formatted_range_get_parsed (_tmp33_);
							_tmp35_ = _tmp34_;
							_tmp36_ = formatted_text_tag_info_formatted_range_new (end, _tmp29_, _tmp32_, _tmp35_);
							g_array_append_val (_tmp26_, _tmp36_);
						}
						_tmp37_ = info;
						formatted_text_tag_info_formatted_range_set_end (_tmp37_, start);
					}
				}
				_formatted_text_tag_info_formatted_range_unref0 (info);
			}
		}
	}
	_tmp38_ = self->priv->_info;
	g_array_sort (_tmp38_, (GCompareFunc) formatted_text_tag_info_formatted_range_compare);
}

static void
formatted_text_tag_info_remove_tag_all (FormattedTextTagInfo* self)
{
	GArray* _tmp0_;
	GArray* _tmp1_;
	gint _tmp2_ = 0;
	gpointer* _tmp3_;
	FormattedTextTagInfoFormattedRange** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_info;
	_tmp1_ = self->priv->_info;
	_tmp3_ = vala_g_array_remove_range (_tmp0_, (guint) 0, _tmp1_->len, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) formatted_text_tag_info_formatted_range_unref), NULL);
}

static void
formatted_text_tag_info_remove_parsed_tags (FormattedTextTagInfo* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		GArray* _tmp0_;
		_tmp0_ = self->priv->_info;
		i = (gint) (_tmp0_->len - 1);
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				FormattedTextTagInfoFormattedRange* _tmp4_;
				gboolean _tmp5_;
				gboolean _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ - 1;
				}
				_tmp1_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp3_ = self->priv->_info;
				_tmp4_ = g_array_index (_tmp3_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp5_ = formatted_text_tag_info_formatted_range_get_parsed (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_) {
					GArray* _tmp7_;
					FormattedTextTagInfoFormattedRange* _tmp8_;
					FormattedTextTagInfoFormattedRange* _tmp9_;
					_tmp7_ = self->priv->_info;
					_tmp8_ = vala_g_array_remove_index (_tmp7_, (guint) i);
					_tmp9_ = _tmp8_;
					_formatted_text_tag_info_formatted_range_unref0 (_tmp9_);
				}
			}
		}
	}
}

static gboolean
formatted_text_tag_info_contains_tag (FormattedTextTagInfo* self,
                                      const gchar* extra)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (extra != NULL, FALSE);
	if (g_strcmp0 (extra, "") == 0) {
		GArray* _tmp0_;
		_tmp0_ = self->priv->_info;
		result = _tmp0_->len > ((guint) 0);
		return result;
	} else {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GArray* _tmp3_;
					GArray* _tmp4_;
					FormattedTextTagInfoFormattedRange* _tmp5_;
					const gchar* _tmp6_;
					const gchar* _tmp7_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = self->priv->_info;
					if (!(((guint) i) < _tmp3_->len)) {
						break;
					}
					_tmp4_ = self->priv->_info;
					_tmp5_ = g_array_index (_tmp4_, FormattedTextTagInfoFormattedRange*, (guint) i);
					_tmp6_ = formatted_text_tag_info_formatted_range_get_extra (_tmp5_);
					_tmp7_ = _tmp6_;
					if (g_strcmp0 (_tmp7_, extra) == 0) {
						result = TRUE;
						return result;
					}
				}
			}
		}
		result = FALSE;
		return result;
	}
}

static void
formatted_text_tag_info_get_extras_for_tag (FormattedTextTagInfo* self,
                                            GeeHashMap** extras)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (*extras != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				gchar* extra = NULL;
				GArray* _tmp3_;
				FormattedTextTagInfoFormattedRange* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				const gchar* _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_info;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_info;
				_tmp4_ = g_array_index (_tmp3_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp5_ = formatted_text_tag_info_formatted_range_get_extra (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strdup (_tmp6_);
				extra = _tmp7_;
				_tmp8_ = extra;
				if (!gee_abstract_map_has_key ((GeeAbstractMap*) (*extras), _tmp8_)) {
					const gchar* _tmp9_;
					_tmp9_ = extra;
					gee_abstract_map_set ((GeeAbstractMap*) (*extras), _tmp9_, (gpointer) ((gintptr) TRUE));
				}
				_g_free0 (extra);
			}
		}
	}
}

static void
formatted_text_tag_info_get_full_tags_in_range (FormattedTextTagInfo* self,
                                                gint tag,
                                                gint start,
                                                gint end,
                                                GArray** tags)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (*tags != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				FormattedTextTagInfoFormattedRange* info = NULL;
				GArray* _tmp3_;
				FormattedTextTagInfoFormattedRange* _tmp4_;
				FormattedTextTagInfoFormattedRange* _tmp5_;
				gboolean _tmp6_ = FALSE;
				FormattedTextTagInfoFormattedRange* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_info;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_info;
				_tmp4_ = g_array_index (_tmp3_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp5_ = _formatted_text_tag_info_formatted_range_ref0 (_tmp4_);
				info = _tmp5_;
				_tmp7_ = info;
				_tmp8_ = formatted_text_tag_info_formatted_range_get_end (_tmp7_);
				_tmp9_ = _tmp8_;
				if (start < _tmp9_) {
					FormattedTextTagInfoFormattedRange* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					_tmp10_ = info;
					_tmp11_ = formatted_text_tag_info_formatted_range_get_start (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp6_ = end > _tmp12_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					FormattedTextTagInfoFormattedRange* _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					FormattedTextTagInfoFormattedRange* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					FormattedTextTagInfoFormattedRange* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					FormattedTextTagInfoFormattedRange* _tmp22_;
					gboolean _tmp23_;
					gboolean _tmp24_;
					UndoTagInfo* _tmp25_;
					_tmp13_ = info;
					_tmp14_ = formatted_text_tag_info_formatted_range_get_start (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = info;
					_tmp17_ = formatted_text_tag_info_formatted_range_get_end (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = info;
					_tmp20_ = formatted_text_tag_info_formatted_range_get_extra (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = info;
					_tmp23_ = formatted_text_tag_info_formatted_range_get_parsed (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = undo_tag_info_new (tag, _tmp15_, _tmp18_, _tmp21_, _tmp24_);
					g_array_append_val (*tags, _tmp25_);
				}
				_formatted_text_tag_info_formatted_range_unref0 (info);
			}
		}
	}
}

static void
formatted_text_tag_info_get_tags_in_range (FormattedTextTagInfo* self,
                                           gint tag,
                                           gint start,
                                           gint end,
                                           GArray** tags)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (*tags != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				FormattedTextTagInfoFormattedRange* info = NULL;
				GArray* _tmp3_;
				FormattedTextTagInfoFormattedRange* _tmp4_;
				FormattedTextTagInfoFormattedRange* _tmp5_;
				gboolean _tmp6_ = FALSE;
				FormattedTextTagInfoFormattedRange* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_info;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_info;
				_tmp4_ = g_array_index (_tmp3_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp5_ = _formatted_text_tag_info_formatted_range_ref0 (_tmp4_);
				info = _tmp5_;
				_tmp7_ = info;
				_tmp8_ = formatted_text_tag_info_formatted_range_get_end (_tmp7_);
				_tmp9_ = _tmp8_;
				if (start < _tmp9_) {
					FormattedTextTagInfoFormattedRange* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					_tmp10_ = info;
					_tmp11_ = formatted_text_tag_info_formatted_range_get_start (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp6_ = end > _tmp12_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					gint _tmp13_ = 0;
					FormattedTextTagInfoFormattedRange* _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					gint save_start = 0;
					gint _tmp20_ = 0;
					FormattedTextTagInfoFormattedRange* _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					gint save_end = 0;
					FormattedTextTagInfoFormattedRange* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					FormattedTextTagInfoFormattedRange* _tmp30_;
					gboolean _tmp31_;
					gboolean _tmp32_;
					UndoTagInfo* _tmp33_;
					_tmp14_ = info;
					_tmp15_ = formatted_text_tag_info_formatted_range_get_start (_tmp14_);
					_tmp16_ = _tmp15_;
					if (_tmp16_ < start) {
						_tmp13_ = start;
					} else {
						FormattedTextTagInfoFormattedRange* _tmp17_;
						gint _tmp18_;
						gint _tmp19_;
						_tmp17_ = info;
						_tmp18_ = formatted_text_tag_info_formatted_range_get_start (_tmp17_);
						_tmp19_ = _tmp18_;
						_tmp13_ = _tmp19_;
					}
					save_start = _tmp13_;
					_tmp21_ = info;
					_tmp22_ = formatted_text_tag_info_formatted_range_get_end (_tmp21_);
					_tmp23_ = _tmp22_;
					if (_tmp23_ > end) {
						_tmp20_ = end;
					} else {
						FormattedTextTagInfoFormattedRange* _tmp24_;
						gint _tmp25_;
						gint _tmp26_;
						_tmp24_ = info;
						_tmp25_ = formatted_text_tag_info_formatted_range_get_end (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp20_ = _tmp26_;
					}
					save_end = _tmp20_;
					_tmp27_ = info;
					_tmp28_ = formatted_text_tag_info_formatted_range_get_extra (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = info;
					_tmp31_ = formatted_text_tag_info_formatted_range_get_parsed (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = undo_tag_info_new (tag, save_start - start, save_end - start, _tmp29_, _tmp32_);
					g_array_append_val (*tags, _tmp33_);
				}
				_formatted_text_tag_info_formatted_range_unref0 (info);
			}
		}
	}
}

static gboolean
formatted_text_tag_info_is_applied_at_index (FormattedTextTagInfo* self,
                                             gint index)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				FormattedTextTagInfoFormattedRange* info = NULL;
				GArray* _tmp3_;
				FormattedTextTagInfoFormattedRange* _tmp4_;
				FormattedTextTagInfoFormattedRange* _tmp5_;
				gboolean _tmp6_ = FALSE;
				FormattedTextTagInfoFormattedRange* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_info;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_info;
				_tmp4_ = g_array_index (_tmp3_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp5_ = _formatted_text_tag_info_formatted_range_ref0 (_tmp4_);
				info = _tmp5_;
				_tmp7_ = info;
				_tmp8_ = formatted_text_tag_info_formatted_range_get_start (_tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_ <= index) {
					FormattedTextTagInfoFormattedRange* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					_tmp10_ = info;
					_tmp11_ = formatted_text_tag_info_formatted_range_get_end (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp6_ = index < _tmp12_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					result = TRUE;
					_formatted_text_tag_info_formatted_range_unref0 (info);
					return result;
				}
				_formatted_text_tag_info_formatted_range_unref0 (info);
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
formatted_text_tag_info_is_applied_in_range (FormattedTextTagInfo* self,
                                             gint start,
                                             gint end)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				FormattedTextTagInfoFormattedRange* info = NULL;
				GArray* _tmp3_;
				FormattedTextTagInfoFormattedRange* _tmp4_;
				FormattedTextTagInfoFormattedRange* _tmp5_;
				gboolean _tmp6_ = FALSE;
				FormattedTextTagInfoFormattedRange* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_info;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_info;
				_tmp4_ = g_array_index (_tmp3_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp5_ = _formatted_text_tag_info_formatted_range_ref0 (_tmp4_);
				info = _tmp5_;
				_tmp7_ = info;
				_tmp8_ = formatted_text_tag_info_formatted_range_get_end (_tmp7_);
				_tmp9_ = _tmp8_;
				if (start < _tmp9_) {
					FormattedTextTagInfoFormattedRange* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					_tmp10_ = info;
					_tmp11_ = formatted_text_tag_info_formatted_range_get_start (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp6_ = end > _tmp12_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					result = TRUE;
					_formatted_text_tag_info_formatted_range_unref0 (info);
					return result;
				}
				_formatted_text_tag_info_formatted_range_unref0 (info);
			}
		}
	}
	result = FALSE;
	return result;
}

static void
formatted_text_tag_info_get_attributes (FormattedTextTagInfo* self,
                                        FormattedTextTagAttr* tag_attr,
                                        PangoAttrList** attrs)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag_attr != NULL);
	g_return_if_fail (*attrs != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				FormattedTextTagInfoFormattedRange* info = NULL;
				GArray* _tmp3_;
				FormattedTextTagInfoFormattedRange* _tmp4_;
				FormattedTextTagInfoFormattedRange* _tmp5_;
				FormattedTextTagInfoFormattedRange* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				FormattedTextTagInfoFormattedRange* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				FormattedTextTagInfoFormattedRange* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_info;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_info;
				_tmp4_ = g_array_index (_tmp3_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp5_ = _formatted_text_tag_info_formatted_range_ref0 (_tmp4_);
				info = _tmp5_;
				_tmp6_ = info;
				_tmp7_ = formatted_text_tag_info_formatted_range_get_start (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = info;
				_tmp10_ = formatted_text_tag_info_formatted_range_get_end (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = info;
				_tmp13_ = formatted_text_tag_info_formatted_range_get_extra (_tmp12_);
				_tmp14_ = _tmp13_;
				formatted_text_tag_attr_add_attrs (tag_attr, attrs, _tmp8_, _tmp11_, _tmp14_);
				_formatted_text_tag_info_formatted_range_unref0 (info);
			}
		}
	}
}

static gchar*
formatted_text_tag_info_get_extra (FormattedTextTagInfo* self,
                                   gint index)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				FormattedTextTagInfoFormattedRange* info = NULL;
				GArray* _tmp3_;
				FormattedTextTagInfoFormattedRange* _tmp4_;
				FormattedTextTagInfoFormattedRange* _tmp5_;
				gboolean _tmp6_ = FALSE;
				FormattedTextTagInfoFormattedRange* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_info;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_info;
				_tmp4_ = g_array_index (_tmp3_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp5_ = _formatted_text_tag_info_formatted_range_ref0 (_tmp4_);
				info = _tmp5_;
				_tmp7_ = info;
				_tmp8_ = formatted_text_tag_info_formatted_range_get_start (_tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_ <= index) {
					FormattedTextTagInfoFormattedRange* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					_tmp10_ = info;
					_tmp11_ = formatted_text_tag_info_formatted_range_get_end (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp6_ = index < _tmp12_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					FormattedTextTagInfoFormattedRange* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp13_ = info;
					_tmp14_ = formatted_text_tag_info_formatted_range_get_extra (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_strdup (_tmp15_);
					result = _tmp16_;
					_formatted_text_tag_info_formatted_range_unref0 (info);
					return result;
				}
				_formatted_text_tag_info_formatted_range_unref0 (info);
			}
		}
	}
	result = NULL;
	return result;
}

static void
formatted_text_tag_info_get_extra_parsed (FormattedTextTagInfo* self,
                                          gint index,
                                          gchar** extra,
                                          gboolean* parsed)
{
	gchar* _vala_extra = NULL;
	gboolean _vala_parsed = FALSE;
	g_return_if_fail (self != NULL);
	_g_free0 (_vala_extra);
	_vala_extra = NULL;
	_vala_parsed = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				FormattedTextTagInfoFormattedRange* info = NULL;
				GArray* _tmp3_;
				FormattedTextTagInfoFormattedRange* _tmp4_;
				FormattedTextTagInfoFormattedRange* _tmp5_;
				gboolean _tmp6_ = FALSE;
				FormattedTextTagInfoFormattedRange* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_info;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_info;
				_tmp4_ = g_array_index (_tmp3_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp5_ = _formatted_text_tag_info_formatted_range_ref0 (_tmp4_);
				info = _tmp5_;
				_tmp7_ = info;
				_tmp8_ = formatted_text_tag_info_formatted_range_get_start (_tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_ <= index) {
					FormattedTextTagInfoFormattedRange* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					_tmp10_ = info;
					_tmp11_ = formatted_text_tag_info_formatted_range_get_end (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp6_ = index < _tmp12_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					FormattedTextTagInfoFormattedRange* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					FormattedTextTagInfoFormattedRange* _tmp17_;
					gboolean _tmp18_;
					gboolean _tmp19_;
					_tmp13_ = info;
					_tmp14_ = formatted_text_tag_info_formatted_range_get_extra (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_strdup (_tmp15_);
					_g_free0 (_vala_extra);
					_vala_extra = _tmp16_;
					_tmp17_ = info;
					_tmp18_ = formatted_text_tag_info_formatted_range_get_parsed (_tmp17_);
					_tmp19_ = _tmp18_;
					_vala_parsed = _tmp19_;
					_formatted_text_tag_info_formatted_range_unref0 (info);
					if (extra) {
						*extra = _vala_extra;
					} else {
						_g_free0 (_vala_extra);
					}
					if (parsed) {
						*parsed = _vala_parsed;
					}
					return;
				}
				_formatted_text_tag_info_formatted_range_unref0 (info);
			}
		}
	}
	if (extra) {
		*extra = _vala_extra;
	} else {
		_g_free0 (_vala_extra);
	}
	if (parsed) {
		*parsed = _vala_parsed;
	}
}

static gchar*
formatted_text_tag_info_get_first_extra_in_range (FormattedTextTagInfo* self,
                                                  gint start,
                                                  gint end)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				FormattedTextTagInfoFormattedRange* info = NULL;
				GArray* _tmp3_;
				FormattedTextTagInfoFormattedRange* _tmp4_;
				FormattedTextTagInfoFormattedRange* _tmp5_;
				gboolean _tmp6_ = FALSE;
				FormattedTextTagInfoFormattedRange* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_info;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_info;
				_tmp4_ = g_array_index (_tmp3_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp5_ = _formatted_text_tag_info_formatted_range_ref0 (_tmp4_);
				info = _tmp5_;
				_tmp7_ = info;
				_tmp8_ = formatted_text_tag_info_formatted_range_get_end (_tmp7_);
				_tmp9_ = _tmp8_;
				if (start < _tmp9_) {
					FormattedTextTagInfoFormattedRange* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					_tmp10_ = info;
					_tmp11_ = formatted_text_tag_info_formatted_range_get_start (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp6_ = end > _tmp12_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					FormattedTextTagInfoFormattedRange* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp13_ = info;
					_tmp14_ = formatted_text_tag_info_formatted_range_get_extra (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_strdup (_tmp15_);
					result = _tmp16_;
					_formatted_text_tag_info_formatted_range_unref0 (info);
					return result;
				}
				_formatted_text_tag_info_formatted_range_unref0 (info);
			}
		}
	}
	result = NULL;
	return result;
}

static xmlNode*
formatted_text_tag_info_save (FormattedTextTagInfo* self,
                              const gchar* tag)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp13_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) tag);
	n = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				FormattedTextTagInfoFormattedRange* info = NULL;
				GArray* _tmp4_;
				FormattedTextTagInfoFormattedRange* _tmp5_;
				FormattedTextTagInfoFormattedRange* _tmp6_;
				FormattedTextTagInfoFormattedRange* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_info;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = self->priv->_info;
				_tmp5_ = g_array_index (_tmp4_, FormattedTextTagInfoFormattedRange*, (guint) i);
				_tmp6_ = _formatted_text_tag_info_formatted_range_ref0 (_tmp5_);
				info = _tmp6_;
				_tmp7_ = info;
				_tmp8_ = formatted_text_tag_info_formatted_range_get_parsed (_tmp7_);
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					xmlNode* _tmp10_;
					FormattedTextTagInfoFormattedRange* _tmp11_;
					xmlNode* _tmp12_;
					_tmp10_ = n;
					_tmp11_ = info;
					_tmp12_ = formatted_text_tag_info_formatted_range_save (_tmp11_);
					xmlAddChild (_tmp10_, _tmp12_);
				}
				_formatted_text_tag_info_formatted_range_unref0 (info);
			}
		}
	}
	_tmp13_ = n;
	result = _tmp13_;
	return result;
}

static void
formatted_text_tag_info_load (FormattedTextTagInfo* self,
                              xmlNode* n)
{
	g_return_if_fail (self != NULL);
	{
		xmlNode* it = NULL;
		xmlNode* _tmp0_;
		_tmp0_ = n->children;
		it = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp4_;
				gboolean _tmp5_ = FALSE;
				xmlNode* _tmp6_;
				if (!_tmp1_) {
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
					_tmp2_ = it;
					_tmp3_ = _tmp2_->next;
					it = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = it;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp6_ = it;
				if (_tmp6_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp7_;
					const gchar* _tmp8_;
					_tmp7_ = it;
					_tmp8_ = _tmp7_->name;
					_tmp5_ = g_strcmp0 (_tmp8_, "range") == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					GArray* _tmp9_;
					xmlNode* _tmp10_;
					FormattedTextTagInfoFormattedRange* _tmp11_;
					_tmp9_ = self->priv->_info;
					_tmp10_ = it;
					_tmp11_ = formatted_text_tag_info_formatted_range_new_from_xml (_tmp10_);
					g_array_append_val (_tmp9_, _tmp11_);
				}
			}
		}
	}
}

static GArray*
formatted_text_tag_info_get_info (FormattedTextTagInfo* self)
{
	GArray* result;
	GArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_info;
	result = _tmp0_;
	return result;
}

static inline gpointer
formatted_text_tag_info_formatted_range_get_instance_private (FormattedTextTagInfoFormattedRange* self)
{
	return G_STRUCT_MEMBER_P (self, FormattedTextTagInfoFormattedRange_private_offset);
}

static FormattedTextTagInfoFormattedRange*
formatted_text_tag_info_formatted_range_construct (GType object_type,
                                                   gint s,
                                                   gint e,
                                                   const gchar* x,
                                                   gboolean p)
{
	FormattedTextTagInfoFormattedRange* self = NULL;
	self = (FormattedTextTagInfoFormattedRange*) g_type_create_instance (object_type);
	formatted_text_tag_info_formatted_range_set_start (self, s);
	formatted_text_tag_info_formatted_range_set_end (self, e);
	formatted_text_tag_info_formatted_range_set_extra (self, x);
	formatted_text_tag_info_formatted_range_set_parsed (self, p);
	return self;
}

static FormattedTextTagInfoFormattedRange*
formatted_text_tag_info_formatted_range_new (gint s,
                                             gint e,
                                             const gchar* x,
                                             gboolean p)
{
	return formatted_text_tag_info_formatted_range_construct (FORMATTED_TEXT_TAG_INFO_TYPE_FORMATTED_RANGE, s, e, x, p);
}

static FormattedTextTagInfoFormattedRange*
formatted_text_tag_info_formatted_range_construct_from_xml (GType object_type,
                                                            xmlNode* n)
{
	FormattedTextTagInfoFormattedRange* self = NULL;
	self = (FormattedTextTagInfoFormattedRange*) g_type_create_instance (object_type);
	formatted_text_tag_info_formatted_range_load (self, n);
	return self;
}

static FormattedTextTagInfoFormattedRange*
formatted_text_tag_info_formatted_range_new_from_xml (xmlNode* n)
{
	return formatted_text_tag_info_formatted_range_construct_from_xml (FORMATTED_TEXT_TAG_INFO_TYPE_FORMATTED_RANGE, n);
}

static gboolean
formatted_text_tag_info_formatted_range_combine (FormattedTextTagInfoFormattedRange* self,
                                                 gint s,
                                                 gint e,
                                                 const gchar* x)
{
	gboolean changed = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	changed = FALSE;
	if (x != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_extra;
		_tmp0_ = g_strcmp0 (x, _tmp1_) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->_end;
	if (s <= _tmp3_) {
		gint _tmp4_;
		_tmp4_ = self->priv->_end;
		_tmp2_ = e > _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		formatted_text_tag_info_formatted_range_set_end (self, e);
		changed = TRUE;
	}
	_tmp6_ = self->priv->_start;
	if (s < _tmp6_) {
		gint _tmp7_;
		_tmp7_ = self->priv->_start;
		_tmp5_ = e >= _tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		formatted_text_tag_info_formatted_range_set_start (self, s);
		changed = TRUE;
	}
	result = changed;
	return result;
}

static xmlNode*
formatted_text_tag_info_formatted_range_save (FormattedTextTagInfoFormattedRange* self)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	xmlNode* _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	xmlNode* _tmp12_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "range");
	n = _tmp0_;
	_tmp1_ = n;
	_tmp2_ = self->priv->_start;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	xmlSetProp (_tmp1_, (xmlChar*) "start", (xmlChar*) _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = n;
	_tmp6_ = self->priv->_end;
	_tmp7_ = g_strdup_printf ("%i", _tmp6_);
	_tmp8_ = _tmp7_;
	xmlSetProp (_tmp5_, (xmlChar*) "end", (xmlChar*) _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = self->priv->_extra;
	if (_tmp9_ != NULL) {
		xmlNode* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = n;
		_tmp11_ = self->priv->_extra;
		xmlSetProp (_tmp10_, (xmlChar*) "extra", (xmlChar*) _tmp11_);
	}
	_tmp12_ = n;
	result = _tmp12_;
	return result;
}

static void
formatted_text_tag_info_formatted_range_load (FormattedTextTagInfoFormattedRange* self,
                                              xmlNode* n)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* e = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (gchar*) xmlGetProp (n, (xmlChar*) "start");
	s = _tmp0_;
	_tmp1_ = s;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = s;
		formatted_text_tag_info_formatted_range_set_start (self, atoi (_tmp2_));
	}
	_tmp3_ = (gchar*) xmlGetProp (n, (xmlChar*) "end");
	e = _tmp3_;
	_tmp4_ = e;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = e;
		formatted_text_tag_info_formatted_range_set_end (self, atoi (_tmp5_));
	}
	_tmp6_ = (gchar*) xmlGetProp (n, (xmlChar*) "extra");
	_tmp7_ = _tmp6_;
	formatted_text_tag_info_formatted_range_set_extra (self, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (e);
	_g_free0 (s);
}

static gint
formatted_text_tag_info_formatted_range_compare (void* x,
                                                 void* y)
{
	FormattedTextTagInfoFormattedRange** x1 = NULL;
	FormattedTextTagInfoFormattedRange** y1 = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint result;
	x1 = (FormattedTextTagInfoFormattedRange**) x;
	y1 = (FormattedTextTagInfoFormattedRange**) y;
	_tmp0_ = (*x1)->priv->_start;
	_tmp1_ = (*y1)->priv->_start;
	_tmp2_ = (*x1)->priv->_start;
	_tmp3_ = (*y1)->priv->_start;
	result = ((gint) (_tmp0_ > _tmp1_)) - ((gint) (_tmp2_ < _tmp3_));
	return result;
}

static gint
formatted_text_tag_info_formatted_range_get_start (FormattedTextTagInfoFormattedRange* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_start;
	return result;
}

static void
formatted_text_tag_info_formatted_range_set_start (FormattedTextTagInfoFormattedRange* self,
                                                   gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_start = value;
}

static gint
formatted_text_tag_info_formatted_range_get_end (FormattedTextTagInfoFormattedRange* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_end;
	return result;
}

static void
formatted_text_tag_info_formatted_range_set_end (FormattedTextTagInfoFormattedRange* self,
                                                 gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_end = value;
}

static gboolean
formatted_text_tag_info_formatted_range_get_parsed (FormattedTextTagInfoFormattedRange* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_parsed;
	return result;
}

static void
formatted_text_tag_info_formatted_range_set_parsed (FormattedTextTagInfoFormattedRange* self,
                                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_parsed = value;
}

static const gchar*
formatted_text_tag_info_formatted_range_get_extra (FormattedTextTagInfoFormattedRange* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extra;
	result = _tmp0_;
	return result;
}

static void
formatted_text_tag_info_formatted_range_set_extra (FormattedTextTagInfoFormattedRange* self,
                                                   const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_extra);
	self->priv->_extra = _tmp0_;
}

static void
formatted_text_tag_info_value_formatted_range_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
formatted_text_tag_info_value_formatted_range_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		formatted_text_tag_info_formatted_range_unref (value->data[0].v_pointer);
	}
}

static void
formatted_text_tag_info_value_formatted_range_copy_value (const GValue* src_value,
                                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = formatted_text_tag_info_formatted_range_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
formatted_text_tag_info_value_formatted_range_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
formatted_text_tag_info_value_formatted_range_collect_value (GValue* value,
                                                             guint n_collect_values,
                                                             GTypeCValue* collect_values,
                                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FormattedTextTagInfoFormattedRange * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = formatted_text_tag_info_formatted_range_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
formatted_text_tag_info_value_formatted_range_lcopy_value (const GValue* value,
                                                           guint n_collect_values,
                                                           GTypeCValue* collect_values,
                                                           guint collect_flags)
{
	FormattedTextTagInfoFormattedRange ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = formatted_text_tag_info_formatted_range_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
formatted_text_tag_info_param_spec_formatted_range (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags)
{
	FormattedTextTagInfoParamSpecFormattedRange* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FORMATTED_TEXT_TAG_INFO_TYPE_FORMATTED_RANGE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
formatted_text_tag_info_value_get_formatted_range (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FORMATTED_TEXT_TAG_INFO_TYPE_FORMATTED_RANGE), NULL);
	return value->data[0].v_pointer;
}

static void
formatted_text_tag_info_value_set_formatted_range (GValue* value,
                                                   gpointer v_object)
{
	FormattedTextTagInfoFormattedRange * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FORMATTED_TEXT_TAG_INFO_TYPE_FORMATTED_RANGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FORMATTED_TEXT_TAG_INFO_TYPE_FORMATTED_RANGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		formatted_text_tag_info_formatted_range_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		formatted_text_tag_info_formatted_range_unref (old);
	}
}

static void
formatted_text_tag_info_value_take_formatted_range (GValue* value,
                                                    gpointer v_object)
{
	FormattedTextTagInfoFormattedRange * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FORMATTED_TEXT_TAG_INFO_TYPE_FORMATTED_RANGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FORMATTED_TEXT_TAG_INFO_TYPE_FORMATTED_RANGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		formatted_text_tag_info_formatted_range_unref (old);
	}
}

static void
formatted_text_tag_info_formatted_range_class_init (FormattedTextTagInfoFormattedRangeClass * klass,
                                                    gpointer klass_data)
{
	formatted_text_tag_info_formatted_range_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextTagInfoFormattedRangeClass *) klass)->finalize = formatted_text_tag_info_formatted_range_finalize;
	g_type_class_adjust_private_offset (klass, &FormattedTextTagInfoFormattedRange_private_offset);
}

static void
formatted_text_tag_info_formatted_range_instance_init (FormattedTextTagInfoFormattedRange * self,
                                                       gpointer klass)
{
	self->priv = formatted_text_tag_info_formatted_range_get_instance_private (self);
	self->priv->_start = 0;
	self->priv->_end = 0;
	self->priv->_parsed = FALSE;
	self->priv->_extra = NULL;
	self->ref_count = 1;
}

static void
formatted_text_tag_info_formatted_range_finalize (FormattedTextTagInfoFormattedRange * obj)
{
	FormattedTextTagInfoFormattedRange * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FORMATTED_TEXT_TAG_INFO_TYPE_FORMATTED_RANGE, FormattedTextTagInfoFormattedRange);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_extra);
}

static GType
formatted_text_tag_info_formatted_range_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { formatted_text_tag_info_value_formatted_range_init, formatted_text_tag_info_value_formatted_range_free_value, formatted_text_tag_info_value_formatted_range_copy_value, formatted_text_tag_info_value_formatted_range_peek_pointer, "p", formatted_text_tag_info_value_formatted_range_collect_value, "p", formatted_text_tag_info_value_formatted_range_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextTagInfoFormattedRangeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_tag_info_formatted_range_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextTagInfoFormattedRange), 0, (GInstanceInitFunc) formatted_text_tag_info_formatted_range_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType formatted_text_tag_info_formatted_range_type_id;
	formatted_text_tag_info_formatted_range_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FormattedTextTagInfoFormattedRange", &g_define_type_info, &g_define_type_fundamental_info, 0);
	FormattedTextTagInfoFormattedRange_private_offset = g_type_add_instance_private (formatted_text_tag_info_formatted_range_type_id, sizeof (FormattedTextTagInfoFormattedRangePrivate));
	return formatted_text_tag_info_formatted_range_type_id;
}

GType
formatted_text_tag_info_formatted_range_get_type (void)
{
	static volatile gsize formatted_text_tag_info_formatted_range_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_tag_info_formatted_range_type_id__once)) {
		GType formatted_text_tag_info_formatted_range_type_id;
		formatted_text_tag_info_formatted_range_type_id = formatted_text_tag_info_formatted_range_get_type_once ();
		g_once_init_leave (&formatted_text_tag_info_formatted_range_type_id__once, formatted_text_tag_info_formatted_range_type_id);
	}
	return formatted_text_tag_info_formatted_range_type_id__once;
}

static gpointer
formatted_text_tag_info_formatted_range_ref (gpointer instance)
{
	FormattedTextTagInfoFormattedRange * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
formatted_text_tag_info_formatted_range_unref (gpointer instance)
{
	FormattedTextTagInfoFormattedRange * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FORMATTED_TEXT_TAG_INFO_FORMATTED_RANGE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
formatted_text_value_tag_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
formatted_text_value_tag_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		formatted_text_tag_info_unref (value->data[0].v_pointer);
	}
}

static void
formatted_text_value_tag_info_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = formatted_text_tag_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
formatted_text_value_tag_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
formatted_text_value_tag_info_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FormattedTextTagInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = formatted_text_tag_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
formatted_text_value_tag_info_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	FormattedTextTagInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = formatted_text_tag_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
formatted_text_param_spec_tag_info (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	FormattedTextParamSpecTagInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FORMATTED_TEXT_TYPE_TAG_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
formatted_text_value_get_tag_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FORMATTED_TEXT_TYPE_TAG_INFO), NULL);
	return value->data[0].v_pointer;
}

static void
formatted_text_value_set_tag_info (GValue* value,
                                   gpointer v_object)
{
	FormattedTextTagInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FORMATTED_TEXT_TYPE_TAG_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FORMATTED_TEXT_TYPE_TAG_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		formatted_text_tag_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		formatted_text_tag_info_unref (old);
	}
}

static void
formatted_text_value_take_tag_info (GValue* value,
                                    gpointer v_object)
{
	FormattedTextTagInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FORMATTED_TEXT_TYPE_TAG_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FORMATTED_TEXT_TYPE_TAG_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		formatted_text_tag_info_unref (old);
	}
}

static void
formatted_text_tag_info_class_init (FormattedTextTagInfoClass * klass,
                                    gpointer klass_data)
{
	formatted_text_tag_info_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextTagInfoClass *) klass)->finalize = formatted_text_tag_info_finalize;
	g_type_class_adjust_private_offset (klass, &FormattedTextTagInfo_private_offset);
}

static void
formatted_text_tag_info_instance_init (FormattedTextTagInfo * self,
                                       gpointer klass)
{
	self->priv = formatted_text_tag_info_get_instance_private (self);
	self->ref_count = 1;
}

static void
formatted_text_tag_info_finalize (FormattedTextTagInfo * obj)
{
	FormattedTextTagInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FORMATTED_TEXT_TYPE_TAG_INFO, FormattedTextTagInfo);
	g_signal_handlers_destroy (self);
	_g_array_unref0 (self->priv->_info);
}

static GType
formatted_text_tag_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { formatted_text_value_tag_info_init, formatted_text_value_tag_info_free_value, formatted_text_value_tag_info_copy_value, formatted_text_value_tag_info_peek_pointer, "p", formatted_text_value_tag_info_collect_value, "p", formatted_text_value_tag_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextTagInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_tag_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextTagInfo), 0, (GInstanceInitFunc) formatted_text_tag_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType formatted_text_tag_info_type_id;
	formatted_text_tag_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FormattedTextTagInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	FormattedTextTagInfo_private_offset = g_type_add_instance_private (formatted_text_tag_info_type_id, sizeof (FormattedTextTagInfoPrivate));
	return formatted_text_tag_info_type_id;
}

static GType
formatted_text_tag_info_get_type (void)
{
	static volatile gsize formatted_text_tag_info_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_tag_info_type_id__once)) {
		GType formatted_text_tag_info_type_id;
		formatted_text_tag_info_type_id = formatted_text_tag_info_get_type_once ();
		g_once_init_leave (&formatted_text_tag_info_type_id__once, formatted_text_tag_info_type_id);
	}
	return formatted_text_tag_info_type_id__once;
}

static gpointer
formatted_text_tag_info_ref (gpointer instance)
{
	FormattedTextTagInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
formatted_text_tag_info_unref (gpointer instance)
{
	FormattedTextTagInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FORMATTED_TEXT_TAG_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_pango_attribute_destroy0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL));
}

static void
_vala_PangoAttribute_free_function_content_of (gpointer data)
{
	PangoAttribute* self;
	self = *((PangoAttribute**) data);
	_pango_attribute_destroy0_ (self);
}

static FormattedTextTagAttr*
formatted_text_tag_attr_construct (GType object_type)
{
	FormattedTextTagAttr* self = NULL;
	GArray* _tmp0_;
	self = (FormattedTextTagAttr*) g_type_create_instance (object_type);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (PangoAttribute*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_PangoAttribute_free_function_content_of);
	_g_array_unref0 (self->attrs);
	self->attrs = _tmp0_;
	return self;
}

static FormattedTextTagAttr*
formatted_text_tag_attr_new (void)
{
	return formatted_text_tag_attr_construct (FORMATTED_TEXT_TYPE_TAG_ATTR);
}

static FormattedTextTagAttr*
formatted_text_tag_attr_construct_copy_from (GType object_type,
                                             FormattedTextTagAttr* ta)
{
	FormattedTextTagAttr* self = NULL;
	GArray* _tmp0_;
	g_return_val_if_fail (ta != NULL, NULL);
	self = (FormattedTextTagAttr*) g_type_create_instance (object_type);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (PangoAttribute*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_PangoAttribute_free_function_content_of);
	_g_array_unref0 (self->attrs);
	self->attrs = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				GArray* _tmp4_;
				GArray* _tmp5_;
				PangoAttribute* _tmp6_;
				PangoAttribute* _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = ta->attrs;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = self->attrs;
				_tmp5_ = ta->attrs;
				_tmp6_ = g_array_index (_tmp5_, PangoAttribute*, (guint) i);
				_tmp7_ = pango_attribute_copy (_tmp6_);
				g_array_append_val (_tmp4_, _tmp7_);
			}
		}
	}
	return self;
}

static FormattedTextTagAttr*
formatted_text_tag_attr_new_copy_from (FormattedTextTagAttr* ta)
{
	return formatted_text_tag_attr_construct_copy_from (FORMATTED_TEXT_TYPE_TAG_ATTR, ta);
}

static void
formatted_text_tag_attr_real_add_attrs (FormattedTextTagAttr* self,
                                        PangoAttrList** list,
                                        gint start,
                                        gint end,
                                        const gchar* extra)
{
	g_return_if_fail (*list != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				PangoAttribute* attr = NULL;
				GArray* _tmp3_;
				PangoAttribute* _tmp4_;
				PangoAttribute* _tmp5_;
				PangoAttribute* _tmp6_;
				PangoAttribute* _tmp7_;
				PangoAttribute* _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->attrs;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->attrs;
				_tmp4_ = g_array_index (_tmp3_, PangoAttribute*, (guint) i);
				_tmp5_ = pango_attribute_copy (_tmp4_);
				attr = _tmp5_;
				_tmp6_ = attr;
				_tmp6_->start_index = (guint) start;
				_tmp7_ = attr;
				_tmp7_->end_index = (guint) end;
				_tmp8_ = attr;
				attr = NULL;
				pango_attr_list_change (*list, _tmp8_);
				_pango_attribute_destroy0 (attr);
			}
		}
	}
}

void
formatted_text_tag_attr_add_attrs (FormattedTextTagAttr* self,
                                   PangoAttrList** list,
                                   gint start,
                                   gint end,
                                   const gchar* extra)
{
	FormattedTextTagAttrClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FORMATTED_TEXT_TAG_ATTR_GET_CLASS (self);
	if (_klass_->add_attrs) {
		_klass_->add_attrs (self, list, start, end, extra);
	}
}

static GtkTextTag*
formatted_text_tag_attr_real_text_tag (FormattedTextTagAttr* self,
                                       const gchar* extra)
{
	GtkTextTag* _tmp0_;
	GtkTextTag* result;
	_tmp0_ = gtk_text_tag_new (NULL);
	result = _tmp0_;
	return result;
}

GtkTextTag*
formatted_text_tag_attr_text_tag (FormattedTextTagAttr* self,
                                  const gchar* extra)
{
	FormattedTextTagAttrClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FORMATTED_TEXT_TAG_ATTR_GET_CLASS (self);
	if (_klass_->text_tag) {
		return _klass_->text_tag (self, extra);
	}
	return NULL;
}

static void
formatted_text_tag_attr_get_color (FormattedTextTagAttr* self,
                                   const gchar* value,
                                   GdkRGBA* result)
{
	GdkRGBA c = {0};
	GdkRGBA _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_.red = 1.0;
	_tmp0_.green = 1.0;
	_tmp0_.blue = 1.0;
	_tmp0_.alpha = 1.0;
	c = _tmp0_;
	gdk_rgba_parse (&c, value);
	*result = c;
	return;
}

static void
formatted_text_value_tag_attr_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
formatted_text_value_tag_attr_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		formatted_text_tag_attr_unref (value->data[0].v_pointer);
	}
}

static void
formatted_text_value_tag_attr_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = formatted_text_tag_attr_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
formatted_text_value_tag_attr_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
formatted_text_value_tag_attr_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FormattedTextTagAttr * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = formatted_text_tag_attr_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
formatted_text_value_tag_attr_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	FormattedTextTagAttr ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = formatted_text_tag_attr_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
formatted_text_param_spec_tag_attr (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	FormattedTextParamSpecTagAttr* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FORMATTED_TEXT_TYPE_TAG_ATTR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
formatted_text_value_get_tag_attr (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FORMATTED_TEXT_TYPE_TAG_ATTR), NULL);
	return value->data[0].v_pointer;
}

static void
formatted_text_value_set_tag_attr (GValue* value,
                                   gpointer v_object)
{
	FormattedTextTagAttr * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FORMATTED_TEXT_TYPE_TAG_ATTR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FORMATTED_TEXT_TYPE_TAG_ATTR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		formatted_text_tag_attr_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		formatted_text_tag_attr_unref (old);
	}
}

static void
formatted_text_value_take_tag_attr (GValue* value,
                                    gpointer v_object)
{
	FormattedTextTagAttr * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FORMATTED_TEXT_TYPE_TAG_ATTR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FORMATTED_TEXT_TYPE_TAG_ATTR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		formatted_text_tag_attr_unref (old);
	}
}

static void
formatted_text_tag_attr_class_init (FormattedTextTagAttrClass * klass,
                                    gpointer klass_data)
{
	formatted_text_tag_attr_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextTagAttrClass *) klass)->finalize = formatted_text_tag_attr_finalize;
	((FormattedTextTagAttrClass *) klass)->add_attrs = (void (*) (FormattedTextTagAttr*, PangoAttrList**, gint, gint, const gchar*)) formatted_text_tag_attr_real_add_attrs;
	((FormattedTextTagAttrClass *) klass)->text_tag = (GtkTextTag* (*) (FormattedTextTagAttr*, const gchar*)) formatted_text_tag_attr_real_text_tag;
}

static void
formatted_text_tag_attr_instance_init (FormattedTextTagAttr * self,
                                       gpointer klass)
{
	self->ref_count = 1;
}

static void
formatted_text_tag_attr_finalize (FormattedTextTagAttr * obj)
{
	FormattedTextTagAttr * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FORMATTED_TEXT_TYPE_TAG_ATTR, FormattedTextTagAttr);
	g_signal_handlers_destroy (self);
	_g_array_unref0 (self->attrs);
}

static GType
formatted_text_tag_attr_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { formatted_text_value_tag_attr_init, formatted_text_value_tag_attr_free_value, formatted_text_value_tag_attr_copy_value, formatted_text_value_tag_attr_peek_pointer, "p", formatted_text_value_tag_attr_collect_value, "p", formatted_text_value_tag_attr_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextTagAttrClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_tag_attr_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextTagAttr), 0, (GInstanceInitFunc) formatted_text_tag_attr_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType formatted_text_tag_attr_type_id;
	formatted_text_tag_attr_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FormattedTextTagAttr", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return formatted_text_tag_attr_type_id;
}

static GType
formatted_text_tag_attr_get_type (void)
{
	static volatile gsize formatted_text_tag_attr_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_tag_attr_type_id__once)) {
		GType formatted_text_tag_attr_type_id;
		formatted_text_tag_attr_type_id = formatted_text_tag_attr_get_type_once ();
		g_once_init_leave (&formatted_text_tag_attr_type_id__once, formatted_text_tag_attr_type_id);
	}
	return formatted_text_tag_attr_type_id__once;
}

static gpointer
formatted_text_tag_attr_ref (gpointer instance)
{
	FormattedTextTagAttr * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
formatted_text_tag_attr_unref (gpointer instance)
{
	FormattedTextTagAttr * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FORMATTED_TEXT_TAG_ATTR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static FormattedTextBoldInfo*
formatted_text_bold_info_construct (GType object_type)
{
	FormattedTextBoldInfo* self = NULL;
	GArray* _tmp0_;
	PangoAttribute* _tmp1_;
	self = (FormattedTextBoldInfo*) formatted_text_tag_attr_construct (object_type);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp1_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	g_array_append_val (_tmp0_, _tmp1_);
	return self;
}

static FormattedTextBoldInfo*
formatted_text_bold_info_new (void)
{
	return formatted_text_bold_info_construct (FORMATTED_TEXT_TYPE_BOLD_INFO);
}

static GtkTextTag*
formatted_text_bold_info_real_text_tag (FormattedTextTagAttr* base,
                                        const gchar* extra)
{
	FormattedTextBoldInfo * self;
	GtkTextTag* ttag = NULL;
	GtkTextTag* _tmp0_;
	GtkTextTag* result;
	self = (FormattedTextBoldInfo*) base;
	_tmp0_ = gtk_text_tag_new ("bold");
	ttag = _tmp0_;
	g_object_set (ttag, "weight", (gint) PANGO_WEIGHT_BOLD, NULL);
	g_object_set (ttag, "weight-set", TRUE, NULL);
	result = ttag;
	return result;
}

static void
formatted_text_bold_info_class_init (FormattedTextBoldInfoClass * klass,
                                     gpointer klass_data)
{
	formatted_text_bold_info_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextTagAttrClass *) klass)->text_tag = (GtkTextTag* (*) (FormattedTextTagAttr*, const gchar*)) formatted_text_bold_info_real_text_tag;
}

static void
formatted_text_bold_info_instance_init (FormattedTextBoldInfo * self,
                                        gpointer klass)
{
}

static GType
formatted_text_bold_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextBoldInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_bold_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextBoldInfo), 0, (GInstanceInitFunc) formatted_text_bold_info_instance_init, NULL };
	GType formatted_text_bold_info_type_id;
	formatted_text_bold_info_type_id = g_type_register_static (FORMATTED_TEXT_TYPE_TAG_ATTR, "FormattedTextBoldInfo", &g_define_type_info, 0);
	return formatted_text_bold_info_type_id;
}

static GType
formatted_text_bold_info_get_type (void)
{
	static volatile gsize formatted_text_bold_info_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_bold_info_type_id__once)) {
		GType formatted_text_bold_info_type_id;
		formatted_text_bold_info_type_id = formatted_text_bold_info_get_type_once ();
		g_once_init_leave (&formatted_text_bold_info_type_id__once, formatted_text_bold_info_type_id);
	}
	return formatted_text_bold_info_type_id__once;
}

static FormattedTextItalicsInfo*
formatted_text_italics_info_construct (GType object_type)
{
	FormattedTextItalicsInfo* self = NULL;
	GArray* _tmp0_;
	PangoAttribute* _tmp1_;
	self = (FormattedTextItalicsInfo*) formatted_text_tag_attr_construct (object_type);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp1_ = pango_attr_style_new (PANGO_STYLE_ITALIC);
	g_array_append_val (_tmp0_, _tmp1_);
	return self;
}

static FormattedTextItalicsInfo*
formatted_text_italics_info_new (void)
{
	return formatted_text_italics_info_construct (FORMATTED_TEXT_TYPE_ITALICS_INFO);
}

static GtkTextTag*
formatted_text_italics_info_real_text_tag (FormattedTextTagAttr* base,
                                           const gchar* extra)
{
	FormattedTextItalicsInfo * self;
	GtkTextTag* ttag = NULL;
	GtkTextTag* _tmp0_;
	GtkTextTag* result;
	self = (FormattedTextItalicsInfo*) base;
	_tmp0_ = gtk_text_tag_new ("italics");
	ttag = _tmp0_;
	g_object_set (ttag, "style", PANGO_STYLE_ITALIC, NULL);
	g_object_set (ttag, "style-set", TRUE, NULL);
	result = ttag;
	return result;
}

static void
formatted_text_italics_info_class_init (FormattedTextItalicsInfoClass * klass,
                                        gpointer klass_data)
{
	formatted_text_italics_info_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextTagAttrClass *) klass)->text_tag = (GtkTextTag* (*) (FormattedTextTagAttr*, const gchar*)) formatted_text_italics_info_real_text_tag;
}

static void
formatted_text_italics_info_instance_init (FormattedTextItalicsInfo * self,
                                           gpointer klass)
{
}

static GType
formatted_text_italics_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextItalicsInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_italics_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextItalicsInfo), 0, (GInstanceInitFunc) formatted_text_italics_info_instance_init, NULL };
	GType formatted_text_italics_info_type_id;
	formatted_text_italics_info_type_id = g_type_register_static (FORMATTED_TEXT_TYPE_TAG_ATTR, "FormattedTextItalicsInfo", &g_define_type_info, 0);
	return formatted_text_italics_info_type_id;
}

static GType
formatted_text_italics_info_get_type (void)
{
	static volatile gsize formatted_text_italics_info_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_italics_info_type_id__once)) {
		GType formatted_text_italics_info_type_id;
		formatted_text_italics_info_type_id = formatted_text_italics_info_get_type_once ();
		g_once_init_leave (&formatted_text_italics_info_type_id__once, formatted_text_italics_info_type_id);
	}
	return formatted_text_italics_info_type_id__once;
}

static FormattedTextUnderlineInfo*
formatted_text_underline_info_construct (GType object_type)
{
	FormattedTextUnderlineInfo* self = NULL;
	GArray* _tmp0_;
	PangoAttribute* _tmp1_;
	self = (FormattedTextUnderlineInfo*) formatted_text_tag_attr_construct (object_type);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp1_ = pango_attr_underline_new (PANGO_UNDERLINE_SINGLE);
	g_array_append_val (_tmp0_, _tmp1_);
	return self;
}

static FormattedTextUnderlineInfo*
formatted_text_underline_info_new (void)
{
	return formatted_text_underline_info_construct (FORMATTED_TEXT_TYPE_UNDERLINE_INFO);
}

static GtkTextTag*
formatted_text_underline_info_real_text_tag (FormattedTextTagAttr* base,
                                             const gchar* extra)
{
	FormattedTextUnderlineInfo * self;
	GtkTextTag* ttag = NULL;
	GtkTextTag* _tmp0_;
	GtkTextTag* result;
	self = (FormattedTextUnderlineInfo*) base;
	_tmp0_ = gtk_text_tag_new ("underline");
	ttag = _tmp0_;
	g_object_set (ttag, "underline", PANGO_UNDERLINE_SINGLE, NULL);
	g_object_set (ttag, "underline-set", TRUE, NULL);
	result = ttag;
	return result;
}

static void
formatted_text_underline_info_class_init (FormattedTextUnderlineInfoClass * klass,
                                          gpointer klass_data)
{
	formatted_text_underline_info_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextTagAttrClass *) klass)->text_tag = (GtkTextTag* (*) (FormattedTextTagAttr*, const gchar*)) formatted_text_underline_info_real_text_tag;
}

static void
formatted_text_underline_info_instance_init (FormattedTextUnderlineInfo * self,
                                             gpointer klass)
{
}

static GType
formatted_text_underline_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextUnderlineInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_underline_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextUnderlineInfo), 0, (GInstanceInitFunc) formatted_text_underline_info_instance_init, NULL };
	GType formatted_text_underline_info_type_id;
	formatted_text_underline_info_type_id = g_type_register_static (FORMATTED_TEXT_TYPE_TAG_ATTR, "FormattedTextUnderlineInfo", &g_define_type_info, 0);
	return formatted_text_underline_info_type_id;
}

static GType
formatted_text_underline_info_get_type (void)
{
	static volatile gsize formatted_text_underline_info_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_underline_info_type_id__once)) {
		GType formatted_text_underline_info_type_id;
		formatted_text_underline_info_type_id = formatted_text_underline_info_get_type_once ();
		g_once_init_leave (&formatted_text_underline_info_type_id__once, formatted_text_underline_info_type_id);
	}
	return formatted_text_underline_info_type_id__once;
}

static FormattedTextStrikeThruInfo*
formatted_text_strike_thru_info_construct (GType object_type)
{
	FormattedTextStrikeThruInfo* self = NULL;
	GArray* _tmp0_;
	PangoAttribute* _tmp1_;
	self = (FormattedTextStrikeThruInfo*) formatted_text_tag_attr_construct (object_type);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp1_ = pango_attr_strikethrough_new (TRUE);
	g_array_append_val (_tmp0_, _tmp1_);
	return self;
}

static FormattedTextStrikeThruInfo*
formatted_text_strike_thru_info_new (void)
{
	return formatted_text_strike_thru_info_construct (FORMATTED_TEXT_TYPE_STRIKE_THRU_INFO);
}

static GtkTextTag*
formatted_text_strike_thru_info_real_text_tag (FormattedTextTagAttr* base,
                                               const gchar* extra)
{
	FormattedTextStrikeThruInfo * self;
	GtkTextTag* ttag = NULL;
	GtkTextTag* _tmp0_;
	GtkTextTag* result;
	self = (FormattedTextStrikeThruInfo*) base;
	_tmp0_ = gtk_text_tag_new ("strikethru");
	ttag = _tmp0_;
	g_object_set (ttag, "strikethrough", TRUE, NULL);
	g_object_set (ttag, "strikethrough-set", TRUE, NULL);
	result = ttag;
	return result;
}

static void
formatted_text_strike_thru_info_class_init (FormattedTextStrikeThruInfoClass * klass,
                                            gpointer klass_data)
{
	formatted_text_strike_thru_info_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextTagAttrClass *) klass)->text_tag = (GtkTextTag* (*) (FormattedTextTagAttr*, const gchar*)) formatted_text_strike_thru_info_real_text_tag;
}

static void
formatted_text_strike_thru_info_instance_init (FormattedTextStrikeThruInfo * self,
                                               gpointer klass)
{
}

static GType
formatted_text_strike_thru_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextStrikeThruInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_strike_thru_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextStrikeThruInfo), 0, (GInstanceInitFunc) formatted_text_strike_thru_info_instance_init, NULL };
	GType formatted_text_strike_thru_info_type_id;
	formatted_text_strike_thru_info_type_id = g_type_register_static (FORMATTED_TEXT_TYPE_TAG_ATTR, "FormattedTextStrikeThruInfo", &g_define_type_info, 0);
	return formatted_text_strike_thru_info_type_id;
}

static GType
formatted_text_strike_thru_info_get_type (void)
{
	static volatile gsize formatted_text_strike_thru_info_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_strike_thru_info_type_id__once)) {
		GType formatted_text_strike_thru_info_type_id;
		formatted_text_strike_thru_info_type_id = formatted_text_strike_thru_info_get_type_once ();
		g_once_init_leave (&formatted_text_strike_thru_info_type_id__once, formatted_text_strike_thru_info_type_id);
	}
	return formatted_text_strike_thru_info_type_id__once;
}

static FormattedTextCodeInfo*
formatted_text_code_info_construct (GType object_type,
                                    DrawArea* da)
{
	FormattedTextCodeInfo* self = NULL;
	GArray* _tmp0_;
	PangoAttribute* _tmp1_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (FormattedTextCodeInfo*) formatted_text_tag_attr_construct (object_type);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp1_ = pango_attr_family_new ("Monospace");
	g_array_append_val (_tmp0_, _tmp1_);
	return self;
}

static FormattedTextCodeInfo*
formatted_text_code_info_new (DrawArea* da)
{
	return formatted_text_code_info_construct (FORMATTED_TEXT_TYPE_CODE_INFO, da);
}

static GtkTextTag*
formatted_text_code_info_real_text_tag (FormattedTextTagAttr* base,
                                        const gchar* extra)
{
	FormattedTextCodeInfo * self;
	GtkTextTag* ttag = NULL;
	GtkTextTag* _tmp0_;
	GtkTextTag* result;
	self = (FormattedTextCodeInfo*) base;
	_tmp0_ = gtk_text_tag_new ("code");
	ttag = _tmp0_;
	g_object_set (ttag, "family", "Monospace", NULL);
	g_object_set (ttag, "family-set", TRUE, NULL);
	result = ttag;
	return result;
}

static void
formatted_text_code_info_class_init (FormattedTextCodeInfoClass * klass,
                                     gpointer klass_data)
{
	formatted_text_code_info_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextTagAttrClass *) klass)->text_tag = (GtkTextTag* (*) (FormattedTextTagAttr*, const gchar*)) formatted_text_code_info_real_text_tag;
}

static void
formatted_text_code_info_instance_init (FormattedTextCodeInfo * self,
                                        gpointer klass)
{
}

static GType
formatted_text_code_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextCodeInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_code_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextCodeInfo), 0, (GInstanceInitFunc) formatted_text_code_info_instance_init, NULL };
	GType formatted_text_code_info_type_id;
	formatted_text_code_info_type_id = g_type_register_static (FORMATTED_TEXT_TYPE_TAG_ATTR, "FormattedTextCodeInfo", &g_define_type_info, 0);
	return formatted_text_code_info_type_id;
}

static GType
formatted_text_code_info_get_type (void)
{
	static volatile gsize formatted_text_code_info_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_code_info_type_id__once)) {
		GType formatted_text_code_info_type_id;
		formatted_text_code_info_type_id = formatted_text_code_info_get_type_once ();
		g_once_init_leave (&formatted_text_code_info_type_id__once, formatted_text_code_info_type_id);
	}
	return formatted_text_code_info_type_id__once;
}

static FormattedTextSubInfo*
formatted_text_sub_info_construct (GType object_type)
{
	FormattedTextSubInfo* self = NULL;
	GArray* _tmp0_;
	PangoAttribute* _tmp1_;
	self = (FormattedTextSubInfo*) formatted_text_tag_attr_construct (object_type);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp1_ = pango_attr_rise_new (0 - (4 * PANGO_SCALE));
	g_array_append_val (_tmp0_, _tmp1_);
	return self;
}

static FormattedTextSubInfo*
formatted_text_sub_info_new (void)
{
	return formatted_text_sub_info_construct (FORMATTED_TEXT_TYPE_SUB_INFO);
}

static GtkTextTag*
formatted_text_sub_info_real_text_tag (FormattedTextTagAttr* base,
                                       const gchar* extra)
{
	FormattedTextSubInfo * self;
	GtkTextTag* ttag = NULL;
	GtkTextTag* _tmp0_;
	GtkTextTag* result;
	self = (FormattedTextSubInfo*) base;
	_tmp0_ = gtk_text_tag_new ("subscript");
	ttag = _tmp0_;
	g_object_set (ttag, "rise", 0 - (4 * PANGO_SCALE), NULL);
	g_object_set (ttag, "rise-set", TRUE, NULL);
	result = ttag;
	return result;
}

static void
formatted_text_sub_info_class_init (FormattedTextSubInfoClass * klass,
                                    gpointer klass_data)
{
	formatted_text_sub_info_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextTagAttrClass *) klass)->text_tag = (GtkTextTag* (*) (FormattedTextTagAttr*, const gchar*)) formatted_text_sub_info_real_text_tag;
}

static void
formatted_text_sub_info_instance_init (FormattedTextSubInfo * self,
                                       gpointer klass)
{
}

static GType
formatted_text_sub_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextSubInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_sub_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextSubInfo), 0, (GInstanceInitFunc) formatted_text_sub_info_instance_init, NULL };
	GType formatted_text_sub_info_type_id;
	formatted_text_sub_info_type_id = g_type_register_static (FORMATTED_TEXT_TYPE_TAG_ATTR, "FormattedTextSubInfo", &g_define_type_info, 0);
	return formatted_text_sub_info_type_id;
}

static GType
formatted_text_sub_info_get_type (void)
{
	static volatile gsize formatted_text_sub_info_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_sub_info_type_id__once)) {
		GType formatted_text_sub_info_type_id;
		formatted_text_sub_info_type_id = formatted_text_sub_info_get_type_once ();
		g_once_init_leave (&formatted_text_sub_info_type_id__once, formatted_text_sub_info_type_id);
	}
	return formatted_text_sub_info_type_id__once;
}

static FormattedTextSuperInfo*
formatted_text_super_info_construct (GType object_type)
{
	FormattedTextSuperInfo* self = NULL;
	GArray* _tmp0_;
	PangoAttribute* _tmp1_;
	self = (FormattedTextSuperInfo*) formatted_text_tag_attr_construct (object_type);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp1_ = pango_attr_rise_new (4 * PANGO_SCALE);
	g_array_append_val (_tmp0_, _tmp1_);
	return self;
}

static FormattedTextSuperInfo*
formatted_text_super_info_new (void)
{
	return formatted_text_super_info_construct (FORMATTED_TEXT_TYPE_SUPER_INFO);
}

static GtkTextTag*
formatted_text_super_info_real_text_tag (FormattedTextTagAttr* base,
                                         const gchar* extra)
{
	FormattedTextSuperInfo * self;
	GtkTextTag* ttag = NULL;
	GtkTextTag* _tmp0_;
	GtkTextTag* result;
	self = (FormattedTextSuperInfo*) base;
	_tmp0_ = gtk_text_tag_new ("superscript");
	ttag = _tmp0_;
	g_object_set (ttag, "rise", 4 * PANGO_SCALE, NULL);
	g_object_set (ttag, "rise-set", TRUE, NULL);
	result = ttag;
	return result;
}

static void
formatted_text_super_info_class_init (FormattedTextSuperInfoClass * klass,
                                      gpointer klass_data)
{
	formatted_text_super_info_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextTagAttrClass *) klass)->text_tag = (GtkTextTag* (*) (FormattedTextTagAttr*, const gchar*)) formatted_text_super_info_real_text_tag;
}

static void
formatted_text_super_info_instance_init (FormattedTextSuperInfo * self,
                                         gpointer klass)
{
}

static GType
formatted_text_super_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextSuperInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_super_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextSuperInfo), 0, (GInstanceInitFunc) formatted_text_super_info_instance_init, NULL };
	GType formatted_text_super_info_type_id;
	formatted_text_super_info_type_id = g_type_register_static (FORMATTED_TEXT_TYPE_TAG_ATTR, "FormattedTextSuperInfo", &g_define_type_info, 0);
	return formatted_text_super_info_type_id;
}

static GType
formatted_text_super_info_get_type (void)
{
	static volatile gsize formatted_text_super_info_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_super_info_type_id__once)) {
		GType formatted_text_super_info_type_id;
		formatted_text_super_info_type_id = formatted_text_super_info_get_type_once ();
		g_once_init_leave (&formatted_text_super_info_type_id__once, formatted_text_super_info_type_id);
	}
	return formatted_text_super_info_type_id__once;
}

static FormattedTextHeaderInfo*
formatted_text_header_info_construct (GType object_type)
{
	FormattedTextHeaderInfo* self = NULL;
	self = (FormattedTextHeaderInfo*) formatted_text_tag_attr_construct (object_type);
	return self;
}

static FormattedTextHeaderInfo*
formatted_text_header_info_new (void)
{
	return formatted_text_header_info_construct (FORMATTED_TEXT_TYPE_HEADER_INFO);
}

static gdouble
formatted_text_header_info_get_scale_factor (FormattedTextHeaderInfo* self,
                                             const gchar* extra)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = extra;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("1")))) {
		switch (0) {
			default:
			{
				result = 2.1;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("2")))) {
		switch (0) {
			default:
			{
				result = 1.8;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("3")))) {
		switch (0) {
			default:
			{
				result = 1.5;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("4")))) {
		switch (0) {
			default:
			{
				result = 1.3;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("5")))) {
		switch (0) {
			default:
			{
				result = 1.2;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("6")))) {
		switch (0) {
			default:
			{
				result = 1.1;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = 1.1;
				return result;
			}
		}
	}
}

static void
formatted_text_header_info_real_add_attrs (FormattedTextTagAttr* base,
                                           PangoAttrList** list,
                                           gint start,
                                           gint end,
                                           const gchar* extra)
{
	FormattedTextHeaderInfo * self;
	PangoAttribute* scale = NULL;
	PangoAttribute* _tmp0_;
	PangoAttribute* bold = NULL;
	PangoAttribute* _tmp1_;
	PangoAttribute* _tmp2_;
	PangoAttribute* _tmp3_;
	PangoAttribute* _tmp4_;
	PangoAttribute* _tmp5_;
	PangoAttribute* _tmp6_;
	PangoAttribute* _tmp7_;
	self = (FormattedTextHeaderInfo*) base;
	g_return_if_fail (*list != NULL);
	_tmp0_ = pango_attr_scale_new (formatted_text_header_info_get_scale_factor (self, extra));
	scale = _tmp0_;
	_tmp1_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	bold = _tmp1_;
	_tmp2_ = scale;
	_tmp2_->start_index = (guint) start;
	_tmp3_ = scale;
	_tmp3_->end_index = (guint) end;
	_tmp4_ = scale;
	scale = NULL;
	pango_attr_list_change (*list, _tmp4_);
	_tmp5_ = bold;
	_tmp5_->start_index = (guint) start;
	_tmp6_ = bold;
	_tmp6_->end_index = (guint) end;
	_tmp7_ = bold;
	bold = NULL;
	pango_attr_list_change (*list, _tmp7_);
	_pango_attribute_destroy0 (bold);
	_pango_attribute_destroy0 (scale);
}

static GtkTextTag*
formatted_text_header_info_real_text_tag (FormattedTextTagAttr* base,
                                          const gchar* extra)
{
	FormattedTextHeaderInfo * self;
	GtkTextTag* ttag = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkTextTag* _tmp2_;
	GtkTextTag* _tmp3_;
	GtkTextTag* result;
	self = (FormattedTextHeaderInfo*) base;
	_tmp0_ = g_strconcat ("header", extra, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_text_tag_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	ttag = _tmp3_;
	g_object_set (ttag, "scale", formatted_text_header_info_get_scale_factor (self, extra), NULL);
	g_object_set (ttag, "scale-set", TRUE, NULL);
	result = ttag;
	return result;
}

static void
formatted_text_header_info_class_init (FormattedTextHeaderInfoClass * klass,
                                       gpointer klass_data)
{
	formatted_text_header_info_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextTagAttrClass *) klass)->add_attrs = (void (*) (FormattedTextTagAttr*, PangoAttrList**, gint, gint, const gchar*)) formatted_text_header_info_real_add_attrs;
	((FormattedTextTagAttrClass *) klass)->text_tag = (GtkTextTag* (*) (FormattedTextTagAttr*, const gchar*)) formatted_text_header_info_real_text_tag;
}

static void
formatted_text_header_info_instance_init (FormattedTextHeaderInfo * self,
                                          gpointer klass)
{
}

static GType
formatted_text_header_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextHeaderInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_header_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextHeaderInfo), 0, (GInstanceInitFunc) formatted_text_header_info_instance_init, NULL };
	GType formatted_text_header_info_type_id;
	formatted_text_header_info_type_id = g_type_register_static (FORMATTED_TEXT_TYPE_TAG_ATTR, "FormattedTextHeaderInfo", &g_define_type_info, 0);
	return formatted_text_header_info_type_id;
}

static GType
formatted_text_header_info_get_type (void)
{
	static volatile gsize formatted_text_header_info_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_header_info_type_id__once)) {
		GType formatted_text_header_info_type_id;
		formatted_text_header_info_type_id = formatted_text_header_info_get_type_once ();
		g_once_init_leave (&formatted_text_header_info_type_id__once, formatted_text_header_info_type_id);
	}
	return formatted_text_header_info_type_id__once;
}

static FormattedTextColorInfo*
formatted_text_color_info_construct (GType object_type)
{
	FormattedTextColorInfo* self = NULL;
	self = (FormattedTextColorInfo*) formatted_text_tag_attr_construct (object_type);
	return self;
}

static FormattedTextColorInfo*
formatted_text_color_info_new (void)
{
	return formatted_text_color_info_construct (FORMATTED_TEXT_TYPE_COLOR_INFO);
}

static void
formatted_text_color_info_real_add_attrs (FormattedTextTagAttr* base,
                                          PangoAttrList** list,
                                          gint start,
                                          gint end,
                                          const gchar* extra)
{
	FormattedTextColorInfo * self;
	GdkRGBA color = {0};
	GdkRGBA _tmp0_ = {0};
	PangoAttribute* attr = NULL;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	PangoAttribute* _tmp4_;
	PangoAttribute* _tmp5_;
	PangoAttribute* _tmp6_;
	PangoAttribute* _tmp7_;
	self = (FormattedTextColorInfo*) base;
	g_return_if_fail (*list != NULL);
	formatted_text_tag_attr_get_color ((FormattedTextTagAttr*) self, extra, &_tmp0_);
	color = _tmp0_;
	_tmp1_ = color;
	_tmp2_ = color;
	_tmp3_ = color;
	_tmp4_ = pango_attr_foreground_new ((guint16) (_tmp1_.red * 65535), (guint16) (_tmp2_.green * 65535), (guint16) (_tmp3_.blue * 65535));
	attr = _tmp4_;
	_tmp5_ = attr;
	_tmp5_->start_index = (guint) start;
	_tmp6_ = attr;
	_tmp6_->end_index = (guint) end;
	_tmp7_ = attr;
	attr = NULL;
	pango_attr_list_change (*list, _tmp7_);
	_pango_attribute_destroy0 (attr);
}

static GtkTextTag*
formatted_text_color_info_real_text_tag (FormattedTextTagAttr* base,
                                         const gchar* extra)
{
	FormattedTextColorInfo * self;
	GtkTextTag* ttag = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkTextTag* _tmp2_;
	GtkTextTag* _tmp3_;
	GdkRGBA _tmp4_ = {0};
	GtkTextTag* result;
	self = (FormattedTextColorInfo*) base;
	_tmp0_ = g_strconcat ("color", extra, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_text_tag_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	ttag = _tmp3_;
	formatted_text_tag_attr_get_color ((FormattedTextTagAttr*) self, extra, &_tmp4_);
	g_object_set (ttag, "foreground-rgba", &_tmp4_, NULL);
	g_object_set (ttag, "foreground-set", TRUE, NULL);
	result = ttag;
	return result;
}

static void
formatted_text_color_info_class_init (FormattedTextColorInfoClass * klass,
                                      gpointer klass_data)
{
	formatted_text_color_info_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextTagAttrClass *) klass)->add_attrs = (void (*) (FormattedTextTagAttr*, PangoAttrList**, gint, gint, const gchar*)) formatted_text_color_info_real_add_attrs;
	((FormattedTextTagAttrClass *) klass)->text_tag = (GtkTextTag* (*) (FormattedTextTagAttr*, const gchar*)) formatted_text_color_info_real_text_tag;
}

static void
formatted_text_color_info_instance_init (FormattedTextColorInfo * self,
                                         gpointer klass)
{
}

static GType
formatted_text_color_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextColorInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_color_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextColorInfo), 0, (GInstanceInitFunc) formatted_text_color_info_instance_init, NULL };
	GType formatted_text_color_info_type_id;
	formatted_text_color_info_type_id = g_type_register_static (FORMATTED_TEXT_TYPE_TAG_ATTR, "FormattedTextColorInfo", &g_define_type_info, 0);
	return formatted_text_color_info_type_id;
}

static GType
formatted_text_color_info_get_type (void)
{
	static volatile gsize formatted_text_color_info_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_color_info_type_id__once)) {
		GType formatted_text_color_info_type_id;
		formatted_text_color_info_type_id = formatted_text_color_info_get_type_once ();
		g_once_init_leave (&formatted_text_color_info_type_id__once, formatted_text_color_info_type_id);
	}
	return formatted_text_color_info_type_id__once;
}

static FormattedTextHighlightInfo*
formatted_text_highlight_info_construct (GType object_type)
{
	FormattedTextHighlightInfo* self = NULL;
	self = (FormattedTextHighlightInfo*) formatted_text_tag_attr_construct (object_type);
	return self;
}

static FormattedTextHighlightInfo*
formatted_text_highlight_info_new (void)
{
	return formatted_text_highlight_info_construct (FORMATTED_TEXT_TYPE_HIGHLIGHT_INFO);
}

static void
formatted_text_highlight_info_real_add_attrs (FormattedTextTagAttr* base,
                                              PangoAttrList** list,
                                              gint start,
                                              gint end,
                                              const gchar* extra)
{
	FormattedTextHighlightInfo * self;
	GdkRGBA color = {0};
	GdkRGBA _tmp0_ = {0};
	PangoAttribute* bg = NULL;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	PangoAttribute* _tmp4_;
	PangoAttribute* alpha = NULL;
	PangoAttribute* _tmp5_;
	PangoAttribute* _tmp6_;
	PangoAttribute* _tmp7_;
	PangoAttribute* _tmp8_;
	PangoAttribute* _tmp9_;
	PangoAttribute* _tmp10_;
	PangoAttribute* _tmp11_;
	self = (FormattedTextHighlightInfo*) base;
	g_return_if_fail (*list != NULL);
	formatted_text_tag_attr_get_color ((FormattedTextTagAttr*) self, extra, &_tmp0_);
	color = _tmp0_;
	_tmp1_ = color;
	_tmp2_ = color;
	_tmp3_ = color;
	_tmp4_ = pango_attr_background_new ((guint16) (_tmp1_.red * 65535), (guint16) (_tmp2_.green * 65535), (guint16) (_tmp3_.blue * 65535));
	bg = _tmp4_;
	_tmp5_ = pango_attr_background_alpha_new ((guint16) (65536 * 0.5));
	alpha = _tmp5_;
	_tmp6_ = bg;
	_tmp6_->start_index = (guint) start;
	_tmp7_ = bg;
	_tmp7_->end_index = (guint) end;
	_tmp8_ = bg;
	bg = NULL;
	pango_attr_list_change (*list, _tmp8_);
	_tmp9_ = alpha;
	_tmp9_->start_index = (guint) start;
	_tmp10_ = alpha;
	_tmp10_->end_index = (guint) end;
	_tmp11_ = alpha;
	alpha = NULL;
	pango_attr_list_change (*list, _tmp11_);
	_pango_attribute_destroy0 (alpha);
	_pango_attribute_destroy0 (bg);
}

static GtkTextTag*
formatted_text_highlight_info_real_text_tag (FormattedTextTagAttr* base,
                                             const gchar* extra)
{
	FormattedTextHighlightInfo * self;
	GtkTextTag* ttag = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkTextTag* _tmp2_;
	GtkTextTag* _tmp3_;
	GdkRGBA _tmp4_ = {0};
	GtkTextTag* result;
	self = (FormattedTextHighlightInfo*) base;
	_tmp0_ = g_strconcat ("hilite", extra, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_text_tag_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	ttag = _tmp3_;
	formatted_text_tag_attr_get_color ((FormattedTextTagAttr*) self, extra, &_tmp4_);
	g_object_set (ttag, "background-rgba", &_tmp4_, NULL);
	g_object_set (ttag, "background-set", TRUE, NULL);
	result = ttag;
	return result;
}

static void
formatted_text_highlight_info_class_init (FormattedTextHighlightInfoClass * klass,
                                          gpointer klass_data)
{
	formatted_text_highlight_info_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextTagAttrClass *) klass)->add_attrs = (void (*) (FormattedTextTagAttr*, PangoAttrList**, gint, gint, const gchar*)) formatted_text_highlight_info_real_add_attrs;
	((FormattedTextTagAttrClass *) klass)->text_tag = (GtkTextTag* (*) (FormattedTextTagAttr*, const gchar*)) formatted_text_highlight_info_real_text_tag;
}

static void
formatted_text_highlight_info_instance_init (FormattedTextHighlightInfo * self,
                                             gpointer klass)
{
}

static GType
formatted_text_highlight_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextHighlightInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_highlight_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextHighlightInfo), 0, (GInstanceInitFunc) formatted_text_highlight_info_instance_init, NULL };
	GType formatted_text_highlight_info_type_id;
	formatted_text_highlight_info_type_id = g_type_register_static (FORMATTED_TEXT_TYPE_TAG_ATTR, "FormattedTextHighlightInfo", &g_define_type_info, 0);
	return formatted_text_highlight_info_type_id;
}

static GType
formatted_text_highlight_info_get_type (void)
{
	static volatile gsize formatted_text_highlight_info_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_highlight_info_type_id__once)) {
		GType formatted_text_highlight_info_type_id;
		formatted_text_highlight_info_type_id = formatted_text_highlight_info_get_type_once ();
		g_once_init_leave (&formatted_text_highlight_info_type_id__once, formatted_text_highlight_info_type_id);
	}
	return formatted_text_highlight_info_type_id__once;
}

static inline gpointer
formatted_text_url_info_get_instance_private (FormattedTextUrlInfo* self)
{
	return G_STRUCT_MEMBER_P (self, FormattedTextUrlInfo_private_offset);
}

static FormattedTextUrlInfo*
formatted_text_url_info_construct (GType object_type,
                                   GdkRGBA* color)
{
	FormattedTextUrlInfo* self = NULL;
	GdkRGBA _tmp0_;
	g_return_val_if_fail (color != NULL, NULL);
	self = (FormattedTextUrlInfo*) formatted_text_tag_attr_construct (object_type);
	_tmp0_ = *color;
	formatted_text_url_info_set_color (self, &_tmp0_);
	return self;
}

static FormattedTextUrlInfo*
formatted_text_url_info_new (GdkRGBA* color)
{
	return formatted_text_url_info_construct (FORMATTED_TEXT_TYPE_URL_INFO, color);
}

static void
formatted_text_url_info_set_color (FormattedTextUrlInfo* self,
                                   GdkRGBA* color)
{
	GArray* _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	PangoAttribute* _tmp4_;
	GArray* _tmp5_;
	PangoAttribute* _tmp6_;
	GdkRGBA* _tmp7_;
	GdkRGBA* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp1_ = *color;
	_tmp2_ = *color;
	_tmp3_ = *color;
	_tmp4_ = pango_attr_foreground_new ((guint16) (_tmp1_.red * 65535), (guint16) (_tmp2_.green * 65535), (guint16) (_tmp3_.blue * 65535));
	g_array_append_val (_tmp0_, _tmp4_);
	_tmp5_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp6_ = pango_attr_underline_new (PANGO_UNDERLINE_SINGLE);
	g_array_append_val (_tmp5_, _tmp6_);
	_tmp7_ = gdk_rgba_copy (color);
	_tmp8_ = _tmp7_;
	self->priv->_color = *_tmp8_;
	__vala_GdkRGBA_free0 (_tmp8_);
}

static void
formatted_text_url_info_update_color (FormattedTextUrlInfo* self,
                                      GdkRGBA* color)
{
	GArray* _tmp0_;
	gint _tmp1_ = 0;
	gpointer* _tmp2_;
	PangoAttribute** _tmp3_;
	gint _tmp3__length1;
	GdkRGBA _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp2_ = vala_g_array_remove_range (_tmp0_, (guint) 0, (guint) 2, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) pango_attribute_destroy), NULL);
	_tmp4_ = *color;
	formatted_text_url_info_set_color (self, &_tmp4_);
}

static GtkTextTag*
formatted_text_url_info_real_text_tag (FormattedTextTagAttr* base,
                                       const gchar* extra)
{
	FormattedTextUrlInfo * self;
	GtkTextTag* ttag = NULL;
	GtkTextTag* _tmp0_;
	GdkRGBA _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkTextTag* result;
	self = (FormattedTextUrlInfo*) base;
	_tmp0_ = gtk_text_tag_new ("url");
	ttag = _tmp0_;
	_tmp1_ = self->priv->_color;
	_tmp2_ = utils_color_from_rgba (&_tmp1_);
	_tmp3_ = _tmp2_;
	g_object_set (ttag, "foreground", _tmp3_, NULL);
	_g_free0 (_tmp3_);
	g_object_set (ttag, "underline", PANGO_UNDERLINE_SINGLE, NULL);
	g_object_set (ttag, "foreground-set", TRUE, NULL);
	g_object_set (ttag, "underline-set", TRUE, NULL);
	result = ttag;
	return result;
}

static void
formatted_text_url_info_class_init (FormattedTextUrlInfoClass * klass,
                                    gpointer klass_data)
{
	formatted_text_url_info_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextTagAttrClass *) klass)->finalize = formatted_text_url_info_finalize;
	g_type_class_adjust_private_offset (klass, &FormattedTextUrlInfo_private_offset);
	((FormattedTextTagAttrClass *) klass)->text_tag = (GtkTextTag* (*) (FormattedTextTagAttr*, const gchar*)) formatted_text_url_info_real_text_tag;
}

static void
formatted_text_url_info_instance_init (FormattedTextUrlInfo * self,
                                       gpointer klass)
{
	self->priv = formatted_text_url_info_get_instance_private (self);
}

static void
formatted_text_url_info_finalize (FormattedTextTagAttr * obj)
{
	FormattedTextUrlInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FORMATTED_TEXT_TYPE_URL_INFO, FormattedTextUrlInfo);
	FORMATTED_TEXT_TAG_ATTR_CLASS (formatted_text_url_info_parent_class)->finalize (obj);
}

static GType
formatted_text_url_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextUrlInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_url_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextUrlInfo), 0, (GInstanceInitFunc) formatted_text_url_info_instance_init, NULL };
	GType formatted_text_url_info_type_id;
	formatted_text_url_info_type_id = g_type_register_static (FORMATTED_TEXT_TYPE_TAG_ATTR, "FormattedTextUrlInfo", &g_define_type_info, 0);
	FormattedTextUrlInfo_private_offset = g_type_add_instance_private (formatted_text_url_info_type_id, sizeof (FormattedTextUrlInfoPrivate));
	return formatted_text_url_info_type_id;
}

static GType
formatted_text_url_info_get_type (void)
{
	static volatile gsize formatted_text_url_info_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_url_info_type_id__once)) {
		GType formatted_text_url_info_type_id;
		formatted_text_url_info_type_id = formatted_text_url_info_get_type_once ();
		g_once_init_leave (&formatted_text_url_info_type_id__once, formatted_text_url_info_type_id);
	}
	return formatted_text_url_info_type_id__once;
}

static inline gpointer
formatted_text_tagging_info_get_instance_private (FormattedTextTaggingInfo* self)
{
	return G_STRUCT_MEMBER_P (self, FormattedTextTaggingInfo_private_offset);
}

static FormattedTextTaggingInfo*
formatted_text_tagging_info_construct (GType object_type,
                                       GdkRGBA* color)
{
	FormattedTextTaggingInfo* self = NULL;
	GdkRGBA _tmp0_;
	g_return_val_if_fail (color != NULL, NULL);
	self = (FormattedTextTaggingInfo*) formatted_text_tag_attr_construct (object_type);
	_tmp0_ = *color;
	formatted_text_tagging_info_set_color (self, &_tmp0_);
	return self;
}

static FormattedTextTaggingInfo*
formatted_text_tagging_info_new (GdkRGBA* color)
{
	return formatted_text_tagging_info_construct (FORMATTED_TEXT_TYPE_TAGGING_INFO, color);
}

static void
formatted_text_tagging_info_set_color (FormattedTextTaggingInfo* self,
                                       GdkRGBA* color)
{
	GArray* _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	PangoAttribute* _tmp4_;
	GdkRGBA* _tmp5_;
	GdkRGBA* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp1_ = *color;
	_tmp2_ = *color;
	_tmp3_ = *color;
	_tmp4_ = pango_attr_foreground_new ((guint16) (_tmp1_.red * 65535), (guint16) (_tmp2_.green * 65535), (guint16) (_tmp3_.blue * 65535));
	g_array_append_val (_tmp0_, _tmp4_);
	_tmp5_ = gdk_rgba_copy (color);
	_tmp6_ = _tmp5_;
	self->priv->_color = *_tmp6_;
	__vala_GdkRGBA_free0 (_tmp6_);
}

static void
formatted_text_tagging_info_update_color (FormattedTextTaggingInfo* self,
                                          GdkRGBA* color)
{
	GArray* _tmp0_;
	gint _tmp1_ = 0;
	gpointer* _tmp2_;
	PangoAttribute** _tmp3_;
	gint _tmp3__length1;
	GdkRGBA _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp2_ = vala_g_array_remove_range (_tmp0_, (guint) 0, (guint) 1, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) pango_attribute_destroy), NULL);
	_tmp4_ = *color;
	formatted_text_tagging_info_set_color (self, &_tmp4_);
}

static GtkTextTag*
formatted_text_tagging_info_real_text_tag (FormattedTextTagAttr* base,
                                           const gchar* extra)
{
	FormattedTextTaggingInfo * self;
	GtkTextTag* ttag = NULL;
	GtkTextTag* _tmp0_;
	GdkRGBA _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkTextTag* result;
	self = (FormattedTextTaggingInfo*) base;
	_tmp0_ = gtk_text_tag_new ("tag");
	ttag = _tmp0_;
	_tmp1_ = self->priv->_color;
	_tmp2_ = utils_color_from_rgba (&_tmp1_);
	_tmp3_ = _tmp2_;
	g_object_set (ttag, "foreground", _tmp3_, NULL);
	_g_free0 (_tmp3_);
	g_object_set (ttag, "foreground-set", TRUE, NULL);
	result = ttag;
	return result;
}

static void
formatted_text_tagging_info_class_init (FormattedTextTaggingInfoClass * klass,
                                        gpointer klass_data)
{
	formatted_text_tagging_info_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextTagAttrClass *) klass)->finalize = formatted_text_tagging_info_finalize;
	g_type_class_adjust_private_offset (klass, &FormattedTextTaggingInfo_private_offset);
	((FormattedTextTagAttrClass *) klass)->text_tag = (GtkTextTag* (*) (FormattedTextTagAttr*, const gchar*)) formatted_text_tagging_info_real_text_tag;
}

static void
formatted_text_tagging_info_instance_init (FormattedTextTaggingInfo * self,
                                           gpointer klass)
{
	self->priv = formatted_text_tagging_info_get_instance_private (self);
}

static void
formatted_text_tagging_info_finalize (FormattedTextTagAttr * obj)
{
	FormattedTextTaggingInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FORMATTED_TEXT_TYPE_TAGGING_INFO, FormattedTextTaggingInfo);
	FORMATTED_TEXT_TAG_ATTR_CLASS (formatted_text_tagging_info_parent_class)->finalize (obj);
}

static GType
formatted_text_tagging_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextTaggingInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_tagging_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextTaggingInfo), 0, (GInstanceInitFunc) formatted_text_tagging_info_instance_init, NULL };
	GType formatted_text_tagging_info_type_id;
	formatted_text_tagging_info_type_id = g_type_register_static (FORMATTED_TEXT_TYPE_TAG_ATTR, "FormattedTextTaggingInfo", &g_define_type_info, 0);
	FormattedTextTaggingInfo_private_offset = g_type_add_instance_private (formatted_text_tagging_info_type_id, sizeof (FormattedTextTaggingInfoPrivate));
	return formatted_text_tagging_info_type_id;
}

static GType
formatted_text_tagging_info_get_type (void)
{
	static volatile gsize formatted_text_tagging_info_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_tagging_info_type_id__once)) {
		GType formatted_text_tagging_info_type_id;
		formatted_text_tagging_info_type_id = formatted_text_tagging_info_get_type_once ();
		g_once_init_leave (&formatted_text_tagging_info_type_id__once, formatted_text_tagging_info_type_id);
	}
	return formatted_text_tagging_info_type_id__once;
}

static inline gpointer
formatted_text_syntax_info_get_instance_private (FormattedTextSyntaxInfo* self)
{
	return G_STRUCT_MEMBER_P (self, FormattedTextSyntaxInfo_private_offset);
}

static FormattedTextSyntaxInfo*
formatted_text_syntax_info_construct (GType object_type,
                                      GdkRGBA* color,
                                      gboolean hide)
{
	FormattedTextSyntaxInfo* self = NULL;
	GdkRGBA _tmp0_;
	g_return_val_if_fail (color != NULL, NULL);
	self = (FormattedTextSyntaxInfo*) formatted_text_tag_attr_construct (object_type);
	_tmp0_ = *color;
	formatted_text_syntax_info_set_color (self, &_tmp0_, hide);
	return self;
}

static FormattedTextSyntaxInfo*
formatted_text_syntax_info_new (GdkRGBA* color,
                                gboolean hide)
{
	return formatted_text_syntax_info_construct (FORMATTED_TEXT_TYPE_SYNTAX_INFO, color, hide);
}

static void
formatted_text_syntax_info_set_color (FormattedTextSyntaxInfo* self,
                                      GdkRGBA* color,
                                      gboolean hide)
{
	GArray* _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	PangoAttribute* _tmp4_;
	gint _tmp5_ = 0;
	GArray* _tmp6_;
	PangoAttribute* _tmp7_;
	GdkRGBA* _tmp8_;
	GdkRGBA* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp1_ = *color;
	_tmp2_ = *color;
	_tmp3_ = *color;
	_tmp4_ = pango_attr_foreground_new ((guint16) (_tmp1_.red * 65535), (guint16) (_tmp2_.green * 65535), (guint16) (_tmp3_.blue * 65535));
	g_array_append_val (_tmp0_, _tmp4_);
	if (hide) {
		_tmp5_ = 20000;
	} else {
		_tmp5_ = 65535;
	}
	_tmp6_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp7_ = pango_attr_foreground_alpha_new ((guint16) _tmp5_);
	g_array_append_val (_tmp6_, _tmp7_);
	_tmp8_ = gdk_rgba_copy (color);
	_tmp9_ = _tmp8_;
	self->priv->_color = *_tmp9_;
	__vala_GdkRGBA_free0 (_tmp9_);
	self->priv->_hide = hide;
}

static void
formatted_text_syntax_info_update_color (FormattedTextSyntaxInfo* self,
                                         GdkRGBA* color)
{
	GArray* _tmp0_;
	gint _tmp1_ = 0;
	gpointer* _tmp2_;
	PangoAttribute** _tmp3_;
	gint _tmp3__length1;
	GdkRGBA _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp2_ = vala_g_array_remove_range (_tmp0_, (guint) 0, (guint) 2, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) pango_attribute_destroy), NULL);
	_tmp4_ = *color;
	formatted_text_syntax_info_set_color (self, &_tmp4_, self->priv->_hide);
}

static GtkTextTag*
formatted_text_syntax_info_real_text_tag (FormattedTextTagAttr* base,
                                          const gchar* extra)
{
	FormattedTextSyntaxInfo * self;
	GtkTextTag* ttag = NULL;
	GtkTextTag* _tmp0_;
	GtkTextTag* result;
	self = (FormattedTextSyntaxInfo*) base;
	_tmp0_ = gtk_text_tag_new ("syntax");
	ttag = _tmp0_;
	if (self->priv->_hide) {
		GtkTextTag* _tmp1_;
		GtkTextTag* _tmp2_;
		_tmp1_ = ttag;
		g_object_set (_tmp1_, "invisible", TRUE, NULL);
		_tmp2_ = ttag;
		g_object_set (_tmp2_, "invisible-set", TRUE, NULL);
	} else {
		GtkTextTag* _tmp3_;
		GdkRGBA _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GtkTextTag* _tmp7_;
		_tmp3_ = ttag;
		_tmp4_ = self->priv->_color;
		_tmp5_ = utils_color_from_rgba (&_tmp4_);
		_tmp6_ = _tmp5_;
		g_object_set (_tmp3_, "foreground", _tmp6_, NULL);
		_g_free0 (_tmp6_);
		_tmp7_ = ttag;
		g_object_set (_tmp7_, "foreground-set", TRUE, NULL);
	}
	result = ttag;
	return result;
}

static void
formatted_text_syntax_info_class_init (FormattedTextSyntaxInfoClass * klass,
                                       gpointer klass_data)
{
	formatted_text_syntax_info_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextTagAttrClass *) klass)->finalize = formatted_text_syntax_info_finalize;
	g_type_class_adjust_private_offset (klass, &FormattedTextSyntaxInfo_private_offset);
	((FormattedTextTagAttrClass *) klass)->text_tag = (GtkTextTag* (*) (FormattedTextTagAttr*, const gchar*)) formatted_text_syntax_info_real_text_tag;
}

static void
formatted_text_syntax_info_instance_init (FormattedTextSyntaxInfo * self,
                                          gpointer klass)
{
	self->priv = formatted_text_syntax_info_get_instance_private (self);
}

static void
formatted_text_syntax_info_finalize (FormattedTextTagAttr * obj)
{
	FormattedTextSyntaxInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FORMATTED_TEXT_TYPE_SYNTAX_INFO, FormattedTextSyntaxInfo);
	FORMATTED_TEXT_TAG_ATTR_CLASS (formatted_text_syntax_info_parent_class)->finalize (obj);
}

static GType
formatted_text_syntax_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextSyntaxInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_syntax_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextSyntaxInfo), 0, (GInstanceInitFunc) formatted_text_syntax_info_instance_init, NULL };
	GType formatted_text_syntax_info_type_id;
	formatted_text_syntax_info_type_id = g_type_register_static (FORMATTED_TEXT_TYPE_TAG_ATTR, "FormattedTextSyntaxInfo", &g_define_type_info, 0);
	FormattedTextSyntaxInfo_private_offset = g_type_add_instance_private (formatted_text_syntax_info_type_id, sizeof (FormattedTextSyntaxInfoPrivate));
	return formatted_text_syntax_info_type_id;
}

static GType
formatted_text_syntax_info_get_type (void)
{
	static volatile gsize formatted_text_syntax_info_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_syntax_info_type_id__once)) {
		GType formatted_text_syntax_info_type_id;
		formatted_text_syntax_info_type_id = formatted_text_syntax_info_get_type_once ();
		g_once_init_leave (&formatted_text_syntax_info_type_id__once, formatted_text_syntax_info_type_id);
	}
	return formatted_text_syntax_info_type_id__once;
}

static FormattedTextMatchInfo*
formatted_text_match_info_construct (GType object_type,
                                     GdkRGBA* f,
                                     GdkRGBA* b)
{
	FormattedTextMatchInfo* self = NULL;
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	g_return_val_if_fail (f != NULL, NULL);
	g_return_val_if_fail (b != NULL, NULL);
	self = (FormattedTextMatchInfo*) formatted_text_tag_attr_construct (object_type);
	_tmp0_ = *f;
	_tmp1_ = *b;
	formatted_text_match_info_set_color (self, &_tmp0_, &_tmp1_);
	return self;
}

static FormattedTextMatchInfo*
formatted_text_match_info_new (GdkRGBA* f,
                               GdkRGBA* b)
{
	return formatted_text_match_info_construct (FORMATTED_TEXT_TYPE_MATCH_INFO, f, b);
}

static void
formatted_text_match_info_set_color (FormattedTextMatchInfo* self,
                                     GdkRGBA* f,
                                     GdkRGBA* b)
{
	GArray* _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	PangoAttribute* _tmp4_;
	GArray* _tmp5_;
	GdkRGBA _tmp6_;
	GdkRGBA _tmp7_;
	GdkRGBA _tmp8_;
	PangoAttribute* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp1_ = *f;
	_tmp2_ = *f;
	_tmp3_ = *f;
	_tmp4_ = pango_attr_foreground_new ((guint16) (_tmp1_.red * 65535), (guint16) (_tmp2_.green * 65535), (guint16) (_tmp3_.blue * 65535));
	g_array_append_val (_tmp0_, _tmp4_);
	_tmp5_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp6_ = *b;
	_tmp7_ = *b;
	_tmp8_ = *b;
	_tmp9_ = pango_attr_background_new ((guint16) (_tmp6_.red * 65535), (guint16) (_tmp7_.green * 65535), (guint16) (_tmp8_.blue * 65535));
	g_array_append_val (_tmp5_, _tmp9_);
}

static void
formatted_text_match_info_update_color (FormattedTextMatchInfo* self,
                                        GdkRGBA* f,
                                        GdkRGBA* b)
{
	GArray* _tmp0_;
	gint _tmp1_ = 0;
	gpointer* _tmp2_;
	PangoAttribute** _tmp3_;
	gint _tmp3__length1;
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp2_ = vala_g_array_remove_range (_tmp0_, (guint) 0, (guint) 2, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) pango_attribute_destroy), NULL);
	_tmp4_ = *f;
	_tmp5_ = *b;
	formatted_text_match_info_set_color (self, &_tmp4_, &_tmp5_);
}

static void
formatted_text_match_info_class_init (FormattedTextMatchInfoClass * klass,
                                      gpointer klass_data)
{
	formatted_text_match_info_parent_class = g_type_class_peek_parent (klass);
}

static void
formatted_text_match_info_instance_init (FormattedTextMatchInfo * self,
                                         gpointer klass)
{
}

static GType
formatted_text_match_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextMatchInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_match_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextMatchInfo), 0, (GInstanceInitFunc) formatted_text_match_info_instance_init, NULL };
	GType formatted_text_match_info_type_id;
	formatted_text_match_info_type_id = g_type_register_static (FORMATTED_TEXT_TYPE_TAG_ATTR, "FormattedTextMatchInfo", &g_define_type_info, 0);
	return formatted_text_match_info_type_id;
}

static GType
formatted_text_match_info_get_type (void)
{
	static volatile gsize formatted_text_match_info_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_match_info_type_id__once)) {
		GType formatted_text_match_info_type_id;
		formatted_text_match_info_type_id = formatted_text_match_info_get_type_once ();
		g_once_init_leave (&formatted_text_match_info_type_id__once, formatted_text_match_info_type_id);
	}
	return formatted_text_match_info_type_id__once;
}

static FormattedTextSelectInfo*
formatted_text_select_info_construct (GType object_type,
                                      GdkRGBA* f,
                                      GdkRGBA* b)
{
	FormattedTextSelectInfo* self = NULL;
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	g_return_val_if_fail (f != NULL, NULL);
	g_return_val_if_fail (b != NULL, NULL);
	self = (FormattedTextSelectInfo*) formatted_text_tag_attr_construct (object_type);
	_tmp0_ = *f;
	_tmp1_ = *b;
	formatted_text_select_info_set_color (self, &_tmp0_, &_tmp1_);
	return self;
}

static FormattedTextSelectInfo*
formatted_text_select_info_new (GdkRGBA* f,
                                GdkRGBA* b)
{
	return formatted_text_select_info_construct (FORMATTED_TEXT_TYPE_SELECT_INFO, f, b);
}

static void
formatted_text_select_info_set_color (FormattedTextSelectInfo* self,
                                      GdkRGBA* f,
                                      GdkRGBA* b)
{
	GArray* _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	PangoAttribute* _tmp4_;
	GArray* _tmp5_;
	GdkRGBA _tmp6_;
	GdkRGBA _tmp7_;
	GdkRGBA _tmp8_;
	PangoAttribute* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp1_ = *f;
	_tmp2_ = *f;
	_tmp3_ = *f;
	_tmp4_ = pango_attr_foreground_new ((guint16) (_tmp1_.red * 65535), (guint16) (_tmp2_.green * 65535), (guint16) (_tmp3_.blue * 65535));
	g_array_append_val (_tmp0_, _tmp4_);
	_tmp5_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp6_ = *b;
	_tmp7_ = *b;
	_tmp8_ = *b;
	_tmp9_ = pango_attr_background_new ((guint16) (_tmp6_.red * 65535), (guint16) (_tmp7_.green * 65535), (guint16) (_tmp8_.blue * 65535));
	g_array_append_val (_tmp5_, _tmp9_);
}

static void
formatted_text_select_info_update_color (FormattedTextSelectInfo* self,
                                         GdkRGBA* f,
                                         GdkRGBA* b)
{
	GArray* _tmp0_;
	gint _tmp1_ = 0;
	gpointer* _tmp2_;
	PangoAttribute** _tmp3_;
	gint _tmp3__length1;
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = ((FormattedTextTagAttr*) self)->attrs;
	_tmp2_ = vala_g_array_remove_range (_tmp0_, (guint) 0, (guint) 2, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) pango_attribute_destroy), NULL);
	_tmp4_ = *f;
	_tmp5_ = *b;
	formatted_text_select_info_set_color (self, &_tmp4_, &_tmp5_);
}

static void
formatted_text_select_info_class_init (FormattedTextSelectInfoClass * klass,
                                       gpointer klass_data)
{
	formatted_text_select_info_parent_class = g_type_class_peek_parent (klass);
}

static void
formatted_text_select_info_instance_init (FormattedTextSelectInfo * self,
                                          gpointer klass)
{
}

static GType
formatted_text_select_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextSelectInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_select_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedTextSelectInfo), 0, (GInstanceInitFunc) formatted_text_select_info_instance_init, NULL };
	GType formatted_text_select_info_type_id;
	formatted_text_select_info_type_id = g_type_register_static (FORMATTED_TEXT_TYPE_TAG_ATTR, "FormattedTextSelectInfo", &g_define_type_info, 0);
	return formatted_text_select_info_type_id;
}

static GType
formatted_text_select_info_get_type (void)
{
	static volatile gsize formatted_text_select_info_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_select_info_type_id__once)) {
		GType formatted_text_select_info_type_id;
		formatted_text_select_info_type_id = formatted_text_select_info_get_type_once ();
		g_once_init_leave (&formatted_text_select_info_type_id__once, formatted_text_select_info_type_id);
	}
	return formatted_text_select_info_type_id__once;
}

static void
value_formatted_text_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_formatted_text_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		formatted_text_unref (value->data[0].v_pointer);
	}
}

static void
value_formatted_text_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = formatted_text_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_formatted_text_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_formatted_text_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FormattedText * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = formatted_text_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_formatted_text_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	FormattedText ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = formatted_text_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_formatted_text (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	ParamSpecFormattedText* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_FORMATTED_TEXT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_formatted_text (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FORMATTED_TEXT), NULL);
	return value->data[0].v_pointer;
}

void
value_set_formatted_text (GValue* value,
                          gpointer v_object)
{
	FormattedText * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FORMATTED_TEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FORMATTED_TEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		formatted_text_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		formatted_text_unref (old);
	}
}

void
value_take_formatted_text (GValue* value,
                           gpointer v_object)
{
	FormattedText * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FORMATTED_TEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FORMATTED_TEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		formatted_text_unref (old);
	}
}

static void
formatted_text_class_init (FormattedTextClass * klass,
                           gpointer klass_data)
{
	formatted_text_parent_class = g_type_class_peek_parent (klass);
	((FormattedTextClass *) klass)->finalize = formatted_text_finalize;
	g_type_class_adjust_private_offset (klass, &FormattedText_private_offset);
	formatted_text_signals[FORMATTED_TEXT_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_FORMATTED_TEXT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
formatted_text_instance_init (FormattedText * self,
                              gpointer klass)
{
	FormattedTextTagInfo** _tmp0_;
	gchar* _tmp1_;
	GArray* _tmp2_;
	self->priv = formatted_text_get_instance_private (self);
	_tmp0_ = g_new0 (FormattedTextTagInfo*, FORMAT_TAG_LENGTH + 1);
	self->priv->_formats = _tmp0_;
	self->priv->_formats_length1 = FORMAT_TAG_LENGTH;
	self->priv->__formats_size_ = self->priv->_formats_length1;
	_tmp1_ = g_strdup ("");
	self->priv->_text = _tmp1_;
	_tmp2_ = g_array_new (TRUE, TRUE, sizeof (TextParser*));
	g_array_set_clear_func (_tmp2_, (GDestroyNotify) _vala_TextParser_free_function_content_of);
	self->priv->_parsers = _tmp2_;
	self->ref_count = 1;
}

static void
formatted_text_finalize (FormattedText * obj)
{
	FormattedText * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FORMATTED_TEXT, FormattedText);
	g_signal_handlers_destroy (self);
	self->priv->_formats = (_vala_array_free (self->priv->_formats, self->priv->_formats_length1, (GDestroyNotify) formatted_text_tag_info_unref), NULL);
	_g_free0 (self->priv->_text);
	_g_array_unref0 (self->priv->_parsers);
}

static GType
formatted_text_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_formatted_text_init, value_formatted_text_free_value, value_formatted_text_copy_value, value_formatted_text_peek_pointer, "p", value_formatted_text_collect_value, "p", value_formatted_text_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FormattedTextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) formatted_text_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FormattedText), 0, (GInstanceInitFunc) formatted_text_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType formatted_text_type_id;
	formatted_text_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FormattedText", &g_define_type_info, &g_define_type_fundamental_info, 0);
	FormattedText_private_offset = g_type_add_instance_private (formatted_text_type_id, sizeof (FormattedTextPrivate));
	return formatted_text_type_id;
}

GType
formatted_text_get_type (void)
{
	static volatile gsize formatted_text_type_id__once = 0;
	if (g_once_init_enter (&formatted_text_type_id__once)) {
		GType formatted_text_type_id;
		formatted_text_type_id = formatted_text_get_type_once ();
		g_once_init_leave (&formatted_text_type_id__once, formatted_text_type_id);
	}
	return formatted_text_type_id__once;
}

gpointer
formatted_text_ref (gpointer instance)
{
	FormattedText * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
formatted_text_unref (gpointer instance)
{
	FormattedText * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FORMATTED_TEXT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

