/* UndoStyleChange.c generated by valac 0.56.18, the Vala compiler
 * generated from UndoStyleChange.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_UNDO_ITEM (undo_item_get_type ())
#define UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_ITEM, UndoItem))
#define UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_ITEM, UndoItemClass))
#define IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_ITEM))
#define IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_ITEM))
#define UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_ITEM, UndoItemClass))

typedef struct _UndoItem UndoItem;
typedef struct _UndoItemClass UndoItemClass;
typedef struct _UndoItemPrivate UndoItemPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_UNDO_STYLE_CHANGE (undo_style_change_get_type ())
#define UNDO_STYLE_CHANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_STYLE_CHANGE, UndoStyleChange))
#define UNDO_STYLE_CHANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_STYLE_CHANGE, UndoStyleChangeClass))
#define IS_UNDO_STYLE_CHANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_STYLE_CHANGE))
#define IS_UNDO_STYLE_CHANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_STYLE_CHANGE))
#define UNDO_STYLE_CHANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_STYLE_CHANGE, UndoStyleChangeClass))

typedef struct _UndoStyleChange UndoStyleChange;
typedef struct _UndoStyleChangeClass UndoStyleChangeClass;
typedef struct _UndoStyleChangePrivate UndoStyleChangePrivate;

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;
typedef enum  {
	STYLE_AFFECTS_ALL = 0,
	STYLE_AFFECTS_SELECTED_NODES,
	STYLE_AFFECTS_SELECTED_CONNECTIONS,
	STYLE_AFFECTS_SELECTED_CALLOUTS
} StyleAffects;

#define TYPE_STYLE_AFFECTS (style_affects_get_type ())

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CALLOUT (callout_get_type ())
#define CALLOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALLOUT, Callout))
#define CALLOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALLOUT, CalloutClass))
#define IS_CALLOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALLOUT))
#define IS_CALLOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALLOUT))
#define CALLOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALLOUT, CalloutClass))

typedef struct _Callout Callout;
typedef struct _CalloutClass CalloutClass;
enum  {
	UNDO_STYLE_CHANGE_0_PROPERTY,
	UNDO_STYLE_CHANGE_NUM_PROPERTIES
};
static GParamSpec* undo_style_change_properties[UNDO_STYLE_CHANGE_NUM_PROPERTIES];
typedef enum  {
	UNDO_STYLE_CHANGE_STYLE_CHANGE_TYPE_LOAD = 0,
	UNDO_STYLE_CHANGE_STYLE_CHANGE_TYPE_UNDO,
	UNDO_STYLE_CHANGE_STYLE_CHANGE_TYPE_REDO
} UndoStyleChangeStyleChangeType;

#define UNDO_STYLE_CHANGE_TYPE_STYLE_CHANGE_TYPE (undo_style_change_style_change_type_get_type ())
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SELECTION (selection_get_type ())
#define SELECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SELECTION, Selection))
#define SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SELECTION, SelectionClass))
#define IS_SELECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SELECTION))
#define IS_SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SELECTION))
#define SELECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SELECTION, SelectionClass))

typedef struct _Selection Selection;
typedef struct _SelectionClass SelectionClass;

#define TYPE_CONNECTIONS (connections_get_type ())
#define CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTIONS, Connections))
#define CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTIONS, ConnectionsClass))
#define IS_CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTIONS))
#define IS_CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTIONS))
#define CONNECTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTIONS, ConnectionsClass))

typedef struct _Connections Connections;
typedef struct _ConnectionsClass ConnectionsClass;
#define _connections_unref0(var) ((var == NULL) ? NULL : (var = (connections_unref (var), NULL)))

#define TYPE_STYLES (styles_get_type ())
#define STYLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLES, Styles))
#define STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLES, StylesClass))
#define IS_STYLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLES))
#define IS_STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLES))
#define STYLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLES, StylesClass))

typedef struct _Styles Styles;
typedef struct _StylesClass StylesClass;
#define _style_unref0(var) ((var == NULL) ? NULL : (var = (style_unref (var), NULL)))
#define _selection_unref0(var) ((var == NULL) ? NULL : (var = (selection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _UndoItem {
	GObject parent_instance;
	UndoItemPrivate * priv;
};

struct _UndoItemClass {
	GObjectClass parent_class;
	void (*undo) (UndoItem* self, DrawArea* da);
	void (*redo) (UndoItem* self, DrawArea* da);
	gboolean (*matches) (UndoItem* self, UndoItem* item);
	void (*replace_with_item) (UndoItem* self, UndoItem* item);
	gchar* (*to_string) (UndoItem* self);
};

struct _UndoStyleChange {
	UndoItem parent_instance;
	UndoStyleChangePrivate * priv;
};

struct _UndoStyleChangeClass {
	UndoItemClass parent_class;
	void (*load_style_value) (UndoStyleChange* self, Style* style);
	void (*store_style_value) (UndoStyleChange* self, Style* style, gint index);
};

struct _UndoStyleChangePrivate {
	StyleAffects _affects;
	GArray* _nodes;
	GArray* _conns;
	GArray* _callouts;
};

static gint UndoStyleChange_private_offset;
static gpointer undo_style_change_parent_class = NULL;
VALA_EXTERN Styles* style_inspector_styles;

VALA_EXTERN GType undo_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoItem, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType undo_style_change_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoStyleChange, g_object_unref)
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN GType style_affects_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GType connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Connection, g_object_unref)
VALA_EXTERN GType callout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Callout, g_object_unref)
VALA_EXTERN gboolean undo_item_matches (UndoItem* self,
                            UndoItem* item);
VALA_EXTERN void undo_style_change_load_style_value (UndoStyleChange* self,
                                         Style* style);
VALA_EXTERN void undo_style_change_store_style_value (UndoStyleChange* self,
                                          Style* style,
                                          gint index);
VALA_EXTERN void undo_item_undo (UndoItem* self,
                     DrawArea* da);
VALA_EXTERN void undo_item_redo (UndoItem* self,
                     DrawArea* da);
VALA_EXTERN gchar* undo_item_to_string (UndoItem* self);
static GType undo_style_change_style_change_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN UndoStyleChange* undo_style_change_new (StyleAffects affects,
                                        DrawArea* da);
VALA_EXTERN UndoStyleChange* undo_style_change_construct (GType object_type,
                                              StyleAffects affects,
                                              DrawArea* da);
VALA_EXTERN UndoItem* undo_item_new (const gchar* name);
VALA_EXTERN UndoItem* undo_item_construct (GType object_type,
                               const gchar* name);
VALA_EXTERN GArray* draw_area_get_selected_nodes (DrawArea* self);
VALA_EXTERN GArray* draw_area_get_selected_connections (DrawArea* self);
VALA_EXTERN GArray* draw_area_get_selected_callouts (DrawArea* self);
static gboolean undo_style_change_real_matches (UndoItem* base,
                                         UndoItem* item);
VALA_EXTERN void undo_style_change_load_styles (UndoStyleChange* self,
                                    DrawArea* da);
static void undo_style_change_traverse_styles (UndoStyleChange* self,
                                        DrawArea* da,
                                        UndoStyleChangeStyleChangeType change_type);
VALA_EXTERN gpointer selection_ref (gpointer instance);
VALA_EXTERN void selection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_selection (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_selection (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_selection (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_selection (const GValue* value);
VALA_EXTERN GType selection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Selection, selection_unref)
VALA_EXTERN Selection* draw_area_get_selections (DrawArea* self);
VALA_EXTERN GArray* draw_area_get_nodes (DrawArea* self);
VALA_EXTERN gpointer connections_ref (gpointer instance);
VALA_EXTERN void connections_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_connections (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_connections (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_connections (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_connections (const GValue* value);
VALA_EXTERN GType connections_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Connections, connections_unref)
VALA_EXTERN Connections* draw_area_get_connections (DrawArea* self);
VALA_EXTERN GArray* connections_get_connections (Connections* self);
static void undo_style_change_set_style_for_tree (UndoStyleChange* self,
                                           Node* node,
                                           UndoStyleChangeStyleChangeType change_type,
                                           gint* index);
static void undo_style_change_set_connection_style (UndoStyleChange* self,
                                             Connection* conn,
                                             UndoStyleChangeStyleChangeType change_type,
                                             gint* index);
VALA_EXTERN Style* style_new_templated (void);
VALA_EXTERN Style* style_construct_templated (GType object_type);
VALA_EXTERN gpointer styles_ref (gpointer instance);
VALA_EXTERN void styles_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_styles (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_styles (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_styles (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_styles (const GValue* value);
VALA_EXTERN GType styles_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Styles, styles_unref)
VALA_EXTERN void styles_set_all_to_style (Styles* self,
                              Style* style);
VALA_EXTERN GArray* selection_nodes (Selection* self);
static void undo_style_change_set_node_style (UndoStyleChange* self,
                                       Node* node,
                                       UndoStyleChangeStyleChangeType change_type,
                                       gint* index);
VALA_EXTERN GArray* selection_connections (Selection* self);
VALA_EXTERN GArray* selection_callouts (Selection* self);
static void undo_style_change_set_callout_style (UndoStyleChange* self,
                                          Callout* callout,
                                          UndoStyleChangeStyleChangeType change_type,
                                          gint* index);
VALA_EXTERN void draw_area_auto_save (DrawArea* self);
static void undo_style_change_set_style (UndoStyleChange* self,
                                  Style* old_style,
                                  Style* new_style,
                                  UndoStyleChangeStyleChangeType change_type,
                                  gint* index);
VALA_EXTERN Style* node_get_style (Node* self);
VALA_EXTERN void node_set_style (Node* self,
                     Style* value);
VALA_EXTERN Style* connection_get_style (Connection* self);
VALA_EXTERN void connection_set_style (Connection* self,
                           Style* value);
VALA_EXTERN Style* callout_get_style (Callout* self);
VALA_EXTERN void callout_set_style (Callout* self,
                        Style* value);
VALA_EXTERN Callout* node_get_callout (Node* self);
VALA_EXTERN GArray* node_children (Node* self);
static void undo_style_change_set_style_for_level (UndoStyleChange* self,
                                            Node* node,
                                            gint levels,
                                            UndoStyleChangeStyleChangeType change_type,
                                            gint* index,
                                            gint level);
static void undo_style_change_real_load_style_value (UndoStyleChange* self,
                                              Style* style);
static void undo_style_change_real_store_style_value (UndoStyleChange* self,
                                               Style* style,
                                               gint index);
static void undo_style_change_real_undo (UndoItem* base,
                                  DrawArea* da);
static void undo_style_change_real_redo (UndoItem* base,
                                  DrawArea* da);
static gchar* undo_style_change_real_to_string (UndoItem* base);
static void undo_style_change_finalize (GObject * obj);
static GType undo_style_change_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
undo_style_change_get_instance_private (UndoStyleChange* self)
{
	return G_STRUCT_MEMBER_P (self, UndoStyleChange_private_offset);
}

static GType
undo_style_change_style_change_type_get_type_once (void)
{
	static const GEnumValue values[] = {{UNDO_STYLE_CHANGE_STYLE_CHANGE_TYPE_LOAD, "UNDO_STYLE_CHANGE_STYLE_CHANGE_TYPE_LOAD", "load"}, {UNDO_STYLE_CHANGE_STYLE_CHANGE_TYPE_UNDO, "UNDO_STYLE_CHANGE_STYLE_CHANGE_TYPE_UNDO", "undo"}, {UNDO_STYLE_CHANGE_STYLE_CHANGE_TYPE_REDO, "UNDO_STYLE_CHANGE_STYLE_CHANGE_TYPE_REDO", "redo"}, {0, NULL, NULL}};
	GType undo_style_change_style_change_type_type_id;
	undo_style_change_style_change_type_type_id = g_enum_register_static ("UndoStyleChangeStyleChangeType", values);
	return undo_style_change_style_change_type_type_id;
}

static GType
undo_style_change_style_change_type_get_type (void)
{
	static volatile gsize undo_style_change_style_change_type_type_id__once = 0;
	if (g_once_init_enter (&undo_style_change_style_change_type_type_id__once)) {
		GType undo_style_change_style_change_type_type_id;
		undo_style_change_style_change_type_type_id = undo_style_change_style_change_type_get_type_once ();
		g_once_init_leave (&undo_style_change_style_change_type_type_id__once, undo_style_change_style_change_type_type_id);
	}
	return undo_style_change_style_change_type_type_id__once;
}

UndoStyleChange*
undo_style_change_construct (GType object_type,
                             StyleAffects affects,
                             DrawArea* da)
{
	UndoStyleChange * self = NULL;
	GArray* _tmp0_;
	GArray* _tmp1_;
	GArray* _tmp2_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (UndoStyleChange*) undo_item_construct (object_type, _ ("style change"));
	self->priv->_affects = affects;
	_tmp0_ = draw_area_get_selected_nodes (da);
	_g_array_unref0 (self->priv->_nodes);
	self->priv->_nodes = _tmp0_;
	_tmp1_ = draw_area_get_selected_connections (da);
	_g_array_unref0 (self->priv->_conns);
	self->priv->_conns = _tmp1_;
	_tmp2_ = draw_area_get_selected_callouts (da);
	_g_array_unref0 (self->priv->_callouts);
	self->priv->_callouts = _tmp2_;
	return self;
}

UndoStyleChange*
undo_style_change_new (StyleAffects affects,
                       DrawArea* da)
{
	return undo_style_change_construct (TYPE_UNDO_STYLE_CHANGE, affects, da);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
undo_style_change_real_matches (UndoItem* base,
                                UndoItem* item)
{
	UndoStyleChange * self;
	UndoStyleChange* other = NULL;
	UndoStyleChange* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	UndoStyleChange* _tmp4_;
	gboolean result;
	self = (UndoStyleChange*) base;
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, TYPE_UNDO_STYLE_CHANGE, UndoStyleChange));
	other = _tmp0_;
	_tmp4_ = other;
	if (self->priv->_affects == _tmp4_->priv->_affects) {
		GArray* _tmp5_;
		UndoStyleChange* _tmp6_;
		GArray* _tmp7_;
		_tmp5_ = self->priv->_nodes;
		_tmp6_ = other;
		_tmp7_ = _tmp6_->priv->_nodes;
		_tmp3_ = _tmp5_->len == _tmp7_->len;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GArray* _tmp8_;
		UndoStyleChange* _tmp9_;
		GArray* _tmp10_;
		_tmp8_ = self->priv->_conns;
		_tmp9_ = other;
		_tmp10_ = _tmp9_->priv->_conns;
		_tmp2_ = _tmp8_->len == _tmp10_->len;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GArray* _tmp11_;
		UndoStyleChange* _tmp12_;
		GArray* _tmp13_;
		_tmp11_ = self->priv->_callouts;
		_tmp12_ = other;
		_tmp13_ = _tmp12_->priv->_callouts;
		_tmp1_ = _tmp11_->len == _tmp13_->len;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp14_ = FALSE;
				_tmp14_ = TRUE;
				while (TRUE) {
					GArray* _tmp16_;
					GArray* _tmp17_;
					Node* _tmp18_;
					UndoStyleChange* _tmp19_;
					GArray* _tmp20_;
					Node* _tmp21_;
					if (!_tmp14_) {
						gint _tmp15_;
						_tmp15_ = i;
						i = _tmp15_ + 1;
					}
					_tmp14_ = FALSE;
					_tmp16_ = self->priv->_nodes;
					if (!(((guint) i) < _tmp16_->len)) {
						break;
					}
					_tmp17_ = self->priv->_nodes;
					_tmp18_ = g_array_index (_tmp17_, Node*, (guint) i);
					_tmp19_ = other;
					_tmp20_ = _tmp19_->priv->_nodes;
					_tmp21_ = g_array_index (_tmp20_, Node*, (guint) i);
					if (_tmp18_ != _tmp21_) {
						result = FALSE;
						_g_object_unref0 (other);
						return result;
					}
				}
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp22_ = FALSE;
				_tmp22_ = TRUE;
				while (TRUE) {
					GArray* _tmp24_;
					GArray* _tmp25_;
					Connection* _tmp26_;
					UndoStyleChange* _tmp27_;
					GArray* _tmp28_;
					Connection* _tmp29_;
					if (!_tmp22_) {
						gint _tmp23_;
						_tmp23_ = i;
						i = _tmp23_ + 1;
					}
					_tmp22_ = FALSE;
					_tmp24_ = self->priv->_conns;
					if (!(((guint) i) < _tmp24_->len)) {
						break;
					}
					_tmp25_ = self->priv->_conns;
					_tmp26_ = g_array_index (_tmp25_, Connection*, (guint) i);
					_tmp27_ = other;
					_tmp28_ = _tmp27_->priv->_conns;
					_tmp29_ = g_array_index (_tmp28_, Connection*, (guint) i);
					if (_tmp26_ != _tmp29_) {
						result = FALSE;
						_g_object_unref0 (other);
						return result;
					}
				}
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp30_ = FALSE;
				_tmp30_ = TRUE;
				while (TRUE) {
					GArray* _tmp32_;
					GArray* _tmp33_;
					Callout* _tmp34_;
					UndoStyleChange* _tmp35_;
					GArray* _tmp36_;
					Callout* _tmp37_;
					if (!_tmp30_) {
						gint _tmp31_;
						_tmp31_ = i;
						i = _tmp31_ + 1;
					}
					_tmp30_ = FALSE;
					_tmp32_ = self->priv->_callouts;
					if (!(((guint) i) < _tmp32_->len)) {
						break;
					}
					_tmp33_ = self->priv->_callouts;
					_tmp34_ = g_array_index (_tmp33_, Callout*, (guint) i);
					_tmp35_ = other;
					_tmp36_ = _tmp35_->priv->_callouts;
					_tmp37_ = g_array_index (_tmp36_, Callout*, (guint) i);
					if (_tmp34_ != _tmp37_) {
						result = FALSE;
						_g_object_unref0 (other);
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (other);
	return result;
}

void
undo_style_change_load_styles (UndoStyleChange* self,
                               DrawArea* da)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	undo_style_change_traverse_styles (self, da, UNDO_STYLE_CHANGE_STYLE_CHANGE_TYPE_LOAD);
}

static gpointer
_g_array_ref0 (gpointer self)
{
	return self ? g_array_ref (self) : NULL;
}

static void
undo_style_change_traverse_styles (UndoStyleChange* self,
                                   DrawArea* da,
                                   UndoStyleChangeStyleChangeType change_type)
{
	gint index = 0;
	Selection* selected = NULL;
	Selection* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	index = 1;
	_tmp0_ = draw_area_get_selections (da);
	selected = _tmp0_;
	switch (self->priv->_affects) {
		case STYLE_AFFECTS_ALL:
		{
			{
				GArray* nodes = NULL;
				GArray* _tmp1_;
				GArray* conns = NULL;
				Connections* _tmp2_;
				Connections* _tmp3_;
				GArray* _tmp4_;
				GArray* _tmp5_;
				GArray* _tmp6_;
				GArray* _tmp7_;
				_tmp1_ = draw_area_get_nodes (da);
				nodes = _tmp1_;
				_tmp2_ = draw_area_get_connections (da);
				_tmp3_ = _tmp2_;
				_tmp4_ = connections_get_connections (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = _g_array_ref0 (_tmp5_);
				_tmp7_ = _tmp6_;
				_connections_unref0 (_tmp3_);
				conns = _tmp7_;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							GArray* _tmp10_;
							GArray* _tmp11_;
							Node* _tmp12_;
							if (!_tmp8_) {
								gint _tmp9_;
								_tmp9_ = i;
								i = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp10_ = nodes;
							if (!(((guint) i) < _tmp10_->len)) {
								break;
							}
							_tmp11_ = nodes;
							_tmp12_ = g_array_index (_tmp11_, Node*, (guint) i);
							undo_style_change_set_style_for_tree (self, _tmp12_, change_type, &index);
						}
					}
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp13_ = FALSE;
						_tmp13_ = TRUE;
						while (TRUE) {
							GArray* _tmp15_;
							GArray* _tmp16_;
							Connection* _tmp17_;
							if (!_tmp13_) {
								gint _tmp14_;
								_tmp14_ = i;
								i = _tmp14_ + 1;
							}
							_tmp13_ = FALSE;
							_tmp15_ = conns;
							if (!(((guint) i) < _tmp15_->len)) {
								break;
							}
							_tmp16_ = conns;
							_tmp17_ = g_array_index (_tmp16_, Connection*, (guint) i);
							undo_style_change_set_connection_style (self, _tmp17_, change_type, &index);
						}
					}
				}
				if (change_type == UNDO_STYLE_CHANGE_STYLE_CHANGE_TYPE_LOAD) {
					Style* new_style = NULL;
					Style* _tmp18_;
					Style* _tmp19_;
					Styles* _tmp20_;
					Style* _tmp21_;
					_tmp18_ = style_new_templated ();
					new_style = _tmp18_;
					_tmp19_ = new_style;
					undo_style_change_store_style_value (self, _tmp19_, 0);
					_tmp20_ = style_inspector_styles;
					_tmp21_ = new_style;
					styles_set_all_to_style (_tmp20_, _tmp21_);
					_style_unref0 (new_style);
				}
				_g_array_unref0 (conns);
				_g_array_unref0 (nodes);
			}
			break;
		}
		case STYLE_AFFECTS_SELECTED_NODES:
		{
			GArray* nodes = NULL;
			Selection* _tmp22_;
			GArray* _tmp23_;
			_tmp22_ = selected;
			_tmp23_ = selection_nodes (_tmp22_);
			nodes = _tmp23_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp24_ = FALSE;
					_tmp24_ = TRUE;
					while (TRUE) {
						GArray* _tmp26_;
						GArray* _tmp27_;
						Node* _tmp28_;
						if (!_tmp24_) {
							gint _tmp25_;
							_tmp25_ = i;
							i = _tmp25_ + 1;
						}
						_tmp24_ = FALSE;
						_tmp26_ = nodes;
						if (!(((guint) i) < _tmp26_->len)) {
							break;
						}
						_tmp27_ = nodes;
						_tmp28_ = g_array_index (_tmp27_, Node*, (guint) i);
						undo_style_change_set_node_style (self, _tmp28_, change_type, &index);
					}
				}
			}
			_g_array_unref0 (nodes);
			break;
		}
		case STYLE_AFFECTS_SELECTED_CONNECTIONS:
		{
			GArray* conns = NULL;
			Selection* _tmp29_;
			GArray* _tmp30_;
			_tmp29_ = selected;
			_tmp30_ = selection_connections (_tmp29_);
			conns = _tmp30_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp31_ = FALSE;
					_tmp31_ = TRUE;
					while (TRUE) {
						GArray* _tmp33_;
						GArray* _tmp34_;
						Connection* _tmp35_;
						if (!_tmp31_) {
							gint _tmp32_;
							_tmp32_ = i;
							i = _tmp32_ + 1;
						}
						_tmp31_ = FALSE;
						_tmp33_ = conns;
						if (!(((guint) i) < _tmp33_->len)) {
							break;
						}
						_tmp34_ = conns;
						_tmp35_ = g_array_index (_tmp34_, Connection*, (guint) i);
						undo_style_change_set_connection_style (self, _tmp35_, change_type, &index);
					}
				}
			}
			_g_array_unref0 (conns);
			break;
		}
		case STYLE_AFFECTS_SELECTED_CALLOUTS:
		{
			GArray* callouts = NULL;
			Selection* _tmp36_;
			GArray* _tmp37_;
			_tmp36_ = selected;
			_tmp37_ = selection_callouts (_tmp36_);
			callouts = _tmp37_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp38_ = FALSE;
					_tmp38_ = TRUE;
					while (TRUE) {
						GArray* _tmp40_;
						GArray* _tmp41_;
						Callout* _tmp42_;
						if (!_tmp38_) {
							gint _tmp39_;
							_tmp39_ = i;
							i = _tmp39_ + 1;
						}
						_tmp38_ = FALSE;
						_tmp40_ = callouts;
						if (!(((guint) i) < _tmp40_->len)) {
							break;
						}
						_tmp41_ = callouts;
						_tmp42_ = g_array_index (_tmp41_, Callout*, (guint) i);
						undo_style_change_set_callout_style (self, _tmp42_, change_type, &index);
					}
				}
			}
			_g_array_unref0 (callouts);
			break;
		}
		default:
		break;
	}
	g_signal_emit_by_name (da, "current-changed", da);
	draw_area_auto_save (da);
	gtk_widget_queue_draw ((GtkWidget*) da);
	_selection_unref0 (selected);
}

static void
undo_style_change_set_style (UndoStyleChange* self,
                             Style* old_style,
                             Style* new_style,
                             UndoStyleChangeStyleChangeType change_type,
                             gint* index)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_style != NULL);
	g_return_if_fail (new_style != NULL);
	switch (change_type) {
		case UNDO_STYLE_CHANGE_STYLE_CHANGE_TYPE_LOAD:
		{
			undo_style_change_load_style_value (self, old_style);
			undo_style_change_store_style_value (self, new_style, 0);
			break;
		}
		case UNDO_STYLE_CHANGE_STYLE_CHANGE_TYPE_UNDO:
		{
			Style* _tmp0_;
			gint _tmp1_;
			_tmp0_ = new_style;
			_tmp1_ = *index;
			*index = _tmp1_ + 1;
			undo_style_change_store_style_value (self, _tmp0_, _tmp1_);
			break;
		}
		case UNDO_STYLE_CHANGE_STYLE_CHANGE_TYPE_REDO:
		{
			undo_style_change_store_style_value (self, new_style, 0);
			break;
		}
		default:
		break;
	}
}

static void
undo_style_change_set_node_style (UndoStyleChange* self,
                                  Node* node,
                                  UndoStyleChangeStyleChangeType change_type,
                                  gint* index)
{
	Style* new_style = NULL;
	Style* _tmp0_;
	Style* _tmp1_;
	Style* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = style_new_templated ();
	new_style = _tmp0_;
	_tmp1_ = node_get_style (node);
	_tmp2_ = _tmp1_;
	undo_style_change_set_style (self, _tmp2_, new_style, change_type, index);
	node_set_style (node, new_style);
	_style_unref0 (new_style);
}

static void
undo_style_change_set_connection_style (UndoStyleChange* self,
                                        Connection* conn,
                                        UndoStyleChangeStyleChangeType change_type,
                                        gint* index)
{
	Style* new_style = NULL;
	Style* _tmp0_;
	Style* _tmp1_;
	Style* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	_tmp0_ = style_new_templated ();
	new_style = _tmp0_;
	_tmp1_ = connection_get_style (conn);
	_tmp2_ = _tmp1_;
	undo_style_change_set_style (self, _tmp2_, new_style, change_type, index);
	connection_set_style (conn, new_style);
	_style_unref0 (new_style);
}

static void
undo_style_change_set_callout_style (UndoStyleChange* self,
                                     Callout* callout,
                                     UndoStyleChangeStyleChangeType change_type,
                                     gint* index)
{
	Style* new_style = NULL;
	Style* _tmp0_;
	Style* _tmp1_;
	Style* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (callout != NULL);
	_tmp0_ = style_new_templated ();
	new_style = _tmp0_;
	_tmp1_ = callout_get_style (callout);
	_tmp2_ = _tmp1_;
	undo_style_change_set_style (self, _tmp2_, new_style, change_type, index);
	callout_set_style (callout, new_style);
	_style_unref0 (new_style);
}

static void
undo_style_change_set_style_for_tree (UndoStyleChange* self,
                                      Node* node,
                                      UndoStyleChangeStyleChangeType change_type,
                                      gint* index)
{
	Callout* _tmp0_;
	Callout* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	undo_style_change_set_node_style (self, node, change_type, index);
	_tmp0_ = node_get_callout (node);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		Callout* _tmp2_;
		Callout* _tmp3_;
		_tmp2_ = node_get_callout (node);
		_tmp3_ = _tmp2_;
		undo_style_change_set_callout_style (self, _tmp3_, change_type, index);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GArray* _tmp6_;
				GArray* _tmp7_;
				gboolean _tmp8_;
				GArray* _tmp9_;
				GArray* _tmp10_;
				Node* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = node_children (node);
				_tmp7_ = _tmp6_;
				_tmp8_ = !(((guint) i) < _tmp7_->len);
				_g_array_unref0 (_tmp7_);
				if (_tmp8_) {
					break;
				}
				_tmp9_ = node_children (node);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_array_index (_tmp10_, Node*, (guint) i);
				undo_style_change_set_style_for_tree (self, _tmp11_, change_type, index);
				_g_array_unref0 (_tmp10_);
			}
		}
	}
}

static void
undo_style_change_set_style_for_level (UndoStyleChange* self,
                                       Node* node,
                                       gint levels,
                                       UndoStyleChangeStyleChangeType change_type,
                                       gint* index,
                                       gint level)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	if ((levels & (1 << level)) != 0) {
		Callout* _tmp0_;
		Callout* _tmp1_;
		undo_style_change_set_node_style (self, node, change_type, index);
		_tmp0_ = node_get_callout (node);
		_tmp1_ = _tmp0_;
		if (_tmp1_ != NULL) {
			Callout* _tmp2_;
			Callout* _tmp3_;
			_tmp2_ = node_get_callout (node);
			_tmp3_ = _tmp2_;
			undo_style_change_set_callout_style (self, _tmp3_, change_type, index);
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GArray* _tmp6_;
				GArray* _tmp7_;
				gboolean _tmp8_;
				gint _tmp9_ = 0;
				GArray* _tmp10_;
				GArray* _tmp11_;
				Node* _tmp12_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = node_children (node);
				_tmp7_ = _tmp6_;
				_tmp8_ = !(((guint) i) < _tmp7_->len);
				_g_array_unref0 (_tmp7_);
				if (_tmp8_) {
					break;
				}
				if (level == 9) {
					_tmp9_ = 9;
				} else {
					_tmp9_ = level + 1;
				}
				_tmp10_ = node_children (node);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_array_index (_tmp11_, Node*, (guint) i);
				undo_style_change_set_style_for_level (self, _tmp12_, levels, change_type, index, _tmp9_);
				_g_array_unref0 (_tmp11_);
			}
		}
	}
}

static void
undo_style_change_real_load_style_value (UndoStyleChange* self,
                                         Style* style)
{
	g_return_if_fail (style != NULL);
}

void
undo_style_change_load_style_value (UndoStyleChange* self,
                                    Style* style)
{
	UndoStyleChangeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = UNDO_STYLE_CHANGE_GET_CLASS (self);
	if (_klass_->load_style_value) {
		_klass_->load_style_value (self, style);
	}
}

static void
undo_style_change_real_store_style_value (UndoStyleChange* self,
                                          Style* style,
                                          gint index)
{
	g_return_if_fail (style != NULL);
}

void
undo_style_change_store_style_value (UndoStyleChange* self,
                                     Style* style,
                                     gint index)
{
	UndoStyleChangeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = UNDO_STYLE_CHANGE_GET_CLASS (self);
	if (_klass_->store_style_value) {
		_klass_->store_style_value (self, style, index);
	}
}

static void
undo_style_change_real_undo (UndoItem* base,
                             DrawArea* da)
{
	UndoStyleChange * self;
	self = (UndoStyleChange*) base;
	g_return_if_fail (da != NULL);
	undo_style_change_traverse_styles (self, da, UNDO_STYLE_CHANGE_STYLE_CHANGE_TYPE_UNDO);
}

static void
undo_style_change_real_redo (UndoItem* base,
                             DrawArea* da)
{
	UndoStyleChange * self;
	self = (UndoStyleChange*) base;
	g_return_if_fail (da != NULL);
	undo_style_change_traverse_styles (self, da, UNDO_STYLE_CHANGE_STYLE_CHANGE_TYPE_REDO);
}

static gchar*
undo_style_change_real_to_string (UndoItem* base)
{
	UndoStyleChange * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GEnumValue* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	self = (UndoStyleChange*) base;
	_tmp0_ = UNDO_ITEM_CLASS (undo_style_change_parent_class)->to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_UNDO_ITEM, UndoItem));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_enum_get_value (g_type_class_ref (TYPE_STYLE_AFFECTS), self->priv->_affects);
	_tmp3_ = g_strdup_printf (", affects: %s", (_tmp2_ != NULL) ? _tmp2_->value_name : NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp1_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
	result = _tmp6_;
	return result;
}

static void
undo_style_change_class_init (UndoStyleChangeClass * klass,
                              gpointer klass_data)
{
	undo_style_change_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UndoStyleChange_private_offset);
	((UndoItemClass *) klass)->matches = (gboolean (*) (UndoItem*, UndoItem*)) undo_style_change_real_matches;
	((UndoStyleChangeClass *) klass)->load_style_value = (void (*) (UndoStyleChange*, Style*)) undo_style_change_real_load_style_value;
	((UndoStyleChangeClass *) klass)->store_style_value = (void (*) (UndoStyleChange*, Style*, gint)) undo_style_change_real_store_style_value;
	((UndoItemClass *) klass)->undo = (void (*) (UndoItem*, DrawArea*)) undo_style_change_real_undo;
	((UndoItemClass *) klass)->redo = (void (*) (UndoItem*, DrawArea*)) undo_style_change_real_redo;
	((UndoItemClass *) klass)->to_string = (gchar* (*) (UndoItem*)) undo_style_change_real_to_string;
	G_OBJECT_CLASS (klass)->finalize = undo_style_change_finalize;
}

static void
undo_style_change_instance_init (UndoStyleChange * self,
                                 gpointer klass)
{
	self->priv = undo_style_change_get_instance_private (self);
}

static void
undo_style_change_finalize (GObject * obj)
{
	UndoStyleChange * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNDO_STYLE_CHANGE, UndoStyleChange);
	_g_array_unref0 (self->priv->_nodes);
	_g_array_unref0 (self->priv->_conns);
	_g_array_unref0 (self->priv->_callouts);
	G_OBJECT_CLASS (undo_style_change_parent_class)->finalize (obj);
}

static GType
undo_style_change_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UndoStyleChangeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) undo_style_change_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UndoStyleChange), 0, (GInstanceInitFunc) undo_style_change_instance_init, NULL };
	GType undo_style_change_type_id;
	undo_style_change_type_id = g_type_register_static (TYPE_UNDO_ITEM, "UndoStyleChange", &g_define_type_info, 0);
	UndoStyleChange_private_offset = g_type_add_instance_private (undo_style_change_type_id, sizeof (UndoStyleChangePrivate));
	return undo_style_change_type_id;
}

GType
undo_style_change_get_type (void)
{
	static volatile gsize undo_style_change_type_id__once = 0;
	if (g_once_init_enter (&undo_style_change_type_id__once)) {
		GType undo_style_change_type_id;
		undo_style_change_type_id = undo_style_change_get_type_once ();
		g_once_init_leave (&undo_style_change_type_id__once, undo_style_change_type_id);
	}
	return undo_style_change_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

