/* AdjustDateTimeDialog.c generated by valac 0.56.18, the Vala compiler
 * generated from AdjustDateTimeDialog.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*               2017-2018 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <granite.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define ADJUST_DATE_TIME_DIALOG_SECONDS_IN_DAY ((gint64) ((60 * 60) * 24))
#define ADJUST_DATE_TIME_DIALOG_SECONDS_IN_HOUR ((gint64) (60 * 60))
#define ADJUST_DATE_TIME_DIALOG_SECONDS_IN_MINUTE ((gint64) 60)
#define ADJUST_DATE_TIME_DIALOG_CALENDAR_THUMBNAIL_SCALE 1
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef enum  {
	ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_AM,
	ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_PM,
	ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_24HR
} AdjustDateTimeDialogTimeSystem;

#define ADJUST_DATE_TIME_DIALOG_TYPE_TIME_SYSTEM (adjust_date_time_dialog_time_system_get_type ())
enum  {
	ADJUST_DATE_TIME_DIALOG_0_PROPERTY,
	ADJUST_DATE_TIME_DIALOG_NUM_PROPERTIES
};
static GParamSpec* adjust_date_time_dialog_properties[ADJUST_DATE_TIME_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AdjustDateTimeDialogPrivate {
	gboolean no_original_time;
	gint64 original_time;
	GtkLabel* original_time_label;
	GtkCalendar* calendar;
	GtkSpinButton* hour;
	GtkSpinButton* minute;
	GtkSpinButton* second;
	GtkComboBoxText* system;
	GtkRadioButton* relativity_radio_button;
	GtkRadioButton* batch_radio_button;
	GtkCheckButton* modify_originals_check_button;
	GtkLabel* notification;
	GSettings* ui_settings;
	GSettings* file_settings;
	AdjustDateTimeDialogTimeSystem previous_time_system;
};

static gint AdjustDateTimeDialog_private_offset;
static gpointer adjust_date_time_dialog_parent_class = NULL;

static GType adjust_date_time_dialog_time_system_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void adjust_date_time_dialog_on_time_changed (AdjustDateTimeDialog* self);
static void _adjust_date_time_dialog_on_time_changed_gtk_calendar_day_selected (GtkCalendar* _sender,
                                                                         gpointer self);
static void _adjust_date_time_dialog_on_time_changed_gtk_calendar_month_changed (GtkCalendar* _sender,
                                                                          gpointer self);
static void _adjust_date_time_dialog_on_time_changed_gtk_calendar_next_year (GtkCalendar* _sender,
                                                                      gpointer self);
static void _adjust_date_time_dialog_on_time_changed_gtk_calendar_prev_year (GtkCalendar* _sender,
                                                                      gpointer self);
static gboolean adjust_date_time_dialog_on_spin_button_output (AdjustDateTimeDialog* self,
                                                        GtkSpinButton* button);
static gboolean _adjust_date_time_dialog_on_spin_button_output_gtk_spin_button_output (GtkSpinButton* _sender,
                                                                                gpointer self);
static void adjust_date_time_dialog_on_time_system_changed (AdjustDateTimeDialog* self);
static void _adjust_date_time_dialog_on_time_system_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                            gpointer self);
static void _adjust_date_time_dialog_on_time_changed_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                         gpointer self);
static void adjust_date_time_dialog_set_time (AdjustDateTimeDialog* self,
                                       GDateTime* time);
static void adjust_date_time_dialog_set_original_time_label (AdjustDateTimeDialog* self,
                                                      gboolean use_24_hr_format);
static gint64 adjust_date_time_dialog_get_time (AdjustDateTimeDialog* self);
static GObject * adjust_date_time_dialog_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void adjust_date_time_dialog_finalize (GObject * obj);
static GType adjust_date_time_dialog_get_type_once (void);

static inline gpointer
adjust_date_time_dialog_get_instance_private (AdjustDateTimeDialog* self)
{
	return G_STRUCT_MEMBER_P (self, AdjustDateTimeDialog_private_offset);
}

static GType
adjust_date_time_dialog_time_system_get_type_once (void)
{
	static const GEnumValue values[] = {{ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_AM, "ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_AM", "am"}, {ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_PM, "ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_PM", "pm"}, {ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_24HR, "ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_24HR", "24hr"}, {0, NULL, NULL}};
	GType adjust_date_time_dialog_time_system_type_id;
	adjust_date_time_dialog_time_system_type_id = g_enum_register_static ("AdjustDateTimeDialogTimeSystem", values);
	return adjust_date_time_dialog_time_system_type_id;
}

static GType
adjust_date_time_dialog_time_system_get_type (void)
{
	static volatile gsize adjust_date_time_dialog_time_system_type_id__once = 0;
	if (g_once_init_enter (&adjust_date_time_dialog_time_system_type_id__once)) {
		GType adjust_date_time_dialog_time_system_type_id;
		adjust_date_time_dialog_time_system_type_id = adjust_date_time_dialog_time_system_get_type_once ();
		g_once_init_leave (&adjust_date_time_dialog_time_system_type_id__once, adjust_date_time_dialog_time_system_type_id);
	}
	return adjust_date_time_dialog_time_system_type_id__once;
}

static void
_adjust_date_time_dialog_on_time_changed_gtk_calendar_day_selected (GtkCalendar* _sender,
                                                                    gpointer self)
{
	adjust_date_time_dialog_on_time_changed ((AdjustDateTimeDialog*) self);
}

static void
_adjust_date_time_dialog_on_time_changed_gtk_calendar_month_changed (GtkCalendar* _sender,
                                                                     gpointer self)
{
	adjust_date_time_dialog_on_time_changed ((AdjustDateTimeDialog*) self);
}

static void
_adjust_date_time_dialog_on_time_changed_gtk_calendar_next_year (GtkCalendar* _sender,
                                                                 gpointer self)
{
	adjust_date_time_dialog_on_time_changed ((AdjustDateTimeDialog*) self);
}

static void
_adjust_date_time_dialog_on_time_changed_gtk_calendar_prev_year (GtkCalendar* _sender,
                                                                 gpointer self)
{
	adjust_date_time_dialog_on_time_changed ((AdjustDateTimeDialog*) self);
}

static gboolean
_adjust_date_time_dialog_on_spin_button_output_gtk_spin_button_output (GtkSpinButton* _sender,
                                                                       gpointer self)
{
	gboolean result;
	result = adjust_date_time_dialog_on_spin_button_output ((AdjustDateTimeDialog*) self, _sender);
	return result;
}

static void
_adjust_date_time_dialog_on_time_system_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                       gpointer self)
{
	adjust_date_time_dialog_on_time_system_changed ((AdjustDateTimeDialog*) self);
}

static void
_adjust_date_time_dialog_on_time_changed_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                    gpointer self)
{
	adjust_date_time_dialog_on_time_changed ((AdjustDateTimeDialog*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

AdjustDateTimeDialog*
adjust_date_time_dialog_construct (GType object_type,
                                   Dateable* source,
                                   gint photo_count,
                                   gboolean display_options,
                                   gboolean contains_video,
                                   gboolean only_video)
{
	AdjustDateTimeDialog * self = NULL;
	GtkCalendar* _tmp0_;
	GtkCalendar* _tmp1_;
	GtkCalendar* _tmp2_;
	GtkCalendar* _tmp3_;
	GtkCalendar* _tmp4_;
	GSettings* _tmp5_;
	GtkSpinButton* _tmp8_;
	GtkSpinButton* _tmp9_;
	GtkSpinButton* _tmp10_;
	GtkSpinButton* _tmp11_;
	GtkSpinButton* _tmp12_;
	GtkSpinButton* _tmp13_;
	GtkSpinButton* _tmp14_;
	GtkSpinButton* _tmp15_;
	GtkComboBoxText* _tmp16_;
	GtkComboBoxText* _tmp17_;
	GtkComboBoxText* _tmp18_;
	GtkComboBoxText* _tmp19_;
	GtkComboBoxText* _tmp20_;
	GtkRadioButton* _tmp21_;
	GtkRadioButton* _tmp22_;
	GSettings* _tmp23_;
	gboolean _tmp24_ = FALSE;
	GtkRadioButton* _tmp25_;
	GtkRadioButton* _tmp26_;
	GSList* _tmp27_;
	GtkRadioButton* _tmp28_;
	GtkRadioButton* _tmp29_;
	GSettings* _tmp30_;
	gboolean _tmp31_ = FALSE;
	GtkRadioButton* _tmp32_;
	GtkRadioButton* _tmp33_;
	gboolean _tmp36_ = FALSE;
	GSettings* _tmp37_;
	GtkCheckButton* _tmp38_;
	gboolean _tmp39_ = FALSE;
	GtkCheckButton* _tmp42_;
	GdkPixbuf* preview = NULL;
	GtkImage* _tmp48_ = NULL;
	GdkPixbuf* _tmp49_;
	GtkImage* image = NULL;
	GtkImage* _tmp53_;
	GtkLabel* _tmp54_;
	GtkLabel* _tmp55_;
	GtkLabel* _tmp56_;
	GtkLabel* _tmp57_;
	GtkLabel* _tmp58_;
	GtkLabel* _tmp59_;
	GtkGrid* clock_grid = NULL;
	GtkGrid* _tmp60_;
	GtkGrid* _tmp61_;
	GtkGrid* _tmp62_;
	GtkSpinButton* _tmp63_;
	GtkGrid* _tmp64_;
	GtkLabel* _tmp65_;
	GtkLabel* _tmp66_;
	GtkGrid* _tmp67_;
	GtkSpinButton* _tmp68_;
	GtkGrid* _tmp69_;
	GtkLabel* _tmp70_;
	GtkLabel* _tmp71_;
	GtkGrid* _tmp72_;
	GtkSpinButton* _tmp73_;
	GtkGrid* _tmp74_;
	GtkComboBoxText* _tmp75_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp76_;
	GtkGrid* _tmp77_;
	GtkGrid* _tmp78_;
	GtkGrid* _tmp79_;
	GtkGrid* _tmp80_;
	GtkImage* _tmp81_;
	GtkGrid* _tmp82_;
	GtkLabel* _tmp83_;
	GtkGrid* _tmp84_;
	GtkCalendar* _tmp85_;
	GtkGrid* _tmp86_;
	GtkGrid* _tmp87_;
	GtkGrid* _tmp88_;
	GtkLabel* _tmp89_;
	GtkBox* _tmp96_;
	GtkGrid* _tmp97_;
	GDateTime* _tmp99_;
	GDateTime* _tmp100_;
	GSettings* _tmp101_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (source != NULL, NULL);
	self = (AdjustDateTimeDialog*) granite_dialog_construct (object_type);
	_vala_assert (source != NULL, "source != null");
	_tmp0_ = (GtkCalendar*) gtk_calendar_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->calendar);
	self->priv->calendar = _tmp0_;
	_tmp1_ = self->priv->calendar;
	g_signal_connect_object (_tmp1_, "day-selected", (GCallback) _adjust_date_time_dialog_on_time_changed_gtk_calendar_day_selected, self, 0);
	_tmp2_ = self->priv->calendar;
	g_signal_connect_object (_tmp2_, "month-changed", (GCallback) _adjust_date_time_dialog_on_time_changed_gtk_calendar_month_changed, self, 0);
	_tmp3_ = self->priv->calendar;
	g_signal_connect_object (_tmp3_, "next-year", (GCallback) _adjust_date_time_dialog_on_time_changed_gtk_calendar_next_year, self, 0);
	_tmp4_ = self->priv->calendar;
	g_signal_connect_object (_tmp4_, "prev-year", (GCallback) _adjust_date_time_dialog_on_time_changed_gtk_calendar_prev_year, self, 0);
	_tmp5_ = self->priv->ui_settings;
	if (g_settings_get_boolean (_tmp5_, "use-24-hour-time")) {
		GtkSpinButton* _tmp6_;
		_tmp6_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) 23, (gdouble) 1);
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (self->priv->hour);
		self->priv->hour = _tmp6_;
	} else {
		GtkSpinButton* _tmp7_;
		_tmp7_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) 12, (gdouble) 1);
		g_object_ref_sink (_tmp7_);
		_g_object_unref0 (self->priv->hour);
		self->priv->hour = _tmp7_;
	}
	_tmp8_ = self->priv->hour;
	g_signal_connect_object (_tmp8_, "output", (GCallback) _adjust_date_time_dialog_on_spin_button_output_gtk_spin_button_output, self, 0);
	_tmp9_ = self->priv->hour;
	gtk_entry_set_width_chars ((GtkEntry*) _tmp9_, 2);
	_tmp10_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) 59, (gdouble) 1);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->minute);
	self->priv->minute = _tmp10_;
	_tmp11_ = self->priv->minute;
	gtk_entry_set_width_chars ((GtkEntry*) _tmp11_, 2);
	_tmp12_ = self->priv->minute;
	g_signal_connect_object (_tmp12_, "output", (GCallback) _adjust_date_time_dialog_on_spin_button_output_gtk_spin_button_output, self, 0);
	_tmp13_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) 59, (gdouble) 1);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->second);
	self->priv->second = _tmp13_;
	_tmp14_ = self->priv->second;
	gtk_entry_set_width_chars ((GtkEntry*) _tmp14_, 2);
	_tmp15_ = self->priv->second;
	g_signal_connect_object (_tmp15_, "output", (GCallback) _adjust_date_time_dialog_on_spin_button_output_gtk_spin_button_output, self, 0);
	_tmp16_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->system);
	self->priv->system = _tmp16_;
	_tmp17_ = self->priv->system;
	gtk_combo_box_text_append_text (_tmp17_, _ ("AM"));
	_tmp18_ = self->priv->system;
	gtk_combo_box_text_append_text (_tmp18_, _ ("PM"));
	_tmp19_ = self->priv->system;
	gtk_combo_box_text_append_text (_tmp19_, _ ("24 Hr"));
	_tmp20_ = self->priv->system;
	g_signal_connect_object ((GtkComboBox*) _tmp20_, "changed", (GCallback) _adjust_date_time_dialog_on_time_system_changed_gtk_combo_box_changed, self, 0);
	_tmp21_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic (NULL, _ ("_Shift photos/videos by the same amount"));
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->relativity_radio_button);
	self->priv->relativity_radio_button = _tmp21_;
	_tmp22_ = self->priv->relativity_radio_button;
	_tmp23_ = self->priv->ui_settings;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp22_, g_settings_get_boolean (_tmp23_, "keep-relativity"));
	if (display_options) {
		_tmp24_ = photo_count > 1;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp25_ = self->priv->relativity_radio_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, _tmp24_);
	_tmp26_ = self->priv->relativity_radio_button;
	_tmp27_ = gtk_radio_button_get_group (_tmp26_);
	_tmp28_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic (_tmp27_, _ ("Set _all photos/videos to this time"));
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->batch_radio_button);
	self->priv->batch_radio_button = _tmp28_;
	_tmp29_ = self->priv->batch_radio_button;
	_tmp30_ = self->priv->ui_settings;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp29_, !g_settings_get_boolean (_tmp30_, "keep-relativity"));
	if (display_options) {
		_tmp31_ = photo_count > 1;
	} else {
		_tmp31_ = FALSE;
	}
	_tmp32_ = self->priv->batch_radio_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp32_, _tmp31_);
	_tmp33_ = self->priv->batch_radio_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp33_, "toggled", (GCallback) _adjust_date_time_dialog_on_time_changed_gtk_toggle_button_toggled, self, 0);
	if (contains_video) {
		GtkCheckButton* _tmp34_;
		_tmp34_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (ngettext ("_Modify original photo file", "_Modify original photo files", (gulong) photo_count));
		g_object_ref_sink (_tmp34_);
		_g_object_unref0 (self->priv->modify_originals_check_button);
		self->priv->modify_originals_check_button = _tmp34_;
	} else {
		GtkCheckButton* _tmp35_;
		_tmp35_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (ngettext ("_Modify original file", "_Modify original files", (gulong) photo_count));
		g_object_ref_sink (_tmp35_);
		_g_object_unref0 (self->priv->modify_originals_check_button);
		self->priv->modify_originals_check_button = _tmp35_;
	}
	_tmp37_ = self->priv->file_settings;
	if (g_settings_get_boolean (_tmp37_, "commit-metadata")) {
		_tmp36_ = display_options;
	} else {
		_tmp36_ = FALSE;
	}
	_tmp38_ = self->priv->modify_originals_check_button;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp38_, _tmp36_);
	if (!only_video) {
		gboolean _tmp40_ = FALSE;
		GSettings* _tmp41_;
		_tmp41_ = self->priv->file_settings;
		if (!g_settings_get_boolean (_tmp41_, "commit-metadata")) {
			_tmp40_ = display_options;
		} else {
			_tmp40_ = FALSE;
		}
		_tmp39_ = _tmp40_;
	} else {
		_tmp39_ = FALSE;
	}
	_tmp42_ = self->priv->modify_originals_check_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp42_, _tmp39_);
	preview = NULL;
	{
		GdkPixbuf* _tmp43_ = NULL;
		GdkPixbuf* _tmp44_;
		GdkPixbuf* _tmp45_;
		_tmp44_ = thumbnail_source_get_thumbnail ((ThumbnailSource*) source, ADJUST_DATE_TIME_DIALOG_CALENDAR_THUMBNAIL_SCALE, &_inner_error0_);
		_tmp43_ = _tmp44_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp45_ = _tmp43_;
		_tmp43_ = NULL;
		_g_object_unref0 (preview);
		preview = _tmp45_;
		_g_object_unref0 (_tmp43_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp46_;
		gchar* _tmp47_;
		g_clear_error (&_inner_error0_);
		_tmp46_ = data_object_to_string ((DataObject*) source);
		_tmp47_ = _tmp46_;
		g_warning ("AdjustDateTimeDialog.vala:129: Unable to fetch preview for %s", _tmp47_);
		_g_free0 (_tmp47_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (preview);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp49_ = preview;
	if (_tmp49_ != NULL) {
		GdkPixbuf* _tmp50_;
		GtkImage* _tmp51_;
		_tmp50_ = preview;
		_tmp51_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp50_);
		g_object_ref_sink (_tmp51_);
		_g_object_unref0 (_tmp48_);
		_tmp48_ = _tmp51_;
	} else {
		GtkImage* _tmp52_;
		_tmp52_ = (GtkImage*) gtk_image_new ();
		g_object_ref_sink (_tmp52_);
		_g_object_unref0 (_tmp48_);
		_tmp48_ = _tmp52_;
	}
	_tmp53_ = _g_object_ref0 (_tmp48_);
	image = _tmp53_;
	_tmp54_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (self->priv->original_time_label);
	self->priv->original_time_label = _tmp54_;
	_tmp55_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->notification);
	self->priv->notification = _tmp55_;
	_tmp56_ = self->priv->notification;
	gtk_label_set_line_wrap (_tmp56_, TRUE);
	_tmp57_ = self->priv->notification;
	gtk_label_set_justify (_tmp57_, GTK_JUSTIFY_CENTER);
	_tmp58_ = self->priv->notification;
	gtk_widget_set_size_request ((GtkWidget*) _tmp58_, -1, -1);
	_tmp59_ = self->priv->notification;
	gtk_misc_set_padding ((GtkMisc*) _tmp59_, 12, 6);
	_tmp60_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp60_);
	clock_grid = _tmp60_;
	_tmp61_ = clock_grid;
	gtk_grid_set_column_spacing (_tmp61_, 3);
	_tmp62_ = clock_grid;
	_tmp63_ = self->priv->hour;
	gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp63_);
	_tmp64_ = clock_grid;
	_tmp65_ = (GtkLabel*) gtk_label_new (":");
	g_object_ref_sink (_tmp65_);
	_tmp66_ = _tmp65_;
	gtk_container_add ((GtkContainer*) _tmp64_, (GtkWidget*) _tmp66_);
	_g_object_unref0 (_tmp66_);
	_tmp67_ = clock_grid;
	_tmp68_ = self->priv->minute;
	gtk_container_add ((GtkContainer*) _tmp67_, (GtkWidget*) _tmp68_);
	_tmp69_ = clock_grid;
	_tmp70_ = (GtkLabel*) gtk_label_new (":");
	g_object_ref_sink (_tmp70_);
	_tmp71_ = _tmp70_;
	gtk_container_add ((GtkContainer*) _tmp69_, (GtkWidget*) _tmp71_);
	_g_object_unref0 (_tmp71_);
	_tmp72_ = clock_grid;
	_tmp73_ = self->priv->second;
	gtk_container_add ((GtkContainer*) _tmp72_, (GtkWidget*) _tmp73_);
	_tmp74_ = clock_grid;
	_tmp75_ = self->priv->system;
	gtk_container_add ((GtkContainer*) _tmp74_, (GtkWidget*) _tmp75_);
	_tmp76_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp76_);
	grid = _tmp76_;
	_tmp77_ = grid;
	gtk_grid_set_column_spacing (_tmp77_, 12);
	_tmp78_ = grid;
	gtk_grid_set_row_spacing (_tmp78_, 12);
	_tmp79_ = grid;
	g_object_set ((GtkWidget*) _tmp79_, "margin", 6, NULL);
	_tmp80_ = grid;
	_tmp81_ = image;
	gtk_grid_attach (_tmp80_, (GtkWidget*) _tmp81_, 0, 0, 1, 1);
	_tmp82_ = grid;
	_tmp83_ = self->priv->original_time_label;
	gtk_grid_attach (_tmp82_, (GtkWidget*) _tmp83_, 0, 1, 1, 1);
	_tmp84_ = grid;
	_tmp85_ = self->priv->calendar;
	gtk_grid_attach (_tmp84_, (GtkWidget*) _tmp85_, 1, 0, 1, 1);
	_tmp86_ = grid;
	_tmp87_ = clock_grid;
	gtk_grid_attach (_tmp86_, (GtkWidget*) _tmp87_, 1, 1, 1, 1);
	_tmp88_ = grid;
	_tmp89_ = self->priv->notification;
	gtk_grid_attach (_tmp88_, (GtkWidget*) _tmp89_, 0, 5, 2, 1);
	if (display_options) {
		GtkGrid* _tmp90_;
		GtkRadioButton* _tmp91_;
		GtkGrid* _tmp92_;
		GtkRadioButton* _tmp93_;
		GtkGrid* _tmp94_;
		GtkCheckButton* _tmp95_;
		_tmp90_ = grid;
		_tmp91_ = self->priv->relativity_radio_button;
		gtk_grid_attach (_tmp90_, (GtkWidget*) _tmp91_, 1, 2, 1, 1);
		_tmp92_ = grid;
		_tmp93_ = self->priv->batch_radio_button;
		gtk_grid_attach (_tmp92_, (GtkWidget*) _tmp93_, 1, 3, 1, 1);
		_tmp94_ = grid;
		_tmp95_ = self->priv->modify_originals_check_button;
		gtk_grid_attach (_tmp94_, (GtkWidget*) _tmp95_, 1, 4, 1, 1);
	}
	_tmp96_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp97_ = grid;
	gtk_container_add ((GtkContainer*) _tmp96_, (GtkWidget*) _tmp97_);
	self->priv->original_time = dateable_get_exposure_time (source);
	if (self->priv->original_time == ((gint64) 0)) {
		time_t _tmp98_;
		_tmp98_ = time (NULL);
		self->priv->original_time = (gint64) _tmp98_;
		self->priv->no_original_time = TRUE;
	}
	_tmp99_ = g_date_time_new_from_unix_local (self->priv->original_time);
	_tmp100_ = _tmp99_;
	adjust_date_time_dialog_set_time (self, _tmp100_);
	_g_date_time_unref0 (_tmp100_);
	_tmp101_ = self->priv->ui_settings;
	adjust_date_time_dialog_set_original_time_label (self, g_settings_get_boolean (_tmp101_, "use-24-hour-time"));
	_g_object_unref0 (grid);
	_g_object_unref0 (clock_grid);
	_g_object_unref0 (image);
	_g_object_unref0 (_tmp48_);
	_g_object_unref0 (preview);
	return self;
}

AdjustDateTimeDialog*
adjust_date_time_dialog_new (Dateable* source,
                             gint photo_count,
                             gboolean display_options,
                             gboolean contains_video,
                             gboolean only_video)
{
	return adjust_date_time_dialog_construct (TYPE_ADJUST_DATE_TIME_DIALOG, source, photo_count, display_options, contains_video, only_video);
}

static void
adjust_date_time_dialog_set_time (AdjustDateTimeDialog* self,
                                  GDateTime* time)
{
	GtkCalendar* _tmp0_;
	GtkCalendar* _tmp1_;
	GSettings* _tmp2_;
	GtkSpinButton* _tmp9_;
	GtkSpinButton* _tmp10_;
	GtkComboBoxText* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (time != NULL);
	_tmp0_ = self->priv->calendar;
	gtk_calendar_select_month (_tmp0_, (guint) g_date_time_get_month (time), (guint) g_date_time_get_year (time));
	_tmp1_ = self->priv->calendar;
	gtk_calendar_select_day (_tmp1_, (guint) g_date_time_get_day_of_month (time));
	_tmp2_ = self->priv->ui_settings;
	if (g_settings_get_boolean (_tmp2_, "use-24-hour-time")) {
		GtkSpinButton* _tmp3_;
		GtkComboBoxText* _tmp4_;
		_tmp3_ = self->priv->hour;
		gtk_spin_button_set_value (_tmp3_, (gdouble) g_date_time_get_hour (time));
		_tmp4_ = self->priv->system;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp4_, (gint) ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_24HR);
	} else {
		gint ampm_hour = 0;
		gint _tmp5_ = 0;
		GtkSpinButton* _tmp6_;
		AdjustDateTimeDialogTimeSystem _tmp7_ = 0;
		GtkComboBoxText* _tmp8_;
		ampm_hour = g_date_time_get_hour (time) % 12;
		if (ampm_hour == 0) {
			_tmp5_ = 12;
		} else {
			_tmp5_ = ampm_hour;
		}
		_tmp6_ = self->priv->hour;
		gtk_spin_button_set_value (_tmp6_, (gdouble) _tmp5_);
		if (g_date_time_get_hour (time) >= 12) {
			_tmp7_ = ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_PM;
		} else {
			_tmp7_ = ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_AM;
		}
		_tmp8_ = self->priv->system;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp8_, (gint) _tmp7_);
	}
	_tmp9_ = self->priv->minute;
	gtk_spin_button_set_value (_tmp9_, (gdouble) g_date_time_get_minute (time));
	_tmp10_ = self->priv->second;
	gtk_spin_button_set_value (_tmp10_, (gdouble) g_date_time_get_second (time));
	_tmp11_ = self->priv->system;
	self->priv->previous_time_system = (AdjustDateTimeDialogTimeSystem) gtk_combo_box_get_active ((GtkComboBox*) _tmp11_);
}

static void
adjust_date_time_dialog_set_original_time_label (AdjustDateTimeDialog* self,
                                                 gboolean use_24_hr_format)
{
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	if (self->priv->no_original_time) {
		return;
	}
	if (use_24_hr_format) {
		_tmp0_ = _ ("%m/%d/%Y, %H:%M:%S");
	} else {
		_tmp0_ = _ ("%m/%d/%Y, %I:%M:%S %p");
	}
	_tmp1_ = self->priv->original_time_label;
	_tmp2_ = g_date_time_new_from_unix_local (self->priv->original_time);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_date_time_format (_tmp3_, _tmp0_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf (_ ("Original: %s"), _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_label_set_text (_tmp1_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_date_time_unref0 (_tmp3_);
}

static gint64
adjust_date_time_dialog_get_time (AdjustDateTimeDialog* self)
{
	gint hour = 0;
	GtkSpinButton* _tmp0_;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gint _tmp4_ = 0;
	GtkComboBoxText* _tmp5_;
	guint year = 0U;
	guint month = 0U;
	guint day = 0U;
	GtkCalendar* _tmp6_;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	GDateTime* date_time = NULL;
	GtkSpinButton* _tmp10_;
	GtkSpinButton* _tmp11_;
	GDateTime* _tmp12_;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->hour;
	hour = (gint) gtk_spin_button_get_value (_tmp0_);
	if (hour == 12) {
		GtkComboBoxText* _tmp3_;
		_tmp3_ = self->priv->system;
		_tmp2_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp3_) != ((gint) ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_24HR);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = 0;
	} else {
		_tmp1_ = hour;
	}
	hour = _tmp1_;
	_tmp5_ = self->priv->system;
	if (gtk_combo_box_get_active ((GtkComboBox*) _tmp5_) == ((gint) ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_PM)) {
		_tmp4_ = 12;
	} else {
		_tmp4_ = 0;
	}
	hour += _tmp4_;
	_tmp6_ = self->priv->calendar;
	gtk_calendar_get_date (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
	year = _tmp7_;
	month = _tmp8_;
	day = _tmp9_;
	_tmp10_ = self->priv->minute;
	_tmp11_ = self->priv->second;
	_tmp12_ = g_date_time_new_local ((gint) year, (gint) month, (gint) day, hour, (gint) gtk_spin_button_get_value (_tmp10_), gtk_spin_button_get_value (_tmp11_));
	date_time = _tmp12_;
	result = g_date_time_to_unix (date_time);
	_g_date_time_unref0 (date_time);
	return result;
}

gboolean
adjust_date_time_dialog_execute (AdjustDateTimeDialog* self,
                                 gint64* time_shift,
                                 gboolean* keep_relativity,
                                 gboolean* modify_originals)
{
	gint64 _vala_time_shift = 0LL;
	gboolean _vala_keep_relativity = FALSE;
	gboolean _vala_modify_originals = FALSE;
	gboolean response = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_widget_show_all ((GtkWidget*) self);
	response = FALSE;
	if (gtk_dialog_run ((GtkDialog*) self) == ((gint) GTK_RESPONSE_OK)) {
		GtkRadioButton* _tmp0_;
		GtkRadioButton* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		GtkCheckButton* _tmp5_;
		GtkCheckButton* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		if (self->priv->no_original_time) {
			_vala_time_shift = adjust_date_time_dialog_get_time (self);
		} else {
			_vala_time_shift = adjust_date_time_dialog_get_time (self) - self->priv->original_time;
		}
		_tmp0_ = self->priv->relativity_radio_button;
		_vala_keep_relativity = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
		_tmp1_ = self->priv->relativity_radio_button;
		_tmp2_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			GSettings* _tmp4_;
			_tmp4_ = self->priv->ui_settings;
			g_settings_set_boolean (_tmp4_, "keep-relativity", _vala_keep_relativity);
		}
		_tmp5_ = self->priv->modify_originals_check_button;
		_vala_modify_originals = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp5_);
		_tmp6_ = self->priv->modify_originals_check_button;
		_tmp7_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_) {
			GSettings* _tmp9_;
			_tmp9_ = self->priv->ui_settings;
			g_settings_set_boolean (_tmp9_, "modify-originals", _vala_modify_originals);
		}
		response = TRUE;
	} else {
		_vala_time_shift = (gint64) 0;
		_vala_keep_relativity = TRUE;
		_vala_modify_originals = FALSE;
	}
	gtk_widget_destroy ((GtkWidget*) self);
	result = response;
	if (time_shift) {
		*time_shift = _vala_time_shift;
	}
	if (keep_relativity) {
		*keep_relativity = _vala_keep_relativity;
	}
	if (modify_originals) {
		*modify_originals = _vala_modify_originals;
	}
	return result;
}

static gboolean
adjust_date_time_dialog_on_spin_button_output (AdjustDateTimeDialog* self,
                                               GtkSpinButton* button)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (button != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("%02d", (gint) gtk_spin_button_get_value (button));
	_tmp1_ = _tmp0_;
	gtk_entry_set_text ((GtkEntry*) button, _tmp1_);
	_g_free0 (_tmp1_);
	adjust_date_time_dialog_on_time_changed (self);
	result = TRUE;
	return result;
}

static void
adjust_date_time_dialog_on_time_changed (AdjustDateTimeDialog* self)
{
	gint64 time_shift = 0LL;
	GtkComboBoxText* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	time_shift = adjust_date_time_dialog_get_time (self) - self->priv->original_time;
	_tmp0_ = self->priv->system;
	self->priv->previous_time_system = (AdjustDateTimeDialogTimeSystem) gtk_combo_box_get_active ((GtkComboBox*) _tmp0_);
	if (time_shift == ((gint64) 0)) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->priv->no_original_time;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		GtkRadioButton* _tmp4_;
		_tmp4_ = self->priv->batch_radio_button;
		if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp4_)) {
			GtkRadioButton* _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp5_ = self->priv->batch_radio_button;
			_tmp6_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp3_ = _tmp7_;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		GtkLabel* _tmp8_;
		_tmp8_ = self->priv->notification;
		gtk_widget_hide ((GtkWidget*) _tmp8_);
	} else {
		gboolean forward = FALSE;
		gint days = 0;
		gint hours = 0;
		gint minutes = 0;
		gint seconds = 0;
		const gchar* _tmp9_ = NULL;
		gchar* shift_status = NULL;
		gchar* _tmp10_;
		GtkLabel* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GtkLabel* _tmp15_;
		forward = time_shift > ((gint64) 0);
		time_shift = llabs (time_shift);
		days = (gint) (time_shift / ADJUST_DATE_TIME_DIALOG_SECONDS_IN_DAY);
		time_shift = time_shift % ADJUST_DATE_TIME_DIALOG_SECONDS_IN_DAY;
		hours = (gint) (time_shift / ADJUST_DATE_TIME_DIALOG_SECONDS_IN_HOUR);
		time_shift = time_shift % ADJUST_DATE_TIME_DIALOG_SECONDS_IN_HOUR;
		minutes = (gint) (time_shift / ADJUST_DATE_TIME_DIALOG_SECONDS_IN_MINUTE);
		seconds = (gint) (time_shift % ADJUST_DATE_TIME_DIALOG_SECONDS_IN_MINUTE);
		if (forward) {
			_tmp9_ = _ ("Exposure time will be shifted forward by\n" \
"%d %s, %d %s, %d %s, and %d %s.");
		} else {
			_tmp9_ = _ ("Exposure time will be shifted backward by\n" \
"%d %s, %d %s, %d %s, and %d %s.");
		}
		_tmp10_ = g_strdup (_tmp9_);
		shift_status = _tmp10_;
		_tmp11_ = self->priv->notification;
		_tmp12_ = shift_status;
		_tmp13_ = g_strdup_printf (_tmp12_, days, ngettext ("day", "days", (gulong) days), hours, ngettext ("hour", "hours", (gulong) hours), minutes, ngettext ("minute", "minutes", (gulong) minutes), seconds, ngettext ("second", "seconds", (gulong) seconds));
		_tmp14_ = _tmp13_;
		gtk_label_set_text (_tmp11_, _tmp14_);
		_g_free0 (_tmp14_);
		_tmp15_ = self->priv->notification;
		gtk_widget_show ((GtkWidget*) _tmp15_);
		_g_free0 (shift_status);
	}
}

static void
adjust_date_time_dialog_on_time_system_changed (AdjustDateTimeDialog* self)
{
	GtkComboBoxText* _tmp0_;
	GSettings* _tmp1_;
	GtkComboBoxText* _tmp2_;
	GtkComboBoxText* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->system;
	if (self->priv->previous_time_system == gtk_combo_box_get_active ((GtkComboBox*) _tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->ui_settings;
	_tmp2_ = self->priv->system;
	g_settings_set_boolean (_tmp1_, "use-24-hour-time", gtk_combo_box_get_active ((GtkComboBox*) _tmp2_) == ((gint) ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_24HR));
	_tmp3_ = self->priv->system;
	if (gtk_combo_box_get_active ((GtkComboBox*) _tmp3_) == ((gint) ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_24HR)) {
		gint _tmp4_ = 0;
		GtkSpinButton* _tmp5_;
		gint time = 0;
		gint _tmp7_ = 0;
		GtkSpinButton* _tmp8_;
		GtkSpinButton* _tmp9_;
		_tmp5_ = self->priv->hour;
		if (gtk_spin_button_get_value (_tmp5_) == 12.0) {
			_tmp4_ = 0;
		} else {
			GtkSpinButton* _tmp6_;
			_tmp6_ = self->priv->hour;
			_tmp4_ = (gint) gtk_spin_button_get_value (_tmp6_);
		}
		time = _tmp4_;
		if (self->priv->previous_time_system == ADJUST_DATE_TIME_DIALOG_TIME_SYSTEM_PM) {
			_tmp7_ = 12;
		} else {
			_tmp7_ = 0;
		}
		time = time + _tmp7_;
		_tmp8_ = self->priv->hour;
		gtk_spin_button_set_range (_tmp8_, (gdouble) 0, (gdouble) 23);
		adjust_date_time_dialog_set_original_time_label (self, TRUE);
		_tmp9_ = self->priv->hour;
		gtk_spin_button_set_value (_tmp9_, (gdouble) time);
	} else {
		gint ampm_hour = 0;
		GtkSpinButton* _tmp10_;
		GtkSpinButton* _tmp11_;
		gint _tmp12_ = 0;
		GtkSpinButton* _tmp13_;
		_tmp10_ = self->priv->hour;
		ampm_hour = ((gint) gtk_spin_button_get_value (_tmp10_)) % 12;
		_tmp11_ = self->priv->hour;
		gtk_spin_button_set_range (_tmp11_, (gdouble) 1, (gdouble) 12);
		adjust_date_time_dialog_set_original_time_label (self, FALSE);
		if (ampm_hour == 0) {
			_tmp12_ = 12;
		} else {
			_tmp12_ = ampm_hour;
		}
		_tmp13_ = self->priv->hour;
		gtk_spin_button_set_value (_tmp13_, (gdouble) _tmp12_);
	}
	adjust_date_time_dialog_on_time_changed (self);
}

static GObject *
adjust_date_time_dialog_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AdjustDateTimeDialog * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	AppWindow* _tmp2_;
	AppWindow* _tmp3_;
	parent_class = G_OBJECT_CLASS (adjust_date_time_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADJUST_DATE_TIME_DIALOG, AdjustDateTimeDialog);
	_tmp0_ = g_settings_new (GSETTINGS_CONFIGURATION_ENGINE_UI_PREFS_SCHEMA_NAME);
	_g_object_unref0 (self->priv->ui_settings);
	self->priv->ui_settings = _tmp0_;
	_tmp1_ = g_settings_new (GSETTINGS_CONFIGURATION_ENGINE_FILES_PREFS_SCHEMA_NAME);
	_g_object_unref0 (self->priv->file_settings);
	self->priv->file_settings = _tmp1_;
	gtk_dialog_add_buttons ((GtkDialog*) self, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Apply"), GTK_RESPONSE_OK, NULL);
	gtk_window_set_deletable ((GtkWindow*) self, FALSE);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_window_set_title ((GtkWindow*) self, _ (RESOURCES_ADJUST_DATE_TIME_LABEL));
	_tmp2_ = app_window_get_instance ();
	_tmp3_ = _tmp2_;
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	gtk_dialog_set_default_response ((GtkDialog*) self, (gint) GTK_RESPONSE_OK);
	return obj;
}

static void
adjust_date_time_dialog_class_init (AdjustDateTimeDialogClass * klass,
                                    gpointer klass_data)
{
	adjust_date_time_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AdjustDateTimeDialog_private_offset);
	G_OBJECT_CLASS (klass)->constructor = adjust_date_time_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = adjust_date_time_dialog_finalize;
}

static void
adjust_date_time_dialog_instance_init (AdjustDateTimeDialog * self,
                                       gpointer klass)
{
	self->priv = adjust_date_time_dialog_get_instance_private (self);
	self->priv->no_original_time = FALSE;
}

static void
adjust_date_time_dialog_finalize (GObject * obj)
{
	AdjustDateTimeDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADJUST_DATE_TIME_DIALOG, AdjustDateTimeDialog);
	_g_object_unref0 (self->priv->original_time_label);
	_g_object_unref0 (self->priv->calendar);
	_g_object_unref0 (self->priv->hour);
	_g_object_unref0 (self->priv->minute);
	_g_object_unref0 (self->priv->second);
	_g_object_unref0 (self->priv->system);
	_g_object_unref0 (self->priv->relativity_radio_button);
	_g_object_unref0 (self->priv->batch_radio_button);
	_g_object_unref0 (self->priv->modify_originals_check_button);
	_g_object_unref0 (self->priv->notification);
	_g_object_unref0 (self->priv->ui_settings);
	_g_object_unref0 (self->priv->file_settings);
	G_OBJECT_CLASS (adjust_date_time_dialog_parent_class)->finalize (obj);
}

static GType
adjust_date_time_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AdjustDateTimeDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) adjust_date_time_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AdjustDateTimeDialog), 0, (GInstanceInitFunc) adjust_date_time_dialog_instance_init, NULL };
	GType adjust_date_time_dialog_type_id;
	adjust_date_time_dialog_type_id = g_type_register_static (GRANITE_TYPE_DIALOG, "AdjustDateTimeDialog", &g_define_type_info, 0);
	AdjustDateTimeDialog_private_offset = g_type_add_instance_private (adjust_date_time_dialog_type_id, sizeof (AdjustDateTimeDialogPrivate));
	return adjust_date_time_dialog_type_id;
}

GType
adjust_date_time_dialog_get_type (void)
{
	static volatile gsize adjust_date_time_dialog_type_id__once = 0;
	if (g_once_init_enter (&adjust_date_time_dialog_type_id__once)) {
		GType adjust_date_time_dialog_type_id;
		adjust_date_time_dialog_type_id = adjust_date_time_dialog_get_type_once ();
		g_once_init_leave (&adjust_date_time_dialog_type_id__once, adjust_date_time_dialog_type_id);
	}
	return adjust_date_time_dialog_type_id__once;
}

