/* Resources.c generated by valac 0.56.18, the Vala compiler
 * generated from Resources.vala, do not modify */

/*
* Copyright (c) 2018 elementary, Inc. (https://elementary.io)
*               2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <granite.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <locale.h>

#define RESOURCES_LIB _LIB
#define RESOURCES_LIBEXECDIR _LIBEXECDIR
#define RESOURCES_FLAG_PADDING 2
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

VALA_EXTERN GdkPixbuf* resources_flag_trinket_cache;
GdkPixbuf* resources_flag_trinket_cache = NULL;
VALA_EXTERN gchar* resources_hh_mm_format_string;
gchar* resources_hh_mm_format_string = NULL;
VALA_EXTERN gchar* resources_hh_mm_ss_format_string;
gchar* resources_hh_mm_ss_format_string = NULL;
VALA_EXTERN gchar* resources_long_date_format_string;
gchar* resources_long_date_format_string = NULL;
VALA_EXTERN gchar* resources_start_multiday_date_format_string;
gchar* resources_start_multiday_date_format_string = NULL;
VALA_EXTERN gchar* resources_end_multiday_date_format_string;
gchar* resources_end_multiday_date_format_string = NULL;
VALA_EXTERN gchar* resources_start_multimonth_date_format_string;
gchar* resources_start_multimonth_date_format_string = NULL;
VALA_EXTERN GdkPixbuf* resources_noninterpretable_badge_pixbuf;
GdkPixbuf* resources_noninterpretable_badge_pixbuf = NULL;

VALA_EXTERN gchar* hierarchical_tag_utilities_get_basename (const gchar* in_path);
VALA_EXTERN void resources_fetch_lc_time_format (void);

gchar*
resources_add_tags_label (gchar** names,
                          gint names_length1)
{
	gchar* result;
	if (names_length1 == 1) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = names[0];
		_tmp1_ = hierarchical_tag_utilities_get_basename (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf (_ ("Add Tag \"%s\""), _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		result = _tmp4_;
		return result;
	} else {
		if (names_length1 == 2) {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp5_ = names[0];
			_tmp6_ = hierarchical_tag_utilities_get_basename (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = names[1];
			_tmp9_ = hierarchical_tag_utilities_get_basename (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strdup_printf (_ ("Add Tags \"%s\" and \"%s\""), _tmp7_, _tmp10_);
			_tmp12_ = _tmp11_;
			_g_free0 (_tmp10_);
			_g_free0 (_tmp7_);
			result = _tmp12_;
			return result;
		} else {
			gchar* _tmp13_;
			_tmp13_ = g_strdup (_ ("Add Tags"));
			result = _tmp13_;
			return result;
		}
	}
}

gchar*
resources_delete_tag_menu (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("_Delete Tag \"%s\""), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_delete_tag_label (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Delete Tag \"%s\""), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_rename_tag_menu (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Re_name Tag \"%s\"…"), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_rename_tag_label (const gchar* old_name,
                            const gchar* new_name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (old_name != NULL, NULL);
	g_return_val_if_fail (new_name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Rename Tag \"%s\" to \"%s\""), old_name, new_name);
	result = _tmp0_;
	return result;
}

gchar*
resources_tag_photos_label (const gchar* name,
                            gint count)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (ngettext ("Tag Photo as \"%s\"", "Tag Photos as \"%s\"", (gulong) count), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_untag_photos_menu (const gchar* name,
                             gint count)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (ngettext ("Remove Tag \"%s\" From _Photo", "Remove Tag \"%s\" From _Photos", (gulong) count), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_untag_photos_label (const gchar* name,
                              gint count)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (ngettext ("Remove Tag \"%s\" From Photo", "Remove Tag \"%s\" From Photos", (gulong) count), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_rename_tag_exists_message (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Unable to rename tag to \"%s\" because the tag already exists."), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_rename_search_exists_message (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Unable to rename search to \"%s\" because the search already exists."), name);
	result = _tmp0_;
	return result;
}

gchar*
resources_rename_search_label (const gchar* old_name,
                               const gchar* new_name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (old_name != NULL, NULL);
	g_return_val_if_fail (new_name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Rename Search \"%s\" to \"%s\""), old_name, new_name);
	result = _tmp0_;
	return result;
}

gchar*
resources_delete_search_label (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Delete Search \"%s\""), name);
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}

GdkPixbuf*
resources_get_flag_trinket (void)
{
	GdkPixbuf* _tmp0_;
	gint size = 0;
	gint padded_size = 0;
	GraniteDrawingBufferSurface* surface = NULL;
	GraniteDrawingBufferSurface* _tmp3_;
	cairo_t* cr = NULL;
	GraniteDrawingBufferSurface* _tmp4_;
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	cairo_t* _tmp9_;
	cairo_t* _tmp10_;
	GdkPixbuf* flag = NULL;
	cairo_t* _tmp15_;
	GdkPixbuf* _tmp16_;
	cairo_t* _tmp17_;
	GraniteDrawingBufferSurface* _tmp18_;
	GdkPixbuf* _tmp19_;
	GdkPixbuf* _tmp20_;
	GdkPixbuf* _tmp21_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	_tmp0_ = resources_flag_trinket_cache;
	if (_tmp0_ != NULL) {
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_;
		_tmp1_ = resources_flag_trinket_cache;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	size = 16;
	padded_size = size + (RESOURCES_FLAG_PADDING * 2);
	_tmp3_ = granite_drawing_buffer_surface_new (padded_size, padded_size);
	surface = _tmp3_;
	_tmp4_ = surface;
	_tmp5_ = granite_drawing_buffer_surface_get_context (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _cairo_reference0 (_tmp6_);
	cr = _tmp7_;
	_tmp8_ = cr;
	cairo_set_source_rgba (_tmp8_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.35);
	_tmp9_ = cr;
	cairo_rectangle (_tmp9_, (gdouble) 0, (gdouble) 0, (gdouble) padded_size, (gdouble) padded_size);
	_tmp10_ = cr;
	cairo_paint (_tmp10_);
	{
		GdkPixbuf* _tmp11_ = NULL;
		GtkIconTheme* _tmp12_;
		GdkPixbuf* _tmp13_;
		GdkPixbuf* _tmp14_;
		_tmp12_ = gtk_icon_theme_get_default ();
		_tmp13_ = gtk_icon_theme_load_icon (_tmp12_, RESOURCES_ICON_FLAGGED_PAGE, size, GTK_ICON_LOOKUP_FORCE_SIZE, &_inner_error0_);
		_tmp11_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp14_ = _tmp11_;
		_tmp11_ = NULL;
		_g_object_unref0 (flag);
		flag = _tmp14_;
		_g_object_unref0 (_tmp11_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_g_object_unref0 (flag);
		_cairo_destroy0 (cr);
		_g_object_unref0 (surface);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (flag);
		_cairo_destroy0 (cr);
		_g_object_unref0 (surface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp15_ = cr;
	_tmp16_ = flag;
	gdk_cairo_set_source_pixbuf (_tmp15_, _tmp16_, (gdouble) RESOURCES_FLAG_PADDING, (gdouble) RESOURCES_FLAG_PADDING);
	_tmp17_ = cr;
	cairo_paint (_tmp17_);
	_tmp18_ = surface;
	_tmp19_ = granite_drawing_buffer_surface_load_to_pixbuf (_tmp18_);
	_g_object_unref0 (resources_flag_trinket_cache);
	resources_flag_trinket_cache = _tmp19_;
	_tmp20_ = resources_flag_trinket_cache;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	result = _tmp21_;
	_g_object_unref0 (flag);
	_cairo_destroy0 (cr);
	_g_object_unref0 (surface);
	return result;
}

gchar*
resources_jump_to_file_failed (GError* err)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (err != NULL, NULL);
	_tmp0_ = err->message;
	_tmp1_ = g_strdup_printf (_ ("Unable to open in file manager: %s"), _tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Helper for getting a format string that matches the
 * user's LC_TIME settings from the system.  This is intended
 * to help support the use case where a user wants the text
 * from one locale, but the timestamp format of another.
 *
 * Stolen wholesale from code written for Geary by Jim Nelson
 * and from Marcel Stimberg's original patch to Photos to
 * try to fix this; both are graciously thanked for their help.
 */
void
resources_fetch_lc_time_format (void)
{
	gchar* old_language = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* old_messages = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* lc_time = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp17_;
	_tmp0_ = g_getenv ("LANGUAGE");
	_tmp1_ = g_strdup (_tmp0_);
	old_language = _tmp1_;
	_tmp2_ = old_language;
	if (_tmp2_ != NULL) {
		g_unsetenv ("LANGUAGE");
	}
	_tmp3_ = setlocale (LC_MESSAGES, NULL);
	_tmp4_ = g_strdup (_tmp3_);
	old_messages = _tmp4_;
	_tmp5_ = setlocale (LC_TIME, NULL);
	_tmp6_ = g_strdup (_tmp5_);
	lc_time = _tmp6_;
	_tmp7_ = lc_time;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = lc_time;
		setlocale (LC_MESSAGES, _tmp8_);
	}
	_tmp9_ = g_strdup (_ ("%-I:%M %p"));
	_g_free0 (resources_hh_mm_format_string);
	resources_hh_mm_format_string = _tmp9_;
	_tmp10_ = g_strdup (_ ("%-I:%M:%S %p"));
	_g_free0 (resources_hh_mm_ss_format_string);
	resources_hh_mm_ss_format_string = _tmp10_;
	_tmp11_ = g_strdup (_ ("%a %b %d, %Y"));
	_g_free0 (resources_long_date_format_string);
	resources_long_date_format_string = _tmp11_;
	_tmp12_ = g_strdup (_ ("%a %b %d"));
	_g_free0 (resources_start_multiday_date_format_string);
	resources_start_multiday_date_format_string = _tmp12_;
	_tmp13_ = g_strdup (_ ("%d, %Y"));
	_g_free0 (resources_end_multiday_date_format_string);
	resources_end_multiday_date_format_string = _tmp13_;
	_tmp14_ = g_strdup (_ ("%a %b %d"));
	_g_free0 (resources_start_multimonth_date_format_string);
	resources_start_multimonth_date_format_string = _tmp14_;
	_tmp15_ = old_messages;
	if (_tmp15_ != NULL) {
		const gchar* _tmp16_;
		_tmp16_ = old_messages;
		setlocale (LC_MESSAGES, _tmp16_);
	}
	_tmp17_ = old_language;
	if (_tmp17_ != NULL) {
		const gchar* _tmp18_;
		_tmp18_ = old_language;
		g_setenv ("LANGUAGE", _tmp18_, TRUE);
	}
	_g_free0 (lc_time);
	_g_free0 (old_messages);
	_g_free0 (old_language);
}

/**
 * Returns a precached format string that matches the
 * user's LC_TIME settings.
 */
gchar*
resources_get_hh_mm_format_string (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = resources_hh_mm_format_string;
	if (_tmp0_ == NULL) {
		resources_fetch_lc_time_format ();
	}
	_tmp1_ = resources_hh_mm_format_string;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
resources_get_hh_mm_ss_format_string (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = resources_hh_mm_ss_format_string;
	if (_tmp0_ == NULL) {
		resources_fetch_lc_time_format ();
	}
	_tmp1_ = resources_hh_mm_ss_format_string;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
resources_get_long_date_format_string (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = resources_long_date_format_string;
	if (_tmp0_ == NULL) {
		resources_fetch_lc_time_format ();
	}
	_tmp1_ = resources_long_date_format_string;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
resources_get_start_multiday_span_format_string (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = resources_start_multiday_date_format_string;
	if (_tmp0_ == NULL) {
		resources_fetch_lc_time_format ();
	}
	_tmp1_ = resources_start_multiday_date_format_string;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
resources_get_end_multiday_span_format_string (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = resources_end_multiday_date_format_string;
	if (_tmp0_ == NULL) {
		resources_fetch_lc_time_format ();
	}
	_tmp1_ = resources_end_multiday_date_format_string;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
resources_get_start_multimonth_span_format_string (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = resources_start_multimonth_date_format_string;
	if (_tmp0_ == NULL) {
		resources_fetch_lc_time_format ();
	}
	_tmp1_ = resources_start_multimonth_date_format_string;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
resources_get_end_multimonth_span_format_string (void)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = resources_get_long_date_format_string ();
	result = _tmp0_;
	return result;
}

GdkPixbuf*
resources_get_noninterpretable_badge_pixbuf (void)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	_tmp0_ = resources_noninterpretable_badge_pixbuf;
	if (_tmp0_ == NULL) {
		{
			GdkPixbuf* _tmp1_ = NULL;
			GdkPixbuf* _tmp2_;
			GdkPixbuf* _tmp3_;
			_tmp2_ = gdk_pixbuf_new_from_resource ("/io/elementary/photos/backgrounds/noninterpretable-video.svg", &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (resources_noninterpretable_badge_pixbuf);
			resources_noninterpretable_badge_pixbuf = _tmp3_;
			_g_object_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp4_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = err->message;
			g_error ("Resources.vala:435: VideoReader can't load noninterpretable badge imag" \
"e: %s", _tmp4_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = resources_noninterpretable_badge_pixbuf;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	result = _tmp6_;
	return result;
}

