/* Page.c generated by valac 0.56.18, the Vala compiler
 * generated from Page.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <granite.h>
#include <cairo-gobject.h>

#define PAGE_CONSIDER_CONFIGURE_HALTED_MSEC 400
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PAGE_0_PROPERTY,
	PAGE_IN_VIEW_PROPERTY,
	PAGE_PAGE_NAME_PROPERTY,
	PAGE_NUM_PROPERTIES
};
static GParamSpec* page_properties[PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _one_shot_scheduler_unref0(var) ((var == NULL) ? NULL : (var = (one_shot_scheduler_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PagePrivate {
	ViewCollection* view;
	GtkWindow* container;
	GdkRectangle last_position;
	GtkWidget* event_source;
	gint64 last_configure_ms;
	gboolean report_move_finished;
	gboolean report_resize_finished;
	GdkPoint last_down;
	gboolean is_destroyed;
	gboolean ctrl_pressed;
	gboolean alt_pressed;
	gboolean shift_pressed;
	gboolean super_pressed;
	GdkCursorType last_cursor;
	gboolean cursor_hidden;
	gint cursor_hide_msec;
	guint last_timeout_id;
	gint cursor_hide_time_cached;
	gboolean are_actions_attached;
	OneShotScheduler* update_actions_scheduler;
	GtkActionGroup* action_group;
	GtkActionGroup** common_action_groups;
	gint common_action_groups_length1;
	gint _common_action_groups_size_;
	GList* contractor_menu_items;
	gboolean _in_view;
	gchar* _page_name;
	gdouble total_dx;
	gdouble total_dy;
};

static gint Page_private_offset;
static gpointer page_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _vala_array_add211 (GFile** * array,
                         gint* length,
                         gint* size,
                         GFile* value);
static void __lambda47_ (Page* self,
                  GtkWidget* item);
static void ___lambda47__gfunc (gconstpointer data,
                         gpointer self);
static void page_real_destroy (GtkWidget* base);
static void page_detach_event_source (Page* self);
static void page_detach_view_signals (Page* self);
static void page_real_set_container (Page* self,
                              GtkWindow* container);
static void page_real_clear_container (Page* self);
static gboolean page_on_button_pressed_internal (Page* self,
                                          GdkEventButton* event);
static gboolean _page_on_button_pressed_internal_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                         GdkEventButton* event,
                                                                         gpointer self);
static gboolean page_on_button_released_internal (Page* self,
                                           GdkEventButton* event);
static gboolean _page_on_button_released_internal_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                            GdkEventButton* event,
                                                                            gpointer self);
static gboolean page_on_motion_internal (Page* self,
                                  GdkEventMotion* event);
static gboolean _page_on_motion_internal_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                  GdkEventMotion* event,
                                                                  gpointer self);
static gboolean _page_on_leave_notify_event_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                    GdkEventCrossing* event,
                                                                    gpointer self);
static gboolean page_on_mousewheel_internal (Page* self,
                                      GdkEventScroll* event);
static gboolean _page_on_mousewheel_internal_gtk_widget_scroll_event (GtkWidget* _sender,
                                                               GdkEventScroll* event,
                                                               gpointer self);
static void page_on_event_source_realize (Page* self);
static void _page_on_event_source_realize_gtk_widget_realize (GtkWidget* _sender,
                                                       gpointer self);
static void page_real_add_toolbar_widgets (Page* self,
                                    GtkActionBar* toolbar);
static GtkMenu* page_real_get_page_context_menu (Page* self);
static GtkMenu* page_real_get_page_sidebar_menu (Page* self);
static void page_real_switching_from (Page* self);
static void page_set_in_view (Page* self,
                       gboolean value);
static void page_real_switched_to (Page* self);
static void page_update_modifiers (Page* self);
static void page_real_ready (Page* self);
static void page_real_switching_to_fullscreen (Page* self,
                                        FullscreenWindow* fsw);
static void page_real_returning_from_fullscreen (Page* self,
                                          FullscreenWindow* fsw);
static gboolean page_get_modifiers (Page* self,
                             gboolean* ctrl,
                             gboolean* alt,
                             gboolean* shift,
                             gboolean* super);
static GtkBox* page_real_get_header_buttons (Page* self);
static void page_attach_view_signals (Page* self);
static void page_on_update_actions (Page* self);
static void _page_on_update_actions_view_collection_items_state_changed (ViewCollection* _sender,
                                                                  GeeIterable* changed,
                                                                  gpointer self);
static void _page_on_update_actions_view_collection_selection_group_altered (ViewCollection* _sender,
                                                                      gpointer self);
static void _page_on_update_actions_view_collection_items_visibility_changed (ViewCollection* _sender,
                                                                       GeeCollection* changed,
                                                                       gpointer self);
static void _page_on_update_actions_data_collection_contents_altered (DataCollection* _sender,
                                                               GeeIterable* added,
                                                               GeeIterable* removed,
                                                               gpointer self);
static void page_on_update_actions_on_idle (Page* self);
static void _page_on_update_actions_on_idle_one_shot_callback (gpointer self);
static GtkActionEntry* page_real_init_collect_action_entries (Page* self,
                                                       gint* result_length1);
static GtkToggleActionEntry* page_real_init_collect_toggle_action_entries (Page* self,
                                                                    gint* result_length1);
static void page_real_register_radio_actions (Page* self,
                                       GtkActionGroup* action_group);
static void page_real_init_actions (Page* self,
                             gint selected_count,
                             gint count);
static void page_real_update_actions (Page* self,
                               gint selected_count,
                               gint count);
static gboolean page_real_on_left_click (Page* self,
                                  GdkEventButton* event);
static gboolean page_real_on_middle_click (Page* self,
                                    GdkEventButton* event);
static gboolean page_real_on_right_click (Page* self,
                                   GdkEventButton* event);
static gboolean page_real_on_left_released (Page* self,
                                     GdkEventButton* event);
static gboolean page_real_on_middle_released (Page* self,
                                       GdkEventButton* event);
static gboolean page_real_on_right_released (Page* self,
                                      GdkEventButton* event);
static gboolean page_real_on_ctrl_pressed (Page* self,
                                    GdkEventKey* event);
static gboolean page_real_on_ctrl_released (Page* self,
                                     GdkEventKey* event);
static gboolean page_real_on_alt_pressed (Page* self,
                                   GdkEventKey* event);
static gboolean page_real_on_alt_released (Page* self,
                                    GdkEventKey* event);
static gboolean page_real_on_shift_pressed (Page* self,
                                     GdkEventKey* event);
static gboolean page_real_on_shift_released (Page* self,
                                      GdkEventKey* event);
static gboolean page_real_on_super_pressed (Page* self,
                                     GdkEventKey* event);
static gboolean page_real_on_super_released (Page* self,
                                      GdkEventKey* event);
static gboolean page_real_on_app_key_pressed (Page* self,
                                       GdkEventKey* event);
static gboolean page_real_on_app_key_released (Page* self,
                                        GdkEventKey* event);
static void page_real_on_move (Page* self,
                        GdkRectangle* rect);
static void page_real_on_move_start (Page* self,
                              GdkRectangle* rect);
static void page_real_on_move_finished (Page* self,
                                 GdkRectangle* rect);
static void page_real_on_resize (Page* self,
                          GdkRectangle* rect);
static void page_real_on_resize_start (Page* self,
                                GdkRectangle* rect);
static void page_real_on_resize_finished (Page* self,
                                   GdkRectangle* rect);
static gboolean page_real_on_configure (Page* self,
                                 GdkEventConfigure* event,
                                 GdkRectangle* rect);
static gboolean page_check_configure_halted (Page* self);
static gboolean _page_check_configure_halted_gsource_func (gpointer self);
static gboolean page_real_on_motion (Page* self,
                              GdkEventMotion* event,
                              gint x,
                              gint y,
                              GdkModifierType mask);
static void page_check_cursor_hiding (Page* self);
static gboolean page_real_on_leave_notify_event (Page* self);
static gboolean page_real_on_mousewheel_up (Page* self,
                                     GdkEventScroll* event);
static gboolean page_real_on_mousewheel_down (Page* self,
                                       GdkEventScroll* event);
static gboolean page_real_on_mousewheel_left (Page* self,
                                       GdkEventScroll* event);
static gboolean page_real_on_mousewheel_right (Page* self,
                                        GdkEventScroll* event);
static gboolean page_real_on_context_keypress (Page* self);
static gboolean page_real_on_context_buttonpress (Page* self,
                                           GdkEventButton* event);
static gboolean page_real_on_context_invoked (Page* self);
static void page_real_set_page_cursor (Page* self,
                                GdkCursorType cursor_type);
static gboolean page_on_hide_cursor (Page* self);
static gboolean _page_on_hide_cursor_gsource_func (gpointer self);
static GObject * page_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties);
static gboolean _page_on_context_keypress_gtk_widget_popup_menu (GtkWidget* _sender,
                                                          gpointer self);
static void _page_attach_view_signals_gtk_widget_realize (GtkWidget* _sender,
                                                   gpointer self);
static void page_finalize (GObject * obj);
static GType page_get_type_once (void);
static void _vala_page_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_page_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
page_get_instance_private (Page* self)
{
	return G_STRUCT_MEMBER_P (self, Page_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

Page*
page_construct (GType object_type,
                const gchar* page_name)
{
	Page * self = NULL;
	g_return_val_if_fail (page_name != NULL, NULL);
	self = (Page*) g_object_new (object_type, "page-name", page_name, NULL);
	return self;
}

static void
_vala_array_add211 (GFile** * array,
                    gint* length,
                    gint* size,
                    GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda47_ (Page* self,
             GtkWidget* item)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (item != NULL);
	if (item != NULL) {
		_tmp0_ = IS_CONTRACT_MENU_ITEM (item);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_widget_destroy (item);
	}
}

static void
___lambda47__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda47_ ((Page*) self, (GtkWidget*) data);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
page_populate_contractor_menu (Page* self,
                               GtkMenu* menu)
{
	GFile** files = NULL;
	GFile** _tmp0_;
	gint files_length1;
	gint _files_size_;
	GeeList* contracts = NULL;
	GList* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = g_new0 (GFile*, 0 + 1);
	files = _tmp0_;
	files_length1 = 0;
	_files_size_ = files_length1;
	contracts = NULL;
	{
		GeeList* selected = NULL;
		ViewCollection* _tmp1_;
		ViewCollection* _tmp2_;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		GeeList* _tmp15_ = NULL;
		GFile** _tmp16_;
		gint _tmp16__length1;
		GeeList* _tmp17_;
		GeeList* _tmp18_;
		_tmp1_ = page_get_view (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = view_collection_get_selected_sources (_tmp2_);
		_tmp4_ = _tmp3_;
		_data_collection_unref0 (_tmp2_);
		selected = _tmp4_;
		{
			GeeList* _item_list = NULL;
			GeeList* _tmp5_;
			gint _item_size = 0;
			GeeList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _item_index = 0;
			_tmp5_ = selected;
			_item_list = _tmp5_;
			_tmp6_ = _item_list;
			_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_item_size = _tmp8_;
			_item_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				DataSource* item = NULL;
				GeeList* _tmp11_;
				gpointer _tmp12_;
				DataSource* _tmp13_;
				GFile* _tmp14_;
				_item_index = _item_index + 1;
				_tmp9_ = _item_index;
				_tmp10_ = _item_size;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = _item_list;
				_tmp12_ = gee_list_get (_tmp11_, _item_index);
				item = (DataSource*) _tmp12_;
				_tmp13_ = item;
				_tmp14_ = media_source_get_file ((MediaSource*) G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_PHOTO, Photo));
				_vala_array_add211 (&files, &files_length1, &_files_size_, _tmp14_);
				_g_object_unref0 (item);
			}
		}
		_tmp16_ = files;
		_tmp16__length1 = files_length1;
		_tmp17_ = granite_services_contractor_proxy_get_contracts_for_files (_tmp16_, (gint) _tmp16__length1, &_inner_error0_);
		_tmp15_ = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (selected);
			goto __catch0_g_error;
		}
		_tmp18_ = _tmp15_;
		_tmp15_ = NULL;
		_g_object_unref0 (contracts);
		contracts = _tmp18_;
		_g_object_unref0 (_tmp15_);
		_g_object_unref0 (selected);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_warning ("Page.vala:111: %s", _tmp20_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (contracts);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp21_ = self->priv->contractor_menu_items;
	g_list_foreach (_tmp21_, ___lambda47__gfunc, self);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				GeeList* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				GraniteServicesContract* contract = NULL;
				GeeList* _tmp27_;
				gpointer _tmp28_;
				GtkMenuItem* menu_item = NULL;
				GraniteServicesContract* _tmp29_;
				ViewCollection* _tmp30_;
				ViewCollection* _tmp31_;
				GeeList* _tmp32_;
				GeeList* _tmp33_;
				ContractMenuItem* _tmp34_;
				GtkMenuItem* _tmp35_;
				GtkMenuItem* _tmp36_;
				GtkWidget* _tmp37_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp24_ = contracts;
				_tmp25_ = gee_collection_get_size ((GeeCollection*) _tmp24_);
				_tmp26_ = _tmp25_;
				if (!(i < _tmp26_)) {
					break;
				}
				_tmp27_ = contracts;
				_tmp28_ = gee_list_get (_tmp27_, i);
				contract = (GraniteServicesContract*) _tmp28_;
				_tmp29_ = contract;
				_tmp30_ = page_get_view (self);
				_tmp31_ = _tmp30_;
				_tmp32_ = view_collection_get_selected_sources (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = contract_menu_item_new (_tmp29_, _tmp33_);
				g_object_ref_sink (_tmp34_);
				_g_object_unref0 (menu_item);
				menu_item = (GtkMenuItem*) _tmp34_;
				_g_object_unref0 (_tmp33_);
				_data_collection_unref0 (_tmp31_);
				_tmp35_ = menu_item;
				gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp35_);
				_tmp36_ = menu_item;
				_tmp37_ = _g_object_ref0 ((GtkWidget*) _tmp36_);
				self->priv->contractor_menu_items = g_list_append (self->priv->contractor_menu_items, _tmp37_);
				_g_object_unref0 (menu_item);
				_g_object_unref0 (contract);
			}
		}
	}
	gtk_widget_show_all ((GtkWidget*) menu);
	_g_object_unref0 (contracts);
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
}

static void
page_real_destroy (GtkWidget* base)
{
	Page * self;
	ViewCollection* _tmp0_;
	GtkActionBar* _tmp1_;
	OneShotScheduler* _tmp3_;
	const gchar* _tmp5_;
	self = (Page*) base;
	if (self->priv->is_destroyed) {
		return;
	}
	page_detach_event_source (self);
	page_detach_view_signals (self);
	_tmp0_ = self->priv->view;
	data_collection_close ((DataCollection*) _tmp0_);
	page_clear_container (self);
	_tmp1_ = self->toolbar;
	if (_tmp1_ != NULL) {
		GtkActionBar* _tmp2_;
		_tmp2_ = self->toolbar;
		gtk_widget_destroy ((GtkWidget*) _tmp2_);
	}
	_tmp3_ = self->priv->update_actions_scheduler;
	if (_tmp3_ != NULL) {
		OneShotScheduler* _tmp4_;
		_tmp4_ = self->priv->update_actions_scheduler;
		one_shot_scheduler_cancel (_tmp4_);
	}
	self->priv->is_destroyed = TRUE;
	GTK_WIDGET_CLASS (page_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp5_ = self->priv->_page_name;
	g_debug ("Page.vala:156: Page %s Destroyed", _tmp5_);
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

ViewCollection*
page_get_view (Page* self)
{
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	ViewCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = _data_collection_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GtkWindow*
page_get_container (Page* self)
{
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->container;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
page_real_set_container (Page* self,
                         GtkWindow* container)
{
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	g_return_if_fail (container != NULL);
	_tmp0_ = self->priv->container;
	_vala_assert (_tmp0_ == NULL, "this.container == null");
	_tmp1_ = _g_object_ref0 (container);
	_g_object_unref0 (self->priv->container);
	self->priv->container = _tmp1_;
}

void
page_set_container (Page* self,
                    GtkWindow* container)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->set_container) {
		_klass_->set_container (self, container);
	}
}

static void
page_real_clear_container (Page* self)
{
	_g_object_unref0 (self->priv->container);
	self->priv->container = NULL;
}

void
page_clear_container (Page* self)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->clear_container) {
		_klass_->clear_container (self);
	}
}

static gboolean
_page_on_button_pressed_internal_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                GdkEventButton* event,
                                                                gpointer self)
{
	gboolean result;
	result = page_on_button_pressed_internal ((Page*) self, event);
	return result;
}

static gboolean
_page_on_button_released_internal_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                   GdkEventButton* event,
                                                                   gpointer self)
{
	gboolean result;
	result = page_on_button_released_internal ((Page*) self, event);
	return result;
}

static gboolean
_page_on_motion_internal_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                         GdkEventMotion* event,
                                                         gpointer self)
{
	gboolean result;
	result = page_on_motion_internal ((Page*) self, event);
	return result;
}

static gboolean
_page_on_leave_notify_event_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                           GdkEventCrossing* event,
                                                           gpointer self)
{
	gboolean result;
	result = page_on_leave_notify_event ((Page*) self);
	return result;
}

static gboolean
_page_on_mousewheel_internal_gtk_widget_scroll_event (GtkWidget* _sender,
                                                      GdkEventScroll* event,
                                                      gpointer self)
{
	gboolean result;
	result = page_on_mousewheel_internal ((Page*) self, event);
	return result;
}

static void
_page_on_event_source_realize_gtk_widget_realize (GtkWidget* _sender,
                                                  gpointer self)
{
	page_on_event_source_realize ((Page*) self);
}

void
page_set_event_source (Page* self,
                       GtkWidget* event_source)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event_source != NULL);
	_tmp0_ = self->priv->event_source;
	_vala_assert (_tmp0_ == NULL, "this.event_source == null");
	_tmp1_ = _g_object_ref0 (event_source);
	_g_object_unref0 (self->priv->event_source);
	self->priv->event_source = _tmp1_;
	gtk_widget_set_can_focus (event_source, TRUE);
	gtk_widget_add_events (event_source, (gint) (((((((GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK) | GDK_POINTER_MOTION_MASK) | GDK_POINTER_MOTION_HINT_MASK) | GDK_BUTTON_MOTION_MASK) | GDK_LEAVE_NOTIFY_MASK) | GDK_SCROLL_MASK) | GDK_SMOOTH_SCROLL_MASK));
	g_signal_connect_object (event_source, "button-press-event", (GCallback) _page_on_button_pressed_internal_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object (event_source, "button-release-event", (GCallback) _page_on_button_released_internal_gtk_widget_button_release_event, self, 0);
	g_signal_connect_object (event_source, "motion-notify-event", (GCallback) _page_on_motion_internal_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object (event_source, "leave-notify-event", (GCallback) _page_on_leave_notify_event_gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object (event_source, "scroll-event", (GCallback) _page_on_mousewheel_internal_gtk_widget_scroll_event, self, 0);
	g_signal_connect_object (event_source, "realize", (GCallback) _page_on_event_source_realize_gtk_widget_realize, self, 0);
}

static void
page_detach_event_source (Page* self)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	guint _tmp2_;
	GtkWidget* _tmp3_;
	guint _tmp4_;
	GtkWidget* _tmp5_;
	guint _tmp6_;
	GtkWidget* _tmp7_;
	guint _tmp8_;
	GtkWidget* _tmp9_;
	guint _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->event_source;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->event_source;
	g_signal_parse_name ("button-press-event", gtk_widget_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _page_on_button_pressed_internal_gtk_widget_button_press_event, self);
	_tmp3_ = self->priv->event_source;
	g_signal_parse_name ("button-release-event", gtk_widget_get_type (), &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _page_on_button_released_internal_gtk_widget_button_release_event, self);
	_tmp5_ = self->priv->event_source;
	g_signal_parse_name ("motion-notify-event", gtk_widget_get_type (), &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _page_on_motion_internal_gtk_widget_motion_notify_event, self);
	_tmp7_ = self->priv->event_source;
	g_signal_parse_name ("leave-notify-event", gtk_widget_get_type (), &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _page_on_leave_notify_event_gtk_widget_leave_notify_event, self);
	_tmp9_ = self->priv->event_source;
	g_signal_parse_name ("scroll-event", gtk_widget_get_type (), &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _page_on_mousewheel_internal_gtk_widget_scroll_event, self);
	_g_object_unref0 (self->priv->event_source);
	self->priv->event_source = NULL;
}

GtkWidget*
page_get_event_source (Page* self)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->event_source;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GtkActionBar*
page_get_toolbar (Page* self,
                  GtkWidget* add_widget,
                  GtkPackType position)
{
	GtkActionBar* _tmp0_;
	GtkActionBar* _tmp11_;
	GtkActionBar* _tmp12_;
	GtkActionBar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->toolbar;
	if (_tmp0_ == NULL) {
		GtkActionBar* _tmp1_;
		GtkActionBar* _tmp2_;
		GtkStyleContext* _tmp3_;
		GtkActionBar* _tmp4_;
		GtkActionBar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		GtkActionBar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp1_ = (GtkActionBar*) gtk_action_bar_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->toolbar);
		self->toolbar = _tmp1_;
		_tmp2_ = self->toolbar;
		_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
		gtk_style_context_add_class (_tmp3_, "bottom-toolbar");
		_tmp4_ = self->toolbar;
		gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_END);
		_tmp5_ = self->toolbar;
		gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_FILL);
		if (add_widget != NULL) {
			_tmp6_ = position == GTK_PACK_START;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GtkActionBar* _tmp7_;
			_tmp7_ = self->toolbar;
			gtk_action_bar_pack_start (_tmp7_, add_widget);
		}
		_tmp8_ = self->toolbar;
		page_add_toolbar_widgets (self, _tmp8_);
		if (add_widget != NULL) {
			_tmp9_ = position == GTK_PACK_END;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GtkActionBar* _tmp10_;
			_tmp10_ = self->toolbar;
			gtk_action_bar_pack_end (_tmp10_, add_widget);
		}
		gtk_widget_show_all ((GtkWidget*) self);
	}
	_tmp11_ = self->toolbar;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	result = _tmp12_;
	return result;
}

static void
page_real_add_toolbar_widgets (Page* self,
                               GtkActionBar* toolbar)
{
	g_return_if_fail (toolbar != NULL);
}

void
page_add_toolbar_widgets (Page* self,
                          GtkActionBar* toolbar)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->add_toolbar_widgets) {
		_klass_->add_toolbar_widgets (self, toolbar);
	}
}

static GtkMenu*
page_real_get_page_context_menu (Page* self)
{
	GtkMenu* result;
	result = NULL;
	return result;
}

GtkMenu*
page_get_page_context_menu (Page* self)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->get_page_context_menu) {
		return _klass_->get_page_context_menu (self);
	}
	return NULL;
}

static GtkMenu*
page_real_get_page_sidebar_menu (Page* self)
{
	GtkMenu* result;
	result = NULL;
	return result;
}

GtkMenu*
page_get_page_sidebar_menu (Page* self)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->get_page_sidebar_menu) {
		return _klass_->get_page_sidebar_menu (self);
	}
	return NULL;
}

static void
page_real_switching_from (Page* self)
{
	page_set_in_view (self, FALSE);
	_g_object_unref0 (self->toolbar);
	self->toolbar = NULL;
}

void
page_switching_from (Page* self)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->switching_from) {
		_klass_->switching_from (self);
	}
}

static void
page_real_switched_to (Page* self)
{
	page_set_in_view (self, TRUE);
	page_update_modifiers (self);
}

void
page_switched_to (Page* self)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->switched_to) {
		_klass_->switched_to (self);
	}
}

static void
page_real_ready (Page* self)
{
}

void
page_ready (Page* self)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->ready) {
		_klass_->ready (self);
	}
}

static void
page_real_switching_to_fullscreen (Page* self,
                                   FullscreenWindow* fsw)
{
	g_return_if_fail (fsw != NULL);
}

void
page_switching_to_fullscreen (Page* self,
                              FullscreenWindow* fsw)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->switching_to_fullscreen) {
		_klass_->switching_to_fullscreen (self, fsw);
	}
}

static void
page_real_returning_from_fullscreen (Page* self,
                                     FullscreenWindow* fsw)
{
	g_return_if_fail (fsw != NULL);
}

void
page_returning_from_fullscreen (Page* self,
                                FullscreenWindow* fsw)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->returning_from_fullscreen) {
		_klass_->returning_from_fullscreen (self, fsw);
	}
}

GtkAction*
page_get_action (Page* self,
                 const gchar* name)
{
	GtkActionGroup* _tmp0_;
	GtkAction* action = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkAction* _tmp3_;
	GtkAction* _tmp4_;
	GtkAction* _tmp6_;
	GtkAction* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->action_group;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->action_group;
	_tmp2_ = gtk_action_group_get_action (_tmp1_, name);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	action = _tmp3_;
	_tmp4_ = action;
	if (_tmp4_ == NULL) {
		GtkAction* _tmp5_;
		_tmp5_ = page_get_common_action (self, name, FALSE);
		_g_object_unref0 (action);
		action = _tmp5_;
	}
	_tmp6_ = action;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_;
		_tmp7_ = self->priv->_page_name;
		g_warning ("Page.vala:280: Page %s: Unable to locate action %s", _tmp7_, name);
	}
	result = action;
	return result;
}

void
page_set_action_sensitive (Page* self,
                           const gchar* name,
                           gboolean sensitive)
{
	GtkAction* action = NULL;
	GtkAction* _tmp0_;
	GtkAction* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = page_get_action (self, name);
	action = _tmp0_;
	_tmp1_ = action;
	if (_tmp1_ != NULL) {
		GtkAction* _tmp2_;
		_tmp2_ = action;
		gtk_action_set_sensitive (_tmp2_, sensitive);
	}
	_g_object_unref0 (action);
}

void
page_set_action_visible (Page* self,
                         const gchar* name,
                         gboolean visible)
{
	GtkAction* action = NULL;
	GtkAction* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	GtkAction* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = page_get_action (self, name);
	action = _tmp0_;
	_tmp1_ = action;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (action);
		return;
	}
	_tmp2_ = action;
	gtk_action_set_visible (_tmp2_, visible);
	_tmp3_ = action;
	gtk_action_set_sensitive (_tmp3_, visible);
	_g_object_unref0 (action);
}

void
page_activate_action (Page* self,
                      const gchar* name)
{
	GtkAction* action = NULL;
	GtkAction* _tmp0_;
	GtkAction* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = page_get_action (self, name);
	action = _tmp0_;
	_tmp1_ = action;
	if (_tmp1_ != NULL) {
		GtkAction* _tmp2_;
		_tmp2_ = action;
		gtk_action_activate (_tmp2_);
	}
	_g_object_unref0 (action);
}

GtkAction*
page_get_common_action (Page* self,
                        const gchar* name,
                        gboolean log_warning)
{
	GtkActionGroup** _tmp0_;
	gint _tmp0__length1;
	GtkActionGroup** _tmp1_;
	gint _tmp1__length1;
	GtkAction* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->common_action_groups;
	_tmp0__length1 = self->priv->common_action_groups_length1;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->common_action_groups;
	_tmp1__length1 = self->priv->common_action_groups_length1;
	{
		GtkActionGroup** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp1_;
		group_collection_length1 = _tmp1__length1;
		for (group_it = 0; group_it < group_collection_length1; group_it = group_it + 1) {
			GtkActionGroup* _tmp2_;
			GtkActionGroup* group = NULL;
			_tmp2_ = _g_object_ref0 (group_collection[group_it]);
			group = _tmp2_;
			{
				GtkAction* action = NULL;
				GtkActionGroup* _tmp3_;
				GtkAction* _tmp4_;
				GtkAction* _tmp5_;
				GtkAction* _tmp6_;
				_tmp3_ = group;
				_tmp4_ = gtk_action_group_get_action (_tmp3_, name);
				_tmp5_ = _g_object_ref0 (_tmp4_);
				action = _tmp5_;
				_tmp6_ = action;
				if (_tmp6_ != NULL) {
					result = action;
					_g_object_unref0 (group);
					return result;
				}
				_g_object_unref0 (action);
				_g_object_unref0 (group);
			}
		}
	}
	if (log_warning) {
		const gchar* _tmp7_;
		_tmp7_ = self->priv->_page_name;
		g_warning ("Page.vala:317: Page %s: Unable to locate common action %s", _tmp7_, name);
	}
	result = NULL;
	return result;
}

void
page_update_sidebar_action (Page* self,
                            gboolean show)
{
	GtkButton* _tmp0_;
	LibraryWindow* app = NULL;
	AppWindow* _tmp9_;
	LibraryWindow* _tmp10_;
	LibraryWindow* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->show_sidebar_button;
	if (_tmp0_ == NULL) {
		return;
	}
	if (!show) {
		GtkButton* _tmp1_;
		GtkImage* _tmp2_;
		GtkImage* _tmp3_;
		GtkButton* _tmp4_;
		_tmp1_ = self->show_sidebar_button;
		_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name (RESOURCES_HIDE_PANE, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
		g_object_ref_sink (_tmp2_);
		_tmp3_ = _tmp2_;
		gtk_button_set_image (_tmp1_, (GtkWidget*) _tmp3_);
		_g_object_unref0 (_tmp3_);
		_tmp4_ = self->show_sidebar_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp4_, RESOURCES_UNTOGGLE_METAPANE_TOOLTIP);
	} else {
		GtkButton* _tmp5_;
		GtkImage* _tmp6_;
		GtkImage* _tmp7_;
		GtkButton* _tmp8_;
		_tmp5_ = self->show_sidebar_button;
		_tmp6_ = (GtkImage*) gtk_image_new_from_icon_name (RESOURCES_SHOW_PANE, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
		g_object_ref_sink (_tmp6_);
		_tmp7_ = _tmp6_;
		gtk_button_set_image (_tmp5_, (GtkWidget*) _tmp7_);
		_g_object_unref0 (_tmp7_);
		_tmp8_ = self->show_sidebar_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp8_, RESOURCES_TOGGLE_METAPANE_TOOLTIP);
	}
	_tmp9_ = app_window_get_instance ();
	_tmp10_ = IS_LIBRARY_WINDOW (_tmp9_) ? ((LibraryWindow*) _tmp9_) : NULL;
	if (_tmp10_ == NULL) {
		_g_object_unref0 (_tmp9_);
	}
	app = _tmp10_;
	_tmp11_ = app;
	library_window_update_common_toggle_actions (_tmp11_);
	_g_object_unref0 (app);
}

gboolean
page_get_ctrl_pressed (Page* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->ctrl_pressed;
	return result;
}

gboolean
page_get_alt_pressed (Page* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->alt_pressed;
	return result;
}

gboolean
page_get_shift_pressed (Page* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->shift_pressed;
	return result;
}

gboolean
page_get_super_pressed (Page* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->super_pressed;
	return result;
}

static gboolean
page_get_modifiers (Page* self,
                    gboolean* ctrl,
                    gboolean* alt,
                    gboolean* shift,
                    gboolean* super)
{
	gboolean _vala_ctrl = FALSE;
	gboolean _vala_alt = FALSE;
	gboolean _vala_shift = FALSE;
	gboolean _vala_super = FALSE;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	GdkWindow* _tmp2_;
	gboolean _tmp3_;
	gint x = 0;
	gint y = 0;
	GdkModifierType mask = 0U;
	GdkSeat* seat = NULL;
	GdkDisplay* _tmp4_;
	GdkSeat* _tmp5_;
	GdkSeat* _tmp6_;
	AppWindow* _tmp7_;
	AppWindow* _tmp8_;
	GdkWindow* _tmp9_;
	GdkSeat* _tmp10_;
	GdkDevice* _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GdkModifierType _tmp14_ = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) _tmp1_);
	_tmp3_ = _tmp2_ == NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp3_) {
		_vala_ctrl = FALSE;
		_vala_alt = FALSE;
		_vala_shift = FALSE;
		_vala_super = FALSE;
		result = FALSE;
		if (ctrl) {
			*ctrl = _vala_ctrl;
		}
		if (alt) {
			*alt = _vala_alt;
		}
		if (shift) {
			*shift = _vala_shift;
		}
		if (super) {
			*super = _vala_super;
		}
		return result;
	}
	_tmp4_ = gdk_display_get_default ();
	_tmp5_ = gdk_display_get_default_seat (_tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	seat = _tmp6_;
	_tmp7_ = app_window_get_instance ();
	_tmp8_ = _tmp7_;
	_tmp9_ = gtk_widget_get_window ((GtkWidget*) _tmp8_);
	_tmp10_ = seat;
	_tmp11_ = gdk_seat_get_pointer (_tmp10_);
	gdk_window_get_device_position (_tmp9_, _tmp11_, &_tmp12_, &_tmp13_, &_tmp14_);
	x = _tmp12_;
	y = _tmp13_;
	mask = _tmp14_;
	_g_object_unref0 (_tmp8_);
	_vala_ctrl = (mask & GDK_CONTROL_MASK) != 0;
	_vala_alt = (mask & GDK_MOD1_MASK) != 0;
	_vala_shift = (mask & GDK_SHIFT_MASK) != 0;
	_vala_super = (mask & GDK_MOD4_MASK) != 0;
	result = TRUE;
	_g_object_unref0 (seat);
	if (ctrl) {
		*ctrl = _vala_ctrl;
	}
	if (alt) {
		*alt = _vala_alt;
	}
	if (shift) {
		*shift = _vala_shift;
	}
	if (super) {
		*super = _vala_super;
	}
	return result;
}

static void
page_update_modifiers (Page* self)
{
	gboolean ctrl_currently_pressed = FALSE;
	gboolean alt_currently_pressed = FALSE;
	gboolean shift_currently_pressed = FALSE;
	gboolean super_currently_pressed = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp4_ = page_get_modifiers (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	ctrl_currently_pressed = _tmp0_;
	alt_currently_pressed = _tmp1_;
	shift_currently_pressed = _tmp2_;
	super_currently_pressed = _tmp3_;
	if (!_tmp4_) {
		return;
	}
	if (self->priv->ctrl_pressed) {
		_tmp5_ = !ctrl_currently_pressed;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		page_on_ctrl_released (self, NULL);
	} else {
		gboolean _tmp6_ = FALSE;
		if (!self->priv->ctrl_pressed) {
			_tmp6_ = ctrl_currently_pressed;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			page_on_ctrl_pressed (self, NULL);
		}
	}
	if (self->priv->alt_pressed) {
		_tmp7_ = !alt_currently_pressed;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		page_on_alt_released (self, NULL);
	} else {
		gboolean _tmp8_ = FALSE;
		if (!self->priv->alt_pressed) {
			_tmp8_ = alt_currently_pressed;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			page_on_alt_pressed (self, NULL);
		}
	}
	if (self->priv->shift_pressed) {
		_tmp9_ = !shift_currently_pressed;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		page_on_shift_released (self, NULL);
	} else {
		gboolean _tmp10_ = FALSE;
		if (!self->priv->shift_pressed) {
			_tmp10_ = shift_currently_pressed;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			page_on_shift_pressed (self, NULL);
		}
	}
	if (self->priv->super_pressed) {
		_tmp11_ = !super_currently_pressed;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		page_on_super_released (self, NULL);
	} else {
		gboolean _tmp12_ = FALSE;
		if (!self->priv->super_pressed) {
			_tmp12_ = super_currently_pressed;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			page_on_super_pressed (self, NULL);
		}
	}
	self->priv->ctrl_pressed = ctrl_currently_pressed;
	self->priv->alt_pressed = alt_currently_pressed;
	self->priv->shift_pressed = shift_currently_pressed;
	self->priv->super_pressed = super_currently_pressed;
}

CommandManager*
page_get_command_manager (Page* self)
{
	CommandManager* _tmp0_;
	CommandManager* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = app_window_get_command_manager ();
	result = _tmp0_;
	return result;
}

static GtkBox*
page_real_get_header_buttons (Page* self)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* result;
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->header_box);
	self->header_box = _tmp0_;
	_tmp1_ = self->header_box;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

GtkBox*
page_get_header_buttons (Page* self)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->get_header_buttons) {
		return _klass_->get_header_buttons (self);
	}
	return NULL;
}

static void
_page_on_update_actions_view_collection_items_state_changed (ViewCollection* _sender,
                                                             GeeIterable* changed,
                                                             gpointer self)
{
	page_on_update_actions ((Page*) self);
}

static void
_page_on_update_actions_view_collection_selection_group_altered (ViewCollection* _sender,
                                                                 gpointer self)
{
	page_on_update_actions ((Page*) self);
}

static void
_page_on_update_actions_view_collection_items_visibility_changed (ViewCollection* _sender,
                                                                  GeeCollection* changed,
                                                                  gpointer self)
{
	page_on_update_actions ((Page*) self);
}

static void
_page_on_update_actions_data_collection_contents_altered (DataCollection* _sender,
                                                          GeeIterable* added,
                                                          GeeIterable* removed,
                                                          gpointer self)
{
	page_on_update_actions ((Page*) self);
}

static void
page_attach_view_signals (Page* self)
{
	gint selected_count = 0;
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	gint _tmp2_;
	gint count = 0;
	ViewCollection* _tmp3_;
	ViewCollection* _tmp4_;
	gint _tmp5_;
	ViewCollection* _tmp6_;
	ViewCollection* _tmp7_;
	ViewCollection* _tmp8_;
	ViewCollection* _tmp9_;
	ViewCollection* _tmp10_;
	ViewCollection* _tmp11_;
	ViewCollection* _tmp12_;
	ViewCollection* _tmp13_;
	g_return_if_fail (self != NULL);
	if (self->priv->are_actions_attached) {
		return;
	}
	_tmp0_ = page_get_view (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = view_collection_get_selected_count (_tmp1_);
	_data_collection_unref0 (_tmp1_);
	selected_count = _tmp2_;
	_tmp3_ = page_get_view (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = data_collection_get_count ((DataCollection*) _tmp4_);
	_data_collection_unref0 (_tmp4_);
	count = _tmp5_;
	page_init_actions (self, selected_count, count);
	page_update_actions (self, selected_count, count);
	_tmp6_ = page_get_view (self);
	_tmp7_ = _tmp6_;
	g_signal_connect_object (_tmp7_, "items-state-changed", (GCallback) _page_on_update_actions_view_collection_items_state_changed, self, 0);
	_data_collection_unref0 (_tmp7_);
	_tmp8_ = page_get_view (self);
	_tmp9_ = _tmp8_;
	g_signal_connect_object (_tmp9_, "selection-group-altered", (GCallback) _page_on_update_actions_view_collection_selection_group_altered, self, 0);
	_data_collection_unref0 (_tmp9_);
	_tmp10_ = page_get_view (self);
	_tmp11_ = _tmp10_;
	g_signal_connect_object (_tmp11_, "items-visibility-changed", (GCallback) _page_on_update_actions_view_collection_items_visibility_changed, self, 0);
	_data_collection_unref0 (_tmp11_);
	_tmp12_ = page_get_view (self);
	_tmp13_ = _tmp12_;
	g_signal_connect_object ((DataCollection*) _tmp13_, "contents-altered", (GCallback) _page_on_update_actions_data_collection_contents_altered, self, 0);
	_data_collection_unref0 (_tmp13_);
	self->priv->are_actions_attached = TRUE;
}

static void
page_detach_view_signals (Page* self)
{
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	guint _tmp2_;
	ViewCollection* _tmp3_;
	ViewCollection* _tmp4_;
	guint _tmp5_;
	ViewCollection* _tmp6_;
	ViewCollection* _tmp7_;
	guint _tmp8_;
	ViewCollection* _tmp9_;
	ViewCollection* _tmp10_;
	guint _tmp11_;
	g_return_if_fail (self != NULL);
	if (!self->priv->are_actions_attached) {
		return;
	}
	_tmp0_ = page_get_view (self);
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("items-state-changed", TYPE_VIEW_COLLECTION, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _page_on_update_actions_view_collection_items_state_changed, self);
	_data_collection_unref0 (_tmp1_);
	_tmp3_ = page_get_view (self);
	_tmp4_ = _tmp3_;
	g_signal_parse_name ("selection-group-altered", TYPE_VIEW_COLLECTION, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _page_on_update_actions_view_collection_selection_group_altered, self);
	_data_collection_unref0 (_tmp4_);
	_tmp6_ = page_get_view (self);
	_tmp7_ = _tmp6_;
	g_signal_parse_name ("items-visibility-changed", TYPE_VIEW_COLLECTION, &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _page_on_update_actions_view_collection_items_visibility_changed, self);
	_data_collection_unref0 (_tmp7_);
	_tmp9_ = page_get_view (self);
	_tmp10_ = _tmp9_;
	g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp11_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _page_on_update_actions_data_collection_contents_altered, self);
	_data_collection_unref0 (_tmp10_);
	self->priv->are_actions_attached = FALSE;
}

static void
_page_on_update_actions_on_idle_one_shot_callback (gpointer self)
{
	page_on_update_actions_on_idle ((Page*) self);
}

static void
page_on_update_actions (Page* self)
{
	OneShotScheduler* _tmp0_;
	OneShotScheduler* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->update_actions_scheduler;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		OneShotScheduler* _tmp4_;
		_tmp1_ = self->priv->_page_name;
		_tmp2_ = g_strdup_printf ("Update actions scheduler for %s", _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = one_shot_scheduler_new (_tmp3_, _page_on_update_actions_on_idle_one_shot_callback, self);
		_one_shot_scheduler_unref0 (self->priv->update_actions_scheduler);
		self->priv->update_actions_scheduler = _tmp4_;
		_g_free0 (_tmp3_);
	}
	_tmp5_ = self->priv->update_actions_scheduler;
	one_shot_scheduler_at_priority_idle (_tmp5_, G_PRIORITY_LOW);
}

static void
page_on_update_actions_on_idle (Page* self)
{
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	ViewCollection* _tmp2_;
	ViewCollection* _tmp3_;
	g_return_if_fail (self != NULL);
	if (self->priv->is_destroyed) {
		return;
	}
	_tmp0_ = page_get_view (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = page_get_view (self);
	_tmp3_ = _tmp2_;
	page_update_actions (self, view_collection_get_selected_count (_tmp1_), data_collection_get_count ((DataCollection*) _tmp3_));
	_data_collection_unref0 (_tmp3_);
	_data_collection_unref0 (_tmp1_);
}

static GtkActionEntry*
page_real_init_collect_action_entries (Page* self,
                                       gint* result_length1)
{
	GtkActionEntry* _tmp0_;
	GtkActionEntry* _tmp1_;
	gint _tmp1__length1;
	GtkActionEntry* result;
	_tmp0_ = g_new0 (GtkActionEntry, 0);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

GtkActionEntry*
page_init_collect_action_entries (Page* self,
                                  gint* result_length1)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->init_collect_action_entries) {
		return _klass_->init_collect_action_entries (self, result_length1);
	}
	return NULL;
}

static GtkToggleActionEntry*
page_real_init_collect_toggle_action_entries (Page* self,
                                              gint* result_length1)
{
	GtkToggleActionEntry* _tmp0_;
	GtkToggleActionEntry* _tmp1_;
	gint _tmp1__length1;
	GtkToggleActionEntry* result;
	_tmp0_ = g_new0 (GtkToggleActionEntry, 0);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

GtkToggleActionEntry*
page_init_collect_toggle_action_entries (Page* self,
                                         gint* result_length1)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->init_collect_toggle_action_entries) {
		return _klass_->init_collect_toggle_action_entries (self, result_length1);
	}
	return NULL;
}

static void
page_real_register_radio_actions (Page* self,
                                  GtkActionGroup* action_group)
{
	g_return_if_fail (action_group != NULL);
}

void
page_register_radio_actions (Page* self,
                             GtkActionGroup* action_group)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->register_radio_actions) {
		_klass_->register_radio_actions (self, action_group);
	}
}

static void
page_real_init_actions (Page* self,
                        gint selected_count,
                        gint count)
{
}

void
page_init_actions (Page* self,
                   gint selected_count,
                   gint count)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->init_actions) {
		_klass_->init_actions (self, selected_count, count);
	}
}

static void
page_real_update_actions (Page* self,
                          gint selected_count,
                          gint count)
{
}

void
page_update_actions (Page* self,
                     gint selected_count,
                     gint count)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->update_actions) {
		_klass_->update_actions (self, selected_count, count);
	}
}

gboolean
page_get_event_source_pointer (Page* self,
                               gint* x,
                               gint* y,
                               GdkModifierType* mask)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	GdkModifierType _vala_mask = 0U;
	GtkWidget* _tmp0_;
	GdkSeat* seat = NULL;
	GdkDisplay* _tmp1_;
	GdkSeat* _tmp2_;
	GdkSeat* _tmp3_;
	GtkWidget* _tmp4_;
	GdkWindow* _tmp5_;
	GdkSeat* _tmp6_;
	GdkDevice* _tmp7_;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GdkModifierType _tmp10_ = 0U;
	gboolean _tmp11_ = FALSE;
	GdkPoint _tmp12_;
	GdkPoint _tmp14_;
	GdkPoint _tmp15_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->event_source;
	if (_tmp0_ == NULL) {
		_vala_x = 0;
		_vala_y = 0;
		_vala_mask = 0;
		result = FALSE;
		if (x) {
			*x = _vala_x;
		}
		if (y) {
			*y = _vala_y;
		}
		if (mask) {
			*mask = _vala_mask;
		}
		return result;
	}
	_tmp1_ = gdk_display_get_default ();
	_tmp2_ = gdk_display_get_default_seat (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	seat = _tmp3_;
	_tmp4_ = self->priv->event_source;
	_tmp5_ = gtk_widget_get_window (_tmp4_);
	_tmp6_ = seat;
	_tmp7_ = gdk_seat_get_pointer (_tmp6_);
	gdk_window_get_device_position (_tmp5_, _tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
	_vala_x = _tmp8_;
	_vala_y = _tmp9_;
	_vala_mask = _tmp10_;
	_tmp12_ = self->priv->last_down;
	if (_tmp12_.x < 0) {
		_tmp11_ = TRUE;
	} else {
		GdkPoint _tmp13_;
		_tmp13_ = self->priv->last_down;
		_tmp11_ = _tmp13_.y < 0;
	}
	if (_tmp11_) {
		result = TRUE;
		_g_object_unref0 (seat);
		if (x) {
			*x = _vala_x;
		}
		if (y) {
			*y = _vala_y;
		}
		if (mask) {
			*mask = _vala_mask;
		}
		return result;
	}
	_tmp14_ = self->priv->last_down;
	if (abs (_vala_x - _tmp14_.x) >= 0x7FFF) {
		_vala_x = _vala_x + 0xFFFF;
	}
	_tmp15_ = self->priv->last_down;
	if (abs (_vala_y - _tmp15_.y) >= 0x7FFF) {
		_vala_y = _vala_y + 0xFFFF;
	}
	result = TRUE;
	_g_object_unref0 (seat);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (mask) {
		*mask = _vala_mask;
	}
	return result;
}

static gboolean
page_real_on_left_click (Page* self,
                         GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
page_on_left_click (Page* self,
                    GdkEventButton* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_left_click) {
		return _klass_->on_left_click (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_middle_click (Page* self,
                           GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
page_on_middle_click (Page* self,
                      GdkEventButton* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_middle_click) {
		return _klass_->on_middle_click (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_right_click (Page* self,
                          GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
page_on_right_click (Page* self,
                     GdkEventButton* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_right_click) {
		return _klass_->on_right_click (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_left_released (Page* self,
                            GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
page_on_left_released (Page* self,
                       GdkEventButton* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_left_released) {
		return _klass_->on_left_released (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_middle_released (Page* self,
                              GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
page_on_middle_released (Page* self,
                         GdkEventButton* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_middle_released) {
		return _klass_->on_middle_released (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_right_released (Page* self,
                             GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
page_on_right_released (Page* self,
                        GdkEventButton* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_right_released) {
		return _klass_->on_right_released (self, event);
	}
	return FALSE;
}

static gboolean
page_on_button_pressed_internal (Page* self,
                                 GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	switch (event->button) {
		case 1:
		{
			GtkWidget* _tmp0_;
			_tmp0_ = self->priv->event_source;
			if (_tmp0_ != NULL) {
				GtkWidget* _tmp1_;
				_tmp1_ = self->priv->event_source;
				gtk_widget_grab_focus (_tmp1_);
			}
			self->priv->last_down.x = (gint) event->x;
			self->priv->last_down.y = (gint) event->y;
			result = page_on_left_click (self, event);
			return result;
		}
		case 2:
		{
			result = page_on_middle_click (self, event);
			return result;
		}
		case 3:
		{
			result = page_on_right_click (self, event);
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gboolean
page_on_button_released_internal (Page* self,
                                  GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	switch (event->button) {
		case 1:
		{
			GdkPoint _tmp0_ = {0};
			_tmp0_.x = -1;
			_tmp0_.y = -1;
			self->priv->last_down = _tmp0_;
			result = page_on_left_released (self, event);
			return result;
		}
		case 2:
		{
			result = page_on_middle_released (self, event);
			return result;
		}
		case 3:
		{
			result = page_on_right_released (self, event);
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gboolean
page_real_on_ctrl_pressed (Page* self,
                           GdkEventKey* event)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
page_on_ctrl_pressed (Page* self,
                      GdkEventKey* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_ctrl_pressed) {
		return _klass_->on_ctrl_pressed (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_ctrl_released (Page* self,
                            GdkEventKey* event)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
page_on_ctrl_released (Page* self,
                       GdkEventKey* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_ctrl_released) {
		return _klass_->on_ctrl_released (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_alt_pressed (Page* self,
                          GdkEventKey* event)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
page_on_alt_pressed (Page* self,
                     GdkEventKey* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_alt_pressed) {
		return _klass_->on_alt_pressed (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_alt_released (Page* self,
                           GdkEventKey* event)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
page_on_alt_released (Page* self,
                      GdkEventKey* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_alt_released) {
		return _klass_->on_alt_released (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_shift_pressed (Page* self,
                            GdkEventKey* event)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
page_on_shift_pressed (Page* self,
                       GdkEventKey* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_shift_pressed) {
		return _klass_->on_shift_pressed (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_shift_released (Page* self,
                             GdkEventKey* event)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
page_on_shift_released (Page* self,
                        GdkEventKey* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_shift_released) {
		return _klass_->on_shift_released (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_super_pressed (Page* self,
                            GdkEventKey* event)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
page_on_super_pressed (Page* self,
                       GdkEventKey* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_super_pressed) {
		return _klass_->on_super_pressed (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_super_released (Page* self,
                             GdkEventKey* event)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
page_on_super_released (Page* self,
                        GdkEventKey* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_super_released) {
		return _klass_->on_super_released (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_app_key_pressed (Page* self,
                              GdkEventKey* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
page_on_app_key_pressed (Page* self,
                         GdkEventKey* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_app_key_pressed) {
		return _klass_->on_app_key_pressed (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_app_key_released (Page* self,
                               GdkEventKey* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
page_on_app_key_released (Page* self,
                          GdkEventKey* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_app_key_released) {
		return _klass_->on_app_key_released (self, event);
	}
	return FALSE;
}

gboolean
page_notify_app_key_pressed (Page* self,
                             GdkEventKey* event)
{
	gboolean ctrl_currently_pressed = FALSE;
	gboolean alt_currently_pressed = FALSE;
	gboolean shift_currently_pressed = FALSE;
	gboolean super_currently_pressed = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	static GQuark _tmp6_label3 = 0;
	static GQuark _tmp6_label4 = 0;
	static GQuark _tmp6_label5 = 0;
	static GQuark _tmp6_label6 = 0;
	static GQuark _tmp6_label7 = 0;
	static GQuark _tmp6_label8 = 0;
	static GQuark _tmp6_label9 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	page_get_modifiers (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	ctrl_currently_pressed = _tmp0_;
	alt_currently_pressed = _tmp1_;
	shift_currently_pressed = _tmp2_;
	super_currently_pressed = _tmp3_;
	_tmp4_ = gdk_keyval_name (event->keyval);
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if ((_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("Control_L")))) || (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("Control_R"))))) {
		switch (0) {
			default:
			{
				gboolean _tmp8_ = FALSE;
				if (!ctrl_currently_pressed) {
					_tmp8_ = TRUE;
				} else {
					_tmp8_ = self->priv->ctrl_pressed;
				}
				if (_tmp8_) {
					result = FALSE;
					return result;
				}
				self->priv->ctrl_pressed = TRUE;
				result = page_on_ctrl_pressed (self, event);
				return result;
			}
		}
	} else if ((((_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("Meta_L")))) || (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("Meta_R"))))) || (_tmp7_ == ((0 != _tmp6_label4) ? _tmp6_label4 : (_tmp6_label4 = g_quark_from_static_string ("Alt_L"))))) || (_tmp7_ == ((0 != _tmp6_label5) ? _tmp6_label5 : (_tmp6_label5 = g_quark_from_static_string ("Alt_R"))))) {
		switch (0) {
			default:
			{
				gboolean _tmp9_ = FALSE;
				if (!alt_currently_pressed) {
					_tmp9_ = TRUE;
				} else {
					_tmp9_ = self->priv->alt_pressed;
				}
				if (_tmp9_) {
					result = FALSE;
					return result;
				}
				self->priv->alt_pressed = TRUE;
				result = page_on_alt_pressed (self, event);
				return result;
			}
		}
	} else if ((_tmp7_ == ((0 != _tmp6_label6) ? _tmp6_label6 : (_tmp6_label6 = g_quark_from_static_string ("Shift_L")))) || (_tmp7_ == ((0 != _tmp6_label7) ? _tmp6_label7 : (_tmp6_label7 = g_quark_from_static_string ("Shift_R"))))) {
		switch (0) {
			default:
			{
				gboolean _tmp10_ = FALSE;
				if (!shift_currently_pressed) {
					_tmp10_ = TRUE;
				} else {
					_tmp10_ = self->priv->shift_pressed;
				}
				if (_tmp10_) {
					result = FALSE;
					return result;
				}
				self->priv->shift_pressed = TRUE;
				result = page_on_shift_pressed (self, event);
				return result;
			}
		}
	} else if ((_tmp7_ == ((0 != _tmp6_label8) ? _tmp6_label8 : (_tmp6_label8 = g_quark_from_static_string ("Super_L")))) || (_tmp7_ == ((0 != _tmp6_label9) ? _tmp6_label9 : (_tmp6_label9 = g_quark_from_static_string ("Super_R"))))) {
		switch (0) {
			default:
			{
				gboolean _tmp11_ = FALSE;
				if (!super_currently_pressed) {
					_tmp11_ = TRUE;
				} else {
					_tmp11_ = self->priv->super_pressed;
				}
				if (_tmp11_) {
					result = FALSE;
					return result;
				}
				self->priv->super_pressed = TRUE;
				result = page_on_super_pressed (self, event);
				return result;
			}
		}
	}
	result = page_on_app_key_pressed (self, event);
	return result;
}

gboolean
page_notify_app_key_released (Page* self,
                              GdkEventKey* event)
{
	gboolean ctrl_currently_pressed = FALSE;
	gboolean alt_currently_pressed = FALSE;
	gboolean shift_currently_pressed = FALSE;
	gboolean super_currently_pressed = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	static GQuark _tmp6_label3 = 0;
	static GQuark _tmp6_label4 = 0;
	static GQuark _tmp6_label5 = 0;
	static GQuark _tmp6_label6 = 0;
	static GQuark _tmp6_label7 = 0;
	static GQuark _tmp6_label8 = 0;
	static GQuark _tmp6_label9 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	page_get_modifiers (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	ctrl_currently_pressed = _tmp0_;
	alt_currently_pressed = _tmp1_;
	shift_currently_pressed = _tmp2_;
	super_currently_pressed = _tmp3_;
	_tmp4_ = gdk_keyval_name (event->keyval);
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if ((_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("Control_L")))) || (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("Control_R"))))) {
		switch (0) {
			default:
			{
				gboolean _tmp8_ = FALSE;
				if (ctrl_currently_pressed) {
					_tmp8_ = TRUE;
				} else {
					_tmp8_ = !self->priv->ctrl_pressed;
				}
				if (_tmp8_) {
					result = FALSE;
					return result;
				}
				self->priv->ctrl_pressed = FALSE;
				result = page_on_ctrl_released (self, event);
				return result;
			}
		}
	} else if ((((_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("Meta_L")))) || (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("Meta_R"))))) || (_tmp7_ == ((0 != _tmp6_label4) ? _tmp6_label4 : (_tmp6_label4 = g_quark_from_static_string ("Alt_L"))))) || (_tmp7_ == ((0 != _tmp6_label5) ? _tmp6_label5 : (_tmp6_label5 = g_quark_from_static_string ("Alt_R"))))) {
		switch (0) {
			default:
			{
				gboolean _tmp9_ = FALSE;
				if (alt_currently_pressed) {
					_tmp9_ = TRUE;
				} else {
					_tmp9_ = !self->priv->alt_pressed;
				}
				if (_tmp9_) {
					result = FALSE;
					return result;
				}
				self->priv->alt_pressed = FALSE;
				result = page_on_alt_released (self, event);
				return result;
			}
		}
	} else if ((_tmp7_ == ((0 != _tmp6_label6) ? _tmp6_label6 : (_tmp6_label6 = g_quark_from_static_string ("Shift_L")))) || (_tmp7_ == ((0 != _tmp6_label7) ? _tmp6_label7 : (_tmp6_label7 = g_quark_from_static_string ("Shift_R"))))) {
		switch (0) {
			default:
			{
				gboolean _tmp10_ = FALSE;
				if (shift_currently_pressed) {
					_tmp10_ = TRUE;
				} else {
					_tmp10_ = !self->priv->shift_pressed;
				}
				if (_tmp10_) {
					result = FALSE;
					return result;
				}
				self->priv->shift_pressed = FALSE;
				result = page_on_shift_released (self, event);
				return result;
			}
		}
	} else if ((_tmp7_ == ((0 != _tmp6_label8) ? _tmp6_label8 : (_tmp6_label8 = g_quark_from_static_string ("Super_L")))) || (_tmp7_ == ((0 != _tmp6_label9) ? _tmp6_label9 : (_tmp6_label9 = g_quark_from_static_string ("Super_R"))))) {
		switch (0) {
			default:
			{
				gboolean _tmp11_ = FALSE;
				if (super_currently_pressed) {
					_tmp11_ = TRUE;
				} else {
					_tmp11_ = !self->priv->super_pressed;
				}
				if (_tmp11_) {
					result = FALSE;
					return result;
				}
				self->priv->super_pressed = FALSE;
				result = page_on_super_released (self, event);
				return result;
			}
		}
	}
	result = page_on_app_key_released (self, event);
	return result;
}

/**
     * Returns true if the code parameter matches the keycode of the keyval parameter for
     * any keyboard group or level (in order to allow for non-QWERTY keyboards)
     */
gboolean
page_match_keycode (Page* self,
                    guint keyval,
                    guint code)
{
	GdkKeymapKey* keys = NULL;
	gint keys_length1 = 0;
	gint _keys_size_ = 0;
	GdkKeymap* keymap = NULL;
	GdkKeymap* _tmp0_;
	GdkKeymap* _tmp1_;
	GdkKeymap* _tmp2_;
	GdkKeymapKey* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gdk_keymap_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	keymap = _tmp1_;
	_tmp2_ = keymap;
	_tmp5_ = gdk_keymap_get_entries_for_keyval (_tmp2_, keyval, &_tmp3_, &_tmp4_);
	keys = (g_free (keys), NULL);
	keys = _tmp3_;
	keys_length1 = _tmp4_;
	_keys_size_ = keys_length1;
	if (_tmp5_) {
		GdkKeymapKey* _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = keys;
		_tmp6__length1 = keys_length1;
		{
			GdkKeymapKey* key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp6_;
			key_collection_length1 = _tmp6__length1;
			for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
				GdkKeymapKey key = {0};
				key = key_collection[key_it];
				{
					GdkKeymapKey _tmp7_;
					_tmp7_ = key;
					if (code == _tmp7_.keycode) {
						result = TRUE;
						_g_object_unref0 (keymap);
						keys = (g_free (keys), NULL);
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (keymap);
	keys = (g_free (keys), NULL);
	return result;
}

gboolean
page_notify_app_focus_in (Page* self,
                          GdkEventFocus* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	page_update_modifiers (self);
	result = FALSE;
	return result;
}

gboolean
page_notify_app_focus_out (Page* self,
                           GdkEventFocus* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

static void
page_real_on_move (Page* self,
                   GdkRectangle* rect)
{
	g_return_if_fail (rect != NULL);
}

void
page_on_move (Page* self,
              GdkRectangle* rect)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_move) {
		_klass_->on_move (self, rect);
	}
}

static void
page_real_on_move_start (Page* self,
                         GdkRectangle* rect)
{
	g_return_if_fail (rect != NULL);
}

void
page_on_move_start (Page* self,
                    GdkRectangle* rect)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_move_start) {
		_klass_->on_move_start (self, rect);
	}
}

static void
page_real_on_move_finished (Page* self,
                            GdkRectangle* rect)
{
	g_return_if_fail (rect != NULL);
}

void
page_on_move_finished (Page* self,
                       GdkRectangle* rect)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_move_finished) {
		_klass_->on_move_finished (self, rect);
	}
}

static void
page_real_on_resize (Page* self,
                     GdkRectangle* rect)
{
	g_return_if_fail (rect != NULL);
}

void
page_on_resize (Page* self,
                GdkRectangle* rect)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_resize) {
		_klass_->on_resize (self, rect);
	}
}

static void
page_real_on_resize_start (Page* self,
                           GdkRectangle* rect)
{
	g_return_if_fail (rect != NULL);
}

void
page_on_resize_start (Page* self,
                      GdkRectangle* rect)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_resize_start) {
		_klass_->on_resize_start (self, rect);
	}
}

static void
page_real_on_resize_finished (Page* self,
                              GdkRectangle* rect)
{
	g_return_if_fail (rect != NULL);
}

void
page_on_resize_finished (Page* self,
                         GdkRectangle* rect)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_resize_finished) {
		_klass_->on_resize_finished (self, rect);
	}
}

static gboolean
page_real_on_configure (Page* self,
                        GdkEventConfigure* event,
                        GdkRectangle* rect)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (rect != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
page_on_configure (Page* self,
                   GdkEventConfigure* event,
                   GdkRectangle* rect)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_configure) {
		return _klass_->on_configure (self, event, rect);
	}
	return FALSE;
}

static gboolean
_page_check_configure_halted_gsource_func (gpointer self)
{
	gboolean result;
	result = page_check_configure_halted ((Page*) self);
	return result;
}

gboolean
page_notify_configure_event (Page* self,
                             GdkEventConfigure* event)
{
	GdkRectangle rect = {0};
	gboolean _tmp12_ = FALSE;
	GdkRectangle _tmp13_;
	GdkRectangle _tmp14_;
	gboolean _tmp18_ = FALSE;
	GdkRectangle _tmp19_;
	GdkRectangle _tmp20_;
	GdkRectangle _tmp24_;
	GdkRectangle _tmp25_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	memset (&rect, 0, sizeof (GdkRectangle));
	rect.x = event->x;
	rect.y = event->y;
	rect.width = event->width;
	rect.height = event->height;
	if (self->priv->last_configure_ms == ((gint64) 0)) {
		gboolean _tmp0_ = FALSE;
		GdkRectangle _tmp1_;
		GdkRectangle _tmp2_;
		gboolean _tmp6_ = FALSE;
		GdkRectangle _tmp7_;
		GdkRectangle _tmp8_;
		_tmp1_ = self->priv->last_position;
		_tmp2_ = rect;
		if (_tmp1_.x != _tmp2_.x) {
			_tmp0_ = TRUE;
		} else {
			GdkRectangle _tmp3_;
			GdkRectangle _tmp4_;
			_tmp3_ = self->priv->last_position;
			_tmp4_ = rect;
			_tmp0_ = _tmp3_.y != _tmp4_.y;
		}
		if (_tmp0_) {
			GdkRectangle _tmp5_;
			_tmp5_ = rect;
			page_on_move_start (self, &_tmp5_);
			self->priv->report_move_finished = TRUE;
		}
		_tmp7_ = self->priv->last_position;
		_tmp8_ = rect;
		if (_tmp7_.width != _tmp8_.width) {
			_tmp6_ = TRUE;
		} else {
			GdkRectangle _tmp9_;
			GdkRectangle _tmp10_;
			_tmp9_ = self->priv->last_position;
			_tmp10_ = rect;
			_tmp6_ = _tmp9_.height != _tmp10_.height;
		}
		if (_tmp6_) {
			GdkRectangle _tmp11_;
			_tmp11_ = rect;
			page_on_resize_start (self, &_tmp11_);
			self->priv->report_resize_finished = TRUE;
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (PAGE_CONSIDER_CONFIGURE_HALTED_MSEC / 8), _page_check_configure_halted_gsource_func, g_object_ref (self), g_object_unref);
	}
	_tmp13_ = self->priv->last_position;
	_tmp14_ = rect;
	if (_tmp13_.x != _tmp14_.x) {
		_tmp12_ = TRUE;
	} else {
		GdkRectangle _tmp15_;
		GdkRectangle _tmp16_;
		_tmp15_ = self->priv->last_position;
		_tmp16_ = rect;
		_tmp12_ = _tmp15_.y != _tmp16_.y;
	}
	if (_tmp12_) {
		GdkRectangle _tmp17_;
		_tmp17_ = rect;
		page_on_move (self, &_tmp17_);
	}
	_tmp19_ = self->priv->last_position;
	_tmp20_ = rect;
	if (_tmp19_.width != _tmp20_.width) {
		_tmp18_ = TRUE;
	} else {
		GdkRectangle _tmp21_;
		GdkRectangle _tmp22_;
		_tmp21_ = self->priv->last_position;
		_tmp22_ = rect;
		_tmp18_ = _tmp21_.height != _tmp22_.height;
	}
	if (_tmp18_) {
		GdkRectangle _tmp23_;
		_tmp23_ = rect;
		page_on_resize (self, &_tmp23_);
	}
	_tmp24_ = rect;
	self->priv->last_position = _tmp24_;
	self->priv->last_configure_ms = now_ms ();
	_tmp25_ = rect;
	result = page_on_configure (self, event, &_tmp25_);
	return result;
}

static gboolean
page_check_configure_halted (Page* self)
{
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->is_destroyed) {
		result = FALSE;
		return result;
	}
	if ((now_ms () - self->priv->last_configure_ms) < ((gint64) PAGE_CONSIDER_CONFIGURE_HALTED_MSEC)) {
		result = TRUE;
		return result;
	}
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	if (self->priv->report_move_finished) {
		GtkAllocation _tmp1_;
		GdkRectangle _tmp2_;
		_tmp1_ = allocation;
		_tmp2_ = (GdkRectangle) _tmp1_;
		page_on_move_finished (self, &_tmp2_);
	}
	if (self->priv->report_resize_finished) {
		GtkAllocation _tmp3_;
		GdkRectangle _tmp4_;
		_tmp3_ = allocation;
		_tmp4_ = (GdkRectangle) _tmp3_;
		page_on_resize_finished (self, &_tmp4_);
	}
	self->priv->last_configure_ms = (gint64) 0;
	self->priv->report_move_finished = FALSE;
	self->priv->report_resize_finished = FALSE;
	result = FALSE;
	return result;
}

static gboolean
page_real_on_motion (Page* self,
                     GdkEventMotion* event,
                     gint x,
                     gint y,
                     GdkModifierType mask)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	page_check_cursor_hiding (self);
	result = FALSE;
	return result;
}

gboolean
page_on_motion (Page* self,
                GdkEventMotion* event,
                gint x,
                gint y,
                GdkModifierType mask)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_motion) {
		return _klass_->on_motion (self, event, x, y, mask);
	}
	return FALSE;
}

static gboolean
page_real_on_leave_notify_event (Page* self)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
page_on_leave_notify_event (Page* self)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_leave_notify_event) {
		return _klass_->on_leave_notify_event (self);
	}
	return FALSE;
}

static gboolean
page_on_motion_internal (Page* self,
                         GdkEventMotion* event)
{
	gint x = 0;
	gint y = 0;
	GdkModifierType mask = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (((gint) event->is_hint) == 1) {
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		GdkModifierType _tmp2_ = 0U;
		page_get_event_source_pointer (self, &_tmp0_, &_tmp1_, &_tmp2_);
		x = _tmp0_;
		y = _tmp1_;
		mask = _tmp2_;
	} else {
		x = (gint) event->x;
		y = (gint) event->y;
		mask = event->state;
	}
	result = page_on_motion (self, event, x, y, mask);
	return result;
}

static gboolean
page_on_mousewheel_internal (Page* self,
                             GdkEventScroll* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	switch (event->direction) {
		case GDK_SCROLL_UP:
		{
			result = page_on_mousewheel_up (self, event);
			return result;
		}
		case GDK_SCROLL_DOWN:
		{
			result = page_on_mousewheel_down (self, event);
			return result;
		}
		case GDK_SCROLL_LEFT:
		{
			result = page_on_mousewheel_left (self, event);
			return result;
		}
		case GDK_SCROLL_RIGHT:
		{
			result = page_on_mousewheel_right (self, event);
			return result;
		}
		case GDK_SCROLL_SMOOTH:
		{
			gdouble dx = 0.0;
			gdouble dy = 0.0;
			gboolean vertical = FALSE;
			gboolean horizontal = FALSE;
			gdouble _tmp0_ = 0.0;
			gdouble _tmp1_ = 0.0;
			gboolean _tmp2_;
			vertical = FALSE;
			horizontal = FALSE;
			_tmp2_ = gdk_event_get_scroll_deltas ((GdkEvent*) event, &_tmp0_, &_tmp1_);
			dx = _tmp0_;
			dy = _tmp1_;
			if (_tmp2_) {
				gboolean _tmp5_ = FALSE;
				self->priv->total_dx = self->priv->total_dx + dx;
				self->priv->total_dy = self->priv->total_dy + dy;
				if (fabs (self->priv->total_dx) > 0.05) {
					gboolean _tmp3_ = FALSE;
					if (self->priv->total_dx > ((gdouble) 0)) {
						_tmp3_ = page_on_mousewheel_right (self, event);
					} else {
						_tmp3_ = page_on_mousewheel_left (self, event);
					}
					horizontal = _tmp3_;
					self->priv->total_dx = 0.0;
				}
				if (fabs (self->priv->total_dy) > 0.05) {
					gboolean _tmp4_ = FALSE;
					if (self->priv->total_dy > ((gdouble) 0)) {
						_tmp4_ = page_on_mousewheel_down (self, event);
					} else {
						_tmp4_ = page_on_mousewheel_up (self, event);
					}
					vertical = _tmp4_;
					self->priv->total_dy = 0.0;
				}
				if (horizontal) {
					_tmp5_ = TRUE;
				} else {
					_tmp5_ = vertical;
				}
				result = _tmp5_;
				return result;
			}
			result = FALSE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gboolean
page_real_on_mousewheel_up (Page* self,
                            GdkEventScroll* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
page_on_mousewheel_up (Page* self,
                       GdkEventScroll* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_mousewheel_up) {
		return _klass_->on_mousewheel_up (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_mousewheel_down (Page* self,
                              GdkEventScroll* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
page_on_mousewheel_down (Page* self,
                         GdkEventScroll* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_mousewheel_down) {
		return _klass_->on_mousewheel_down (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_mousewheel_left (Page* self,
                              GdkEventScroll* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
page_on_mousewheel_left (Page* self,
                         GdkEventScroll* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_mousewheel_left) {
		return _klass_->on_mousewheel_left (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_mousewheel_right (Page* self,
                               GdkEventScroll* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
page_on_mousewheel_right (Page* self,
                          GdkEventScroll* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_mousewheel_right) {
		return _klass_->on_mousewheel_right (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_context_keypress (Page* self)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
page_on_context_keypress (Page* self)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_context_keypress) {
		return _klass_->on_context_keypress (self);
	}
	return FALSE;
}

static gboolean
page_real_on_context_buttonpress (Page* self,
                                  GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
page_on_context_buttonpress (Page* self,
                             GdkEventButton* event)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_context_buttonpress) {
		return _klass_->on_context_buttonpress (self, event);
	}
	return FALSE;
}

static gboolean
page_real_on_context_invoked (Page* self)
{
	gboolean result;
	result = TRUE;
	return result;
}

gboolean
page_on_context_invoked (Page* self)
{
	PageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->on_context_invoked) {
		return _klass_->on_context_invoked (self);
	}
	return FALSE;
}

gboolean
page_popup_context_menu (Page* self,
                         GtkMenu* context_menu,
                         GdkEventButton* event)
{
	gboolean _tmp0_ = FALSE;
	GdkRectangle rect = {0};
	GdkRectangle _tmp1_ = {0};
	GdkWindow* _tmp2_;
	GdkRectangle _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (context_menu == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !page_on_context_invoked (self);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	memset (&_tmp1_, 0, sizeof (GdkRectangle));
	_tmp1_.x = (gint) event->x;
	_tmp1_.y = (gint) event->y;
	_tmp1_.width = 1;
	_tmp1_.height = 1;
	rect = _tmp1_;
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp3_ = rect;
	gtk_menu_popup_at_rect (context_menu, _tmp2_, &_tmp3_, GDK_GRAVITY_NORTH_WEST, GDK_GRAVITY_NORTH_WEST, (GdkEvent*) event);
	result = TRUE;
	return result;
}

static void
page_on_event_source_realize (Page* self)
{
	GtkWidget* _tmp0_;
	GdkWindow* _tmp1_;
	GtkWidget* _tmp2_;
	GdkWindow* _tmp3_;
	GdkCursor* _tmp4_;
	GdkWindow* parent_window = NULL;
	GtkWidget* _tmp8_;
	GdkWindow* _tmp9_;
	GdkWindow* _tmp10_;
	GdkWindow* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->event_source;
	_tmp1_ = gtk_widget_get_window (_tmp0_);
	_vala_assert (_tmp1_ != NULL, "event_source.get_window () != null");
	_tmp2_ = self->priv->event_source;
	_tmp3_ = gtk_widget_get_window (_tmp2_);
	_tmp4_ = gdk_window_get_cursor (_tmp3_);
	if (_tmp4_ != NULL) {
		GtkWidget* _tmp5_;
		GdkWindow* _tmp6_;
		GdkCursor* _tmp7_;
		_tmp5_ = self->priv->event_source;
		_tmp6_ = gtk_widget_get_window (_tmp5_);
		_tmp7_ = gdk_window_get_cursor (_tmp6_);
		self->priv->last_cursor = gdk_cursor_get_cursor_type (_tmp7_);
		return;
	}
	_tmp8_ = self->priv->event_source;
	_tmp9_ = gtk_widget_get_window (_tmp8_);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	parent_window = _tmp10_;
	{
		gboolean _tmp11_ = FALSE;
		_tmp11_ = TRUE;
		while (TRUE) {
			GdkWindow* _tmp16_;
			GdkWindow* _tmp17_;
			GdkWindow* _tmp18_;
			if (!_tmp11_) {
				gboolean _tmp12_ = FALSE;
				GdkWindow* _tmp13_;
				_tmp13_ = parent_window;
				if (_tmp13_ != NULL) {
					GdkWindow* _tmp14_;
					GdkCursor* _tmp15_;
					_tmp14_ = parent_window;
					_tmp15_ = gdk_window_get_cursor (_tmp14_);
					_tmp12_ = _tmp15_ == NULL;
				} else {
					_tmp12_ = FALSE;
				}
				if (!_tmp12_) {
					break;
				}
			}
			_tmp11_ = FALSE;
			_tmp16_ = parent_window;
			_tmp17_ = gdk_window_get_parent (_tmp16_);
			_tmp18_ = _g_object_ref0 (_tmp17_);
			_g_object_unref0 (parent_window);
			parent_window = _tmp18_;
		}
	}
	_tmp19_ = parent_window;
	if (_tmp19_ != NULL) {
		GdkWindow* _tmp20_;
		GdkCursor* _tmp21_;
		_tmp20_ = parent_window;
		_tmp21_ = gdk_window_get_cursor (_tmp20_);
		self->priv->last_cursor = gdk_cursor_get_cursor_type (_tmp21_);
	}
	_g_object_unref0 (parent_window);
}

void
page_set_cursor_hide_time (Page* self,
                           gint hide_time)
{
	g_return_if_fail (self != NULL);
	self->priv->cursor_hide_msec = hide_time;
}

void
page_start_cursor_hiding (Page* self)
{
	g_return_if_fail (self != NULL);
	page_check_cursor_hiding (self);
}

void
page_stop_cursor_hiding (Page* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->last_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->last_timeout_id);
		self->priv->last_timeout_id = (guint) 0;
	}
}

void
page_suspend_cursor_hiding (Page* self)
{
	g_return_if_fail (self != NULL);
	self->priv->cursor_hide_time_cached = self->priv->cursor_hide_msec;
	if (self->priv->last_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->last_timeout_id);
		self->priv->last_timeout_id = (guint) 0;
	}
	self->priv->cursor_hide_msec = 0;
}

void
page_restore_cursor_hiding (Page* self)
{
	g_return_if_fail (self != NULL);
	self->priv->cursor_hide_msec = self->priv->cursor_hide_time_cached;
	page_check_cursor_hiding (self);
}

static void
page_real_set_page_cursor (Page* self,
                           GdkCursorType cursor_type)
{
	gboolean _tmp0_ = FALSE;
	self->priv->last_cursor = cursor_type;
	if (!self->priv->cursor_hidden) {
		GtkWidget* _tmp1_;
		_tmp1_ = self->priv->event_source;
		_tmp0_ = _tmp1_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkWidget* _tmp2_;
		GdkWindow* _tmp3_;
		GdkDisplay* _tmp4_;
		GdkCursor* _tmp5_;
		GdkCursor* _tmp6_;
		_tmp2_ = self->priv->event_source;
		_tmp3_ = gtk_widget_get_window (_tmp2_);
		_tmp4_ = gdk_display_get_default ();
		_tmp5_ = gdk_cursor_new_for_display (_tmp4_, cursor_type);
		_tmp6_ = _tmp5_;
		gdk_window_set_cursor (_tmp3_, _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
}

void
page_set_page_cursor (Page* self,
                      GdkCursorType cursor_type)
{
	PageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PAGE_GET_CLASS (self);
	if (_klass_->set_page_cursor) {
		_klass_->set_page_cursor (self, cursor_type);
	}
}

static gboolean
_page_on_hide_cursor_gsource_func (gpointer self)
{
	gboolean result;
	result = page_on_hide_cursor ((Page*) self);
	return result;
}

static void
page_check_cursor_hiding (Page* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->cursor_hidden) {
		self->priv->cursor_hidden = FALSE;
		page_set_page_cursor (self, self->priv->last_cursor);
	}
	if (self->priv->cursor_hide_msec != 0) {
		if (self->priv->last_timeout_id != ((guint) 0)) {
			g_source_remove (self->priv->last_timeout_id);
		}
		self->priv->last_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) self->priv->cursor_hide_msec, _page_on_hide_cursor_gsource_func, g_object_ref (self), g_object_unref);
	}
}

static gboolean
page_on_hide_cursor (Page* self)
{
	GtkWidget* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->cursor_hidden = TRUE;
	_tmp0_ = self->priv->event_source;
	if (_tmp0_ != NULL) {
		GtkWidget* _tmp1_;
		GdkWindow* _tmp2_;
		GdkDisplay* _tmp3_;
		GdkCursor* _tmp4_;
		GdkCursor* _tmp5_;
		_tmp1_ = self->priv->event_source;
		_tmp2_ = gtk_widget_get_window (_tmp1_);
		_tmp3_ = gdk_display_get_default ();
		_tmp4_ = gdk_cursor_new_for_display (_tmp3_, GDK_BLANK_CURSOR);
		_tmp5_ = _tmp4_;
		gdk_window_set_cursor (_tmp2_, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	self->priv->last_timeout_id = (guint) 0;
	result = FALSE;
	return result;
}

gboolean
page_get_in_view (Page* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_in_view;
	return result;
}

static void
page_set_in_view (Page* self,
                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_in_view (self);
	if (old_value != value) {
		self->priv->_in_view = value;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_IN_VIEW_PROPERTY]);
	}
}

const gchar*
page_get_page_name (Page* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_page_name;
	result = _tmp0_;
	return result;
}

void
page_set_page_name (Page* self,
                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_page_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_page_name);
		self->priv->_page_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_PAGE_NAME_PROPERTY]);
	}
}

static gboolean
_page_on_context_keypress_gtk_widget_popup_menu (GtkWidget* _sender,
                                                 gpointer self)
{
	gboolean result;
	result = page_on_context_keypress ((Page*) self);
	return result;
}

static void
_page_attach_view_signals_gtk_widget_realize (GtkWidget* _sender,
                                              gpointer self)
{
	page_attach_view_signals ((Page*) self);
}

static GObject *
page_constructor (GType type,
                  guint n_construct_properties,
                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Page * self;
	GSettings* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ViewCollection* _tmp4_;
	GdkPoint _tmp5_ = {0};
	GtkActionGroup* _tmp6_;
	GtkActionEntry* action_entries = NULL;
	gint _tmp7_ = 0;
	GtkActionEntry* _tmp8_;
	gint action_entries_length1;
	gint _action_entries_size_;
	GtkActionEntry* _tmp9_;
	gint _tmp9__length1;
	GtkToggleActionEntry* toggle_entries = NULL;
	gint _tmp12_ = 0;
	GtkToggleActionEntry* _tmp13_;
	gint toggle_entries_length1;
	gint _toggle_entries_size_;
	GtkToggleActionEntry* _tmp14_;
	gint _tmp14__length1;
	GtkActionGroup* _tmp17_;
	AppWindow* _tmp18_;
	AppWindow* _tmp19_;
	gint _tmp20_ = 0;
	GtkActionGroup** _tmp21_;
	parent_class = G_OBJECT_CLASS (page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE, Page);
	_tmp0_ = g_settings_new (GSETTINGS_CONFIGURATION_ENGINE_UI_PREFS_SCHEMA_NAME);
	_g_object_unref0 (self->ui_settings);
	self->ui_settings = _tmp0_;
	_tmp1_ = self->priv->_page_name;
	_tmp2_ = g_strdup_printf ("ViewCollection for Page %s", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = view_collection_new (_tmp3_);
	_data_collection_unref0 (self->priv->view);
	self->priv->view = _tmp4_;
	_g_free0 (_tmp3_);
	_tmp5_.x = -1;
	_tmp5_.y = -1;
	self->priv->last_down = _tmp5_;
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	g_signal_connect_object ((GtkWidget*) self, "popup-menu", (GCallback) _page_on_context_keypress_gtk_widget_popup_menu, self, 0);
	_tmp6_ = gtk_action_group_new ("PageActionGroup");
	_g_object_unref0 (self->priv->action_group);
	self->priv->action_group = _tmp6_;
	_tmp8_ = page_init_collect_action_entries (self, &_tmp7_);
	action_entries = _tmp8_;
	action_entries_length1 = _tmp7_;
	_action_entries_size_ = action_entries_length1;
	_tmp9_ = action_entries;
	_tmp9__length1 = action_entries_length1;
	if (_tmp9__length1 > 0) {
		GtkActionGroup* _tmp10_;
		GtkActionEntry* _tmp11_;
		gint _tmp11__length1;
		_tmp10_ = self->priv->action_group;
		_tmp11_ = action_entries;
		_tmp11__length1 = action_entries_length1;
		gtk_action_group_add_actions (_tmp10_, _tmp11_, (guint) _tmp11__length1, self);
	}
	_tmp13_ = page_init_collect_toggle_action_entries (self, &_tmp12_);
	toggle_entries = _tmp13_;
	toggle_entries_length1 = _tmp12_;
	_toggle_entries_size_ = toggle_entries_length1;
	_tmp14_ = toggle_entries;
	_tmp14__length1 = toggle_entries_length1;
	if (_tmp14__length1 > 0) {
		GtkActionGroup* _tmp15_;
		GtkToggleActionEntry* _tmp16_;
		gint _tmp16__length1;
		_tmp15_ = self->priv->action_group;
		_tmp16_ = toggle_entries;
		_tmp16__length1 = toggle_entries_length1;
		gtk_action_group_add_toggle_actions (_tmp15_, _tmp16_, (guint) _tmp16__length1, self);
	}
	_tmp17_ = self->priv->action_group;
	page_register_radio_actions (self, _tmp17_);
	_tmp18_ = app_window_get_instance ();
	_tmp19_ = _tmp18_;
	_tmp21_ = app_window_get_common_action_groups (_tmp19_, &_tmp20_);
	self->priv->common_action_groups = (_vala_array_free (self->priv->common_action_groups, self->priv->common_action_groups_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->common_action_groups = _tmp21_;
	self->priv->common_action_groups_length1 = _tmp20_;
	self->priv->_common_action_groups_size_ = self->priv->common_action_groups_length1;
	_g_object_unref0 (_tmp19_);
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) _page_attach_view_signals_gtk_widget_realize, self, 0);
	toggle_entries = (g_free (toggle_entries), NULL);
	action_entries = (g_free (action_entries), NULL);
	return obj;
}

static void
page_class_init (PageClass * klass,
                 gpointer klass_data)
{
	page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Page_private_offset);
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) page_real_destroy;
	((PageClass *) klass)->set_container = (void (*) (Page*, GtkWindow*)) page_real_set_container;
	((PageClass *) klass)->clear_container = (void (*) (Page*)) page_real_clear_container;
	((PageClass *) klass)->add_toolbar_widgets = (void (*) (Page*, GtkActionBar*)) page_real_add_toolbar_widgets;
	((PageClass *) klass)->get_page_context_menu = (GtkMenu* (*) (Page*)) page_real_get_page_context_menu;
	((PageClass *) klass)->get_page_sidebar_menu = (GtkMenu* (*) (Page*)) page_real_get_page_sidebar_menu;
	((PageClass *) klass)->switching_from = (void (*) (Page*)) page_real_switching_from;
	((PageClass *) klass)->switched_to = (void (*) (Page*)) page_real_switched_to;
	((PageClass *) klass)->ready = (void (*) (Page*)) page_real_ready;
	((PageClass *) klass)->switching_to_fullscreen = (void (*) (Page*, FullscreenWindow*)) page_real_switching_to_fullscreen;
	((PageClass *) klass)->returning_from_fullscreen = (void (*) (Page*, FullscreenWindow*)) page_real_returning_from_fullscreen;
	((PageClass *) klass)->get_header_buttons = (GtkBox* (*) (Page*)) page_real_get_header_buttons;
	((PageClass *) klass)->init_collect_action_entries = (GtkActionEntry* (*) (Page*, gint*)) page_real_init_collect_action_entries;
	((PageClass *) klass)->init_collect_toggle_action_entries = (GtkToggleActionEntry* (*) (Page*, gint*)) page_real_init_collect_toggle_action_entries;
	((PageClass *) klass)->register_radio_actions = (void (*) (Page*, GtkActionGroup*)) page_real_register_radio_actions;
	((PageClass *) klass)->init_actions = (void (*) (Page*, gint, gint)) page_real_init_actions;
	((PageClass *) klass)->update_actions = (void (*) (Page*, gint, gint)) page_real_update_actions;
	((PageClass *) klass)->on_left_click = (gboolean (*) (Page*, GdkEventButton*)) page_real_on_left_click;
	((PageClass *) klass)->on_middle_click = (gboolean (*) (Page*, GdkEventButton*)) page_real_on_middle_click;
	((PageClass *) klass)->on_right_click = (gboolean (*) (Page*, GdkEventButton*)) page_real_on_right_click;
	((PageClass *) klass)->on_left_released = (gboolean (*) (Page*, GdkEventButton*)) page_real_on_left_released;
	((PageClass *) klass)->on_middle_released = (gboolean (*) (Page*, GdkEventButton*)) page_real_on_middle_released;
	((PageClass *) klass)->on_right_released = (gboolean (*) (Page*, GdkEventButton*)) page_real_on_right_released;
	((PageClass *) klass)->on_ctrl_pressed = (gboolean (*) (Page*, GdkEventKey*)) page_real_on_ctrl_pressed;
	((PageClass *) klass)->on_ctrl_released = (gboolean (*) (Page*, GdkEventKey*)) page_real_on_ctrl_released;
	((PageClass *) klass)->on_alt_pressed = (gboolean (*) (Page*, GdkEventKey*)) page_real_on_alt_pressed;
	((PageClass *) klass)->on_alt_released = (gboolean (*) (Page*, GdkEventKey*)) page_real_on_alt_released;
	((PageClass *) klass)->on_shift_pressed = (gboolean (*) (Page*, GdkEventKey*)) page_real_on_shift_pressed;
	((PageClass *) klass)->on_shift_released = (gboolean (*) (Page*, GdkEventKey*)) page_real_on_shift_released;
	((PageClass *) klass)->on_super_pressed = (gboolean (*) (Page*, GdkEventKey*)) page_real_on_super_pressed;
	((PageClass *) klass)->on_super_released = (gboolean (*) (Page*, GdkEventKey*)) page_real_on_super_released;
	((PageClass *) klass)->on_app_key_pressed = (gboolean (*) (Page*, GdkEventKey*)) page_real_on_app_key_pressed;
	((PageClass *) klass)->on_app_key_released = (gboolean (*) (Page*, GdkEventKey*)) page_real_on_app_key_released;
	((PageClass *) klass)->on_move = (void (*) (Page*, GdkRectangle*)) page_real_on_move;
	((PageClass *) klass)->on_move_start = (void (*) (Page*, GdkRectangle*)) page_real_on_move_start;
	((PageClass *) klass)->on_move_finished = (void (*) (Page*, GdkRectangle*)) page_real_on_move_finished;
	((PageClass *) klass)->on_resize = (void (*) (Page*, GdkRectangle*)) page_real_on_resize;
	((PageClass *) klass)->on_resize_start = (void (*) (Page*, GdkRectangle*)) page_real_on_resize_start;
	((PageClass *) klass)->on_resize_finished = (void (*) (Page*, GdkRectangle*)) page_real_on_resize_finished;
	((PageClass *) klass)->on_configure = (gboolean (*) (Page*, GdkEventConfigure*, GdkRectangle*)) page_real_on_configure;
	((PageClass *) klass)->on_motion = (gboolean (*) (Page*, GdkEventMotion*, gint, gint, GdkModifierType)) page_real_on_motion;
	((PageClass *) klass)->on_leave_notify_event = (gboolean (*) (Page*)) page_real_on_leave_notify_event;
	((PageClass *) klass)->on_mousewheel_up = (gboolean (*) (Page*, GdkEventScroll*)) page_real_on_mousewheel_up;
	((PageClass *) klass)->on_mousewheel_down = (gboolean (*) (Page*, GdkEventScroll*)) page_real_on_mousewheel_down;
	((PageClass *) klass)->on_mousewheel_left = (gboolean (*) (Page*, GdkEventScroll*)) page_real_on_mousewheel_left;
	((PageClass *) klass)->on_mousewheel_right = (gboolean (*) (Page*, GdkEventScroll*)) page_real_on_mousewheel_right;
	((PageClass *) klass)->on_context_keypress = (gboolean (*) (Page*)) page_real_on_context_keypress;
	((PageClass *) klass)->on_context_buttonpress = (gboolean (*) (Page*, GdkEventButton*)) page_real_on_context_buttonpress;
	((PageClass *) klass)->on_context_invoked = (gboolean (*) (Page*)) page_real_on_context_invoked;
	((PageClass *) klass)->set_page_cursor = (void (*) (Page*, GdkCursorType)) page_real_set_page_cursor;
	G_OBJECT_CLASS (klass)->get_property = _vala_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = page_constructor;
	G_OBJECT_CLASS (klass)->finalize = page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_IN_VIEW_PROPERTY, page_properties[PAGE_IN_VIEW_PROPERTY] = g_param_spec_boolean ("in-view", "in-view", "in-view", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_PAGE_NAME_PROPERTY, page_properties[PAGE_PAGE_NAME_PROPERTY] = g_param_spec_string ("page-name", "page-name", "page-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
page_instance_init (Page * self,
                    gpointer klass)
{
	self->priv = page_get_instance_private (self);
	self->toolbar = NULL;
	self->show_sidebar_button = NULL;
	self->priv->view = NULL;
	self->priv->container = NULL;
	memset (&self->priv->last_position, 0, sizeof (GdkRectangle));
	self->priv->event_source = NULL;
	self->priv->last_configure_ms = (gint64) 0;
	self->priv->report_move_finished = FALSE;
	self->priv->report_resize_finished = FALSE;
	memset (&self->priv->last_down, 0, sizeof (GdkPoint));
	self->priv->is_destroyed = FALSE;
	self->priv->ctrl_pressed = FALSE;
	self->priv->alt_pressed = FALSE;
	self->priv->shift_pressed = FALSE;
	self->priv->super_pressed = FALSE;
	self->priv->last_cursor = GDK_LEFT_PTR;
	self->priv->cursor_hidden = FALSE;
	self->priv->cursor_hide_msec = 0;
	self->priv->last_timeout_id = (guint) 0;
	self->priv->cursor_hide_time_cached = 0;
	self->priv->are_actions_attached = FALSE;
	self->priv->update_actions_scheduler = NULL;
	self->priv->action_group = NULL;
	self->priv->common_action_groups = NULL;
	self->priv->common_action_groups_length1 = 0;
	self->priv->_common_action_groups_size_ = self->priv->common_action_groups_length1;
	self->priv->contractor_menu_items = NULL;
	self->priv->_in_view = FALSE;
	self->priv->total_dx = 0.0;
	self->priv->total_dy = 0.0;
}

static void
page_finalize (GObject * obj)
{
	Page * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE, Page);
	_g_object_unref0 (self->toolbar);
	_g_object_unref0 (self->show_sidebar_button);
	_data_collection_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->container);
	_g_object_unref0 (self->priv->event_source);
	_one_shot_scheduler_unref0 (self->priv->update_actions_scheduler);
	_g_object_unref0 (self->priv->action_group);
	self->priv->common_action_groups = (_vala_array_free (self->priv->common_action_groups, self->priv->common_action_groups_length1, (GDestroyNotify) g_object_unref), NULL);
	(self->priv->contractor_menu_items == NULL) ? NULL : (self->priv->contractor_menu_items = (_g_list_free__g_object_unref0_ (self->priv->contractor_menu_items), NULL));
	_g_object_unref0 (self->header_box);
	_g_object_unref0 (self->ui_settings);
	_g_free0 (self->priv->_page_name);
	G_OBJECT_CLASS (page_parent_class)->finalize (obj);
}

static GType
page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Page), 0, (GInstanceInitFunc) page_instance_init, NULL };
	GType page_type_id;
	page_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "Page", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	Page_private_offset = g_type_add_instance_private (page_type_id, sizeof (PagePrivate));
	return page_type_id;
}

GType
page_get_type (void)
{
	static volatile gsize page_type_id__once = 0;
	if (g_once_init_enter (&page_type_id__once)) {
		GType page_type_id;
		page_type_id = page_get_type_once ();
		g_once_init_leave (&page_type_id__once, page_type_id);
	}
	return page_type_id__once;
}

static void
_vala_page_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Page * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PAGE, Page);
	switch (property_id) {
		case PAGE_IN_VIEW_PROPERTY:
		g_value_set_boolean (value, page_get_in_view (self));
		break;
		case PAGE_PAGE_NAME_PROPERTY:
		g_value_set_string (value, page_get_page_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_page_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Page * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PAGE, Page);
	switch (property_id) {
		case PAGE_IN_VIEW_PROPERTY:
		page_set_in_view (self, g_value_get_boolean (value));
		break;
		case PAGE_PAGE_NAME_PROPERTY:
		page_set_page_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

