/* PhotoTable.c generated by valac 0.56.18, the Vala compiler
 * generated from PhotoTable.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <sqlite3.h>
#include <gee.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecPhotoRow ParamSpecPhotoRow;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _photo_row_unref0(var) ((var == NULL) ? NULL : (var = (photo_row_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _key_value_map_unref0(var) ((var == NULL) ? NULL : (var = (key_value_map_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _ParamSpecBackingPhotoRow ParamSpecBackingPhotoRow;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ParamSpecPhotoRow {
	GParamSpec parent_instance;
};

struct _ParamSpecBackingPhotoRow {
	GParamSpec parent_instance;
};

static gpointer photo_row_parent_class = NULL;
static gpointer photo_table_parent_class = NULL;
static PhotoTable* photo_table_instance;
static PhotoTable* photo_table_instance = NULL;
static gpointer backing_photo_row_parent_class = NULL;
static gpointer backing_photo_table_parent_class = NULL;
static BackingPhotoTable* backing_photo_table_instance;
static BackingPhotoTable* backing_photo_table_instance = NULL;

static void photo_row_finalize (PhotoRow * obj);
static GType photo_row_get_type_once (void);
static PhotoTable* photo_table_new (void);
static PhotoTable* photo_table_construct (GType object_type);
static void photo_table_validate_orientation (PhotoTable* self,
                                       PhotoRow* row);
static gchar* photo_table_get_raw_transformations (PhotoTable* self,
                                            PhotoID* photo_id);
static gboolean photo_table_set_raw_transformations (PhotoTable* self,
                                              PhotoID* photo_id,
                                              const gchar* trans);
static gboolean photo_table_set_raw_original_transforms (PhotoTable* self,
                                                  PhotoID* photo_id,
                                                  const gchar* trans);
static sqlite3_stmt* photo_table_get_duplicate_stmt (PhotoTable* self,
                                              GFile* file,
                                              const gchar* thumbnail_md5,
                                              const gchar* md5,
                                              PhotoFileFormat file_format);
static void _vala_array_add49 (PhotoID* * array,
                        gint* length,
                        gint* size,
                        const PhotoID* value);
static void photo_table_finalize (DatabaseTable * obj);
static GType photo_table_get_type_once (void);
static void backing_photo_row_finalize (BackingPhotoRow * obj);
static GType backing_photo_row_get_type_once (void);
static BackingPhotoTable* backing_photo_table_new (void);
static BackingPhotoTable* backing_photo_table_construct (GType object_type);
static void backing_photo_table_finalize (DatabaseTable * obj);
static GType backing_photo_table_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

void
photo_id_init (PhotoID *self,
               gint64 id)
{
	memset (self, 0, sizeof (PhotoID));
	(*self).id = id;
}

gboolean
photo_id_is_invalid (PhotoID *self)
{
	gboolean result;
	result = (*self).id == PHOTO_ID_INVALID;
	return result;
}

gboolean
photo_id_is_valid (PhotoID *self)
{
	gboolean result;
	result = (*self).id != PHOTO_ID_INVALID;
	return result;
}

guint
photo_id_hash (PhotoID *self)
{
	guint result;
	result = int64_hash (&(*self).id);
	return result;
}

gboolean
photo_id_equal (void* a,
                void* b)
{
	gboolean result;
	result = (*((PhotoID*) a)).id == (*((PhotoID*) b)).id;
	return result;
}

gchar*
photo_id_upgrade_photo_id_to_source_id (PhotoID* photo_id)
{
	PhotoID _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (photo_id != NULL, NULL);
	_tmp0_ = *photo_id;
	_tmp1_ = g_strdup_printf ("%s%016" G_GINT64_MODIFIER "x", PHOTO_TYPENAME, _tmp0_.id);
	result = _tmp1_;
	return result;
}

PhotoID*
photo_id_dup (const PhotoID* self)
{
	PhotoID* dup;
	dup = g_new0 (PhotoID, 1);
	memcpy (dup, self, sizeof (PhotoID));
	return dup;
}

void
photo_id_free (PhotoID* self)
{
	g_free (self);
}

static GType
photo_id_get_type_once (void)
{
	GType photo_id_type_id;
	photo_id_type_id = g_boxed_type_register_static ("PhotoID", (GBoxedCopyFunc) photo_id_dup, (GBoxedFreeFunc) photo_id_free);
	return photo_id_type_id;
}

GType
photo_id_get_type (void)
{
	static volatile gsize photo_id_type_id__once = 0;
	if (g_once_init_enter (&photo_id_type_id__once)) {
		GType photo_id_type_id;
		photo_id_type_id = photo_id_get_type_once ();
		g_once_init_leave (&photo_id_type_id__once, photo_id_type_id);
	}
	return photo_id_type_id__once;
}

void
import_id_init (ImportID *self,
                gint64 id)
{
	memset (self, 0, sizeof (ImportID));
	(*self).id = id;
}

void
import_id_generate (ImportID* result)
{
	ImportID _tmp0_ = {0};
	import_id_init (&_tmp0_, now_sec ());
	*result = _tmp0_;
	return;
}

gboolean
import_id_is_invalid (ImportID *self)
{
	gboolean result;
	result = (*self).id == IMPORT_ID_INVALID;
	return result;
}

gboolean
import_id_is_valid (ImportID *self)
{
	gboolean result;
	result = (*self).id != IMPORT_ID_INVALID;
	return result;
}

gint
import_id_compare_func (ImportID* a,
                        ImportID* b)
{
	gboolean _tmp0_ = FALSE;
	gint result;
	if (a != NULL) {
		_tmp0_ = b != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "a != null && b != null");
	result = (gint) ((*a).id - (*b).id);
	return result;
}

gint64
import_id_comparator (void* a,
                      void* b)
{
	gint64 result;
	result = (*((ImportID*) a)).id - (*((ImportID*) b)).id;
	return result;
}

ImportID*
import_id_dup (const ImportID* self)
{
	ImportID* dup;
	dup = g_new0 (ImportID, 1);
	memcpy (dup, self, sizeof (ImportID));
	return dup;
}

void
import_id_free (ImportID* self)
{
	g_free (self);
}

static GType
import_id_get_type_once (void)
{
	GType import_id_type_id;
	import_id_type_id = g_boxed_type_register_static ("ImportID", (GBoxedCopyFunc) import_id_dup, (GBoxedFreeFunc) import_id_free);
	return import_id_type_id;
}

GType
import_id_get_type (void)
{
	static volatile gsize import_id_type_id__once = 0;
	if (g_once_init_enter (&import_id_type_id__once)) {
		GType import_id_type_id;
		import_id_type_id = import_id_get_type_once ();
		g_once_init_leave (&import_id_type_id__once, import_id_type_id);
	}
	return import_id_type_id__once;
}

PhotoRow*
photo_row_construct (GType object_type)
{
	PhotoRow* self = NULL;
	BackingPhotoRow* _tmp0_;
	gint _tmp1_ = 0;
	RawDeveloper* _tmp2_;
	RawDeveloper* _tmp3_;
	gint _tmp3__length1;
	BackingPhotoID* _tmp4_;
	gint _tmp5_ = 0;
	RawDeveloper* _tmp6_;
	self = (PhotoRow*) g_type_create_instance (object_type);
	_tmp0_ = backing_photo_row_new ();
	_backing_photo_row_unref0 (self->master);
	self->master = _tmp0_;
	backing_photo_id_init (&self->editable_id, BACKING_PHOTO_ID_INVALID);
	_tmp2_ = raw_developer_as_array (&_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	_tmp4_ = g_new0 (BackingPhotoID, _tmp1_);
	self->development_ids = (g_free (self->development_ids), NULL);
	self->development_ids = _tmp4_;
	self->development_ids_length1 = _tmp1_;
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp6_ = raw_developer_as_array (&_tmp5_);
	{
		RawDeveloper* d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
		d_collection = _tmp6_;
		d_collection_length1 = _tmp5_;
		for (d_it = 0; d_it < d_collection_length1; d_it = d_it + 1) {
			RawDeveloper d = 0;
			d = d_collection[d_it];
			{
				BackingPhotoID* _tmp7_;
				gint _tmp7__length1;
				BackingPhotoID _tmp8_ = {0};
				_tmp7_ = self->development_ids;
				_tmp7__length1 = self->development_ids_length1;
				backing_photo_id_init (&_tmp8_, BACKING_PHOTO_ID_INVALID);
				_tmp7_[d] = _tmp8_;
			}
		}
		d_collection = (g_free (d_collection), NULL);
	}
	return self;
}

PhotoRow*
photo_row_new (void)
{
	return photo_row_construct (TYPE_PHOTO_ROW);
}

static void
value_photo_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_photo_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_row_unref (value->data[0].v_pointer);
	}
}

static void
value_photo_row_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_photo_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_photo_row_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_photo_row_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	PhotoRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_photo_row (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecPhotoRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_photo_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_ROW), NULL);
	return value->data[0].v_pointer;
}

void
value_set_photo_row (GValue* value,
                     gpointer v_object)
{
	PhotoRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_row_unref (old);
	}
}

void
value_take_photo_row (GValue* value,
                      gpointer v_object)
{
	PhotoRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_row_unref (old);
	}
}

static void
photo_row_class_init (PhotoRowClass * klass,
                      gpointer klass_data)
{
	photo_row_parent_class = g_type_class_peek_parent (klass);
	((PhotoRowClass *) klass)->finalize = photo_row_finalize;
}

static void
photo_row_instance_init (PhotoRow * self,
                         gpointer klass)
{
	self->ref_count = 1;
}

static void
photo_row_finalize (PhotoRow * obj)
{
	PhotoRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_ROW, PhotoRow);
	g_signal_handlers_destroy (self);
	_backing_photo_row_unref0 (self->master);
	_g_object_unref0 (self->transformations);
	_g_free0 (self->md5);
	_g_free0 (self->thumbnail_md5);
	_g_free0 (self->exif_md5);
	_g_free0 (self->title);
	_g_free0 (self->comment);
	_g_free0 (self->backlinks);
	_g_object_unref0 (self->original_transforms);
	self->development_ids = (g_free (self->development_ids), NULL);
}

static GType
photo_row_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_photo_row_init, value_photo_row_free_value, value_photo_row_copy_value, value_photo_row_peek_pointer, "p", value_photo_row_collect_value, "p", value_photo_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoRow), 0, (GInstanceInitFunc) photo_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_row_type_id;
	photo_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return photo_row_type_id;
}

GType
photo_row_get_type (void)
{
	static volatile gsize photo_row_type_id__once = 0;
	if (g_once_init_enter (&photo_row_type_id__once)) {
		GType photo_row_type_id;
		photo_row_type_id = photo_row_get_type_once ();
		g_once_init_leave (&photo_row_type_id__once, photo_row_type_id);
	}
	return photo_row_type_id__once;
}

gpointer
photo_row_ref (gpointer instance)
{
	PhotoRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_row_unref (gpointer instance)
{
	PhotoRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static PhotoTable*
photo_table_construct (GType object_type)
{
	PhotoTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	self = (PhotoTable*) database_table_construct (object_type);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE TABLE IF NOT EXISTS PhotoTable (" "id INTEGER PRIMARY KEY, " "filename TEXT UNIQUE NOT NULL, " "width INTEGER, " "height INTEGER, " "filesize INTEGER, " "timestamp INTEGER, " "exposure_time INTEGER, " "orientation INTEGER, " "original_orientation INTEGER, " "import_id INTEGER, " "event_id INTEGER, " "transformations TEXT, " "md5 TEXT, " "thumbnail_md5 TEXT, " "exif_md5 TEXT, " "time_created INTEGER, " "flags INTEGER DEFAULT 0, " "file_format INTEGER DEFAULT 0, " "title TEXT, " "backlinks TEXT, " "time_reimported INTEGER, " "editable_id INTEGER DEFAULT -1, " "metadata_dirty INTEGER DEFAULT 0, " "developer TEXT, " "develop_shotwell_id INTEGER DEFAULT -1, " "develop_camera_id INTEGER DEFAULT -1, " "develop_embedded_id INTEGER DEFAULT -1, " "comment TEXT, " "enhanced INTEGER DEFAULT 0, " "original_transforms TEXT " ")");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	res = sqlite3_step (_tmp1_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create photo table", res);
	}
	_tmp2_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE INDEX IF NOT EXISTS PhotoEventIDIndex ON PhotoTable (event_id)");
	_sqlite3_finalize0 (stmt);
	stmt = _tmp2_;
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create photo table", res);
	}
	database_table_set_table_name ((DatabaseTable*) self, "PhotoTable");
	_sqlite3_finalize0 (stmt);
	return self;
}

static PhotoTable*
photo_table_new (void)
{
	return photo_table_construct (TYPE_PHOTO_TABLE);
}

static gpointer
_database_table_ref0 (gpointer self)
{
	return self ? database_table_ref (self) : NULL;
}

PhotoTable*
photo_table_get_instance (void)
{
	PhotoTable* _tmp0_;
	PhotoTable* _tmp2_;
	PhotoTable* _tmp3_;
	PhotoTable* result;
	_tmp0_ = photo_table_instance;
	if (_tmp0_ == NULL) {
		PhotoTable* _tmp1_;
		_tmp1_ = photo_table_new ();
		_database_table_unref0 (photo_table_instance);
		photo_table_instance = _tmp1_;
	}
	_tmp2_ = photo_table_instance;
	_tmp3_ = _database_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

void
photo_table_add (PhotoTable* self,
                 PhotoRow* photo_row,
                 PhotoID* result)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint64 time_created = 0LL;
	sqlite3_stmt* _tmp1_;
	BackingPhotoRow* _tmp2_;
	const gchar* _tmp3_;
	sqlite3_stmt* _tmp4_;
	BackingPhotoRow* _tmp5_;
	Dimensions _tmp6_;
	sqlite3_stmt* _tmp7_;
	BackingPhotoRow* _tmp8_;
	Dimensions _tmp9_;
	sqlite3_stmt* _tmp10_;
	BackingPhotoRow* _tmp11_;
	sqlite3_stmt* _tmp12_;
	BackingPhotoRow* _tmp13_;
	sqlite3_stmt* _tmp14_;
	sqlite3_stmt* _tmp15_;
	BackingPhotoRow* _tmp16_;
	sqlite3_stmt* _tmp17_;
	BackingPhotoRow* _tmp18_;
	sqlite3_stmt* _tmp19_;
	ImportID _tmp20_;
	sqlite3_stmt* _tmp21_;
	sqlite3_stmt* _tmp22_;
	const gchar* _tmp23_;
	sqlite3_stmt* _tmp24_;
	const gchar* _tmp25_;
	sqlite3_stmt* _tmp26_;
	const gchar* _tmp27_;
	sqlite3_stmt* _tmp28_;
	sqlite3_stmt* _tmp29_;
	BackingPhotoRow* _tmp30_;
	sqlite3_stmt* _tmp31_;
	const gchar* _tmp32_;
	sqlite3_stmt* _tmp33_;
	sqlite3_stmt* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	sqlite3_stmt* _tmp37_;
	const gchar* _tmp38_;
	gint res = 0;
	sqlite3_stmt* _tmp39_;
	sqlite3* _tmp41_;
	BackingPhotoRow* _tmp42_;
	PhotoID _tmp43_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo_row != NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "INSERT INTO PhotoTable (filename, width, height, filesize, timestamp, " \
"exposure_time, " "orientation, original_orientation, import_id, event_id, md5, thumbnail" \
"_md5, " "exif_md5, time_created, file_format, title, editable_id, developer, co" \
"mment) " "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
	stmt = _tmp0_;
	time_created = now_sec ();
	_tmp1_ = stmt;
	_tmp2_ = photo_row->master;
	_tmp3_ = _tmp2_->filepath;
	database_table_bind_text (_tmp1_, 1, _tmp3_);
	_tmp4_ = stmt;
	_tmp5_ = photo_row->master;
	_tmp6_ = _tmp5_->dim;
	database_table_bind_int (_tmp4_, 2, _tmp6_.width);
	_tmp7_ = stmt;
	_tmp8_ = photo_row->master;
	_tmp9_ = _tmp8_->dim;
	database_table_bind_int (_tmp7_, 3, _tmp9_.height);
	_tmp10_ = stmt;
	_tmp11_ = photo_row->master;
	database_table_bind_int64 (_tmp10_, 4, _tmp11_->filesize);
	_tmp12_ = stmt;
	_tmp13_ = photo_row->master;
	database_table_bind_int64 (_tmp12_, 5, _tmp13_->timestamp);
	_tmp14_ = stmt;
	database_table_bind_int64 (_tmp14_, 6, photo_row->exposure_time);
	_tmp15_ = stmt;
	_tmp16_ = photo_row->master;
	database_table_bind_int (_tmp15_, 7, (gint) _tmp16_->original_orientation);
	_tmp17_ = stmt;
	_tmp18_ = photo_row->master;
	database_table_bind_int (_tmp17_, 8, (gint) _tmp18_->original_orientation);
	_tmp19_ = stmt;
	_tmp20_ = photo_row->import_id;
	database_table_bind_int64 (_tmp19_, 9, _tmp20_.id);
	_tmp21_ = stmt;
	database_table_bind_int64 (_tmp21_, 10, EVENT_ID_INVALID);
	_tmp22_ = stmt;
	_tmp23_ = photo_row->md5;
	database_table_bind_text (_tmp22_, 11, _tmp23_);
	_tmp24_ = stmt;
	_tmp25_ = photo_row->thumbnail_md5;
	database_table_bind_text (_tmp24_, 12, _tmp25_);
	_tmp26_ = stmt;
	_tmp27_ = photo_row->exif_md5;
	database_table_bind_text (_tmp26_, 13, _tmp27_);
	_tmp28_ = stmt;
	database_table_bind_int64 (_tmp28_, 14, time_created);
	_tmp29_ = stmt;
	_tmp30_ = photo_row->master;
	database_table_bind_int (_tmp29_, 15, photo_file_format_serialize (_tmp30_->file_format));
	_tmp31_ = stmt;
	_tmp32_ = photo_row->title;
	database_table_bind_text (_tmp31_, 16, _tmp32_);
	_tmp33_ = stmt;
	database_table_bind_int64 (_tmp33_, 17, BACKING_PHOTO_ID_INVALID);
	_tmp34_ = stmt;
	_tmp35_ = raw_developer_to_string (photo_row->developer);
	_tmp36_ = _tmp35_;
	database_table_bind_text (_tmp34_, 18, _tmp36_);
	_g_free0 (_tmp36_);
	_tmp37_ = stmt;
	_tmp38_ = photo_row->comment;
	database_table_bind_text (_tmp37_, 19, _tmp38_);
	_tmp39_ = stmt;
	res = sqlite3_step (_tmp39_);
	if (res != SQLITE_DONE) {
		PhotoID _tmp40_ = {0};
		if (res != SQLITE_CONSTRAINT) {
			database_table_fatal ("add_photo", res);
		}
		photo_id_init (&_tmp40_, PHOTO_ID_INVALID);
		*result = _tmp40_;
		_sqlite3_finalize0 (stmt);
		return;
	}
	_tmp41_ = database_table_db;
	photo_id_init (&photo_row->photo_id, sqlite3_last_insert_rowid (_tmp41_));
	_tmp42_ = photo_row->master;
	photo_row->orientation = _tmp42_->original_orientation;
	event_id_init (&photo_row->event_id, EVENT_ID_INVALID);
	photo_row->time_created = time_created;
	photo_row->flags = (guint64) 0;
	_tmp43_ = photo_row->photo_id;
	*result = _tmp43_;
	_sqlite3_finalize0 (stmt);
	return;
}

void
photo_table_reimport (PhotoTable* self,
                      PhotoRow* row,
                      GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint64 time_reimported = 0LL;
	sqlite3_stmt* _tmp1_;
	BackingPhotoRow* _tmp2_;
	Dimensions _tmp3_;
	sqlite3_stmt* _tmp4_;
	BackingPhotoRow* _tmp5_;
	Dimensions _tmp6_;
	sqlite3_stmt* _tmp7_;
	BackingPhotoRow* _tmp8_;
	sqlite3_stmt* _tmp9_;
	BackingPhotoRow* _tmp10_;
	sqlite3_stmt* _tmp11_;
	sqlite3_stmt* _tmp12_;
	BackingPhotoRow* _tmp13_;
	sqlite3_stmt* _tmp14_;
	BackingPhotoRow* _tmp15_;
	sqlite3_stmt* _tmp16_;
	const gchar* _tmp17_;
	sqlite3_stmt* _tmp18_;
	const gchar* _tmp19_;
	sqlite3_stmt* _tmp20_;
	const gchar* _tmp21_;
	sqlite3_stmt* _tmp22_;
	BackingPhotoRow* _tmp23_;
	sqlite3_stmt* _tmp24_;
	const gchar* _tmp25_;
	sqlite3_stmt* _tmp26_;
	sqlite3_stmt* _tmp27_;
	PhotoID _tmp28_;
	gint res = 0;
	sqlite3_stmt* _tmp29_;
	BackingPhotoRow* _tmp30_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "UPDATE PhotoTable SET width = ?, height = ?, filesize = ?, timestamp =" \
" ?, " "exposure_time = ?, orientation = ?, original_orientation = ?, md5 = ?," \
" " "exif_md5 = ?, thumbnail_md5 = ?, file_format = ?, title = ?, time_reim" \
"ported = ? " "WHERE id = ?");
	stmt = _tmp0_;
	time_reimported = now_sec ();
	_tmp1_ = stmt;
	_tmp2_ = row->master;
	_tmp3_ = _tmp2_->dim;
	database_table_bind_int (_tmp1_, 1, _tmp3_.width);
	_tmp4_ = stmt;
	_tmp5_ = row->master;
	_tmp6_ = _tmp5_->dim;
	database_table_bind_int (_tmp4_, 2, _tmp6_.height);
	_tmp7_ = stmt;
	_tmp8_ = row->master;
	database_table_bind_int64 (_tmp7_, 3, _tmp8_->filesize);
	_tmp9_ = stmt;
	_tmp10_ = row->master;
	database_table_bind_int64 (_tmp9_, 4, _tmp10_->timestamp);
	_tmp11_ = stmt;
	database_table_bind_int64 (_tmp11_, 5, row->exposure_time);
	_tmp12_ = stmt;
	_tmp13_ = row->master;
	database_table_bind_int (_tmp12_, 6, (gint) _tmp13_->original_orientation);
	_tmp14_ = stmt;
	_tmp15_ = row->master;
	database_table_bind_int (_tmp14_, 7, (gint) _tmp15_->original_orientation);
	_tmp16_ = stmt;
	_tmp17_ = row->md5;
	database_table_bind_text (_tmp16_, 8, _tmp17_);
	_tmp18_ = stmt;
	_tmp19_ = row->exif_md5;
	database_table_bind_text (_tmp18_, 9, _tmp19_);
	_tmp20_ = stmt;
	_tmp21_ = row->thumbnail_md5;
	database_table_bind_text (_tmp20_, 10, _tmp21_);
	_tmp22_ = stmt;
	_tmp23_ = row->master;
	database_table_bind_int (_tmp22_, 11, photo_file_format_serialize (_tmp23_->file_format));
	_tmp24_ = stmt;
	_tmp25_ = row->title;
	database_table_bind_text (_tmp24_, 12, _tmp25_);
	_tmp26_ = stmt;
	database_table_bind_int64 (_tmp26_, 13, time_reimported);
	_tmp27_ = stmt;
	_tmp28_ = row->photo_id;
	database_table_bind_int64 (_tmp27_, 14, _tmp28_.id);
	_tmp29_ = stmt;
	res = sqlite3_step (_tmp29_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("PhotoTable.reimport_master", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	row->time_reimported = time_reimported;
	_tmp30_ = row->master;
	row->orientation = _tmp30_->original_orientation;
	_sqlite3_finalize0 (stmt);
}

gboolean
photo_table_master_exif_updated (PhotoTable* self,
                                 PhotoID* photo_id,
                                 gint64 filesize,
                                 gint64 timestamp,
                                 const gchar* md5,
                                 const gchar* exif_md5,
                                 const gchar* thumbnail_md5,
                                 PhotoRow* row)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	sqlite3_stmt* _tmp5_;
	sqlite3_stmt* _tmp6_;
	PhotoID _tmp7_;
	gint res = 0;
	sqlite3_stmt* _tmp8_;
	BackingPhotoRow* _tmp9_;
	BackingPhotoRow* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	g_return_val_if_fail (md5 != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "UPDATE PhotoTable SET filesize = ?, timestamp = ?, md5 = ?, exif_md5 =" \
" ?," "thumbnail_md5 =? WHERE id = ?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	database_table_bind_int64 (_tmp1_, 1, filesize);
	_tmp2_ = stmt;
	database_table_bind_int64 (_tmp2_, 2, timestamp);
	_tmp3_ = stmt;
	database_table_bind_text (_tmp3_, 3, md5);
	_tmp4_ = stmt;
	database_table_bind_text (_tmp4_, 4, exif_md5);
	_tmp5_ = stmt;
	database_table_bind_text (_tmp5_, 5, thumbnail_md5);
	_tmp6_ = stmt;
	_tmp7_ = *photo_id;
	database_table_bind_int64 (_tmp6_, 6, _tmp7_.id);
	_tmp8_ = stmt;
	res = sqlite3_step (_tmp8_);
	if (res != SQLITE_DONE) {
		if (res != SQLITE_CONSTRAINT) {
			database_table_fatal ("write_update_photo", res);
		}
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp9_ = row->master;
	_tmp9_->filesize = filesize;
	_tmp10_ = row->master;
	_tmp10_->timestamp = timestamp;
	_tmp11_ = g_strdup (md5);
	_g_free0 (row->md5);
	row->md5 = _tmp11_;
	_tmp12_ = g_strdup (exif_md5);
	_g_free0 (row->exif_md5);
	row->exif_md5 = _tmp12_;
	_tmp13_ = g_strdup (thumbnail_md5);
	_g_free0 (row->thumbnail_md5);
	row->thumbnail_md5 = _tmp13_;
	result = TRUE;
	_sqlite3_finalize0 (stmt);
	return result;
}

static void
photo_table_validate_orientation (PhotoTable* self,
                                  PhotoRow* row)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	if (row->orientation < ORIENTATION_MIN) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = row->orientation > ORIENTATION_MAX;
	}
	if (_tmp0_) {
		PhotoID _tmp1_;
		_tmp1_ = row->photo_id;
		photo_table_set_orientation (self, &_tmp1_, ORIENTATION_MIN);
		row->orientation = ORIENTATION_MIN;
	}
}

PhotoRow*
photo_table_get_row (PhotoTable* self,
                     PhotoID* photo_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	PhotoID _tmp2_;
	sqlite3_stmt* _tmp3_;
	PhotoRow* row = NULL;
	PhotoRow* _tmp4_;
	PhotoRow* _tmp5_;
	PhotoID _tmp6_;
	PhotoRow* _tmp7_;
	BackingPhotoRow* _tmp8_;
	sqlite3_stmt* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	PhotoRow* _tmp12_;
	BackingPhotoRow* _tmp13_;
	sqlite3_stmt* _tmp14_;
	sqlite3_stmt* _tmp15_;
	PhotoRow* _tmp16_;
	BackingPhotoRow* _tmp17_;
	sqlite3_stmt* _tmp18_;
	PhotoRow* _tmp19_;
	BackingPhotoRow* _tmp20_;
	sqlite3_stmt* _tmp21_;
	PhotoRow* _tmp22_;
	sqlite3_stmt* _tmp23_;
	PhotoRow* _tmp24_;
	sqlite3_stmt* _tmp25_;
	PhotoRow* _tmp26_;
	BackingPhotoRow* _tmp27_;
	sqlite3_stmt* _tmp28_;
	PhotoRow* _tmp29_;
	sqlite3_stmt* _tmp30_;
	PhotoRow* _tmp31_;
	sqlite3_stmt* _tmp32_;
	PhotoRow* _tmp33_;
	sqlite3_stmt* _tmp34_;
	const gchar* _tmp35_;
	GeeHashMap* _tmp36_;
	PhotoRow* _tmp37_;
	sqlite3_stmt* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	PhotoRow* _tmp41_;
	sqlite3_stmt* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	PhotoRow* _tmp45_;
	sqlite3_stmt* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	PhotoRow* _tmp49_;
	sqlite3_stmt* _tmp50_;
	PhotoRow* _tmp51_;
	sqlite3_stmt* _tmp52_;
	PhotoRow* _tmp53_;
	BackingPhotoRow* _tmp54_;
	sqlite3_stmt* _tmp55_;
	PhotoRow* _tmp56_;
	sqlite3_stmt* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	PhotoRow* _tmp60_;
	sqlite3_stmt* _tmp61_;
	const gchar* _tmp62_;
	gchar* _tmp63_;
	PhotoRow* _tmp64_;
	sqlite3_stmt* _tmp65_;
	PhotoRow* _tmp66_;
	sqlite3_stmt* _tmp67_;
	PhotoRow* _tmp68_;
	sqlite3_stmt* _tmp69_;
	RawDeveloper _tmp70_ = 0;
	sqlite3_stmt* _tmp71_;
	const gchar* _tmp72_;
	PhotoRow* _tmp75_;
	PhotoRow* _tmp76_;
	BackingPhotoID* _tmp77_;
	gint _tmp77__length1;
	sqlite3_stmt* _tmp78_;
	BackingPhotoID _tmp79_ = {0};
	PhotoRow* _tmp80_;
	BackingPhotoID* _tmp81_;
	gint _tmp81__length1;
	sqlite3_stmt* _tmp82_;
	BackingPhotoID _tmp83_ = {0};
	PhotoRow* _tmp84_;
	BackingPhotoID* _tmp85_;
	gint _tmp85__length1;
	sqlite3_stmt* _tmp86_;
	BackingPhotoID _tmp87_ = {0};
	PhotoRow* _tmp88_;
	sqlite3_stmt* _tmp89_;
	const gchar* _tmp90_;
	gchar* _tmp91_;
	PhotoRow* _tmp92_;
	sqlite3_stmt* _tmp93_;
	PhotoRow* _tmp94_;
	sqlite3_stmt* _tmp95_;
	const gchar* _tmp96_;
	GeeHashMap* _tmp97_;
	PhotoRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (photo_id != NULL, NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT filename, width, height, filesize, timestamp, exposure_time, or" \
"ientation, " "original_orientation, import_id, event_id, transformations, md5, thumb" \
"nail_md5, " "exif_md5, time_created, flags, file_format, title, backlinks, " "time_reimported, editable_id, metadata_dirty, developer, develop_shotw" \
"ell_id, " "develop_camera_id, develop_embedded_id, comment, enhanced, original_tr" \
"ansforms " "FROM PhotoTable WHERE id=?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = *photo_id;
	database_table_bind_int64 (_tmp1_, 1, _tmp2_.id);
	_tmp3_ = stmt;
	if (sqlite3_step (_tmp3_) != SQLITE_ROW) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp4_ = photo_row_new ();
	row = _tmp4_;
	_tmp5_ = row;
	_tmp6_ = *photo_id;
	_tmp5_->photo_id = _tmp6_;
	_tmp7_ = row;
	_tmp8_ = _tmp7_->master;
	_tmp9_ = stmt;
	_tmp10_ = (const gchar*) sqlite3_column_text (_tmp9_, 0);
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (_tmp8_->filepath);
	_tmp8_->filepath = _tmp11_;
	_tmp12_ = row;
	_tmp13_ = _tmp12_->master;
	_tmp14_ = stmt;
	_tmp15_ = stmt;
	dimensions_init (&_tmp13_->dim, sqlite3_column_int (_tmp14_, 1), sqlite3_column_int (_tmp15_, 2));
	_tmp16_ = row;
	_tmp17_ = _tmp16_->master;
	_tmp18_ = stmt;
	_tmp17_->filesize = sqlite3_column_int64 (_tmp18_, 3);
	_tmp19_ = row;
	_tmp20_ = _tmp19_->master;
	_tmp21_ = stmt;
	_tmp20_->timestamp = sqlite3_column_int64 (_tmp21_, 4);
	_tmp22_ = row;
	_tmp23_ = stmt;
	_tmp22_->exposure_time = sqlite3_column_int64 (_tmp23_, 5);
	_tmp24_ = row;
	_tmp25_ = stmt;
	_tmp24_->orientation = (Orientation) sqlite3_column_int (_tmp25_, 6);
	_tmp26_ = row;
	_tmp27_ = _tmp26_->master;
	_tmp28_ = stmt;
	_tmp27_->original_orientation = (Orientation) sqlite3_column_int (_tmp28_, 7);
	_tmp29_ = row;
	_tmp30_ = stmt;
	_tmp29_->import_id.id = sqlite3_column_int64 (_tmp30_, 8);
	_tmp31_ = row;
	_tmp32_ = stmt;
	_tmp31_->event_id.id = sqlite3_column_int64 (_tmp32_, 9);
	_tmp33_ = row;
	_tmp34_ = stmt;
	_tmp35_ = (const gchar*) sqlite3_column_text (_tmp34_, 10);
	_tmp36_ = photo_table_marshall_all_transformations (_tmp35_);
	_g_object_unref0 (_tmp33_->transformations);
	_tmp33_->transformations = _tmp36_;
	_tmp37_ = row;
	_tmp38_ = stmt;
	_tmp39_ = (const gchar*) sqlite3_column_text (_tmp38_, 11);
	_tmp40_ = g_strdup (_tmp39_);
	_g_free0 (_tmp37_->md5);
	_tmp37_->md5 = _tmp40_;
	_tmp41_ = row;
	_tmp42_ = stmt;
	_tmp43_ = (const gchar*) sqlite3_column_text (_tmp42_, 12);
	_tmp44_ = g_strdup (_tmp43_);
	_g_free0 (_tmp41_->thumbnail_md5);
	_tmp41_->thumbnail_md5 = _tmp44_;
	_tmp45_ = row;
	_tmp46_ = stmt;
	_tmp47_ = (const gchar*) sqlite3_column_text (_tmp46_, 13);
	_tmp48_ = g_strdup (_tmp47_);
	_g_free0 (_tmp45_->exif_md5);
	_tmp45_->exif_md5 = _tmp48_;
	_tmp49_ = row;
	_tmp50_ = stmt;
	_tmp49_->time_created = sqlite3_column_int64 (_tmp50_, 14);
	_tmp51_ = row;
	_tmp52_ = stmt;
	_tmp51_->flags = (guint64) sqlite3_column_int64 (_tmp52_, 15);
	_tmp53_ = row;
	_tmp54_ = _tmp53_->master;
	_tmp55_ = stmt;
	_tmp54_->file_format = photo_file_format_unserialize (sqlite3_column_int (_tmp55_, 16));
	_tmp56_ = row;
	_tmp57_ = stmt;
	_tmp58_ = (const gchar*) sqlite3_column_text (_tmp57_, 17);
	_tmp59_ = g_strdup (_tmp58_);
	_g_free0 (_tmp56_->title);
	_tmp56_->title = _tmp59_;
	_tmp60_ = row;
	_tmp61_ = stmt;
	_tmp62_ = (const gchar*) sqlite3_column_text (_tmp61_, 18);
	_tmp63_ = g_strdup (_tmp62_);
	_g_free0 (_tmp60_->backlinks);
	_tmp60_->backlinks = _tmp63_;
	_tmp64_ = row;
	_tmp65_ = stmt;
	_tmp64_->time_reimported = sqlite3_column_int64 (_tmp65_, 19);
	_tmp66_ = row;
	_tmp67_ = stmt;
	backing_photo_id_init (&_tmp66_->editable_id, sqlite3_column_int64 (_tmp67_, 20));
	_tmp68_ = row;
	_tmp69_ = stmt;
	_tmp68_->metadata_dirty = sqlite3_column_int (_tmp69_, 21) != 0;
	_tmp71_ = stmt;
	_tmp72_ = (const gchar*) sqlite3_column_text (_tmp71_, 22);
	if (_tmp72_ != NULL) {
		sqlite3_stmt* _tmp73_;
		const gchar* _tmp74_;
		_tmp73_ = stmt;
		_tmp74_ = (const gchar*) sqlite3_column_text (_tmp73_, 22);
		_tmp70_ = raw_developer_from_string (_tmp74_);
	} else {
		_tmp70_ = RAW_DEVELOPER_CAMERA;
	}
	_tmp75_ = row;
	_tmp75_->developer = _tmp70_;
	_tmp76_ = row;
	_tmp77_ = _tmp76_->development_ids;
	_tmp77__length1 = _tmp76_->development_ids_length1;
	_tmp78_ = stmt;
	backing_photo_id_init (&_tmp79_, sqlite3_column_int64 (_tmp78_, 23));
	_tmp77_[RAW_DEVELOPER_SHOTWELL] = _tmp79_;
	_tmp80_ = row;
	_tmp81_ = _tmp80_->development_ids;
	_tmp81__length1 = _tmp80_->development_ids_length1;
	_tmp82_ = stmt;
	backing_photo_id_init (&_tmp83_, sqlite3_column_int64 (_tmp82_, 24));
	_tmp81_[RAW_DEVELOPER_CAMERA] = _tmp83_;
	_tmp84_ = row;
	_tmp85_ = _tmp84_->development_ids;
	_tmp85__length1 = _tmp84_->development_ids_length1;
	_tmp86_ = stmt;
	backing_photo_id_init (&_tmp87_, sqlite3_column_int64 (_tmp86_, 25));
	_tmp85_[RAW_DEVELOPER_EMBEDDED] = _tmp87_;
	_tmp88_ = row;
	_tmp89_ = stmt;
	_tmp90_ = (const gchar*) sqlite3_column_text (_tmp89_, 26);
	_tmp91_ = g_strdup (_tmp90_);
	_g_free0 (_tmp88_->comment);
	_tmp88_->comment = _tmp91_;
	_tmp92_ = row;
	_tmp93_ = stmt;
	_tmp92_->enhanced = sqlite3_column_int (_tmp93_, 27) != 0;
	_tmp94_ = row;
	_tmp95_ = stmt;
	_tmp96_ = (const gchar*) sqlite3_column_text (_tmp95_, 28);
	_tmp97_ = photo_table_marshall_all_transformations (_tmp96_);
	_g_object_unref0 (_tmp94_->original_transforms);
	_tmp94_->original_transforms = _tmp97_;
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

GeeArrayList*
photo_table_get_all (PhotoTable* self)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	GeeArrayList* all = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT id, filename, width, height, filesize, timestamp, exposure_time" \
", orientation, " "original_orientation, import_id, event_id, transformations, md5, thumb" \
"nail_md5, " "exif_md5, time_created, flags, file_format, title, backlinks, time_rei" \
"mported, " "editable_id, metadata_dirty, developer, develop_shotwell_id, develop_c" \
"amera_id, " "develop_embedded_id, comment, enhanced, original_transforms FROM Photo" \
"Table");
	stmt = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_PHOTO_ROW, (GBoxedCopyFunc) photo_row_ref, (GDestroyNotify) photo_row_unref, NULL, NULL, NULL);
	all = _tmp1_;
	while (TRUE) {
		sqlite3_stmt* _tmp2_;
		PhotoRow* row = NULL;
		PhotoRow* _tmp3_;
		PhotoRow* _tmp4_;
		sqlite3_stmt* _tmp5_;
		PhotoRow* _tmp6_;
		BackingPhotoRow* _tmp7_;
		sqlite3_stmt* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		PhotoRow* _tmp11_;
		BackingPhotoRow* _tmp12_;
		sqlite3_stmt* _tmp13_;
		sqlite3_stmt* _tmp14_;
		PhotoRow* _tmp15_;
		BackingPhotoRow* _tmp16_;
		sqlite3_stmt* _tmp17_;
		PhotoRow* _tmp18_;
		BackingPhotoRow* _tmp19_;
		sqlite3_stmt* _tmp20_;
		PhotoRow* _tmp21_;
		sqlite3_stmt* _tmp22_;
		PhotoRow* _tmp23_;
		sqlite3_stmt* _tmp24_;
		PhotoRow* _tmp25_;
		BackingPhotoRow* _tmp26_;
		sqlite3_stmt* _tmp27_;
		PhotoRow* _tmp28_;
		sqlite3_stmt* _tmp29_;
		PhotoRow* _tmp30_;
		sqlite3_stmt* _tmp31_;
		PhotoRow* _tmp32_;
		sqlite3_stmt* _tmp33_;
		const gchar* _tmp34_;
		GeeHashMap* _tmp35_;
		PhotoRow* _tmp36_;
		sqlite3_stmt* _tmp37_;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		PhotoRow* _tmp40_;
		sqlite3_stmt* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		PhotoRow* _tmp44_;
		sqlite3_stmt* _tmp45_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		PhotoRow* _tmp48_;
		sqlite3_stmt* _tmp49_;
		PhotoRow* _tmp50_;
		sqlite3_stmt* _tmp51_;
		PhotoRow* _tmp52_;
		BackingPhotoRow* _tmp53_;
		sqlite3_stmt* _tmp54_;
		PhotoRow* _tmp55_;
		sqlite3_stmt* _tmp56_;
		const gchar* _tmp57_;
		gchar* _tmp58_;
		PhotoRow* _tmp59_;
		sqlite3_stmt* _tmp60_;
		const gchar* _tmp61_;
		gchar* _tmp62_;
		PhotoRow* _tmp63_;
		sqlite3_stmt* _tmp64_;
		PhotoRow* _tmp65_;
		sqlite3_stmt* _tmp66_;
		PhotoRow* _tmp67_;
		sqlite3_stmt* _tmp68_;
		RawDeveloper _tmp69_ = 0;
		sqlite3_stmt* _tmp70_;
		const gchar* _tmp71_;
		PhotoRow* _tmp74_;
		PhotoRow* _tmp75_;
		BackingPhotoID* _tmp76_;
		gint _tmp76__length1;
		sqlite3_stmt* _tmp77_;
		BackingPhotoID _tmp78_ = {0};
		PhotoRow* _tmp79_;
		BackingPhotoID* _tmp80_;
		gint _tmp80__length1;
		sqlite3_stmt* _tmp81_;
		BackingPhotoID _tmp82_ = {0};
		PhotoRow* _tmp83_;
		BackingPhotoID* _tmp84_;
		gint _tmp84__length1;
		sqlite3_stmt* _tmp85_;
		BackingPhotoID _tmp86_ = {0};
		PhotoRow* _tmp87_;
		sqlite3_stmt* _tmp88_;
		const gchar* _tmp89_;
		gchar* _tmp90_;
		PhotoRow* _tmp91_;
		sqlite3_stmt* _tmp92_;
		PhotoRow* _tmp93_;
		sqlite3_stmt* _tmp94_;
		const gchar* _tmp95_;
		GeeHashMap* _tmp96_;
		PhotoRow* _tmp97_;
		GeeArrayList* _tmp98_;
		PhotoRow* _tmp99_;
		_tmp2_ = stmt;
		if (!(sqlite3_step (_tmp2_) == SQLITE_ROW)) {
			break;
		}
		_tmp3_ = photo_row_new ();
		row = _tmp3_;
		_tmp4_ = row;
		_tmp5_ = stmt;
		_tmp4_->photo_id.id = sqlite3_column_int64 (_tmp5_, 0);
		_tmp6_ = row;
		_tmp7_ = _tmp6_->master;
		_tmp8_ = stmt;
		_tmp9_ = (const gchar*) sqlite3_column_text (_tmp8_, 1);
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (_tmp7_->filepath);
		_tmp7_->filepath = _tmp10_;
		_tmp11_ = row;
		_tmp12_ = _tmp11_->master;
		_tmp13_ = stmt;
		_tmp14_ = stmt;
		dimensions_init (&_tmp12_->dim, sqlite3_column_int (_tmp13_, 2), sqlite3_column_int (_tmp14_, 3));
		_tmp15_ = row;
		_tmp16_ = _tmp15_->master;
		_tmp17_ = stmt;
		_tmp16_->filesize = sqlite3_column_int64 (_tmp17_, 4);
		_tmp18_ = row;
		_tmp19_ = _tmp18_->master;
		_tmp20_ = stmt;
		_tmp19_->timestamp = sqlite3_column_int64 (_tmp20_, 5);
		_tmp21_ = row;
		_tmp22_ = stmt;
		_tmp21_->exposure_time = sqlite3_column_int64 (_tmp22_, 6);
		_tmp23_ = row;
		_tmp24_ = stmt;
		_tmp23_->orientation = (Orientation) sqlite3_column_int (_tmp24_, 7);
		_tmp25_ = row;
		_tmp26_ = _tmp25_->master;
		_tmp27_ = stmt;
		_tmp26_->original_orientation = (Orientation) sqlite3_column_int (_tmp27_, 8);
		_tmp28_ = row;
		_tmp29_ = stmt;
		_tmp28_->import_id.id = sqlite3_column_int64 (_tmp29_, 9);
		_tmp30_ = row;
		_tmp31_ = stmt;
		_tmp30_->event_id.id = sqlite3_column_int64 (_tmp31_, 10);
		_tmp32_ = row;
		_tmp33_ = stmt;
		_tmp34_ = (const gchar*) sqlite3_column_text (_tmp33_, 11);
		_tmp35_ = photo_table_marshall_all_transformations (_tmp34_);
		_g_object_unref0 (_tmp32_->transformations);
		_tmp32_->transformations = _tmp35_;
		_tmp36_ = row;
		_tmp37_ = stmt;
		_tmp38_ = (const gchar*) sqlite3_column_text (_tmp37_, 12);
		_tmp39_ = g_strdup (_tmp38_);
		_g_free0 (_tmp36_->md5);
		_tmp36_->md5 = _tmp39_;
		_tmp40_ = row;
		_tmp41_ = stmt;
		_tmp42_ = (const gchar*) sqlite3_column_text (_tmp41_, 13);
		_tmp43_ = g_strdup (_tmp42_);
		_g_free0 (_tmp40_->thumbnail_md5);
		_tmp40_->thumbnail_md5 = _tmp43_;
		_tmp44_ = row;
		_tmp45_ = stmt;
		_tmp46_ = (const gchar*) sqlite3_column_text (_tmp45_, 14);
		_tmp47_ = g_strdup (_tmp46_);
		_g_free0 (_tmp44_->exif_md5);
		_tmp44_->exif_md5 = _tmp47_;
		_tmp48_ = row;
		_tmp49_ = stmt;
		_tmp48_->time_created = sqlite3_column_int64 (_tmp49_, 15);
		_tmp50_ = row;
		_tmp51_ = stmt;
		_tmp50_->flags = (guint64) sqlite3_column_int64 (_tmp51_, 16);
		_tmp52_ = row;
		_tmp53_ = _tmp52_->master;
		_tmp54_ = stmt;
		_tmp53_->file_format = photo_file_format_unserialize (sqlite3_column_int (_tmp54_, 17));
		_tmp55_ = row;
		_tmp56_ = stmt;
		_tmp57_ = (const gchar*) sqlite3_column_text (_tmp56_, 18);
		_tmp58_ = g_strdup (_tmp57_);
		_g_free0 (_tmp55_->title);
		_tmp55_->title = _tmp58_;
		_tmp59_ = row;
		_tmp60_ = stmt;
		_tmp61_ = (const gchar*) sqlite3_column_text (_tmp60_, 19);
		_tmp62_ = g_strdup (_tmp61_);
		_g_free0 (_tmp59_->backlinks);
		_tmp59_->backlinks = _tmp62_;
		_tmp63_ = row;
		_tmp64_ = stmt;
		_tmp63_->time_reimported = sqlite3_column_int64 (_tmp64_, 20);
		_tmp65_ = row;
		_tmp66_ = stmt;
		backing_photo_id_init (&_tmp65_->editable_id, sqlite3_column_int64 (_tmp66_, 21));
		_tmp67_ = row;
		_tmp68_ = stmt;
		_tmp67_->metadata_dirty = sqlite3_column_int (_tmp68_, 22) != 0;
		_tmp70_ = stmt;
		_tmp71_ = (const gchar*) sqlite3_column_text (_tmp70_, 23);
		if (_tmp71_ != NULL) {
			sqlite3_stmt* _tmp72_;
			const gchar* _tmp73_;
			_tmp72_ = stmt;
			_tmp73_ = (const gchar*) sqlite3_column_text (_tmp72_, 23);
			_tmp69_ = raw_developer_from_string (_tmp73_);
		} else {
			_tmp69_ = RAW_DEVELOPER_CAMERA;
		}
		_tmp74_ = row;
		_tmp74_->developer = _tmp69_;
		_tmp75_ = row;
		_tmp76_ = _tmp75_->development_ids;
		_tmp76__length1 = _tmp75_->development_ids_length1;
		_tmp77_ = stmt;
		backing_photo_id_init (&_tmp78_, sqlite3_column_int64 (_tmp77_, 24));
		_tmp76_[RAW_DEVELOPER_SHOTWELL] = _tmp78_;
		_tmp79_ = row;
		_tmp80_ = _tmp79_->development_ids;
		_tmp80__length1 = _tmp79_->development_ids_length1;
		_tmp81_ = stmt;
		backing_photo_id_init (&_tmp82_, sqlite3_column_int64 (_tmp81_, 25));
		_tmp80_[RAW_DEVELOPER_CAMERA] = _tmp82_;
		_tmp83_ = row;
		_tmp84_ = _tmp83_->development_ids;
		_tmp84__length1 = _tmp83_->development_ids_length1;
		_tmp85_ = stmt;
		backing_photo_id_init (&_tmp86_, sqlite3_column_int64 (_tmp85_, 26));
		_tmp84_[RAW_DEVELOPER_EMBEDDED] = _tmp86_;
		_tmp87_ = row;
		_tmp88_ = stmt;
		_tmp89_ = (const gchar*) sqlite3_column_text (_tmp88_, 27);
		_tmp90_ = g_strdup (_tmp89_);
		_g_free0 (_tmp87_->comment);
		_tmp87_->comment = _tmp90_;
		_tmp91_ = row;
		_tmp92_ = stmt;
		_tmp91_->enhanced = sqlite3_column_int (_tmp92_, 28) != 0;
		_tmp93_ = row;
		_tmp94_ = stmt;
		_tmp95_ = (const gchar*) sqlite3_column_text (_tmp94_, 29);
		_tmp96_ = photo_table_marshall_all_transformations (_tmp95_);
		_g_object_unref0 (_tmp93_->original_transforms);
		_tmp93_->original_transforms = _tmp96_;
		_tmp97_ = row;
		photo_table_validate_orientation (self, _tmp97_);
		_tmp98_ = all;
		_tmp99_ = row;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp98_, _tmp99_);
		_photo_row_unref0 (row);
	}
	result = all;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
photo_table_duplicate (PhotoTable* self,
                       PhotoID* photo_id,
                       const gchar* new_filename,
                       BackingPhotoID* editable_id,
                       BackingPhotoID* develop_shotwell,
                       BackingPhotoID* develop_camera_id,
                       BackingPhotoID* develop_embedded_id,
                       PhotoID* result)
{
	PhotoRow* original = NULL;
	PhotoID _tmp0_;
	PhotoRow* _tmp1_;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	PhotoRow* _tmp5_;
	BackingPhotoRow* _tmp6_;
	Dimensions _tmp7_;
	sqlite3_stmt* _tmp8_;
	PhotoRow* _tmp9_;
	BackingPhotoRow* _tmp10_;
	Dimensions _tmp11_;
	sqlite3_stmt* _tmp12_;
	PhotoRow* _tmp13_;
	BackingPhotoRow* _tmp14_;
	sqlite3_stmt* _tmp15_;
	PhotoRow* _tmp16_;
	BackingPhotoRow* _tmp17_;
	sqlite3_stmt* _tmp18_;
	PhotoRow* _tmp19_;
	sqlite3_stmt* _tmp20_;
	PhotoRow* _tmp21_;
	sqlite3_stmt* _tmp22_;
	PhotoRow* _tmp23_;
	BackingPhotoRow* _tmp24_;
	sqlite3_stmt* _tmp25_;
	PhotoRow* _tmp26_;
	ImportID _tmp27_;
	sqlite3_stmt* _tmp28_;
	PhotoRow* _tmp29_;
	EventID _tmp30_;
	sqlite3_stmt* _tmp31_;
	PhotoRow* _tmp32_;
	GeeHashMap* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	sqlite3_stmt* _tmp36_;
	PhotoRow* _tmp37_;
	const gchar* _tmp38_;
	sqlite3_stmt* _tmp39_;
	PhotoRow* _tmp40_;
	const gchar* _tmp41_;
	sqlite3_stmt* _tmp42_;
	PhotoRow* _tmp43_;
	const gchar* _tmp44_;
	sqlite3_stmt* _tmp45_;
	sqlite3_stmt* _tmp46_;
	PhotoRow* _tmp47_;
	sqlite3_stmt* _tmp48_;
	PhotoRow* _tmp49_;
	BackingPhotoRow* _tmp50_;
	sqlite3_stmt* _tmp51_;
	PhotoRow* _tmp52_;
	const gchar* _tmp53_;
	sqlite3_stmt* _tmp54_;
	BackingPhotoID _tmp55_;
	sqlite3_stmt* _tmp56_;
	PhotoRow* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	sqlite3_stmt* _tmp60_;
	BackingPhotoID _tmp61_;
	sqlite3_stmt* _tmp62_;
	BackingPhotoID _tmp63_;
	sqlite3_stmt* _tmp64_;
	BackingPhotoID _tmp65_;
	sqlite3_stmt* _tmp66_;
	PhotoRow* _tmp67_;
	const gchar* _tmp68_;
	gint _tmp69_ = 0;
	PhotoRow* _tmp70_;
	sqlite3_stmt* _tmp71_;
	sqlite3_stmt* _tmp72_;
	PhotoRow* _tmp73_;
	GeeHashMap* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gint res = 0;
	sqlite3_stmt* _tmp77_;
	sqlite3* _tmp79_;
	PhotoID _tmp80_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo_id != NULL);
	g_return_if_fail (new_filename != NULL);
	g_return_if_fail (editable_id != NULL);
	g_return_if_fail (develop_shotwell != NULL);
	g_return_if_fail (develop_camera_id != NULL);
	g_return_if_fail (develop_embedded_id != NULL);
	_tmp0_ = *photo_id;
	_tmp1_ = photo_table_get_row (self, &_tmp0_);
	original = _tmp1_;
	_tmp2_ = database_table_create_stmt ((DatabaseTable*) self, "INSERT INTO PhotoTable (filename, width, height, filesize, " "timestamp, exposure_time, orientation, original_orientation, import_id" \
", event_id, " "transformations, md5, thumbnail_md5, exif_md5, time_created, flags, " "file_format, title, editable_id, developer, develop_shotwell_id, devel" \
"op_camera_id, " "develop_embedded_id, comment, enhanced, original_transforms) " "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?," \
" ?, ?, ?, ?, ?)");
	stmt = _tmp2_;
	_tmp3_ = stmt;
	database_table_bind_text (_tmp3_, 1, new_filename);
	_tmp4_ = stmt;
	_tmp5_ = original;
	_tmp6_ = _tmp5_->master;
	_tmp7_ = _tmp6_->dim;
	database_table_bind_int (_tmp4_, 2, _tmp7_.width);
	_tmp8_ = stmt;
	_tmp9_ = original;
	_tmp10_ = _tmp9_->master;
	_tmp11_ = _tmp10_->dim;
	database_table_bind_int (_tmp8_, 3, _tmp11_.height);
	_tmp12_ = stmt;
	_tmp13_ = original;
	_tmp14_ = _tmp13_->master;
	database_table_bind_int64 (_tmp12_, 4, _tmp14_->filesize);
	_tmp15_ = stmt;
	_tmp16_ = original;
	_tmp17_ = _tmp16_->master;
	database_table_bind_int64 (_tmp15_, 5, _tmp17_->timestamp);
	_tmp18_ = stmt;
	_tmp19_ = original;
	database_table_bind_int64 (_tmp18_, 6, _tmp19_->exposure_time);
	_tmp20_ = stmt;
	_tmp21_ = original;
	database_table_bind_int (_tmp20_, 7, (gint) _tmp21_->orientation);
	_tmp22_ = stmt;
	_tmp23_ = original;
	_tmp24_ = _tmp23_->master;
	database_table_bind_int (_tmp22_, 8, (gint) _tmp24_->original_orientation);
	_tmp25_ = stmt;
	_tmp26_ = original;
	_tmp27_ = _tmp26_->import_id;
	database_table_bind_int64 (_tmp25_, 9, _tmp27_.id);
	_tmp28_ = stmt;
	_tmp29_ = original;
	_tmp30_ = _tmp29_->event_id;
	database_table_bind_int64 (_tmp28_, 10, _tmp30_.id);
	_tmp31_ = stmt;
	_tmp32_ = original;
	_tmp33_ = _tmp32_->transformations;
	_tmp34_ = photo_table_unmarshall_all_transformations (_tmp33_);
	_tmp35_ = _tmp34_;
	database_table_bind_text (_tmp31_, 11, _tmp35_);
	_g_free0 (_tmp35_);
	_tmp36_ = stmt;
	_tmp37_ = original;
	_tmp38_ = _tmp37_->md5;
	database_table_bind_text (_tmp36_, 12, _tmp38_);
	_tmp39_ = stmt;
	_tmp40_ = original;
	_tmp41_ = _tmp40_->thumbnail_md5;
	database_table_bind_text (_tmp39_, 13, _tmp41_);
	_tmp42_ = stmt;
	_tmp43_ = original;
	_tmp44_ = _tmp43_->exif_md5;
	database_table_bind_text (_tmp42_, 14, _tmp44_);
	_tmp45_ = stmt;
	database_table_bind_int64 (_tmp45_, 15, now_sec ());
	_tmp46_ = stmt;
	_tmp47_ = original;
	database_table_bind_int64 (_tmp46_, 16, (gint64) _tmp47_->flags);
	_tmp48_ = stmt;
	_tmp49_ = original;
	_tmp50_ = _tmp49_->master;
	database_table_bind_int (_tmp48_, 17, photo_file_format_serialize (_tmp50_->file_format));
	_tmp51_ = stmt;
	_tmp52_ = original;
	_tmp53_ = _tmp52_->title;
	database_table_bind_text (_tmp51_, 18, _tmp53_);
	_tmp54_ = stmt;
	_tmp55_ = *editable_id;
	database_table_bind_int64 (_tmp54_, 19, _tmp55_.id);
	_tmp56_ = stmt;
	_tmp57_ = original;
	_tmp58_ = raw_developer_to_string (_tmp57_->developer);
	_tmp59_ = _tmp58_;
	database_table_bind_text (_tmp56_, 20, _tmp59_);
	_g_free0 (_tmp59_);
	_tmp60_ = stmt;
	_tmp61_ = *develop_shotwell;
	database_table_bind_int64 (_tmp60_, 21, _tmp61_.id);
	_tmp62_ = stmt;
	_tmp63_ = *develop_camera_id;
	database_table_bind_int64 (_tmp62_, 22, _tmp63_.id);
	_tmp64_ = stmt;
	_tmp65_ = *develop_embedded_id;
	database_table_bind_int64 (_tmp64_, 23, _tmp65_.id);
	_tmp66_ = stmt;
	_tmp67_ = original;
	_tmp68_ = _tmp67_->comment;
	database_table_bind_text (_tmp66_, 24, _tmp68_);
	_tmp70_ = original;
	if (_tmp70_->enhanced) {
		_tmp69_ = 1;
	} else {
		_tmp69_ = 0;
	}
	_tmp71_ = stmt;
	database_table_bind_int (_tmp71_, 25, _tmp69_);
	_tmp72_ = stmt;
	_tmp73_ = original;
	_tmp74_ = _tmp73_->original_transforms;
	_tmp75_ = photo_table_unmarshall_all_transformations (_tmp74_);
	_tmp76_ = _tmp75_;
	database_table_bind_text (_tmp72_, 26, _tmp76_);
	_g_free0 (_tmp76_);
	_tmp77_ = stmt;
	res = sqlite3_step (_tmp77_);
	if (res != SQLITE_DONE) {
		PhotoID _tmp78_ = {0};
		if (res != SQLITE_CONSTRAINT) {
			database_table_fatal ("duplicate", res);
		}
		photo_id_init (&_tmp78_, PHOTO_ID_INVALID);
		*result = _tmp78_;
		_sqlite3_finalize0 (stmt);
		_photo_row_unref0 (original);
		return;
	}
	_tmp79_ = database_table_db;
	photo_id_init (&_tmp80_, sqlite3_last_insert_rowid (_tmp79_));
	*result = _tmp80_;
	_sqlite3_finalize0 (stmt);
	_photo_row_unref0 (original);
	return;
}

gboolean
photo_table_set_title (PhotoTable* self,
                       PhotoID* photo_id,
                       const gchar* new_title)
{
	const gchar* _tmp0_ = NULL;
	PhotoID _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	if (new_title != NULL) {
		_tmp0_ = new_title;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = *photo_id;
	result = database_table_update_text_by_id ((DatabaseTable*) self, _tmp1_.id, "title", _tmp0_);
	return result;
}

gboolean
photo_table_set_comment (PhotoTable* self,
                         PhotoID* photo_id,
                         const gchar* new_comment)
{
	const gchar* _tmp0_ = NULL;
	PhotoID _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	if (new_comment != NULL) {
		_tmp0_ = new_comment;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = *photo_id;
	result = database_table_update_text_by_id ((DatabaseTable*) self, _tmp1_.id, "comment", _tmp0_);
	return result;
}

void
photo_table_set_filepath (PhotoTable* self,
                          PhotoID* photo_id,
                          const gchar* filepath,
                          GError** error)
{
	PhotoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo_id != NULL);
	g_return_if_fail (filepath != NULL);
	_tmp0_ = *photo_id;
	database_table_update_text_by_id_2 ((DatabaseTable*) self, _tmp0_.id, "filename", filepath, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
photo_table_update_timestamp (PhotoTable* self,
                              PhotoID* photo_id,
                              gint64 timestamp,
                              GError** error)
{
	PhotoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo_id != NULL);
	_tmp0_ = *photo_id;
	database_table_update_int64_by_id_2 ((DatabaseTable*) self, _tmp0_.id, "timestamp", timestamp, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

gboolean
photo_table_set_exposure_time (PhotoTable* self,
                               PhotoID* photo_id,
                               gint64 time)
{
	PhotoID _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	_tmp0_ = *photo_id;
	result = database_table_update_int64_by_id ((DatabaseTable*) self, _tmp0_.id, "exposure_time", time);
	return result;
}

void
photo_table_set_import_id (PhotoTable* self,
                           PhotoID* photo_id,
                           ImportID* import_id,
                           GError** error)
{
	PhotoID _tmp0_;
	ImportID _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo_id != NULL);
	g_return_if_fail (import_id != NULL);
	_tmp0_ = *photo_id;
	_tmp1_ = *import_id;
	database_table_update_int64_by_id_2 ((DatabaseTable*) self, _tmp0_.id, "import_id", _tmp1_.id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

gboolean
photo_table_remove_by_file (PhotoTable* self,
                            GFile* file)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint res = 0;
	sqlite3_stmt* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "DELETE FROM PhotoTable WHERE filename=?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = g_file_get_path (file);
	_tmp3_ = _tmp2_;
	database_table_bind_text (_tmp1_, 1, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = stmt;
	res = sqlite3_step (_tmp4_);
	if (res != SQLITE_DONE) {
		database_table_warning ("remove", res);
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	result = TRUE;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
photo_table_remove (PhotoTable* self,
                    PhotoID* photo_id,
                    GError** error)
{
	PhotoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo_id != NULL);
	_tmp0_ = *photo_id;
	database_table_delete_by_id ((DatabaseTable*) self, _tmp0_.id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

GeeArrayList*
photo_table_get_photos (PhotoTable* self)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	GeeArrayList* photo_ids = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT id FROM PhotoTable");
	stmt = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_PHOTO_ID, (GBoxedCopyFunc) photo_id_dup, (GDestroyNotify) photo_id_free, NULL, NULL, NULL);
	photo_ids = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			gint res = 0;
			sqlite3_stmt* _tmp3_;
			GeeArrayList* _tmp4_;
			sqlite3_stmt* _tmp5_;
			PhotoID _tmp6_ = {0};
			if (!_tmp2_) {
			}
			_tmp2_ = FALSE;
			_tmp3_ = stmt;
			res = sqlite3_step (_tmp3_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_fatal ("get_photos", res);
					break;
				}
			}
			_tmp4_ = photo_ids;
			_tmp5_ = stmt;
			photo_id_init (&_tmp6_, sqlite3_column_int64 (_tmp5_, 0));
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, &_tmp6_);
		}
	}
	result = photo_ids;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
photo_table_set_orientation (PhotoTable* self,
                             PhotoID* photo_id,
                             Orientation orientation)
{
	PhotoID _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	_tmp0_ = *photo_id;
	result = database_table_update_int_by_id ((DatabaseTable*) self, _tmp0_.id, "orientation", (gint) orientation);
	return result;
}

gboolean
photo_table_replace_flags (PhotoTable* self,
                           PhotoID* photo_id,
                           guint64 flags)
{
	PhotoID _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	_tmp0_ = *photo_id;
	result = database_table_update_int64_by_id ((DatabaseTable*) self, _tmp0_.id, "flags", (gint64) flags);
	return result;
}

gint
photo_table_get_event_photo_count (PhotoTable* self,
                                   EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	EventID _tmp2_;
	gint count = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (event_id != NULL, 0);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT id FROM PhotoTable WHERE event_id = ?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = *event_id;
	database_table_bind_int64 (_tmp1_, 1, _tmp2_.id);
	count = 0;
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			gint res = 0;
			sqlite3_stmt* _tmp4_;
			gint _tmp5_;
			if (!_tmp3_) {
			}
			_tmp3_ = FALSE;
			_tmp4_ = stmt;
			res = sqlite3_step (_tmp4_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_fatal ("get_event_photo_count", res);
					break;
				}
			}
			_tmp5_ = count;
			count = _tmp5_ + 1;
		}
	}
	result = count;
	_sqlite3_finalize0 (stmt);
	return result;
}

GeeArrayList*
photo_table_get_event_source_ids (PhotoTable* self,
                                  EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	EventID _tmp2_;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT id FROM PhotoTable WHERE event_id = ?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = *event_id;
	database_table_bind_int64 (_tmp1_, 1, _tmp2_.id);
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_result_ = _tmp3_;
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = TRUE;
		while (TRUE) {
			gint res = 0;
			sqlite3_stmt* _tmp5_;
			GeeArrayList* _tmp6_;
			sqlite3_stmt* _tmp7_;
			PhotoID _tmp8_ = {0};
			gchar* _tmp9_;
			gchar* _tmp10_;
			if (!_tmp4_) {
			}
			_tmp4_ = FALSE;
			_tmp5_ = stmt;
			res = sqlite3_step (_tmp5_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_fatal ("get_event_source_ids", res);
					break;
				}
			}
			_tmp6_ = _result_;
			_tmp7_ = stmt;
			photo_id_init (&_tmp8_, sqlite3_column_int64 (_tmp7_, 0));
			_tmp9_ = photo_id_upgrade_photo_id_to_source_id (&_tmp8_);
			_tmp10_ = _tmp9_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp10_);
			_g_free0 (_tmp10_);
		}
	}
	result = _result_;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
photo_table_event_has_photos (PhotoTable* self,
                              EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	EventID _tmp2_;
	gint res = 0;
	sqlite3_stmt* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event_id != NULL, FALSE);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT id FROM PhotoTable WHERE event_id = ? LIMIT 1");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = *event_id;
	database_table_bind_int64 (_tmp1_, 1, _tmp2_.id);
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res == SQLITE_DONE) {
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	} else {
		if (res != SQLITE_ROW) {
			database_table_fatal ("event_has_photos", res);
			result = FALSE;
			_sqlite3_finalize0 (stmt);
			return result;
		}
	}
	result = TRUE;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
photo_table_drop_event (PhotoTable* self,
                        EventID* event_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	EventID _tmp3_;
	gint res = 0;
	sqlite3_stmt* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event_id != NULL, FALSE);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "UPDATE PhotoTable SET event_id = ? WHERE event_id = ?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	database_table_bind_int64 (_tmp1_, 1, EVENT_ID_INVALID);
	_tmp2_ = stmt;
	_tmp3_ = *event_id;
	database_table_bind_int64 (_tmp2_, 2, _tmp3_.id);
	_tmp4_ = stmt;
	res = sqlite3_step (_tmp4_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("drop_event", res);
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	result = TRUE;
	_sqlite3_finalize0 (stmt);
	return result;
}

gboolean
photo_table_set_event (PhotoTable* self,
                       PhotoID* photo_id,
                       EventID* event_id)
{
	PhotoID _tmp0_;
	EventID _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	g_return_val_if_fail (event_id != NULL, FALSE);
	_tmp0_ = *photo_id;
	_tmp1_ = *event_id;
	result = database_table_update_int64_by_id ((DatabaseTable*) self, _tmp0_.id, "event_id", _tmp1_.id);
	return result;
}

static gchar*
photo_table_get_raw_transformations (PhotoTable* self,
                                     PhotoID* photo_id)
{
	sqlite3_stmt* stmt = NULL;
	PhotoID _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gboolean _tmp2_;
	gchar* trans = NULL;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (photo_id != NULL, NULL);
	_tmp0_ = *photo_id;
	_tmp2_ = database_table_select_by_id ((DatabaseTable*) self, _tmp0_.id, "transformations", &_tmp1_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	if (!_tmp2_) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp3_ = stmt;
	_tmp4_ = (const gchar*) sqlite3_column_text (_tmp3_, 0);
	_tmp5_ = g_strdup (_tmp4_);
	trans = _tmp5_;
	_tmp7_ = trans;
	if (_tmp7_ == NULL) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp8_ = trans;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ == 0;
	}
	if (_tmp6_) {
		result = NULL;
		_g_free0 (trans);
		_sqlite3_finalize0 (stmt);
		return result;
	}
	result = trans;
	_sqlite3_finalize0 (stmt);
	return result;
}

static gboolean
photo_table_set_raw_transformations (PhotoTable* self,
                                     PhotoID* photo_id,
                                     const gchar* trans)
{
	PhotoID _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	g_return_val_if_fail (trans != NULL, FALSE);
	_tmp0_ = *photo_id;
	result = database_table_update_text_by_id ((DatabaseTable*) self, _tmp0_.id, "transformations", trans);
	return result;
}

static gboolean
photo_table_set_raw_original_transforms (PhotoTable* self,
                                         PhotoID* photo_id,
                                         const gchar* trans)
{
	PhotoID _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	g_return_val_if_fail (trans != NULL, FALSE);
	_tmp0_ = *photo_id;
	result = database_table_update_text_by_id ((DatabaseTable*) self, _tmp0_.id, "original_transforms", trans);
	return result;
}

gboolean
photo_table_set_transformation_state (PhotoTable* self,
                                      PhotoID* photo_id,
                                      Orientation orientation,
                                      GeeHashMap* transformations,
                                      GeeHashMap* original_transforms,
                                      gboolean enhanced)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	sqlite3_stmt* _tmp5_;
	PhotoID _tmp6_;
	gint res = 0;
	sqlite3_stmt* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "UPDATE PhotoTable SET orientation = ?, transformations = ? WHERE id = " \
"?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	database_table_bind_int (_tmp1_, 1, (gint) orientation);
	_tmp2_ = stmt;
	_tmp3_ = photo_table_unmarshall_all_transformations (transformations);
	_tmp4_ = _tmp3_;
	database_table_bind_text (_tmp2_, 2, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = stmt;
	_tmp6_ = *photo_id;
	database_table_bind_int64 (_tmp5_, 3, _tmp6_.id);
	_tmp7_ = stmt;
	res = sqlite3_step (_tmp7_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("set_transformation_state", res);
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	result = TRUE;
	_sqlite3_finalize0 (stmt);
	return result;
}

GeeHashMap*
photo_table_marshall_all_transformations (const gchar* trans)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	GeeHashMap* result;
	if (trans == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (trans);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == 0;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	{
		GKeyFile* keyfile = NULL;
		GKeyFile* _tmp3_;
		gboolean _tmp4_ = FALSE;
		GKeyFile* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GeeHashMap* map = NULL;
		GeeHashMap* _tmp8_;
		gchar** objects = NULL;
		GKeyFile* _tmp9_;
		gsize _tmp10_ = 0;
		gchar** _tmp11_;
		gint objects_length1;
		gint _objects_size_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		_tmp3_ = g_key_file_new ();
		keyfile = _tmp3_;
		_tmp5_ = keyfile;
		_tmp6_ = strlen (trans);
		_tmp7_ = _tmp6_;
		_tmp4_ = g_key_file_load_from_data (_tmp5_, trans, (gsize) _tmp7_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (keyfile);
			goto __catch0_g_error;
		}
		if (!_tmp4_) {
			result = NULL;
			_g_key_file_unref0 (keyfile);
			return result;
		}
		_tmp8_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_KEY_VALUE_MAP, (GBoxedCopyFunc) key_value_map_ref, (GDestroyNotify) key_value_map_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		map = _tmp8_;
		_tmp9_ = keyfile;
		_tmp11_ = g_key_file_get_groups (_tmp9_, &_tmp10_);
		objects = _tmp11_;
		objects_length1 = _tmp10_;
		_objects_size_ = objects_length1;
		_tmp12_ = objects;
		_tmp12__length1 = objects_length1;
		{
			gchar** object_collection = NULL;
			gint object_collection_length1 = 0;
			gint _object_collection_size_ = 0;
			gint object_it = 0;
			object_collection = _tmp12_;
			object_collection_length1 = _tmp12__length1;
			for (object_it = 0; object_it < object_collection_length1; object_it = object_it + 1) {
				gchar* _tmp13_;
				gchar* object = NULL;
				_tmp13_ = g_strdup (object_collection[object_it]);
				object = _tmp13_;
				{
					gchar** keys = NULL;
					GKeyFile* _tmp14_;
					const gchar* _tmp15_;
					gsize _tmp16_ = 0;
					gchar** _tmp17_;
					gint keys_length1;
					gint _keys_size_;
					gboolean _tmp18_ = FALSE;
					gchar** _tmp19_;
					gint _tmp19__length1;
					KeyValueMap* key_map = NULL;
					const gchar* _tmp21_;
					KeyValueMap* _tmp22_;
					GeeHashMap* _tmp35_;
					const gchar* _tmp36_;
					KeyValueMap* _tmp37_;
					_tmp14_ = keyfile;
					_tmp15_ = object;
					_tmp17_ = g_key_file_get_keys (_tmp14_, _tmp15_, &_tmp16_, &_inner_error0_);
					keys = _tmp17_;
					keys_length1 = _tmp16_;
					_keys_size_ = keys_length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (object);
						objects = (_vala_array_free (objects, objects_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (map);
						_g_key_file_unref0 (keyfile);
						goto __catch0_g_error;
					}
					_tmp19_ = keys;
					_tmp19__length1 = keys_length1;
					if (_tmp19_ == NULL) {
						_tmp18_ = TRUE;
					} else {
						gchar** _tmp20_;
						gint _tmp20__length1;
						_tmp20_ = keys;
						_tmp20__length1 = keys_length1;
						_tmp18_ = _tmp20__length1 == 0;
					}
					if (_tmp18_) {
						keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (object);
						continue;
					}
					_tmp21_ = object;
					_tmp22_ = key_value_map_new (_tmp21_);
					key_map = _tmp22_;
					{
						gint ctr = 0;
						ctr = 0;
						{
							gboolean _tmp23_ = FALSE;
							_tmp23_ = TRUE;
							while (TRUE) {
								gchar** _tmp25_;
								gint _tmp25__length1;
								gchar* _tmp26_ = NULL;
								GKeyFile* _tmp27_;
								const gchar* _tmp28_;
								gchar** _tmp29_;
								gint _tmp29__length1;
								const gchar* _tmp30_;
								gchar* _tmp31_;
								KeyValueMap* _tmp32_;
								gchar** _tmp33_;
								gint _tmp33__length1;
								const gchar* _tmp34_;
								if (!_tmp23_) {
									gint _tmp24_;
									_tmp24_ = ctr;
									ctr = _tmp24_ + 1;
								}
								_tmp23_ = FALSE;
								_tmp25_ = keys;
								_tmp25__length1 = keys_length1;
								if (!(ctr < _tmp25__length1)) {
									break;
								}
								_tmp27_ = keyfile;
								_tmp28_ = object;
								_tmp29_ = keys;
								_tmp29__length1 = keys_length1;
								_tmp30_ = _tmp29_[ctr];
								_tmp31_ = g_key_file_get_string (_tmp27_, _tmp28_, _tmp30_, &_inner_error0_);
								_tmp26_ = _tmp31_;
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									_key_value_map_unref0 (key_map);
									keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (object);
									objects = (_vala_array_free (objects, objects_length1, (GDestroyNotify) g_free), NULL);
									_g_object_unref0 (map);
									_g_key_file_unref0 (keyfile);
									goto __catch0_g_error;
								}
								_tmp32_ = key_map;
								_tmp33_ = keys;
								_tmp33__length1 = keys_length1;
								_tmp34_ = _tmp33_[ctr];
								key_value_map_set_string (_tmp32_, _tmp34_, _tmp26_);
								_g_free0 (_tmp26_);
							}
						}
					}
					_tmp35_ = map;
					_tmp36_ = object;
					_tmp37_ = key_map;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp35_, _tmp36_, _tmp37_);
					_key_value_map_unref0 (key_map);
					keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (object);
				}
			}
		}
		result = map;
		objects = (_vala_array_free (objects, objects_length1, (GDestroyNotify) g_free), NULL);
		_g_key_file_unref0 (keyfile);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp38_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = err->message;
		g_error ("PhotoTable.vala:684: %s", _tmp38_);
		_g_error_free0 (err);
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
photo_table_unmarshall_all_transformations (GeeHashMap* transformations)
{
	gboolean _tmp0_ = FALSE;
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp6_;
	gsize length = 0UL;
	gchar* unmarshalled = NULL;
	GKeyFile* _tmp33_;
	gsize _tmp34_ = 0UL;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gchar* result;
	if (transformations == NULL) {
		_tmp0_ = TRUE;
	} else {
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp1_ = gee_abstract_map_get_keys ((GeeAbstractMap*) transformations);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ == 0;
		_g_object_unref0 (_tmp3_);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp6_ = g_key_file_new ();
	keyfile = _tmp6_;
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeSet* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp7_ = gee_abstract_map_get_keys ((GeeAbstractMap*) transformations);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_object_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			gchar* object = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			KeyValueMap* map = NULL;
			const gchar* _tmp15_;
			gpointer _tmp16_;
			_tmp12_ = _object_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _object_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			object = (gchar*) _tmp14_;
			_tmp15_ = object;
			_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) transformations, _tmp15_);
			map = (KeyValueMap*) _tmp16_;
			{
				GeeIterator* _key_it = NULL;
				KeyValueMap* _tmp17_;
				GeeSet* _tmp18_;
				GeeSet* _tmp19_;
				GeeIterator* _tmp20_;
				GeeIterator* _tmp21_;
				_tmp17_ = map;
				_tmp18_ = key_value_map_get_keys (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = gee_iterable_iterator ((GeeIterable*) _tmp19_);
				_tmp21_ = _tmp20_;
				_g_object_unref0 (_tmp19_);
				_key_it = _tmp21_;
				while (TRUE) {
					GeeIterator* _tmp22_;
					gchar* key = NULL;
					GeeIterator* _tmp23_;
					gpointer _tmp24_;
					gchar* value = NULL;
					KeyValueMap* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					const gchar* _tmp28_;
					GKeyFile* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					_tmp22_ = _key_it;
					if (!gee_iterator_next (_tmp22_)) {
						break;
					}
					_tmp23_ = _key_it;
					_tmp24_ = gee_iterator_get (_tmp23_);
					key = (gchar*) _tmp24_;
					_tmp25_ = map;
					_tmp26_ = key;
					_tmp27_ = key_value_map_get_string (_tmp25_, _tmp26_, NULL);
					value = _tmp27_;
					_tmp28_ = value;
					_vala_assert (_tmp28_ != NULL, "value != null");
					_tmp29_ = keyfile;
					_tmp30_ = object;
					_tmp31_ = key;
					_tmp32_ = value;
					g_key_file_set_string (_tmp29_, _tmp30_, _tmp31_, _tmp32_);
					_g_free0 (value);
					_g_free0 (key);
				}
				_g_object_unref0 (_key_it);
			}
			_key_value_map_unref0 (map);
			_g_free0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp33_ = keyfile;
	_tmp35_ = g_key_file_to_data (_tmp33_, &_tmp34_, NULL);
	length = _tmp34_;
	unmarshalled = _tmp35_;
	_tmp36_ = unmarshalled;
	_vala_assert (_tmp36_ != NULL, "unmarshalled != null");
	_tmp37_ = unmarshalled;
	_tmp38_ = strlen (_tmp37_);
	_tmp39_ = _tmp38_;
	_vala_assert (_tmp39_ > 0, "unmarshalled.length > 0");
	result = unmarshalled;
	_g_key_file_unref0 (keyfile);
	return result;
}

gboolean
photo_table_set_transformation (PhotoTable* self,
                                PhotoID* photo_id,
                                KeyValueMap* map)
{
	gchar* trans = NULL;
	PhotoID _tmp0_;
	gchar* _tmp1_;
	PhotoID _tmp33_;
	const gchar* _tmp34_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	g_return_val_if_fail (map != NULL, FALSE);
	_tmp0_ = *photo_id;
	_tmp1_ = photo_table_get_raw_transformations (self, &_tmp0_);
	trans = _tmp1_;
	{
		GKeyFile* keyfile = NULL;
		GKeyFile* _tmp2_;
		const gchar* _tmp3_;
		GeeSet* keys = NULL;
		GeeSet* _tmp10_;
		gsize length = 0UL;
		GKeyFile* _tmp24_;
		gsize _tmp25_ = 0UL;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp2_ = g_key_file_new ();
		keyfile = _tmp2_;
		_tmp3_ = trans;
		if (_tmp3_ != NULL) {
			gboolean _tmp4_ = FALSE;
			GKeyFile* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			_tmp5_ = keyfile;
			_tmp6_ = trans;
			_tmp7_ = trans;
			_tmp8_ = strlen (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp4_ = g_key_file_load_from_data (_tmp5_, _tmp6_, (gsize) _tmp9_, G_KEY_FILE_NONE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_key_file_unref0 (keyfile);
				goto __catch0_g_error;
			}
			if (!_tmp4_) {
				result = FALSE;
				_g_key_file_unref0 (keyfile);
				_g_free0 (trans);
				return result;
			}
		}
		_tmp10_ = key_value_map_get_keys (map);
		keys = _tmp10_;
		{
			GeeIterator* _key_it = NULL;
			GeeSet* _tmp11_;
			GeeIterator* _tmp12_;
			_tmp11_ = keys;
			_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
			_key_it = _tmp12_;
			while (TRUE) {
				GeeIterator* _tmp13_;
				gchar* key = NULL;
				GeeIterator* _tmp14_;
				gpointer _tmp15_;
				gchar* value = NULL;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				GKeyFile* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				_tmp13_ = _key_it;
				if (!gee_iterator_next (_tmp13_)) {
					break;
				}
				_tmp14_ = _key_it;
				_tmp15_ = gee_iterator_get (_tmp14_);
				key = (gchar*) _tmp15_;
				_tmp16_ = key;
				_tmp17_ = key_value_map_get_string (map, _tmp16_, NULL);
				value = _tmp17_;
				_tmp18_ = value;
				_vala_assert (_tmp18_ != NULL, "value != null");
				_tmp19_ = keyfile;
				_tmp20_ = key_value_map_get_group (map);
				_tmp21_ = _tmp20_;
				_tmp22_ = key;
				_tmp23_ = value;
				g_key_file_set_string (_tmp19_, _tmp21_, _tmp22_, _tmp23_);
				_g_free0 (_tmp21_);
				_g_free0 (value);
				_g_free0 (key);
			}
			_g_object_unref0 (_key_it);
		}
		_tmp24_ = keyfile;
		_tmp26_ = g_key_file_to_data (_tmp24_, &_tmp25_, NULL);
		length = _tmp25_;
		_g_free0 (trans);
		trans = _tmp26_;
		_tmp27_ = trans;
		_vala_assert (_tmp27_ != NULL, "trans != null");
		_tmp28_ = trans;
		_tmp29_ = strlen (_tmp28_);
		_tmp30_ = _tmp29_;
		_vala_assert (_tmp30_ > 0, "trans.length > 0");
		_g_object_unref0 (keys);
		_g_key_file_unref0 (keyfile);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp31_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp31_ = err->message;
		g_error ("PhotoTable.vala:736: %s", _tmp31_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp32_ = FALSE;
		_g_free0 (trans);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp32_;
	}
	_tmp33_ = *photo_id;
	_tmp34_ = trans;
	result = photo_table_set_raw_transformations (self, &_tmp33_, _tmp34_);
	_g_free0 (trans);
	return result;
}

gboolean
photo_table_set_original_transforms (PhotoTable* self,
                                     PhotoID* photo_id,
                                     KeyValueMap* map)
{
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp1_;
	GeeSet* keys = NULL;
	GeeSet* _tmp2_;
	gsize length = 0UL;
	gchar* trans = NULL;
	GKeyFile* _tmp16_;
	gsize _tmp17_ = 0UL;
	gchar* _tmp18_;
	PhotoID _tmp19_;
	const gchar* _tmp20_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	if (map == NULL) {
		PhotoID _tmp0_;
		_tmp0_ = *photo_id;
		result = photo_table_set_raw_original_transforms (self, &_tmp0_, "");
		return result;
	}
	_tmp1_ = g_key_file_new ();
	keyfile = _tmp1_;
	_tmp2_ = key_value_map_get_keys (map);
	keys = _tmp2_;
	{
		GeeIterator* _key_it = NULL;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp3_ = keys;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_key_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gchar* key = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			gchar* value = NULL;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			GKeyFile* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp5_ = _key_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _key_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			key = (gchar*) _tmp7_;
			_tmp8_ = key;
			_tmp9_ = key_value_map_get_string (map, _tmp8_, NULL);
			value = _tmp9_;
			_tmp10_ = value;
			_vala_assert (_tmp10_ != NULL, "value != null");
			_tmp11_ = keyfile;
			_tmp12_ = key_value_map_get_group (map);
			_tmp13_ = _tmp12_;
			_tmp14_ = key;
			_tmp15_ = value;
			g_key_file_set_string (_tmp11_, _tmp13_, _tmp14_, _tmp15_);
			_g_free0 (_tmp13_);
			_g_free0 (value);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_it);
	}
	_tmp16_ = keyfile;
	_tmp18_ = g_key_file_to_data (_tmp16_, &_tmp17_, NULL);
	length = _tmp17_;
	trans = _tmp18_;
	_tmp19_ = *photo_id;
	_tmp20_ = trans;
	result = photo_table_set_raw_original_transforms (self, &_tmp19_, _tmp20_);
	_g_free0 (trans);
	_g_object_unref0 (keys);
	_g_key_file_unref0 (keyfile);
	return result;
}

gboolean
photo_table_remove_transformation (PhotoTable* self,
                                   PhotoID* photo_id,
                                   const gchar* object)
{
	gchar* trans = NULL;
	PhotoID _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	PhotoID _tmp18_;
	const gchar* _tmp19_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = *photo_id;
	_tmp1_ = photo_table_get_raw_transformations (self, &_tmp0_);
	trans = _tmp1_;
	_tmp2_ = trans;
	if (_tmp2_ == NULL) {
		result = TRUE;
		_g_free0 (trans);
		return result;
	}
	{
		GKeyFile* keyfile = NULL;
		GKeyFile* _tmp3_;
		gboolean _tmp4_ = FALSE;
		GKeyFile* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		GKeyFile* _tmp10_;
		GKeyFile* _tmp11_;
		gsize length = 0UL;
		GKeyFile* _tmp12_;
		gsize _tmp13_ = 0UL;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp3_ = g_key_file_new ();
		keyfile = _tmp3_;
		_tmp5_ = keyfile;
		_tmp6_ = trans;
		_tmp7_ = trans;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp4_ = g_key_file_load_from_data (_tmp5_, _tmp6_, (gsize) _tmp9_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (keyfile);
			goto __catch0_g_error;
		}
		if (!_tmp4_) {
			result = FALSE;
			_g_key_file_unref0 (keyfile);
			_g_free0 (trans);
			return result;
		}
		_tmp10_ = keyfile;
		if (!g_key_file_has_group (_tmp10_, object)) {
			result = TRUE;
			_g_key_file_unref0 (keyfile);
			_g_free0 (trans);
			return result;
		}
		_tmp11_ = keyfile;
		g_key_file_remove_group (_tmp11_, object, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (keyfile);
			goto __catch0_g_error;
		}
		_tmp12_ = keyfile;
		_tmp14_ = g_key_file_to_data (_tmp12_, &_tmp13_, NULL);
		length = _tmp13_;
		_g_free0 (trans);
		trans = _tmp14_;
		_tmp15_ = trans;
		_vala_assert (_tmp15_ != NULL, "trans != null");
		_g_key_file_unref0 (keyfile);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp16_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = err->message;
		g_error ("PhotoTable.vala:780: %s", _tmp16_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp17_ = FALSE;
		_g_free0 (trans);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp17_;
	}
	_tmp18_ = *photo_id;
	_tmp19_ = trans;
	result = photo_table_set_raw_transformations (self, &_tmp18_, _tmp19_);
	_g_free0 (trans);
	return result;
}

gboolean
photo_table_remove_all_transformations (PhotoTable* self,
                                        PhotoID* photo_id)
{
	PhotoID _tmp0_;
	PhotoID _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	PhotoID _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	_tmp0_ = *photo_id;
	photo_table_set_enhanced (self, &_tmp0_, FALSE);
	_tmp1_ = *photo_id;
	_tmp2_ = photo_table_get_raw_transformations (self, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ == NULL;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = *photo_id;
	result = database_table_update_text_by_id ((DatabaseTable*) self, _tmp5_.id, "transformations", "");
	return result;
}

static sqlite3_stmt*
photo_table_get_duplicate_stmt (PhotoTable* self,
                                GFile* file,
                                const gchar* thumbnail_md5,
                                const gchar* md5,
                                PhotoFileFormat file_format)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* sql = NULL;
	gchar* _tmp2_;
	gboolean first = FALSE;
	gboolean _tmp5_ = FALSE;
	sqlite3_stmt* stmt = NULL;
	const gchar* _tmp22_;
	sqlite3_stmt* _tmp23_;
	gint col = 0;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	sqlite3_stmt* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (file != NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = thumbnail_md5 != NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = md5 != NULL;
	}
	_vala_assert (_tmp0_, "file != null || thumbnail_md5 != null || md5 != null");
	_tmp2_ = g_strdup ("SELECT id FROM PhotoTable WHERE");
	sql = _tmp2_;
	first = TRUE;
	if (file != NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = sql;
		_tmp4_ = g_strconcat (_tmp3_, " filename=?", NULL);
		_g_free0 (sql);
		sql = _tmp4_;
		first = FALSE;
	}
	if (thumbnail_md5 != NULL) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = md5 != NULL;
	}
	if (_tmp5_) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		if (first) {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = sql;
			_tmp7_ = g_strconcat (_tmp6_, " ((", NULL);
			_g_free0 (sql);
			sql = _tmp7_;
		} else {
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = sql;
			_tmp9_ = g_strconcat (_tmp8_, " OR ((", NULL);
			_g_free0 (sql);
			sql = _tmp9_;
		}
		first = FALSE;
		if (thumbnail_md5 != NULL) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = sql;
			_tmp11_ = g_strconcat (_tmp10_, " thumbnail_md5=?", NULL);
			_g_free0 (sql);
			sql = _tmp11_;
		}
		if (md5 != NULL) {
			if (thumbnail_md5 == NULL) {
				const gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp12_ = sql;
				_tmp13_ = g_strconcat (_tmp12_, " md5=?", NULL);
				_g_free0 (sql);
				sql = _tmp13_;
			} else {
				const gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp14_ = sql;
				_tmp15_ = g_strconcat (_tmp14_, " OR md5=?", NULL);
				_g_free0 (sql);
				sql = _tmp15_;
			}
		}
		_tmp16_ = sql;
		_tmp17_ = g_strconcat (_tmp16_, ")", NULL);
		_g_free0 (sql);
		sql = _tmp17_;
		if (file_format != PHOTO_FILE_FORMAT_UNKNOWN) {
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp18_ = sql;
			_tmp19_ = g_strconcat (_tmp18_, " AND file_format=?", NULL);
			_g_free0 (sql);
			sql = _tmp19_;
		}
		_tmp20_ = sql;
		_tmp21_ = g_strconcat (_tmp20_, ")", NULL);
		_g_free0 (sql);
		sql = _tmp21_;
	}
	_tmp22_ = sql;
	_tmp23_ = database_table_create_stmt ((DatabaseTable*) self, _tmp22_);
	stmt = _tmp23_;
	col = 1;
	if (file != NULL) {
		sqlite3_stmt* _tmp24_;
		gint _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp24_ = stmt;
		_tmp25_ = col;
		col = _tmp25_ + 1;
		_tmp26_ = g_file_get_path (file);
		_tmp27_ = _tmp26_;
		database_table_bind_text (_tmp24_, _tmp25_, _tmp27_);
		_g_free0 (_tmp27_);
	}
	if (thumbnail_md5 != NULL) {
		sqlite3_stmt* _tmp28_;
		gint _tmp29_;
		const gchar* _tmp30_;
		_tmp28_ = stmt;
		_tmp29_ = col;
		col = _tmp29_ + 1;
		_tmp30_ = thumbnail_md5;
		database_table_bind_text (_tmp28_, _tmp29_, _tmp30_);
	}
	if (md5 != NULL) {
		sqlite3_stmt* _tmp31_;
		gint _tmp32_;
		const gchar* _tmp33_;
		_tmp31_ = stmt;
		_tmp32_ = col;
		col = _tmp32_ + 1;
		_tmp33_ = md5;
		database_table_bind_text (_tmp31_, _tmp32_, _tmp33_);
	}
	if (thumbnail_md5 != NULL) {
		_tmp35_ = TRUE;
	} else {
		_tmp35_ = md5 != NULL;
	}
	if (_tmp35_) {
		_tmp34_ = file_format != PHOTO_FILE_FORMAT_UNKNOWN;
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		sqlite3_stmt* _tmp36_;
		gint _tmp37_;
		_tmp36_ = stmt;
		_tmp37_ = col;
		col = _tmp37_ + 1;
		database_table_bind_int (_tmp36_, _tmp37_, photo_file_format_serialize (file_format));
	}
	result = stmt;
	_g_free0 (sql);
	return result;
}

gboolean
photo_table_has_duplicate (PhotoTable* self,
                           GFile* file,
                           const gchar* thumbnail_md5,
                           const gchar* md5,
                           PhotoFileFormat file_format)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = photo_table_get_duplicate_stmt (self, file, thumbnail_md5, md5, file_format);
	stmt = _tmp0_;
	_tmp1_ = stmt;
	res = sqlite3_step (_tmp1_);
	if (res == SQLITE_DONE) {
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	} else {
		if (res == SQLITE_ROW) {
			result = TRUE;
			_sqlite3_finalize0 (stmt);
			return result;
		} else {
			database_table_fatal ("has_duplicate", res);
			result = FALSE;
			_sqlite3_finalize0 (stmt);
			return result;
		}
	}
}

static void
_vala_array_add49 (PhotoID* * array,
                   gint* length,
                   gint* size,
                   const PhotoID* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PhotoID, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

PhotoID*
photo_table_get_duplicate_ids (PhotoTable* self,
                               GFile* file,
                               const gchar* thumbnail_md5,
                               const gchar* md5,
                               PhotoFileFormat file_format,
                               gint* result_length1)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	PhotoID* ids = NULL;
	PhotoID* _tmp1_;
	gint ids_length1;
	gint _ids_size_;
	gint res = 0;
	sqlite3_stmt* _tmp2_;
	PhotoID* _tmp6_;
	gint _tmp6__length1;
	PhotoID* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = photo_table_get_duplicate_stmt (self, file, thumbnail_md5, md5, file_format);
	stmt = _tmp0_;
	_tmp1_ = g_new0 (PhotoID, 0);
	ids = _tmp1_;
	ids_length1 = 0;
	_ids_size_ = ids_length1;
	_tmp2_ = stmt;
	res = sqlite3_step (_tmp2_);
	while (TRUE) {
		sqlite3_stmt* _tmp3_;
		PhotoID _tmp4_ = {0};
		sqlite3_stmt* _tmp5_;
		if (!(res == SQLITE_ROW)) {
			break;
		}
		_tmp3_ = stmt;
		photo_id_init (&_tmp4_, sqlite3_column_int64 (_tmp3_, 0));
		_vala_array_add49 (&ids, &ids_length1, &_ids_size_, &_tmp4_);
		_tmp5_ = stmt;
		res = sqlite3_step (_tmp5_);
	}
	_tmp6_ = ids;
	_tmp6__length1 = ids_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
photo_table_update_backlinks (PhotoTable* self,
                              PhotoID* photo_id,
                              const gchar* backlinks,
                              GError** error)
{
	const gchar* _tmp0_ = NULL;
	PhotoID _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo_id != NULL);
	if (backlinks != NULL) {
		_tmp0_ = backlinks;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = *photo_id;
	database_table_update_text_by_id_2 ((DatabaseTable*) self, _tmp1_.id, "backlinks", _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
photo_table_attach_editable (PhotoTable* self,
                             PhotoRow* row,
                             BackingPhotoID* editable_id,
                             GError** error)
{
	PhotoID _tmp0_;
	BackingPhotoID _tmp1_;
	BackingPhotoID _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	g_return_if_fail (editable_id != NULL);
	_tmp0_ = row->photo_id;
	_tmp1_ = *editable_id;
	database_table_update_int64_by_id_2 ((DatabaseTable*) self, _tmp0_.id, "editable_id", _tmp1_.id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp2_ = *editable_id;
	row->editable_id = _tmp2_;
}

void
photo_table_detach_editable (PhotoTable* self,
                             PhotoRow* row,
                             GError** error)
{
	PhotoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = row->photo_id;
	database_table_update_int64_by_id_2 ((DatabaseTable*) self, _tmp0_.id, "editable_id", BACKING_PHOTO_ID_INVALID, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	backing_photo_id_init (&row->editable_id, BACKING_PHOTO_ID_INVALID);
}

void
photo_table_set_metadata_dirty (PhotoTable* self,
                                PhotoID* photo_id,
                                gboolean dirty,
                                GError** error)
{
	gint _tmp0_ = 0;
	PhotoID _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo_id != NULL);
	if (dirty) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	_tmp1_ = *photo_id;
	database_table_update_int_by_id_2 ((DatabaseTable*) self, _tmp1_.id, "metadata_dirty", _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

gboolean
photo_table_set_enhanced (PhotoTable* self,
                          PhotoID* photo_id,
                          gboolean enhanced)
{
	gint _tmp0_ = 0;
	PhotoID _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo_id != NULL, FALSE);
	if (enhanced) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	_tmp1_ = *photo_id;
	result = database_table_update_int_by_id ((DatabaseTable*) self, _tmp1_.id, "enhanced", _tmp0_);
	return result;
}

void
photo_table_update_raw_development (PhotoTable* self,
                                    PhotoRow* row,
                                    RawDeveloper rd,
                                    BackingPhotoID* backing_photo_id,
                                    GError** error)
{
	gchar* col = NULL;
	BackingPhotoID* _tmp3_;
	gint _tmp3__length1;
	BackingPhotoID _tmp4_;
	PhotoID _tmp5_;
	const gchar* _tmp6_;
	BackingPhotoID _tmp7_;
	BackingPhotoID _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	g_return_if_fail (backing_photo_id != NULL);
	switch (rd) {
		case RAW_DEVELOPER_SHOTWELL:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("develop_shotwell_id");
			_g_free0 (col);
			col = _tmp0_;
			break;
		}
		case RAW_DEVELOPER_CAMERA:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("develop_camera_id");
			_g_free0 (col);
			col = _tmp1_;
			break;
		}
		case RAW_DEVELOPER_EMBEDDED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("develop_embedded_id");
			_g_free0 (col);
			col = _tmp2_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp3_ = row->development_ids;
	_tmp3__length1 = row->development_ids_length1;
	_tmp4_ = *backing_photo_id;
	_tmp3_[rd] = _tmp4_;
	_tmp5_ = row->photo_id;
	_tmp6_ = col;
	_tmp7_ = *backing_photo_id;
	database_table_update_int64_by_id_2 ((DatabaseTable*) self, _tmp5_.id, _tmp6_, _tmp7_.id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (col);
			return;
		} else {
			_g_free0 (col);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp8_ = *backing_photo_id;
	if (_tmp8_.id != BACKING_PHOTO_ID_INVALID) {
		PhotoID _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = row->photo_id;
		_tmp10_ = raw_developer_to_string (rd);
		_tmp11_ = _tmp10_;
		database_table_update_text_by_id_2 ((DatabaseTable*) self, _tmp9_.id, "developer", _tmp11_, &_inner_error0_);
		_g_free0 (_tmp11_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (col);
				return;
			} else {
				_g_free0 (col);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_g_free0 (col);
}

void
photo_table_remove_development (PhotoTable* self,
                                PhotoRow* row,
                                RawDeveloper rd,
                                GError** error)
{
	BackingPhotoID _tmp0_ = {0};
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	backing_photo_id_init (&_tmp0_, BACKING_PHOTO_ID_INVALID);
	photo_table_update_raw_development (self, row, rd, &_tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
photo_table_class_init (PhotoTableClass * klass,
                        gpointer klass_data)
{
	photo_table_parent_class = g_type_class_peek_parent (klass);
	((DatabaseTableClass *) klass)->finalize = photo_table_finalize;
}

static void
photo_table_instance_init (PhotoTable * self,
                           gpointer klass)
{
}

static void
photo_table_finalize (DatabaseTable * obj)
{
	PhotoTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_TABLE, PhotoTable);
	DATABASE_TABLE_CLASS (photo_table_parent_class)->finalize (obj);
}

static GType
photo_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoTable), 0, (GInstanceInitFunc) photo_table_instance_init, NULL };
	GType photo_table_type_id;
	photo_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "PhotoTable", &g_define_type_info, 0);
	return photo_table_type_id;
}

GType
photo_table_get_type (void)
{
	static volatile gsize photo_table_type_id__once = 0;
	if (g_once_init_enter (&photo_table_type_id__once)) {
		GType photo_table_type_id;
		photo_table_type_id = photo_table_get_type_once ();
		g_once_init_leave (&photo_table_type_id__once, photo_table_type_id);
	}
	return photo_table_type_id__once;
}

void
backing_photo_id_init (BackingPhotoID *self,
                       gint64 id)
{
	memset (self, 0, sizeof (BackingPhotoID));
	(*self).id = id;
}

gboolean
backing_photo_id_is_invalid (BackingPhotoID *self)
{
	gboolean result;
	result = (*self).id == BACKING_PHOTO_ID_INVALID;
	return result;
}

gboolean
backing_photo_id_is_valid (BackingPhotoID *self)
{
	gboolean result;
	result = (*self).id != BACKING_PHOTO_ID_INVALID;
	return result;
}

BackingPhotoID*
backing_photo_id_dup (const BackingPhotoID* self)
{
	BackingPhotoID* dup;
	dup = g_new0 (BackingPhotoID, 1);
	memcpy (dup, self, sizeof (BackingPhotoID));
	return dup;
}

void
backing_photo_id_free (BackingPhotoID* self)
{
	g_free (self);
}

static GType
backing_photo_id_get_type_once (void)
{
	GType backing_photo_id_type_id;
	backing_photo_id_type_id = g_boxed_type_register_static ("BackingPhotoID", (GBoxedCopyFunc) backing_photo_id_dup, (GBoxedFreeFunc) backing_photo_id_free);
	return backing_photo_id_type_id;
}

GType
backing_photo_id_get_type (void)
{
	static volatile gsize backing_photo_id_type_id__once = 0;
	if (g_once_init_enter (&backing_photo_id_type_id__once)) {
		GType backing_photo_id_type_id;
		backing_photo_id_type_id = backing_photo_id_get_type_once ();
		g_once_init_leave (&backing_photo_id_type_id__once, backing_photo_id_type_id);
	}
	return backing_photo_id_type_id__once;
}

gboolean
backing_photo_row_matches_file_info (BackingPhotoRow* self,
                                     GFileInfo* info)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	if (self->filesize != g_file_info_get_size (info)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = g_file_info_get_modification_date_time (info);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->timestamp == g_date_time_to_unix (_tmp1_);
	_g_date_time_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gboolean
backing_photo_row_is_touched (BackingPhotoRow* self,
                              GFileInfo* info)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	if (self->filesize != g_file_info_get_size (info)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = g_file_info_get_modification_date_time (info);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->timestamp != g_date_time_to_unix (_tmp1_);
	_g_date_time_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

void
backing_photo_row_copy_from (BackingPhotoRow* self,
                             BackingPhotoRow* from)
{
	BackingPhotoID _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	Dimensions _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (from != NULL);
	_tmp0_ = from->id;
	self->id = _tmp0_;
	self->time_created = from->time_created;
	_tmp1_ = from->filepath;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->filepath);
	self->filepath = _tmp2_;
	self->filesize = from->filesize;
	self->timestamp = from->timestamp;
	self->file_format = from->file_format;
	_tmp3_ = from->dim;
	self->dim = _tmp3_;
	self->original_orientation = from->original_orientation;
}

BackingPhotoRow*
backing_photo_row_construct (GType object_type)
{
	BackingPhotoRow* self = NULL;
	self = (BackingPhotoRow*) g_type_create_instance (object_type);
	return self;
}

BackingPhotoRow*
backing_photo_row_new (void)
{
	return backing_photo_row_construct (TYPE_BACKING_PHOTO_ROW);
}

static void
value_backing_photo_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_backing_photo_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		backing_photo_row_unref (value->data[0].v_pointer);
	}
}

static void
value_backing_photo_row_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = backing_photo_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_backing_photo_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_backing_photo_row_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BackingPhotoRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = backing_photo_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_backing_photo_row_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	BackingPhotoRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = backing_photo_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_backing_photo_row (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	ParamSpecBackingPhotoRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BACKING_PHOTO_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_backing_photo_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_PHOTO_ROW), NULL);
	return value->data[0].v_pointer;
}

void
value_set_backing_photo_row (GValue* value,
                             gpointer v_object)
{
	BackingPhotoRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_PHOTO_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKING_PHOTO_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		backing_photo_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		backing_photo_row_unref (old);
	}
}

void
value_take_backing_photo_row (GValue* value,
                              gpointer v_object)
{
	BackingPhotoRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_PHOTO_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKING_PHOTO_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		backing_photo_row_unref (old);
	}
}

static void
backing_photo_row_class_init (BackingPhotoRowClass * klass,
                              gpointer klass_data)
{
	backing_photo_row_parent_class = g_type_class_peek_parent (klass);
	((BackingPhotoRowClass *) klass)->finalize = backing_photo_row_finalize;
}

static void
backing_photo_row_instance_init (BackingPhotoRow * self,
                                 gpointer klass)
{
	self->filepath = NULL;
	self->ref_count = 1;
}

static void
backing_photo_row_finalize (BackingPhotoRow * obj)
{
	BackingPhotoRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKING_PHOTO_ROW, BackingPhotoRow);
	g_signal_handlers_destroy (self);
	_g_free0 (self->filepath);
}

static GType
backing_photo_row_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_backing_photo_row_init, value_backing_photo_row_free_value, value_backing_photo_row_copy_value, value_backing_photo_row_peek_pointer, "p", value_backing_photo_row_collect_value, "p", value_backing_photo_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BackingPhotoRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) backing_photo_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackingPhotoRow), 0, (GInstanceInitFunc) backing_photo_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType backing_photo_row_type_id;
	backing_photo_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BackingPhotoRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return backing_photo_row_type_id;
}

GType
backing_photo_row_get_type (void)
{
	static volatile gsize backing_photo_row_type_id__once = 0;
	if (g_once_init_enter (&backing_photo_row_type_id__once)) {
		GType backing_photo_row_type_id;
		backing_photo_row_type_id = backing_photo_row_get_type_once ();
		g_once_init_leave (&backing_photo_row_type_id__once, backing_photo_row_type_id);
	}
	return backing_photo_row_type_id__once;
}

gpointer
backing_photo_row_ref (gpointer instance)
{
	BackingPhotoRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
backing_photo_row_unref (gpointer instance)
{
	BackingPhotoRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BACKING_PHOTO_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static BackingPhotoTable*
backing_photo_table_construct (GType object_type)
{
	BackingPhotoTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	self = (BackingPhotoTable*) database_table_construct (object_type);
	database_table_set_table_name ((DatabaseTable*) self, "BackingPhotoTable");
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE TABLE IF NOT EXISTS " "BackingPhotoTable " "(" "id INTEGER PRIMARY KEY, " "filepath TEXT UNIQUE NOT NULL, " "timestamp INTEGER, " "filesize INTEGER, " "width INTEGER, " "height INTEGER, " "original_orientation INTEGER, " "file_format INTEGER, " "time_created INTEGER)");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	res = sqlite3_step (_tmp1_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create PhotoBackingTable", res);
	}
	_sqlite3_finalize0 (stmt);
	return self;
}

static BackingPhotoTable*
backing_photo_table_new (void)
{
	return backing_photo_table_construct (TYPE_BACKING_PHOTO_TABLE);
}

BackingPhotoTable*
backing_photo_table_get_instance (void)
{
	BackingPhotoTable* _tmp0_;
	BackingPhotoTable* _tmp2_;
	BackingPhotoTable* _tmp3_;
	BackingPhotoTable* result;
	_tmp0_ = backing_photo_table_instance;
	if (_tmp0_ == NULL) {
		BackingPhotoTable* _tmp1_;
		_tmp1_ = backing_photo_table_new ();
		_database_table_unref0 (backing_photo_table_instance);
		backing_photo_table_instance = _tmp1_;
	}
	_tmp2_ = backing_photo_table_instance;
	_tmp3_ = _database_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

void
backing_photo_table_add (BackingPhotoTable* self,
                         BackingPhotoRow* state,
                         GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint64 time_created = 0LL;
	sqlite3_stmt* _tmp1_;
	const gchar* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	sqlite3_stmt* _tmp5_;
	Dimensions _tmp6_;
	sqlite3_stmt* _tmp7_;
	Dimensions _tmp8_;
	sqlite3_stmt* _tmp9_;
	sqlite3_stmt* _tmp10_;
	sqlite3_stmt* _tmp11_;
	gint res = 0;
	sqlite3_stmt* _tmp12_;
	sqlite3* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "INSERT INTO BackingPhotoTable " "(filepath, timestamp, filesize, width, height, original_orientation, " "file_format, time_created) " "VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
	stmt = _tmp0_;
	time_created = now_sec ();
	_tmp1_ = stmt;
	_tmp2_ = state->filepath;
	database_table_bind_text (_tmp1_, 1, _tmp2_);
	_tmp3_ = stmt;
	database_table_bind_int64 (_tmp3_, 2, state->timestamp);
	_tmp4_ = stmt;
	database_table_bind_int64 (_tmp4_, 3, state->filesize);
	_tmp5_ = stmt;
	_tmp6_ = state->dim;
	database_table_bind_int (_tmp5_, 4, _tmp6_.width);
	_tmp7_ = stmt;
	_tmp8_ = state->dim;
	database_table_bind_int (_tmp7_, 5, _tmp8_.height);
	_tmp9_ = stmt;
	database_table_bind_int (_tmp9_, 6, (gint) state->original_orientation);
	_tmp10_ = stmt;
	database_table_bind_int (_tmp10_, 7, photo_file_format_serialize (state->file_format));
	_tmp11_ = stmt;
	database_table_bind_int64 (_tmp11_, 8, time_created);
	_tmp12_ = stmt;
	res = sqlite3_step (_tmp12_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("PhotoBackingTable.add", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_tmp13_ = database_table_db;
	backing_photo_id_init (&state->id, sqlite3_last_insert_rowid (_tmp13_));
	state->time_created = time_created;
	_sqlite3_finalize0 (stmt);
}

BackingPhotoRow*
backing_photo_table_fetch (BackingPhotoTable* self,
                           BackingPhotoID* id,
                           GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	BackingPhotoID _tmp2_;
	gint res = 0;
	sqlite3_stmt* _tmp3_;
	BackingPhotoRow* row = NULL;
	BackingPhotoRow* _tmp4_;
	BackingPhotoRow* _tmp5_;
	BackingPhotoID _tmp6_;
	BackingPhotoRow* _tmp7_;
	sqlite3_stmt* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	BackingPhotoRow* _tmp11_;
	sqlite3_stmt* _tmp12_;
	BackingPhotoRow* _tmp13_;
	sqlite3_stmt* _tmp14_;
	BackingPhotoRow* _tmp15_;
	sqlite3_stmt* _tmp16_;
	sqlite3_stmt* _tmp17_;
	BackingPhotoRow* _tmp18_;
	sqlite3_stmt* _tmp19_;
	BackingPhotoRow* _tmp20_;
	sqlite3_stmt* _tmp21_;
	BackingPhotoRow* _tmp22_;
	sqlite3_stmt* _tmp23_;
	GError* _inner_error0_ = NULL;
	BackingPhotoRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT filepath, timestamp, filesize, width, height, " "original_orientation, file_format, time_created FROM BackingPhotoTable" \
" WHERE id=?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = *id;
	database_table_bind_int64 (_tmp1_, 1, _tmp2_.id);
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res == SQLITE_DONE) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	} else {
		if (res != SQLITE_ROW) {
			database_table_throw_error ("BackingPhotoTable.fetch_for_photo", res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_sqlite3_finalize0 (stmt);
					return NULL;
				} else {
					_sqlite3_finalize0 (stmt);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	}
	_tmp4_ = backing_photo_row_new ();
	row = _tmp4_;
	_tmp5_ = row;
	_tmp6_ = *id;
	_tmp5_->id = _tmp6_;
	_tmp7_ = row;
	_tmp8_ = stmt;
	_tmp9_ = (const gchar*) sqlite3_column_text (_tmp8_, 0);
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (_tmp7_->filepath);
	_tmp7_->filepath = _tmp10_;
	_tmp11_ = row;
	_tmp12_ = stmt;
	_tmp11_->timestamp = sqlite3_column_int64 (_tmp12_, 1);
	_tmp13_ = row;
	_tmp14_ = stmt;
	_tmp13_->filesize = sqlite3_column_int64 (_tmp14_, 2);
	_tmp15_ = row;
	_tmp16_ = stmt;
	_tmp17_ = stmt;
	dimensions_init (&_tmp15_->dim, sqlite3_column_int (_tmp16_, 3), sqlite3_column_int (_tmp17_, 4));
	_tmp18_ = row;
	_tmp19_ = stmt;
	_tmp18_->original_orientation = (Orientation) sqlite3_column_int (_tmp19_, 5);
	_tmp20_ = row;
	_tmp21_ = stmt;
	_tmp20_->file_format = photo_file_format_unserialize (sqlite3_column_int (_tmp21_, 6));
	_tmp22_ = row;
	_tmp23_ = stmt;
	_tmp22_->time_created = sqlite3_column_int64 (_tmp23_, 7);
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
backing_photo_table_update (BackingPhotoTable* self,
                            BackingPhotoRow* row,
                            GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	Dimensions _tmp4_;
	sqlite3_stmt* _tmp5_;
	Dimensions _tmp6_;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp8_;
	sqlite3_stmt* _tmp9_;
	BackingPhotoID _tmp10_;
	gint res = 0;
	sqlite3_stmt* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "UPDATE BackingPhotoTable SET timestamp=?, filesize=?, " "width=?, height=?, original_orientation=?, file_format=? " "WHERE id=?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	database_table_bind_int64 (_tmp1_, 1, row->timestamp);
	_tmp2_ = stmt;
	database_table_bind_int64 (_tmp2_, 2, row->filesize);
	_tmp3_ = stmt;
	_tmp4_ = row->dim;
	database_table_bind_int (_tmp3_, 3, _tmp4_.width);
	_tmp5_ = stmt;
	_tmp6_ = row->dim;
	database_table_bind_int (_tmp5_, 4, _tmp6_.height);
	_tmp7_ = stmt;
	database_table_bind_int (_tmp7_, 5, (gint) row->original_orientation);
	_tmp8_ = stmt;
	database_table_bind_int (_tmp8_, 6, photo_file_format_serialize (row->file_format));
	_tmp9_ = stmt;
	_tmp10_ = row->id;
	database_table_bind_int64 (_tmp9_, 7, _tmp10_.id);
	_tmp11_ = stmt;
	res = sqlite3_step (_tmp11_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("BackingPhotoTable.update", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

void
backing_photo_table_update_attributes (BackingPhotoTable* self,
                                       BackingPhotoID* id,
                                       gint64 timestamp,
                                       gint64 filesize,
                                       GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	BackingPhotoID _tmp4_;
	gint res = 0;
	sqlite3_stmt* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "UPDATE BackingPhotoTable SET timestamp=?, filesize=? WHERE id=?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	database_table_bind_int64 (_tmp1_, 1, timestamp);
	_tmp2_ = stmt;
	database_table_bind_int64 (_tmp2_, 2, filesize);
	_tmp3_ = stmt;
	_tmp4_ = *id;
	database_table_bind_int64 (_tmp3_, 3, _tmp4_.id);
	_tmp5_ = stmt;
	res = sqlite3_step (_tmp5_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("BackingPhotoTable.update_attributes", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

void
backing_photo_table_remove (BackingPhotoTable* self,
                            BackingPhotoID* backing_id,
                            GError** error)
{
	BackingPhotoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backing_id != NULL);
	_tmp0_ = *backing_id;
	database_table_delete_by_id ((DatabaseTable*) self, _tmp0_.id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
backing_photo_table_set_filepath (BackingPhotoTable* self,
                                  BackingPhotoID* id,
                                  const gchar* filepath,
                                  GError** error)
{
	BackingPhotoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (filepath != NULL);
	_tmp0_ = *id;
	database_table_update_text_by_id_2 ((DatabaseTable*) self, _tmp0_.id, "filepath", filepath, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
backing_photo_table_update_timestamp (BackingPhotoTable* self,
                                      BackingPhotoID* id,
                                      gint64 timestamp,
                                      GError** error)
{
	BackingPhotoID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = *id;
	database_table_update_int64_by_id_2 ((DatabaseTable*) self, _tmp0_.id, "timestamp", timestamp, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
backing_photo_table_class_init (BackingPhotoTableClass * klass,
                                gpointer klass_data)
{
	backing_photo_table_parent_class = g_type_class_peek_parent (klass);
	((DatabaseTableClass *) klass)->finalize = backing_photo_table_finalize;
}

static void
backing_photo_table_instance_init (BackingPhotoTable * self,
                                   gpointer klass)
{
}

static void
backing_photo_table_finalize (DatabaseTable * obj)
{
	BackingPhotoTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKING_PHOTO_TABLE, BackingPhotoTable);
	DATABASE_TABLE_CLASS (backing_photo_table_parent_class)->finalize (obj);
}

static GType
backing_photo_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BackingPhotoTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) backing_photo_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackingPhotoTable), 0, (GInstanceInitFunc) backing_photo_table_instance_init, NULL };
	GType backing_photo_table_type_id;
	backing_photo_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "BackingPhotoTable", &g_define_type_info, 0);
	return backing_photo_table_type_id;
}

GType
backing_photo_table_get_type (void)
{
	static volatile gsize backing_photo_table_type_id__once = 0;
	if (g_once_init_enter (&backing_photo_table_type_id__once)) {
		GType backing_photo_table_type_id;
		backing_photo_table_type_id = backing_photo_table_get_type_once ();
		g_once_init_leave (&backing_photo_table_type_id__once, backing_photo_table_type_id);
	}
	return backing_photo_table_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

