/* GdkSupport.c generated by valac 0.56.18, the Vala compiler
 * generated from GdkSupport.vala, do not modify */

/*
* Copyright (c) 2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))

struct _GdkSnifferPrivate {
	DetectedPhotoInformation* detected;
	gboolean size_ready;
	gboolean area_prepared;
};

static gpointer gdk_reader_parent_class = NULL;
static gint GdkSniffer_private_offset;
static gpointer gdk_sniffer_parent_class = NULL;

static PhotoMetadata* gdk_reader_real_read_metadata (PhotoFileReader* base,
                                              GError** error);
static GdkPixbuf* gdk_reader_real_unscaled_read (PhotoFileReader* base,
                                          GError** error);
static GdkPixbuf* gdk_reader_real_scaled_read (PhotoFileReader* base,
                                        Dimensions* full,
                                        Dimensions* scaled,
                                        GError** error);
static GType gdk_reader_get_type_once (void);
static DetectedPhotoInformation* gdk_sniffer_real_sniff (PhotoFileSniffer* base,
                                                  GError** error);
static void gdk_sniffer_on_size_prepared (GdkSniffer* self,
                                   GdkPixbufLoader* loader,
                                   gint width,
                                   gint height);
static void _gdk_sniffer_on_size_prepared_gdk_pixbuf_loader_size_prepared (GdkPixbufLoader* _sender,
                                                                    gint width,
                                                                    gint height,
                                                                    gpointer self);
static void gdk_sniffer_on_area_prepared (GdkSniffer* self,
                                   GdkPixbufLoader* pixbuf_loader);
static void _gdk_sniffer_on_area_prepared_gdk_pixbuf_loader_area_prepared (GdkPixbufLoader* _sender,
                                                                    gpointer self);
static guint8* _vala_array_dup8 (guint8* self,
                          gssize length);
static void gdk_sniffer_finalize (PhotoFileSniffer * obj);
static GType gdk_sniffer_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GdkReader*
gdk_reader_construct (GType object_type,
                      const gchar* filepath,
                      PhotoFileFormat file_format)
{
	GdkReader* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (GdkReader*) photo_file_reader_construct (object_type, filepath, file_format);
	return self;
}

static PhotoMetadata*
gdk_reader_real_read_metadata (PhotoFileReader* base,
                               GError** error)
{
	GdkReader * self;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	PhotoMetadata* result;
	self = (GdkReader*) base;
	_tmp0_ = photo_metadata_new ();
	metadata = _tmp0_;
	_tmp1_ = photo_file_adapter_get_file ((PhotoFileAdapter*) self);
	_tmp2_ = _tmp1_;
	media_metadata_read_from_file ((MediaMetadata*) metadata, _tmp2_, &_inner_error0_);
	_g_object_unref0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		return NULL;
	}
	result = metadata;
	return result;
}

static GdkPixbuf*
gdk_reader_real_unscaled_read (PhotoFileReader* base,
                               GError** error)
{
	GdkReader * self;
	GdkPixbuf* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (GdkReader*) base;
	_tmp1_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gdk_pixbuf_new_from_file (_tmp2_, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static GdkPixbuf*
gdk_reader_real_scaled_read (PhotoFileReader* base,
                             Dimensions* full,
                             Dimensions* scaled,
                             GError** error)
{
	GdkReader * self;
	GdkPixbuf* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	Dimensions _tmp3_;
	Dimensions _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (GdkReader*) base;
	g_return_val_if_fail (full != NULL, NULL);
	g_return_val_if_fail (scaled != NULL, NULL);
	_tmp1_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = *scaled;
	_tmp4_ = *scaled;
	_tmp5_ = gdk_pixbuf_new_from_file_at_scale (_tmp2_, _tmp3_.width, _tmp4_.height, FALSE, &_inner_error0_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp7_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp7_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static void
gdk_reader_class_init (GdkReaderClass * klass,
                       gpointer klass_data)
{
	gdk_reader_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileReaderClass *) klass)->read_metadata = (PhotoMetadata* (*) (PhotoFileReader*, GError**)) gdk_reader_real_read_metadata;
	((PhotoFileReaderClass *) klass)->unscaled_read = (GdkPixbuf* (*) (PhotoFileReader*, GError**)) gdk_reader_real_unscaled_read;
	((PhotoFileReaderClass *) klass)->scaled_read = (GdkPixbuf* (*) (PhotoFileReader*, Dimensions*, Dimensions*, GError**)) gdk_reader_real_scaled_read;
}

static void
gdk_reader_instance_init (GdkReader * self,
                          gpointer klass)
{
}

static GType
gdk_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GdkReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gdk_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GdkReader), 0, (GInstanceInitFunc) gdk_reader_instance_init, NULL };
	GType gdk_reader_type_id;
	gdk_reader_type_id = g_type_register_static (TYPE_PHOTO_FILE_READER, "GdkReader", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return gdk_reader_type_id;
}

GType
gdk_reader_get_type (void)
{
	static volatile gsize gdk_reader_type_id__once = 0;
	if (g_once_init_enter (&gdk_reader_type_id__once)) {
		GType gdk_reader_type_id;
		gdk_reader_type_id = gdk_reader_get_type_once ();
		g_once_init_leave (&gdk_reader_type_id__once, gdk_reader_type_id);
	}
	return gdk_reader_type_id__once;
}

static inline gpointer
gdk_sniffer_get_instance_private (GdkSniffer* self)
{
	return G_STRUCT_MEMBER_P (self, GdkSniffer_private_offset);
}

GdkSniffer*
gdk_sniffer_construct (GType object_type,
                       GFile* file,
                       PhotoFileSnifferOptions options)
{
	GdkSniffer* self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GdkSniffer*) photo_file_sniffer_construct (object_type, file, options);
	return self;
}

static void
_gdk_sniffer_on_size_prepared_gdk_pixbuf_loader_size_prepared (GdkPixbufLoader* _sender,
                                                               gint width,
                                                               gint height,
                                                               gpointer self)
{
	gdk_sniffer_on_size_prepared ((GdkSniffer*) self, _sender, width, height);
}

static void
_gdk_sniffer_on_area_prepared_gdk_pixbuf_loader_area_prepared (GdkPixbufLoader* _sender,
                                                               gpointer self)
{
	gdk_sniffer_on_area_prepared ((GdkSniffer*) self, _sender);
}

static guint8*
_vala_array_dup8 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static gpointer
_detected_photo_information_ref0 (gpointer self)
{
	return self ? detected_photo_information_ref (self) : NULL;
}

static DetectedPhotoInformation*
gdk_sniffer_real_sniff (PhotoFileSniffer* base,
                        GError** error)
{
	GdkSniffer * self;
	DetectedPhotoInformation* _tmp0_;
	GdkPixbufLoader* pixbuf_loader = NULL;
	GdkPixbufLoader* _tmp1_;
	GdkPixbufLoader* _tmp2_;
	GdkPixbufLoader* _tmp3_;
	GChecksum* md5_checksum = NULL;
	DetectedPhotoInformation* _tmp5_;
	PhotoMetadata* _tmp6_;
	gboolean _tmp11_ = FALSE;
	guint8* _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	gint __tmp36__size_ = 0;
	guint8* buffer = NULL;
	guint8* _tmp39_;
	gint _tmp39__length1;
	gint buffer_length1;
	gint _buffer_size_;
	gsize count = 0UL;
	GFileInputStream* fins = NULL;
	GFile* _tmp40_;
	GFileInputStream* _tmp41_;
	GFileInputStream* _tmp53_;
	DetectedPhotoInformation* _tmp59_;
	DetectedPhotoInformation* _tmp60_;
	GError* _inner_error0_ = NULL;
	DetectedPhotoInformation* result;
	self = (GdkSniffer*) base;
	_tmp0_ = detected_photo_information_new ();
	_detected_photo_information_unref0 (self->priv->detected);
	self->priv->detected = _tmp0_;
	_tmp1_ = gdk_pixbuf_loader_new ();
	pixbuf_loader = _tmp1_;
	_tmp2_ = pixbuf_loader;
	g_signal_connect (_tmp2_, "size-prepared", (GCallback) _gdk_sniffer_on_size_prepared_gdk_pixbuf_loader_size_prepared, self);
	_tmp3_ = pixbuf_loader;
	g_signal_connect (_tmp3_, "area-prepared", (GCallback) _gdk_sniffer_on_area_prepared_gdk_pixbuf_loader_area_prepared, self);
	md5_checksum = NULL;
	if (((PhotoFileSniffer*) self)->calc_md5) {
		GChecksum* _tmp4_;
		_tmp4_ = g_checksum_new (G_CHECKSUM_MD5);
		_g_checksum_free0 (md5_checksum);
		md5_checksum = _tmp4_;
	}
	_tmp5_ = self->priv->detected;
	_tmp6_ = photo_metadata_new ();
	_media_metadata_unref0 (_tmp5_->metadata);
	_tmp5_->metadata = _tmp6_;
	{
		DetectedPhotoInformation* _tmp7_;
		PhotoMetadata* _tmp8_;
		GFile* _tmp9_;
		_tmp7_ = self->priv->detected;
		_tmp8_ = _tmp7_->metadata;
		_tmp9_ = ((PhotoFileSniffer*) self)->file;
		media_metadata_read_from_file ((MediaMetadata*) _tmp8_, _tmp9_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		DetectedPhotoInformation* _tmp10_;
		g_clear_error (&_inner_error0_);
		_tmp10_ = self->priv->detected;
		_media_metadata_unref0 (_tmp10_->metadata);
		_tmp10_->metadata = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_checksum_free0 (md5_checksum);
		_g_object_unref0 (pixbuf_loader);
		return NULL;
	}
	if (((PhotoFileSniffer*) self)->calc_md5) {
		DetectedPhotoInformation* _tmp12_;
		PhotoMetadata* _tmp13_;
		_tmp12_ = self->priv->detected;
		_tmp13_ = _tmp12_->metadata;
		_tmp11_ = _tmp13_ != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		guint8* flattened_sans_thumbnail = NULL;
		DetectedPhotoInformation* _tmp14_;
		PhotoMetadata* _tmp15_;
		gint _tmp16_ = 0;
		guint8* _tmp17_;
		gint flattened_sans_thumbnail_length1;
		gint _flattened_sans_thumbnail_size_;
		gboolean _tmp18_ = FALSE;
		guint8* _tmp19_;
		gint _tmp19__length1;
		guint8* flattened_thumbnail = NULL;
		DetectedPhotoInformation* _tmp25_;
		PhotoMetadata* _tmp26_;
		gint _tmp27_ = 0;
		guint8* _tmp28_;
		gint flattened_thumbnail_length1;
		gint _flattened_thumbnail_size_;
		gboolean _tmp29_ = FALSE;
		guint8* _tmp30_;
		gint _tmp30__length1;
		_tmp14_ = self->priv->detected;
		_tmp15_ = _tmp14_->metadata;
		_tmp17_ = photo_metadata_flatten_exif (_tmp15_, FALSE, &_tmp16_);
		flattened_sans_thumbnail = _tmp17_;
		flattened_sans_thumbnail_length1 = _tmp16_;
		_flattened_sans_thumbnail_size_ = flattened_sans_thumbnail_length1;
		_tmp19_ = flattened_sans_thumbnail;
		_tmp19__length1 = flattened_sans_thumbnail_length1;
		if (_tmp19_ != NULL) {
			guint8* _tmp20_;
			gint _tmp20__length1;
			_tmp20_ = flattened_sans_thumbnail;
			_tmp20__length1 = flattened_sans_thumbnail_length1;
			_tmp18_ = _tmp20__length1 > 0;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			DetectedPhotoInformation* _tmp21_;
			guint8* _tmp22_;
			gint _tmp22__length1;
			guint8* _tmp23_;
			gint _tmp23__length1;
			gchar* _tmp24_;
			_tmp21_ = self->priv->detected;
			_tmp22_ = flattened_sans_thumbnail;
			_tmp22__length1 = flattened_sans_thumbnail_length1;
			_tmp23_ = flattened_sans_thumbnail;
			_tmp23__length1 = flattened_sans_thumbnail_length1;
			_tmp24_ = md5_binary (_tmp22_, (gsize) _tmp23__length1);
			_g_free0 (_tmp21_->exif_md5);
			_tmp21_->exif_md5 = _tmp24_;
		}
		_tmp25_ = self->priv->detected;
		_tmp26_ = _tmp25_->metadata;
		_tmp28_ = photo_metadata_flatten_exif_preview (_tmp26_, &_tmp27_);
		flattened_thumbnail = _tmp28_;
		flattened_thumbnail_length1 = _tmp27_;
		_flattened_thumbnail_size_ = flattened_thumbnail_length1;
		_tmp30_ = flattened_thumbnail;
		_tmp30__length1 = flattened_thumbnail_length1;
		if (_tmp30_ != NULL) {
			guint8* _tmp31_;
			gint _tmp31__length1;
			_tmp31_ = flattened_thumbnail;
			_tmp31__length1 = flattened_thumbnail_length1;
			_tmp29_ = _tmp31__length1 > 0;
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			DetectedPhotoInformation* _tmp32_;
			guint8* _tmp33_;
			gint _tmp33__length1;
			guint8* _tmp34_;
			gint _tmp34__length1;
			gchar* _tmp35_;
			_tmp32_ = self->priv->detected;
			_tmp33_ = flattened_thumbnail;
			_tmp33__length1 = flattened_thumbnail_length1;
			_tmp34_ = flattened_thumbnail;
			_tmp34__length1 = flattened_thumbnail_length1;
			_tmp35_ = md5_binary (_tmp33_, (gsize) _tmp34__length1);
			_g_free0 (_tmp32_->thumbnail_md5);
			_tmp32_->thumbnail_md5 = _tmp35_;
		}
		flattened_thumbnail = (g_free (flattened_thumbnail), NULL);
		flattened_sans_thumbnail = (g_free (flattened_sans_thumbnail), NULL);
	}
	if (((PhotoFileSniffer*) self)->calc_md5) {
		guint8* _tmp37_;
		_tmp37_ = g_new0 (guint8, 64 * 1024);
		_tmp36_ = (g_free (_tmp36_), NULL);
		_tmp36_ = _tmp37_;
		_tmp36__length1 = 64 * 1024;
		__tmp36__size_ = _tmp36__length1;
	} else {
		guint8* _tmp38_;
		_tmp38_ = g_new0 (guint8, 8 * 1024);
		_tmp36_ = (g_free (_tmp36_), NULL);
		_tmp36_ = _tmp38_;
		_tmp36__length1 = 8 * 1024;
		__tmp36__size_ = _tmp36__length1;
	}
	_tmp39_ = (_tmp36_ != NULL) ? _vala_array_dup8 (_tmp36_, _tmp36__length1) : _tmp36_;
	_tmp39__length1 = _tmp36__length1;
	buffer = _tmp39_;
	buffer_length1 = _tmp39__length1;
	_buffer_size_ = buffer_length1;
	count = (gsize) 0;
	_tmp40_ = ((PhotoFileSniffer*) self)->file;
	_tmp41_ = g_file_read (_tmp40_, NULL, &_inner_error0_);
	fins = _tmp41_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		buffer = (g_free (buffer), NULL);
		_tmp36_ = (g_free (_tmp36_), NULL);
		_g_checksum_free0 (md5_checksum);
		_g_object_unref0 (pixbuf_loader);
		return NULL;
	}
	{
		gboolean _tmp42_ = FALSE;
		_tmp42_ = TRUE;
		while (TRUE) {
			gsize bytes_read = 0UL;
			GFileInputStream* _tmp43_;
			guint8* _tmp44_;
			gint _tmp44__length1;
			gboolean _tmp47_ = FALSE;
			gboolean _tmp50_ = FALSE;
			gboolean _tmp51_ = FALSE;
			if (!_tmp42_) {
			}
			_tmp42_ = FALSE;
			_tmp43_ = fins;
			_tmp44_ = buffer;
			_tmp44__length1 = buffer_length1;
			bytes_read = (gsize) g_input_stream_read ((GInputStream*) _tmp43_, _tmp44_, (gsize) _tmp44__length1, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (fins);
				buffer = (g_free (buffer), NULL);
				_tmp36_ = (g_free (_tmp36_), NULL);
				_g_checksum_free0 (md5_checksum);
				_g_object_unref0 (pixbuf_loader);
				return NULL;
			}
			if (bytes_read <= ((gsize) 0)) {
				break;
			}
			count += bytes_read;
			if (((PhotoFileSniffer*) self)->calc_md5) {
				GChecksum* _tmp45_;
				guint8* _tmp46_;
				gint _tmp46__length1;
				_tmp45_ = md5_checksum;
				_tmp46_ = buffer;
				_tmp46__length1 = buffer_length1;
				g_checksum_update (_tmp45_, _tmp46_, bytes_read);
			}
			if (!self->priv->size_ready) {
				_tmp47_ = TRUE;
			} else {
				_tmp47_ = !self->priv->area_prepared;
			}
			if (_tmp47_) {
				GdkPixbufLoader* _tmp48_;
				guint8* _tmp49_;
				gint _tmp49__length1;
				_tmp48_ = pixbuf_loader;
				_tmp49_ = buffer;
				_tmp49__length1 = buffer_length1;
				gdk_pixbuf_loader_write (_tmp48_, _tmp49_ + 0, (gsize) (((gint) bytes_read) - 0), &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (fins);
					buffer = (g_free (buffer), NULL);
					_tmp36_ = (g_free (_tmp36_), NULL);
					_g_checksum_free0 (md5_checksum);
					_g_object_unref0 (pixbuf_loader);
					return NULL;
				}
			}
			if (!((PhotoFileSniffer*) self)->calc_md5) {
				_tmp51_ = self->priv->size_ready;
			} else {
				_tmp51_ = FALSE;
			}
			if (_tmp51_) {
				_tmp50_ = self->priv->area_prepared;
			} else {
				_tmp50_ = FALSE;
			}
			if (_tmp50_) {
				break;
			}
		}
	}
	{
		GdkPixbufLoader* _tmp52_;
		_tmp52_ = pixbuf_loader;
		gdk_pixbuf_loader_close (_tmp52_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fins);
		buffer = (g_free (buffer), NULL);
		_tmp36_ = (g_free (_tmp36_), NULL);
		_g_checksum_free0 (md5_checksum);
		_g_object_unref0 (pixbuf_loader);
		return NULL;
	}
	_tmp53_ = fins;
	if (_tmp53_ != NULL) {
		GFileInputStream* _tmp54_;
		_tmp54_ = fins;
		g_input_stream_close ((GInputStream*) _tmp54_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (fins);
			buffer = (g_free (buffer), NULL);
			_tmp36_ = (g_free (_tmp36_), NULL);
			_g_checksum_free0 (md5_checksum);
			_g_object_unref0 (pixbuf_loader);
			return NULL;
		}
	}
	if (((PhotoFileSniffer*) self)->calc_md5) {
		DetectedPhotoInformation* _tmp55_;
		GChecksum* _tmp56_;
		const gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp55_ = self->priv->detected;
		_tmp56_ = md5_checksum;
		_tmp57_ = g_checksum_get_string (_tmp56_);
		_tmp58_ = g_strdup (_tmp57_);
		_g_free0 (_tmp55_->md5);
		_tmp55_->md5 = _tmp58_;
	}
	_tmp59_ = self->priv->detected;
	_tmp60_ = _detected_photo_information_ref0 (_tmp59_);
	result = _tmp60_;
	_g_object_unref0 (fins);
	buffer = (g_free (buffer), NULL);
	_tmp36_ = (g_free (_tmp36_), NULL);
	_g_checksum_free0 (md5_checksum);
	_g_object_unref0 (pixbuf_loader);
	return result;
}

static void
gdk_sniffer_on_size_prepared (GdkSniffer* self,
                              GdkPixbufLoader* loader,
                              gint width,
                              gint height)
{
	DetectedPhotoInformation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (loader != NULL);
	_tmp0_ = self->priv->detected;
	dimensions_init (&_tmp0_->image_dim, width, height);
	self->priv->size_ready = TRUE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gdk_sniffer_on_area_prepared (GdkSniffer* self,
                              GdkPixbufLoader* pixbuf_loader)
{
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	DetectedPhotoInformation* _tmp3_;
	GdkPixbuf* _tmp4_;
	DetectedPhotoInformation* _tmp5_;
	GdkPixbuf* _tmp6_;
	DetectedPhotoInformation* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbufFormat* format = NULL;
	GdkPixbufFormat* _tmp9_;
	DetectedPhotoInformation* _tmp10_;
	GdkPixbufFormat* _tmp11_;
	gchar* _tmp12_;
	DetectedPhotoInformation* _tmp13_;
	DetectedPhotoInformation* _tmp14_;
	const gchar* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf_loader != NULL);
	_tmp0_ = gdk_pixbuf_loader_get_pixbuf (pixbuf_loader);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	pixbuf = _tmp1_;
	_tmp2_ = pixbuf;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (pixbuf);
		return;
	}
	_tmp3_ = self->priv->detected;
	_tmp4_ = pixbuf;
	_tmp3_->colorspace = gdk_pixbuf_get_colorspace (_tmp4_);
	_tmp5_ = self->priv->detected;
	_tmp6_ = pixbuf;
	_tmp5_->channels = gdk_pixbuf_get_n_channels (_tmp6_);
	_tmp7_ = self->priv->detected;
	_tmp8_ = pixbuf;
	_tmp7_->bits_per_channel = gdk_pixbuf_get_bits_per_sample (_tmp8_);
	_tmp9_ = gdk_pixbuf_loader_get_format (pixbuf_loader);
	format = _tmp9_;
	_tmp10_ = self->priv->detected;
	_tmp11_ = format;
	_tmp12_ = gdk_pixbuf_format_get_name (_tmp11_);
	_g_free0 (_tmp10_->format_name);
	_tmp10_->format_name = _tmp12_;
	_tmp13_ = self->priv->detected;
	_tmp14_ = self->priv->detected;
	_tmp15_ = _tmp14_->format_name;
	_tmp13_->file_format = photo_file_format_from_pixbuf_name (_tmp15_);
	self->priv->area_prepared = TRUE;
	_g_object_unref0 (pixbuf);
}

static void
gdk_sniffer_class_init (GdkSnifferClass * klass,
                        gpointer klass_data)
{
	gdk_sniffer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileSnifferClass *) klass)->finalize = gdk_sniffer_finalize;
	g_type_class_adjust_private_offset (klass, &GdkSniffer_private_offset);
	((PhotoFileSnifferClass *) klass)->sniff = (DetectedPhotoInformation* (*) (PhotoFileSniffer*, GError**)) gdk_sniffer_real_sniff;
}

static void
gdk_sniffer_instance_init (GdkSniffer * self,
                           gpointer klass)
{
	self->priv = gdk_sniffer_get_instance_private (self);
	self->priv->detected = NULL;
	self->priv->size_ready = FALSE;
	self->priv->area_prepared = FALSE;
}

static void
gdk_sniffer_finalize (PhotoFileSniffer * obj)
{
	GdkSniffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GDK_SNIFFER, GdkSniffer);
	_detected_photo_information_unref0 (self->priv->detected);
	PHOTO_FILE_SNIFFER_CLASS (gdk_sniffer_parent_class)->finalize (obj);
}

static GType
gdk_sniffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GdkSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gdk_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GdkSniffer), 0, (GInstanceInitFunc) gdk_sniffer_instance_init, NULL };
	GType gdk_sniffer_type_id;
	gdk_sniffer_type_id = g_type_register_static (TYPE_PHOTO_FILE_SNIFFER, "GdkSniffer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GdkSniffer_private_offset = g_type_add_instance_private (gdk_sniffer_type_id, sizeof (GdkSnifferPrivate));
	return gdk_sniffer_type_id;
}

GType
gdk_sniffer_get_type (void)
{
	static volatile gsize gdk_sniffer_type_id__once = 0;
	if (g_once_init_enter (&gdk_sniffer_type_id__once)) {
		GType gdk_sniffer_type_id;
		gdk_sniffer_type_id = gdk_sniffer_get_type_once ();
		g_once_init_leave (&gdk_sniffer_type_id__once, gdk_sniffer_type_id);
	}
	return gdk_sniffer_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

