/* PhotoFileFormat.c generated by valac 0.56.18, the Vala compiler
 * generated from PhotoFileFormat.vala, do not modify */

/*
* Copyright (c) 2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gphoto2/gphoto2-file.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef gboolean (*PhotoFileFormatDataApplicableTest) (PhotoFileFormat format, gpointer user_data);
#define _g_free0(var) (var = (g_free (var), NULL))
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
#define _photo_file_format_driver_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_driver_unref (var), NULL)))
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))
typedef struct _ParamSpecPhotoFileFormatDriver ParamSpecPhotoFileFormatDriver;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecPhotoFileFormatProperties ParamSpecPhotoFileFormatProperties;

struct _ParamSpecPhotoFileFormatDriver {
	GParamSpec parent_instance;
};

struct _ParamSpecPhotoFileFormatProperties {
	GParamSpec parent_instance;
};

VALA_EXTERN PhotoFileFormat* photo_file_format_data_writeable;
VALA_EXTERN gint photo_file_format_data_writeable_length1;
PhotoFileFormat* photo_file_format_data_writeable = NULL;
gint photo_file_format_data_writeable_length1 = 0;
static gint _photo_file_format_data_writeable_size_ = 0;
VALA_EXTERN PhotoFileFormat* photo_file_format_data_image_writeable;
VALA_EXTERN gint photo_file_format_data_image_writeable_length1;
PhotoFileFormat* photo_file_format_data_image_writeable = NULL;
gint photo_file_format_data_image_writeable_length1 = 0;
static gint _photo_file_format_data_image_writeable_size_ = 0;
VALA_EXTERN PhotoFileFormat* photo_file_format_data_metadata_writeable;
VALA_EXTERN gint photo_file_format_data_metadata_writeable_length1;
PhotoFileFormat* photo_file_format_data_metadata_writeable = NULL;
gint photo_file_format_data_metadata_writeable_length1 = 0;
static gint _photo_file_format_data_metadata_writeable_size_ = 0;
static gpointer photo_file_format_driver_parent_class = NULL;
static gpointer photo_file_format_properties_parent_class = NULL;

VALA_EXTERN PhotoFileFormat* photo_file_format_data_find_applicable (PhotoFileFormatDataApplicableTest test,
                                                         gpointer test_target,
                                                         gint* result_length1);
static void _vala_array_add93 (PhotoFileFormat* * array,
                        gint* length,
                        gint* size,
                        PhotoFileFormat value);
static gboolean ___lambda40_ (PhotoFileFormat format);
static gboolean ____lambda40__photo_file_format_data_applicable_test (PhotoFileFormat format,
                                                               gpointer self);
static PhotoFileFormat* _vala_array_dup14 (PhotoFileFormat* self,
                                    gssize length);
static gboolean ___lambda124_ (PhotoFileFormat format);
static gboolean ____lambda124__photo_file_format_data_applicable_test (PhotoFileFormat format,
                                                                gpointer self);
static PhotoFileFormat* _vala_array_dup15 (PhotoFileFormat* self,
                                    gssize length);
static gboolean ___lambda125_ (PhotoFileFormat format);
static gboolean ____lambda125__photo_file_format_data_applicable_test (PhotoFileFormat format,
                                                                gpointer self);
static PhotoFileFormat* _vala_array_dup16 (PhotoFileFormat* self,
                                    gssize length);
static PhotoFileFormatDriver* photo_file_format_get_driver (PhotoFileFormat self);
static PhotoFileFormatProperties* photo_file_format_driver_real_get_properties (PhotoFileFormatDriver* self);
static PhotoFileReader* photo_file_format_driver_real_create_reader (PhotoFileFormatDriver* self,
                                                              const gchar* filepath);
static PhotoMetadata* photo_file_format_driver_real_create_metadata (PhotoFileFormatDriver* self);
static gboolean photo_file_format_driver_real_can_write_image (PhotoFileFormatDriver* self);
static gboolean photo_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* self);
static PhotoFileWriter* photo_file_format_driver_real_create_writer (PhotoFileFormatDriver* self,
                                                              const gchar* filepath);
static PhotoFileMetadataWriter* photo_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* self,
                                                                               const gchar* filepath);
static PhotoFileSniffer* photo_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* self,
                                                                GFile* file,
                                                                PhotoFileSnifferOptions options);
static void photo_file_format_driver_finalize (PhotoFileFormatDriver * obj);
static GType photo_file_format_driver_get_type_once (void);
static PhotoFileFormat photo_file_format_properties_real_get_file_format (PhotoFileFormatProperties* self);
static PhotoFileFormatFlags photo_file_format_properties_real_get_flags (PhotoFileFormatProperties* self);
static gboolean photo_file_format_properties_real_is_recognized_extension (PhotoFileFormatProperties* self,
                                                                    const gchar* ext);
static gchar* photo_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* self);
static gchar** photo_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* self,
                                                                gint* result_length1);
static gchar* photo_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* self);
static gchar** photo_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* self,
                                                          gint* result_length1);
static gchar* photo_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* self);
static void photo_file_format_properties_finalize (PhotoFileFormatProperties * obj);
static GType photo_file_format_properties_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
photo_format_error_quark (void)
{
	return g_quark_from_static_string ("photo-format-error-quark");
}

static GType
photo_format_error_get_type_once (void)
{
	static const GEnumValue values[] = {{PHOTO_FORMAT_ERROR_READ_ONLY, "PHOTO_FORMAT_ERROR_READ_ONLY", "read-only"}, {0, NULL, NULL}};
	GType photo_format_error_type_id;
	photo_format_error_type_id = g_enum_register_static ("PhotoFormatError", values);
	return photo_format_error_type_id;
}

GType
photo_format_error_get_type (void)
{
	static volatile gsize photo_format_error_type_id__once = 0;
	if (g_once_init_enter (&photo_format_error_type_id__once)) {
		GType photo_format_error_type_id;
		photo_format_error_type_id = photo_format_error_get_type_once ();
		g_once_init_leave (&photo_format_error_type_id__once, photo_format_error_type_id);
	}
	return photo_format_error_type_id__once;
}

static void
_vala_array_add93 (PhotoFileFormat* * array,
                   gint* length,
                   gint* size,
                   PhotoFileFormat value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PhotoFileFormat, *array, *size);
	}
	(*array)[(*length)++] = value;
}

PhotoFileFormat*
photo_file_format_data_find_applicable (PhotoFileFormatDataApplicableTest test,
                                        gpointer test_target,
                                        gint* result_length1)
{
	PhotoFileFormat* applicable = NULL;
	PhotoFileFormat* _tmp0_;
	gint applicable_length1;
	gint _applicable_size_;
	gint _tmp1_ = 0;
	PhotoFileFormat* _tmp2_;
	PhotoFileFormat* _tmp3_;
	gint _tmp3__length1;
	PhotoFileFormat* result;
	_tmp0_ = g_new0 (PhotoFileFormat, 0);
	applicable = _tmp0_;
	applicable_length1 = 0;
	_applicable_size_ = applicable_length1;
	_tmp2_ = photo_file_format_get_supported (&_tmp1_);
	{
		PhotoFileFormat* format_collection = NULL;
		gint format_collection_length1 = 0;
		gint _format_collection_size_ = 0;
		gint format_it = 0;
		format_collection = _tmp2_;
		format_collection_length1 = _tmp1_;
		for (format_it = 0; format_it < format_collection_length1; format_it = format_it + 1) {
			PhotoFileFormat format = 0;
			format = format_collection[format_it];
			{
				if (test (format, test_target)) {
					_vala_array_add93 (&applicable, &applicable_length1, &_applicable_size_, format);
				}
			}
		}
		format_collection = (g_free (format_collection), NULL);
	}
	_tmp3_ = applicable;
	_tmp3__length1 = applicable_length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static gboolean
___lambda40_ (PhotoFileFormat format)
{
	gboolean result;
	result = photo_file_format_can_write (format);
	return result;
}

static gboolean
____lambda40__photo_file_format_data_applicable_test (PhotoFileFormat format,
                                                      gpointer self)
{
	gboolean result;
	result = ___lambda40_ (format);
	return result;
}

static PhotoFileFormat*
_vala_array_dup14 (PhotoFileFormat* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (PhotoFileFormat));
	}
	return NULL;
}

PhotoFileFormat*
photo_file_format_data_get_writeable (gint* result_length1)
{
	PhotoFileFormat* _tmp0_;
	gint _tmp0__length1;
	PhotoFileFormat* _tmp3_;
	gint _tmp3__length1;
	PhotoFileFormat* _tmp4_;
	gint _tmp4__length1;
	PhotoFileFormat* _tmp5_;
	gint _tmp5__length1;
	PhotoFileFormat* result;
	_tmp0_ = photo_file_format_data_writeable;
	_tmp0__length1 = photo_file_format_data_writeable_length1;
	if (_tmp0_ == NULL) {
		gint _tmp1_ = 0;
		PhotoFileFormat* _tmp2_;
		_tmp2_ = photo_file_format_data_find_applicable (____lambda40__photo_file_format_data_applicable_test, NULL, &_tmp1_);
		photo_file_format_data_writeable = (g_free (photo_file_format_data_writeable), NULL);
		photo_file_format_data_writeable = _tmp2_;
		photo_file_format_data_writeable_length1 = _tmp1_;
		_photo_file_format_data_writeable_size_ = photo_file_format_data_writeable_length1;
	}
	_tmp3_ = photo_file_format_data_writeable;
	_tmp3__length1 = photo_file_format_data_writeable_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup14 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

static gboolean
___lambda124_ (PhotoFileFormat format)
{
	gboolean result;
	result = photo_file_format_can_write_image (format);
	return result;
}

static gboolean
____lambda124__photo_file_format_data_applicable_test (PhotoFileFormat format,
                                                       gpointer self)
{
	gboolean result;
	result = ___lambda124_ (format);
	return result;
}

static PhotoFileFormat*
_vala_array_dup15 (PhotoFileFormat* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (PhotoFileFormat));
	}
	return NULL;
}

PhotoFileFormat*
photo_file_format_data_get_image_writeable (gint* result_length1)
{
	PhotoFileFormat* _tmp0_;
	gint _tmp0__length1;
	PhotoFileFormat* _tmp3_;
	gint _tmp3__length1;
	PhotoFileFormat* _tmp4_;
	gint _tmp4__length1;
	PhotoFileFormat* _tmp5_;
	gint _tmp5__length1;
	PhotoFileFormat* result;
	_tmp0_ = photo_file_format_data_image_writeable;
	_tmp0__length1 = photo_file_format_data_image_writeable_length1;
	if (_tmp0_ == NULL) {
		gint _tmp1_ = 0;
		PhotoFileFormat* _tmp2_;
		_tmp2_ = photo_file_format_data_find_applicable (____lambda124__photo_file_format_data_applicable_test, NULL, &_tmp1_);
		photo_file_format_data_image_writeable = (g_free (photo_file_format_data_image_writeable), NULL);
		photo_file_format_data_image_writeable = _tmp2_;
		photo_file_format_data_image_writeable_length1 = _tmp1_;
		_photo_file_format_data_image_writeable_size_ = photo_file_format_data_image_writeable_length1;
	}
	_tmp3_ = photo_file_format_data_image_writeable;
	_tmp3__length1 = photo_file_format_data_image_writeable_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup15 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

static gboolean
___lambda125_ (PhotoFileFormat format)
{
	gboolean result;
	result = photo_file_format_can_write_metadata (format);
	return result;
}

static gboolean
____lambda125__photo_file_format_data_applicable_test (PhotoFileFormat format,
                                                       gpointer self)
{
	gboolean result;
	result = ___lambda125_ (format);
	return result;
}

static PhotoFileFormat*
_vala_array_dup16 (PhotoFileFormat* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (PhotoFileFormat));
	}
	return NULL;
}

PhotoFileFormat*
photo_file_format_data_get_metadata_writeable (gint* result_length1)
{
	PhotoFileFormat* _tmp0_;
	gint _tmp0__length1;
	PhotoFileFormat* _tmp3_;
	gint _tmp3__length1;
	PhotoFileFormat* _tmp4_;
	gint _tmp4__length1;
	PhotoFileFormat* _tmp5_;
	gint _tmp5__length1;
	PhotoFileFormat* result;
	_tmp0_ = photo_file_format_data_metadata_writeable;
	_tmp0__length1 = photo_file_format_data_metadata_writeable_length1;
	if (_tmp0_ == NULL) {
		gint _tmp1_ = 0;
		PhotoFileFormat* _tmp2_;
		_tmp2_ = photo_file_format_data_find_applicable (____lambda125__photo_file_format_data_applicable_test, NULL, &_tmp1_);
		photo_file_format_data_metadata_writeable = (g_free (photo_file_format_data_metadata_writeable), NULL);
		photo_file_format_data_metadata_writeable = _tmp2_;
		photo_file_format_data_metadata_writeable_length1 = _tmp1_;
		_photo_file_format_data_metadata_writeable_size_ = photo_file_format_data_metadata_writeable_length1;
	}
	_tmp3_ = photo_file_format_data_metadata_writeable;
	_tmp3__length1 = photo_file_format_data_metadata_writeable_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup16 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

void
photo_file_format_init_supported (void)
{
	gint _tmp0_ = 0;
	PhotoFileFormat* _tmp1_;
	_tmp1_ = photo_file_format_get_supported (&_tmp0_);
	{
		PhotoFileFormat* format_collection = NULL;
		gint format_collection_length1 = 0;
		gint _format_collection_size_ = 0;
		gint format_it = 0;
		format_collection = _tmp1_;
		format_collection_length1 = _tmp0_;
		for (format_it = 0; format_it < format_collection_length1; format_it = format_it + 1) {
			PhotoFileFormat format = 0;
			format = format_collection[format_it];
			{
				photo_file_format_init (format);
			}
		}
		format_collection = (g_free (format_collection), NULL);
	}
}

PhotoFileFormat*
photo_file_format_get_supported (gint* result_length1)
{
	PhotoFileFormat* _tmp0_;
	PhotoFileFormat* _tmp1_;
	gint _tmp1__length1;
	PhotoFileFormat* result;
	_tmp0_ = g_new0 (PhotoFileFormat, 7);
	_tmp0_[0] = PHOTO_FILE_FORMAT_JFIF;
	_tmp0_[1] = PHOTO_FILE_FORMAT_RAW;
	_tmp0_[2] = PHOTO_FILE_FORMAT_PNG;
	_tmp0_[3] = PHOTO_FILE_FORMAT_TIFF;
	_tmp0_[4] = PHOTO_FILE_FORMAT_BMP;
	_tmp0_[5] = PHOTO_FILE_FORMAT_GIF;
	_tmp0_[6] = PHOTO_FILE_FORMAT_WEBP;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 7;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

PhotoFileFormat*
photo_file_format_get_writeable (gint* result_length1)
{
	gint _tmp0_ = 0;
	PhotoFileFormat* _tmp1_;
	PhotoFileFormat* _tmp2_;
	gint _tmp2__length1;
	PhotoFileFormat* result;
	_tmp1_ = photo_file_format_data_get_writeable (&_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

PhotoFileFormat*
photo_file_format_get_image_writeable (gint* result_length1)
{
	gint _tmp0_ = 0;
	PhotoFileFormat* _tmp1_;
	PhotoFileFormat* _tmp2_;
	gint _tmp2__length1;
	PhotoFileFormat* result;
	_tmp1_ = photo_file_format_data_get_image_writeable (&_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

PhotoFileFormat*
photo_file_format_get_metadata_writeable (gint* result_length1)
{
	gint _tmp0_ = 0;
	PhotoFileFormat* _tmp1_;
	PhotoFileFormat* _tmp2_;
	gint _tmp2__length1;
	PhotoFileFormat* result;
	_tmp1_ = photo_file_format_data_get_metadata_writeable (&_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

PhotoFileFormat
photo_file_format_get_by_basename_extension (const gchar* basename)
{
	gchar* name = NULL;
	gchar* ext = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	PhotoFileFormat* _tmp4_;
	PhotoFileFormat result;
	g_return_val_if_fail (basename != NULL, 0);
	disassemble_filename (basename, &_tmp0_, &_tmp1_);
	_g_free0 (name);
	name = _tmp0_;
	_g_free0 (ext);
	ext = _tmp1_;
	_tmp2_ = ext;
	if (is_string_empty (_tmp2_)) {
		result = PHOTO_FILE_FORMAT_UNKNOWN;
		_g_free0 (ext);
		_g_free0 (name);
		return result;
	}
	_tmp4_ = photo_file_format_get_supported (&_tmp3_);
	{
		PhotoFileFormat* file_format_collection = NULL;
		gint file_format_collection_length1 = 0;
		gint _file_format_collection_size_ = 0;
		gint file_format_it = 0;
		file_format_collection = _tmp4_;
		file_format_collection_length1 = _tmp3_;
		for (file_format_it = 0; file_format_it < file_format_collection_length1; file_format_it = file_format_it + 1) {
			PhotoFileFormat file_format = 0;
			file_format = file_format_collection[file_format_it];
			{
				PhotoFileFormatDriver* _tmp5_;
				PhotoFileFormatDriver* _tmp6_;
				PhotoFileFormatProperties* _tmp7_;
				PhotoFileFormatProperties* _tmp8_;
				const gchar* _tmp9_;
				gboolean _tmp10_;
				_tmp5_ = photo_file_format_get_driver (file_format);
				_tmp6_ = _tmp5_;
				_tmp7_ = photo_file_format_driver_get_properties (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = ext;
				_tmp10_ = photo_file_format_properties_is_recognized_extension (_tmp8_, _tmp9_);
				_photo_file_format_properties_unref0 (_tmp8_);
				_photo_file_format_driver_unref0 (_tmp6_);
				if (_tmp10_) {
					result = file_format;
					file_format_collection = (g_free (file_format_collection), NULL);
					_g_free0 (ext);
					_g_free0 (name);
					return result;
				}
			}
		}
		file_format_collection = (g_free (file_format_collection), NULL);
	}
	result = PHOTO_FILE_FORMAT_UNKNOWN;
	_g_free0 (ext);
	_g_free0 (name);
	return result;
}

gboolean
photo_file_format_is_file_supported (GFile* file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = g_file_get_basename (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_is_basename_supported (_tmp1_);
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gboolean
photo_file_format_is_basename_supported (const gchar* basename)
{
	gchar* name = NULL;
	gchar* ext = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	PhotoFileFormat* _tmp4_;
	gboolean result;
	g_return_val_if_fail (basename != NULL, FALSE);
	disassemble_filename (basename, &_tmp0_, &_tmp1_);
	_g_free0 (name);
	name = _tmp0_;
	_g_free0 (ext);
	ext = _tmp1_;
	_tmp2_ = ext;
	if (is_string_empty (_tmp2_)) {
		result = FALSE;
		_g_free0 (ext);
		_g_free0 (name);
		return result;
	}
	_tmp4_ = photo_file_format_get_supported (&_tmp3_);
	{
		PhotoFileFormat* format_collection = NULL;
		gint format_collection_length1 = 0;
		gint _format_collection_size_ = 0;
		gint format_it = 0;
		format_collection = _tmp4_;
		format_collection_length1 = _tmp3_;
		for (format_it = 0; format_it < format_collection_length1; format_it = format_it + 1) {
			PhotoFileFormat format = 0;
			format = format_collection[format_it];
			{
				PhotoFileFormatDriver* _tmp5_;
				PhotoFileFormatDriver* _tmp6_;
				PhotoFileFormatProperties* _tmp7_;
				PhotoFileFormatProperties* _tmp8_;
				const gchar* _tmp9_;
				gboolean _tmp10_;
				_tmp5_ = photo_file_format_get_driver (format);
				_tmp6_ = _tmp5_;
				_tmp7_ = photo_file_format_driver_get_properties (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = ext;
				_tmp10_ = photo_file_format_properties_is_recognized_extension (_tmp8_, _tmp9_);
				_photo_file_format_properties_unref0 (_tmp8_);
				_photo_file_format_driver_unref0 (_tmp6_);
				if (_tmp10_) {
					result = TRUE;
					format_collection = (g_free (format_collection), NULL);
					_g_free0 (ext);
					_g_free0 (name);
					return result;
				}
			}
		}
		format_collection = (g_free (format_collection), NULL);
	}
	result = FALSE;
	_g_free0 (ext);
	_g_free0 (name);
	return result;
}

PhotoFileFormat
photo_file_format_get_system_default_format (void)
{
	PhotoFileFormat result;
	result = PHOTO_FILE_FORMAT_JFIF;
	return result;
}

PhotoFileFormat
photo_file_format_get_by_file_extension (GFile* file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	PhotoFileFormat _tmp2_;
	PhotoFileFormat result;
	g_return_val_if_fail (file != NULL, 0);
	_tmp0_ = g_file_get_basename (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_get_by_basename_extension (_tmp1_);
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gint
photo_file_format_serialize (PhotoFileFormat self)
{
	gint result;
	switch (self) {
		case PHOTO_FILE_FORMAT_JFIF:
		{
			result = 0;
			return result;
		}
		case PHOTO_FILE_FORMAT_RAW:
		{
			result = 1;
			return result;
		}
		case PHOTO_FILE_FORMAT_PNG:
		{
			result = 2;
			return result;
		}
		case PHOTO_FILE_FORMAT_TIFF:
		{
			result = 3;
			return result;
		}
		case PHOTO_FILE_FORMAT_BMP:
		{
			result = 4;
			return result;
		}
		case PHOTO_FILE_FORMAT_GIF:
		{
			result = 5;
			return result;
		}
		case PHOTO_FILE_FORMAT_WEBP:
		{
			result = 6;
			return result;
		}
		default:
		case PHOTO_FILE_FORMAT_UNKNOWN:
		{
			result = -1;
			return result;
		}
	}
}

PhotoFileFormat
photo_file_format_unserialize (gint value)
{
	PhotoFileFormat result;
	switch (value) {
		case 0:
		{
			result = PHOTO_FILE_FORMAT_JFIF;
			return result;
		}
		case 1:
		{
			result = PHOTO_FILE_FORMAT_RAW;
			return result;
		}
		case 2:
		{
			result = PHOTO_FILE_FORMAT_PNG;
			return result;
		}
		case 3:
		{
			result = PHOTO_FILE_FORMAT_TIFF;
			return result;
		}
		case 4:
		{
			result = PHOTO_FILE_FORMAT_BMP;
			return result;
		}
		case 5:
		{
			result = PHOTO_FILE_FORMAT_GIF;
			return result;
		}
		case 6:
		{
			result = PHOTO_FILE_FORMAT_WEBP;
			return result;
		}
		default:
		{
			result = PHOTO_FILE_FORMAT_UNKNOWN;
			return result;
		}
	}
}

PhotoFileFormat
photo_file_format_from_gphoto_type (const gchar* type)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	PhotoFileFormat result;
	g_return_val_if_fail (type != NULL, 0);
	_tmp0_ = type;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (GP_MIME_JPEG)))) {
		switch (0) {
			default:
			{
				result = PHOTO_FILE_FORMAT_JFIF;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (GP_MIME_RAW)))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (GP_MIME_CRW))))) {
		switch (0) {
			default:
			{
				result = PHOTO_FILE_FORMAT_RAW;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string (GP_MIME_PNG)))) {
		switch (0) {
			default:
			{
				result = PHOTO_FILE_FORMAT_PNG;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string (GP_MIME_TIFF)))) {
		switch (0) {
			default:
			{
				result = PHOTO_FILE_FORMAT_TIFF;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string (GP_MIME_BMP)))) {
		switch (0) {
			default:
			{
				result = PHOTO_FILE_FORMAT_BMP;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = PHOTO_FILE_FORMAT_UNKNOWN;
				return result;
			}
		}
	}
}

PhotoFileFormat
photo_file_format_from_pixbuf_name (const gchar* name)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	PhotoFileFormat result;
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("jpeg")))) {
		switch (0) {
			default:
			{
				result = PHOTO_FILE_FORMAT_JFIF;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("png")))) {
		switch (0) {
			default:
			{
				result = PHOTO_FILE_FORMAT_PNG;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("tiff")))) {
		switch (0) {
			default:
			{
				result = PHOTO_FILE_FORMAT_TIFF;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("bmp")))) {
		switch (0) {
			default:
			{
				result = PHOTO_FILE_FORMAT_BMP;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("gif")))) {
		switch (0) {
			default:
			{
				result = PHOTO_FILE_FORMAT_GIF;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = PHOTO_FILE_FORMAT_UNKNOWN;
				return result;
			}
		}
	}
}

void
photo_file_format_init (PhotoFileFormat self)
{
	switch (self) {
		case PHOTO_FILE_FORMAT_JFIF:
		{
			jfif_file_format_driver_init ();
			break;
		}
		case PHOTO_FILE_FORMAT_RAW:
		{
			raw_file_format_driver_init ();
			break;
		}
		case PHOTO_FILE_FORMAT_PNG:
		{
			png_file_format_driver_init ();
			break;
		}
		case PHOTO_FILE_FORMAT_TIFF:
		{
			photos_tiff_file_format_driver_init ();
			break;
		}
		case PHOTO_FILE_FORMAT_BMP:
		{
			photos_bmp_file_format_driver_init ();
			break;
		}
		case PHOTO_FILE_FORMAT_GIF:
		{
			gif_file_format_driver_init ();
			break;
		}
		case PHOTO_FILE_FORMAT_WEBP:
		{
			web_pfile_format_driver_init ();
			break;
		}
		default:
		{
			GEnumValue* _tmp0_;
			_tmp0_ = g_enum_get_value (g_type_class_ref (TYPE_PHOTO_FILE_FORMAT), self);
			g_error ("PhotoFileFormat.vala:287: Unsupported file format %s", (_tmp0_ != NULL) ? _tmp0_->value_name : NULL);
		}
	}
}

static PhotoFileFormatDriver*
photo_file_format_get_driver (PhotoFileFormat self)
{
	PhotoFileFormatDriver* result;
	switch (self) {
		case PHOTO_FILE_FORMAT_JFIF:
		{
			JfifFileFormatDriver* _tmp0_;
			_tmp0_ = jfif_file_format_driver_get_instance ();
			result = (PhotoFileFormatDriver*) _tmp0_;
			return result;
		}
		case PHOTO_FILE_FORMAT_RAW:
		{
			RawFileFormatDriver* _tmp1_;
			_tmp1_ = raw_file_format_driver_get_instance ();
			result = (PhotoFileFormatDriver*) _tmp1_;
			return result;
		}
		case PHOTO_FILE_FORMAT_PNG:
		{
			PngFileFormatDriver* _tmp2_;
			_tmp2_ = png_file_format_driver_get_instance ();
			result = (PhotoFileFormatDriver*) _tmp2_;
			return result;
		}
		case PHOTO_FILE_FORMAT_TIFF:
		{
			PhotosTiffFileFormatDriver* _tmp3_;
			_tmp3_ = photos_tiff_file_format_driver_get_instance ();
			result = (PhotoFileFormatDriver*) _tmp3_;
			return result;
		}
		case PHOTO_FILE_FORMAT_BMP:
		{
			PhotosBmpFileFormatDriver* _tmp4_;
			_tmp4_ = photos_bmp_file_format_driver_get_instance ();
			result = (PhotoFileFormatDriver*) _tmp4_;
			return result;
		}
		case PHOTO_FILE_FORMAT_GIF:
		{
			GifFileFormatDriver* _tmp5_;
			_tmp5_ = gif_file_format_driver_get_instance ();
			result = (PhotoFileFormatDriver*) _tmp5_;
			return result;
		}
		case PHOTO_FILE_FORMAT_WEBP:
		{
			WebPFileFormatDriver* _tmp6_;
			_tmp6_ = web_pfile_format_driver_get_instance ();
			result = (PhotoFileFormatDriver*) _tmp6_;
			return result;
		}
		default:
		{
			GEnumValue* _tmp7_;
			_tmp7_ = g_enum_get_value (g_type_class_ref (TYPE_PHOTO_FILE_FORMAT), self);
			g_error ("PhotoFileFormat.vala:315: Unsupported file format %s", (_tmp7_ != NULL) ? _tmp7_->value_name : NULL);
		}
	}
}

PhotoFileFormatProperties*
photo_file_format_get_properties (PhotoFileFormat self)
{
	PhotoFileFormatDriver* _tmp0_;
	PhotoFileFormatDriver* _tmp1_;
	PhotoFileFormatProperties* _tmp2_;
	PhotoFileFormatProperties* _tmp3_;
	PhotoFileFormatProperties* result;
	_tmp0_ = photo_file_format_get_driver (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_driver_get_properties (_tmp1_);
	_tmp3_ = _tmp2_;
	_photo_file_format_driver_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
photo_file_format_get_default_basename (PhotoFileFormat self,
                                        const gchar* name)
{
	PhotoFileFormatProperties* _tmp0_;
	PhotoFileFormatProperties* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = photo_file_format_get_properties (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_properties_get_default_extension (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s.%s", name, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_photo_file_format_properties_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}

PhotoFileReader*
photo_file_format_create_reader (PhotoFileFormat self,
                                 const gchar* filepath)
{
	PhotoFileFormatDriver* _tmp0_;
	PhotoFileFormatDriver* _tmp1_;
	PhotoFileReader* _tmp2_;
	PhotoFileReader* _tmp3_;
	PhotoFileReader* result;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = photo_file_format_get_driver (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_driver_create_reader (_tmp1_, filepath);
	_tmp3_ = _tmp2_;
	_photo_file_format_driver_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gboolean
photo_file_format_can_write (PhotoFileFormat self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (photo_file_format_can_write_image (self)) {
		_tmp0_ = photo_file_format_can_write_metadata (self);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
photo_file_format_can_write_image (PhotoFileFormat self)
{
	PhotoFileFormatDriver* _tmp0_;
	PhotoFileFormatDriver* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	_tmp0_ = photo_file_format_get_driver (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_driver_can_write_image (_tmp1_);
	_photo_file_format_driver_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gboolean
photo_file_format_can_write_metadata (PhotoFileFormat self)
{
	PhotoFileFormatDriver* _tmp0_;
	PhotoFileFormatDriver* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	_tmp0_ = photo_file_format_get_driver (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_driver_can_write_metadata (_tmp1_);
	_photo_file_format_driver_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

PhotoFileWriter*
photo_file_format_create_writer (PhotoFileFormat self,
                                 const gchar* filepath,
                                 GError** error)
{
	PhotoFileWriter* writer = NULL;
	PhotoFileFormatDriver* _tmp0_;
	PhotoFileFormatDriver* _tmp1_;
	PhotoFileWriter* _tmp2_;
	PhotoFileWriter* _tmp3_;
	PhotoFileWriter* _tmp4_;
	GError* _inner_error0_ = NULL;
	PhotoFileWriter* result;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = photo_file_format_get_driver (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_driver_create_writer (_tmp1_, filepath);
	_tmp3_ = _tmp2_;
	_photo_file_format_driver_unref0 (_tmp1_);
	writer = _tmp3_;
	_tmp4_ = writer;
	if (_tmp4_ == NULL) {
		GEnumValue* _tmp5_;
		GError* _tmp6_;
		_tmp5_ = g_enum_get_value (g_type_class_ref (TYPE_PHOTO_FILE_FORMAT), self);
		_tmp6_ = g_error_new (PHOTO_FORMAT_ERROR, PHOTO_FORMAT_ERROR_READ_ONLY, "File format %s is read-only", (_tmp5_ != NULL) ? _tmp5_->value_name : NULL);
		_inner_error0_ = _tmp6_;
		if (_inner_error0_->domain == PHOTO_FORMAT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_photo_file_adapter_unref0 (writer);
			return NULL;
		} else {
			_photo_file_adapter_unref0 (writer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = writer;
	return result;
}

PhotoFileMetadataWriter*
photo_file_format_create_metadata_writer (PhotoFileFormat self,
                                          const gchar* filepath,
                                          GError** error)
{
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileFormatDriver* _tmp0_;
	PhotoFileFormatDriver* _tmp1_;
	PhotoFileMetadataWriter* _tmp2_;
	PhotoFileMetadataWriter* _tmp3_;
	PhotoFileMetadataWriter* _tmp4_;
	GError* _inner_error0_ = NULL;
	PhotoFileMetadataWriter* result;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = photo_file_format_get_driver (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_driver_create_metadata_writer (_tmp1_, filepath);
	_tmp3_ = _tmp2_;
	_photo_file_format_driver_unref0 (_tmp1_);
	writer = _tmp3_;
	_tmp4_ = writer;
	if (_tmp4_ == NULL) {
		GEnumValue* _tmp5_;
		GError* _tmp6_;
		_tmp5_ = g_enum_get_value (g_type_class_ref (TYPE_PHOTO_FILE_FORMAT), self);
		_tmp6_ = g_error_new (PHOTO_FORMAT_ERROR, PHOTO_FORMAT_ERROR_READ_ONLY, "File format %s metadata is read-only", (_tmp5_ != NULL) ? _tmp5_->value_name : NULL);
		_inner_error0_ = _tmp6_;
		if (_inner_error0_->domain == PHOTO_FORMAT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_photo_file_adapter_unref0 (writer);
			return NULL;
		} else {
			_photo_file_adapter_unref0 (writer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = writer;
	return result;
}

PhotoFileSniffer*
photo_file_format_create_sniffer (PhotoFileFormat self,
                                  GFile* file,
                                  PhotoFileSnifferOptions options)
{
	PhotoFileFormatDriver* _tmp0_;
	PhotoFileFormatDriver* _tmp1_;
	PhotoFileSniffer* _tmp2_;
	PhotoFileSniffer* _tmp3_;
	PhotoFileSniffer* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = photo_file_format_get_driver (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_driver_create_sniffer (_tmp1_, file, options);
	_tmp3_ = _tmp2_;
	_photo_file_format_driver_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

PhotoMetadata*
photo_file_format_create_metadata (PhotoFileFormat self)
{
	PhotoFileFormatDriver* _tmp0_;
	PhotoFileFormatDriver* _tmp1_;
	PhotoMetadata* _tmp2_;
	PhotoMetadata* _tmp3_;
	PhotoMetadata* result;
	_tmp0_ = photo_file_format_get_driver (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_driver_create_metadata (_tmp1_);
	_tmp3_ = _tmp2_;
	_photo_file_format_driver_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
photo_file_format_get_default_mime_type (PhotoFileFormat self)
{
	PhotoFileFormatDriver* _tmp0_;
	PhotoFileFormatDriver* _tmp1_;
	PhotoFileFormatProperties* _tmp2_;
	PhotoFileFormatProperties* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	_tmp0_ = photo_file_format_get_driver (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_driver_get_properties (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = photo_file_format_properties_get_default_mime_type (_tmp3_);
	_tmp5_ = _tmp4_;
	_photo_file_format_properties_unref0 (_tmp3_);
	_photo_file_format_driver_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}

gchar**
photo_file_format_get_mime_types (PhotoFileFormat self,
                                  gint* result_length1)
{
	PhotoFileFormatDriver* _tmp0_;
	PhotoFileFormatDriver* _tmp1_;
	PhotoFileFormatProperties* _tmp2_;
	PhotoFileFormatProperties* _tmp3_;
	gint _tmp4_ = 0;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** result;
	_tmp0_ = photo_file_format_get_driver (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_driver_get_properties (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp5_ = photo_file_format_properties_get_mime_types (_tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_photo_file_format_properties_unref0 (_tmp3_);
	_photo_file_format_driver_unref0 (_tmp1_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}

static GType
photo_file_format_get_type_once (void)
{
	static const GEnumValue values[] = {{PHOTO_FILE_FORMAT_JFIF, "PHOTO_FILE_FORMAT_JFIF", "jfif"}, {PHOTO_FILE_FORMAT_RAW, "PHOTO_FILE_FORMAT_RAW", "raw"}, {PHOTO_FILE_FORMAT_PNG, "PHOTO_FILE_FORMAT_PNG", "png"}, {PHOTO_FILE_FORMAT_TIFF, "PHOTO_FILE_FORMAT_TIFF", "tiff"}, {PHOTO_FILE_FORMAT_BMP, "PHOTO_FILE_FORMAT_BMP", "bmp"}, {PHOTO_FILE_FORMAT_GIF, "PHOTO_FILE_FORMAT_GIF", "gif"}, {PHOTO_FILE_FORMAT_WEBP, "PHOTO_FILE_FORMAT_WEBP", "webp"}, {PHOTO_FILE_FORMAT_UNKNOWN, "PHOTO_FILE_FORMAT_UNKNOWN", "unknown"}, {0, NULL, NULL}};
	GType photo_file_format_type_id;
	photo_file_format_type_id = g_enum_register_static ("PhotoFileFormat", values);
	return photo_file_format_type_id;
}

GType
photo_file_format_get_type (void)
{
	static volatile gsize photo_file_format_type_id__once = 0;
	if (g_once_init_enter (&photo_file_format_type_id__once)) {
		GType photo_file_format_type_id;
		photo_file_format_type_id = photo_file_format_get_type_once ();
		g_once_init_leave (&photo_file_format_type_id__once, photo_file_format_type_id);
	}
	return photo_file_format_type_id__once;
}

static PhotoFileFormatProperties*
photo_file_format_driver_real_get_properties (PhotoFileFormatDriver* self)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_driver_get_properties'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

PhotoFileFormatProperties*
photo_file_format_driver_get_properties (PhotoFileFormatDriver* self)
{
	PhotoFileFormatDriverClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self);
	if (_klass_->get_properties) {
		return _klass_->get_properties (self);
	}
	return NULL;
}

static PhotoFileReader*
photo_file_format_driver_real_create_reader (PhotoFileFormatDriver* self,
                                             const gchar* filepath)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_driver_create_reader'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

PhotoFileReader*
photo_file_format_driver_create_reader (PhotoFileFormatDriver* self,
                                        const gchar* filepath)
{
	PhotoFileFormatDriverClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self);
	if (_klass_->create_reader) {
		return _klass_->create_reader (self, filepath);
	}
	return NULL;
}

static PhotoMetadata*
photo_file_format_driver_real_create_metadata (PhotoFileFormatDriver* self)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_driver_create_metadata'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

PhotoMetadata*
photo_file_format_driver_create_metadata (PhotoFileFormatDriver* self)
{
	PhotoFileFormatDriverClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self);
	if (_klass_->create_metadata) {
		return _klass_->create_metadata (self);
	}
	return NULL;
}

static gboolean
photo_file_format_driver_real_can_write_image (PhotoFileFormatDriver* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_driver_can_write_image'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
photo_file_format_driver_can_write_image (PhotoFileFormatDriver* self)
{
	PhotoFileFormatDriverClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self);
	if (_klass_->can_write_image) {
		return _klass_->can_write_image (self);
	}
	return FALSE;
}

static gboolean
photo_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_driver_can_write_metadata'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
photo_file_format_driver_can_write_metadata (PhotoFileFormatDriver* self)
{
	PhotoFileFormatDriverClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self);
	if (_klass_->can_write_metadata) {
		return _klass_->can_write_metadata (self);
	}
	return FALSE;
}

static PhotoFileWriter*
photo_file_format_driver_real_create_writer (PhotoFileFormatDriver* self,
                                             const gchar* filepath)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_driver_create_writer'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

PhotoFileWriter*
photo_file_format_driver_create_writer (PhotoFileFormatDriver* self,
                                        const gchar* filepath)
{
	PhotoFileFormatDriverClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self);
	if (_klass_->create_writer) {
		return _klass_->create_writer (self, filepath);
	}
	return NULL;
}

static PhotoFileMetadataWriter*
photo_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* self,
                                                      const gchar* filepath)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_driver_create_metadata_writer'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

PhotoFileMetadataWriter*
photo_file_format_driver_create_metadata_writer (PhotoFileFormatDriver* self,
                                                 const gchar* filepath)
{
	PhotoFileFormatDriverClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self);
	if (_klass_->create_metadata_writer) {
		return _klass_->create_metadata_writer (self, filepath);
	}
	return NULL;
}

static PhotoFileSniffer*
photo_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* self,
                                              GFile* file,
                                              PhotoFileSnifferOptions options)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_driver_create_sniffer'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

PhotoFileSniffer*
photo_file_format_driver_create_sniffer (PhotoFileFormatDriver* self,
                                         GFile* file,
                                         PhotoFileSnifferOptions options)
{
	PhotoFileFormatDriverClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self);
	if (_klass_->create_sniffer) {
		return _klass_->create_sniffer (self, file, options);
	}
	return NULL;
}

PhotoFileFormatDriver*
photo_file_format_driver_construct (GType object_type)
{
	PhotoFileFormatDriver* self = NULL;
	self = (PhotoFileFormatDriver*) g_type_create_instance (object_type);
	return self;
}

static void
value_photo_file_format_driver_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_photo_file_format_driver_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_file_format_driver_unref (value->data[0].v_pointer);
	}
}

static void
value_photo_file_format_driver_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_file_format_driver_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_photo_file_format_driver_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_photo_file_format_driver_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoFileFormatDriver * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_file_format_driver_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_photo_file_format_driver_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	PhotoFileFormatDriver ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_file_format_driver_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_photo_file_format_driver (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	ParamSpecPhotoFileFormatDriver* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_FILE_FORMAT_DRIVER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_photo_file_format_driver (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_FORMAT_DRIVER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_photo_file_format_driver (GValue* value,
                                    gpointer v_object)
{
	PhotoFileFormatDriver * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_FORMAT_DRIVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_FORMAT_DRIVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_file_format_driver_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_file_format_driver_unref (old);
	}
}

void
value_take_photo_file_format_driver (GValue* value,
                                     gpointer v_object)
{
	PhotoFileFormatDriver * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_FORMAT_DRIVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_FORMAT_DRIVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_file_format_driver_unref (old);
	}
}

static void
photo_file_format_driver_class_init (PhotoFileFormatDriverClass * klass,
                                     gpointer klass_data)
{
	photo_file_format_driver_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatDriverClass *) klass)->finalize = photo_file_format_driver_finalize;
	((PhotoFileFormatDriverClass *) klass)->get_properties = (PhotoFileFormatProperties* (*) (PhotoFileFormatDriver*)) photo_file_format_driver_real_get_properties;
	((PhotoFileFormatDriverClass *) klass)->create_reader = (PhotoFileReader* (*) (PhotoFileFormatDriver*, const gchar*)) photo_file_format_driver_real_create_reader;
	((PhotoFileFormatDriverClass *) klass)->create_metadata = (PhotoMetadata* (*) (PhotoFileFormatDriver*)) photo_file_format_driver_real_create_metadata;
	((PhotoFileFormatDriverClass *) klass)->can_write_image = (gboolean (*) (PhotoFileFormatDriver*)) photo_file_format_driver_real_can_write_image;
	((PhotoFileFormatDriverClass *) klass)->can_write_metadata = (gboolean (*) (PhotoFileFormatDriver*)) photo_file_format_driver_real_can_write_metadata;
	((PhotoFileFormatDriverClass *) klass)->create_writer = (PhotoFileWriter* (*) (PhotoFileFormatDriver*, const gchar*)) photo_file_format_driver_real_create_writer;
	((PhotoFileFormatDriverClass *) klass)->create_metadata_writer = (PhotoFileMetadataWriter* (*) (PhotoFileFormatDriver*, const gchar*)) photo_file_format_driver_real_create_metadata_writer;
	((PhotoFileFormatDriverClass *) klass)->create_sniffer = (PhotoFileSniffer* (*) (PhotoFileFormatDriver*, GFile*, PhotoFileSnifferOptions)) photo_file_format_driver_real_create_sniffer;
}

static void
photo_file_format_driver_instance_init (PhotoFileFormatDriver * self,
                                        gpointer klass)
{
	self->ref_count = 1;
}

static void
photo_file_format_driver_finalize (PhotoFileFormatDriver * obj)
{
	PhotoFileFormatDriver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriver);
	g_signal_handlers_destroy (self);
}

static GType
photo_file_format_driver_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_photo_file_format_driver_init, value_photo_file_format_driver_free_value, value_photo_file_format_driver_copy_value, value_photo_file_format_driver_peek_pointer, "p", value_photo_file_format_driver_collect_value, "p", value_photo_file_format_driver_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoFileFormatDriverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_format_driver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileFormatDriver), 0, (GInstanceInitFunc) photo_file_format_driver_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_file_format_driver_type_id;
	photo_file_format_driver_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoFileFormatDriver", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return photo_file_format_driver_type_id;
}

GType
photo_file_format_driver_get_type (void)
{
	static volatile gsize photo_file_format_driver_type_id__once = 0;
	if (g_once_init_enter (&photo_file_format_driver_type_id__once)) {
		GType photo_file_format_driver_type_id;
		photo_file_format_driver_type_id = photo_file_format_driver_get_type_once ();
		g_once_init_leave (&photo_file_format_driver_type_id__once, photo_file_format_driver_type_id);
	}
	return photo_file_format_driver_type_id__once;
}

gpointer
photo_file_format_driver_ref (gpointer instance)
{
	PhotoFileFormatDriver * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_file_format_driver_unref (gpointer instance)
{
	PhotoFileFormatDriver * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GType
photo_file_format_flags_get_type_once (void)
{
	static const GEnumValue values[] = {{PHOTO_FILE_FORMAT_FLAGS_NONE, "PHOTO_FILE_FORMAT_FLAGS_NONE", "none"}, {0, NULL, NULL}};
	GType photo_file_format_flags_type_id;
	photo_file_format_flags_type_id = g_enum_register_static ("PhotoFileFormatFlags", values);
	return photo_file_format_flags_type_id;
}

GType
photo_file_format_flags_get_type (void)
{
	static volatile gsize photo_file_format_flags_type_id__once = 0;
	if (g_once_init_enter (&photo_file_format_flags_type_id__once)) {
		GType photo_file_format_flags_type_id;
		photo_file_format_flags_type_id = photo_file_format_flags_get_type_once ();
		g_once_init_leave (&photo_file_format_flags_type_id__once, photo_file_format_flags_type_id);
	}
	return photo_file_format_flags_type_id__once;
}

static PhotoFileFormat
photo_file_format_properties_real_get_file_format (PhotoFileFormatProperties* self)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_properties_get_file_format'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}

PhotoFileFormat
photo_file_format_properties_get_file_format (PhotoFileFormatProperties* self)
{
	PhotoFileFormatPropertiesClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self);
	if (_klass_->get_file_format) {
		return _klass_->get_file_format (self);
	}
	return 0;
}

static PhotoFileFormatFlags
photo_file_format_properties_real_get_flags (PhotoFileFormatProperties* self)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_properties_get_flags'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}

PhotoFileFormatFlags
photo_file_format_properties_get_flags (PhotoFileFormatProperties* self)
{
	PhotoFileFormatPropertiesClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self);
	if (_klass_->get_flags) {
		return _klass_->get_flags (self);
	}
	return 0;
}

static gboolean
photo_file_format_properties_real_is_recognized_extension (PhotoFileFormatProperties* self,
                                                           const gchar* ext)
{
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (ext != NULL, FALSE);
	_tmp1_ = photo_file_format_properties_get_known_extensions (self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp3_ = is_in_ci_array (ext, _tmp2_, (gint) _tmp0_);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp3_;
	return result;
}

gboolean
photo_file_format_properties_is_recognized_extension (PhotoFileFormatProperties* self,
                                                      const gchar* ext)
{
	PhotoFileFormatPropertiesClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self);
	if (_klass_->is_recognized_extension) {
		return _klass_->is_recognized_extension (self, ext);
	}
	return FALSE;
}

static gchar*
photo_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* self)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_properties_get_default_extension'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
photo_file_format_properties_get_default_extension (PhotoFileFormatProperties* self)
{
	PhotoFileFormatPropertiesClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self);
	if (_klass_->get_default_extension) {
		return _klass_->get_default_extension (self);
	}
	return NULL;
}

static gchar**
photo_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* self,
                                                        gint* result_length1)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_properties_get_known_extensions'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar**
photo_file_format_properties_get_known_extensions (PhotoFileFormatProperties* self,
                                                   gint* result_length1)
{
	PhotoFileFormatPropertiesClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self);
	if (_klass_->get_known_extensions) {
		return _klass_->get_known_extensions (self, result_length1);
	}
	return NULL;
}

static gchar*
photo_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* self)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_properties_get_default_mime_type'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
photo_file_format_properties_get_default_mime_type (PhotoFileFormatProperties* self)
{
	PhotoFileFormatPropertiesClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self);
	if (_klass_->get_default_mime_type) {
		return _klass_->get_default_mime_type (self);
	}
	return NULL;
}

static gchar**
photo_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* self,
                                                  gint* result_length1)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_properties_get_mime_types'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar**
photo_file_format_properties_get_mime_types (PhotoFileFormatProperties* self,
                                             gint* result_length1)
{
	PhotoFileFormatPropertiesClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self);
	if (_klass_->get_mime_types) {
		return _klass_->get_mime_types (self, result_length1);
	}
	return NULL;
}

static gchar*
photo_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* self)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_properties_get_user_visible_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
photo_file_format_properties_get_user_visible_name (PhotoFileFormatProperties* self)
{
	PhotoFileFormatPropertiesClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self);
	if (_klass_->get_user_visible_name) {
		return _klass_->get_user_visible_name (self);
	}
	return NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GFile*
photo_file_format_properties_convert_file_extension (PhotoFileFormatProperties* self,
                                                     GFile* file)
{
	gchar* name = NULL;
	gchar* ext = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_file_get_basename (file);
	_tmp1_ = _tmp0_;
	disassemble_filename (_tmp1_, &_tmp2_, &_tmp3_);
	_g_free0 (name);
	name = _tmp2_;
	_g_free0 (ext);
	ext = _tmp3_;
	_g_free0 (_tmp1_);
	_tmp5_ = ext;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = ext;
		_tmp4_ = photo_file_format_properties_is_recognized_extension (self, _tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GFile* _tmp7_;
		_tmp7_ = _g_object_ref0 (file);
		result = _tmp7_;
		_g_free0 (ext);
		_g_free0 (name);
		return result;
	}
	_tmp8_ = g_file_get_parent (file);
	_tmp9_ = _tmp8_;
	_tmp10_ = name;
	_tmp11_ = photo_file_format_properties_get_default_extension (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%s.%s", _tmp10_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_file_get_child (_tmp9_, _tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_object_unref0 (_tmp9_);
	result = _tmp16_;
	_g_free0 (ext);
	_g_free0 (name);
	return result;
}

PhotoFileFormatProperties*
photo_file_format_properties_construct (GType object_type)
{
	PhotoFileFormatProperties* self = NULL;
	self = (PhotoFileFormatProperties*) g_type_create_instance (object_type);
	return self;
}

static void
value_photo_file_format_properties_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_photo_file_format_properties_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_file_format_properties_unref (value->data[0].v_pointer);
	}
}

static void
value_photo_file_format_properties_copy_value (const GValue* src_value,
                                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_file_format_properties_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_photo_file_format_properties_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_photo_file_format_properties_collect_value (GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoFileFormatProperties * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_file_format_properties_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_photo_file_format_properties_lcopy_value (const GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	PhotoFileFormatProperties ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_file_format_properties_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_photo_file_format_properties (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags)
{
	ParamSpecPhotoFileFormatProperties* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_FILE_FORMAT_PROPERTIES), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_photo_file_format_properties (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_FORMAT_PROPERTIES), NULL);
	return value->data[0].v_pointer;
}

void
value_set_photo_file_format_properties (GValue* value,
                                        gpointer v_object)
{
	PhotoFileFormatProperties * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_FORMAT_PROPERTIES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_FORMAT_PROPERTIES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_file_format_properties_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_file_format_properties_unref (old);
	}
}

void
value_take_photo_file_format_properties (GValue* value,
                                         gpointer v_object)
{
	PhotoFileFormatProperties * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_FORMAT_PROPERTIES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_FORMAT_PROPERTIES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_file_format_properties_unref (old);
	}
}

static void
photo_file_format_properties_class_init (PhotoFileFormatPropertiesClass * klass,
                                         gpointer klass_data)
{
	photo_file_format_properties_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatPropertiesClass *) klass)->finalize = photo_file_format_properties_finalize;
	((PhotoFileFormatPropertiesClass *) klass)->get_file_format = (PhotoFileFormat (*) (PhotoFileFormatProperties*)) photo_file_format_properties_real_get_file_format;
	((PhotoFileFormatPropertiesClass *) klass)->get_flags = (PhotoFileFormatFlags (*) (PhotoFileFormatProperties*)) photo_file_format_properties_real_get_flags;
	((PhotoFileFormatPropertiesClass *) klass)->is_recognized_extension = (gboolean (*) (PhotoFileFormatProperties*, const gchar*)) photo_file_format_properties_real_is_recognized_extension;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_extension = (gchar* (*) (PhotoFileFormatProperties*)) photo_file_format_properties_real_get_default_extension;
	((PhotoFileFormatPropertiesClass *) klass)->get_known_extensions = (gchar** (*) (PhotoFileFormatProperties*, gint*)) photo_file_format_properties_real_get_known_extensions;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_mime_type = (gchar* (*) (PhotoFileFormatProperties*)) photo_file_format_properties_real_get_default_mime_type;
	((PhotoFileFormatPropertiesClass *) klass)->get_mime_types = (gchar** (*) (PhotoFileFormatProperties*, gint*)) photo_file_format_properties_real_get_mime_types;
	((PhotoFileFormatPropertiesClass *) klass)->get_user_visible_name = (gchar* (*) (PhotoFileFormatProperties*)) photo_file_format_properties_real_get_user_visible_name;
}

static void
photo_file_format_properties_instance_init (PhotoFileFormatProperties * self,
                                            gpointer klass)
{
	self->ref_count = 1;
}

static void
photo_file_format_properties_finalize (PhotoFileFormatProperties * obj)
{
	PhotoFileFormatProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties);
	g_signal_handlers_destroy (self);
}

static GType
photo_file_format_properties_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_photo_file_format_properties_init, value_photo_file_format_properties_free_value, value_photo_file_format_properties_copy_value, value_photo_file_format_properties_peek_pointer, "p", value_photo_file_format_properties_collect_value, "p", value_photo_file_format_properties_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoFileFormatPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_format_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileFormatProperties), 0, (GInstanceInitFunc) photo_file_format_properties_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_file_format_properties_type_id;
	photo_file_format_properties_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoFileFormatProperties", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return photo_file_format_properties_type_id;
}

GType
photo_file_format_properties_get_type (void)
{
	static volatile gsize photo_file_format_properties_type_id__once = 0;
	if (g_once_init_enter (&photo_file_format_properties_type_id__once)) {
		GType photo_file_format_properties_type_id;
		photo_file_format_properties_type_id = photo_file_format_properties_get_type_once ();
		g_once_init_leave (&photo_file_format_properties_type_id__once, photo_file_format_properties_type_id);
	}
	return photo_file_format_properties_type_id__once;
}

gpointer
photo_file_format_properties_ref (gpointer instance)
{
	PhotoFileFormatProperties * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_file_format_properties_unref (gpointer instance)
{
	PhotoFileFormatProperties * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

