/* SearchFilter.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SearchFilter.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* Bitfield values used to specify which search bar features we want.*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecTextAction ParamSpecTextAction;
enum  {
	TEXT_ACTION_TEXT_CHANGED_SIGNAL,
	TEXT_ACTION_SENSITIVITY_CHANGED_SIGNAL,
	TEXT_ACTION_VISIBILITY_CHANGED_SIGNAL,
	TEXT_ACTION_NUM_SIGNALS
};
static guint text_action_signals[TEXT_ACTION_NUM_SIGNALS] = {0};
enum  {
	SEARCH_FILTER_ENTRY_0_PROPERTY,
	SEARCH_FILTER_ENTRY_NUM_PROPERTIES
};
static GParamSpec* search_filter_entry_properties[SEARCH_FILTER_ENTRY_NUM_PROPERTIES];
#define _view_filter_unref0(var) ((var == NULL) ? NULL : (var = (view_filter_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SearchViewFilterPrivate {
	gboolean _flagged;
	gboolean _show_media_video;
	gboolean _show_media_photos;
	gboolean _show_media_raw;
	gchar* search_filter;
	gchar** search_filter_words;
	gint search_filter_words_length1;
	gint _search_filter_words_size_;
};

struct _TextActionPrivate {
	gchar* text;
	gboolean sensitive;
	gboolean visible;
};

struct _ParamSpecTextAction {
	GParamSpec parent_instance;
};

struct _SearchFilterEntryPrivate {
	SearchViewFilter* search_filter;
};

static gint SearchViewFilter_private_offset;
static gpointer search_view_filter_parent_class = NULL;
static gpointer default_search_view_filter_parent_class = NULL;
static gpointer disabled_view_filter_parent_class = NULL;
static gint TextAction_private_offset;
static gpointer text_action_parent_class = NULL;
static gint SearchFilterEntry_private_offset;
static gpointer search_filter_entry_parent_class = NULL;

static guint search_view_filter_real_get_criteria (SearchViewFilter* self);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
static void search_view_filter_finalize (ViewFilter * obj);
static GType search_view_filter_get_type_once (void);
static gboolean default_search_view_filter_real_predicate (ViewFilter* base,
                                                    DataView* view);
static GType default_search_view_filter_get_type_once (void);
static gboolean disabled_view_filter_real_predicate (ViewFilter* base,
                                              DataView* view);
static guint disabled_view_filter_real_get_criteria (SearchViewFilter* base);
static GType disabled_view_filter_get_type_once (void);
static void text_action_finalize (TextAction * obj);
static GType text_action_get_type_once (void);
static void __lambda54_ (SearchFilterEntry* self);
static void search_filter_entry_on_search_text_changed (SearchFilterEntry* self);
static void ___lambda54__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                   gpointer self);
static gboolean search_filter_entry_on_escape_key (SearchFilterEntry* self,
                                            GdkEventKey* e);
static gboolean _search_filter_entry_on_escape_key_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                        GdkEventKey* event,
                                                                        gpointer self);
static void search_filter_entry_finalize (GObject * obj);
static GType search_filter_entry_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GType
search_filter_criteria_get_type_once (void)
{
	static const GFlagsValue values[] = {{SEARCH_FILTER_CRITERIA_NONE, "SEARCH_FILTER_CRITERIA_NONE", "none"}, {SEARCH_FILTER_CRITERIA_RECURSIVE, "SEARCH_FILTER_CRITERIA_RECURSIVE", "recursive"}, {SEARCH_FILTER_CRITERIA_TEXT, "SEARCH_FILTER_CRITERIA_TEXT", "text"}, {SEARCH_FILTER_CRITERIA_FLAG, "SEARCH_FILTER_CRITERIA_FLAG", "flag"}, {SEARCH_FILTER_CRITERIA_MEDIA, "SEARCH_FILTER_CRITERIA_MEDIA", "media"}, {SEARCH_FILTER_CRITERIA_ALL, "SEARCH_FILTER_CRITERIA_ALL", "all"}, {0, NULL, NULL}};
	GType search_filter_criteria_type_id;
	search_filter_criteria_type_id = g_flags_register_static ("SearchFilterCriteria", values);
	return search_filter_criteria_type_id;
}

GType
search_filter_criteria_get_type (void)
{
	static volatile gsize search_filter_criteria_type_id__once = 0;
	if (g_once_init_enter (&search_filter_criteria_type_id__once)) {
		GType search_filter_criteria_type_id;
		search_filter_criteria_type_id = search_filter_criteria_get_type_once ();
		g_once_init_leave (&search_filter_criteria_type_id__once, search_filter_criteria_type_id);
	}
	return search_filter_criteria_type_id__once;
}

static inline gpointer
search_view_filter_get_instance_private (SearchViewFilter* self)
{
	return G_STRUCT_MEMBER_P (self, SearchViewFilter_private_offset);
}

static guint
search_view_filter_real_get_criteria (SearchViewFilter* self)
{
	guint _tmp0_ = 0U;
	g_critical ("Type `%s' does not implement abstract method `search_view_filter_get_criteria'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

guint
search_view_filter_get_criteria (SearchViewFilter* self)
{
	SearchViewFilterClass* _klass_;
	g_return_val_if_fail (self != NULL, 0U);
	_klass_ = SEARCH_VIEW_FILTER_GET_CLASS (self);
	if (_klass_->get_criteria) {
		return _klass_->get_criteria (self);
	}
	return 0U;
}

gboolean
search_view_filter_has_search_filter (SearchViewFilter* self)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->search_filter;
	result = !is_string_empty (_tmp0_);
	return result;
}

const gchar*
search_view_filter_get_search_filter (SearchViewFilter* self)
{
	const gchar* _tmp0_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->search_filter;
	result = _tmp0_;
	return result;
}

gchar**
search_view_filter_get_search_filter_words (SearchViewFilter* self,
                                            gint* result_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->search_filter_words;
	_tmp0__length1 = self->priv->search_filter_words_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
search_view_filter_set_search_filter (SearchViewFilter* self,
                                      const gchar* text)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp2_;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint __tmp3__size_ = 0;
	const gchar* _tmp4_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	if (!is_string_empty (text)) {
		gchar* _tmp1_;
		_tmp1_ = g_utf8_strdown (text, (gssize) -1);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		_g_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	_tmp2_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->search_filter);
	self->priv->search_filter = _tmp2_;
	_tmp4_ = self->priv->search_filter;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_;
		_tmp5_ = self->priv->search_filter;
		_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, " ", 0);
		_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
		_tmp3_ = _tmp7_;
		_tmp3__length1 = _vala_array_length (_tmp6_);
		__tmp3__size_ = _tmp3__length1;
	} else {
		_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
		_tmp3_ = NULL;
		_tmp3__length1 = 0;
		__tmp3__size_ = _tmp3__length1;
	}
	_tmp8_ = (_tmp3_ != NULL) ? _vala_array_dup5 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp8__length1 = _tmp3__length1;
	self->priv->search_filter_words = (_vala_array_free (self->priv->search_filter_words, self->priv->search_filter_words_length1, (GDestroyNotify) g_free), NULL);
	self->priv->search_filter_words = _tmp8_;
	self->priv->search_filter_words_length1 = _tmp8__length1;
	self->priv->_search_filter_words_size_ = self->priv->search_filter_words_length1;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp0_);
}

void
search_view_filter_clear_search_filter (SearchViewFilter* self)
{
	g_return_if_fail (self != NULL);
	_g_free0 (self->priv->search_filter);
	self->priv->search_filter = NULL;
	self->priv->search_filter_words = (_vala_array_free (self->priv->search_filter_words, self->priv->search_filter_words_length1, (GDestroyNotify) g_free), NULL);
	self->priv->search_filter_words = NULL;
	self->priv->search_filter_words_length1 = 0;
	self->priv->_search_filter_words_size_ = self->priv->search_filter_words_length1;
}

gboolean
search_view_filter_filter_by_media_type (SearchViewFilter* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->_show_media_video;
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_;
		_tmp4_ = self->priv->_show_media_photos;
		_tmp2_ = _tmp4_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_;
		_tmp5_ = self->priv->_show_media_raw;
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_;
		_tmp8_ = self->priv->_show_media_video;
		if (_tmp8_) {
			gboolean _tmp9_;
			_tmp9_ = self->priv->_show_media_photos;
			_tmp7_ = _tmp9_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			gboolean _tmp10_;
			_tmp10_ = self->priv->_show_media_raw;
			_tmp6_ = _tmp10_;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp0_ = !_tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

SearchViewFilter*
search_view_filter_construct (GType object_type)
{
	SearchViewFilter* self = NULL;
	self = (SearchViewFilter*) view_filter_construct (object_type);
	return self;
}

gboolean
search_view_filter_get_flagged (SearchViewFilter* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_flagged;
	return result;
}

void
search_view_filter_set_flagged (SearchViewFilter* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_flagged = value;
}

gboolean
search_view_filter_get_show_media_video (SearchViewFilter* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_media_video;
	return result;
}

void
search_view_filter_set_show_media_video (SearchViewFilter* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_media_video = value;
}

gboolean
search_view_filter_get_show_media_photos (SearchViewFilter* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_media_photos;
	return result;
}

void
search_view_filter_set_show_media_photos (SearchViewFilter* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_media_photos = value;
}

gboolean
search_view_filter_get_show_media_raw (SearchViewFilter* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_media_raw;
	return result;
}

void
search_view_filter_set_show_media_raw (SearchViewFilter* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_media_raw = value;
}

static void
search_view_filter_class_init (SearchViewFilterClass * klass,
                               gpointer klass_data)
{
	search_view_filter_parent_class = g_type_class_peek_parent (klass);
	((ViewFilterClass *) klass)->finalize = search_view_filter_finalize;
	g_type_class_adjust_private_offset (klass, &SearchViewFilter_private_offset);
	((SearchViewFilterClass *) klass)->get_criteria = (guint (*) (SearchViewFilter*)) search_view_filter_real_get_criteria;
}

static void
search_view_filter_instance_init (SearchViewFilter * self,
                                  gpointer klass)
{
	self->priv = search_view_filter_get_instance_private (self);
	self->priv->_flagged = FALSE;
	self->priv->_show_media_video = TRUE;
	self->priv->_show_media_photos = TRUE;
	self->priv->_show_media_raw = TRUE;
	self->priv->search_filter = NULL;
	self->priv->search_filter_words = NULL;
	self->priv->search_filter_words_length1 = 0;
	self->priv->_search_filter_words_size_ = self->priv->search_filter_words_length1;
}

static void
search_view_filter_finalize (ViewFilter * obj)
{
	SearchViewFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter);
	_g_free0 (self->priv->search_filter);
	self->priv->search_filter_words = (_vala_array_free (self->priv->search_filter_words, self->priv->search_filter_words_length1, (GDestroyNotify) g_free), NULL);
	VIEW_FILTER_CLASS (search_view_filter_parent_class)->finalize (obj);
}

static GType
search_view_filter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchViewFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_view_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchViewFilter), 0, (GInstanceInitFunc) search_view_filter_instance_init, NULL };
	GType search_view_filter_type_id;
	search_view_filter_type_id = g_type_register_static (TYPE_VIEW_FILTER, "SearchViewFilter", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SearchViewFilter_private_offset = g_type_add_instance_private (search_view_filter_type_id, sizeof (SearchViewFilterPrivate));
	return search_view_filter_type_id;
}

GType
search_view_filter_get_type (void)
{
	static volatile gsize search_view_filter_type_id__once = 0;
	if (g_once_init_enter (&search_view_filter_type_id__once)) {
		GType search_view_filter_type_id;
		search_view_filter_type_id = search_view_filter_get_type_once ();
		g_once_init_leave (&search_view_filter_type_id__once, search_view_filter_type_id);
	}
	return search_view_filter_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
default_search_view_filter_real_predicate (ViewFilter* base,
                                           DataView* view)
{
	DefaultSearchViewFilter * self;
	MediaSource* source = NULL;
	MediaSource* _tmp0_;
	guint criteria = 0U;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean result;
	self = (DefaultSearchViewFilter*) base;
	g_return_val_if_fail (view != NULL, FALSE);
	_tmp0_ = thumbnail_get_media_source (G_TYPE_CHECK_INSTANCE_CAST (view, TYPE_THUMBNAIL, Thumbnail));
	source = _tmp0_;
	criteria = search_view_filter_get_criteria ((SearchViewFilter*) self);
	if ((SEARCH_FILTER_CRITERIA_FLAG & criteria) != 0) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = search_view_filter_get_flagged ((SearchViewFilter*) self);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			MediaSource* _tmp5_;
			_tmp5_ = source;
			_tmp2_ = IS_FLAGGABLE (_tmp5_);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			MediaSource* _tmp6_;
			_tmp6_ = source;
			_tmp1_ = !flaggable_is_flagged (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_FLAGGABLE, Flaggable));
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = FALSE;
			_g_object_unref0 (source);
			return result;
		}
	}
	if ((SEARCH_FILTER_CRITERIA_MEDIA & criteria) != 0) {
		_tmp7_ = search_view_filter_filter_by_media_type ((SearchViewFilter*) self);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		MediaSource* _tmp8_;
		_tmp8_ = source;
		if (IS_VIDEO_SOURCE (_tmp8_)) {
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = search_view_filter_get_show_media_video ((SearchViewFilter*) self);
			_tmp10_ = _tmp9_;
			if (!_tmp10_) {
				result = FALSE;
				_g_object_unref0 (source);
				return result;
			}
		} else {
			MediaSource* _tmp11_;
			_tmp11_ = source;
			if (IS_PHOTO (_tmp11_)) {
				Photo* photo = NULL;
				MediaSource* _tmp12_;
				Photo* _tmp13_;
				Photo* _tmp14_;
				_tmp12_ = source;
				_tmp13_ = _g_object_ref0 (IS_PHOTO (_tmp12_) ? ((Photo*) _tmp12_) : NULL);
				photo = _tmp13_;
				_tmp14_ = photo;
				if (photo_get_master_file_format (_tmp14_) == PHOTO_FILE_FORMAT_RAW) {
					Photo* _tmp15_;
					_tmp15_ = photo;
					if (photo_is_raw_developer_available (_tmp15_, RAW_DEVELOPER_CAMERA)) {
						gboolean _tmp16_ = FALSE;
						gboolean _tmp17_;
						gboolean _tmp18_;
						_tmp17_ = search_view_filter_get_show_media_photos ((SearchViewFilter*) self);
						_tmp18_ = _tmp17_;
						if (!_tmp18_) {
							gboolean _tmp19_;
							gboolean _tmp20_;
							_tmp19_ = search_view_filter_get_show_media_raw ((SearchViewFilter*) self);
							_tmp20_ = _tmp19_;
							_tmp16_ = !_tmp20_;
						} else {
							_tmp16_ = FALSE;
						}
						if (_tmp16_) {
							result = FALSE;
							_g_object_unref0 (photo);
							_g_object_unref0 (source);
							return result;
						}
					} else {
						gboolean _tmp21_;
						gboolean _tmp22_;
						_tmp21_ = search_view_filter_get_show_media_raw ((SearchViewFilter*) self);
						_tmp22_ = _tmp21_;
						if (!_tmp22_) {
							result = FALSE;
							_g_object_unref0 (photo);
							_g_object_unref0 (source);
							return result;
						}
					}
				} else {
					gboolean _tmp23_;
					gboolean _tmp24_;
					_tmp23_ = search_view_filter_get_show_media_photos ((SearchViewFilter*) self);
					_tmp24_ = _tmp23_;
					if (!_tmp24_) {
						result = FALSE;
						_g_object_unref0 (photo);
						_g_object_unref0 (source);
						return result;
					}
				}
				_g_object_unref0 (photo);
			}
		}
	}
	if ((SEARCH_FILTER_CRITERIA_TEXT & criteria) != 0) {
		_tmp25_ = search_view_filter_has_search_filter ((SearchViewFilter*) self);
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		const gchar* media_keywords = NULL;
		MediaSource* _tmp26_;
		const gchar* _tmp27_;
		const gchar* event_keywords = NULL;
		Event* event = NULL;
		MediaSource* _tmp28_;
		Event* _tmp29_;
		Event* _tmp30_;
		GeeList* tags = NULL;
		TagSourceCollection* _tmp33_;
		MediaSource* _tmp34_;
		GeeList* _tmp35_;
		gint _tmp36_ = 0;
		GeeList* _tmp37_;
		gint tags_size = 0;
		gint _tmp41_ = 0;
		gchar** _tmp42_;
		_tmp26_ = source;
		_tmp27_ = indexable_get_indexable_keywords ((Indexable*) _tmp26_);
		media_keywords = _tmp27_;
		event_keywords = NULL;
		_tmp28_ = source;
		_tmp29_ = media_source_get_event (_tmp28_);
		event = _tmp29_;
		_tmp30_ = event;
		if (_tmp30_ != NULL) {
			Event* _tmp31_;
			const gchar* _tmp32_;
			_tmp31_ = event;
			_tmp32_ = indexable_get_indexable_keywords ((Indexable*) _tmp31_);
			event_keywords = _tmp32_;
		}
		_tmp33_ = tag_global;
		_tmp34_ = source;
		_tmp35_ = tag_source_collection_fetch_for_source (_tmp33_, _tmp34_);
		tags = _tmp35_;
		_tmp37_ = tags;
		if (_tmp37_ != NULL) {
			GeeList* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			_tmp38_ = tags;
			_tmp39_ = gee_collection_get_size ((GeeCollection*) _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp36_ = _tmp40_;
		} else {
			_tmp36_ = 0;
		}
		tags_size = _tmp36_;
		_tmp42_ = search_view_filter_get_search_filter_words ((SearchViewFilter*) self, &_tmp41_);
		{
			gchar** word_collection = NULL;
			gint word_collection_length1 = 0;
			gint _word_collection_size_ = 0;
			gint word_it = 0;
			word_collection = _tmp42_;
			word_collection_length1 = _tmp41_;
			for (word_it = 0; word_it < word_collection_length1; word_it = word_it + 1) {
				const gchar* word = NULL;
				word = word_collection[word_it];
				{
					gboolean _tmp43_ = FALSE;
					const gchar* _tmp44_;
					gboolean _tmp47_ = FALSE;
					const gchar* _tmp48_;
					_tmp44_ = media_keywords;
					if (_tmp44_ != NULL) {
						const gchar* _tmp45_;
						const gchar* _tmp46_;
						_tmp45_ = media_keywords;
						_tmp46_ = word;
						_tmp43_ = string_contains (_tmp45_, _tmp46_);
					} else {
						_tmp43_ = FALSE;
					}
					if (_tmp43_) {
						continue;
					}
					_tmp48_ = event_keywords;
					if (_tmp48_ != NULL) {
						const gchar* _tmp49_;
						const gchar* _tmp50_;
						_tmp49_ = event_keywords;
						_tmp50_ = word;
						_tmp47_ = string_contains (_tmp49_, _tmp50_);
					} else {
						_tmp47_ = FALSE;
					}
					if (_tmp47_) {
						continue;
					}
					if (tags_size > 0) {
						gboolean found = FALSE;
						found = FALSE;
						{
							gint ctr = 0;
							ctr = 0;
							{
								gboolean _tmp51_ = FALSE;
								_tmp51_ = TRUE;
								while (TRUE) {
									const gchar* tag_keywords = NULL;
									GeeList* _tmp53_;
									gpointer _tmp54_;
									Tag* _tmp55_;
									const gchar* _tmp56_;
									const gchar* _tmp57_;
									gboolean _tmp58_ = FALSE;
									const gchar* _tmp59_;
									if (!_tmp51_) {
										gint _tmp52_;
										_tmp52_ = ctr;
										ctr = _tmp52_ + 1;
									}
									_tmp51_ = FALSE;
									if (!(ctr < tags_size)) {
										break;
									}
									_tmp53_ = tags;
									_tmp54_ = gee_list_get (_tmp53_, ctr);
									_tmp55_ = (Tag*) _tmp54_;
									_tmp56_ = indexable_get_indexable_keywords ((Indexable*) _tmp55_);
									_tmp57_ = _tmp56_;
									_g_object_unref0 (_tmp55_);
									tag_keywords = _tmp57_;
									_tmp59_ = tag_keywords;
									if (_tmp59_ != NULL) {
										const gchar* _tmp60_;
										const gchar* _tmp61_;
										_tmp60_ = tag_keywords;
										_tmp61_ = word;
										_tmp58_ = string_contains (_tmp60_, _tmp61_);
									} else {
										_tmp58_ = FALSE;
									}
									if (_tmp58_) {
										found = TRUE;
										break;
									}
								}
							}
						}
						if (found) {
							continue;
						}
					}
					result = FALSE;
					_g_object_unref0 (tags);
					_g_object_unref0 (event);
					_g_object_unref0 (source);
					return result;
				}
			}
		}
		_g_object_unref0 (tags);
		_g_object_unref0 (event);
	}
	result = TRUE;
	_g_object_unref0 (source);
	return result;
}

DefaultSearchViewFilter*
default_search_view_filter_construct (GType object_type)
{
	DefaultSearchViewFilter* self = NULL;
	self = (DefaultSearchViewFilter*) search_view_filter_construct (object_type);
	return self;
}

static void
default_search_view_filter_class_init (DefaultSearchViewFilterClass * klass,
                                       gpointer klass_data)
{
	default_search_view_filter_parent_class = g_type_class_peek_parent (klass);
	((ViewFilterClass *) klass)->predicate = (gboolean (*) (ViewFilter*, DataView*)) default_search_view_filter_real_predicate;
}

static void
default_search_view_filter_instance_init (DefaultSearchViewFilter * self,
                                          gpointer klass)
{
}

static GType
default_search_view_filter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DefaultSearchViewFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) default_search_view_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DefaultSearchViewFilter), 0, (GInstanceInitFunc) default_search_view_filter_instance_init, NULL };
	GType default_search_view_filter_type_id;
	default_search_view_filter_type_id = g_type_register_static (TYPE_SEARCH_VIEW_FILTER, "DefaultSearchViewFilter", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return default_search_view_filter_type_id;
}

GType
default_search_view_filter_get_type (void)
{
	static volatile gsize default_search_view_filter_type_id__once = 0;
	if (g_once_init_enter (&default_search_view_filter_type_id__once)) {
		GType default_search_view_filter_type_id;
		default_search_view_filter_type_id = default_search_view_filter_get_type_once ();
		g_once_init_leave (&default_search_view_filter_type_id__once, default_search_view_filter_type_id);
	}
	return default_search_view_filter_type_id__once;
}

static gboolean
disabled_view_filter_real_predicate (ViewFilter* base,
                                     DataView* view)
{
	DisabledViewFilter * self;
	gboolean result;
	self = (DisabledViewFilter*) base;
	g_return_val_if_fail (view != NULL, FALSE);
	result = TRUE;
	return result;
}

static guint
disabled_view_filter_real_get_criteria (SearchViewFilter* base)
{
	DisabledViewFilter * self;
	guint result;
	self = (DisabledViewFilter*) base;
	result = (guint) SEARCH_FILTER_CRITERIA_NONE;
	return result;
}

DisabledViewFilter*
disabled_view_filter_construct (GType object_type)
{
	DisabledViewFilter* self = NULL;
	self = (DisabledViewFilter*) search_view_filter_construct (object_type);
	return self;
}

DisabledViewFilter*
disabled_view_filter_new (void)
{
	return disabled_view_filter_construct (TYPE_DISABLED_VIEW_FILTER);
}

static void
disabled_view_filter_class_init (DisabledViewFilterClass * klass,
                                 gpointer klass_data)
{
	disabled_view_filter_parent_class = g_type_class_peek_parent (klass);
	((ViewFilterClass *) klass)->predicate = (gboolean (*) (ViewFilter*, DataView*)) disabled_view_filter_real_predicate;
	((SearchViewFilterClass *) klass)->get_criteria = (guint (*) (SearchViewFilter*)) disabled_view_filter_real_get_criteria;
}

static void
disabled_view_filter_instance_init (DisabledViewFilter * self,
                                    gpointer klass)
{
}

static GType
disabled_view_filter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DisabledViewFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) disabled_view_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DisabledViewFilter), 0, (GInstanceInitFunc) disabled_view_filter_instance_init, NULL };
	GType disabled_view_filter_type_id;
	disabled_view_filter_type_id = g_type_register_static (TYPE_SEARCH_VIEW_FILTER, "DisabledViewFilter", &g_define_type_info, 0);
	return disabled_view_filter_type_id;
}

GType
disabled_view_filter_get_type (void)
{
	static volatile gsize disabled_view_filter_type_id__once = 0;
	if (g_once_init_enter (&disabled_view_filter_type_id__once)) {
		GType disabled_view_filter_type_id;
		disabled_view_filter_type_id = disabled_view_filter_get_type_once ();
		g_once_init_leave (&disabled_view_filter_type_id__once, disabled_view_filter_type_id);
	}
	return disabled_view_filter_type_id__once;
}

static inline gpointer
text_action_get_instance_private (TextAction* self)
{
	return G_STRUCT_MEMBER_P (self, TextAction_private_offset);
}

TextAction*
text_action_construct (GType object_type,
                       const gchar* init)
{
	TextAction* self = NULL;
	gchar* _tmp0_;
	self = (TextAction*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (init);
	_g_free0 (self->priv->text);
	self->priv->text = _tmp0_;
	return self;
}

TextAction*
text_action_new (const gchar* init)
{
	return text_action_construct (TYPE_TEXT_ACTION, init);
}

void
text_action_set_text (TextAction* self,
                      const gchar* text)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->text;
	if (g_strcmp0 (_tmp0_, text) != 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (text);
		_g_free0 (self->priv->text);
		self->priv->text = _tmp1_;
		g_signal_emit (self, text_action_signals[TEXT_ACTION_TEXT_CHANGED_SIGNAL], 0, text);
	}
}

void
text_action_clear (TextAction* self)
{
	g_return_if_fail (self != NULL);
	text_action_set_text (self, NULL);
}

gboolean
text_action_is_sensitive (TextAction* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->sensitive;
	return result;
}

void
text_action_set_sensitive (TextAction* self,
                           gboolean sensitive)
{
	g_return_if_fail (self != NULL);
	if (self->priv->sensitive != sensitive) {
		self->priv->sensitive = sensitive;
		g_signal_emit (self, text_action_signals[TEXT_ACTION_SENSITIVITY_CHANGED_SIGNAL], 0, sensitive);
	}
}

gboolean
text_action_is_visible (TextAction* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->visible;
	return result;
}

void
text_action_set_visible (TextAction* self,
                         gboolean visible)
{
	g_return_if_fail (self != NULL);
	if (self->priv->visible != visible) {
		self->priv->visible = visible;
		g_signal_emit (self, text_action_signals[TEXT_ACTION_VISIBILITY_CHANGED_SIGNAL], 0, visible);
	}
}

const gchar*
text_action_get_value (TextAction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->text;
	result = _tmp0_;
	return result;
}

static void
value_text_action_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_text_action_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		text_action_unref (value->data[0].v_pointer);
	}
}

static void
value_text_action_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = text_action_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_text_action_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_text_action_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TextAction * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = text_action_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_text_action_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	TextAction ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = text_action_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_text_action (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecTextAction* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEXT_ACTION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_text_action (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_ACTION), NULL);
	return value->data[0].v_pointer;
}

void
value_set_text_action (GValue* value,
                       gpointer v_object)
{
	TextAction * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_ACTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEXT_ACTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		text_action_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		text_action_unref (old);
	}
}

void
value_take_text_action (GValue* value,
                        gpointer v_object)
{
	TextAction * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_ACTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEXT_ACTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		text_action_unref (old);
	}
}

static void
text_action_class_init (TextActionClass * klass,
                        gpointer klass_data)
{
	text_action_parent_class = g_type_class_peek_parent (klass);
	((TextActionClass *) klass)->finalize = text_action_finalize;
	g_type_class_adjust_private_offset (klass, &TextAction_private_offset);
	text_action_signals[TEXT_ACTION_TEXT_CHANGED_SIGNAL] = g_signal_new ("text-changed", TYPE_TEXT_ACTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	text_action_signals[TEXT_ACTION_SENSITIVITY_CHANGED_SIGNAL] = g_signal_new ("sensitivity-changed", TYPE_TEXT_ACTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	text_action_signals[TEXT_ACTION_VISIBILITY_CHANGED_SIGNAL] = g_signal_new ("visibility-changed", TYPE_TEXT_ACTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
text_action_instance_init (TextAction * self,
                           gpointer klass)
{
	self->priv = text_action_get_instance_private (self);
	self->priv->text = NULL;
	self->priv->sensitive = TRUE;
	self->priv->visible = TRUE;
	self->ref_count = 1;
}

static void
text_action_finalize (TextAction * obj)
{
	TextAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEXT_ACTION, TextAction);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->text);
}

static GType
text_action_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_text_action_init, value_text_action_free_value, value_text_action_copy_value, value_text_action_peek_pointer, "p", value_text_action_collect_value, "p", value_text_action_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TextActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) text_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TextAction), 0, (GInstanceInitFunc) text_action_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType text_action_type_id;
	text_action_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TextAction", &g_define_type_info, &g_define_type_fundamental_info, 0);
	TextAction_private_offset = g_type_add_instance_private (text_action_type_id, sizeof (TextActionPrivate));
	return text_action_type_id;
}

GType
text_action_get_type (void)
{
	static volatile gsize text_action_type_id__once = 0;
	if (g_once_init_enter (&text_action_type_id__once)) {
		GType text_action_type_id;
		text_action_type_id = text_action_get_type_once ();
		g_once_init_leave (&text_action_type_id__once, text_action_type_id);
	}
	return text_action_type_id__once;
}

gpointer
text_action_ref (gpointer instance)
{
	TextAction * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
text_action_unref (gpointer instance)
{
	TextAction * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEXT_ACTION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
search_filter_entry_get_instance_private (SearchFilterEntry* self)
{
	return G_STRUCT_MEMBER_P (self, SearchFilterEntry_private_offset);
}

static void
__lambda54_ (SearchFilterEntry* self)
{
	search_filter_entry_on_search_text_changed (self);
}

static void
___lambda54__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                              gpointer self)
{
	__lambda54_ ((SearchFilterEntry*) self);
}

static gboolean
_search_filter_entry_on_escape_key_gtk_widget_key_press_event (GtkWidget* _sender,
                                                               GdkEventKey* event,
                                                               gpointer self)
{
	gboolean result;
	result = search_filter_entry_on_escape_key ((SearchFilterEntry*) self, event);
	return result;
}

SearchFilterEntry*
search_filter_entry_construct (GType object_type)
{
	SearchFilterEntry * self = NULL;
	self = (SearchFilterEntry*) g_object_new (object_type, NULL);
	gtk_entry_set_placeholder_text ((GtkEntry*) self, _ ("Search Photos"));
	g_signal_connect_object ((GtkSearchEntry*) self, "search-changed", (GCallback) ___lambda54__gtk_search_entry_search_changed, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _search_filter_entry_on_escape_key_gtk_widget_key_press_event, self, 0);
	return self;
}

SearchFilterEntry*
search_filter_entry_new (void)
{
	return search_filter_entry_construct (TYPE_SEARCH_FILTER_ENTRY);
}

static gboolean
search_filter_entry_on_escape_key (SearchFilterEntry* self,
                                   GdkEventKey* e)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = gdk_keyval_name (e->keyval);
	if (g_strcmp0 (_tmp0_, "Escape") == 0) {
		gtk_entry_set_text ((GtkEntry*) self, "");
	}
	result = FALSE;
	return result;
}

static void
search_filter_entry_on_search_text_changed (SearchFilterEntry* self)
{
	g_return_if_fail (self != NULL);
	search_filter_entry_update (self);
}

static gpointer
_view_filter_ref0 (gpointer self)
{
	return self ? view_filter_ref (self) : NULL;
}

void
search_filter_entry_set_view_filter (SearchFilterEntry* self,
                                     SearchViewFilter* search_filter)
{
	SearchViewFilter* _tmp0_;
	SearchViewFilter* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search_filter != NULL);
	_tmp0_ = self->priv->search_filter;
	if (search_filter == _tmp0_) {
		return;
	}
	_tmp1_ = _view_filter_ref0 (search_filter);
	_view_filter_unref0 (self->priv->search_filter);
	self->priv->search_filter = _tmp1_;
	search_filter_entry_update (self);
}

void
search_filter_entry_unset_view_filter (SearchFilterEntry* self)
{
	DisabledViewFilter* _tmp0_;
	DisabledViewFilter* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = disabled_view_filter_new ();
	_tmp1_ = _tmp0_;
	search_filter_entry_set_view_filter (self, (SearchViewFilter*) _tmp1_);
	_view_filter_unref0 (_tmp1_);
}

void
search_filter_entry_update (SearchFilterEntry* self)
{
	SearchViewFilter* _tmp0_;
	SearchViewFilter* _tmp1_;
	SearchViewFilter* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	SearchViewFilter* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_filter;
	if (NULL == _tmp0_) {
		gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
	}
	_tmp1_ = self->priv->search_filter;
	_vala_assert (NULL != _tmp1_, "null != search_filter");
	_tmp2_ = self->priv->search_filter;
	_tmp3_ = gtk_entry_get_text ((GtkEntry*) self);
	_tmp4_ = _tmp3_;
	search_view_filter_set_search_filter (_tmp2_, _tmp4_);
	_tmp5_ = self->priv->search_filter;
	g_signal_emit_by_name ((ViewFilter*) _tmp5_, "refresh");
}

static void
search_filter_entry_class_init (SearchFilterEntryClass * klass,
                                gpointer klass_data)
{
	search_filter_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SearchFilterEntry_private_offset);
	G_OBJECT_CLASS (klass)->finalize = search_filter_entry_finalize;
}

static void
search_filter_entry_instance_init (SearchFilterEntry * self,
                                   gpointer klass)
{
	self->priv = search_filter_entry_get_instance_private (self);
	self->priv->search_filter = NULL;
}

static void
search_filter_entry_finalize (GObject * obj)
{
	SearchFilterEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_FILTER_ENTRY, SearchFilterEntry);
	_view_filter_unref0 (self->priv->search_filter);
	G_OBJECT_CLASS (search_filter_entry_parent_class)->finalize (obj);
}

static GType
search_filter_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchFilterEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_filter_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchFilterEntry), 0, (GInstanceInitFunc) search_filter_entry_instance_init, NULL };
	GType search_filter_entry_type_id;
	search_filter_entry_type_id = g_type_register_static (gtk_search_entry_get_type (), "SearchFilterEntry", &g_define_type_info, 0);
	SearchFilterEntry_private_offset = g_type_add_instance_private (search_filter_entry_type_id, sizeof (SearchFilterEntryPrivate));
	return search_filter_entry_type_id;
}

GType
search_filter_entry_get_type (void)
{
	static volatile gsize search_filter_entry_type_id__once = 0;
	if (g_once_init_enter (&search_filter_entry_type_id__once)) {
		GType search_filter_entry_type_id;
		search_filter_entry_type_id = search_filter_entry_get_type_once ();
		g_once_init_leave (&search_filter_entry_type_id__once, search_filter_entry_type_id);
	}
	return search_filter_entry_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

