/* main.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from main.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <glib-object.h>
#include <glib.h>
#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <gexiv2/gexiv2.h>
#include <locale.h>
#include <config.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef enum  {
	SHOTWELL_COMMAND_MOUNTED_CAMERA = 1
} ShotwellCommand;

#define TYPE_SHOTWELL_COMMAND (shotwell_command_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _upgrades_unref0(var) ((var == NULL) ? NULL : (var = (upgrades_unref (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _aggregate_progress_monitor_unref0(var) ((var == NULL) ? NULL : (var = (aggregate_progress_monitor_unref (var), NULL)))
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))
#define _batch_import_job_unref0(var) ((var == NULL) ? NULL : (var = (batch_import_job_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

VALA_EXTERN GTimer* startup_timer;
GTimer* startup_timer = NULL;
VALA_EXTERN gboolean was_already_running;
gboolean was_already_running = FALSE;
VALA_EXTERN gboolean commandline_options_no_startup_progress;
VALA_EXTERN gboolean do_external_import;
VALA_EXTERN gboolean do_system_pictures_import;
gboolean do_system_pictures_import = FALSE;
gboolean do_external_import = FALSE;
VALA_EXTERN gchar* commandline_options_data_dir;
gchar* commandline_options_data_dir = NULL;
VALA_EXTERN gboolean commandline_options_no_runtime_monitoring;
gboolean commandline_options_no_runtime_monitoring = FALSE;
gboolean commandline_options_no_startup_progress = FALSE;
VALA_EXTERN gboolean commandline_options_show_version;
gboolean commandline_options_show_version = FALSE;
VALA_EXTERN gboolean commandline_options_debug_enabled;
gboolean commandline_options_debug_enabled = FALSE;

VALA_EXTERN GType shotwell_command_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void library_exec (gchar** mounts,
                   gint mounts_length1);
VALA_EXTERN GFile* app_dirs_get_data_subdir (const gchar* name,
                                 const gchar* subname);
VALA_EXTERN GFile* app_dirs_get_data_dir (void);
static gboolean _progress_dialog_monitor_progress_monitor (guint64 current,
                                                    guint64 total,
                                                    gboolean do_event_loop,
                                                    gpointer self);
static gboolean _aggregate_progress_monitor_monitor_progress_monitor (guint64 current,
                                                               guint64 total,
                                                               gboolean do_event_loop,
                                                               gpointer self);
VALA_EXTERN GFile* app_dirs_get_import_dir (void);
VALA_EXTERN void report_system_pictures_import (ImportManifest* manifest,
                                    BatchImportRoll* import_roll);
static void _report_system_pictures_import_batch_import_import_reporter (ImportManifest* manifest,
                                                                  BatchImportRoll* import_roll,
                                                                  gpointer self);
VALA_EXTERN void editing_exec (const gchar* filename);
static void _vala_main (gchar** args,
                 gint args_length1);
VALA_EXTERN void app_dirs_init (const gchar* arg0);
VALA_EXTERN GFile* app_dirs_get_install_dir (void);
VALA_EXTERN GFile* app_dirs_get_exec_dir (void);
VALA_EXTERN void app_dirs_terminate (void);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN void app_dirs_set_data_dir (const gchar* user_data_dir);
VALA_EXTERN void app_dirs_try_migrate_data (void);
VALA_EXTERN void app_dirs_verify_data_dir (void);
VALA_EXTERN void app_dirs_verify_cache_dir (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

const GOptionEntry COMMANDLINE_OPTIONS_APP_OPTIONS[6] = {{"datadir", 'd', (gint) 0, G_OPTION_ARG_FILENAME, &commandline_options_data_dir, N_ ("Path to Photos' private data"), N_ ("DIRECTORY")}, {"no-runtime-monitoring", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &commandline_options_no_runtime_monitoring, N_ ("Do not monitor library directory at runtime for changes"), NULL}, {"no-startup-progress", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &commandline_options_no_startup_progress, N_ ("Don't display startup progress meter"), NULL}, {"version", 'v', (gint) 0, G_OPTION_ARG_NONE, &commandline_options_show_version, N_ ("Show the application's version"), NULL}, {"debug", 'D', (gint) 0, G_OPTION_ARG_NONE, &commandline_options_debug_enabled, N_ ("Show extra debugging output"), NULL}, {NULL}};

static GType
shotwell_command_get_type_once (void)
{
	static const GEnumValue values[] = {{SHOTWELL_COMMAND_MOUNTED_CAMERA, "SHOTWELL_COMMAND_MOUNTED_CAMERA", "mounted-camera"}, {0, NULL, NULL}};
	GType shotwell_command_type_id;
	shotwell_command_type_id = g_enum_register_static ("ShotwellCommand", values);
	return shotwell_command_type_id;
}

GType
shotwell_command_get_type (void)
{
	static volatile gsize shotwell_command_type_id__once = 0;
	if (g_once_init_enter (&shotwell_command_type_id__once)) {
		GType shotwell_command_type_id;
		shotwell_command_type_id = shotwell_command_get_type_once ();
		g_once_init_leave (&shotwell_command_type_id__once, shotwell_command_type_id);
	}
	return shotwell_command_type_id__once;
}

static gboolean
_progress_dialog_monitor_progress_monitor (guint64 current,
                                           guint64 total,
                                           gboolean do_event_loop,
                                           gpointer self)
{
	gboolean result;
	result = progress_dialog_monitor ((ProgressDialog*) self, current, total, do_event_loop);
	return result;
}

static gboolean
_aggregate_progress_monitor_monitor_progress_monitor (guint64 current,
                                                      guint64 total,
                                                      gboolean do_event_loop,
                                                      gpointer self)
{
	gboolean result;
	result = aggregate_progress_monitor_monitor ((AggregateProgressMonitor*) self, current, total);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
library_exec (gchar** mounts,
              gint mounts_length1)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* error_title = NULL;
	gchar* error_message = NULL;
	gchar* app_version = NULL;
	gint schema_version = 0;
	DbVerifyResult _result_ = 0;
	gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	DbVerifyResult _tmp8_;
	const gchar* _tmp25_;
	ProgressDialog* progress_dialog = NULL;
	AggregateProgressMonitor* aggregate_monitor = NULL;
	ProgressMonitor monitor = NULL;
	gpointer monitor_target;
	GDestroyNotify monitor_target_destroy_notify;
	AggregateProgressMonitor* _tmp48_;
	ProgressMonitor _tmp50_;
	gpointer _tmp50__target;
	AggregateProgressMonitor* _tmp51_;
	ProgressMonitor _tmp53_;
	gpointer _tmp53__target;
	AggregateProgressMonitor* _tmp54_;
	Upgrades* _tmp56_;
	Upgrades* _tmp57_;
	MediaCollectionRegistry* registry = NULL;
	MediaCollectionRegistry* _tmp58_;
	MediaCollectionRegistry* _tmp59_;
	LibraryPhotoSourceCollection* _tmp60_;
	MediaCollectionRegistry* _tmp61_;
	VideoSourceCollection* _tmp62_;
	AggregateProgressMonitor* _tmp63_;
	ProgressMonitor _tmp65_;
	gpointer _tmp65__target;
	AggregateProgressMonitor* _tmp66_;
	ProgressMonitor _tmp68_;
	gpointer _tmp68__target;
	GApplication* _tmp69_;
	AggregateProgressMonitor* _tmp70_;
	LibraryWindow* library_window = NULL;
	ProgressMonitor _tmp72_;
	gpointer _tmp72__target;
	LibraryWindow* _tmp73_;
	AggregateProgressMonitor* _tmp74_;
	ProgressDialog* _tmp76_;
	LibraryWindow* _tmp81_;
	WelcomeServiceEntry** selected_import_entries = NULL;
	WelcomeServiceEntry** _tmp82_;
	gint selected_import_entries_length1;
	gint _selected_import_entries_size_;
	WelcomeServiceEntry** _tmp83_;
	gint _tmp83__length1;
	GTimer* _tmp87_;
	GApplication* _tmp88_;
	GError* _inner_error0_ = NULL;
	was_already_running = photos_application_app_get_is_remote ();
	if (was_already_running) {
		photos_application_present_primary_instance ();
		photos_application_send_to_primary_instance (mounts, (gint) mounts_length1);
		return;
	}
	_tmp0_ = app_dirs_get_data_subdir ("data", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, "photo.db");
	_tmp3_ = _tmp2_;
	db_preconfigure (_tmp3_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	{
		library_app_init (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		app_window_panic (_tmp5_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_message ("main.vala:57: Verifying database …");
	error_title = NULL;
	error_message = NULL;
	_tmp8_ = db_verify_database (&_tmp6_, &_tmp7_);
	_g_free0 (app_version);
	app_version = _tmp6_;
	schema_version = _tmp7_;
	_result_ = _tmp8_;
	switch (_result_) {
		case DB_VERIFY_RESULT_OK:
		{
			break;
		}
		case DB_VERIFY_RESULT_FUTURE_VERSION:
		{
			gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = g_strdup (_ ("Your Photo Library Is Not Compatible With This Version of Photos"));
			_g_free0 (error_title);
			error_title = _tmp9_;
			_tmp10_ = app_version;
			_tmp11_ = g_strdup_printf (_ ("It appears it was created by Photos %s (schema %d). This version is %s" \
" (schema %d). Please use the latest version of Photos."), _tmp10_, schema_version, RESOURCES_APP_VERSION, DATABASE_TABLE_SCHEMA_VERSION);
			_g_free0 (error_message);
			error_message = _tmp11_;
			break;
		}
		case DB_VERIFY_RESULT_UPGRADE_ERROR:
		{
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp12_ = app_version;
			_tmp13_ = g_strdup_printf (_ ("Photos Was Unable To Upgrade Your Photo Library From Version %s (Schem" \
"a %d) to %s (Schema %d)"), _tmp12_, schema_version, RESOURCES_APP_VERSION, DATABASE_TABLE_SCHEMA_VERSION);
			_g_free0 (error_title);
			error_title = _tmp13_;
			_tmp14_ = g_strdup_printf (_ ("For more information please check the Photos Wiki at %s"), RESOURCES_WIKI_URL);
			_g_free0 (error_message);
			error_message = _tmp14_;
			break;
		}
		case DB_VERIFY_RESULT_NO_UPGRADE_AVAILABLE:
		{
			gchar* _tmp15_;
			const gchar* _tmp16_;
			GFile* _tmp17_;
			GFile* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp15_ = g_strdup (_ ("Your Photo Library Is Not Compatible With This Version of Photos"));
			_g_free0 (error_title);
			error_title = _tmp15_;
			_tmp16_ = app_version;
			_tmp17_ = app_dirs_get_data_dir ();
			_tmp18_ = _tmp17_;
			_tmp19_ = g_file_get_path (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strdup_printf (_ ("It appears it was created by Photos %s (schema %d). This version is %s" \
" (schema %d). Please clear your library by deleting %s and re-import y" \
"our photos."), _tmp16_, schema_version, RESOURCES_APP_VERSION, DATABASE_TABLE_SCHEMA_VERSION, _tmp20_);
			_g_free0 (error_message);
			error_message = _tmp21_;
			_g_free0 (_tmp20_);
			_g_object_unref0 (_tmp18_);
			break;
		}
		default:
		{
			gchar* _tmp22_;
			GEnumValue* _tmp23_;
			gchar* _tmp24_;
			_tmp22_ = g_strdup (_ ("Unknown Error Attempting To Verify Photos' Database"));
			_g_free0 (error_title);
			error_title = _tmp22_;
			_tmp23_ = g_enum_get_value (g_type_class_ref (DB_TYPE_VERIFY_RESULT), _result_);
			_tmp24_ = g_strdup ((_tmp23_ != NULL) ? _tmp23_->value_name : NULL);
			_g_free0 (error_message);
			error_message = _tmp24_;
			break;
		}
	}
	_tmp25_ = error_title;
	if (_tmp25_ != NULL) {
		GraniteMessageDialog* dialog = NULL;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		GraniteMessageDialog* _tmp28_;
		GraniteMessageDialog* _tmp29_;
		GraniteMessageDialog* _tmp30_;
		_tmp26_ = error_title;
		_tmp27_ = error_message;
		_tmp28_ = granite_message_dialog_new_with_image_from_icon_name (_tmp26_, _tmp27_, "dialog-error", GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp28_);
		dialog = _tmp28_;
		_tmp29_ = dialog;
		gtk_dialog_run ((GtkDialog*) _tmp29_);
		_tmp30_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp30_);
		database_table_terminate ();
		_g_object_unref0 (dialog);
		_g_free0 (app_version);
		_g_free0 (error_message);
		_g_free0 (error_title);
		return;
	}
	upgrades_init ();
	progress_dialog = NULL;
	aggregate_monitor = NULL;
	monitor = NULL;
	monitor_target = NULL;
	monitor_target_destroy_notify = NULL;
	if (!commandline_options_no_startup_progress) {
		guint64 grand_total = 0ULL;
		PhotoTable* _tmp31_;
		PhotoTable* _tmp32_;
		EventTable* _tmp33_;
		EventTable* _tmp34_;
		TagTable* _tmp35_;
		TagTable* _tmp36_;
		VideoTable* _tmp37_;
		VideoTable* _tmp38_;
		Upgrades* _tmp39_;
		Upgrades* _tmp40_;
		guint64 _tmp41_;
		_tmp31_ = photo_table_get_instance ();
		_tmp32_ = _tmp31_;
		_tmp33_ = event_table_get_instance ();
		_tmp34_ = _tmp33_;
		_tmp35_ = tag_table_get_instance ();
		_tmp36_ = _tmp35_;
		_tmp37_ = video_table_get_instance ();
		_tmp38_ = _tmp37_;
		_tmp39_ = upgrades_get_instance ();
		_tmp40_ = _tmp39_;
		_tmp41_ = (((database_table_get_row_count ((DatabaseTable*) _tmp32_) + database_table_get_row_count ((DatabaseTable*) _tmp34_)) + database_table_get_row_count ((DatabaseTable*) _tmp36_)) + database_table_get_row_count ((DatabaseTable*) _tmp38_)) + upgrades_get_step_count (_tmp40_);
		_upgrades_unref0 (_tmp40_);
		_database_table_unref0 (_tmp38_);
		_database_table_unref0 (_tmp36_);
		_database_table_unref0 (_tmp34_);
		_database_table_unref0 (_tmp32_);
		grand_total = _tmp41_;
		if (grand_total > ((guint64) 5000)) {
			ProgressDialog* _tmp42_;
			ProgressDialog* _tmp43_;
			ProgressDialog* _tmp44_;
			ProgressDialog* _tmp45_;
			AggregateProgressMonitor* _tmp46_;
			AggregateProgressMonitor* _tmp47_;
			_tmp42_ = progress_dialog_new (NULL, _ ("Loading Photos"), NULL);
			g_object_ref_sink (_tmp42_);
			_g_object_unref0 (progress_dialog);
			progress_dialog = _tmp42_;
			_tmp43_ = progress_dialog;
			progress_dialog_update_display_every (_tmp43_, 100);
			_tmp44_ = progress_dialog;
			progress_dialog_set_minimum_on_screen_time_msec (_tmp44_, 250);
			_tmp45_ = progress_dialog;
			_tmp46_ = aggregate_progress_monitor_new (grand_total, _progress_dialog_monitor_progress_monitor, _tmp45_);
			_aggregate_progress_monitor_unref0 (aggregate_monitor);
			aggregate_monitor = _tmp46_;
			_tmp47_ = aggregate_monitor;
			(monitor_target_destroy_notify == NULL) ? NULL : (monitor_target_destroy_notify (monitor_target), NULL);
			monitor = NULL;
			monitor_target = NULL;
			monitor_target_destroy_notify = NULL;
			monitor = _aggregate_progress_monitor_monitor_progress_monitor;
			monitor_target = aggregate_progress_monitor_ref (_tmp47_);
			monitor_target_destroy_notify = aggregate_progress_monitor_unref;
		}
	}
	thumbnail_cache_init ();
	tombstone_init ();
	_tmp48_ = aggregate_monitor;
	if (_tmp48_ != NULL) {
		AggregateProgressMonitor* _tmp49_;
		_tmp49_ = aggregate_monitor;
		aggregate_progress_monitor_next_step (_tmp49_, "LibraryPhoto.init");
	}
	_tmp50_ = monitor;
	_tmp50__target = monitor_target;
	library_photo_init (_tmp50_, _tmp50__target);
	_tmp51_ = aggregate_monitor;
	if (_tmp51_ != NULL) {
		AggregateProgressMonitor* _tmp52_;
		_tmp52_ = aggregate_monitor;
		aggregate_progress_monitor_next_step (_tmp52_, "Video.init");
	}
	_tmp53_ = monitor;
	_tmp53__target = monitor_target;
	video_init (_tmp53_, _tmp53__target);
	_tmp54_ = aggregate_monitor;
	if (_tmp54_ != NULL) {
		AggregateProgressMonitor* _tmp55_;
		_tmp55_ = aggregate_monitor;
		aggregate_progress_monitor_next_step (_tmp55_, "Upgrades.execute");
	}
	_tmp56_ = upgrades_get_instance ();
	_tmp57_ = _tmp56_;
	upgrades_execute (_tmp57_, NULL, NULL);
	_upgrades_unref0 (_tmp57_);
	library_monitor_pool_init ();
	media_collection_registry_init ();
	_tmp58_ = media_collection_registry_get_instance ();
	registry = _tmp58_;
	_tmp59_ = registry;
	_tmp60_ = library_photo_global;
	media_collection_registry_register_collection (_tmp59_, (MediaSourceCollection*) _tmp60_);
	_tmp61_ = registry;
	_tmp62_ = video_global;
	media_collection_registry_register_collection (_tmp61_, (MediaSourceCollection*) _tmp62_);
	_tmp63_ = aggregate_monitor;
	if (_tmp63_ != NULL) {
		AggregateProgressMonitor* _tmp64_;
		_tmp64_ = aggregate_monitor;
		aggregate_progress_monitor_next_step (_tmp64_, "Event.init");
	}
	_tmp65_ = monitor;
	_tmp65__target = monitor_target;
	event_init (_tmp65_, _tmp65__target);
	_tmp66_ = aggregate_monitor;
	if (_tmp66_ != NULL) {
		AggregateProgressMonitor* _tmp67_;
		_tmp67_ = aggregate_monitor;
		aggregate_progress_monitor_next_step (_tmp67_, "Tag.init");
	}
	_tmp68_ = monitor;
	_tmp68__target = monitor_target;
	tag_init (_tmp68_, _tmp68__target);
	metadata_writer_init ();
	_tmp69_ = g_application_get_default ();
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, PHOTOS_TYPE_APPLICATION, PhotosApplication), "init-done");
	_tmp70_ = aggregate_monitor;
	if (_tmp70_ != NULL) {
		AggregateProgressMonitor* _tmp71_;
		_tmp71_ = aggregate_monitor;
		aggregate_progress_monitor_next_step (_tmp71_, "LibraryWindow");
	}
	_tmp72_ = monitor;
	_tmp72__target = monitor_target;
	_tmp73_ = library_window_new (_tmp72_, _tmp72__target);
	g_object_ref_sink (_tmp73_);
	library_window = _tmp73_;
	_tmp74_ = aggregate_monitor;
	if (_tmp74_ != NULL) {
		AggregateProgressMonitor* _tmp75_;
		_tmp75_ = aggregate_monitor;
		aggregate_progress_monitor_next_step (_tmp75_, "done");
	}
	(monitor_target_destroy_notify == NULL) ? NULL : (monitor_target_destroy_notify (monitor_target), NULL);
	monitor = NULL;
	monitor_target = NULL;
	monitor_target_destroy_notify = NULL;
	monitor = NULL;
	monitor_target = NULL;
	monitor_target_destroy_notify = NULL;
	_aggregate_progress_monitor_unref0 (aggregate_monitor);
	aggregate_monitor = NULL;
	_tmp76_ = progress_dialog;
	if (_tmp76_ != NULL) {
		ProgressDialog* _tmp77_;
		_tmp77_ = progress_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp77_);
	}
	_g_object_unref0 (progress_dialog);
	progress_dialog = NULL;
	{
		gchar** mount_collection = NULL;
		gint mount_collection_length1 = 0;
		gint _mount_collection_size_ = 0;
		gint mount_it = 0;
		mount_collection = mounts;
		mount_collection_length1 = mounts_length1;
		for (mount_it = 0; mount_it < mount_collection_length1; mount_it = mount_it + 1) {
			gchar* _tmp78_;
			gchar* mount = NULL;
			_tmp78_ = g_strdup (mount_collection[mount_it]);
			mount = _tmp78_;
			{
				LibraryWindow* _tmp79_;
				const gchar* _tmp80_;
				_tmp79_ = library_window;
				_tmp80_ = mount;
				library_window_mounted_camera_shell_notification (_tmp79_, _tmp80_, TRUE);
				_g_free0 (mount);
			}
		}
	}
	_tmp81_ = library_window;
	gtk_widget_show_all ((GtkWidget*) _tmp81_);
	_tmp82_ = g_new0 (WelcomeServiceEntry*, 0 + 1);
	selected_import_entries = _tmp82_;
	selected_import_entries_length1 = 0;
	_selected_import_entries_size_ = selected_import_entries_length1;
	_tmp83_ = selected_import_entries;
	_tmp83__length1 = selected_import_entries_length1;
	if (_tmp83__length1 > 0) {
		WelcomeServiceEntry** _tmp84_;
		gint _tmp84__length1;
		do_external_import = TRUE;
		_tmp84_ = selected_import_entries;
		_tmp84__length1 = selected_import_entries_length1;
		{
			WelcomeServiceEntry** entry_collection = NULL;
			gint entry_collection_length1 = 0;
			gint _entry_collection_size_ = 0;
			gint entry_it = 0;
			entry_collection = _tmp84_;
			entry_collection_length1 = _tmp84__length1;
			for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
				WelcomeServiceEntry* _tmp85_;
				WelcomeServiceEntry* entry = NULL;
				_tmp85_ = _g_object_ref0 (entry_collection[entry_it]);
				entry = _tmp85_;
				{
					WelcomeServiceEntry* _tmp86_;
					_tmp86_ = entry;
					welcome_service_entry_execute (_tmp86_);
					_g_object_unref0 (entry);
				}
			}
		}
	}
	if (do_system_pictures_import) {
		run_system_pictures_import (NULL);
	}
	_tmp87_ = startup_timer;
	g_debug ("main.vala:191: %lf seconds to Gtk.main ()", g_timer_elapsed (_tmp87_, NULL));
	_tmp88_ = g_application_get_default ();
	photos_application_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, PHOTOS_TYPE_APPLICATION, PhotosApplication), NULL, (gint) 0);
	metadata_writer_terminate ();
	tag_terminate ();
	event_terminate ();
	library_photo_terminate ();
	library_monitor_pool_terminate ();
	tombstone_terminate ();
	thumbnail_cache_terminate ();
	video_terminate ();
	library_app_terminate ();
	selected_import_entries = (_vala_array_free (selected_import_entries, selected_import_entries_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (library_window);
	_media_collection_registry_unref0 (registry);
	(monitor_target_destroy_notify == NULL) ? NULL : (monitor_target_destroy_notify (monitor_target), NULL);
	monitor = NULL;
	monitor_target = NULL;
	monitor_target_destroy_notify = NULL;
	_aggregate_progress_monitor_unref0 (aggregate_monitor);
	_g_object_unref0 (progress_dialog);
	_g_free0 (app_version);
	_g_free0 (error_message);
	_g_free0 (error_title);
}

static void
_report_system_pictures_import_batch_import_import_reporter (ImportManifest* manifest,
                                                             BatchImportRoll* import_roll,
                                                             gpointer self)
{
	report_system_pictures_import (manifest, import_roll);
}

void
run_system_pictures_import (ImportManifest* external_exclusion_manifest)
{
	GeeArrayList* jobs = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	FileImportJob* _tmp4_;
	FileImportJob* _tmp5_;
	LibraryWindow* library_window = NULL;
	AppWindow* _tmp6_;
	BatchImport* batch_import = NULL;
	GeeArrayList* _tmp7_;
	BatchImport* _tmp8_;
	LibraryWindow* _tmp9_;
	BatchImport* _tmp10_;
	LibraryWindow* _tmp11_;
	if (!do_system_pictures_import) {
		return;
	}
	_tmp0_ = gee_array_list_new (TYPE_FILE_IMPORT_JOB, (GBoxedCopyFunc) batch_import_job_ref, (GDestroyNotify) batch_import_job_unref, NULL, NULL, NULL);
	jobs = _tmp0_;
	_tmp1_ = jobs;
	_tmp2_ = app_dirs_get_import_dir ();
	_tmp3_ = _tmp2_;
	_tmp4_ = file_import_job_new (_tmp3_, FALSE);
	_tmp5_ = _tmp4_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp5_);
	_batch_import_job_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	_tmp6_ = app_window_get_instance ();
	library_window = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_LIBRARY_WINDOW, LibraryWindow);
	_tmp7_ = jobs;
	_tmp8_ = batch_import_new ((GeeIterable*) _tmp7_, "startup_import", _report_system_pictures_import_batch_import_import_reporter, NULL, NULL, NULL, NULL, NULL, external_exclusion_manifest);
	batch_import = _tmp8_;
	_tmp9_ = library_window;
	_tmp10_ = batch_import;
	library_window_enqueue_batch_import (_tmp9_, _tmp10_, TRUE);
	_tmp11_ = library_window;
	library_window_switch_to_import_queue_page (_tmp11_);
	_g_object_unref0 (batch_import);
	_g_object_unref0 (library_window);
	_g_object_unref0 (jobs);
}

void
report_system_pictures_import (ImportManifest* manifest,
                               BatchImportRoll* import_roll)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (manifest != NULL);
	g_return_if_fail (import_roll != NULL);
	if (do_external_import) {
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = manifest->all;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	import_ui_report_manifest (manifest, TRUE, NULL);
}

void
editing_exec (const gchar* filename)
{
	GFile* initial_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	DirectWindow* direct_window = NULL;
	GFile* _tmp4_;
	DirectWindow* _tmp5_;
	DirectWindow* _tmp6_;
	GTimer* _tmp7_;
	GApplication* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (filename != NULL);
	_tmp0_ = g_file_new_for_commandline_arg (filename);
	initial_file = _tmp0_;
	_tmp1_ = initial_file;
	direct_preconfigure (_tmp1_);
	db_preconfigure (NULL);
	{
		direct_app_init (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		app_window_panic (_tmp3_);
		_g_error_free0 (err);
		_g_object_unref0 (initial_file);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (initial_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = initial_file;
	_tmp5_ = direct_window_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	direct_window = _tmp5_;
	_tmp6_ = direct_window;
	gtk_widget_show_all ((GtkWidget*) _tmp6_);
	_tmp7_ = startup_timer;
	g_debug ("main.vala:261: %lf seconds to Gtk.main ()", g_timer_elapsed (_tmp7_, NULL));
	_tmp8_ = g_application_get_default ();
	photos_application_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, PHOTOS_TYPE_APPLICATION, PhotosApplication), NULL, (gint) 0);
	direct_app_terminate ();
	_g_object_unref0 (direct_window);
	_g_object_unref0 (initial_file);
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_vala_main (gchar** args,
            gint args_length1)
{
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_;
	gchar** mounts = NULL;
	gchar** _tmp15_;
	gint mounts_length1;
	gint _mounts_size_;
	gchar* filename = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	GTimer* _tmp33_;
	GTimer* _tmp34_;
	const gchar* _tmp35_;
	gboolean _tmp38_ = FALSE;
	const gchar* _tmp39_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = args[0];
	app_dirs_init (_tmp0_);
	gexiv2_initialize ();
	_tmp1_ = app_dirs_get_install_dir ();
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ == NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		GFile* _tmp4_;
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp4_ = app_dirs_get_exec_dir ();
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_get_path (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, "/misc", NULL);
		_tmp9_ = _tmp8_;
		g_setenv ("GSETTINGS_SCHEMA_DIR", _tmp9_, TRUE);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_object_unref0 (_tmp5_);
	}
	{
		gtk_init_with_args ((gint*) (&args_length1), &args, _ ("[FILE]"), COMMANDLINE_OPTIONS_APP_OPTIONS, RESOURCES_APP_GETTEXT_PACKAGE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
		_tmp13_ = _tmp12_;
		g_print ("%s", _tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = args[0];
		g_print (_ ("Run '%s --help' to see a full list of available command line options.\n"), _tmp14_);
		app_dirs_terminate ();
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (commandline_options_show_version) {
		if (RESOURCES_GIT_VERSION != NULL) {
			g_print ("%s %s (%s)\n", _ (RESOURCES_APP_TITLE), RESOURCES_APP_VERSION, RESOURCES_GIT_VERSION);
		} else {
			g_print ("%s %s\n", _ (RESOURCES_APP_TITLE), RESOURCES_APP_VERSION);
		}
		app_dirs_terminate ();
		return;
	}
	_tmp15_ = g_new0 (gchar*, 0 + 1);
	mounts = _tmp15_;
	mounts_length1 = 0;
	_mounts_size_ = mounts_length1;
	filename = NULL;
	{
		gint ctr = 0;
		ctr = 1;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gchar* arg = NULL;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				const gchar* _tmp20_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = ctr;
					ctr = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				if (!(ctr < args_length1)) {
					break;
				}
				_tmp18_ = args[ctr];
				_tmp19_ = g_strdup (_tmp18_);
				arg = _tmp19_;
				_tmp20_ = arg;
				if (library_window_is_mount_uri_supported (_tmp20_)) {
					const gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp21_ = arg;
					_tmp22_ = g_strdup (_tmp21_);
					_vala_array_add4 (&mounts, &mounts_length1, &_mounts_size_, _tmp22_);
				} else {
					gboolean _tmp23_ = FALSE;
					const gchar* _tmp24_;
					_tmp24_ = filename;
					if (is_string_empty (_tmp24_)) {
						const gchar* _tmp25_;
						_tmp25_ = arg;
						_tmp23_ = !string_contains (_tmp25_, "://");
					} else {
						_tmp23_ = FALSE;
					}
					if (_tmp23_) {
						const gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp26_ = arg;
						_tmp27_ = g_strdup (_tmp26_);
						_g_free0 (filename);
						filename = _tmp27_;
					}
				}
				_g_free0 (arg);
			}
		}
	}
	_tmp29_ = filename;
	if (is_string_empty (_tmp29_)) {
		_tmp28_ = RESOURCES_APP_LIBRARY_ROLE;
	} else {
		_tmp28_ = RESOURCES_APP_DIRECT_ROLE;
	}
	g_message ("main.vala:347: Photos %s %s", _tmp28_, RESOURCES_APP_VERSION);
	_tmp30_ = filename;
	photos_application_init (!is_string_empty (_tmp30_));
	_tmp31_ = commandline_options_data_dir;
	if (_tmp31_ != NULL) {
		const gchar* _tmp32_;
		_tmp32_ = commandline_options_data_dir;
		app_dirs_set_data_dir (_tmp32_);
	} else {
		app_dirs_try_migrate_data ();
	}
	app_dirs_verify_data_dir ();
	app_dirs_verify_cache_dir ();
	setlocale (LC_ALL, "");
	textdomain (GETTEXT_PACKAGE);
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp33_ = g_timer_new ();
	_g_timer_destroy0 (startup_timer);
	startup_timer = _tmp33_;
	_tmp34_ = startup_timer;
	g_timer_start (_tmp34_);
	g_set_application_name (_ (RESOURCES_APP_TITLE));
	_tmp35_ = filename;
	if (is_string_empty (_tmp35_)) {
		gchar** _tmp36_;
		gint _tmp36__length1;
		_tmp36_ = mounts;
		_tmp36__length1 = mounts_length1;
		library_exec (_tmp36_, (gint) _tmp36__length1);
	} else {
		const gchar* _tmp37_;
		_tmp37_ = filename;
		editing_exec (_tmp37_);
	}
	photos_application_terminate ();
	app_dirs_terminate ();
	_tmp39_ = filename;
	if (is_string_empty (_tmp39_)) {
		_tmp38_ = !was_already_running;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		gchar* orig_path = NULL;
		GFile* _tmp40_;
		GFile* _tmp41_;
		GFile* _tmp42_;
		GFile* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* backup_path = NULL;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* cmdline = NULL;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		const gchar* _tmp56_;
		_tmp40_ = app_dirs_get_data_subdir ("data", NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_file_get_child (_tmp41_, "photo.db");
		_tmp43_ = _tmp42_;
		_tmp44_ = g_file_get_path (_tmp43_);
		_tmp45_ = _tmp44_;
		_g_object_unref0 (_tmp43_);
		_g_object_unref0 (_tmp41_);
		orig_path = _tmp45_;
		_tmp46_ = orig_path;
		_tmp47_ = g_strconcat (_tmp46_, ".bak", NULL);
		backup_path = _tmp47_;
		_tmp48_ = orig_path;
		_tmp49_ = g_strconcat ("cp ", _tmp48_, NULL);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_strconcat (_tmp50_, " ", NULL);
		_tmp52_ = _tmp51_;
		_tmp53_ = backup_path;
		_tmp54_ = g_strconcat (_tmp52_, _tmp53_, NULL);
		_tmp55_ = _tmp54_;
		_g_free0 (_tmp52_);
		_g_free0 (_tmp50_);
		cmdline = _tmp55_;
		_tmp56_ = cmdline;
		system (_tmp56_);
		system ("sync");
		_g_free0 (cmdline);
		_g_free0 (backup_path);
		_g_free0 (orig_path);
	}
	_g_free0 (filename);
	mounts = (_vala_array_free (mounts, mounts_length1, (GDestroyNotify) g_free), NULL);
}

int
main (int argc,
      char ** argv)
{
	_vala_main (argv, argc);
	return 0;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

