// services/viz/public/mojom/compositing/copy_output_request.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/copy_output_request.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-blink-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/mailbox.mojom-blink-forward.h"
#include "gpu/ipc/common/sync_token.mojom-blink-forward.h"
#include "services/viz/public/mojom/compositing/copy_output_result.mojom-blink-forward.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {

class CopyOutputResultSenderProxy;

template <typename ImplRefTraits>
class CopyOutputResultSenderStub;

class CopyOutputResultSenderRequestValidator;


class BLINK_PLATFORM_EXPORT CopyOutputResultSender
    : public CopyOutputResultSenderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CopyOutputResultSenderInterfaceBase;
  using Proxy_ = CopyOutputResultSenderProxy;

  template <typename ImplRefTraits>
  using Stub_ = CopyOutputResultSenderStub<ImplRefTraits>;

  using RequestValidator_ = CopyOutputResultSenderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSendResultMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SendResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CopyOutputResultSender() = default;

  
  virtual void SendResult(::viz::mojom::blink::CopyOutputResultPtr result) = 0;
};



class BLINK_PLATFORM_EXPORT CopyOutputResultSenderProxy
    : public CopyOutputResultSender {
 public:
  using InterfaceType = CopyOutputResultSender;

  explicit CopyOutputResultSenderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SendResult(::viz::mojom::blink::CopyOutputResultPtr result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT CopyOutputResultSenderStubDispatch {
 public:
  static bool Accept(CopyOutputResultSender* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CopyOutputResultSender* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CopyOutputResultSender>>
class CopyOutputResultSenderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CopyOutputResultSenderStub() = default;
  ~CopyOutputResultSenderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CopyOutputResultSenderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CopyOutputResultSenderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT CopyOutputResultSenderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_PLATFORM_EXPORT CopyOutputRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CopyOutputRequest, T>::value>;
  using DataView = CopyOutputRequestDataView;
  using Data_ = internal::CopyOutputRequest_Data;

  template <typename... Args>
  static CopyOutputRequestPtr New(Args&&... args) {
    return CopyOutputRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CopyOutputRequestPtr From(const U& u) {
    return mojo::TypeConverter<CopyOutputRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CopyOutputRequest>::Convert(*this);
  }


  CopyOutputRequest();

  CopyOutputRequest(
      ::viz::mojom::blink::CopyOutputResultFormat result_format,
      ::viz::mojom::blink::CopyOutputResultDestination result_destination,
      const ::gfx::Vector2d& scale_from,
      const ::gfx::Vector2d& scale_to,
      const std::optional<::base::UnguessableToken>& source,
      const std::optional<::gfx::Rect>& area,
      const std::optional<::gfx::Rect>& result_selection,
      ::mojo::PendingRemote<CopyOutputResultSender> result_sender);

CopyOutputRequest(const CopyOutputRequest&) = delete;
CopyOutputRequest& operator=(const CopyOutputRequest&) = delete;

  ~CopyOutputRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CopyOutputRequestPtr>
  CopyOutputRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CopyOutputRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CopyOutputRequest_UnserializedMessageContext<
            UserType, CopyOutputRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CopyOutputRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CopyOutputRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CopyOutputRequest_UnserializedMessageContext<
            UserType, CopyOutputRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CopyOutputRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::mojom::blink::CopyOutputResultFormat result_format;
  
  ::viz::mojom::blink::CopyOutputResultDestination result_destination;
  
  ::gfx::Vector2d scale_from;
  
  ::gfx::Vector2d scale_to;
  
  std::optional<::base::UnguessableToken> source;
  
  std::optional<::gfx::Rect> area;
  
  std::optional<::gfx::Rect> result_selection;
  
  ::mojo::PendingRemote<CopyOutputResultSender> result_sender;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CopyOutputRequestPtr CopyOutputRequest::Clone() const {
  return New(
      mojo::Clone(result_format),
      mojo::Clone(result_destination),
      mojo::Clone(scale_from),
      mojo::Clone(scale_to),
      mojo::Clone(source),
      mojo::Clone(area),
      mojo::Clone(result_selection),
      mojo::Clone(result_sender)
  );
}

template <typename T, CopyOutputRequest::EnableIfSame<T>*>
bool CopyOutputRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->result_format, other_struct.result_format))
    return false;
  if (!mojo::Equals(this->result_destination, other_struct.result_destination))
    return false;
  if (!mojo::Equals(this->scale_from, other_struct.scale_from))
    return false;
  if (!mojo::Equals(this->scale_to, other_struct.scale_to))
    return false;
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  if (!mojo::Equals(this->area, other_struct.area))
    return false;
  if (!mojo::Equals(this->result_selection, other_struct.result_selection))
    return false;
  if (!mojo::Equals(this->result_sender, other_struct.result_sender))
    return false;
  return true;
}

template <typename T, CopyOutputRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.result_format < rhs.result_format)
    return true;
  if (rhs.result_format < lhs.result_format)
    return false;
  if (lhs.result_destination < rhs.result_destination)
    return true;
  if (rhs.result_destination < lhs.result_destination)
    return false;
  if (lhs.scale_from < rhs.scale_from)
    return true;
  if (rhs.scale_from < lhs.scale_from)
    return false;
  if (lhs.scale_to < rhs.scale_to)
    return true;
  if (rhs.scale_to < lhs.scale_to)
    return false;
  if (lhs.source < rhs.source)
    return true;
  if (rhs.source < lhs.source)
    return false;
  if (lhs.area < rhs.area)
    return true;
  if (rhs.area < lhs.area)
    return false;
  if (lhs.result_selection < rhs.result_selection)
    return true;
  if (rhs.result_selection < lhs.result_selection)
    return false;
  if (lhs.result_sender < rhs.result_sender)
    return true;
  if (rhs.result_sender < lhs.result_sender)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::CopyOutputRequest::DataView,
                                         ::viz::mojom::blink::CopyOutputRequestPtr> {
  static bool IsNull(const ::viz::mojom::blink::CopyOutputRequestPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::CopyOutputRequestPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::CopyOutputRequest::result_format) result_format(
      const ::viz::mojom::blink::CopyOutputRequestPtr& input) {
    return input->result_format;
  }

  static decltype(::viz::mojom::blink::CopyOutputRequest::result_destination) result_destination(
      const ::viz::mojom::blink::CopyOutputRequestPtr& input) {
    return input->result_destination;
  }

  static const decltype(::viz::mojom::blink::CopyOutputRequest::scale_from)& scale_from(
      const ::viz::mojom::blink::CopyOutputRequestPtr& input) {
    return input->scale_from;
  }

  static const decltype(::viz::mojom::blink::CopyOutputRequest::scale_to)& scale_to(
      const ::viz::mojom::blink::CopyOutputRequestPtr& input) {
    return input->scale_to;
  }

  static const decltype(::viz::mojom::blink::CopyOutputRequest::source)& source(
      const ::viz::mojom::blink::CopyOutputRequestPtr& input) {
    return input->source;
  }

  static const decltype(::viz::mojom::blink::CopyOutputRequest::area)& area(
      const ::viz::mojom::blink::CopyOutputRequestPtr& input) {
    return input->area;
  }

  static const decltype(::viz::mojom::blink::CopyOutputRequest::result_selection)& result_selection(
      const ::viz::mojom::blink::CopyOutputRequestPtr& input) {
    return input->result_selection;
  }

  static  decltype(::viz::mojom::blink::CopyOutputRequest::result_sender)& result_sender(
       ::viz::mojom::blink::CopyOutputRequestPtr& input) {
    return input->result_sender;
  }

  static bool Read(::viz::mojom::blink::CopyOutputRequest::DataView input, ::viz::mojom::blink::CopyOutputRequestPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_BLINK_H_