// services/viz/public/mojom/compositing/frame_sink_bundle.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-params-data.h"
namespace viz {
namespace mojom {

namespace internal {
// static
bool BundledFrameSubmissionData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const BundledFrameSubmissionData_Data* object = static_cast<const BundledFrameSubmissionData_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case BundledFrameSubmissionData_Tag::kFrame: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_frame, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_frame, validation_context))
        return false;
      return true;
    }
    case BundledFrameSubmissionData_Tag::kDidNotProduceFrame: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_did_not_produce_frame, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_did_not_produce_frame, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in BundledFrameSubmissionData");
      return false;
    }
  }
}


// static
bool BundledFrameSubmission_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundledFrameSubmission_Data* object =
      static_cast<const BundledFrameSubmission_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

BundledFrameSubmission_Data::BundledFrameSubmission_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundledCompositorFrame_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundledCompositorFrame_Data* object =
      static_cast<const BundledCompositorFrame_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->local_surface_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->local_surface_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->hit_test_region_list, validation_context))
    return false;

  return true;
}

BundledCompositorFrame_Data::BundledCompositorFrame_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundledReturnedResources_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundledReturnedResources_Data* object =
      static_cast<const BundledReturnedResources_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resources, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->resources, validation_context,
                                         &resources_validate_params)) {
    return false;
  }

  return true;
}

BundledReturnedResources_Data::BundledReturnedResources_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BeginFrameInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BeginFrameInfo_Data* object =
      static_cast<const BeginFrameInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->args, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->args, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->details, validation_context,
                                         &details_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resources, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->resources, validation_context,
                                         &resources_validate_params)) {
    return false;
  }

  return true;
}

BeginFrameInfo_Data::BeginFrameInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkBundle_InitializeCompositorFrameSinkType_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkBundle_InitializeCompositorFrameSinkType_Params_Data* object =
      static_cast<const FrameSinkBundle_InitializeCompositorFrameSinkType_Params_Data*>(data);


  if (!::viz::mojom::internal::CompositorFrameSinkType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

FrameSinkBundle_InitializeCompositorFrameSinkType_Params_Data::FrameSinkBundle_InitializeCompositorFrameSinkType_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkBundle_SetNeedsBeginFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkBundle_SetNeedsBeginFrame_Params_Data* object =
      static_cast<const FrameSinkBundle_SetNeedsBeginFrame_Params_Data*>(data);

  return true;
}

FrameSinkBundle_SetNeedsBeginFrame_Params_Data::FrameSinkBundle_SetNeedsBeginFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkBundle_SetWantsBeginFrameAcks_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkBundle_SetWantsBeginFrameAcks_Params_Data* object =
      static_cast<const FrameSinkBundle_SetWantsBeginFrameAcks_Params_Data*>(data);

  return true;
}

FrameSinkBundle_SetWantsBeginFrameAcks_Params_Data::FrameSinkBundle_SetWantsBeginFrameAcks_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkBundle_Submit_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkBundle_Submit_Params_Data* object =
      static_cast<const FrameSinkBundle_Submit_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->submissions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& submissions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->submissions, validation_context,
                                         &submissions_validate_params)) {
    return false;
  }

  return true;
}

FrameSinkBundle_Submit_Params_Data::FrameSinkBundle_Submit_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkBundleClient_FlushNotifications_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkBundleClient_FlushNotifications_Params_Data* object =
      static_cast<const FrameSinkBundleClient_FlushNotifications_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->acks, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& acks_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->acks, validation_context,
                                         &acks_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->begin_frames, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& begin_frames_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->begin_frames, validation_context,
                                         &begin_frames_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reclaimed_resources, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& reclaimed_resources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->reclaimed_resources, validation_context,
                                         &reclaimed_resources_validate_params)) {
    return false;
  }

  return true;
}

FrameSinkBundleClient_FlushNotifications_Params_Data::FrameSinkBundleClient_FlushNotifications_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkBundleClient_OnBeginFramePausedChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkBundleClient_OnBeginFramePausedChanged_Params_Data* object =
      static_cast<const FrameSinkBundleClient_OnBeginFramePausedChanged_Params_Data*>(data);

  return true;
}

FrameSinkBundleClient_OnBeginFramePausedChanged_Params_Data::FrameSinkBundleClient_OnBeginFramePausedChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data* object =
      static_cast<const FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data*>(data);

  return true;
}

FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data::FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz