// third_party/blink/public/mojom/webauthn/authenticator.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_SHARED_INTERNAL_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "components/payments/mojom/payment_request_data.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace blink::mojom {
namespace internal {
class CommonCredentialInfo_Data;
class SupplementalPubKeysResponse_Data;
class AuthenticationExtensionsPaymentResponse_Data;
class MakeCredentialAuthenticatorResponse_Data;
class GetAssertionAuthenticatorResponse_Data;
class AuthenticationExtensionsClientOutputs_Data;
class PublicKeyCredentialRpEntity_Data;
class PublicKeyCredentialUserEntity_Data;
class PublicKeyCredentialParameters_Data;
class CableAuthentication_Data;
class PRFValues_Data;
class PaymentOptions_Data;
class PaymentCredentialInstrument_Data;
class RemoteDesktopClientOverride_Data;
class SupplementalPubKeysRequest_Data;
class PublicKeyCredentialRequestOptions_Data;
class AuthenticationExtensionsClientInputs_Data;
class AuthenticatorSelectionCriteria_Data;
class PublicKeyCredentialCreationOptions_Data;
class PublicKeyCredentialDescriptor_Data;
class WebAuthnDOMExceptionDetails_Data;
class PublicKeyCredentialReportOptions_Data;
class AllAcceptedCredentialsOptions_Data;
class CurrentUserDetailsOptions_Data;
class WebAuthnClientCapability_Data;

struct AuthenticatorStatus_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct AuthenticatorTransport_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct Hint_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct UserVerificationRequirement_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct ResidentKeyRequirement_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct AuthenticatorAttachment_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct ProtectionPolicy_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct LargeBlobSupport_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct AttestationConveyancePreference_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct PublicKeyCredentialType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) CommonCredentialInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> id;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> raw_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> client_data_json;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> authenticator_data;

 private:
  friend class mojo::internal::MessageFragment<CommonCredentialInfo_Data>;

  CommonCredentialInfo_Data();
  ~CommonCredentialInfo_Data() = delete;
};
static_assert(sizeof(CommonCredentialInfo_Data) == 40,
              "Bad sizeof(CommonCredentialInfo_Data)");
// Used by CommonCredentialInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CommonCredentialInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CommonCredentialInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CommonCredentialInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CommonCredentialInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CommonCredentialInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) SupplementalPubKeysResponse_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>>>> signatures;

 private:
  friend class mojo::internal::MessageFragment<SupplementalPubKeysResponse_Data>;

  SupplementalPubKeysResponse_Data();
  ~SupplementalPubKeysResponse_Data() = delete;
};
static_assert(sizeof(SupplementalPubKeysResponse_Data) == 16,
              "Bad sizeof(SupplementalPubKeysResponse_Data)");
// Used by SupplementalPubKeysResponse::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SupplementalPubKeysResponse_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SupplementalPubKeysResponse_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SupplementalPubKeysResponse_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SupplementalPubKeysResponse_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SupplementalPubKeysResponse_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) AuthenticationExtensionsPaymentResponse_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> browser_bound_signature;

 private:
  friend class mojo::internal::MessageFragment<AuthenticationExtensionsPaymentResponse_Data>;

  AuthenticationExtensionsPaymentResponse_Data();
  ~AuthenticationExtensionsPaymentResponse_Data() = delete;
};
static_assert(sizeof(AuthenticationExtensionsPaymentResponse_Data) == 16,
              "Bad sizeof(AuthenticationExtensionsPaymentResponse_Data)");
// Used by AuthenticationExtensionsPaymentResponse::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AuthenticationExtensionsPaymentResponse_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AuthenticationExtensionsPaymentResponse_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AuthenticationExtensionsPaymentResponse_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AuthenticationExtensionsPaymentResponse_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AuthenticationExtensionsPaymentResponse_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MakeCredentialAuthenticatorResponse_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CommonCredentialInfo_Data> info;
  int32_t authenticator_attachment;
  uint8_t echo_hmac_create_secret : 1;
  uint8_t hmac_create_secret : 1;
  uint8_t echo_prf : 1;
  uint8_t prf : 1;
  uint8_t echo_cred_blob : 1;
  uint8_t cred_blob : 1;
  uint8_t echo_cred_props : 1;
  uint8_t has_cred_props_rk : 1;
  uint8_t cred_props_rk : 1;
  uint8_t echo_large_blob : 1;
  uint8_t supports_large_blob : 1;
  uint8_t pad12_[2];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> attestation_object;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> transports;
  mojo::internal::Pointer<internal::PRFValues_Data> prf_results;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> public_key_der;
  int32_t public_key_algo;
  uint8_t pad17_[4];
  mojo::internal::Pointer<internal::SupplementalPubKeysResponse_Data> supplemental_pub_keys;
  mojo::internal::Pointer<internal::AuthenticationExtensionsPaymentResponse_Data> payment;

 private:
  friend class mojo::internal::MessageFragment<MakeCredentialAuthenticatorResponse_Data>;

  MakeCredentialAuthenticatorResponse_Data();
  ~MakeCredentialAuthenticatorResponse_Data() = delete;
};
static_assert(sizeof(MakeCredentialAuthenticatorResponse_Data) == 80,
              "Bad sizeof(MakeCredentialAuthenticatorResponse_Data)");
// Used by MakeCredentialAuthenticatorResponse::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct MakeCredentialAuthenticatorResponse_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  MakeCredentialAuthenticatorResponse_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~MakeCredentialAuthenticatorResponse_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<MakeCredentialAuthenticatorResponse_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    MakeCredentialAuthenticatorResponse_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) GetAssertionAuthenticatorResponse_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CommonCredentialInfo_Data> info;
  int32_t authenticator_attachment;
  uint8_t pad1_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> signature;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> user_handle;
  mojo::internal::Pointer<internal::AuthenticationExtensionsClientOutputs_Data> extensions;

 private:
  friend class mojo::internal::MessageFragment<GetAssertionAuthenticatorResponse_Data>;

  GetAssertionAuthenticatorResponse_Data();
  ~GetAssertionAuthenticatorResponse_Data() = delete;
};
static_assert(sizeof(GetAssertionAuthenticatorResponse_Data) == 48,
              "Bad sizeof(GetAssertionAuthenticatorResponse_Data)");
// Used by GetAssertionAuthenticatorResponse::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct GetAssertionAuthenticatorResponse_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  GetAssertionAuthenticatorResponse_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~GetAssertionAuthenticatorResponse_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<GetAssertionAuthenticatorResponse_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    GetAssertionAuthenticatorResponse_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) AuthenticationExtensionsClientOutputs_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t echo_appid_extension : 1;
  uint8_t appid_extension : 1;
  uint8_t echo_prf : 1;
  uint8_t prf_not_evaluated : 1;
  uint8_t echo_large_blob : 1;
  uint8_t echo_large_blob_written : 1;
  uint8_t large_blob_written : 1;
  uint8_t pad6_[7];
  mojo::internal::Pointer<internal::PRFValues_Data> prf_results;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> large_blob;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> get_cred_blob;
  mojo::internal::Pointer<internal::SupplementalPubKeysResponse_Data> supplemental_pub_keys;
  mojo::internal::Pointer<internal::AuthenticationExtensionsPaymentResponse_Data> payment;

 private:
  friend class mojo::internal::MessageFragment<AuthenticationExtensionsClientOutputs_Data>;

  AuthenticationExtensionsClientOutputs_Data();
  ~AuthenticationExtensionsClientOutputs_Data() = delete;
};
static_assert(sizeof(AuthenticationExtensionsClientOutputs_Data) == 56,
              "Bad sizeof(AuthenticationExtensionsClientOutputs_Data)");
// Used by AuthenticationExtensionsClientOutputs::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AuthenticationExtensionsClientOutputs_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AuthenticationExtensionsClientOutputs_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AuthenticationExtensionsClientOutputs_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AuthenticationExtensionsClientOutputs_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AuthenticationExtensionsClientOutputs_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) PublicKeyCredentialRpEntity_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> id;
  mojo::internal::Pointer<mojo::internal::String_Data> name;

 private:
  friend class mojo::internal::MessageFragment<PublicKeyCredentialRpEntity_Data>;

  PublicKeyCredentialRpEntity_Data();
  ~PublicKeyCredentialRpEntity_Data() = delete;
};
static_assert(sizeof(PublicKeyCredentialRpEntity_Data) == 24,
              "Bad sizeof(PublicKeyCredentialRpEntity_Data)");
// Used by PublicKeyCredentialRpEntity::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PublicKeyCredentialRpEntity_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PublicKeyCredentialRpEntity_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PublicKeyCredentialRpEntity_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PublicKeyCredentialRpEntity_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PublicKeyCredentialRpEntity_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) PublicKeyCredentialUserEntity_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> id;
  mojo::internal::Pointer<mojo::internal::String_Data> name;
  mojo::internal::Pointer<mojo::internal::String_Data> display_name;

 private:
  friend class mojo::internal::MessageFragment<PublicKeyCredentialUserEntity_Data>;

  PublicKeyCredentialUserEntity_Data();
  ~PublicKeyCredentialUserEntity_Data() = delete;
};
static_assert(sizeof(PublicKeyCredentialUserEntity_Data) == 32,
              "Bad sizeof(PublicKeyCredentialUserEntity_Data)");
// Used by PublicKeyCredentialUserEntity::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PublicKeyCredentialUserEntity_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PublicKeyCredentialUserEntity_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PublicKeyCredentialUserEntity_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PublicKeyCredentialUserEntity_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PublicKeyCredentialUserEntity_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) PublicKeyCredentialParameters_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  int32_t algorithm_identifier;

 private:
  friend class mojo::internal::MessageFragment<PublicKeyCredentialParameters_Data>;

  PublicKeyCredentialParameters_Data();
  ~PublicKeyCredentialParameters_Data() = delete;
};
static_assert(sizeof(PublicKeyCredentialParameters_Data) == 16,
              "Bad sizeof(PublicKeyCredentialParameters_Data)");
// Used by PublicKeyCredentialParameters::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PublicKeyCredentialParameters_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PublicKeyCredentialParameters_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PublicKeyCredentialParameters_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PublicKeyCredentialParameters_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PublicKeyCredentialParameters_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) CableAuthentication_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t version;
  uint8_t pad0_[7];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> client_eid;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> authenticator_eid;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> session_pre_key;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> server_link_data;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> experiments;

 private:
  friend class mojo::internal::MessageFragment<CableAuthentication_Data>;

  CableAuthentication_Data();
  ~CableAuthentication_Data() = delete;
};
static_assert(sizeof(CableAuthentication_Data) == 56,
              "Bad sizeof(CableAuthentication_Data)");
// Used by CableAuthentication::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CableAuthentication_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CableAuthentication_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CableAuthentication_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CableAuthentication_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CableAuthentication_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) PRFValues_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> id;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> first;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> second;

 private:
  friend class mojo::internal::MessageFragment<PRFValues_Data>;

  PRFValues_Data();
  ~PRFValues_Data() = delete;
};
static_assert(sizeof(PRFValues_Data) == 32,
              "Bad sizeof(PRFValues_Data)");
// Used by PRFValues::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PRFValues_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PRFValues_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PRFValues_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PRFValues_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PRFValues_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) PaymentOptions_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::payments::mojom::internal::PaymentCurrencyAmount_Data> total;
  mojo::internal::Pointer<internal::PaymentCredentialInstrument_Data> instrument;
  mojo::internal::Pointer<mojo::internal::String_Data> payee_name;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> payee_origin;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> browser_bound_public_key;

 private:
  friend class mojo::internal::MessageFragment<PaymentOptions_Data>;

  PaymentOptions_Data();
  ~PaymentOptions_Data() = delete;
};
static_assert(sizeof(PaymentOptions_Data) == 48,
              "Bad sizeof(PaymentOptions_Data)");
// Used by PaymentOptions::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PaymentOptions_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PaymentOptions_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PaymentOptions_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PaymentOptions_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PaymentOptions_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) PaymentCredentialInstrument_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> display_name;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> icon;
  uint8_t iconMustBeShown : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<PaymentCredentialInstrument_Data>;

  PaymentCredentialInstrument_Data();
  ~PaymentCredentialInstrument_Data() = delete;
};
static_assert(sizeof(PaymentCredentialInstrument_Data) == 32,
              "Bad sizeof(PaymentCredentialInstrument_Data)");
// Used by PaymentCredentialInstrument::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PaymentCredentialInstrument_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PaymentCredentialInstrument_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PaymentCredentialInstrument_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PaymentCredentialInstrument_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PaymentCredentialInstrument_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) RemoteDesktopClientOverride_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> origin;
  uint8_t same_origin_with_ancestors : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<RemoteDesktopClientOverride_Data>;

  RemoteDesktopClientOverride_Data();
  ~RemoteDesktopClientOverride_Data() = delete;
};
static_assert(sizeof(RemoteDesktopClientOverride_Data) == 24,
              "Bad sizeof(RemoteDesktopClientOverride_Data)");
// Used by RemoteDesktopClientOverride::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct RemoteDesktopClientOverride_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  RemoteDesktopClientOverride_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~RemoteDesktopClientOverride_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<RemoteDesktopClientOverride_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    RemoteDesktopClientOverride_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) SupplementalPubKeysRequest_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t device_scope_requested : 1;
  uint8_t provider_scope_requested : 1;
  uint8_t pad1_[3];
  int32_t attestation;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> attestation_formats;

 private:
  friend class mojo::internal::MessageFragment<SupplementalPubKeysRequest_Data>;

  SupplementalPubKeysRequest_Data();
  ~SupplementalPubKeysRequest_Data() = delete;
};
static_assert(sizeof(SupplementalPubKeysRequest_Data) == 24,
              "Bad sizeof(SupplementalPubKeysRequest_Data)");
// Used by SupplementalPubKeysRequest::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SupplementalPubKeysRequest_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SupplementalPubKeysRequest_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SupplementalPubKeysRequest_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SupplementalPubKeysRequest_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SupplementalPubKeysRequest_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) PublicKeyCredentialRequestOptions_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_conditional : 1;
  uint8_t pad0_[3];
  int32_t requested_credential_type_flags;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> challenge;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> challenge_url;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> timeout;
  mojo::internal::Pointer<mojo::internal::String_Data> relying_party_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::PublicKeyCredentialDescriptor_Data>>> allow_credentials;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> hints;
  int32_t user_verification;
  uint8_t pad8_[4];
  mojo::internal::Pointer<internal::AuthenticationExtensionsClientInputs_Data> extensions;

 private:
  friend class mojo::internal::MessageFragment<PublicKeyCredentialRequestOptions_Data>;

  PublicKeyCredentialRequestOptions_Data();
  ~PublicKeyCredentialRequestOptions_Data() = delete;
};
static_assert(sizeof(PublicKeyCredentialRequestOptions_Data) == 80,
              "Bad sizeof(PublicKeyCredentialRequestOptions_Data)");
// Used by PublicKeyCredentialRequestOptions::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PublicKeyCredentialRequestOptions_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PublicKeyCredentialRequestOptions_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PublicKeyCredentialRequestOptions_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PublicKeyCredentialRequestOptions_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PublicKeyCredentialRequestOptions_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) AuthenticationExtensionsClientInputs_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> appid;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::CableAuthentication_Data>>> cable_authentication_data;
  uint8_t prf : 1;
  uint8_t large_blob_read : 1;
  uint8_t get_cred_blob : 1;
  uint8_t pad4_[7];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::PRFValues_Data>>> prf_inputs;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> large_blob_write;
  mojo::internal::Pointer<internal::RemoteDesktopClientOverride_Data> remote_desktop_client_override;
  mojo::internal::Pointer<internal::SupplementalPubKeysRequest_Data> supplemental_pub_keys;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::PublicKeyCredentialParameters_Data>>> payment_browser_bound_key_parameters;

 private:
  friend class mojo::internal::MessageFragment<AuthenticationExtensionsClientInputs_Data>;

  AuthenticationExtensionsClientInputs_Data();
  ~AuthenticationExtensionsClientInputs_Data() = delete;
};
static_assert(sizeof(AuthenticationExtensionsClientInputs_Data) == 72,
              "Bad sizeof(AuthenticationExtensionsClientInputs_Data)");
// Used by AuthenticationExtensionsClientInputs::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AuthenticationExtensionsClientInputs_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AuthenticationExtensionsClientInputs_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AuthenticationExtensionsClientInputs_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AuthenticationExtensionsClientInputs_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AuthenticationExtensionsClientInputs_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) AuthenticatorSelectionCriteria_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t authenticator_attachment;
  int32_t resident_key;
  int32_t user_verification;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<AuthenticatorSelectionCriteria_Data>;

  AuthenticatorSelectionCriteria_Data();
  ~AuthenticatorSelectionCriteria_Data() = delete;
};
static_assert(sizeof(AuthenticatorSelectionCriteria_Data) == 24,
              "Bad sizeof(AuthenticatorSelectionCriteria_Data)");
// Used by AuthenticatorSelectionCriteria::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AuthenticatorSelectionCriteria_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AuthenticatorSelectionCriteria_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AuthenticatorSelectionCriteria_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AuthenticatorSelectionCriteria_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AuthenticatorSelectionCriteria_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) PublicKeyCredentialCreationOptions_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::PublicKeyCredentialRpEntity_Data> relying_party;
  mojo::internal::Pointer<internal::PublicKeyCredentialUserEntity_Data> user;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> challenge;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::PublicKeyCredentialParameters_Data>>> public_key_parameters;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> timeout;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::PublicKeyCredentialDescriptor_Data>>> exclude_credentials;
  mojo::internal::Pointer<internal::AuthenticatorSelectionCriteria_Data> authenticator_selection;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> hints;
  int32_t attestation;
  uint8_t hmac_create_secret : 1;
  uint8_t prf_enable : 1;
  uint8_t enforce_protection_policy : 1;
  uint8_t cred_props : 1;
  uint8_t is_payment_credential_creation : 1;
  uint8_t min_pin_length_requested : 1;
  uint8_t is_conditional : 1;
  uint8_t pad15_[3];
  mojo::internal::Pointer<internal::PRFValues_Data> prf_input;
  int32_t protection_policy;
  int32_t large_blob_enable;
  mojo::internal::Pointer<mojo::internal::String_Data> appid_exclude;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> cred_blob;
  mojo::internal::Pointer<internal::RemoteDesktopClientOverride_Data> remote_desktop_client_override;
  mojo::internal::Pointer<internal::SupplementalPubKeysRequest_Data> supplemental_pub_keys;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::PublicKeyCredentialParameters_Data>>> payment_browser_bound_key_parameters;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> attestation_formats;

 private:
  friend class mojo::internal::MessageFragment<PublicKeyCredentialCreationOptions_Data>;

  PublicKeyCredentialCreationOptions_Data();
  ~PublicKeyCredentialCreationOptions_Data() = delete;
};
static_assert(sizeof(PublicKeyCredentialCreationOptions_Data) == 144,
              "Bad sizeof(PublicKeyCredentialCreationOptions_Data)");
// Used by PublicKeyCredentialCreationOptions::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PublicKeyCredentialCreationOptions_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PublicKeyCredentialCreationOptions_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PublicKeyCredentialCreationOptions_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PublicKeyCredentialCreationOptions_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PublicKeyCredentialCreationOptions_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) PublicKeyCredentialDescriptor_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> id;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> transports;

 private:
  friend class mojo::internal::MessageFragment<PublicKeyCredentialDescriptor_Data>;

  PublicKeyCredentialDescriptor_Data();
  ~PublicKeyCredentialDescriptor_Data() = delete;
};
static_assert(sizeof(PublicKeyCredentialDescriptor_Data) == 32,
              "Bad sizeof(PublicKeyCredentialDescriptor_Data)");
// Used by PublicKeyCredentialDescriptor::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PublicKeyCredentialDescriptor_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PublicKeyCredentialDescriptor_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PublicKeyCredentialDescriptor_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PublicKeyCredentialDescriptor_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PublicKeyCredentialDescriptor_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) WebAuthnDOMExceptionDetails_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> name;
  mojo::internal::Pointer<mojo::internal::String_Data> message;

 private:
  friend class mojo::internal::MessageFragment<WebAuthnDOMExceptionDetails_Data>;

  WebAuthnDOMExceptionDetails_Data();
  ~WebAuthnDOMExceptionDetails_Data() = delete;
};
static_assert(sizeof(WebAuthnDOMExceptionDetails_Data) == 24,
              "Bad sizeof(WebAuthnDOMExceptionDetails_Data)");
// Used by WebAuthnDOMExceptionDetails::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct WebAuthnDOMExceptionDetails_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  WebAuthnDOMExceptionDetails_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~WebAuthnDOMExceptionDetails_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<WebAuthnDOMExceptionDetails_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    WebAuthnDOMExceptionDetails_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) PublicKeyCredentialReportOptions_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> relying_party_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> unknown_credential_id;
  mojo::internal::Pointer<internal::AllAcceptedCredentialsOptions_Data> all_accepted_credentials;
  mojo::internal::Pointer<internal::CurrentUserDetailsOptions_Data> current_user_details;

 private:
  friend class mojo::internal::MessageFragment<PublicKeyCredentialReportOptions_Data>;

  PublicKeyCredentialReportOptions_Data();
  ~PublicKeyCredentialReportOptions_Data() = delete;
};
static_assert(sizeof(PublicKeyCredentialReportOptions_Data) == 40,
              "Bad sizeof(PublicKeyCredentialReportOptions_Data)");
// Used by PublicKeyCredentialReportOptions::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PublicKeyCredentialReportOptions_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PublicKeyCredentialReportOptions_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PublicKeyCredentialReportOptions_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PublicKeyCredentialReportOptions_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PublicKeyCredentialReportOptions_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) AllAcceptedCredentialsOptions_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> user_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>>>> all_accepted_credentials_ids;

 private:
  friend class mojo::internal::MessageFragment<AllAcceptedCredentialsOptions_Data>;

  AllAcceptedCredentialsOptions_Data();
  ~AllAcceptedCredentialsOptions_Data() = delete;
};
static_assert(sizeof(AllAcceptedCredentialsOptions_Data) == 24,
              "Bad sizeof(AllAcceptedCredentialsOptions_Data)");
// Used by AllAcceptedCredentialsOptions::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AllAcceptedCredentialsOptions_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AllAcceptedCredentialsOptions_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AllAcceptedCredentialsOptions_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AllAcceptedCredentialsOptions_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AllAcceptedCredentialsOptions_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) CurrentUserDetailsOptions_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> user_id;
  mojo::internal::Pointer<mojo::internal::String_Data> name;
  mojo::internal::Pointer<mojo::internal::String_Data> display_name;

 private:
  friend class mojo::internal::MessageFragment<CurrentUserDetailsOptions_Data>;

  CurrentUserDetailsOptions_Data();
  ~CurrentUserDetailsOptions_Data() = delete;
};
static_assert(sizeof(CurrentUserDetailsOptions_Data) == 32,
              "Bad sizeof(CurrentUserDetailsOptions_Data)");
// Used by CurrentUserDetailsOptions::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CurrentUserDetailsOptions_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CurrentUserDetailsOptions_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CurrentUserDetailsOptions_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CurrentUserDetailsOptions_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CurrentUserDetailsOptions_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) WebAuthnClientCapability_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> name;
  uint8_t supported : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<WebAuthnClientCapability_Data>;

  WebAuthnClientCapability_Data();
  ~WebAuthnClientCapability_Data() = delete;
};
static_assert(sizeof(WebAuthnClientCapability_Data) == 24,
              "Bad sizeof(WebAuthnClientCapability_Data)");
// Used by WebAuthnClientCapability::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct WebAuthnClientCapability_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  WebAuthnClientCapability_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~WebAuthnClientCapability_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<WebAuthnClientCapability_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    WebAuthnClientCapability_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_SHARED_INTERNAL_H_