
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_ntlmssp.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/security.h"
static PyTypeObject ntlmssp_VERSION_Type;
static PyTypeObject ntlmssp_Version_Type;
static PyTypeObject NEGOTIATE_MESSAGE_Type;
static PyTypeObject ntlmssp_SingleHostData_Type;
static PyTypeObject ntlmssp_AvValue_Type;
static PyTypeObject AV_PAIR_Type;
static PyTypeObject AV_PAIR_LIST_Type;
static PyTypeObject CHALLENGE_MESSAGE_Type;
static PyTypeObject LM_RESPONSE_Type;
static PyTypeObject LMv2_RESPONSE_Type;
static PyTypeObject ntlmssp_LM_RESPONSE_with_len_Type;
static PyTypeObject NTLM_RESPONSE_Type;
static PyTypeObject NTLMv2_CLIENT_CHALLENGE_Type;
static PyTypeObject NTLMv2_RESPONSE_Type;
static PyTypeObject ntlmssp_NTLM_RESPONSE_with_len_Type;
static PyTypeObject ntlmssp_MIC_Type;
static PyTypeObject AUTHENTICATE_MESSAGE_Type;
static PyTypeObject NTLMSSP_MESSAGE_SIGNATURE_Type;
static PyTypeObject NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_Type;
static PyTypeObject ntlmssp_InterfaceType;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *LSAP_TOKEN_INFO_INTEGRITY_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_ntlmssp_VERSION_get_ProductMajorVersion(PyObject *obj, void *closure)
{
	struct ntlmssp_VERSION *object = pytalloc_get_ptr(obj);
	PyObject *py_ProductMajorVersion;
	py_ProductMajorVersion = PyLong_FromLong((uint16_t)(object->ProductMajorVersion));
	return py_ProductMajorVersion;
}

static int py_ntlmssp_VERSION_set_ProductMajorVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ntlmssp_VERSION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ProductMajorVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ProductMajorVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ProductMajorVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ntlmssp_VERSION_get_ProductMinorVersion(PyObject *obj, void *closure)
{
	struct ntlmssp_VERSION *object = pytalloc_get_ptr(obj);
	PyObject *py_ProductMinorVersion;
	py_ProductMinorVersion = PyLong_FromLong((uint16_t)(object->ProductMinorVersion));
	return py_ProductMinorVersion;
}

static int py_ntlmssp_VERSION_set_ProductMinorVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ntlmssp_VERSION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ProductMinorVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ProductMinorVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ProductMinorVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ntlmssp_VERSION_get_ProductBuild(PyObject *obj, void *closure)
{
	struct ntlmssp_VERSION *object = pytalloc_get_ptr(obj);
	PyObject *py_ProductBuild;
	py_ProductBuild = PyLong_FromLong((uint16_t)(object->ProductBuild));
	return py_ProductBuild;
}

static int py_ntlmssp_VERSION_set_ProductBuild(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ntlmssp_VERSION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ProductBuild");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ProductBuild));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ProductBuild = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ntlmssp_VERSION_get_Reserved(PyObject *obj, void *closure)
{
	struct ntlmssp_VERSION *object = pytalloc_get_ptr(obj);
	PyObject *py_Reserved;
	py_Reserved = PyList_New(3);
	if (py_Reserved == NULL) {
		return NULL;
	}
	{
		int Reserved_cntr_0;
		for (Reserved_cntr_0 = 0; Reserved_cntr_0 < (3); Reserved_cntr_0++) {
			PyObject *py_Reserved_0;
			py_Reserved_0 = PyLong_FromLong((uint16_t)((object->Reserved)[Reserved_cntr_0]));
			PyList_SetItem(py_Reserved, Reserved_cntr_0, py_Reserved_0);
		}
	}
	return py_Reserved;
}

static int py_ntlmssp_VERSION_set_Reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ntlmssp_VERSION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Reserved");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Reserved_cntr_0;
		if (ARRAY_SIZE(object->Reserved) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->Reserved),  PyList_GET_SIZE(value));
			return -1;
		}
		for (Reserved_cntr_0 = 0; Reserved_cntr_0 < PyList_GET_SIZE(value); Reserved_cntr_0++) {
			if (PyList_GET_ITEM(value, Reserved_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->Reserved)[Reserved_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->Reserved)[Reserved_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, Reserved_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, Reserved_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->Reserved)[Reserved_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_ntlmssp_VERSION_get_NTLMRevisionCurrent(PyObject *obj, void *closure)
{
	struct ntlmssp_VERSION *object = pytalloc_get_ptr(obj);
	PyObject *py_NTLMRevisionCurrent;
	py_NTLMRevisionCurrent = PyLong_FromLong((uint16_t)(object->NTLMRevisionCurrent));
	return py_NTLMRevisionCurrent;
}

static int py_ntlmssp_VERSION_set_NTLMRevisionCurrent(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ntlmssp_VERSION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->NTLMRevisionCurrent");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->NTLMRevisionCurrent));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->NTLMRevisionCurrent = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_ntlmssp_VERSION_getsetters[] = {
	{
		.name = discard_const_p(char, "ProductMajorVersion"),
		.get = py_ntlmssp_VERSION_get_ProductMajorVersion,
		.set = py_ntlmssp_VERSION_set_ProductMajorVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type ntlmssp_WindowsMajorVersion")
	},
	{
		.name = discard_const_p(char, "ProductMinorVersion"),
		.get = py_ntlmssp_VERSION_get_ProductMinorVersion,
		.set = py_ntlmssp_VERSION_set_ProductMinorVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type ntlmssp_WindowsMinorVersion")
	},
	{
		.name = discard_const_p(char, "ProductBuild"),
		.get = py_ntlmssp_VERSION_get_ProductBuild,
		.set = py_ntlmssp_VERSION_set_ProductBuild,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "Reserved"),
		.get = py_ntlmssp_VERSION_get_Reserved,
		.set = py_ntlmssp_VERSION_set_Reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "NTLMRevisionCurrent"),
		.get = py_ntlmssp_VERSION_get_NTLMRevisionCurrent,
		.set = py_ntlmssp_VERSION_set_NTLMRevisionCurrent,
		.doc = discard_const_p(char, "PIDL-generated element of base type ntlmssp_NTLMRevisionCurrent")
	},
	{ .name = NULL }
};

static PyObject *py_ntlmssp_VERSION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ntlmssp_VERSION, type);
}

static PyObject *py_ntlmssp_VERSION_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct ntlmssp_VERSION *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_ntlmssp_VERSION);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_ntlmssp_VERSION_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ntlmssp_VERSION *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ntlmssp_VERSION);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ntlmssp_VERSION);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ntlmssp_VERSION_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ntlmssp_VERSION *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ntlmssp_VERSION, "ntlmssp_VERSION", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ntlmssp_VERSION, "ntlmssp_VERSION", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ntlmssp_VERSION_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ntlmssp_VERSION_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ntlmssp_VERSION_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ntlmssp_VERSION_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ntlmssp_VERSION_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.VERSION",
	.tp_getset = py_ntlmssp_VERSION_getsetters,
	.tp_methods = py_ntlmssp_VERSION_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ntlmssp_VERSION_new,
};

static PyObject *py_import_ntlmssp_Version(TALLOC_CTX *mem_ctx, int level, union ntlmssp_Version *in)
{
	PyObject *ret;

	switch (level) {
		case NTLMSSP_NEGOTIATE_VERSION:
			ret = pytalloc_reference_ex(&ntlmssp_VERSION_Type, mem_ctx, &in->version);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union ntlmssp_Version *py_export_ntlmssp_Version(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union ntlmssp_Version *ret = talloc_zero(mem_ctx, union ntlmssp_Version);
	switch (level) {
		case NTLMSSP_NEGOTIATE_VERSION:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->version");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ntlmssp_VERSION_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->version = *(struct ntlmssp_VERSION *)pytalloc_get_ptr(in);
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_ntlmssp_Version_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union ntlmssp_Version *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union ntlmssp_Version *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union ntlmssp_Version!");
		return NULL;
	}

	return py_import_ntlmssp_Version(mem_ctx, level, in);
}

static PyObject *py_ntlmssp_Version_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union ntlmssp_Version *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_ntlmssp_Version(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_ntlmssp_Version_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ntlmssp_Version_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ntlmssp_Version_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_ntlmssp_Version_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject ntlmssp_Version_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.Version",
	.tp_getset = NULL,
	.tp_methods = py_ntlmssp_Version_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ntlmssp_Version_new,
};


static PyObject *py_NEGOTIATE_MESSAGE_get_Signature(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_Signature;
	if (object->Signature == NULL) {
		py_Signature = Py_None;
		Py_INCREF(py_Signature);
	} else {
		py_Signature = PyUnicode_Decode(object->Signature, strlen(object->Signature), "utf-8", "ignore");
	}
	return py_Signature;
}

static int py_NEGOTIATE_MESSAGE_set_Signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Signature");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->Signature = talloc_str;
	}
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_MessageType(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_MessageType;
	py_MessageType = PyLong_FromUnsignedLongLong((uint32_t)(object->MessageType));
	return py_MessageType;
}

static int py_NEGOTIATE_MESSAGE_set_MessageType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->MessageType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->MessageType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->MessageType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_NegotiateFlags(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_NegotiateFlags;
	py_NegotiateFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->NegotiateFlags));
	return py_NegotiateFlags;
}

static int py_NEGOTIATE_MESSAGE_set_NegotiateFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->NegotiateFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->NegotiateFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->NegotiateFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_DomainNameLen(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_DomainNameLen;
	py_DomainNameLen = PyLong_FromLong((uint16_t)(object->DomainNameLen));
	return py_DomainNameLen;
}

static int py_NEGOTIATE_MESSAGE_set_DomainNameLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->DomainNameLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->DomainNameLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->DomainNameLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_DomainNameMaxLen(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_DomainNameMaxLen;
	py_DomainNameMaxLen = PyLong_FromLong((uint16_t)(object->DomainNameMaxLen));
	return py_DomainNameMaxLen;
}

static int py_NEGOTIATE_MESSAGE_set_DomainNameMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->DomainNameMaxLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->DomainNameMaxLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->DomainNameMaxLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_DomainName(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_DomainName;
	if (object->DomainName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->DomainName == NULL) {
		py_DomainName = Py_None;
		Py_INCREF(py_DomainName);
	} else {
		py_DomainName = PyString_FromStringOrNULL(object->DomainName);
	}
	return py_DomainName;
}

static int py_NEGOTIATE_MESSAGE_set_DomainName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->DomainName));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->DomainName");
		return -1;
	}
	if (value == Py_None) {
		object->DomainName = NULL;
	} else {
		object->DomainName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->DomainName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_WorkstationLen(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_WorkstationLen;
	py_WorkstationLen = PyLong_FromLong((uint16_t)(object->WorkstationLen));
	return py_WorkstationLen;
}

static int py_NEGOTIATE_MESSAGE_set_WorkstationLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->WorkstationLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->WorkstationLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->WorkstationLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_WorkstationMaxLen(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_WorkstationMaxLen;
	py_WorkstationMaxLen = PyLong_FromLong((uint16_t)(object->WorkstationMaxLen));
	return py_WorkstationMaxLen;
}

static int py_NEGOTIATE_MESSAGE_set_WorkstationMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->WorkstationMaxLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->WorkstationMaxLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->WorkstationMaxLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_Workstation(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_Workstation;
	if (object->Workstation == NULL) {
		Py_RETURN_NONE;
	}
	if (object->Workstation == NULL) {
		py_Workstation = Py_None;
		Py_INCREF(py_Workstation);
	} else {
		py_Workstation = PyString_FromStringOrNULL(object->Workstation);
	}
	return py_Workstation;
}

static int py_NEGOTIATE_MESSAGE_set_Workstation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->Workstation));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Workstation");
		return -1;
	}
	if (value == Py_None) {
		object->Workstation = NULL;
	} else {
		object->Workstation = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->Workstation = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_Version(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = pyrpc_import_union(&ntlmssp_Version_Type, pytalloc_get_mem_ctx(obj), object->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION, &object->Version, "union ntlmssp_Version");
	if (py_Version == NULL) {
		return NULL;
	}
	return py_Version;
}

static int py_NEGOTIATE_MESSAGE_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Version");
		return -1;
	}
	{
		union ntlmssp_Version *Version_switch_0;
		Version_switch_0 = (union ntlmssp_Version *)pyrpc_export_union(&ntlmssp_Version_Type, pytalloc_get_mem_ctx(py_obj), object->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION, value, "union ntlmssp_Version");
		if (Version_switch_0 == NULL) {
			return -1;
		}
		object->Version = *Version_switch_0;
	}
	return 0;
}

static PyGetSetDef py_NEGOTIATE_MESSAGE_getsetters[] = {
	{
		.name = discard_const_p(char, "Signature"),
		.get = py_NEGOTIATE_MESSAGE_get_Signature,
		.set = py_NEGOTIATE_MESSAGE_set_Signature,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "MessageType"),
		.get = py_NEGOTIATE_MESSAGE_get_MessageType,
		.set = py_NEGOTIATE_MESSAGE_set_MessageType,
		.doc = discard_const_p(char, "PIDL-generated element of base type ntlmssp_MessageType")
	},
	{
		.name = discard_const_p(char, "NegotiateFlags"),
		.get = py_NEGOTIATE_MESSAGE_get_NegotiateFlags,
		.set = py_NEGOTIATE_MESSAGE_set_NegotiateFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type NEGOTIATE")
	},
	{
		.name = discard_const_p(char, "DomainNameLen"),
		.get = py_NEGOTIATE_MESSAGE_get_DomainNameLen,
		.set = py_NEGOTIATE_MESSAGE_set_DomainNameLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "DomainNameMaxLen"),
		.get = py_NEGOTIATE_MESSAGE_get_DomainNameMaxLen,
		.set = py_NEGOTIATE_MESSAGE_set_DomainNameMaxLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "DomainName"),
		.get = py_NEGOTIATE_MESSAGE_get_DomainName,
		.set = py_NEGOTIATE_MESSAGE_set_DomainName,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "WorkstationLen"),
		.get = py_NEGOTIATE_MESSAGE_get_WorkstationLen,
		.set = py_NEGOTIATE_MESSAGE_set_WorkstationLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "WorkstationMaxLen"),
		.get = py_NEGOTIATE_MESSAGE_get_WorkstationMaxLen,
		.set = py_NEGOTIATE_MESSAGE_set_WorkstationMaxLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "Workstation"),
		.get = py_NEGOTIATE_MESSAGE_get_Workstation,
		.set = py_NEGOTIATE_MESSAGE_set_Workstation,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "Version"),
		.get = py_NEGOTIATE_MESSAGE_get_Version,
		.set = py_NEGOTIATE_MESSAGE_set_Version,
		.doc = discard_const_p(char, "PIDL-generated element of base type ntlmssp_Version")
	},
	{ .name = NULL }
};

static PyObject *py_NEGOTIATE_MESSAGE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NEGOTIATE_MESSAGE, type);
}

static PyObject *py_NEGOTIATE_MESSAGE_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_NEGOTIATE_MESSAGE);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_NEGOTIATE_MESSAGE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NEGOTIATE_MESSAGE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NEGOTIATE_MESSAGE);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NEGOTIATE_MESSAGE_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NEGOTIATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NEGOTIATE_MESSAGE, "NEGOTIATE_MESSAGE", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NEGOTIATE_MESSAGE, "NEGOTIATE_MESSAGE", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NEGOTIATE_MESSAGE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NEGOTIATE_MESSAGE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NEGOTIATE_MESSAGE_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NEGOTIATE_MESSAGE_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NEGOTIATE_MESSAGE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.NEGOTIATE_MESSAGE",
	.tp_getset = py_NEGOTIATE_MESSAGE_getsetters,
	.tp_methods = py_NEGOTIATE_MESSAGE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NEGOTIATE_MESSAGE_new,
};


static PyObject *py_ntlmssp_SingleHostData_get_Size(PyObject *obj, void *closure)
{
	struct ntlmssp_SingleHostData *object = pytalloc_get_ptr(obj);
	PyObject *py_Size;
	py_Size = PyLong_FromUnsignedLongLong((uint32_t)(object->Size));
	return py_Size;
}

static int py_ntlmssp_SingleHostData_set_Size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ntlmssp_SingleHostData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ntlmssp_SingleHostData_get_Z4(PyObject *obj, void *closure)
{
	struct ntlmssp_SingleHostData *object = pytalloc_get_ptr(obj);
	PyObject *py_Z4;
	py_Z4 = PyLong_FromUnsignedLongLong((uint32_t)(object->Z4));
	return py_Z4;
}

static int py_ntlmssp_SingleHostData_set_Z4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ntlmssp_SingleHostData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Z4");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Z4));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Z4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ntlmssp_SingleHostData_get_token_info(PyObject *obj, void *closure)
{
	struct ntlmssp_SingleHostData *object = pytalloc_get_ptr(obj);
	PyObject *py_token_info;
	py_token_info = pytalloc_reference_ex(LSAP_TOKEN_INFO_INTEGRITY_Type, pytalloc_get_mem_ctx(obj), &object->token_info);
	return py_token_info;
}

static int py_ntlmssp_SingleHostData_set_token_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ntlmssp_SingleHostData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->token_info");
		return -1;
	}
	PY_CHECK_TYPE(LSAP_TOKEN_INFO_INTEGRITY_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->token_info = *(struct LSAP_TOKEN_INFO_INTEGRITY *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_ntlmssp_SingleHostData_get_remaining(PyObject *obj, void *closure)
{
	struct ntlmssp_SingleHostData *object = pytalloc_get_ptr(obj);
	PyObject *py_remaining;
	py_remaining = PyBytes_FromStringAndSize((char *)(object->remaining).data, (object->remaining).length);
	return py_remaining;
}

static int py_ntlmssp_SingleHostData_set_remaining(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ntlmssp_SingleHostData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->remaining");
		return -1;
	}
	object->remaining = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_ntlmssp_SingleHostData_getsetters[] = {
	{
		.name = discard_const_p(char, "Size"),
		.get = py_ntlmssp_SingleHostData_get_Size,
		.set = py_ntlmssp_SingleHostData_set_Size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "Z4"),
		.get = py_ntlmssp_SingleHostData_get_Z4,
		.set = py_ntlmssp_SingleHostData_set_Z4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "token_info"),
		.get = py_ntlmssp_SingleHostData_get_token_info,
		.set = py_ntlmssp_SingleHostData_set_token_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type LSAP_TOKEN_INFO_INTEGRITY")
	},
	{
		.name = discard_const_p(char, "remaining"),
		.get = py_ntlmssp_SingleHostData_get_remaining,
		.set = py_ntlmssp_SingleHostData_set_remaining,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_ntlmssp_SingleHostData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ntlmssp_SingleHostData, type);
}


static PyTypeObject ntlmssp_SingleHostData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.SingleHostData",
	.tp_getset = py_ntlmssp_SingleHostData_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ntlmssp_SingleHostData_new,
};

static PyObject *py_import_ntlmssp_AvValue(TALLOC_CTX *mem_ctx, int level, union ntlmssp_AvValue *in)
{
	PyObject *ret;

	switch (level) {
		case MsvAvEOL:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case MsvAvNbComputerName:
			ret = PyString_FromStringOrNULL(in->AvNbComputerName);
			return ret;

		case MsvAvNbDomainName:
			ret = PyString_FromStringOrNULL(in->AvNbDomainName);
			return ret;

		case MsvAvDnsComputerName:
			ret = PyString_FromStringOrNULL(in->AvDnsComputerName);
			return ret;

		case MsvAvDnsDomainName:
			ret = PyString_FromStringOrNULL(in->AvDnsDomainName);
			return ret;

		case MsvAvDnsTreeName:
			ret = PyString_FromStringOrNULL(in->AvDnsTreeName);
			return ret;

		case MsvAvFlags:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->AvFlags));
			return ret;

		case MsvAvTimestamp:
			ret = PyLong_FromUnsignedLongLong(in->AvTimestamp);
			return ret;

		case MsvAvSingleHost:
			ret = pytalloc_reference_ex(&ntlmssp_SingleHostData_Type, mem_ctx, &in->AvSingleHost);
			return ret;

		case MsvAvTargetName:
			ret = PyString_FromStringOrNULL(in->AvTargetName);
			return ret;

		case MsvChannelBindings:
			ret = PyList_New(16);
			if (ret == NULL) {
				return NULL;
			}
			{
				int ChannelBindings_cntr_0;
				for (ChannelBindings_cntr_0 = 0; ChannelBindings_cntr_0 < (16); ChannelBindings_cntr_0++) {
					PyObject *py_ChannelBindings_0;
					py_ChannelBindings_0 = PyLong_FromLong((uint16_t)((in->ChannelBindings)[ChannelBindings_cntr_0]));
					PyList_SetItem(ret, ChannelBindings_cntr_0, py_ChannelBindings_0);
				}
			}
			return ret;

		default:
			ret = PyBytes_FromStringAndSize((char *)(in->blob).data, (in->blob).length);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union ntlmssp_AvValue *py_export_ntlmssp_AvValue(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union ntlmssp_AvValue *ret = talloc_zero(mem_ctx, union ntlmssp_AvValue);
	switch (level) {
		case MsvAvEOL:
			break;

		case MsvAvNbComputerName:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->AvNbComputerName");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->AvNbComputerName = talloc_str;
			}
			break;

		case MsvAvNbDomainName:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->AvNbDomainName");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->AvNbDomainName = talloc_str;
			}
			break;

		case MsvAvDnsComputerName:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->AvDnsComputerName");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->AvDnsComputerName = talloc_str;
			}
			break;

		case MsvAvDnsDomainName:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->AvDnsDomainName");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->AvDnsDomainName = talloc_str;
			}
			break;

		case MsvAvDnsTreeName:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->AvDnsTreeName");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->AvDnsTreeName = talloc_str;
			}
			break;

		case MsvAvFlags:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->AvFlags");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->AvFlags));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->AvFlags = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case MsvAvTimestamp:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->AvTimestamp");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->AvTimestamp));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->AvTimestamp = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case MsvAvSingleHost:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->AvSingleHost");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&ntlmssp_SingleHostData_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->AvSingleHost = *(struct ntlmssp_SingleHostData *)pytalloc_get_ptr(in);
			break;

		case MsvAvTargetName:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->AvTargetName");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->AvTargetName = talloc_str;
			}
			break;

		case MsvChannelBindings:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ChannelBindings");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PyList_Type, in, talloc_free(ret); return NULL;);
			{
				int ChannelBindings_cntr_0;
				if (ARRAY_SIZE(ret->ChannelBindings) != PyList_GET_SIZE(in)) {
					PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(in)->tp_name, ARRAY_SIZE(ret->ChannelBindings),  PyList_GET_SIZE(in));
					talloc_free(ret); return NULL;
				}
				for (ChannelBindings_cntr_0 = 0; ChannelBindings_cntr_0 < PyList_GET_SIZE(in); ChannelBindings_cntr_0++) {
					if (PyList_GET_ITEM(in, ChannelBindings_cntr_0) == NULL) {
						PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (ret->ChannelBindings)[ChannelBindings_cntr_0]");
						talloc_free(ret); return NULL;
					}
					{
						const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((ret->ChannelBindings)[ChannelBindings_cntr_0]));
						if (PyLong_Check(PyList_GET_ITEM(in, ChannelBindings_cntr_0))) {
							unsigned long long test_var;
							test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(in, ChannelBindings_cntr_0));
							if (PyErr_Occurred() != NULL) {
								talloc_free(ret); return NULL;
							}
							if (test_var > uint_max) {
								PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
								  PyLong_Type.tp_name, uint_max, test_var);
								talloc_free(ret); return NULL;
							}
							(ret->ChannelBindings)[ChannelBindings_cntr_0] = test_var;
						} else {
							PyErr_Format(PyExc_TypeError, "Expected type %s",
							  PyLong_Type.tp_name);
							talloc_free(ret); return NULL;
						}
					}
				}
			}
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->blob");
				talloc_free(ret); return NULL;
			}
			ret->blob = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

	}

	return ret;
}

static PyObject *py_ntlmssp_AvValue_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union ntlmssp_AvValue *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union ntlmssp_AvValue *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union ntlmssp_AvValue!");
		return NULL;
	}

	return py_import_ntlmssp_AvValue(mem_ctx, level, in);
}

static PyObject *py_ntlmssp_AvValue_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union ntlmssp_AvValue *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_ntlmssp_AvValue(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_ntlmssp_AvValue_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ntlmssp_AvValue_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ntlmssp_AvValue_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_ntlmssp_AvValue_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject ntlmssp_AvValue_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.AvValue",
	.tp_getset = NULL,
	.tp_methods = py_ntlmssp_AvValue_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ntlmssp_AvValue_new,
};


static PyObject *py_AV_PAIR_get_AvId(PyObject *obj, void *closure)
{
	struct AV_PAIR *object = pytalloc_get_ptr(obj);
	PyObject *py_AvId;
	py_AvId = PyLong_FromLong((uint16_t)(object->AvId));
	return py_AvId;
}

static int py_AV_PAIR_set_AvId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AV_PAIR *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->AvId");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->AvId));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->AvId = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AV_PAIR_get_AvLen(PyObject *obj, void *closure)
{
	struct AV_PAIR *object = pytalloc_get_ptr(obj);
	PyObject *py_AvLen;
	py_AvLen = PyLong_FromLong((uint16_t)(object->AvLen));
	return py_AvLen;
}

static int py_AV_PAIR_set_AvLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AV_PAIR *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->AvLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->AvLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->AvLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AV_PAIR_get_Value(PyObject *obj, void *closure)
{
	struct AV_PAIR *object = pytalloc_get_ptr(obj);
	PyObject *py_Value;
	py_Value = pyrpc_import_union(&ntlmssp_AvValue_Type, pytalloc_get_mem_ctx(obj), object->AvId, &object->Value, "union ntlmssp_AvValue");
	if (py_Value == NULL) {
		return NULL;
	}
	return py_Value;
}

static int py_AV_PAIR_set_Value(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AV_PAIR *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Value");
		return -1;
	}
	{
		union ntlmssp_AvValue *Value_switch_1;
		Value_switch_1 = (union ntlmssp_AvValue *)pyrpc_export_union(&ntlmssp_AvValue_Type, pytalloc_get_mem_ctx(py_obj), object->AvId, value, "union ntlmssp_AvValue");
		if (Value_switch_1 == NULL) {
			return -1;
		}
		object->Value = *Value_switch_1;
	}
	return 0;
}

static PyGetSetDef py_AV_PAIR_getsetters[] = {
	{
		.name = discard_const_p(char, "AvId"),
		.get = py_AV_PAIR_get_AvId,
		.set = py_AV_PAIR_set_AvId,
		.doc = discard_const_p(char, "PIDL-generated element of base type ntlmssp_AvId")
	},
	{
		.name = discard_const_p(char, "AvLen"),
		.get = py_AV_PAIR_get_AvLen,
		.set = py_AV_PAIR_set_AvLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "Value"),
		.get = py_AV_PAIR_get_Value,
		.set = py_AV_PAIR_set_Value,
		.doc = discard_const_p(char, "PIDL-generated element of base type ntlmssp_AvValue")
	},
	{ .name = NULL }
};

static PyObject *py_AV_PAIR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct AV_PAIR, type);
}

static PyObject *py_AV_PAIR_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct AV_PAIR *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_AV_PAIR);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_AV_PAIR_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct AV_PAIR *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_AV_PAIR);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_AV_PAIR);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_AV_PAIR_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct AV_PAIR *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_AV_PAIR, "AV_PAIR", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_AV_PAIR, "AV_PAIR", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_AV_PAIR_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_AV_PAIR_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_AV_PAIR_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_AV_PAIR_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject AV_PAIR_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.AV_PAIR",
	.tp_getset = py_AV_PAIR_getsetters,
	.tp_methods = py_AV_PAIR_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_AV_PAIR_new,
};


static PyObject *py_AV_PAIR_LIST_get_count(PyObject *obj, void *closure)
{
	struct AV_PAIR_LIST *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_AV_PAIR_LIST_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AV_PAIR_LIST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AV_PAIR_LIST_get_pair(PyObject *obj, void *closure)
{
	struct AV_PAIR_LIST *object = pytalloc_get_ptr(obj);
	PyObject *py_pair;
	py_pair = PyList_New(object->count);
	if (py_pair == NULL) {
		return NULL;
	}
	{
		int pair_cntr_0;
		for (pair_cntr_0 = 0; pair_cntr_0 < (object->count); pair_cntr_0++) {
			PyObject *py_pair_0;
			py_pair_0 = pytalloc_reference_ex(&AV_PAIR_Type, object->pair, &(object->pair)[pair_cntr_0]);
			PyList_SetItem(py_pair, pair_cntr_0, py_pair_0);
		}
	}
	return py_pair;
}

static int py_AV_PAIR_LIST_set_pair(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AV_PAIR_LIST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pair");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pair_cntr_0;
		object->pair = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pair, PyList_GET_SIZE(value));
		if (!object->pair) { return -1; }
		talloc_set_name_const(object->pair, "ARRAY: object->pair");
		for (pair_cntr_0 = 0; pair_cntr_0 < PyList_GET_SIZE(value); pair_cntr_0++) {
			if (PyList_GET_ITEM(value, pair_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->pair)[pair_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&AV_PAIR_Type, PyList_GET_ITEM(value, pair_cntr_0), return -1;);
			if (talloc_reference(object->pair, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, pair_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->pair)[pair_cntr_0] = *(struct AV_PAIR *)pytalloc_get_ptr(PyList_GET_ITEM(value, pair_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_AV_PAIR_LIST_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_AV_PAIR_LIST_get_count,
		.set = py_AV_PAIR_LIST_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pair"),
		.get = py_AV_PAIR_LIST_get_pair,
		.set = py_AV_PAIR_LIST_set_pair,
		.doc = discard_const_p(char, "PIDL-generated element of base type AV_PAIR")
	},
	{ .name = NULL }
};

static PyObject *py_AV_PAIR_LIST_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct AV_PAIR_LIST, type);
}

static PyObject *py_AV_PAIR_LIST_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct AV_PAIR_LIST *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_AV_PAIR_LIST);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_AV_PAIR_LIST_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct AV_PAIR_LIST *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_AV_PAIR_LIST);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_AV_PAIR_LIST);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_AV_PAIR_LIST_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct AV_PAIR_LIST *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_AV_PAIR_LIST, "AV_PAIR_LIST", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_AV_PAIR_LIST, "AV_PAIR_LIST", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_AV_PAIR_LIST_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_AV_PAIR_LIST_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_AV_PAIR_LIST_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_AV_PAIR_LIST_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject AV_PAIR_LIST_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.AV_PAIR_LIST",
	.tp_getset = py_AV_PAIR_LIST_getsetters,
	.tp_methods = py_AV_PAIR_LIST_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_AV_PAIR_LIST_new,
};


static PyObject *py_CHALLENGE_MESSAGE_get_Signature(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_Signature;
	if (object->Signature == NULL) {
		py_Signature = Py_None;
		Py_INCREF(py_Signature);
	} else {
		py_Signature = PyUnicode_Decode(object->Signature, strlen(object->Signature), "utf-8", "ignore");
	}
	return py_Signature;
}

static int py_CHALLENGE_MESSAGE_set_Signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Signature");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->Signature = talloc_str;
	}
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_MessageType(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_MessageType;
	py_MessageType = PyLong_FromUnsignedLongLong((uint32_t)(object->MessageType));
	return py_MessageType;
}

static int py_CHALLENGE_MESSAGE_set_MessageType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->MessageType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->MessageType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->MessageType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_TargetNameLen(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_TargetNameLen;
	py_TargetNameLen = PyLong_FromLong((uint16_t)(object->TargetNameLen));
	return py_TargetNameLen;
}

static int py_CHALLENGE_MESSAGE_set_TargetNameLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->TargetNameLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->TargetNameLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->TargetNameLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_TargetNameMaxLen(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_TargetNameMaxLen;
	py_TargetNameMaxLen = PyLong_FromLong((uint16_t)(object->TargetNameMaxLen));
	return py_TargetNameMaxLen;
}

static int py_CHALLENGE_MESSAGE_set_TargetNameMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->TargetNameMaxLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->TargetNameMaxLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->TargetNameMaxLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_TargetName(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_TargetName;
	if (object->TargetName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->TargetName == NULL) {
		py_TargetName = Py_None;
		Py_INCREF(py_TargetName);
	} else {
		py_TargetName = PyString_FromStringOrNULL(object->TargetName);
	}
	return py_TargetName;
}

static int py_CHALLENGE_MESSAGE_set_TargetName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->TargetName));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->TargetName");
		return -1;
	}
	if (value == Py_None) {
		object->TargetName = NULL;
	} else {
		object->TargetName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->TargetName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_NegotiateFlags(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_NegotiateFlags;
	py_NegotiateFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->NegotiateFlags));
	return py_NegotiateFlags;
}

static int py_CHALLENGE_MESSAGE_set_NegotiateFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->NegotiateFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->NegotiateFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->NegotiateFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_ServerChallenge(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_ServerChallenge;
	py_ServerChallenge = PyList_New(8);
	if (py_ServerChallenge == NULL) {
		return NULL;
	}
	{
		int ServerChallenge_cntr_0;
		for (ServerChallenge_cntr_0 = 0; ServerChallenge_cntr_0 < (8); ServerChallenge_cntr_0++) {
			PyObject *py_ServerChallenge_0;
			py_ServerChallenge_0 = PyLong_FromLong((uint16_t)((object->ServerChallenge)[ServerChallenge_cntr_0]));
			PyList_SetItem(py_ServerChallenge, ServerChallenge_cntr_0, py_ServerChallenge_0);
		}
	}
	return py_ServerChallenge;
}

static int py_CHALLENGE_MESSAGE_set_ServerChallenge(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ServerChallenge");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ServerChallenge_cntr_0;
		if (ARRAY_SIZE(object->ServerChallenge) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->ServerChallenge),  PyList_GET_SIZE(value));
			return -1;
		}
		for (ServerChallenge_cntr_0 = 0; ServerChallenge_cntr_0 < PyList_GET_SIZE(value); ServerChallenge_cntr_0++) {
			if (PyList_GET_ITEM(value, ServerChallenge_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->ServerChallenge)[ServerChallenge_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->ServerChallenge)[ServerChallenge_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, ServerChallenge_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, ServerChallenge_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->ServerChallenge)[ServerChallenge_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_Reserved(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_Reserved;
	py_Reserved = PyList_New(8);
	if (py_Reserved == NULL) {
		return NULL;
	}
	{
		int Reserved_cntr_0;
		for (Reserved_cntr_0 = 0; Reserved_cntr_0 < (8); Reserved_cntr_0++) {
			PyObject *py_Reserved_0;
			py_Reserved_0 = PyLong_FromLong((uint16_t)((object->Reserved)[Reserved_cntr_0]));
			PyList_SetItem(py_Reserved, Reserved_cntr_0, py_Reserved_0);
		}
	}
	return py_Reserved;
}

static int py_CHALLENGE_MESSAGE_set_Reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Reserved");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Reserved_cntr_0;
		if (ARRAY_SIZE(object->Reserved) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->Reserved),  PyList_GET_SIZE(value));
			return -1;
		}
		for (Reserved_cntr_0 = 0; Reserved_cntr_0 < PyList_GET_SIZE(value); Reserved_cntr_0++) {
			if (PyList_GET_ITEM(value, Reserved_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->Reserved)[Reserved_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->Reserved)[Reserved_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, Reserved_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, Reserved_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->Reserved)[Reserved_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_TargetInfoLen(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_TargetInfoLen;
	py_TargetInfoLen = PyLong_FromLong((uint16_t)(object->TargetInfoLen));
	return py_TargetInfoLen;
}

static int py_CHALLENGE_MESSAGE_set_TargetInfoLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->TargetInfoLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->TargetInfoLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->TargetInfoLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_TargetInfoMaxLen(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_TargetInfoMaxLen;
	py_TargetInfoMaxLen = PyLong_FromLong((uint16_t)(object->TargetInfoMaxLen));
	return py_TargetInfoMaxLen;
}

static int py_CHALLENGE_MESSAGE_set_TargetInfoMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->TargetInfoMaxLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->TargetInfoMaxLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->TargetInfoMaxLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_TargetInfo(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_TargetInfo;
	if (object->TargetInfo == NULL) {
		Py_RETURN_NONE;
	}
	if (object->TargetInfo == NULL) {
		py_TargetInfo = Py_None;
		Py_INCREF(py_TargetInfo);
	} else {
		py_TargetInfo = pytalloc_reference_ex(&AV_PAIR_LIST_Type, object->TargetInfo, object->TargetInfo);
	}
	return py_TargetInfo;
}

static int py_CHALLENGE_MESSAGE_set_TargetInfo(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->TargetInfo));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->TargetInfo");
		return -1;
	}
	if (value == Py_None) {
		object->TargetInfo = NULL;
	} else {
		object->TargetInfo = NULL;
		PY_CHECK_TYPE(&AV_PAIR_LIST_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->TargetInfo = (struct AV_PAIR_LIST *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_Version(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = pyrpc_import_union(&ntlmssp_Version_Type, pytalloc_get_mem_ctx(obj), object->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION, &object->Version, "union ntlmssp_Version");
	if (py_Version == NULL) {
		return NULL;
	}
	return py_Version;
}

static int py_CHALLENGE_MESSAGE_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Version");
		return -1;
	}
	{
		union ntlmssp_Version *Version_switch_0;
		Version_switch_0 = (union ntlmssp_Version *)pyrpc_export_union(&ntlmssp_Version_Type, pytalloc_get_mem_ctx(py_obj), object->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION, value, "union ntlmssp_Version");
		if (Version_switch_0 == NULL) {
			return -1;
		}
		object->Version = *Version_switch_0;
	}
	return 0;
}

static PyGetSetDef py_CHALLENGE_MESSAGE_getsetters[] = {
	{
		.name = discard_const_p(char, "Signature"),
		.get = py_CHALLENGE_MESSAGE_get_Signature,
		.set = py_CHALLENGE_MESSAGE_set_Signature,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "MessageType"),
		.get = py_CHALLENGE_MESSAGE_get_MessageType,
		.set = py_CHALLENGE_MESSAGE_set_MessageType,
		.doc = discard_const_p(char, "PIDL-generated element of base type ntlmssp_MessageType")
	},
	{
		.name = discard_const_p(char, "TargetNameLen"),
		.get = py_CHALLENGE_MESSAGE_get_TargetNameLen,
		.set = py_CHALLENGE_MESSAGE_set_TargetNameLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "TargetNameMaxLen"),
		.get = py_CHALLENGE_MESSAGE_get_TargetNameMaxLen,
		.set = py_CHALLENGE_MESSAGE_set_TargetNameMaxLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "TargetName"),
		.get = py_CHALLENGE_MESSAGE_get_TargetName,
		.set = py_CHALLENGE_MESSAGE_set_TargetName,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "NegotiateFlags"),
		.get = py_CHALLENGE_MESSAGE_get_NegotiateFlags,
		.set = py_CHALLENGE_MESSAGE_set_NegotiateFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type NEGOTIATE")
	},
	{
		.name = discard_const_p(char, "ServerChallenge"),
		.get = py_CHALLENGE_MESSAGE_get_ServerChallenge,
		.set = py_CHALLENGE_MESSAGE_set_ServerChallenge,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Reserved"),
		.get = py_CHALLENGE_MESSAGE_get_Reserved,
		.set = py_CHALLENGE_MESSAGE_set_Reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "TargetInfoLen"),
		.get = py_CHALLENGE_MESSAGE_get_TargetInfoLen,
		.set = py_CHALLENGE_MESSAGE_set_TargetInfoLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "TargetInfoMaxLen"),
		.get = py_CHALLENGE_MESSAGE_get_TargetInfoMaxLen,
		.set = py_CHALLENGE_MESSAGE_set_TargetInfoMaxLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "TargetInfo"),
		.get = py_CHALLENGE_MESSAGE_get_TargetInfo,
		.set = py_CHALLENGE_MESSAGE_set_TargetInfo,
		.doc = discard_const_p(char, "PIDL-generated element of base type AV_PAIR_LIST")
	},
	{
		.name = discard_const_p(char, "Version"),
		.get = py_CHALLENGE_MESSAGE_get_Version,
		.set = py_CHALLENGE_MESSAGE_set_Version,
		.doc = discard_const_p(char, "PIDL-generated element of base type ntlmssp_Version")
	},
	{ .name = NULL }
};

static PyObject *py_CHALLENGE_MESSAGE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CHALLENGE_MESSAGE, type);
}

static PyObject *py_CHALLENGE_MESSAGE_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_CHALLENGE_MESSAGE);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_CHALLENGE_MESSAGE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_CHALLENGE_MESSAGE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_CHALLENGE_MESSAGE);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_CHALLENGE_MESSAGE_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct CHALLENGE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_CHALLENGE_MESSAGE, "CHALLENGE_MESSAGE", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_CHALLENGE_MESSAGE, "CHALLENGE_MESSAGE", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_CHALLENGE_MESSAGE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_CHALLENGE_MESSAGE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_CHALLENGE_MESSAGE_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_CHALLENGE_MESSAGE_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject CHALLENGE_MESSAGE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.CHALLENGE_MESSAGE",
	.tp_getset = py_CHALLENGE_MESSAGE_getsetters,
	.tp_methods = py_CHALLENGE_MESSAGE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CHALLENGE_MESSAGE_new,
};


static PyObject *py_LM_RESPONSE_get_Response(PyObject *obj, void *closure)
{
	struct LM_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_Response;
	py_Response = PyList_New(24);
	if (py_Response == NULL) {
		return NULL;
	}
	{
		int Response_cntr_0;
		for (Response_cntr_0 = 0; Response_cntr_0 < (24); Response_cntr_0++) {
			PyObject *py_Response_0;
			py_Response_0 = PyLong_FromLong((uint16_t)((object->Response)[Response_cntr_0]));
			PyList_SetItem(py_Response, Response_cntr_0, py_Response_0);
		}
	}
	return py_Response;
}

static int py_LM_RESPONSE_set_Response(PyObject *py_obj, PyObject *value, void *closure)
{
	struct LM_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Response");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Response_cntr_0;
		if (ARRAY_SIZE(object->Response) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->Response),  PyList_GET_SIZE(value));
			return -1;
		}
		for (Response_cntr_0 = 0; Response_cntr_0 < PyList_GET_SIZE(value); Response_cntr_0++) {
			if (PyList_GET_ITEM(value, Response_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->Response)[Response_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->Response)[Response_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, Response_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, Response_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->Response)[Response_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_LM_RESPONSE_getsetters[] = {
	{
		.name = discard_const_p(char, "Response"),
		.get = py_LM_RESPONSE_get_Response,
		.set = py_LM_RESPONSE_set_Response,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_LM_RESPONSE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct LM_RESPONSE, type);
}

static PyObject *py_LM_RESPONSE_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct LM_RESPONSE *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_LM_RESPONSE);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_LM_RESPONSE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct LM_RESPONSE *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_LM_RESPONSE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_LM_RESPONSE);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_LM_RESPONSE_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct LM_RESPONSE *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_LM_RESPONSE, "LM_RESPONSE", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_LM_RESPONSE, "LM_RESPONSE", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_LM_RESPONSE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_LM_RESPONSE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_LM_RESPONSE_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_LM_RESPONSE_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject LM_RESPONSE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.LM_RESPONSE",
	.tp_getset = py_LM_RESPONSE_getsetters,
	.tp_methods = py_LM_RESPONSE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_LM_RESPONSE_new,
};


static PyObject *py_LMv2_RESPONSE_get_Response(PyObject *obj, void *closure)
{
	struct LMv2_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_Response;
	py_Response = PyList_New(16);
	if (py_Response == NULL) {
		return NULL;
	}
	{
		int Response_cntr_0;
		for (Response_cntr_0 = 0; Response_cntr_0 < (16); Response_cntr_0++) {
			PyObject *py_Response_0;
			py_Response_0 = PyLong_FromLong((uint16_t)((object->Response)[Response_cntr_0]));
			PyList_SetItem(py_Response, Response_cntr_0, py_Response_0);
		}
	}
	return py_Response;
}

static int py_LMv2_RESPONSE_set_Response(PyObject *py_obj, PyObject *value, void *closure)
{
	struct LMv2_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Response");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Response_cntr_0;
		if (ARRAY_SIZE(object->Response) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->Response),  PyList_GET_SIZE(value));
			return -1;
		}
		for (Response_cntr_0 = 0; Response_cntr_0 < PyList_GET_SIZE(value); Response_cntr_0++) {
			if (PyList_GET_ITEM(value, Response_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->Response)[Response_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->Response)[Response_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, Response_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, Response_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->Response)[Response_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_LMv2_RESPONSE_get_ChallengeFromClient(PyObject *obj, void *closure)
{
	struct LMv2_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_ChallengeFromClient;
	py_ChallengeFromClient = PyList_New(8);
	if (py_ChallengeFromClient == NULL) {
		return NULL;
	}
	{
		int ChallengeFromClient_cntr_0;
		for (ChallengeFromClient_cntr_0 = 0; ChallengeFromClient_cntr_0 < (8); ChallengeFromClient_cntr_0++) {
			PyObject *py_ChallengeFromClient_0;
			py_ChallengeFromClient_0 = PyLong_FromLong((uint16_t)((object->ChallengeFromClient)[ChallengeFromClient_cntr_0]));
			PyList_SetItem(py_ChallengeFromClient, ChallengeFromClient_cntr_0, py_ChallengeFromClient_0);
		}
	}
	return py_ChallengeFromClient;
}

static int py_LMv2_RESPONSE_set_ChallengeFromClient(PyObject *py_obj, PyObject *value, void *closure)
{
	struct LMv2_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ChallengeFromClient");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ChallengeFromClient_cntr_0;
		if (ARRAY_SIZE(object->ChallengeFromClient) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->ChallengeFromClient),  PyList_GET_SIZE(value));
			return -1;
		}
		for (ChallengeFromClient_cntr_0 = 0; ChallengeFromClient_cntr_0 < PyList_GET_SIZE(value); ChallengeFromClient_cntr_0++) {
			if (PyList_GET_ITEM(value, ChallengeFromClient_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->ChallengeFromClient)[ChallengeFromClient_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->ChallengeFromClient)[ChallengeFromClient_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, ChallengeFromClient_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, ChallengeFromClient_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->ChallengeFromClient)[ChallengeFromClient_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_LMv2_RESPONSE_getsetters[] = {
	{
		.name = discard_const_p(char, "Response"),
		.get = py_LMv2_RESPONSE_get_Response,
		.set = py_LMv2_RESPONSE_set_Response,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "ChallengeFromClient"),
		.get = py_LMv2_RESPONSE_get_ChallengeFromClient,
		.set = py_LMv2_RESPONSE_set_ChallengeFromClient,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_LMv2_RESPONSE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct LMv2_RESPONSE, type);
}

static PyObject *py_LMv2_RESPONSE_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct LMv2_RESPONSE *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_LMv2_RESPONSE);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_LMv2_RESPONSE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct LMv2_RESPONSE *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_LMv2_RESPONSE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_LMv2_RESPONSE);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_LMv2_RESPONSE_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct LMv2_RESPONSE *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_LMv2_RESPONSE, "LMv2_RESPONSE", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_LMv2_RESPONSE, "LMv2_RESPONSE", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_LMv2_RESPONSE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_LMv2_RESPONSE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_LMv2_RESPONSE_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_LMv2_RESPONSE_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject LMv2_RESPONSE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.LMv2_RESPONSE",
	.tp_getset = py_LMv2_RESPONSE_getsetters,
	.tp_methods = py_LMv2_RESPONSE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_LMv2_RESPONSE_new,
};

static PyObject *py_import_ntlmssp_LM_RESPONSE_with_len(TALLOC_CTX *mem_ctx, int level, union ntlmssp_LM_RESPONSE_with_len *in)
{
	PyObject *ret;

	switch (level) {
		case 24:
			ret = pytalloc_reference_ex(&LM_RESPONSE_Type, mem_ctx, &in->v1);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union ntlmssp_LM_RESPONSE_with_len *py_export_ntlmssp_LM_RESPONSE_with_len(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union ntlmssp_LM_RESPONSE_with_len *ret = talloc_zero(mem_ctx, union ntlmssp_LM_RESPONSE_with_len);
	switch (level) {
		case 24:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->v1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&LM_RESPONSE_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->v1 = *(struct LM_RESPONSE *)pytalloc_get_ptr(in);
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_ntlmssp_LM_RESPONSE_with_len_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union ntlmssp_LM_RESPONSE_with_len *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union ntlmssp_LM_RESPONSE_with_len *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union ntlmssp_LM_RESPONSE_with_len!");
		return NULL;
	}

	return py_import_ntlmssp_LM_RESPONSE_with_len(mem_ctx, level, in);
}

static PyObject *py_ntlmssp_LM_RESPONSE_with_len_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union ntlmssp_LM_RESPONSE_with_len *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_ntlmssp_LM_RESPONSE_with_len(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_ntlmssp_LM_RESPONSE_with_len_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ntlmssp_LM_RESPONSE_with_len_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ntlmssp_LM_RESPONSE_with_len_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_ntlmssp_LM_RESPONSE_with_len_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject ntlmssp_LM_RESPONSE_with_len_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.LM_RESPONSE_with_len",
	.tp_getset = NULL,
	.tp_methods = py_ntlmssp_LM_RESPONSE_with_len_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ntlmssp_LM_RESPONSE_with_len_new,
};


static PyObject *py_NTLM_RESPONSE_get_Response(PyObject *obj, void *closure)
{
	struct NTLM_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_Response;
	py_Response = PyList_New(24);
	if (py_Response == NULL) {
		return NULL;
	}
	{
		int Response_cntr_0;
		for (Response_cntr_0 = 0; Response_cntr_0 < (24); Response_cntr_0++) {
			PyObject *py_Response_0;
			py_Response_0 = PyLong_FromLong((uint16_t)((object->Response)[Response_cntr_0]));
			PyList_SetItem(py_Response, Response_cntr_0, py_Response_0);
		}
	}
	return py_Response;
}

static int py_NTLM_RESPONSE_set_Response(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLM_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Response");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Response_cntr_0;
		if (ARRAY_SIZE(object->Response) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->Response),  PyList_GET_SIZE(value));
			return -1;
		}
		for (Response_cntr_0 = 0; Response_cntr_0 < PyList_GET_SIZE(value); Response_cntr_0++) {
			if (PyList_GET_ITEM(value, Response_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->Response)[Response_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->Response)[Response_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, Response_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, Response_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->Response)[Response_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_NTLM_RESPONSE_getsetters[] = {
	{
		.name = discard_const_p(char, "Response"),
		.get = py_NTLM_RESPONSE_get_Response,
		.set = py_NTLM_RESPONSE_set_Response,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_NTLM_RESPONSE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NTLM_RESPONSE, type);
}

static PyObject *py_NTLM_RESPONSE_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct NTLM_RESPONSE *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_NTLM_RESPONSE);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_NTLM_RESPONSE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NTLM_RESPONSE *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NTLM_RESPONSE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NTLM_RESPONSE);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NTLM_RESPONSE_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NTLM_RESPONSE *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NTLM_RESPONSE, "NTLM_RESPONSE", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NTLM_RESPONSE, "NTLM_RESPONSE", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NTLM_RESPONSE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NTLM_RESPONSE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NTLM_RESPONSE_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NTLM_RESPONSE_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NTLM_RESPONSE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.NTLM_RESPONSE",
	.tp_getset = py_NTLM_RESPONSE_getsetters,
	.tp_methods = py_NTLM_RESPONSE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NTLM_RESPONSE_new,
};


static PyObject *py_NTLMv2_CLIENT_CHALLENGE_get_RespType(PyObject *obj, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = pytalloc_get_ptr(obj);
	PyObject *py_RespType;
	py_RespType = PyLong_FromLong((uint16_t)(object->RespType));
	return py_RespType;
}

static int py_NTLMv2_CLIENT_CHALLENGE_set_RespType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->RespType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->RespType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->RespType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NTLMv2_CLIENT_CHALLENGE_get_HiRespType(PyObject *obj, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = pytalloc_get_ptr(obj);
	PyObject *py_HiRespType;
	py_HiRespType = PyLong_FromLong((uint16_t)(object->HiRespType));
	return py_HiRespType;
}

static int py_NTLMv2_CLIENT_CHALLENGE_set_HiRespType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->HiRespType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->HiRespType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->HiRespType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NTLMv2_CLIENT_CHALLENGE_get_Reserved1(PyObject *obj, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = pytalloc_get_ptr(obj);
	PyObject *py_Reserved1;
	py_Reserved1 = PyLong_FromLong((uint16_t)(object->Reserved1));
	return py_Reserved1;
}

static int py_NTLMv2_CLIENT_CHALLENGE_set_Reserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Reserved1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Reserved1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Reserved1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NTLMv2_CLIENT_CHALLENGE_get_Reserved2(PyObject *obj, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = pytalloc_get_ptr(obj);
	PyObject *py_Reserved2;
	py_Reserved2 = PyLong_FromUnsignedLongLong((uint32_t)(object->Reserved2));
	return py_Reserved2;
}

static int py_NTLMv2_CLIENT_CHALLENGE_set_Reserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Reserved2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Reserved2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Reserved2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NTLMv2_CLIENT_CHALLENGE_get_TimeStamp(PyObject *obj, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = pytalloc_get_ptr(obj);
	PyObject *py_TimeStamp;
	py_TimeStamp = PyLong_FromUnsignedLongLong(object->TimeStamp);
	return py_TimeStamp;
}

static int py_NTLMv2_CLIENT_CHALLENGE_set_TimeStamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->TimeStamp");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->TimeStamp));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->TimeStamp = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NTLMv2_CLIENT_CHALLENGE_get_ChallengeFromClient(PyObject *obj, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = pytalloc_get_ptr(obj);
	PyObject *py_ChallengeFromClient;
	py_ChallengeFromClient = PyList_New(8);
	if (py_ChallengeFromClient == NULL) {
		return NULL;
	}
	{
		int ChallengeFromClient_cntr_0;
		for (ChallengeFromClient_cntr_0 = 0; ChallengeFromClient_cntr_0 < (8); ChallengeFromClient_cntr_0++) {
			PyObject *py_ChallengeFromClient_0;
			py_ChallengeFromClient_0 = PyLong_FromLong((uint16_t)((object->ChallengeFromClient)[ChallengeFromClient_cntr_0]));
			PyList_SetItem(py_ChallengeFromClient, ChallengeFromClient_cntr_0, py_ChallengeFromClient_0);
		}
	}
	return py_ChallengeFromClient;
}

static int py_NTLMv2_CLIENT_CHALLENGE_set_ChallengeFromClient(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ChallengeFromClient");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ChallengeFromClient_cntr_0;
		if (ARRAY_SIZE(object->ChallengeFromClient) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->ChallengeFromClient),  PyList_GET_SIZE(value));
			return -1;
		}
		for (ChallengeFromClient_cntr_0 = 0; ChallengeFromClient_cntr_0 < PyList_GET_SIZE(value); ChallengeFromClient_cntr_0++) {
			if (PyList_GET_ITEM(value, ChallengeFromClient_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->ChallengeFromClient)[ChallengeFromClient_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->ChallengeFromClient)[ChallengeFromClient_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, ChallengeFromClient_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, ChallengeFromClient_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->ChallengeFromClient)[ChallengeFromClient_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_NTLMv2_CLIENT_CHALLENGE_get_Reserved3(PyObject *obj, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = pytalloc_get_ptr(obj);
	PyObject *py_Reserved3;
	py_Reserved3 = PyLong_FromUnsignedLongLong((uint32_t)(object->Reserved3));
	return py_Reserved3;
}

static int py_NTLMv2_CLIENT_CHALLENGE_set_Reserved3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Reserved3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Reserved3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Reserved3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NTLMv2_CLIENT_CHALLENGE_get_AvPairs(PyObject *obj, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = pytalloc_get_ptr(obj);
	PyObject *py_AvPairs;
	py_AvPairs = pytalloc_reference_ex(&AV_PAIR_LIST_Type, pytalloc_get_mem_ctx(obj), &object->AvPairs);
	return py_AvPairs;
}

static int py_NTLMv2_CLIENT_CHALLENGE_set_AvPairs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->AvPairs");
		return -1;
	}
	PY_CHECK_TYPE(&AV_PAIR_LIST_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->AvPairs = *(struct AV_PAIR_LIST *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_NTLMv2_CLIENT_CHALLENGE_getsetters[] = {
	{
		.name = discard_const_p(char, "RespType"),
		.get = py_NTLMv2_CLIENT_CHALLENGE_get_RespType,
		.set = py_NTLMv2_CLIENT_CHALLENGE_set_RespType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "HiRespType"),
		.get = py_NTLMv2_CLIENT_CHALLENGE_get_HiRespType,
		.set = py_NTLMv2_CLIENT_CHALLENGE_set_HiRespType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Reserved1"),
		.get = py_NTLMv2_CLIENT_CHALLENGE_get_Reserved1,
		.set = py_NTLMv2_CLIENT_CHALLENGE_set_Reserved1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "Reserved2"),
		.get = py_NTLMv2_CLIENT_CHALLENGE_get_Reserved2,
		.set = py_NTLMv2_CLIENT_CHALLENGE_set_Reserved2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "TimeStamp"),
		.get = py_NTLMv2_CLIENT_CHALLENGE_get_TimeStamp,
		.set = py_NTLMv2_CLIENT_CHALLENGE_set_TimeStamp,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "ChallengeFromClient"),
		.get = py_NTLMv2_CLIENT_CHALLENGE_get_ChallengeFromClient,
		.set = py_NTLMv2_CLIENT_CHALLENGE_set_ChallengeFromClient,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Reserved3"),
		.get = py_NTLMv2_CLIENT_CHALLENGE_get_Reserved3,
		.set = py_NTLMv2_CLIENT_CHALLENGE_set_Reserved3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "AvPairs"),
		.get = py_NTLMv2_CLIENT_CHALLENGE_get_AvPairs,
		.set = py_NTLMv2_CLIENT_CHALLENGE_set_AvPairs,
		.doc = discard_const_p(char, "PIDL-generated element of base type AV_PAIR_LIST")
	},
	{ .name = NULL }
};

static PyObject *py_NTLMv2_CLIENT_CHALLENGE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NTLMv2_CLIENT_CHALLENGE, type);
}


static PyTypeObject NTLMv2_CLIENT_CHALLENGE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.NTLMv2_CLIENT_CHALLENGE",
	.tp_getset = py_NTLMv2_CLIENT_CHALLENGE_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NTLMv2_CLIENT_CHALLENGE_new,
};


static PyObject *py_NTLMv2_RESPONSE_get_Response(PyObject *obj, void *closure)
{
	struct NTLMv2_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_Response;
	py_Response = PyList_New(16);
	if (py_Response == NULL) {
		return NULL;
	}
	{
		int Response_cntr_0;
		for (Response_cntr_0 = 0; Response_cntr_0 < (16); Response_cntr_0++) {
			PyObject *py_Response_0;
			py_Response_0 = PyLong_FromLong((uint16_t)((object->Response)[Response_cntr_0]));
			PyList_SetItem(py_Response, Response_cntr_0, py_Response_0);
		}
	}
	return py_Response;
}

static int py_NTLMv2_RESPONSE_set_Response(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Response");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Response_cntr_0;
		if (ARRAY_SIZE(object->Response) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->Response),  PyList_GET_SIZE(value));
			return -1;
		}
		for (Response_cntr_0 = 0; Response_cntr_0 < PyList_GET_SIZE(value); Response_cntr_0++) {
			if (PyList_GET_ITEM(value, Response_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->Response)[Response_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->Response)[Response_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, Response_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, Response_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->Response)[Response_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_NTLMv2_RESPONSE_get_Challenge(PyObject *obj, void *closure)
{
	struct NTLMv2_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_Challenge;
	py_Challenge = pytalloc_reference_ex(&NTLMv2_CLIENT_CHALLENGE_Type, pytalloc_get_mem_ctx(obj), &object->Challenge);
	return py_Challenge;
}

static int py_NTLMv2_RESPONSE_set_Challenge(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Challenge");
		return -1;
	}
	PY_CHECK_TYPE(&NTLMv2_CLIENT_CHALLENGE_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->Challenge = *(struct NTLMv2_CLIENT_CHALLENGE *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_NTLMv2_RESPONSE_getsetters[] = {
	{
		.name = discard_const_p(char, "Response"),
		.get = py_NTLMv2_RESPONSE_get_Response,
		.set = py_NTLMv2_RESPONSE_set_Response,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Challenge"),
		.get = py_NTLMv2_RESPONSE_get_Challenge,
		.set = py_NTLMv2_RESPONSE_set_Challenge,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTLMv2_CLIENT_CHALLENGE")
	},
	{ .name = NULL }
};

static PyObject *py_NTLMv2_RESPONSE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NTLMv2_RESPONSE, type);
}

static PyObject *py_NTLMv2_RESPONSE_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct NTLMv2_RESPONSE *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_NTLMv2_RESPONSE);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_NTLMv2_RESPONSE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NTLMv2_RESPONSE *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NTLMv2_RESPONSE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NTLMv2_RESPONSE);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NTLMv2_RESPONSE_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NTLMv2_RESPONSE *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NTLMv2_RESPONSE, "NTLMv2_RESPONSE", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NTLMv2_RESPONSE, "NTLMv2_RESPONSE", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NTLMv2_RESPONSE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NTLMv2_RESPONSE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NTLMv2_RESPONSE_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NTLMv2_RESPONSE_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NTLMv2_RESPONSE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.NTLMv2_RESPONSE",
	.tp_getset = py_NTLMv2_RESPONSE_getsetters,
	.tp_methods = py_NTLMv2_RESPONSE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NTLMv2_RESPONSE_new,
};

static PyObject *py_import_ntlmssp_NTLM_RESPONSE_with_len(TALLOC_CTX *mem_ctx, int level, union ntlmssp_NTLM_RESPONSE_with_len *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case 0x18:
			ret = pytalloc_reference_ex(&NTLM_RESPONSE_Type, mem_ctx, &in->v1);
			return ret;

		default:
			ret = pytalloc_reference_ex(&NTLMv2_RESPONSE_Type, mem_ctx, &in->v2);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union ntlmssp_NTLM_RESPONSE_with_len *py_export_ntlmssp_NTLM_RESPONSE_with_len(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union ntlmssp_NTLM_RESPONSE_with_len *ret = talloc_zero(mem_ctx, union ntlmssp_NTLM_RESPONSE_with_len);
	switch (level) {
		case 0:
			break;

		case 0x18:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->v1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&NTLM_RESPONSE_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->v1 = *(struct NTLM_RESPONSE *)pytalloc_get_ptr(in);
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->v2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&NTLMv2_RESPONSE_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->v2 = *(struct NTLMv2_RESPONSE *)pytalloc_get_ptr(in);
			break;

	}

	return ret;
}

static PyObject *py_ntlmssp_NTLM_RESPONSE_with_len_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union ntlmssp_NTLM_RESPONSE_with_len *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union ntlmssp_NTLM_RESPONSE_with_len *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union ntlmssp_NTLM_RESPONSE_with_len!");
		return NULL;
	}

	return py_import_ntlmssp_NTLM_RESPONSE_with_len(mem_ctx, level, in);
}

static PyObject *py_ntlmssp_NTLM_RESPONSE_with_len_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union ntlmssp_NTLM_RESPONSE_with_len *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_ntlmssp_NTLM_RESPONSE_with_len(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_ntlmssp_NTLM_RESPONSE_with_len_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ntlmssp_NTLM_RESPONSE_with_len_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ntlmssp_NTLM_RESPONSE_with_len_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_ntlmssp_NTLM_RESPONSE_with_len_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject ntlmssp_NTLM_RESPONSE_with_len_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.NTLM_RESPONSE_with_len",
	.tp_getset = NULL,
	.tp_methods = py_ntlmssp_NTLM_RESPONSE_with_len_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ntlmssp_NTLM_RESPONSE_with_len_new,
};


static PyObject *py_ntlmssp_MIC_get_MIC(PyObject *obj, void *closure)
{
	struct ntlmssp_MIC *object = pytalloc_get_ptr(obj);
	PyObject *py_MIC;
	py_MIC = PyList_New(NTLMSSP_MIC_SIZE);
	if (py_MIC == NULL) {
		return NULL;
	}
	{
		int MIC_cntr_0;
		for (MIC_cntr_0 = 0; MIC_cntr_0 < (NTLMSSP_MIC_SIZE); MIC_cntr_0++) {
			PyObject *py_MIC_0;
			py_MIC_0 = PyLong_FromLong((uint16_t)((object->MIC)[MIC_cntr_0]));
			PyList_SetItem(py_MIC, MIC_cntr_0, py_MIC_0);
		}
	}
	return py_MIC;
}

static int py_ntlmssp_MIC_set_MIC(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ntlmssp_MIC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->MIC");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int MIC_cntr_0;
		object->MIC = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->MIC, PyList_GET_SIZE(value));
		if (!object->MIC) { return -1; }
		talloc_set_name_const(object->MIC, "ARRAY: object->MIC");
		for (MIC_cntr_0 = 0; MIC_cntr_0 < PyList_GET_SIZE(value); MIC_cntr_0++) {
			if (PyList_GET_ITEM(value, MIC_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->MIC)[MIC_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->MIC)[MIC_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, MIC_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, MIC_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->MIC)[MIC_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_ntlmssp_MIC_getsetters[] = {
	{
		.name = discard_const_p(char, "MIC"),
		.get = py_ntlmssp_MIC_get_MIC,
		.set = py_ntlmssp_MIC_set_MIC,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_ntlmssp_MIC_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ntlmssp_MIC, type);
}


static PyTypeObject ntlmssp_MIC_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.MIC",
	.tp_getset = py_ntlmssp_MIC_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ntlmssp_MIC_new,
};


static PyObject *py_AUTHENTICATE_MESSAGE_get_Signature(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_Signature;
	if (object->Signature == NULL) {
		py_Signature = Py_None;
		Py_INCREF(py_Signature);
	} else {
		py_Signature = PyUnicode_Decode(object->Signature, strlen(object->Signature), "utf-8", "ignore");
	}
	return py_Signature;
}

static int py_AUTHENTICATE_MESSAGE_set_Signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Signature");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->Signature = talloc_str;
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_MessageType(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_MessageType;
	py_MessageType = PyLong_FromUnsignedLongLong((uint32_t)(object->MessageType));
	return py_MessageType;
}

static int py_AUTHENTICATE_MESSAGE_set_MessageType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->MessageType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->MessageType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->MessageType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_LmChallengeResponseLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_LmChallengeResponseLen;
	py_LmChallengeResponseLen = PyLong_FromLong((uint16_t)(object->LmChallengeResponseLen));
	return py_LmChallengeResponseLen;
}

static int py_AUTHENTICATE_MESSAGE_set_LmChallengeResponseLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->LmChallengeResponseLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->LmChallengeResponseLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->LmChallengeResponseLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_LmChallengeResponseMaxLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_LmChallengeResponseMaxLen;
	py_LmChallengeResponseMaxLen = PyLong_FromLong((uint16_t)(object->LmChallengeResponseMaxLen));
	return py_LmChallengeResponseMaxLen;
}

static int py_AUTHENTICATE_MESSAGE_set_LmChallengeResponseMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->LmChallengeResponseMaxLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->LmChallengeResponseMaxLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->LmChallengeResponseMaxLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_LmChallengeResponse(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_LmChallengeResponse;
	if (object->LmChallengeResponse == NULL) {
		Py_RETURN_NONE;
	}
	if (object->LmChallengeResponse == NULL) {
		py_LmChallengeResponse = Py_None;
		Py_INCREF(py_LmChallengeResponse);
	} else {
		py_LmChallengeResponse = pyrpc_import_union(&ntlmssp_LM_RESPONSE_with_len_Type, object->LmChallengeResponse, object->LmChallengeResponseLen, object->LmChallengeResponse, "union ntlmssp_LM_RESPONSE_with_len");
		if (py_LmChallengeResponse == NULL) {
			return NULL;
		}
	}
	return py_LmChallengeResponse;
}

static int py_AUTHENTICATE_MESSAGE_set_LmChallengeResponse(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->LmChallengeResponse));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->LmChallengeResponse");
		return -1;
	}
	if (value == Py_None) {
		object->LmChallengeResponse = NULL;
	} else {
		object->LmChallengeResponse = NULL;
		{
			union ntlmssp_LM_RESPONSE_with_len *LmChallengeResponse_switch_2;
			LmChallengeResponse_switch_2 = (union ntlmssp_LM_RESPONSE_with_len *)pyrpc_export_union(&ntlmssp_LM_RESPONSE_with_len_Type, pytalloc_get_mem_ctx(py_obj), object->LmChallengeResponseLen, value, "union ntlmssp_LM_RESPONSE_with_len");
			if (LmChallengeResponse_switch_2 == NULL) {
				return -1;
			}
			object->LmChallengeResponse = LmChallengeResponse_switch_2;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_NtChallengeResponseLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_NtChallengeResponseLen;
	py_NtChallengeResponseLen = PyLong_FromLong((uint16_t)(object->NtChallengeResponseLen));
	return py_NtChallengeResponseLen;
}

static int py_AUTHENTICATE_MESSAGE_set_NtChallengeResponseLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->NtChallengeResponseLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->NtChallengeResponseLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->NtChallengeResponseLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_NtChallengeResponseMaxLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_NtChallengeResponseMaxLen;
	py_NtChallengeResponseMaxLen = PyLong_FromLong((uint16_t)(object->NtChallengeResponseMaxLen));
	return py_NtChallengeResponseMaxLen;
}

static int py_AUTHENTICATE_MESSAGE_set_NtChallengeResponseMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->NtChallengeResponseMaxLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->NtChallengeResponseMaxLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->NtChallengeResponseMaxLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_NtChallengeResponse(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_NtChallengeResponse;
	if (object->NtChallengeResponse == NULL) {
		Py_RETURN_NONE;
	}
	if (object->NtChallengeResponse == NULL) {
		py_NtChallengeResponse = Py_None;
		Py_INCREF(py_NtChallengeResponse);
	} else {
		py_NtChallengeResponse = pyrpc_import_union(&ntlmssp_NTLM_RESPONSE_with_len_Type, object->NtChallengeResponse, object->NtChallengeResponseLen, object->NtChallengeResponse, "union ntlmssp_NTLM_RESPONSE_with_len");
		if (py_NtChallengeResponse == NULL) {
			return NULL;
		}
	}
	return py_NtChallengeResponse;
}

static int py_AUTHENTICATE_MESSAGE_set_NtChallengeResponse(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->NtChallengeResponse));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->NtChallengeResponse");
		return -1;
	}
	if (value == Py_None) {
		object->NtChallengeResponse = NULL;
	} else {
		object->NtChallengeResponse = NULL;
		{
			union ntlmssp_NTLM_RESPONSE_with_len *NtChallengeResponse_switch_2;
			NtChallengeResponse_switch_2 = (union ntlmssp_NTLM_RESPONSE_with_len *)pyrpc_export_union(&ntlmssp_NTLM_RESPONSE_with_len_Type, pytalloc_get_mem_ctx(py_obj), object->NtChallengeResponseLen, value, "union ntlmssp_NTLM_RESPONSE_with_len");
			if (NtChallengeResponse_switch_2 == NULL) {
				return -1;
			}
			object->NtChallengeResponse = NtChallengeResponse_switch_2;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_DomainNameLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_DomainNameLen;
	py_DomainNameLen = PyLong_FromLong((uint16_t)(object->DomainNameLen));
	return py_DomainNameLen;
}

static int py_AUTHENTICATE_MESSAGE_set_DomainNameLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->DomainNameLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->DomainNameLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->DomainNameLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_DomainNameMaxLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_DomainNameMaxLen;
	py_DomainNameMaxLen = PyLong_FromLong((uint16_t)(object->DomainNameMaxLen));
	return py_DomainNameMaxLen;
}

static int py_AUTHENTICATE_MESSAGE_set_DomainNameMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->DomainNameMaxLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->DomainNameMaxLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->DomainNameMaxLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_DomainName(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_DomainName;
	if (object->DomainName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->DomainName == NULL) {
		py_DomainName = Py_None;
		Py_INCREF(py_DomainName);
	} else {
		py_DomainName = PyString_FromStringOrNULL(object->DomainName);
	}
	return py_DomainName;
}

static int py_AUTHENTICATE_MESSAGE_set_DomainName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->DomainName));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->DomainName");
		return -1;
	}
	if (value == Py_None) {
		object->DomainName = NULL;
	} else {
		object->DomainName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->DomainName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_UserNameLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_UserNameLen;
	py_UserNameLen = PyLong_FromLong((uint16_t)(object->UserNameLen));
	return py_UserNameLen;
}

static int py_AUTHENTICATE_MESSAGE_set_UserNameLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->UserNameLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->UserNameLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->UserNameLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_UserNameMaxLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_UserNameMaxLen;
	py_UserNameMaxLen = PyLong_FromLong((uint16_t)(object->UserNameMaxLen));
	return py_UserNameMaxLen;
}

static int py_AUTHENTICATE_MESSAGE_set_UserNameMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->UserNameMaxLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->UserNameMaxLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->UserNameMaxLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_UserName(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_UserName;
	if (object->UserName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->UserName == NULL) {
		py_UserName = Py_None;
		Py_INCREF(py_UserName);
	} else {
		py_UserName = PyString_FromStringOrNULL(object->UserName);
	}
	return py_UserName;
}

static int py_AUTHENTICATE_MESSAGE_set_UserName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->UserName));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->UserName");
		return -1;
	}
	if (value == Py_None) {
		object->UserName = NULL;
	} else {
		object->UserName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->UserName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_WorkstationLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_WorkstationLen;
	py_WorkstationLen = PyLong_FromLong((uint16_t)(object->WorkstationLen));
	return py_WorkstationLen;
}

static int py_AUTHENTICATE_MESSAGE_set_WorkstationLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->WorkstationLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->WorkstationLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->WorkstationLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_WorkstationMaxLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_WorkstationMaxLen;
	py_WorkstationMaxLen = PyLong_FromLong((uint16_t)(object->WorkstationMaxLen));
	return py_WorkstationMaxLen;
}

static int py_AUTHENTICATE_MESSAGE_set_WorkstationMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->WorkstationMaxLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->WorkstationMaxLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->WorkstationMaxLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_Workstation(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_Workstation;
	if (object->Workstation == NULL) {
		Py_RETURN_NONE;
	}
	if (object->Workstation == NULL) {
		py_Workstation = Py_None;
		Py_INCREF(py_Workstation);
	} else {
		py_Workstation = PyString_FromStringOrNULL(object->Workstation);
	}
	return py_Workstation;
}

static int py_AUTHENTICATE_MESSAGE_set_Workstation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->Workstation));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Workstation");
		return -1;
	}
	if (value == Py_None) {
		object->Workstation = NULL;
	} else {
		object->Workstation = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->Workstation = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_EncryptedRandomSessionKeyLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_EncryptedRandomSessionKeyLen;
	py_EncryptedRandomSessionKeyLen = PyLong_FromLong((uint16_t)(object->EncryptedRandomSessionKeyLen));
	return py_EncryptedRandomSessionKeyLen;
}

static int py_AUTHENTICATE_MESSAGE_set_EncryptedRandomSessionKeyLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->EncryptedRandomSessionKeyLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->EncryptedRandomSessionKeyLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->EncryptedRandomSessionKeyLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_EncryptedRandomSessionKeyMaxLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_EncryptedRandomSessionKeyMaxLen;
	py_EncryptedRandomSessionKeyMaxLen = PyLong_FromLong((uint16_t)(object->EncryptedRandomSessionKeyMaxLen));
	return py_EncryptedRandomSessionKeyMaxLen;
}

static int py_AUTHENTICATE_MESSAGE_set_EncryptedRandomSessionKeyMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->EncryptedRandomSessionKeyMaxLen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->EncryptedRandomSessionKeyMaxLen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->EncryptedRandomSessionKeyMaxLen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_EncryptedRandomSessionKey(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_EncryptedRandomSessionKey;
	if (object->EncryptedRandomSessionKey == NULL) {
		Py_RETURN_NONE;
	}
	if (object->EncryptedRandomSessionKey == NULL) {
		py_EncryptedRandomSessionKey = Py_None;
		Py_INCREF(py_EncryptedRandomSessionKey);
	} else {
		py_EncryptedRandomSessionKey = PyBytes_FromStringAndSize((char *)(*object->EncryptedRandomSessionKey).data, (*object->EncryptedRandomSessionKey).length);
	}
	return py_EncryptedRandomSessionKey;
}

static int py_AUTHENTICATE_MESSAGE_set_EncryptedRandomSessionKey(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->EncryptedRandomSessionKey));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->EncryptedRandomSessionKey");
		return -1;
	}
	if (value == Py_None) {
		object->EncryptedRandomSessionKey = NULL;
	} else {
		object->EncryptedRandomSessionKey = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->EncryptedRandomSessionKey);
		if (object->EncryptedRandomSessionKey == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->EncryptedRandomSessionKey = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_NegotiateFlags(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_NegotiateFlags;
	py_NegotiateFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->NegotiateFlags));
	return py_NegotiateFlags;
}

static int py_AUTHENTICATE_MESSAGE_set_NegotiateFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->NegotiateFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->NegotiateFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->NegotiateFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_Version(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = pyrpc_import_union(&ntlmssp_Version_Type, pytalloc_get_mem_ctx(obj), object->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION, &object->Version, "union ntlmssp_Version");
	if (py_Version == NULL) {
		return NULL;
	}
	return py_Version;
}

static int py_AUTHENTICATE_MESSAGE_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Version");
		return -1;
	}
	{
		union ntlmssp_Version *Version_switch_0;
		Version_switch_0 = (union ntlmssp_Version *)pyrpc_export_union(&ntlmssp_Version_Type, pytalloc_get_mem_ctx(py_obj), object->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION, value, "union ntlmssp_Version");
		if (Version_switch_0 == NULL) {
			return -1;
		}
		object->Version = *Version_switch_0;
	}
	return 0;
}

static PyGetSetDef py_AUTHENTICATE_MESSAGE_getsetters[] = {
	{
		.name = discard_const_p(char, "Signature"),
		.get = py_AUTHENTICATE_MESSAGE_get_Signature,
		.set = py_AUTHENTICATE_MESSAGE_set_Signature,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "MessageType"),
		.get = py_AUTHENTICATE_MESSAGE_get_MessageType,
		.set = py_AUTHENTICATE_MESSAGE_set_MessageType,
		.doc = discard_const_p(char, "PIDL-generated element of base type ntlmssp_MessageType")
	},
	{
		.name = discard_const_p(char, "LmChallengeResponseLen"),
		.get = py_AUTHENTICATE_MESSAGE_get_LmChallengeResponseLen,
		.set = py_AUTHENTICATE_MESSAGE_set_LmChallengeResponseLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "LmChallengeResponseMaxLen"),
		.get = py_AUTHENTICATE_MESSAGE_get_LmChallengeResponseMaxLen,
		.set = py_AUTHENTICATE_MESSAGE_set_LmChallengeResponseMaxLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "LmChallengeResponse"),
		.get = py_AUTHENTICATE_MESSAGE_get_LmChallengeResponse,
		.set = py_AUTHENTICATE_MESSAGE_set_LmChallengeResponse,
		.doc = discard_const_p(char, "PIDL-generated element of base type ntlmssp_LM_RESPONSE_with_len")
	},
	{
		.name = discard_const_p(char, "NtChallengeResponseLen"),
		.get = py_AUTHENTICATE_MESSAGE_get_NtChallengeResponseLen,
		.set = py_AUTHENTICATE_MESSAGE_set_NtChallengeResponseLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "NtChallengeResponseMaxLen"),
		.get = py_AUTHENTICATE_MESSAGE_get_NtChallengeResponseMaxLen,
		.set = py_AUTHENTICATE_MESSAGE_set_NtChallengeResponseMaxLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "NtChallengeResponse"),
		.get = py_AUTHENTICATE_MESSAGE_get_NtChallengeResponse,
		.set = py_AUTHENTICATE_MESSAGE_set_NtChallengeResponse,
		.doc = discard_const_p(char, "PIDL-generated element of base type ntlmssp_NTLM_RESPONSE_with_len")
	},
	{
		.name = discard_const_p(char, "DomainNameLen"),
		.get = py_AUTHENTICATE_MESSAGE_get_DomainNameLen,
		.set = py_AUTHENTICATE_MESSAGE_set_DomainNameLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "DomainNameMaxLen"),
		.get = py_AUTHENTICATE_MESSAGE_get_DomainNameMaxLen,
		.set = py_AUTHENTICATE_MESSAGE_set_DomainNameMaxLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "DomainName"),
		.get = py_AUTHENTICATE_MESSAGE_get_DomainName,
		.set = py_AUTHENTICATE_MESSAGE_set_DomainName,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "UserNameLen"),
		.get = py_AUTHENTICATE_MESSAGE_get_UserNameLen,
		.set = py_AUTHENTICATE_MESSAGE_set_UserNameLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "UserNameMaxLen"),
		.get = py_AUTHENTICATE_MESSAGE_get_UserNameMaxLen,
		.set = py_AUTHENTICATE_MESSAGE_set_UserNameMaxLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "UserName"),
		.get = py_AUTHENTICATE_MESSAGE_get_UserName,
		.set = py_AUTHENTICATE_MESSAGE_set_UserName,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "WorkstationLen"),
		.get = py_AUTHENTICATE_MESSAGE_get_WorkstationLen,
		.set = py_AUTHENTICATE_MESSAGE_set_WorkstationLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "WorkstationMaxLen"),
		.get = py_AUTHENTICATE_MESSAGE_get_WorkstationMaxLen,
		.set = py_AUTHENTICATE_MESSAGE_set_WorkstationMaxLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "Workstation"),
		.get = py_AUTHENTICATE_MESSAGE_get_Workstation,
		.set = py_AUTHENTICATE_MESSAGE_set_Workstation,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "EncryptedRandomSessionKeyLen"),
		.get = py_AUTHENTICATE_MESSAGE_get_EncryptedRandomSessionKeyLen,
		.set = py_AUTHENTICATE_MESSAGE_set_EncryptedRandomSessionKeyLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "EncryptedRandomSessionKeyMaxLen"),
		.get = py_AUTHENTICATE_MESSAGE_get_EncryptedRandomSessionKeyMaxLen,
		.set = py_AUTHENTICATE_MESSAGE_set_EncryptedRandomSessionKeyMaxLen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "EncryptedRandomSessionKey"),
		.get = py_AUTHENTICATE_MESSAGE_get_EncryptedRandomSessionKey,
		.set = py_AUTHENTICATE_MESSAGE_set_EncryptedRandomSessionKey,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "NegotiateFlags"),
		.get = py_AUTHENTICATE_MESSAGE_get_NegotiateFlags,
		.set = py_AUTHENTICATE_MESSAGE_set_NegotiateFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type NEGOTIATE")
	},
	{
		.name = discard_const_p(char, "Version"),
		.get = py_AUTHENTICATE_MESSAGE_get_Version,
		.set = py_AUTHENTICATE_MESSAGE_set_Version,
		.doc = discard_const_p(char, "PIDL-generated element of base type ntlmssp_Version")
	},
	{ .name = NULL }
};

static PyObject *py_AUTHENTICATE_MESSAGE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct AUTHENTICATE_MESSAGE, type);
}

static PyObject *py_AUTHENTICATE_MESSAGE_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_AUTHENTICATE_MESSAGE);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_AUTHENTICATE_MESSAGE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_AUTHENTICATE_MESSAGE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_AUTHENTICATE_MESSAGE);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_AUTHENTICATE_MESSAGE_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct AUTHENTICATE_MESSAGE *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_AUTHENTICATE_MESSAGE, "AUTHENTICATE_MESSAGE", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_AUTHENTICATE_MESSAGE, "AUTHENTICATE_MESSAGE", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_AUTHENTICATE_MESSAGE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_AUTHENTICATE_MESSAGE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_AUTHENTICATE_MESSAGE_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_AUTHENTICATE_MESSAGE_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject AUTHENTICATE_MESSAGE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.AUTHENTICATE_MESSAGE",
	.tp_getset = py_AUTHENTICATE_MESSAGE_getsetters,
	.tp_methods = py_AUTHENTICATE_MESSAGE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_AUTHENTICATE_MESSAGE_new,
};


static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_get_Version(PyObject *obj, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = PyLong_FromUnsignedLongLong((uint32_t)(object->Version));
	return py_Version;
}

static int py_NTLMSSP_MESSAGE_SIGNATURE_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_get_RandomPad(PyObject *obj, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_RandomPad;
	py_RandomPad = PyLong_FromUnsignedLongLong((uint32_t)(object->RandomPad));
	return py_RandomPad;
}

static int py_NTLMSSP_MESSAGE_SIGNATURE_set_RandomPad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->RandomPad");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->RandomPad));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->RandomPad = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_get_Checksum(PyObject *obj, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_Checksum;
	py_Checksum = PyLong_FromUnsignedLongLong((uint32_t)(object->Checksum));
	return py_Checksum;
}

static int py_NTLMSSP_MESSAGE_SIGNATURE_set_Checksum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Checksum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Checksum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Checksum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_get_SeqNum(PyObject *obj, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_SeqNum;
	py_SeqNum = PyLong_FromUnsignedLongLong((uint32_t)(object->SeqNum));
	return py_SeqNum;
}

static int py_NTLMSSP_MESSAGE_SIGNATURE_set_SeqNum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SeqNum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SeqNum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SeqNum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_NTLMSSP_MESSAGE_SIGNATURE_getsetters[] = {
	{
		.name = discard_const_p(char, "Version"),
		.get = py_NTLMSSP_MESSAGE_SIGNATURE_get_Version,
		.set = py_NTLMSSP_MESSAGE_SIGNATURE_set_Version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "RandomPad"),
		.get = py_NTLMSSP_MESSAGE_SIGNATURE_get_RandomPad,
		.set = py_NTLMSSP_MESSAGE_SIGNATURE_set_RandomPad,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "Checksum"),
		.get = py_NTLMSSP_MESSAGE_SIGNATURE_get_Checksum,
		.set = py_NTLMSSP_MESSAGE_SIGNATURE_set_Checksum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "SeqNum"),
		.get = py_NTLMSSP_MESSAGE_SIGNATURE_get_SeqNum,
		.set = py_NTLMSSP_MESSAGE_SIGNATURE_set_SeqNum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NTLMSSP_MESSAGE_SIGNATURE, type);
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_NTLMSSP_MESSAGE_SIGNATURE);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NTLMSSP_MESSAGE_SIGNATURE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NTLMSSP_MESSAGE_SIGNATURE);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NTLMSSP_MESSAGE_SIGNATURE, "NTLMSSP_MESSAGE_SIGNATURE", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NTLMSSP_MESSAGE_SIGNATURE, "NTLMSSP_MESSAGE_SIGNATURE", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NTLMSSP_MESSAGE_SIGNATURE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NTLMSSP_MESSAGE_SIGNATURE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NTLMSSP_MESSAGE_SIGNATURE_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NTLMSSP_MESSAGE_SIGNATURE_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NTLMSSP_MESSAGE_SIGNATURE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.NTLMSSP_MESSAGE_SIGNATURE",
	.tp_getset = py_NTLMSSP_MESSAGE_SIGNATURE_getsetters,
	.tp_methods = py_NTLMSSP_MESSAGE_SIGNATURE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NTLMSSP_MESSAGE_SIGNATURE_new,
};


static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_get_Version(PyObject *obj, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = pytalloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = PyLong_FromUnsignedLongLong((uint32_t)(object->Version));
	return py_Version;
}

static int py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_get_Checksum(PyObject *obj, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = pytalloc_get_ptr(obj);
	PyObject *py_Checksum;
	py_Checksum = PyList_New(8);
	if (py_Checksum == NULL) {
		return NULL;
	}
	{
		int Checksum_cntr_0;
		for (Checksum_cntr_0 = 0; Checksum_cntr_0 < (8); Checksum_cntr_0++) {
			PyObject *py_Checksum_0;
			py_Checksum_0 = PyLong_FromLong((uint16_t)((object->Checksum)[Checksum_cntr_0]));
			PyList_SetItem(py_Checksum, Checksum_cntr_0, py_Checksum_0);
		}
	}
	return py_Checksum;
}

static int py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_set_Checksum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Checksum");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Checksum_cntr_0;
		if (ARRAY_SIZE(object->Checksum) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->Checksum),  PyList_GET_SIZE(value));
			return -1;
		}
		for (Checksum_cntr_0 = 0; Checksum_cntr_0 < PyList_GET_SIZE(value); Checksum_cntr_0++) {
			if (PyList_GET_ITEM(value, Checksum_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->Checksum)[Checksum_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->Checksum)[Checksum_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, Checksum_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, Checksum_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->Checksum)[Checksum_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_get_SeqNum(PyObject *obj, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = pytalloc_get_ptr(obj);
	PyObject *py_SeqNum;
	py_SeqNum = PyLong_FromUnsignedLongLong((uint32_t)(object->SeqNum));
	return py_SeqNum;
}

static int py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_set_SeqNum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SeqNum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SeqNum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SeqNum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_getsetters[] = {
	{
		.name = discard_const_p(char, "Version"),
		.get = py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_get_Version,
		.set = py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_set_Version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "Checksum"),
		.get = py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_get_Checksum,
		.set = py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_set_Checksum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "SeqNum"),
		.get = py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_get_SeqNum,
		.set = py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_set_SeqNum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2, type);
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2, "NTLMSSP_MESSAGE_SIGNATURE_NTLMv2", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2, "NTLMSSP_MESSAGE_SIGNATURE_NTLMv2", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.NTLMSSP_MESSAGE_SIGNATURE_NTLMv2",
	.tp_getset = py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_getsetters,
	.tp_methods = py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_new,
};


const struct PyNdrRpcMethodDef py_ndr_ntlmssp_methods[] = {
	{
		.name = NULL,
	},
};

static PyObject *interface_ntlmssp_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_ntlmssp);
}

#define PY_DOC_NTLMSSP "NTLM messages"
static PyTypeObject ntlmssp_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.ntlmssp",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "ntlmssp(binding, lp_ctx=None, credentials=None, basis_connection=None) -> connection\n"
"\n\n"
"Parameters\n"
"----------\n"
"binding : str\n"
"    A DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx : param.LoadParm\n"
"    Should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials : credentials.Credentials, optional\n"
"    A credentials.Credentials object (default is None).\n"
"basis_connection : samba.dcerpc.ClientConnection, optional\n"
"    A ntlmssp client connection object (default is None).\n"
"\n\n"
"Returns\n"
"-------\n"
"samba.dcerpc.ClientConnection\n"
"    A ClientConnection object\n"
"\n\n"
"Raises\n"
"------\n"
"samba.NTSTATUSError\n"
"    An NTSTATUS error\n"
"\n"PY_DOC_NTLMSSP,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_ntlmssp_new,
};

static PyObject *syntax_ntlmssp_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_ntlmssp.syntax_id);
}

#define PY_DOC_NTLMSSP_SYNTAX "NTLM messages"
static PyTypeObject ntlmssp_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "ntlmssp.ntlmssp_abstract_syntax",
	.tp_doc = "ntlmssp_abstract_syntax()\n"PY_DOC_NTLMSSP_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_ntlmssp_new,
};

static PyMethodDef ntlmssp_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "ntlmssp",
	.m_doc = "ntlmssp DCE/RPC",
	.m_size = -1,
	.m_methods = ntlmssp_methods,
};
MODULE_INIT_FUNC(ntlmssp)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_security = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	LSAP_TOKEN_INFO_INTEGRITY_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "LSAP_TOKEN_INFO_INTEGRITY");
	if (LSAP_TOKEN_INFO_INTEGRITY_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	ntlmssp_VERSION_Type.tp_base = BaseObject_Type;
	ntlmssp_VERSION_Type.tp_basicsize = pytalloc_BaseObject_size();

	ntlmssp_Version_Type.tp_base = BaseObject_Type;
	ntlmssp_Version_Type.tp_basicsize = pytalloc_BaseObject_size();

	NEGOTIATE_MESSAGE_Type.tp_base = BaseObject_Type;
	NEGOTIATE_MESSAGE_Type.tp_basicsize = pytalloc_BaseObject_size();

	ntlmssp_SingleHostData_Type.tp_base = BaseObject_Type;
	ntlmssp_SingleHostData_Type.tp_basicsize = pytalloc_BaseObject_size();

	ntlmssp_AvValue_Type.tp_base = BaseObject_Type;
	ntlmssp_AvValue_Type.tp_basicsize = pytalloc_BaseObject_size();

	AV_PAIR_Type.tp_base = BaseObject_Type;
	AV_PAIR_Type.tp_basicsize = pytalloc_BaseObject_size();

	AV_PAIR_LIST_Type.tp_base = BaseObject_Type;
	AV_PAIR_LIST_Type.tp_basicsize = pytalloc_BaseObject_size();

	CHALLENGE_MESSAGE_Type.tp_base = BaseObject_Type;
	CHALLENGE_MESSAGE_Type.tp_basicsize = pytalloc_BaseObject_size();

	LM_RESPONSE_Type.tp_base = BaseObject_Type;
	LM_RESPONSE_Type.tp_basicsize = pytalloc_BaseObject_size();

	LMv2_RESPONSE_Type.tp_base = BaseObject_Type;
	LMv2_RESPONSE_Type.tp_basicsize = pytalloc_BaseObject_size();

	ntlmssp_LM_RESPONSE_with_len_Type.tp_base = BaseObject_Type;
	ntlmssp_LM_RESPONSE_with_len_Type.tp_basicsize = pytalloc_BaseObject_size();

	NTLM_RESPONSE_Type.tp_base = BaseObject_Type;
	NTLM_RESPONSE_Type.tp_basicsize = pytalloc_BaseObject_size();

	NTLMv2_CLIENT_CHALLENGE_Type.tp_base = BaseObject_Type;
	NTLMv2_CLIENT_CHALLENGE_Type.tp_basicsize = pytalloc_BaseObject_size();

	NTLMv2_RESPONSE_Type.tp_base = BaseObject_Type;
	NTLMv2_RESPONSE_Type.tp_basicsize = pytalloc_BaseObject_size();

	ntlmssp_NTLM_RESPONSE_with_len_Type.tp_base = BaseObject_Type;
	ntlmssp_NTLM_RESPONSE_with_len_Type.tp_basicsize = pytalloc_BaseObject_size();

	ntlmssp_MIC_Type.tp_base = BaseObject_Type;
	ntlmssp_MIC_Type.tp_basicsize = pytalloc_BaseObject_size();

	AUTHENTICATE_MESSAGE_Type.tp_base = BaseObject_Type;
	AUTHENTICATE_MESSAGE_Type.tp_basicsize = pytalloc_BaseObject_size();

	NTLMSSP_MESSAGE_SIGNATURE_Type.tp_base = BaseObject_Type;
	NTLMSSP_MESSAGE_SIGNATURE_Type.tp_basicsize = pytalloc_BaseObject_size();

	NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_Type.tp_base = BaseObject_Type;
	NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_Type.tp_basicsize = pytalloc_BaseObject_size();

	ntlmssp_InterfaceType.tp_base = ClientConnection_Type;

	ntlmssp_SyntaxType.tp_base = ndr_syntax_id_Type;
	ntlmssp_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&ntlmssp_VERSION_Type) < 0)
		goto out;
	if (PyType_Ready(&ntlmssp_Version_Type) < 0)
		goto out;
	if (PyType_Ready(&NEGOTIATE_MESSAGE_Type) < 0)
		goto out;
	if (PyType_Ready(&ntlmssp_SingleHostData_Type) < 0)
		goto out;
	if (PyType_Ready(&ntlmssp_AvValue_Type) < 0)
		goto out;
	if (PyType_Ready(&AV_PAIR_Type) < 0)
		goto out;
	if (PyType_Ready(&AV_PAIR_LIST_Type) < 0)
		goto out;
	if (PyType_Ready(&CHALLENGE_MESSAGE_Type) < 0)
		goto out;
	if (PyType_Ready(&LM_RESPONSE_Type) < 0)
		goto out;
	if (PyType_Ready(&LMv2_RESPONSE_Type) < 0)
		goto out;
	if (PyType_Ready(&ntlmssp_LM_RESPONSE_with_len_Type) < 0)
		goto out;
	if (PyType_Ready(&NTLM_RESPONSE_Type) < 0)
		goto out;
	if (PyType_Ready(&NTLMv2_CLIENT_CHALLENGE_Type) < 0)
		goto out;
	if (PyType_Ready(&NTLMv2_RESPONSE_Type) < 0)
		goto out;
	if (PyType_Ready(&ntlmssp_NTLM_RESPONSE_with_len_Type) < 0)
		goto out;
	if (PyType_Ready(&ntlmssp_MIC_Type) < 0)
		goto out;
	if (PyType_Ready(&AUTHENTICATE_MESSAGE_Type) < 0)
		goto out;
	if (PyType_Ready(&NTLMSSP_MESSAGE_SIGNATURE_Type) < 0)
		goto out;
	if (PyType_Ready(&NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_Type) < 0)
		goto out;
	if (PyType_Ready(&ntlmssp_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&ntlmssp_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&ntlmssp_InterfaceType, py_ndr_ntlmssp_methods))
		return NULL;

#ifdef PY_VERSION_PATCH
	PY_VERSION_PATCH(&ntlmssp_VERSION_Type);
#endif
#ifdef PY_VERSION_PATCH
	PY_VERSION_PATCH(&ntlmssp_Version_Type);
#endif
#ifdef PY_NEGOTIATE_MESSAGE_PATCH
	PY_NEGOTIATE_MESSAGE_PATCH(&NEGOTIATE_MESSAGE_Type);
#endif
#ifdef PY_SINGLEHOSTDATA_PATCH
	PY_SINGLEHOSTDATA_PATCH(&ntlmssp_SingleHostData_Type);
#endif
#ifdef PY_AVVALUE_PATCH
	PY_AVVALUE_PATCH(&ntlmssp_AvValue_Type);
#endif
#ifdef PY_AV_PAIR_PATCH
	PY_AV_PAIR_PATCH(&AV_PAIR_Type);
#endif
#ifdef PY_AV_PAIR_LIST_PATCH
	PY_AV_PAIR_LIST_PATCH(&AV_PAIR_LIST_Type);
#endif
#ifdef PY_CHALLENGE_MESSAGE_PATCH
	PY_CHALLENGE_MESSAGE_PATCH(&CHALLENGE_MESSAGE_Type);
#endif
#ifdef PY_LM_RESPONSE_PATCH
	PY_LM_RESPONSE_PATCH(&LM_RESPONSE_Type);
#endif
#ifdef PY_LMV2_RESPONSE_PATCH
	PY_LMV2_RESPONSE_PATCH(&LMv2_RESPONSE_Type);
#endif
#ifdef PY_LM_RESPONSE_WITH_LEN_PATCH
	PY_LM_RESPONSE_WITH_LEN_PATCH(&ntlmssp_LM_RESPONSE_with_len_Type);
#endif
#ifdef PY_NTLM_RESPONSE_PATCH
	PY_NTLM_RESPONSE_PATCH(&NTLM_RESPONSE_Type);
#endif
#ifdef PY_NTLMV2_CLIENT_CHALLENGE_PATCH
	PY_NTLMV2_CLIENT_CHALLENGE_PATCH(&NTLMv2_CLIENT_CHALLENGE_Type);
#endif
#ifdef PY_NTLMV2_RESPONSE_PATCH
	PY_NTLMV2_RESPONSE_PATCH(&NTLMv2_RESPONSE_Type);
#endif
#ifdef PY_NTLM_RESPONSE_WITH_LEN_PATCH
	PY_NTLM_RESPONSE_WITH_LEN_PATCH(&ntlmssp_NTLM_RESPONSE_with_len_Type);
#endif
#ifdef PY_MIC_PATCH
	PY_MIC_PATCH(&ntlmssp_MIC_Type);
#endif
#ifdef PY_AUTHENTICATE_MESSAGE_PATCH
	PY_AUTHENTICATE_MESSAGE_PATCH(&AUTHENTICATE_MESSAGE_Type);
#endif
#ifdef PY_NTLMSSP_MESSAGE_SIGNATURE_PATCH
	PY_NTLMSSP_MESSAGE_SIGNATURE_PATCH(&NTLMSSP_MESSAGE_SIGNATURE_Type);
#endif
#ifdef PY_NTLMSSP_MESSAGE_SIGNATURE_NTLMV2_PATCH
	PY_NTLMSSP_MESSAGE_SIGNATURE_NTLMV2_PATCH(&NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_Type);
#endif
#ifdef PY_NTLMSSP_PATCH
	PY_NTLMSSP_PATCH(&ntlmssp_InterfaceType);
#endif
#ifdef PY_NTLMSSP_ABSTRACT_SYNTAX_PATCH
	PY_NTLMSSP_ABSTRACT_SYNTAX_PATCH(&ntlmssp_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&ntlmssp_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_NTLM2", PyLong_FromLong(NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY));
	PyModule_AddObject(m, "NTLMSSP_MIC_OFFSET", PyLong_FromUnsignedLongLong(72));
	PyModule_AddObject(m, "NTLMSSP_MIC_SIZE", PyLong_FromUnsignedLongLong(16));
	PyModule_AddObject(m, "NTLMSSP_SIGN_VERSION", PyLong_FromUnsignedLongLong(0x01));
	PyModule_AddObject(m, "NTLMSSP_SIG_SIZE", PyLong_FromUnsignedLongLong(16));
	PyModule_AddObject(m, "NtLmNegotiate", PyLong_FromUnsignedLongLong((uint32_t)(NtLmNegotiate)));
	PyModule_AddObject(m, "NtLmChallenge", PyLong_FromUnsignedLongLong((uint32_t)(NtLmChallenge)));
	PyModule_AddObject(m, "NtLmAuthenticate", PyLong_FromUnsignedLongLong((uint32_t)(NtLmAuthenticate)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_UNICODE", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_UNICODE)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_OEM", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_OEM)));
	PyModule_AddObject(m, "NTLMSSP_REQUEST_TARGET", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_REQUEST_TARGET)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_SIGN", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_SIGN)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_SEAL", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_SEAL)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_DATAGRAM", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_DATAGRAM)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_LM_KEY", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_LM_KEY)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_NETWARE", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_NETWARE)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_NTLM", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_NTLM)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_NT_ONLY", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_NT_ONLY)));
	PyModule_AddObject(m, "NTLMSSP_ANONYMOUS", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_ANONYMOUS)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_OEM_DOMAIN_SUPPLIED", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_OEM_DOMAIN_SUPPLIED)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_OEM_WORKSTATION_SUPPLIED", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_OEM_WORKSTATION_SUPPLIED)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_THIS_IS_LOCAL_CALL", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_THIS_IS_LOCAL_CALL)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_ALWAYS_SIGN", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_ALWAYS_SIGN)));
	PyModule_AddObject(m, "NTLMSSP_TARGET_TYPE_DOMAIN", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_TARGET_TYPE_DOMAIN)));
	PyModule_AddObject(m, "NTLMSSP_TARGET_TYPE_SERVER", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_TARGET_TYPE_SERVER)));
	PyModule_AddObject(m, "NTLMSSP_TARGET_TYPE_SHARE", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_TARGET_TYPE_SHARE)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_IDENTIFY", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_IDENTIFY)));
	PyModule_AddObject(m, "NTLMSSP_REQUEST_NON_NT_SESSION_KEY", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_REQUEST_NON_NT_SESSION_KEY)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_TARGET_INFO", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_TARGET_INFO)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_VERSION", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_VERSION)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_128", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_128)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_KEY_EXCH", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_KEY_EXCH)));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_56", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_NEGOTIATE_56)));
	PyModule_AddObject(m, "NTLMSSP_WINDOWS_MAJOR_VERSION_5", PyLong_FromLong((uint16_t)(NTLMSSP_WINDOWS_MAJOR_VERSION_5)));
	PyModule_AddObject(m, "NTLMSSP_WINDOWS_MAJOR_VERSION_6", PyLong_FromLong((uint16_t)(NTLMSSP_WINDOWS_MAJOR_VERSION_6)));
	PyModule_AddObject(m, "NTLMSSP_WINDOWS_MAJOR_VERSION_10", PyLong_FromLong((uint16_t)(NTLMSSP_WINDOWS_MAJOR_VERSION_10)));
	PyModule_AddObject(m, "NTLMSSP_WINDOWS_MINOR_VERSION_0", PyLong_FromLong((uint16_t)(NTLMSSP_WINDOWS_MINOR_VERSION_0)));
	PyModule_AddObject(m, "NTLMSSP_WINDOWS_MINOR_VERSION_1", PyLong_FromLong((uint16_t)(NTLMSSP_WINDOWS_MINOR_VERSION_1)));
	PyModule_AddObject(m, "NTLMSSP_WINDOWS_MINOR_VERSION_2", PyLong_FromLong((uint16_t)(NTLMSSP_WINDOWS_MINOR_VERSION_2)));
	PyModule_AddObject(m, "NTLMSSP_WINDOWS_MINOR_VERSION_3", PyLong_FromLong((uint16_t)(NTLMSSP_WINDOWS_MINOR_VERSION_3)));
	PyModule_AddObject(m, "NTLMSSP_REVISION_W2K3_RC1", PyLong_FromLong((uint16_t)(NTLMSSP_REVISION_W2K3_RC1)));
	PyModule_AddObject(m, "NTLMSSP_REVISION_W2K3", PyLong_FromLong((uint16_t)(NTLMSSP_REVISION_W2K3)));
	PyModule_AddObject(m, "MsvAvEOL", PyLong_FromLong((uint16_t)(MsvAvEOL)));
	PyModule_AddObject(m, "MsvAvNbComputerName", PyLong_FromLong((uint16_t)(MsvAvNbComputerName)));
	PyModule_AddObject(m, "MsvAvNbDomainName", PyLong_FromLong((uint16_t)(MsvAvNbDomainName)));
	PyModule_AddObject(m, "MsvAvDnsComputerName", PyLong_FromLong((uint16_t)(MsvAvDnsComputerName)));
	PyModule_AddObject(m, "MsvAvDnsDomainName", PyLong_FromLong((uint16_t)(MsvAvDnsDomainName)));
	PyModule_AddObject(m, "MsvAvDnsTreeName", PyLong_FromLong((uint16_t)(MsvAvDnsTreeName)));
	PyModule_AddObject(m, "MsvAvFlags", PyLong_FromLong((uint16_t)(MsvAvFlags)));
	PyModule_AddObject(m, "MsvAvTimestamp", PyLong_FromLong((uint16_t)(MsvAvTimestamp)));
	PyModule_AddObject(m, "MsvAvSingleHost", PyLong_FromLong((uint16_t)(MsvAvSingleHost)));
	PyModule_AddObject(m, "MsvAvTargetName", PyLong_FromLong((uint16_t)(MsvAvTargetName)));
	PyModule_AddObject(m, "MsvChannelBindings", PyLong_FromLong((uint16_t)(MsvChannelBindings)));
	PyModule_AddObject(m, "NTLMSSP_AVFLAG_CONSTRAINTED_ACCOUNT", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_AVFLAG_CONSTRAINTED_ACCOUNT)));
	PyModule_AddObject(m, "NTLMSSP_AVFLAG_MIC_IN_AUTHENTICATE_MESSAGE", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_AVFLAG_MIC_IN_AUTHENTICATE_MESSAGE)));
	PyModule_AddObject(m, "NTLMSSP_AVFLAG_TARGET_SPN_FROM_UNTRUSTED_SOURCE", PyLong_FromUnsignedLongLong((uint32_t)(NTLMSSP_AVFLAG_TARGET_SPN_FROM_UNTRUSTED_SOURCE)));
	Py_INCREF((PyObject *)(void *)&ntlmssp_VERSION_Type);
	PyModule_AddObject(m, "VERSION", (PyObject *)(void *)&ntlmssp_VERSION_Type);
	Py_INCREF((PyObject *)(void *)&ntlmssp_Version_Type);
	PyModule_AddObject(m, "Version", (PyObject *)(void *)&ntlmssp_Version_Type);
	Py_INCREF((PyObject *)(void *)&NEGOTIATE_MESSAGE_Type);
	PyModule_AddObject(m, "NEGOTIATE_MESSAGE", (PyObject *)(void *)&NEGOTIATE_MESSAGE_Type);
	Py_INCREF((PyObject *)(void *)&ntlmssp_SingleHostData_Type);
	PyModule_AddObject(m, "SingleHostData", (PyObject *)(void *)&ntlmssp_SingleHostData_Type);
	Py_INCREF((PyObject *)(void *)&ntlmssp_AvValue_Type);
	PyModule_AddObject(m, "AvValue", (PyObject *)(void *)&ntlmssp_AvValue_Type);
	Py_INCREF((PyObject *)(void *)&AV_PAIR_Type);
	PyModule_AddObject(m, "AV_PAIR", (PyObject *)(void *)&AV_PAIR_Type);
	Py_INCREF((PyObject *)(void *)&AV_PAIR_LIST_Type);
	PyModule_AddObject(m, "AV_PAIR_LIST", (PyObject *)(void *)&AV_PAIR_LIST_Type);
	Py_INCREF((PyObject *)(void *)&CHALLENGE_MESSAGE_Type);
	PyModule_AddObject(m, "CHALLENGE_MESSAGE", (PyObject *)(void *)&CHALLENGE_MESSAGE_Type);
	Py_INCREF((PyObject *)(void *)&LM_RESPONSE_Type);
	PyModule_AddObject(m, "LM_RESPONSE", (PyObject *)(void *)&LM_RESPONSE_Type);
	Py_INCREF((PyObject *)(void *)&LMv2_RESPONSE_Type);
	PyModule_AddObject(m, "LMv2_RESPONSE", (PyObject *)(void *)&LMv2_RESPONSE_Type);
	Py_INCREF((PyObject *)(void *)&ntlmssp_LM_RESPONSE_with_len_Type);
	PyModule_AddObject(m, "LM_RESPONSE_with_len", (PyObject *)(void *)&ntlmssp_LM_RESPONSE_with_len_Type);
	Py_INCREF((PyObject *)(void *)&NTLM_RESPONSE_Type);
	PyModule_AddObject(m, "NTLM_RESPONSE", (PyObject *)(void *)&NTLM_RESPONSE_Type);
	Py_INCREF((PyObject *)(void *)&NTLMv2_CLIENT_CHALLENGE_Type);
	PyModule_AddObject(m, "NTLMv2_CLIENT_CHALLENGE", (PyObject *)(void *)&NTLMv2_CLIENT_CHALLENGE_Type);
	Py_INCREF((PyObject *)(void *)&NTLMv2_RESPONSE_Type);
	PyModule_AddObject(m, "NTLMv2_RESPONSE", (PyObject *)(void *)&NTLMv2_RESPONSE_Type);
	Py_INCREF((PyObject *)(void *)&ntlmssp_NTLM_RESPONSE_with_len_Type);
	PyModule_AddObject(m, "NTLM_RESPONSE_with_len", (PyObject *)(void *)&ntlmssp_NTLM_RESPONSE_with_len_Type);
	Py_INCREF((PyObject *)(void *)&ntlmssp_MIC_Type);
	PyModule_AddObject(m, "MIC", (PyObject *)(void *)&ntlmssp_MIC_Type);
	Py_INCREF((PyObject *)(void *)&AUTHENTICATE_MESSAGE_Type);
	PyModule_AddObject(m, "AUTHENTICATE_MESSAGE", (PyObject *)(void *)&AUTHENTICATE_MESSAGE_Type);
	Py_INCREF((PyObject *)(void *)&NTLMSSP_MESSAGE_SIGNATURE_Type);
	PyModule_AddObject(m, "NTLMSSP_MESSAGE_SIGNATURE", (PyObject *)(void *)&NTLMSSP_MESSAGE_SIGNATURE_Type);
	Py_INCREF((PyObject *)(void *)&NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_Type);
	PyModule_AddObject(m, "NTLMSSP_MESSAGE_SIGNATURE_NTLMv2", (PyObject *)(void *)&NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_Type);
	Py_INCREF((PyObject *)(void *)&ntlmssp_InterfaceType);
	PyModule_AddObject(m, "ntlmssp", (PyObject *)(void *)&ntlmssp_InterfaceType);
	Py_INCREF((PyObject *)(void *)&ntlmssp_SyntaxType);
	PyModule_AddObject(m, "ntlmssp_abstract_syntax", (PyObject *)(void *)&ntlmssp_SyntaxType);
	Py_INCREF((PyObject *)(void *)&ntlmssp_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&ntlmssp_SyntaxType);
#ifdef PY_MOD_NTLMSSP_PATCH
	PY_MOD_NTLMSSP_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_security);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	Py_XDECREF(dep_samba_dcerpc_misc);
	return m;

}
