/* ViewCollection.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ViewCollection.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* A ViewCollection holds DataView objects, which are view instances wrapping DataSource objects.*/
/* Thus, multiple views can exist of a single SourceCollection, each view displaying all or some*/
/* of that SourceCollection.  A view collection also has a notion of order*/
/* (first/last/next/previous) that can be overridden by child classes.  It also understands hidden*/
/* objects, which are withheld entirely from the collection until they're made visible.  Currently*/
/* the only way to hide objects is with a ViewFilter.*/
/**/
/* A ViewCollection may also be locked.  When locked, it will not (a) remove hidden items from the*/
/* collection and (b) remove DataViews representing unlinked DataSources.  This allows for the*/
/* ViewCollection to be "frozen" while manipulating items within it.  When the collection is*/
/* unlocked, all changes are applied at once.*/
/**/
/* The default implementation provides a browser which orders the view in the order they're*/
/* stored in DataCollection, which is not specified.*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
typedef gint64 (*Comparator) (void* a, void* b, gpointer user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, gpointer user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, gpointer user_data);

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;
typedef struct _ViewCollectionPrivate ViewCollectionPrivate;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;

#define TYPE_VIEW_FILTER (view_filter_get_type ())
#define VIEW_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_FILTER, ViewFilter))
#define VIEW_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_FILTER, ViewFilterClass))
#define IS_VIEW_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_FILTER))
#define IS_VIEW_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_FILTER))
#define VIEW_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_FILTER, ViewFilterClass))

typedef struct _ViewFilter ViewFilter;
typedef struct _ViewFilterClass ViewFilterClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define VIEW_COLLECTION_TYPE_MONITOR (view_collection_monitor_get_type ())
#define VIEW_COLLECTION_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIEW_COLLECTION_TYPE_MONITOR, ViewCollectionMonitor))
#define VIEW_COLLECTION_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIEW_COLLECTION_TYPE_MONITOR, ViewCollectionMonitorClass))
#define VIEW_COLLECTION_IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIEW_COLLECTION_TYPE_MONITOR))
#define VIEW_COLLECTION_IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIEW_COLLECTION_TYPE_MONITOR))
#define VIEW_COLLECTION_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIEW_COLLECTION_TYPE_MONITOR, ViewCollectionMonitorClass))

typedef struct _ViewCollectionMonitor ViewCollectionMonitor;
typedef struct _ViewCollectionMonitorClass ViewCollectionMonitorClass;

#define VIEW_COLLECTION_TYPE_MONITOR_IMPL (view_collection_monitor_impl_get_type ())
#define VIEW_COLLECTION_MONITOR_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIEW_COLLECTION_TYPE_MONITOR_IMPL, ViewCollectionMonitorImpl))
#define VIEW_COLLECTION_MONITOR_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIEW_COLLECTION_TYPE_MONITOR_IMPL, ViewCollectionMonitorImplClass))
#define VIEW_COLLECTION_IS_MONITOR_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIEW_COLLECTION_TYPE_MONITOR_IMPL))
#define VIEW_COLLECTION_IS_MONITOR_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIEW_COLLECTION_TYPE_MONITOR_IMPL))
#define VIEW_COLLECTION_MONITOR_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIEW_COLLECTION_TYPE_MONITOR_IMPL, ViewCollectionMonitorImplClass))

typedef struct _ViewCollectionMonitorImpl ViewCollectionMonitorImpl;
typedef struct _ViewCollectionMonitorImplClass ViewCollectionMonitorImplClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef DataView* (*CreateView) (DataSource* source, gpointer user_data);
typedef gboolean (*CreateViewPredicate) (DataSource* source, gpointer user_data);

#define TYPE_DATA_SET (data_set_get_type ())
#define DATA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SET, DataSet))
#define DATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SET, DataSetClass))
#define IS_DATA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SET))
#define IS_DATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SET))
#define DATA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SET, DataSetClass))

typedef struct _DataSet DataSet;
typedef struct _DataSetClass DataSetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _data_set_unref0(var) ((var == NULL) ? NULL : (var = (data_set_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _view_filter_unref0(var) ((var == NULL) ? NULL : (var = (view_filter_unref (var), NULL)))

#define TYPE_VIEW_MANAGER (view_manager_get_type ())
#define VIEW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_MANAGER, ViewManager))
#define VIEW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_MANAGER, ViewManagerClass))
#define IS_VIEW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_MANAGER))
#define IS_VIEW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_MANAGER))
#define VIEW_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_MANAGER, ViewManagerClass))

typedef struct _ViewManager ViewManager;
typedef struct _ViewManagerClass ViewManagerClass;
typedef struct _ViewCollectionMonitorPrivate ViewCollectionMonitorPrivate;
typedef struct _ViewCollectionMonitorImplPrivate ViewCollectionMonitorImplPrivate;
#define _view_collection_monitor_unref0(var) ((var == NULL) ? NULL : (var = (view_collection_monitor_unref (var), NULL)))

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;

#define TYPE_PHOTO_VIEW (photo_view_get_type ())
#define PHOTO_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_VIEW, PhotoView))
#define PHOTO_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_VIEW, PhotoViewClass))
#define IS_PHOTO_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_VIEW))
#define IS_PHOTO_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_VIEW))
#define PHOTO_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_VIEW, PhotoViewClass))

typedef struct _PhotoView PhotoView;
typedef struct _PhotoViewClass PhotoViewClass;
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

#define TYPE_RATING (rating_get_type ())
typedef gboolean (*MarkedAction) (DataObject* object, GObject* user, gpointer user_data);

#define VIEW_COLLECTION_TYPE_TOGGLE_LISTS (view_collection_toggle_lists_get_type ())
#define VIEW_COLLECTION_TOGGLE_LISTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIEW_COLLECTION_TYPE_TOGGLE_LISTS, ViewCollectionToggleLists))
#define VIEW_COLLECTION_TOGGLE_LISTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIEW_COLLECTION_TYPE_TOGGLE_LISTS, ViewCollectionToggleListsClass))
#define VIEW_COLLECTION_IS_TOGGLE_LISTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIEW_COLLECTION_TYPE_TOGGLE_LISTS))
#define VIEW_COLLECTION_IS_TOGGLE_LISTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIEW_COLLECTION_TYPE_TOGGLE_LISTS))
#define VIEW_COLLECTION_TOGGLE_LISTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIEW_COLLECTION_TYPE_TOGGLE_LISTS, ViewCollectionToggleListsClass))

typedef struct _ViewCollectionToggleLists ViewCollectionToggleLists;
typedef struct _ViewCollectionToggleListsClass ViewCollectionToggleListsClass;
typedef struct _ViewCollectionToggleListsPrivate ViewCollectionToggleListsPrivate;
typedef struct _ViewCollectionParamSpecMonitor ViewCollectionParamSpecMonitor;
#define _view_manager_unref0(var) ((var == NULL) ? NULL : (var = (view_manager_unref (var), NULL)))
enum  {
	VIEW_COLLECTION_TOGGLE_LISTS_0_PROPERTY,
	VIEW_COLLECTION_TOGGLE_LISTS_NUM_PROPERTIES
};
static GParamSpec* view_collection_toggle_lists_properties[VIEW_COLLECTION_TOGGLE_LISTS_NUM_PROPERTIES];
enum  {
	VIEW_COLLECTION_ITEMS_SELECTED_SIGNAL,
	VIEW_COLLECTION_ITEMS_UNSELECTED_SIGNAL,
	VIEW_COLLECTION_ITEMS_STATE_CHANGED_SIGNAL,
	VIEW_COLLECTION_SELECTION_GROUP_ALTERED_SIGNAL,
	VIEW_COLLECTION_ITEMS_SHOWN_SIGNAL,
	VIEW_COLLECTION_ITEMS_HIDDEN_SIGNAL,
	VIEW_COLLECTION_ITEMS_VISIBILITY_CHANGED_SIGNAL,
	VIEW_COLLECTION_ITEM_VIEW_ALTERED_SIGNAL,
	VIEW_COLLECTION_ITEM_GEOMETRY_ALTERED_SIGNAL,
	VIEW_COLLECTION_VIEWS_ALTERED_SIGNAL,
	VIEW_COLLECTION_GEOMETRIES_ALTERED_SIGNAL,
	VIEW_COLLECTION_VIEW_FILTER_INSTALLED_SIGNAL,
	VIEW_COLLECTION_VIEW_FILTER_REMOVED_SIGNAL,
	VIEW_COLLECTION_NUM_SIGNALS
};
static guint view_collection_signals[VIEW_COLLECTION_NUM_SIGNALS] = {0};
typedef struct _ViewManagerPrivate ViewManagerPrivate;
typedef struct _ParamSpecViewManager ParamSpecViewManager;
typedef struct _ViewFilterPrivate ViewFilterPrivate;
typedef struct _ParamSpecViewFilter ParamSpecViewFilter;
enum  {
	VIEW_FILTER_REFRESH_SIGNAL,
	VIEW_FILTER_NUM_SIGNALS
};
static guint view_filter_signals[VIEW_FILTER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, gpointer comparator_target, ComparatorPredicate predicate, gpointer predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, gpointer monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _ViewCollection {
	DataCollection parent_instance;
	ViewCollectionPrivate * priv;
};

struct _ViewCollectionClass {
	DataCollectionClass parent_class;
	void (*notify_items_selected_unselected) (ViewCollection* self, GeeCollection* selected, GeeCollection* unselected);
	void (*notify_selection_group_altered) (ViewCollection* self);
	void (*notify_item_view_altered) (ViewCollection* self, DataView* view);
	void (*notify_views_altered) (ViewCollection* self, GeeCollection* views);
	void (*notify_item_geometry_altered) (ViewCollection* self, DataView* view);
	void (*notify_geometries_altered) (ViewCollection* self, GeeCollection* views);
	void (*notify_items_shown) (ViewCollection* self, GeeCollection* shown);
	void (*notify_items_hidden) (ViewCollection* self, GeeCollection* hidden);
	void (*notify_items_visibility_changed) (ViewCollection* self, GeeCollection* changed);
	void (*notify_view_filter_installed) (ViewCollection* self, ViewFilter* filter);
	void (*notify_view_filter_removed) (ViewCollection* self, ViewFilter* filter);
	DataView* (*get_first) (ViewCollection* self);
	DataView* (*get_first_unrejected) (ViewCollection* self);
	DataView* (*get_first_photo) (ViewCollection* self);
	DataView* (*get_last) (ViewCollection* self);
	DataView* (*get_next) (ViewCollection* self, DataView* view, gboolean** wrapped);
	DataView* (*get_previous) (ViewCollection* self, DataView* view);
	void (*items_selected) (ViewCollection* self, GeeIterable* selected);
	void (*items_unselected) (ViewCollection* self, GeeIterable* unselected);
	void (*items_state_changed) (ViewCollection* self, GeeIterable* changed);
	void (*selection_group_altered) (ViewCollection* self);
	void (*items_shown) (ViewCollection* self, GeeCollection* visible);
	void (*items_hidden) (ViewCollection* self, GeeCollection* hidden);
	void (*items_visibility_changed) (ViewCollection* self, GeeCollection* changed);
	void (*item_view_altered) (ViewCollection* self, DataView* view);
	void (*item_geometry_altered) (ViewCollection* self, DataView* view);
	void (*views_altered) (ViewCollection* self, GeeCollection* views);
	void (*geometries_altered) (ViewCollection* self, GeeCollection* views);
	void (*view_filter_installed) (ViewCollection* self, ViewFilter* filer);
	void (*view_filter_removed) (ViewCollection* self, ViewFilter* filer);
};

struct _ViewCollectionPrivate {
	GeeHashMultiMap* monitors;
	ViewCollection* mirroring;
	CreateView mirroring_ctor;
	gpointer mirroring_ctor_target;
	CreateViewPredicate should_mirror;
	gpointer should_mirror_target;
	GeeSet* filters;
	DataSet* selected;
	DataSet* visible;
	GeeHashSet* frozen_views_altered;
	GeeHashSet* frozen_geometries_altered;
	GeeHashMap* source_map;
};

struct _ViewCollectionMonitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ViewCollectionMonitorPrivate * priv;
};

struct _ViewCollectionMonitorClass {
	GTypeClass parent_class;
	void (*finalize) (ViewCollectionMonitor *self);
};

struct _ViewCollectionMonitorImpl {
	ViewCollectionMonitor parent_instance;
	ViewCollectionMonitorImplPrivate * priv;
	ViewCollection* owner;
	SourceCollection* sources;
	ViewManager* manager;
	Alteration* prereq;
};

struct _ViewCollectionMonitorImplClass {
	ViewCollectionMonitorClass parent_class;
};

struct _ViewCollectionToggleLists {
	GObject parent_instance;
	ViewCollectionToggleListsPrivate * priv;
	GeeArrayList* selected;
	GeeArrayList* unselected;
};

struct _ViewCollectionToggleListsClass {
	GObjectClass parent_class;
};

struct _ViewCollectionParamSpecMonitor {
	GParamSpec parent_instance;
};

struct _ViewManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ViewManagerPrivate * priv;
};

struct _ViewManagerClass {
	GTypeClass parent_class;
	void (*finalize) (ViewManager *self);
	gboolean (*include_in_view) (ViewManager* self, DataSource* source);
	DataView* (*create_view) (ViewManager* self, DataSource* source);
};

struct _ParamSpecViewManager {
	GParamSpec parent_instance;
};

struct _ViewFilter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ViewFilterPrivate * priv;
};

struct _ViewFilterClass {
	GTypeClass parent_class;
	void (*finalize) (ViewFilter *self);
	gboolean (*predicate) (ViewFilter* self, DataView* view);
	void (*refresh) (ViewFilter* self);
};

struct _ParamSpecViewFilter {
	GParamSpec parent_instance;
};

static gint ViewCollection_private_offset;
static gpointer view_collection_parent_class = NULL;
static gpointer view_collection_monitor_parent_class = NULL;
static gpointer view_collection_monitor_impl_parent_class = NULL;
static gpointer view_collection_toggle_lists_parent_class = NULL;
static gpointer view_manager_parent_class = NULL;
static gpointer view_filter_parent_class = NULL;

VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, g_object_unref)
VALA_EXTERN GType view_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ViewCollection, data_collection_unref)
VALA_EXTERN GType data_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataView, g_object_unref)
VALA_EXTERN gpointer view_filter_ref (gpointer instance);
VALA_EXTERN void view_filter_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_view_filter (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_view_filter (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_view_filter (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_view_filter (const GValue* value);
VALA_EXTERN GType view_filter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ViewFilter, view_filter_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN gpointer view_collection_monitor_ref (gpointer instance);
VALA_EXTERN void view_collection_monitor_unref (gpointer instance);
VALA_EXTERN GParamSpec* view_collection_param_spec_monitor (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void view_collection_value_set_monitor (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void view_collection_value_take_monitor (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer view_collection_value_get_monitor (const GValue* value);
VALA_EXTERN GType view_collection_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ViewCollectionMonitor, view_collection_monitor_unref)
static GType view_collection_monitor_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ViewCollectionMonitorImpl, view_collection_monitor_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN gpointer data_set_ref (gpointer instance);
VALA_EXTERN void data_set_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_set (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
VALA_EXTERN void value_set_data_set (GValue* value,
                         gpointer v_object);
VALA_EXTERN void value_take_data_set (GValue* value,
                          gpointer v_object);
VALA_EXTERN gpointer value_get_data_set (const GValue* value);
VALA_EXTERN GType data_set_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSet, data_set_unref)
VALA_EXTERN void view_collection_notify_items_selected_unselected (ViewCollection* self,
                                                       GeeCollection* selected,
                                                       GeeCollection* unselected);
VALA_EXTERN void view_collection_notify_selection_group_altered (ViewCollection* self);
VALA_EXTERN void view_collection_notify_item_view_altered (ViewCollection* self,
                                               DataView* view);
VALA_EXTERN void view_collection_notify_views_altered (ViewCollection* self,
                                           GeeCollection* views);
VALA_EXTERN void view_collection_notify_item_geometry_altered (ViewCollection* self,
                                                   DataView* view);
VALA_EXTERN void view_collection_notify_geometries_altered (ViewCollection* self,
                                                GeeCollection* views);
VALA_EXTERN void view_collection_notify_items_shown (ViewCollection* self,
                                         GeeCollection* shown);
VALA_EXTERN void view_collection_notify_items_hidden (ViewCollection* self,
                                          GeeCollection* hidden);
VALA_EXTERN void view_collection_notify_items_visibility_changed (ViewCollection* self,
                                                      GeeCollection* changed);
VALA_EXTERN void view_collection_notify_view_filter_installed (ViewCollection* self,
                                                   ViewFilter* filter);
VALA_EXTERN void view_collection_notify_view_filter_removed (ViewCollection* self,
                                                 ViewFilter* filter);
VALA_EXTERN void data_collection_clear (DataCollection* self);
VALA_EXTERN void data_collection_close (DataCollection* self);
VALA_EXTERN gboolean data_collection_valid_type (DataCollection* self,
                                     DataObject* object);
VALA_EXTERN gboolean data_collection_add (DataCollection* self,
                              DataObject* object);
VALA_EXTERN GeeCollection* data_collection_add_many (DataCollection* self,
                                         GeeCollection* objects,
                                         ProgressMonitor monitor,
                                         gpointer monitor_target);
VALA_EXTERN void data_collection_notify_items_added (DataCollection* self,
                                         GeeIterable* added);
VALA_EXTERN void data_collection_notify_items_removed (DataCollection* self,
                                           GeeIterable* removed);
VALA_EXTERN void data_collection_items_altered (DataCollection* self,
                                    GeeMap* items);
VALA_EXTERN void data_collection_set_comparator (DataCollection* self,
                                     Comparator comparator,
                                     gpointer comparator_target,
                                     ComparatorPredicate predicate,
                                     gpointer predicate_target);
VALA_EXTERN void data_collection_reset_comparator (DataCollection* self);
VALA_EXTERN GeeCollection* data_collection_get_all (DataCollection* self);
VALA_EXTERN gint data_collection_get_count (DataCollection* self);
VALA_EXTERN DataObject* data_collection_get_at (DataCollection* self,
                                    gint index);
VALA_EXTERN gint data_collection_index_of (DataCollection* self,
                               DataObject* object);
VALA_EXTERN gboolean data_collection_contains (DataCollection* self,
                                   DataObject* object);
VALA_EXTERN DataView* view_collection_get_first (ViewCollection* self);
VALA_EXTERN DataView* view_collection_get_first_unrejected (ViewCollection* self);
VALA_EXTERN DataView* view_collection_get_first_photo (ViewCollection* self);
VALA_EXTERN DataView* view_collection_get_last (ViewCollection* self);
VALA_EXTERN DataView* view_collection_get_next (ViewCollection* self,
                                    DataView* view,
                                    gboolean** wrapped);
VALA_EXTERN DataView* view_collection_get_previous (ViewCollection* self,
                                        DataView* view);
VALA_EXTERN void data_collection_notify_thawed (DataCollection* self);
VALA_EXTERN DataSet* data_set_new (void);
VALA_EXTERN DataSet* data_set_construct (GType object_type);
VALA_EXTERN ViewCollection* view_collection_new (const gchar* name);
VALA_EXTERN ViewCollection* view_collection_construct (GType object_type,
                                           const gchar* name);
VALA_EXTERN DataCollection* data_collection_new (const gchar* name);
VALA_EXTERN DataCollection* data_collection_construct (GType object_type,
                                           const gchar* name);
static void view_collection_real_notify_items_selected_unselected (ViewCollection* self,
                                                            GeeCollection* selected,
                                                            GeeCollection* unselected);
static void view_collection_real_notify_selection_group_altered (ViewCollection* self);
static void view_collection_real_notify_item_view_altered (ViewCollection* self,
                                                    DataView* view);
static void view_collection_real_notify_views_altered (ViewCollection* self,
                                                GeeCollection* views);
static void view_collection_real_notify_item_geometry_altered (ViewCollection* self,
                                                        DataView* view);
static void view_collection_real_notify_geometries_altered (ViewCollection* self,
                                                     GeeCollection* views);
static void view_collection_real_notify_items_shown (ViewCollection* self,
                                              GeeCollection* shown);
static void view_collection_real_notify_items_hidden (ViewCollection* self,
                                               GeeCollection* hidden);
static void view_collection_real_notify_items_visibility_changed (ViewCollection* self,
                                                           GeeCollection* changed);
static void view_collection_real_notify_view_filter_installed (ViewCollection* self,
                                                        ViewFilter* filter);
static void view_collection_real_notify_view_filter_removed (ViewCollection* self,
                                                      ViewFilter* filter);
static void view_collection_real_clear (DataCollection* base);
VALA_EXTERN gchar* data_collection_to_string (DataCollection* self);
static void view_collection_real_close (DataCollection* base);
VALA_EXTERN void view_collection_halt_all_monitoring (ViewCollection* self);
VALA_EXTERN void view_collection_halt_mirroring (ViewCollection* self);
static void view_collection_on_view_filter_refresh (ViewCollection* self);
static void _view_collection_on_view_filter_refresh_view_filter_refresh (ViewFilter* _sender,
                                                                  gpointer self);
VALA_EXTERN gpointer view_manager_ref (gpointer instance);
VALA_EXTERN void view_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_view_manager (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_view_manager (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_view_manager (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_view_manager (const GValue* value);
VALA_EXTERN GType view_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ViewManager, view_manager_unref)
VALA_EXTERN ViewCollectionMonitor* view_collection_monitor_source_collection (ViewCollection* self,
                                                                  SourceCollection* sources,
                                                                  ViewManager* manager,
                                                                  Alteration* prereq,
                                                                  GeeCollection* initial,
                                                                  ProgressMonitor progress_monitor,
                                                                  gpointer progress_monitor_target);
VALA_EXTERN void data_collection_freeze_notifications (DataCollection* self);
static ViewCollectionMonitorImpl* view_collection_monitor_impl_new (ViewCollection* owner,
                                                             SourceCollection* sources,
                                                             ViewManager* manager,
                                                             Alteration* prereq);
static ViewCollectionMonitorImpl* view_collection_monitor_impl_construct (GType object_type,
                                                                   ViewCollection* owner,
                                                                   SourceCollection* sources,
                                                                   ViewManager* manager,
                                                                   Alteration* prereq);
VALA_EXTERN DataView* view_manager_create_view (ViewManager* self,
                                    DataSource* source);
static void view_collection_add_sources (ViewCollection* self,
                                  SourceCollection* sources,
                                  GeeIterable* added,
                                  ProgressMonitor progress_monitor,
                                  gpointer progress_monitor_target);
VALA_EXTERN void data_collection_thaw_notifications (DataCollection* self);
VALA_EXTERN void view_collection_halt_monitoring (ViewCollection* self,
                                      ViewCollectionMonitor* m);
VALA_EXTERN void view_collection_mirror (ViewCollection* self,
                             ViewCollection* to_mirror,
                             CreateView mirroring_ctor,
                             gpointer mirroring_ctor_target,
                             CreateViewPredicate should_mirror,
                             gpointer should_mirror_target);
VALA_EXTERN Comparator data_collection_get_comparator (DataCollection* self,
                                           gpointer* result_target);
VALA_EXTERN ComparatorPredicate data_collection_get_comparator_predicate (DataCollection* self,
                                                              gpointer* result_target);
static void view_collection_on_mirror_contents_added (ViewCollection* self,
                                               GeeIterable* added);
static void _view_collection_on_mirror_contents_added_data_collection_items_added (DataCollection* _sender,
                                                                            GeeIterable* added,
                                                                            gpointer self);
static void view_collection_on_mirror_contents_removed (ViewCollection* self,
                                                 GeeIterable* removed);
static void _view_collection_on_mirror_contents_removed_data_collection_items_removed (DataCollection* _sender,
                                                                                GeeIterable* removed,
                                                                                gpointer self);
VALA_EXTERN void view_collection_copy_into (ViewCollection* self,
                                ViewCollection* to_copy,
                                CreateView copying_ctor,
                                gpointer copying_ctor_target,
                                CreateViewPredicate should_copy,
                                gpointer should_copy_target);
VALA_EXTERN DataSource* data_view_get_source (DataView* self);
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN ViewCollection* view_collection_shuffled_copy (ViewCollection* self,
                                               Photo* start);
VALA_EXTERN PhotoView* photo_view_new (PhotoSource* source);
VALA_EXTERN PhotoView* photo_view_construct (GType object_type,
                                 PhotoSource* source);
VALA_EXTERN GType thumbnail_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailView, g_object_unref)
VALA_EXTERN GType photo_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoView, g_object_unref)
VALA_EXTERN gboolean view_collection_is_view_filter_installed (ViewCollection* self,
                                                   ViewFilter* f);
VALA_EXTERN void view_collection_install_view_filter (ViewCollection* self,
                                          ViewFilter* f);
VALA_EXTERN void view_collection_remove_view_filter (ViewCollection* self,
                                         ViewFilter* f);
static void view_collection_filter_altered_items (ViewCollection* self,
                                           GeeCollection* views);
static gboolean view_collection_is_in_filter (ViewCollection* self,
                                       DataView* view);
VALA_EXTERN gboolean view_filter_predicate (ViewFilter* self,
                                DataView* view);
static gboolean view_collection_real_valid_type (DataCollection* base,
                                          DataObject* object);
static void view_collection_on_sources_added (ViewCollection* self,
                                       DataCollection* sources,
                                       GeeIterable* added);
VALA_EXTERN gboolean view_manager_include_in_view (ViewManager* self,
                                       DataSource* source);
static DataView* _view_manager_create_view_create_view (DataSource* source,
                                                 gpointer self);
static gboolean view_collection_real_add (DataCollection* base,
                                   DataObject* object);
VALA_EXTERN void data_view_internal_set_visible (DataView* self,
                                     gboolean visible);
VALA_EXTERN GeeCollection* data_collection_get_singleton (DataObject* object);
static GeeCollection* view_collection_real_add_many (DataCollection* base,
                                              GeeCollection* objects,
                                              ProgressMonitor monitor,
                                              gpointer monitor_target);
static void view_collection_on_sources_removed (ViewCollection* self,
                                         GeeIterable* removed);
VALA_EXTERN Marker* data_collection_start_marking (DataCollection* self);
VALA_EXTERN void marker_mark (Marker* self,
                  DataObject* object);
VALA_EXTERN gint marker_get_count (Marker* self);
VALA_EXTERN void data_collection_remove_marked (DataCollection* self,
                                    Marker* m);
static void view_collection_on_sources_altered (ViewCollection* self,
                                         DataCollection* collection,
                                         GeeMap* items);
VALA_EXTERN gboolean alteration_contains_any (Alteration* self,
                                  Alteration* other);
VALA_EXTERN gboolean view_collection_has_view_for_source (ViewCollection* self,
                                              DataSource* source);
VALA_EXTERN DataView* view_collection_get_view_for_source (ViewCollection* self,
                                               DataSource* source);
VALA_EXTERN gboolean data_set_contains (DataSet* self,
                            DataObject* object);
VALA_EXTERN gboolean data_set_resort_object (DataSet* self,
                                 DataObject* object,
                                 Alteration* alteration);
static gboolean view_collection_is_visible (ViewCollection* self,
                                     DataView* view);
VALA_EXTERN Marker* data_collection_mark_many (DataCollection* self,
                                   GeeCollection* objects);
VALA_EXTERN void data_collection_notify_ordering_changed (DataCollection* self);
static void view_collection_real_notify_items_added (DataCollection* base,
                                              GeeIterable* added);
VALA_EXTERN gboolean data_view_is_selected (DataView* self);
VALA_EXTERN gboolean data_view_is_visible (DataView* self);
static gboolean view_collection_add_many_visible (ViewCollection* self,
                                           GeeCollection* many);
static void view_collection_add_many_selected (ViewCollection* self,
                                        GeeCollection* views);
static void view_collection_real_notify_items_removed (DataCollection* base,
                                                GeeIterable* removed);
VALA_EXTERN gboolean data_set_remove (DataSet* self,
                          DataObject* object);
static void view_collection_remove_many_selected (ViewCollection* self,
                                           GeeCollection* views);
static void view_collection_show_items (ViewCollection* self,
                                 GeeList* to_show);
static void view_collection_hide_items (ViewCollection* self,
                                 GeeList* to_hide);
static void view_collection_real_items_altered (DataCollection* base,
                                         GeeMap* map);
static void view_collection_real_set_comparator (DataCollection* base,
                                          Comparator comparator,
                                          gpointer comparator_target,
                                          ComparatorPredicate predicate,
                                          gpointer predicate_target);
VALA_EXTERN void data_set_set_comparator (DataSet* self,
                              Comparator user_comparator,
                              gpointer user_comparator_target,
                              ComparatorPredicate comparator_predicate,
                              gpointer comparator_predicate_target);
static void view_collection_real_reset_comparator (DataCollection* base);
VALA_EXTERN void data_set_reset_comparator (DataSet* self);
static GeeCollection* view_collection_real_get_all (DataCollection* base);
VALA_EXTERN GeeList* data_set_get_all (DataSet* self);
VALA_EXTERN GeeCollection* view_collection_get_all_unfiltered (ViewCollection* self);
static gint view_collection_real_get_count (DataCollection* base);
VALA_EXTERN gint data_set_get_count (DataSet* self);
VALA_EXTERN gint view_collection_get_unfiltered_count (ViewCollection* self);
static DataObject* view_collection_real_get_at (DataCollection* base,
                                         gint index);
VALA_EXTERN DataObject* data_set_get_at (DataSet* self,
                             gint index);
static gint view_collection_real_index_of (DataCollection* base,
                                    DataObject* object);
VALA_EXTERN gint data_set_index_of (DataSet* self,
                        DataObject* object);
static gboolean view_collection_real_contains (DataCollection* base,
                                        DataObject* object);
static DataView* view_collection_real_get_first (ViewCollection* self);
static DataView* view_collection_real_get_first_unrejected (ViewCollection* self);
VALA_EXTERN GType rating_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Rating media_source_get_rating (MediaSource* self);
static DataView* view_collection_real_get_first_photo (ViewCollection* self);
static DataView* view_collection_real_get_last (ViewCollection* self);
static DataView* view_collection_real_get_next (ViewCollection* self,
                                         DataView* view,
                                         gboolean** wrapped);
static gboolean* _bool_dup (gboolean* self);
static DataView* view_collection_real_get_previous (ViewCollection* self,
                                             DataView* view);
VALA_EXTERN gboolean view_collection_get_immediate_neighbors (ViewCollection* self,
                                                  DataSource* home,
                                                  DataSource** next,
                                                  DataSource** prev,
                                                  const gchar* type_selector);
VALA_EXTERN gchar* data_source_get_typename (DataSource* self);
VALA_EXTERN GeeSet* view_collection_get_extended_neighbors (ViewCollection* self,
                                                DataSource* home,
                                                const gchar* typename);
VALA_EXTERN gboolean data_set_add_many (DataSet* self,
                            GeeCollection* objects);
VALA_EXTERN gboolean data_set_remove_many (DataSet* self,
                               GeeCollection* objects);
VALA_EXTERN void view_collection_select_marked (ViewCollection* self,
                                    Marker* marker);
VALA_EXTERN void data_collection_act_on_marked (DataCollection* self,
                                    Marker* m,
                                    MarkedAction action,
                                    gpointer action_target,
                                    ProgressMonitor monitor,
                                    gpointer monitor_target,
                                    GObject* user);
static gboolean view_collection_select_item (ViewCollection* self,
                                      DataObject* object,
                                      GObject* user);
static gboolean _view_collection_select_item_marked_action (DataObject* object,
                                                     GObject* user,
                                                     gpointer self);
VALA_EXTERN void view_collection_select_all (ViewCollection* self);
VALA_EXTERN void marker_mark_all (Marker* self);
VALA_EXTERN void data_view_internal_set_selected (DataView* self,
                                      gboolean selected);
VALA_EXTERN void view_collection_unselect_marked (ViewCollection* self,
                                      Marker* marker);
static gboolean view_collection_unselect_item (ViewCollection* self,
                                        DataObject* object,
                                        GObject* user);
static gboolean _view_collection_unselect_item_marked_action (DataObject* object,
                                                       GObject* user,
                                                       gpointer self);
VALA_EXTERN void view_collection_unselect_all (ViewCollection* self);
VALA_EXTERN void marker_mark_many (Marker* self,
                       GeeCollection* list);
VALA_EXTERN GeeList* view_collection_get_selected (ViewCollection* self);
VALA_EXTERN void view_collection_unselect_all_but (ViewCollection* self,
                                       DataView* exception);
VALA_EXTERN void view_collection_unselect_and_select_marked (ViewCollection* self,
                                                 Marker* unselect,
                                                 Marker* select);
VALA_EXTERN void view_collection_toggle_marked (ViewCollection* self,
                                    Marker* marker);
static GType view_collection_toggle_lists_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ViewCollectionToggleLists, g_object_unref)
static ViewCollectionToggleLists* view_collection_toggle_lists_new (void);
static ViewCollectionToggleLists* view_collection_toggle_lists_construct (GType object_type);
static gboolean view_collection_toggle_item (ViewCollection* self,
                                      DataObject* object,
                                      GObject* user);
static gboolean _view_collection_toggle_item_marked_action (DataObject* object,
                                                     GObject* user,
                                                     gpointer self);
VALA_EXTERN gboolean data_view_internal_toggle (DataView* self);
VALA_EXTERN gint view_collection_get_selected_count (ViewCollection* self);
VALA_EXTERN DataView* view_collection_get_selected_at (ViewCollection* self,
                                           gint index);
VALA_EXTERN DataSet* data_collection_get_dataset_copy (DataCollection* self);
VALA_EXTERN gboolean view_collection_has_view_for_source_with_filtered (ViewCollection* self,
                                                            DataSource* source);
VALA_EXTERN DataView* view_collection_get_view_for_source_filtered (ViewCollection* self,
                                                        DataSource* source);
VALA_EXTERN GeeCollection* view_collection_get_sources (ViewCollection* self);
VALA_EXTERN gboolean view_collection_has_source_of_type (ViewCollection* self,
                                             GType t);
VALA_EXTERN gint view_collection_get_sources_of_type_count (ViewCollection* self,
                                                GType t);
VALA_EXTERN GeeList* view_collection_get_sources_of_type (ViewCollection* self,
                                              GType t);
VALA_EXTERN GeeList* view_collection_get_selected_sources (ViewCollection* self);
VALA_EXTERN DataSource* view_collection_get_selected_source_at (ViewCollection* self,
                                                    gint index);
VALA_EXTERN GeeList* view_collection_get_selected_sources_of_type (ViewCollection* self,
                                                       GType t);
VALA_EXTERN gint view_collection_index_of_source (ViewCollection* self,
                                      DataSource* source);
VALA_EXTERN void view_collection_internal_notify_view_altered (ViewCollection* self,
                                                   DataView* view);
VALA_EXTERN gboolean data_collection_are_notifications_frozen (DataCollection* self);
VALA_EXTERN void view_collection_internal_notify_geometry_altered (ViewCollection* self,
                                                       DataView* view);
static void view_collection_real_notify_thawed (DataCollection* base);
VALA_EXTERN gboolean view_collection_are_items_filtered_out (ViewCollection* self);
static void view_collection_real_items_selected (ViewCollection* self,
                                          GeeIterable* selected);
static void view_collection_real_items_unselected (ViewCollection* self,
                                            GeeIterable* unselected);
static void view_collection_real_items_state_changed (ViewCollection* self,
                                               GeeIterable* changed);
static void view_collection_real_selection_group_altered (ViewCollection* self);
static void view_collection_real_items_shown (ViewCollection* self,
                                       GeeCollection* visible);
static void view_collection_real_items_hidden (ViewCollection* self,
                                        GeeCollection* hidden);
static void view_collection_real_items_visibility_changed (ViewCollection* self,
                                                    GeeCollection* changed);
static void view_collection_real_item_view_altered (ViewCollection* self,
                                             DataView* view);
static void view_collection_real_item_geometry_altered (ViewCollection* self,
                                                 DataView* view);
static void view_collection_real_views_altered (ViewCollection* self,
                                         GeeCollection* views);
static void view_collection_real_geometries_altered (ViewCollection* self,
                                              GeeCollection* views);
static void view_collection_real_view_filter_installed (ViewCollection* self,
                                                 ViewFilter* filer);
static void g_cclosure_user_marshal_VOID__VIEW_FILTER (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void view_collection_real_view_filter_removed (ViewCollection* self,
                                               ViewFilter* filer);
VALA_EXTERN ViewCollectionMonitor* view_collection_monitor_new (void);
VALA_EXTERN ViewCollectionMonitor* view_collection_monitor_construct (GType object_type);
static void view_collection_monitor_finalize (ViewCollectionMonitor * obj);
static GType view_collection_monitor_get_type_once (void);
static void _view_collection_on_sources_added_data_collection_items_added (DataCollection* _sender,
                                                                    GeeIterable* added,
                                                                    gpointer self);
static void _view_collection_on_sources_removed_data_collection_items_removed (DataCollection* _sender,
                                                                        GeeIterable* removed,
                                                                        gpointer self);
static void _view_collection_on_sources_altered_data_collection_items_altered (DataCollection* _sender,
                                                                        GeeMap* items,
                                                                        gpointer self);
static void view_collection_monitor_impl_finalize (ViewCollectionMonitor * obj);
static GType view_collection_monitor_impl_get_type_once (void);
static void view_collection_toggle_lists_finalize (GObject * obj);
static GType view_collection_toggle_lists_get_type_once (void);
static void view_collection_finalize (DataCollection * obj);
static GType view_collection_get_type_once (void);
static gboolean view_manager_real_include_in_view (ViewManager* self,
                                            DataSource* source);
static DataView* view_manager_real_create_view (ViewManager* self,
                                         DataSource* source);
VALA_EXTERN ViewManager* view_manager_construct (GType object_type);
static void view_manager_finalize (ViewManager * obj);
static GType view_manager_get_type_once (void);
static gboolean view_filter_real_predicate (ViewFilter* self,
                                     DataView* view);
VALA_EXTERN ViewFilter* view_filter_construct (GType object_type);
static void view_filter_real_refresh (ViewFilter* self);
static void view_filter_finalize (ViewFilter * obj);
static GType view_filter_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
view_collection_get_instance_private (ViewCollection* self)
{
	return G_STRUCT_MEMBER_P (self, ViewCollection_private_offset);
}

ViewCollection*
view_collection_construct (GType object_type,
                           const gchar* name)
{
	ViewCollection* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ViewCollection*) data_collection_construct (object_type, name);
	return self;
}

ViewCollection*
view_collection_new (const gchar* name)
{
	return view_collection_construct (TYPE_VIEW_COLLECTION, name);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
view_collection_real_notify_items_selected_unselected (ViewCollection* self,
                                                       GeeCollection* selected,
                                                       GeeCollection* unselected)
{
	gboolean _tmp0_ = FALSE;
	gboolean has_selected = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean has_unselected = FALSE;
	GeeCollection* sum = NULL;
	gboolean _tmp6_ = FALSE;
	GeeCollection* _tmp14_;
	g_return_if_fail ((selected == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (selected, GEE_TYPE_COLLECTION));
	g_return_if_fail ((unselected == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (unselected, GEE_TYPE_COLLECTION));
	if (selected != NULL) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = gee_collection_get_size (selected);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	has_selected = _tmp0_;
	if (unselected != NULL) {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = gee_collection_get_size (unselected);
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_ > 0;
	} else {
		_tmp3_ = FALSE;
	}
	has_unselected = _tmp3_;
	if (has_selected) {
		g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_ITEMS_SELECTED_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (selected, GEE_TYPE_ITERABLE, GeeIterable));
	}
	if (has_unselected) {
		g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_ITEMS_UNSELECTED_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (unselected, GEE_TYPE_ITERABLE, GeeIterable));
	}
	if (has_selected) {
		_tmp6_ = !has_unselected;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GeeCollection* _tmp7_;
		_tmp7_ = _g_object_ref0 (selected);
		_g_object_unref0 (sum);
		sum = _tmp7_;
	} else {
		gboolean _tmp8_ = FALSE;
		if (!has_selected) {
			_tmp8_ = has_unselected;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			GeeCollection* _tmp9_;
			_tmp9_ = _g_object_ref0 (unselected);
			_g_object_unref0 (sum);
			sum = _tmp9_;
		} else {
			gboolean _tmp10_ = FALSE;
			if (!has_selected) {
				_tmp10_ = !has_unselected;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				_g_object_unref0 (sum);
				sum = NULL;
			} else {
				GeeHashSet* _tmp11_;
				GeeCollection* _tmp12_;
				GeeCollection* _tmp13_;
				_tmp11_ = gee_hash_set_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
				_g_object_unref0 (sum);
				sum = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection);
				_tmp12_ = sum;
				gee_collection_add_all (_tmp12_, selected);
				_tmp13_ = sum;
				gee_collection_add_all (_tmp13_, unselected);
			}
		}
	}
	_tmp14_ = sum;
	if (_tmp14_ != NULL) {
		GeeCollection* _tmp15_;
		_tmp15_ = sum;
		g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_ITEMS_STATE_CHANGED_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ITERABLE, GeeIterable));
		view_collection_notify_selection_group_altered (self);
	}
	_g_object_unref0 (sum);
}

void
view_collection_notify_items_selected_unselected (ViewCollection* self,
                                                  GeeCollection* selected,
                                                  GeeCollection* unselected)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_selected_unselected) {
		_klass_->notify_items_selected_unselected (self, selected, unselected);
	}
}

static void
view_collection_real_notify_selection_group_altered (ViewCollection* self)
{
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_SELECTION_GROUP_ALTERED_SIGNAL], 0);
}

void
view_collection_notify_selection_group_altered (ViewCollection* self)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_selection_group_altered) {
		_klass_->notify_selection_group_altered (self);
	}
}

static void
view_collection_real_notify_item_view_altered (ViewCollection* self,
                                               DataView* view)
{
	g_return_if_fail (IS_DATA_VIEW (view));
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_ITEM_VIEW_ALTERED_SIGNAL], 0, view);
}

void
view_collection_notify_item_view_altered (ViewCollection* self,
                                          DataView* view)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_item_view_altered) {
		_klass_->notify_item_view_altered (self, view);
	}
}

static void
view_collection_real_notify_views_altered (ViewCollection* self,
                                           GeeCollection* views)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (views, GEE_TYPE_COLLECTION));
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_VIEWS_ALTERED_SIGNAL], 0, views);
}

void
view_collection_notify_views_altered (ViewCollection* self,
                                      GeeCollection* views)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_views_altered) {
		_klass_->notify_views_altered (self, views);
	}
}

static void
view_collection_real_notify_item_geometry_altered (ViewCollection* self,
                                                   DataView* view)
{
	g_return_if_fail (IS_DATA_VIEW (view));
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_ITEM_GEOMETRY_ALTERED_SIGNAL], 0, view);
}

void
view_collection_notify_item_geometry_altered (ViewCollection* self,
                                              DataView* view)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_item_geometry_altered) {
		_klass_->notify_item_geometry_altered (self, view);
	}
}

static void
view_collection_real_notify_geometries_altered (ViewCollection* self,
                                                GeeCollection* views)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (views, GEE_TYPE_COLLECTION));
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_GEOMETRIES_ALTERED_SIGNAL], 0, views);
}

void
view_collection_notify_geometries_altered (ViewCollection* self,
                                           GeeCollection* views)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_geometries_altered) {
		_klass_->notify_geometries_altered (self, views);
	}
}

static void
view_collection_real_notify_items_shown (ViewCollection* self,
                                         GeeCollection* shown)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (shown, GEE_TYPE_COLLECTION));
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_ITEMS_SHOWN_SIGNAL], 0, shown);
}

void
view_collection_notify_items_shown (ViewCollection* self,
                                    GeeCollection* shown)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_shown) {
		_klass_->notify_items_shown (self, shown);
	}
}

static void
view_collection_real_notify_items_hidden (ViewCollection* self,
                                          GeeCollection* hidden)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (hidden, GEE_TYPE_COLLECTION));
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_ITEMS_HIDDEN_SIGNAL], 0, hidden);
}

void
view_collection_notify_items_hidden (ViewCollection* self,
                                     GeeCollection* hidden)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_hidden) {
		_klass_->notify_items_hidden (self, hidden);
	}
}

static void
view_collection_real_notify_items_visibility_changed (ViewCollection* self,
                                                      GeeCollection* changed)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (changed, GEE_TYPE_COLLECTION));
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_ITEMS_VISIBILITY_CHANGED_SIGNAL], 0, changed);
}

void
view_collection_notify_items_visibility_changed (ViewCollection* self,
                                                 GeeCollection* changed)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_visibility_changed) {
		_klass_->notify_items_visibility_changed (self, changed);
	}
}

static void
view_collection_real_notify_view_filter_installed (ViewCollection* self,
                                                   ViewFilter* filter)
{
	g_return_if_fail (IS_VIEW_FILTER (filter));
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_VIEW_FILTER_INSTALLED_SIGNAL], 0, filter);
}

void
view_collection_notify_view_filter_installed (ViewCollection* self,
                                              ViewFilter* filter)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_view_filter_installed) {
		_klass_->notify_view_filter_installed (self, filter);
	}
}

static void
view_collection_real_notify_view_filter_removed (ViewCollection* self,
                                                 ViewFilter* filter)
{
	g_return_if_fail (IS_VIEW_FILTER (filter));
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_VIEW_FILTER_REMOVED_SIGNAL], 0, filter);
}

void
view_collection_notify_view_filter_removed (ViewCollection* self,
                                            ViewFilter* filter)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_view_filter_removed) {
		_klass_->notify_view_filter_removed (self, filter);
	}
}

static void
view_collection_real_clear (DataCollection* base)
{
	ViewCollection * self;
	gboolean _tmp0_ = FALSE;
	GeeHashMultiMap* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
	_tmp1_ = self->priv->monitors;
	_tmp2_ = gee_multi_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		_tmp0_ = TRUE;
	} else {
		ViewCollection* _tmp4_;
		_tmp4_ = self->priv->mirroring;
		_tmp0_ = _tmp4_ != NULL;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = data_collection_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
		_tmp6_ = _tmp5_;
		g_warning ("ViewCollection.vala:203: Cannot clear %s: monitoring or mirroring in e" \
"ffect", _tmp6_);
		_g_free0 (_tmp6_);
		return;
	}
	DATA_COLLECTION_CLASS (view_collection_parent_class)->clear (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
}

static void
_view_collection_on_view_filter_refresh_view_filter_refresh (ViewFilter* _sender,
                                                             gpointer self)
{
	view_collection_on_view_filter_refresh ((ViewCollection*) self);
}

static void
view_collection_real_close (DataCollection* base)
{
	ViewCollection * self;
	GeeSet* _tmp7_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
	view_collection_halt_all_monitoring (self);
	view_collection_halt_mirroring (self);
	{
		GeeIterator* _f_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->filters;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
		_f_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			ViewFilter* f = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			ViewFilter* _tmp5_;
			guint _tmp6_;
			_tmp2_ = _f_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _f_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			f = (ViewFilter*) _tmp4_;
			_tmp5_ = f;
			g_signal_parse_name ("refresh", TYPE_VIEW_FILTER, &_tmp6_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _view_collection_on_view_filter_refresh_view_filter_refresh, self);
			_view_filter_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	_tmp7_ = self->priv->filters;
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
	DATA_COLLECTION_CLASS (view_collection_parent_class)->close (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
}

ViewCollectionMonitor*
view_collection_monitor_source_collection (ViewCollection* self,
                                           SourceCollection* sources,
                                           ViewManager* manager,
                                           Alteration* prereq,
                                           GeeCollection* initial,
                                           ProgressMonitor progress_monitor,
                                           gpointer progress_monitor_target)
{
	ViewCollectionMonitorImpl* monitor = NULL;
	ViewCollectionMonitorImpl* _tmp0_;
	GeeHashMultiMap* _tmp1_;
	ViewCollectionMonitorImpl* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ViewCollectionMonitor* result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	g_return_val_if_fail (IS_SOURCE_COLLECTION (sources), NULL);
	g_return_val_if_fail (IS_VIEW_MANAGER (manager), NULL);
	g_return_val_if_fail ((prereq == NULL) || IS_ALTERATION (prereq), NULL);
	g_return_val_if_fail ((initial == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (initial, GEE_TYPE_COLLECTION), NULL);
	view_collection_halt_mirroring (self);
	data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	_tmp0_ = view_collection_monitor_impl_new (self, sources, manager, prereq);
	monitor = _tmp0_;
	_tmp1_ = self->priv->monitors;
	_tmp2_ = monitor;
	gee_multi_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MULTI_MAP, GeeMultiMap), sources, _tmp2_);
	if (initial != NULL) {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = gee_collection_get_size (initial);
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_ > 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GeeArrayList* created_views = NULL;
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp15_;
		GeeCollection* _tmp16_;
		GeeCollection* _tmp17_;
		_tmp6_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		created_views = _tmp6_;
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp7_;
			_tmp7_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (initial, GEE_TYPE_ITERABLE, GeeIterable));
			_source_it = _tmp7_;
			while (TRUE) {
				GeeIterator* _tmp8_;
				DataSource* source = NULL;
				GeeIterator* _tmp9_;
				gpointer _tmp10_;
				GeeArrayList* _tmp11_;
				DataSource* _tmp12_;
				DataView* _tmp13_;
				DataView* _tmp14_;
				_tmp8_ = _source_it;
				if (!gee_iterator_next (_tmp8_)) {
					break;
				}
				_tmp9_ = _source_it;
				_tmp10_ = gee_iterator_get (_tmp9_);
				source = (DataSource*) _tmp10_;
				_tmp11_ = created_views;
				_tmp12_ = source;
				_tmp13_ = view_manager_create_view (manager, _tmp12_);
				_tmp14_ = _tmp13_;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp14_);
				_g_object_unref0 (_tmp14_);
				_g_object_unref0 (source);
			}
			_g_object_unref0 (_source_it);
		}
		_tmp15_ = created_views;
		_tmp16_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection), progress_monitor, progress_monitor_target);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp17_);
		_g_object_unref0 (created_views);
	} else {
		GeeCollection* _tmp18_;
		GeeIterable* _tmp19_;
		_tmp18_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (sources, TYPE_DATA_COLLECTION, DataCollection));
		_tmp19_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ITERABLE, GeeIterable);
		view_collection_add_sources (self, sources, _tmp19_, progress_monitor, progress_monitor_target);
		_g_object_unref0 (_tmp19_);
	}
	data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	result = G_TYPE_CHECK_INSTANCE_CAST (monitor, VIEW_COLLECTION_TYPE_MONITOR, ViewCollectionMonitor);
	return result;
}

static gpointer
_view_collection_monitor_ref0 (gpointer self)
{
	return self ? view_collection_monitor_ref (self) : NULL;
}

void
view_collection_halt_monitoring (ViewCollection* self,
                                 ViewCollectionMonitor* m)
{
	ViewCollectionMonitorImpl* monitor = NULL;
	ViewCollectionMonitorImpl* _tmp0_;
	gboolean removed = FALSE;
	GeeHashMultiMap* _tmp1_;
	SourceCollection* _tmp2_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (VIEW_COLLECTION_IS_MONITOR (m));
	_tmp0_ = _view_collection_monitor_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, VIEW_COLLECTION_TYPE_MONITOR_IMPL, ViewCollectionMonitorImpl));
	monitor = _tmp0_;
	_tmp1_ = self->priv->monitors;
	_tmp2_ = monitor->sources;
	removed = gee_multi_map_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp2_, monitor);
	_vala_assert (removed, "removed");
	_view_collection_monitor_unref0 (monitor);
}

void
view_collection_halt_all_monitoring (ViewCollection* self)
{
	GeeHashMultiMap* _tmp0_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	_tmp0_ = self->priv->monitors;
	gee_multi_map_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

static void
_view_collection_on_mirror_contents_added_data_collection_items_added (DataCollection* _sender,
                                                                       GeeIterable* added,
                                                                       gpointer self)
{
	view_collection_on_mirror_contents_added ((ViewCollection*) self, added);
}

static void
_view_collection_on_mirror_contents_removed_data_collection_items_removed (DataCollection* _sender,
                                                                           GeeIterable* removed,
                                                                           gpointer self)
{
	view_collection_on_mirror_contents_removed ((ViewCollection*) self, removed);
}

void
view_collection_mirror (ViewCollection* self,
                        ViewCollection* to_mirror,
                        CreateView mirroring_ctor,
                        gpointer mirroring_ctor_target,
                        CreateViewPredicate should_mirror,
                        gpointer should_mirror_target)
{
	ViewCollection* _tmp0_;
	gpointer _tmp1_ = NULL;
	Comparator _tmp2_;
	gpointer _tmp3_ = NULL;
	ComparatorPredicate _tmp4_;
	ViewCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	ViewCollection* _tmp8_;
	ViewCollection* _tmp9_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (IS_VIEW_COLLECTION (to_mirror));
	view_collection_halt_mirroring (self);
	view_collection_halt_all_monitoring (self);
	data_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	_tmp0_ = _data_collection_ref0 (to_mirror);
	_data_collection_unref0 (self->priv->mirroring);
	self->priv->mirroring = _tmp0_;
	self->priv->mirroring_ctor = mirroring_ctor;
	self->priv->mirroring_ctor_target = mirroring_ctor_target;
	self->priv->should_mirror = should_mirror;
	self->priv->should_mirror_target = should_mirror_target;
	_tmp2_ = data_collection_get_comparator (G_TYPE_CHECK_INSTANCE_CAST (to_mirror, TYPE_DATA_COLLECTION, DataCollection), &_tmp1_);
	_tmp4_ = data_collection_get_comparator_predicate (G_TYPE_CHECK_INSTANCE_CAST (to_mirror, TYPE_DATA_COLLECTION, DataCollection), &_tmp3_);
	data_collection_set_comparator (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp2_, _tmp1_, _tmp4_, _tmp3_);
	_tmp5_ = self->priv->mirroring;
	_tmp6_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_COLLECTION, DataCollection));
	_tmp7_ = _tmp6_;
	view_collection_on_mirror_contents_added (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ITERABLE, GeeIterable));
	_g_object_unref0 (_tmp7_);
	_tmp8_ = self->priv->mirroring;
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection), "items-added", (GCallback) _view_collection_on_mirror_contents_added_data_collection_items_added, self);
	_tmp9_ = self->priv->mirroring;
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_COLLECTION, DataCollection), "items-removed", (GCallback) _view_collection_on_mirror_contents_removed_data_collection_items_removed, self);
}

void
view_collection_halt_mirroring (ViewCollection* self)
{
	ViewCollection* _tmp0_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	_tmp0_ = self->priv->mirroring;
	if (_tmp0_ != NULL) {
		ViewCollection* _tmp1_;
		guint _tmp2_;
		ViewCollection* _tmp3_;
		guint _tmp4_;
		_tmp1_ = self->priv->mirroring;
		g_signal_parse_name ("items-added", TYPE_DATA_COLLECTION, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _view_collection_on_mirror_contents_added_data_collection_items_added, self);
		_tmp3_ = self->priv->mirroring;
		g_signal_parse_name ("items-removed", TYPE_DATA_COLLECTION, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _view_collection_on_mirror_contents_removed_data_collection_items_removed, self);
	}
	_data_collection_unref0 (self->priv->mirroring);
	self->priv->mirroring = NULL;
}

void
view_collection_copy_into (ViewCollection* self,
                           ViewCollection* to_copy,
                           CreateView copying_ctor,
                           gpointer copying_ctor_target,
                           CreateViewPredicate should_copy,
                           gpointer should_copy_target)
{
	GeeArrayList* copy_view = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp20_;
	GeeCollection* _tmp21_;
	GeeCollection* _tmp22_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (IS_VIEW_COLLECTION (to_copy));
	_tmp0_ = gee_array_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	copy_view = _tmp0_;
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp1_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (to_copy, TYPE_DATA_COLLECTION, DataCollection));
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			DataView* view = NULL;
			DataObject* _tmp8_;
			DataView* _tmp9_;
			DataView* _tmp10_;
			DataSource* _tmp11_;
			DataSource* _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_VIEW, DataView));
			view = _tmp9_;
			_tmp10_ = view;
			_tmp11_ = data_view_get_source (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = should_copy (_tmp12_, should_copy_target);
			_g_object_unref0 (_tmp12_);
			if (_tmp13_) {
				GeeArrayList* _tmp14_;
				DataView* _tmp15_;
				DataSource* _tmp16_;
				DataSource* _tmp17_;
				DataView* _tmp18_;
				DataView* _tmp19_;
				_tmp14_ = copy_view;
				_tmp15_ = view;
				_tmp16_ = data_view_get_source (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = copying_ctor (_tmp17_, copying_ctor_target);
				_tmp19_ = _tmp18_;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_DATA_OBJECT, DataObject));
				_g_object_unref0 (_tmp19_);
				_g_object_unref0 (_tmp17_);
			}
			_g_object_unref0 (view);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp20_ = copy_view;
	_tmp21_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
	_tmp22_ = _tmp21_;
	_g_object_unref0 (_tmp22_);
	_g_object_unref0 (copy_view);
}

ViewCollection*
view_collection_shuffled_copy (ViewCollection* self,
                               Photo* start)
{
	ViewCollection* shuffled = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ViewCollection* _tmp4_;
	ViewCollection* _tmp5_;
	GeeCollection* data = NULL;
	GeeCollection* _tmp6_;
	GeeArrayList* data_copy = NULL;
	GeeArrayList* _tmp7_;
	ViewCollection* _tmp46_;
	GeeArrayList* _tmp47_;
	GeeCollection* _tmp48_;
	GeeCollection* _tmp49_;
	ViewCollection* result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	g_return_val_if_fail ((start == NULL) || IS_PHOTO (start), NULL);
	_tmp0_ = data_collection_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("shuffled copy of ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = view_collection_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	shuffled = _tmp5_;
	_tmp6_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	data = _tmp6_;
	_tmp7_ = gee_array_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	data_copy = _tmp7_;
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp8_ = data;
		_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ITERABLE, GeeIterable));
		_object_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			DataObject* object = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			DataView* view = NULL;
			DataObject* _tmp13_;
			DataView* _tmp14_;
			gboolean _tmp15_ = FALSE;
			DataView* _tmp16_;
			DataSource* _tmp17_;
			DataSource* _tmp18_;
			gboolean _tmp19_;
			_tmp10_ = _object_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _object_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			object = (DataObject*) _tmp12_;
			_tmp13_ = object;
			_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_VIEW, DataView));
			view = _tmp14_;
			_tmp16_ = view;
			_tmp17_ = data_view_get_source (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = IS_PHOTO_SOURCE (_tmp18_);
			_g_object_unref0 (_tmp18_);
			if (_tmp19_) {
				gboolean _tmp20_ = FALSE;
				if (start == NULL) {
					_tmp20_ = TRUE;
				} else {
					DataView* _tmp21_;
					DataSource* _tmp22_;
					DataSource* _tmp23_;
					_tmp21_ = view;
					_tmp22_ = data_view_get_source (_tmp21_);
					_tmp23_ = _tmp22_;
					_tmp20_ = _tmp23_ != G_TYPE_CHECK_INSTANCE_CAST (start, TYPE_DATA_SOURCE, DataSource);
					_g_object_unref0 (_tmp23_);
				}
				_tmp15_ = _tmp20_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				GeeArrayList* _tmp24_;
				DataObject* _tmp25_;
				DataSource* _tmp26_;
				PhotoSource* _tmp27_;
				PhotoView* _tmp28_;
				PhotoView* _tmp29_;
				_tmp24_ = data_copy;
				_tmp25_ = object;
				_tmp26_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_DATA_VIEW, DataView));
				_tmp27_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_PHOTO_SOURCE, PhotoSource);
				_tmp28_ = photo_view_new (_tmp27_);
				_tmp29_ = _tmp28_;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_DATA_OBJECT, DataObject));
				_g_object_unref0 (_tmp29_);
				_g_object_unref0 (_tmp27_);
			}
			_g_object_unref0 (view);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	{
		gint ctr = 0;
		GeeArrayList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		_tmp30_ = data_copy;
		_tmp31_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp32_ = _tmp31_;
		ctr = _tmp32_ - 1;
		{
			gboolean _tmp33_ = FALSE;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint rand = 0;
				DataObject* temp = NULL;
				GeeArrayList* _tmp35_;
				gpointer _tmp36_;
				GeeArrayList* _tmp37_;
				GeeArrayList* _tmp38_;
				gpointer _tmp39_;
				DataObject* _tmp40_;
				GeeArrayList* _tmp41_;
				DataObject* _tmp42_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = ctr;
					ctr = _tmp34_ - 1;
				}
				_tmp33_ = FALSE;
				if (!(ctr > 0)) {
					break;
				}
				rand = (gint) g_random_int_range ((gint32) 0, (gint32) (ctr + 1));
				_tmp35_ = data_copy;
				_tmp36_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), rand);
				temp = (DataObject*) _tmp36_;
				_tmp37_ = data_copy;
				_tmp38_ = data_copy;
				_tmp39_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), ctr);
				_tmp40_ = (DataObject*) _tmp39_;
				gee_abstract_list_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), rand, _tmp40_);
				_g_object_unref0 (_tmp40_);
				_tmp41_ = data_copy;
				_tmp42_ = temp;
				gee_abstract_list_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), ctr, _tmp42_);
				_g_object_unref0 (temp);
			}
		}
	}
	if (start != NULL) {
		ViewCollection* _tmp43_;
		PhotoView* _tmp44_;
		PhotoView* _tmp45_;
		_tmp43_ = shuffled;
		_tmp44_ = photo_view_new (G_TYPE_CHECK_INSTANCE_CAST (start, TYPE_PHOTO_SOURCE, PhotoSource));
		_tmp45_ = _tmp44_;
		data_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, TYPE_DATA_OBJECT, DataObject));
		_g_object_unref0 (_tmp45_);
	}
	_tmp46_ = shuffled;
	_tmp47_ = data_copy;
	_tmp48_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
	_tmp49_ = _tmp48_;
	_g_object_unref0 (_tmp49_);
	result = shuffled;
	_g_object_unref0 (data_copy);
	_g_object_unref0 (data);
	return result;
}

gboolean
view_collection_is_view_filter_installed (ViewCollection* self,
                                          ViewFilter* f)
{
	GeeSet* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
	g_return_val_if_fail (IS_VIEW_FILTER (f), FALSE);
	_tmp0_ = self->priv->filters;
	result = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), f);
	return result;
}

void
view_collection_install_view_filter (ViewCollection* self,
                                     ViewFilter* f)
{
	GeeSet* _tmp0_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (IS_VIEW_FILTER (f));
	if (view_collection_is_view_filter_installed (self, f)) {
		return;
	}
	_tmp0_ = self->priv->filters;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), f);
	g_signal_connect (f, "refresh", (GCallback) _view_collection_on_view_filter_refresh_view_filter_refresh, self);
	view_collection_on_view_filter_refresh (self);
	view_collection_notify_view_filter_installed (self, f);
}

void
view_collection_remove_view_filter (ViewCollection* self,
                                    ViewFilter* f)
{
	GeeSet* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (IS_VIEW_FILTER (f));
	if (!view_collection_is_view_filter_installed (self, f)) {
		return;
	}
	_tmp0_ = self->priv->filters;
	gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), f);
	g_signal_parse_name ("refresh", TYPE_VIEW_FILTER, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (f, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _view_collection_on_view_filter_refresh_view_filter_refresh, self);
	view_collection_on_view_filter_refresh (self);
	view_collection_notify_view_filter_removed (self, f);
}

static void
view_collection_on_view_filter_refresh (ViewCollection* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	_tmp0_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	view_collection_filter_altered_items (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
}

static gboolean
view_collection_is_in_filter (ViewCollection* self,
                              DataView* view)
{
	gboolean result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
	g_return_val_if_fail (IS_DATA_VIEW (view), FALSE);
	{
		GeeIterator* _f_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->filters;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
		_f_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			ViewFilter* f = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			ViewFilter* _tmp5_;
			_tmp2_ = _f_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _f_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			f = (ViewFilter*) _tmp4_;
			_tmp5_ = f;
			if (!view_filter_predicate (_tmp5_, view)) {
				result = FALSE;
				_view_filter_unref0 (f);
				_g_object_unref0 (_f_it);
				return result;
			}
			_view_filter_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	result = TRUE;
	return result;
}

static gboolean
view_collection_real_valid_type (DataCollection* base,
                                 DataObject* object)
{
	ViewCollection * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	result = IS_DATA_VIEW (object);
	return result;
}

static void
view_collection_on_sources_added (ViewCollection* self,
                                  DataCollection* sources,
                                  GeeIterable* added)
{
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (IS_DATA_COLLECTION (sources));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
	view_collection_add_sources (self, G_TYPE_CHECK_INSTANCE_CAST (sources, TYPE_SOURCE_COLLECTION, SourceCollection), added, NULL, NULL);
}

static DataView*
_view_manager_create_view_create_view (DataSource* source,
                                       gpointer self)
{
	DataView* result;
	result = view_manager_create_view ((ViewManager*) self, source);
	return result;
}

static void
view_collection_add_sources (ViewCollection* self,
                             SourceCollection* sources,
                             GeeIterable* added,
                             ProgressMonitor progress_monitor,
                             gpointer progress_monitor_target)
{
	DataView* created_view = NULL;
	GeeArrayList* created_views = NULL;
	DataView* _tmp32_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (IS_SOURCE_COLLECTION (sources));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
	created_view = NULL;
	created_views = NULL;
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (added);
		_source_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataSource* source = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			CreateView factory = NULL;
			gpointer factory_target;
			GDestroyNotify factory_target_destroy_notify;
			CreateView _tmp17_;
			gpointer _tmp17__target;
			_tmp1_ = _source_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _source_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			source = (DataSource*) _tmp3_;
			factory = NULL;
			factory_target = NULL;
			factory_target_destroy_notify = NULL;
			{
				GeeIterator* _monitor_it = NULL;
				GeeHashMultiMap* _tmp4_;
				GeeCollection* _tmp5_;
				GeeCollection* _tmp6_;
				GeeIterator* _tmp7_;
				GeeIterator* _tmp8_;
				_tmp4_ = self->priv->monitors;
				_tmp5_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_MULTI_MAP, GeeMultiMap), sources);
				_tmp6_ = _tmp5_;
				_tmp7_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ITERABLE, GeeIterable));
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp6_);
				_monitor_it = _tmp8_;
				while (TRUE) {
					GeeIterator* _tmp9_;
					ViewCollectionMonitorImpl* monitor = NULL;
					GeeIterator* _tmp10_;
					gpointer _tmp11_;
					ViewCollectionMonitorImpl* _tmp12_;
					ViewManager* _tmp13_;
					DataSource* _tmp14_;
					_tmp9_ = _monitor_it;
					if (!gee_iterator_next (_tmp9_)) {
						break;
					}
					_tmp10_ = _monitor_it;
					_tmp11_ = gee_iterator_get (_tmp10_);
					monitor = (ViewCollectionMonitorImpl*) _tmp11_;
					_tmp12_ = monitor;
					_tmp13_ = _tmp12_->manager;
					_tmp14_ = source;
					if (view_manager_include_in_view (_tmp13_, _tmp14_)) {
						ViewCollectionMonitorImpl* _tmp15_;
						ViewManager* _tmp16_;
						_tmp15_ = monitor;
						_tmp16_ = _tmp15_->manager;
						(factory_target_destroy_notify == NULL) ? NULL : (factory_target_destroy_notify (factory_target), NULL);
						factory = NULL;
						factory_target = NULL;
						factory_target_destroy_notify = NULL;
						factory = _view_manager_create_view_create_view;
						factory_target = view_manager_ref (_tmp16_);
						factory_target_destroy_notify = view_manager_unref;
						_view_collection_monitor_unref0 (monitor);
						break;
					}
					_view_collection_monitor_unref0 (monitor);
				}
				_g_object_unref0 (_monitor_it);
			}
			_tmp17_ = factory;
			_tmp17__target = factory_target;
			if (_tmp17_ != NULL) {
				DataView* new_view = NULL;
				CreateView _tmp18_;
				gpointer _tmp18__target;
				DataSource* _tmp19_;
				DataView* _tmp20_;
				GeeArrayList* _tmp21_;
				_tmp18_ = factory;
				_tmp18__target = factory_target;
				_tmp19_ = source;
				_tmp20_ = _tmp18_ (_tmp19_, _tmp18__target);
				new_view = _tmp20_;
				_tmp21_ = created_views;
				if (_tmp21_ != NULL) {
					GeeArrayList* _tmp22_;
					DataView* _tmp23_;
					_tmp22_ = created_views;
					_tmp23_ = new_view;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp23_);
				} else {
					DataView* _tmp24_;
					_tmp24_ = created_view;
					if (_tmp24_ == NULL) {
						DataView* _tmp25_;
						DataView* _tmp26_;
						_tmp25_ = new_view;
						_tmp26_ = _g_object_ref0 (_tmp25_);
						_g_object_unref0 (created_view);
						created_view = _tmp26_;
					} else {
						GeeArrayList* _tmp27_;
						GeeArrayList* _tmp28_;
						DataView* _tmp29_;
						GeeArrayList* _tmp30_;
						DataView* _tmp31_;
						_tmp27_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
						_g_object_unref0 (created_views);
						created_views = _tmp27_;
						_tmp28_ = created_views;
						_tmp29_ = created_view;
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp29_);
						_g_object_unref0 (created_view);
						created_view = NULL;
						_tmp30_ = created_views;
						_tmp31_ = new_view;
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp31_);
					}
				}
				_g_object_unref0 (new_view);
			}
			(factory_target_destroy_notify == NULL) ? NULL : (factory_target_destroy_notify (factory_target), NULL);
			factory = NULL;
			factory_target = NULL;
			factory_target_destroy_notify = NULL;
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp32_ = created_view;
	if (_tmp32_ != NULL) {
		DataView* _tmp33_;
		_tmp33_ = created_view;
		data_collection_add (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TYPE_DATA_OBJECT, DataObject));
	} else {
		gboolean _tmp34_ = FALSE;
		GeeArrayList* _tmp35_;
		_tmp35_ = created_views;
		if (_tmp35_ != NULL) {
			GeeArrayList* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			_tmp36_ = created_views;
			_tmp37_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp38_ = _tmp37_;
			_tmp34_ = _tmp38_ > 0;
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			GeeArrayList* _tmp39_;
			GeeCollection* _tmp40_;
			GeeCollection* _tmp41_;
			_tmp39_ = created_views;
			_tmp40_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_COLLECTION, GeeCollection), progress_monitor, progress_monitor_target);
			_tmp41_ = _tmp40_;
			_g_object_unref0 (_tmp41_);
		}
	}
	_g_object_unref0 (created_views);
	_g_object_unref0 (created_view);
}

static gboolean
view_collection_real_add (DataCollection* base,
                          DataObject* object)
{
	ViewCollection * self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	data_view_internal_set_visible (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView), TRUE);
	if (!DATA_COLLECTION_CLASS (view_collection_parent_class)->add (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), object)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = data_collection_get_singleton (object);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	view_collection_filter_altered_items (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	result = TRUE;
	return result;
}

static GeeCollection*
view_collection_real_add_many (DataCollection* base,
                               GeeCollection* objects,
                               ProgressMonitor monitor,
                               gpointer monitor_target)
{
	ViewCollection * self;
	GeeCollection* return_list = NULL;
	GeeCollection* _tmp5_;
	GeeCollection* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (objects, GEE_TYPE_COLLECTION), NULL);
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (objects, GEE_TYPE_ITERABLE, GeeIterable));
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataObject* _tmp4_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = object;
			data_view_internal_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_VIEW, DataView), TRUE);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp5_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), objects, monitor, monitor_target);
	return_list = _tmp5_;
	view_collection_filter_altered_items (self, G_TYPE_CHECK_INSTANCE_CAST (return_list, GEE_TYPE_COLLECTION, GeeCollection));
	result = return_list;
	return result;
}

static void
view_collection_on_sources_removed (ViewCollection* self,
                                    GeeIterable* removed)
{
	Marker* marker = NULL;
	gboolean _tmp12_ = FALSE;
	Marker* _tmp13_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
	marker = NULL;
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (removed);
		_source_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataSource* source = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataView* view = NULL;
			GeeHashMap* _tmp4_;
			DataSource* _tmp5_;
			gpointer _tmp6_;
			DataView* _tmp7_;
			_tmp1_ = _source_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _source_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			source = (DataSource*) _tmp3_;
			_tmp4_ = self->priv->source_map;
			_tmp5_ = source;
			_tmp6_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp5_);
			view = (DataView*) _tmp6_;
			_tmp7_ = view;
			if (_tmp7_ != NULL) {
				Marker* _tmp8_;
				Marker* _tmp10_;
				DataView* _tmp11_;
				_tmp8_ = marker;
				if (_tmp8_ == NULL) {
					Marker* _tmp9_;
					_tmp9_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
					_g_object_unref0 (marker);
					marker = _tmp9_;
				}
				_tmp10_ = marker;
				_tmp11_ = view;
				marker_mark (_tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_OBJECT, DataObject));
			}
			_g_object_unref0 (view);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp13_ = marker;
	if (_tmp13_ != NULL) {
		Marker* _tmp14_;
		_tmp14_ = marker;
		_tmp12_ = marker_get_count (_tmp14_) != 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		Marker* _tmp15_;
		_tmp15_ = marker;
		data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp15_);
	}
	_g_object_unref0 (marker);
}

static void
view_collection_on_sources_altered (ViewCollection* self,
                                    DataCollection* collection,
                                    GeeMap* items)
{
	GeeArrayList* to_add = NULL;
	GeeArrayList* to_remove = NULL;
	gboolean ordering_changed = FALSE;
	GeeArrayList* _tmp68_;
	GeeArrayList* _tmp72_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (IS_DATA_COLLECTION (collection));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (items, GEE_TYPE_MAP));
	to_add = NULL;
	to_remove = NULL;
	ordering_changed = FALSE;
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (items);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Alteration* alteration = NULL;
			DataObject* _tmp8_;
			gpointer _tmp9_;
			DataSource* source = NULL;
			DataObject* _tmp10_;
			DataSource* _tmp11_;
			ViewCollectionMonitorImpl* monitor = NULL;
			gboolean ignored = FALSE;
			gboolean _tmp32_ = FALSE;
			ViewCollectionMonitorImpl* _tmp33_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = gee_map_get (items, _tmp8_);
			alteration = (Alteration*) _tmp9_;
			_tmp10_ = object;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_SOURCE, DataSource));
			source = _tmp11_;
			monitor = NULL;
			ignored = TRUE;
			{
				GeeIterator* _monitor_impl_it = NULL;
				GeeHashMultiMap* _tmp12_;
				GeeCollection* _tmp13_;
				GeeCollection* _tmp14_;
				GeeIterator* _tmp15_;
				GeeIterator* _tmp16_;
				_tmp12_ = self->priv->monitors;
				_tmp13_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_MULTI_MAP, GeeMultiMap), G_TYPE_CHECK_INSTANCE_CAST (collection, TYPE_SOURCE_COLLECTION, SourceCollection));
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ITERABLE, GeeIterable));
				_tmp16_ = _tmp15_;
				_g_object_unref0 (_tmp14_);
				_monitor_impl_it = _tmp16_;
				while (TRUE) {
					GeeIterator* _tmp17_;
					ViewCollectionMonitorImpl* monitor_impl = NULL;
					GeeIterator* _tmp18_;
					gpointer _tmp19_;
					gboolean _tmp20_ = FALSE;
					ViewCollectionMonitorImpl* _tmp21_;
					Alteration* _tmp22_;
					ViewCollectionMonitorImpl* _tmp26_;
					ViewManager* _tmp27_;
					DataSource* _tmp28_;
					_tmp17_ = _monitor_impl_it;
					if (!gee_iterator_next (_tmp17_)) {
						break;
					}
					_tmp18_ = _monitor_impl_it;
					_tmp19_ = gee_iterator_get (_tmp18_);
					monitor_impl = (ViewCollectionMonitorImpl*) _tmp19_;
					_tmp21_ = monitor_impl;
					_tmp22_ = _tmp21_->prereq;
					if (_tmp22_ != NULL) {
						Alteration* _tmp23_;
						ViewCollectionMonitorImpl* _tmp24_;
						Alteration* _tmp25_;
						_tmp23_ = alteration;
						_tmp24_ = monitor_impl;
						_tmp25_ = _tmp24_->prereq;
						_tmp20_ = !alteration_contains_any (_tmp23_, _tmp25_);
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
						_view_collection_monitor_unref0 (monitor_impl);
						continue;
					}
					ignored = FALSE;
					_tmp26_ = monitor_impl;
					_tmp27_ = _tmp26_->manager;
					_tmp28_ = source;
					if (view_manager_include_in_view (_tmp27_, _tmp28_)) {
						ViewCollectionMonitorImpl* _tmp29_;
						ViewCollectionMonitorImpl* _tmp30_;
						_tmp29_ = monitor_impl;
						_tmp30_ = _view_collection_monitor_ref0 (_tmp29_);
						_view_collection_monitor_unref0 (monitor);
						monitor = _tmp30_;
						_view_collection_monitor_unref0 (monitor_impl);
						break;
					}
					_view_collection_monitor_unref0 (monitor_impl);
				}
				_g_object_unref0 (_monitor_impl_it);
			}
			if (ignored) {
				ViewCollectionMonitorImpl* _tmp31_;
				_tmp31_ = monitor;
				_vala_assert (_tmp31_ == NULL, "monitor == null");
				_view_collection_monitor_unref0 (monitor);
				_g_object_unref0 (source);
				_alteration_unref0 (alteration);
				_g_object_unref0 (object);
				continue;
			}
			_tmp33_ = monitor;
			if (_tmp33_ != NULL) {
				DataSource* _tmp34_;
				_tmp34_ = source;
				_tmp32_ = !view_collection_has_view_for_source (self, _tmp34_);
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				GeeArrayList* _tmp35_;
				GeeArrayList* _tmp37_;
				ViewCollectionMonitorImpl* _tmp38_;
				ViewManager* _tmp39_;
				DataSource* _tmp40_;
				DataView* _tmp41_;
				DataView* _tmp42_;
				_tmp35_ = to_add;
				if (_tmp35_ == NULL) {
					GeeArrayList* _tmp36_;
					_tmp36_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (to_add);
					to_add = _tmp36_;
				}
				_tmp37_ = to_add;
				_tmp38_ = monitor;
				_tmp39_ = _tmp38_->manager;
				_tmp40_ = source;
				_tmp41_ = view_manager_create_view (_tmp39_, _tmp40_);
				_tmp42_ = _tmp41_;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp42_);
				_g_object_unref0 (_tmp42_);
			} else {
				gboolean _tmp43_ = FALSE;
				ViewCollectionMonitorImpl* _tmp44_;
				_tmp44_ = monitor;
				if (_tmp44_ == NULL) {
					DataSource* _tmp45_;
					_tmp45_ = source;
					_tmp43_ = view_collection_has_view_for_source (self, _tmp45_);
				} else {
					_tmp43_ = FALSE;
				}
				if (_tmp43_) {
					GeeArrayList* _tmp46_;
					GeeArrayList* _tmp48_;
					DataSource* _tmp49_;
					DataView* _tmp50_;
					DataView* _tmp51_;
					_tmp46_ = to_remove;
					if (_tmp46_ == NULL) {
						GeeArrayList* _tmp47_;
						_tmp47_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
						_g_object_unref0 (to_remove);
						to_remove = _tmp47_;
					}
					_tmp48_ = to_remove;
					_tmp49_ = source;
					_tmp50_ = view_collection_get_view_for_source (self, _tmp49_);
					_tmp51_ = _tmp50_;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp51_);
					_g_object_unref0 (_tmp51_);
				} else {
					gboolean _tmp52_ = FALSE;
					ViewCollectionMonitorImpl* _tmp53_;
					_tmp53_ = monitor;
					if (_tmp53_ != NULL) {
						DataSource* _tmp54_;
						_tmp54_ = source;
						_tmp52_ = view_collection_has_view_for_source (self, _tmp54_);
					} else {
						_tmp52_ = FALSE;
					}
					if (_tmp52_) {
						DataView* view = NULL;
						DataSource* _tmp55_;
						DataView* _tmp56_;
						DataSet* _tmp57_;
						DataView* _tmp58_;
						gboolean _tmp62_ = FALSE;
						DataSet* _tmp63_;
						_tmp55_ = source;
						_tmp56_ = view_collection_get_view_for_source (self, _tmp55_);
						view = _tmp56_;
						_tmp57_ = self->priv->selected;
						_tmp58_ = view;
						if (data_set_contains (_tmp57_, G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, TYPE_DATA_OBJECT, DataObject))) {
							DataSet* _tmp59_;
							DataView* _tmp60_;
							Alteration* _tmp61_;
							_tmp59_ = self->priv->selected;
							_tmp60_ = view;
							_tmp61_ = alteration;
							data_set_resort_object (_tmp59_, G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, TYPE_DATA_OBJECT, DataObject), _tmp61_);
						}
						_tmp63_ = self->priv->visible;
						if (_tmp63_ != NULL) {
							DataView* _tmp64_;
							_tmp64_ = view;
							_tmp62_ = view_collection_is_visible (self, _tmp64_);
						} else {
							_tmp62_ = FALSE;
						}
						if (_tmp62_) {
							DataSet* _tmp65_;
							DataView* _tmp66_;
							Alteration* _tmp67_;
							_tmp65_ = self->priv->visible;
							_tmp66_ = view;
							_tmp67_ = alteration;
							if (data_set_resort_object (_tmp65_, G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, TYPE_DATA_OBJECT, DataObject), _tmp67_)) {
								ordering_changed = TRUE;
							}
						}
						_g_object_unref0 (view);
					}
				}
			}
			_view_collection_monitor_unref0 (monitor);
			_g_object_unref0 (source);
			_alteration_unref0 (alteration);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp68_ = to_add;
	if (_tmp68_ != NULL) {
		GeeArrayList* _tmp69_;
		GeeCollection* _tmp70_;
		GeeCollection* _tmp71_;
		_tmp69_ = to_add;
		_tmp70_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
		_tmp71_ = _tmp70_;
		_g_object_unref0 (_tmp71_);
	}
	_tmp72_ = to_remove;
	if (_tmp72_ != NULL) {
		GeeArrayList* _tmp73_;
		Marker* _tmp74_;
		Marker* _tmp75_;
		_tmp73_ = to_remove;
		_tmp74_ = data_collection_mark_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp75_ = _tmp74_;
		data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp75_);
		_g_object_unref0 (_tmp75_);
	}
	if (ordering_changed) {
		data_collection_notify_ordering_changed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	}
	_g_object_unref0 (to_remove);
	_g_object_unref0 (to_add);
}

static void
view_collection_on_mirror_contents_added (ViewCollection* self,
                                          GeeIterable* added)
{
	GeeArrayList* to_add = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	to_add = _tmp0_;
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (added);
		_object_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			DataObject* object = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			DataSource* source = NULL;
			DataObject* _tmp5_;
			DataSource* _tmp6_;
			gboolean _tmp7_ = FALSE;
			CreateViewPredicate _tmp8_;
			gpointer _tmp8__target;
			_tmp2_ = _object_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _object_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			object = (DataObject*) _tmp4_;
			_tmp5_ = object;
			_tmp6_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_VIEW, DataView));
			source = _tmp6_;
			_tmp8_ = self->priv->should_mirror;
			_tmp8__target = self->priv->should_mirror_target;
			if (_tmp8_ == NULL) {
				_tmp7_ = TRUE;
			} else {
				CreateViewPredicate _tmp9_;
				gpointer _tmp9__target;
				DataSource* _tmp10_;
				_tmp9_ = self->priv->should_mirror;
				_tmp9__target = self->priv->should_mirror_target;
				_tmp10_ = source;
				_tmp7_ = _tmp9_ (_tmp10_, _tmp9__target);
			}
			if (_tmp7_) {
				GeeArrayList* _tmp11_;
				CreateView _tmp12_;
				gpointer _tmp12__target;
				DataSource* _tmp13_;
				DataView* _tmp14_;
				DataView* _tmp15_;
				_tmp11_ = to_add;
				_tmp12_ = self->priv->mirroring_ctor;
				_tmp12__target = self->priv->mirroring_ctor_target;
				_tmp13_ = source;
				_tmp14_ = _tmp12_ (_tmp13_, _tmp12__target);
				_tmp15_ = _tmp14_;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp15_);
				_g_object_unref0 (_tmp15_);
			}
			_g_object_unref0 (source);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp16_ = to_add;
	_tmp17_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp18_ = _tmp17_;
	if (_tmp18_ > 0) {
		GeeArrayList* _tmp19_;
		GeeCollection* _tmp20_;
		GeeCollection* _tmp21_;
		_tmp19_ = to_add;
		_tmp20_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
		_tmp21_ = _tmp20_;
		_g_object_unref0 (_tmp21_);
	}
	_g_object_unref0 (to_add);
}

static void
view_collection_on_mirror_contents_removed (ViewCollection* self,
                                            GeeIterable* removed)
{
	Marker* marker = NULL;
	Marker* _tmp0_;
	Marker* _tmp15_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
	_tmp0_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	marker = _tmp0_;
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (removed);
		_object_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			DataObject* object = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			DataView* view = NULL;
			DataObject* _tmp5_;
			DataView* _tmp6_;
			DataView* our_view = NULL;
			DataView* _tmp7_;
			DataSource* _tmp8_;
			DataSource* _tmp9_;
			DataView* _tmp10_;
			DataView* _tmp11_;
			DataView* _tmp12_;
			Marker* _tmp13_;
			DataView* _tmp14_;
			_tmp2_ = _object_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _object_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			object = (DataObject*) _tmp4_;
			_tmp5_ = object;
			_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_VIEW, DataView));
			view = _tmp6_;
			_tmp7_ = view;
			_tmp8_ = data_view_get_source (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = view_collection_get_view_for_source (self, _tmp9_);
			_tmp11_ = _tmp10_;
			_g_object_unref0 (_tmp9_);
			our_view = _tmp11_;
			_tmp12_ = our_view;
			_vala_assert (_tmp12_ != NULL, "our_view != null");
			_tmp13_ = marker;
			_tmp14_ = our_view;
			marker_mark (_tmp13_, G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DATA_OBJECT, DataObject));
			_g_object_unref0 (our_view);
			_g_object_unref0 (view);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp15_ = marker;
	data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp15_);
	_g_object_unref0 (marker);
}

static void
view_collection_real_notify_items_added (DataCollection* base,
                                         GeeIterable* added)
{
	ViewCollection * self;
	GeeArrayList* added_visible = NULL;
	GeeArrayList* added_selected = NULL;
	GeeArrayList* _tmp25_;
	GeeArrayList* _tmp27_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
	added_visible = NULL;
	added_selected = NULL;
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (added);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataView* view = NULL;
			DataObject* _tmp4_;
			DataView* _tmp5_;
			GeeHashMap* _tmp6_;
			DataView* _tmp7_;
			DataSource* _tmp8_;
			DataSource* _tmp9_;
			DataView* _tmp10_;
			gboolean _tmp11_ = FALSE;
			DataView* _tmp12_;
			gboolean _tmp18_ = FALSE;
			DataView* _tmp19_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = object;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_VIEW, DataView));
			view = _tmp5_;
			_tmp6_ = self->priv->source_map;
			_tmp7_ = view;
			_tmp8_ = data_view_get_source (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = view;
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_, _tmp10_);
			_g_object_unref0 (_tmp9_);
			_tmp12_ = view;
			if (data_view_is_selected (_tmp12_)) {
				DataView* _tmp13_;
				_tmp13_ = view;
				_tmp11_ = data_view_is_visible (_tmp13_);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				GeeArrayList* _tmp14_;
				GeeArrayList* _tmp16_;
				DataView* _tmp17_;
				_tmp14_ = added_selected;
				if (_tmp14_ == NULL) {
					GeeArrayList* _tmp15_;
					_tmp15_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (added_selected);
					added_selected = _tmp15_;
				}
				_tmp16_ = added_selected;
				_tmp17_ = view;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp17_);
			}
			_tmp19_ = view;
			if (data_view_is_visible (_tmp19_)) {
				DataSet* _tmp20_;
				_tmp20_ = self->priv->visible;
				_tmp18_ = _tmp20_ != NULL;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				GeeArrayList* _tmp21_;
				GeeArrayList* _tmp23_;
				DataView* _tmp24_;
				_tmp21_ = added_visible;
				if (_tmp21_ == NULL) {
					GeeArrayList* _tmp22_;
					_tmp22_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (added_visible);
					added_visible = _tmp22_;
				}
				_tmp23_ = added_visible;
				_tmp24_ = view;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp24_);
			}
			_g_object_unref0 (view);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp25_ = added_visible;
	if (_tmp25_ != NULL) {
		gboolean is_added = FALSE;
		GeeArrayList* _tmp26_;
		_tmp26_ = added_visible;
		is_added = view_collection_add_many_visible (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_COLLECTION, GeeCollection));
		_vala_assert (is_added, "is_added");
	}
	_tmp27_ = added_selected;
	if (_tmp27_ != NULL) {
		GeeArrayList* _tmp28_;
		GeeArrayList* _tmp29_;
		_tmp28_ = added_selected;
		view_collection_add_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp29_ = added_selected;
		view_collection_notify_items_selected_unselected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_COLLECTION, GeeCollection), NULL);
	}
	DATA_COLLECTION_CLASS (view_collection_parent_class)->notify_items_added (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), added);
	_g_object_unref0 (added_selected);
	_g_object_unref0 (added_visible);
}

static void
view_collection_real_notify_items_removed (DataCollection* base,
                                           GeeIterable* removed)
{
	ViewCollection * self;
	GeeArrayList* selected_removed = NULL;
	GeeArrayList* _tmp30_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
	selected_removed = NULL;
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (removed);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataView* view = NULL;
			DataObject* _tmp4_;
			DataView* _tmp5_;
			GeeHashMap* _tmp6_;
			DataView* _tmp7_;
			DataSource* _tmp8_;
			DataSource* _tmp9_;
			gboolean _tmp10_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = object;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_VIEW, DataView));
			view = _tmp5_;
			_tmp6_ = self->priv->source_map;
			_tmp7_ = view;
			_tmp8_ = data_view_get_source (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_);
			_g_object_unref0 (_tmp9_);
			if (_tmp10_) {
				gboolean is_removed = FALSE;
				GeeHashMap* _tmp11_;
				DataView* _tmp12_;
				DataSource* _tmp13_;
				DataSource* _tmp14_;
				gboolean _tmp15_;
				DataView* _tmp16_;
				gboolean _tmp25_ = FALSE;
				DataView* _tmp26_;
				_tmp11_ = self->priv->source_map;
				_tmp12_ = view;
				_tmp13_ = data_view_get_source (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp14_, NULL);
				_g_object_unref0 (_tmp14_);
				is_removed = _tmp15_;
				_vala_assert (is_removed, "is_removed");
				_tmp16_ = view;
				if (data_view_is_selected (_tmp16_)) {
					DataSet* _tmp17_;
					DataView* _tmp18_;
					DataView* _tmp19_;
					DataView* _tmp20_;
					_tmp17_ = self->priv->selected;
					_tmp18_ = view;
					_tmp19_ = view;
					_vala_assert (data_set_contains (_tmp17_, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_DATA_OBJECT, DataObject)) == data_view_is_visible (_tmp19_), "selected.contains(view) == view.is_visible()");
					_tmp20_ = view;
					if (data_view_is_visible (_tmp20_)) {
						GeeArrayList* _tmp21_;
						GeeArrayList* _tmp23_;
						DataView* _tmp24_;
						_tmp21_ = selected_removed;
						if (_tmp21_ == NULL) {
							GeeArrayList* _tmp22_;
							_tmp22_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
							_g_object_unref0 (selected_removed);
							selected_removed = _tmp22_;
						}
						_tmp23_ = selected_removed;
						_tmp24_ = view;
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp24_);
					}
				}
				_tmp26_ = view;
				if (data_view_is_visible (_tmp26_)) {
					DataSet* _tmp27_;
					_tmp27_ = self->priv->visible;
					_tmp25_ = _tmp27_ != NULL;
				} else {
					_tmp25_ = FALSE;
				}
				if (_tmp25_) {
					DataSet* _tmp28_;
					DataView* _tmp29_;
					_tmp28_ = self->priv->visible;
					_tmp29_ = view;
					is_removed = data_set_remove (_tmp28_, G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_DATA_OBJECT, DataObject));
					_vala_assert (is_removed, "is_removed");
				}
			}
			_g_object_unref0 (view);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp30_ = selected_removed;
	if (_tmp30_ != NULL) {
		GeeArrayList* _tmp31_;
		_tmp31_ = selected_removed;
		view_collection_remove_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_COLLECTION, GeeCollection));
		view_collection_notify_selection_group_altered (self);
	}
	DATA_COLLECTION_CLASS (view_collection_parent_class)->notify_items_removed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), removed);
	_g_object_unref0 (selected_removed);
}

static void
view_collection_filter_altered_items (ViewCollection* self,
                                      GeeCollection* views)
{
	GeeArrayList* to_show = NULL;
	GeeArrayList* to_hide = NULL;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp17_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (views, GEE_TYPE_COLLECTION));
	to_show = NULL;
	to_hide = NULL;
	{
		GeeIterator* _view_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (views, GEE_TYPE_ITERABLE, GeeIterable));
		_view_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataView* view = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataView* _tmp4_;
			_tmp1_ = _view_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _view_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			view = (DataView*) _tmp3_;
			_tmp4_ = view;
			if (view_collection_is_in_filter (self, _tmp4_)) {
				DataView* _tmp5_;
				_tmp5_ = view;
				if (!data_view_is_visible (_tmp5_)) {
					GeeArrayList* _tmp6_;
					GeeArrayList* _tmp8_;
					DataView* _tmp9_;
					_tmp6_ = to_show;
					if (_tmp6_ == NULL) {
						GeeArrayList* _tmp7_;
						_tmp7_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
						_g_object_unref0 (to_show);
						to_show = _tmp7_;
					}
					_tmp8_ = to_show;
					_tmp9_ = view;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp9_);
				}
			} else {
				DataView* _tmp10_;
				_tmp10_ = view;
				if (data_view_is_visible (_tmp10_)) {
					GeeArrayList* _tmp11_;
					GeeArrayList* _tmp13_;
					DataView* _tmp14_;
					_tmp11_ = to_hide;
					if (_tmp11_ == NULL) {
						GeeArrayList* _tmp12_;
						_tmp12_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
						_g_object_unref0 (to_hide);
						to_hide = _tmp12_;
					}
					_tmp13_ = to_hide;
					_tmp14_ = view;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp14_);
				}
			}
			_g_object_unref0 (view);
		}
		_g_object_unref0 (_view_it);
	}
	_tmp15_ = to_show;
	if (_tmp15_ != NULL) {
		GeeArrayList* _tmp16_;
		_tmp16_ = to_show;
		view_collection_show_items (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_LIST, GeeList));
	}
	_tmp17_ = to_hide;
	if (_tmp17_ != NULL) {
		GeeArrayList* _tmp18_;
		_tmp18_ = to_hide;
		view_collection_hide_items (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_LIST, GeeList));
	}
	_g_object_unref0 (to_hide);
	_g_object_unref0 (to_show);
}

static void
view_collection_real_items_altered (DataCollection* base,
                                    GeeMap* map)
{
	ViewCollection * self;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeCollection* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (map, GEE_TYPE_MAP));
	_tmp0_ = gee_map_get_keys (map);
	_tmp1_ = _tmp0_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
	view_collection_filter_altered_items (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	DATA_COLLECTION_CLASS (view_collection_parent_class)->items_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), map);
}

static void
view_collection_real_set_comparator (DataCollection* base,
                                     Comparator comparator,
                                     gpointer comparator_target,
                                     ComparatorPredicate predicate,
                                     gpointer predicate_target)
{
	ViewCollection * self;
	DataSet* _tmp0_;
	DataSet* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
	_tmp0_ = self->priv->selected;
	data_set_set_comparator (_tmp0_, comparator, comparator_target, predicate, predicate_target);
	_tmp1_ = self->priv->visible;
	if (_tmp1_ != NULL) {
		DataSet* _tmp2_;
		_tmp2_ = self->priv->visible;
		data_set_set_comparator (_tmp2_, comparator, comparator_target, predicate, predicate_target);
	}
	DATA_COLLECTION_CLASS (view_collection_parent_class)->set_comparator (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), comparator, comparator_target, predicate, predicate_target);
}

static void
view_collection_real_reset_comparator (DataCollection* base)
{
	ViewCollection * self;
	DataSet* _tmp0_;
	DataSet* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
	_tmp0_ = self->priv->selected;
	data_set_reset_comparator (_tmp0_);
	_tmp1_ = self->priv->visible;
	if (_tmp1_ != NULL) {
		DataSet* _tmp2_;
		_tmp2_ = self->priv->visible;
		data_set_reset_comparator (_tmp2_);
	}
	DATA_COLLECTION_CLASS (view_collection_parent_class)->reset_comparator (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
}

static GeeCollection*
view_collection_real_get_all (DataCollection* base)
{
	ViewCollection * self;
	GeeCollection* _tmp0_ = NULL;
	DataSet* _tmp1_;
	GeeCollection* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
	_tmp1_ = self->priv->visible;
	if (_tmp1_ != NULL) {
		DataSet* _tmp2_;
		GeeList* _tmp3_;
		_tmp2_ = self->priv->visible;
		_tmp3_ = data_set_get_all (_tmp2_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
	} else {
		GeeCollection* _tmp4_;
		_tmp4_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

GeeCollection*
view_collection_get_all_unfiltered (ViewCollection* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	_tmp0_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	result = _tmp0_;
	return result;
}

static gint
view_collection_real_get_count (DataCollection* base)
{
	ViewCollection * self;
	gint _tmp0_ = 0;
	DataSet* _tmp1_;
	gint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
	_tmp1_ = self->priv->visible;
	if (_tmp1_ != NULL) {
		DataSet* _tmp2_;
		_tmp2_ = self->priv->visible;
		_tmp0_ = data_set_get_count (_tmp2_);
	} else {
		_tmp0_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	}
	result = _tmp0_;
	return result;
}

gint
view_collection_get_unfiltered_count (ViewCollection* self)
{
	gint result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), 0);
	result = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	return result;
}

static DataObject*
view_collection_real_get_at (DataCollection* base,
                             gint index)
{
	ViewCollection * self;
	DataObject* _tmp0_ = NULL;
	DataSet* _tmp1_;
	DataObject* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
	_tmp1_ = self->priv->visible;
	if (_tmp1_ != NULL) {
		DataSet* _tmp2_;
		DataObject* _tmp3_;
		_tmp2_ = self->priv->visible;
		_tmp3_ = data_set_get_at (_tmp2_, index);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		DataObject* _tmp4_;
		_tmp4_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_at (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), index);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

static gint
view_collection_real_index_of (DataCollection* base,
                               DataObject* object)
{
	ViewCollection * self;
	gint _tmp0_ = 0;
	DataSet* _tmp1_;
	gint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
	g_return_val_if_fail (IS_DATA_OBJECT (object), 0);
	_tmp1_ = self->priv->visible;
	if (_tmp1_ != NULL) {
		DataSet* _tmp2_;
		_tmp2_ = self->priv->visible;
		_tmp0_ = data_set_index_of (_tmp2_, object);
	} else {
		_tmp0_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->index_of (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), object);
	}
	result = _tmp0_;
	return result;
}

static gboolean
view_collection_real_contains (DataCollection* base,
                               DataObject* object)
{
	ViewCollection * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	if (!DATA_COLLECTION_CLASS (view_collection_parent_class)->contains (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), object)) {
		result = FALSE;
		return result;
	}
	result = view_collection_is_visible (self, G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	return result;
}

static DataView*
view_collection_real_get_first (ViewCollection* self)
{
	DataView* _tmp0_ = NULL;
	DataView* result;
	if (data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection)) > 0) {
		DataObject* _tmp1_;
		_tmp1_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), 0);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_VIEW, DataView);
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

DataView*
view_collection_get_first (ViewCollection* self)
{
	ViewCollectionClass* _klass_;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->get_first) {
		return _klass_->get_first (self);
	}
	return NULL;
}

/**
     * @brief A helper method for places in the app that need a
     *  non-rejected media source (namely Events, when looking to
     *  automatically choose a thumbnail).
     *
     * @note If every view in this collection is rejected, we
     *  return the first view; this is intentional.  This prevents
     *  pathological events that have nothing but rejected images
     *  in them from breaking.
     */
static DataView*
view_collection_real_get_first_unrejected (ViewCollection* self)
{
	DataView* dv = NULL;
	DataView* _tmp0_;
	gint num_views = 0;
	DataView* _tmp12_;
	DataView* result;
	if (data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection)) < 1) {
		result = NULL;
		return result;
	}
	_tmp0_ = view_collection_get_first (self);
	dv = _tmp0_;
	num_views = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		DataView* _tmp2_;
		MediaSource* tmp = NULL;
		DataView* _tmp4_;
		DataSource* _tmp5_;
		MediaSource* _tmp6_;
		gboolean _tmp7_ = FALSE;
		MediaSource* _tmp8_;
		_tmp2_ = dv;
		if (_tmp2_ != NULL) {
			DataView* _tmp3_;
			_tmp3_ = dv;
			_tmp1_ = data_collection_index_of (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_OBJECT, DataObject)) < (num_views - 1);
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp4_ = dv;
		_tmp5_ = data_view_get_source (_tmp4_);
		_tmp6_ = IS_MEDIA_SOURCE (_tmp5_) ? ((MediaSource*) _tmp5_) : NULL;
		if (_tmp6_ == NULL) {
			_g_object_unref0 (_tmp5_);
		}
		tmp = _tmp6_;
		_tmp8_ = tmp;
		if (_tmp8_ != NULL) {
			MediaSource* _tmp9_;
			_tmp9_ = tmp;
			_tmp7_ = media_source_get_rating (_tmp9_) != RATING_REJECTED;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			result = dv;
			_g_object_unref0 (tmp);
			return result;
		} else {
			DataView* _tmp10_;
			DataView* _tmp11_;
			_tmp10_ = dv;
			_tmp11_ = view_collection_get_next (self, _tmp10_, NULL);
			_g_object_unref0 (dv);
			dv = _tmp11_;
		}
		_g_object_unref0 (tmp);
	}
	_tmp12_ = view_collection_get_first (self);
	result = _tmp12_;
	_g_object_unref0 (dv);
	return result;
}

DataView*
view_collection_get_first_unrejected (ViewCollection* self)
{
	ViewCollectionClass* _klass_;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->get_first_unrejected) {
		return _klass_->get_first_unrejected (self);
	}
	return NULL;
}

static DataView*
view_collection_real_get_first_photo (ViewCollection* self)
{
	DataView* dv = NULL;
	DataView* _tmp0_;
	gint num_views = 0;
	DataView* result;
	if (data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection)) < 1) {
		result = NULL;
		return result;
	}
	_tmp0_ = view_collection_get_first (self);
	dv = _tmp0_;
	num_views = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		DataView* _tmp2_;
		DataView* _tmp4_;
		DataSource* _tmp5_;
		DataSource* _tmp6_;
		gboolean _tmp7_;
		_tmp2_ = dv;
		if (_tmp2_ != NULL) {
			DataView* _tmp3_;
			_tmp3_ = dv;
			_tmp1_ = data_collection_index_of (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_OBJECT, DataObject)) < num_views;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp4_ = dv;
		_tmp5_ = data_view_get_source (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = IS_PHOTO_SOURCE (_tmp6_);
		_g_object_unref0 (_tmp6_);
		if (_tmp7_) {
			result = dv;
			return result;
		} else {
			DataView* _tmp8_;
			DataView* _tmp9_;
			_tmp8_ = dv;
			_tmp9_ = view_collection_get_next (self, _tmp8_, NULL);
			_g_object_unref0 (dv);
			dv = _tmp9_;
		}
	}
	result = NULL;
	_g_object_unref0 (dv);
	return result;
}

DataView*
view_collection_get_first_photo (ViewCollection* self)
{
	ViewCollectionClass* _klass_;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->get_first_photo) {
		return _klass_->get_first_photo (self);
	}
	return NULL;
}

static DataView*
view_collection_real_get_last (ViewCollection* self)
{
	DataView* _tmp0_ = NULL;
	DataView* result;
	if (data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection)) > 0) {
		DataObject* _tmp1_;
		_tmp1_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection)) - 1);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_VIEW, DataView);
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

DataView*
view_collection_get_last (ViewCollection* self)
{
	ViewCollectionClass* _klass_;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->get_last) {
		return _klass_->get_last (self);
	}
	return NULL;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static DataView*
view_collection_real_get_next (ViewCollection* self,
                               DataView* view,
                               gboolean** wrapped)
{
	gboolean* _vala_wrapped = NULL;
	gboolean _tmp0_;
	gboolean* _tmp1_;
	gint index = 0;
	gint _tmp2_;
	DataObject* _tmp5_;
	DataView* result;
	g_return_val_if_fail (IS_DATA_VIEW (view), NULL);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (_vala_wrapped);
	_vala_wrapped = _tmp1_;
	if (data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection)) == 0) {
		result = NULL;
		if (wrapped) {
			*wrapped = _vala_wrapped;
		} else {
			_g_free0 (_vala_wrapped);
		}
		return result;
	}
	index = data_collection_index_of (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (view, TYPE_DATA_OBJECT, DataObject));
	if (index < 0) {
		result = NULL;
		if (wrapped) {
			*wrapped = _vala_wrapped;
		} else {
			_g_free0 (_vala_wrapped);
		}
		return result;
	}
	_tmp2_ = index;
	index = _tmp2_ + 1;
	if (index >= data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection))) {
		gboolean _tmp3_;
		gboolean* _tmp4_;
		index = 0;
		_tmp3_ = TRUE;
		_tmp4_ = __bool_dup0 (&_tmp3_);
		_g_free0 (_vala_wrapped);
		_vala_wrapped = _tmp4_;
	}
	_tmp5_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), index);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_VIEW, DataView);
	if (wrapped) {
		*wrapped = _vala_wrapped;
	} else {
		_g_free0 (_vala_wrapped);
	}
	return result;
}

DataView*
view_collection_get_next (ViewCollection* self,
                          DataView* view,
                          gboolean** wrapped)
{
	ViewCollectionClass* _klass_;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->get_next) {
		return _klass_->get_next (self, view, wrapped);
	}
	return NULL;
}

static DataView*
view_collection_real_get_previous (ViewCollection* self,
                                   DataView* view)
{
	gint index = 0;
	gint _tmp0_;
	DataObject* _tmp1_;
	DataView* result;
	g_return_val_if_fail (IS_DATA_VIEW (view), NULL);
	if (data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection)) == 0) {
		result = NULL;
		return result;
	}
	index = data_collection_index_of (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (view, TYPE_DATA_OBJECT, DataObject));
	if (index < 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = index;
	index = _tmp0_ - 1;
	if (index < 0) {
		index = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection)) - 1;
	}
	_tmp1_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), index);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_VIEW, DataView);
	return result;
}

DataView*
view_collection_get_previous (ViewCollection* self,
                              DataView* view)
{
	ViewCollectionClass* _klass_;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->get_previous) {
		return _klass_->get_previous (self, view);
	}
	return NULL;
}

gboolean
view_collection_get_immediate_neighbors (ViewCollection* self,
                                         DataSource* home,
                                         DataSource** next,
                                         DataSource** prev,
                                         const gchar* type_selector)
{
	DataSource* _vala_next = NULL;
	DataSource* _vala_prev = NULL;
	DataView* home_view = NULL;
	DataView* _tmp0_;
	DataView* _tmp1_;
	DataView* next_view = NULL;
	DataView* _tmp2_;
	DataView* _tmp3_;
	DataView* prev_view = NULL;
	DataView* _tmp16_;
	DataView* _tmp17_;
	gboolean result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
	g_return_val_if_fail (IS_DATA_SOURCE (home), FALSE);
	_g_object_unref0 (_vala_next);
	_vala_next = NULL;
	_g_object_unref0 (_vala_prev);
	_vala_prev = NULL;
	_tmp0_ = view_collection_get_view_for_source (self, home);
	home_view = _tmp0_;
	_tmp1_ = home_view;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (home_view);
		if (next) {
			*next = _vala_next;
		} else {
			_g_object_unref0 (_vala_next);
		}
		if (prev) {
			*prev = _vala_prev;
		} else {
			_g_object_unref0 (_vala_prev);
		}
		return result;
	}
	_tmp2_ = home_view;
	_tmp3_ = view_collection_get_next (self, _tmp2_, NULL);
	next_view = _tmp3_;
	while (TRUE) {
		DataView* _tmp4_;
		DataView* _tmp5_;
		gboolean _tmp6_ = FALSE;
		DataView* _tmp14_;
		DataView* _tmp15_;
		_tmp4_ = next_view;
		_tmp5_ = home_view;
		if (!(_tmp4_ != _tmp5_)) {
			break;
		}
		if (type_selector == NULL) {
			_tmp6_ = TRUE;
		} else {
			DataView* _tmp7_;
			DataSource* _tmp8_;
			DataSource* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = next_view;
			_tmp8_ = data_view_get_source (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = data_source_get_typename (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp6_ = g_strcmp0 (_tmp11_, type_selector) == 0;
			_g_free0 (_tmp11_);
			_g_object_unref0 (_tmp9_);
		}
		if (_tmp6_) {
			DataView* _tmp12_;
			DataSource* _tmp13_;
			_tmp12_ = next_view;
			_tmp13_ = data_view_get_source (_tmp12_);
			_g_object_unref0 (_vala_next);
			_vala_next = _tmp13_;
			break;
		}
		_tmp14_ = next_view;
		_tmp15_ = view_collection_get_next (self, _tmp14_, NULL);
		_g_object_unref0 (next_view);
		next_view = _tmp15_;
	}
	_tmp16_ = home_view;
	_tmp17_ = view_collection_get_previous (self, _tmp16_);
	prev_view = _tmp17_;
	while (TRUE) {
		DataView* _tmp18_;
		DataView* _tmp19_;
		gboolean _tmp20_ = FALSE;
		DataView* _tmp28_;
		DataView* _tmp29_;
		_tmp18_ = prev_view;
		_tmp19_ = home_view;
		if (!(_tmp18_ != _tmp19_)) {
			break;
		}
		if (type_selector == NULL) {
			_tmp20_ = TRUE;
		} else {
			DataView* _tmp21_;
			DataSource* _tmp22_;
			DataSource* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp21_ = prev_view;
			_tmp22_ = data_view_get_source (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = data_source_get_typename (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp20_ = g_strcmp0 (_tmp25_, type_selector) == 0;
			_g_free0 (_tmp25_);
			_g_object_unref0 (_tmp23_);
		}
		if (_tmp20_) {
			DataView* _tmp26_;
			DataSource* _tmp27_;
			_tmp26_ = prev_view;
			_tmp27_ = data_view_get_source (_tmp26_);
			_g_object_unref0 (_vala_prev);
			_vala_prev = _tmp27_;
			break;
		}
		_tmp28_ = prev_view;
		_tmp29_ = view_collection_get_previous (self, _tmp28_);
		_g_object_unref0 (prev_view);
		prev_view = _tmp29_;
	}
	result = TRUE;
	_g_object_unref0 (prev_view);
	_g_object_unref0 (next_view);
	_g_object_unref0 (home_view);
	if (next) {
		*next = _vala_next;
	} else {
		_g_object_unref0 (_vala_next);
	}
	if (prev) {
		*prev = _vala_prev;
	} else {
		_g_object_unref0 (_vala_prev);
	}
	return result;
}

GeeSet*
view_collection_get_extended_neighbors (ViewCollection* self,
                                        DataSource* home,
                                        const gchar* typename)
{
	GeeSet* neighbors = NULL;
	GeeHashSet* _tmp0_;
	DataSource* next = NULL;
	DataSource* prev = NULL;
	DataSource* _tmp1_ = NULL;
	DataSource* _tmp2_ = NULL;
	gboolean _tmp3_;
	DataSource* _tmp4_;
	DataSource* _tmp13_;
	GeeSet* _tmp22_;
	GeeSet* result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	g_return_val_if_fail (IS_DATA_SOURCE (home), NULL);
	_tmp0_ = gee_hash_set_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	neighbors = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SET, GeeSet);
	_tmp3_ = view_collection_get_immediate_neighbors (self, home, &_tmp1_, &_tmp2_, typename);
	_g_object_unref0 (next);
	next = _tmp1_;
	_g_object_unref0 (prev);
	prev = _tmp2_;
	if (!_tmp3_) {
		result = neighbors;
		_g_object_unref0 (prev);
		_g_object_unref0 (next);
		return result;
	}
	_tmp4_ = next;
	if (_tmp4_ != NULL) {
		GeeSet* _tmp5_;
		DataSource* _tmp6_;
		DataSource* next_next = NULL;
		DataSource* next_prev = NULL;
		DataSource* _tmp7_;
		DataSource* _tmp8_ = NULL;
		DataSource* _tmp9_ = NULL;
		DataSource* _tmp10_;
		_tmp5_ = neighbors;
		_tmp6_ = next;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection), _tmp6_);
		_tmp7_ = next;
		view_collection_get_immediate_neighbors (self, _tmp7_, &_tmp8_, &_tmp9_, typename);
		_g_object_unref0 (next_next);
		next_next = _tmp8_;
		_g_object_unref0 (next_prev);
		next_prev = _tmp9_;
		_tmp10_ = next_next;
		if (_tmp10_ != NULL) {
			GeeSet* _tmp11_;
			DataSource* _tmp12_;
			_tmp11_ = neighbors;
			_tmp12_ = next_next;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection), _tmp12_);
		}
		_g_object_unref0 (next_prev);
		_g_object_unref0 (next_next);
	}
	_tmp13_ = prev;
	if (_tmp13_ != NULL) {
		GeeSet* _tmp14_;
		DataSource* _tmp15_;
		DataSource* next_prev = NULL;
		DataSource* prev_prev = NULL;
		DataSource* _tmp16_;
		DataSource* _tmp17_ = NULL;
		DataSource* _tmp18_ = NULL;
		DataSource* _tmp19_;
		_tmp14_ = neighbors;
		_tmp15_ = prev;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_COLLECTION, GeeCollection), _tmp15_);
		_tmp16_ = prev;
		view_collection_get_immediate_neighbors (self, _tmp16_, &_tmp17_, &_tmp18_, typename);
		_g_object_unref0 (next_prev);
		next_prev = _tmp17_;
		_g_object_unref0 (prev_prev);
		prev_prev = _tmp18_;
		_tmp19_ = prev_prev;
		if (_tmp19_ != NULL) {
			GeeSet* _tmp20_;
			DataSource* _tmp21_;
			_tmp20_ = neighbors;
			_tmp21_ = prev_prev;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection), _tmp21_);
		}
		_g_object_unref0 (prev_prev);
		_g_object_unref0 (next_prev);
	}
	_tmp22_ = neighbors;
	gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_COLLECTION, GeeCollection), home);
	result = neighbors;
	_g_object_unref0 (prev);
	_g_object_unref0 (next);
	return result;
}

static void
view_collection_add_many_selected (ViewCollection* self,
                                   GeeCollection* views)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean added = FALSE;
	DataSet* _tmp7_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (views, GEE_TYPE_COLLECTION));
	_tmp0_ = gee_collection_get_size (views);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	{
		GeeIterator* _view_it = NULL;
		GeeIterator* _tmp2_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (views, GEE_TYPE_ITERABLE, GeeIterable));
		_view_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			DataView* view = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			DataView* _tmp6_;
			_tmp3_ = _view_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _view_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			view = (DataView*) _tmp5_;
			_tmp6_ = view;
			_vala_assert (data_view_is_visible (_tmp6_), "view.is_visible()");
			_g_object_unref0 (view);
		}
		_g_object_unref0 (_view_it);
	}
	_tmp7_ = self->priv->selected;
	added = data_set_add_many (_tmp7_, views);
	_vala_assert (added, "added");
}

static void
view_collection_remove_many_selected (ViewCollection* self,
                                      GeeCollection* views)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean removed = FALSE;
	DataSet* _tmp2_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (views, GEE_TYPE_COLLECTION));
	_tmp0_ = gee_collection_get_size (views);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	_tmp2_ = self->priv->selected;
	removed = data_set_remove_many (_tmp2_, views);
	_vala_assert (removed, "removed");
}

static gboolean
_view_collection_select_item_marked_action (DataObject* object,
                                            GObject* user,
                                            gpointer self)
{
	gboolean result;
	result = view_collection_select_item ((ViewCollection*) self, object, user);
	return result;
}

void
view_collection_select_marked (ViewCollection* self,
                               Marker* marker)
{
	GeeArrayList* selected = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (IS_MARKER (marker));
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	selected = _tmp0_;
	_tmp1_ = selected;
	data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), marker, _view_collection_select_item_marked_action, self, NULL, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject));
	_tmp2_ = selected;
	_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		_tmp5_ = selected;
		view_collection_add_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp6_ = selected;
		view_collection_notify_items_selected_unselected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection), NULL);
	}
	_g_object_unref0 (selected);
}

void
view_collection_select_all (ViewCollection* self)
{
	Marker* marker = NULL;
	Marker* _tmp0_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	_tmp0_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	marker = _tmp0_;
	marker_mark_all (marker);
	view_collection_select_marked (self, marker);
	_g_object_unref0 (marker);
}

static gboolean
view_collection_select_item (ViewCollection* self,
                             DataObject* object,
                             GObject* user)
{
	DataView* view = NULL;
	DataView* _tmp0_;
	DataView* _tmp1_;
	DataView* _tmp5_;
	DataView* _tmp6_;
	gboolean result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	g_return_val_if_fail ((user == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (user, G_TYPE_OBJECT), FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	view = _tmp0_;
	_tmp1_ = view;
	if (data_view_is_selected (_tmp1_)) {
		DataView* _tmp2_;
		_tmp2_ = view;
		if (data_view_is_visible (_tmp2_)) {
			DataSet* _tmp3_;
			DataView* _tmp4_;
			_tmp3_ = self->priv->selected;
			_tmp4_ = view;
			_vala_assert (data_set_contains (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject)), "selected.contains(view)");
		}
		result = TRUE;
		_g_object_unref0 (view);
		return result;
	}
	_tmp5_ = view;
	data_view_internal_set_selected (_tmp5_, TRUE);
	_tmp6_ = view;
	if (data_view_is_visible (_tmp6_)) {
		DataView* _tmp7_;
		_tmp7_ = view;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (user, GEE_TYPE_ARRAY_LIST, GeeArrayList), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp7_);
	}
	result = TRUE;
	_g_object_unref0 (view);
	return result;
}

static gboolean
_view_collection_unselect_item_marked_action (DataObject* object,
                                              GObject* user,
                                              gpointer self)
{
	gboolean result;
	result = view_collection_unselect_item ((ViewCollection*) self, object, user);
	return result;
}

void
view_collection_unselect_marked (ViewCollection* self,
                                 Marker* marker)
{
	GeeArrayList* unselected = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (IS_MARKER (marker));
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	unselected = _tmp0_;
	_tmp1_ = unselected;
	data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), marker, _view_collection_unselect_item_marked_action, self, NULL, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject));
	_tmp2_ = unselected;
	_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		_tmp5_ = unselected;
		view_collection_remove_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp6_ = unselected;
		view_collection_notify_items_selected_unselected (self, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
	}
	_g_object_unref0 (unselected);
}

void
view_collection_unselect_all (ViewCollection* self)
{
	DataSet* _tmp0_;
	Marker* marker = NULL;
	Marker* _tmp1_;
	Marker* _tmp2_;
	GeeList* _tmp3_;
	GeeList* _tmp4_;
	Marker* _tmp5_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	_tmp0_ = self->priv->selected;
	if (data_set_get_count (_tmp0_) == 0) {
		return;
	}
	_tmp1_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	marker = _tmp1_;
	_tmp2_ = marker;
	_tmp3_ = view_collection_get_selected (self);
	_tmp4_ = _tmp3_;
	marker_mark_many (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
	_g_object_unref0 (_tmp4_);
	_tmp5_ = marker;
	view_collection_unselect_marked (self, _tmp5_);
	_g_object_unref0 (marker);
}

void
view_collection_unselect_all_but (ViewCollection* self,
                                  DataView* exception)
{
	Marker* marker = NULL;
	Marker* _tmp0_;
	Marker* _tmp13_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (IS_DATA_VIEW (exception));
	_tmp0_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	marker = _tmp0_;
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp1_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			DataView* view = NULL;
			DataObject* _tmp8_;
			DataView* _tmp9_;
			DataView* _tmp10_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_VIEW, DataView));
			view = _tmp9_;
			_tmp10_ = view;
			if (_tmp10_ != exception) {
				Marker* _tmp11_;
				DataView* _tmp12_;
				_tmp11_ = marker;
				_tmp12_ = view;
				marker_mark (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DATA_OBJECT, DataObject));
			}
			_g_object_unref0 (view);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp13_ = marker;
	view_collection_unselect_marked (self, _tmp13_);
	_g_object_unref0 (marker);
}

static gboolean
view_collection_unselect_item (ViewCollection* self,
                               DataObject* object,
                               GObject* user)
{
	DataView* view = NULL;
	DataView* _tmp0_;
	DataView* _tmp1_;
	DataView* _tmp4_;
	DataView* _tmp5_;
	gboolean result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	g_return_val_if_fail ((user == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (user, G_TYPE_OBJECT), FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	view = _tmp0_;
	_tmp1_ = view;
	if (!data_view_is_selected (_tmp1_)) {
		DataSet* _tmp2_;
		DataView* _tmp3_;
		_tmp2_ = self->priv->selected;
		_tmp3_ = view;
		_vala_assert (!data_set_contains (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_OBJECT, DataObject)), "!selected.contains(view)");
		result = TRUE;
		_g_object_unref0 (view);
		return result;
	}
	_tmp4_ = view;
	data_view_internal_set_selected (_tmp4_, FALSE);
	_tmp5_ = view;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (user, GEE_TYPE_ARRAY_LIST, GeeArrayList), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp5_);
	result = TRUE;
	_g_object_unref0 (view);
	return result;
}

void
view_collection_unselect_and_select_marked (ViewCollection* self,
                                            Marker* unselect,
                                            Marker* select)
{
	GeeArrayList* unselected = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* selected = NULL;
	GeeArrayList* _tmp1_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (IS_MARKER (unselect));
	g_return_if_fail (IS_MARKER (select));
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	unselected = _tmp0_;
	data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), unselect, _view_collection_unselect_item_marked_action, self, NULL, NULL, G_TYPE_CHECK_INSTANCE_CAST (unselected, G_TYPE_OBJECT, GObject));
	view_collection_remove_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (unselected, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp1_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	selected = _tmp1_;
	data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), select, _view_collection_select_item_marked_action, self, NULL, NULL, G_TYPE_CHECK_INSTANCE_CAST (selected, G_TYPE_OBJECT, GObject));
	view_collection_add_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (selected, GEE_TYPE_COLLECTION, GeeCollection));
	view_collection_notify_items_selected_unselected (self, G_TYPE_CHECK_INSTANCE_CAST (selected, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (unselected, GEE_TYPE_COLLECTION, GeeCollection));
	_g_object_unref0 (selected);
	_g_object_unref0 (unselected);
}

static gboolean
_view_collection_toggle_item_marked_action (DataObject* object,
                                            GObject* user,
                                            gpointer self)
{
	gboolean result;
	result = view_collection_toggle_item ((ViewCollection*) self, object, user);
	return result;
}

void
view_collection_toggle_marked (ViewCollection* self,
                               Marker* marker)
{
	ViewCollectionToggleLists* lists = NULL;
	ViewCollectionToggleLists* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (IS_MARKER (marker));
	_tmp0_ = view_collection_toggle_lists_new ();
	lists = _tmp0_;
	data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), marker, _view_collection_toggle_item_marked_action, self, NULL, NULL, G_TYPE_CHECK_INSTANCE_CAST (lists, G_TYPE_OBJECT, GObject));
	_tmp1_ = lists->selected;
	view_collection_add_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = lists->unselected;
	view_collection_remove_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp3_ = lists->selected;
	_tmp4_ = lists->unselected;
	view_collection_notify_items_selected_unselected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
	_g_object_unref0 (lists);
}

static gboolean
view_collection_toggle_item (ViewCollection* self,
                             DataObject* object,
                             GObject* user)
{
	DataView* view = NULL;
	DataView* _tmp0_;
	ViewCollectionToggleLists* lists = NULL;
	ViewCollectionToggleLists* _tmp1_;
	DataView* _tmp2_;
	gboolean result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	g_return_val_if_fail ((user == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (user, G_TYPE_OBJECT), FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	view = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (user, VIEW_COLLECTION_TYPE_TOGGLE_LISTS, ViewCollectionToggleLists));
	lists = _tmp1_;
	_tmp2_ = view;
	if (data_view_internal_toggle (_tmp2_)) {
		DataView* _tmp3_;
		_tmp3_ = view;
		if (data_view_is_visible (_tmp3_)) {
			ViewCollectionToggleLists* _tmp4_;
			GeeArrayList* _tmp5_;
			DataView* _tmp6_;
			_tmp4_ = lists;
			_tmp5_ = _tmp4_->selected;
			_tmp6_ = view;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp6_);
		}
	} else {
		ViewCollectionToggleLists* _tmp7_;
		GeeArrayList* _tmp8_;
		DataView* _tmp9_;
		_tmp7_ = lists;
		_tmp8_ = _tmp7_->unselected;
		_tmp9_ = view;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp9_);
	}
	result = TRUE;
	_g_object_unref0 (lists);
	_g_object_unref0 (view);
	return result;
}

gint
view_collection_get_selected_count (ViewCollection* self)
{
	DataSet* _tmp0_;
	gint result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), 0);
	_tmp0_ = self->priv->selected;
	result = data_set_get_count (_tmp0_);
	return result;
}

GeeList*
view_collection_get_selected (ViewCollection* self)
{
	DataSet* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	_tmp0_ = self->priv->selected;
	_tmp1_ = data_set_get_all (_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_LIST, GeeList);
	return result;
}

DataView*
view_collection_get_selected_at (ViewCollection* self,
                                 gint index)
{
	DataSet* _tmp0_;
	DataObject* _tmp1_;
	DataView* result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	_tmp0_ = self->priv->selected;
	_tmp1_ = data_set_get_at (_tmp0_, index);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_VIEW, DataView);
	return result;
}

static gboolean
view_collection_is_visible (ViewCollection* self,
                            DataView* view)
{
	gboolean _tmp0_ = FALSE;
	DataSet* _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
	g_return_val_if_fail (IS_DATA_VIEW (view), FALSE);
	_tmp1_ = self->priv->visible;
	if (_tmp1_ != NULL) {
		DataSet* _tmp2_;
		_tmp2_ = self->priv->visible;
		_tmp0_ = data_set_contains (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (view, TYPE_DATA_OBJECT, DataObject));
	} else {
		_tmp0_ = TRUE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
view_collection_add_many_visible (ViewCollection* self,
                                  GeeCollection* many)
{
	DataSet* _tmp0_;
	DataSet* _tmp1_;
	DataSet* _tmp2_;
	gboolean result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (many, GEE_TYPE_COLLECTION), FALSE);
	_tmp0_ = self->priv->visible;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->visible;
	if (!data_set_add_many (_tmp1_, many)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->visible;
	if (data_set_get_count (_tmp2_) == DATA_COLLECTION_CLASS (view_collection_parent_class)->get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection))) {
		_data_set_unref0 (self->priv->visible);
		self->priv->visible = NULL;
	}
	result = TRUE;
	return result;
}

static void
view_collection_hide_items (ViewCollection* self,
                            GeeList* to_hide)
{
	GeeArrayList* unselected = NULL;
	GeeArrayList* _tmp0_;
	gint count = 0;
	gint _tmp1_;
	gint _tmp2_;
	DataSet* _tmp14_;
	gboolean removed = FALSE;
	DataSet* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp22_;
	gint _tmp23_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_hide, GEE_TYPE_LIST));
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	unselected = _tmp0_;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (to_hide, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	count = _tmp2_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				DataView* view = NULL;
				gpointer _tmp5_;
				DataView* _tmp6_;
				DataView* _tmp7_;
				DataView* _tmp13_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = ctr;
					ctr = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp5_ = gee_list_get (to_hide, ctr);
				view = (DataView*) _tmp5_;
				_tmp6_ = view;
				_vala_assert (data_view_is_visible (_tmp6_), "view.is_visible()");
				_tmp7_ = view;
				if (data_view_is_selected (_tmp7_)) {
					DataView* _tmp8_;
					GeeArrayList* _tmp9_;
					DataView* _tmp10_;
					_tmp8_ = view;
					data_view_internal_set_selected (_tmp8_, FALSE);
					_tmp9_ = unselected;
					_tmp10_ = view;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp10_);
				} else {
					DataSet* _tmp11_;
					DataView* _tmp12_;
					_tmp11_ = self->priv->selected;
					_tmp12_ = view;
					_vala_assert (!data_set_contains (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DATA_OBJECT, DataObject)), "!selected.contains(view)");
				}
				_tmp13_ = view;
				data_view_internal_set_visible (_tmp13_, FALSE);
				_g_object_unref0 (view);
			}
		}
	}
	_tmp14_ = self->priv->visible;
	if (_tmp14_ == NULL) {
		DataSet* _tmp15_;
		_tmp15_ = data_collection_get_dataset_copy (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
		_data_set_unref0 (self->priv->visible);
		self->priv->visible = _tmp15_;
	}
	_tmp16_ = self->priv->visible;
	removed = data_set_remove_many (_tmp16_, G_TYPE_CHECK_INSTANCE_CAST (to_hide, GEE_TYPE_COLLECTION, GeeCollection));
	_vala_assert (removed, "removed");
	_tmp17_ = unselected;
	view_collection_remove_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp18_ = unselected;
	_tmp19_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp20_ = _tmp19_;
	if (_tmp20_ > 0) {
		GeeArrayList* _tmp21_;
		_tmp21_ = unselected;
		view_collection_notify_items_selected_unselected (self, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
	}
	_tmp22_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (to_hide, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp23_ = _tmp22_;
	if (_tmp23_ > 0) {
		view_collection_notify_items_hidden (self, G_TYPE_CHECK_INSTANCE_CAST (to_hide, GEE_TYPE_COLLECTION, GeeCollection));
		view_collection_notify_items_visibility_changed (self, G_TYPE_CHECK_INSTANCE_CAST (to_hide, GEE_TYPE_COLLECTION, GeeCollection));
	}
	_g_object_unref0 (unselected);
}

static void
view_collection_show_items (ViewCollection* self,
                            GeeList* to_show)
{
	GeeArrayList* added_selected = NULL;
	GeeArrayList* _tmp0_;
	gint count = 0;
	gint _tmp1_;
	gint _tmp2_;
	gboolean added = FALSE;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_show, GEE_TYPE_LIST));
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	added_selected = _tmp0_;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (to_show, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	count = _tmp2_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				DataView* view = NULL;
				gpointer _tmp5_;
				DataView* _tmp6_;
				DataView* _tmp7_;
				DataView* _tmp8_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = ctr;
					ctr = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp5_ = gee_list_get (to_show, ctr);
				view = (DataView*) _tmp5_;
				_tmp6_ = view;
				_vala_assert (!data_view_is_visible (_tmp6_), "!view.is_visible()");
				_tmp7_ = view;
				data_view_internal_set_visible (_tmp7_, TRUE);
				_tmp8_ = view;
				if (data_view_is_selected (_tmp8_)) {
					DataSet* _tmp9_;
					DataView* _tmp10_;
					GeeArrayList* _tmp11_;
					DataView* _tmp12_;
					_tmp9_ = self->priv->selected;
					_tmp10_ = view;
					_vala_assert (!data_set_contains (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_OBJECT, DataObject)), "!selected.contains(view)");
					_tmp11_ = added_selected;
					_tmp12_ = view;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp12_);
				}
				_g_object_unref0 (view);
			}
		}
	}
	added = view_collection_add_many_visible (self, G_TYPE_CHECK_INSTANCE_CAST (to_show, GEE_TYPE_COLLECTION, GeeCollection));
	_vala_assert (added, "added");
	_tmp13_ = added_selected;
	view_collection_add_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp14_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (to_show, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp15_ = _tmp14_;
	if (_tmp15_ > 0) {
		view_collection_notify_items_shown (self, G_TYPE_CHECK_INSTANCE_CAST (to_show, GEE_TYPE_COLLECTION, GeeCollection));
		view_collection_notify_items_visibility_changed (self, G_TYPE_CHECK_INSTANCE_CAST (to_show, GEE_TYPE_COLLECTION, GeeCollection));
	}
	_g_object_unref0 (added_selected);
}

gboolean
view_collection_has_view_for_source (ViewCollection* self,
                                     DataSource* source)
{
	DataView* _tmp0_;
	DataView* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
	_tmp0_ = view_collection_get_view_for_source (self, source);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

DataView*
view_collection_get_view_for_source (ViewCollection* self,
                                     DataSource* source)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	DataView* result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	g_return_val_if_fail (IS_DATA_SOURCE (source), NULL);
	_tmp0_ = self->priv->source_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), source);
	result = (DataView*) _tmp1_;
	return result;
}

gboolean
view_collection_has_view_for_source_with_filtered (ViewCollection* self,
                                                   DataSource* source)
{
	DataView* _tmp0_;
	DataView* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
	_tmp0_ = view_collection_get_view_for_source_filtered (self, source);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

DataView*
view_collection_get_view_for_source_filtered (ViewCollection* self,
                                              DataSource* source)
{
	DataView* view = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
	DataView* _tmp3_;
	DataView* result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	g_return_val_if_fail (IS_DATA_SOURCE (source), NULL);
	_tmp0_ = self->priv->source_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), source);
	view = (DataView*) _tmp1_;
	_tmp3_ = view;
	if (_tmp3_ != NULL) {
		DataView* _tmp4_;
		_tmp4_ = view;
		_tmp2_ = !view_collection_is_in_filter (self, _tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = NULL;
		_g_object_unref0 (view);
		return result;
	}
	result = view;
	return result;
}

GeeCollection*
view_collection_get_sources (ViewCollection* self)
{
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	_tmp0_ = self->priv->source_map;
	_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_set_get_read_only_view (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection);
	_g_object_unref0 (_tmp3_);
	result = _tmp6_;
	return result;
}

gboolean
view_collection_has_source_of_type (ViewCollection* self,
                                    GType t)
{
	gboolean result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
	_vala_assert (g_type_is_a (t, TYPE_DATA_SOURCE), "t.is_a(typeof(DataSource))");
	{
		GeeIterator* _source_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->source_map;
		_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_source_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			DataSource* source = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			DataSource* _tmp9_;
			_tmp6_ = _source_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _source_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			source = (DataSource*) _tmp8_;
			_tmp9_ = source;
			if (g_type_is_a (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, G_TYPE_OBJECT, GObject)), t)) {
				result = TRUE;
				_g_object_unref0 (source);
				_g_object_unref0 (_source_it);
				return result;
			}
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	result = FALSE;
	return result;
}

gint
view_collection_get_sources_of_type_count (ViewCollection* self,
                                           GType t)
{
	gint count = 0;
	gint result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), 0);
	_vala_assert (g_type_is_a (t, TYPE_DATA_SOURCE), "t.is_a(typeof(DataSource))");
	count = 0;
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_object_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			DataObject* object = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			DataObject* _tmp7_;
			DataSource* _tmp8_;
			DataSource* _tmp9_;
			gboolean _tmp10_;
			_tmp4_ = _object_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _object_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			object = (DataObject*) _tmp6_;
			_tmp7_ = object;
			_tmp8_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_VIEW, DataView));
			_tmp9_ = _tmp8_;
			_tmp10_ = g_type_is_a (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, G_TYPE_OBJECT, GObject)), t);
			_g_object_unref0 (_tmp9_);
			if (_tmp10_) {
				gint _tmp11_;
				_tmp11_ = count;
				count = _tmp11_ + 1;
			}
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	result = count;
	return result;
}

GeeList*
view_collection_get_sources_of_type (ViewCollection* self,
                                     GType t)
{
	GeeList* sources = NULL;
	GeeList* result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	_vala_assert (g_type_is_a (t, TYPE_DATA_SOURCE), "t.is_a(typeof(DataSource))");
	sources = NULL;
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_object_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			DataObject* object = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			DataSource* source = NULL;
			DataObject* _tmp7_;
			DataSource* _tmp8_;
			DataSource* _tmp9_;
			_tmp4_ = _object_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _object_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			object = (DataObject*) _tmp6_;
			_tmp7_ = object;
			_tmp8_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_VIEW, DataView));
			source = _tmp8_;
			_tmp9_ = source;
			if (g_type_is_a (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, G_TYPE_OBJECT, GObject)), t)) {
				GeeList* _tmp10_;
				GeeList* _tmp12_;
				DataSource* _tmp13_;
				_tmp10_ = sources;
				if (_tmp10_ == NULL) {
					GeeArrayList* _tmp11_;
					_tmp11_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (sources);
					sources = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_LIST, GeeList);
				}
				_tmp12_ = sources;
				_tmp13_ = source;
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection), _tmp13_);
			}
			_g_object_unref0 (source);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	result = sources;
	return result;
}

GeeList*
view_collection_get_selected_sources (ViewCollection* self)
{
	GeeList* sources = NULL;
	GeeArrayList* _tmp0_;
	gint count = 0;
	DataSet* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	_tmp0_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	sources = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	_tmp1_ = self->priv->selected;
	count = data_set_get_count (_tmp1_);
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GeeList* _tmp4_;
				DataSet* _tmp5_;
				DataObject* _tmp6_;
				DataView* _tmp7_;
				DataSource* _tmp8_;
				DataSource* _tmp9_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = ctr;
					ctr = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp4_ = sources;
				_tmp5_ = self->priv->selected;
				_tmp6_ = data_set_get_at (_tmp5_, ctr);
				_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_VIEW, DataView);
				_tmp8_ = data_view_get_source (_tmp7_);
				_tmp9_ = _tmp8_;
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), _tmp9_);
				_g_object_unref0 (_tmp9_);
				_g_object_unref0 (_tmp7_);
			}
		}
	}
	result = sources;
	return result;
}

DataSource*
view_collection_get_selected_source_at (ViewCollection* self,
                                        gint index)
{
	DataObject* object = NULL;
	DataSet* _tmp0_;
	DataObject* _tmp1_;
	DataSource* _tmp2_ = NULL;
	DataObject* _tmp3_;
	DataSource* result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	_tmp0_ = self->priv->selected;
	_tmp1_ = data_set_get_at (_tmp0_, index);
	object = _tmp1_;
	_tmp3_ = object;
	if (_tmp3_ != NULL) {
		DataObject* _tmp4_;
		DataSource* _tmp5_;
		_tmp4_ = object;
		_tmp5_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_VIEW, DataView));
		_g_object_unref0 (_tmp2_);
		_tmp2_ = _tmp5_;
	} else {
		_g_object_unref0 (_tmp2_);
		_tmp2_ = NULL;
	}
	result = _tmp2_;
	_g_object_unref0 (object);
	return result;
}

GeeList*
view_collection_get_selected_sources_of_type (ViewCollection* self,
                                              GType t)
{
	GeeList* sources = NULL;
	GeeList* result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
	sources = NULL;
	{
		GeeList* _view_list = NULL;
		GeeList* _tmp0_;
		gint _view_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _view_index = 0;
		_tmp0_ = view_collection_get_selected (self);
		_view_list = _tmp0_;
		_tmp1_ = _view_list;
		_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp3_ = _tmp2_;
		_view_size = _tmp3_;
		_view_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			DataView* view = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			DataSource* source = NULL;
			DataView* _tmp8_;
			DataSource* _tmp9_;
			DataSource* _tmp10_;
			_view_index = _view_index + 1;
			_tmp4_ = _view_index;
			_tmp5_ = _view_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _view_list;
			_tmp7_ = gee_list_get (_tmp6_, _view_index);
			view = (DataView*) _tmp7_;
			_tmp8_ = view;
			_tmp9_ = data_view_get_source (_tmp8_);
			source = _tmp9_;
			_tmp10_ = source;
			if (g_type_is_a (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, G_TYPE_OBJECT, GObject)), t)) {
				GeeList* _tmp11_;
				GeeList* _tmp13_;
				DataSource* _tmp14_;
				_tmp11_ = sources;
				if (_tmp11_ == NULL) {
					GeeArrayList* _tmp12_;
					_tmp12_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (sources);
					sources = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_LIST, GeeList);
				}
				_tmp13_ = sources;
				_tmp14_ = source;
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_COLLECTION, GeeCollection), _tmp14_);
			}
			_g_object_unref0 (source);
			_g_object_unref0 (view);
		}
		_g_object_unref0 (_view_list);
	}
	result = sources;
	return result;
}

gint
view_collection_index_of_source (ViewCollection* self,
                                 DataSource* source)
{
	DataView* view = NULL;
	DataView* _tmp0_;
	gint _tmp1_ = 0;
	DataView* _tmp2_;
	gint result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), 0);
	g_return_val_if_fail (IS_DATA_SOURCE (source), 0);
	_tmp0_ = view_collection_get_view_for_source (self, source);
	view = _tmp0_;
	_tmp2_ = view;
	if (_tmp2_ != NULL) {
		DataView* _tmp3_;
		_tmp3_ = view;
		_tmp1_ = data_collection_index_of (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_OBJECT, DataObject));
	} else {
		_tmp1_ = -1;
	}
	result = _tmp1_;
	_g_object_unref0 (view);
	return result;
}

void
view_collection_internal_notify_view_altered (ViewCollection* self,
                                              DataView* view)
{
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (IS_DATA_VIEW (view));
	if (!data_collection_are_notifications_frozen (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection))) {
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		view_collection_notify_item_view_altered (self, view);
		_tmp0_ = data_collection_get_singleton (G_TYPE_CHECK_INSTANCE_CAST (view, TYPE_DATA_OBJECT, DataObject));
		_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
		view_collection_notify_views_altered (self, _tmp1_);
		_g_object_unref0 (_tmp1_);
	} else {
		GeeHashSet* _tmp2_;
		GeeHashSet* _tmp4_;
		_tmp2_ = self->priv->frozen_views_altered;
		if (_tmp2_ == NULL) {
			GeeHashSet* _tmp3_;
			_tmp3_ = gee_hash_set_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
			_g_object_unref0 (self->priv->frozen_views_altered);
			self->priv->frozen_views_altered = _tmp3_;
		}
		_tmp4_ = self->priv->frozen_views_altered;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), view);
	}
}

void
view_collection_internal_notify_geometry_altered (ViewCollection* self,
                                                  DataView* view)
{
	g_return_if_fail (IS_VIEW_COLLECTION (self));
	g_return_if_fail (IS_DATA_VIEW (view));
	if (!data_collection_are_notifications_frozen (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection))) {
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		view_collection_notify_item_geometry_altered (self, view);
		_tmp0_ = data_collection_get_singleton (G_TYPE_CHECK_INSTANCE_CAST (view, TYPE_DATA_OBJECT, DataObject));
		_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
		view_collection_notify_geometries_altered (self, _tmp1_);
		_g_object_unref0 (_tmp1_);
	} else {
		GeeHashSet* _tmp2_;
		GeeHashSet* _tmp4_;
		_tmp2_ = self->priv->frozen_geometries_altered;
		if (_tmp2_ == NULL) {
			GeeHashSet* _tmp3_;
			_tmp3_ = gee_hash_set_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
			_g_object_unref0 (self->priv->frozen_geometries_altered);
			self->priv->frozen_geometries_altered = _tmp3_;
		}
		_tmp4_ = self->priv->frozen_geometries_altered;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), view);
	}
}

static void
view_collection_real_notify_thawed (DataCollection* base)
{
	ViewCollection * self;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp8_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
	_tmp0_ = self->priv->frozen_views_altered;
	if (_tmp0_ != NULL) {
		GeeHashSet* _tmp7_;
		{
			GeeIterator* _view_it = NULL;
			GeeHashSet* _tmp1_;
			GeeIterator* _tmp2_;
			_tmp1_ = self->priv->frozen_views_altered;
			_tmp2_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_view_it = _tmp2_;
			while (TRUE) {
				GeeIterator* _tmp3_;
				DataView* view = NULL;
				GeeIterator* _tmp4_;
				gpointer _tmp5_;
				DataView* _tmp6_;
				_tmp3_ = _view_it;
				if (!gee_iterator_next (_tmp3_)) {
					break;
				}
				_tmp4_ = _view_it;
				_tmp5_ = gee_iterator_get (_tmp4_);
				view = (DataView*) _tmp5_;
				_tmp6_ = view;
				view_collection_notify_item_view_altered (self, _tmp6_);
				_g_object_unref0 (view);
			}
			_g_object_unref0 (_view_it);
		}
		_tmp7_ = self->priv->frozen_views_altered;
		view_collection_notify_views_altered (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
		_g_object_unref0 (self->priv->frozen_views_altered);
		self->priv->frozen_views_altered = NULL;
	}
	_tmp8_ = self->priv->frozen_geometries_altered;
	if (_tmp8_ != NULL) {
		GeeHashSet* _tmp15_;
		{
			GeeIterator* _view_it = NULL;
			GeeHashSet* _tmp9_;
			GeeIterator* _tmp10_;
			_tmp9_ = self->priv->frozen_geometries_altered;
			_tmp10_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_view_it = _tmp10_;
			while (TRUE) {
				GeeIterator* _tmp11_;
				DataView* view = NULL;
				GeeIterator* _tmp12_;
				gpointer _tmp13_;
				DataView* _tmp14_;
				_tmp11_ = _view_it;
				if (!gee_iterator_next (_tmp11_)) {
					break;
				}
				_tmp12_ = _view_it;
				_tmp13_ = gee_iterator_get (_tmp12_);
				view = (DataView*) _tmp13_;
				_tmp14_ = view;
				view_collection_notify_item_geometry_altered (self, _tmp14_);
				_g_object_unref0 (view);
			}
			_g_object_unref0 (_view_it);
		}
		_tmp15_ = self->priv->frozen_geometries_altered;
		view_collection_notify_geometries_altered (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection));
		_g_object_unref0 (self->priv->frozen_geometries_altered);
		self->priv->frozen_geometries_altered = NULL;
	}
	DATA_COLLECTION_CLASS (view_collection_parent_class)->notify_thawed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
}

gboolean
view_collection_are_items_filtered_out (ViewCollection* self)
{
	gboolean result;
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
	result = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection)) != data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	return result;
}

static void
view_collection_real_items_selected (ViewCollection* self,
                                     GeeIterable* selected)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (selected, GEE_TYPE_ITERABLE));
}

static void
view_collection_real_items_unselected (ViewCollection* self,
                                       GeeIterable* unselected)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (unselected, GEE_TYPE_ITERABLE));
}

static void
view_collection_real_items_state_changed (ViewCollection* self,
                                          GeeIterable* changed)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (changed, GEE_TYPE_ITERABLE));
}

static void
view_collection_real_selection_group_altered (ViewCollection* self)
{
}

static void
view_collection_real_items_shown (ViewCollection* self,
                                  GeeCollection* visible)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (visible, GEE_TYPE_COLLECTION));
}

static void
view_collection_real_items_hidden (ViewCollection* self,
                                   GeeCollection* hidden)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (hidden, GEE_TYPE_COLLECTION));
}

static void
view_collection_real_items_visibility_changed (ViewCollection* self,
                                               GeeCollection* changed)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (changed, GEE_TYPE_COLLECTION));
}

static void
view_collection_real_item_view_altered (ViewCollection* self,
                                        DataView* view)
{
	g_return_if_fail (IS_DATA_VIEW (view));
}

static void
view_collection_real_item_geometry_altered (ViewCollection* self,
                                            DataView* view)
{
	g_return_if_fail (IS_DATA_VIEW (view));
}

static void
view_collection_real_views_altered (ViewCollection* self,
                                    GeeCollection* views)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (views, GEE_TYPE_COLLECTION));
}

static void
view_collection_real_geometries_altered (ViewCollection* self,
                                         GeeCollection* views)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (views, GEE_TYPE_COLLECTION));
}

static void
view_collection_real_view_filter_installed (ViewCollection* self,
                                            ViewFilter* filer)
{
	g_return_if_fail (IS_VIEW_FILTER (filer));
}

static void
g_cclosure_user_marshal_VOID__VIEW_FILTER (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__VIEW_FILTER) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__VIEW_FILTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__VIEW_FILTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_view_filter (param_values + 1), data2);
}

static void
view_collection_real_view_filter_removed (ViewCollection* self,
                                          ViewFilter* filer)
{
	g_return_if_fail (IS_VIEW_FILTER (filer));
}

ViewCollectionMonitor*
view_collection_monitor_construct (GType object_type)
{
	ViewCollectionMonitor* self = NULL;
	self = (ViewCollectionMonitor*) g_type_create_instance (object_type);
	return self;
}

ViewCollectionMonitor*
view_collection_monitor_new (void)
{
	return view_collection_monitor_construct (VIEW_COLLECTION_TYPE_MONITOR);
}

static void
view_collection_value_monitor_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
view_collection_value_monitor_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		view_collection_monitor_unref (value->data[0].v_pointer);
	}
}

static void
view_collection_value_monitor_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = view_collection_monitor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
view_collection_value_monitor_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
view_collection_value_monitor_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ViewCollectionMonitor * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = view_collection_monitor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
view_collection_value_monitor_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	ViewCollectionMonitor ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = view_collection_monitor_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
view_collection_param_spec_monitor (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	ViewCollectionParamSpecMonitor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VIEW_COLLECTION_TYPE_MONITOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
view_collection_value_get_monitor (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIEW_COLLECTION_TYPE_MONITOR), NULL);
	return value->data[0].v_pointer;
}

void
view_collection_value_set_monitor (GValue* value,
                                   gpointer v_object)
{
	ViewCollectionMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIEW_COLLECTION_TYPE_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VIEW_COLLECTION_TYPE_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		view_collection_monitor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		view_collection_monitor_unref (old);
	}
}

void
view_collection_value_take_monitor (GValue* value,
                                    gpointer v_object)
{
	ViewCollectionMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIEW_COLLECTION_TYPE_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VIEW_COLLECTION_TYPE_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		view_collection_monitor_unref (old);
	}
}

static void
view_collection_monitor_class_init (ViewCollectionMonitorClass * klass,
                                    gpointer klass_data)
{
	view_collection_monitor_parent_class = g_type_class_peek_parent (klass);
	((ViewCollectionMonitorClass *) klass)->finalize = view_collection_monitor_finalize;
}

static void
view_collection_monitor_instance_init (ViewCollectionMonitor * self,
                                       gpointer klass)
{
	self->ref_count = 1;
}

static void
view_collection_monitor_finalize (ViewCollectionMonitor * obj)
{
	ViewCollectionMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIEW_COLLECTION_TYPE_MONITOR, ViewCollectionMonitor);
	g_signal_handlers_destroy (self);
}

static GType
view_collection_monitor_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { view_collection_value_monitor_init, view_collection_value_monitor_free_value, view_collection_value_monitor_copy_value, view_collection_value_monitor_peek_pointer, "p", view_collection_value_monitor_collect_value, "p", view_collection_value_monitor_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ViewCollectionMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_collection_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewCollectionMonitor), 0, (GInstanceInitFunc) view_collection_monitor_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType view_collection_monitor_type_id;
	view_collection_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ViewCollectionMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return view_collection_monitor_type_id;
}

GType
view_collection_monitor_get_type (void)
{
	static volatile gsize view_collection_monitor_type_id__once = 0;
	if (g_once_init_enter (&view_collection_monitor_type_id__once)) {
		GType view_collection_monitor_type_id;
		view_collection_monitor_type_id = view_collection_monitor_get_type_once ();
		g_once_init_leave (&view_collection_monitor_type_id__once, view_collection_monitor_type_id);
	}
	return view_collection_monitor_type_id__once;
}

gpointer
view_collection_monitor_ref (gpointer instance)
{
	ViewCollectionMonitor * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
view_collection_monitor_unref (gpointer instance)
{
	ViewCollectionMonitor * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VIEW_COLLECTION_MONITOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_view_collection_on_sources_added_data_collection_items_added (DataCollection* _sender,
                                                               GeeIterable* added,
                                                               gpointer self)
{
	view_collection_on_sources_added ((ViewCollection*) self, _sender, added);
}

static void
_view_collection_on_sources_removed_data_collection_items_removed (DataCollection* _sender,
                                                                   GeeIterable* removed,
                                                                   gpointer self)
{
	view_collection_on_sources_removed ((ViewCollection*) self, removed);
}

static void
_view_collection_on_sources_altered_data_collection_items_altered (DataCollection* _sender,
                                                                   GeeMap* items,
                                                                   gpointer self)
{
	view_collection_on_sources_altered ((ViewCollection*) self, _sender, items);
}

static gpointer
_view_manager_ref0 (gpointer self)
{
	return self ? view_manager_ref (self) : NULL;
}

static gpointer
_alteration_ref0 (gpointer self)
{
	return self ? alteration_ref (self) : NULL;
}

static ViewCollectionMonitorImpl*
view_collection_monitor_impl_construct (GType object_type,
                                        ViewCollection* owner,
                                        SourceCollection* sources,
                                        ViewManager* manager,
                                        Alteration* prereq)
{
	ViewCollectionMonitorImpl* self = NULL;
	ViewCollection* _tmp0_;
	SourceCollection* _tmp1_;
	ViewManager* _tmp2_;
	Alteration* _tmp3_;
	g_return_val_if_fail (IS_VIEW_COLLECTION (owner), NULL);
	g_return_val_if_fail (IS_SOURCE_COLLECTION (sources), NULL);
	g_return_val_if_fail (IS_VIEW_MANAGER (manager), NULL);
	g_return_val_if_fail ((prereq == NULL) || IS_ALTERATION (prereq), NULL);
	self = (ViewCollectionMonitorImpl*) view_collection_monitor_construct (object_type);
	_tmp0_ = _data_collection_ref0 (owner);
	_data_collection_unref0 (self->owner);
	self->owner = _tmp0_;
	_tmp1_ = _data_collection_ref0 (sources);
	_data_collection_unref0 (self->sources);
	self->sources = _tmp1_;
	_tmp2_ = _view_manager_ref0 (manager);
	_view_manager_unref0 (self->manager);
	self->manager = _tmp2_;
	_tmp3_ = _alteration_ref0 (prereq);
	_alteration_unref0 (self->prereq);
	self->prereq = _tmp3_;
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (sources, TYPE_DATA_COLLECTION, DataCollection), "items-added", (GCallback) _view_collection_on_sources_added_data_collection_items_added, owner);
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (sources, TYPE_DATA_COLLECTION, DataCollection), "items-removed", (GCallback) _view_collection_on_sources_removed_data_collection_items_removed, owner);
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (sources, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _view_collection_on_sources_altered_data_collection_items_altered, owner);
	return self;
}

static ViewCollectionMonitorImpl*
view_collection_monitor_impl_new (ViewCollection* owner,
                                  SourceCollection* sources,
                                  ViewManager* manager,
                                  Alteration* prereq)
{
	return view_collection_monitor_impl_construct (VIEW_COLLECTION_TYPE_MONITOR_IMPL, owner, sources, manager, prereq);
}

static void
view_collection_monitor_impl_class_init (ViewCollectionMonitorImplClass * klass,
                                         gpointer klass_data)
{
	view_collection_monitor_impl_parent_class = g_type_class_peek_parent (klass);
	((ViewCollectionMonitorClass *) klass)->finalize = view_collection_monitor_impl_finalize;
}

static void
view_collection_monitor_impl_instance_init (ViewCollectionMonitorImpl * self,
                                            gpointer klass)
{
}

static void
view_collection_monitor_impl_finalize (ViewCollectionMonitor * obj)
{
	ViewCollectionMonitorImpl * self;
	SourceCollection* _tmp0_;
	ViewCollection* _tmp1_;
	guint _tmp2_;
	SourceCollection* _tmp3_;
	ViewCollection* _tmp4_;
	guint _tmp5_;
	SourceCollection* _tmp6_;
	ViewCollection* _tmp7_;
	guint _tmp8_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIEW_COLLECTION_TYPE_MONITOR_IMPL, ViewCollectionMonitorImpl);
	_tmp0_ = self->sources;
	_tmp1_ = self->owner;
	g_signal_parse_name ("items-added", TYPE_DATA_COLLECTION, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _view_collection_on_sources_added_data_collection_items_added, _tmp1_);
	_tmp3_ = self->sources;
	_tmp4_ = self->owner;
	g_signal_parse_name ("items-removed", TYPE_DATA_COLLECTION, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _view_collection_on_sources_removed_data_collection_items_removed, _tmp4_);
	_tmp6_ = self->sources;
	_tmp7_ = self->owner;
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _view_collection_on_sources_altered_data_collection_items_altered, _tmp7_);
	_data_collection_unref0 (self->owner);
	_data_collection_unref0 (self->sources);
	_view_manager_unref0 (self->manager);
	_alteration_unref0 (self->prereq);
	VIEW_COLLECTION_MONITOR_CLASS (view_collection_monitor_impl_parent_class)->finalize (obj);
}

static GType
view_collection_monitor_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ViewCollectionMonitorImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_collection_monitor_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewCollectionMonitorImpl), 0, (GInstanceInitFunc) view_collection_monitor_impl_instance_init, NULL };
	GType view_collection_monitor_impl_type_id;
	view_collection_monitor_impl_type_id = g_type_register_static (VIEW_COLLECTION_TYPE_MONITOR, "ViewCollectionMonitorImpl", &g_define_type_info, 0);
	return view_collection_monitor_impl_type_id;
}

static GType
view_collection_monitor_impl_get_type (void)
{
	static volatile gsize view_collection_monitor_impl_type_id__once = 0;
	if (g_once_init_enter (&view_collection_monitor_impl_type_id__once)) {
		GType view_collection_monitor_impl_type_id;
		view_collection_monitor_impl_type_id = view_collection_monitor_impl_get_type_once ();
		g_once_init_leave (&view_collection_monitor_impl_type_id__once, view_collection_monitor_impl_type_id);
	}
	return view_collection_monitor_impl_type_id__once;
}

static ViewCollectionToggleLists*
view_collection_toggle_lists_construct (GType object_type)
{
	ViewCollectionToggleLists * self = NULL;
	self = (ViewCollectionToggleLists*) g_object_new (object_type, NULL);
	return self;
}

static ViewCollectionToggleLists*
view_collection_toggle_lists_new (void)
{
	return view_collection_toggle_lists_construct (VIEW_COLLECTION_TYPE_TOGGLE_LISTS);
}

static void
view_collection_toggle_lists_class_init (ViewCollectionToggleListsClass * klass,
                                         gpointer klass_data)
{
	view_collection_toggle_lists_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = view_collection_toggle_lists_finalize;
}

static void
view_collection_toggle_lists_instance_init (ViewCollectionToggleLists * self,
                                            gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->selected = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->unselected = _tmp1_;
}

static void
view_collection_toggle_lists_finalize (GObject * obj)
{
	ViewCollectionToggleLists * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIEW_COLLECTION_TYPE_TOGGLE_LISTS, ViewCollectionToggleLists);
	_g_object_unref0 (self->selected);
	_g_object_unref0 (self->unselected);
	G_OBJECT_CLASS (view_collection_toggle_lists_parent_class)->finalize (obj);
}

static GType
view_collection_toggle_lists_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ViewCollectionToggleListsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_collection_toggle_lists_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewCollectionToggleLists), 0, (GInstanceInitFunc) view_collection_toggle_lists_instance_init, NULL };
	GType view_collection_toggle_lists_type_id;
	view_collection_toggle_lists_type_id = g_type_register_static (G_TYPE_OBJECT, "ViewCollectionToggleLists", &g_define_type_info, 0);
	return view_collection_toggle_lists_type_id;
}

static GType
view_collection_toggle_lists_get_type (void)
{
	static volatile gsize view_collection_toggle_lists_type_id__once = 0;
	if (g_once_init_enter (&view_collection_toggle_lists_type_id__once)) {
		GType view_collection_toggle_lists_type_id;
		view_collection_toggle_lists_type_id = view_collection_toggle_lists_get_type_once ();
		g_once_init_leave (&view_collection_toggle_lists_type_id__once, view_collection_toggle_lists_type_id);
	}
	return view_collection_toggle_lists_type_id__once;
}

static void
view_collection_class_init (ViewCollectionClass * klass,
                            gpointer klass_data)
{
	view_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = view_collection_finalize;
	g_type_class_adjust_private_offset (klass, &ViewCollection_private_offset);
	((ViewCollectionClass *) klass)->notify_items_selected_unselected = (void (*) (ViewCollection*, GeeCollection*, GeeCollection*)) view_collection_real_notify_items_selected_unselected;
	((ViewCollectionClass *) klass)->notify_selection_group_altered = (void (*) (ViewCollection*)) view_collection_real_notify_selection_group_altered;
	((ViewCollectionClass *) klass)->notify_item_view_altered = (void (*) (ViewCollection*, DataView*)) view_collection_real_notify_item_view_altered;
	((ViewCollectionClass *) klass)->notify_views_altered = (void (*) (ViewCollection*, GeeCollection*)) view_collection_real_notify_views_altered;
	((ViewCollectionClass *) klass)->notify_item_geometry_altered = (void (*) (ViewCollection*, DataView*)) view_collection_real_notify_item_geometry_altered;
	((ViewCollectionClass *) klass)->notify_geometries_altered = (void (*) (ViewCollection*, GeeCollection*)) view_collection_real_notify_geometries_altered;
	((ViewCollectionClass *) klass)->notify_items_shown = (void (*) (ViewCollection*, GeeCollection*)) view_collection_real_notify_items_shown;
	((ViewCollectionClass *) klass)->notify_items_hidden = (void (*) (ViewCollection*, GeeCollection*)) view_collection_real_notify_items_hidden;
	((ViewCollectionClass *) klass)->notify_items_visibility_changed = (void (*) (ViewCollection*, GeeCollection*)) view_collection_real_notify_items_visibility_changed;
	((ViewCollectionClass *) klass)->notify_view_filter_installed = (void (*) (ViewCollection*, ViewFilter*)) view_collection_real_notify_view_filter_installed;
	((ViewCollectionClass *) klass)->notify_view_filter_removed = (void (*) (ViewCollection*, ViewFilter*)) view_collection_real_notify_view_filter_removed;
	((DataCollectionClass *) klass)->clear = (void (*) (DataCollection*)) view_collection_real_clear;
	((DataCollectionClass *) klass)->close = (void (*) (DataCollection*)) view_collection_real_close;
	((DataCollectionClass *) klass)->valid_type = (gboolean (*) (DataCollection*, DataObject*)) view_collection_real_valid_type;
	((DataCollectionClass *) klass)->add = (gboolean (*) (DataCollection*, DataObject*)) view_collection_real_add;
	((DataCollectionClass *) klass)->add_many = (GeeCollection* (*) (DataCollection*, GeeCollection*, ProgressMonitor, gpointer)) view_collection_real_add_many;
	((DataCollectionClass *) klass)->notify_items_added = (void (*) (DataCollection*, GeeIterable*)) view_collection_real_notify_items_added;
	((DataCollectionClass *) klass)->notify_items_removed = (void (*) (DataCollection*, GeeIterable*)) view_collection_real_notify_items_removed;
	((DataCollectionClass *) klass)->items_altered = (void (*) (DataCollection*, GeeMap*)) view_collection_real_items_altered;
	((DataCollectionClass *) klass)->set_comparator = (void (*) (DataCollection*, Comparator, gpointer, ComparatorPredicate, gpointer)) view_collection_real_set_comparator;
	((DataCollectionClass *) klass)->reset_comparator = (void (*) (DataCollection*)) view_collection_real_reset_comparator;
	((DataCollectionClass *) klass)->get_all = (GeeCollection* (*) (DataCollection*)) view_collection_real_get_all;
	((DataCollectionClass *) klass)->get_count = (gint (*) (DataCollection*)) view_collection_real_get_count;
	((DataCollectionClass *) klass)->get_at = (DataObject* (*) (DataCollection*, gint)) view_collection_real_get_at;
	((DataCollectionClass *) klass)->index_of = (gint (*) (DataCollection*, DataObject*)) view_collection_real_index_of;
	((DataCollectionClass *) klass)->contains = (gboolean (*) (DataCollection*, DataObject*)) view_collection_real_contains;
	((ViewCollectionClass *) klass)->get_first = (DataView* (*) (ViewCollection*)) view_collection_real_get_first;
	((ViewCollectionClass *) klass)->get_first_unrejected = (DataView* (*) (ViewCollection*)) view_collection_real_get_first_unrejected;
	((ViewCollectionClass *) klass)->get_first_photo = (DataView* (*) (ViewCollection*)) view_collection_real_get_first_photo;
	((ViewCollectionClass *) klass)->get_last = (DataView* (*) (ViewCollection*)) view_collection_real_get_last;
	((ViewCollectionClass *) klass)->get_next = (DataView* (*) (ViewCollection*, DataView*, gboolean**)) view_collection_real_get_next;
	((ViewCollectionClass *) klass)->get_previous = (DataView* (*) (ViewCollection*, DataView*)) view_collection_real_get_previous;
	((DataCollectionClass *) klass)->notify_thawed = (void (*) (DataCollection*)) view_collection_real_notify_thawed;
	((ViewCollectionClass *) klass)->items_selected = view_collection_real_items_selected;
	((ViewCollectionClass *) klass)->items_unselected = view_collection_real_items_unselected;
	((ViewCollectionClass *) klass)->items_state_changed = view_collection_real_items_state_changed;
	((ViewCollectionClass *) klass)->selection_group_altered = view_collection_real_selection_group_altered;
	((ViewCollectionClass *) klass)->items_shown = view_collection_real_items_shown;
	((ViewCollectionClass *) klass)->items_hidden = view_collection_real_items_hidden;
	((ViewCollectionClass *) klass)->items_visibility_changed = view_collection_real_items_visibility_changed;
	((ViewCollectionClass *) klass)->item_view_altered = view_collection_real_item_view_altered;
	((ViewCollectionClass *) klass)->item_geometry_altered = view_collection_real_item_geometry_altered;
	((ViewCollectionClass *) klass)->views_altered = view_collection_real_views_altered;
	((ViewCollectionClass *) klass)->geometries_altered = view_collection_real_geometries_altered;
	((ViewCollectionClass *) klass)->view_filter_installed = view_collection_real_view_filter_installed;
	((ViewCollectionClass *) klass)->view_filter_removed = view_collection_real_view_filter_removed;
	view_collection_signals[VIEW_COLLECTION_ITEMS_SELECTED_SIGNAL] = g_signal_new ("items-selected", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_selected), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_ITERABLE);
	view_collection_signals[VIEW_COLLECTION_ITEMS_UNSELECTED_SIGNAL] = g_signal_new ("items-unselected", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_unselected), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_ITERABLE);
	view_collection_signals[VIEW_COLLECTION_ITEMS_STATE_CHANGED_SIGNAL] = g_signal_new ("items-state-changed", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_state_changed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_ITERABLE);
	view_collection_signals[VIEW_COLLECTION_SELECTION_GROUP_ALTERED_SIGNAL] = g_signal_new ("selection-group-altered", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, selection_group_altered), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	view_collection_signals[VIEW_COLLECTION_ITEMS_SHOWN_SIGNAL] = g_signal_new ("items-shown", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_shown), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	view_collection_signals[VIEW_COLLECTION_ITEMS_HIDDEN_SIGNAL] = g_signal_new ("items-hidden", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_hidden), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	view_collection_signals[VIEW_COLLECTION_ITEMS_VISIBILITY_CHANGED_SIGNAL] = g_signal_new ("items-visibility-changed", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_visibility_changed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	view_collection_signals[VIEW_COLLECTION_ITEM_VIEW_ALTERED_SIGNAL] = g_signal_new ("item-view-altered", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, item_view_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_VIEW);
	view_collection_signals[VIEW_COLLECTION_ITEM_GEOMETRY_ALTERED_SIGNAL] = g_signal_new ("item-geometry-altered", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, item_geometry_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_VIEW);
	view_collection_signals[VIEW_COLLECTION_VIEWS_ALTERED_SIGNAL] = g_signal_new ("views-altered", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, views_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	view_collection_signals[VIEW_COLLECTION_GEOMETRIES_ALTERED_SIGNAL] = g_signal_new ("geometries-altered", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, geometries_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	view_collection_signals[VIEW_COLLECTION_VIEW_FILTER_INSTALLED_SIGNAL] = g_signal_new ("view-filter-installed", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, view_filter_installed), NULL, NULL, g_cclosure_user_marshal_VOID__VIEW_FILTER, G_TYPE_NONE, 1, TYPE_VIEW_FILTER);
	view_collection_signals[VIEW_COLLECTION_VIEW_FILTER_REMOVED_SIGNAL] = g_signal_new ("view-filter-removed", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, view_filter_removed), NULL, NULL, g_cclosure_user_marshal_VOID__VIEW_FILTER, G_TYPE_NONE, 1, TYPE_VIEW_FILTER);
}

static void
view_collection_instance_init (ViewCollection * self,
                               gpointer klass)
{
	GeeHashMultiMap* _tmp0_;
	GeeHashSet* _tmp1_;
	DataSet* _tmp2_;
	GeeHashMap* _tmp3_;
	self->priv = view_collection_get_instance_private (self);
	_tmp0_ = gee_hash_multi_map_new (TYPE_SOURCE_COLLECTION, (GBoxedCopyFunc) data_collection_ref, (GDestroyNotify) data_collection_unref, VIEW_COLLECTION_TYPE_MONITOR_IMPL, (GBoxedCopyFunc) view_collection_monitor_ref, (GDestroyNotify) view_collection_monitor_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->monitors = _tmp0_;
	self->priv->mirroring = NULL;
	self->priv->mirroring_ctor = NULL;
	self->priv->mirroring_ctor_target = NULL;
	self->priv->should_mirror = NULL;
	self->priv->should_mirror_target = NULL;
	_tmp1_ = gee_hash_set_new (TYPE_VIEW_FILTER, (GBoxedCopyFunc) view_filter_ref, (GDestroyNotify) view_filter_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->filters = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_SET, GeeSet);
	_tmp2_ = data_set_new ();
	self->priv->selected = _tmp2_;
	self->priv->visible = NULL;
	self->priv->frozen_views_altered = NULL;
	self->priv->frozen_geometries_altered = NULL;
	_tmp3_ = gee_hash_map_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->source_map = _tmp3_;
}

static void
view_collection_finalize (DataCollection * obj)
{
	ViewCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIEW_COLLECTION, ViewCollection);
	_g_object_unref0 (self->priv->monitors);
	_data_collection_unref0 (self->priv->mirroring);
	_g_object_unref0 (self->priv->filters);
	_data_set_unref0 (self->priv->selected);
	_data_set_unref0 (self->priv->visible);
	_g_object_unref0 (self->priv->frozen_views_altered);
	_g_object_unref0 (self->priv->frozen_geometries_altered);
	_g_object_unref0 (self->priv->source_map);
	DATA_COLLECTION_CLASS (view_collection_parent_class)->finalize (obj);
}

static GType
view_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ViewCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewCollection), 0, (GInstanceInitFunc) view_collection_instance_init, NULL };
	GType view_collection_type_id;
	view_collection_type_id = g_type_register_static (TYPE_DATA_COLLECTION, "ViewCollection", &g_define_type_info, 0);
	ViewCollection_private_offset = g_type_add_instance_private (view_collection_type_id, sizeof (ViewCollectionPrivate));
	return view_collection_type_id;
}

GType
view_collection_get_type (void)
{
	static volatile gsize view_collection_type_id__once = 0;
	if (g_once_init_enter (&view_collection_type_id__once)) {
		GType view_collection_type_id;
		view_collection_type_id = view_collection_get_type_once ();
		g_once_init_leave (&view_collection_type_id__once, view_collection_type_id);
	}
	return view_collection_type_id__once;
}

static gboolean
view_manager_real_include_in_view (ViewManager* self,
                                   DataSource* source)
{
	gboolean result;
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
	result = TRUE;
	return result;
}

gboolean
view_manager_include_in_view (ViewManager* self,
                              DataSource* source)
{
	ViewManagerClass* _klass_;
	g_return_val_if_fail (IS_VIEW_MANAGER (self), FALSE);
	_klass_ = VIEW_MANAGER_GET_CLASS (self);
	if (_klass_->include_in_view) {
		return _klass_->include_in_view (self, source);
	}
	return FALSE;
}

static DataView*
view_manager_real_create_view (ViewManager* self,
                               DataSource* source)
{
	g_critical ("Type `%s' does not implement abstract method `view_manager_create_view'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

DataView*
view_manager_create_view (ViewManager* self,
                          DataSource* source)
{
	ViewManagerClass* _klass_;
	g_return_val_if_fail (IS_VIEW_MANAGER (self), NULL);
	_klass_ = VIEW_MANAGER_GET_CLASS (self);
	if (_klass_->create_view) {
		return _klass_->create_view (self, source);
	}
	return NULL;
}

ViewManager*
view_manager_construct (GType object_type)
{
	ViewManager* self = NULL;
	self = (ViewManager*) g_type_create_instance (object_type);
	return self;
}

static void
value_view_manager_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_view_manager_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		view_manager_unref (value->data[0].v_pointer);
	}
}

static void
value_view_manager_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = view_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_view_manager_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_view_manager_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ViewManager * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = view_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_view_manager_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	ViewManager ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = view_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_view_manager (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecViewManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIEW_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_view_manager (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_MANAGER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_view_manager (GValue* value,
                        gpointer v_object)
{
	ViewManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIEW_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		view_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		view_manager_unref (old);
	}
}

void
value_take_view_manager (GValue* value,
                         gpointer v_object)
{
	ViewManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIEW_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		view_manager_unref (old);
	}
}

static void
view_manager_class_init (ViewManagerClass * klass,
                         gpointer klass_data)
{
	view_manager_parent_class = g_type_class_peek_parent (klass);
	((ViewManagerClass *) klass)->finalize = view_manager_finalize;
	((ViewManagerClass *) klass)->include_in_view = (gboolean (*) (ViewManager*, DataSource*)) view_manager_real_include_in_view;
	((ViewManagerClass *) klass)->create_view = (DataView* (*) (ViewManager*, DataSource*)) view_manager_real_create_view;
}

static void
view_manager_instance_init (ViewManager * self,
                            gpointer klass)
{
	self->ref_count = 1;
}

static void
view_manager_finalize (ViewManager * obj)
{
	ViewManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIEW_MANAGER, ViewManager);
	g_signal_handlers_destroy (self);
}

static GType
view_manager_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_view_manager_init, value_view_manager_free_value, value_view_manager_copy_value, value_view_manager_peek_pointer, "p", value_view_manager_collect_value, "p", value_view_manager_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ViewManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewManager), 0, (GInstanceInitFunc) view_manager_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType view_manager_type_id;
	view_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ViewManager", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return view_manager_type_id;
}

GType
view_manager_get_type (void)
{
	static volatile gsize view_manager_type_id__once = 0;
	if (g_once_init_enter (&view_manager_type_id__once)) {
		GType view_manager_type_id;
		view_manager_type_id = view_manager_get_type_once ();
		g_once_init_leave (&view_manager_type_id__once, view_manager_type_id);
	}
	return view_manager_type_id__once;
}

gpointer
view_manager_ref (gpointer instance)
{
	ViewManager * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
view_manager_unref (gpointer instance)
{
	ViewManager * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VIEW_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gboolean
view_filter_real_predicate (ViewFilter* self,
                            DataView* view)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `view_filter_predicate'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
view_filter_predicate (ViewFilter* self,
                       DataView* view)
{
	ViewFilterClass* _klass_;
	g_return_val_if_fail (IS_VIEW_FILTER (self), FALSE);
	_klass_ = VIEW_FILTER_GET_CLASS (self);
	if (_klass_->predicate) {
		return _klass_->predicate (self, view);
	}
	return FALSE;
}

ViewFilter*
view_filter_construct (GType object_type)
{
	ViewFilter* self = NULL;
	self = (ViewFilter*) g_type_create_instance (object_type);
	return self;
}

static void
view_filter_real_refresh (ViewFilter* self)
{
}

static void
value_view_filter_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_view_filter_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		view_filter_unref (value->data[0].v_pointer);
	}
}

static void
value_view_filter_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = view_filter_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_view_filter_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_view_filter_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ViewFilter * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = view_filter_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_view_filter_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	ViewFilter ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = view_filter_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_view_filter (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecViewFilter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIEW_FILTER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_view_filter (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_FILTER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_view_filter (GValue* value,
                       gpointer v_object)
{
	ViewFilter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_FILTER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIEW_FILTER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		view_filter_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		view_filter_unref (old);
	}
}

void
value_take_view_filter (GValue* value,
                        gpointer v_object)
{
	ViewFilter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_FILTER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIEW_FILTER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		view_filter_unref (old);
	}
}

static void
view_filter_class_init (ViewFilterClass * klass,
                        gpointer klass_data)
{
	view_filter_parent_class = g_type_class_peek_parent (klass);
	((ViewFilterClass *) klass)->finalize = view_filter_finalize;
	((ViewFilterClass *) klass)->predicate = (gboolean (*) (ViewFilter*, DataView*)) view_filter_real_predicate;
	((ViewFilterClass *) klass)->refresh = view_filter_real_refresh;
	view_filter_signals[VIEW_FILTER_REFRESH_SIGNAL] = g_signal_new ("refresh", TYPE_VIEW_FILTER, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewFilterClass, refresh), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
view_filter_instance_init (ViewFilter * self,
                           gpointer klass)
{
	self->ref_count = 1;
}

static void
view_filter_finalize (ViewFilter * obj)
{
	ViewFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIEW_FILTER, ViewFilter);
	g_signal_handlers_destroy (self);
}

static GType
view_filter_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_view_filter_init, value_view_filter_free_value, value_view_filter_copy_value, value_view_filter_peek_pointer, "p", value_view_filter_collect_value, "p", value_view_filter_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ViewFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewFilter), 0, (GInstanceInitFunc) view_filter_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType view_filter_type_id;
	view_filter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ViewFilter", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return view_filter_type_id;
}

GType
view_filter_get_type (void)
{
	static volatile gsize view_filter_type_id__once = 0;
	if (g_once_init_enter (&view_filter_type_id__once)) {
		GType view_filter_type_id;
		view_filter_type_id = view_filter_get_type_once ();
		g_once_init_leave (&view_filter_type_id__once, view_filter_type_id);
	}
	return view_filter_type_id__once;
}

gpointer
view_filter_ref (gpointer instance)
{
	ViewFilter * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
view_filter_unref (gpointer instance)
{
	ViewFilter * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VIEW_FILTER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

