/* raw-gamepad-monitor.c generated by valac 0.56.18, the Vala compiler
 * generated from raw-gamepad-monitor.vala, do not modify */

/*
 * Copyright 2016 Megh Parikh
 *
 * This file is part of LibGamepad.
 *
 * LibGamepad is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LibGamepad is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gudev/gudev.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define LIB_GAMEPAD_TYPE_RAW_GAMEPAD_MONITOR (lib_gamepad_raw_gamepad_monitor_get_type ())
#define LIB_GAMEPAD_RAW_GAMEPAD_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD_MONITOR, LibGamepadRawGamepadMonitor))
#define LIB_GAMEPAD_IS_RAW_GAMEPAD_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD_MONITOR))
#define LIB_GAMEPAD_RAW_GAMEPAD_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD_MONITOR, LibGamepadRawGamepadMonitorIface))

typedef struct _LibGamepadRawGamepadMonitor LibGamepadRawGamepadMonitor;
typedef struct _LibGamepadRawGamepadMonitorIface LibGamepadRawGamepadMonitorIface;

#define LIB_GAMEPAD_TYPE_RAW_GAMEPAD (lib_gamepad_raw_gamepad_get_type ())
#define LIB_GAMEPAD_RAW_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD, LibGamepadRawGamepad))
#define LIB_GAMEPAD_IS_RAW_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD))
#define LIB_GAMEPAD_RAW_GAMEPAD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD, LibGamepadRawGamepadIface))

typedef struct _LibGamepadRawGamepad LibGamepadRawGamepad;
typedef struct _LibGamepadRawGamepadIface LibGamepadRawGamepadIface;
typedef void (*LibGamepadRawGamepadMonitorRawGamepadCallback) (LibGamepadRawGamepad* raw_gamepad, gpointer user_data);

#define LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD_MONITOR (lib_gamepad_linux_raw_gamepad_monitor_get_type ())
#define LIB_GAMEPAD_LINUX_RAW_GAMEPAD_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD_MONITOR, LibGamepadLinuxRawGamepadMonitor))
#define LIB_GAMEPAD_LINUX_RAW_GAMEPAD_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD_MONITOR, LibGamepadLinuxRawGamepadMonitorClass))
#define LIB_GAMEPAD_IS_LINUX_RAW_GAMEPAD_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD_MONITOR))
#define LIB_GAMEPAD_IS_LINUX_RAW_GAMEPAD_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD_MONITOR))
#define LIB_GAMEPAD_LINUX_RAW_GAMEPAD_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD_MONITOR, LibGamepadLinuxRawGamepadMonitorClass))

typedef struct _LibGamepadLinuxRawGamepadMonitor LibGamepadLinuxRawGamepadMonitor;
typedef struct _LibGamepadLinuxRawGamepadMonitorClass LibGamepadLinuxRawGamepadMonitorClass;
typedef struct _LibGamepadLinuxRawGamepadMonitorPrivate LibGamepadLinuxRawGamepadMonitorPrivate;
enum  {
	LIB_GAMEPAD_LINUX_RAW_GAMEPAD_MONITOR_0_PROPERTY,
	LIB_GAMEPAD_LINUX_RAW_GAMEPAD_MONITOR_NUM_PROPERTIES
};
static GParamSpec* lib_gamepad_linux_raw_gamepad_monitor_properties[LIB_GAMEPAD_LINUX_RAW_GAMEPAD_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef void (*LibGamepadLinuxRawGamepadMonitorRawGamepadCallback) (LibGamepadRawGamepad* raw_gamepad, gpointer user_data);
typedef struct _Block29Data Block29Data;

#define LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD (lib_gamepad_linux_raw_gamepad_get_type ())
#define LIB_GAMEPAD_LINUX_RAW_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD, LibGamepadLinuxRawGamepad))
#define LIB_GAMEPAD_LINUX_RAW_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD, LibGamepadLinuxRawGamepadClass))
#define LIB_GAMEPAD_IS_LINUX_RAW_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD))
#define LIB_GAMEPAD_IS_LINUX_RAW_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD))
#define LIB_GAMEPAD_LINUX_RAW_GAMEPAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD, LibGamepadLinuxRawGamepadClass))

typedef struct _LibGamepadLinuxRawGamepad LibGamepadLinuxRawGamepad;
typedef struct _LibGamepadLinuxRawGamepadClass LibGamepadLinuxRawGamepadClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _LibGamepadRawGamepadIface {
	GTypeInterface parent_iface;
	const gchar* (*get_identifier) (LibGamepadRawGamepad* self);
	const gchar* (*get_name) (LibGamepadRawGamepad* self);
	const gchar* (*get_guid) (LibGamepadRawGamepad* self);
	guint8 (*get_axes_number) (LibGamepadRawGamepad* self);
	guint8 (*get_buttons_number) (LibGamepadRawGamepad* self);
	guint8 (*get_dpads_number) (LibGamepadRawGamepad* self);
};

struct _LibGamepadRawGamepadMonitorIface {
	GTypeInterface parent_iface;
	void (*foreach_gamepad) (LibGamepadRawGamepadMonitor* self, LibGamepadRawGamepadMonitorRawGamepadCallback callback, gpointer callback_target);
};

struct _LibGamepadLinuxRawGamepadMonitor {
	GObject parent_instance;
	LibGamepadLinuxRawGamepadMonitorPrivate * priv;
};

struct _LibGamepadLinuxRawGamepadMonitorClass {
	GObjectClass parent_class;
};

struct _LibGamepadLinuxRawGamepadMonitorPrivate {
	GUdevClient* client;
};

struct _Block29Data {
	int _ref_count_;
	LibGamepadLinuxRawGamepadMonitor* self;
	LibGamepadLinuxRawGamepadMonitorRawGamepadCallback callback;
	gpointer callback_target;
};

static gint LibGamepadLinuxRawGamepadMonitor_private_offset;
static gpointer lib_gamepad_linux_raw_gamepad_monitor_parent_class = NULL;
static LibGamepadRawGamepadMonitorIface * lib_gamepad_linux_raw_gamepad_monitor_lib_gamepad_raw_gamepad_monitor_parent_iface = NULL;

VALA_EXTERN GType lib_gamepad_raw_gamepad_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadRawGamepad, g_object_unref)
VALA_EXTERN GType lib_gamepad_raw_gamepad_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadRawGamepadMonitor, g_object_unref)
VALA_EXTERN GType lib_gamepad_linux_raw_gamepad_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadLinuxRawGamepadMonitor, g_object_unref)
VALA_EXTERN LibGamepadLinuxRawGamepadMonitor* lib_gamepad_linux_raw_gamepad_monitor_new (void);
VALA_EXTERN LibGamepadLinuxRawGamepadMonitor* lib_gamepad_linux_raw_gamepad_monitor_construct (GType object_type);
static void lib_gamepad_linux_raw_gamepad_monitor_handle_udev_client_callback (LibGamepadLinuxRawGamepadMonitor* self,
                                                                        const gchar* action,
                                                                        GUdevDevice* dev);
static void _lib_gamepad_linux_raw_gamepad_monitor_handle_udev_client_callback_g_udev_client_uevent (GUdevClient* _sender,
                                                                                              const gchar* action,
                                                                                              GUdevDevice* device,
                                                                                              gpointer self);
static void lib_gamepad_linux_raw_gamepad_monitor_real_foreach_gamepad (LibGamepadRawGamepadMonitor* base,
                                                                 LibGamepadLinuxRawGamepadMonitorRawGamepadCallback callback,
                                                                 gpointer callback_target);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static void __lambda134_ (Block29Data* _data29_,
                   GUdevDevice* dev);
VALA_EXTERN GType lib_gamepad_linux_raw_gamepad_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadLinuxRawGamepad, g_object_unref)
VALA_EXTERN LibGamepadLinuxRawGamepad* lib_gamepad_linux_raw_gamepad_new (const gchar* file_name,
                                                              GError** error);
VALA_EXTERN LibGamepadLinuxRawGamepad* lib_gamepad_linux_raw_gamepad_construct (GType object_type,
                                                                    const gchar* file_name,
                                                                    GError** error);
static void ___lambda134__gfunc (gconstpointer data,
                          gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN void lib_gamepad_raw_gamepad_monitor_foreach_gamepad (LibGamepadRawGamepadMonitor* self,
                                                      LibGamepadRawGamepadMonitorRawGamepadCallback callback,
                                                      gpointer callback_target);
static void lib_gamepad_linux_raw_gamepad_monitor_finalize (GObject * obj);
static GType lib_gamepad_linux_raw_gamepad_monitor_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
lib_gamepad_linux_raw_gamepad_monitor_get_instance_private (LibGamepadLinuxRawGamepadMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, LibGamepadLinuxRawGamepadMonitor_private_offset);
}

static void
_lib_gamepad_linux_raw_gamepad_monitor_handle_udev_client_callback_g_udev_client_uevent (GUdevClient* _sender,
                                                                                         const gchar* action,
                                                                                         GUdevDevice* device,
                                                                                         gpointer self)
{
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	lib_gamepad_linux_raw_gamepad_monitor_handle_udev_client_callback ((LibGamepadLinuxRawGamepadMonitor*) self, action, device);
#line 193 "raw-gamepad-monitor.c"
}

LibGamepadLinuxRawGamepadMonitor*
lib_gamepad_linux_raw_gamepad_monitor_construct (GType object_type)
{
	LibGamepadLinuxRawGamepadMonitor * self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GUdevClient* _tmp3_;
	GUdevClient* _tmp4_;
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	self = (LibGamepadLinuxRawGamepadMonitor*) g_object_new (object_type, NULL);
#line 26 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp0_ = g_strdup ("input");
#line 26 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp1_ = g_new0 (gchar*, 1 + 1);
#line 26 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp1_[0] = _tmp0_;
#line 26 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp2_ = _tmp1_;
#line 26 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp2__length1 = 1;
#line 26 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp3_ = g_udev_client_new (_tmp2_);
#line 26 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_g_object_unref0 (self->priv->client);
#line 26 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	self->priv->client = _tmp3_;
#line 26 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp4_ = self->priv->client;
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	g_signal_connect_object (_tmp4_, "uevent", (GCallback) _lib_gamepad_linux_raw_gamepad_monitor_handle_udev_client_callback_g_udev_client_uevent, self, 0);
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	return self;
#line 232 "raw-gamepad-monitor.c"
}

LibGamepadLinuxRawGamepadMonitor*
lib_gamepad_linux_raw_gamepad_monitor_new (void)
{
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	return lib_gamepad_linux_raw_gamepad_monitor_construct (LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD_MONITOR);
#line 240 "raw-gamepad-monitor.c"
}

static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
#line 30 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	g_atomic_int_inc (&_data29_->_ref_count_);
#line 30 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	return _data29_;
#line 250 "raw-gamepad-monitor.c"
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
#line 30 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
#line 260 "raw-gamepad-monitor.c"
		LibGamepadLinuxRawGamepadMonitor* self;
#line 30 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		self = _data29_->self;
#line 30 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		_g_object_unref0 (self);
#line 30 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		g_slice_free (Block29Data, _data29_);
#line 268 "raw-gamepad-monitor.c"
	}
}

static void
__lambda134_ (Block29Data* _data29_,
              GUdevDevice* dev)
{
	LibGamepadLinuxRawGamepadMonitor* self;
	const gchar* _tmp0_;
	gchar* identifier = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GError* _inner_error0_ = NULL;
#line 31 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	self = _data29_->self;
#line 31 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	g_return_if_fail (dev != NULL);
#line 32 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp0_ = g_udev_device_get_device_file (dev);
#line 32 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	if (_tmp0_ == NULL) {
#line 33 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		return;
#line 294 "raw-gamepad-monitor.c"
	}
#line 34 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp1_ = g_udev_device_get_device_file (dev);
#line 34 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 34 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	identifier = _tmp2_;
#line 35 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	if (g_udev_device_has_property (dev, "ID_INPUT_JOYSTICK")) {
#line 304 "raw-gamepad-monitor.c"
		const gchar* _tmp5_;
#line 35 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		_tmp5_ = g_udev_device_get_property (dev, "ID_INPUT_JOYSTICK");
#line 35 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		_tmp4_ = g_strcmp0 (_tmp5_, "1") == 0;
#line 310 "raw-gamepad-monitor.c"
	} else {
#line 35 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		_tmp4_ = FALSE;
#line 314 "raw-gamepad-monitor.c"
	}
#line 35 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	if (_tmp4_) {
#line 35 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		_tmp3_ = TRUE;
#line 320 "raw-gamepad-monitor.c"
	} else {
		gboolean _tmp6_ = FALSE;
#line 36 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		if (g_udev_device_has_property (dev, ".INPUT_CLASS")) {
#line 325 "raw-gamepad-monitor.c"
			const gchar* _tmp7_;
#line 36 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_tmp7_ = g_udev_device_get_property (dev, ".INPUT_CLASS");
#line 36 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_tmp6_ = g_strcmp0 (_tmp7_, "joystick") == 0;
#line 331 "raw-gamepad-monitor.c"
		} else {
#line 36 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_tmp6_ = FALSE;
#line 335 "raw-gamepad-monitor.c"
		}
#line 36 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		_tmp3_ = _tmp6_;
#line 339 "raw-gamepad-monitor.c"
	}
#line 35 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	if (_tmp3_) {
#line 343 "raw-gamepad-monitor.c"
		LibGamepadRawGamepad* raw_gamepad = NULL;
		LibGamepadRawGamepad* _tmp12_;
		{
			LibGamepadLinuxRawGamepad* _tmp8_ = NULL;
			const gchar* _tmp9_;
			LibGamepadLinuxRawGamepad* _tmp10_;
			LibGamepadLinuxRawGamepad* _tmp11_;
#line 39 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_tmp9_ = identifier;
#line 39 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_tmp10_ = lib_gamepad_linux_raw_gamepad_new (_tmp9_, &_inner_error0_);
#line 39 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_tmp8_ = _tmp10_;
#line 39 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 39 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
				if (_inner_error0_->domain == G_FILE_ERROR) {
#line 361 "raw-gamepad-monitor.c"
					goto __catch0_g_file_error;
				}
#line 39 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
				_g_object_unref0 (raw_gamepad);
#line 39 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
				_g_free0 (identifier);
#line 39 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 39 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
				g_clear_error (&_inner_error0_);
#line 39 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
				return;
#line 374 "raw-gamepad-monitor.c"
			}
#line 39 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_tmp11_ = _tmp8_;
#line 39 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_tmp8_ = NULL;
#line 39 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_g_object_unref0 (raw_gamepad);
#line 39 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			raw_gamepad = (LibGamepadRawGamepad*) _tmp11_;
#line 38 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_g_object_unref0 (_tmp8_);
#line 386 "raw-gamepad-monitor.c"
		}
		goto __finally0;
		__catch0_g_file_error:
		{
#line 38 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			g_clear_error (&_inner_error0_);
#line 41 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_g_object_unref0 (raw_gamepad);
#line 41 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_g_free0 (identifier);
#line 41 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			return;
#line 399 "raw-gamepad-monitor.c"
		}
		__finally0:
#line 38 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 38 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_g_object_unref0 (raw_gamepad);
#line 38 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_g_free0 (identifier);
#line 38 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 38 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			g_clear_error (&_inner_error0_);
#line 38 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			return;
#line 414 "raw-gamepad-monitor.c"
		}
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		_tmp12_ = raw_gamepad;
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		_data29_->callback (_tmp12_, _data29_->callback_target);
#line 35 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		_g_object_unref0 (raw_gamepad);
#line 422 "raw-gamepad-monitor.c"
	}
#line 31 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_g_free0 (identifier);
#line 426 "raw-gamepad-monitor.c"
}

static void
___lambda134__gfunc (gconstpointer data,
                     gpointer self)
{
#line 31 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	__lambda134_ (self, (GUdevDevice*) data);
#line 435 "raw-gamepad-monitor.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 31 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 443 "raw-gamepad-monitor.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 31 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 451 "raw-gamepad-monitor.c"
}

static void
lib_gamepad_linux_raw_gamepad_monitor_real_foreach_gamepad (LibGamepadRawGamepadMonitor* base,
                                                            LibGamepadLinuxRawGamepadMonitorRawGamepadCallback callback,
                                                            gpointer callback_target)
{
	LibGamepadLinuxRawGamepadMonitor * self;
	Block29Data* _data29_;
	GUdevClient* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
#line 30 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	self = (LibGamepadLinuxRawGamepadMonitor*) base;
#line 30 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_data29_ = g_slice_new0 (Block29Data);
#line 30 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_data29_->_ref_count_ = 1;
#line 30 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_data29_->self = g_object_ref (self);
#line 30 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_data29_->callback = callback;
#line 30 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_data29_->callback_target = callback_target;
#line 31 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp0_ = self->priv->client;
#line 31 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp1_ = g_udev_client_query_by_subsystem (_tmp0_, "input");
#line 31 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp2_ = _tmp1_;
#line 31 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	g_list_foreach (_tmp2_, ___lambda134__gfunc, _data29_);
#line 31 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
#line 30 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	block29_data_unref (_data29_);
#line 30 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_data29_ = NULL;
#line 490 "raw-gamepad-monitor.c"
}

static void
lib_gamepad_linux_raw_gamepad_monitor_handle_udev_client_callback (LibGamepadLinuxRawGamepadMonitor* self,
                                                                   const gchar* action,
                                                                   GUdevDevice* dev)
{
	const gchar* _tmp0_;
	gchar* identifier = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GError* _inner_error0_ = NULL;
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	g_return_if_fail (self != NULL);
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	g_return_if_fail (action != NULL);
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	g_return_if_fail (dev != NULL);
#line 49 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp0_ = g_udev_device_get_device_file (dev);
#line 49 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	if (_tmp0_ == NULL) {
#line 50 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		return;
#line 517 "raw-gamepad-monitor.c"
	}
#line 52 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp1_ = g_udev_device_get_device_file (dev);
#line 52 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 52 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	identifier = _tmp2_;
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	if (g_udev_device_has_property (dev, "ID_INPUT_JOYSTICK")) {
#line 527 "raw-gamepad-monitor.c"
		const gchar* _tmp5_;
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		_tmp5_ = g_udev_device_get_property (dev, "ID_INPUT_JOYSTICK");
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		_tmp4_ = g_strcmp0 (_tmp5_, "1") == 0;
#line 533 "raw-gamepad-monitor.c"
	} else {
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		_tmp4_ = FALSE;
#line 537 "raw-gamepad-monitor.c"
	}
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	if (_tmp4_) {
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		_tmp3_ = TRUE;
#line 543 "raw-gamepad-monitor.c"
	} else {
		gboolean _tmp6_ = FALSE;
#line 54 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		if (g_udev_device_has_property (dev, ".INPUT_CLASS")) {
#line 548 "raw-gamepad-monitor.c"
			const gchar* _tmp7_;
#line 54 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_tmp7_ = g_udev_device_get_property (dev, ".INPUT_CLASS");
#line 54 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_tmp6_ = g_strcmp0 (_tmp7_, "joystick") == 0;
#line 554 "raw-gamepad-monitor.c"
		} else {
#line 54 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			_tmp6_ = FALSE;
#line 558 "raw-gamepad-monitor.c"
		}
#line 54 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		_tmp3_ = _tmp6_;
#line 562 "raw-gamepad-monitor.c"
	}
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	if (_tmp3_) {
#line 566 "raw-gamepad-monitor.c"
		const gchar* _tmp8_;
		GQuark _tmp10_ = 0U;
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		static GQuark _tmp9_label0 = 0;
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		static GQuark _tmp9_label1 = 0;
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		_tmp8_ = action;
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
		if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("add")))) {
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			switch (0) {
#line 581 "raw-gamepad-monitor.c"
				default:
				{
					LibGamepadRawGamepad* raw_gamepad = NULL;
					LibGamepadRawGamepad* _tmp15_;
					{
						LibGamepadLinuxRawGamepad* _tmp11_ = NULL;
						const gchar* _tmp12_;
						LibGamepadLinuxRawGamepad* _tmp13_;
						LibGamepadLinuxRawGamepad* _tmp14_;
#line 59 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						_tmp12_ = identifier;
#line 59 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						_tmp13_ = lib_gamepad_linux_raw_gamepad_new (_tmp12_, &_inner_error0_);
#line 59 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						_tmp11_ = _tmp13_;
#line 59 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 59 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
							if (_inner_error0_->domain == G_FILE_ERROR) {
#line 601 "raw-gamepad-monitor.c"
								goto __catch0_g_file_error;
							}
#line 59 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
							_g_object_unref0 (raw_gamepad);
#line 59 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
							_g_free0 (identifier);
#line 59 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 59 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
							g_clear_error (&_inner_error0_);
#line 59 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
							return;
#line 614 "raw-gamepad-monitor.c"
						}
#line 59 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						_tmp14_ = _tmp11_;
#line 59 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						_tmp11_ = NULL;
#line 59 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						_g_object_unref0 (raw_gamepad);
#line 59 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						raw_gamepad = (LibGamepadRawGamepad*) _tmp14_;
#line 58 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						_g_object_unref0 (_tmp11_);
#line 626 "raw-gamepad-monitor.c"
					}
					goto __finally0;
					__catch0_g_file_error:
					{
#line 58 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						g_clear_error (&_inner_error0_);
#line 61 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						_g_object_unref0 (raw_gamepad);
#line 61 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						_g_free0 (identifier);
#line 61 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						return;
#line 639 "raw-gamepad-monitor.c"
					}
					__finally0:
#line 58 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 58 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						_g_object_unref0 (raw_gamepad);
#line 58 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						_g_free0 (identifier);
#line 58 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 58 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						g_clear_error (&_inner_error0_);
#line 58 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
						return;
#line 654 "raw-gamepad-monitor.c"
					}
#line 63 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
					_tmp15_ = raw_gamepad;
#line 63 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
					g_signal_emit_by_name ((LibGamepadRawGamepadMonitor*) self, "gamepad-plugged", _tmp15_);
#line 64 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
					_g_object_unref0 (raw_gamepad);
#line 64 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
					break;
#line 664 "raw-gamepad-monitor.c"
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("remove")))) {
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
			switch (0) {
#line 670 "raw-gamepad-monitor.c"
				default:
				{
					const gchar* _tmp16_;
#line 66 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
					_tmp16_ = identifier;
#line 66 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
					g_signal_emit_by_name ((LibGamepadRawGamepadMonitor*) self, "gamepad-unplugged", _tmp16_);
#line 67 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
					break;
#line 680 "raw-gamepad-monitor.c"
				}
			}
		}
	}
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_g_free0 (identifier);
#line 687 "raw-gamepad-monitor.c"
}

static void
lib_gamepad_linux_raw_gamepad_monitor_class_init (LibGamepadLinuxRawGamepadMonitorClass * klass,
                                                  gpointer klass_data)
{
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	lib_gamepad_linux_raw_gamepad_monitor_parent_class = g_type_class_peek_parent (klass);
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	g_type_class_adjust_private_offset (klass, &LibGamepadLinuxRawGamepadMonitor_private_offset);
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	G_OBJECT_CLASS (klass)->finalize = lib_gamepad_linux_raw_gamepad_monitor_finalize;
#line 700 "raw-gamepad-monitor.c"
}

static void
lib_gamepad_linux_raw_gamepad_monitor_lib_gamepad_raw_gamepad_monitor_interface_init (LibGamepadRawGamepadMonitorIface * iface,
                                                                                      gpointer iface_data)
{
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	lib_gamepad_linux_raw_gamepad_monitor_lib_gamepad_raw_gamepad_monitor_parent_iface = g_type_interface_peek_parent (iface);
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	iface->foreach_gamepad = (void (*) (LibGamepadRawGamepadMonitor*, LibGamepadRawGamepadMonitorRawGamepadCallback, gpointer)) lib_gamepad_linux_raw_gamepad_monitor_real_foreach_gamepad;
#line 711 "raw-gamepad-monitor.c"
}

static void
lib_gamepad_linux_raw_gamepad_monitor_instance_init (LibGamepadLinuxRawGamepadMonitor * self,
                                                     gpointer klass)
{
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	self->priv = lib_gamepad_linux_raw_gamepad_monitor_get_instance_private (self);
#line 720 "raw-gamepad-monitor.c"
}

static void
lib_gamepad_linux_raw_gamepad_monitor_finalize (GObject * obj)
{
	LibGamepadLinuxRawGamepadMonitor * self;
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD_MONITOR, LibGamepadLinuxRawGamepadMonitor);
#line 23 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	_g_object_unref0 (self->priv->client);
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad-monitor.vala"
	G_OBJECT_CLASS (lib_gamepad_linux_raw_gamepad_monitor_parent_class)->finalize (obj);
#line 733 "raw-gamepad-monitor.c"
}

static GType
lib_gamepad_linux_raw_gamepad_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibGamepadLinuxRawGamepadMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lib_gamepad_linux_raw_gamepad_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibGamepadLinuxRawGamepadMonitor), 0, (GInstanceInitFunc) lib_gamepad_linux_raw_gamepad_monitor_instance_init, NULL };
	static const GInterfaceInfo lib_gamepad_raw_gamepad_monitor_info = { (GInterfaceInitFunc) lib_gamepad_linux_raw_gamepad_monitor_lib_gamepad_raw_gamepad_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType lib_gamepad_linux_raw_gamepad_monitor_type_id;
	lib_gamepad_linux_raw_gamepad_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "LibGamepadLinuxRawGamepadMonitor", &g_define_type_info, 0);
	g_type_add_interface_static (lib_gamepad_linux_raw_gamepad_monitor_type_id, LIB_GAMEPAD_TYPE_RAW_GAMEPAD_MONITOR, &lib_gamepad_raw_gamepad_monitor_info);
	LibGamepadLinuxRawGamepadMonitor_private_offset = g_type_add_instance_private (lib_gamepad_linux_raw_gamepad_monitor_type_id, sizeof (LibGamepadLinuxRawGamepadMonitorPrivate));
	return lib_gamepad_linux_raw_gamepad_monitor_type_id;
}

GType
lib_gamepad_linux_raw_gamepad_monitor_get_type (void)
{
	static volatile gsize lib_gamepad_linux_raw_gamepad_monitor_type_id__once = 0;
	if (g_once_init_enter (&lib_gamepad_linux_raw_gamepad_monitor_type_id__once)) {
		GType lib_gamepad_linux_raw_gamepad_monitor_type_id;
		lib_gamepad_linux_raw_gamepad_monitor_type_id = lib_gamepad_linux_raw_gamepad_monitor_get_type_once ();
		g_once_init_leave (&lib_gamepad_linux_raw_gamepad_monitor_type_id__once, lib_gamepad_linux_raw_gamepad_monitor_type_id);
	}
	return lib_gamepad_linux_raw_gamepad_monitor_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

