/* Shortcut.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Shortcut.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2017-2025 elementary, Inc. (https://elementary.io)
 */
/* stores a shortcut, converts to gsettings format and readable format*/
/* and checks for validity*/

#include "keyboard.h"
#include <gdk/gdk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>

#define KEYBOARD_SHORTCUTS_SHORTCUT_SEPARATOR " + "
#define KEYBOARD_SHORTCUTS_SHORTCUT_A_UPPERCASE_ASCII ((guint) 65)
#define KEYBOARD_SHORTCUTS_SHORTCUT_Z_UPPERCASE_ASCII ((guint) 90)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	KEYBOARD_SHORTCUTS_SHORTCUT_0_PROPERTY,
	KEYBOARD_SHORTCUTS_SHORTCUT_MODIFIERS_PROPERTY,
	KEYBOARD_SHORTCUTS_SHORTCUT_ACCEL_KEY_PROPERTY,
	KEYBOARD_SHORTCUTS_SHORTCUT_NUM_PROPERTIES
};
static GParamSpec* keyboard_shortcuts_shortcut_properties[KEYBOARD_SHORTCUTS_SHORTCUT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _KeyboardShortcutsShortcutPrivate {
	GdkModifierType _modifiers;
	guint _accel_key;
};

static gint KeyboardShortcutsShortcut_private_offset;
static gpointer keyboard_shortcuts_shortcut_parent_class = NULL;

static gboolean keyboard_shortcuts_shortcut_valid (KeyboardShortcutsShortcut* self);
static void keyboard_shortcuts_shortcut_finalize (GObject * obj);
static GType keyboard_shortcuts_shortcut_get_type_once (void);
static void _vala_keyboard_shortcuts_shortcut_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_keyboard_shortcuts_shortcut_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
keyboard_shortcuts_shortcut_get_instance_private (KeyboardShortcutsShortcut* self)
{
	return G_STRUCT_MEMBER_P (self, KeyboardShortcutsShortcut_private_offset);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

KeyboardShortcutsShortcut*
keyboard_shortcuts_shortcut_construct (GType object_type,
                                       guint key,
                                       GdkModifierType mod)
{
	KeyboardShortcutsShortcut * self = NULL;
	gboolean _tmp0_ = FALSE;
	if (key >= KEYBOARD_SHORTCUTS_SHORTCUT_A_UPPERCASE_ASCII) {
		_tmp0_ = key <= KEYBOARD_SHORTCUTS_SHORTCUT_Z_UPPERCASE_ASCII;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = g_strdup_printf ("%c", (gchar) key);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_ascii_strdown (_tmp2_, (gssize) -1);
		_tmp4_ = _tmp3_;
		key = (guint) string_get (_tmp4_, (glong) 0);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
	}
	self = (KeyboardShortcutsShortcut*) g_object_new (object_type, "accel-key", key, "modifiers", mod, NULL);
	return self;
}

KeyboardShortcutsShortcut*
keyboard_shortcuts_shortcut_new (guint key,
                                 GdkModifierType mod)
{
	return keyboard_shortcuts_shortcut_construct (KEYBOARD_SHORTCUTS_TYPE_SHORTCUT, key, mod);
}

KeyboardShortcutsShortcut*
keyboard_shortcuts_shortcut_construct_parse (GType object_type,
                                             const gchar* str)
{
	KeyboardShortcutsShortcut * self = NULL;
	guint key = 0U;
	GdkModifierType mod = 0U;
	key = (guint) 0;
	mod = (GdkModifierType) 0;
	if (str != NULL) {
		guint _tmp0_ = 0U;
		GdkModifierType _tmp1_ = 0U;
		gtk_accelerator_parse (str, &_tmp0_, &_tmp1_);
		key = _tmp0_;
		mod = _tmp1_;
	}
	self = (KeyboardShortcutsShortcut*) keyboard_shortcuts_shortcut_construct (object_type, key, mod);
	return self;
}

KeyboardShortcutsShortcut*
keyboard_shortcuts_shortcut_new_parse (const gchar* str)
{
	return keyboard_shortcuts_shortcut_construct_parse (KEYBOARD_SHORTCUTS_TYPE_SHORTCUT, str);
}

gchar*
keyboard_shortcuts_shortcut_to_gsettings (KeyboardShortcutsShortcut* self)
{
	guint _tmp1_;
	GdkModifierType _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!keyboard_shortcuts_shortcut_valid (self)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = self->priv->_accel_key;
	_tmp2_ = self->priv->_modifiers;
	_tmp3_ = gtk_accelerator_name (_tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
keyboard_shortcuts_shortcut_to_readable (KeyboardShortcutsShortcut* self)
{
	gchar* tmp = NULL;
	gchar* _tmp1_;
	GdkModifierType _tmp2_;
	GdkModifierType _tmp7_;
	GdkModifierType _tmp10_;
	GdkModifierType _tmp15_;
	GdkModifierType _tmp20_;
	guint _tmp25_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!keyboard_shortcuts_shortcut_valid (self)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (_ ("Disabled"));
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_strdup ("");
	tmp = _tmp1_;
	_tmp2_ = self->priv->_modifiers;
	if ((_tmp2_ & GDK_SHIFT_MASK) > 0) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = tmp;
		_tmp4_ = g_strconcat (_ ("Shift"), KEYBOARD_SHORTCUTS_SHORTCUT_SEPARATOR, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp3_, _tmp5_, NULL);
		_g_free0 (tmp);
		tmp = _tmp6_;
		_g_free0 (_tmp5_);
	}
	_tmp7_ = self->priv->_modifiers;
	if ((_tmp7_ & GDK_SUPER_MASK) > 0) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = tmp;
		_tmp9_ = g_strconcat (_tmp8_, "⌘" KEYBOARD_SHORTCUTS_SHORTCUT_SEPARATOR, NULL);
		_g_free0 (tmp);
		tmp = _tmp9_;
	}
	_tmp10_ = self->priv->_modifiers;
	if ((_tmp10_ & GDK_CONTROL_MASK) > 0) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp11_ = tmp;
		_tmp12_ = g_strconcat (_ ("Ctrl"), KEYBOARD_SHORTCUTS_SHORTCUT_SEPARATOR, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
		_g_free0 (tmp);
		tmp = _tmp14_;
		_g_free0 (_tmp13_);
	}
	_tmp15_ = self->priv->_modifiers;
	if ((_tmp15_ & GDK_ALT_MASK) > 0) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp16_ = tmp;
		_tmp17_ = g_strconcat (_ ("Alt"), KEYBOARD_SHORTCUTS_SHORTCUT_SEPARATOR, NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp16_, _tmp18_, NULL);
		_g_free0 (tmp);
		tmp = _tmp19_;
		_g_free0 (_tmp18_);
	}
	_tmp20_ = self->priv->_modifiers;
	if ((_tmp20_ & GDK_META_MASK) > 0) {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp21_ = tmp;
		_tmp22_ = g_strconcat (_ ("Meta"), KEYBOARD_SHORTCUTS_SHORTCUT_SEPARATOR, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp21_, _tmp23_, NULL);
		_g_free0 (tmp);
		tmp = _tmp24_;
		_g_free0 (_tmp23_);
	}
	_tmp25_ = self->priv->_accel_key;
	switch (_tmp25_) {
		case GDK_KEY_Up:
		{
			const gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp26_ = tmp;
			_tmp27_ = g_strconcat (_tmp26_, "↑", NULL);
			_g_free0 (tmp);
			tmp = _tmp27_;
			break;
		}
		case GDK_KEY_Down:
		{
			const gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp28_ = tmp;
			_tmp29_ = g_strconcat (_tmp28_, "↓", NULL);
			_g_free0 (tmp);
			tmp = _tmp29_;
			break;
		}
		case GDK_KEY_Left:
		{
			const gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp30_ = tmp;
			_tmp31_ = g_strconcat (_tmp30_, "←", NULL);
			_g_free0 (tmp);
			tmp = _tmp31_;
			break;
		}
		case GDK_KEY_Right:
		{
			const gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp32_ = tmp;
			_tmp33_ = g_strconcat (_tmp32_, "→", NULL);
			_g_free0 (tmp);
			tmp = _tmp33_;
			break;
		}
		default:
		{
			const gchar* _tmp34_;
			guint _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			_tmp34_ = tmp;
			_tmp35_ = self->priv->_accel_key;
			_tmp36_ = gtk_accelerator_get_label (_tmp35_, 0);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat (_tmp34_, _tmp37_, NULL);
			_g_free0 (tmp);
			tmp = _tmp38_;
			_g_free0 (_tmp37_);
			break;
		}
	}
	result = tmp;
	return result;
}

gboolean
keyboard_shortcuts_shortcut_is_equal (KeyboardShortcutsShortcut* self,
                                      KeyboardShortcutsShortcut* shortcut)
{
	gboolean _tmp0_ = FALSE;
	GdkModifierType _tmp1_;
	GdkModifierType _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (shortcut != NULL, FALSE);
	_tmp1_ = shortcut->priv->_modifiers;
	_tmp2_ = self->priv->_modifiers;
	if (_tmp1_ == _tmp2_) {
		guint _tmp3_;
		guint _tmp4_;
		_tmp3_ = shortcut->priv->_accel_key;
		_tmp4_ = self->priv->_accel_key;
		_tmp0_ = _tmp3_ == _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
keyboard_shortcuts_shortcut_valid (KeyboardShortcutsShortcut* self)
{
	guint _tmp0_;
	gboolean _tmp1_ = FALSE;
	GdkModifierType _tmp2_;
	GdkModifierType _tmp61_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_accel_key;
	if (_tmp0_ == ((guint) 0)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_modifiers;
	if (_tmp2_ == ((GdkModifierType) 0)) {
		_tmp1_ = TRUE;
	} else {
		GdkModifierType _tmp3_;
		_tmp3_ = self->priv->_modifiers;
		_tmp1_ = _tmp3_ == GDK_SHIFT_MASK;
	}
	if (_tmp1_) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		guint _tmp22_;
		_tmp22_ = self->priv->_accel_key;
		if (_tmp22_ >= GDK_KEY_a) {
			guint _tmp23_;
			_tmp23_ = self->priv->_accel_key;
			_tmp21_ = _tmp23_ <= GDK_KEY_z;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			_tmp20_ = TRUE;
		} else {
			gboolean _tmp24_ = FALSE;
			guint _tmp25_;
			_tmp25_ = self->priv->_accel_key;
			if (_tmp25_ >= GDK_KEY_A) {
				guint _tmp26_;
				_tmp26_ = self->priv->_accel_key;
				_tmp24_ = _tmp26_ <= GDK_KEY_Z;
			} else {
				_tmp24_ = FALSE;
			}
			_tmp20_ = _tmp24_;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			gboolean _tmp27_ = FALSE;
			guint _tmp28_;
			_tmp28_ = self->priv->_accel_key;
			if (_tmp28_ >= GDK_KEY_0) {
				guint _tmp29_;
				_tmp29_ = self->priv->_accel_key;
				_tmp27_ = _tmp29_ <= GDK_KEY_9;
			} else {
				_tmp27_ = FALSE;
			}
			_tmp19_ = _tmp27_;
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gboolean _tmp30_ = FALSE;
			guint _tmp31_;
			_tmp31_ = self->priv->_accel_key;
			if (_tmp31_ >= GDK_KEY_kana_fullstop) {
				guint _tmp32_;
				_tmp32_ = self->priv->_accel_key;
				_tmp30_ = _tmp32_ <= GDK_KEY_semivoicedsound;
			} else {
				_tmp30_ = FALSE;
			}
			_tmp18_ = _tmp30_;
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			gboolean _tmp33_ = FALSE;
			guint _tmp34_;
			_tmp34_ = self->priv->_accel_key;
			if (_tmp34_ >= GDK_KEY_Arabic_comma) {
				guint _tmp35_;
				_tmp35_ = self->priv->_accel_key;
				_tmp33_ = _tmp35_ <= GDK_KEY_Arabic_sukun;
			} else {
				_tmp33_ = FALSE;
			}
			_tmp17_ = _tmp33_;
		}
		if (_tmp17_) {
			_tmp16_ = TRUE;
		} else {
			gboolean _tmp36_ = FALSE;
			guint _tmp37_;
			_tmp37_ = self->priv->_accel_key;
			if (_tmp37_ >= GDK_KEY_Serbian_dje) {
				guint _tmp38_;
				_tmp38_ = self->priv->_accel_key;
				_tmp36_ = _tmp38_ <= GDK_KEY_Cyrillic_HARDSIGN;
			} else {
				_tmp36_ = FALSE;
			}
			_tmp16_ = _tmp36_;
		}
		if (_tmp16_) {
			_tmp15_ = TRUE;
		} else {
			gboolean _tmp39_ = FALSE;
			guint _tmp40_;
			_tmp40_ = self->priv->_accel_key;
			if (_tmp40_ >= GDK_KEY_Greek_ALPHAaccent) {
				guint _tmp41_;
				_tmp41_ = self->priv->_accel_key;
				_tmp39_ = _tmp41_ <= GDK_KEY_Greek_omega;
			} else {
				_tmp39_ = FALSE;
			}
			_tmp15_ = _tmp39_;
		}
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			gboolean _tmp42_ = FALSE;
			guint _tmp43_;
			_tmp43_ = self->priv->_accel_key;
			if (_tmp43_ >= GDK_KEY_hebrew_doublelowline) {
				guint _tmp44_;
				_tmp44_ = self->priv->_accel_key;
				_tmp42_ = _tmp44_ <= GDK_KEY_hebrew_taf;
			} else {
				_tmp42_ = FALSE;
			}
			_tmp14_ = _tmp42_;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			gboolean _tmp45_ = FALSE;
			guint _tmp46_;
			_tmp46_ = self->priv->_accel_key;
			if (_tmp46_ >= GDK_KEY_Thai_kokai) {
				guint _tmp47_;
				_tmp47_ = self->priv->_accel_key;
				_tmp45_ = _tmp47_ <= GDK_KEY_Thai_lekkao;
			} else {
				_tmp45_ = FALSE;
			}
			_tmp13_ = _tmp45_;
		}
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			gboolean _tmp48_ = FALSE;
			guint _tmp49_;
			_tmp49_ = self->priv->_accel_key;
			if (_tmp49_ >= GDK_KEY_Hangul) {
				guint _tmp50_;
				_tmp50_ = self->priv->_accel_key;
				_tmp48_ = _tmp50_ <= GDK_KEY_Hangul_Special;
			} else {
				_tmp48_ = FALSE;
			}
			_tmp12_ = _tmp48_;
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			gboolean _tmp51_ = FALSE;
			guint _tmp52_;
			_tmp52_ = self->priv->_accel_key;
			if (_tmp52_ >= GDK_KEY_Hangul_Kiyeog) {
				guint _tmp53_;
				_tmp53_ = self->priv->_accel_key;
				_tmp51_ = _tmp53_ <= GDK_KEY_Hangul_J_YeorinHieuh;
			} else {
				_tmp51_ = FALSE;
			}
			_tmp11_ = _tmp51_;
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			guint _tmp54_;
			_tmp54_ = self->priv->_accel_key;
			_tmp10_ = _tmp54_ == GDK_KEY_Left;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			guint _tmp55_;
			_tmp55_ = self->priv->_accel_key;
			_tmp9_ = _tmp55_ == GDK_KEY_Up;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			guint _tmp56_;
			_tmp56_ = self->priv->_accel_key;
			_tmp8_ = _tmp56_ == GDK_KEY_Right;
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			guint _tmp57_;
			_tmp57_ = self->priv->_accel_key;
			_tmp7_ = _tmp57_ == GDK_KEY_Down;
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			guint _tmp58_;
			_tmp58_ = self->priv->_accel_key;
			_tmp6_ = _tmp58_ == GDK_KEY_Tab;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			guint _tmp59_;
			_tmp59_ = self->priv->_accel_key;
			_tmp5_ = _tmp59_ == GDK_KEY_KP_Enter;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			guint _tmp60_;
			_tmp60_ = self->priv->_accel_key;
			_tmp4_ = _tmp60_ == GDK_KEY_Return;
		}
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	}
	_tmp61_ = self->priv->_modifiers;
	if (_tmp61_ == ((GdkModifierType) 0)) {
		gboolean _tmp62_ = FALSE;
		gboolean _tmp63_ = FALSE;
		gboolean _tmp64_ = FALSE;
		gboolean _tmp65_ = FALSE;
		gboolean _tmp66_ = FALSE;
		gboolean _tmp67_ = FALSE;
		gboolean _tmp68_ = FALSE;
		gboolean _tmp69_ = FALSE;
		gboolean _tmp70_ = FALSE;
		guint _tmp71_;
		_tmp71_ = self->priv->_accel_key;
		if (_tmp71_ == GDK_KEY_backslash) {
			_tmp70_ = TRUE;
		} else {
			guint _tmp72_;
			_tmp72_ = self->priv->_accel_key;
			_tmp70_ = _tmp72_ == GDK_KEY_bracketright;
		}
		if (_tmp70_) {
			_tmp69_ = TRUE;
		} else {
			guint _tmp73_;
			_tmp73_ = self->priv->_accel_key;
			_tmp69_ = _tmp73_ == GDK_KEY_bracketleft;
		}
		if (_tmp69_) {
			_tmp68_ = TRUE;
		} else {
			guint _tmp74_;
			_tmp74_ = self->priv->_accel_key;
			_tmp68_ = _tmp74_ == GDK_KEY_apostrophe;
		}
		if (_tmp68_) {
			_tmp67_ = TRUE;
		} else {
			guint _tmp75_;
			_tmp75_ = self->priv->_accel_key;
			_tmp67_ = _tmp75_ == GDK_KEY_semicolon;
		}
		if (_tmp67_) {
			_tmp66_ = TRUE;
		} else {
			guint _tmp76_;
			_tmp76_ = self->priv->_accel_key;
			_tmp66_ = _tmp76_ == GDK_KEY_slash;
		}
		if (_tmp66_) {
			_tmp65_ = TRUE;
		} else {
			guint _tmp77_;
			_tmp77_ = self->priv->_accel_key;
			_tmp65_ = _tmp77_ == GDK_KEY_period;
		}
		if (_tmp65_) {
			_tmp64_ = TRUE;
		} else {
			guint _tmp78_;
			_tmp78_ = self->priv->_accel_key;
			_tmp64_ = _tmp78_ == GDK_KEY_comma;
		}
		if (_tmp64_) {
			_tmp63_ = TRUE;
		} else {
			guint _tmp79_;
			_tmp79_ = self->priv->_accel_key;
			_tmp63_ = _tmp79_ == GDK_KEY_space;
		}
		if (_tmp63_) {
			_tmp62_ = TRUE;
		} else {
			guint _tmp80_;
			_tmp80_ = self->priv->_accel_key;
			_tmp62_ = _tmp80_ == GDK_KEY_grave;
		}
		if (_tmp62_) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}

GdkModifierType
keyboard_shortcuts_shortcut_get_modifiers (KeyboardShortcutsShortcut* self)
{
	GdkModifierType result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_modifiers;
	return result;
}

static void
keyboard_shortcuts_shortcut_set_modifiers (KeyboardShortcutsShortcut* self,
                                           GdkModifierType value)
{
	GdkModifierType old_value;
	g_return_if_fail (self != NULL);
	old_value = keyboard_shortcuts_shortcut_get_modifiers (self);
	if (old_value != value) {
		self->priv->_modifiers = value;
		g_object_notify_by_pspec ((GObject *) self, keyboard_shortcuts_shortcut_properties[KEYBOARD_SHORTCUTS_SHORTCUT_MODIFIERS_PROPERTY]);
	}
}

guint
keyboard_shortcuts_shortcut_get_accel_key (KeyboardShortcutsShortcut* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_accel_key;
	return result;
}

static void
keyboard_shortcuts_shortcut_set_accel_key (KeyboardShortcutsShortcut* self,
                                           guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = keyboard_shortcuts_shortcut_get_accel_key (self);
	if (old_value != value) {
		self->priv->_accel_key = value;
		g_object_notify_by_pspec ((GObject *) self, keyboard_shortcuts_shortcut_properties[KEYBOARD_SHORTCUTS_SHORTCUT_ACCEL_KEY_PROPERTY]);
	}
}

static void
keyboard_shortcuts_shortcut_class_init (KeyboardShortcutsShortcutClass * klass,
                                        gpointer klass_data)
{
	keyboard_shortcuts_shortcut_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &KeyboardShortcutsShortcut_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_keyboard_shortcuts_shortcut_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_keyboard_shortcuts_shortcut_set_property;
	G_OBJECT_CLASS (klass)->finalize = keyboard_shortcuts_shortcut_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_SHORTCUTS_SHORTCUT_MODIFIERS_PROPERTY, keyboard_shortcuts_shortcut_properties[KEYBOARD_SHORTCUTS_SHORTCUT_MODIFIERS_PROPERTY] = g_param_spec_flags ("modifiers", "modifiers", "modifiers", gdk_modifier_type_get_type (), 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_SHORTCUTS_SHORTCUT_ACCEL_KEY_PROPERTY, keyboard_shortcuts_shortcut_properties[KEYBOARD_SHORTCUTS_SHORTCUT_ACCEL_KEY_PROPERTY] = g_param_spec_uint ("accel-key", "accel-key", "accel-key", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
keyboard_shortcuts_shortcut_instance_init (KeyboardShortcutsShortcut * self,
                                           gpointer klass)
{
	self->priv = keyboard_shortcuts_shortcut_get_instance_private (self);
}

static void
keyboard_shortcuts_shortcut_finalize (GObject * obj)
{
	KeyboardShortcutsShortcut * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_SHORTCUTS_TYPE_SHORTCUT, KeyboardShortcutsShortcut);
	G_OBJECT_CLASS (keyboard_shortcuts_shortcut_parent_class)->finalize (obj);
}

static GType
keyboard_shortcuts_shortcut_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardShortcutsShortcutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_shortcuts_shortcut_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardShortcutsShortcut), 0, (GInstanceInitFunc) keyboard_shortcuts_shortcut_instance_init, NULL };
	GType keyboard_shortcuts_shortcut_type_id;
	keyboard_shortcuts_shortcut_type_id = g_type_register_static (G_TYPE_OBJECT, "KeyboardShortcutsShortcut", &g_define_type_info, 0);
	KeyboardShortcutsShortcut_private_offset = g_type_add_instance_private (keyboard_shortcuts_shortcut_type_id, sizeof (KeyboardShortcutsShortcutPrivate));
	return keyboard_shortcuts_shortcut_type_id;
}

GType
keyboard_shortcuts_shortcut_get_type (void)
{
	static volatile gsize keyboard_shortcuts_shortcut_type_id__once = 0;
	if (g_once_init_enter (&keyboard_shortcuts_shortcut_type_id__once)) {
		GType keyboard_shortcuts_shortcut_type_id;
		keyboard_shortcuts_shortcut_type_id = keyboard_shortcuts_shortcut_get_type_once ();
		g_once_init_leave (&keyboard_shortcuts_shortcut_type_id__once, keyboard_shortcuts_shortcut_type_id);
	}
	return keyboard_shortcuts_shortcut_type_id__once;
}

static void
_vala_keyboard_shortcuts_shortcut_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	KeyboardShortcutsShortcut * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_SHORTCUTS_TYPE_SHORTCUT, KeyboardShortcutsShortcut);
	switch (property_id) {
		case KEYBOARD_SHORTCUTS_SHORTCUT_MODIFIERS_PROPERTY:
		g_value_set_flags (value, keyboard_shortcuts_shortcut_get_modifiers (self));
		break;
		case KEYBOARD_SHORTCUTS_SHORTCUT_ACCEL_KEY_PROPERTY:
		g_value_set_uint (value, keyboard_shortcuts_shortcut_get_accel_key (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_keyboard_shortcuts_shortcut_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	KeyboardShortcutsShortcut * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_SHORTCUTS_TYPE_SHORTCUT, KeyboardShortcutsShortcut);
	switch (property_id) {
		case KEYBOARD_SHORTCUTS_SHORTCUT_MODIFIERS_PROPERTY:
		keyboard_shortcuts_shortcut_set_modifiers (self, g_value_get_flags (value));
		break;
		case KEYBOARD_SHORTCUTS_SHORTCUT_ACCEL_KEY_PROPERTY:
		keyboard_shortcuts_shortcut_set_accel_key (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

